// Copyright 2023 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/compute/vpn_gateways/v1/vpn_gateways.proto

#include "google/cloud/compute/vpn_gateways/v1/vpn_gateways_connection.h"
#include "google/cloud/compute/vpn_gateways/v1/internal/vpn_gateways_option_defaults.h"
#include "google/cloud/compute/vpn_gateways/v1/internal/vpn_gateways_tracing_connection.h"
#include "google/cloud/compute/vpn_gateways/v1/vpn_gateways_options.h"
#include "google/cloud/background_threads.h"
#include "google/cloud/common_options.h"
#include "google/cloud/credentials.h"
#include "google/cloud/grpc_options.h"
#include "google/cloud/internal/pagination_range.h"
#include "google/cloud/internal/unified_grpc_credentials.h"
#include <memory>
#include <utility>

namespace google {
namespace cloud {
namespace compute_vpn_gateways_v1 {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

VpnGatewaysConnection::~VpnGatewaysConnection() = default;

StreamRange<std::pair<std::string,
                      google::cloud::cpp::compute::v1::VpnGatewaysScopedList>>
VpnGatewaysConnection::AggregatedListVpnGateways(
    google::cloud::cpp::compute::vpn_gateways::v1::
        AggregatedListVpnGatewaysRequest) {  // NOLINT(performance-unnecessary-value-param)
  return google::cloud::internal::MakeUnimplementedPaginationRange<StreamRange<
      std::pair<std::string,
                google::cloud::cpp::compute::v1::VpnGatewaysScopedList>>>();
}

future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
VpnGatewaysConnection::DeleteVpnGateway(
    google::cloud::cpp::compute::vpn_gateways::v1::
        DeleteVpnGatewayRequest const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::cloud::cpp::compute::v1::Operation>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

StatusOr<google::cloud::cpp::compute::v1::Operation>
VpnGatewaysConnection::DeleteVpnGateway(
    NoAwaitTag, google::cloud::cpp::compute::vpn_gateways::v1::
                    DeleteVpnGatewayRequest const&) {
  return StatusOr<google::cloud::cpp::compute::v1::Operation>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
VpnGatewaysConnection::DeleteVpnGateway(
    google::cloud::cpp::compute::v1::Operation const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::cloud::cpp::compute::v1::Operation>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

StatusOr<google::cloud::cpp::compute::v1::VpnGateway>
VpnGatewaysConnection::GetVpnGateway(google::cloud::cpp::compute::vpn_gateways::
                                         v1::GetVpnGatewayRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

StatusOr<google::cloud::cpp::compute::v1::VpnGatewaysGetStatusResponse>
VpnGatewaysConnection::GetStatus(
    google::cloud::cpp::compute::vpn_gateways::v1::GetStatusRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
VpnGatewaysConnection::InsertVpnGateway(
    google::cloud::cpp::compute::vpn_gateways::v1::
        InsertVpnGatewayRequest const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::cloud::cpp::compute::v1::Operation>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

StatusOr<google::cloud::cpp::compute::v1::Operation>
VpnGatewaysConnection::InsertVpnGateway(
    NoAwaitTag, google::cloud::cpp::compute::vpn_gateways::v1::
                    InsertVpnGatewayRequest const&) {
  return StatusOr<google::cloud::cpp::compute::v1::Operation>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
VpnGatewaysConnection::InsertVpnGateway(
    google::cloud::cpp::compute::v1::Operation const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::cloud::cpp::compute::v1::Operation>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

StreamRange<google::cloud::cpp::compute::v1::VpnGateway>
VpnGatewaysConnection::ListVpnGateways(
    google::cloud::cpp::compute::vpn_gateways::v1::
        ListVpnGatewaysRequest) {  // NOLINT(performance-unnecessary-value-param)
  return google::cloud::internal::MakeUnimplementedPaginationRange<
      StreamRange<google::cloud::cpp::compute::v1::VpnGateway>>();
}

future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
VpnGatewaysConnection::SetLabels(
    google::cloud::cpp::compute::vpn_gateways::v1::SetLabelsRequest const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::cloud::cpp::compute::v1::Operation>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

StatusOr<google::cloud::cpp::compute::v1::Operation>
VpnGatewaysConnection::SetLabels(
    NoAwaitTag,
    google::cloud::cpp::compute::vpn_gateways::v1::SetLabelsRequest const&) {
  return StatusOr<google::cloud::cpp::compute::v1::Operation>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
VpnGatewaysConnection::SetLabels(
    google::cloud::cpp::compute::v1::Operation const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::cloud::cpp::compute::v1::Operation>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

StatusOr<google::cloud::cpp::compute::v1::TestPermissionsResponse>
VpnGatewaysConnection::TestIamPermissions(
    google::cloud::cpp::compute::vpn_gateways::v1::
        TestIamPermissionsRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace compute_vpn_gateways_v1
}  // namespace cloud
}  // namespace google
