// Copyright 2023 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/config/v1/config.proto

#include "google/cloud/config/v1/config_connection.h"
#include "google/cloud/config/v1/config_options.h"
#include "google/cloud/config/v1/internal/config_connection_impl.h"
#include "google/cloud/config/v1/internal/config_option_defaults.h"
#include "google/cloud/config/v1/internal/config_stub_factory.h"
#include "google/cloud/config/v1/internal/config_tracing_connection.h"
#include "google/cloud/background_threads.h"
#include "google/cloud/common_options.h"
#include "google/cloud/credentials.h"
#include "google/cloud/grpc_options.h"
#include "google/cloud/internal/pagination_range.h"
#include "google/cloud/internal/unified_grpc_credentials.h"
#include <memory>
#include <utility>

namespace google {
namespace cloud {
namespace config_v1 {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

ConfigConnection::~ConfigConnection() = default;

StreamRange<google::cloud::config::v1::Deployment>
ConfigConnection::ListDeployments(
    google::cloud::config::v1::
        ListDeploymentsRequest) {  // NOLINT(performance-unnecessary-value-param)
  return google::cloud::internal::MakeUnimplementedPaginationRange<
      StreamRange<google::cloud::config::v1::Deployment>>();
}

StatusOr<google::cloud::config::v1::Deployment> ConfigConnection::GetDeployment(
    google::cloud::config::v1::GetDeploymentRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

future<StatusOr<google::cloud::config::v1::Deployment>>
ConfigConnection::CreateDeployment(
    google::cloud::config::v1::CreateDeploymentRequest const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::cloud::config::v1::Deployment>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

StatusOr<google::longrunning::Operation> ConfigConnection::CreateDeployment(
    NoAwaitTag, google::cloud::config::v1::CreateDeploymentRequest const&) {
  return StatusOr<google::longrunning::Operation>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

future<StatusOr<google::cloud::config::v1::Deployment>>
ConfigConnection::CreateDeployment(google::longrunning::Operation const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::cloud::config::v1::Deployment>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

future<StatusOr<google::cloud::config::v1::Deployment>>
ConfigConnection::UpdateDeployment(
    google::cloud::config::v1::UpdateDeploymentRequest const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::cloud::config::v1::Deployment>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

StatusOr<google::longrunning::Operation> ConfigConnection::UpdateDeployment(
    NoAwaitTag, google::cloud::config::v1::UpdateDeploymentRequest const&) {
  return StatusOr<google::longrunning::Operation>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

future<StatusOr<google::cloud::config::v1::Deployment>>
ConfigConnection::UpdateDeployment(google::longrunning::Operation const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::cloud::config::v1::Deployment>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

future<StatusOr<google::cloud::config::v1::Deployment>>
ConfigConnection::DeleteDeployment(
    google::cloud::config::v1::DeleteDeploymentRequest const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::cloud::config::v1::Deployment>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

StatusOr<google::longrunning::Operation> ConfigConnection::DeleteDeployment(
    NoAwaitTag, google::cloud::config::v1::DeleteDeploymentRequest const&) {
  return StatusOr<google::longrunning::Operation>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

future<StatusOr<google::cloud::config::v1::Deployment>>
ConfigConnection::DeleteDeployment(google::longrunning::Operation const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::cloud::config::v1::Deployment>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

StreamRange<google::cloud::config::v1::Revision>
ConfigConnection::ListRevisions(
    google::cloud::config::v1::
        ListRevisionsRequest) {  // NOLINT(performance-unnecessary-value-param)
  return google::cloud::internal::MakeUnimplementedPaginationRange<
      StreamRange<google::cloud::config::v1::Revision>>();
}

StatusOr<google::cloud::config::v1::Revision> ConfigConnection::GetRevision(
    google::cloud::config::v1::GetRevisionRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

StatusOr<google::cloud::config::v1::Resource> ConfigConnection::GetResource(
    google::cloud::config::v1::GetResourceRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

StreamRange<google::cloud::config::v1::Resource>
ConfigConnection::ListResources(
    google::cloud::config::v1::
        ListResourcesRequest) {  // NOLINT(performance-unnecessary-value-param)
  return google::cloud::internal::MakeUnimplementedPaginationRange<
      StreamRange<google::cloud::config::v1::Resource>>();
}

StatusOr<google::cloud::config::v1::Statefile>
ConfigConnection::ExportDeploymentStatefile(
    google::cloud::config::v1::ExportDeploymentStatefileRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

StatusOr<google::cloud::config::v1::Statefile>
ConfigConnection::ExportRevisionStatefile(
    google::cloud::config::v1::ExportRevisionStatefileRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

StatusOr<google::cloud::config::v1::Statefile>
ConfigConnection::ImportStatefile(
    google::cloud::config::v1::ImportStatefileRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

Status ConfigConnection::DeleteStatefile(
    google::cloud::config::v1::DeleteStatefileRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

future<StatusOr<google::cloud::config::v1::Deployment>>
ConfigConnection::LockDeployment(
    google::cloud::config::v1::LockDeploymentRequest const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::cloud::config::v1::Deployment>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

StatusOr<google::longrunning::Operation> ConfigConnection::LockDeployment(
    NoAwaitTag, google::cloud::config::v1::LockDeploymentRequest const&) {
  return StatusOr<google::longrunning::Operation>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

future<StatusOr<google::cloud::config::v1::Deployment>>
ConfigConnection::LockDeployment(google::longrunning::Operation const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::cloud::config::v1::Deployment>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

future<StatusOr<google::cloud::config::v1::Deployment>>
ConfigConnection::UnlockDeployment(
    google::cloud::config::v1::UnlockDeploymentRequest const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::cloud::config::v1::Deployment>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

StatusOr<google::longrunning::Operation> ConfigConnection::UnlockDeployment(
    NoAwaitTag, google::cloud::config::v1::UnlockDeploymentRequest const&) {
  return StatusOr<google::longrunning::Operation>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

future<StatusOr<google::cloud::config::v1::Deployment>>
ConfigConnection::UnlockDeployment(google::longrunning::Operation const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::cloud::config::v1::Deployment>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

StatusOr<google::cloud::config::v1::LockInfo> ConfigConnection::ExportLockInfo(
    google::cloud::config::v1::ExportLockInfoRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

future<StatusOr<google::cloud::config::v1::Preview>>
ConfigConnection::CreatePreview(
    google::cloud::config::v1::CreatePreviewRequest const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::cloud::config::v1::Preview>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

StatusOr<google::longrunning::Operation> ConfigConnection::CreatePreview(
    NoAwaitTag, google::cloud::config::v1::CreatePreviewRequest const&) {
  return StatusOr<google::longrunning::Operation>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

future<StatusOr<google::cloud::config::v1::Preview>>
ConfigConnection::CreatePreview(google::longrunning::Operation const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::cloud::config::v1::Preview>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

StatusOr<google::cloud::config::v1::Preview> ConfigConnection::GetPreview(
    google::cloud::config::v1::GetPreviewRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

StreamRange<google::cloud::config::v1::Preview> ConfigConnection::ListPreviews(
    google::cloud::config::v1::
        ListPreviewsRequest) {  // NOLINT(performance-unnecessary-value-param)
  return google::cloud::internal::MakeUnimplementedPaginationRange<
      StreamRange<google::cloud::config::v1::Preview>>();
}

future<StatusOr<google::cloud::config::v1::Preview>>
ConfigConnection::DeletePreview(
    google::cloud::config::v1::DeletePreviewRequest const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::cloud::config::v1::Preview>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

StatusOr<google::longrunning::Operation> ConfigConnection::DeletePreview(
    NoAwaitTag, google::cloud::config::v1::DeletePreviewRequest const&) {
  return StatusOr<google::longrunning::Operation>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

future<StatusOr<google::cloud::config::v1::Preview>>
ConfigConnection::DeletePreview(google::longrunning::Operation const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::cloud::config::v1::Preview>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

StatusOr<google::cloud::config::v1::ExportPreviewResultResponse>
ConfigConnection::ExportPreviewResult(
    google::cloud::config::v1::ExportPreviewResultRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

StreamRange<google::cloud::config::v1::TerraformVersion>
ConfigConnection::ListTerraformVersions(
    google::cloud::config::v1::
        ListTerraformVersionsRequest) {  // NOLINT(performance-unnecessary-value-param)
  return google::cloud::internal::MakeUnimplementedPaginationRange<
      StreamRange<google::cloud::config::v1::TerraformVersion>>();
}

StatusOr<google::cloud::config::v1::TerraformVersion>
ConfigConnection::GetTerraformVersion(
    google::cloud::config::v1::GetTerraformVersionRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

std::shared_ptr<ConfigConnection> MakeConfigConnection(Options options) {
  internal::CheckExpectedOptions<CommonOptionList, GrpcOptionList,
                                 UnifiedCredentialsOptionList,
                                 ConfigPolicyOptionList>(options, __func__);
  options = config_v1_internal::ConfigDefaultOptions(std::move(options));
  auto background = internal::MakeBackgroundThreadsFactory(options)();
  auto auth = internal::CreateAuthenticationStrategy(background->cq(), options);
  auto stub =
      config_v1_internal::CreateDefaultConfigStub(std::move(auth), options);
  return config_v1_internal::MakeConfigTracingConnection(
      std::make_shared<config_v1_internal::ConfigConnectionImpl>(
          std::move(background), std::move(stub), std::move(options)));
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace config_v1
}  // namespace cloud
}  // namespace google
