// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/container/v1/cluster_service.proto

#include "google/cloud/container/v1/cluster_manager_client.h"
#include <memory>
#include <utility>

namespace google {
namespace cloud {
namespace container_v1 {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

ClusterManagerClient::ClusterManagerClient(
    std::shared_ptr<ClusterManagerConnection> connection, Options opts)
    : connection_(std::move(connection)),
      options_(
          internal::MergeOptions(std::move(opts), connection_->options())) {}
ClusterManagerClient::~ClusterManagerClient() = default;

StatusOr<google::container::v1::ListClustersResponse>
ClusterManagerClient::ListClusters(std::string const& parent, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::container::v1::ListClustersRequest request;
  request.set_parent(parent);
  return connection_->ListClusters(request);
}

StatusOr<google::container::v1::ListClustersResponse>
ClusterManagerClient::ListClusters(
    google::container::v1::ListClustersRequest const& request, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->ListClusters(request);
}

StatusOr<google::container::v1::Cluster> ClusterManagerClient::GetCluster(
    std::string const& name, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::container::v1::GetClusterRequest request;
  request.set_name(name);
  return connection_->GetCluster(request);
}

StatusOr<google::container::v1::Cluster> ClusterManagerClient::GetCluster(
    google::container::v1::GetClusterRequest const& request, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->GetCluster(request);
}

StatusOr<google::container::v1::Operation> ClusterManagerClient::CreateCluster(
    std::string const& parent, google::container::v1::Cluster const& cluster,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::container::v1::CreateClusterRequest request;
  request.set_parent(parent);
  *request.mutable_cluster() = cluster;
  return connection_->CreateCluster(request);
}

StatusOr<google::container::v1::Operation> ClusterManagerClient::CreateCluster(
    google::container::v1::CreateClusterRequest const& request, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->CreateCluster(request);
}

StatusOr<google::container::v1::Operation> ClusterManagerClient::UpdateCluster(
    std::string const& name, google::container::v1::ClusterUpdate const& update,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::container::v1::UpdateClusterRequest request;
  request.set_name(name);
  *request.mutable_update() = update;
  return connection_->UpdateCluster(request);
}

StatusOr<google::container::v1::Operation> ClusterManagerClient::UpdateCluster(
    google::container::v1::UpdateClusterRequest const& request, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->UpdateCluster(request);
}

StatusOr<google::container::v1::Operation> ClusterManagerClient::UpdateNodePool(
    google::container::v1::UpdateNodePoolRequest const& request, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->UpdateNodePool(request);
}

StatusOr<google::container::v1::Operation>
ClusterManagerClient::SetNodePoolAutoscaling(
    google::container::v1::SetNodePoolAutoscalingRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->SetNodePoolAutoscaling(request);
}

StatusOr<google::container::v1::Operation>
ClusterManagerClient::SetLoggingService(std::string const& name,
                                        std::string const& logging_service,
                                        Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::container::v1::SetLoggingServiceRequest request;
  request.set_name(name);
  request.set_logging_service(logging_service);
  return connection_->SetLoggingService(request);
}

StatusOr<google::container::v1::Operation>
ClusterManagerClient::SetLoggingService(
    google::container::v1::SetLoggingServiceRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->SetLoggingService(request);
}

StatusOr<google::container::v1::Operation>
ClusterManagerClient::SetMonitoringService(
    std::string const& name, std::string const& monitoring_service,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::container::v1::SetMonitoringServiceRequest request;
  request.set_name(name);
  request.set_monitoring_service(monitoring_service);
  return connection_->SetMonitoringService(request);
}

StatusOr<google::container::v1::Operation>
ClusterManagerClient::SetMonitoringService(
    google::container::v1::SetMonitoringServiceRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->SetMonitoringService(request);
}

StatusOr<google::container::v1::Operation>
ClusterManagerClient::SetAddonsConfig(
    std::string const& name,
    google::container::v1::AddonsConfig const& addons_config, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::container::v1::SetAddonsConfigRequest request;
  request.set_name(name);
  *request.mutable_addons_config() = addons_config;
  return connection_->SetAddonsConfig(request);
}

StatusOr<google::container::v1::Operation>
ClusterManagerClient::SetAddonsConfig(
    google::container::v1::SetAddonsConfigRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->SetAddonsConfig(request);
}

StatusOr<google::container::v1::Operation> ClusterManagerClient::SetLocations(
    std::string const& name, std::vector<std::string> const& locations,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::container::v1::SetLocationsRequest request;
  request.set_name(name);
  *request.mutable_locations() = {locations.begin(), locations.end()};
  return connection_->SetLocations(request);
}

StatusOr<google::container::v1::Operation> ClusterManagerClient::SetLocations(
    google::container::v1::SetLocationsRequest const& request, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->SetLocations(request);
}

StatusOr<google::container::v1::Operation> ClusterManagerClient::UpdateMaster(
    std::string const& name, std::string const& master_version, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::container::v1::UpdateMasterRequest request;
  request.set_name(name);
  request.set_master_version(master_version);
  return connection_->UpdateMaster(request);
}

StatusOr<google::container::v1::Operation> ClusterManagerClient::UpdateMaster(
    google::container::v1::UpdateMasterRequest const& request, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->UpdateMaster(request);
}

StatusOr<google::container::v1::Operation> ClusterManagerClient::SetMasterAuth(
    google::container::v1::SetMasterAuthRequest const& request, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->SetMasterAuth(request);
}

StatusOr<google::container::v1::Operation> ClusterManagerClient::DeleteCluster(
    std::string const& name, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::container::v1::DeleteClusterRequest request;
  request.set_name(name);
  return connection_->DeleteCluster(request);
}

StatusOr<google::container::v1::Operation> ClusterManagerClient::DeleteCluster(
    google::container::v1::DeleteClusterRequest const& request, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->DeleteCluster(request);
}

StatusOr<google::container::v1::ListOperationsResponse>
ClusterManagerClient::ListOperations(std::string const& parent, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::container::v1::ListOperationsRequest request;
  request.set_parent(parent);
  return connection_->ListOperations(request);
}

StatusOr<google::container::v1::ListOperationsResponse>
ClusterManagerClient::ListOperations(
    google::container::v1::ListOperationsRequest const& request, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->ListOperations(request);
}

StatusOr<google::container::v1::Operation> ClusterManagerClient::GetOperation(
    std::string const& name, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::container::v1::GetOperationRequest request;
  request.set_name(name);
  return connection_->GetOperation(request);
}

StatusOr<google::container::v1::Operation> ClusterManagerClient::GetOperation(
    google::container::v1::GetOperationRequest const& request, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->GetOperation(request);
}

Status ClusterManagerClient::CancelOperation(std::string const& name,
                                             Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::container::v1::CancelOperationRequest request;
  request.set_name(name);
  return connection_->CancelOperation(request);
}

Status ClusterManagerClient::CancelOperation(
    google::container::v1::CancelOperationRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->CancelOperation(request);
}

StatusOr<google::container::v1::ServerConfig>
ClusterManagerClient::GetServerConfig(std::string const& name, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::container::v1::GetServerConfigRequest request;
  request.set_name(name);
  return connection_->GetServerConfig(request);
}

StatusOr<google::container::v1::ServerConfig>
ClusterManagerClient::GetServerConfig(
    google::container::v1::GetServerConfigRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->GetServerConfig(request);
}

StatusOr<google::container::v1::GetJSONWebKeysResponse>
ClusterManagerClient::GetJSONWebKeys(
    google::container::v1::GetJSONWebKeysRequest const& request, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->GetJSONWebKeys(request);
}

StatusOr<google::container::v1::ListNodePoolsResponse>
ClusterManagerClient::ListNodePools(std::string const& parent, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::container::v1::ListNodePoolsRequest request;
  request.set_parent(parent);
  return connection_->ListNodePools(request);
}

StatusOr<google::container::v1::ListNodePoolsResponse>
ClusterManagerClient::ListNodePools(
    google::container::v1::ListNodePoolsRequest const& request, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->ListNodePools(request);
}

StatusOr<google::container::v1::NodePool> ClusterManagerClient::GetNodePool(
    std::string const& name, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::container::v1::GetNodePoolRequest request;
  request.set_name(name);
  return connection_->GetNodePool(request);
}

StatusOr<google::container::v1::NodePool> ClusterManagerClient::GetNodePool(
    google::container::v1::GetNodePoolRequest const& request, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->GetNodePool(request);
}

StatusOr<google::container::v1::Operation> ClusterManagerClient::CreateNodePool(
    std::string const& parent, google::container::v1::NodePool const& node_pool,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::container::v1::CreateNodePoolRequest request;
  request.set_parent(parent);
  *request.mutable_node_pool() = node_pool;
  return connection_->CreateNodePool(request);
}

StatusOr<google::container::v1::Operation> ClusterManagerClient::CreateNodePool(
    google::container::v1::CreateNodePoolRequest const& request, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->CreateNodePool(request);
}

StatusOr<google::container::v1::Operation> ClusterManagerClient::DeleteNodePool(
    std::string const& name, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::container::v1::DeleteNodePoolRequest request;
  request.set_name(name);
  return connection_->DeleteNodePool(request);
}

StatusOr<google::container::v1::Operation> ClusterManagerClient::DeleteNodePool(
    google::container::v1::DeleteNodePoolRequest const& request, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->DeleteNodePool(request);
}

Status ClusterManagerClient::CompleteNodePoolUpgrade(
    google::container::v1::CompleteNodePoolUpgradeRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->CompleteNodePoolUpgrade(request);
}

StatusOr<google::container::v1::Operation>
ClusterManagerClient::RollbackNodePoolUpgrade(std::string const& name,
                                              Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::container::v1::RollbackNodePoolUpgradeRequest request;
  request.set_name(name);
  return connection_->RollbackNodePoolUpgrade(request);
}

StatusOr<google::container::v1::Operation>
ClusterManagerClient::RollbackNodePoolUpgrade(
    google::container::v1::RollbackNodePoolUpgradeRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->RollbackNodePoolUpgrade(request);
}

StatusOr<google::container::v1::Operation>
ClusterManagerClient::SetNodePoolManagement(
    google::container::v1::SetNodePoolManagementRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->SetNodePoolManagement(request);
}

StatusOr<google::container::v1::Operation> ClusterManagerClient::SetLabels(
    google::container::v1::SetLabelsRequest const& request, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->SetLabels(request);
}

StatusOr<google::container::v1::Operation> ClusterManagerClient::SetLegacyAbac(
    std::string const& name, bool enabled, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::container::v1::SetLegacyAbacRequest request;
  request.set_name(name);
  request.set_enabled(enabled);
  return connection_->SetLegacyAbac(request);
}

StatusOr<google::container::v1::Operation> ClusterManagerClient::SetLegacyAbac(
    google::container::v1::SetLegacyAbacRequest const& request, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->SetLegacyAbac(request);
}

StatusOr<google::container::v1::Operation>
ClusterManagerClient::StartIPRotation(std::string const& name, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::container::v1::StartIPRotationRequest request;
  request.set_name(name);
  return connection_->StartIPRotation(request);
}

StatusOr<google::container::v1::Operation>
ClusterManagerClient::StartIPRotation(
    google::container::v1::StartIPRotationRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->StartIPRotation(request);
}

StatusOr<google::container::v1::Operation>
ClusterManagerClient::CompleteIPRotation(std::string const& name,
                                         Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::container::v1::CompleteIPRotationRequest request;
  request.set_name(name);
  return connection_->CompleteIPRotation(request);
}

StatusOr<google::container::v1::Operation>
ClusterManagerClient::CompleteIPRotation(
    google::container::v1::CompleteIPRotationRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->CompleteIPRotation(request);
}

StatusOr<google::container::v1::Operation>
ClusterManagerClient::SetNodePoolSize(
    google::container::v1::SetNodePoolSizeRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->SetNodePoolSize(request);
}

StatusOr<google::container::v1::Operation>
ClusterManagerClient::SetNetworkPolicy(
    std::string const& name,
    google::container::v1::NetworkPolicy const& network_policy, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::container::v1::SetNetworkPolicyRequest request;
  request.set_name(name);
  *request.mutable_network_policy() = network_policy;
  return connection_->SetNetworkPolicy(request);
}

StatusOr<google::container::v1::Operation>
ClusterManagerClient::SetNetworkPolicy(
    google::container::v1::SetNetworkPolicyRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->SetNetworkPolicy(request);
}

StatusOr<google::container::v1::Operation>
ClusterManagerClient::SetMaintenancePolicy(
    std::string const& project_id, std::string const& zone,
    std::string const& cluster_id,
    google::container::v1::MaintenancePolicy const& maintenance_policy,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::container::v1::SetMaintenancePolicyRequest request;
  request.set_project_id(project_id);
  request.set_zone(zone);
  request.set_cluster_id(cluster_id);
  *request.mutable_maintenance_policy() = maintenance_policy;
  return connection_->SetMaintenancePolicy(request);
}

StatusOr<google::container::v1::Operation>
ClusterManagerClient::SetMaintenancePolicy(
    std::string const& name,
    google::container::v1::MaintenancePolicy const& maintenance_policy,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::container::v1::SetMaintenancePolicyRequest request;
  request.set_name(name);
  *request.mutable_maintenance_policy() = maintenance_policy;
  return connection_->SetMaintenancePolicy(request);
}

StatusOr<google::container::v1::Operation>
ClusterManagerClient::SetMaintenancePolicy(
    google::container::v1::SetMaintenancePolicyRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->SetMaintenancePolicy(request);
}

StreamRange<google::container::v1::UsableSubnetwork>
ClusterManagerClient::ListUsableSubnetworks(
    google::container::v1::ListUsableSubnetworksRequest request, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->ListUsableSubnetworks(std::move(request));
}

StatusOr<google::container::v1::CheckAutopilotCompatibilityResponse>
ClusterManagerClient::CheckAutopilotCompatibility(
    google::container::v1::CheckAutopilotCompatibilityRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->CheckAutopilotCompatibility(request);
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace container_v1
}  // namespace cloud
}  // namespace google
