// Copyright 2024 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/dataplex/v1/catalog.proto

#include "google/cloud/dataplex/v1/internal/catalog_tracing_connection.h"
#include "google/cloud/internal/opentelemetry.h"
#include "google/cloud/internal/traced_stream_range.h"
#include <memory>
#include <utility>

namespace google {
namespace cloud {
namespace dataplex_v1_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

#ifdef GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY

CatalogServiceTracingConnection::CatalogServiceTracingConnection(
    std::shared_ptr<dataplex_v1::CatalogServiceConnection> child)
    : child_(std::move(child)) {}

future<StatusOr<google::cloud::dataplex::v1::EntryType>>
CatalogServiceTracingConnection::CreateEntryType(
    google::cloud::dataplex::v1::CreateEntryTypeRequest const& request) {
  auto span = internal::MakeSpan(
      "dataplex_v1::CatalogServiceConnection::CreateEntryType");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span), child_->CreateEntryType(request));
}

StatusOr<google::longrunning::Operation>
CatalogServiceTracingConnection::CreateEntryType(
    NoAwaitTag,
    google::cloud::dataplex::v1::CreateEntryTypeRequest const& request) {
  auto span = internal::MakeSpan(
      "dataplex_v1::CatalogServiceConnection::CreateEntryType");
  opentelemetry::trace::Scope scope(span);
  return internal::EndSpan(*span,
                           child_->CreateEntryType(NoAwaitTag{}, request));
}

future<StatusOr<google::cloud::dataplex::v1::EntryType>>
CatalogServiceTracingConnection::CreateEntryType(
    google::longrunning::Operation const& operation) {
  auto span = internal::MakeSpan(
      "dataplex_v1::CatalogServiceConnection::CreateEntryType");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span), child_->CreateEntryType(operation));
}

future<StatusOr<google::cloud::dataplex::v1::EntryType>>
CatalogServiceTracingConnection::UpdateEntryType(
    google::cloud::dataplex::v1::UpdateEntryTypeRequest const& request) {
  auto span = internal::MakeSpan(
      "dataplex_v1::CatalogServiceConnection::UpdateEntryType");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span), child_->UpdateEntryType(request));
}

StatusOr<google::longrunning::Operation>
CatalogServiceTracingConnection::UpdateEntryType(
    NoAwaitTag,
    google::cloud::dataplex::v1::UpdateEntryTypeRequest const& request) {
  auto span = internal::MakeSpan(
      "dataplex_v1::CatalogServiceConnection::UpdateEntryType");
  opentelemetry::trace::Scope scope(span);
  return internal::EndSpan(*span,
                           child_->UpdateEntryType(NoAwaitTag{}, request));
}

future<StatusOr<google::cloud::dataplex::v1::EntryType>>
CatalogServiceTracingConnection::UpdateEntryType(
    google::longrunning::Operation const& operation) {
  auto span = internal::MakeSpan(
      "dataplex_v1::CatalogServiceConnection::UpdateEntryType");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span), child_->UpdateEntryType(operation));
}

future<StatusOr<google::cloud::dataplex::v1::OperationMetadata>>
CatalogServiceTracingConnection::DeleteEntryType(
    google::cloud::dataplex::v1::DeleteEntryTypeRequest const& request) {
  auto span = internal::MakeSpan(
      "dataplex_v1::CatalogServiceConnection::DeleteEntryType");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span), child_->DeleteEntryType(request));
}

StatusOr<google::longrunning::Operation>
CatalogServiceTracingConnection::DeleteEntryType(
    NoAwaitTag,
    google::cloud::dataplex::v1::DeleteEntryTypeRequest const& request) {
  auto span = internal::MakeSpan(
      "dataplex_v1::CatalogServiceConnection::DeleteEntryType");
  opentelemetry::trace::Scope scope(span);
  return internal::EndSpan(*span,
                           child_->DeleteEntryType(NoAwaitTag{}, request));
}

future<StatusOr<google::cloud::dataplex::v1::OperationMetadata>>
CatalogServiceTracingConnection::DeleteEntryType(
    google::longrunning::Operation const& operation) {
  auto span = internal::MakeSpan(
      "dataplex_v1::CatalogServiceConnection::DeleteEntryType");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span), child_->DeleteEntryType(operation));
}

StreamRange<google::cloud::dataplex::v1::EntryType>
CatalogServiceTracingConnection::ListEntryTypes(
    google::cloud::dataplex::v1::ListEntryTypesRequest request) {
  auto span = internal::MakeSpan(
      "dataplex_v1::CatalogServiceConnection::ListEntryTypes");
  internal::OTelScope scope(span);
  auto sr = child_->ListEntryTypes(std::move(request));
  return internal::MakeTracedStreamRange<
      google::cloud::dataplex::v1::EntryType>(std::move(span), std::move(sr));
}

StatusOr<google::cloud::dataplex::v1::EntryType>
CatalogServiceTracingConnection::GetEntryType(
    google::cloud::dataplex::v1::GetEntryTypeRequest const& request) {
  auto span =
      internal::MakeSpan("dataplex_v1::CatalogServiceConnection::GetEntryType");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->GetEntryType(request));
}

future<StatusOr<google::cloud::dataplex::v1::AspectType>>
CatalogServiceTracingConnection::CreateAspectType(
    google::cloud::dataplex::v1::CreateAspectTypeRequest const& request) {
  auto span = internal::MakeSpan(
      "dataplex_v1::CatalogServiceConnection::CreateAspectType");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span), child_->CreateAspectType(request));
}

StatusOr<google::longrunning::Operation>
CatalogServiceTracingConnection::CreateAspectType(
    NoAwaitTag,
    google::cloud::dataplex::v1::CreateAspectTypeRequest const& request) {
  auto span = internal::MakeSpan(
      "dataplex_v1::CatalogServiceConnection::CreateAspectType");
  opentelemetry::trace::Scope scope(span);
  return internal::EndSpan(*span,
                           child_->CreateAspectType(NoAwaitTag{}, request));
}

future<StatusOr<google::cloud::dataplex::v1::AspectType>>
CatalogServiceTracingConnection::CreateAspectType(
    google::longrunning::Operation const& operation) {
  auto span = internal::MakeSpan(
      "dataplex_v1::CatalogServiceConnection::CreateAspectType");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span),
                           child_->CreateAspectType(operation));
}

future<StatusOr<google::cloud::dataplex::v1::AspectType>>
CatalogServiceTracingConnection::UpdateAspectType(
    google::cloud::dataplex::v1::UpdateAspectTypeRequest const& request) {
  auto span = internal::MakeSpan(
      "dataplex_v1::CatalogServiceConnection::UpdateAspectType");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span), child_->UpdateAspectType(request));
}

StatusOr<google::longrunning::Operation>
CatalogServiceTracingConnection::UpdateAspectType(
    NoAwaitTag,
    google::cloud::dataplex::v1::UpdateAspectTypeRequest const& request) {
  auto span = internal::MakeSpan(
      "dataplex_v1::CatalogServiceConnection::UpdateAspectType");
  opentelemetry::trace::Scope scope(span);
  return internal::EndSpan(*span,
                           child_->UpdateAspectType(NoAwaitTag{}, request));
}

future<StatusOr<google::cloud::dataplex::v1::AspectType>>
CatalogServiceTracingConnection::UpdateAspectType(
    google::longrunning::Operation const& operation) {
  auto span = internal::MakeSpan(
      "dataplex_v1::CatalogServiceConnection::UpdateAspectType");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span),
                           child_->UpdateAspectType(operation));
}

future<StatusOr<google::cloud::dataplex::v1::OperationMetadata>>
CatalogServiceTracingConnection::DeleteAspectType(
    google::cloud::dataplex::v1::DeleteAspectTypeRequest const& request) {
  auto span = internal::MakeSpan(
      "dataplex_v1::CatalogServiceConnection::DeleteAspectType");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span), child_->DeleteAspectType(request));
}

StatusOr<google::longrunning::Operation>
CatalogServiceTracingConnection::DeleteAspectType(
    NoAwaitTag,
    google::cloud::dataplex::v1::DeleteAspectTypeRequest const& request) {
  auto span = internal::MakeSpan(
      "dataplex_v1::CatalogServiceConnection::DeleteAspectType");
  opentelemetry::trace::Scope scope(span);
  return internal::EndSpan(*span,
                           child_->DeleteAspectType(NoAwaitTag{}, request));
}

future<StatusOr<google::cloud::dataplex::v1::OperationMetadata>>
CatalogServiceTracingConnection::DeleteAspectType(
    google::longrunning::Operation const& operation) {
  auto span = internal::MakeSpan(
      "dataplex_v1::CatalogServiceConnection::DeleteAspectType");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span),
                           child_->DeleteAspectType(operation));
}

StreamRange<google::cloud::dataplex::v1::AspectType>
CatalogServiceTracingConnection::ListAspectTypes(
    google::cloud::dataplex::v1::ListAspectTypesRequest request) {
  auto span = internal::MakeSpan(
      "dataplex_v1::CatalogServiceConnection::ListAspectTypes");
  internal::OTelScope scope(span);
  auto sr = child_->ListAspectTypes(std::move(request));
  return internal::MakeTracedStreamRange<
      google::cloud::dataplex::v1::AspectType>(std::move(span), std::move(sr));
}

StatusOr<google::cloud::dataplex::v1::AspectType>
CatalogServiceTracingConnection::GetAspectType(
    google::cloud::dataplex::v1::GetAspectTypeRequest const& request) {
  auto span = internal::MakeSpan(
      "dataplex_v1::CatalogServiceConnection::GetAspectType");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->GetAspectType(request));
}

future<StatusOr<google::cloud::dataplex::v1::EntryGroup>>
CatalogServiceTracingConnection::CreateEntryGroup(
    google::cloud::dataplex::v1::CreateEntryGroupRequest const& request) {
  auto span = internal::MakeSpan(
      "dataplex_v1::CatalogServiceConnection::CreateEntryGroup");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span), child_->CreateEntryGroup(request));
}

StatusOr<google::longrunning::Operation>
CatalogServiceTracingConnection::CreateEntryGroup(
    NoAwaitTag,
    google::cloud::dataplex::v1::CreateEntryGroupRequest const& request) {
  auto span = internal::MakeSpan(
      "dataplex_v1::CatalogServiceConnection::CreateEntryGroup");
  opentelemetry::trace::Scope scope(span);
  return internal::EndSpan(*span,
                           child_->CreateEntryGroup(NoAwaitTag{}, request));
}

future<StatusOr<google::cloud::dataplex::v1::EntryGroup>>
CatalogServiceTracingConnection::CreateEntryGroup(
    google::longrunning::Operation const& operation) {
  auto span = internal::MakeSpan(
      "dataplex_v1::CatalogServiceConnection::CreateEntryGroup");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span),
                           child_->CreateEntryGroup(operation));
}

future<StatusOr<google::cloud::dataplex::v1::EntryGroup>>
CatalogServiceTracingConnection::UpdateEntryGroup(
    google::cloud::dataplex::v1::UpdateEntryGroupRequest const& request) {
  auto span = internal::MakeSpan(
      "dataplex_v1::CatalogServiceConnection::UpdateEntryGroup");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span), child_->UpdateEntryGroup(request));
}

StatusOr<google::longrunning::Operation>
CatalogServiceTracingConnection::UpdateEntryGroup(
    NoAwaitTag,
    google::cloud::dataplex::v1::UpdateEntryGroupRequest const& request) {
  auto span = internal::MakeSpan(
      "dataplex_v1::CatalogServiceConnection::UpdateEntryGroup");
  opentelemetry::trace::Scope scope(span);
  return internal::EndSpan(*span,
                           child_->UpdateEntryGroup(NoAwaitTag{}, request));
}

future<StatusOr<google::cloud::dataplex::v1::EntryGroup>>
CatalogServiceTracingConnection::UpdateEntryGroup(
    google::longrunning::Operation const& operation) {
  auto span = internal::MakeSpan(
      "dataplex_v1::CatalogServiceConnection::UpdateEntryGroup");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span),
                           child_->UpdateEntryGroup(operation));
}

future<StatusOr<google::cloud::dataplex::v1::OperationMetadata>>
CatalogServiceTracingConnection::DeleteEntryGroup(
    google::cloud::dataplex::v1::DeleteEntryGroupRequest const& request) {
  auto span = internal::MakeSpan(
      "dataplex_v1::CatalogServiceConnection::DeleteEntryGroup");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span), child_->DeleteEntryGroup(request));
}

StatusOr<google::longrunning::Operation>
CatalogServiceTracingConnection::DeleteEntryGroup(
    NoAwaitTag,
    google::cloud::dataplex::v1::DeleteEntryGroupRequest const& request) {
  auto span = internal::MakeSpan(
      "dataplex_v1::CatalogServiceConnection::DeleteEntryGroup");
  opentelemetry::trace::Scope scope(span);
  return internal::EndSpan(*span,
                           child_->DeleteEntryGroup(NoAwaitTag{}, request));
}

future<StatusOr<google::cloud::dataplex::v1::OperationMetadata>>
CatalogServiceTracingConnection::DeleteEntryGroup(
    google::longrunning::Operation const& operation) {
  auto span = internal::MakeSpan(
      "dataplex_v1::CatalogServiceConnection::DeleteEntryGroup");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span),
                           child_->DeleteEntryGroup(operation));
}

StreamRange<google::cloud::dataplex::v1::EntryGroup>
CatalogServiceTracingConnection::ListEntryGroups(
    google::cloud::dataplex::v1::ListEntryGroupsRequest request) {
  auto span = internal::MakeSpan(
      "dataplex_v1::CatalogServiceConnection::ListEntryGroups");
  internal::OTelScope scope(span);
  auto sr = child_->ListEntryGroups(std::move(request));
  return internal::MakeTracedStreamRange<
      google::cloud::dataplex::v1::EntryGroup>(std::move(span), std::move(sr));
}

StatusOr<google::cloud::dataplex::v1::EntryGroup>
CatalogServiceTracingConnection::GetEntryGroup(
    google::cloud::dataplex::v1::GetEntryGroupRequest const& request) {
  auto span = internal::MakeSpan(
      "dataplex_v1::CatalogServiceConnection::GetEntryGroup");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->GetEntryGroup(request));
}

StatusOr<google::cloud::dataplex::v1::Entry>
CatalogServiceTracingConnection::CreateEntry(
    google::cloud::dataplex::v1::CreateEntryRequest const& request) {
  auto span =
      internal::MakeSpan("dataplex_v1::CatalogServiceConnection::CreateEntry");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->CreateEntry(request));
}

StatusOr<google::cloud::dataplex::v1::Entry>
CatalogServiceTracingConnection::UpdateEntry(
    google::cloud::dataplex::v1::UpdateEntryRequest const& request) {
  auto span =
      internal::MakeSpan("dataplex_v1::CatalogServiceConnection::UpdateEntry");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->UpdateEntry(request));
}

StatusOr<google::cloud::dataplex::v1::Entry>
CatalogServiceTracingConnection::DeleteEntry(
    google::cloud::dataplex::v1::DeleteEntryRequest const& request) {
  auto span =
      internal::MakeSpan("dataplex_v1::CatalogServiceConnection::DeleteEntry");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->DeleteEntry(request));
}

StreamRange<google::cloud::dataplex::v1::Entry>
CatalogServiceTracingConnection::ListEntries(
    google::cloud::dataplex::v1::ListEntriesRequest request) {
  auto span =
      internal::MakeSpan("dataplex_v1::CatalogServiceConnection::ListEntries");
  internal::OTelScope scope(span);
  auto sr = child_->ListEntries(std::move(request));
  return internal::MakeTracedStreamRange<google::cloud::dataplex::v1::Entry>(
      std::move(span), std::move(sr));
}

StatusOr<google::cloud::dataplex::v1::Entry>
CatalogServiceTracingConnection::GetEntry(
    google::cloud::dataplex::v1::GetEntryRequest const& request) {
  auto span =
      internal::MakeSpan("dataplex_v1::CatalogServiceConnection::GetEntry");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->GetEntry(request));
}

StatusOr<google::cloud::dataplex::v1::Entry>
CatalogServiceTracingConnection::LookupEntry(
    google::cloud::dataplex::v1::LookupEntryRequest const& request) {
  auto span =
      internal::MakeSpan("dataplex_v1::CatalogServiceConnection::LookupEntry");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->LookupEntry(request));
}

StreamRange<google::cloud::dataplex::v1::SearchEntriesResult>
CatalogServiceTracingConnection::SearchEntries(
    google::cloud::dataplex::v1::SearchEntriesRequest request) {
  auto span = internal::MakeSpan(
      "dataplex_v1::CatalogServiceConnection::SearchEntries");
  internal::OTelScope scope(span);
  auto sr = child_->SearchEntries(std::move(request));
  return internal::MakeTracedStreamRange<
      google::cloud::dataplex::v1::SearchEntriesResult>(std::move(span),
                                                        std::move(sr));
}

#endif  // GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY

std::shared_ptr<dataplex_v1::CatalogServiceConnection>
MakeCatalogServiceTracingConnection(
    std::shared_ptr<dataplex_v1::CatalogServiceConnection> conn) {
#ifdef GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY
  if (internal::TracingEnabled(conn->options())) {
    conn = std::make_shared<CatalogServiceTracingConnection>(std::move(conn));
  }
#endif  // GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY
  return conn;
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace dataplex_v1_internal
}  // namespace cloud
}  // namespace google
