// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/datastream/v1/datastream.proto

#ifndef GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_DATASTREAM_V1_DATASTREAM_CLIENT_H
#define GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_DATASTREAM_V1_DATASTREAM_CLIENT_H

#include "google/cloud/datastream/v1/datastream_connection.h"
#include "google/cloud/future.h"
#include "google/cloud/no_await_tag.h"
#include "google/cloud/options.h"
#include "google/cloud/polling_policy.h"
#include "google/cloud/status_or.h"
#include "google/cloud/version.h"
#include <google/longrunning/operations.grpc.pb.h>
#include <map>
#include <memory>
#include <string>

namespace google {
namespace cloud {
namespace datastream_v1 {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

///
/// Datastream service
///
/// @par Equality
///
/// Instances of this class created via copy-construction or copy-assignment
/// always compare equal. Instances created with equal
/// `std::shared_ptr<*Connection>` objects compare equal. Objects that compare
/// equal share the same underlying resources.
///
/// @par Performance
///
/// Creating a new instance of this class is a relatively expensive operation,
/// new objects establish new connections to the service. In contrast,
/// copy-construction, move-construction, and the corresponding assignment
/// operations are relatively efficient as the copies share all underlying
/// resources.
///
/// @par Thread Safety
///
/// Concurrent access to different instances of this class, even if they compare
/// equal, is guaranteed to work. Two or more threads operating on the same
/// instance of this class is not guaranteed to work. Since copy-construction
/// and move-construction is a relatively efficient operation, consider using
/// such a copy when using this class from multiple threads.
///
class DatastreamClient {
 public:
  explicit DatastreamClient(std::shared_ptr<DatastreamConnection> connection,
                            Options opts = {});
  ~DatastreamClient();

  ///@{
  /// @name Copy and move support
  DatastreamClient(DatastreamClient const&) = default;
  DatastreamClient& operator=(DatastreamClient const&) = default;
  DatastreamClient(DatastreamClient&&) = default;
  DatastreamClient& operator=(DatastreamClient&&) = default;
  ///@}

  ///@{
  /// @name Equality
  friend bool operator==(DatastreamClient const& a, DatastreamClient const& b) {
    return a.connection_ == b.connection_;
  }
  friend bool operator!=(DatastreamClient const& a, DatastreamClient const& b) {
    return !(a == b);
  }
  ///@}

  // clang-format off
  ///
  /// Use this method to list connection profiles created in a project and
  /// location.
  ///
  /// @param parent  Required. The parent that owns the collection of connection profiles.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return a [StreamRange](@ref google::cloud::StreamRange)
  ///     to iterate of the results. See the documentation of this type for
  ///     details. In brief, this class has `begin()` and `end()` member
  ///     functions returning a iterator class meeting the
  ///     [input iterator requirements]. The value type for this iterator is a
  ///     [`StatusOr`] as the iteration may fail even after some values are
  ///     retrieved successfully, for example, if there is a network disconnect.
  ///     An empty set of results does not indicate an error, it indicates
  ///     that there are no resources meeting the request criteria.
  ///     On a successful iteration the `StatusOr<T>` contains elements of type
  ///     [google.cloud.datastream.v1.ConnectionProfile], or rather,
  ///     the C++ class generated by Protobuf from that type. Please consult the
  ///     Protobuf documentation for details on the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.datastream.v1.ConnectionProfile]: @googleapis_reference_link{google/cloud/datastream/v1/datastream_resources.proto#L278}
  /// [google.cloud.datastream.v1.ListConnectionProfilesRequest]: @googleapis_reference_link{google/cloud/datastream/v1/datastream.proto#L403}
  ///
  // clang-format on
  StreamRange<google::cloud::datastream::v1::ConnectionProfile>
  ListConnectionProfiles(std::string const& parent, Options opts = {});

  // clang-format off
  ///
  /// Use this method to list connection profiles created in a project and
  /// location.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.datastream.v1.ListConnectionProfilesRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return a [StreamRange](@ref google::cloud::StreamRange)
  ///     to iterate of the results. See the documentation of this type for
  ///     details. In brief, this class has `begin()` and `end()` member
  ///     functions returning a iterator class meeting the
  ///     [input iterator requirements]. The value type for this iterator is a
  ///     [`StatusOr`] as the iteration may fail even after some values are
  ///     retrieved successfully, for example, if there is a network disconnect.
  ///     An empty set of results does not indicate an error, it indicates
  ///     that there are no resources meeting the request criteria.
  ///     On a successful iteration the `StatusOr<T>` contains elements of type
  ///     [google.cloud.datastream.v1.ConnectionProfile], or rather,
  ///     the C++ class generated by Protobuf from that type. Please consult the
  ///     Protobuf documentation for details on the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.datastream.v1.ConnectionProfile]: @googleapis_reference_link{google/cloud/datastream/v1/datastream_resources.proto#L278}
  /// [google.cloud.datastream.v1.ListConnectionProfilesRequest]: @googleapis_reference_link{google/cloud/datastream/v1/datastream.proto#L403}
  ///
  // clang-format on
  StreamRange<google::cloud::datastream::v1::ConnectionProfile>
  ListConnectionProfiles(
      google::cloud::datastream::v1::ListConnectionProfilesRequest request,
      Options opts = {});

  // clang-format off
  ///
  /// Use this method to get details about a connection profile.
  ///
  /// @param name  Required. The name of the connection profile resource to get.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.datastream.v1.ConnectionProfile])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.datastream.v1.ConnectionProfile]: @googleapis_reference_link{google/cloud/datastream/v1/datastream_resources.proto#L278}
  /// [google.cloud.datastream.v1.GetConnectionProfileRequest]: @googleapis_reference_link{google/cloud/datastream/v1/datastream.proto#L445}
  ///
  // clang-format on
  StatusOr<google::cloud::datastream::v1::ConnectionProfile>
  GetConnectionProfile(std::string const& name, Options opts = {});

  // clang-format off
  ///
  /// Use this method to get details about a connection profile.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.datastream.v1.GetConnectionProfileRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.datastream.v1.ConnectionProfile])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.datastream.v1.ConnectionProfile]: @googleapis_reference_link{google/cloud/datastream/v1/datastream_resources.proto#L278}
  /// [google.cloud.datastream.v1.GetConnectionProfileRequest]: @googleapis_reference_link{google/cloud/datastream/v1/datastream.proto#L445}
  ///
  // clang-format on
  StatusOr<google::cloud::datastream::v1::ConnectionProfile>
  GetConnectionProfile(
      google::cloud::datastream::v1::GetConnectionProfileRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// Use this method to create a connection profile in a project and location.
  ///
  /// @param parent  Required. The parent that owns the collection of ConnectionProfiles.
  /// @param connection_profile  Required. The connection profile resource to create.
  /// @param connection_profile_id  Required. The connection profile identifier.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.datastream.v1.ConnectionProfile] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.datastream.v1.ConnectionProfile]: @googleapis_reference_link{google/cloud/datastream/v1/datastream_resources.proto#L278}
  /// [google.cloud.datastream.v1.CreateConnectionProfileRequest]: @googleapis_reference_link{google/cloud/datastream/v1/datastream.proto#L456}
  ///
  // clang-format on
  future<StatusOr<google::cloud::datastream::v1::ConnectionProfile>>
  CreateConnectionProfile(
      std::string const& parent,
      google::cloud::datastream::v1::ConnectionProfile const&
          connection_profile,
      std::string const& connection_profile_id, Options opts = {});

  // clang-format off
  ///
  /// @copybrief CreateConnectionProfile
  ///
  /// Specifying the [`NoAwaitTag`] immediately returns the
  /// [`google::longrunning::Operation`] that corresponds to the Long Running
  /// Operation that has been started. No polling for operation status occurs.
  ///
  /// [`NoAwaitTag`]: @ref google::cloud::NoAwaitTag
  ///
  // clang-format on
  StatusOr<google::longrunning::Operation> CreateConnectionProfile(
      NoAwaitTag, std::string const& parent,
      google::cloud::datastream::v1::ConnectionProfile const&
          connection_profile,
      std::string const& connection_profile_id, Options opts = {});

  // clang-format off
  ///
  /// Use this method to create a connection profile in a project and location.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.datastream.v1.CreateConnectionProfileRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.datastream.v1.ConnectionProfile] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.datastream.v1.ConnectionProfile]: @googleapis_reference_link{google/cloud/datastream/v1/datastream_resources.proto#L278}
  /// [google.cloud.datastream.v1.CreateConnectionProfileRequest]: @googleapis_reference_link{google/cloud/datastream/v1/datastream.proto#L456}
  ///
  // clang-format on
  future<StatusOr<google::cloud::datastream::v1::ConnectionProfile>>
  CreateConnectionProfile(
      google::cloud::datastream::v1::CreateConnectionProfileRequest const&
          request,
      Options opts = {});

  // clang-format off
  ///
  /// @copybrief CreateConnectionProfile
  ///
  /// Specifying the [`NoAwaitTag`] immediately returns the
  /// [`google::longrunning::Operation`] that corresponds to the Long Running
  /// Operation that has been started. No polling for operation status occurs.
  ///
  /// [`NoAwaitTag`]: @ref google::cloud::NoAwaitTag
  ///
  // clang-format on
  StatusOr<google::longrunning::Operation> CreateConnectionProfile(
      NoAwaitTag,
      google::cloud::datastream::v1::CreateConnectionProfileRequest const&
          request,
      Options opts = {});

  // clang-format off
  ///
  /// @copybrief CreateConnectionProfile
  ///
  /// This method accepts a `google::longrunning::Operation` that corresponds
  /// to a previously started Long Running Operation (LRO) and polls the status
  /// of the LRO in the background.
  ///
  // clang-format on
  future<StatusOr<google::cloud::datastream::v1::ConnectionProfile>>
  CreateConnectionProfile(google::longrunning::Operation const& operation,
                          Options opts = {});

  // clang-format off
  ///
  /// Use this method to update the parameters of a connection profile.
  ///
  /// @param connection_profile  Required. The connection profile to update.
  /// @param update_mask  Optional. Field mask is used to specify the fields to be overwritten in the
  ///  ConnectionProfile resource by the update.
  ///  The fields specified in the update_mask are relative to the resource, not
  ///  the full request. A field will be overwritten if it is in the mask. If the
  ///  user does not provide a mask then all fields will be overwritten.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.datastream.v1.ConnectionProfile] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.datastream.v1.ConnectionProfile]: @googleapis_reference_link{google/cloud/datastream/v1/datastream_resources.proto#L278}
  /// [google.cloud.datastream.v1.UpdateConnectionProfileRequest]: @googleapis_reference_link{google/cloud/datastream/v1/datastream.proto#L496}
  ///
  // clang-format on
  future<StatusOr<google::cloud::datastream::v1::ConnectionProfile>>
  UpdateConnectionProfile(
      google::cloud::datastream::v1::ConnectionProfile const&
          connection_profile,
      google::protobuf::FieldMask const& update_mask, Options opts = {});

  // clang-format off
  ///
  /// @copybrief UpdateConnectionProfile
  ///
  /// Specifying the [`NoAwaitTag`] immediately returns the
  /// [`google::longrunning::Operation`] that corresponds to the Long Running
  /// Operation that has been started. No polling for operation status occurs.
  ///
  /// [`NoAwaitTag`]: @ref google::cloud::NoAwaitTag
  ///
  // clang-format on
  StatusOr<google::longrunning::Operation> UpdateConnectionProfile(
      NoAwaitTag,
      google::cloud::datastream::v1::ConnectionProfile const&
          connection_profile,
      google::protobuf::FieldMask const& update_mask, Options opts = {});

  // clang-format off
  ///
  /// Use this method to update the parameters of a connection profile.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.datastream.v1.UpdateConnectionProfileRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.datastream.v1.ConnectionProfile] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.datastream.v1.ConnectionProfile]: @googleapis_reference_link{google/cloud/datastream/v1/datastream_resources.proto#L278}
  /// [google.cloud.datastream.v1.UpdateConnectionProfileRequest]: @googleapis_reference_link{google/cloud/datastream/v1/datastream.proto#L496}
  ///
  // clang-format on
  future<StatusOr<google::cloud::datastream::v1::ConnectionProfile>>
  UpdateConnectionProfile(
      google::cloud::datastream::v1::UpdateConnectionProfileRequest const&
          request,
      Options opts = {});

  // clang-format off
  ///
  /// @copybrief UpdateConnectionProfile
  ///
  /// Specifying the [`NoAwaitTag`] immediately returns the
  /// [`google::longrunning::Operation`] that corresponds to the Long Running
  /// Operation that has been started. No polling for operation status occurs.
  ///
  /// [`NoAwaitTag`]: @ref google::cloud::NoAwaitTag
  ///
  // clang-format on
  StatusOr<google::longrunning::Operation> UpdateConnectionProfile(
      NoAwaitTag,
      google::cloud::datastream::v1::UpdateConnectionProfileRequest const&
          request,
      Options opts = {});

  // clang-format off
  ///
  /// @copybrief UpdateConnectionProfile
  ///
  /// This method accepts a `google::longrunning::Operation` that corresponds
  /// to a previously started Long Running Operation (LRO) and polls the status
  /// of the LRO in the background.
  ///
  // clang-format on
  future<StatusOr<google::cloud::datastream::v1::ConnectionProfile>>
  UpdateConnectionProfile(google::longrunning::Operation const& operation,
                          Options opts = {});

  // clang-format off
  ///
  /// Use this method to delete a connection profile.
  ///
  /// @param name  Required. The name of the connection profile resource to delete.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.datastream.v1.OperationMetadata] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.datastream.v1.DeleteConnectionProfileRequest]: @googleapis_reference_link{google/cloud/datastream/v1/datastream.proto#L533}
  /// [google.cloud.datastream.v1.OperationMetadata]: @googleapis_reference_link{google/cloud/datastream/v1/datastream.proto#L809}
  ///
  // clang-format on
  future<StatusOr<google::cloud::datastream::v1::OperationMetadata>>
  DeleteConnectionProfile(std::string const& name, Options opts = {});

  // clang-format off
  ///
  /// @copybrief DeleteConnectionProfile
  ///
  /// Specifying the [`NoAwaitTag`] immediately returns the
  /// [`google::longrunning::Operation`] that corresponds to the Long Running
  /// Operation that has been started. No polling for operation status occurs.
  ///
  /// [`NoAwaitTag`]: @ref google::cloud::NoAwaitTag
  ///
  // clang-format on
  StatusOr<google::longrunning::Operation> DeleteConnectionProfile(
      NoAwaitTag, std::string const& name, Options opts = {});

  // clang-format off
  ///
  /// Use this method to delete a connection profile.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.datastream.v1.DeleteConnectionProfileRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.datastream.v1.OperationMetadata] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.datastream.v1.DeleteConnectionProfileRequest]: @googleapis_reference_link{google/cloud/datastream/v1/datastream.proto#L533}
  /// [google.cloud.datastream.v1.OperationMetadata]: @googleapis_reference_link{google/cloud/datastream/v1/datastream.proto#L809}
  ///
  // clang-format on
  future<StatusOr<google::cloud::datastream::v1::OperationMetadata>>
  DeleteConnectionProfile(
      google::cloud::datastream::v1::DeleteConnectionProfileRequest const&
          request,
      Options opts = {});

  // clang-format off
  ///
  /// @copybrief DeleteConnectionProfile
  ///
  /// Specifying the [`NoAwaitTag`] immediately returns the
  /// [`google::longrunning::Operation`] that corresponds to the Long Running
  /// Operation that has been started. No polling for operation status occurs.
  ///
  /// [`NoAwaitTag`]: @ref google::cloud::NoAwaitTag
  ///
  // clang-format on
  StatusOr<google::longrunning::Operation> DeleteConnectionProfile(
      NoAwaitTag,
      google::cloud::datastream::v1::DeleteConnectionProfileRequest const&
          request,
      Options opts = {});

  // clang-format off
  ///
  /// @copybrief DeleteConnectionProfile
  ///
  /// This method accepts a `google::longrunning::Operation` that corresponds
  /// to a previously started Long Running Operation (LRO) and polls the status
  /// of the LRO in the background.
  ///
  // clang-format on
  future<StatusOr<google::cloud::datastream::v1::OperationMetadata>>
  DeleteConnectionProfile(google::longrunning::Operation const& operation,
                          Options opts = {});

  // clang-format off
  ///
  /// Use this method to discover a connection profile.
  /// The discover API call exposes the data objects and metadata belonging to
  /// the profile. Typically, a request returns children data objects of a
  /// parent data object that's optionally supplied in the request.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.datastream.v1.DiscoverConnectionProfileRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.datastream.v1.DiscoverConnectionProfileResponse])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.datastream.v1.DiscoverConnectionProfileRequest]: @googleapis_reference_link{google/cloud/datastream/v1/datastream.proto#L316}
  /// [google.cloud.datastream.v1.DiscoverConnectionProfileResponse]: @googleapis_reference_link{google/cloud/datastream/v1/datastream.proto#L359}
  ///
  // clang-format on
  StatusOr<google::cloud::datastream::v1::DiscoverConnectionProfileResponse>
  DiscoverConnectionProfile(
      google::cloud::datastream::v1::DiscoverConnectionProfileRequest const&
          request,
      Options opts = {});

  // clang-format off
  ///
  /// Use this method to list streams in a project and location.
  ///
  /// @param parent  Required. The parent that owns the collection of streams.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return a [StreamRange](@ref google::cloud::StreamRange)
  ///     to iterate of the results. See the documentation of this type for
  ///     details. In brief, this class has `begin()` and `end()` member
  ///     functions returning a iterator class meeting the
  ///     [input iterator requirements]. The value type for this iterator is a
  ///     [`StatusOr`] as the iteration may fail even after some values are
  ///     retrieved successfully, for example, if there is a network disconnect.
  ///     An empty set of results does not indicate an error, it indicates
  ///     that there are no resources meeting the request criteria.
  ///     On a successful iteration the `StatusOr<T>` contains elements of type
  ///     [google.cloud.datastream.v1.Stream], or rather,
  ///     the C++ class generated by Protobuf from that type. Please consult the
  ///     Protobuf documentation for details on the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.datastream.v1.ListStreamsRequest]: @googleapis_reference_link{google/cloud/datastream/v1/datastream.proto#L559}
  /// [google.cloud.datastream.v1.Stream]: @googleapis_reference_link{google/cloud/datastream/v1/datastream_resources.proto#L731}
  ///
  // clang-format on
  StreamRange<google::cloud::datastream::v1::Stream> ListStreams(
      std::string const& parent, Options opts = {});

  // clang-format off
  ///
  /// Use this method to list streams in a project and location.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.datastream.v1.ListStreamsRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return a [StreamRange](@ref google::cloud::StreamRange)
  ///     to iterate of the results. See the documentation of this type for
  ///     details. In brief, this class has `begin()` and `end()` member
  ///     functions returning a iterator class meeting the
  ///     [input iterator requirements]. The value type for this iterator is a
  ///     [`StatusOr`] as the iteration may fail even after some values are
  ///     retrieved successfully, for example, if there is a network disconnect.
  ///     An empty set of results does not indicate an error, it indicates
  ///     that there are no resources meeting the request criteria.
  ///     On a successful iteration the `StatusOr<T>` contains elements of type
  ///     [google.cloud.datastream.v1.Stream], or rather,
  ///     the C++ class generated by Protobuf from that type. Please consult the
  ///     Protobuf documentation for details on the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.datastream.v1.ListStreamsRequest]: @googleapis_reference_link{google/cloud/datastream/v1/datastream.proto#L559}
  /// [google.cloud.datastream.v1.Stream]: @googleapis_reference_link{google/cloud/datastream/v1/datastream_resources.proto#L731}
  ///
  // clang-format on
  StreamRange<google::cloud::datastream::v1::Stream> ListStreams(
      google::cloud::datastream::v1::ListStreamsRequest request,
      Options opts = {});

  // clang-format off
  ///
  /// Use this method to get details about a stream.
  ///
  /// @param name  Required. The name of the stream resource to get.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.datastream.v1.Stream])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.datastream.v1.GetStreamRequest]: @googleapis_reference_link{google/cloud/datastream/v1/datastream.proto#L601}
  /// [google.cloud.datastream.v1.Stream]: @googleapis_reference_link{google/cloud/datastream/v1/datastream_resources.proto#L731}
  ///
  // clang-format on
  StatusOr<google::cloud::datastream::v1::Stream> GetStream(
      std::string const& name, Options opts = {});

  // clang-format off
  ///
  /// Use this method to get details about a stream.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.datastream.v1.GetStreamRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.datastream.v1.Stream])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.datastream.v1.GetStreamRequest]: @googleapis_reference_link{google/cloud/datastream/v1/datastream.proto#L601}
  /// [google.cloud.datastream.v1.Stream]: @googleapis_reference_link{google/cloud/datastream/v1/datastream_resources.proto#L731}
  ///
  // clang-format on
  StatusOr<google::cloud::datastream::v1::Stream> GetStream(
      google::cloud::datastream::v1::GetStreamRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// Use this method to create a stream.
  ///
  /// @param parent  Required. The parent that owns the collection of streams.
  /// @param stream  Required. The stream resource to create.
  /// @param stream_id  Required. The stream identifier.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.datastream.v1.Stream] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.datastream.v1.CreateStreamRequest]: @googleapis_reference_link{google/cloud/datastream/v1/datastream.proto#L612}
  /// [google.cloud.datastream.v1.Stream]: @googleapis_reference_link{google/cloud/datastream/v1/datastream_resources.proto#L731}
  ///
  // clang-format on
  future<StatusOr<google::cloud::datastream::v1::Stream>> CreateStream(
      std::string const& parent,
      google::cloud::datastream::v1::Stream const& stream,
      std::string const& stream_id, Options opts = {});

  // clang-format off
  ///
  /// @copybrief CreateStream
  ///
  /// Specifying the [`NoAwaitTag`] immediately returns the
  /// [`google::longrunning::Operation`] that corresponds to the Long Running
  /// Operation that has been started. No polling for operation status occurs.
  ///
  /// [`NoAwaitTag`]: @ref google::cloud::NoAwaitTag
  ///
  // clang-format on
  StatusOr<google::longrunning::Operation> CreateStream(
      NoAwaitTag, std::string const& parent,
      google::cloud::datastream::v1::Stream const& stream,
      std::string const& stream_id, Options opts = {});

  // clang-format off
  ///
  /// Use this method to create a stream.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.datastream.v1.CreateStreamRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.datastream.v1.Stream] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.datastream.v1.CreateStreamRequest]: @googleapis_reference_link{google/cloud/datastream/v1/datastream.proto#L612}
  /// [google.cloud.datastream.v1.Stream]: @googleapis_reference_link{google/cloud/datastream/v1/datastream_resources.proto#L731}
  ///
  // clang-format on
  future<StatusOr<google::cloud::datastream::v1::Stream>> CreateStream(
      google::cloud::datastream::v1::CreateStreamRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// @copybrief CreateStream
  ///
  /// Specifying the [`NoAwaitTag`] immediately returns the
  /// [`google::longrunning::Operation`] that corresponds to the Long Running
  /// Operation that has been started. No polling for operation status occurs.
  ///
  /// [`NoAwaitTag`]: @ref google::cloud::NoAwaitTag
  ///
  // clang-format on
  StatusOr<google::longrunning::Operation> CreateStream(
      NoAwaitTag,
      google::cloud::datastream::v1::CreateStreamRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// @copybrief CreateStream
  ///
  /// This method accepts a `google::longrunning::Operation` that corresponds
  /// to a previously started Long Running Operation (LRO) and polls the status
  /// of the LRO in the background.
  ///
  // clang-format on
  future<StatusOr<google::cloud::datastream::v1::Stream>> CreateStream(
      google::longrunning::Operation const& operation, Options opts = {});

  // clang-format off
  ///
  /// Use this method to update the configuration of a stream.
  ///
  /// @param stream  Required. The stream resource to update.
  /// @param update_mask  Optional. Field mask is used to specify the fields to be overwritten in the
  ///  stream resource by the update.
  ///  The fields specified in the update_mask are relative to the resource, not
  ///  the full request. A field will be overwritten if it is in the mask. If the
  ///  user does not provide a mask then all fields will be overwritten.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.datastream.v1.Stream] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.datastream.v1.Stream]: @googleapis_reference_link{google/cloud/datastream/v1/datastream_resources.proto#L731}
  /// [google.cloud.datastream.v1.UpdateStreamRequest]: @googleapis_reference_link{google/cloud/datastream/v1/datastream.proto#L651}
  ///
  // clang-format on
  future<StatusOr<google::cloud::datastream::v1::Stream>> UpdateStream(
      google::cloud::datastream::v1::Stream const& stream,
      google::protobuf::FieldMask const& update_mask, Options opts = {});

  // clang-format off
  ///
  /// @copybrief UpdateStream
  ///
  /// Specifying the [`NoAwaitTag`] immediately returns the
  /// [`google::longrunning::Operation`] that corresponds to the Long Running
  /// Operation that has been started. No polling for operation status occurs.
  ///
  /// [`NoAwaitTag`]: @ref google::cloud::NoAwaitTag
  ///
  // clang-format on
  StatusOr<google::longrunning::Operation> UpdateStream(
      NoAwaitTag, google::cloud::datastream::v1::Stream const& stream,
      google::protobuf::FieldMask const& update_mask, Options opts = {});

  // clang-format off
  ///
  /// Use this method to update the configuration of a stream.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.datastream.v1.UpdateStreamRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.datastream.v1.Stream] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.datastream.v1.Stream]: @googleapis_reference_link{google/cloud/datastream/v1/datastream_resources.proto#L731}
  /// [google.cloud.datastream.v1.UpdateStreamRequest]: @googleapis_reference_link{google/cloud/datastream/v1/datastream.proto#L651}
  ///
  // clang-format on
  future<StatusOr<google::cloud::datastream::v1::Stream>> UpdateStream(
      google::cloud::datastream::v1::UpdateStreamRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// @copybrief UpdateStream
  ///
  /// Specifying the [`NoAwaitTag`] immediately returns the
  /// [`google::longrunning::Operation`] that corresponds to the Long Running
  /// Operation that has been started. No polling for operation status occurs.
  ///
  /// [`NoAwaitTag`]: @ref google::cloud::NoAwaitTag
  ///
  // clang-format on
  StatusOr<google::longrunning::Operation> UpdateStream(
      NoAwaitTag,
      google::cloud::datastream::v1::UpdateStreamRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// @copybrief UpdateStream
  ///
  /// This method accepts a `google::longrunning::Operation` that corresponds
  /// to a previously started Long Running Operation (LRO) and polls the status
  /// of the LRO in the background.
  ///
  // clang-format on
  future<StatusOr<google::cloud::datastream::v1::Stream>> UpdateStream(
      google::longrunning::Operation const& operation, Options opts = {});

  // clang-format off
  ///
  /// Use this method to delete a stream.
  ///
  /// @param name  Required. The name of the stream resource to delete.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.datastream.v1.OperationMetadata] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.datastream.v1.DeleteStreamRequest]: @googleapis_reference_link{google/cloud/datastream/v1/datastream.proto#L687}
  /// [google.cloud.datastream.v1.OperationMetadata]: @googleapis_reference_link{google/cloud/datastream/v1/datastream.proto#L809}
  ///
  // clang-format on
  future<StatusOr<google::cloud::datastream::v1::OperationMetadata>>
  DeleteStream(std::string const& name, Options opts = {});

  // clang-format off
  ///
  /// @copybrief DeleteStream
  ///
  /// Specifying the [`NoAwaitTag`] immediately returns the
  /// [`google::longrunning::Operation`] that corresponds to the Long Running
  /// Operation that has been started. No polling for operation status occurs.
  ///
  /// [`NoAwaitTag`]: @ref google::cloud::NoAwaitTag
  ///
  // clang-format on
  StatusOr<google::longrunning::Operation> DeleteStream(NoAwaitTag,
                                                        std::string const& name,
                                                        Options opts = {});

  // clang-format off
  ///
  /// Use this method to delete a stream.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.datastream.v1.DeleteStreamRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.datastream.v1.OperationMetadata] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.datastream.v1.DeleteStreamRequest]: @googleapis_reference_link{google/cloud/datastream/v1/datastream.proto#L687}
  /// [google.cloud.datastream.v1.OperationMetadata]: @googleapis_reference_link{google/cloud/datastream/v1/datastream.proto#L809}
  ///
  // clang-format on
  future<StatusOr<google::cloud::datastream::v1::OperationMetadata>>
  DeleteStream(
      google::cloud::datastream::v1::DeleteStreamRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// @copybrief DeleteStream
  ///
  /// Specifying the [`NoAwaitTag`] immediately returns the
  /// [`google::longrunning::Operation`] that corresponds to the Long Running
  /// Operation that has been started. No polling for operation status occurs.
  ///
  /// [`NoAwaitTag`]: @ref google::cloud::NoAwaitTag
  ///
  // clang-format on
  StatusOr<google::longrunning::Operation> DeleteStream(
      NoAwaitTag,
      google::cloud::datastream::v1::DeleteStreamRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// @copybrief DeleteStream
  ///
  /// This method accepts a `google::longrunning::Operation` that corresponds
  /// to a previously started Long Running Operation (LRO) and polls the status
  /// of the LRO in the background.
  ///
  // clang-format on
  future<StatusOr<google::cloud::datastream::v1::OperationMetadata>>
  DeleteStream(google::longrunning::Operation const& operation,
               Options opts = {});

  // clang-format off
  ///
  /// Use this method to get details about a stream object.
  ///
  /// @param name  Required. The name of the stream object resource to get.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.datastream.v1.StreamObject])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.datastream.v1.GetStreamObjectRequest]: @googleapis_reference_link{google/cloud/datastream/v1/datastream.proto#L713}
  /// [google.cloud.datastream.v1.StreamObject]: @googleapis_reference_link{google/cloud/datastream/v1/datastream_resources.proto#L839}
  ///
  // clang-format on
  StatusOr<google::cloud::datastream::v1::StreamObject> GetStreamObject(
      std::string const& name, Options opts = {});

  // clang-format off
  ///
  /// Use this method to get details about a stream object.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.datastream.v1.GetStreamObjectRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.datastream.v1.StreamObject])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.datastream.v1.GetStreamObjectRequest]: @googleapis_reference_link{google/cloud/datastream/v1/datastream.proto#L713}
  /// [google.cloud.datastream.v1.StreamObject]: @googleapis_reference_link{google/cloud/datastream/v1/datastream_resources.proto#L839}
  ///
  // clang-format on
  StatusOr<google::cloud::datastream::v1::StreamObject> GetStreamObject(
      google::cloud::datastream::v1::GetStreamObjectRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// Use this method to look up a stream object by its source object identifier.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.datastream.v1.LookupStreamObjectRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.datastream.v1.StreamObject])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.datastream.v1.LookupStreamObjectRequest]: @googleapis_reference_link{google/cloud/datastream/v1/datastream.proto#L725}
  /// [google.cloud.datastream.v1.StreamObject]: @googleapis_reference_link{google/cloud/datastream/v1/datastream_resources.proto#L839}
  ///
  // clang-format on
  StatusOr<google::cloud::datastream::v1::StreamObject> LookupStreamObject(
      google::cloud::datastream::v1::LookupStreamObjectRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// Use this method to list the objects of a specific stream.
  ///
  /// @param parent  Required. The parent stream that owns the collection of objects.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return a [StreamRange](@ref google::cloud::StreamRange)
  ///     to iterate of the results. See the documentation of this type for
  ///     details. In brief, this class has `begin()` and `end()` member
  ///     functions returning a iterator class meeting the
  ///     [input iterator requirements]. The value type for this iterator is a
  ///     [`StatusOr`] as the iteration may fail even after some values are
  ///     retrieved successfully, for example, if there is a network disconnect.
  ///     An empty set of results does not indicate an error, it indicates
  ///     that there are no resources meeting the request criteria.
  ///     On a successful iteration the `StatusOr<T>` contains elements of type
  ///     [google.cloud.datastream.v1.StreamObject], or rather,
  ///     the C++ class generated by Protobuf from that type. Please consult the
  ///     Protobuf documentation for details on the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.datastream.v1.ListStreamObjectsRequest]: @googleapis_reference_link{google/cloud/datastream/v1/datastream.proto#L777}
  /// [google.cloud.datastream.v1.StreamObject]: @googleapis_reference_link{google/cloud/datastream/v1/datastream_resources.proto#L839}
  ///
  // clang-format on
  StreamRange<google::cloud::datastream::v1::StreamObject> ListStreamObjects(
      std::string const& parent, Options opts = {});

  // clang-format off
  ///
  /// Use this method to list the objects of a specific stream.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.datastream.v1.ListStreamObjectsRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return a [StreamRange](@ref google::cloud::StreamRange)
  ///     to iterate of the results. See the documentation of this type for
  ///     details. In brief, this class has `begin()` and `end()` member
  ///     functions returning a iterator class meeting the
  ///     [input iterator requirements]. The value type for this iterator is a
  ///     [`StatusOr`] as the iteration may fail even after some values are
  ///     retrieved successfully, for example, if there is a network disconnect.
  ///     An empty set of results does not indicate an error, it indicates
  ///     that there are no resources meeting the request criteria.
  ///     On a successful iteration the `StatusOr<T>` contains elements of type
  ///     [google.cloud.datastream.v1.StreamObject], or rather,
  ///     the C++ class generated by Protobuf from that type. Please consult the
  ///     Protobuf documentation for details on the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.datastream.v1.ListStreamObjectsRequest]: @googleapis_reference_link{google/cloud/datastream/v1/datastream.proto#L777}
  /// [google.cloud.datastream.v1.StreamObject]: @googleapis_reference_link{google/cloud/datastream/v1/datastream_resources.proto#L839}
  ///
  // clang-format on
  StreamRange<google::cloud::datastream::v1::StreamObject> ListStreamObjects(
      google::cloud::datastream::v1::ListStreamObjectsRequest request,
      Options opts = {});

  // clang-format off
  ///
  /// Use this method to start a backfill job for the specified stream object.
  ///
  /// @param object  Required. The name of the stream object resource to start a backfill job
  ///  for.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.datastream.v1.StartBackfillJobResponse])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.datastream.v1.StartBackfillJobRequest]: @googleapis_reference_link{google/cloud/datastream/v1/datastream.proto#L740}
  /// [google.cloud.datastream.v1.StartBackfillJobResponse]: @googleapis_reference_link{google/cloud/datastream/v1/datastream.proto#L752}
  ///
  // clang-format on
  StatusOr<google::cloud::datastream::v1::StartBackfillJobResponse>
  StartBackfillJob(std::string const& object, Options opts = {});

  // clang-format off
  ///
  /// Use this method to start a backfill job for the specified stream object.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.datastream.v1.StartBackfillJobRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.datastream.v1.StartBackfillJobResponse])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.datastream.v1.StartBackfillJobRequest]: @googleapis_reference_link{google/cloud/datastream/v1/datastream.proto#L740}
  /// [google.cloud.datastream.v1.StartBackfillJobResponse]: @googleapis_reference_link{google/cloud/datastream/v1/datastream.proto#L752}
  ///
  // clang-format on
  StatusOr<google::cloud::datastream::v1::StartBackfillJobResponse>
  StartBackfillJob(
      google::cloud::datastream::v1::StartBackfillJobRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// Use this method to stop a backfill job for the specified stream object.
  ///
  /// @param object  Required. The name of the stream object resource to stop the backfill job
  ///  for.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.datastream.v1.StopBackfillJobResponse])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.datastream.v1.StopBackfillJobRequest]: @googleapis_reference_link{google/cloud/datastream/v1/datastream.proto#L759}
  /// [google.cloud.datastream.v1.StopBackfillJobResponse]: @googleapis_reference_link{google/cloud/datastream/v1/datastream.proto#L771}
  ///
  // clang-format on
  StatusOr<google::cloud::datastream::v1::StopBackfillJobResponse>
  StopBackfillJob(std::string const& object, Options opts = {});

  // clang-format off
  ///
  /// Use this method to stop a backfill job for the specified stream object.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.datastream.v1.StopBackfillJobRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.datastream.v1.StopBackfillJobResponse])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.datastream.v1.StopBackfillJobRequest]: @googleapis_reference_link{google/cloud/datastream/v1/datastream.proto#L759}
  /// [google.cloud.datastream.v1.StopBackfillJobResponse]: @googleapis_reference_link{google/cloud/datastream/v1/datastream.proto#L771}
  ///
  // clang-format on
  StatusOr<google::cloud::datastream::v1::StopBackfillJobResponse>
  StopBackfillJob(
      google::cloud::datastream::v1::StopBackfillJobRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// The FetchStaticIps API call exposes the static IP addresses used by
  /// Datastream.
  ///
  /// @param name  Required. The resource name for the location for which static IPs should be
  ///  returned. Must be in the format `projects/*/locations/*`.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return a [StreamRange](@ref google::cloud::StreamRange)
  ///     to iterate of the results. See the documentation of this type for
  ///     details. In brief, this class has `begin()` and `end()` member
  ///     functions returning a iterator class meeting the
  ///     [input iterator requirements]. The value type for this iterator is a
  ///     [`StatusOr`] as the iteration may fail even after some values are
  ///     retrieved successfully, for example, if there is a network disconnect.
  ///     An empty set of results does not indicate an error, it indicates
  ///     that there are no resources meeting the request criteria.
  ///     On a successful iteration the `StatusOr<T>` contains a
  ///     [`std::string`].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.datastream.v1.FetchStaticIpsRequest]: @googleapis_reference_link{google/cloud/datastream/v1/datastream.proto#L374}
  ///
  // clang-format on
  StreamRange<std::string> FetchStaticIps(std::string const& name,
                                          Options opts = {});

  // clang-format off
  ///
  /// The FetchStaticIps API call exposes the static IP addresses used by
  /// Datastream.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.datastream.v1.FetchStaticIpsRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return a [StreamRange](@ref google::cloud::StreamRange)
  ///     to iterate of the results. See the documentation of this type for
  ///     details. In brief, this class has `begin()` and `end()` member
  ///     functions returning a iterator class meeting the
  ///     [input iterator requirements]. The value type for this iterator is a
  ///     [`StatusOr`] as the iteration may fail even after some values are
  ///     retrieved successfully, for example, if there is a network disconnect.
  ///     An empty set of results does not indicate an error, it indicates
  ///     that there are no resources meeting the request criteria.
  ///     On a successful iteration the `StatusOr<T>` contains a
  ///     [`std::string`].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.datastream.v1.FetchStaticIpsRequest]: @googleapis_reference_link{google/cloud/datastream/v1/datastream.proto#L374}
  ///
  // clang-format on
  StreamRange<std::string> FetchStaticIps(
      google::cloud::datastream::v1::FetchStaticIpsRequest request,
      Options opts = {});

  // clang-format off
  ///
  /// Use this method to create a private connectivity configuration.
  ///
  /// @param parent  Required. The parent that owns the collection of PrivateConnections.
  /// @param private_connection  Required. The Private Connectivity resource to create.
  /// @param private_connection_id  Required. The private connectivity identifier.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.datastream.v1.PrivateConnection] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.datastream.v1.CreatePrivateConnectionRequest]: @googleapis_reference_link{google/cloud/datastream/v1/datastream.proto#L843}
  /// [google.cloud.datastream.v1.PrivateConnection]: @googleapis_reference_link{google/cloud/datastream/v1/datastream_resources.proto#L151}
  ///
  // clang-format on
  future<StatusOr<google::cloud::datastream::v1::PrivateConnection>>
  CreatePrivateConnection(
      std::string const& parent,
      google::cloud::datastream::v1::PrivateConnection const&
          private_connection,
      std::string const& private_connection_id, Options opts = {});

  // clang-format off
  ///
  /// @copybrief CreatePrivateConnection
  ///
  /// Specifying the [`NoAwaitTag`] immediately returns the
  /// [`google::longrunning::Operation`] that corresponds to the Long Running
  /// Operation that has been started. No polling for operation status occurs.
  ///
  /// [`NoAwaitTag`]: @ref google::cloud::NoAwaitTag
  ///
  // clang-format on
  StatusOr<google::longrunning::Operation> CreatePrivateConnection(
      NoAwaitTag, std::string const& parent,
      google::cloud::datastream::v1::PrivateConnection const&
          private_connection,
      std::string const& private_connection_id, Options opts = {});

  // clang-format off
  ///
  /// Use this method to create a private connectivity configuration.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.datastream.v1.CreatePrivateConnectionRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.datastream.v1.PrivateConnection] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.datastream.v1.CreatePrivateConnectionRequest]: @googleapis_reference_link{google/cloud/datastream/v1/datastream.proto#L843}
  /// [google.cloud.datastream.v1.PrivateConnection]: @googleapis_reference_link{google/cloud/datastream/v1/datastream_resources.proto#L151}
  ///
  // clang-format on
  future<StatusOr<google::cloud::datastream::v1::PrivateConnection>>
  CreatePrivateConnection(
      google::cloud::datastream::v1::CreatePrivateConnectionRequest const&
          request,
      Options opts = {});

  // clang-format off
  ///
  /// @copybrief CreatePrivateConnection
  ///
  /// Specifying the [`NoAwaitTag`] immediately returns the
  /// [`google::longrunning::Operation`] that corresponds to the Long Running
  /// Operation that has been started. No polling for operation status occurs.
  ///
  /// [`NoAwaitTag`]: @ref google::cloud::NoAwaitTag
  ///
  // clang-format on
  StatusOr<google::longrunning::Operation> CreatePrivateConnection(
      NoAwaitTag,
      google::cloud::datastream::v1::CreatePrivateConnectionRequest const&
          request,
      Options opts = {});

  // clang-format off
  ///
  /// @copybrief CreatePrivateConnection
  ///
  /// This method accepts a `google::longrunning::Operation` that corresponds
  /// to a previously started Long Running Operation (LRO) and polls the status
  /// of the LRO in the background.
  ///
  // clang-format on
  future<StatusOr<google::cloud::datastream::v1::PrivateConnection>>
  CreatePrivateConnection(google::longrunning::Operation const& operation,
                          Options opts = {});

  // clang-format off
  ///
  /// Use this method to get details about a private connectivity configuration.
  ///
  /// @param name  Required. The name of the  private connectivity configuration to get.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.datastream.v1.PrivateConnection])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.datastream.v1.GetPrivateConnectionRequest]: @googleapis_reference_link{google/cloud/datastream/v1/datastream.proto#L954}
  /// [google.cloud.datastream.v1.PrivateConnection]: @googleapis_reference_link{google/cloud/datastream/v1/datastream_resources.proto#L151}
  ///
  // clang-format on
  StatusOr<google::cloud::datastream::v1::PrivateConnection>
  GetPrivateConnection(std::string const& name, Options opts = {});

  // clang-format off
  ///
  /// Use this method to get details about a private connectivity configuration.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.datastream.v1.GetPrivateConnectionRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.datastream.v1.PrivateConnection])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.datastream.v1.GetPrivateConnectionRequest]: @googleapis_reference_link{google/cloud/datastream/v1/datastream.proto#L954}
  /// [google.cloud.datastream.v1.PrivateConnection]: @googleapis_reference_link{google/cloud/datastream/v1/datastream_resources.proto#L151}
  ///
  // clang-format on
  StatusOr<google::cloud::datastream::v1::PrivateConnection>
  GetPrivateConnection(
      google::cloud::datastream::v1::GetPrivateConnectionRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// Use this method to list private connectivity configurations in a project
  /// and location.
  ///
  /// @param parent  Required. The parent that owns the collection of private connectivity
  ///  configurations.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return a [StreamRange](@ref google::cloud::StreamRange)
  ///     to iterate of the results. See the documentation of this type for
  ///     details. In brief, this class has `begin()` and `end()` member
  ///     functions returning a iterator class meeting the
  ///     [input iterator requirements]. The value type for this iterator is a
  ///     [`StatusOr`] as the iteration may fail even after some values are
  ///     retrieved successfully, for example, if there is a network disconnect.
  ///     An empty set of results does not indicate an error, it indicates
  ///     that there are no resources meeting the request criteria.
  ///     On a successful iteration the `StatusOr<T>` contains elements of type
  ///     [google.cloud.datastream.v1.PrivateConnection], or rather,
  ///     the C++ class generated by Protobuf from that type. Please consult the
  ///     Protobuf documentation for details on the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.datastream.v1.ListPrivateConnectionsRequest]: @googleapis_reference_link{google/cloud/datastream/v1/datastream.proto#L879}
  /// [google.cloud.datastream.v1.PrivateConnection]: @googleapis_reference_link{google/cloud/datastream/v1/datastream_resources.proto#L151}
  ///
  // clang-format on
  StreamRange<google::cloud::datastream::v1::PrivateConnection>
  ListPrivateConnections(std::string const& parent, Options opts = {});

  // clang-format off
  ///
  /// Use this method to list private connectivity configurations in a project
  /// and location.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.datastream.v1.ListPrivateConnectionsRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return a [StreamRange](@ref google::cloud::StreamRange)
  ///     to iterate of the results. See the documentation of this type for
  ///     details. In brief, this class has `begin()` and `end()` member
  ///     functions returning a iterator class meeting the
  ///     [input iterator requirements]. The value type for this iterator is a
  ///     [`StatusOr`] as the iteration may fail even after some values are
  ///     retrieved successfully, for example, if there is a network disconnect.
  ///     An empty set of results does not indicate an error, it indicates
  ///     that there are no resources meeting the request criteria.
  ///     On a successful iteration the `StatusOr<T>` contains elements of type
  ///     [google.cloud.datastream.v1.PrivateConnection], or rather,
  ///     the C++ class generated by Protobuf from that type. Please consult the
  ///     Protobuf documentation for details on the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.datastream.v1.ListPrivateConnectionsRequest]: @googleapis_reference_link{google/cloud/datastream/v1/datastream.proto#L879}
  /// [google.cloud.datastream.v1.PrivateConnection]: @googleapis_reference_link{google/cloud/datastream/v1/datastream_resources.proto#L151}
  ///
  // clang-format on
  StreamRange<google::cloud::datastream::v1::PrivateConnection>
  ListPrivateConnections(
      google::cloud::datastream::v1::ListPrivateConnectionsRequest request,
      Options opts = {});

  // clang-format off
  ///
  /// Use this method to delete a private connectivity configuration.
  ///
  /// @param name  Required. The name of the private connectivity configuration to delete.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.datastream.v1.OperationMetadata] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.datastream.v1.DeletePrivateConnectionRequest]: @googleapis_reference_link{google/cloud/datastream/v1/datastream.proto#L924}
  /// [google.cloud.datastream.v1.OperationMetadata]: @googleapis_reference_link{google/cloud/datastream/v1/datastream.proto#L809}
  ///
  // clang-format on
  future<StatusOr<google::cloud::datastream::v1::OperationMetadata>>
  DeletePrivateConnection(std::string const& name, Options opts = {});

  // clang-format off
  ///
  /// @copybrief DeletePrivateConnection
  ///
  /// Specifying the [`NoAwaitTag`] immediately returns the
  /// [`google::longrunning::Operation`] that corresponds to the Long Running
  /// Operation that has been started. No polling for operation status occurs.
  ///
  /// [`NoAwaitTag`]: @ref google::cloud::NoAwaitTag
  ///
  // clang-format on
  StatusOr<google::longrunning::Operation> DeletePrivateConnection(
      NoAwaitTag, std::string const& name, Options opts = {});

  // clang-format off
  ///
  /// Use this method to delete a private connectivity configuration.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.datastream.v1.DeletePrivateConnectionRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.datastream.v1.OperationMetadata] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.datastream.v1.DeletePrivateConnectionRequest]: @googleapis_reference_link{google/cloud/datastream/v1/datastream.proto#L924}
  /// [google.cloud.datastream.v1.OperationMetadata]: @googleapis_reference_link{google/cloud/datastream/v1/datastream.proto#L809}
  ///
  // clang-format on
  future<StatusOr<google::cloud::datastream::v1::OperationMetadata>>
  DeletePrivateConnection(
      google::cloud::datastream::v1::DeletePrivateConnectionRequest const&
          request,
      Options opts = {});

  // clang-format off
  ///
  /// @copybrief DeletePrivateConnection
  ///
  /// Specifying the [`NoAwaitTag`] immediately returns the
  /// [`google::longrunning::Operation`] that corresponds to the Long Running
  /// Operation that has been started. No polling for operation status occurs.
  ///
  /// [`NoAwaitTag`]: @ref google::cloud::NoAwaitTag
  ///
  // clang-format on
  StatusOr<google::longrunning::Operation> DeletePrivateConnection(
      NoAwaitTag,
      google::cloud::datastream::v1::DeletePrivateConnectionRequest const&
          request,
      Options opts = {});

  // clang-format off
  ///
  /// @copybrief DeletePrivateConnection
  ///
  /// This method accepts a `google::longrunning::Operation` that corresponds
  /// to a previously started Long Running Operation (LRO) and polls the status
  /// of the LRO in the background.
  ///
  // clang-format on
  future<StatusOr<google::cloud::datastream::v1::OperationMetadata>>
  DeletePrivateConnection(google::longrunning::Operation const& operation,
                          Options opts = {});

  // clang-format off
  ///
  /// Use this method to create a route for a private connectivity configuration
  /// in a project and location.
  ///
  /// @param parent  Required. The parent that owns the collection of Routes.
  /// @param route  Required. The Route resource to create.
  /// @param route_id  Required. The Route identifier.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.datastream.v1.Route] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.datastream.v1.CreateRouteRequest]: @googleapis_reference_link{google/cloud/datastream/v1/datastream.proto#L965}
  /// [google.cloud.datastream.v1.Route]: @googleapis_reference_link{google/cloud/datastream/v1/datastream_resources.proto#L220}
  ///
  // clang-format on
  future<StatusOr<google::cloud::datastream::v1::Route>> CreateRoute(
      std::string const& parent,
      google::cloud::datastream::v1::Route const& route,
      std::string const& route_id, Options opts = {});

  // clang-format off
  ///
  /// @copybrief CreateRoute
  ///
  /// Specifying the [`NoAwaitTag`] immediately returns the
  /// [`google::longrunning::Operation`] that corresponds to the Long Running
  /// Operation that has been started. No polling for operation status occurs.
  ///
  /// [`NoAwaitTag`]: @ref google::cloud::NoAwaitTag
  ///
  // clang-format on
  StatusOr<google::longrunning::Operation> CreateRoute(
      NoAwaitTag, std::string const& parent,
      google::cloud::datastream::v1::Route const& route,
      std::string const& route_id, Options opts = {});

  // clang-format off
  ///
  /// Use this method to create a route for a private connectivity configuration
  /// in a project and location.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.datastream.v1.CreateRouteRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.datastream.v1.Route] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.datastream.v1.CreateRouteRequest]: @googleapis_reference_link{google/cloud/datastream/v1/datastream.proto#L965}
  /// [google.cloud.datastream.v1.Route]: @googleapis_reference_link{google/cloud/datastream/v1/datastream_resources.proto#L220}
  ///
  // clang-format on
  future<StatusOr<google::cloud::datastream::v1::Route>> CreateRoute(
      google::cloud::datastream::v1::CreateRouteRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// @copybrief CreateRoute
  ///
  /// Specifying the [`NoAwaitTag`] immediately returns the
  /// [`google::longrunning::Operation`] that corresponds to the Long Running
  /// Operation that has been started. No polling for operation status occurs.
  ///
  /// [`NoAwaitTag`]: @ref google::cloud::NoAwaitTag
  ///
  // clang-format on
  StatusOr<google::longrunning::Operation> CreateRoute(
      NoAwaitTag,
      google::cloud::datastream::v1::CreateRouteRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// @copybrief CreateRoute
  ///
  /// This method accepts a `google::longrunning::Operation` that corresponds
  /// to a previously started Long Running Operation (LRO) and polls the status
  /// of the LRO in the background.
  ///
  // clang-format on
  future<StatusOr<google::cloud::datastream::v1::Route>> CreateRoute(
      google::longrunning::Operation const& operation, Options opts = {});

  // clang-format off
  ///
  /// Use this method to get details about a route.
  ///
  /// @param name  Required. The name of the Route resource to get.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.datastream.v1.Route])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.datastream.v1.GetRouteRequest]: @googleapis_reference_link{google/cloud/datastream/v1/datastream.proto#L1067}
  /// [google.cloud.datastream.v1.Route]: @googleapis_reference_link{google/cloud/datastream/v1/datastream_resources.proto#L220}
  ///
  // clang-format on
  StatusOr<google::cloud::datastream::v1::Route> GetRoute(
      std::string const& name, Options opts = {});

  // clang-format off
  ///
  /// Use this method to get details about a route.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.datastream.v1.GetRouteRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.datastream.v1.Route])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.datastream.v1.GetRouteRequest]: @googleapis_reference_link{google/cloud/datastream/v1/datastream.proto#L1067}
  /// [google.cloud.datastream.v1.Route]: @googleapis_reference_link{google/cloud/datastream/v1/datastream_resources.proto#L220}
  ///
  // clang-format on
  StatusOr<google::cloud::datastream::v1::Route> GetRoute(
      google::cloud::datastream::v1::GetRouteRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// Use this method to list routes created for a private connectivity
  /// configuration in a project and location.
  ///
  /// @param parent  Required. The parent that owns the collection of Routess.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return a [StreamRange](@ref google::cloud::StreamRange)
  ///     to iterate of the results. See the documentation of this type for
  ///     details. In brief, this class has `begin()` and `end()` member
  ///     functions returning a iterator class meeting the
  ///     [input iterator requirements]. The value type for this iterator is a
  ///     [`StatusOr`] as the iteration may fail even after some values are
  ///     retrieved successfully, for example, if there is a network disconnect.
  ///     An empty set of results does not indicate an error, it indicates
  ///     that there are no resources meeting the request criteria.
  ///     On a successful iteration the `StatusOr<T>` contains elements of type
  ///     [google.cloud.datastream.v1.Route], or rather,
  ///     the C++ class generated by Protobuf from that type. Please consult the
  ///     Protobuf documentation for details on the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.datastream.v1.ListRoutesRequest]: @googleapis_reference_link{google/cloud/datastream/v1/datastream.proto#L997}
  /// [google.cloud.datastream.v1.Route]: @googleapis_reference_link{google/cloud/datastream/v1/datastream_resources.proto#L220}
  ///
  // clang-format on
  StreamRange<google::cloud::datastream::v1::Route> ListRoutes(
      std::string const& parent, Options opts = {});

  // clang-format off
  ///
  /// Use this method to list routes created for a private connectivity
  /// configuration in a project and location.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.datastream.v1.ListRoutesRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return a [StreamRange](@ref google::cloud::StreamRange)
  ///     to iterate of the results. See the documentation of this type for
  ///     details. In brief, this class has `begin()` and `end()` member
  ///     functions returning a iterator class meeting the
  ///     [input iterator requirements]. The value type for this iterator is a
  ///     [`StatusOr`] as the iteration may fail even after some values are
  ///     retrieved successfully, for example, if there is a network disconnect.
  ///     An empty set of results does not indicate an error, it indicates
  ///     that there are no resources meeting the request criteria.
  ///     On a successful iteration the `StatusOr<T>` contains elements of type
  ///     [google.cloud.datastream.v1.Route], or rather,
  ///     the C++ class generated by Protobuf from that type. Please consult the
  ///     Protobuf documentation for details on the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.datastream.v1.ListRoutesRequest]: @googleapis_reference_link{google/cloud/datastream/v1/datastream.proto#L997}
  /// [google.cloud.datastream.v1.Route]: @googleapis_reference_link{google/cloud/datastream/v1/datastream_resources.proto#L220}
  ///
  // clang-format on
  StreamRange<google::cloud::datastream::v1::Route> ListRoutes(
      google::cloud::datastream::v1::ListRoutesRequest request,
      Options opts = {});

  // clang-format off
  ///
  /// Use this method to delete a route.
  ///
  /// @param name  Required. The name of the Route resource to delete.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.datastream.v1.OperationMetadata] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.datastream.v1.DeleteRouteRequest]: @googleapis_reference_link{google/cloud/datastream/v1/datastream.proto#L1041}
  /// [google.cloud.datastream.v1.OperationMetadata]: @googleapis_reference_link{google/cloud/datastream/v1/datastream.proto#L809}
  ///
  // clang-format on
  future<StatusOr<google::cloud::datastream::v1::OperationMetadata>>
  DeleteRoute(std::string const& name, Options opts = {});

  // clang-format off
  ///
  /// @copybrief DeleteRoute
  ///
  /// Specifying the [`NoAwaitTag`] immediately returns the
  /// [`google::longrunning::Operation`] that corresponds to the Long Running
  /// Operation that has been started. No polling for operation status occurs.
  ///
  /// [`NoAwaitTag`]: @ref google::cloud::NoAwaitTag
  ///
  // clang-format on
  StatusOr<google::longrunning::Operation> DeleteRoute(NoAwaitTag,
                                                       std::string const& name,
                                                       Options opts = {});

  // clang-format off
  ///
  /// Use this method to delete a route.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.datastream.v1.DeleteRouteRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.datastream.v1.OperationMetadata] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.datastream.v1.DeleteRouteRequest]: @googleapis_reference_link{google/cloud/datastream/v1/datastream.proto#L1041}
  /// [google.cloud.datastream.v1.OperationMetadata]: @googleapis_reference_link{google/cloud/datastream/v1/datastream.proto#L809}
  ///
  // clang-format on
  future<StatusOr<google::cloud::datastream::v1::OperationMetadata>>
  DeleteRoute(google::cloud::datastream::v1::DeleteRouteRequest const& request,
              Options opts = {});

  // clang-format off
  ///
  /// @copybrief DeleteRoute
  ///
  /// Specifying the [`NoAwaitTag`] immediately returns the
  /// [`google::longrunning::Operation`] that corresponds to the Long Running
  /// Operation that has been started. No polling for operation status occurs.
  ///
  /// [`NoAwaitTag`]: @ref google::cloud::NoAwaitTag
  ///
  // clang-format on
  StatusOr<google::longrunning::Operation> DeleteRoute(
      NoAwaitTag,
      google::cloud::datastream::v1::DeleteRouteRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// @copybrief DeleteRoute
  ///
  /// This method accepts a `google::longrunning::Operation` that corresponds
  /// to a previously started Long Running Operation (LRO) and polls the status
  /// of the LRO in the background.
  ///
  // clang-format on
  future<StatusOr<google::cloud::datastream::v1::OperationMetadata>>
  DeleteRoute(google::longrunning::Operation const& operation,
              Options opts = {});

 private:
  std::shared_ptr<DatastreamConnection> connection_;
  Options options_;
};

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace datastream_v1
}  // namespace cloud
}  // namespace google

#endif  // GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_DATASTREAM_V1_DATASTREAM_CLIENT_H
