// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/dialogflow/cx/v3/flow.proto

#ifndef GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_DIALOGFLOW_CX_INTERNAL_FLOWS_TRACING_CONNECTION_H
#define GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_DIALOGFLOW_CX_INTERNAL_FLOWS_TRACING_CONNECTION_H

#include "google/cloud/dialogflow_cx/flows_connection.h"
#include "google/cloud/version.h"
#include <memory>

namespace google {
namespace cloud {
namespace dialogflow_cx_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

#ifdef GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY

class FlowsTracingConnection : public dialogflow_cx::FlowsConnection {
 public:
  ~FlowsTracingConnection() override = default;

  explicit FlowsTracingConnection(
      std::shared_ptr<dialogflow_cx::FlowsConnection> child);

  Options options() override { return child_->options(); }

  StatusOr<google::cloud::dialogflow::cx::v3::Flow> CreateFlow(
      google::cloud::dialogflow::cx::v3::CreateFlowRequest const& request)
      override;

  Status DeleteFlow(google::cloud::dialogflow::cx::v3::DeleteFlowRequest const&
                        request) override;

  StreamRange<google::cloud::dialogflow::cx::v3::Flow> ListFlows(
      google::cloud::dialogflow::cx::v3::ListFlowsRequest request) override;

  StatusOr<google::cloud::dialogflow::cx::v3::Flow> GetFlow(
      google::cloud::dialogflow::cx::v3::GetFlowRequest const& request)
      override;

  StatusOr<google::cloud::dialogflow::cx::v3::Flow> UpdateFlow(
      google::cloud::dialogflow::cx::v3::UpdateFlowRequest const& request)
      override;

  future<StatusOr<google::protobuf::Struct>> TrainFlow(
      google::cloud::dialogflow::cx::v3::TrainFlowRequest const& request)
      override;

  StatusOr<google::longrunning::Operation> TrainFlow(
      NoAwaitTag,
      google::cloud::dialogflow::cx::v3::TrainFlowRequest const& request)
      override;

  future<StatusOr<google::protobuf::Struct>> TrainFlow(
      google::longrunning::Operation const& operation) override;

  StatusOr<google::cloud::dialogflow::cx::v3::FlowValidationResult>
  ValidateFlow(google::cloud::dialogflow::cx::v3::ValidateFlowRequest const&
                   request) override;

  StatusOr<google::cloud::dialogflow::cx::v3::FlowValidationResult>
  GetFlowValidationResult(
      google::cloud::dialogflow::cx::v3::GetFlowValidationResultRequest const&
          request) override;

  future<StatusOr<google::cloud::dialogflow::cx::v3::ImportFlowResponse>>
  ImportFlow(google::cloud::dialogflow::cx::v3::ImportFlowRequest const&
                 request) override;

  StatusOr<google::longrunning::Operation> ImportFlow(
      NoAwaitTag,
      google::cloud::dialogflow::cx::v3::ImportFlowRequest const& request)
      override;

  future<StatusOr<google::cloud::dialogflow::cx::v3::ImportFlowResponse>>
  ImportFlow(google::longrunning::Operation const& operation) override;

  future<StatusOr<google::cloud::dialogflow::cx::v3::ExportFlowResponse>>
  ExportFlow(google::cloud::dialogflow::cx::v3::ExportFlowRequest const&
                 request) override;

  StatusOr<google::longrunning::Operation> ExportFlow(
      NoAwaitTag,
      google::cloud::dialogflow::cx::v3::ExportFlowRequest const& request)
      override;

  future<StatusOr<google::cloud::dialogflow::cx::v3::ExportFlowResponse>>
  ExportFlow(google::longrunning::Operation const& operation) override;

 private:
  std::shared_ptr<dialogflow_cx::FlowsConnection> child_;
};

#endif  // GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY

/**
 * Conditionally applies the tracing decorator to the given connection.
 *
 * The connection is only decorated if tracing is enabled (as determined by the
 * connection's options).
 */
std::shared_ptr<dialogflow_cx::FlowsConnection> MakeFlowsTracingConnection(
    std::shared_ptr<dialogflow_cx::FlowsConnection> conn);

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace dialogflow_cx_internal
}  // namespace cloud
}  // namespace google

#endif  // GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_DIALOGFLOW_CX_INTERNAL_FLOWS_TRACING_CONNECTION_H
