// Copyright 2024 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/discoveryengine/v1/control_service.proto

#ifndef GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_DISCOVERYENGINE_V1_CONTROL_CLIENT_H
#define GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_DISCOVERYENGINE_V1_CONTROL_CLIENT_H

#include "google/cloud/discoveryengine/v1/control_connection.h"
#include "google/cloud/future.h"
#include "google/cloud/options.h"
#include "google/cloud/polling_policy.h"
#include "google/cloud/status_or.h"
#include "google/cloud/version.h"
#include <memory>
#include <string>

namespace google {
namespace cloud {
namespace discoveryengine_v1 {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

///
/// Service for performing CRUD operations on Controls.
/// Controls allow for custom logic to be implemented in the serving path.
/// Controls need to be attached to a Serving Config to be considered during a
/// request.
///
/// @par Equality
///
/// Instances of this class created via copy-construction or copy-assignment
/// always compare equal. Instances created with equal
/// `std::shared_ptr<*Connection>` objects compare equal. Objects that compare
/// equal share the same underlying resources.
///
/// @par Performance
///
/// Creating a new instance of this class is a relatively expensive operation,
/// new objects establish new connections to the service. In contrast,
/// copy-construction, move-construction, and the corresponding assignment
/// operations are relatively efficient as the copies share all underlying
/// resources.
///
/// @par Thread Safety
///
/// Concurrent access to different instances of this class, even if they compare
/// equal, is guaranteed to work. Two or more threads operating on the same
/// instance of this class is not guaranteed to work. Since copy-construction
/// and move-construction is a relatively efficient operation, consider using
/// such a copy when using this class from multiple threads.
///
class ControlServiceClient {
 public:
  explicit ControlServiceClient(
      std::shared_ptr<ControlServiceConnection> connection, Options opts = {});
  ~ControlServiceClient();

  ///@{
  /// @name Copy and move support
  ControlServiceClient(ControlServiceClient const&) = default;
  ControlServiceClient& operator=(ControlServiceClient const&) = default;
  ControlServiceClient(ControlServiceClient&&) = default;
  ControlServiceClient& operator=(ControlServiceClient&&) = default;
  ///@}

  ///@{
  /// @name Equality
  friend bool operator==(ControlServiceClient const& a,
                         ControlServiceClient const& b) {
    return a.connection_ == b.connection_;
  }
  friend bool operator!=(ControlServiceClient const& a,
                         ControlServiceClient const& b) {
    return !(a == b);
  }
  ///@}

  // clang-format off
  ///
  /// Creates a Control.
  ///
  /// By default 1000 controls are allowed for a data store.
  /// A request can be submitted to adjust this limit.
  /// If the [Control][google.cloud.discoveryengine.v1.Control] to create already
  /// exists, an ALREADY_EXISTS error is returned.
  ///
  /// @param parent  Required. Full resource name of parent data store. Format:
  ///  `projects/{project_number}/locations/{location_id}/collections/{collection_id}/dataStores/{data_store_id}`
  ///  or
  ///  `projects/{project_number}/locations/{location_id}/collections/{collection_id}/engines/{engine_id}`.
  /// @param control  Required. The Control to create.
  /// @param control_id  Required. The ID to use for the Control, which will become the final
  ///  component of the Control's resource name.
  ///  @n
  ///  This value must be within 1-63 characters.
  ///  Valid characters are /[a-z][0-9]-_/.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.discoveryengine.v1.Control])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.discoveryengine.v1.Control]: @googleapis_reference_link{google/cloud/discoveryengine/v1/control.proto#L79}
  /// [google.cloud.discoveryengine.v1.CreateControlRequest]: @googleapis_reference_link{google/cloud/discoveryengine/v1/control_service.proto#L136}
  ///
  // clang-format on
  StatusOr<google::cloud::discoveryengine::v1::Control> CreateControl(
      std::string const& parent,
      google::cloud::discoveryengine::v1::Control const& control,
      std::string const& control_id, Options opts = {});

  // clang-format off
  ///
  /// Creates a Control.
  ///
  /// By default 1000 controls are allowed for a data store.
  /// A request can be submitted to adjust this limit.
  /// If the [Control][google.cloud.discoveryengine.v1.Control] to create already
  /// exists, an ALREADY_EXISTS error is returned.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.discoveryengine.v1.CreateControlRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.discoveryengine.v1.Control])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.discoveryengine.v1.Control]: @googleapis_reference_link{google/cloud/discoveryengine/v1/control.proto#L79}
  /// [google.cloud.discoveryengine.v1.CreateControlRequest]: @googleapis_reference_link{google/cloud/discoveryengine/v1/control_service.proto#L136}
  ///
  // clang-format on
  StatusOr<google::cloud::discoveryengine::v1::Control> CreateControl(
      google::cloud::discoveryengine::v1::CreateControlRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// Deletes a Control.
  ///
  /// If the [Control][google.cloud.discoveryengine.v1.Control] to delete does
  /// not exist, a NOT_FOUND error is returned.
  ///
  /// @param name  Required. The resource name of the Control to delete. Format:
  ///  `projects/{project_number}/locations/{location_id}/collections/{collection_id}/dataStores/{data_store_id}/controls/{control_id}`
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return a [`Status`] object. If the request failed, the
  ///     status contains the details of the failure.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.discoveryengine.v1.Control]: @googleapis_reference_link{google/cloud/discoveryengine/v1/control.proto#L79}
  /// [google.cloud.discoveryengine.v1.DeleteControlRequest]: @googleapis_reference_link{google/cloud/discoveryengine/v1/control_service.proto#L177}
  ///
  // clang-format on
  Status DeleteControl(std::string const& name, Options opts = {});

  // clang-format off
  ///
  /// Deletes a Control.
  ///
  /// If the [Control][google.cloud.discoveryengine.v1.Control] to delete does
  /// not exist, a NOT_FOUND error is returned.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.discoveryengine.v1.DeleteControlRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return a [`Status`] object. If the request failed, the
  ///     status contains the details of the failure.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.discoveryengine.v1.Control]: @googleapis_reference_link{google/cloud/discoveryengine/v1/control.proto#L79}
  /// [google.cloud.discoveryengine.v1.DeleteControlRequest]: @googleapis_reference_link{google/cloud/discoveryengine/v1/control_service.proto#L177}
  ///
  // clang-format on
  Status DeleteControl(
      google::cloud::discoveryengine::v1::DeleteControlRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// Updates a Control.
  ///
  /// [Control][google.cloud.discoveryengine.v1.Control] action type cannot be
  /// changed. If the [Control][google.cloud.discoveryengine.v1.Control] to
  /// update does not exist, a NOT_FOUND error is returned.
  ///
  /// @param control  Required. The Control to update.
  /// @param update_mask  Optional. Indicates which fields in the provided
  ///  [Control][google.cloud.discoveryengine.v1.Control] to update. The following
  ///  are NOT supported:
  ///  @n
  ///  * [Control.name][google.cloud.discoveryengine.v1.Control.name]
  ///  * [Control.solution_type][google.cloud.discoveryengine.v1.Control.solution_type]
  ///  @n
  ///  If not set or empty, all supported fields are updated.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.discoveryengine.v1.Control])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.discoveryengine.v1.Control]: @googleapis_reference_link{google/cloud/discoveryengine/v1/control.proto#L79}
  /// [google.cloud.discoveryengine.v1.Control.name]: @googleapis_reference_link{google/cloud/discoveryengine/v1/control.proto#L178}
  /// [google.cloud.discoveryengine.v1.Control.solution_type]: @googleapis_reference_link{google/cloud/discoveryengine/v1/control.proto#L196}
  /// [google.cloud.discoveryengine.v1.UpdateControlRequest]: @googleapis_reference_link{google/cloud/discoveryengine/v1/control_service.proto#L160}
  ///
  // clang-format on
  StatusOr<google::cloud::discoveryengine::v1::Control> UpdateControl(
      google::cloud::discoveryengine::v1::Control const& control,
      google::protobuf::FieldMask const& update_mask, Options opts = {});

  // clang-format off
  ///
  /// Updates a Control.
  ///
  /// [Control][google.cloud.discoveryengine.v1.Control] action type cannot be
  /// changed. If the [Control][google.cloud.discoveryengine.v1.Control] to
  /// update does not exist, a NOT_FOUND error is returned.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.discoveryengine.v1.UpdateControlRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.discoveryengine.v1.Control])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.discoveryengine.v1.Control]: @googleapis_reference_link{google/cloud/discoveryengine/v1/control.proto#L79}
  /// [google.cloud.discoveryengine.v1.UpdateControlRequest]: @googleapis_reference_link{google/cloud/discoveryengine/v1/control_service.proto#L160}
  ///
  // clang-format on
  StatusOr<google::cloud::discoveryengine::v1::Control> UpdateControl(
      google::cloud::discoveryengine::v1::UpdateControlRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// Gets a Control.
  ///
  /// @param name  Required. The resource name of the Control to get. Format:
  ///  `projects/{project_number}/locations/{location_id}/collections/{collection_id}/dataStores/{data_store_id}/controls/{control_id}`
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.discoveryengine.v1.Control])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.discoveryengine.v1.Control]: @googleapis_reference_link{google/cloud/discoveryengine/v1/control.proto#L79}
  /// [google.cloud.discoveryengine.v1.GetControlRequest]: @googleapis_reference_link{google/cloud/discoveryengine/v1/control_service.proto#L189}
  ///
  // clang-format on
  StatusOr<google::cloud::discoveryengine::v1::Control> GetControl(
      std::string const& name, Options opts = {});

  // clang-format off
  ///
  /// Gets a Control.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.discoveryengine.v1.GetControlRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.discoveryengine.v1.Control])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.discoveryengine.v1.Control]: @googleapis_reference_link{google/cloud/discoveryengine/v1/control.proto#L79}
  /// [google.cloud.discoveryengine.v1.GetControlRequest]: @googleapis_reference_link{google/cloud/discoveryengine/v1/control_service.proto#L189}
  ///
  // clang-format on
  StatusOr<google::cloud::discoveryengine::v1::Control> GetControl(
      google::cloud::discoveryengine::v1::GetControlRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// Lists all Controls by their parent
  /// [DataStore][google.cloud.discoveryengine.v1.DataStore].
  ///
  /// @param parent  Required. The data store resource name. Format:
  ///  `projects/{project_number}/locations/{location_id}/collections/{collection_id}/dataStores/{data_store_id}`
  ///  or
  ///  `projects/{project_number}/locations/{location_id}/collections/{collection_id}/engines/{engine_id}`.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return a [StreamRange](@ref google::cloud::StreamRange)
  ///     to iterate of the results. See the documentation of this type for
  ///     details. In brief, this class has `begin()` and `end()` member
  ///     functions returning a iterator class meeting the
  ///     [input iterator requirements]. The value type for this iterator is a
  ///     [`StatusOr`] as the iteration may fail even after some values are
  ///     retrieved successfully, for example, if there is a network disconnect.
  ///     An empty set of results does not indicate an error, it indicates
  ///     that there are no resources meeting the request criteria.
  ///     On a successful iteration the `StatusOr<T>` contains elements of type
  ///     [google.cloud.discoveryengine.v1.Control], or rather,
  ///     the C++ class generated by Protobuf from that type. Please consult the
  ///     Protobuf documentation for details on the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.discoveryengine.v1.Control]: @googleapis_reference_link{google/cloud/discoveryengine/v1/control.proto#L79}
  /// [google.cloud.discoveryengine.v1.ListControlsRequest]: @googleapis_reference_link{google/cloud/discoveryengine/v1/control_service.proto#L201}
  ///
  // clang-format on
  StreamRange<google::cloud::discoveryengine::v1::Control> ListControls(
      std::string const& parent, Options opts = {});

  // clang-format off
  ///
  /// Lists all Controls by their parent
  /// [DataStore][google.cloud.discoveryengine.v1.DataStore].
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.discoveryengine.v1.ListControlsRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return a [StreamRange](@ref google::cloud::StreamRange)
  ///     to iterate of the results. See the documentation of this type for
  ///     details. In brief, this class has `begin()` and `end()` member
  ///     functions returning a iterator class meeting the
  ///     [input iterator requirements]. The value type for this iterator is a
  ///     [`StatusOr`] as the iteration may fail even after some values are
  ///     retrieved successfully, for example, if there is a network disconnect.
  ///     An empty set of results does not indicate an error, it indicates
  ///     that there are no resources meeting the request criteria.
  ///     On a successful iteration the `StatusOr<T>` contains elements of type
  ///     [google.cloud.discoveryengine.v1.Control], or rather,
  ///     the C++ class generated by Protobuf from that type. Please consult the
  ///     Protobuf documentation for details on the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.discoveryengine.v1.Control]: @googleapis_reference_link{google/cloud/discoveryengine/v1/control.proto#L79}
  /// [google.cloud.discoveryengine.v1.ListControlsRequest]: @googleapis_reference_link{google/cloud/discoveryengine/v1/control_service.proto#L201}
  ///
  // clang-format on
  StreamRange<google::cloud::discoveryengine::v1::Control> ListControls(
      google::cloud::discoveryengine::v1::ListControlsRequest request,
      Options opts = {});

 private:
  std::shared_ptr<ControlServiceConnection> connection_;
  Options options_;
};

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace discoveryengine_v1
}  // namespace cloud
}  // namespace google

#endif  // GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_DISCOVERYENGINE_V1_CONTROL_CLIENT_H
