// Copyright 2024 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/discoveryengine/v1/engine_service.proto

#ifndef GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_DISCOVERYENGINE_V1_INTERNAL_ENGINE_STUB_H
#define GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_DISCOVERYENGINE_V1_INTERNAL_ENGINE_STUB_H

#include "google/cloud/completion_queue.h"
#include "google/cloud/future.h"
#include "google/cloud/options.h"
#include "google/cloud/status_or.h"
#include "google/cloud/version.h"
#include <google/cloud/discoveryengine/v1/engine_service.grpc.pb.h>
#include <google/longrunning/operations.grpc.pb.h>
#include <memory>
#include <utility>

namespace google {
namespace cloud {
namespace discoveryengine_v1_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

class EngineServiceStub {
 public:
  virtual ~EngineServiceStub() = 0;

  virtual future<StatusOr<google::longrunning::Operation>> AsyncCreateEngine(
      google::cloud::CompletionQueue& cq,
      std::shared_ptr<grpc::ClientContext> context,
      google::cloud::internal::ImmutableOptions options,
      google::cloud::discoveryengine::v1::CreateEngineRequest const&
          request) = 0;

  virtual StatusOr<google::longrunning::Operation> CreateEngine(
      grpc::ClientContext& context, Options options,
      google::cloud::discoveryengine::v1::CreateEngineRequest const&
          request) = 0;

  virtual future<StatusOr<google::longrunning::Operation>> AsyncDeleteEngine(
      google::cloud::CompletionQueue& cq,
      std::shared_ptr<grpc::ClientContext> context,
      google::cloud::internal::ImmutableOptions options,
      google::cloud::discoveryengine::v1::DeleteEngineRequest const&
          request) = 0;

  virtual StatusOr<google::longrunning::Operation> DeleteEngine(
      grpc::ClientContext& context, Options options,
      google::cloud::discoveryengine::v1::DeleteEngineRequest const&
          request) = 0;

  virtual StatusOr<google::cloud::discoveryengine::v1::Engine> UpdateEngine(
      grpc::ClientContext& context, Options const& options,
      google::cloud::discoveryengine::v1::UpdateEngineRequest const&
          request) = 0;

  virtual StatusOr<google::cloud::discoveryengine::v1::Engine> GetEngine(
      grpc::ClientContext& context, Options const& options,
      google::cloud::discoveryengine::v1::GetEngineRequest const& request) = 0;

  virtual StatusOr<google::cloud::discoveryengine::v1::ListEnginesResponse>
  ListEngines(grpc::ClientContext& context, Options const& options,
              google::cloud::discoveryengine::v1::ListEnginesRequest const&
                  request) = 0;

  virtual future<StatusOr<google::longrunning::Operation>> AsyncGetOperation(
      google::cloud::CompletionQueue& cq,
      std::shared_ptr<grpc::ClientContext> context,
      google::cloud::internal::ImmutableOptions options,
      google::longrunning::GetOperationRequest const& request) = 0;

  virtual future<Status> AsyncCancelOperation(
      google::cloud::CompletionQueue& cq,
      std::shared_ptr<grpc::ClientContext> context,
      google::cloud::internal::ImmutableOptions options,
      google::longrunning::CancelOperationRequest const& request) = 0;
};

class DefaultEngineServiceStub : public EngineServiceStub {
 public:
  DefaultEngineServiceStub(
      std::unique_ptr<
          google::cloud::discoveryengine::v1::EngineService::StubInterface>
          grpc_stub,
      std::unique_ptr<google::longrunning::Operations::StubInterface>
          operations)
      : grpc_stub_(std::move(grpc_stub)), operations_(std::move(operations)) {}

  future<StatusOr<google::longrunning::Operation>> AsyncCreateEngine(
      google::cloud::CompletionQueue& cq,
      std::shared_ptr<grpc::ClientContext> context,
      google::cloud::internal::ImmutableOptions options,
      google::cloud::discoveryengine::v1::CreateEngineRequest const& request)
      override;

  StatusOr<google::longrunning::Operation> CreateEngine(
      grpc::ClientContext& context, Options options,
      google::cloud::discoveryengine::v1::CreateEngineRequest const& request)
      override;

  future<StatusOr<google::longrunning::Operation>> AsyncDeleteEngine(
      google::cloud::CompletionQueue& cq,
      std::shared_ptr<grpc::ClientContext> context,
      google::cloud::internal::ImmutableOptions options,
      google::cloud::discoveryengine::v1::DeleteEngineRequest const& request)
      override;

  StatusOr<google::longrunning::Operation> DeleteEngine(
      grpc::ClientContext& context, Options options,
      google::cloud::discoveryengine::v1::DeleteEngineRequest const& request)
      override;

  StatusOr<google::cloud::discoveryengine::v1::Engine> UpdateEngine(
      grpc::ClientContext& context, Options const& options,
      google::cloud::discoveryengine::v1::UpdateEngineRequest const& request)
      override;

  StatusOr<google::cloud::discoveryengine::v1::Engine> GetEngine(
      grpc::ClientContext& context, Options const& options,
      google::cloud::discoveryengine::v1::GetEngineRequest const& request)
      override;

  StatusOr<google::cloud::discoveryengine::v1::ListEnginesResponse> ListEngines(
      grpc::ClientContext& context, Options const& options,
      google::cloud::discoveryengine::v1::ListEnginesRequest const& request)
      override;

  future<StatusOr<google::longrunning::Operation>> AsyncGetOperation(
      google::cloud::CompletionQueue& cq,
      std::shared_ptr<grpc::ClientContext> context,
      google::cloud::internal::ImmutableOptions options,
      google::longrunning::GetOperationRequest const& request) override;

  future<Status> AsyncCancelOperation(
      google::cloud::CompletionQueue& cq,
      std::shared_ptr<grpc::ClientContext> context,
      google::cloud::internal::ImmutableOptions options,
      google::longrunning::CancelOperationRequest const& request) override;

 private:
  std::unique_ptr<
      google::cloud::discoveryengine::v1::EngineService::StubInterface>
      grpc_stub_;
  std::unique_ptr<google::longrunning::Operations::StubInterface> operations_;
};

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace discoveryengine_v1_internal
}  // namespace cloud
}  // namespace google

#endif  // GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_DISCOVERYENGINE_V1_INTERNAL_ENGINE_STUB_H
