// Copyright 2023 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/edgenetwork/v1/service.proto

#ifndef GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_EDGENETWORK_V1_EDGE_NETWORK_CONNECTION_IDEMPOTENCY_POLICY_H
#define GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_EDGENETWORK_V1_EDGE_NETWORK_CONNECTION_IDEMPOTENCY_POLICY_H

#include "google/cloud/idempotency.h"
#include "google/cloud/version.h"
#include <google/cloud/edgenetwork/v1/service.grpc.pb.h>
#include <memory>

namespace google {
namespace cloud {
namespace edgenetwork_v1 {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

class EdgeNetworkConnectionIdempotencyPolicy {
 public:
  virtual ~EdgeNetworkConnectionIdempotencyPolicy();

  /// Create a new copy of this object.
  virtual std::unique_ptr<EdgeNetworkConnectionIdempotencyPolicy> clone() const;

  virtual google::cloud::Idempotency InitializeZone(
      google::cloud::edgenetwork::v1::InitializeZoneRequest const& request);

  virtual google::cloud::Idempotency ListZones(
      google::cloud::edgenetwork::v1::ListZonesRequest request);

  virtual google::cloud::Idempotency GetZone(
      google::cloud::edgenetwork::v1::GetZoneRequest const& request);

  virtual google::cloud::Idempotency ListNetworks(
      google::cloud::edgenetwork::v1::ListNetworksRequest request);

  virtual google::cloud::Idempotency GetNetwork(
      google::cloud::edgenetwork::v1::GetNetworkRequest const& request);

  virtual google::cloud::Idempotency DiagnoseNetwork(
      google::cloud::edgenetwork::v1::DiagnoseNetworkRequest const& request);

  virtual google::cloud::Idempotency CreateNetwork(
      google::cloud::edgenetwork::v1::CreateNetworkRequest const& request);

  virtual google::cloud::Idempotency DeleteNetwork(
      google::cloud::edgenetwork::v1::DeleteNetworkRequest const& request);

  virtual google::cloud::Idempotency ListSubnets(
      google::cloud::edgenetwork::v1::ListSubnetsRequest request);

  virtual google::cloud::Idempotency GetSubnet(
      google::cloud::edgenetwork::v1::GetSubnetRequest const& request);

  virtual google::cloud::Idempotency CreateSubnet(
      google::cloud::edgenetwork::v1::CreateSubnetRequest const& request);

  virtual google::cloud::Idempotency UpdateSubnet(
      google::cloud::edgenetwork::v1::UpdateSubnetRequest const& request);

  virtual google::cloud::Idempotency DeleteSubnet(
      google::cloud::edgenetwork::v1::DeleteSubnetRequest const& request);

  virtual google::cloud::Idempotency ListInterconnects(
      google::cloud::edgenetwork::v1::ListInterconnectsRequest request);

  virtual google::cloud::Idempotency GetInterconnect(
      google::cloud::edgenetwork::v1::GetInterconnectRequest const& request);

  virtual google::cloud::Idempotency DiagnoseInterconnect(
      google::cloud::edgenetwork::v1::DiagnoseInterconnectRequest const&
          request);

  virtual google::cloud::Idempotency ListInterconnectAttachments(
      google::cloud::edgenetwork::v1::ListInterconnectAttachmentsRequest
          request);

  virtual google::cloud::Idempotency GetInterconnectAttachment(
      google::cloud::edgenetwork::v1::GetInterconnectAttachmentRequest const&
          request);

  virtual google::cloud::Idempotency CreateInterconnectAttachment(
      google::cloud::edgenetwork::v1::CreateInterconnectAttachmentRequest const&
          request);

  virtual google::cloud::Idempotency DeleteInterconnectAttachment(
      google::cloud::edgenetwork::v1::DeleteInterconnectAttachmentRequest const&
          request);

  virtual google::cloud::Idempotency ListRouters(
      google::cloud::edgenetwork::v1::ListRoutersRequest request);

  virtual google::cloud::Idempotency GetRouter(
      google::cloud::edgenetwork::v1::GetRouterRequest const& request);

  virtual google::cloud::Idempotency DiagnoseRouter(
      google::cloud::edgenetwork::v1::DiagnoseRouterRequest const& request);

  virtual google::cloud::Idempotency CreateRouter(
      google::cloud::edgenetwork::v1::CreateRouterRequest const& request);

  virtual google::cloud::Idempotency UpdateRouter(
      google::cloud::edgenetwork::v1::UpdateRouterRequest const& request);

  virtual google::cloud::Idempotency DeleteRouter(
      google::cloud::edgenetwork::v1::DeleteRouterRequest const& request);
};

std::unique_ptr<EdgeNetworkConnectionIdempotencyPolicy>
MakeDefaultEdgeNetworkConnectionIdempotencyPolicy();

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace edgenetwork_v1
}  // namespace cloud
}  // namespace google

#endif  // GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_EDGENETWORK_V1_EDGE_NETWORK_CONNECTION_IDEMPOTENCY_POLICY_H
