// Copyright 2023 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/gkemulticloud/v1/aws_service.proto

#include "google/cloud/gkemulticloud/v1/aws_clusters_client.h"
#include <memory>
#include <utility>

namespace google {
namespace cloud {
namespace gkemulticloud_v1 {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

AwsClustersClient::AwsClustersClient(
    std::shared_ptr<AwsClustersConnection> connection, Options opts)
    : connection_(std::move(connection)),
      options_(
          internal::MergeOptions(std::move(opts), connection_->options())) {}
AwsClustersClient::~AwsClustersClient() = default;

future<StatusOr<google::cloud::gkemulticloud::v1::AwsCluster>>
AwsClustersClient::CreateAwsCluster(
    std::string const& parent,
    google::cloud::gkemulticloud::v1::AwsCluster const& aws_cluster,
    std::string const& aws_cluster_id, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::gkemulticloud::v1::CreateAwsClusterRequest request;
  request.set_parent(parent);
  *request.mutable_aws_cluster() = aws_cluster;
  request.set_aws_cluster_id(aws_cluster_id);
  return connection_->CreateAwsCluster(request);
}

StatusOr<google::longrunning::Operation> AwsClustersClient::CreateAwsCluster(
    NoAwaitTag, std::string const& parent,
    google::cloud::gkemulticloud::v1::AwsCluster const& aws_cluster,
    std::string const& aws_cluster_id, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::gkemulticloud::v1::CreateAwsClusterRequest request;
  request.set_parent(parent);
  *request.mutable_aws_cluster() = aws_cluster;
  request.set_aws_cluster_id(aws_cluster_id);
  return connection_->CreateAwsCluster(NoAwaitTag{}, request);
}

future<StatusOr<google::cloud::gkemulticloud::v1::AwsCluster>>
AwsClustersClient::CreateAwsCluster(
    google::cloud::gkemulticloud::v1::CreateAwsClusterRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->CreateAwsCluster(request);
}

StatusOr<google::longrunning::Operation> AwsClustersClient::CreateAwsCluster(
    NoAwaitTag,
    google::cloud::gkemulticloud::v1::CreateAwsClusterRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->CreateAwsCluster(NoAwaitTag{}, request);
}

future<StatusOr<google::cloud::gkemulticloud::v1::AwsCluster>>
AwsClustersClient::CreateAwsCluster(
    google::longrunning::Operation const& operation, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->CreateAwsCluster(operation);
}

future<StatusOr<google::cloud::gkemulticloud::v1::AwsCluster>>
AwsClustersClient::UpdateAwsCluster(
    google::cloud::gkemulticloud::v1::AwsCluster const& aws_cluster,
    google::protobuf::FieldMask const& update_mask, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::gkemulticloud::v1::UpdateAwsClusterRequest request;
  *request.mutable_aws_cluster() = aws_cluster;
  *request.mutable_update_mask() = update_mask;
  return connection_->UpdateAwsCluster(request);
}

StatusOr<google::longrunning::Operation> AwsClustersClient::UpdateAwsCluster(
    NoAwaitTag, google::cloud::gkemulticloud::v1::AwsCluster const& aws_cluster,
    google::protobuf::FieldMask const& update_mask, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::gkemulticloud::v1::UpdateAwsClusterRequest request;
  *request.mutable_aws_cluster() = aws_cluster;
  *request.mutable_update_mask() = update_mask;
  return connection_->UpdateAwsCluster(NoAwaitTag{}, request);
}

future<StatusOr<google::cloud::gkemulticloud::v1::AwsCluster>>
AwsClustersClient::UpdateAwsCluster(
    google::cloud::gkemulticloud::v1::UpdateAwsClusterRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->UpdateAwsCluster(request);
}

StatusOr<google::longrunning::Operation> AwsClustersClient::UpdateAwsCluster(
    NoAwaitTag,
    google::cloud::gkemulticloud::v1::UpdateAwsClusterRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->UpdateAwsCluster(NoAwaitTag{}, request);
}

future<StatusOr<google::cloud::gkemulticloud::v1::AwsCluster>>
AwsClustersClient::UpdateAwsCluster(
    google::longrunning::Operation const& operation, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->UpdateAwsCluster(operation);
}

StatusOr<google::cloud::gkemulticloud::v1::AwsCluster>
AwsClustersClient::GetAwsCluster(std::string const& name, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::gkemulticloud::v1::GetAwsClusterRequest request;
  request.set_name(name);
  return connection_->GetAwsCluster(request);
}

StatusOr<google::cloud::gkemulticloud::v1::AwsCluster>
AwsClustersClient::GetAwsCluster(
    google::cloud::gkemulticloud::v1::GetAwsClusterRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->GetAwsCluster(request);
}

StreamRange<google::cloud::gkemulticloud::v1::AwsCluster>
AwsClustersClient::ListAwsClusters(std::string const& parent, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::gkemulticloud::v1::ListAwsClustersRequest request;
  request.set_parent(parent);
  return connection_->ListAwsClusters(request);
}

StreamRange<google::cloud::gkemulticloud::v1::AwsCluster>
AwsClustersClient::ListAwsClusters(
    google::cloud::gkemulticloud::v1::ListAwsClustersRequest request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->ListAwsClusters(std::move(request));
}

future<StatusOr<google::cloud::gkemulticloud::v1::OperationMetadata>>
AwsClustersClient::DeleteAwsCluster(std::string const& name, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::gkemulticloud::v1::DeleteAwsClusterRequest request;
  request.set_name(name);
  return connection_->DeleteAwsCluster(request);
}

StatusOr<google::longrunning::Operation> AwsClustersClient::DeleteAwsCluster(
    NoAwaitTag, std::string const& name, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::gkemulticloud::v1::DeleteAwsClusterRequest request;
  request.set_name(name);
  return connection_->DeleteAwsCluster(NoAwaitTag{}, request);
}

future<StatusOr<google::cloud::gkemulticloud::v1::OperationMetadata>>
AwsClustersClient::DeleteAwsCluster(
    google::cloud::gkemulticloud::v1::DeleteAwsClusterRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->DeleteAwsCluster(request);
}

StatusOr<google::longrunning::Operation> AwsClustersClient::DeleteAwsCluster(
    NoAwaitTag,
    google::cloud::gkemulticloud::v1::DeleteAwsClusterRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->DeleteAwsCluster(NoAwaitTag{}, request);
}

future<StatusOr<google::cloud::gkemulticloud::v1::OperationMetadata>>
AwsClustersClient::DeleteAwsCluster(
    google::longrunning::Operation const& operation, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->DeleteAwsCluster(operation);
}

StatusOr<google::cloud::gkemulticloud::v1::GenerateAwsClusterAgentTokenResponse>
AwsClustersClient::GenerateAwsClusterAgentToken(
    google::cloud::gkemulticloud::v1::GenerateAwsClusterAgentTokenRequest const&
        request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->GenerateAwsClusterAgentToken(request);
}

StatusOr<google::cloud::gkemulticloud::v1::GenerateAwsAccessTokenResponse>
AwsClustersClient::GenerateAwsAccessToken(
    google::cloud::gkemulticloud::v1::GenerateAwsAccessTokenRequest const&
        request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->GenerateAwsAccessToken(request);
}

future<StatusOr<google::cloud::gkemulticloud::v1::AwsNodePool>>
AwsClustersClient::CreateAwsNodePool(
    std::string const& parent,
    google::cloud::gkemulticloud::v1::AwsNodePool const& aws_node_pool,
    std::string const& aws_node_pool_id, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::gkemulticloud::v1::CreateAwsNodePoolRequest request;
  request.set_parent(parent);
  *request.mutable_aws_node_pool() = aws_node_pool;
  request.set_aws_node_pool_id(aws_node_pool_id);
  return connection_->CreateAwsNodePool(request);
}

StatusOr<google::longrunning::Operation> AwsClustersClient::CreateAwsNodePool(
    NoAwaitTag, std::string const& parent,
    google::cloud::gkemulticloud::v1::AwsNodePool const& aws_node_pool,
    std::string const& aws_node_pool_id, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::gkemulticloud::v1::CreateAwsNodePoolRequest request;
  request.set_parent(parent);
  *request.mutable_aws_node_pool() = aws_node_pool;
  request.set_aws_node_pool_id(aws_node_pool_id);
  return connection_->CreateAwsNodePool(NoAwaitTag{}, request);
}

future<StatusOr<google::cloud::gkemulticloud::v1::AwsNodePool>>
AwsClustersClient::CreateAwsNodePool(
    google::cloud::gkemulticloud::v1::CreateAwsNodePoolRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->CreateAwsNodePool(request);
}

StatusOr<google::longrunning::Operation> AwsClustersClient::CreateAwsNodePool(
    NoAwaitTag,
    google::cloud::gkemulticloud::v1::CreateAwsNodePoolRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->CreateAwsNodePool(NoAwaitTag{}, request);
}

future<StatusOr<google::cloud::gkemulticloud::v1::AwsNodePool>>
AwsClustersClient::CreateAwsNodePool(
    google::longrunning::Operation const& operation, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->CreateAwsNodePool(operation);
}

future<StatusOr<google::cloud::gkemulticloud::v1::AwsNodePool>>
AwsClustersClient::UpdateAwsNodePool(
    google::cloud::gkemulticloud::v1::AwsNodePool const& aws_node_pool,
    google::protobuf::FieldMask const& update_mask, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::gkemulticloud::v1::UpdateAwsNodePoolRequest request;
  *request.mutable_aws_node_pool() = aws_node_pool;
  *request.mutable_update_mask() = update_mask;
  return connection_->UpdateAwsNodePool(request);
}

StatusOr<google::longrunning::Operation> AwsClustersClient::UpdateAwsNodePool(
    NoAwaitTag,
    google::cloud::gkemulticloud::v1::AwsNodePool const& aws_node_pool,
    google::protobuf::FieldMask const& update_mask, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::gkemulticloud::v1::UpdateAwsNodePoolRequest request;
  *request.mutable_aws_node_pool() = aws_node_pool;
  *request.mutable_update_mask() = update_mask;
  return connection_->UpdateAwsNodePool(NoAwaitTag{}, request);
}

future<StatusOr<google::cloud::gkemulticloud::v1::AwsNodePool>>
AwsClustersClient::UpdateAwsNodePool(
    google::cloud::gkemulticloud::v1::UpdateAwsNodePoolRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->UpdateAwsNodePool(request);
}

StatusOr<google::longrunning::Operation> AwsClustersClient::UpdateAwsNodePool(
    NoAwaitTag,
    google::cloud::gkemulticloud::v1::UpdateAwsNodePoolRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->UpdateAwsNodePool(NoAwaitTag{}, request);
}

future<StatusOr<google::cloud::gkemulticloud::v1::AwsNodePool>>
AwsClustersClient::UpdateAwsNodePool(
    google::longrunning::Operation const& operation, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->UpdateAwsNodePool(operation);
}

future<StatusOr<google::cloud::gkemulticloud::v1::AwsNodePool>>
AwsClustersClient::RollbackAwsNodePoolUpdate(std::string const& name,
                                             Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::gkemulticloud::v1::RollbackAwsNodePoolUpdateRequest request;
  request.set_name(name);
  return connection_->RollbackAwsNodePoolUpdate(request);
}

StatusOr<google::longrunning::Operation>
AwsClustersClient::RollbackAwsNodePoolUpdate(NoAwaitTag,
                                             std::string const& name,
                                             Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::gkemulticloud::v1::RollbackAwsNodePoolUpdateRequest request;
  request.set_name(name);
  return connection_->RollbackAwsNodePoolUpdate(NoAwaitTag{}, request);
}

future<StatusOr<google::cloud::gkemulticloud::v1::AwsNodePool>>
AwsClustersClient::RollbackAwsNodePoolUpdate(
    google::cloud::gkemulticloud::v1::RollbackAwsNodePoolUpdateRequest const&
        request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->RollbackAwsNodePoolUpdate(request);
}

StatusOr<google::longrunning::Operation>
AwsClustersClient::RollbackAwsNodePoolUpdate(
    NoAwaitTag,
    google::cloud::gkemulticloud::v1::RollbackAwsNodePoolUpdateRequest const&
        request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->RollbackAwsNodePoolUpdate(NoAwaitTag{}, request);
}

future<StatusOr<google::cloud::gkemulticloud::v1::AwsNodePool>>
AwsClustersClient::RollbackAwsNodePoolUpdate(
    google::longrunning::Operation const& operation, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->RollbackAwsNodePoolUpdate(operation);
}

StatusOr<google::cloud::gkemulticloud::v1::AwsNodePool>
AwsClustersClient::GetAwsNodePool(std::string const& name, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::gkemulticloud::v1::GetAwsNodePoolRequest request;
  request.set_name(name);
  return connection_->GetAwsNodePool(request);
}

StatusOr<google::cloud::gkemulticloud::v1::AwsNodePool>
AwsClustersClient::GetAwsNodePool(
    google::cloud::gkemulticloud::v1::GetAwsNodePoolRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->GetAwsNodePool(request);
}

StreamRange<google::cloud::gkemulticloud::v1::AwsNodePool>
AwsClustersClient::ListAwsNodePools(std::string const& parent, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::gkemulticloud::v1::ListAwsNodePoolsRequest request;
  request.set_parent(parent);
  return connection_->ListAwsNodePools(request);
}

StreamRange<google::cloud::gkemulticloud::v1::AwsNodePool>
AwsClustersClient::ListAwsNodePools(
    google::cloud::gkemulticloud::v1::ListAwsNodePoolsRequest request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->ListAwsNodePools(std::move(request));
}

future<StatusOr<google::cloud::gkemulticloud::v1::OperationMetadata>>
AwsClustersClient::DeleteAwsNodePool(std::string const& name, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::gkemulticloud::v1::DeleteAwsNodePoolRequest request;
  request.set_name(name);
  return connection_->DeleteAwsNodePool(request);
}

StatusOr<google::longrunning::Operation> AwsClustersClient::DeleteAwsNodePool(
    NoAwaitTag, std::string const& name, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::gkemulticloud::v1::DeleteAwsNodePoolRequest request;
  request.set_name(name);
  return connection_->DeleteAwsNodePool(NoAwaitTag{}, request);
}

future<StatusOr<google::cloud::gkemulticloud::v1::OperationMetadata>>
AwsClustersClient::DeleteAwsNodePool(
    google::cloud::gkemulticloud::v1::DeleteAwsNodePoolRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->DeleteAwsNodePool(request);
}

StatusOr<google::longrunning::Operation> AwsClustersClient::DeleteAwsNodePool(
    NoAwaitTag,
    google::cloud::gkemulticloud::v1::DeleteAwsNodePoolRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->DeleteAwsNodePool(NoAwaitTag{}, request);
}

future<StatusOr<google::cloud::gkemulticloud::v1::OperationMetadata>>
AwsClustersClient::DeleteAwsNodePool(
    google::longrunning::Operation const& operation, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->DeleteAwsNodePool(operation);
}

StatusOr<google::cloud::gkemulticloud::v1::AwsOpenIdConfig>
AwsClustersClient::GetAwsOpenIdConfig(
    google::cloud::gkemulticloud::v1::GetAwsOpenIdConfigRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->GetAwsOpenIdConfig(request);
}

StatusOr<google::cloud::gkemulticloud::v1::AwsJsonWebKeys>
AwsClustersClient::GetAwsJsonWebKeys(
    google::cloud::gkemulticloud::v1::GetAwsJsonWebKeysRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->GetAwsJsonWebKeys(request);
}

StatusOr<google::cloud::gkemulticloud::v1::AwsServerConfig>
AwsClustersClient::GetAwsServerConfig(std::string const& name, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::gkemulticloud::v1::GetAwsServerConfigRequest request;
  request.set_name(name);
  return connection_->GetAwsServerConfig(request);
}

StatusOr<google::cloud::gkemulticloud::v1::AwsServerConfig>
AwsClustersClient::GetAwsServerConfig(
    google::cloud::gkemulticloud::v1::GetAwsServerConfigRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->GetAwsServerConfig(request);
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace gkemulticloud_v1
}  // namespace cloud
}  // namespace google
