// Copyright 2024 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/kms/v1/autokey.proto

#ifndef GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_KMS_V1_AUTOKEY_CONNECTION_IDEMPOTENCY_POLICY_H
#define GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_KMS_V1_AUTOKEY_CONNECTION_IDEMPOTENCY_POLICY_H

#include "google/cloud/idempotency.h"
#include "google/cloud/version.h"
#include <google/cloud/kms/v1/autokey.grpc.pb.h>
#include <memory>

namespace google {
namespace cloud {
namespace kms_v1 {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

class AutokeyConnectionIdempotencyPolicy {
 public:
  virtual ~AutokeyConnectionIdempotencyPolicy();

  /// Create a new copy of this object.
  virtual std::unique_ptr<AutokeyConnectionIdempotencyPolicy> clone() const;

  virtual google::cloud::Idempotency CreateKeyHandle(
      google::cloud::kms::v1::CreateKeyHandleRequest const& request);

  virtual google::cloud::Idempotency GetKeyHandle(
      google::cloud::kms::v1::GetKeyHandleRequest const& request);

  virtual google::cloud::Idempotency ListKeyHandles(
      google::cloud::kms::v1::ListKeyHandlesRequest request);
};

std::unique_ptr<AutokeyConnectionIdempotencyPolicy>
MakeDefaultAutokeyConnectionIdempotencyPolicy();

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace kms_v1
}  // namespace cloud
}  // namespace google

#endif  // GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_KMS_V1_AUTOKEY_CONNECTION_IDEMPOTENCY_POLICY_H
