// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/notebooks/v1/managed_service.proto

#include "google/cloud/notebooks/v1/internal/managed_notebook_option_defaults.h"
#include "google/cloud/notebooks/v1/managed_notebook_connection.h"
#include "google/cloud/notebooks/v1/managed_notebook_options.h"
#include "google/cloud/internal/populate_common_options.h"
#include "google/cloud/internal/populate_grpc_options.h"
#include <memory>
#include <utility>

namespace google {
namespace cloud {
namespace notebooks_v1_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

namespace {
auto constexpr kBackoffScaling = 2.0;
}  // namespace

Options ManagedNotebookServiceDefaultOptions(Options options) {
  options = internal::PopulateCommonOptions(
      std::move(options), "GOOGLE_CLOUD_CPP_MANAGED_NOTEBOOK_SERVICE_ENDPOINT",
      "", "GOOGLE_CLOUD_CPP_MANAGED_NOTEBOOK_SERVICE_AUTHORITY",
      "notebooks.googleapis.com");
  options = internal::PopulateGrpcOptions(std::move(options));
  if (!options.has<notebooks_v1::ManagedNotebookServiceRetryPolicyOption>()) {
    options.set<notebooks_v1::ManagedNotebookServiceRetryPolicyOption>(
        notebooks_v1::ManagedNotebookServiceLimitedTimeRetryPolicy(
            std::chrono::minutes(30))
            .clone());
  }
  if (!options.has<notebooks_v1::ManagedNotebookServiceBackoffPolicyOption>()) {
    options.set<notebooks_v1::ManagedNotebookServiceBackoffPolicyOption>(
        ExponentialBackoffPolicy(
            std::chrono::seconds(0), std::chrono::seconds(1),
            std::chrono::minutes(5), kBackoffScaling, kBackoffScaling)
            .clone());
  }
  if (!options.has<notebooks_v1::ManagedNotebookServicePollingPolicyOption>()) {
    options.set<notebooks_v1::ManagedNotebookServicePollingPolicyOption>(
        GenericPollingPolicy<
            notebooks_v1::ManagedNotebookServiceRetryPolicyOption::Type,
            notebooks_v1::ManagedNotebookServiceBackoffPolicyOption::Type>(
            options
                .get<notebooks_v1::ManagedNotebookServiceRetryPolicyOption>()
                ->clone(),
            ExponentialBackoffPolicy(std::chrono::seconds(1),
                                     std::chrono::minutes(5), kBackoffScaling)
                .clone())
            .clone());
  }
  if (!options.has<
          notebooks_v1::
              ManagedNotebookServiceConnectionIdempotencyPolicyOption>()) {
    options.set<
        notebooks_v1::ManagedNotebookServiceConnectionIdempotencyPolicyOption>(
        notebooks_v1::
            MakeDefaultManagedNotebookServiceConnectionIdempotencyPolicy());
  }

  return options;
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace notebooks_v1_internal
}  // namespace cloud
}  // namespace google
