// Copyright 2024 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/security/publicca/v1/service.proto

#ifndef GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_PUBLICCA_V1_INTERNAL_PUBLIC_CERTIFICATE_AUTHORITY_TRACING_CONNECTION_H
#define GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_PUBLICCA_V1_INTERNAL_PUBLIC_CERTIFICATE_AUTHORITY_TRACING_CONNECTION_H

#include "google/cloud/publicca/v1/public_certificate_authority_connection.h"
#include "google/cloud/version.h"
#include <memory>

namespace google {
namespace cloud {
namespace publicca_v1_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

#ifdef GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY

class PublicCertificateAuthorityServiceTracingConnection
    : public publicca_v1::PublicCertificateAuthorityServiceConnection {
 public:
  ~PublicCertificateAuthorityServiceTracingConnection() override = default;

  explicit PublicCertificateAuthorityServiceTracingConnection(
      std::shared_ptr<publicca_v1::PublicCertificateAuthorityServiceConnection>
          child);

  Options options() override { return child_->options(); }

  StatusOr<google::cloud::security::publicca::v1::ExternalAccountKey>
  CreateExternalAccountKey(
      google::cloud::security::publicca::v1::
          CreateExternalAccountKeyRequest const& request) override;

 private:
  std::shared_ptr<publicca_v1::PublicCertificateAuthorityServiceConnection>
      child_;
};

#endif  // GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY

/**
 * Conditionally applies the tracing decorator to the given connection.
 *
 * The connection is only decorated if tracing is enabled (as determined by the
 * connection's options).
 */
std::shared_ptr<publicca_v1::PublicCertificateAuthorityServiceConnection>
MakePublicCertificateAuthorityServiceTracingConnection(
    std::shared_ptr<publicca_v1::PublicCertificateAuthorityServiceConnection>
        conn);

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace publicca_v1_internal
}  // namespace cloud
}  // namespace google

#endif  // GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_PUBLICCA_V1_INTERNAL_PUBLIC_CERTIFICATE_AUTHORITY_TRACING_CONNECTION_H
