// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/shell/v1/cloudshell.proto

#ifndef GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_SHELL_V1_INTERNAL_CLOUD_SHELL_CONNECTION_IMPL_H
#define GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_SHELL_V1_INTERNAL_CLOUD_SHELL_CONNECTION_IMPL_H

#include "google/cloud/shell/v1/cloud_shell_connection.h"
#include "google/cloud/shell/v1/cloud_shell_connection_idempotency_policy.h"
#include "google/cloud/shell/v1/cloud_shell_options.h"
#include "google/cloud/shell/v1/internal/cloud_shell_retry_traits.h"
#include "google/cloud/shell/v1/internal/cloud_shell_stub.h"
#include "google/cloud/background_threads.h"
#include "google/cloud/backoff_policy.h"
#include "google/cloud/future.h"
#include "google/cloud/options.h"
#include "google/cloud/polling_policy.h"
#include "google/cloud/status_or.h"
#include "google/cloud/version.h"
#include <google/longrunning/operations.grpc.pb.h>
#include <memory>

namespace google {
namespace cloud {
namespace shell_v1_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

class CloudShellServiceConnectionImpl
    : public shell_v1::CloudShellServiceConnection {
 public:
  ~CloudShellServiceConnectionImpl() override = default;

  CloudShellServiceConnectionImpl(
      std::unique_ptr<google::cloud::BackgroundThreads> background,
      std::shared_ptr<shell_v1_internal::CloudShellServiceStub> stub,
      Options options);

  Options options() override { return options_; }

  StatusOr<google::cloud::shell::v1::Environment> GetEnvironment(
      google::cloud::shell::v1::GetEnvironmentRequest const& request) override;

  future<StatusOr<google::cloud::shell::v1::StartEnvironmentResponse>>
  StartEnvironment(google::cloud::shell::v1::StartEnvironmentRequest const&
                       request) override;

  StatusOr<google::longrunning::Operation> StartEnvironment(
      NoAwaitTag,
      google::cloud::shell::v1::StartEnvironmentRequest const& request)
      override;

  future<StatusOr<google::cloud::shell::v1::StartEnvironmentResponse>>
  StartEnvironment(google::longrunning::Operation const& operation) override;

  future<StatusOr<google::cloud::shell::v1::AuthorizeEnvironmentResponse>>
  AuthorizeEnvironment(
      google::cloud::shell::v1::AuthorizeEnvironmentRequest const& request)
      override;

  StatusOr<google::longrunning::Operation> AuthorizeEnvironment(
      NoAwaitTag,
      google::cloud::shell::v1::AuthorizeEnvironmentRequest const& request)
      override;

  future<StatusOr<google::cloud::shell::v1::AuthorizeEnvironmentResponse>>
  AuthorizeEnvironment(
      google::longrunning::Operation const& operation) override;

  future<StatusOr<google::cloud::shell::v1::AddPublicKeyResponse>> AddPublicKey(
      google::cloud::shell::v1::AddPublicKeyRequest const& request) override;

  StatusOr<google::longrunning::Operation> AddPublicKey(
      NoAwaitTag,
      google::cloud::shell::v1::AddPublicKeyRequest const& request) override;

  future<StatusOr<google::cloud::shell::v1::AddPublicKeyResponse>> AddPublicKey(
      google::longrunning::Operation const& operation) override;

  future<StatusOr<google::cloud::shell::v1::RemovePublicKeyResponse>>
  RemovePublicKey(
      google::cloud::shell::v1::RemovePublicKeyRequest const& request) override;

  StatusOr<google::longrunning::Operation> RemovePublicKey(
      NoAwaitTag,
      google::cloud::shell::v1::RemovePublicKeyRequest const& request) override;

  future<StatusOr<google::cloud::shell::v1::RemovePublicKeyResponse>>
  RemovePublicKey(google::longrunning::Operation const& operation) override;

 private:
  std::unique_ptr<google::cloud::BackgroundThreads> background_;
  std::shared_ptr<shell_v1_internal::CloudShellServiceStub> stub_;
  Options options_;
};

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace shell_v1_internal
}  // namespace cloud
}  // namespace google

#endif  // GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_SHELL_V1_INTERNAL_CLOUD_SHELL_CONNECTION_IMPL_H
