// Copyright 2024 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/storage/control/v2/storage_control.proto

#include "google/cloud/storagecontrol/v2/internal/storage_control_tracing_connection.h"
#include "google/cloud/internal/opentelemetry.h"
#include "google/cloud/internal/traced_stream_range.h"
#include <memory>
#include <utility>

namespace google {
namespace cloud {
namespace storagecontrol_v2_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

#ifdef GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY

StorageControlTracingConnection::StorageControlTracingConnection(
    std::shared_ptr<storagecontrol_v2::StorageControlConnection> child)
    : child_(std::move(child)) {}

StatusOr<google::storage::control::v2::Folder>
StorageControlTracingConnection::CreateFolder(
    google::storage::control::v2::CreateFolderRequest const& request) {
  auto span = internal::MakeSpan(
      "storagecontrol_v2::StorageControlConnection::CreateFolder");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->CreateFolder(request));
}

Status StorageControlTracingConnection::DeleteFolder(
    google::storage::control::v2::DeleteFolderRequest const& request) {
  auto span = internal::MakeSpan(
      "storagecontrol_v2::StorageControlConnection::DeleteFolder");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->DeleteFolder(request));
}

StatusOr<google::storage::control::v2::Folder>
StorageControlTracingConnection::GetFolder(
    google::storage::control::v2::GetFolderRequest const& request) {
  auto span = internal::MakeSpan(
      "storagecontrol_v2::StorageControlConnection::GetFolder");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->GetFolder(request));
}

StreamRange<google::storage::control::v2::Folder>
StorageControlTracingConnection::ListFolders(
    google::storage::control::v2::ListFoldersRequest request) {
  auto span = internal::MakeSpan(
      "storagecontrol_v2::StorageControlConnection::ListFolders");
  internal::OTelScope scope(span);
  auto sr = child_->ListFolders(std::move(request));
  return internal::MakeTracedStreamRange<google::storage::control::v2::Folder>(
      std::move(span), std::move(sr));
}

future<StatusOr<google::storage::control::v2::Folder>>
StorageControlTracingConnection::RenameFolder(
    google::storage::control::v2::RenameFolderRequest const& request) {
  auto span = internal::MakeSpan(
      "storagecontrol_v2::StorageControlConnection::RenameFolder");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span), child_->RenameFolder(request));
}

StatusOr<google::longrunning::Operation>
StorageControlTracingConnection::RenameFolder(
    NoAwaitTag,
    google::storage::control::v2::RenameFolderRequest const& request) {
  auto span = internal::MakeSpan(
      "storagecontrol_v2::StorageControlConnection::RenameFolder");
  opentelemetry::trace::Scope scope(span);
  return internal::EndSpan(*span, child_->RenameFolder(NoAwaitTag{}, request));
}

future<StatusOr<google::storage::control::v2::Folder>>
StorageControlTracingConnection::RenameFolder(
    google::longrunning::Operation const& operation) {
  auto span = internal::MakeSpan(
      "storagecontrol_v2::StorageControlConnection::RenameFolder");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span), child_->RenameFolder(operation));
}

StatusOr<google::storage::control::v2::StorageLayout>
StorageControlTracingConnection::GetStorageLayout(
    google::storage::control::v2::GetStorageLayoutRequest const& request) {
  auto span = internal::MakeSpan(
      "storagecontrol_v2::StorageControlConnection::GetStorageLayout");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->GetStorageLayout(request));
}

StatusOr<google::storage::control::v2::ManagedFolder>
StorageControlTracingConnection::CreateManagedFolder(
    google::storage::control::v2::CreateManagedFolderRequest const& request) {
  auto span = internal::MakeSpan(
      "storagecontrol_v2::StorageControlConnection::CreateManagedFolder");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->CreateManagedFolder(request));
}

Status StorageControlTracingConnection::DeleteManagedFolder(
    google::storage::control::v2::DeleteManagedFolderRequest const& request) {
  auto span = internal::MakeSpan(
      "storagecontrol_v2::StorageControlConnection::DeleteManagedFolder");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->DeleteManagedFolder(request));
}

StatusOr<google::storage::control::v2::ManagedFolder>
StorageControlTracingConnection::GetManagedFolder(
    google::storage::control::v2::GetManagedFolderRequest const& request) {
  auto span = internal::MakeSpan(
      "storagecontrol_v2::StorageControlConnection::GetManagedFolder");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->GetManagedFolder(request));
}

StreamRange<google::storage::control::v2::ManagedFolder>
StorageControlTracingConnection::ListManagedFolders(
    google::storage::control::v2::ListManagedFoldersRequest request) {
  auto span = internal::MakeSpan(
      "storagecontrol_v2::StorageControlConnection::ListManagedFolders");
  internal::OTelScope scope(span);
  auto sr = child_->ListManagedFolders(std::move(request));
  return internal::MakeTracedStreamRange<
      google::storage::control::v2::ManagedFolder>(std::move(span),
                                                   std::move(sr));
}

#endif  // GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY

std::shared_ptr<storagecontrol_v2::StorageControlConnection>
MakeStorageControlTracingConnection(
    std::shared_ptr<storagecontrol_v2::StorageControlConnection> conn) {
#ifdef GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY
  if (internal::TracingEnabled(conn->options())) {
    conn = std::make_shared<StorageControlTracingConnection>(std::move(conn));
  }
#endif  // GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY
  return conn;
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace storagecontrol_v2_internal
}  // namespace cloud
}  // namespace google
