// Copyright 2024 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/storage/control/v2/storage_control.proto

#ifndef GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_STORAGECONTROL_V2_STORAGE_CONTROL_CONNECTION_IDEMPOTENCY_POLICY_H
#define GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_STORAGECONTROL_V2_STORAGE_CONTROL_CONNECTION_IDEMPOTENCY_POLICY_H

#include "google/cloud/idempotency.h"
#include "google/cloud/version.h"
#include <google/storage/control/v2/storage_control.grpc.pb.h>
#include <memory>

namespace google {
namespace cloud {
namespace storagecontrol_v2 {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

class StorageControlConnectionIdempotencyPolicy {
 public:
  virtual ~StorageControlConnectionIdempotencyPolicy();

  /// Create a new copy of this object.
  virtual std::unique_ptr<StorageControlConnectionIdempotencyPolicy> clone()
      const;

  virtual google::cloud::Idempotency CreateFolder(
      google::storage::control::v2::CreateFolderRequest const& request);

  virtual google::cloud::Idempotency DeleteFolder(
      google::storage::control::v2::DeleteFolderRequest const& request);

  virtual google::cloud::Idempotency GetFolder(
      google::storage::control::v2::GetFolderRequest const& request);

  virtual google::cloud::Idempotency ListFolders(
      google::storage::control::v2::ListFoldersRequest request);

  virtual google::cloud::Idempotency RenameFolder(
      google::storage::control::v2::RenameFolderRequest const& request);

  virtual google::cloud::Idempotency GetStorageLayout(
      google::storage::control::v2::GetStorageLayoutRequest const& request);

  virtual google::cloud::Idempotency CreateManagedFolder(
      google::storage::control::v2::CreateManagedFolderRequest const& request);

  virtual google::cloud::Idempotency DeleteManagedFolder(
      google::storage::control::v2::DeleteManagedFolderRequest const& request);

  virtual google::cloud::Idempotency GetManagedFolder(
      google::storage::control::v2::GetManagedFolderRequest const& request);

  virtual google::cloud::Idempotency ListManagedFolders(
      google::storage::control::v2::ListManagedFoldersRequest request);
};

std::unique_ptr<StorageControlConnectionIdempotencyPolicy>
MakeDefaultStorageControlConnectionIdempotencyPolicy();

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace storagecontrol_v2
}  // namespace cloud
}  // namespace google

#endif  // GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_STORAGECONTROL_V2_STORAGE_CONTROL_CONNECTION_IDEMPOTENCY_POLICY_H
