// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/video/transcoder/v1/services.proto

#include "google/cloud/video/transcoder/v1/internal/transcoder_option_defaults.h"
#include "google/cloud/video/transcoder/v1/transcoder_connection.h"
#include "google/cloud/video/transcoder/v1/transcoder_options.h"
#include "google/cloud/internal/populate_common_options.h"
#include "google/cloud/internal/populate_grpc_options.h"
#include <memory>
#include <utility>

namespace google {
namespace cloud {
namespace video_transcoder_v1_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

namespace {
auto constexpr kBackoffScaling = 2.0;
}  // namespace

Options TranscoderServiceDefaultOptions(Options options) {
  options = internal::PopulateCommonOptions(
      std::move(options), "GOOGLE_CLOUD_CPP_TRANSCODER_SERVICE_ENDPOINT", "",
      "GOOGLE_CLOUD_CPP_TRANSCODER_SERVICE_AUTHORITY",
      "transcoder.googleapis.com");
  options = internal::PopulateGrpcOptions(std::move(options));
  if (!options.has<video_transcoder_v1::TranscoderServiceRetryPolicyOption>()) {
    options.set<video_transcoder_v1::TranscoderServiceRetryPolicyOption>(
        video_transcoder_v1::TranscoderServiceLimitedTimeRetryPolicy(
            std::chrono::minutes(30))
            .clone());
  }
  if (!options
           .has<video_transcoder_v1::TranscoderServiceBackoffPolicyOption>()) {
    options.set<video_transcoder_v1::TranscoderServiceBackoffPolicyOption>(
        ExponentialBackoffPolicy(
            std::chrono::seconds(0), std::chrono::seconds(1),
            std::chrono::minutes(5), kBackoffScaling, kBackoffScaling)
            .clone());
  }
  if (!options.has<video_transcoder_v1::
                       TranscoderServiceConnectionIdempotencyPolicyOption>()) {
    options.set<video_transcoder_v1::
                    TranscoderServiceConnectionIdempotencyPolicyOption>(
        video_transcoder_v1::
            MakeDefaultTranscoderServiceConnectionIdempotencyPolicy());
  }

  return options;
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace video_transcoder_v1_internal
}  // namespace cloud
}  // namespace google
