// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/vision/v1/image_annotator.proto

#ifndef GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_VISION_V1_INTERNAL_IMAGE_ANNOTATOR_TRACING_CONNECTION_H
#define GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_VISION_V1_INTERNAL_IMAGE_ANNOTATOR_TRACING_CONNECTION_H

#include "google/cloud/vision/v1/image_annotator_connection.h"
#include "google/cloud/version.h"
#include <memory>

namespace google {
namespace cloud {
namespace vision_v1_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

#ifdef GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY

class ImageAnnotatorTracingConnection
    : public vision_v1::ImageAnnotatorConnection {
 public:
  ~ImageAnnotatorTracingConnection() override = default;

  explicit ImageAnnotatorTracingConnection(
      std::shared_ptr<vision_v1::ImageAnnotatorConnection> child);

  Options options() override { return child_->options(); }

  StatusOr<google::cloud::vision::v1::BatchAnnotateImagesResponse>
  BatchAnnotateImages(
      google::cloud::vision::v1::BatchAnnotateImagesRequest const& request)
      override;

  StatusOr<google::cloud::vision::v1::BatchAnnotateFilesResponse>
  BatchAnnotateFiles(google::cloud::vision::v1::BatchAnnotateFilesRequest const&
                         request) override;

  future<StatusOr<google::cloud::vision::v1::AsyncBatchAnnotateImagesResponse>>
  AsyncBatchAnnotateImages(
      google::cloud::vision::v1::AsyncBatchAnnotateImagesRequest const& request)
      override;

  StatusOr<google::longrunning::Operation> AsyncBatchAnnotateImages(
      NoAwaitTag,
      google::cloud::vision::v1::AsyncBatchAnnotateImagesRequest const& request)
      override;

  future<StatusOr<google::cloud::vision::v1::AsyncBatchAnnotateImagesResponse>>
  AsyncBatchAnnotateImages(
      google::longrunning::Operation const& operation) override;

  future<StatusOr<google::cloud::vision::v1::AsyncBatchAnnotateFilesResponse>>
  AsyncBatchAnnotateFiles(
      google::cloud::vision::v1::AsyncBatchAnnotateFilesRequest const& request)
      override;

  StatusOr<google::longrunning::Operation> AsyncBatchAnnotateFiles(
      NoAwaitTag,
      google::cloud::vision::v1::AsyncBatchAnnotateFilesRequest const& request)
      override;

  future<StatusOr<google::cloud::vision::v1::AsyncBatchAnnotateFilesResponse>>
  AsyncBatchAnnotateFiles(
      google::longrunning::Operation const& operation) override;

 private:
  std::shared_ptr<vision_v1::ImageAnnotatorConnection> child_;
};

#endif  // GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY

/**
 * Conditionally applies the tracing decorator to the given connection.
 *
 * The connection is only decorated if tracing is enabled (as determined by the
 * connection's options).
 */
std::shared_ptr<vision_v1::ImageAnnotatorConnection>
MakeImageAnnotatorTracingConnection(
    std::shared_ptr<vision_v1::ImageAnnotatorConnection> conn);

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace vision_v1_internal
}  // namespace cloud
}  // namespace google

#endif  // GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_VISION_V1_INTERNAL_IMAGE_ANNOTATOR_TRACING_CONNECTION_H
