/*
 * Decompiled with CFR 0.152.
 */
package org.jmock.core.constraint;

import java.util.EventObject;
import org.jmock.core.Constraint;

public class IsEventFrom
implements Constraint {
    private Class eventClass;
    private Object source;

    public IsEventFrom(Object source) {
        this(EventObject.class, source);
    }

    public IsEventFrom(Class eventClass, Object source) {
        this.eventClass = eventClass;
        this.source = source;
    }

    public boolean eval(Object o) {
        return o instanceof EventObject && this.eventClass.isInstance(o) && this.eventHasSameSource((EventObject)o);
    }

    private boolean eventHasSameSource(EventObject ev) {
        return ev.getSource() == this.source;
    }

    public StringBuffer describeTo(StringBuffer buffer) {
        return buffer.append("an event of type ").append(this.eventClass.getName()).append(" from ").append(this.source);
    }
}

