#pragma once

namespace nCine {

	enum class KeySym
	{
		// Common keysyms
		BACKSPACE,
		TAB,
		RETURN,
		ESCAPE,
		SPACE,
		QUOTE,
		PLUS,
		COMMA,
		MINUS,
		PERIOD,
		SLASH,
		N0,
		N1,
		N2,
		N3,
		N4,
		N5,
		N6,
		N7,
		N8,
		N9,
		SEMICOLON,
		LEFTBRACKET,
		BACKSLASH,
		RIGHTBRACKET,
		BACKQUOTE,

		A,
		B,
		C,
		D,
		E,
		F,
		G,
		H,
		I,
		J,
		K,
		L,
		M,
		N,
		O,
		P,
		Q,
		R,
		S,
		T,
		U,
		V,
		W,
		X,
		Y,
		Z,
		Delete,

		KP0,
		KP1,
		KP2,
		KP3,
		KP4,
		KP5,
		KP6,
		KP7,
		KP8,
		KP9,
		KP_PERIOD,
		KP_DIVIDE,
		KP_MULTIPLY,
		KP_MINUS,
		KP_PLUS,
		KP_ENTER,
		KP_EQUALS,

		UP,
		DOWN,
		RIGHT,
		LEFT,
		INSERT,
		HOME,
		END,
		PAGEUP,
		PAGEDOWN,

		F1,
		F2,
		F3,
		F4,
		F5,
		F6,
		F7,
		F8,
		F9,
		F10,
		F11,
		F12,
		F13,
		F14,
		F15,

		NUM_LOCK,
		CAPS_LOCK,
		SCROLL_LOCK,
		RSHIFT,
		LSHIFT,
		RCTRL,
		LCTRL,
		RALT,
		LALT,
		RSUPER,
		LSUPER,
		PRINTSCREEN,
		PAUSE,
		MENU,

		// SDL only keysyms
		CLEAR, // Android too
		EXCLAIM,
		QUOTEDBL,
		HASH,
		DOLLAR,
		AMPERSAND,
		LEFTPAREN,
		RIGHTPAREN,
		ASTERISK,
		COLON,
		LESS,
		EQUALS, // Android too
		GREATER,
		QUESTION,
		AT, // Android too
		CARET,
		UNDERSCORE,
		MODE,
		APPLICATION,
		HELP,
		SYSREQ, // Android too
		POWER, // Android too
		UNDO,

		// GLFW only keysyms
		WORLD1,
		WORLD2,

		// Android only keysyms
		SOFT_LEFT,
		SOFT_RIGHT,
		BACK,
		CALL,
		ENDCALL,
		STAR,
		POUND,
		DPAD_CENTER,
		VOLUME_UP,
		VOLUME_DOWN,
		CAMERA,
		SYM,
		EXPLORER,
		ENVELOPE,
		NUM,
		HEADSETHOOK,
		FOCUS,
		NOTIFICATION,
		SEARCH,
		MEDIA_PLAY_PAUSE,
		MEDIA_STOP,
		MEDIA_NEXT,
		MEDIA_PREVIOUS,
		MEDIA_REWIND,
		MEDIA_FAST_FORWARD,
		MUTE,
		PICTSYMBOLS,
		SWITCH_CHARSET,
		BUTTON_A,
		BUTTON_B,
		BUTTON_C,
		BUTTON_X,
		BUTTON_Y,
		BUTTON_Z,
		BUTTON_L1,
		BUTTON_R1,
		BUTTON_L2,
		BUTTON_R2,
		BUTTON_THUMBL,
		BUTTON_THUMBR,
		BUTTON_START,
		BUTTON_SELECT,
		BUTTON_MODE,
		// From API level 13
		FUNCTION_KEY,
		MOVE_HOME,
		MOVE_END,
		FORWARD,
		MEDIA_PLAY,
		MEDIA_PAUSE,
		MEDIA_CLOSE,
		MEDIA_EJECT,
		MEDIA_RECORD,
		KP_COMMA,
		KP_LEFTPAREN,
		KP_RIGHTPAREN,
		VOLUME_MUTE,
		INFO,
		CHANNEL_UP,
		CHANNEL_DOWN,
		ZOOM_IN,
		ZOOM_OUT,
		TV,
		WINDOW,
		GUIDE,
		DVR,
		BOOKMARK,
		CAPTIONS,
		SETTINGS,
		TV_POWER,
		TV_INPUT,
		STB_POWER,
		STB_INPUT,
		AVR_POWER,
		AVR_INPUT,
		PROG_RED,
		PROG_GREEN,
		PROG_YELLOW,
		PROG_BLUE,
		APP_SWITCH,
		BUTTON_1,
		BUTTON_2,
		BUTTON_3,
		BUTTON_4,
		BUTTON_5,
		BUTTON_6,
		BUTTON_7,
		BUTTON_8,
		BUTTON_9,
		BUTTON_10,
		BUTTON_11,
		BUTTON_12,
		BUTTON_13,
		BUTTON_14,
		BUTTON_15,
		BUTTON_16,

		COUNT,

		UNKNOWN = COUNT
	};

	enum KeyMod
	{
		// clang-format off
		NONE = 0x0000,

		LSHIFT = 0x0001,
		RSHIFT = 0x0002,
		LCTRL = 0x0040,
		RCTRL = 0x0080,
		LALT = 0x0100,
		RALT = 0x0200,
		LSUPER = 0x0400,
		RSUPER = 0x0800,
		NUM = 0x1000,
		CAPS = 0x2000,
		MODE = 0x4000,
		SYM = 0x8000,

		CTRL = (LCTRL | RCTRL),
		SHIFT = (LSHIFT | RSHIFT),
		ALT = (LALT | RALT),
		SUPER = (LSUPER | RSUPER),
		MASK = (CTRL | SHIFT | ALT | SUPER),

		COUNT
		// clang-format on
	};

}
