// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.26.0
// 	protoc        v3.12.2
// source: google/cloud/visionai/v1alpha1/warehouse.proto

package visionai

import (
	context "context"
	reflect "reflect"
	sync "sync"

	_ "google.golang.org/genproto/googleapis/api/annotations"
	longrunning "google.golang.org/genproto/googleapis/longrunning"
	status "google.golang.org/genproto/googleapis/rpc/status"
	datetime "google.golang.org/genproto/googleapis/type/datetime"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status1 "google.golang.org/grpc/status"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	anypb "google.golang.org/protobuf/types/known/anypb"
	durationpb "google.golang.org/protobuf/types/known/durationpb"
	emptypb "google.golang.org/protobuf/types/known/emptypb"
	fieldmaskpb "google.golang.org/protobuf/types/known/fieldmaskpb"
	structpb "google.golang.org/protobuf/types/known/structpb"
	timestamppb "google.golang.org/protobuf/types/known/timestamppb"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// Different types for a facet bucket.
type FacetBucketType int32

const (
	// Unspecified type.
	FacetBucketType_FACET_BUCKET_TYPE_UNSPECIFIED FacetBucketType = 0
	// Value type.
	FacetBucketType_FACET_BUCKET_TYPE_VALUE FacetBucketType = 1
	// Datetime type.
	FacetBucketType_FACET_BUCKET_TYPE_DATETIME FacetBucketType = 2
	// Fixed Range type.
	FacetBucketType_FACET_BUCKET_TYPE_FIXED_RANGE FacetBucketType = 3
	// Custom Range type.
	FacetBucketType_FACET_BUCKET_TYPE_CUSTOM_RANGE FacetBucketType = 4
)

// Enum value maps for FacetBucketType.
var (
	FacetBucketType_name = map[int32]string{
		0: "FACET_BUCKET_TYPE_UNSPECIFIED",
		1: "FACET_BUCKET_TYPE_VALUE",
		2: "FACET_BUCKET_TYPE_DATETIME",
		3: "FACET_BUCKET_TYPE_FIXED_RANGE",
		4: "FACET_BUCKET_TYPE_CUSTOM_RANGE",
	}
	FacetBucketType_value = map[string]int32{
		"FACET_BUCKET_TYPE_UNSPECIFIED":  0,
		"FACET_BUCKET_TYPE_VALUE":        1,
		"FACET_BUCKET_TYPE_DATETIME":     2,
		"FACET_BUCKET_TYPE_FIXED_RANGE":  3,
		"FACET_BUCKET_TYPE_CUSTOM_RANGE": 4,
	}
)

func (x FacetBucketType) Enum() *FacetBucketType {
	p := new(FacetBucketType)
	*p = x
	return p
}

func (x FacetBucketType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (FacetBucketType) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_visionai_v1alpha1_warehouse_proto_enumTypes[0].Descriptor()
}

func (FacetBucketType) Type() protoreflect.EnumType {
	return &file_google_cloud_visionai_v1alpha1_warehouse_proto_enumTypes[0]
}

func (x FacetBucketType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use FacetBucketType.Descriptor instead.
func (FacetBucketType) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_visionai_v1alpha1_warehouse_proto_rawDescGZIP(), []int{0}
}

// Data type of the annotation.
type DataSchemaDetails_DataType int32

const (
	// Unspecified type.
	DataSchemaDetails_DATA_TYPE_UNSPECIFIED DataSchemaDetails_DataType = 0
	// Integer type.
	// Allowed search strategies:
	//   - DataSchema.SearchStrategy.NO_SEARCH,
	//   - DataSchema.SearchStrategy.EXACT_SEARCH.
	//     Supports query by IntRangeArray.
	DataSchemaDetails_INTEGER DataSchemaDetails_DataType = 1
	// Float type.
	// Allowed search strategies:
	//   - DataSchema.SearchStrategy.NO_SEARCH,
	//   - DataSchema.SearchStrategy.EXACT_SEARCH.
	//     Supports query by FloatRangeArray.
	DataSchemaDetails_FLOAT DataSchemaDetails_DataType = 2
	// String type.
	// Allowed search strategies:
	// - DataSchema.SearchStrategy.NO_SEARCH,
	// - DataSchema.SearchStrategy.EXACT_SEARCH,
	// - DataSchema.SearchStrategy.SMART_SEARCH.
	DataSchemaDetails_STRING DataSchemaDetails_DataType = 3
	// Supported formats:
	// %Y-%m-%dT%H:%M:%E*S%E*z (absl::RFC3339_full)
	// %Y-%m-%dT%H:%M:%E*S
	// %Y-%m-%dT%H:%M%E*z
	// %Y-%m-%dT%H:%M
	// %Y-%m-%dT%H%E*z
	// %Y-%m-%dT%H
	// %Y-%m-%d%E*z
	// %Y-%m-%d
	// %Y-%m
	// %Y
	// Allowed search strategies:
	//   - DataSchema.SearchStrategy.NO_SEARCH,
	//   - DataSchema.SearchStrategy.EXACT_SEARCH.
	//     Supports query by DateTimeRangeArray.
	DataSchemaDetails_DATETIME DataSchemaDetails_DataType = 5
	// Geo coordinate type.
	// Allowed search strategies:
	//   - DataSchema.SearchStrategy.NO_SEARCH,
	//   - DataSchema.SearchStrategy.EXACT_SEARCH.
	//     Supports query by GeoLocationArray.
	DataSchemaDetails_GEO_COORDINATE DataSchemaDetails_DataType = 7
	// Type to pass any proto as available in annotations.proto. Only use
	// internally.
	// Available proto types and its corresponding search behavior:
	//   - ImageObjectDetectionPredictionResult, allows SMART_SEARCH on
	//     display_names and NO_SEARCH.
	//   - ClassificationPredictionResult, allows SMART_SEARCH on display_names
	//     and NO_SEARCH.
	//   - ImageSegmentationPredictionResult, allows NO_SEARCH.
	//   - VideoActionRecognitionPredictionResult, allows SMART_SEARCH on
	//     display_name and NO_SEARCH.
	//   - VideoObjectTrackingPredictionResult, allows SMART_SEARCH on
	//     display_name and NO_SEARCH.
	//   - VideoClassificationPredictionResult, allows SMART_SEARCH on
	//     display_name and NO_SEARCH.
	//   - OccupancyCountingPredictionResult, allows EXACT_SEARCH on
	//     stats.full_frame_count.count and NO_SEARCH.
	//   - ObjectDetectionPredictionResult, allows SMART_SEARCH on
	//     identified_boxes.entity.label_string and NO_SEARCH.
	DataSchemaDetails_PROTO_ANY DataSchemaDetails_DataType = 8
	// Boolean type.
	// Allowed search strategies:
	// - DataSchema.SearchStrategy.NO_SEARCH,
	// - DataSchema.SearchStrategy.EXACT_SEARCH.
	DataSchemaDetails_BOOLEAN DataSchemaDetails_DataType = 9
)

// Enum value maps for DataSchemaDetails_DataType.
var (
	DataSchemaDetails_DataType_name = map[int32]string{
		0: "DATA_TYPE_UNSPECIFIED",
		1: "INTEGER",
		2: "FLOAT",
		3: "STRING",
		5: "DATETIME",
		7: "GEO_COORDINATE",
		8: "PROTO_ANY",
		9: "BOOLEAN",
	}
	DataSchemaDetails_DataType_value = map[string]int32{
		"DATA_TYPE_UNSPECIFIED": 0,
		"INTEGER":               1,
		"FLOAT":                 2,
		"STRING":                3,
		"DATETIME":              5,
		"GEO_COORDINATE":        7,
		"PROTO_ANY":             8,
		"BOOLEAN":               9,
	}
)

func (x DataSchemaDetails_DataType) Enum() *DataSchemaDetails_DataType {
	p := new(DataSchemaDetails_DataType)
	*p = x
	return p
}

func (x DataSchemaDetails_DataType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (DataSchemaDetails_DataType) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_visionai_v1alpha1_warehouse_proto_enumTypes[1].Descriptor()
}

func (DataSchemaDetails_DataType) Type() protoreflect.EnumType {
	return &file_google_cloud_visionai_v1alpha1_warehouse_proto_enumTypes[1]
}

func (x DataSchemaDetails_DataType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use DataSchemaDetails_DataType.Descriptor instead.
func (DataSchemaDetails_DataType) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_visionai_v1alpha1_warehouse_proto_rawDescGZIP(), []int{16, 0}
}

// The granularity of annotations under this DataSchema.
type DataSchemaDetails_Granularity int32

const (
	// Unspecified granularity.
	DataSchemaDetails_GRANULARITY_UNSPECIFIED DataSchemaDetails_Granularity = 0
	// Asset-level granularity (annotations must not contain partition info).
	DataSchemaDetails_GRANULARITY_ASSET_LEVEL DataSchemaDetails_Granularity = 1
	// Partition-level granularity (annotations must contain partition info).
	DataSchemaDetails_GRANULARITY_PARTITION_LEVEL DataSchemaDetails_Granularity = 2
)

// Enum value maps for DataSchemaDetails_Granularity.
var (
	DataSchemaDetails_Granularity_name = map[int32]string{
		0: "GRANULARITY_UNSPECIFIED",
		1: "GRANULARITY_ASSET_LEVEL",
		2: "GRANULARITY_PARTITION_LEVEL",
	}
	DataSchemaDetails_Granularity_value = map[string]int32{
		"GRANULARITY_UNSPECIFIED":     0,
		"GRANULARITY_ASSET_LEVEL":     1,
		"GRANULARITY_PARTITION_LEVEL": 2,
	}
)

func (x DataSchemaDetails_Granularity) Enum() *DataSchemaDetails_Granularity {
	p := new(DataSchemaDetails_Granularity)
	*p = x
	return p
}

func (x DataSchemaDetails_Granularity) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (DataSchemaDetails_Granularity) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_visionai_v1alpha1_warehouse_proto_enumTypes[2].Descriptor()
}

func (DataSchemaDetails_Granularity) Type() protoreflect.EnumType {
	return &file_google_cloud_visionai_v1alpha1_warehouse_proto_enumTypes[2]
}

func (x DataSchemaDetails_Granularity) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use DataSchemaDetails_Granularity.Descriptor instead.
func (DataSchemaDetails_Granularity) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_visionai_v1alpha1_warehouse_proto_rawDescGZIP(), []int{16, 1}
}

// The types of search strategies to be applied on the annotation key.
type DataSchemaDetails_SearchStrategy_SearchStrategyType int32

const (
	// Annotatation values of the `key` above will not be searchable.
	DataSchemaDetails_SearchStrategy_NO_SEARCH DataSchemaDetails_SearchStrategy_SearchStrategyType = 0
	// When searching with `key`, the value must be exactly as the annotation
	// value that has been ingested.
	DataSchemaDetails_SearchStrategy_EXACT_SEARCH DataSchemaDetails_SearchStrategy_SearchStrategyType = 1
	// When searching with `key`, Warehouse will perform broad search based on
	// semantic of the annotation value.
	DataSchemaDetails_SearchStrategy_SMART_SEARCH DataSchemaDetails_SearchStrategy_SearchStrategyType = 2
)

// Enum value maps for DataSchemaDetails_SearchStrategy_SearchStrategyType.
var (
	DataSchemaDetails_SearchStrategy_SearchStrategyType_name = map[int32]string{
		0: "NO_SEARCH",
		1: "EXACT_SEARCH",
		2: "SMART_SEARCH",
	}
	DataSchemaDetails_SearchStrategy_SearchStrategyType_value = map[string]int32{
		"NO_SEARCH":    0,
		"EXACT_SEARCH": 1,
		"SMART_SEARCH": 2,
	}
)

func (x DataSchemaDetails_SearchStrategy_SearchStrategyType) Enum() *DataSchemaDetails_SearchStrategy_SearchStrategyType {
	p := new(DataSchemaDetails_SearchStrategy_SearchStrategyType)
	*p = x
	return p
}

func (x DataSchemaDetails_SearchStrategy_SearchStrategyType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (DataSchemaDetails_SearchStrategy_SearchStrategyType) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_visionai_v1alpha1_warehouse_proto_enumTypes[3].Descriptor()
}

func (DataSchemaDetails_SearchStrategy_SearchStrategyType) Type() protoreflect.EnumType {
	return &file_google_cloud_visionai_v1alpha1_warehouse_proto_enumTypes[3]
}

func (x DataSchemaDetails_SearchStrategy_SearchStrategyType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use DataSchemaDetails_SearchStrategy_SearchStrategyType.Descriptor instead.
func (DataSchemaDetails_SearchStrategy_SearchStrategyType) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_visionai_v1alpha1_warehouse_proto_rawDescGZIP(), []int{16, 1, 0}
}

// Granularity enum for the datetime bucket.
type FacetProperty_DateTimeBucketSpec_Granularity int32

const (
	// Unspecified granularity.
	FacetProperty_DateTimeBucketSpec_GRANULARITY_UNSPECIFIED FacetProperty_DateTimeBucketSpec_Granularity = 0
	// Granularity is year.
	FacetProperty_DateTimeBucketSpec_YEAR FacetProperty_DateTimeBucketSpec_Granularity = 1
	// Granularity is month.
	FacetProperty_DateTimeBucketSpec_MONTH FacetProperty_DateTimeBucketSpec_Granularity = 2
	// Granularity is day.
	FacetProperty_DateTimeBucketSpec_DAY FacetProperty_DateTimeBucketSpec_Granularity = 3
)

// Enum value maps for FacetProperty_DateTimeBucketSpec_Granularity.
var (
	FacetProperty_DateTimeBucketSpec_Granularity_name = map[int32]string{
		0: "GRANULARITY_UNSPECIFIED",
		1: "YEAR",
		2: "MONTH",
		3: "DAY",
	}
	FacetProperty_DateTimeBucketSpec_Granularity_value = map[string]int32{
		"GRANULARITY_UNSPECIFIED": 0,
		"YEAR":                    1,
		"MONTH":                   2,
		"DAY":                     3,
	}
)

func (x FacetProperty_DateTimeBucketSpec_Granularity) Enum() *FacetProperty_DateTimeBucketSpec_Granularity {
	p := new(FacetProperty_DateTimeBucketSpec_Granularity)
	*p = x
	return p
}

func (x FacetProperty_DateTimeBucketSpec_Granularity) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (FacetProperty_DateTimeBucketSpec_Granularity) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_visionai_v1alpha1_warehouse_proto_enumTypes[4].Descriptor()
}

func (FacetProperty_DateTimeBucketSpec_Granularity) Type() protoreflect.EnumType {
	return &file_google_cloud_visionai_v1alpha1_warehouse_proto_enumTypes[4]
}

func (x FacetProperty_DateTimeBucketSpec_Granularity) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use FacetProperty_DateTimeBucketSpec_Granularity.Descriptor instead.
func (FacetProperty_DateTimeBucketSpec_Granularity) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_visionai_v1alpha1_warehouse_proto_rawDescGZIP(), []int{39, 2, 0}
}

// Container format of the video.
type IngestAssetRequest_Config_VideoType_ContainerFormat int32

const (
	// The default type, not supposed to be used.
	IngestAssetRequest_Config_VideoType_CONTAINER_FORMAT_UNSPECIFIED IngestAssetRequest_Config_VideoType_ContainerFormat = 0
	// Mp4 container format.
	IngestAssetRequest_Config_VideoType_CONTAINER_FORMAT_MP4 IngestAssetRequest_Config_VideoType_ContainerFormat = 1
)

// Enum value maps for IngestAssetRequest_Config_VideoType_ContainerFormat.
var (
	IngestAssetRequest_Config_VideoType_ContainerFormat_name = map[int32]string{
		0: "CONTAINER_FORMAT_UNSPECIFIED",
		1: "CONTAINER_FORMAT_MP4",
	}
	IngestAssetRequest_Config_VideoType_ContainerFormat_value = map[string]int32{
		"CONTAINER_FORMAT_UNSPECIFIED": 0,
		"CONTAINER_FORMAT_MP4":         1,
	}
)

func (x IngestAssetRequest_Config_VideoType_ContainerFormat) Enum() *IngestAssetRequest_Config_VideoType_ContainerFormat {
	p := new(IngestAssetRequest_Config_VideoType_ContainerFormat)
	*p = x
	return p
}

func (x IngestAssetRequest_Config_VideoType_ContainerFormat) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (IngestAssetRequest_Config_VideoType_ContainerFormat) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_visionai_v1alpha1_warehouse_proto_enumTypes[5].Descriptor()
}

func (IngestAssetRequest_Config_VideoType_ContainerFormat) Type() protoreflect.EnumType {
	return &file_google_cloud_visionai_v1alpha1_warehouse_proto_enumTypes[5]
}

func (x IngestAssetRequest_Config_VideoType_ContainerFormat) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use IngestAssetRequest_Config_VideoType_ContainerFormat.Descriptor instead.
func (IngestAssetRequest_Config_VideoType_ContainerFormat) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_visionai_v1alpha1_warehouse_proto_rawDescGZIP(), []int{44, 0, 0, 0}
}

// When one result has multiple values with the same key, specify
// which value is used to sort. By default, AGGREGATE_METHOD_LARGEST
// is used when results are sorted in decreasing order,
// AGGREGATE_METHOD_SMALLEST is used when results are sorted in
// incresing order.
type SchemaKeySortingStrategy_Option_AggregateMethod int32

const (
	// The unspecified aggregate method will be overwritten as mentioned
	// above.
	SchemaKeySortingStrategy_Option_AGGREGATE_METHOD_UNSPECIFIED SchemaKeySortingStrategy_Option_AggregateMethod = 0
	// Take the (lexicographical or numerical) largest value to sort.
	SchemaKeySortingStrategy_Option_AGGREGATE_METHOD_LARGEST SchemaKeySortingStrategy_Option_AggregateMethod = 1
	// Take the (lexicographical or numerical) smallest value to sort.
	SchemaKeySortingStrategy_Option_AGGREGATE_METHOD_SMALLEST SchemaKeySortingStrategy_Option_AggregateMethod = 2
)

// Enum value maps for SchemaKeySortingStrategy_Option_AggregateMethod.
var (
	SchemaKeySortingStrategy_Option_AggregateMethod_name = map[int32]string{
		0: "AGGREGATE_METHOD_UNSPECIFIED",
		1: "AGGREGATE_METHOD_LARGEST",
		2: "AGGREGATE_METHOD_SMALLEST",
	}
	SchemaKeySortingStrategy_Option_AggregateMethod_value = map[string]int32{
		"AGGREGATE_METHOD_UNSPECIFIED": 0,
		"AGGREGATE_METHOD_LARGEST":     1,
		"AGGREGATE_METHOD_SMALLEST":    2,
	}
)

func (x SchemaKeySortingStrategy_Option_AggregateMethod) Enum() *SchemaKeySortingStrategy_Option_AggregateMethod {
	p := new(SchemaKeySortingStrategy_Option_AggregateMethod)
	*p = x
	return p
}

func (x SchemaKeySortingStrategy_Option_AggregateMethod) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (SchemaKeySortingStrategy_Option_AggregateMethod) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_visionai_v1alpha1_warehouse_proto_enumTypes[6].Descriptor()
}

func (SchemaKeySortingStrategy_Option_AggregateMethod) Type() protoreflect.EnumType {
	return &file_google_cloud_visionai_v1alpha1_warehouse_proto_enumTypes[6]
}

func (x SchemaKeySortingStrategy_Option_AggregateMethod) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use SchemaKeySortingStrategy_Option_AggregateMethod.Descriptor instead.
func (SchemaKeySortingStrategy_Option_AggregateMethod) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_visionai_v1alpha1_warehouse_proto_rawDescGZIP(), []int{51, 0, 0}
}

// Request message for CreateAssetRequest.
type CreateAssetRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The parent resource where this asset will be created.
	// Format: projects/*/locations/*/corpora/*
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Required. The asset to create.
	Asset *Asset `protobuf:"bytes,2,opt,name=asset,proto3" json:"asset,omitempty"`
	// Optional. The ID to use for the asset, which will become the final component of
	// the asset's resource name if user choose to specify. Otherwise, asset id
	// will be generated by system.
	//
	// This value should be up to 63 characters, and valid characters
	// are /[a-z][0-9]-/. The first character must be a letter, the last could be
	// a letter or a number.
	AssetId *string `protobuf:"bytes,3,opt,name=asset_id,json=assetId,proto3,oneof" json:"asset_id,omitempty"`
}

func (x *CreateAssetRequest) Reset() {
	*x = CreateAssetRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_visionai_v1alpha1_warehouse_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CreateAssetRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreateAssetRequest) ProtoMessage() {}

func (x *CreateAssetRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_visionai_v1alpha1_warehouse_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CreateAssetRequest.ProtoReflect.Descriptor instead.
func (*CreateAssetRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_visionai_v1alpha1_warehouse_proto_rawDescGZIP(), []int{0}
}

func (x *CreateAssetRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *CreateAssetRequest) GetAsset() *Asset {
	if x != nil {
		return x.Asset
	}
	return nil
}

func (x *CreateAssetRequest) GetAssetId() string {
	if x != nil && x.AssetId != nil {
		return *x.AssetId
	}
	return ""
}

// Request message for GetAsset.
type GetAssetRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the asset to retrieve.
	// Format:
	// projects/{project_number}/locations/{location}/corpora/{corpus}/assets/{asset}
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *GetAssetRequest) Reset() {
	*x = GetAssetRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_visionai_v1alpha1_warehouse_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetAssetRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetAssetRequest) ProtoMessage() {}

func (x *GetAssetRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_visionai_v1alpha1_warehouse_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetAssetRequest.ProtoReflect.Descriptor instead.
func (*GetAssetRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_visionai_v1alpha1_warehouse_proto_rawDescGZIP(), []int{1}
}

func (x *GetAssetRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Request message for ListAssets.
type ListAssetsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The parent, which owns this collection of assets.
	// Format:
	// projects/{project_number}/locations/{location}/corpora/{corpus}
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// The maximum number of assets to return. The service may return fewer than
	// this value.
	// If unspecified, at most 50 assets will be returned.
	// The maximum value is 1000; values above 1000 will be coerced to 1000.
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// A page token, received from a previous `ListAssets` call.
	// Provide this to retrieve the subsequent page.
	//
	// When paginating, all other parameters provided to `ListAssets` must match
	// the call that provided the page token.
	PageToken string `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
}

func (x *ListAssetsRequest) Reset() {
	*x = ListAssetsRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_visionai_v1alpha1_warehouse_proto_msgTypes[2]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListAssetsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListAssetsRequest) ProtoMessage() {}

func (x *ListAssetsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_visionai_v1alpha1_warehouse_proto_msgTypes[2]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListAssetsRequest.ProtoReflect.Descriptor instead.
func (*ListAssetsRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_visionai_v1alpha1_warehouse_proto_rawDescGZIP(), []int{2}
}

func (x *ListAssetsRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *ListAssetsRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *ListAssetsRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

// Response message for ListAssets.
type ListAssetsResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The assets from the specified corpus.
	Assets []*Asset `protobuf:"bytes,1,rep,name=assets,proto3" json:"assets,omitempty"`
	// A token, which can be sent as `page_token` to retrieve the next page.
	// If this field is omitted, there are no subsequent pages.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
}

func (x *ListAssetsResponse) Reset() {
	*x = ListAssetsResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_visionai_v1alpha1_warehouse_proto_msgTypes[3]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListAssetsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListAssetsResponse) ProtoMessage() {}

func (x *ListAssetsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_visionai_v1alpha1_warehouse_proto_msgTypes[3]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListAssetsResponse.ProtoReflect.Descriptor instead.
func (*ListAssetsResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_visionai_v1alpha1_warehouse_proto_rawDescGZIP(), []int{3}
}

func (x *ListAssetsResponse) GetAssets() []*Asset {
	if x != nil {
		return x.Assets
	}
	return nil
}

func (x *ListAssetsResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

// Response message for UpdateAsset.
type UpdateAssetRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The asset to update.
	//
	// The asset's `name` field is used to identify the asset to be updated.
	// Format:
	// projects/{project_number}/locations/{location}/corpora/{corpus}/assets/{asset}
	Asset *Asset `protobuf:"bytes,1,opt,name=asset,proto3" json:"asset,omitempty"`
	// The list of fields to be updated.
	UpdateMask *fieldmaskpb.FieldMask `protobuf:"bytes,2,opt,name=update_mask,json=updateMask,proto3" json:"update_mask,omitempty"`
}

func (x *UpdateAssetRequest) Reset() {
	*x = UpdateAssetRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_visionai_v1alpha1_warehouse_proto_msgTypes[4]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *UpdateAssetRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UpdateAssetRequest) ProtoMessage() {}

func (x *UpdateAssetRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_visionai_v1alpha1_warehouse_proto_msgTypes[4]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UpdateAssetRequest.ProtoReflect.Descriptor instead.
func (*UpdateAssetRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_visionai_v1alpha1_warehouse_proto_rawDescGZIP(), []int{4}
}

func (x *UpdateAssetRequest) GetAsset() *Asset {
	if x != nil {
		return x.Asset
	}
	return nil
}

func (x *UpdateAssetRequest) GetUpdateMask() *fieldmaskpb.FieldMask {
	if x != nil {
		return x.UpdateMask
	}
	return nil
}

// Request message for DeleteAsset.
type DeleteAssetRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the asset to delete.
	// Format:
	// projects/{project_number}/locations/{location}/corpora/{corpus}/assets/{asset}
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *DeleteAssetRequest) Reset() {
	*x = DeleteAssetRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_visionai_v1alpha1_warehouse_proto_msgTypes[5]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DeleteAssetRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeleteAssetRequest) ProtoMessage() {}

func (x *DeleteAssetRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_visionai_v1alpha1_warehouse_proto_msgTypes[5]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeleteAssetRequest.ProtoReflect.Descriptor instead.
func (*DeleteAssetRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_visionai_v1alpha1_warehouse_proto_rawDescGZIP(), []int{5}
}

func (x *DeleteAssetRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// An asset is a resource in corpus. It represents a media object inside corpus,
// contains metadata and another resource annotation. Different feature could be
// applied to the asset to generate annotations. User could specified annotation
// related to the target asset.
type Asset struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Resource name of the asset.
	// Form:
	// `projects/{project_number}/locations/{location_id}/corpora/{corpus_id}/assets/{asset_id}`
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// The duration for which all media assets, associated metadata, and search
	// documents can exist. If not set, then it will using the default ttl in the
	// parent corpus resource.
	Ttl *durationpb.Duration `protobuf:"bytes,2,opt,name=ttl,proto3" json:"ttl,omitempty"`
}

func (x *Asset) Reset() {
	*x = Asset{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_visionai_v1alpha1_warehouse_proto_msgTypes[6]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Asset) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Asset) ProtoMessage() {}

func (x *Asset) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_visionai_v1alpha1_warehouse_proto_msgTypes[6]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Asset.ProtoReflect.Descriptor instead.
func (*Asset) Descriptor() ([]byte, []int) {
	return file_google_cloud_visionai_v1alpha1_warehouse_proto_rawDescGZIP(), []int{6}
}

func (x *Asset) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *Asset) GetTtl() *durationpb.Duration {
	if x != nil {
		return x.Ttl
	}
	return nil
}

// Request message of CreateCorpus API.
type CreateCorpusRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Form: `projects/{project_number}/locations/{location_id}`
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Required. The corpus to be created.
	Corpus *Corpus `protobuf:"bytes,2,opt,name=corpus,proto3" json:"corpus,omitempty"`
}

func (x *CreateCorpusRequest) Reset() {
	*x = CreateCorpusRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_visionai_v1alpha1_warehouse_proto_msgTypes[7]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CreateCorpusRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreateCorpusRequest) ProtoMessage() {}

func (x *CreateCorpusRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_visionai_v1alpha1_warehouse_proto_msgTypes[7]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CreateCorpusRequest.ProtoReflect.Descriptor instead.
func (*CreateCorpusRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_visionai_v1alpha1_warehouse_proto_rawDescGZIP(), []int{7}
}

func (x *CreateCorpusRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *CreateCorpusRequest) GetCorpus() *Corpus {
	if x != nil {
		return x.Corpus
	}
	return nil
}

// Corpus is a set of video contents for management. Within a corpus, videos
// share the same data schema. Search is also restricted within a single corpus.
type Corpus struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Resource name of the corpus.
	// Form:
	// `projects/{project_number}/locations/{location_id}/corpora/{corpus_id}`
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Required. The corpus name to shown in the UI. The name can be up to 32 characters
	// long.
	DisplayName string `protobuf:"bytes,2,opt,name=display_name,json=displayName,proto3" json:"display_name,omitempty"`
	// Optional. Description of the corpus. Can be up to 25000 characters long.
	Description string `protobuf:"bytes,3,opt,name=description,proto3" json:"description,omitempty"`
	// Required. The default TTL value for all assets under the corpus without a asset level
	// user-defined TTL with a maximum of 10 years. This is required for all
	// corpora.
	DefaultTtl *durationpb.Duration `protobuf:"bytes,5,opt,name=default_ttl,json=defaultTtl,proto3" json:"default_ttl,omitempty"`
}

func (x *Corpus) Reset() {
	*x = Corpus{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_visionai_v1alpha1_warehouse_proto_msgTypes[8]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Corpus) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Corpus) ProtoMessage() {}

func (x *Corpus) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_visionai_v1alpha1_warehouse_proto_msgTypes[8]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Corpus.ProtoReflect.Descriptor instead.
func (*Corpus) Descriptor() ([]byte, []int) {
	return file_google_cloud_visionai_v1alpha1_warehouse_proto_rawDescGZIP(), []int{8}
}

func (x *Corpus) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *Corpus) GetDisplayName() string {
	if x != nil {
		return x.DisplayName
	}
	return ""
}

func (x *Corpus) GetDescription() string {
	if x != nil {
		return x.Description
	}
	return ""
}

func (x *Corpus) GetDefaultTtl() *durationpb.Duration {
	if x != nil {
		return x.DefaultTtl
	}
	return nil
}

// Request message for GetCorpus.
type GetCorpusRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The resource name of the corpus to retrieve.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *GetCorpusRequest) Reset() {
	*x = GetCorpusRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_visionai_v1alpha1_warehouse_proto_msgTypes[9]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetCorpusRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetCorpusRequest) ProtoMessage() {}

func (x *GetCorpusRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_visionai_v1alpha1_warehouse_proto_msgTypes[9]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetCorpusRequest.ProtoReflect.Descriptor instead.
func (*GetCorpusRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_visionai_v1alpha1_warehouse_proto_rawDescGZIP(), []int{9}
}

func (x *GetCorpusRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Request message for UpdateCorpus.
type UpdateCorpusRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The corpus which replaces the resource on the server.
	Corpus *Corpus `protobuf:"bytes,1,opt,name=corpus,proto3" json:"corpus,omitempty"`
	// The list of fields to be updated.
	UpdateMask *fieldmaskpb.FieldMask `protobuf:"bytes,2,opt,name=update_mask,json=updateMask,proto3" json:"update_mask,omitempty"`
}

func (x *UpdateCorpusRequest) Reset() {
	*x = UpdateCorpusRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_visionai_v1alpha1_warehouse_proto_msgTypes[10]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *UpdateCorpusRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UpdateCorpusRequest) ProtoMessage() {}

func (x *UpdateCorpusRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_visionai_v1alpha1_warehouse_proto_msgTypes[10]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UpdateCorpusRequest.ProtoReflect.Descriptor instead.
func (*UpdateCorpusRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_visionai_v1alpha1_warehouse_proto_rawDescGZIP(), []int{10}
}

func (x *UpdateCorpusRequest) GetCorpus() *Corpus {
	if x != nil {
		return x.Corpus
	}
	return nil
}

func (x *UpdateCorpusRequest) GetUpdateMask() *fieldmaskpb.FieldMask {
	if x != nil {
		return x.UpdateMask
	}
	return nil
}

// Request message for ListCorpora.
type ListCorporaRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The resource name of the project from which to list corpora.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Requested page size. API may return fewer results than requested.
	// If negative, INVALID_ARGUMENT error will be returned.
	// If unspecified or 0, API will pick a default size, which is 10.
	// If the requested page size is larger than the maximum size, API will pick
	// use the maximum size, which is 20.
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// A token identifying a page of results for the server to return.
	// Typically obtained via [ListCorpora.next_page_token][] of the previous
	// [Warehouse.ListCorpora][google.cloud.visionai.v1alpha1.Warehouse.ListCorpora] call.
	PageToken string `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
}

func (x *ListCorporaRequest) Reset() {
	*x = ListCorporaRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_visionai_v1alpha1_warehouse_proto_msgTypes[11]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListCorporaRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListCorporaRequest) ProtoMessage() {}

func (x *ListCorporaRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_visionai_v1alpha1_warehouse_proto_msgTypes[11]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListCorporaRequest.ProtoReflect.Descriptor instead.
func (*ListCorporaRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_visionai_v1alpha1_warehouse_proto_rawDescGZIP(), []int{11}
}

func (x *ListCorporaRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *ListCorporaRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *ListCorporaRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

// Response message for ListCorpora.
type ListCorporaResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The corpora in the project.
	Corpora []*Corpus `protobuf:"bytes,1,rep,name=corpora,proto3" json:"corpora,omitempty"`
	// A token to retrieve next page of results.
	// Pass to [ListCorporaRequest.page_token][google.cloud.visionai.v1alpha1.ListCorporaRequest.page_token] to obtain that page.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
}

func (x *ListCorporaResponse) Reset() {
	*x = ListCorporaResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_visionai_v1alpha1_warehouse_proto_msgTypes[12]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListCorporaResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListCorporaResponse) ProtoMessage() {}

func (x *ListCorporaResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_visionai_v1alpha1_warehouse_proto_msgTypes[12]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListCorporaResponse.ProtoReflect.Descriptor instead.
func (*ListCorporaResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_visionai_v1alpha1_warehouse_proto_rawDescGZIP(), []int{12}
}

func (x *ListCorporaResponse) GetCorpora() []*Corpus {
	if x != nil {
		return x.Corpora
	}
	return nil
}

func (x *ListCorporaResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

// Request message for DeleteCorpus.
type DeleteCorpusRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The resource name of the corpus to delete.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *DeleteCorpusRequest) Reset() {
	*x = DeleteCorpusRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_visionai_v1alpha1_warehouse_proto_msgTypes[13]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DeleteCorpusRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeleteCorpusRequest) ProtoMessage() {}

func (x *DeleteCorpusRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_visionai_v1alpha1_warehouse_proto_msgTypes[13]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeleteCorpusRequest.ProtoReflect.Descriptor instead.
func (*DeleteCorpusRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_visionai_v1alpha1_warehouse_proto_rawDescGZIP(), []int{13}
}

func (x *DeleteCorpusRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Request message for CreateDataSchema.
type CreateDataSchemaRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The parent resource where this data schema will be created.
	// Format: projects/*/locations/*/corpora/*
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Required. The data schema to create.
	DataSchema *DataSchema `protobuf:"bytes,2,opt,name=data_schema,json=dataSchema,proto3" json:"data_schema,omitempty"`
}

func (x *CreateDataSchemaRequest) Reset() {
	*x = CreateDataSchemaRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_visionai_v1alpha1_warehouse_proto_msgTypes[14]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CreateDataSchemaRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreateDataSchemaRequest) ProtoMessage() {}

func (x *CreateDataSchemaRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_visionai_v1alpha1_warehouse_proto_msgTypes[14]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CreateDataSchemaRequest.ProtoReflect.Descriptor instead.
func (*CreateDataSchemaRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_visionai_v1alpha1_warehouse_proto_rawDescGZIP(), []int{14}
}

func (x *CreateDataSchemaRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *CreateDataSchemaRequest) GetDataSchema() *DataSchema {
	if x != nil {
		return x.DataSchema
	}
	return nil
}

// Data schema indicates how the user specified annotation is interpreted in the
// system.
type DataSchema struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Resource name of the data schema in the form of:
	// `projects/{project_number}/locations/{location}/corpora/{corpus}/dataSchemas/{data_schema}`
	// where {data_schema} part should be the same as the `key` field below.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Required. The key of this data schema. This key should be matching the key of user
	// specified annotation and unique inside corpus. This value can be up to
	// 63 characters, and valid characters are /[a-z][0-9]-/. The first character
	// must be a letter, the last could be a letter or a number.
	Key string `protobuf:"bytes,2,opt,name=key,proto3" json:"key,omitempty"`
	// The schema details mapping to the key.
	SchemaDetails *DataSchemaDetails `protobuf:"bytes,3,opt,name=schema_details,json=schemaDetails,proto3" json:"schema_details,omitempty"`
}

func (x *DataSchema) Reset() {
	*x = DataSchema{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_visionai_v1alpha1_warehouse_proto_msgTypes[15]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DataSchema) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DataSchema) ProtoMessage() {}

func (x *DataSchema) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_visionai_v1alpha1_warehouse_proto_msgTypes[15]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DataSchema.ProtoReflect.Descriptor instead.
func (*DataSchema) Descriptor() ([]byte, []int) {
	return file_google_cloud_visionai_v1alpha1_warehouse_proto_rawDescGZIP(), []int{15}
}

func (x *DataSchema) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *DataSchema) GetKey() string {
	if x != nil {
		return x.Key
	}
	return ""
}

func (x *DataSchema) GetSchemaDetails() *DataSchemaDetails {
	if x != nil {
		return x.SchemaDetails
	}
	return nil
}

// Data schema details indicates the data type and the data struct corresponding
// to the key of user specified annotation.
type DataSchemaDetails struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Type of the annotation.
	Type DataSchemaDetails_DataType `protobuf:"varint,1,opt,name=type,proto3,enum=google.cloud.visionai.v1alpha1.DataSchemaDetails_DataType" json:"type,omitempty"`
	// Config for protobuf any type.
	ProtoAnyConfig *DataSchemaDetails_ProtoAnyConfig `protobuf:"bytes,6,opt,name=proto_any_config,json=protoAnyConfig,proto3" json:"proto_any_config,omitempty"`
	// The granularity associated with this DataSchema.
	Granularity DataSchemaDetails_Granularity `protobuf:"varint,5,opt,name=granularity,proto3,enum=google.cloud.visionai.v1alpha1.DataSchemaDetails_Granularity" json:"granularity,omitempty"`
	// The search strategy to be applied on the `key` above.
	SearchStrategy *DataSchemaDetails_SearchStrategy `protobuf:"bytes,7,opt,name=search_strategy,json=searchStrategy,proto3" json:"search_strategy,omitempty"`
}

func (x *DataSchemaDetails) Reset() {
	*x = DataSchemaDetails{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_visionai_v1alpha1_warehouse_proto_msgTypes[16]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DataSchemaDetails) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DataSchemaDetails) ProtoMessage() {}

func (x *DataSchemaDetails) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_visionai_v1alpha1_warehouse_proto_msgTypes[16]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DataSchemaDetails.ProtoReflect.Descriptor instead.
func (*DataSchemaDetails) Descriptor() ([]byte, []int) {
	return file_google_cloud_visionai_v1alpha1_warehouse_proto_rawDescGZIP(), []int{16}
}

func (x *DataSchemaDetails) GetType() DataSchemaDetails_DataType {
	if x != nil {
		return x.Type
	}
	return DataSchemaDetails_DATA_TYPE_UNSPECIFIED
}

func (x *DataSchemaDetails) GetProtoAnyConfig() *DataSchemaDetails_ProtoAnyConfig {
	if x != nil {
		return x.ProtoAnyConfig
	}
	return nil
}

func (x *DataSchemaDetails) GetGranularity() DataSchemaDetails_Granularity {
	if x != nil {
		return x.Granularity
	}
	return DataSchemaDetails_GRANULARITY_UNSPECIFIED
}

func (x *DataSchemaDetails) GetSearchStrategy() *DataSchemaDetails_SearchStrategy {
	if x != nil {
		return x.SearchStrategy
	}
	return nil
}

// Request message for UpdateDataSchema.
type UpdateDataSchemaRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The data schema's `name` field is used to identify the data schema to be
	// updated. Format:
	// projects/{project_number}/locations/{location}/corpora/{corpus}/dataSchemas/{data_schema}
	DataSchema *DataSchema `protobuf:"bytes,1,opt,name=data_schema,json=dataSchema,proto3" json:"data_schema,omitempty"`
	// The list of fields to be updated.
	UpdateMask *fieldmaskpb.FieldMask `protobuf:"bytes,2,opt,name=update_mask,json=updateMask,proto3" json:"update_mask,omitempty"`
}

func (x *UpdateDataSchemaRequest) Reset() {
	*x = UpdateDataSchemaRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_visionai_v1alpha1_warehouse_proto_msgTypes[17]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *UpdateDataSchemaRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UpdateDataSchemaRequest) ProtoMessage() {}

func (x *UpdateDataSchemaRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_visionai_v1alpha1_warehouse_proto_msgTypes[17]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UpdateDataSchemaRequest.ProtoReflect.Descriptor instead.
func (*UpdateDataSchemaRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_visionai_v1alpha1_warehouse_proto_rawDescGZIP(), []int{17}
}

func (x *UpdateDataSchemaRequest) GetDataSchema() *DataSchema {
	if x != nil {
		return x.DataSchema
	}
	return nil
}

func (x *UpdateDataSchemaRequest) GetUpdateMask() *fieldmaskpb.FieldMask {
	if x != nil {
		return x.UpdateMask
	}
	return nil
}

// Request message for GetDataSchema.
type GetDataSchemaRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the data schema to retrieve.
	// Format:
	// projects/{project_number}/locations/{location_id}/corpora/{corpus_id}/dataSchemas/{data_schema_id}
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *GetDataSchemaRequest) Reset() {
	*x = GetDataSchemaRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_visionai_v1alpha1_warehouse_proto_msgTypes[18]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetDataSchemaRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetDataSchemaRequest) ProtoMessage() {}

func (x *GetDataSchemaRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_visionai_v1alpha1_warehouse_proto_msgTypes[18]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetDataSchemaRequest.ProtoReflect.Descriptor instead.
func (*GetDataSchemaRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_visionai_v1alpha1_warehouse_proto_rawDescGZIP(), []int{18}
}

func (x *GetDataSchemaRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Request message for DeleteDataSchema.
type DeleteDataSchemaRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the data schema to delete.
	// Format:
	// projects/{project_number}/locations/{location_id}/corpora/{corpus_id}/dataSchemas/{data_schema_id}
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *DeleteDataSchemaRequest) Reset() {
	*x = DeleteDataSchemaRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_visionai_v1alpha1_warehouse_proto_msgTypes[19]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DeleteDataSchemaRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeleteDataSchemaRequest) ProtoMessage() {}

func (x *DeleteDataSchemaRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_visionai_v1alpha1_warehouse_proto_msgTypes[19]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeleteDataSchemaRequest.ProtoReflect.Descriptor instead.
func (*DeleteDataSchemaRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_visionai_v1alpha1_warehouse_proto_rawDescGZIP(), []int{19}
}

func (x *DeleteDataSchemaRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Request message for ListDataSchemas.
type ListDataSchemasRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The parent, which owns this collection of data schemas.
	// Format:
	// projects/{project_number}/locations/{location_id}/corpora/{corpus_id}
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// The maximum number of data schemas to return. The service may return fewer
	// than this value. If unspecified, at most 50 data schemas will be returned.
	// The maximum value is 1000; values above 1000 will be coerced to 1000.
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// A page token, received from a previous `ListDataSchemas` call.
	// Provide this to retrieve the subsequent page.
	//
	// When paginating, all other parameters provided to `ListDataSchemas` must
	// match the call that provided the page token.
	PageToken string `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
}

func (x *ListDataSchemasRequest) Reset() {
	*x = ListDataSchemasRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_visionai_v1alpha1_warehouse_proto_msgTypes[20]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListDataSchemasRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListDataSchemasRequest) ProtoMessage() {}

func (x *ListDataSchemasRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_visionai_v1alpha1_warehouse_proto_msgTypes[20]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListDataSchemasRequest.ProtoReflect.Descriptor instead.
func (*ListDataSchemasRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_visionai_v1alpha1_warehouse_proto_rawDescGZIP(), []int{20}
}

func (x *ListDataSchemasRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *ListDataSchemasRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *ListDataSchemasRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

// Response message for ListDataSchemas.
type ListDataSchemasResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The data schemas from the specified corpus.
	DataSchemas []*DataSchema `protobuf:"bytes,1,rep,name=data_schemas,json=dataSchemas,proto3" json:"data_schemas,omitempty"`
	// A token, which can be sent as `page_token` to retrieve the next page.
	// If this field is omitted, there are no subsequent pages.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
}

func (x *ListDataSchemasResponse) Reset() {
	*x = ListDataSchemasResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_visionai_v1alpha1_warehouse_proto_msgTypes[21]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListDataSchemasResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListDataSchemasResponse) ProtoMessage() {}

func (x *ListDataSchemasResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_visionai_v1alpha1_warehouse_proto_msgTypes[21]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListDataSchemasResponse.ProtoReflect.Descriptor instead.
func (*ListDataSchemasResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_visionai_v1alpha1_warehouse_proto_rawDescGZIP(), []int{21}
}

func (x *ListDataSchemasResponse) GetDataSchemas() []*DataSchema {
	if x != nil {
		return x.DataSchemas
	}
	return nil
}

func (x *ListDataSchemasResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

// Request message for CreateAnnotation.
type CreateAnnotationRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The parent resource where this annotation will be created.
	// Format: projects/*/locations/*/corpora/*/assets/*
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Required. The annotation to create.
	Annotation *Annotation `protobuf:"bytes,2,opt,name=annotation,proto3" json:"annotation,omitempty"`
	// Optional. The ID to use for the annotation, which will become the final component of
	// the annotation's resource name if user choose to specify. Otherwise,
	// annotation id will be generated by system.
	//
	// This value should be up to 63 characters, and valid characters
	// are /[a-z][0-9]-/. The first character must be a letter, the last could be
	// a letter or a number.
	AnnotationId *string `protobuf:"bytes,3,opt,name=annotation_id,json=annotationId,proto3,oneof" json:"annotation_id,omitempty"`
}

func (x *CreateAnnotationRequest) Reset() {
	*x = CreateAnnotationRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_visionai_v1alpha1_warehouse_proto_msgTypes[22]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CreateAnnotationRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreateAnnotationRequest) ProtoMessage() {}

func (x *CreateAnnotationRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_visionai_v1alpha1_warehouse_proto_msgTypes[22]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CreateAnnotationRequest.ProtoReflect.Descriptor instead.
func (*CreateAnnotationRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_visionai_v1alpha1_warehouse_proto_rawDescGZIP(), []int{22}
}

func (x *CreateAnnotationRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *CreateAnnotationRequest) GetAnnotation() *Annotation {
	if x != nil {
		return x.Annotation
	}
	return nil
}

func (x *CreateAnnotationRequest) GetAnnotationId() string {
	if x != nil && x.AnnotationId != nil {
		return *x.AnnotationId
	}
	return ""
}

// An annotation is a resource in asset. It represents a key-value mapping of
// content in asset.
type Annotation struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Resource name of the annotation.
	// Form:
	// `projects/{project_number}/locations/{location}/corpora/{corpus}/assets/{asset}/annotations/{annotation}`
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// User provided annotation.
	UserSpecifiedAnnotation *UserSpecifiedAnnotation `protobuf:"bytes,2,opt,name=user_specified_annotation,json=userSpecifiedAnnotation,proto3" json:"user_specified_annotation,omitempty"`
}

func (x *Annotation) Reset() {
	*x = Annotation{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_visionai_v1alpha1_warehouse_proto_msgTypes[23]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Annotation) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Annotation) ProtoMessage() {}

func (x *Annotation) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_visionai_v1alpha1_warehouse_proto_msgTypes[23]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Annotation.ProtoReflect.Descriptor instead.
func (*Annotation) Descriptor() ([]byte, []int) {
	return file_google_cloud_visionai_v1alpha1_warehouse_proto_rawDescGZIP(), []int{23}
}

func (x *Annotation) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *Annotation) GetUserSpecifiedAnnotation() *UserSpecifiedAnnotation {
	if x != nil {
		return x.UserSpecifiedAnnotation
	}
	return nil
}

// Annotation provided by users.
type UserSpecifiedAnnotation struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Key of the annotation. The key must be set with type by CreateDataSchema.
	Key string `protobuf:"bytes,1,opt,name=key,proto3" json:"key,omitempty"`
	// Value of the annotation. The value must be able to convert
	// to the type according to the data schema.
	Value *AnnotationValue `protobuf:"bytes,2,opt,name=value,proto3" json:"value,omitempty"`
	// Partition information in time and space for the sub-asset level annotation.
	Partition *Partition `protobuf:"bytes,3,opt,name=partition,proto3" json:"partition,omitempty"`
}

func (x *UserSpecifiedAnnotation) Reset() {
	*x = UserSpecifiedAnnotation{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_visionai_v1alpha1_warehouse_proto_msgTypes[24]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *UserSpecifiedAnnotation) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UserSpecifiedAnnotation) ProtoMessage() {}

func (x *UserSpecifiedAnnotation) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_visionai_v1alpha1_warehouse_proto_msgTypes[24]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UserSpecifiedAnnotation.ProtoReflect.Descriptor instead.
func (*UserSpecifiedAnnotation) Descriptor() ([]byte, []int) {
	return file_google_cloud_visionai_v1alpha1_warehouse_proto_rawDescGZIP(), []int{24}
}

func (x *UserSpecifiedAnnotation) GetKey() string {
	if x != nil {
		return x.Key
	}
	return ""
}

func (x *UserSpecifiedAnnotation) GetValue() *AnnotationValue {
	if x != nil {
		return x.Value
	}
	return nil
}

func (x *UserSpecifiedAnnotation) GetPartition() *Partition {
	if x != nil {
		return x.Partition
	}
	return nil
}

// Location Coordinate Representation
type GeoCoordinate struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Latitude Coordinate. Degrees [-90 .. 90]
	Latitude float64 `protobuf:"fixed64,1,opt,name=latitude,proto3" json:"latitude,omitempty"`
	// Longitude Coordinate. Degrees [-180 .. 180]
	Longitude float64 `protobuf:"fixed64,2,opt,name=longitude,proto3" json:"longitude,omitempty"`
}

func (x *GeoCoordinate) Reset() {
	*x = GeoCoordinate{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_visionai_v1alpha1_warehouse_proto_msgTypes[25]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GeoCoordinate) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GeoCoordinate) ProtoMessage() {}

func (x *GeoCoordinate) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_visionai_v1alpha1_warehouse_proto_msgTypes[25]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GeoCoordinate.ProtoReflect.Descriptor instead.
func (*GeoCoordinate) Descriptor() ([]byte, []int) {
	return file_google_cloud_visionai_v1alpha1_warehouse_proto_rawDescGZIP(), []int{25}
}

func (x *GeoCoordinate) GetLatitude() float64 {
	if x != nil {
		return x.Latitude
	}
	return 0
}

func (x *GeoCoordinate) GetLongitude() float64 {
	if x != nil {
		return x.Longitude
	}
	return 0
}

// Value of annotation, including all types available in data schema.
type AnnotationValue struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Types that are assignable to Value:
	//
	//	*AnnotationValue_IntValue
	//	*AnnotationValue_FloatValue
	//	*AnnotationValue_StrValue
	//	*AnnotationValue_DatetimeValue
	//	*AnnotationValue_GeoCoordinate
	//	*AnnotationValue_ProtoAnyValue
	//	*AnnotationValue_BoolValue
	//	*AnnotationValue_CustomizedStructDataValue
	Value isAnnotationValue_Value `protobuf_oneof:"value"`
}

func (x *AnnotationValue) Reset() {
	*x = AnnotationValue{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_visionai_v1alpha1_warehouse_proto_msgTypes[26]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AnnotationValue) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AnnotationValue) ProtoMessage() {}

func (x *AnnotationValue) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_visionai_v1alpha1_warehouse_proto_msgTypes[26]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AnnotationValue.ProtoReflect.Descriptor instead.
func (*AnnotationValue) Descriptor() ([]byte, []int) {
	return file_google_cloud_visionai_v1alpha1_warehouse_proto_rawDescGZIP(), []int{26}
}

func (m *AnnotationValue) GetValue() isAnnotationValue_Value {
	if m != nil {
		return m.Value
	}
	return nil
}

func (x *AnnotationValue) GetIntValue() int64 {
	if x, ok := x.GetValue().(*AnnotationValue_IntValue); ok {
		return x.IntValue
	}
	return 0
}

func (x *AnnotationValue) GetFloatValue() float32 {
	if x, ok := x.GetValue().(*AnnotationValue_FloatValue); ok {
		return x.FloatValue
	}
	return 0
}

func (x *AnnotationValue) GetStrValue() string {
	if x, ok := x.GetValue().(*AnnotationValue_StrValue); ok {
		return x.StrValue
	}
	return ""
}

func (x *AnnotationValue) GetDatetimeValue() string {
	if x, ok := x.GetValue().(*AnnotationValue_DatetimeValue); ok {
		return x.DatetimeValue
	}
	return ""
}

func (x *AnnotationValue) GetGeoCoordinate() *GeoCoordinate {
	if x, ok := x.GetValue().(*AnnotationValue_GeoCoordinate); ok {
		return x.GeoCoordinate
	}
	return nil
}

func (x *AnnotationValue) GetProtoAnyValue() *anypb.Any {
	if x, ok := x.GetValue().(*AnnotationValue_ProtoAnyValue); ok {
		return x.ProtoAnyValue
	}
	return nil
}

func (x *AnnotationValue) GetBoolValue() bool {
	if x, ok := x.GetValue().(*AnnotationValue_BoolValue); ok {
		return x.BoolValue
	}
	return false
}

func (x *AnnotationValue) GetCustomizedStructDataValue() *structpb.Struct {
	if x, ok := x.GetValue().(*AnnotationValue_CustomizedStructDataValue); ok {
		return x.CustomizedStructDataValue
	}
	return nil
}

type isAnnotationValue_Value interface {
	isAnnotationValue_Value()
}

type AnnotationValue_IntValue struct {
	// Value of int type annotation.
	IntValue int64 `protobuf:"varint,1,opt,name=int_value,json=intValue,proto3,oneof"`
}

type AnnotationValue_FloatValue struct {
	// Value of float type annotation.
	FloatValue float32 `protobuf:"fixed32,2,opt,name=float_value,json=floatValue,proto3,oneof"`
}

type AnnotationValue_StrValue struct {
	// Value of string type annotation.
	StrValue string `protobuf:"bytes,3,opt,name=str_value,json=strValue,proto3,oneof"`
}

type AnnotationValue_DatetimeValue struct {
	// Value of date time type annotation.
	DatetimeValue string `protobuf:"bytes,5,opt,name=datetime_value,json=datetimeValue,proto3,oneof"`
}

type AnnotationValue_GeoCoordinate struct {
	// Value of geo coordinate type annotation.
	GeoCoordinate *GeoCoordinate `protobuf:"bytes,7,opt,name=geo_coordinate,json=geoCoordinate,proto3,oneof"`
}

type AnnotationValue_ProtoAnyValue struct {
	// Value of any proto value.
	ProtoAnyValue *anypb.Any `protobuf:"bytes,8,opt,name=proto_any_value,json=protoAnyValue,proto3,oneof"`
}

type AnnotationValue_BoolValue struct {
	// Value of boolean type annotation.
	BoolValue bool `protobuf:"varint,9,opt,name=bool_value,json=boolValue,proto3,oneof"`
}

type AnnotationValue_CustomizedStructDataValue struct {
	// Value of customized struct annotation.
	CustomizedStructDataValue *structpb.Struct `protobuf:"bytes,10,opt,name=customized_struct_data_value,json=customizedStructDataValue,proto3,oneof"`
}

func (*AnnotationValue_IntValue) isAnnotationValue_Value() {}

func (*AnnotationValue_FloatValue) isAnnotationValue_Value() {}

func (*AnnotationValue_StrValue) isAnnotationValue_Value() {}

func (*AnnotationValue_DatetimeValue) isAnnotationValue_Value() {}

func (*AnnotationValue_GeoCoordinate) isAnnotationValue_Value() {}

func (*AnnotationValue_ProtoAnyValue) isAnnotationValue_Value() {}

func (*AnnotationValue_BoolValue) isAnnotationValue_Value() {}

func (*AnnotationValue_CustomizedStructDataValue) isAnnotationValue_Value() {}

// Request message for GetAnnotation API.
type ListAnnotationsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The parent, which owns this collection of annotations.
	// Format:
	// projects/{project_number}/locations/{location}/corpora/{corpus}/assets/{asset}
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// The maximum number of annotations to return. The service may return fewer
	// than this value. If unspecified, at most 50 annotations will be returned.
	// The maximum value is 1000; values above 1000 will be coerced to 1000.
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// A page token, received from a previous `ListAnnotations` call.
	// Provide this to retrieve the subsequent page.
	//
	// When paginating, all other parameters provided to `ListAnnotations` must
	// match the call that provided the page token.
	PageToken string `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	// The filter applied to the returned list.
	// We only support filtering for the following fields:
	// `partition.temporal_partition.start_time`,
	// `partition.temporal_partition.end_time`, and `key`.
	// Timestamps are specified in the RFC-3339 format, and only one restriction
	// may be applied per field, joined by conjunctions.
	// Format:
	// "partition.temporal_partition.start_time > "2012-04-21T11:30:00-04:00" AND
	// partition.temporal_partition.end_time < "2012-04-22T11:30:00-04:00" AND
	// key = "example_key""
	Filter string `protobuf:"bytes,4,opt,name=filter,proto3" json:"filter,omitempty"`
}

func (x *ListAnnotationsRequest) Reset() {
	*x = ListAnnotationsRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_visionai_v1alpha1_warehouse_proto_msgTypes[27]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListAnnotationsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListAnnotationsRequest) ProtoMessage() {}

func (x *ListAnnotationsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_visionai_v1alpha1_warehouse_proto_msgTypes[27]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListAnnotationsRequest.ProtoReflect.Descriptor instead.
func (*ListAnnotationsRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_visionai_v1alpha1_warehouse_proto_rawDescGZIP(), []int{27}
}

func (x *ListAnnotationsRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *ListAnnotationsRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *ListAnnotationsRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

func (x *ListAnnotationsRequest) GetFilter() string {
	if x != nil {
		return x.Filter
	}
	return ""
}

// Request message for ListAnnotations API.
type ListAnnotationsResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The annotations from the specified asset.
	Annotations []*Annotation `protobuf:"bytes,1,rep,name=annotations,proto3" json:"annotations,omitempty"`
	// A token, which can be sent as `page_token` to retrieve the next page.
	// If this field is omitted, there are no subsequent pages.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
}

func (x *ListAnnotationsResponse) Reset() {
	*x = ListAnnotationsResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_visionai_v1alpha1_warehouse_proto_msgTypes[28]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListAnnotationsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListAnnotationsResponse) ProtoMessage() {}

func (x *ListAnnotationsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_visionai_v1alpha1_warehouse_proto_msgTypes[28]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListAnnotationsResponse.ProtoReflect.Descriptor instead.
func (*ListAnnotationsResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_visionai_v1alpha1_warehouse_proto_rawDescGZIP(), []int{28}
}

func (x *ListAnnotationsResponse) GetAnnotations() []*Annotation {
	if x != nil {
		return x.Annotations
	}
	return nil
}

func (x *ListAnnotationsResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

// Request message for GetAnnotation API.
type GetAnnotationRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the annotation to retrieve.
	// Format:
	// projects/{project_number}/locations/{location}/corpora/{corpus}/assets/{asset}/annotations/{annotation}
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *GetAnnotationRequest) Reset() {
	*x = GetAnnotationRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_visionai_v1alpha1_warehouse_proto_msgTypes[29]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetAnnotationRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetAnnotationRequest) ProtoMessage() {}

func (x *GetAnnotationRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_visionai_v1alpha1_warehouse_proto_msgTypes[29]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetAnnotationRequest.ProtoReflect.Descriptor instead.
func (*GetAnnotationRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_visionai_v1alpha1_warehouse_proto_rawDescGZIP(), []int{29}
}

func (x *GetAnnotationRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Request message for UpdateAnnotation API.
type UpdateAnnotationRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The annotation to update.
	// The annotation's `name` field is used to identify the annotation to be
	// updated. Format:
	// projects/{project_number}/locations/{location}/corpora/{corpus}/assets/{asset}/annotations/{annotation}
	Annotation *Annotation `protobuf:"bytes,1,opt,name=annotation,proto3" json:"annotation,omitempty"`
	// The list of fields to be updated.
	UpdateMask *fieldmaskpb.FieldMask `protobuf:"bytes,2,opt,name=update_mask,json=updateMask,proto3" json:"update_mask,omitempty"`
}

func (x *UpdateAnnotationRequest) Reset() {
	*x = UpdateAnnotationRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_visionai_v1alpha1_warehouse_proto_msgTypes[30]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *UpdateAnnotationRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UpdateAnnotationRequest) ProtoMessage() {}

func (x *UpdateAnnotationRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_visionai_v1alpha1_warehouse_proto_msgTypes[30]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UpdateAnnotationRequest.ProtoReflect.Descriptor instead.
func (*UpdateAnnotationRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_visionai_v1alpha1_warehouse_proto_rawDescGZIP(), []int{30}
}

func (x *UpdateAnnotationRequest) GetAnnotation() *Annotation {
	if x != nil {
		return x.Annotation
	}
	return nil
}

func (x *UpdateAnnotationRequest) GetUpdateMask() *fieldmaskpb.FieldMask {
	if x != nil {
		return x.UpdateMask
	}
	return nil
}

// Request message for DeleteAnnotation API.
type DeleteAnnotationRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the annotation to delete.
	// Format:
	// projects/{project_number}/locations/{location}/corpora/{corpus}/assets/{asset}/annotations/{annotation}
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *DeleteAnnotationRequest) Reset() {
	*x = DeleteAnnotationRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_visionai_v1alpha1_warehouse_proto_msgTypes[31]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DeleteAnnotationRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeleteAnnotationRequest) ProtoMessage() {}

func (x *DeleteAnnotationRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_visionai_v1alpha1_warehouse_proto_msgTypes[31]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeleteAnnotationRequest.ProtoReflect.Descriptor instead.
func (*DeleteAnnotationRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_visionai_v1alpha1_warehouse_proto_rawDescGZIP(), []int{31}
}

func (x *DeleteAnnotationRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Request message for CreateSearchConfig.
type CreateSearchConfigRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The parent resource where this search configuration will be created.
	// Format: projects/*/locations/*/corpora/*
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Required. The search config to create.
	SearchConfig *SearchConfig `protobuf:"bytes,2,opt,name=search_config,json=searchConfig,proto3" json:"search_config,omitempty"`
	// Required. ID to use for the new search config. Will become the final component of the
	// SearchConfig's resource name. This value should be up to 63 characters, and
	// valid characters are /[a-z][0-9]-_/. The first character must be a letter,
	// the last could be a letter or a number.
	SearchConfigId string `protobuf:"bytes,3,opt,name=search_config_id,json=searchConfigId,proto3" json:"search_config_id,omitempty"`
}

func (x *CreateSearchConfigRequest) Reset() {
	*x = CreateSearchConfigRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_visionai_v1alpha1_warehouse_proto_msgTypes[32]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CreateSearchConfigRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreateSearchConfigRequest) ProtoMessage() {}

func (x *CreateSearchConfigRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_visionai_v1alpha1_warehouse_proto_msgTypes[32]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CreateSearchConfigRequest.ProtoReflect.Descriptor instead.
func (*CreateSearchConfigRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_visionai_v1alpha1_warehouse_proto_rawDescGZIP(), []int{32}
}

func (x *CreateSearchConfigRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *CreateSearchConfigRequest) GetSearchConfig() *SearchConfig {
	if x != nil {
		return x.SearchConfig
	}
	return nil
}

func (x *CreateSearchConfigRequest) GetSearchConfigId() string {
	if x != nil {
		return x.SearchConfigId
	}
	return ""
}

// Request message for UpdateSearchConfig.
type UpdateSearchConfigRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The search configuration to update.
	//
	// The search configuration's `name` field is used to identify the resource to
	// be updated. Format:
	// projects/{project_number}/locations/{location}/corpora/{corpus}/searchConfigs/{search_config}
	SearchConfig *SearchConfig `protobuf:"bytes,1,opt,name=search_config,json=searchConfig,proto3" json:"search_config,omitempty"`
	// The list of fields to be updated. If left unset, all field paths will be
	// updated/overwritten.
	UpdateMask *fieldmaskpb.FieldMask `protobuf:"bytes,2,opt,name=update_mask,json=updateMask,proto3" json:"update_mask,omitempty"`
}

func (x *UpdateSearchConfigRequest) Reset() {
	*x = UpdateSearchConfigRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_visionai_v1alpha1_warehouse_proto_msgTypes[33]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *UpdateSearchConfigRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UpdateSearchConfigRequest) ProtoMessage() {}

func (x *UpdateSearchConfigRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_visionai_v1alpha1_warehouse_proto_msgTypes[33]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UpdateSearchConfigRequest.ProtoReflect.Descriptor instead.
func (*UpdateSearchConfigRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_visionai_v1alpha1_warehouse_proto_rawDescGZIP(), []int{33}
}

func (x *UpdateSearchConfigRequest) GetSearchConfig() *SearchConfig {
	if x != nil {
		return x.SearchConfig
	}
	return nil
}

func (x *UpdateSearchConfigRequest) GetUpdateMask() *fieldmaskpb.FieldMask {
	if x != nil {
		return x.UpdateMask
	}
	return nil
}

// Request message for GetSearchConfig.
type GetSearchConfigRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the search configuration to retrieve.
	// Format:
	// projects/{project_number}/locations/{location}/corpora/{corpus}/searchConfigs/{search_config}
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *GetSearchConfigRequest) Reset() {
	*x = GetSearchConfigRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_visionai_v1alpha1_warehouse_proto_msgTypes[34]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetSearchConfigRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetSearchConfigRequest) ProtoMessage() {}

func (x *GetSearchConfigRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_visionai_v1alpha1_warehouse_proto_msgTypes[34]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetSearchConfigRequest.ProtoReflect.Descriptor instead.
func (*GetSearchConfigRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_visionai_v1alpha1_warehouse_proto_rawDescGZIP(), []int{34}
}

func (x *GetSearchConfigRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Request message for DeleteSearchConfig.
type DeleteSearchConfigRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the search configuration to delete.
	// Format:
	// projects/{project_number}/locations/{location}/corpora/{corpus}/searchConfigs/{search_config}
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *DeleteSearchConfigRequest) Reset() {
	*x = DeleteSearchConfigRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_visionai_v1alpha1_warehouse_proto_msgTypes[35]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DeleteSearchConfigRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeleteSearchConfigRequest) ProtoMessage() {}

func (x *DeleteSearchConfigRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_visionai_v1alpha1_warehouse_proto_msgTypes[35]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeleteSearchConfigRequest.ProtoReflect.Descriptor instead.
func (*DeleteSearchConfigRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_visionai_v1alpha1_warehouse_proto_rawDescGZIP(), []int{35}
}

func (x *DeleteSearchConfigRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Request message for ListSearchConfigs.
type ListSearchConfigsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The parent, which owns this collection of search configurations.
	// Format:
	// projects/{project_number}/locations/{location}/corpora/{corpus}
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// The maximum number of search configurations to return. The service may
	// return fewer than this value. If unspecified, a page size of 50 will be
	// used. The maximum value is 1000; values above 1000 will be coerced to 1000.
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// A page token, received from a previous `ListSearchConfigs` call.
	// Provide this to retrieve the subsequent page.
	//
	// When paginating, all other parameters provided to
	// `ListSearchConfigs` must match the call that provided the page
	// token.
	PageToken string `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
}

func (x *ListSearchConfigsRequest) Reset() {
	*x = ListSearchConfigsRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_visionai_v1alpha1_warehouse_proto_msgTypes[36]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListSearchConfigsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListSearchConfigsRequest) ProtoMessage() {}

func (x *ListSearchConfigsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_visionai_v1alpha1_warehouse_proto_msgTypes[36]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListSearchConfigsRequest.ProtoReflect.Descriptor instead.
func (*ListSearchConfigsRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_visionai_v1alpha1_warehouse_proto_rawDescGZIP(), []int{36}
}

func (x *ListSearchConfigsRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *ListSearchConfigsRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *ListSearchConfigsRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

// Response message for ListSearchConfigs.
type ListSearchConfigsResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The search configurations from the specified corpus.
	SearchConfigs []*SearchConfig `protobuf:"bytes,1,rep,name=search_configs,json=searchConfigs,proto3" json:"search_configs,omitempty"`
	// A token, which can be sent as `page_token` to retrieve the next page.
	// If this field is omitted, there are no subsequent pages.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
}

func (x *ListSearchConfigsResponse) Reset() {
	*x = ListSearchConfigsResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_visionai_v1alpha1_warehouse_proto_msgTypes[37]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListSearchConfigsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListSearchConfigsResponse) ProtoMessage() {}

func (x *ListSearchConfigsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_visionai_v1alpha1_warehouse_proto_msgTypes[37]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListSearchConfigsResponse.ProtoReflect.Descriptor instead.
func (*ListSearchConfigsResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_visionai_v1alpha1_warehouse_proto_rawDescGZIP(), []int{37}
}

func (x *ListSearchConfigsResponse) GetSearchConfigs() []*SearchConfig {
	if x != nil {
		return x.SearchConfigs
	}
	return nil
}

func (x *ListSearchConfigsResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

// SearchConfig stores different properties that will affect search
// behaviors and search results.
type SearchConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Resource name of the search configuration.
	// For CustomSearchCriteria, search_config would be the search
	// operator name. For Facets, search_config would be the facet
	// dimension name.
	// Form:
	// `projects/{project_number}/locations/{location}/corpora/{corpus}/searchConfigs/{search_config}`
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Establishes a FacetDimension and associated specifications.
	FacetProperty *FacetProperty `protobuf:"bytes,2,opt,name=facet_property,json=facetProperty,proto3" json:"facet_property,omitempty"`
	// Creates a mapping between a custom SearchCriteria and one or more UGA keys.
	SearchCriteriaProperty *SearchCriteriaProperty `protobuf:"bytes,3,opt,name=search_criteria_property,json=searchCriteriaProperty,proto3" json:"search_criteria_property,omitempty"`
}

func (x *SearchConfig) Reset() {
	*x = SearchConfig{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_visionai_v1alpha1_warehouse_proto_msgTypes[38]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SearchConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SearchConfig) ProtoMessage() {}

func (x *SearchConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_visionai_v1alpha1_warehouse_proto_msgTypes[38]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SearchConfig.ProtoReflect.Descriptor instead.
func (*SearchConfig) Descriptor() ([]byte, []int) {
	return file_google_cloud_visionai_v1alpha1_warehouse_proto_rawDescGZIP(), []int{38}
}

func (x *SearchConfig) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *SearchConfig) GetFacetProperty() *FacetProperty {
	if x != nil {
		return x.FacetProperty
	}
	return nil
}

func (x *SearchConfig) GetSearchCriteriaProperty() *SearchCriteriaProperty {
	if x != nil {
		return x.SearchCriteriaProperty
	}
	return nil
}

// Central configuration for a facet.
type FacetProperty struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Types that are assignable to RangeFacetConfig:
	//
	//	*FacetProperty_FixedRangeBucketSpec_
	//	*FacetProperty_CustomRangeBucketSpec_
	//	*FacetProperty_DatetimeBucketSpec
	RangeFacetConfig isFacetProperty_RangeFacetConfig `protobuf_oneof:"range_facet_config"`
	// Name of the facets, which are the dimensions users want to use to refine
	// search results. `mapped_fields` will match UserSpecifiedDataSchema keys.
	//
	// For example, user can add a bunch of UGAs with the same key, such as
	// player:adam, player:bob, player:charles. When multiple mapped_fields are
	// specified, will merge their value together as final facet value. E.g.
	// home_team: a, home_team:b, away_team:a, away_team:c, when facet_field =
	// [home_team, away_team], facet_value will be [a, b, c].
	//
	// UNLESS this is a 1:1 facet dimension (mapped_fields.size() == 1) AND the
	// mapped_field equals the parent SearchConfig.name, the parent must
	// also contain a SearchCriteriaProperty that maps to the same fields.
	// mapped_fields must not be empty.
	MappedFields []string `protobuf:"bytes,1,rep,name=mapped_fields,json=mappedFields,proto3" json:"mapped_fields,omitempty"`
	// Display name of the facet. To be used by UI for facet rendering.
	DisplayName string `protobuf:"bytes,2,opt,name=display_name,json=displayName,proto3" json:"display_name,omitempty"`
	// Maximum number of unique bucket to return for one facet. Bucket number can
	// be large for high-cardinality facet such as "player". We only return top-n
	// most related ones to user. If it's <= 0, the server will decide the
	// appropriate result_size.
	ResultSize int64 `protobuf:"varint,3,opt,name=result_size,json=resultSize,proto3" json:"result_size,omitempty"`
	// Facet bucket type e.g. value, range.
	BucketType FacetBucketType `protobuf:"varint,4,opt,name=bucket_type,json=bucketType,proto3,enum=google.cloud.visionai.v1alpha1.FacetBucketType" json:"bucket_type,omitempty"`
}

func (x *FacetProperty) Reset() {
	*x = FacetProperty{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_visionai_v1alpha1_warehouse_proto_msgTypes[39]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *FacetProperty) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*FacetProperty) ProtoMessage() {}

func (x *FacetProperty) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_visionai_v1alpha1_warehouse_proto_msgTypes[39]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use FacetProperty.ProtoReflect.Descriptor instead.
func (*FacetProperty) Descriptor() ([]byte, []int) {
	return file_google_cloud_visionai_v1alpha1_warehouse_proto_rawDescGZIP(), []int{39}
}

func (m *FacetProperty) GetRangeFacetConfig() isFacetProperty_RangeFacetConfig {
	if m != nil {
		return m.RangeFacetConfig
	}
	return nil
}

func (x *FacetProperty) GetFixedRangeBucketSpec() *FacetProperty_FixedRangeBucketSpec {
	if x, ok := x.GetRangeFacetConfig().(*FacetProperty_FixedRangeBucketSpec_); ok {
		return x.FixedRangeBucketSpec
	}
	return nil
}

func (x *FacetProperty) GetCustomRangeBucketSpec() *FacetProperty_CustomRangeBucketSpec {
	if x, ok := x.GetRangeFacetConfig().(*FacetProperty_CustomRangeBucketSpec_); ok {
		return x.CustomRangeBucketSpec
	}
	return nil
}

func (x *FacetProperty) GetDatetimeBucketSpec() *FacetProperty_DateTimeBucketSpec {
	if x, ok := x.GetRangeFacetConfig().(*FacetProperty_DatetimeBucketSpec); ok {
		return x.DatetimeBucketSpec
	}
	return nil
}

func (x *FacetProperty) GetMappedFields() []string {
	if x != nil {
		return x.MappedFields
	}
	return nil
}

func (x *FacetProperty) GetDisplayName() string {
	if x != nil {
		return x.DisplayName
	}
	return ""
}

func (x *FacetProperty) GetResultSize() int64 {
	if x != nil {
		return x.ResultSize
	}
	return 0
}

func (x *FacetProperty) GetBucketType() FacetBucketType {
	if x != nil {
		return x.BucketType
	}
	return FacetBucketType_FACET_BUCKET_TYPE_UNSPECIFIED
}

type isFacetProperty_RangeFacetConfig interface {
	isFacetProperty_RangeFacetConfig()
}

type FacetProperty_FixedRangeBucketSpec_ struct {
	// Fixed range facet bucket config.
	FixedRangeBucketSpec *FacetProperty_FixedRangeBucketSpec `protobuf:"bytes,5,opt,name=fixed_range_bucket_spec,json=fixedRangeBucketSpec,proto3,oneof"`
}

type FacetProperty_CustomRangeBucketSpec_ struct {
	// Custom range facet bucket config.
	CustomRangeBucketSpec *FacetProperty_CustomRangeBucketSpec `protobuf:"bytes,6,opt,name=custom_range_bucket_spec,json=customRangeBucketSpec,proto3,oneof"`
}

type FacetProperty_DatetimeBucketSpec struct {
	// Datetime range facet bucket config.
	DatetimeBucketSpec *FacetProperty_DateTimeBucketSpec `protobuf:"bytes,7,opt,name=datetime_bucket_spec,json=datetimeBucketSpec,proto3,oneof"`
}

func (*FacetProperty_FixedRangeBucketSpec_) isFacetProperty_RangeFacetConfig() {}

func (*FacetProperty_CustomRangeBucketSpec_) isFacetProperty_RangeFacetConfig() {}

func (*FacetProperty_DatetimeBucketSpec) isFacetProperty_RangeFacetConfig() {}

// Central configuration for custom search criteria.
type SearchCriteriaProperty struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Each mapped_field corresponds to a UGA key. To understand how this property
	// works, take the following example. In the SearchConfig table, the
	// user adds this entry:
	//
	//	search_config {
	//	  name: "person"
	//	  search_criteria_property {
	//	    mapped_fields: "player"
	//	    mapped_fields: "coach"
	//	  }
	//	}
	//
	// Now, when a user issues a query like:
	//
	//	criteria {
	//	  field: "person"
	//	  text_array {
	//	    txt_values: "Tom Brady"
	//	    txt_values: "Bill Belichick"
	//	  }
	//	}
	//
	// MWH search will return search documents where (player=Tom Brady ||
	// coach=Tom Brady || player=Bill Belichick || coach=Bill Belichick).
	MappedFields []string `protobuf:"bytes,1,rep,name=mapped_fields,json=mappedFields,proto3" json:"mapped_fields,omitempty"`
}

func (x *SearchCriteriaProperty) Reset() {
	*x = SearchCriteriaProperty{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_visionai_v1alpha1_warehouse_proto_msgTypes[40]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SearchCriteriaProperty) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SearchCriteriaProperty) ProtoMessage() {}

func (x *SearchCriteriaProperty) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_visionai_v1alpha1_warehouse_proto_msgTypes[40]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SearchCriteriaProperty.ProtoReflect.Descriptor instead.
func (*SearchCriteriaProperty) Descriptor() ([]byte, []int) {
	return file_google_cloud_visionai_v1alpha1_warehouse_proto_rawDescGZIP(), []int{40}
}

func (x *SearchCriteriaProperty) GetMappedFields() []string {
	if x != nil {
		return x.MappedFields
	}
	return nil
}

// Definition of a single value with generic type.
type FacetValue struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Types that are assignable to Value:
	//
	//	*FacetValue_StringValue
	//	*FacetValue_IntegerValue
	//	*FacetValue_DatetimeValue
	Value isFacetValue_Value `protobuf_oneof:"value"`
}

func (x *FacetValue) Reset() {
	*x = FacetValue{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_visionai_v1alpha1_warehouse_proto_msgTypes[41]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *FacetValue) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*FacetValue) ProtoMessage() {}

func (x *FacetValue) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_visionai_v1alpha1_warehouse_proto_msgTypes[41]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use FacetValue.ProtoReflect.Descriptor instead.
func (*FacetValue) Descriptor() ([]byte, []int) {
	return file_google_cloud_visionai_v1alpha1_warehouse_proto_rawDescGZIP(), []int{41}
}

func (m *FacetValue) GetValue() isFacetValue_Value {
	if m != nil {
		return m.Value
	}
	return nil
}

func (x *FacetValue) GetStringValue() string {
	if x, ok := x.GetValue().(*FacetValue_StringValue); ok {
		return x.StringValue
	}
	return ""
}

func (x *FacetValue) GetIntegerValue() int64 {
	if x, ok := x.GetValue().(*FacetValue_IntegerValue); ok {
		return x.IntegerValue
	}
	return 0
}

func (x *FacetValue) GetDatetimeValue() *datetime.DateTime {
	if x, ok := x.GetValue().(*FacetValue_DatetimeValue); ok {
		return x.DatetimeValue
	}
	return nil
}

type isFacetValue_Value interface {
	isFacetValue_Value()
}

type FacetValue_StringValue struct {
	// String type value.
	StringValue string `protobuf:"bytes,1,opt,name=string_value,json=stringValue,proto3,oneof"`
}

type FacetValue_IntegerValue struct {
	// Integer type value.
	IntegerValue int64 `protobuf:"varint,2,opt,name=integer_value,json=integerValue,proto3,oneof"`
}

type FacetValue_DatetimeValue struct {
	// Datetime type value.
	DatetimeValue *datetime.DateTime `protobuf:"bytes,3,opt,name=datetime_value,json=datetimeValue,proto3,oneof"`
}

func (*FacetValue_StringValue) isFacetValue_Value() {}

func (*FacetValue_IntegerValue) isFacetValue_Value() {}

func (*FacetValue_DatetimeValue) isFacetValue_Value() {}

// Holds the facet value, selections state, and metadata.
type FacetBucket struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Bucket associated with a facet. For example, bucket of facet “team”
	// can be "49ers", "patriots", etc; bucket of facet "player" can be "tom
	// brady", "drew brees", etc.
	//
	// Types that are assignable to BucketValue:
	//
	//	*FacetBucket_Value
	//	*FacetBucket_Range_
	BucketValue isFacetBucket_BucketValue `protobuf_oneof:"bucket_value"`
	// Whether one facet bucket is selected. This field represents user's facet
	// selection. It is set by frontend in SearchVideosRequest.
	Selected bool `protobuf:"varint,3,opt,name=selected,proto3" json:"selected,omitempty"`
}

func (x *FacetBucket) Reset() {
	*x = FacetBucket{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_visionai_v1alpha1_warehouse_proto_msgTypes[42]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *FacetBucket) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*FacetBucket) ProtoMessage() {}

func (x *FacetBucket) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_visionai_v1alpha1_warehouse_proto_msgTypes[42]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use FacetBucket.ProtoReflect.Descriptor instead.
func (*FacetBucket) Descriptor() ([]byte, []int) {
	return file_google_cloud_visionai_v1alpha1_warehouse_proto_rawDescGZIP(), []int{42}
}

func (m *FacetBucket) GetBucketValue() isFacetBucket_BucketValue {
	if m != nil {
		return m.BucketValue
	}
	return nil
}

func (x *FacetBucket) GetValue() *FacetValue {
	if x, ok := x.GetBucketValue().(*FacetBucket_Value); ok {
		return x.Value
	}
	return nil
}

func (x *FacetBucket) GetRange() *FacetBucket_Range {
	if x, ok := x.GetBucketValue().(*FacetBucket_Range_); ok {
		return x.Range
	}
	return nil
}

func (x *FacetBucket) GetSelected() bool {
	if x != nil {
		return x.Selected
	}
	return false
}

type isFacetBucket_BucketValue interface {
	isFacetBucket_BucketValue()
}

type FacetBucket_Value struct {
	// Singular value.
	Value *FacetValue `protobuf:"bytes,2,opt,name=value,proto3,oneof"`
}

type FacetBucket_Range_ struct {
	// Range value.
	Range *FacetBucket_Range `protobuf:"bytes,4,opt,name=range,proto3,oneof"`
}

func (*FacetBucket_Value) isFacetBucket_BucketValue() {}

func (*FacetBucket_Range_) isFacetBucket_BucketValue() {}

// A group of facet buckets to be passed back and forth between backend &
// frontend.
type FacetGroup struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Unique id of the facet group.
	FacetId string `protobuf:"bytes,1,opt,name=facet_id,json=facetId,proto3" json:"facet_id,omitempty"`
	// Display name of the facet. To be used by UI for facet rendering.
	DisplayName string `protobuf:"bytes,2,opt,name=display_name,json=displayName,proto3" json:"display_name,omitempty"`
	// Buckets associated with the facet. E.g. for "Team" facet, the bucket
	// can be 49ers, patriots, etc.
	Buckets []*FacetBucket `protobuf:"bytes,3,rep,name=buckets,proto3" json:"buckets,omitempty"`
	// Facet bucket type.
	BucketType FacetBucketType `protobuf:"varint,4,opt,name=bucket_type,json=bucketType,proto3,enum=google.cloud.visionai.v1alpha1.FacetBucketType" json:"bucket_type,omitempty"`
	// If true, return query matched annotations for this facet group's selection.
	// This option is only applicable for facets based on partition level
	// annotations. It supports the following facet values:
	//   - INTEGER
	//   - STRING (DataSchema.SearchStrategy.EXACT_SEARCH only)
	FetchMatchedAnnotations bool `protobuf:"varint,5,opt,name=fetch_matched_annotations,json=fetchMatchedAnnotations,proto3" json:"fetch_matched_annotations,omitempty"`
}

func (x *FacetGroup) Reset() {
	*x = FacetGroup{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_visionai_v1alpha1_warehouse_proto_msgTypes[43]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *FacetGroup) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*FacetGroup) ProtoMessage() {}

func (x *FacetGroup) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_visionai_v1alpha1_warehouse_proto_msgTypes[43]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use FacetGroup.ProtoReflect.Descriptor instead.
func (*FacetGroup) Descriptor() ([]byte, []int) {
	return file_google_cloud_visionai_v1alpha1_warehouse_proto_rawDescGZIP(), []int{43}
}

func (x *FacetGroup) GetFacetId() string {
	if x != nil {
		return x.FacetId
	}
	return ""
}

func (x *FacetGroup) GetDisplayName() string {
	if x != nil {
		return x.DisplayName
	}
	return ""
}

func (x *FacetGroup) GetBuckets() []*FacetBucket {
	if x != nil {
		return x.Buckets
	}
	return nil
}

func (x *FacetGroup) GetBucketType() FacetBucketType {
	if x != nil {
		return x.BucketType
	}
	return FacetBucketType_FACET_BUCKET_TYPE_UNSPECIFIED
}

func (x *FacetGroup) GetFetchMatchedAnnotations() bool {
	if x != nil {
		return x.FetchMatchedAnnotations
	}
	return false
}

// Request message for IngestAsset API.
type IngestAssetRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Types that are assignable to StreamingRequest:
	//
	//	*IngestAssetRequest_Config_
	//	*IngestAssetRequest_TimeIndexedData_
	StreamingRequest isIngestAssetRequest_StreamingRequest `protobuf_oneof:"streaming_request"`
}

func (x *IngestAssetRequest) Reset() {
	*x = IngestAssetRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_visionai_v1alpha1_warehouse_proto_msgTypes[44]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *IngestAssetRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*IngestAssetRequest) ProtoMessage() {}

func (x *IngestAssetRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_visionai_v1alpha1_warehouse_proto_msgTypes[44]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use IngestAssetRequest.ProtoReflect.Descriptor instead.
func (*IngestAssetRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_visionai_v1alpha1_warehouse_proto_rawDescGZIP(), []int{44}
}

func (m *IngestAssetRequest) GetStreamingRequest() isIngestAssetRequest_StreamingRequest {
	if m != nil {
		return m.StreamingRequest
	}
	return nil
}

func (x *IngestAssetRequest) GetConfig() *IngestAssetRequest_Config {
	if x, ok := x.GetStreamingRequest().(*IngestAssetRequest_Config_); ok {
		return x.Config
	}
	return nil
}

func (x *IngestAssetRequest) GetTimeIndexedData() *IngestAssetRequest_TimeIndexedData {
	if x, ok := x.GetStreamingRequest().(*IngestAssetRequest_TimeIndexedData_); ok {
		return x.TimeIndexedData
	}
	return nil
}

type isIngestAssetRequest_StreamingRequest interface {
	isIngestAssetRequest_StreamingRequest()
}

type IngestAssetRequest_Config_ struct {
	// Provides information for the data and the asset resource name that the
	// data belongs to. The first `IngestAssetRequest` message must only contain
	// a `Config` message.
	Config *IngestAssetRequest_Config `protobuf:"bytes,1,opt,name=config,proto3,oneof"`
}

type IngestAssetRequest_TimeIndexedData_ struct {
	// Data to be ingested.
	TimeIndexedData *IngestAssetRequest_TimeIndexedData `protobuf:"bytes,2,opt,name=time_indexed_data,json=timeIndexedData,proto3,oneof"`
}

func (*IngestAssetRequest_Config_) isIngestAssetRequest_StreamingRequest() {}

func (*IngestAssetRequest_TimeIndexedData_) isIngestAssetRequest_StreamingRequest() {}

// Response message for IngestAsset API.
type IngestAssetResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Time range of the data that has been successfully ingested.
	SuccessfullyIngestedPartition *Partition_TemporalPartition `protobuf:"bytes,1,opt,name=successfully_ingested_partition,json=successfullyIngestedPartition,proto3" json:"successfully_ingested_partition,omitempty"`
}

func (x *IngestAssetResponse) Reset() {
	*x = IngestAssetResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_visionai_v1alpha1_warehouse_proto_msgTypes[45]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *IngestAssetResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*IngestAssetResponse) ProtoMessage() {}

func (x *IngestAssetResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_visionai_v1alpha1_warehouse_proto_msgTypes[45]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use IngestAssetResponse.ProtoReflect.Descriptor instead.
func (*IngestAssetResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_visionai_v1alpha1_warehouse_proto_rawDescGZIP(), []int{45}
}

func (x *IngestAssetResponse) GetSuccessfullyIngestedPartition() *Partition_TemporalPartition {
	if x != nil {
		return x.SuccessfullyIngestedPartition
	}
	return nil
}

// Request message for ClipAsset API.
type ClipAssetRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The resource name of the asset to request clips for.
	// Form:
	// 'projects/{project_number}/locations/{location_id}/corpora/{corpus_id}/assets/{asset_id}'
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Required. The time range to request clips for.
	TemporalPartition *Partition_TemporalPartition `protobuf:"bytes,2,opt,name=temporal_partition,json=temporalPartition,proto3" json:"temporal_partition,omitempty"`
}

func (x *ClipAssetRequest) Reset() {
	*x = ClipAssetRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_visionai_v1alpha1_warehouse_proto_msgTypes[46]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ClipAssetRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ClipAssetRequest) ProtoMessage() {}

func (x *ClipAssetRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_visionai_v1alpha1_warehouse_proto_msgTypes[46]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ClipAssetRequest.ProtoReflect.Descriptor instead.
func (*ClipAssetRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_visionai_v1alpha1_warehouse_proto_rawDescGZIP(), []int{46}
}

func (x *ClipAssetRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *ClipAssetRequest) GetTemporalPartition() *Partition_TemporalPartition {
	if x != nil {
		return x.TemporalPartition
	}
	return nil
}

// Response message for ClipAsset API.
type ClipAssetResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// A list of signed uris to download the video clips that cover the requested
	// time range ordered by time.
	TimeIndexedUris []*ClipAssetResponse_TimeIndexedUri `protobuf:"bytes,1,rep,name=time_indexed_uris,json=timeIndexedUris,proto3" json:"time_indexed_uris,omitempty"`
}

func (x *ClipAssetResponse) Reset() {
	*x = ClipAssetResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_visionai_v1alpha1_warehouse_proto_msgTypes[47]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ClipAssetResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ClipAssetResponse) ProtoMessage() {}

func (x *ClipAssetResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_visionai_v1alpha1_warehouse_proto_msgTypes[47]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ClipAssetResponse.ProtoReflect.Descriptor instead.
func (*ClipAssetResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_visionai_v1alpha1_warehouse_proto_rawDescGZIP(), []int{47}
}

func (x *ClipAssetResponse) GetTimeIndexedUris() []*ClipAssetResponse_TimeIndexedUri {
	if x != nil {
		return x.TimeIndexedUris
	}
	return nil
}

// Request message for GenerateHlsUri API.
type GenerateHlsUriRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The resource name of the asset to request clips for.
	// Form:
	// 'projects/{project_number}/locations/{location_id}/corpora/{corpus_id}/assets/{asset_id}'
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Required. The time range to request clips for.
	TemporalPartitions []*Partition_TemporalPartition `protobuf:"bytes,2,rep,name=temporal_partitions,json=temporalPartitions,proto3" json:"temporal_partitions,omitempty"`
}

func (x *GenerateHlsUriRequest) Reset() {
	*x = GenerateHlsUriRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_visionai_v1alpha1_warehouse_proto_msgTypes[48]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GenerateHlsUriRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GenerateHlsUriRequest) ProtoMessage() {}

func (x *GenerateHlsUriRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_visionai_v1alpha1_warehouse_proto_msgTypes[48]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GenerateHlsUriRequest.ProtoReflect.Descriptor instead.
func (*GenerateHlsUriRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_visionai_v1alpha1_warehouse_proto_rawDescGZIP(), []int{48}
}

func (x *GenerateHlsUriRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *GenerateHlsUriRequest) GetTemporalPartitions() []*Partition_TemporalPartition {
	if x != nil {
		return x.TemporalPartitions
	}
	return nil
}

// Response message for GenerateHlsUri API.
type GenerateHlsUriResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// A signed uri to download the HLS manifest corresponding to the requested
	// times.
	Uri string `protobuf:"bytes,1,opt,name=uri,proto3" json:"uri,omitempty"`
	// A list of temporal partitions of the content returned in the order they
	// appear in the stream.
	TemporalPartitions []*Partition_TemporalPartition `protobuf:"bytes,2,rep,name=temporal_partitions,json=temporalPartitions,proto3" json:"temporal_partitions,omitempty"`
}

func (x *GenerateHlsUriResponse) Reset() {
	*x = GenerateHlsUriResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_visionai_v1alpha1_warehouse_proto_msgTypes[49]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GenerateHlsUriResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GenerateHlsUriResponse) ProtoMessage() {}

func (x *GenerateHlsUriResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_visionai_v1alpha1_warehouse_proto_msgTypes[49]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GenerateHlsUriResponse.ProtoReflect.Descriptor instead.
func (*GenerateHlsUriResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_visionai_v1alpha1_warehouse_proto_rawDescGZIP(), []int{49}
}

func (x *GenerateHlsUriResponse) GetUri() string {
	if x != nil {
		return x.Uri
	}
	return ""
}

func (x *GenerateHlsUriResponse) GetTemporalPartitions() []*Partition_TemporalPartition {
	if x != nil {
		return x.TemporalPartitions
	}
	return nil
}

// Request message for SearchAssets.
type SearchAssetsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Sorting specification. If this field is not specified, by default:
	// - STREAM_VIDEO: search results are sorted by the start time.
	//
	// Types that are assignable to SortSpec:
	//
	//	*SearchAssetsRequest_SchemaKeySortingStrategy
	SortSpec isSearchAssetsRequest_SortSpec `protobuf_oneof:"sort_spec"`
	// Required. The parent corpus to search.
	// Form: `projects/{project_id}/locations/{location_id}/corpora/{corpus_id}'
	Corpus string `protobuf:"bytes,1,opt,name=corpus,proto3" json:"corpus,omitempty"`
	// The number of results to be returned in this page. If it's 0, the server
	// will decide the appropriate page_size.
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// The continuation token to fetch the next page. If empty, it means it is
	// fetching the first page.
	PageToken string `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	// Time ranges that matching video content must fall within. If no ranges are
	// provided, there will be no time restriction. This field is treated just
	// like the criteria below, but defined separately for convenience as it is
	// used frequently. Note that if the end_time is in the future, it will be
	// clamped to the time the request was received.
	ContentTimeRanges *DateTimeRangeArray `protobuf:"bytes,5,opt,name=content_time_ranges,json=contentTimeRanges,proto3" json:"content_time_ranges,omitempty"`
	// Criteria applied to search results.
	Criteria []*Criteria `protobuf:"bytes,4,rep,name=criteria,proto3" json:"criteria,omitempty"`
	// Stores most recent facet selection state. Only facet groups with user's
	// selection will be presented here. Selection state is either selected or
	// unselected. Only selected facet buckets will be used as search criteria.
	FacetSelections []*FacetGroup `protobuf:"bytes,6,rep,name=facet_selections,json=facetSelections,proto3" json:"facet_selections,omitempty"`
	// A list of annotation keys to specify the annotations to be retrieved and
	// returned with each search result.
	// Annotation granularity must be GRANULARITY_ASSET_LEVEL and its search
	// strategy must not be NO_SEARCH.
	ResultAnnotationKeys []string `protobuf:"bytes,8,rep,name=result_annotation_keys,json=resultAnnotationKeys,proto3" json:"result_annotation_keys,omitempty"`
}

func (x *SearchAssetsRequest) Reset() {
	*x = SearchAssetsRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_visionai_v1alpha1_warehouse_proto_msgTypes[50]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SearchAssetsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SearchAssetsRequest) ProtoMessage() {}

func (x *SearchAssetsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_visionai_v1alpha1_warehouse_proto_msgTypes[50]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SearchAssetsRequest.ProtoReflect.Descriptor instead.
func (*SearchAssetsRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_visionai_v1alpha1_warehouse_proto_rawDescGZIP(), []int{50}
}

func (m *SearchAssetsRequest) GetSortSpec() isSearchAssetsRequest_SortSpec {
	if m != nil {
		return m.SortSpec
	}
	return nil
}

func (x *SearchAssetsRequest) GetSchemaKeySortingStrategy() *SchemaKeySortingStrategy {
	if x, ok := x.GetSortSpec().(*SearchAssetsRequest_SchemaKeySortingStrategy); ok {
		return x.SchemaKeySortingStrategy
	}
	return nil
}

func (x *SearchAssetsRequest) GetCorpus() string {
	if x != nil {
		return x.Corpus
	}
	return ""
}

func (x *SearchAssetsRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *SearchAssetsRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

func (x *SearchAssetsRequest) GetContentTimeRanges() *DateTimeRangeArray {
	if x != nil {
		return x.ContentTimeRanges
	}
	return nil
}

func (x *SearchAssetsRequest) GetCriteria() []*Criteria {
	if x != nil {
		return x.Criteria
	}
	return nil
}

func (x *SearchAssetsRequest) GetFacetSelections() []*FacetGroup {
	if x != nil {
		return x.FacetSelections
	}
	return nil
}

func (x *SearchAssetsRequest) GetResultAnnotationKeys() []string {
	if x != nil {
		return x.ResultAnnotationKeys
	}
	return nil
}

type isSearchAssetsRequest_SortSpec interface {
	isSearchAssetsRequest_SortSpec()
}

type SearchAssetsRequest_SchemaKeySortingStrategy struct {
	// Sort by the value under the data schema key.
	SchemaKeySortingStrategy *SchemaKeySortingStrategy `protobuf:"bytes,9,opt,name=schema_key_sorting_strategy,json=schemaKeySortingStrategy,proto3,oneof"`
}

func (*SearchAssetsRequest_SchemaKeySortingStrategy) isSearchAssetsRequest_SortSpec() {}

// A strategy to specify how to sort by data schema key.
type SchemaKeySortingStrategy struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Options in the front have high priority than those in the back.
	Options []*SchemaKeySortingStrategy_Option `protobuf:"bytes,1,rep,name=options,proto3" json:"options,omitempty"`
}

func (x *SchemaKeySortingStrategy) Reset() {
	*x = SchemaKeySortingStrategy{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_visionai_v1alpha1_warehouse_proto_msgTypes[51]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SchemaKeySortingStrategy) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SchemaKeySortingStrategy) ProtoMessage() {}

func (x *SchemaKeySortingStrategy) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_visionai_v1alpha1_warehouse_proto_msgTypes[51]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SchemaKeySortingStrategy.ProtoReflect.Descriptor instead.
func (*SchemaKeySortingStrategy) Descriptor() ([]byte, []int) {
	return file_google_cloud_visionai_v1alpha1_warehouse_proto_rawDescGZIP(), []int{51}
}

func (x *SchemaKeySortingStrategy) GetOptions() []*SchemaKeySortingStrategy_Option {
	if x != nil {
		return x.Options
	}
	return nil
}

// Stores the criteria-annotation matching results for each search result item.
type AnnotationMatchingResult struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The criteria used for matching. It can be an input search criteria or a
	// criteria converted from a facet selection.
	Criteria *Criteria `protobuf:"bytes,1,opt,name=criteria,proto3" json:"criteria,omitempty"`
	// Matched annotations for the criteria.
	MatchedAnnotations []*Annotation `protobuf:"bytes,2,rep,name=matched_annotations,json=matchedAnnotations,proto3" json:"matched_annotations,omitempty"`
	// Status of the match result. Possible values:
	// FAILED_PRECONDITION - the criteria is not eligible for match.
	// OK - matching is performed.
	Status *status.Status `protobuf:"bytes,3,opt,name=status,proto3" json:"status,omitempty"`
}

func (x *AnnotationMatchingResult) Reset() {
	*x = AnnotationMatchingResult{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_visionai_v1alpha1_warehouse_proto_msgTypes[52]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AnnotationMatchingResult) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AnnotationMatchingResult) ProtoMessage() {}

func (x *AnnotationMatchingResult) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_visionai_v1alpha1_warehouse_proto_msgTypes[52]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AnnotationMatchingResult.ProtoReflect.Descriptor instead.
func (*AnnotationMatchingResult) Descriptor() ([]byte, []int) {
	return file_google_cloud_visionai_v1alpha1_warehouse_proto_rawDescGZIP(), []int{52}
}

func (x *AnnotationMatchingResult) GetCriteria() *Criteria {
	if x != nil {
		return x.Criteria
	}
	return nil
}

func (x *AnnotationMatchingResult) GetMatchedAnnotations() []*Annotation {
	if x != nil {
		return x.MatchedAnnotations
	}
	return nil
}

func (x *AnnotationMatchingResult) GetStatus() *status.Status {
	if x != nil {
		return x.Status
	}
	return nil
}

// Search result contains asset name and corresponding time ranges.
type SearchResultItem struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The resource name of the asset.
	// Form:
	// 'projects/{project_number}/locations/{location_id}/corpora/{corpus_id}/assets/{asset_id}'
	Asset string `protobuf:"bytes,1,opt,name=asset,proto3" json:"asset,omitempty"`
	// The matched asset segments.
	// Deprecated: please use singular `segment` field.
	//
	// Deprecated: Do not use.
	Segments []*Partition_TemporalPartition `protobuf:"bytes,2,rep,name=segments,proto3" json:"segments,omitempty"`
	// The matched asset segment.
	Segment *Partition_TemporalPartition `protobuf:"bytes,5,opt,name=segment,proto3" json:"segment,omitempty"`
	// Search result annotations specified by result_annotation_keys in search
	// request.
	RequestedAnnotations []*Annotation `protobuf:"bytes,3,rep,name=requested_annotations,json=requestedAnnotations,proto3" json:"requested_annotations,omitempty"`
	// Criteria or facet-selection based annotation matching results associated to
	// this search result item. Only contains results for criteria or
	// facet_selections with fetch_matched_annotations=true.
	AnnotationMatchingResults []*AnnotationMatchingResult `protobuf:"bytes,4,rep,name=annotation_matching_results,json=annotationMatchingResults,proto3" json:"annotation_matching_results,omitempty"`
}

func (x *SearchResultItem) Reset() {
	*x = SearchResultItem{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_visionai_v1alpha1_warehouse_proto_msgTypes[53]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SearchResultItem) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SearchResultItem) ProtoMessage() {}

func (x *SearchResultItem) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_visionai_v1alpha1_warehouse_proto_msgTypes[53]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SearchResultItem.ProtoReflect.Descriptor instead.
func (*SearchResultItem) Descriptor() ([]byte, []int) {
	return file_google_cloud_visionai_v1alpha1_warehouse_proto_rawDescGZIP(), []int{53}
}

func (x *SearchResultItem) GetAsset() string {
	if x != nil {
		return x.Asset
	}
	return ""
}

// Deprecated: Do not use.
func (x *SearchResultItem) GetSegments() []*Partition_TemporalPartition {
	if x != nil {
		return x.Segments
	}
	return nil
}

func (x *SearchResultItem) GetSegment() *Partition_TemporalPartition {
	if x != nil {
		return x.Segment
	}
	return nil
}

func (x *SearchResultItem) GetRequestedAnnotations() []*Annotation {
	if x != nil {
		return x.RequestedAnnotations
	}
	return nil
}

func (x *SearchResultItem) GetAnnotationMatchingResults() []*AnnotationMatchingResult {
	if x != nil {
		return x.AnnotationMatchingResults
	}
	return nil
}

// Response message for SearchAssets.
type SearchAssetsResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Returned search results.
	SearchResultItems []*SearchResultItem `protobuf:"bytes,1,rep,name=search_result_items,json=searchResultItems,proto3" json:"search_result_items,omitempty"`
	// The next-page continuation token.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
	// Facet search results of a given query, which contains user's
	// already-selected facet values and updated facet search results.
	FacetResults []*FacetGroup `protobuf:"bytes,3,rep,name=facet_results,json=facetResults,proto3" json:"facet_results,omitempty"`
}

func (x *SearchAssetsResponse) Reset() {
	*x = SearchAssetsResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_visionai_v1alpha1_warehouse_proto_msgTypes[54]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SearchAssetsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SearchAssetsResponse) ProtoMessage() {}

func (x *SearchAssetsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_visionai_v1alpha1_warehouse_proto_msgTypes[54]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SearchAssetsResponse.ProtoReflect.Descriptor instead.
func (*SearchAssetsResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_visionai_v1alpha1_warehouse_proto_rawDescGZIP(), []int{54}
}

func (x *SearchAssetsResponse) GetSearchResultItems() []*SearchResultItem {
	if x != nil {
		return x.SearchResultItems
	}
	return nil
}

func (x *SearchAssetsResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

func (x *SearchAssetsResponse) GetFacetResults() []*FacetGroup {
	if x != nil {
		return x.FacetResults
	}
	return nil
}

// Integer range type.
type IntRange struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Start of the int range.
	Start *int64 `protobuf:"varint,1,opt,name=start,proto3,oneof" json:"start,omitempty"`
	// End of the int range.
	End *int64 `protobuf:"varint,2,opt,name=end,proto3,oneof" json:"end,omitempty"`
}

func (x *IntRange) Reset() {
	*x = IntRange{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_visionai_v1alpha1_warehouse_proto_msgTypes[55]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *IntRange) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*IntRange) ProtoMessage() {}

func (x *IntRange) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_visionai_v1alpha1_warehouse_proto_msgTypes[55]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use IntRange.ProtoReflect.Descriptor instead.
func (*IntRange) Descriptor() ([]byte, []int) {
	return file_google_cloud_visionai_v1alpha1_warehouse_proto_rawDescGZIP(), []int{55}
}

func (x *IntRange) GetStart() int64 {
	if x != nil && x.Start != nil {
		return *x.Start
	}
	return 0
}

func (x *IntRange) GetEnd() int64 {
	if x != nil && x.End != nil {
		return *x.End
	}
	return 0
}

// Float range type.
type FloatRange struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Start of the float range.
	Start *float32 `protobuf:"fixed32,1,opt,name=start,proto3,oneof" json:"start,omitempty"`
	// End of the float range.
	End *float32 `protobuf:"fixed32,2,opt,name=end,proto3,oneof" json:"end,omitempty"`
}

func (x *FloatRange) Reset() {
	*x = FloatRange{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_visionai_v1alpha1_warehouse_proto_msgTypes[56]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *FloatRange) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*FloatRange) ProtoMessage() {}

func (x *FloatRange) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_visionai_v1alpha1_warehouse_proto_msgTypes[56]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use FloatRange.ProtoReflect.Descriptor instead.
func (*FloatRange) Descriptor() ([]byte, []int) {
	return file_google_cloud_visionai_v1alpha1_warehouse_proto_rawDescGZIP(), []int{56}
}

func (x *FloatRange) GetStart() float32 {
	if x != nil && x.Start != nil {
		return *x.Start
	}
	return 0
}

func (x *FloatRange) GetEnd() float32 {
	if x != nil && x.End != nil {
		return *x.End
	}
	return 0
}

// A list of string-type values.
type StringArray struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// String type values.
	TxtValues []string `protobuf:"bytes,1,rep,name=txt_values,json=txtValues,proto3" json:"txt_values,omitempty"`
}

func (x *StringArray) Reset() {
	*x = StringArray{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_visionai_v1alpha1_warehouse_proto_msgTypes[57]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *StringArray) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*StringArray) ProtoMessage() {}

func (x *StringArray) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_visionai_v1alpha1_warehouse_proto_msgTypes[57]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use StringArray.ProtoReflect.Descriptor instead.
func (*StringArray) Descriptor() ([]byte, []int) {
	return file_google_cloud_visionai_v1alpha1_warehouse_proto_rawDescGZIP(), []int{57}
}

func (x *StringArray) GetTxtValues() []string {
	if x != nil {
		return x.TxtValues
	}
	return nil
}

// A list of integer range values.
type IntRangeArray struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Int range values.
	IntRanges []*IntRange `protobuf:"bytes,1,rep,name=int_ranges,json=intRanges,proto3" json:"int_ranges,omitempty"`
}

func (x *IntRangeArray) Reset() {
	*x = IntRangeArray{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_visionai_v1alpha1_warehouse_proto_msgTypes[58]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *IntRangeArray) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*IntRangeArray) ProtoMessage() {}

func (x *IntRangeArray) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_visionai_v1alpha1_warehouse_proto_msgTypes[58]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use IntRangeArray.ProtoReflect.Descriptor instead.
func (*IntRangeArray) Descriptor() ([]byte, []int) {
	return file_google_cloud_visionai_v1alpha1_warehouse_proto_rawDescGZIP(), []int{58}
}

func (x *IntRangeArray) GetIntRanges() []*IntRange {
	if x != nil {
		return x.IntRanges
	}
	return nil
}

// A list of float range values.
type FloatRangeArray struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Float range values.
	FloatRanges []*FloatRange `protobuf:"bytes,1,rep,name=float_ranges,json=floatRanges,proto3" json:"float_ranges,omitempty"`
}

func (x *FloatRangeArray) Reset() {
	*x = FloatRangeArray{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_visionai_v1alpha1_warehouse_proto_msgTypes[59]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *FloatRangeArray) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*FloatRangeArray) ProtoMessage() {}

func (x *FloatRangeArray) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_visionai_v1alpha1_warehouse_proto_msgTypes[59]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use FloatRangeArray.ProtoReflect.Descriptor instead.
func (*FloatRangeArray) Descriptor() ([]byte, []int) {
	return file_google_cloud_visionai_v1alpha1_warehouse_proto_rawDescGZIP(), []int{59}
}

func (x *FloatRangeArray) GetFloatRanges() []*FloatRange {
	if x != nil {
		return x.FloatRanges
	}
	return nil
}

// Datetime range type.
type DateTimeRange struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Start date time.
	Start *datetime.DateTime `protobuf:"bytes,1,opt,name=start,proto3" json:"start,omitempty"`
	// End data time.
	End *datetime.DateTime `protobuf:"bytes,2,opt,name=end,proto3" json:"end,omitempty"`
}

func (x *DateTimeRange) Reset() {
	*x = DateTimeRange{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_visionai_v1alpha1_warehouse_proto_msgTypes[60]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DateTimeRange) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DateTimeRange) ProtoMessage() {}

func (x *DateTimeRange) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_visionai_v1alpha1_warehouse_proto_msgTypes[60]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DateTimeRange.ProtoReflect.Descriptor instead.
func (*DateTimeRange) Descriptor() ([]byte, []int) {
	return file_google_cloud_visionai_v1alpha1_warehouse_proto_rawDescGZIP(), []int{60}
}

func (x *DateTimeRange) GetStart() *datetime.DateTime {
	if x != nil {
		return x.Start
	}
	return nil
}

func (x *DateTimeRange) GetEnd() *datetime.DateTime {
	if x != nil {
		return x.End
	}
	return nil
}

// A list of datetime range values.
type DateTimeRangeArray struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Date time ranges.
	DateTimeRanges []*DateTimeRange `protobuf:"bytes,1,rep,name=date_time_ranges,json=dateTimeRanges,proto3" json:"date_time_ranges,omitempty"`
}

func (x *DateTimeRangeArray) Reset() {
	*x = DateTimeRangeArray{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_visionai_v1alpha1_warehouse_proto_msgTypes[61]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DateTimeRangeArray) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DateTimeRangeArray) ProtoMessage() {}

func (x *DateTimeRangeArray) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_visionai_v1alpha1_warehouse_proto_msgTypes[61]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DateTimeRangeArray.ProtoReflect.Descriptor instead.
func (*DateTimeRangeArray) Descriptor() ([]byte, []int) {
	return file_google_cloud_visionai_v1alpha1_warehouse_proto_rawDescGZIP(), []int{61}
}

func (x *DateTimeRangeArray) GetDateTimeRanges() []*DateTimeRange {
	if x != nil {
		return x.DateTimeRanges
	}
	return nil
}

// Representation of a circle area.
type CircleArea struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Latitude of circle area's center. Degrees [-90 .. 90]
	Latitude float64 `protobuf:"fixed64,1,opt,name=latitude,proto3" json:"latitude,omitempty"`
	// Longitude of circle area's center. Degrees [-180 .. 180]
	Longitude float64 `protobuf:"fixed64,2,opt,name=longitude,proto3" json:"longitude,omitempty"`
	// Radius of the circle area in meters.
	RadiusMeter float64 `protobuf:"fixed64,3,opt,name=radius_meter,json=radiusMeter,proto3" json:"radius_meter,omitempty"`
}

func (x *CircleArea) Reset() {
	*x = CircleArea{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_visionai_v1alpha1_warehouse_proto_msgTypes[62]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CircleArea) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CircleArea) ProtoMessage() {}

func (x *CircleArea) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_visionai_v1alpha1_warehouse_proto_msgTypes[62]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CircleArea.ProtoReflect.Descriptor instead.
func (*CircleArea) Descriptor() ([]byte, []int) {
	return file_google_cloud_visionai_v1alpha1_warehouse_proto_rawDescGZIP(), []int{62}
}

func (x *CircleArea) GetLatitude() float64 {
	if x != nil {
		return x.Latitude
	}
	return 0
}

func (x *CircleArea) GetLongitude() float64 {
	if x != nil {
		return x.Longitude
	}
	return 0
}

func (x *CircleArea) GetRadiusMeter() float64 {
	if x != nil {
		return x.RadiusMeter
	}
	return 0
}

// A list of locations.
type GeoLocationArray struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// A list of circle areas.
	CircleAreas []*CircleArea `protobuf:"bytes,1,rep,name=circle_areas,json=circleAreas,proto3" json:"circle_areas,omitempty"`
}

func (x *GeoLocationArray) Reset() {
	*x = GeoLocationArray{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_visionai_v1alpha1_warehouse_proto_msgTypes[63]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GeoLocationArray) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GeoLocationArray) ProtoMessage() {}

func (x *GeoLocationArray) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_visionai_v1alpha1_warehouse_proto_msgTypes[63]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GeoLocationArray.ProtoReflect.Descriptor instead.
func (*GeoLocationArray) Descriptor() ([]byte, []int) {
	return file_google_cloud_visionai_v1alpha1_warehouse_proto_rawDescGZIP(), []int{63}
}

func (x *GeoLocationArray) GetCircleAreas() []*CircleArea {
	if x != nil {
		return x.CircleAreas
	}
	return nil
}

type BoolValue struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Value bool `protobuf:"varint,1,opt,name=value,proto3" json:"value,omitempty"`
}

func (x *BoolValue) Reset() {
	*x = BoolValue{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_visionai_v1alpha1_warehouse_proto_msgTypes[64]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *BoolValue) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*BoolValue) ProtoMessage() {}

func (x *BoolValue) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_visionai_v1alpha1_warehouse_proto_msgTypes[64]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use BoolValue.ProtoReflect.Descriptor instead.
func (*BoolValue) Descriptor() ([]byte, []int) {
	return file_google_cloud_visionai_v1alpha1_warehouse_proto_rawDescGZIP(), []int{64}
}

func (x *BoolValue) GetValue() bool {
	if x != nil {
		return x.Value
	}
	return false
}

// Filter criteria applied to current search results.
type Criteria struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Types that are assignable to Value:
	//
	//	*Criteria_TextArray
	//	*Criteria_IntRangeArray
	//	*Criteria_FloatRangeArray
	//	*Criteria_DateTimeRangeArray
	//	*Criteria_GeoLocationArray
	//	*Criteria_BoolValue
	Value isCriteria_Value `protobuf_oneof:"value"`
	// The UGA field or ML field to apply filtering criteria.
	Field string `protobuf:"bytes,1,opt,name=field,proto3" json:"field,omitempty"`
	// If true, return query matched annotations for this criteria.
	// This option is only applicable for partition level annotations and supports
	// the following data types:
	//   - INTEGER
	//   - FLOAT
	//   - STRING (DataSchema.SearchStrategy.EXACT_SEARCH only)
	//   - BOOLEAN
	FetchMatchedAnnotations bool `protobuf:"varint,8,opt,name=fetch_matched_annotations,json=fetchMatchedAnnotations,proto3" json:"fetch_matched_annotations,omitempty"`
}

func (x *Criteria) Reset() {
	*x = Criteria{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_visionai_v1alpha1_warehouse_proto_msgTypes[65]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Criteria) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Criteria) ProtoMessage() {}

func (x *Criteria) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_visionai_v1alpha1_warehouse_proto_msgTypes[65]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Criteria.ProtoReflect.Descriptor instead.
func (*Criteria) Descriptor() ([]byte, []int) {
	return file_google_cloud_visionai_v1alpha1_warehouse_proto_rawDescGZIP(), []int{65}
}

func (m *Criteria) GetValue() isCriteria_Value {
	if m != nil {
		return m.Value
	}
	return nil
}

func (x *Criteria) GetTextArray() *StringArray {
	if x, ok := x.GetValue().(*Criteria_TextArray); ok {
		return x.TextArray
	}
	return nil
}

func (x *Criteria) GetIntRangeArray() *IntRangeArray {
	if x, ok := x.GetValue().(*Criteria_IntRangeArray); ok {
		return x.IntRangeArray
	}
	return nil
}

func (x *Criteria) GetFloatRangeArray() *FloatRangeArray {
	if x, ok := x.GetValue().(*Criteria_FloatRangeArray); ok {
		return x.FloatRangeArray
	}
	return nil
}

func (x *Criteria) GetDateTimeRangeArray() *DateTimeRangeArray {
	if x, ok := x.GetValue().(*Criteria_DateTimeRangeArray); ok {
		return x.DateTimeRangeArray
	}
	return nil
}

func (x *Criteria) GetGeoLocationArray() *GeoLocationArray {
	if x, ok := x.GetValue().(*Criteria_GeoLocationArray); ok {
		return x.GeoLocationArray
	}
	return nil
}

func (x *Criteria) GetBoolValue() *BoolValue {
	if x, ok := x.GetValue().(*Criteria_BoolValue); ok {
		return x.BoolValue
	}
	return nil
}

func (x *Criteria) GetField() string {
	if x != nil {
		return x.Field
	}
	return ""
}

func (x *Criteria) GetFetchMatchedAnnotations() bool {
	if x != nil {
		return x.FetchMatchedAnnotations
	}
	return false
}

type isCriteria_Value interface {
	isCriteria_Value()
}

type Criteria_TextArray struct {
	// The text values associated with the field.
	TextArray *StringArray `protobuf:"bytes,2,opt,name=text_array,json=textArray,proto3,oneof"`
}

type Criteria_IntRangeArray struct {
	// The integer ranges associated with the field.
	IntRangeArray *IntRangeArray `protobuf:"bytes,3,opt,name=int_range_array,json=intRangeArray,proto3,oneof"`
}

type Criteria_FloatRangeArray struct {
	// The float ranges associated with the field.
	FloatRangeArray *FloatRangeArray `protobuf:"bytes,4,opt,name=float_range_array,json=floatRangeArray,proto3,oneof"`
}

type Criteria_DateTimeRangeArray struct {
	// The datetime ranges associated with the field.
	DateTimeRangeArray *DateTimeRangeArray `protobuf:"bytes,5,opt,name=date_time_range_array,json=dateTimeRangeArray,proto3,oneof"`
}

type Criteria_GeoLocationArray struct {
	// Geo Location array.
	GeoLocationArray *GeoLocationArray `protobuf:"bytes,6,opt,name=geo_location_array,json=geoLocationArray,proto3,oneof"`
}

type Criteria_BoolValue struct {
	// A Boolean value.
	BoolValue *BoolValue `protobuf:"bytes,7,opt,name=bool_value,json=boolValue,proto3,oneof"`
}

func (*Criteria_TextArray) isCriteria_Value() {}

func (*Criteria_IntRangeArray) isCriteria_Value() {}

func (*Criteria_FloatRangeArray) isCriteria_Value() {}

func (*Criteria_DateTimeRangeArray) isCriteria_Value() {}

func (*Criteria_GeoLocationArray) isCriteria_Value() {}

func (*Criteria_BoolValue) isCriteria_Value() {}

// Partition to specify the partition in time and space for sub-asset level
// annotation.
type Partition struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Partition of asset in time.
	TemporalPartition *Partition_TemporalPartition `protobuf:"bytes,1,opt,name=temporal_partition,json=temporalPartition,proto3" json:"temporal_partition,omitempty"`
	// Partition of asset in space.
	SpatialPartition *Partition_SpatialPartition `protobuf:"bytes,2,opt,name=spatial_partition,json=spatialPartition,proto3" json:"spatial_partition,omitempty"`
}

func (x *Partition) Reset() {
	*x = Partition{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_visionai_v1alpha1_warehouse_proto_msgTypes[66]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Partition) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Partition) ProtoMessage() {}

func (x *Partition) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_visionai_v1alpha1_warehouse_proto_msgTypes[66]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Partition.ProtoReflect.Descriptor instead.
func (*Partition) Descriptor() ([]byte, []int) {
	return file_google_cloud_visionai_v1alpha1_warehouse_proto_rawDescGZIP(), []int{66}
}

func (x *Partition) GetTemporalPartition() *Partition_TemporalPartition {
	if x != nil {
		return x.TemporalPartition
	}
	return nil
}

func (x *Partition) GetSpatialPartition() *Partition_SpatialPartition {
	if x != nil {
		return x.SpatialPartition
	}
	return nil
}

// The metadata for DeleteAsset API that embeds in
// [metadata][google.longrunning.Operation.metadata] field.
type DeleteAssetMetadata struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *DeleteAssetMetadata) Reset() {
	*x = DeleteAssetMetadata{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_visionai_v1alpha1_warehouse_proto_msgTypes[67]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DeleteAssetMetadata) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeleteAssetMetadata) ProtoMessage() {}

func (x *DeleteAssetMetadata) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_visionai_v1alpha1_warehouse_proto_msgTypes[67]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeleteAssetMetadata.ProtoReflect.Descriptor instead.
func (*DeleteAssetMetadata) Descriptor() ([]byte, []int) {
	return file_google_cloud_visionai_v1alpha1_warehouse_proto_rawDescGZIP(), []int{67}
}

// Metadata for CreateCorpus API.
type CreateCorpusMetadata struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *CreateCorpusMetadata) Reset() {
	*x = CreateCorpusMetadata{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_visionai_v1alpha1_warehouse_proto_msgTypes[68]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CreateCorpusMetadata) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreateCorpusMetadata) ProtoMessage() {}

func (x *CreateCorpusMetadata) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_visionai_v1alpha1_warehouse_proto_msgTypes[68]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CreateCorpusMetadata.ProtoReflect.Descriptor instead.
func (*CreateCorpusMetadata) Descriptor() ([]byte, []int) {
	return file_google_cloud_visionai_v1alpha1_warehouse_proto_rawDescGZIP(), []int{68}
}

// The configuration for `PROTO_ANY` data type.
type DataSchemaDetails_ProtoAnyConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The type URI of the proto message.
	TypeUri string `protobuf:"bytes,1,opt,name=type_uri,json=typeUri,proto3" json:"type_uri,omitempty"`
}

func (x *DataSchemaDetails_ProtoAnyConfig) Reset() {
	*x = DataSchemaDetails_ProtoAnyConfig{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_visionai_v1alpha1_warehouse_proto_msgTypes[69]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DataSchemaDetails_ProtoAnyConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DataSchemaDetails_ProtoAnyConfig) ProtoMessage() {}

func (x *DataSchemaDetails_ProtoAnyConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_visionai_v1alpha1_warehouse_proto_msgTypes[69]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DataSchemaDetails_ProtoAnyConfig.ProtoReflect.Descriptor instead.
func (*DataSchemaDetails_ProtoAnyConfig) Descriptor() ([]byte, []int) {
	return file_google_cloud_visionai_v1alpha1_warehouse_proto_rawDescGZIP(), []int{16, 0}
}

func (x *DataSchemaDetails_ProtoAnyConfig) GetTypeUri() string {
	if x != nil {
		return x.TypeUri
	}
	return ""
}

// The search strategy for annotations value of the `key`.
type DataSchemaDetails_SearchStrategy struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The type of search strategy to be applied on the `key` above.
	// The allowed `search_strategy_type` is different for different data types,
	// which is documented in the DataSchemaDetails.DataType. Specifying
	// unsupported `search_strategy_type` for data types will result in
	// INVALID_ARGUMENT error.
	SearchStrategyType DataSchemaDetails_SearchStrategy_SearchStrategyType `protobuf:"varint,1,opt,name=search_strategy_type,json=searchStrategyType,proto3,enum=google.cloud.visionai.v1alpha1.DataSchemaDetails_SearchStrategy_SearchStrategyType" json:"search_strategy_type,omitempty"`
}

func (x *DataSchemaDetails_SearchStrategy) Reset() {
	*x = DataSchemaDetails_SearchStrategy{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_visionai_v1alpha1_warehouse_proto_msgTypes[70]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DataSchemaDetails_SearchStrategy) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DataSchemaDetails_SearchStrategy) ProtoMessage() {}

func (x *DataSchemaDetails_SearchStrategy) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_visionai_v1alpha1_warehouse_proto_msgTypes[70]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DataSchemaDetails_SearchStrategy.ProtoReflect.Descriptor instead.
func (*DataSchemaDetails_SearchStrategy) Descriptor() ([]byte, []int) {
	return file_google_cloud_visionai_v1alpha1_warehouse_proto_rawDescGZIP(), []int{16, 1}
}

func (x *DataSchemaDetails_SearchStrategy) GetSearchStrategyType() DataSchemaDetails_SearchStrategy_SearchStrategyType {
	if x != nil {
		return x.SearchStrategyType
	}
	return DataSchemaDetails_SearchStrategy_NO_SEARCH
}

// If bucket type is FIXED_RANGE, specify how values are bucketized. Use
// FixedRangeBucketSpec when you want to create multiple buckets with equal
// granularities. Using integer bucket value as an example, when
// bucket_start = 0, bucket_granularity = 10, bucket_count = 5, this facet
// will be aggregated via the following buckets:
// [-inf, 0), [0, 10), [10, 20), [20, 30), [30, inf).
// Notably, bucket_count <= 1 is an invalid spec.
type FacetProperty_FixedRangeBucketSpec struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Lower bound of the bucket. NOTE: Only integer type is currently supported
	// for this field.
	BucketStart *FacetValue `protobuf:"bytes,1,opt,name=bucket_start,json=bucketStart,proto3" json:"bucket_start,omitempty"`
	// Bucket granularity. NOTE: Only integer type is currently supported for
	// this field.
	BucketGranularity *FacetValue `protobuf:"bytes,2,opt,name=bucket_granularity,json=bucketGranularity,proto3" json:"bucket_granularity,omitempty"`
	// Total number of buckets.
	BucketCount int32 `protobuf:"varint,3,opt,name=bucket_count,json=bucketCount,proto3" json:"bucket_count,omitempty"`
}

func (x *FacetProperty_FixedRangeBucketSpec) Reset() {
	*x = FacetProperty_FixedRangeBucketSpec{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_visionai_v1alpha1_warehouse_proto_msgTypes[71]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *FacetProperty_FixedRangeBucketSpec) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*FacetProperty_FixedRangeBucketSpec) ProtoMessage() {}

func (x *FacetProperty_FixedRangeBucketSpec) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_visionai_v1alpha1_warehouse_proto_msgTypes[71]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use FacetProperty_FixedRangeBucketSpec.ProtoReflect.Descriptor instead.
func (*FacetProperty_FixedRangeBucketSpec) Descriptor() ([]byte, []int) {
	return file_google_cloud_visionai_v1alpha1_warehouse_proto_rawDescGZIP(), []int{39, 0}
}

func (x *FacetProperty_FixedRangeBucketSpec) GetBucketStart() *FacetValue {
	if x != nil {
		return x.BucketStart
	}
	return nil
}

func (x *FacetProperty_FixedRangeBucketSpec) GetBucketGranularity() *FacetValue {
	if x != nil {
		return x.BucketGranularity
	}
	return nil
}

func (x *FacetProperty_FixedRangeBucketSpec) GetBucketCount() int32 {
	if x != nil {
		return x.BucketCount
	}
	return 0
}

// If bucket type is CUSTOM_RANGE, specify how values are bucketized. Use
// integer bucket value as an example, when the endpoints are 0, 10, 100, and
// 1000, we will generate the following facets:
// [-inf, 0), [0, 10), [10, 100), [100, 1000), [1000, inf).
// Notably:
//   - endpoints must be listed in ascending order. Otherwise, the SearchConfig
//     API will reject the facet config.
//   - < 1 endpoints is an invalid spec.
type FacetProperty_CustomRangeBucketSpec struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Currently, only integer type is supported for this field.
	Endpoints []*FacetValue `protobuf:"bytes,1,rep,name=endpoints,proto3" json:"endpoints,omitempty"`
}

func (x *FacetProperty_CustomRangeBucketSpec) Reset() {
	*x = FacetProperty_CustomRangeBucketSpec{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_visionai_v1alpha1_warehouse_proto_msgTypes[72]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *FacetProperty_CustomRangeBucketSpec) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*FacetProperty_CustomRangeBucketSpec) ProtoMessage() {}

func (x *FacetProperty_CustomRangeBucketSpec) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_visionai_v1alpha1_warehouse_proto_msgTypes[72]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use FacetProperty_CustomRangeBucketSpec.ProtoReflect.Descriptor instead.
func (*FacetProperty_CustomRangeBucketSpec) Descriptor() ([]byte, []int) {
	return file_google_cloud_visionai_v1alpha1_warehouse_proto_rawDescGZIP(), []int{39, 1}
}

func (x *FacetProperty_CustomRangeBucketSpec) GetEndpoints() []*FacetValue {
	if x != nil {
		return x.Endpoints
	}
	return nil
}

// If bucket type is DATE, specify how date values are bucketized.
type FacetProperty_DateTimeBucketSpec struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Granularity of date type facet.
	Granularity FacetProperty_DateTimeBucketSpec_Granularity `protobuf:"varint,1,opt,name=granularity,proto3,enum=google.cloud.visionai.v1alpha1.FacetProperty_DateTimeBucketSpec_Granularity" json:"granularity,omitempty"`
}

func (x *FacetProperty_DateTimeBucketSpec) Reset() {
	*x = FacetProperty_DateTimeBucketSpec{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_visionai_v1alpha1_warehouse_proto_msgTypes[73]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *FacetProperty_DateTimeBucketSpec) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*FacetProperty_DateTimeBucketSpec) ProtoMessage() {}

func (x *FacetProperty_DateTimeBucketSpec) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_visionai_v1alpha1_warehouse_proto_msgTypes[73]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use FacetProperty_DateTimeBucketSpec.ProtoReflect.Descriptor instead.
func (*FacetProperty_DateTimeBucketSpec) Descriptor() ([]byte, []int) {
	return file_google_cloud_visionai_v1alpha1_warehouse_proto_rawDescGZIP(), []int{39, 2}
}

func (x *FacetProperty_DateTimeBucketSpec) GetGranularity() FacetProperty_DateTimeBucketSpec_Granularity {
	if x != nil {
		return x.Granularity
	}
	return FacetProperty_DateTimeBucketSpec_GRANULARITY_UNSPECIFIED
}

// The range of values [start, end) for which faceting is applied.
type FacetBucket_Range struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Start of the range. Non-existence indicates some bound (e.g. -inf).
	Start *FacetValue `protobuf:"bytes,1,opt,name=start,proto3" json:"start,omitempty"`
	// End of the range. Non-existence indicates some bound (e.g. inf).
	End *FacetValue `protobuf:"bytes,2,opt,name=end,proto3" json:"end,omitempty"`
}

func (x *FacetBucket_Range) Reset() {
	*x = FacetBucket_Range{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_visionai_v1alpha1_warehouse_proto_msgTypes[74]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *FacetBucket_Range) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*FacetBucket_Range) ProtoMessage() {}

func (x *FacetBucket_Range) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_visionai_v1alpha1_warehouse_proto_msgTypes[74]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use FacetBucket_Range.ProtoReflect.Descriptor instead.
func (*FacetBucket_Range) Descriptor() ([]byte, []int) {
	return file_google_cloud_visionai_v1alpha1_warehouse_proto_rawDescGZIP(), []int{42, 0}
}

func (x *FacetBucket_Range) GetStart() *FacetValue {
	if x != nil {
		return x.Start
	}
	return nil
}

func (x *FacetBucket_Range) GetEnd() *FacetValue {
	if x != nil {
		return x.End
	}
	return nil
}

// Configuration for the data.
type IngestAssetRequest_Config struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Types that are assignable to DataType:
	//
	//	*IngestAssetRequest_Config_VideoType_
	DataType isIngestAssetRequest_Config_DataType `protobuf_oneof:"data_type"`
	// Required. The resource name of the asset that the ingested data belongs to.
	Asset string `protobuf:"bytes,1,opt,name=asset,proto3" json:"asset,omitempty"`
}

func (x *IngestAssetRequest_Config) Reset() {
	*x = IngestAssetRequest_Config{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_visionai_v1alpha1_warehouse_proto_msgTypes[75]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *IngestAssetRequest_Config) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*IngestAssetRequest_Config) ProtoMessage() {}

func (x *IngestAssetRequest_Config) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_visionai_v1alpha1_warehouse_proto_msgTypes[75]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use IngestAssetRequest_Config.ProtoReflect.Descriptor instead.
func (*IngestAssetRequest_Config) Descriptor() ([]byte, []int) {
	return file_google_cloud_visionai_v1alpha1_warehouse_proto_rawDescGZIP(), []int{44, 0}
}

func (m *IngestAssetRequest_Config) GetDataType() isIngestAssetRequest_Config_DataType {
	if m != nil {
		return m.DataType
	}
	return nil
}

func (x *IngestAssetRequest_Config) GetVideoType() *IngestAssetRequest_Config_VideoType {
	if x, ok := x.GetDataType().(*IngestAssetRequest_Config_VideoType_); ok {
		return x.VideoType
	}
	return nil
}

func (x *IngestAssetRequest_Config) GetAsset() string {
	if x != nil {
		return x.Asset
	}
	return ""
}

type isIngestAssetRequest_Config_DataType interface {
	isIngestAssetRequest_Config_DataType()
}

type IngestAssetRequest_Config_VideoType_ struct {
	// Type information for video data.
	VideoType *IngestAssetRequest_Config_VideoType `protobuf:"bytes,2,opt,name=video_type,json=videoType,proto3,oneof"`
}

func (*IngestAssetRequest_Config_VideoType_) isIngestAssetRequest_Config_DataType() {}

// Contains the data and the corresponding time range this data is for.
type IngestAssetRequest_TimeIndexedData struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Data to be ingested.
	Data []byte `protobuf:"bytes,1,opt,name=data,proto3" json:"data,omitempty"`
	// Time range of the data.
	TemporalPartition *Partition_TemporalPartition `protobuf:"bytes,2,opt,name=temporal_partition,json=temporalPartition,proto3" json:"temporal_partition,omitempty"`
}

func (x *IngestAssetRequest_TimeIndexedData) Reset() {
	*x = IngestAssetRequest_TimeIndexedData{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_visionai_v1alpha1_warehouse_proto_msgTypes[76]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *IngestAssetRequest_TimeIndexedData) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*IngestAssetRequest_TimeIndexedData) ProtoMessage() {}

func (x *IngestAssetRequest_TimeIndexedData) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_visionai_v1alpha1_warehouse_proto_msgTypes[76]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use IngestAssetRequest_TimeIndexedData.ProtoReflect.Descriptor instead.
func (*IngestAssetRequest_TimeIndexedData) Descriptor() ([]byte, []int) {
	return file_google_cloud_visionai_v1alpha1_warehouse_proto_rawDescGZIP(), []int{44, 1}
}

func (x *IngestAssetRequest_TimeIndexedData) GetData() []byte {
	if x != nil {
		return x.Data
	}
	return nil
}

func (x *IngestAssetRequest_TimeIndexedData) GetTemporalPartition() *Partition_TemporalPartition {
	if x != nil {
		return x.TemporalPartition
	}
	return nil
}

// Type information for video data.
type IngestAssetRequest_Config_VideoType struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Container format of the video data.
	ContainerFormat IngestAssetRequest_Config_VideoType_ContainerFormat `protobuf:"varint,1,opt,name=container_format,json=containerFormat,proto3,enum=google.cloud.visionai.v1alpha1.IngestAssetRequest_Config_VideoType_ContainerFormat" json:"container_format,omitempty"`
}

func (x *IngestAssetRequest_Config_VideoType) Reset() {
	*x = IngestAssetRequest_Config_VideoType{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_visionai_v1alpha1_warehouse_proto_msgTypes[77]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *IngestAssetRequest_Config_VideoType) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*IngestAssetRequest_Config_VideoType) ProtoMessage() {}

func (x *IngestAssetRequest_Config_VideoType) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_visionai_v1alpha1_warehouse_proto_msgTypes[77]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use IngestAssetRequest_Config_VideoType.ProtoReflect.Descriptor instead.
func (*IngestAssetRequest_Config_VideoType) Descriptor() ([]byte, []int) {
	return file_google_cloud_visionai_v1alpha1_warehouse_proto_rawDescGZIP(), []int{44, 0, 0}
}

func (x *IngestAssetRequest_Config_VideoType) GetContainerFormat() IngestAssetRequest_Config_VideoType_ContainerFormat {
	if x != nil {
		return x.ContainerFormat
	}
	return IngestAssetRequest_Config_VideoType_CONTAINER_FORMAT_UNSPECIFIED
}

// Signed uri with corresponding time range.
type ClipAssetResponse_TimeIndexedUri struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Time range of the video that the uri is for.
	TemporalPartition *Partition_TemporalPartition `protobuf:"bytes,1,opt,name=temporal_partition,json=temporalPartition,proto3" json:"temporal_partition,omitempty"`
	// Signed uri to download the video clip.
	Uri string `protobuf:"bytes,2,opt,name=uri,proto3" json:"uri,omitempty"`
}

func (x *ClipAssetResponse_TimeIndexedUri) Reset() {
	*x = ClipAssetResponse_TimeIndexedUri{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_visionai_v1alpha1_warehouse_proto_msgTypes[78]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ClipAssetResponse_TimeIndexedUri) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ClipAssetResponse_TimeIndexedUri) ProtoMessage() {}

func (x *ClipAssetResponse_TimeIndexedUri) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_visionai_v1alpha1_warehouse_proto_msgTypes[78]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ClipAssetResponse_TimeIndexedUri.ProtoReflect.Descriptor instead.
func (*ClipAssetResponse_TimeIndexedUri) Descriptor() ([]byte, []int) {
	return file_google_cloud_visionai_v1alpha1_warehouse_proto_rawDescGZIP(), []int{47, 0}
}

func (x *ClipAssetResponse_TimeIndexedUri) GetTemporalPartition() *Partition_TemporalPartition {
	if x != nil {
		return x.TemporalPartition
	}
	return nil
}

func (x *ClipAssetResponse_TimeIndexedUri) GetUri() string {
	if x != nil {
		return x.Uri
	}
	return ""
}

// Option for one data schema key.
type SchemaKeySortingStrategy_Option struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The data used to sort.
	DataSchemaKey string `protobuf:"bytes,1,opt,name=data_schema_key,json=dataSchemaKey,proto3" json:"data_schema_key,omitempty"`
	// Whether to sort in decreasing order or increasing order.
	// By default, results are sorted in incresing order.
	SortDecreasing bool `protobuf:"varint,2,opt,name=sort_decreasing,json=sortDecreasing,proto3" json:"sort_decreasing,omitempty"`
	// Aggregate method for the current data schema key.
	AggregateMethod *SchemaKeySortingStrategy_Option_AggregateMethod `protobuf:"varint,3,opt,name=aggregate_method,json=aggregateMethod,proto3,enum=google.cloud.visionai.v1alpha1.SchemaKeySortingStrategy_Option_AggregateMethod,oneof" json:"aggregate_method,omitempty"`
}

func (x *SchemaKeySortingStrategy_Option) Reset() {
	*x = SchemaKeySortingStrategy_Option{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_visionai_v1alpha1_warehouse_proto_msgTypes[79]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SchemaKeySortingStrategy_Option) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SchemaKeySortingStrategy_Option) ProtoMessage() {}

func (x *SchemaKeySortingStrategy_Option) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_visionai_v1alpha1_warehouse_proto_msgTypes[79]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SchemaKeySortingStrategy_Option.ProtoReflect.Descriptor instead.
func (*SchemaKeySortingStrategy_Option) Descriptor() ([]byte, []int) {
	return file_google_cloud_visionai_v1alpha1_warehouse_proto_rawDescGZIP(), []int{51, 0}
}

func (x *SchemaKeySortingStrategy_Option) GetDataSchemaKey() string {
	if x != nil {
		return x.DataSchemaKey
	}
	return ""
}

func (x *SchemaKeySortingStrategy_Option) GetSortDecreasing() bool {
	if x != nil {
		return x.SortDecreasing
	}
	return false
}

func (x *SchemaKeySortingStrategy_Option) GetAggregateMethod() SchemaKeySortingStrategy_Option_AggregateMethod {
	if x != nil && x.AggregateMethod != nil {
		return *x.AggregateMethod
	}
	return SchemaKeySortingStrategy_Option_AGGREGATE_METHOD_UNSPECIFIED
}

// Partition of asset in UTC Epoch time.
type Partition_TemporalPartition struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Start time of the partition.
	StartTime *timestamppb.Timestamp `protobuf:"bytes,1,opt,name=start_time,json=startTime,proto3" json:"start_time,omitempty"`
	// End time of the partition.
	EndTime *timestamppb.Timestamp `protobuf:"bytes,2,opt,name=end_time,json=endTime,proto3" json:"end_time,omitempty"`
}

func (x *Partition_TemporalPartition) Reset() {
	*x = Partition_TemporalPartition{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_visionai_v1alpha1_warehouse_proto_msgTypes[80]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Partition_TemporalPartition) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Partition_TemporalPartition) ProtoMessage() {}

func (x *Partition_TemporalPartition) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_visionai_v1alpha1_warehouse_proto_msgTypes[80]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Partition_TemporalPartition.ProtoReflect.Descriptor instead.
func (*Partition_TemporalPartition) Descriptor() ([]byte, []int) {
	return file_google_cloud_visionai_v1alpha1_warehouse_proto_rawDescGZIP(), []int{66, 0}
}

func (x *Partition_TemporalPartition) GetStartTime() *timestamppb.Timestamp {
	if x != nil {
		return x.StartTime
	}
	return nil
}

func (x *Partition_TemporalPartition) GetEndTime() *timestamppb.Timestamp {
	if x != nil {
		return x.EndTime
	}
	return nil
}

// Partition of asset in space.
type Partition_SpatialPartition struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The minimum x coordinate value.
	XMin *int64 `protobuf:"varint,1,opt,name=x_min,json=xMin,proto3,oneof" json:"x_min,omitempty"`
	// The minimum y coordinate value.
	YMin *int64 `protobuf:"varint,2,opt,name=y_min,json=yMin,proto3,oneof" json:"y_min,omitempty"`
	// The maximum x coordinate value.
	XMax *int64 `protobuf:"varint,3,opt,name=x_max,json=xMax,proto3,oneof" json:"x_max,omitempty"`
	// The maximum y coordinate value.
	YMax *int64 `protobuf:"varint,4,opt,name=y_max,json=yMax,proto3,oneof" json:"y_max,omitempty"`
}

func (x *Partition_SpatialPartition) Reset() {
	*x = Partition_SpatialPartition{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_visionai_v1alpha1_warehouse_proto_msgTypes[81]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Partition_SpatialPartition) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Partition_SpatialPartition) ProtoMessage() {}

func (x *Partition_SpatialPartition) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_visionai_v1alpha1_warehouse_proto_msgTypes[81]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Partition_SpatialPartition.ProtoReflect.Descriptor instead.
func (*Partition_SpatialPartition) Descriptor() ([]byte, []int) {
	return file_google_cloud_visionai_v1alpha1_warehouse_proto_rawDescGZIP(), []int{66, 1}
}

func (x *Partition_SpatialPartition) GetXMin() int64 {
	if x != nil && x.XMin != nil {
		return *x.XMin
	}
	return 0
}

func (x *Partition_SpatialPartition) GetYMin() int64 {
	if x != nil && x.YMin != nil {
		return *x.YMin
	}
	return 0
}

func (x *Partition_SpatialPartition) GetXMax() int64 {
	if x != nil && x.XMax != nil {
		return *x.XMax
	}
	return 0
}

func (x *Partition_SpatialPartition) GetYMax() int64 {
	if x != nil && x.YMax != nil {
		return *x.YMax
	}
	return 0
}

var File_google_cloud_visionai_v1alpha1_warehouse_proto protoreflect.FileDescriptor

var file_google_cloud_visionai_v1alpha1_warehouse_proto_rawDesc = []byte{
	0x0a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x76,
	0x69, 0x73, 0x69, 0x6f, 0x6e, 0x61, 0x69, 0x2f, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31,
	0x2f, 0x77, 0x61, 0x72, 0x65, 0x68, 0x6f, 0x75, 0x73, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x12, 0x1e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76,
	0x69, 0x73, 0x69, 0x6f, 0x6e, 0x61, 0x69, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31,
	0x1a, 0x1c, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x61, 0x6e, 0x6e,
	0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x17,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x63, 0x6c, 0x69, 0x65, 0x6e,
	0x74, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f,
	0x61, 0x70, 0x69, 0x2f, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x5f, 0x62, 0x65, 0x68, 0x61, 0x76, 0x69,
	0x6f, 0x72, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x19, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2f, 0x61, 0x70, 0x69, 0x2f, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x1a, 0x23, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x6c, 0x6f, 0x6e, 0x67,
	0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x2f, 0x6f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x19, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x61, 0x6e, 0x79, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x1a, 0x1e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x62, 0x75, 0x66, 0x2f, 0x64, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x1a, 0x1b, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x62, 0x75, 0x66, 0x2f, 0x65, 0x6d, 0x70, 0x74, 0x79, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x1a, 0x20, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75,
	0x66, 0x2f, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x1a, 0x1c, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x62, 0x75, 0x66, 0x2f, 0x73, 0x74, 0x72, 0x75, 0x63, 0x74, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75,
	0x66, 0x2f, 0x74, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x1a, 0x17, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x72, 0x70, 0x63, 0x2f, 0x73, 0x74,
	0x61, 0x74, 0x75, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1a, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2f, 0x74, 0x79, 0x70, 0x65, 0x2f, 0x64, 0x61, 0x74, 0x65, 0x74, 0x69, 0x6d, 0x65,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x22, 0xc8, 0x01, 0x0a, 0x12, 0x43, 0x72, 0x65, 0x61, 0x74,
	0x65, 0x41, 0x73, 0x73, 0x65, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x3e, 0x0a,
	0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x26, 0xe0,
	0x41, 0x02, 0xfa, 0x41, 0x20, 0x0a, 0x1e, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x61, 0x69, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x43,
	0x6f, 0x72, 0x70, 0x75, 0x73, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x40, 0x0a,
	0x05, 0x61, 0x73, 0x73, 0x65, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x25, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x73, 0x69,
	0x6f, 0x6e, 0x61, 0x69, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e, 0x41, 0x73,
	0x73, 0x65, 0x74, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x05, 0x61, 0x73, 0x73, 0x65, 0x74, 0x12,
	0x23, 0x0a, 0x08, 0x61, 0x73, 0x73, 0x65, 0x74, 0x5f, 0x69, 0x64, 0x18, 0x03, 0x20, 0x01, 0x28,
	0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x48, 0x00, 0x52, 0x07, 0x61, 0x73, 0x73, 0x65, 0x74, 0x49,
	0x64, 0x88, 0x01, 0x01, 0x42, 0x0b, 0x0a, 0x09, 0x5f, 0x61, 0x73, 0x73, 0x65, 0x74, 0x5f, 0x69,
	0x64, 0x22, 0x4c, 0x0a, 0x0f, 0x47, 0x65, 0x74, 0x41, 0x73, 0x73, 0x65, 0x74, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x12, 0x39, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x09, 0x42, 0x25, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x1f, 0x0a, 0x1d, 0x76, 0x69, 0x73, 0x69,
	0x6f, 0x6e, 0x61, 0x69, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e,
	0x63, 0x6f, 0x6d, 0x2f, 0x41, 0x73, 0x73, 0x65, 0x74, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22,
	0x8e, 0x01, 0x0a, 0x11, 0x4c, 0x69, 0x73, 0x74, 0x41, 0x73, 0x73, 0x65, 0x74, 0x73, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x3d, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x25, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x1f, 0x12, 0x1d, 0x76,
	0x69, 0x73, 0x69, 0x6f, 0x6e, 0x61, 0x69, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70,
	0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x41, 0x73, 0x73, 0x65, 0x74, 0x52, 0x06, 0x70, 0x61,
	0x72, 0x65, 0x6e, 0x74, 0x12, 0x1b, 0x0a, 0x09, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x73, 0x69, 0x7a,
	0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x05, 0x52, 0x08, 0x70, 0x61, 0x67, 0x65, 0x53, 0x69, 0x7a,
	0x65, 0x12, 0x1d, 0x0a, 0x0a, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18,
	0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x70, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e,
	0x22, 0x7b, 0x0a, 0x12, 0x4c, 0x69, 0x73, 0x74, 0x41, 0x73, 0x73, 0x65, 0x74, 0x73, 0x52, 0x65,
	0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x3d, 0x0a, 0x06, 0x61, 0x73, 0x73, 0x65, 0x74, 0x73,
	0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x25, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x61, 0x69, 0x2e, 0x76,
	0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e, 0x41, 0x73, 0x73, 0x65, 0x74, 0x52, 0x06, 0x61,
	0x73, 0x73, 0x65, 0x74, 0x73, 0x12, 0x26, 0x0a, 0x0f, 0x6e, 0x65, 0x78, 0x74, 0x5f, 0x70, 0x61,
	0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d,
	0x6e, 0x65, 0x78, 0x74, 0x50, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x22, 0x93, 0x01,
	0x0a, 0x12, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x41, 0x73, 0x73, 0x65, 0x74, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x12, 0x40, 0x0a, 0x05, 0x61, 0x73, 0x73, 0x65, 0x74, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x25, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x61, 0x69, 0x2e, 0x76, 0x31, 0x61, 0x6c,
	0x70, 0x68, 0x61, 0x31, 0x2e, 0x41, 0x73, 0x73, 0x65, 0x74, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52,
	0x05, 0x61, 0x73, 0x73, 0x65, 0x74, 0x12, 0x3b, 0x0a, 0x0b, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65,
	0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x46, 0x69,
	0x65, 0x6c, 0x64, 0x4d, 0x61, 0x73, 0x6b, 0x52, 0x0a, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x4d,
	0x61, 0x73, 0x6b, 0x22, 0x4f, 0x0a, 0x12, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x41, 0x73, 0x73,
	0x65, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x39, 0x0a, 0x04, 0x6e, 0x61, 0x6d,
	0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x25, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x1f, 0x0a,
	0x1d, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x61, 0x69, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x41, 0x73, 0x73, 0x65, 0x74, 0x52, 0x04,
	0x6e, 0x61, 0x6d, 0x65, 0x22, 0xbc, 0x01, 0x0a, 0x05, 0x41, 0x73, 0x73, 0x65, 0x74, 0x12, 0x12,
	0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x6e, 0x61,
	0x6d, 0x65, 0x12, 0x2b, 0x0a, 0x03, 0x74, 0x74, 0x6c, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x19, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75,
	0x66, 0x2e, 0x44, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x03, 0x74, 0x74, 0x6c, 0x3a,
	0x72, 0xea, 0x41, 0x6f, 0x0a, 0x1d, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x61, 0x69, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x41, 0x73,
	0x73, 0x65, 0x74, 0x12, 0x4e, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x7b, 0x70,
	0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x5f, 0x6e, 0x75, 0x6d, 0x62, 0x65, 0x72, 0x7d, 0x2f, 0x6c,
	0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x7b, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x7d, 0x2f, 0x63, 0x6f, 0x72, 0x70, 0x6f, 0x72, 0x61, 0x2f, 0x7b, 0x63, 0x6f, 0x72,
	0x70, 0x75, 0x73, 0x7d, 0x2f, 0x61, 0x73, 0x73, 0x65, 0x74, 0x73, 0x2f, 0x7b, 0x61, 0x73, 0x73,
	0x65, 0x74, 0x7d, 0x22, 0x77, 0x0a, 0x13, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x43, 0x6f, 0x72,
	0x70, 0x75, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x1b, 0x0a, 0x06, 0x70, 0x61,
	0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52,
	0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x43, 0x0a, 0x06, 0x63, 0x6f, 0x72, 0x70, 0x75,
	0x73, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x26, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x61, 0x69, 0x2e,
	0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e, 0x43, 0x6f, 0x72, 0x70, 0x75, 0x73, 0x42,
	0x03, 0xe0, 0x41, 0x02, 0x52, 0x06, 0x63, 0x6f, 0x72, 0x70, 0x75, 0x73, 0x22, 0x92, 0x02, 0x0a,
	0x06, 0x43, 0x6f, 0x72, 0x70, 0x75, 0x73, 0x12, 0x12, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x26, 0x0a, 0x0c, 0x64,
	0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0b, 0x64, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x4e,
	0x61, 0x6d, 0x65, 0x12, 0x25, 0x0a, 0x0b, 0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69,
	0x6f, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0b, 0x64,
	0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x3f, 0x0a, 0x0b, 0x64, 0x65,
	0x66, 0x61, 0x75, 0x6c, 0x74, 0x5f, 0x74, 0x74, 0x6c, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x19, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75,
	0x66, 0x2e, 0x44, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52,
	0x0a, 0x64, 0x65, 0x66, 0x61, 0x75, 0x6c, 0x74, 0x54, 0x74, 0x6c, 0x3a, 0x64, 0xea, 0x41, 0x61,
	0x0a, 0x1e, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x61, 0x69, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x43, 0x6f, 0x72, 0x70, 0x75, 0x73,
	0x12, 0x3f, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x7b, 0x70, 0x72, 0x6f, 0x6a,
	0x65, 0x63, 0x74, 0x5f, 0x6e, 0x75, 0x6d, 0x62, 0x65, 0x72, 0x7d, 0x2f, 0x6c, 0x6f, 0x63, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x7b, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x7d,
	0x2f, 0x63, 0x6f, 0x72, 0x70, 0x6f, 0x72, 0x61, 0x2f, 0x7b, 0x63, 0x6f, 0x72, 0x70, 0x75, 0x73,
	0x7d, 0x22, 0x4e, 0x0a, 0x10, 0x47, 0x65, 0x74, 0x43, 0x6f, 0x72, 0x70, 0x75, 0x73, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x3a, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x09, 0x42, 0x26, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x20, 0x0a, 0x1e, 0x76, 0x69, 0x73,
	0x69, 0x6f, 0x6e, 0x61, 0x69, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73,
	0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x43, 0x6f, 0x72, 0x70, 0x75, 0x73, 0x52, 0x04, 0x6e, 0x61, 0x6d,
	0x65, 0x22, 0x97, 0x01, 0x0a, 0x13, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x43, 0x6f, 0x72, 0x70,
	0x75, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x43, 0x0a, 0x06, 0x63, 0x6f, 0x72,
	0x70, 0x75, 0x73, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x26, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x61,
	0x69, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e, 0x43, 0x6f, 0x72, 0x70, 0x75,
	0x73, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x06, 0x63, 0x6f, 0x72, 0x70, 0x75, 0x73, 0x12, 0x3b,
	0x0a, 0x0b, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x46, 0x69, 0x65, 0x6c, 0x64, 0x4d, 0x61, 0x73, 0x6b, 0x52,
	0x0a, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x4d, 0x61, 0x73, 0x6b, 0x22, 0x6d, 0x0a, 0x12, 0x4c,
	0x69, 0x73, 0x74, 0x43, 0x6f, 0x72, 0x70, 0x6f, 0x72, 0x61, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x12, 0x1b, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x1b,
	0x0a, 0x09, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x05, 0x52, 0x08, 0x70, 0x61, 0x67, 0x65, 0x53, 0x69, 0x7a, 0x65, 0x12, 0x1d, 0x0a, 0x0a, 0x70,
	0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x09, 0x70, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x22, 0x7f, 0x0a, 0x13, 0x4c, 0x69,
	0x73, 0x74, 0x43, 0x6f, 0x72, 0x70, 0x6f, 0x72, 0x61, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73,
	0x65, 0x12, 0x40, 0x0a, 0x07, 0x63, 0x6f, 0x72, 0x70, 0x6f, 0x72, 0x61, 0x18, 0x01, 0x20, 0x03,
	0x28, 0x0b, 0x32, 0x26, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x61, 0x69, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70,
	0x68, 0x61, 0x31, 0x2e, 0x43, 0x6f, 0x72, 0x70, 0x75, 0x73, 0x52, 0x07, 0x63, 0x6f, 0x72, 0x70,
	0x6f, 0x72, 0x61, 0x12, 0x26, 0x0a, 0x0f, 0x6e, 0x65, 0x78, 0x74, 0x5f, 0x70, 0x61, 0x67, 0x65,
	0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x6e, 0x65,
	0x78, 0x74, 0x50, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x22, 0x51, 0x0a, 0x13, 0x44,
	0x65, 0x6c, 0x65, 0x74, 0x65, 0x43, 0x6f, 0x72, 0x70, 0x75, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x12, 0x3a, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09,
	0x42, 0x26, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x20, 0x0a, 0x1e, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e,
	0x61, 0x69, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f,
	0x6d, 0x2f, 0x43, 0x6f, 0x72, 0x70, 0x75, 0x73, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22, 0xab,
	0x01, 0x0a, 0x17, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x44, 0x61, 0x74, 0x61, 0x53, 0x63, 0x68,
	0x65, 0x6d, 0x61, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x3e, 0x0a, 0x06, 0x70, 0x61,
	0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x26, 0xe0, 0x41, 0x02, 0xfa,
	0x41, 0x20, 0x0a, 0x1e, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x61, 0x69, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x43, 0x6f, 0x72, 0x70,
	0x75, 0x73, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x50, 0x0a, 0x0b, 0x64, 0x61,
	0x74, 0x61, 0x5f, 0x73, 0x63, 0x68, 0x65, 0x6d, 0x61, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x2a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76,
	0x69, 0x73, 0x69, 0x6f, 0x6e, 0x61, 0x69, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31,
	0x2e, 0x44, 0x61, 0x74, 0x61, 0x53, 0x63, 0x68, 0x65, 0x6d, 0x61, 0x42, 0x03, 0xe0, 0x41, 0x02,
	0x52, 0x0a, 0x64, 0x61, 0x74, 0x61, 0x53, 0x63, 0x68, 0x65, 0x6d, 0x61, 0x22, 0x96, 0x02, 0x0a,
	0x0a, 0x44, 0x61, 0x74, 0x61, 0x53, 0x63, 0x68, 0x65, 0x6d, 0x61, 0x12, 0x12, 0x0a, 0x04, 0x6e,
	0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12,
	0x15, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41,
	0x02, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x58, 0x0a, 0x0e, 0x73, 0x63, 0x68, 0x65, 0x6d, 0x61,
	0x5f, 0x64, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x73, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x31,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69,
	0x73, 0x69, 0x6f, 0x6e, 0x61, 0x69, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e,
	0x44, 0x61, 0x74, 0x61, 0x53, 0x63, 0x68, 0x65, 0x6d, 0x61, 0x44, 0x65, 0x74, 0x61, 0x69, 0x6c,
	0x73, 0x52, 0x0d, 0x73, 0x63, 0x68, 0x65, 0x6d, 0x61, 0x44, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x73,
	0x3a, 0x82, 0x01, 0xea, 0x41, 0x7f, 0x0a, 0x22, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x61, 0x69,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f,
	0x44, 0x61, 0x74, 0x61, 0x53, 0x63, 0x68, 0x65, 0x6d, 0x61, 0x12, 0x59, 0x70, 0x72, 0x6f, 0x6a,
	0x65, 0x63, 0x74, 0x73, 0x2f, 0x7b, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x5f, 0x6e, 0x75,
	0x6d, 0x62, 0x65, 0x72, 0x7d, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f,
	0x7b, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x7d, 0x2f, 0x63, 0x6f, 0x72, 0x70, 0x6f,
	0x72, 0x61, 0x2f, 0x7b, 0x63, 0x6f, 0x72, 0x70, 0x75, 0x73, 0x7d, 0x2f, 0x64, 0x61, 0x74, 0x61,
	0x53, 0x63, 0x68, 0x65, 0x6d, 0x61, 0x73, 0x2f, 0x7b, 0x64, 0x61, 0x74, 0x61, 0x5f, 0x73, 0x63,
	0x68, 0x65, 0x6d, 0x61, 0x7d, 0x22, 0xa0, 0x07, 0x0a, 0x11, 0x44, 0x61, 0x74, 0x61, 0x53, 0x63,
	0x68, 0x65, 0x6d, 0x61, 0x44, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x73, 0x12, 0x4e, 0x0a, 0x04, 0x74,
	0x79, 0x70, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x3a, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x61,
	0x69, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e, 0x44, 0x61, 0x74, 0x61, 0x53,
	0x63, 0x68, 0x65, 0x6d, 0x61, 0x44, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x73, 0x2e, 0x44, 0x61, 0x74,
	0x61, 0x54, 0x79, 0x70, 0x65, 0x52, 0x04, 0x74, 0x79, 0x70, 0x65, 0x12, 0x6a, 0x0a, 0x10, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x5f, 0x61, 0x6e, 0x79, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18,
	0x06, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x40, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x61, 0x69, 0x2e, 0x76, 0x31,
	0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e, 0x44, 0x61, 0x74, 0x61, 0x53, 0x63, 0x68, 0x65, 0x6d,
	0x61, 0x44, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x73, 0x2e, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x41, 0x6e,
	0x79, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x0e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x41, 0x6e,
	0x79, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x5f, 0x0a, 0x0b, 0x67, 0x72, 0x61, 0x6e, 0x75,
	0x6c, 0x61, 0x72, 0x69, 0x74, 0x79, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x3d, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x73, 0x69,
	0x6f, 0x6e, 0x61, 0x69, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e, 0x44, 0x61,
	0x74, 0x61, 0x53, 0x63, 0x68, 0x65, 0x6d, 0x61, 0x44, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x73, 0x2e,
	0x47, 0x72, 0x61, 0x6e, 0x75, 0x6c, 0x61, 0x72, 0x69, 0x74, 0x79, 0x52, 0x0b, 0x67, 0x72, 0x61,
	0x6e, 0x75, 0x6c, 0x61, 0x72, 0x69, 0x74, 0x79, 0x12, 0x69, 0x0a, 0x0f, 0x73, 0x65, 0x61, 0x72,
	0x63, 0x68, 0x5f, 0x73, 0x74, 0x72, 0x61, 0x74, 0x65, 0x67, 0x79, 0x18, 0x07, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x40, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x61, 0x69, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68,
	0x61, 0x31, 0x2e, 0x44, 0x61, 0x74, 0x61, 0x53, 0x63, 0x68, 0x65, 0x6d, 0x61, 0x44, 0x65, 0x74,
	0x61, 0x69, 0x6c, 0x73, 0x2e, 0x53, 0x65, 0x61, 0x72, 0x63, 0x68, 0x53, 0x74, 0x72, 0x61, 0x74,
	0x65, 0x67, 0x79, 0x52, 0x0e, 0x73, 0x65, 0x61, 0x72, 0x63, 0x68, 0x53, 0x74, 0x72, 0x61, 0x74,
	0x65, 0x67, 0x79, 0x1a, 0x2b, 0x0a, 0x0e, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x41, 0x6e, 0x79, 0x43,
	0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x19, 0x0a, 0x08, 0x74, 0x79, 0x70, 0x65, 0x5f, 0x75, 0x72,
	0x69, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x07, 0x74, 0x79, 0x70, 0x65, 0x55, 0x72, 0x69,
	0x1a, 0xe1, 0x01, 0x0a, 0x0e, 0x53, 0x65, 0x61, 0x72, 0x63, 0x68, 0x53, 0x74, 0x72, 0x61, 0x74,
	0x65, 0x67, 0x79, 0x12, 0x85, 0x01, 0x0a, 0x14, 0x73, 0x65, 0x61, 0x72, 0x63, 0x68, 0x5f, 0x73,
	0x74, 0x72, 0x61, 0x74, 0x65, 0x67, 0x79, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x0e, 0x32, 0x53, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x61, 0x69, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70,
	0x68, 0x61, 0x31, 0x2e, 0x44, 0x61, 0x74, 0x61, 0x53, 0x63, 0x68, 0x65, 0x6d, 0x61, 0x44, 0x65,
	0x74, 0x61, 0x69, 0x6c, 0x73, 0x2e, 0x53, 0x65, 0x61, 0x72, 0x63, 0x68, 0x53, 0x74, 0x72, 0x61,
	0x74, 0x65, 0x67, 0x79, 0x2e, 0x53, 0x65, 0x61, 0x72, 0x63, 0x68, 0x53, 0x74, 0x72, 0x61, 0x74,
	0x65, 0x67, 0x79, 0x54, 0x79, 0x70, 0x65, 0x52, 0x12, 0x73, 0x65, 0x61, 0x72, 0x63, 0x68, 0x53,
	0x74, 0x72, 0x61, 0x74, 0x65, 0x67, 0x79, 0x54, 0x79, 0x70, 0x65, 0x22, 0x47, 0x0a, 0x12, 0x53,
	0x65, 0x61, 0x72, 0x63, 0x68, 0x53, 0x74, 0x72, 0x61, 0x74, 0x65, 0x67, 0x79, 0x54, 0x79, 0x70,
	0x65, 0x12, 0x0d, 0x0a, 0x09, 0x4e, 0x4f, 0x5f, 0x53, 0x45, 0x41, 0x52, 0x43, 0x48, 0x10, 0x00,
	0x12, 0x10, 0x0a, 0x0c, 0x45, 0x58, 0x41, 0x43, 0x54, 0x5f, 0x53, 0x45, 0x41, 0x52, 0x43, 0x48,
	0x10, 0x01, 0x12, 0x10, 0x0a, 0x0c, 0x53, 0x4d, 0x41, 0x52, 0x54, 0x5f, 0x53, 0x45, 0x41, 0x52,
	0x43, 0x48, 0x10, 0x02, 0x22, 0x87, 0x01, 0x0a, 0x08, 0x44, 0x61, 0x74, 0x61, 0x54, 0x79, 0x70,
	0x65, 0x12, 0x19, 0x0a, 0x15, 0x44, 0x41, 0x54, 0x41, 0x5f, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x55,
	0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x0b, 0x0a, 0x07,
	0x49, 0x4e, 0x54, 0x45, 0x47, 0x45, 0x52, 0x10, 0x01, 0x12, 0x09, 0x0a, 0x05, 0x46, 0x4c, 0x4f,
	0x41, 0x54, 0x10, 0x02, 0x12, 0x0a, 0x0a, 0x06, 0x53, 0x54, 0x52, 0x49, 0x4e, 0x47, 0x10, 0x03,
	0x12, 0x0c, 0x0a, 0x08, 0x44, 0x41, 0x54, 0x45, 0x54, 0x49, 0x4d, 0x45, 0x10, 0x05, 0x12, 0x12,
	0x0a, 0x0e, 0x47, 0x45, 0x4f, 0x5f, 0x43, 0x4f, 0x4f, 0x52, 0x44, 0x49, 0x4e, 0x41, 0x54, 0x45,
	0x10, 0x07, 0x12, 0x0d, 0x0a, 0x09, 0x50, 0x52, 0x4f, 0x54, 0x4f, 0x5f, 0x41, 0x4e, 0x59, 0x10,
	0x08, 0x12, 0x0b, 0x0a, 0x07, 0x42, 0x4f, 0x4f, 0x4c, 0x45, 0x41, 0x4e, 0x10, 0x09, 0x22, 0x68,
	0x0a, 0x0b, 0x47, 0x72, 0x61, 0x6e, 0x75, 0x6c, 0x61, 0x72, 0x69, 0x74, 0x79, 0x12, 0x1b, 0x0a,
	0x17, 0x47, 0x52, 0x41, 0x4e, 0x55, 0x4c, 0x41, 0x52, 0x49, 0x54, 0x59, 0x5f, 0x55, 0x4e, 0x53,
	0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x1b, 0x0a, 0x17, 0x47, 0x52,
	0x41, 0x4e, 0x55, 0x4c, 0x41, 0x52, 0x49, 0x54, 0x59, 0x5f, 0x41, 0x53, 0x53, 0x45, 0x54, 0x5f,
	0x4c, 0x45, 0x56, 0x45, 0x4c, 0x10, 0x01, 0x12, 0x1f, 0x0a, 0x1b, 0x47, 0x52, 0x41, 0x4e, 0x55,
	0x4c, 0x41, 0x52, 0x49, 0x54, 0x59, 0x5f, 0x50, 0x41, 0x52, 0x54, 0x49, 0x54, 0x49, 0x4f, 0x4e,
	0x5f, 0x4c, 0x45, 0x56, 0x45, 0x4c, 0x10, 0x02, 0x22, 0xa8, 0x01, 0x0a, 0x17, 0x55, 0x70, 0x64,
	0x61, 0x74, 0x65, 0x44, 0x61, 0x74, 0x61, 0x53, 0x63, 0x68, 0x65, 0x6d, 0x61, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x12, 0x50, 0x0a, 0x0b, 0x64, 0x61, 0x74, 0x61, 0x5f, 0x73, 0x63, 0x68,
	0x65, 0x6d, 0x61, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2a, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x61,
	0x69, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e, 0x44, 0x61, 0x74, 0x61, 0x53,
	0x63, 0x68, 0x65, 0x6d, 0x61, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0a, 0x64, 0x61, 0x74, 0x61,
	0x53, 0x63, 0x68, 0x65, 0x6d, 0x61, 0x12, 0x3b, 0x0a, 0x0b, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65,
	0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x46, 0x69,
	0x65, 0x6c, 0x64, 0x4d, 0x61, 0x73, 0x6b, 0x52, 0x0a, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x4d,
	0x61, 0x73, 0x6b, 0x22, 0x56, 0x0a, 0x14, 0x47, 0x65, 0x74, 0x44, 0x61, 0x74, 0x61, 0x53, 0x63,
	0x68, 0x65, 0x6d, 0x61, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x3e, 0x0a, 0x04, 0x6e,
	0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x2a, 0xe0, 0x41, 0x02, 0xfa, 0x41,
	0x24, 0x0a, 0x22, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x61, 0x69, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x44, 0x61, 0x74, 0x61, 0x53,
	0x63, 0x68, 0x65, 0x6d, 0x61, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22, 0x59, 0x0a, 0x17, 0x44,
	0x65, 0x6c, 0x65, 0x74, 0x65, 0x44, 0x61, 0x74, 0x61, 0x53, 0x63, 0x68, 0x65, 0x6d, 0x61, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x3e, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x09, 0x42, 0x2a, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x24, 0x0a, 0x22, 0x76, 0x69,
	0x73, 0x69, 0x6f, 0x6e, 0x61, 0x69, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69,
	0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x44, 0x61, 0x74, 0x61, 0x53, 0x63, 0x68, 0x65, 0x6d, 0x61,
	0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22, 0x98, 0x01, 0x0a, 0x16, 0x4c, 0x69, 0x73, 0x74, 0x44,
	0x61, 0x74, 0x61, 0x53, 0x63, 0x68, 0x65, 0x6d, 0x61, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x12, 0x42, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x09, 0x42, 0x2a, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x24, 0x12, 0x22, 0x76, 0x69, 0x73, 0x69, 0x6f,
	0x6e, 0x61, 0x69, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63,
	0x6f, 0x6d, 0x2f, 0x44, 0x61, 0x74, 0x61, 0x53, 0x63, 0x68, 0x65, 0x6d, 0x61, 0x52, 0x06, 0x70,
	0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x1b, 0x0a, 0x09, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x73, 0x69,
	0x7a, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x05, 0x52, 0x08, 0x70, 0x61, 0x67, 0x65, 0x53, 0x69,
	0x7a, 0x65, 0x12, 0x1d, 0x0a, 0x0a, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e,
	0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x70, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65,
	0x6e, 0x22, 0x90, 0x01, 0x0a, 0x17, 0x4c, 0x69, 0x73, 0x74, 0x44, 0x61, 0x74, 0x61, 0x53, 0x63,
	0x68, 0x65, 0x6d, 0x61, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x4d, 0x0a,
	0x0c, 0x64, 0x61, 0x74, 0x61, 0x5f, 0x73, 0x63, 0x68, 0x65, 0x6d, 0x61, 0x73, 0x18, 0x01, 0x20,
	0x03, 0x28, 0x0b, 0x32, 0x2a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x61, 0x69, 0x2e, 0x76, 0x31, 0x61, 0x6c,
	0x70, 0x68, 0x61, 0x31, 0x2e, 0x44, 0x61, 0x74, 0x61, 0x53, 0x63, 0x68, 0x65, 0x6d, 0x61, 0x52,
	0x0b, 0x64, 0x61, 0x74, 0x61, 0x53, 0x63, 0x68, 0x65, 0x6d, 0x61, 0x73, 0x12, 0x26, 0x0a, 0x0f,
	0x6e, 0x65, 0x78, 0x74, 0x5f, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x6e, 0x65, 0x78, 0x74, 0x50, 0x61, 0x67, 0x65, 0x54,
	0x6f, 0x6b, 0x65, 0x6e, 0x22, 0xea, 0x01, 0x0a, 0x17, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x41,
	0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x12, 0x3d, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09,
	0x42, 0x25, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x1f, 0x0a, 0x1d, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e,
	0x61, 0x69, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f,
	0x6d, 0x2f, 0x41, 0x73, 0x73, 0x65, 0x74, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12,
	0x4f, 0x0a, 0x0a, 0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x2a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x61, 0x69, 0x2e, 0x76, 0x31, 0x61, 0x6c,
	0x70, 0x68, 0x61, 0x31, 0x2e, 0x41, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x42,
	0x03, 0xe0, 0x41, 0x02, 0x52, 0x0a, 0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x12, 0x2d, 0x0a, 0x0d, 0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x69,
	0x64, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x48, 0x00, 0x52, 0x0c,
	0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x49, 0x64, 0x88, 0x01, 0x01, 0x42,
	0x10, 0x0a, 0x0e, 0x5f, 0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x69,
	0x64, 0x22, 0xa9, 0x02, 0x0a, 0x0a, 0x41, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x12, 0x12, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04,
	0x6e, 0x61, 0x6d, 0x65, 0x12, 0x73, 0x0a, 0x19, 0x75, 0x73, 0x65, 0x72, 0x5f, 0x73, 0x70, 0x65,
	0x63, 0x69, 0x66, 0x69, 0x65, 0x64, 0x5f, 0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x37, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x61, 0x69, 0x2e,
	0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e, 0x55, 0x73, 0x65, 0x72, 0x53, 0x70, 0x65,
	0x63, 0x69, 0x66, 0x69, 0x65, 0x64, 0x41, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x52, 0x17, 0x75, 0x73, 0x65, 0x72, 0x53, 0x70, 0x65, 0x63, 0x69, 0x66, 0x69, 0x65, 0x64, 0x41,
	0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x3a, 0x91, 0x01, 0xea, 0x41, 0x8d, 0x01,
	0x0a, 0x22, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x61, 0x69, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x41, 0x6e, 0x6e, 0x6f, 0x74, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x12, 0x67, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x7b,
	0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x5f, 0x6e, 0x75, 0x6d, 0x62, 0x65, 0x72, 0x7d, 0x2f,
	0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x7b, 0x6c, 0x6f, 0x63, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x7d, 0x2f, 0x63, 0x6f, 0x72, 0x70, 0x6f, 0x72, 0x61, 0x2f, 0x7b, 0x63, 0x6f,
	0x72, 0x70, 0x75, 0x73, 0x7d, 0x2f, 0x61, 0x73, 0x73, 0x65, 0x74, 0x73, 0x2f, 0x7b, 0x61, 0x73,
	0x73, 0x65, 0x74, 0x7d, 0x2f, 0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73,
	0x2f, 0x7b, 0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x7d, 0x22, 0xc0, 0x01,
	0x0a, 0x17, 0x55, 0x73, 0x65, 0x72, 0x53, 0x70, 0x65, 0x63, 0x69, 0x66, 0x69, 0x65, 0x64, 0x41,
	0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x15, 0x0a, 0x03, 0x6b, 0x65, 0x79,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x03, 0x6b, 0x65, 0x79,
	0x12, 0x45, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x2f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76,
	0x69, 0x73, 0x69, 0x6f, 0x6e, 0x61, 0x69, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31,
	0x2e, 0x41, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x56, 0x61, 0x6c, 0x75, 0x65,
	0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x12, 0x47, 0x0a, 0x09, 0x70, 0x61, 0x72, 0x74, 0x69,
	0x74, 0x69, 0x6f, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x29, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e,
	0x61, 0x69, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e, 0x50, 0x61, 0x72, 0x74,
	0x69, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x09, 0x70, 0x61, 0x72, 0x74, 0x69, 0x74, 0x69, 0x6f, 0x6e,
	0x22, 0x49, 0x0a, 0x0d, 0x47, 0x65, 0x6f, 0x43, 0x6f, 0x6f, 0x72, 0x64, 0x69, 0x6e, 0x61, 0x74,
	0x65, 0x12, 0x1a, 0x0a, 0x08, 0x6c, 0x61, 0x74, 0x69, 0x74, 0x75, 0x64, 0x65, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x01, 0x52, 0x08, 0x6c, 0x61, 0x74, 0x69, 0x74, 0x75, 0x64, 0x65, 0x12, 0x1c, 0x0a,
	0x09, 0x6c, 0x6f, 0x6e, 0x67, 0x69, 0x74, 0x75, 0x64, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x01,
	0x52, 0x09, 0x6c, 0x6f, 0x6e, 0x67, 0x69, 0x74, 0x75, 0x64, 0x65, 0x22, 0xb9, 0x03, 0x0a, 0x0f,
	0x41, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x12,
	0x1d, 0x0a, 0x09, 0x69, 0x6e, 0x74, 0x5f, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x03, 0x48, 0x00, 0x52, 0x08, 0x69, 0x6e, 0x74, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x12, 0x21,
	0x0a, 0x0b, 0x66, 0x6c, 0x6f, 0x61, 0x74, 0x5f, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x02, 0x48, 0x00, 0x52, 0x0a, 0x66, 0x6c, 0x6f, 0x61, 0x74, 0x56, 0x61, 0x6c, 0x75,
	0x65, 0x12, 0x1d, 0x0a, 0x09, 0x73, 0x74, 0x72, 0x5f, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x03,
	0x20, 0x01, 0x28, 0x09, 0x48, 0x00, 0x52, 0x08, 0x73, 0x74, 0x72, 0x56, 0x61, 0x6c, 0x75, 0x65,
	0x12, 0x27, 0x0a, 0x0e, 0x64, 0x61, 0x74, 0x65, 0x74, 0x69, 0x6d, 0x65, 0x5f, 0x76, 0x61, 0x6c,
	0x75, 0x65, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x48, 0x00, 0x52, 0x0d, 0x64, 0x61, 0x74, 0x65,
	0x74, 0x69, 0x6d, 0x65, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x12, 0x56, 0x0a, 0x0e, 0x67, 0x65, 0x6f,
	0x5f, 0x63, 0x6f, 0x6f, 0x72, 0x64, 0x69, 0x6e, 0x61, 0x74, 0x65, 0x18, 0x07, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x2d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x61, 0x69, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68,
	0x61, 0x31, 0x2e, 0x47, 0x65, 0x6f, 0x43, 0x6f, 0x6f, 0x72, 0x64, 0x69, 0x6e, 0x61, 0x74, 0x65,
	0x48, 0x00, 0x52, 0x0d, 0x67, 0x65, 0x6f, 0x43, 0x6f, 0x6f, 0x72, 0x64, 0x69, 0x6e, 0x61, 0x74,
	0x65, 0x12, 0x3e, 0x0a, 0x0f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x5f, 0x61, 0x6e, 0x79, 0x5f, 0x76,
	0x61, 0x6c, 0x75, 0x65, 0x18, 0x08, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x14, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x41, 0x6e, 0x79,
	0x48, 0x00, 0x52, 0x0d, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x41, 0x6e, 0x79, 0x56, 0x61, 0x6c, 0x75,
	0x65, 0x12, 0x1f, 0x0a, 0x0a, 0x62, 0x6f, 0x6f, 0x6c, 0x5f, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18,
	0x09, 0x20, 0x01, 0x28, 0x08, 0x48, 0x00, 0x52, 0x09, 0x62, 0x6f, 0x6f, 0x6c, 0x56, 0x61, 0x6c,
	0x75, 0x65, 0x12, 0x5a, 0x0a, 0x1c, 0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x69, 0x7a, 0x65, 0x64,
	0x5f, 0x73, 0x74, 0x72, 0x75, 0x63, 0x74, 0x5f, 0x64, 0x61, 0x74, 0x61, 0x5f, 0x76, 0x61, 0x6c,
	0x75, 0x65, 0x18, 0x0a, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x17, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x53, 0x74, 0x72, 0x75, 0x63,
	0x74, 0x48, 0x00, 0x52, 0x19, 0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x69, 0x7a, 0x65, 0x64, 0x53,
	0x74, 0x72, 0x75, 0x63, 0x74, 0x44, 0x61, 0x74, 0x61, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x42, 0x07,
	0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x22, 0xa8, 0x01, 0x0a, 0x16, 0x4c, 0x69, 0x73, 0x74,
	0x41, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x12, 0x3a, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x09, 0x42, 0x22, 0xfa, 0x41, 0x1f, 0x0a, 0x1d, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x61,
	0x69, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d,
	0x2f, 0x41, 0x73, 0x73, 0x65, 0x74, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x1b,
	0x0a, 0x09, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x05, 0x52, 0x08, 0x70, 0x61, 0x67, 0x65, 0x53, 0x69, 0x7a, 0x65, 0x12, 0x1d, 0x0a, 0x0a, 0x70,
	0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x09, 0x70, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x12, 0x16, 0x0a, 0x06, 0x66, 0x69,
	0x6c, 0x74, 0x65, 0x72, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x52, 0x06, 0x66, 0x69, 0x6c, 0x74,
	0x65, 0x72, 0x22, 0x8f, 0x01, 0x0a, 0x17, 0x4c, 0x69, 0x73, 0x74, 0x41, 0x6e, 0x6e, 0x6f, 0x74,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x4c,
	0x0a, 0x0b, 0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x01, 0x20,
	0x03, 0x28, 0x0b, 0x32, 0x2a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x61, 0x69, 0x2e, 0x76, 0x31, 0x61, 0x6c,
	0x70, 0x68, 0x61, 0x31, 0x2e, 0x41, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52,
	0x0b, 0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x26, 0x0a, 0x0f,
	0x6e, 0x65, 0x78, 0x74, 0x5f, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x6e, 0x65, 0x78, 0x74, 0x50, 0x61, 0x67, 0x65, 0x54,
	0x6f, 0x6b, 0x65, 0x6e, 0x22, 0x56, 0x0a, 0x14, 0x47, 0x65, 0x74, 0x41, 0x6e, 0x6e, 0x6f, 0x74,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x3e, 0x0a, 0x04,
	0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x2a, 0xe0, 0x41, 0x02, 0xfa,
	0x41, 0x24, 0x0a, 0x22, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x61, 0x69, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x41, 0x6e, 0x6e, 0x6f,
	0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22, 0xa7, 0x01, 0x0a,
	0x17, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x41, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x4f, 0x0a, 0x0a, 0x61, 0x6e, 0x6e, 0x6f,
	0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2a, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x73, 0x69,
	0x6f, 0x6e, 0x61, 0x69, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e, 0x41, 0x6e,
	0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0a, 0x61,
	0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x3b, 0x0a, 0x0b, 0x75, 0x70, 0x64,
	0x61, 0x74, 0x65, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66,
	0x2e, 0x46, 0x69, 0x65, 0x6c, 0x64, 0x4d, 0x61, 0x73, 0x6b, 0x52, 0x0a, 0x75, 0x70, 0x64, 0x61,
	0x74, 0x65, 0x4d, 0x61, 0x73, 0x6b, 0x22, 0x59, 0x0a, 0x17, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65,
	0x41, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x12, 0x3e, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42,
	0x2a, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x24, 0x0a, 0x22, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x61,
	0x69, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d,
	0x2f, 0x41, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x04, 0x6e, 0x61, 0x6d,
	0x65, 0x22, 0xe8, 0x01, 0x0a, 0x19, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x53, 0x65, 0x61, 0x72,
	0x63, 0x68, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12,
	0x44, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42,
	0x2c, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x26, 0x12, 0x24, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x61,
	0x69, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d,
	0x2f, 0x53, 0x65, 0x61, 0x72, 0x63, 0x68, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x06, 0x70,
	0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x56, 0x0a, 0x0d, 0x73, 0x65, 0x61, 0x72, 0x63, 0x68, 0x5f,
	0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2c, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x73, 0x69,
	0x6f, 0x6e, 0x61, 0x69, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e, 0x53, 0x65,
	0x61, 0x72, 0x63, 0x68, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52,
	0x0c, 0x73, 0x65, 0x61, 0x72, 0x63, 0x68, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x2d, 0x0a,
	0x10, 0x73, 0x65, 0x61, 0x72, 0x63, 0x68, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x5f, 0x69,
	0x64, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0e, 0x73, 0x65,
	0x61, 0x72, 0x63, 0x68, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x49, 0x64, 0x22, 0xb0, 0x01, 0x0a,
	0x19, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x53, 0x65, 0x61, 0x72, 0x63, 0x68, 0x43, 0x6f, 0x6e,
	0x66, 0x69, 0x67, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x56, 0x0a, 0x0d, 0x73, 0x65,
	0x61, 0x72, 0x63, 0x68, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x2c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x61, 0x69, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68,
	0x61, 0x31, 0x2e, 0x53, 0x65, 0x61, 0x72, 0x63, 0x68, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x42,
	0x03, 0xe0, 0x41, 0x02, 0x52, 0x0c, 0x73, 0x65, 0x61, 0x72, 0x63, 0x68, 0x43, 0x6f, 0x6e, 0x66,
	0x69, 0x67, 0x12, 0x3b, 0x0a, 0x0b, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x6d, 0x61, 0x73,
	0x6b, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x46, 0x69, 0x65, 0x6c, 0x64, 0x4d,
	0x61, 0x73, 0x6b, 0x52, 0x0a, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x4d, 0x61, 0x73, 0x6b, 0x22,
	0x5a, 0x0a, 0x16, 0x47, 0x65, 0x74, 0x53, 0x65, 0x61, 0x72, 0x63, 0x68, 0x43, 0x6f, 0x6e, 0x66,
	0x69, 0x67, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x40, 0x0a, 0x04, 0x6e, 0x61, 0x6d,
	0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x2c, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x26, 0x0a,
	0x24, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x61, 0x69, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x53, 0x65, 0x61, 0x72, 0x63, 0x68, 0x43,
	0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22, 0x5d, 0x0a, 0x19, 0x44,
	0x65, 0x6c, 0x65, 0x74, 0x65, 0x53, 0x65, 0x61, 0x72, 0x63, 0x68, 0x43, 0x6f, 0x6e, 0x66, 0x69,
	0x67, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x40, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x2c, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x26, 0x0a, 0x24,
	0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x61, 0x69, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61,
	0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x53, 0x65, 0x61, 0x72, 0x63, 0x68, 0x43, 0x6f,
	0x6e, 0x66, 0x69, 0x67, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22, 0x9c, 0x01, 0x0a, 0x18, 0x4c,
	0x69, 0x73, 0x74, 0x53, 0x65, 0x61, 0x72, 0x63, 0x68, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x73,
	0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x44, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e,
	0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x2c, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x26, 0x12,
	0x24, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x61, 0x69, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x53, 0x65, 0x61, 0x72, 0x63, 0x68, 0x43,
	0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x1b, 0x0a,
	0x09, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x05,
	0x52, 0x08, 0x70, 0x61, 0x67, 0x65, 0x53, 0x69, 0x7a, 0x65, 0x12, 0x1d, 0x0a, 0x0a, 0x70, 0x61,
	0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09,
	0x70, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x22, 0x98, 0x01, 0x0a, 0x19, 0x4c, 0x69,
	0x73, 0x74, 0x53, 0x65, 0x61, 0x72, 0x63, 0x68, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x73, 0x52,
	0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x53, 0x0a, 0x0e, 0x73, 0x65, 0x61, 0x72, 0x63,
	0x68, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32,
	0x2c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76,
	0x69, 0x73, 0x69, 0x6f, 0x6e, 0x61, 0x69, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31,
	0x2e, 0x53, 0x65, 0x61, 0x72, 0x63, 0x68, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x0d, 0x73,
	0x65, 0x61, 0x72, 0x63, 0x68, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x73, 0x12, 0x26, 0x0a, 0x0f,
	0x6e, 0x65, 0x78, 0x74, 0x5f, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x6e, 0x65, 0x78, 0x74, 0x50, 0x61, 0x67, 0x65, 0x54,
	0x6f, 0x6b, 0x65, 0x6e, 0x22, 0xf6, 0x02, 0x0a, 0x0c, 0x53, 0x65, 0x61, 0x72, 0x63, 0x68, 0x43,
	0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x12, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x54, 0x0a, 0x0e, 0x66, 0x61, 0x63,
	0x65, 0x74, 0x5f, 0x70, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x79, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x2d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x61, 0x69, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68,
	0x61, 0x31, 0x2e, 0x46, 0x61, 0x63, 0x65, 0x74, 0x50, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x79,
	0x52, 0x0d, 0x66, 0x61, 0x63, 0x65, 0x74, 0x50, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x79, 0x12,
	0x70, 0x0a, 0x18, 0x73, 0x65, 0x61, 0x72, 0x63, 0x68, 0x5f, 0x63, 0x72, 0x69, 0x74, 0x65, 0x72,
	0x69, 0x61, 0x5f, 0x70, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x79, 0x18, 0x03, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x36, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x61, 0x69, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68,
	0x61, 0x31, 0x2e, 0x53, 0x65, 0x61, 0x72, 0x63, 0x68, 0x43, 0x72, 0x69, 0x74, 0x65, 0x72, 0x69,
	0x61, 0x50, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x79, 0x52, 0x16, 0x73, 0x65, 0x61, 0x72, 0x63,
	0x68, 0x43, 0x72, 0x69, 0x74, 0x65, 0x72, 0x69, 0x61, 0x50, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74,
	0x79, 0x3a, 0x89, 0x01, 0xea, 0x41, 0x85, 0x01, 0x0a, 0x24, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e,
	0x61, 0x69, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f,
	0x6d, 0x2f, 0x53, 0x65, 0x61, 0x72, 0x63, 0x68, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x5d,
	0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x7b, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63,
	0x74, 0x5f, 0x6e, 0x75, 0x6d, 0x62, 0x65, 0x72, 0x7d, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x73, 0x2f, 0x7b, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x7d, 0x2f, 0x63,
	0x6f, 0x72, 0x70, 0x6f, 0x72, 0x61, 0x2f, 0x7b, 0x63, 0x6f, 0x72, 0x70, 0x75, 0x73, 0x7d, 0x2f,
	0x73, 0x65, 0x61, 0x72, 0x63, 0x68, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x73, 0x2f, 0x7b, 0x73,
	0x65, 0x61, 0x72, 0x63, 0x68, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x7d, 0x22, 0xed, 0x08,
	0x0a, 0x0d, 0x46, 0x61, 0x63, 0x65, 0x74, 0x50, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x79, 0x12,
	0x7b, 0x0a, 0x17, 0x66, 0x69, 0x78, 0x65, 0x64, 0x5f, 0x72, 0x61, 0x6e, 0x67, 0x65, 0x5f, 0x62,
	0x75, 0x63, 0x6b, 0x65, 0x74, 0x5f, 0x73, 0x70, 0x65, 0x63, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x42, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x61, 0x69, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61,
	0x31, 0x2e, 0x46, 0x61, 0x63, 0x65, 0x74, 0x50, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x79, 0x2e,
	0x46, 0x69, 0x78, 0x65, 0x64, 0x52, 0x61, 0x6e, 0x67, 0x65, 0x42, 0x75, 0x63, 0x6b, 0x65, 0x74,
	0x53, 0x70, 0x65, 0x63, 0x48, 0x00, 0x52, 0x14, 0x66, 0x69, 0x78, 0x65, 0x64, 0x52, 0x61, 0x6e,
	0x67, 0x65, 0x42, 0x75, 0x63, 0x6b, 0x65, 0x74, 0x53, 0x70, 0x65, 0x63, 0x12, 0x7e, 0x0a, 0x18,
	0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x5f, 0x72, 0x61, 0x6e, 0x67, 0x65, 0x5f, 0x62, 0x75, 0x63,
	0x6b, 0x65, 0x74, 0x5f, 0x73, 0x70, 0x65, 0x63, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x43,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69,
	0x73, 0x69, 0x6f, 0x6e, 0x61, 0x69, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e,
	0x46, 0x61, 0x63, 0x65, 0x74, 0x50, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x79, 0x2e, 0x43, 0x75,
	0x73, 0x74, 0x6f, 0x6d, 0x52, 0x61, 0x6e, 0x67, 0x65, 0x42, 0x75, 0x63, 0x6b, 0x65, 0x74, 0x53,
	0x70, 0x65, 0x63, 0x48, 0x00, 0x52, 0x15, 0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x52, 0x61, 0x6e,
	0x67, 0x65, 0x42, 0x75, 0x63, 0x6b, 0x65, 0x74, 0x53, 0x70, 0x65, 0x63, 0x12, 0x74, 0x0a, 0x14,
	0x64, 0x61, 0x74, 0x65, 0x74, 0x69, 0x6d, 0x65, 0x5f, 0x62, 0x75, 0x63, 0x6b, 0x65, 0x74, 0x5f,
	0x73, 0x70, 0x65, 0x63, 0x18, 0x07, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x40, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e,
	0x61, 0x69, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e, 0x46, 0x61, 0x63, 0x65,
	0x74, 0x50, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x79, 0x2e, 0x44, 0x61, 0x74, 0x65, 0x54, 0x69,
	0x6d, 0x65, 0x42, 0x75, 0x63, 0x6b, 0x65, 0x74, 0x53, 0x70, 0x65, 0x63, 0x48, 0x00, 0x52, 0x12,
	0x64, 0x61, 0x74, 0x65, 0x74, 0x69, 0x6d, 0x65, 0x42, 0x75, 0x63, 0x6b, 0x65, 0x74, 0x53, 0x70,
	0x65, 0x63, 0x12, 0x23, 0x0a, 0x0d, 0x6d, 0x61, 0x70, 0x70, 0x65, 0x64, 0x5f, 0x66, 0x69, 0x65,
	0x6c, 0x64, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x09, 0x52, 0x0c, 0x6d, 0x61, 0x70, 0x70, 0x65,
	0x64, 0x46, 0x69, 0x65, 0x6c, 0x64, 0x73, 0x12, 0x21, 0x0a, 0x0c, 0x64, 0x69, 0x73, 0x70, 0x6c,
	0x61, 0x79, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0b, 0x64,
	0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x1f, 0x0a, 0x0b, 0x72, 0x65,
	0x73, 0x75, 0x6c, 0x74, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x03, 0x52,
	0x0a, 0x72, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x53, 0x69, 0x7a, 0x65, 0x12, 0x50, 0x0a, 0x0b, 0x62,
	0x75, 0x63, 0x6b, 0x65, 0x74, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0e,
	0x32, 0x2f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x61, 0x69, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61,
	0x31, 0x2e, 0x46, 0x61, 0x63, 0x65, 0x74, 0x42, 0x75, 0x63, 0x6b, 0x65, 0x74, 0x54, 0x79, 0x70,
	0x65, 0x52, 0x0a, 0x62, 0x75, 0x63, 0x6b, 0x65, 0x74, 0x54, 0x79, 0x70, 0x65, 0x1a, 0xe3, 0x01,
	0x0a, 0x14, 0x46, 0x69, 0x78, 0x65, 0x64, 0x52, 0x61, 0x6e, 0x67, 0x65, 0x42, 0x75, 0x63, 0x6b,
	0x65, 0x74, 0x53, 0x70, 0x65, 0x63, 0x12, 0x4d, 0x0a, 0x0c, 0x62, 0x75, 0x63, 0x6b, 0x65, 0x74,
	0x5f, 0x73, 0x74, 0x61, 0x72, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2a, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x73, 0x69,
	0x6f, 0x6e, 0x61, 0x69, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e, 0x46, 0x61,
	0x63, 0x65, 0x74, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x0b, 0x62, 0x75, 0x63, 0x6b, 0x65, 0x74,
	0x53, 0x74, 0x61, 0x72, 0x74, 0x12, 0x59, 0x0a, 0x12, 0x62, 0x75, 0x63, 0x6b, 0x65, 0x74, 0x5f,
	0x67, 0x72, 0x61, 0x6e, 0x75, 0x6c, 0x61, 0x72, 0x69, 0x74, 0x79, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x2a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x61, 0x69, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68,
	0x61, 0x31, 0x2e, 0x46, 0x61, 0x63, 0x65, 0x74, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x11, 0x62,
	0x75, 0x63, 0x6b, 0x65, 0x74, 0x47, 0x72, 0x61, 0x6e, 0x75, 0x6c, 0x61, 0x72, 0x69, 0x74, 0x79,
	0x12, 0x21, 0x0a, 0x0c, 0x62, 0x75, 0x63, 0x6b, 0x65, 0x74, 0x5f, 0x63, 0x6f, 0x75, 0x6e, 0x74,
	0x18, 0x03, 0x20, 0x01, 0x28, 0x05, 0x52, 0x0b, 0x62, 0x75, 0x63, 0x6b, 0x65, 0x74, 0x43, 0x6f,
	0x75, 0x6e, 0x74, 0x1a, 0x61, 0x0a, 0x15, 0x43, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x52, 0x61, 0x6e,
	0x67, 0x65, 0x42, 0x75, 0x63, 0x6b, 0x65, 0x74, 0x53, 0x70, 0x65, 0x63, 0x12, 0x48, 0x0a, 0x09,
	0x65, 0x6e, 0x64, 0x70, 0x6f, 0x69, 0x6e, 0x74, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32,
	0x2a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76,
	0x69, 0x73, 0x69, 0x6f, 0x6e, 0x61, 0x69, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31,
	0x2e, 0x46, 0x61, 0x63, 0x65, 0x74, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x09, 0x65, 0x6e, 0x64,
	0x70, 0x6f, 0x69, 0x6e, 0x74, 0x73, 0x1a, 0xce, 0x01, 0x0a, 0x12, 0x44, 0x61, 0x74, 0x65, 0x54,
	0x69, 0x6d, 0x65, 0x42, 0x75, 0x63, 0x6b, 0x65, 0x74, 0x53, 0x70, 0x65, 0x63, 0x12, 0x6e, 0x0a,
	0x0b, 0x67, 0x72, 0x61, 0x6e, 0x75, 0x6c, 0x61, 0x72, 0x69, 0x74, 0x79, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x0e, 0x32, 0x4c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x61, 0x69, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70,
	0x68, 0x61, 0x31, 0x2e, 0x46, 0x61, 0x63, 0x65, 0x74, 0x50, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74,
	0x79, 0x2e, 0x44, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x42, 0x75, 0x63, 0x6b, 0x65, 0x74,
	0x53, 0x70, 0x65, 0x63, 0x2e, 0x47, 0x72, 0x61, 0x6e, 0x75, 0x6c, 0x61, 0x72, 0x69, 0x74, 0x79,
	0x52, 0x0b, 0x67, 0x72, 0x61, 0x6e, 0x75, 0x6c, 0x61, 0x72, 0x69, 0x74, 0x79, 0x22, 0x48, 0x0a,
	0x0b, 0x47, 0x72, 0x61, 0x6e, 0x75, 0x6c, 0x61, 0x72, 0x69, 0x74, 0x79, 0x12, 0x1b, 0x0a, 0x17,
	0x47, 0x52, 0x41, 0x4e, 0x55, 0x4c, 0x41, 0x52, 0x49, 0x54, 0x59, 0x5f, 0x55, 0x4e, 0x53, 0x50,
	0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x08, 0x0a, 0x04, 0x59, 0x45, 0x41,
	0x52, 0x10, 0x01, 0x12, 0x09, 0x0a, 0x05, 0x4d, 0x4f, 0x4e, 0x54, 0x48, 0x10, 0x02, 0x12, 0x07,
	0x0a, 0x03, 0x44, 0x41, 0x59, 0x10, 0x03, 0x42, 0x14, 0x0a, 0x12, 0x72, 0x61, 0x6e, 0x67, 0x65,
	0x5f, 0x66, 0x61, 0x63, 0x65, 0x74, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x22, 0x3d, 0x0a,
	0x16, 0x53, 0x65, 0x61, 0x72, 0x63, 0x68, 0x43, 0x72, 0x69, 0x74, 0x65, 0x72, 0x69, 0x61, 0x50,
	0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x79, 0x12, 0x23, 0x0a, 0x0d, 0x6d, 0x61, 0x70, 0x70, 0x65,
	0x64, 0x5f, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x09, 0x52, 0x0c,
	0x6d, 0x61, 0x70, 0x70, 0x65, 0x64, 0x46, 0x69, 0x65, 0x6c, 0x64, 0x73, 0x22, 0xa1, 0x01, 0x0a,
	0x0a, 0x46, 0x61, 0x63, 0x65, 0x74, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x12, 0x23, 0x0a, 0x0c, 0x73,
	0x74, 0x72, 0x69, 0x6e, 0x67, 0x5f, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x09, 0x48, 0x00, 0x52, 0x0b, 0x73, 0x74, 0x72, 0x69, 0x6e, 0x67, 0x56, 0x61, 0x6c, 0x75, 0x65,
	0x12, 0x25, 0x0a, 0x0d, 0x69, 0x6e, 0x74, 0x65, 0x67, 0x65, 0x72, 0x5f, 0x76, 0x61, 0x6c, 0x75,
	0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x03, 0x48, 0x00, 0x52, 0x0c, 0x69, 0x6e, 0x74, 0x65, 0x67,
	0x65, 0x72, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x12, 0x3e, 0x0a, 0x0e, 0x64, 0x61, 0x74, 0x65, 0x74,
	0x69, 0x6d, 0x65, 0x5f, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x15, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x74, 0x79, 0x70, 0x65, 0x2e, 0x44, 0x61,
	0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x48, 0x00, 0x52, 0x0d, 0x64, 0x61, 0x74, 0x65, 0x74, 0x69,
	0x6d, 0x65, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x42, 0x07, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65,
	0x22, 0xd2, 0x02, 0x0a, 0x0b, 0x46, 0x61, 0x63, 0x65, 0x74, 0x42, 0x75, 0x63, 0x6b, 0x65, 0x74,
	0x12, 0x42, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x2a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76,
	0x69, 0x73, 0x69, 0x6f, 0x6e, 0x61, 0x69, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31,
	0x2e, 0x46, 0x61, 0x63, 0x65, 0x74, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x48, 0x00, 0x52, 0x05, 0x76,
	0x61, 0x6c, 0x75, 0x65, 0x12, 0x49, 0x0a, 0x05, 0x72, 0x61, 0x6e, 0x67, 0x65, 0x18, 0x04, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x31, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x61, 0x69, 0x2e, 0x76, 0x31, 0x61, 0x6c,
	0x70, 0x68, 0x61, 0x31, 0x2e, 0x46, 0x61, 0x63, 0x65, 0x74, 0x42, 0x75, 0x63, 0x6b, 0x65, 0x74,
	0x2e, 0x52, 0x61, 0x6e, 0x67, 0x65, 0x48, 0x00, 0x52, 0x05, 0x72, 0x61, 0x6e, 0x67, 0x65, 0x12,
	0x1a, 0x0a, 0x08, 0x73, 0x65, 0x6c, 0x65, 0x63, 0x74, 0x65, 0x64, 0x18, 0x03, 0x20, 0x01, 0x28,
	0x08, 0x52, 0x08, 0x73, 0x65, 0x6c, 0x65, 0x63, 0x74, 0x65, 0x64, 0x1a, 0x87, 0x01, 0x0a, 0x05,
	0x52, 0x61, 0x6e, 0x67, 0x65, 0x12, 0x40, 0x0a, 0x05, 0x73, 0x74, 0x61, 0x72, 0x74, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x2a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x61, 0x69, 0x2e, 0x76, 0x31, 0x61,
	0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e, 0x46, 0x61, 0x63, 0x65, 0x74, 0x56, 0x61, 0x6c, 0x75, 0x65,
	0x52, 0x05, 0x73, 0x74, 0x61, 0x72, 0x74, 0x12, 0x3c, 0x0a, 0x03, 0x65, 0x6e, 0x64, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x2a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x61, 0x69, 0x2e, 0x76, 0x31, 0x61,
	0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e, 0x46, 0x61, 0x63, 0x65, 0x74, 0x56, 0x61, 0x6c, 0x75, 0x65,
	0x52, 0x03, 0x65, 0x6e, 0x64, 0x42, 0x0e, 0x0a, 0x0c, 0x62, 0x75, 0x63, 0x6b, 0x65, 0x74, 0x5f,
	0x76, 0x61, 0x6c, 0x75, 0x65, 0x22, 0x9f, 0x02, 0x0a, 0x0a, 0x46, 0x61, 0x63, 0x65, 0x74, 0x47,
	0x72, 0x6f, 0x75, 0x70, 0x12, 0x19, 0x0a, 0x08, 0x66, 0x61, 0x63, 0x65, 0x74, 0x5f, 0x69, 0x64,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x07, 0x66, 0x61, 0x63, 0x65, 0x74, 0x49, 0x64, 0x12,
	0x21, 0x0a, 0x0c, 0x64, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0b, 0x64, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x4e, 0x61,
	0x6d, 0x65, 0x12, 0x45, 0x0a, 0x07, 0x62, 0x75, 0x63, 0x6b, 0x65, 0x74, 0x73, 0x18, 0x03, 0x20,
	0x03, 0x28, 0x0b, 0x32, 0x2b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x61, 0x69, 0x2e, 0x76, 0x31, 0x61, 0x6c,
	0x70, 0x68, 0x61, 0x31, 0x2e, 0x46, 0x61, 0x63, 0x65, 0x74, 0x42, 0x75, 0x63, 0x6b, 0x65, 0x74,
	0x52, 0x07, 0x62, 0x75, 0x63, 0x6b, 0x65, 0x74, 0x73, 0x12, 0x50, 0x0a, 0x0b, 0x62, 0x75, 0x63,
	0x6b, 0x65, 0x74, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x2f,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69,
	0x73, 0x69, 0x6f, 0x6e, 0x61, 0x69, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e,
	0x46, 0x61, 0x63, 0x65, 0x74, 0x42, 0x75, 0x63, 0x6b, 0x65, 0x74, 0x54, 0x79, 0x70, 0x65, 0x52,
	0x0a, 0x62, 0x75, 0x63, 0x6b, 0x65, 0x74, 0x54, 0x79, 0x70, 0x65, 0x12, 0x3a, 0x0a, 0x19, 0x66,
	0x65, 0x74, 0x63, 0x68, 0x5f, 0x6d, 0x61, 0x74, 0x63, 0x68, 0x65, 0x64, 0x5f, 0x61, 0x6e, 0x6e,
	0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x05, 0x20, 0x01, 0x28, 0x08, 0x52, 0x17,
	0x66, 0x65, 0x74, 0x63, 0x68, 0x4d, 0x61, 0x74, 0x63, 0x68, 0x65, 0x64, 0x41, 0x6e, 0x6e, 0x6f,
	0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x22, 0x9c, 0x06, 0x0a, 0x12, 0x49, 0x6e, 0x67, 0x65,
	0x73, 0x74, 0x41, 0x73, 0x73, 0x65, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x53,
	0x0a, 0x06, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x39,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69,
	0x73, 0x69, 0x6f, 0x6e, 0x61, 0x69, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e,
	0x49, 0x6e, 0x67, 0x65, 0x73, 0x74, 0x41, 0x73, 0x73, 0x65, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x2e, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x48, 0x00, 0x52, 0x06, 0x63, 0x6f, 0x6e,
	0x66, 0x69, 0x67, 0x12, 0x70, 0x0a, 0x11, 0x74, 0x69, 0x6d, 0x65, 0x5f, 0x69, 0x6e, 0x64, 0x65,
	0x78, 0x65, 0x64, 0x5f, 0x64, 0x61, 0x74, 0x61, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x42,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69,
	0x73, 0x69, 0x6f, 0x6e, 0x61, 0x69, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e,
	0x49, 0x6e, 0x67, 0x65, 0x73, 0x74, 0x41, 0x73, 0x73, 0x65, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x49, 0x6e, 0x64, 0x65, 0x78, 0x65, 0x64, 0x44, 0x61,
	0x74, 0x61, 0x48, 0x00, 0x52, 0x0f, 0x74, 0x69, 0x6d, 0x65, 0x49, 0x6e, 0x64, 0x65, 0x78, 0x65,
	0x64, 0x44, 0x61, 0x74, 0x61, 0x1a, 0x95, 0x03, 0x0a, 0x06, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67,
	0x12, 0x64, 0x0a, 0x0a, 0x76, 0x69, 0x64, 0x65, 0x6f, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x43, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x61, 0x69, 0x2e, 0x76, 0x31, 0x61,
	0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e, 0x49, 0x6e, 0x67, 0x65, 0x73, 0x74, 0x41, 0x73, 0x73, 0x65,
	0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x2e, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e,
	0x56, 0x69, 0x64, 0x65, 0x6f, 0x54, 0x79, 0x70, 0x65, 0x48, 0x00, 0x52, 0x09, 0x76, 0x69, 0x64,
	0x65, 0x6f, 0x54, 0x79, 0x70, 0x65, 0x12, 0x3b, 0x0a, 0x05, 0x61, 0x73, 0x73, 0x65, 0x74, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x25, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x1f, 0x0a, 0x1d, 0x76,
	0x69, 0x73, 0x69, 0x6f, 0x6e, 0x61, 0x69, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70,
	0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x41, 0x73, 0x73, 0x65, 0x74, 0x52, 0x05, 0x61, 0x73,
	0x73, 0x65, 0x74, 0x1a, 0xda, 0x01, 0x0a, 0x09, 0x56, 0x69, 0x64, 0x65, 0x6f, 0x54, 0x79, 0x70,
	0x65, 0x12, 0x7e, 0x0a, 0x10, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x5f, 0x66,
	0x6f, 0x72, 0x6d, 0x61, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x53, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x73, 0x69, 0x6f,
	0x6e, 0x61, 0x69, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e, 0x49, 0x6e, 0x67,
	0x65, 0x73, 0x74, 0x41, 0x73, 0x73, 0x65, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x2e,
	0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x56, 0x69, 0x64, 0x65, 0x6f, 0x54, 0x79, 0x70, 0x65,
	0x2e, 0x43, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x46, 0x6f, 0x72, 0x6d, 0x61, 0x74,
	0x52, 0x0f, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x46, 0x6f, 0x72, 0x6d, 0x61,
	0x74, 0x22, 0x4d, 0x0a, 0x0f, 0x43, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x46, 0x6f,
	0x72, 0x6d, 0x61, 0x74, 0x12, 0x20, 0x0a, 0x1c, 0x43, 0x4f, 0x4e, 0x54, 0x41, 0x49, 0x4e, 0x45,
	0x52, 0x5f, 0x46, 0x4f, 0x52, 0x4d, 0x41, 0x54, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49,
	0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x18, 0x0a, 0x14, 0x43, 0x4f, 0x4e, 0x54, 0x41, 0x49,
	0x4e, 0x45, 0x52, 0x5f, 0x46, 0x4f, 0x52, 0x4d, 0x41, 0x54, 0x5f, 0x4d, 0x50, 0x34, 0x10, 0x01,
	0x42, 0x0b, 0x0a, 0x09, 0x64, 0x61, 0x74, 0x61, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x1a, 0x91, 0x01,
	0x0a, 0x0f, 0x54, 0x69, 0x6d, 0x65, 0x49, 0x6e, 0x64, 0x65, 0x78, 0x65, 0x64, 0x44, 0x61, 0x74,
	0x61, 0x12, 0x12, 0x0a, 0x04, 0x64, 0x61, 0x74, 0x61, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0c, 0x52,
	0x04, 0x64, 0x61, 0x74, 0x61, 0x12, 0x6a, 0x0a, 0x12, 0x74, 0x65, 0x6d, 0x70, 0x6f, 0x72, 0x61,
	0x6c, 0x5f, 0x70, 0x61, 0x72, 0x74, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x3b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x61, 0x69, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68,
	0x61, 0x31, 0x2e, 0x50, 0x61, 0x72, 0x74, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x54, 0x65, 0x6d,
	0x70, 0x6f, 0x72, 0x61, 0x6c, 0x50, 0x61, 0x72, 0x74, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x11,
	0x74, 0x65, 0x6d, 0x70, 0x6f, 0x72, 0x61, 0x6c, 0x50, 0x61, 0x72, 0x74, 0x69, 0x74, 0x69, 0x6f,
	0x6e, 0x42, 0x13, 0x0a, 0x11, 0x73, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x69, 0x6e, 0x67, 0x5f, 0x72,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x22, 0x9b, 0x01, 0x0a, 0x13, 0x49, 0x6e, 0x67, 0x65, 0x73,
	0x74, 0x41, 0x73, 0x73, 0x65, 0x74, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x83,
	0x01, 0x0a, 0x1f, 0x73, 0x75, 0x63, 0x63, 0x65, 0x73, 0x73, 0x66, 0x75, 0x6c, 0x6c, 0x79, 0x5f,
	0x69, 0x6e, 0x67, 0x65, 0x73, 0x74, 0x65, 0x64, 0x5f, 0x70, 0x61, 0x72, 0x74, 0x69, 0x74, 0x69,
	0x6f, 0x6e, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x3b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x61, 0x69,
	0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e, 0x50, 0x61, 0x72, 0x74, 0x69, 0x74,
	0x69, 0x6f, 0x6e, 0x2e, 0x54, 0x65, 0x6d, 0x70, 0x6f, 0x72, 0x61, 0x6c, 0x50, 0x61, 0x72, 0x74,
	0x69, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x1d, 0x73, 0x75, 0x63, 0x63, 0x65, 0x73, 0x73, 0x66, 0x75,
	0x6c, 0x6c, 0x79, 0x49, 0x6e, 0x67, 0x65, 0x73, 0x74, 0x65, 0x64, 0x50, 0x61, 0x72, 0x74, 0x69,
	0x74, 0x69, 0x6f, 0x6e, 0x22, 0xbe, 0x01, 0x0a, 0x10, 0x43, 0x6c, 0x69, 0x70, 0x41, 0x73, 0x73,
	0x65, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x39, 0x0a, 0x04, 0x6e, 0x61, 0x6d,
	0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x25, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x1f, 0x0a,
	0x1d, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x61, 0x69, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x41, 0x73, 0x73, 0x65, 0x74, 0x52, 0x04,
	0x6e, 0x61, 0x6d, 0x65, 0x12, 0x6f, 0x0a, 0x12, 0x74, 0x65, 0x6d, 0x70, 0x6f, 0x72, 0x61, 0x6c,
	0x5f, 0x70, 0x61, 0x72, 0x74, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x3b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x61, 0x69, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61,
	0x31, 0x2e, 0x50, 0x61, 0x72, 0x74, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x54, 0x65, 0x6d, 0x70,
	0x6f, 0x72, 0x61, 0x6c, 0x50, 0x61, 0x72, 0x74, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x42, 0x03, 0xe0,
	0x41, 0x02, 0x52, 0x11, 0x74, 0x65, 0x6d, 0x70, 0x6f, 0x72, 0x61, 0x6c, 0x50, 0x61, 0x72, 0x74,
	0x69, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x92, 0x02, 0x0a, 0x11, 0x43, 0x6c, 0x69, 0x70, 0x41, 0x73,
	0x73, 0x65, 0x74, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x6c, 0x0a, 0x11, 0x74,
	0x69, 0x6d, 0x65, 0x5f, 0x69, 0x6e, 0x64, 0x65, 0x78, 0x65, 0x64, 0x5f, 0x75, 0x72, 0x69, 0x73,
	0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x40, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x61, 0x69, 0x2e, 0x76,
	0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e, 0x43, 0x6c, 0x69, 0x70, 0x41, 0x73, 0x73, 0x65,
	0x74, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x49, 0x6e,
	0x64, 0x65, 0x78, 0x65, 0x64, 0x55, 0x72, 0x69, 0x52, 0x0f, 0x74, 0x69, 0x6d, 0x65, 0x49, 0x6e,
	0x64, 0x65, 0x78, 0x65, 0x64, 0x55, 0x72, 0x69, 0x73, 0x1a, 0x8e, 0x01, 0x0a, 0x0e, 0x54, 0x69,
	0x6d, 0x65, 0x49, 0x6e, 0x64, 0x65, 0x78, 0x65, 0x64, 0x55, 0x72, 0x69, 0x12, 0x6a, 0x0a, 0x12,
	0x74, 0x65, 0x6d, 0x70, 0x6f, 0x72, 0x61, 0x6c, 0x5f, 0x70, 0x61, 0x72, 0x74, 0x69, 0x74, 0x69,
	0x6f, 0x6e, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x3b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x61, 0x69,
	0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e, 0x50, 0x61, 0x72, 0x74, 0x69, 0x74,
	0x69, 0x6f, 0x6e, 0x2e, 0x54, 0x65, 0x6d, 0x70, 0x6f, 0x72, 0x61, 0x6c, 0x50, 0x61, 0x72, 0x74,
	0x69, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x11, 0x74, 0x65, 0x6d, 0x70, 0x6f, 0x72, 0x61, 0x6c, 0x50,
	0x61, 0x72, 0x74, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x10, 0x0a, 0x03, 0x75, 0x72, 0x69, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x75, 0x72, 0x69, 0x22, 0xc5, 0x01, 0x0a, 0x15, 0x47,
	0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x65, 0x48, 0x6c, 0x73, 0x55, 0x72, 0x69, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x12, 0x39, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x09, 0x42, 0x25, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x1f, 0x0a, 0x1d, 0x76, 0x69, 0x73, 0x69,
	0x6f, 0x6e, 0x61, 0x69, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e,
	0x63, 0x6f, 0x6d, 0x2f, 0x41, 0x73, 0x73, 0x65, 0x74, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12,
	0x71, 0x0a, 0x13, 0x74, 0x65, 0x6d, 0x70, 0x6f, 0x72, 0x61, 0x6c, 0x5f, 0x70, 0x61, 0x72, 0x74,
	0x69, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x3b, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x73, 0x69,
	0x6f, 0x6e, 0x61, 0x69, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e, 0x50, 0x61,
	0x72, 0x74, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x54, 0x65, 0x6d, 0x70, 0x6f, 0x72, 0x61, 0x6c,
	0x50, 0x61, 0x72, 0x74, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x12,
	0x74, 0x65, 0x6d, 0x70, 0x6f, 0x72, 0x61, 0x6c, 0x50, 0x61, 0x72, 0x74, 0x69, 0x74, 0x69, 0x6f,
	0x6e, 0x73, 0x22, 0x98, 0x01, 0x0a, 0x16, 0x47, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x65, 0x48,
	0x6c, 0x73, 0x55, 0x72, 0x69, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x10, 0x0a,
	0x03, 0x75, 0x72, 0x69, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x75, 0x72, 0x69, 0x12,
	0x6c, 0x0a, 0x13, 0x74, 0x65, 0x6d, 0x70, 0x6f, 0x72, 0x61, 0x6c, 0x5f, 0x70, 0x61, 0x72, 0x74,
	0x69, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x3b, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x73, 0x69,
	0x6f, 0x6e, 0x61, 0x69, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e, 0x50, 0x61,
	0x72, 0x74, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x54, 0x65, 0x6d, 0x70, 0x6f, 0x72, 0x61, 0x6c,
	0x50, 0x61, 0x72, 0x74, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x12, 0x74, 0x65, 0x6d, 0x70, 0x6f,
	0x72, 0x61, 0x6c, 0x50, 0x61, 0x72, 0x74, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x22, 0xd0, 0x04,
	0x0a, 0x13, 0x53, 0x65, 0x61, 0x72, 0x63, 0x68, 0x41, 0x73, 0x73, 0x65, 0x74, 0x73, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x79, 0x0a, 0x1b, 0x73, 0x63, 0x68, 0x65, 0x6d, 0x61, 0x5f,
	0x6b, 0x65, 0x79, 0x5f, 0x73, 0x6f, 0x72, 0x74, 0x69, 0x6e, 0x67, 0x5f, 0x73, 0x74, 0x72, 0x61,
	0x74, 0x65, 0x67, 0x79, 0x18, 0x09, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x38, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e,
	0x61, 0x69, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e, 0x53, 0x63, 0x68, 0x65,
	0x6d, 0x61, 0x4b, 0x65, 0x79, 0x53, 0x6f, 0x72, 0x74, 0x69, 0x6e, 0x67, 0x53, 0x74, 0x72, 0x61,
	0x74, 0x65, 0x67, 0x79, 0x48, 0x00, 0x52, 0x18, 0x73, 0x63, 0x68, 0x65, 0x6d, 0x61, 0x4b, 0x65,
	0x79, 0x53, 0x6f, 0x72, 0x74, 0x69, 0x6e, 0x67, 0x53, 0x74, 0x72, 0x61, 0x74, 0x65, 0x67, 0x79,
	0x12, 0x3e, 0x0a, 0x06, 0x63, 0x6f, 0x72, 0x70, 0x75, 0x73, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09,
	0x42, 0x26, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x20, 0x0a, 0x1e, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e,
	0x61, 0x69, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f,
	0x6d, 0x2f, 0x43, 0x6f, 0x72, 0x70, 0x75, 0x73, 0x52, 0x06, 0x63, 0x6f, 0x72, 0x70, 0x75, 0x73,
	0x12, 0x1b, 0x0a, 0x09, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x05, 0x52, 0x08, 0x70, 0x61, 0x67, 0x65, 0x53, 0x69, 0x7a, 0x65, 0x12, 0x1d, 0x0a,
	0x0a, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x09, 0x70, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x12, 0x62, 0x0a, 0x13,
	0x63, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x5f, 0x72, 0x61, 0x6e,
	0x67, 0x65, 0x73, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x32, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x61,
	0x69, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e, 0x44, 0x61, 0x74, 0x65, 0x54,
	0x69, 0x6d, 0x65, 0x52, 0x61, 0x6e, 0x67, 0x65, 0x41, 0x72, 0x72, 0x61, 0x79, 0x52, 0x11, 0x63,
	0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x54, 0x69, 0x6d, 0x65, 0x52, 0x61, 0x6e, 0x67, 0x65, 0x73,
	0x12, 0x44, 0x0a, 0x08, 0x63, 0x72, 0x69, 0x74, 0x65, 0x72, 0x69, 0x61, 0x18, 0x04, 0x20, 0x03,
	0x28, 0x0b, 0x32, 0x28, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x61, 0x69, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70,
	0x68, 0x61, 0x31, 0x2e, 0x43, 0x72, 0x69, 0x74, 0x65, 0x72, 0x69, 0x61, 0x52, 0x08, 0x63, 0x72,
	0x69, 0x74, 0x65, 0x72, 0x69, 0x61, 0x12, 0x55, 0x0a, 0x10, 0x66, 0x61, 0x63, 0x65, 0x74, 0x5f,
	0x73, 0x65, 0x6c, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x06, 0x20, 0x03, 0x28, 0x0b,
	0x32, 0x2a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x61, 0x69, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61,
	0x31, 0x2e, 0x46, 0x61, 0x63, 0x65, 0x74, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x52, 0x0f, 0x66, 0x61,
	0x63, 0x65, 0x74, 0x53, 0x65, 0x6c, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x34, 0x0a,
	0x16, 0x72, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x5f, 0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x5f, 0x6b, 0x65, 0x79, 0x73, 0x18, 0x08, 0x20, 0x03, 0x28, 0x09, 0x52, 0x14, 0x72,
	0x65, 0x73, 0x75, 0x6c, 0x74, 0x41, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4b,
	0x65, 0x79, 0x73, 0x42, 0x0b, 0x0a, 0x09, 0x73, 0x6f, 0x72, 0x74, 0x5f, 0x73, 0x70, 0x65, 0x63,
	0x22, 0xd9, 0x03, 0x0a, 0x18, 0x53, 0x63, 0x68, 0x65, 0x6d, 0x61, 0x4b, 0x65, 0x79, 0x53, 0x6f,
	0x72, 0x74, 0x69, 0x6e, 0x67, 0x53, 0x74, 0x72, 0x61, 0x74, 0x65, 0x67, 0x79, 0x12, 0x59, 0x0a,
	0x07, 0x6f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x3f,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69,
	0x73, 0x69, 0x6f, 0x6e, 0x61, 0x69, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e,
	0x53, 0x63, 0x68, 0x65, 0x6d, 0x61, 0x4b, 0x65, 0x79, 0x53, 0x6f, 0x72, 0x74, 0x69, 0x6e, 0x67,
	0x53, 0x74, 0x72, 0x61, 0x74, 0x65, 0x67, 0x79, 0x2e, 0x4f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x52,
	0x07, 0x6f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x1a, 0xe1, 0x02, 0x0a, 0x06, 0x4f, 0x70, 0x74,
	0x69, 0x6f, 0x6e, 0x12, 0x26, 0x0a, 0x0f, 0x64, 0x61, 0x74, 0x61, 0x5f, 0x73, 0x63, 0x68, 0x65,
	0x6d, 0x61, 0x5f, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x64, 0x61,
	0x74, 0x61, 0x53, 0x63, 0x68, 0x65, 0x6d, 0x61, 0x4b, 0x65, 0x79, 0x12, 0x27, 0x0a, 0x0f, 0x73,
	0x6f, 0x72, 0x74, 0x5f, 0x64, 0x65, 0x63, 0x72, 0x65, 0x61, 0x73, 0x69, 0x6e, 0x67, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x08, 0x52, 0x0e, 0x73, 0x6f, 0x72, 0x74, 0x44, 0x65, 0x63, 0x72, 0x65, 0x61,
	0x73, 0x69, 0x6e, 0x67, 0x12, 0x7f, 0x0a, 0x10, 0x61, 0x67, 0x67, 0x72, 0x65, 0x67, 0x61, 0x74,
	0x65, 0x5f, 0x6d, 0x65, 0x74, 0x68, 0x6f, 0x64, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x4f,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69,
	0x73, 0x69, 0x6f, 0x6e, 0x61, 0x69, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e,
	0x53, 0x63, 0x68, 0x65, 0x6d, 0x61, 0x4b, 0x65, 0x79, 0x53, 0x6f, 0x72, 0x74, 0x69, 0x6e, 0x67,
	0x53, 0x74, 0x72, 0x61, 0x74, 0x65, 0x67, 0x79, 0x2e, 0x4f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x2e,
	0x41, 0x67, 0x67, 0x72, 0x65, 0x67, 0x61, 0x74, 0x65, 0x4d, 0x65, 0x74, 0x68, 0x6f, 0x64, 0x48,
	0x00, 0x52, 0x0f, 0x61, 0x67, 0x67, 0x72, 0x65, 0x67, 0x61, 0x74, 0x65, 0x4d, 0x65, 0x74, 0x68,
	0x6f, 0x64, 0x88, 0x01, 0x01, 0x22, 0x70, 0x0a, 0x0f, 0x41, 0x67, 0x67, 0x72, 0x65, 0x67, 0x61,
	0x74, 0x65, 0x4d, 0x65, 0x74, 0x68, 0x6f, 0x64, 0x12, 0x20, 0x0a, 0x1c, 0x41, 0x47, 0x47, 0x52,
	0x45, 0x47, 0x41, 0x54, 0x45, 0x5f, 0x4d, 0x45, 0x54, 0x48, 0x4f, 0x44, 0x5f, 0x55, 0x4e, 0x53,
	0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x1c, 0x0a, 0x18, 0x41, 0x47,
	0x47, 0x52, 0x45, 0x47, 0x41, 0x54, 0x45, 0x5f, 0x4d, 0x45, 0x54, 0x48, 0x4f, 0x44, 0x5f, 0x4c,
	0x41, 0x52, 0x47, 0x45, 0x53, 0x54, 0x10, 0x01, 0x12, 0x1d, 0x0a, 0x19, 0x41, 0x47, 0x47, 0x52,
	0x45, 0x47, 0x41, 0x54, 0x45, 0x5f, 0x4d, 0x45, 0x54, 0x48, 0x4f, 0x44, 0x5f, 0x53, 0x4d, 0x41,
	0x4c, 0x4c, 0x45, 0x53, 0x54, 0x10, 0x02, 0x42, 0x13, 0x0a, 0x11, 0x5f, 0x61, 0x67, 0x67, 0x72,
	0x65, 0x67, 0x61, 0x74, 0x65, 0x5f, 0x6d, 0x65, 0x74, 0x68, 0x6f, 0x64, 0x22, 0xe9, 0x01, 0x0a,
	0x18, 0x41, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x61, 0x74, 0x63, 0x68,
	0x69, 0x6e, 0x67, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x12, 0x44, 0x0a, 0x08, 0x63, 0x72, 0x69,
	0x74, 0x65, 0x72, 0x69, 0x61, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x28, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x73, 0x69, 0x6f,
	0x6e, 0x61, 0x69, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e, 0x43, 0x72, 0x69,
	0x74, 0x65, 0x72, 0x69, 0x61, 0x52, 0x08, 0x63, 0x72, 0x69, 0x74, 0x65, 0x72, 0x69, 0x61, 0x12,
	0x5b, 0x0a, 0x13, 0x6d, 0x61, 0x74, 0x63, 0x68, 0x65, 0x64, 0x5f, 0x61, 0x6e, 0x6e, 0x6f, 0x74,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x2a, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x73, 0x69,
	0x6f, 0x6e, 0x61, 0x69, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e, 0x41, 0x6e,
	0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x12, 0x6d, 0x61, 0x74, 0x63, 0x68, 0x65,
	0x64, 0x41, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x2a, 0x0a, 0x06,
	0x73, 0x74, 0x61, 0x74, 0x75, 0x73, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x12, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x72, 0x70, 0x63, 0x2e, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73,
	0x52, 0x06, 0x73, 0x74, 0x61, 0x74, 0x75, 0x73, 0x22, 0xb7, 0x03, 0x0a, 0x10, 0x53, 0x65, 0x61,
	0x72, 0x63, 0x68, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x49, 0x74, 0x65, 0x6d, 0x12, 0x14, 0x0a,
	0x05, 0x61, 0x73, 0x73, 0x65, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x61, 0x73,
	0x73, 0x65, 0x74, 0x12, 0x5b, 0x0a, 0x08, 0x73, 0x65, 0x67, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x18,
	0x02, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x3b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x61, 0x69, 0x2e, 0x76, 0x31,
	0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e, 0x50, 0x61, 0x72, 0x74, 0x69, 0x74, 0x69, 0x6f, 0x6e,
	0x2e, 0x54, 0x65, 0x6d, 0x70, 0x6f, 0x72, 0x61, 0x6c, 0x50, 0x61, 0x72, 0x74, 0x69, 0x74, 0x69,
	0x6f, 0x6e, 0x42, 0x02, 0x18, 0x01, 0x52, 0x08, 0x73, 0x65, 0x67, 0x6d, 0x65, 0x6e, 0x74, 0x73,
	0x12, 0x55, 0x0a, 0x07, 0x73, 0x65, 0x67, 0x6d, 0x65, 0x6e, 0x74, 0x18, 0x05, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x3b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x61, 0x69, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68,
	0x61, 0x31, 0x2e, 0x50, 0x61, 0x72, 0x74, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x54, 0x65, 0x6d,
	0x70, 0x6f, 0x72, 0x61, 0x6c, 0x50, 0x61, 0x72, 0x74, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x07,
	0x73, 0x65, 0x67, 0x6d, 0x65, 0x6e, 0x74, 0x12, 0x5f, 0x0a, 0x15, 0x72, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x65, 0x64, 0x5f, 0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73,
	0x18, 0x03, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x2a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x61, 0x69, 0x2e, 0x76,
	0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e, 0x41, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x52, 0x14, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x65, 0x64, 0x41, 0x6e, 0x6e,
	0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x78, 0x0a, 0x1b, 0x61, 0x6e, 0x6e, 0x6f,
	0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x6d, 0x61, 0x74, 0x63, 0x68, 0x69, 0x6e, 0x67, 0x5f,
	0x72, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x73, 0x18, 0x04, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x38, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x73,
	0x69, 0x6f, 0x6e, 0x61, 0x69, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e, 0x41,
	0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x61, 0x74, 0x63, 0x68, 0x69, 0x6e,
	0x67, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x52, 0x19, 0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x4d, 0x61, 0x74, 0x63, 0x68, 0x69, 0x6e, 0x67, 0x52, 0x65, 0x73, 0x75, 0x6c,
	0x74, 0x73, 0x22, 0xf1, 0x01, 0x0a, 0x14, 0x53, 0x65, 0x61, 0x72, 0x63, 0x68, 0x41, 0x73, 0x73,
	0x65, 0x74, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x60, 0x0a, 0x13, 0x73,
	0x65, 0x61, 0x72, 0x63, 0x68, 0x5f, 0x72, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x5f, 0x69, 0x74, 0x65,
	0x6d, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x30, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x61, 0x69,
	0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e, 0x53, 0x65, 0x61, 0x72, 0x63, 0x68,
	0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x49, 0x74, 0x65, 0x6d, 0x52, 0x11, 0x73, 0x65, 0x61, 0x72,
	0x63, 0x68, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x49, 0x74, 0x65, 0x6d, 0x73, 0x12, 0x26, 0x0a,
	0x0f, 0x6e, 0x65, 0x78, 0x74, 0x5f, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x6e, 0x65, 0x78, 0x74, 0x50, 0x61, 0x67, 0x65,
	0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x12, 0x4f, 0x0a, 0x0d, 0x66, 0x61, 0x63, 0x65, 0x74, 0x5f, 0x72,
	0x65, 0x73, 0x75, 0x6c, 0x74, 0x73, 0x18, 0x03, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x2a, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x73, 0x69,
	0x6f, 0x6e, 0x61, 0x69, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e, 0x46, 0x61,
	0x63, 0x65, 0x74, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x52, 0x0c, 0x66, 0x61, 0x63, 0x65, 0x74, 0x52,
	0x65, 0x73, 0x75, 0x6c, 0x74, 0x73, 0x22, 0x4e, 0x0a, 0x08, 0x49, 0x6e, 0x74, 0x52, 0x61, 0x6e,
	0x67, 0x65, 0x12, 0x19, 0x0a, 0x05, 0x73, 0x74, 0x61, 0x72, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x03, 0x48, 0x00, 0x52, 0x05, 0x73, 0x74, 0x61, 0x72, 0x74, 0x88, 0x01, 0x01, 0x12, 0x15, 0x0a,
	0x03, 0x65, 0x6e, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x03, 0x48, 0x01, 0x52, 0x03, 0x65, 0x6e,
	0x64, 0x88, 0x01, 0x01, 0x42, 0x08, 0x0a, 0x06, 0x5f, 0x73, 0x74, 0x61, 0x72, 0x74, 0x42, 0x06,
	0x0a, 0x04, 0x5f, 0x65, 0x6e, 0x64, 0x22, 0x50, 0x0a, 0x0a, 0x46, 0x6c, 0x6f, 0x61, 0x74, 0x52,
	0x61, 0x6e, 0x67, 0x65, 0x12, 0x19, 0x0a, 0x05, 0x73, 0x74, 0x61, 0x72, 0x74, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x02, 0x48, 0x00, 0x52, 0x05, 0x73, 0x74, 0x61, 0x72, 0x74, 0x88, 0x01, 0x01, 0x12,
	0x15, 0x0a, 0x03, 0x65, 0x6e, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x02, 0x48, 0x01, 0x52, 0x03,
	0x65, 0x6e, 0x64, 0x88, 0x01, 0x01, 0x42, 0x08, 0x0a, 0x06, 0x5f, 0x73, 0x74, 0x61, 0x72, 0x74,
	0x42, 0x06, 0x0a, 0x04, 0x5f, 0x65, 0x6e, 0x64, 0x22, 0x2c, 0x0a, 0x0b, 0x53, 0x74, 0x72, 0x69,
	0x6e, 0x67, 0x41, 0x72, 0x72, 0x61, 0x79, 0x12, 0x1d, 0x0a, 0x0a, 0x74, 0x78, 0x74, 0x5f, 0x76,
	0x61, 0x6c, 0x75, 0x65, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x09, 0x52, 0x09, 0x74, 0x78, 0x74,
	0x56, 0x61, 0x6c, 0x75, 0x65, 0x73, 0x22, 0x58, 0x0a, 0x0d, 0x49, 0x6e, 0x74, 0x52, 0x61, 0x6e,
	0x67, 0x65, 0x41, 0x72, 0x72, 0x61, 0x79, 0x12, 0x47, 0x0a, 0x0a, 0x69, 0x6e, 0x74, 0x5f, 0x72,
	0x61, 0x6e, 0x67, 0x65, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x28, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x73, 0x69, 0x6f,
	0x6e, 0x61, 0x69, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e, 0x49, 0x6e, 0x74,
	0x52, 0x61, 0x6e, 0x67, 0x65, 0x52, 0x09, 0x69, 0x6e, 0x74, 0x52, 0x61, 0x6e, 0x67, 0x65, 0x73,
	0x22, 0x60, 0x0a, 0x0f, 0x46, 0x6c, 0x6f, 0x61, 0x74, 0x52, 0x61, 0x6e, 0x67, 0x65, 0x41, 0x72,
	0x72, 0x61, 0x79, 0x12, 0x4d, 0x0a, 0x0c, 0x66, 0x6c, 0x6f, 0x61, 0x74, 0x5f, 0x72, 0x61, 0x6e,
	0x67, 0x65, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x2a, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x61,
	0x69, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e, 0x46, 0x6c, 0x6f, 0x61, 0x74,
	0x52, 0x61, 0x6e, 0x67, 0x65, 0x52, 0x0b, 0x66, 0x6c, 0x6f, 0x61, 0x74, 0x52, 0x61, 0x6e, 0x67,
	0x65, 0x73, 0x22, 0x65, 0x0a, 0x0d, 0x44, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x52, 0x61,
	0x6e, 0x67, 0x65, 0x12, 0x2b, 0x0a, 0x05, 0x73, 0x74, 0x61, 0x72, 0x74, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x15, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x74, 0x79, 0x70, 0x65,
	0x2e, 0x44, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x52, 0x05, 0x73, 0x74, 0x61, 0x72, 0x74,
	0x12, 0x27, 0x0a, 0x03, 0x65, 0x6e, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x15, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x74, 0x79, 0x70, 0x65, 0x2e, 0x44, 0x61, 0x74, 0x65,
	0x54, 0x69, 0x6d, 0x65, 0x52, 0x03, 0x65, 0x6e, 0x64, 0x22, 0x6d, 0x0a, 0x12, 0x44, 0x61, 0x74,
	0x65, 0x54, 0x69, 0x6d, 0x65, 0x52, 0x61, 0x6e, 0x67, 0x65, 0x41, 0x72, 0x72, 0x61, 0x79, 0x12,
	0x57, 0x0a, 0x10, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x5f, 0x72, 0x61, 0x6e,
	0x67, 0x65, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x2d, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x61,
	0x69, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e, 0x44, 0x61, 0x74, 0x65, 0x54,
	0x69, 0x6d, 0x65, 0x52, 0x61, 0x6e, 0x67, 0x65, 0x52, 0x0e, 0x64, 0x61, 0x74, 0x65, 0x54, 0x69,
	0x6d, 0x65, 0x52, 0x61, 0x6e, 0x67, 0x65, 0x73, 0x22, 0x69, 0x0a, 0x0a, 0x43, 0x69, 0x72, 0x63,
	0x6c, 0x65, 0x41, 0x72, 0x65, 0x61, 0x12, 0x1a, 0x0a, 0x08, 0x6c, 0x61, 0x74, 0x69, 0x74, 0x75,
	0x64, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x01, 0x52, 0x08, 0x6c, 0x61, 0x74, 0x69, 0x74, 0x75,
	0x64, 0x65, 0x12, 0x1c, 0x0a, 0x09, 0x6c, 0x6f, 0x6e, 0x67, 0x69, 0x74, 0x75, 0x64, 0x65, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x01, 0x52, 0x09, 0x6c, 0x6f, 0x6e, 0x67, 0x69, 0x74, 0x75, 0x64, 0x65,
	0x12, 0x21, 0x0a, 0x0c, 0x72, 0x61, 0x64, 0x69, 0x75, 0x73, 0x5f, 0x6d, 0x65, 0x74, 0x65, 0x72,
	0x18, 0x03, 0x20, 0x01, 0x28, 0x01, 0x52, 0x0b, 0x72, 0x61, 0x64, 0x69, 0x75, 0x73, 0x4d, 0x65,
	0x74, 0x65, 0x72, 0x22, 0x61, 0x0a, 0x10, 0x47, 0x65, 0x6f, 0x4c, 0x6f, 0x63, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x41, 0x72, 0x72, 0x61, 0x79, 0x12, 0x4d, 0x0a, 0x0c, 0x63, 0x69, 0x72, 0x63, 0x6c,
	0x65, 0x5f, 0x61, 0x72, 0x65, 0x61, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x2a, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x73,
	0x69, 0x6f, 0x6e, 0x61, 0x69, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e, 0x43,
	0x69, 0x72, 0x63, 0x6c, 0x65, 0x41, 0x72, 0x65, 0x61, 0x52, 0x0b, 0x63, 0x69, 0x72, 0x63, 0x6c,
	0x65, 0x41, 0x72, 0x65, 0x61, 0x73, 0x22, 0x21, 0x0a, 0x09, 0x42, 0x6f, 0x6f, 0x6c, 0x56, 0x61,
	0x6c, 0x75, 0x65, 0x12, 0x14, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x08, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x22, 0x82, 0x05, 0x0a, 0x08, 0x43, 0x72,
	0x69, 0x74, 0x65, 0x72, 0x69, 0x61, 0x12, 0x4c, 0x0a, 0x0a, 0x74, 0x65, 0x78, 0x74, 0x5f, 0x61,
	0x72, 0x72, 0x61, 0x79, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2b, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e,
	0x61, 0x69, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e, 0x53, 0x74, 0x72, 0x69,
	0x6e, 0x67, 0x41, 0x72, 0x72, 0x61, 0x79, 0x48, 0x00, 0x52, 0x09, 0x74, 0x65, 0x78, 0x74, 0x41,
	0x72, 0x72, 0x61, 0x79, 0x12, 0x57, 0x0a, 0x0f, 0x69, 0x6e, 0x74, 0x5f, 0x72, 0x61, 0x6e, 0x67,
	0x65, 0x5f, 0x61, 0x72, 0x72, 0x61, 0x79, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2d, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x73,
	0x69, 0x6f, 0x6e, 0x61, 0x69, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e, 0x49,
	0x6e, 0x74, 0x52, 0x61, 0x6e, 0x67, 0x65, 0x41, 0x72, 0x72, 0x61, 0x79, 0x48, 0x00, 0x52, 0x0d,
	0x69, 0x6e, 0x74, 0x52, 0x61, 0x6e, 0x67, 0x65, 0x41, 0x72, 0x72, 0x61, 0x79, 0x12, 0x5d, 0x0a,
	0x11, 0x66, 0x6c, 0x6f, 0x61, 0x74, 0x5f, 0x72, 0x61, 0x6e, 0x67, 0x65, 0x5f, 0x61, 0x72, 0x72,
	0x61, 0x79, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x61, 0x69,
	0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e, 0x46, 0x6c, 0x6f, 0x61, 0x74, 0x52,
	0x61, 0x6e, 0x67, 0x65, 0x41, 0x72, 0x72, 0x61, 0x79, 0x48, 0x00, 0x52, 0x0f, 0x66, 0x6c, 0x6f,
	0x61, 0x74, 0x52, 0x61, 0x6e, 0x67, 0x65, 0x41, 0x72, 0x72, 0x61, 0x79, 0x12, 0x67, 0x0a, 0x15,
	0x64, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x5f, 0x72, 0x61, 0x6e, 0x67, 0x65, 0x5f,
	0x61, 0x72, 0x72, 0x61, 0x79, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x32, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x73, 0x69, 0x6f,
	0x6e, 0x61, 0x69, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e, 0x44, 0x61, 0x74,
	0x65, 0x54, 0x69, 0x6d, 0x65, 0x52, 0x61, 0x6e, 0x67, 0x65, 0x41, 0x72, 0x72, 0x61, 0x79, 0x48,
	0x00, 0x52, 0x12, 0x64, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x52, 0x61, 0x6e, 0x67, 0x65,
	0x41, 0x72, 0x72, 0x61, 0x79, 0x12, 0x60, 0x0a, 0x12, 0x67, 0x65, 0x6f, 0x5f, 0x6c, 0x6f, 0x63,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x61, 0x72, 0x72, 0x61, 0x79, 0x18, 0x06, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x30, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x61, 0x69, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68,
	0x61, 0x31, 0x2e, 0x47, 0x65, 0x6f, 0x4c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x41, 0x72,
	0x72, 0x61, 0x79, 0x48, 0x00, 0x52, 0x10, 0x67, 0x65, 0x6f, 0x4c, 0x6f, 0x63, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x41, 0x72, 0x72, 0x61, 0x79, 0x12, 0x4a, 0x0a, 0x0a, 0x62, 0x6f, 0x6f, 0x6c, 0x5f,
	0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x07, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x29, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x73, 0x69, 0x6f,
	0x6e, 0x61, 0x69, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e, 0x42, 0x6f, 0x6f,
	0x6c, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x48, 0x00, 0x52, 0x09, 0x62, 0x6f, 0x6f, 0x6c, 0x56, 0x61,
	0x6c, 0x75, 0x65, 0x12, 0x14, 0x0a, 0x05, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x05, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x12, 0x3a, 0x0a, 0x19, 0x66, 0x65, 0x74,
	0x63, 0x68, 0x5f, 0x6d, 0x61, 0x74, 0x63, 0x68, 0x65, 0x64, 0x5f, 0x61, 0x6e, 0x6e, 0x6f, 0x74,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x08, 0x20, 0x01, 0x28, 0x08, 0x52, 0x17, 0x66, 0x65,
	0x74, 0x63, 0x68, 0x4d, 0x61, 0x74, 0x63, 0x68, 0x65, 0x64, 0x41, 0x6e, 0x6e, 0x6f, 0x74, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x73, 0x42, 0x07, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x22, 0x8d,
	0x04, 0x0a, 0x09, 0x50, 0x61, 0x72, 0x74, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x6a, 0x0a, 0x12,
	0x74, 0x65, 0x6d, 0x70, 0x6f, 0x72, 0x61, 0x6c, 0x5f, 0x70, 0x61, 0x72, 0x74, 0x69, 0x74, 0x69,
	0x6f, 0x6e, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x3b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x61, 0x69,
	0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e, 0x50, 0x61, 0x72, 0x74, 0x69, 0x74,
	0x69, 0x6f, 0x6e, 0x2e, 0x54, 0x65, 0x6d, 0x70, 0x6f, 0x72, 0x61, 0x6c, 0x50, 0x61, 0x72, 0x74,
	0x69, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x11, 0x74, 0x65, 0x6d, 0x70, 0x6f, 0x72, 0x61, 0x6c, 0x50,
	0x61, 0x72, 0x74, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x67, 0x0a, 0x11, 0x73, 0x70, 0x61, 0x74,
	0x69, 0x61, 0x6c, 0x5f, 0x70, 0x61, 0x72, 0x74, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x3a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x61, 0x69, 0x2e, 0x76, 0x31, 0x61, 0x6c,
	0x70, 0x68, 0x61, 0x31, 0x2e, 0x50, 0x61, 0x72, 0x74, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x53,
	0x70, 0x61, 0x74, 0x69, 0x61, 0x6c, 0x50, 0x61, 0x72, 0x74, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x52,
	0x10, 0x73, 0x70, 0x61, 0x74, 0x69, 0x61, 0x6c, 0x50, 0x61, 0x72, 0x74, 0x69, 0x74, 0x69, 0x6f,
	0x6e, 0x1a, 0x85, 0x01, 0x0a, 0x11, 0x54, 0x65, 0x6d, 0x70, 0x6f, 0x72, 0x61, 0x6c, 0x50, 0x61,
	0x72, 0x74, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x39, 0x0a, 0x0a, 0x73, 0x74, 0x61, 0x72, 0x74,
	0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69,
	0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x52, 0x09, 0x73, 0x74, 0x61, 0x72, 0x74, 0x54, 0x69,
	0x6d, 0x65, 0x12, 0x35, 0x0a, 0x08, 0x65, 0x6e, 0x64, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70,
	0x52, 0x07, 0x65, 0x6e, 0x64, 0x54, 0x69, 0x6d, 0x65, 0x1a, 0xa2, 0x01, 0x0a, 0x10, 0x53, 0x70,
	0x61, 0x74, 0x69, 0x61, 0x6c, 0x50, 0x61, 0x72, 0x74, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x18,
	0x0a, 0x05, 0x78, 0x5f, 0x6d, 0x69, 0x6e, 0x18, 0x01, 0x20, 0x01, 0x28, 0x03, 0x48, 0x00, 0x52,
	0x04, 0x78, 0x4d, 0x69, 0x6e, 0x88, 0x01, 0x01, 0x12, 0x18, 0x0a, 0x05, 0x79, 0x5f, 0x6d, 0x69,
	0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x03, 0x48, 0x01, 0x52, 0x04, 0x79, 0x4d, 0x69, 0x6e, 0x88,
	0x01, 0x01, 0x12, 0x18, 0x0a, 0x05, 0x78, 0x5f, 0x6d, 0x61, 0x78, 0x18, 0x03, 0x20, 0x01, 0x28,
	0x03, 0x48, 0x02, 0x52, 0x04, 0x78, 0x4d, 0x61, 0x78, 0x88, 0x01, 0x01, 0x12, 0x18, 0x0a, 0x05,
	0x79, 0x5f, 0x6d, 0x61, 0x78, 0x18, 0x04, 0x20, 0x01, 0x28, 0x03, 0x48, 0x03, 0x52, 0x04, 0x79,
	0x4d, 0x61, 0x78, 0x88, 0x01, 0x01, 0x42, 0x08, 0x0a, 0x06, 0x5f, 0x78, 0x5f, 0x6d, 0x69, 0x6e,
	0x42, 0x08, 0x0a, 0x06, 0x5f, 0x79, 0x5f, 0x6d, 0x69, 0x6e, 0x42, 0x08, 0x0a, 0x06, 0x5f, 0x78,
	0x5f, 0x6d, 0x61, 0x78, 0x42, 0x08, 0x0a, 0x06, 0x5f, 0x79, 0x5f, 0x6d, 0x61, 0x78, 0x22, 0x15,
	0x0a, 0x13, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x41, 0x73, 0x73, 0x65, 0x74, 0x4d, 0x65, 0x74,
	0x61, 0x64, 0x61, 0x74, 0x61, 0x22, 0x16, 0x0a, 0x14, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x43,
	0x6f, 0x72, 0x70, 0x75, 0x73, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x2a, 0xb8, 0x01,
	0x0a, 0x0f, 0x46, 0x61, 0x63, 0x65, 0x74, 0x42, 0x75, 0x63, 0x6b, 0x65, 0x74, 0x54, 0x79, 0x70,
	0x65, 0x12, 0x21, 0x0a, 0x1d, 0x46, 0x41, 0x43, 0x45, 0x54, 0x5f, 0x42, 0x55, 0x43, 0x4b, 0x45,
	0x54, 0x5f, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49,
	0x45, 0x44, 0x10, 0x00, 0x12, 0x1b, 0x0a, 0x17, 0x46, 0x41, 0x43, 0x45, 0x54, 0x5f, 0x42, 0x55,
	0x43, 0x4b, 0x45, 0x54, 0x5f, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x56, 0x41, 0x4c, 0x55, 0x45, 0x10,
	0x01, 0x12, 0x1e, 0x0a, 0x1a, 0x46, 0x41, 0x43, 0x45, 0x54, 0x5f, 0x42, 0x55, 0x43, 0x4b, 0x45,
	0x54, 0x5f, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x44, 0x41, 0x54, 0x45, 0x54, 0x49, 0x4d, 0x45, 0x10,
	0x02, 0x12, 0x21, 0x0a, 0x1d, 0x46, 0x41, 0x43, 0x45, 0x54, 0x5f, 0x42, 0x55, 0x43, 0x4b, 0x45,
	0x54, 0x5f, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x46, 0x49, 0x58, 0x45, 0x44, 0x5f, 0x52, 0x41, 0x4e,
	0x47, 0x45, 0x10, 0x03, 0x12, 0x22, 0x0a, 0x1e, 0x46, 0x41, 0x43, 0x45, 0x54, 0x5f, 0x42, 0x55,
	0x43, 0x4b, 0x45, 0x54, 0x5f, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x43, 0x55, 0x53, 0x54, 0x4f, 0x4d,
	0x5f, 0x52, 0x41, 0x4e, 0x47, 0x45, 0x10, 0x04, 0x32, 0xcf, 0x2f, 0x0a, 0x09, 0x57, 0x61, 0x72,
	0x65, 0x68, 0x6f, 0x75, 0x73, 0x65, 0x12, 0xcb, 0x01, 0x0a, 0x0b, 0x43, 0x72, 0x65, 0x61, 0x74,
	0x65, 0x41, 0x73, 0x73, 0x65, 0x74, 0x12, 0x32, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x61, 0x69, 0x2e, 0x76,
	0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x41, 0x73,
	0x73, 0x65, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x25, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e,
	0x61, 0x69, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e, 0x41, 0x73, 0x73, 0x65,
	0x74, 0x22, 0x61, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x43, 0x22, 0x3a, 0x2f, 0x76, 0x31, 0x61, 0x6c,
	0x70, 0x68, 0x61, 0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f,
	0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x73, 0x2f, 0x2a, 0x2f, 0x63, 0x6f, 0x72, 0x70, 0x6f, 0x72, 0x61, 0x2f, 0x2a, 0x7d, 0x2f, 0x61,
	0x73, 0x73, 0x65, 0x74, 0x73, 0x3a, 0x05, 0x61, 0x73, 0x73, 0x65, 0x74, 0xda, 0x41, 0x15, 0x70,
	0x61, 0x72, 0x65, 0x6e, 0x74, 0x2c, 0x61, 0x73, 0x73, 0x65, 0x74, 0x2c, 0x61, 0x73, 0x73, 0x65,
	0x74, 0x5f, 0x69, 0x64, 0x12, 0xcd, 0x01, 0x0a, 0x0b, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x41,
	0x73, 0x73, 0x65, 0x74, 0x12, 0x32, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x61, 0x69, 0x2e, 0x76, 0x31, 0x61,
	0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x41, 0x73, 0x73, 0x65,
	0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x25, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x61, 0x69,
	0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e, 0x41, 0x73, 0x73, 0x65, 0x74, 0x22,
	0x63, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x49, 0x32, 0x40, 0x2f, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68,
	0x61, 0x31, 0x2f, 0x7b, 0x61, 0x73, 0x73, 0x65, 0x74, 0x2e, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70,
	0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x63, 0x6f, 0x72, 0x70, 0x6f, 0x72, 0x61, 0x2f, 0x2a, 0x2f,
	0x61, 0x73, 0x73, 0x65, 0x74, 0x73, 0x2f, 0x2a, 0x7d, 0x3a, 0x05, 0x61, 0x73, 0x73, 0x65, 0x74,
	0xda, 0x41, 0x11, 0x61, 0x73, 0x73, 0x65, 0x74, 0x2c, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f,
	0x6d, 0x61, 0x73, 0x6b, 0x12, 0xad, 0x01, 0x0a, 0x08, 0x47, 0x65, 0x74, 0x41, 0x73, 0x73, 0x65,
	0x74, 0x12, 0x2f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x61, 0x69, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68,
	0x61, 0x31, 0x2e, 0x47, 0x65, 0x74, 0x41, 0x73, 0x73, 0x65, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x1a, 0x25, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x61, 0x69, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70,
	0x68, 0x61, 0x31, 0x2e, 0x41, 0x73, 0x73, 0x65, 0x74, 0x22, 0x49, 0x82, 0xd3, 0xe4, 0x93, 0x02,
	0x3c, 0x12, 0x3a, 0x2f, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2f, 0x7b, 0x6e, 0x61,
	0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f,
	0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x63, 0x6f, 0x72, 0x70, 0x6f, 0x72,
	0x61, 0x2f, 0x2a, 0x2f, 0x61, 0x73, 0x73, 0x65, 0x74, 0x73, 0x2f, 0x2a, 0x7d, 0xda, 0x41, 0x04,
	0x6e, 0x61, 0x6d, 0x65, 0x12, 0xc0, 0x01, 0x0a, 0x0a, 0x4c, 0x69, 0x73, 0x74, 0x41, 0x73, 0x73,
	0x65, 0x74, 0x73, 0x12, 0x31, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x61, 0x69, 0x2e, 0x76, 0x31, 0x61, 0x6c,
	0x70, 0x68, 0x61, 0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x41, 0x73, 0x73, 0x65, 0x74, 0x73, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x32, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x61, 0x69, 0x2e, 0x76,
	0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x41, 0x73, 0x73, 0x65,
	0x74, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x4b, 0x82, 0xd3, 0xe4, 0x93,
	0x02, 0x3c, 0x12, 0x3a, 0x2f, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2f, 0x7b, 0x70,
	0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a,
	0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x63, 0x6f, 0x72,
	0x70, 0x6f, 0x72, 0x61, 0x2f, 0x2a, 0x7d, 0x2f, 0x61, 0x73, 0x73, 0x65, 0x74, 0x73, 0xda, 0x41,
	0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0xda, 0x01, 0x0a, 0x0b, 0x44, 0x65, 0x6c, 0x65,
	0x74, 0x65, 0x41, 0x73, 0x73, 0x65, 0x74, 0x12, 0x32, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x61, 0x69, 0x2e,
	0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x41,
	0x73, 0x73, 0x65, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1d, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6c, 0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67,
	0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x78, 0x82, 0xd3, 0xe4, 0x93,
	0x02, 0x3c, 0x2a, 0x3a, 0x2f, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2f, 0x7b, 0x6e,
	0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c,
	0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x63, 0x6f, 0x72, 0x70, 0x6f,
	0x72, 0x61, 0x2f, 0x2a, 0x2f, 0x61, 0x73, 0x73, 0x65, 0x74, 0x73, 0x2f, 0x2a, 0x7d, 0xda, 0x41,
	0x04, 0x6e, 0x61, 0x6d, 0x65, 0xca, 0x41, 0x2c, 0x0a, 0x15, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x45, 0x6d, 0x70, 0x74, 0x79, 0x12,
	0x13, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x41, 0x73, 0x73, 0x65, 0x74, 0x4d, 0x65, 0x74, 0x61,
	0x64, 0x61, 0x74, 0x61, 0x12, 0xd6, 0x01, 0x0a, 0x0c, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x43,
	0x6f, 0x72, 0x70, 0x75, 0x73, 0x12, 0x33, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x61, 0x69, 0x2e, 0x76, 0x31,
	0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x43, 0x6f, 0x72,
	0x70, 0x75, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1d, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x6c, 0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x2e,
	0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x72, 0x82, 0xd3, 0xe4, 0x93, 0x02,
	0x3b, 0x22, 0x31, 0x2f, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2f, 0x7b, 0x70, 0x61,
	0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f,
	0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x63, 0x6f, 0x72,
	0x70, 0x6f, 0x72, 0x61, 0x3a, 0x06, 0x63, 0x6f, 0x72, 0x70, 0x75, 0x73, 0xda, 0x41, 0x0d, 0x70,
	0x61, 0x72, 0x65, 0x6e, 0x74, 0x2c, 0x63, 0x6f, 0x72, 0x70, 0x75, 0x73, 0xca, 0x41, 0x1e, 0x0a,
	0x06, 0x43, 0x6f, 0x72, 0x70, 0x75, 0x73, 0x12, 0x14, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x43,
	0x6f, 0x72, 0x70, 0x75, 0x73, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x12, 0xa7, 0x01,
	0x0a, 0x09, 0x47, 0x65, 0x74, 0x43, 0x6f, 0x72, 0x70, 0x75, 0x73, 0x12, 0x30, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x73, 0x69, 0x6f,
	0x6e, 0x61, 0x69, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e, 0x47, 0x65, 0x74,
	0x43, 0x6f, 0x72, 0x70, 0x75, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x26, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x73,
	0x69, 0x6f, 0x6e, 0x61, 0x69, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e, 0x43,
	0x6f, 0x72, 0x70, 0x75, 0x73, 0x22, 0x40, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x33, 0x12, 0x31, 0x2f,
	0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70,
	0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x63, 0x6f, 0x72, 0x70, 0x6f, 0x72, 0x61, 0x2f, 0x2a, 0x7d,
	0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0xca, 0x01, 0x0a, 0x0c, 0x55, 0x70, 0x64, 0x61,
	0x74, 0x65, 0x43, 0x6f, 0x72, 0x70, 0x75, 0x73, 0x12, 0x33, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x61, 0x69,
	0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65,
	0x43, 0x6f, 0x72, 0x70, 0x75, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x26, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x73,
	0x69, 0x6f, 0x6e, 0x61, 0x69, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e, 0x43,
	0x6f, 0x72, 0x70, 0x75, 0x73, 0x22, 0x5d, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x42, 0x32, 0x38, 0x2f,
	0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2f, 0x7b, 0x63, 0x6f, 0x72, 0x70, 0x75, 0x73,
	0x2e, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a,
	0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x63, 0x6f, 0x72,
	0x70, 0x6f, 0x72, 0x61, 0x2f, 0x2a, 0x7d, 0x3a, 0x06, 0x63, 0x6f, 0x72, 0x70, 0x75, 0x73, 0xda,
	0x41, 0x12, 0x63, 0x6f, 0x72, 0x70, 0x75, 0x73, 0x2c, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f,
	0x6d, 0x61, 0x73, 0x6b, 0x12, 0xba, 0x01, 0x0a, 0x0b, 0x4c, 0x69, 0x73, 0x74, 0x43, 0x6f, 0x72,
	0x70, 0x6f, 0x72, 0x61, 0x12, 0x32, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x61, 0x69, 0x2e, 0x76, 0x31, 0x61,
	0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x43, 0x6f, 0x72, 0x70, 0x6f, 0x72,
	0x61, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x33, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x61, 0x69,
	0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x43, 0x6f,
	0x72, 0x70, 0x6f, 0x72, 0x61, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x42, 0x82,
	0xd3, 0xe4, 0x93, 0x02, 0x33, 0x12, 0x31, 0x2f, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31,
	0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74,
	0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x7d,
	0x2f, 0x63, 0x6f, 0x72, 0x70, 0x6f, 0x72, 0x61, 0xda, 0x41, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e,
	0x74, 0x12, 0x9d, 0x01, 0x0a, 0x0c, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x43, 0x6f, 0x72, 0x70,
	0x75, 0x73, 0x12, 0x33, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x61, 0x69, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70,
	0x68, 0x61, 0x31, 0x2e, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x43, 0x6f, 0x72, 0x70, 0x75, 0x73,
	0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x16, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x45, 0x6d, 0x70, 0x74, 0x79, 0x22,
	0x40, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x33, 0x2a, 0x31, 0x2f, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68,
	0x61, 0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74,
	0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f,
	0x63, 0x6f, 0x72, 0x70, 0x6f, 0x72, 0x61, 0x2f, 0x2a, 0x7d, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d,
	0x65, 0x12, 0xe2, 0x01, 0x0a, 0x10, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x44, 0x61, 0x74, 0x61,
	0x53, 0x63, 0x68, 0x65, 0x6d, 0x61, 0x12, 0x37, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x61, 0x69, 0x2e, 0x76,
	0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x44, 0x61,
	0x74, 0x61, 0x53, 0x63, 0x68, 0x65, 0x6d, 0x61, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a,
	0x2a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76,
	0x69, 0x73, 0x69, 0x6f, 0x6e, 0x61, 0x69, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31,
	0x2e, 0x44, 0x61, 0x74, 0x61, 0x53, 0x63, 0x68, 0x65, 0x6d, 0x61, 0x22, 0x69, 0x82, 0xd3, 0xe4,
	0x93, 0x02, 0x4e, 0x22, 0x3f, 0x2f, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2f, 0x7b,
	0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f,
	0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x63, 0x6f,
	0x72, 0x70, 0x6f, 0x72, 0x61, 0x2f, 0x2a, 0x7d, 0x2f, 0x64, 0x61, 0x74, 0x61, 0x53, 0x63, 0x68,
	0x65, 0x6d, 0x61, 0x73, 0x3a, 0x0b, 0x64, 0x61, 0x74, 0x61, 0x5f, 0x73, 0x63, 0x68, 0x65, 0x6d,
	0x61, 0xda, 0x41, 0x12, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x2c, 0x64, 0x61, 0x74, 0x61, 0x5f,
	0x73, 0x63, 0x68, 0x65, 0x6d, 0x61, 0x12, 0xf3, 0x01, 0x0a, 0x10, 0x55, 0x70, 0x64, 0x61, 0x74,
	0x65, 0x44, 0x61, 0x74, 0x61, 0x53, 0x63, 0x68, 0x65, 0x6d, 0x61, 0x12, 0x37, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x73, 0x69, 0x6f,
	0x6e, 0x61, 0x69, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e, 0x55, 0x70, 0x64,
	0x61, 0x74, 0x65, 0x44, 0x61, 0x74, 0x61, 0x53, 0x63, 0x68, 0x65, 0x6d, 0x61, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x1a, 0x2a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x61, 0x69, 0x2e, 0x76, 0x31, 0x61,
	0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e, 0x44, 0x61, 0x74, 0x61, 0x53, 0x63, 0x68, 0x65, 0x6d, 0x61,
	0x22, 0x7a, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x5a, 0x32, 0x4b, 0x2f, 0x76, 0x31, 0x61, 0x6c, 0x70,
	0x68, 0x61, 0x31, 0x2f, 0x7b, 0x64, 0x61, 0x74, 0x61, 0x5f, 0x73, 0x63, 0x68, 0x65, 0x6d, 0x61,
	0x2e, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a,
	0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x63, 0x6f, 0x72,
	0x70, 0x6f, 0x72, 0x61, 0x2f, 0x2a, 0x2f, 0x64, 0x61, 0x74, 0x61, 0x53, 0x63, 0x68, 0x65, 0x6d,
	0x61, 0x73, 0x2f, 0x2a, 0x7d, 0x3a, 0x0b, 0x64, 0x61, 0x74, 0x61, 0x5f, 0x73, 0x63, 0x68, 0x65,
	0x6d, 0x61, 0xda, 0x41, 0x17, 0x64, 0x61, 0x74, 0x61, 0x5f, 0x73, 0x63, 0x68, 0x65, 0x6d, 0x61,
	0x2c, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x12, 0xc1, 0x01, 0x0a,
	0x0d, 0x47, 0x65, 0x74, 0x44, 0x61, 0x74, 0x61, 0x53, 0x63, 0x68, 0x65, 0x6d, 0x61, 0x12, 0x34,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69,
	0x73, 0x69, 0x6f, 0x6e, 0x61, 0x69, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e,
	0x47, 0x65, 0x74, 0x44, 0x61, 0x74, 0x61, 0x53, 0x63, 0x68, 0x65, 0x6d, 0x61, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x1a, 0x2a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x61, 0x69, 0x2e, 0x76, 0x31, 0x61,
	0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e, 0x44, 0x61, 0x74, 0x61, 0x53, 0x63, 0x68, 0x65, 0x6d, 0x61,
	0x22, 0x4e, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x41, 0x12, 0x3f, 0x2f, 0x76, 0x31, 0x61, 0x6c, 0x70,
	0x68, 0x61, 0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63,
	0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a,
	0x2f, 0x63, 0x6f, 0x72, 0x70, 0x6f, 0x72, 0x61, 0x2f, 0x2a, 0x2f, 0x64, 0x61, 0x74, 0x61, 0x53,
	0x63, 0x68, 0x65, 0x6d, 0x61, 0x73, 0x2f, 0x2a, 0x7d, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65,
	0x12, 0xb3, 0x01, 0x0a, 0x10, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x44, 0x61, 0x74, 0x61, 0x53,
	0x63, 0x68, 0x65, 0x6d, 0x61, 0x12, 0x37, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x61, 0x69, 0x2e, 0x76, 0x31,
	0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x44, 0x61, 0x74,
	0x61, 0x53, 0x63, 0x68, 0x65, 0x6d, 0x61, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x16,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66,
	0x2e, 0x45, 0x6d, 0x70, 0x74, 0x79, 0x22, 0x4e, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x41, 0x2a, 0x3f,
	0x2f, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d,
	0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x63, 0x6f, 0x72, 0x70, 0x6f, 0x72, 0x61, 0x2f, 0x2a,
	0x2f, 0x64, 0x61, 0x74, 0x61, 0x53, 0x63, 0x68, 0x65, 0x6d, 0x61, 0x73, 0x2f, 0x2a, 0x7d, 0xda,
	0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0xd4, 0x01, 0x0a, 0x0f, 0x4c, 0x69, 0x73, 0x74, 0x44,
	0x61, 0x74, 0x61, 0x53, 0x63, 0x68, 0x65, 0x6d, 0x61, 0x73, 0x12, 0x36, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e,
	0x61, 0x69, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74,
	0x44, 0x61, 0x74, 0x61, 0x53, 0x63, 0x68, 0x65, 0x6d, 0x61, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x1a, 0x37, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x61, 0x69, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70,
	0x68, 0x61, 0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x44, 0x61, 0x74, 0x61, 0x53, 0x63, 0x68, 0x65,
	0x6d, 0x61, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x50, 0x82, 0xd3, 0xe4,
	0x93, 0x02, 0x41, 0x12, 0x3f, 0x2f, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2f, 0x7b,
	0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f,
	0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x63, 0x6f,
	0x72, 0x70, 0x6f, 0x72, 0x61, 0x2f, 0x2a, 0x7d, 0x2f, 0x64, 0x61, 0x74, 0x61, 0x53, 0x63, 0x68,
	0x65, 0x6d, 0x61, 0x73, 0xda, 0x41, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0xf7, 0x01,
	0x0a, 0x10, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x41, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x12, 0x37, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x61, 0x69, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70,
	0x68, 0x61, 0x31, 0x2e, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x41, 0x6e, 0x6e, 0x6f, 0x74, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x2a, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x73, 0x69, 0x6f,
	0x6e, 0x61, 0x69, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e, 0x41, 0x6e, 0x6e,
	0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x7e, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x56, 0x22,
	0x48, 0x2f, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65,
	0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f,
	0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x63, 0x6f, 0x72, 0x70, 0x6f, 0x72,
	0x61, 0x2f, 0x2a, 0x2f, 0x61, 0x73, 0x73, 0x65, 0x74, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x61, 0x6e,
	0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x3a, 0x0a, 0x61, 0x6e, 0x6e, 0x6f, 0x74,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0xda, 0x41, 0x1f, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x2c, 0x61,
	0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2c, 0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x69, 0x64, 0x12, 0xca, 0x01, 0x0a, 0x0d, 0x47, 0x65, 0x74, 0x41,
	0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x34, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x61,
	0x69, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e, 0x47, 0x65, 0x74, 0x41, 0x6e,
	0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a,
	0x2a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76,
	0x69, 0x73, 0x69, 0x6f, 0x6e, 0x61, 0x69, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31,
	0x2e, 0x41, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x57, 0x82, 0xd3, 0xe4,
	0x93, 0x02, 0x4a, 0x12, 0x48, 0x2f, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2f, 0x7b,
	0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f,
	0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x63, 0x6f, 0x72, 0x70,
	0x6f, 0x72, 0x61, 0x2f, 0x2a, 0x2f, 0x61, 0x73, 0x73, 0x65, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x61,
	0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x7d, 0xda, 0x41, 0x04,
	0x6e, 0x61, 0x6d, 0x65, 0x12, 0xdd, 0x01, 0x0a, 0x0f, 0x4c, 0x69, 0x73, 0x74, 0x41, 0x6e, 0x6e,
	0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x36, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x61, 0x69,
	0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x41, 0x6e,
	0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x1a, 0x37, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x61, 0x69, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61,
	0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x41, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x59, 0x82, 0xd3, 0xe4, 0x93, 0x02,
	0x4a, 0x12, 0x48, 0x2f, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2f, 0x7b, 0x70, 0x61,
	0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f,
	0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x63, 0x6f, 0x72, 0x70,
	0x6f, 0x72, 0x61, 0x2f, 0x2a, 0x2f, 0x61, 0x73, 0x73, 0x65, 0x74, 0x73, 0x2f, 0x2a, 0x7d, 0x2f,
	0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0xda, 0x41, 0x06, 0x70, 0x61,
	0x72, 0x65, 0x6e, 0x74, 0x12, 0xfa, 0x01, 0x0a, 0x10, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x41,
	0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x37, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x61,
	0x69, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e, 0x55, 0x70, 0x64, 0x61, 0x74,
	0x65, 0x41, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x1a, 0x2a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x61, 0x69, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70,
	0x68, 0x61, 0x31, 0x2e, 0x41, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x80,
	0x01, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x61, 0x32, 0x53, 0x2f, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68,
	0x61, 0x31, 0x2f, 0x7b, 0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x6e,
	0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c,
	0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x63, 0x6f, 0x72, 0x70, 0x6f,
	0x72, 0x61, 0x2f, 0x2a, 0x2f, 0x61, 0x73, 0x73, 0x65, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x61, 0x6e,
	0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x7d, 0x3a, 0x0a, 0x61, 0x6e,
	0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0xda, 0x41, 0x16, 0x61, 0x6e, 0x6e, 0x6f, 0x74,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2c, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x6d, 0x61, 0x73,
	0x6b, 0x12, 0xbc, 0x01, 0x0a, 0x10, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x41, 0x6e, 0x6e, 0x6f,
	0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x37, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x61, 0x69, 0x2e, 0x76,
	0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x41, 0x6e,
	0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a,
	0x16, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75,
	0x66, 0x2e, 0x45, 0x6d, 0x70, 0x74, 0x79, 0x22, 0x57, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x4a, 0x2a,
	0x48, 0x2f, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65,
	0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x63, 0x6f, 0x72, 0x70, 0x6f, 0x72, 0x61, 0x2f,
	0x2a, 0x2f, 0x61, 0x73, 0x73, 0x65, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x61, 0x6e, 0x6e, 0x6f, 0x74,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x7d, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65,
	0x12, 0x7c, 0x0a, 0x0b, 0x49, 0x6e, 0x67, 0x65, 0x73, 0x74, 0x41, 0x73, 0x73, 0x65, 0x74, 0x12,
	0x32, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76,
	0x69, 0x73, 0x69, 0x6f, 0x6e, 0x61, 0x69, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31,
	0x2e, 0x49, 0x6e, 0x67, 0x65, 0x73, 0x74, 0x41, 0x73, 0x73, 0x65, 0x74, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x1a, 0x33, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x61, 0x69, 0x2e, 0x76, 0x31, 0x61, 0x6c,
	0x70, 0x68, 0x61, 0x31, 0x2e, 0x49, 0x6e, 0x67, 0x65, 0x73, 0x74, 0x41, 0x73, 0x73, 0x65, 0x74,
	0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x00, 0x28, 0x01, 0x30, 0x01, 0x12, 0xbc,
	0x01, 0x0a, 0x09, 0x43, 0x6c, 0x69, 0x70, 0x41, 0x73, 0x73, 0x65, 0x74, 0x12, 0x30, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x73, 0x69,
	0x6f, 0x6e, 0x61, 0x69, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e, 0x43, 0x6c,
	0x69, 0x70, 0x41, 0x73, 0x73, 0x65, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x31,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69,
	0x73, 0x69, 0x6f, 0x6e, 0x61, 0x69, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e,
	0x43, 0x6c, 0x69, 0x70, 0x41, 0x73, 0x73, 0x65, 0x74, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73,
	0x65, 0x22, 0x4a, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x44, 0x22, 0x3f, 0x2f, 0x76, 0x31, 0x61, 0x6c,
	0x70, 0x68, 0x61, 0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65,
	0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f,
	0x2a, 0x2f, 0x63, 0x6f, 0x72, 0x70, 0x6f, 0x72, 0x61, 0x2f, 0x2a, 0x2f, 0x61, 0x73, 0x73, 0x65,
	0x74, 0x73, 0x2f, 0x2a, 0x7d, 0x3a, 0x63, 0x6c, 0x69, 0x70, 0x3a, 0x01, 0x2a, 0x12, 0xd5, 0x01,
	0x0a, 0x0e, 0x47, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x65, 0x48, 0x6c, 0x73, 0x55, 0x72, 0x69,
	0x12, 0x35, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x61, 0x69, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61,
	0x31, 0x2e, 0x47, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x65, 0x48, 0x6c, 0x73, 0x55, 0x72, 0x69,
	0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x36, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x61, 0x69, 0x2e,
	0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e, 0x47, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74,
	0x65, 0x48, 0x6c, 0x73, 0x55, 0x72, 0x69, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22,
	0x54, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x4e, 0x22, 0x49, 0x2f, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68,
	0x61, 0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74,
	0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f,
	0x63, 0x6f, 0x72, 0x70, 0x6f, 0x72, 0x61, 0x2f, 0x2a, 0x2f, 0x61, 0x73, 0x73, 0x65, 0x74, 0x73,
	0x2f, 0x2a, 0x7d, 0x3a, 0x67, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x65, 0x48, 0x6c, 0x73, 0x55,
	0x72, 0x69, 0x3a, 0x01, 0x2a, 0x12, 0x80, 0x02, 0x0a, 0x12, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65,
	0x53, 0x65, 0x61, 0x72, 0x63, 0x68, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x39, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x73, 0x69,
	0x6f, 0x6e, 0x61, 0x69, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e, 0x43, 0x72,
	0x65, 0x61, 0x74, 0x65, 0x53, 0x65, 0x61, 0x72, 0x63, 0x68, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67,
	0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x2c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x61, 0x69, 0x2e,
	0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e, 0x53, 0x65, 0x61, 0x72, 0x63, 0x68, 0x43,
	0x6f, 0x6e, 0x66, 0x69, 0x67, 0x22, 0x80, 0x01, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x52, 0x22, 0x41,
	0x2f, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e,
	0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x63, 0x6f, 0x72, 0x70, 0x6f, 0x72, 0x61,
	0x2f, 0x2a, 0x7d, 0x2f, 0x73, 0x65, 0x61, 0x72, 0x63, 0x68, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67,
	0x73, 0x3a, 0x0d, 0x73, 0x65, 0x61, 0x72, 0x63, 0x68, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67,
	0xda, 0x41, 0x25, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x2c, 0x73, 0x65, 0x61, 0x72, 0x63, 0x68,
	0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2c, 0x73, 0x65, 0x61, 0x72, 0x63, 0x68, 0x5f, 0x63,
	0x6f, 0x6e, 0x66, 0x69, 0x67, 0x5f, 0x69, 0x64, 0x12, 0x82, 0x02, 0x0a, 0x12, 0x55, 0x70, 0x64,
	0x61, 0x74, 0x65, 0x53, 0x65, 0x61, 0x72, 0x63, 0x68, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12,
	0x39, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76,
	0x69, 0x73, 0x69, 0x6f, 0x6e, 0x61, 0x69, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31,
	0x2e, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x53, 0x65, 0x61, 0x72, 0x63, 0x68, 0x43, 0x6f, 0x6e,
	0x66, 0x69, 0x67, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x2c, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e,
	0x61, 0x69, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e, 0x53, 0x65, 0x61, 0x72,
	0x63, 0x68, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x22, 0x82, 0x01, 0x82, 0xd3, 0xe4, 0x93, 0x02,
	0x60, 0x32, 0x4f, 0x2f, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2f, 0x7b, 0x73, 0x65,
	0x61, 0x72, 0x63, 0x68, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x6e, 0x61, 0x6d, 0x65,
	0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x63, 0x6f, 0x72, 0x70, 0x6f, 0x72, 0x61, 0x2f,
	0x2a, 0x2f, 0x73, 0x65, 0x61, 0x72, 0x63, 0x68, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x73, 0x2f,
	0x2a, 0x7d, 0x3a, 0x0d, 0x73, 0x65, 0x61, 0x72, 0x63, 0x68, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69,
	0x67, 0xda, 0x41, 0x19, 0x73, 0x65, 0x61, 0x72, 0x63, 0x68, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69,
	0x67, 0x2c, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x12, 0xc9, 0x01,
	0x0a, 0x0f, 0x47, 0x65, 0x74, 0x53, 0x65, 0x61, 0x72, 0x63, 0x68, 0x43, 0x6f, 0x6e, 0x66, 0x69,
	0x67, 0x12, 0x36, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x61, 0x69, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68,
	0x61, 0x31, 0x2e, 0x47, 0x65, 0x74, 0x53, 0x65, 0x61, 0x72, 0x63, 0x68, 0x43, 0x6f, 0x6e, 0x66,
	0x69, 0x67, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x2c, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x61,
	0x69, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e, 0x53, 0x65, 0x61, 0x72, 0x63,
	0x68, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x22, 0x50, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x43, 0x12,
	0x41, 0x2f, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65,
	0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x63, 0x6f, 0x72, 0x70, 0x6f, 0x72, 0x61, 0x2f,
	0x2a, 0x2f, 0x73, 0x65, 0x61, 0x72, 0x63, 0x68, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x73, 0x2f,
	0x2a, 0x7d, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0xb9, 0x01, 0x0a, 0x12, 0x44, 0x65,
	0x6c, 0x65, 0x74, 0x65, 0x53, 0x65, 0x61, 0x72, 0x63, 0x68, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67,
	0x12, 0x39, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x61, 0x69, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61,
	0x31, 0x2e, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x53, 0x65, 0x61, 0x72, 0x63, 0x68, 0x43, 0x6f,
	0x6e, 0x66, 0x69, 0x67, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x16, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x45, 0x6d,
	0x70, 0x74, 0x79, 0x22, 0x50, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x43, 0x2a, 0x41, 0x2f, 0x76, 0x31,
	0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f,
	0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x73, 0x2f, 0x2a, 0x2f, 0x63, 0x6f, 0x72, 0x70, 0x6f, 0x72, 0x61, 0x2f, 0x2a, 0x2f, 0x73, 0x65,
	0x61, 0x72, 0x63, 0x68, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x73, 0x2f, 0x2a, 0x7d, 0xda, 0x41,
	0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0xdc, 0x01, 0x0a, 0x11, 0x4c, 0x69, 0x73, 0x74, 0x53, 0x65,
	0x61, 0x72, 0x63, 0x68, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x73, 0x12, 0x38, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x73, 0x69, 0x6f,
	0x6e, 0x61, 0x69, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e, 0x4c, 0x69, 0x73,
	0x74, 0x53, 0x65, 0x61, 0x72, 0x63, 0x68, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x73, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x39, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x61, 0x69, 0x2e, 0x76, 0x31,
	0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x53, 0x65, 0x61, 0x72, 0x63,
	0x68, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65,
	0x22, 0x52, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x43, 0x12, 0x41, 0x2f, 0x76, 0x31, 0x61, 0x6c, 0x70,
	0x68, 0x61, 0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a,
	0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73,
	0x2f, 0x2a, 0x2f, 0x63, 0x6f, 0x72, 0x70, 0x6f, 0x72, 0x61, 0x2f, 0x2a, 0x7d, 0x2f, 0x73, 0x65,
	0x61, 0x72, 0x63, 0x68, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x73, 0xda, 0x41, 0x06, 0x70, 0x61,
	0x72, 0x65, 0x6e, 0x74, 0x12, 0xc6, 0x01, 0x0a, 0x0c, 0x53, 0x65, 0x61, 0x72, 0x63, 0x68, 0x41,
	0x73, 0x73, 0x65, 0x74, 0x73, 0x12, 0x33, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x61, 0x69, 0x2e, 0x76, 0x31,
	0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e, 0x53, 0x65, 0x61, 0x72, 0x63, 0x68, 0x41, 0x73, 0x73,
	0x65, 0x74, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x34, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e,
	0x61, 0x69, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e, 0x53, 0x65, 0x61, 0x72,
	0x63, 0x68, 0x41, 0x73, 0x73, 0x65, 0x74, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65,
	0x22, 0x4b, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x45, 0x22, 0x40, 0x2f, 0x76, 0x31, 0x61, 0x6c, 0x70,
	0x68, 0x61, 0x31, 0x2f, 0x7b, 0x63, 0x6f, 0x72, 0x70, 0x75, 0x73, 0x3d, 0x70, 0x72, 0x6f, 0x6a,
	0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73,
	0x2f, 0x2a, 0x2f, 0x63, 0x6f, 0x72, 0x70, 0x6f, 0x72, 0x61, 0x2f, 0x2a, 0x7d, 0x3a, 0x73, 0x65,
	0x61, 0x72, 0x63, 0x68, 0x41, 0x73, 0x73, 0x65, 0x74, 0x73, 0x3a, 0x01, 0x2a, 0x1a, 0x4b, 0xca,
	0x41, 0x17, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x61, 0x69, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0xd2, 0x41, 0x2e, 0x68, 0x74, 0x74, 0x70,
	0x73, 0x3a, 0x2f, 0x2f, 0x77, 0x77, 0x77, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70,
	0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x61, 0x75, 0x74, 0x68, 0x2f, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2d, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x42, 0xe4, 0x01, 0x0a, 0x22, 0x63,
	0x6f, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x61, 0x69, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61,
	0x31, 0x42, 0x0e, 0x57, 0x61, 0x72, 0x65, 0x68, 0x6f, 0x75, 0x73, 0x65, 0x50, 0x72, 0x6f, 0x74,
	0x6f, 0x50, 0x01, 0x5a, 0x46, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x67, 0x6f, 0x6c, 0x61,
	0x6e, 0x67, 0x2e, 0x6f, 0x72, 0x67, 0x2f, 0x67, 0x65, 0x6e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x2f,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2f, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x61, 0x69, 0x2f, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68,
	0x61, 0x31, 0x3b, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x61, 0x69, 0xaa, 0x02, 0x1e, 0x47, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x56, 0x69, 0x73, 0x69, 0x6f,
	0x6e, 0x41, 0x49, 0x2e, 0x56, 0x31, 0x41, 0x6c, 0x70, 0x68, 0x61, 0x31, 0xca, 0x02, 0x1e, 0x47,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x5c, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x5c, 0x56, 0x69, 0x73, 0x69,
	0x6f, 0x6e, 0x41, 0x49, 0x5c, 0x56, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0xea, 0x02, 0x21,
	0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x3a, 0x3a, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x3a, 0x3a, 0x56,
	0x69, 0x73, 0x69, 0x6f, 0x6e, 0x41, 0x49, 0x3a, 0x3a, 0x56, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61,
	0x31, 0x62, 0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_google_cloud_visionai_v1alpha1_warehouse_proto_rawDescOnce sync.Once
	file_google_cloud_visionai_v1alpha1_warehouse_proto_rawDescData = file_google_cloud_visionai_v1alpha1_warehouse_proto_rawDesc
)

func file_google_cloud_visionai_v1alpha1_warehouse_proto_rawDescGZIP() []byte {
	file_google_cloud_visionai_v1alpha1_warehouse_proto_rawDescOnce.Do(func() {
		file_google_cloud_visionai_v1alpha1_warehouse_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_cloud_visionai_v1alpha1_warehouse_proto_rawDescData)
	})
	return file_google_cloud_visionai_v1alpha1_warehouse_proto_rawDescData
}

var file_google_cloud_visionai_v1alpha1_warehouse_proto_enumTypes = make([]protoimpl.EnumInfo, 7)
var file_google_cloud_visionai_v1alpha1_warehouse_proto_msgTypes = make([]protoimpl.MessageInfo, 82)
var file_google_cloud_visionai_v1alpha1_warehouse_proto_goTypes = []interface{}{
	(FacetBucketType)(0),                                     // 0: google.cloud.visionai.v1alpha1.FacetBucketType
	(DataSchemaDetails_DataType)(0),                          // 1: google.cloud.visionai.v1alpha1.DataSchemaDetails.DataType
	(DataSchemaDetails_Granularity)(0),                       // 2: google.cloud.visionai.v1alpha1.DataSchemaDetails.Granularity
	(DataSchemaDetails_SearchStrategy_SearchStrategyType)(0), // 3: google.cloud.visionai.v1alpha1.DataSchemaDetails.SearchStrategy.SearchStrategyType
	(FacetProperty_DateTimeBucketSpec_Granularity)(0),        // 4: google.cloud.visionai.v1alpha1.FacetProperty.DateTimeBucketSpec.Granularity
	(IngestAssetRequest_Config_VideoType_ContainerFormat)(0), // 5: google.cloud.visionai.v1alpha1.IngestAssetRequest.Config.VideoType.ContainerFormat
	(SchemaKeySortingStrategy_Option_AggregateMethod)(0),     // 6: google.cloud.visionai.v1alpha1.SchemaKeySortingStrategy.Option.AggregateMethod
	(*CreateAssetRequest)(nil),                               // 7: google.cloud.visionai.v1alpha1.CreateAssetRequest
	(*GetAssetRequest)(nil),                                  // 8: google.cloud.visionai.v1alpha1.GetAssetRequest
	(*ListAssetsRequest)(nil),                                // 9: google.cloud.visionai.v1alpha1.ListAssetsRequest
	(*ListAssetsResponse)(nil),                               // 10: google.cloud.visionai.v1alpha1.ListAssetsResponse
	(*UpdateAssetRequest)(nil),                               // 11: google.cloud.visionai.v1alpha1.UpdateAssetRequest
	(*DeleteAssetRequest)(nil),                               // 12: google.cloud.visionai.v1alpha1.DeleteAssetRequest
	(*Asset)(nil),                                            // 13: google.cloud.visionai.v1alpha1.Asset
	(*CreateCorpusRequest)(nil),                              // 14: google.cloud.visionai.v1alpha1.CreateCorpusRequest
	(*Corpus)(nil),                                           // 15: google.cloud.visionai.v1alpha1.Corpus
	(*GetCorpusRequest)(nil),                                 // 16: google.cloud.visionai.v1alpha1.GetCorpusRequest
	(*UpdateCorpusRequest)(nil),                              // 17: google.cloud.visionai.v1alpha1.UpdateCorpusRequest
	(*ListCorporaRequest)(nil),                               // 18: google.cloud.visionai.v1alpha1.ListCorporaRequest
	(*ListCorporaResponse)(nil),                              // 19: google.cloud.visionai.v1alpha1.ListCorporaResponse
	(*DeleteCorpusRequest)(nil),                              // 20: google.cloud.visionai.v1alpha1.DeleteCorpusRequest
	(*CreateDataSchemaRequest)(nil),                          // 21: google.cloud.visionai.v1alpha1.CreateDataSchemaRequest
	(*DataSchema)(nil),                                       // 22: google.cloud.visionai.v1alpha1.DataSchema
	(*DataSchemaDetails)(nil),                                // 23: google.cloud.visionai.v1alpha1.DataSchemaDetails
	(*UpdateDataSchemaRequest)(nil),                          // 24: google.cloud.visionai.v1alpha1.UpdateDataSchemaRequest
	(*GetDataSchemaRequest)(nil),                             // 25: google.cloud.visionai.v1alpha1.GetDataSchemaRequest
	(*DeleteDataSchemaRequest)(nil),                          // 26: google.cloud.visionai.v1alpha1.DeleteDataSchemaRequest
	(*ListDataSchemasRequest)(nil),                           // 27: google.cloud.visionai.v1alpha1.ListDataSchemasRequest
	(*ListDataSchemasResponse)(nil),                          // 28: google.cloud.visionai.v1alpha1.ListDataSchemasResponse
	(*CreateAnnotationRequest)(nil),                          // 29: google.cloud.visionai.v1alpha1.CreateAnnotationRequest
	(*Annotation)(nil),                                       // 30: google.cloud.visionai.v1alpha1.Annotation
	(*UserSpecifiedAnnotation)(nil),                          // 31: google.cloud.visionai.v1alpha1.UserSpecifiedAnnotation
	(*GeoCoordinate)(nil),                                    // 32: google.cloud.visionai.v1alpha1.GeoCoordinate
	(*AnnotationValue)(nil),                                  // 33: google.cloud.visionai.v1alpha1.AnnotationValue
	(*ListAnnotationsRequest)(nil),                           // 34: google.cloud.visionai.v1alpha1.ListAnnotationsRequest
	(*ListAnnotationsResponse)(nil),                          // 35: google.cloud.visionai.v1alpha1.ListAnnotationsResponse
	(*GetAnnotationRequest)(nil),                             // 36: google.cloud.visionai.v1alpha1.GetAnnotationRequest
	(*UpdateAnnotationRequest)(nil),                          // 37: google.cloud.visionai.v1alpha1.UpdateAnnotationRequest
	(*DeleteAnnotationRequest)(nil),                          // 38: google.cloud.visionai.v1alpha1.DeleteAnnotationRequest
	(*CreateSearchConfigRequest)(nil),                        // 39: google.cloud.visionai.v1alpha1.CreateSearchConfigRequest
	(*UpdateSearchConfigRequest)(nil),                        // 40: google.cloud.visionai.v1alpha1.UpdateSearchConfigRequest
	(*GetSearchConfigRequest)(nil),                           // 41: google.cloud.visionai.v1alpha1.GetSearchConfigRequest
	(*DeleteSearchConfigRequest)(nil),                        // 42: google.cloud.visionai.v1alpha1.DeleteSearchConfigRequest
	(*ListSearchConfigsRequest)(nil),                         // 43: google.cloud.visionai.v1alpha1.ListSearchConfigsRequest
	(*ListSearchConfigsResponse)(nil),                        // 44: google.cloud.visionai.v1alpha1.ListSearchConfigsResponse
	(*SearchConfig)(nil),                                     // 45: google.cloud.visionai.v1alpha1.SearchConfig
	(*FacetProperty)(nil),                                    // 46: google.cloud.visionai.v1alpha1.FacetProperty
	(*SearchCriteriaProperty)(nil),                           // 47: google.cloud.visionai.v1alpha1.SearchCriteriaProperty
	(*FacetValue)(nil),                                       // 48: google.cloud.visionai.v1alpha1.FacetValue
	(*FacetBucket)(nil),                                      // 49: google.cloud.visionai.v1alpha1.FacetBucket
	(*FacetGroup)(nil),                                       // 50: google.cloud.visionai.v1alpha1.FacetGroup
	(*IngestAssetRequest)(nil),                               // 51: google.cloud.visionai.v1alpha1.IngestAssetRequest
	(*IngestAssetResponse)(nil),                              // 52: google.cloud.visionai.v1alpha1.IngestAssetResponse
	(*ClipAssetRequest)(nil),                                 // 53: google.cloud.visionai.v1alpha1.ClipAssetRequest
	(*ClipAssetResponse)(nil),                                // 54: google.cloud.visionai.v1alpha1.ClipAssetResponse
	(*GenerateHlsUriRequest)(nil),                            // 55: google.cloud.visionai.v1alpha1.GenerateHlsUriRequest
	(*GenerateHlsUriResponse)(nil),                           // 56: google.cloud.visionai.v1alpha1.GenerateHlsUriResponse
	(*SearchAssetsRequest)(nil),                              // 57: google.cloud.visionai.v1alpha1.SearchAssetsRequest
	(*SchemaKeySortingStrategy)(nil),                         // 58: google.cloud.visionai.v1alpha1.SchemaKeySortingStrategy
	(*AnnotationMatchingResult)(nil),                         // 59: google.cloud.visionai.v1alpha1.AnnotationMatchingResult
	(*SearchResultItem)(nil),                                 // 60: google.cloud.visionai.v1alpha1.SearchResultItem
	(*SearchAssetsResponse)(nil),                             // 61: google.cloud.visionai.v1alpha1.SearchAssetsResponse
	(*IntRange)(nil),                                         // 62: google.cloud.visionai.v1alpha1.IntRange
	(*FloatRange)(nil),                                       // 63: google.cloud.visionai.v1alpha1.FloatRange
	(*StringArray)(nil),                                      // 64: google.cloud.visionai.v1alpha1.StringArray
	(*IntRangeArray)(nil),                                    // 65: google.cloud.visionai.v1alpha1.IntRangeArray
	(*FloatRangeArray)(nil),                                  // 66: google.cloud.visionai.v1alpha1.FloatRangeArray
	(*DateTimeRange)(nil),                                    // 67: google.cloud.visionai.v1alpha1.DateTimeRange
	(*DateTimeRangeArray)(nil),                               // 68: google.cloud.visionai.v1alpha1.DateTimeRangeArray
	(*CircleArea)(nil),                                       // 69: google.cloud.visionai.v1alpha1.CircleArea
	(*GeoLocationArray)(nil),                                 // 70: google.cloud.visionai.v1alpha1.GeoLocationArray
	(*BoolValue)(nil),                                        // 71: google.cloud.visionai.v1alpha1.BoolValue
	(*Criteria)(nil),                                         // 72: google.cloud.visionai.v1alpha1.Criteria
	(*Partition)(nil),                                        // 73: google.cloud.visionai.v1alpha1.Partition
	(*DeleteAssetMetadata)(nil),                              // 74: google.cloud.visionai.v1alpha1.DeleteAssetMetadata
	(*CreateCorpusMetadata)(nil),                             // 75: google.cloud.visionai.v1alpha1.CreateCorpusMetadata
	(*DataSchemaDetails_ProtoAnyConfig)(nil),                 // 76: google.cloud.visionai.v1alpha1.DataSchemaDetails.ProtoAnyConfig
	(*DataSchemaDetails_SearchStrategy)(nil),                 // 77: google.cloud.visionai.v1alpha1.DataSchemaDetails.SearchStrategy
	(*FacetProperty_FixedRangeBucketSpec)(nil),               // 78: google.cloud.visionai.v1alpha1.FacetProperty.FixedRangeBucketSpec
	(*FacetProperty_CustomRangeBucketSpec)(nil),              // 79: google.cloud.visionai.v1alpha1.FacetProperty.CustomRangeBucketSpec
	(*FacetProperty_DateTimeBucketSpec)(nil),                 // 80: google.cloud.visionai.v1alpha1.FacetProperty.DateTimeBucketSpec
	(*FacetBucket_Range)(nil),                                // 81: google.cloud.visionai.v1alpha1.FacetBucket.Range
	(*IngestAssetRequest_Config)(nil),                        // 82: google.cloud.visionai.v1alpha1.IngestAssetRequest.Config
	(*IngestAssetRequest_TimeIndexedData)(nil),               // 83: google.cloud.visionai.v1alpha1.IngestAssetRequest.TimeIndexedData
	(*IngestAssetRequest_Config_VideoType)(nil),              // 84: google.cloud.visionai.v1alpha1.IngestAssetRequest.Config.VideoType
	(*ClipAssetResponse_TimeIndexedUri)(nil),                 // 85: google.cloud.visionai.v1alpha1.ClipAssetResponse.TimeIndexedUri
	(*SchemaKeySortingStrategy_Option)(nil),                  // 86: google.cloud.visionai.v1alpha1.SchemaKeySortingStrategy.Option
	(*Partition_TemporalPartition)(nil),                      // 87: google.cloud.visionai.v1alpha1.Partition.TemporalPartition
	(*Partition_SpatialPartition)(nil),                       // 88: google.cloud.visionai.v1alpha1.Partition.SpatialPartition
	(*fieldmaskpb.FieldMask)(nil),                            // 89: google.protobuf.FieldMask
	(*durationpb.Duration)(nil),                              // 90: google.protobuf.Duration
	(*anypb.Any)(nil),                                        // 91: google.protobuf.Any
	(*structpb.Struct)(nil),                                  // 92: google.protobuf.Struct
	(*datetime.DateTime)(nil),                                // 93: google.type.DateTime
	(*status.Status)(nil),                                    // 94: google.rpc.Status
	(*timestamppb.Timestamp)(nil),                            // 95: google.protobuf.Timestamp
	(*longrunning.Operation)(nil),                            // 96: google.longrunning.Operation
	(*emptypb.Empty)(nil),                                    // 97: google.protobuf.Empty
}
var file_google_cloud_visionai_v1alpha1_warehouse_proto_depIdxs = []int32{
	13,  // 0: google.cloud.visionai.v1alpha1.CreateAssetRequest.asset:type_name -> google.cloud.visionai.v1alpha1.Asset
	13,  // 1: google.cloud.visionai.v1alpha1.ListAssetsResponse.assets:type_name -> google.cloud.visionai.v1alpha1.Asset
	13,  // 2: google.cloud.visionai.v1alpha1.UpdateAssetRequest.asset:type_name -> google.cloud.visionai.v1alpha1.Asset
	89,  // 3: google.cloud.visionai.v1alpha1.UpdateAssetRequest.update_mask:type_name -> google.protobuf.FieldMask
	90,  // 4: google.cloud.visionai.v1alpha1.Asset.ttl:type_name -> google.protobuf.Duration
	15,  // 5: google.cloud.visionai.v1alpha1.CreateCorpusRequest.corpus:type_name -> google.cloud.visionai.v1alpha1.Corpus
	90,  // 6: google.cloud.visionai.v1alpha1.Corpus.default_ttl:type_name -> google.protobuf.Duration
	15,  // 7: google.cloud.visionai.v1alpha1.UpdateCorpusRequest.corpus:type_name -> google.cloud.visionai.v1alpha1.Corpus
	89,  // 8: google.cloud.visionai.v1alpha1.UpdateCorpusRequest.update_mask:type_name -> google.protobuf.FieldMask
	15,  // 9: google.cloud.visionai.v1alpha1.ListCorporaResponse.corpora:type_name -> google.cloud.visionai.v1alpha1.Corpus
	22,  // 10: google.cloud.visionai.v1alpha1.CreateDataSchemaRequest.data_schema:type_name -> google.cloud.visionai.v1alpha1.DataSchema
	23,  // 11: google.cloud.visionai.v1alpha1.DataSchema.schema_details:type_name -> google.cloud.visionai.v1alpha1.DataSchemaDetails
	1,   // 12: google.cloud.visionai.v1alpha1.DataSchemaDetails.type:type_name -> google.cloud.visionai.v1alpha1.DataSchemaDetails.DataType
	76,  // 13: google.cloud.visionai.v1alpha1.DataSchemaDetails.proto_any_config:type_name -> google.cloud.visionai.v1alpha1.DataSchemaDetails.ProtoAnyConfig
	2,   // 14: google.cloud.visionai.v1alpha1.DataSchemaDetails.granularity:type_name -> google.cloud.visionai.v1alpha1.DataSchemaDetails.Granularity
	77,  // 15: google.cloud.visionai.v1alpha1.DataSchemaDetails.search_strategy:type_name -> google.cloud.visionai.v1alpha1.DataSchemaDetails.SearchStrategy
	22,  // 16: google.cloud.visionai.v1alpha1.UpdateDataSchemaRequest.data_schema:type_name -> google.cloud.visionai.v1alpha1.DataSchema
	89,  // 17: google.cloud.visionai.v1alpha1.UpdateDataSchemaRequest.update_mask:type_name -> google.protobuf.FieldMask
	22,  // 18: google.cloud.visionai.v1alpha1.ListDataSchemasResponse.data_schemas:type_name -> google.cloud.visionai.v1alpha1.DataSchema
	30,  // 19: google.cloud.visionai.v1alpha1.CreateAnnotationRequest.annotation:type_name -> google.cloud.visionai.v1alpha1.Annotation
	31,  // 20: google.cloud.visionai.v1alpha1.Annotation.user_specified_annotation:type_name -> google.cloud.visionai.v1alpha1.UserSpecifiedAnnotation
	33,  // 21: google.cloud.visionai.v1alpha1.UserSpecifiedAnnotation.value:type_name -> google.cloud.visionai.v1alpha1.AnnotationValue
	73,  // 22: google.cloud.visionai.v1alpha1.UserSpecifiedAnnotation.partition:type_name -> google.cloud.visionai.v1alpha1.Partition
	32,  // 23: google.cloud.visionai.v1alpha1.AnnotationValue.geo_coordinate:type_name -> google.cloud.visionai.v1alpha1.GeoCoordinate
	91,  // 24: google.cloud.visionai.v1alpha1.AnnotationValue.proto_any_value:type_name -> google.protobuf.Any
	92,  // 25: google.cloud.visionai.v1alpha1.AnnotationValue.customized_struct_data_value:type_name -> google.protobuf.Struct
	30,  // 26: google.cloud.visionai.v1alpha1.ListAnnotationsResponse.annotations:type_name -> google.cloud.visionai.v1alpha1.Annotation
	30,  // 27: google.cloud.visionai.v1alpha1.UpdateAnnotationRequest.annotation:type_name -> google.cloud.visionai.v1alpha1.Annotation
	89,  // 28: google.cloud.visionai.v1alpha1.UpdateAnnotationRequest.update_mask:type_name -> google.protobuf.FieldMask
	45,  // 29: google.cloud.visionai.v1alpha1.CreateSearchConfigRequest.search_config:type_name -> google.cloud.visionai.v1alpha1.SearchConfig
	45,  // 30: google.cloud.visionai.v1alpha1.UpdateSearchConfigRequest.search_config:type_name -> google.cloud.visionai.v1alpha1.SearchConfig
	89,  // 31: google.cloud.visionai.v1alpha1.UpdateSearchConfigRequest.update_mask:type_name -> google.protobuf.FieldMask
	45,  // 32: google.cloud.visionai.v1alpha1.ListSearchConfigsResponse.search_configs:type_name -> google.cloud.visionai.v1alpha1.SearchConfig
	46,  // 33: google.cloud.visionai.v1alpha1.SearchConfig.facet_property:type_name -> google.cloud.visionai.v1alpha1.FacetProperty
	47,  // 34: google.cloud.visionai.v1alpha1.SearchConfig.search_criteria_property:type_name -> google.cloud.visionai.v1alpha1.SearchCriteriaProperty
	78,  // 35: google.cloud.visionai.v1alpha1.FacetProperty.fixed_range_bucket_spec:type_name -> google.cloud.visionai.v1alpha1.FacetProperty.FixedRangeBucketSpec
	79,  // 36: google.cloud.visionai.v1alpha1.FacetProperty.custom_range_bucket_spec:type_name -> google.cloud.visionai.v1alpha1.FacetProperty.CustomRangeBucketSpec
	80,  // 37: google.cloud.visionai.v1alpha1.FacetProperty.datetime_bucket_spec:type_name -> google.cloud.visionai.v1alpha1.FacetProperty.DateTimeBucketSpec
	0,   // 38: google.cloud.visionai.v1alpha1.FacetProperty.bucket_type:type_name -> google.cloud.visionai.v1alpha1.FacetBucketType
	93,  // 39: google.cloud.visionai.v1alpha1.FacetValue.datetime_value:type_name -> google.type.DateTime
	48,  // 40: google.cloud.visionai.v1alpha1.FacetBucket.value:type_name -> google.cloud.visionai.v1alpha1.FacetValue
	81,  // 41: google.cloud.visionai.v1alpha1.FacetBucket.range:type_name -> google.cloud.visionai.v1alpha1.FacetBucket.Range
	49,  // 42: google.cloud.visionai.v1alpha1.FacetGroup.buckets:type_name -> google.cloud.visionai.v1alpha1.FacetBucket
	0,   // 43: google.cloud.visionai.v1alpha1.FacetGroup.bucket_type:type_name -> google.cloud.visionai.v1alpha1.FacetBucketType
	82,  // 44: google.cloud.visionai.v1alpha1.IngestAssetRequest.config:type_name -> google.cloud.visionai.v1alpha1.IngestAssetRequest.Config
	83,  // 45: google.cloud.visionai.v1alpha1.IngestAssetRequest.time_indexed_data:type_name -> google.cloud.visionai.v1alpha1.IngestAssetRequest.TimeIndexedData
	87,  // 46: google.cloud.visionai.v1alpha1.IngestAssetResponse.successfully_ingested_partition:type_name -> google.cloud.visionai.v1alpha1.Partition.TemporalPartition
	87,  // 47: google.cloud.visionai.v1alpha1.ClipAssetRequest.temporal_partition:type_name -> google.cloud.visionai.v1alpha1.Partition.TemporalPartition
	85,  // 48: google.cloud.visionai.v1alpha1.ClipAssetResponse.time_indexed_uris:type_name -> google.cloud.visionai.v1alpha1.ClipAssetResponse.TimeIndexedUri
	87,  // 49: google.cloud.visionai.v1alpha1.GenerateHlsUriRequest.temporal_partitions:type_name -> google.cloud.visionai.v1alpha1.Partition.TemporalPartition
	87,  // 50: google.cloud.visionai.v1alpha1.GenerateHlsUriResponse.temporal_partitions:type_name -> google.cloud.visionai.v1alpha1.Partition.TemporalPartition
	58,  // 51: google.cloud.visionai.v1alpha1.SearchAssetsRequest.schema_key_sorting_strategy:type_name -> google.cloud.visionai.v1alpha1.SchemaKeySortingStrategy
	68,  // 52: google.cloud.visionai.v1alpha1.SearchAssetsRequest.content_time_ranges:type_name -> google.cloud.visionai.v1alpha1.DateTimeRangeArray
	72,  // 53: google.cloud.visionai.v1alpha1.SearchAssetsRequest.criteria:type_name -> google.cloud.visionai.v1alpha1.Criteria
	50,  // 54: google.cloud.visionai.v1alpha1.SearchAssetsRequest.facet_selections:type_name -> google.cloud.visionai.v1alpha1.FacetGroup
	86,  // 55: google.cloud.visionai.v1alpha1.SchemaKeySortingStrategy.options:type_name -> google.cloud.visionai.v1alpha1.SchemaKeySortingStrategy.Option
	72,  // 56: google.cloud.visionai.v1alpha1.AnnotationMatchingResult.criteria:type_name -> google.cloud.visionai.v1alpha1.Criteria
	30,  // 57: google.cloud.visionai.v1alpha1.AnnotationMatchingResult.matched_annotations:type_name -> google.cloud.visionai.v1alpha1.Annotation
	94,  // 58: google.cloud.visionai.v1alpha1.AnnotationMatchingResult.status:type_name -> google.rpc.Status
	87,  // 59: google.cloud.visionai.v1alpha1.SearchResultItem.segments:type_name -> google.cloud.visionai.v1alpha1.Partition.TemporalPartition
	87,  // 60: google.cloud.visionai.v1alpha1.SearchResultItem.segment:type_name -> google.cloud.visionai.v1alpha1.Partition.TemporalPartition
	30,  // 61: google.cloud.visionai.v1alpha1.SearchResultItem.requested_annotations:type_name -> google.cloud.visionai.v1alpha1.Annotation
	59,  // 62: google.cloud.visionai.v1alpha1.SearchResultItem.annotation_matching_results:type_name -> google.cloud.visionai.v1alpha1.AnnotationMatchingResult
	60,  // 63: google.cloud.visionai.v1alpha1.SearchAssetsResponse.search_result_items:type_name -> google.cloud.visionai.v1alpha1.SearchResultItem
	50,  // 64: google.cloud.visionai.v1alpha1.SearchAssetsResponse.facet_results:type_name -> google.cloud.visionai.v1alpha1.FacetGroup
	62,  // 65: google.cloud.visionai.v1alpha1.IntRangeArray.int_ranges:type_name -> google.cloud.visionai.v1alpha1.IntRange
	63,  // 66: google.cloud.visionai.v1alpha1.FloatRangeArray.float_ranges:type_name -> google.cloud.visionai.v1alpha1.FloatRange
	93,  // 67: google.cloud.visionai.v1alpha1.DateTimeRange.start:type_name -> google.type.DateTime
	93,  // 68: google.cloud.visionai.v1alpha1.DateTimeRange.end:type_name -> google.type.DateTime
	67,  // 69: google.cloud.visionai.v1alpha1.DateTimeRangeArray.date_time_ranges:type_name -> google.cloud.visionai.v1alpha1.DateTimeRange
	69,  // 70: google.cloud.visionai.v1alpha1.GeoLocationArray.circle_areas:type_name -> google.cloud.visionai.v1alpha1.CircleArea
	64,  // 71: google.cloud.visionai.v1alpha1.Criteria.text_array:type_name -> google.cloud.visionai.v1alpha1.StringArray
	65,  // 72: google.cloud.visionai.v1alpha1.Criteria.int_range_array:type_name -> google.cloud.visionai.v1alpha1.IntRangeArray
	66,  // 73: google.cloud.visionai.v1alpha1.Criteria.float_range_array:type_name -> google.cloud.visionai.v1alpha1.FloatRangeArray
	68,  // 74: google.cloud.visionai.v1alpha1.Criteria.date_time_range_array:type_name -> google.cloud.visionai.v1alpha1.DateTimeRangeArray
	70,  // 75: google.cloud.visionai.v1alpha1.Criteria.geo_location_array:type_name -> google.cloud.visionai.v1alpha1.GeoLocationArray
	71,  // 76: google.cloud.visionai.v1alpha1.Criteria.bool_value:type_name -> google.cloud.visionai.v1alpha1.BoolValue
	87,  // 77: google.cloud.visionai.v1alpha1.Partition.temporal_partition:type_name -> google.cloud.visionai.v1alpha1.Partition.TemporalPartition
	88,  // 78: google.cloud.visionai.v1alpha1.Partition.spatial_partition:type_name -> google.cloud.visionai.v1alpha1.Partition.SpatialPartition
	3,   // 79: google.cloud.visionai.v1alpha1.DataSchemaDetails.SearchStrategy.search_strategy_type:type_name -> google.cloud.visionai.v1alpha1.DataSchemaDetails.SearchStrategy.SearchStrategyType
	48,  // 80: google.cloud.visionai.v1alpha1.FacetProperty.FixedRangeBucketSpec.bucket_start:type_name -> google.cloud.visionai.v1alpha1.FacetValue
	48,  // 81: google.cloud.visionai.v1alpha1.FacetProperty.FixedRangeBucketSpec.bucket_granularity:type_name -> google.cloud.visionai.v1alpha1.FacetValue
	48,  // 82: google.cloud.visionai.v1alpha1.FacetProperty.CustomRangeBucketSpec.endpoints:type_name -> google.cloud.visionai.v1alpha1.FacetValue
	4,   // 83: google.cloud.visionai.v1alpha1.FacetProperty.DateTimeBucketSpec.granularity:type_name -> google.cloud.visionai.v1alpha1.FacetProperty.DateTimeBucketSpec.Granularity
	48,  // 84: google.cloud.visionai.v1alpha1.FacetBucket.Range.start:type_name -> google.cloud.visionai.v1alpha1.FacetValue
	48,  // 85: google.cloud.visionai.v1alpha1.FacetBucket.Range.end:type_name -> google.cloud.visionai.v1alpha1.FacetValue
	84,  // 86: google.cloud.visionai.v1alpha1.IngestAssetRequest.Config.video_type:type_name -> google.cloud.visionai.v1alpha1.IngestAssetRequest.Config.VideoType
	87,  // 87: google.cloud.visionai.v1alpha1.IngestAssetRequest.TimeIndexedData.temporal_partition:type_name -> google.cloud.visionai.v1alpha1.Partition.TemporalPartition
	5,   // 88: google.cloud.visionai.v1alpha1.IngestAssetRequest.Config.VideoType.container_format:type_name -> google.cloud.visionai.v1alpha1.IngestAssetRequest.Config.VideoType.ContainerFormat
	87,  // 89: google.cloud.visionai.v1alpha1.ClipAssetResponse.TimeIndexedUri.temporal_partition:type_name -> google.cloud.visionai.v1alpha1.Partition.TemporalPartition
	6,   // 90: google.cloud.visionai.v1alpha1.SchemaKeySortingStrategy.Option.aggregate_method:type_name -> google.cloud.visionai.v1alpha1.SchemaKeySortingStrategy.Option.AggregateMethod
	95,  // 91: google.cloud.visionai.v1alpha1.Partition.TemporalPartition.start_time:type_name -> google.protobuf.Timestamp
	95,  // 92: google.cloud.visionai.v1alpha1.Partition.TemporalPartition.end_time:type_name -> google.protobuf.Timestamp
	7,   // 93: google.cloud.visionai.v1alpha1.Warehouse.CreateAsset:input_type -> google.cloud.visionai.v1alpha1.CreateAssetRequest
	11,  // 94: google.cloud.visionai.v1alpha1.Warehouse.UpdateAsset:input_type -> google.cloud.visionai.v1alpha1.UpdateAssetRequest
	8,   // 95: google.cloud.visionai.v1alpha1.Warehouse.GetAsset:input_type -> google.cloud.visionai.v1alpha1.GetAssetRequest
	9,   // 96: google.cloud.visionai.v1alpha1.Warehouse.ListAssets:input_type -> google.cloud.visionai.v1alpha1.ListAssetsRequest
	12,  // 97: google.cloud.visionai.v1alpha1.Warehouse.DeleteAsset:input_type -> google.cloud.visionai.v1alpha1.DeleteAssetRequest
	14,  // 98: google.cloud.visionai.v1alpha1.Warehouse.CreateCorpus:input_type -> google.cloud.visionai.v1alpha1.CreateCorpusRequest
	16,  // 99: google.cloud.visionai.v1alpha1.Warehouse.GetCorpus:input_type -> google.cloud.visionai.v1alpha1.GetCorpusRequest
	17,  // 100: google.cloud.visionai.v1alpha1.Warehouse.UpdateCorpus:input_type -> google.cloud.visionai.v1alpha1.UpdateCorpusRequest
	18,  // 101: google.cloud.visionai.v1alpha1.Warehouse.ListCorpora:input_type -> google.cloud.visionai.v1alpha1.ListCorporaRequest
	20,  // 102: google.cloud.visionai.v1alpha1.Warehouse.DeleteCorpus:input_type -> google.cloud.visionai.v1alpha1.DeleteCorpusRequest
	21,  // 103: google.cloud.visionai.v1alpha1.Warehouse.CreateDataSchema:input_type -> google.cloud.visionai.v1alpha1.CreateDataSchemaRequest
	24,  // 104: google.cloud.visionai.v1alpha1.Warehouse.UpdateDataSchema:input_type -> google.cloud.visionai.v1alpha1.UpdateDataSchemaRequest
	25,  // 105: google.cloud.visionai.v1alpha1.Warehouse.GetDataSchema:input_type -> google.cloud.visionai.v1alpha1.GetDataSchemaRequest
	26,  // 106: google.cloud.visionai.v1alpha1.Warehouse.DeleteDataSchema:input_type -> google.cloud.visionai.v1alpha1.DeleteDataSchemaRequest
	27,  // 107: google.cloud.visionai.v1alpha1.Warehouse.ListDataSchemas:input_type -> google.cloud.visionai.v1alpha1.ListDataSchemasRequest
	29,  // 108: google.cloud.visionai.v1alpha1.Warehouse.CreateAnnotation:input_type -> google.cloud.visionai.v1alpha1.CreateAnnotationRequest
	36,  // 109: google.cloud.visionai.v1alpha1.Warehouse.GetAnnotation:input_type -> google.cloud.visionai.v1alpha1.GetAnnotationRequest
	34,  // 110: google.cloud.visionai.v1alpha1.Warehouse.ListAnnotations:input_type -> google.cloud.visionai.v1alpha1.ListAnnotationsRequest
	37,  // 111: google.cloud.visionai.v1alpha1.Warehouse.UpdateAnnotation:input_type -> google.cloud.visionai.v1alpha1.UpdateAnnotationRequest
	38,  // 112: google.cloud.visionai.v1alpha1.Warehouse.DeleteAnnotation:input_type -> google.cloud.visionai.v1alpha1.DeleteAnnotationRequest
	51,  // 113: google.cloud.visionai.v1alpha1.Warehouse.IngestAsset:input_type -> google.cloud.visionai.v1alpha1.IngestAssetRequest
	53,  // 114: google.cloud.visionai.v1alpha1.Warehouse.ClipAsset:input_type -> google.cloud.visionai.v1alpha1.ClipAssetRequest
	55,  // 115: google.cloud.visionai.v1alpha1.Warehouse.GenerateHlsUri:input_type -> google.cloud.visionai.v1alpha1.GenerateHlsUriRequest
	39,  // 116: google.cloud.visionai.v1alpha1.Warehouse.CreateSearchConfig:input_type -> google.cloud.visionai.v1alpha1.CreateSearchConfigRequest
	40,  // 117: google.cloud.visionai.v1alpha1.Warehouse.UpdateSearchConfig:input_type -> google.cloud.visionai.v1alpha1.UpdateSearchConfigRequest
	41,  // 118: google.cloud.visionai.v1alpha1.Warehouse.GetSearchConfig:input_type -> google.cloud.visionai.v1alpha1.GetSearchConfigRequest
	42,  // 119: google.cloud.visionai.v1alpha1.Warehouse.DeleteSearchConfig:input_type -> google.cloud.visionai.v1alpha1.DeleteSearchConfigRequest
	43,  // 120: google.cloud.visionai.v1alpha1.Warehouse.ListSearchConfigs:input_type -> google.cloud.visionai.v1alpha1.ListSearchConfigsRequest
	57,  // 121: google.cloud.visionai.v1alpha1.Warehouse.SearchAssets:input_type -> google.cloud.visionai.v1alpha1.SearchAssetsRequest
	13,  // 122: google.cloud.visionai.v1alpha1.Warehouse.CreateAsset:output_type -> google.cloud.visionai.v1alpha1.Asset
	13,  // 123: google.cloud.visionai.v1alpha1.Warehouse.UpdateAsset:output_type -> google.cloud.visionai.v1alpha1.Asset
	13,  // 124: google.cloud.visionai.v1alpha1.Warehouse.GetAsset:output_type -> google.cloud.visionai.v1alpha1.Asset
	10,  // 125: google.cloud.visionai.v1alpha1.Warehouse.ListAssets:output_type -> google.cloud.visionai.v1alpha1.ListAssetsResponse
	96,  // 126: google.cloud.visionai.v1alpha1.Warehouse.DeleteAsset:output_type -> google.longrunning.Operation
	96,  // 127: google.cloud.visionai.v1alpha1.Warehouse.CreateCorpus:output_type -> google.longrunning.Operation
	15,  // 128: google.cloud.visionai.v1alpha1.Warehouse.GetCorpus:output_type -> google.cloud.visionai.v1alpha1.Corpus
	15,  // 129: google.cloud.visionai.v1alpha1.Warehouse.UpdateCorpus:output_type -> google.cloud.visionai.v1alpha1.Corpus
	19,  // 130: google.cloud.visionai.v1alpha1.Warehouse.ListCorpora:output_type -> google.cloud.visionai.v1alpha1.ListCorporaResponse
	97,  // 131: google.cloud.visionai.v1alpha1.Warehouse.DeleteCorpus:output_type -> google.protobuf.Empty
	22,  // 132: google.cloud.visionai.v1alpha1.Warehouse.CreateDataSchema:output_type -> google.cloud.visionai.v1alpha1.DataSchema
	22,  // 133: google.cloud.visionai.v1alpha1.Warehouse.UpdateDataSchema:output_type -> google.cloud.visionai.v1alpha1.DataSchema
	22,  // 134: google.cloud.visionai.v1alpha1.Warehouse.GetDataSchema:output_type -> google.cloud.visionai.v1alpha1.DataSchema
	97,  // 135: google.cloud.visionai.v1alpha1.Warehouse.DeleteDataSchema:output_type -> google.protobuf.Empty
	28,  // 136: google.cloud.visionai.v1alpha1.Warehouse.ListDataSchemas:output_type -> google.cloud.visionai.v1alpha1.ListDataSchemasResponse
	30,  // 137: google.cloud.visionai.v1alpha1.Warehouse.CreateAnnotation:output_type -> google.cloud.visionai.v1alpha1.Annotation
	30,  // 138: google.cloud.visionai.v1alpha1.Warehouse.GetAnnotation:output_type -> google.cloud.visionai.v1alpha1.Annotation
	35,  // 139: google.cloud.visionai.v1alpha1.Warehouse.ListAnnotations:output_type -> google.cloud.visionai.v1alpha1.ListAnnotationsResponse
	30,  // 140: google.cloud.visionai.v1alpha1.Warehouse.UpdateAnnotation:output_type -> google.cloud.visionai.v1alpha1.Annotation
	97,  // 141: google.cloud.visionai.v1alpha1.Warehouse.DeleteAnnotation:output_type -> google.protobuf.Empty
	52,  // 142: google.cloud.visionai.v1alpha1.Warehouse.IngestAsset:output_type -> google.cloud.visionai.v1alpha1.IngestAssetResponse
	54,  // 143: google.cloud.visionai.v1alpha1.Warehouse.ClipAsset:output_type -> google.cloud.visionai.v1alpha1.ClipAssetResponse
	56,  // 144: google.cloud.visionai.v1alpha1.Warehouse.GenerateHlsUri:output_type -> google.cloud.visionai.v1alpha1.GenerateHlsUriResponse
	45,  // 145: google.cloud.visionai.v1alpha1.Warehouse.CreateSearchConfig:output_type -> google.cloud.visionai.v1alpha1.SearchConfig
	45,  // 146: google.cloud.visionai.v1alpha1.Warehouse.UpdateSearchConfig:output_type -> google.cloud.visionai.v1alpha1.SearchConfig
	45,  // 147: google.cloud.visionai.v1alpha1.Warehouse.GetSearchConfig:output_type -> google.cloud.visionai.v1alpha1.SearchConfig
	97,  // 148: google.cloud.visionai.v1alpha1.Warehouse.DeleteSearchConfig:output_type -> google.protobuf.Empty
	44,  // 149: google.cloud.visionai.v1alpha1.Warehouse.ListSearchConfigs:output_type -> google.cloud.visionai.v1alpha1.ListSearchConfigsResponse
	61,  // 150: google.cloud.visionai.v1alpha1.Warehouse.SearchAssets:output_type -> google.cloud.visionai.v1alpha1.SearchAssetsResponse
	122, // [122:151] is the sub-list for method output_type
	93,  // [93:122] is the sub-list for method input_type
	93,  // [93:93] is the sub-list for extension type_name
	93,  // [93:93] is the sub-list for extension extendee
	0,   // [0:93] is the sub-list for field type_name
}

func init() { file_google_cloud_visionai_v1alpha1_warehouse_proto_init() }
func file_google_cloud_visionai_v1alpha1_warehouse_proto_init() {
	if File_google_cloud_visionai_v1alpha1_warehouse_proto != nil {
		return
	}
	if !protoimpl.UnsafeEnabled {
		file_google_cloud_visionai_v1alpha1_warehouse_proto_msgTypes[0].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CreateAssetRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_visionai_v1alpha1_warehouse_proto_msgTypes[1].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetAssetRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_visionai_v1alpha1_warehouse_proto_msgTypes[2].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListAssetsRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_visionai_v1alpha1_warehouse_proto_msgTypes[3].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListAssetsResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_visionai_v1alpha1_warehouse_proto_msgTypes[4].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*UpdateAssetRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_visionai_v1alpha1_warehouse_proto_msgTypes[5].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DeleteAssetRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_visionai_v1alpha1_warehouse_proto_msgTypes[6].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Asset); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_visionai_v1alpha1_warehouse_proto_msgTypes[7].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CreateCorpusRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_visionai_v1alpha1_warehouse_proto_msgTypes[8].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Corpus); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_visionai_v1alpha1_warehouse_proto_msgTypes[9].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetCorpusRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_visionai_v1alpha1_warehouse_proto_msgTypes[10].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*UpdateCorpusRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_visionai_v1alpha1_warehouse_proto_msgTypes[11].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListCorporaRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_visionai_v1alpha1_warehouse_proto_msgTypes[12].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListCorporaResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_visionai_v1alpha1_warehouse_proto_msgTypes[13].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DeleteCorpusRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_visionai_v1alpha1_warehouse_proto_msgTypes[14].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CreateDataSchemaRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_visionai_v1alpha1_warehouse_proto_msgTypes[15].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DataSchema); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_visionai_v1alpha1_warehouse_proto_msgTypes[16].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DataSchemaDetails); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_visionai_v1alpha1_warehouse_proto_msgTypes[17].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*UpdateDataSchemaRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_visionai_v1alpha1_warehouse_proto_msgTypes[18].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetDataSchemaRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_visionai_v1alpha1_warehouse_proto_msgTypes[19].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DeleteDataSchemaRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_visionai_v1alpha1_warehouse_proto_msgTypes[20].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListDataSchemasRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_visionai_v1alpha1_warehouse_proto_msgTypes[21].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListDataSchemasResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_visionai_v1alpha1_warehouse_proto_msgTypes[22].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CreateAnnotationRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_visionai_v1alpha1_warehouse_proto_msgTypes[23].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Annotation); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_visionai_v1alpha1_warehouse_proto_msgTypes[24].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*UserSpecifiedAnnotation); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_visionai_v1alpha1_warehouse_proto_msgTypes[25].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GeoCoordinate); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_visionai_v1alpha1_warehouse_proto_msgTypes[26].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*AnnotationValue); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_visionai_v1alpha1_warehouse_proto_msgTypes[27].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListAnnotationsRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_visionai_v1alpha1_warehouse_proto_msgTypes[28].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListAnnotationsResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_visionai_v1alpha1_warehouse_proto_msgTypes[29].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetAnnotationRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_visionai_v1alpha1_warehouse_proto_msgTypes[30].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*UpdateAnnotationRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_visionai_v1alpha1_warehouse_proto_msgTypes[31].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DeleteAnnotationRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_visionai_v1alpha1_warehouse_proto_msgTypes[32].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CreateSearchConfigRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_visionai_v1alpha1_warehouse_proto_msgTypes[33].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*UpdateSearchConfigRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_visionai_v1alpha1_warehouse_proto_msgTypes[34].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetSearchConfigRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_visionai_v1alpha1_warehouse_proto_msgTypes[35].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DeleteSearchConfigRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_visionai_v1alpha1_warehouse_proto_msgTypes[36].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListSearchConfigsRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_visionai_v1alpha1_warehouse_proto_msgTypes[37].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListSearchConfigsResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_visionai_v1alpha1_warehouse_proto_msgTypes[38].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SearchConfig); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_visionai_v1alpha1_warehouse_proto_msgTypes[39].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*FacetProperty); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_visionai_v1alpha1_warehouse_proto_msgTypes[40].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SearchCriteriaProperty); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_visionai_v1alpha1_warehouse_proto_msgTypes[41].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*FacetValue); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_visionai_v1alpha1_warehouse_proto_msgTypes[42].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*FacetBucket); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_visionai_v1alpha1_warehouse_proto_msgTypes[43].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*FacetGroup); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_visionai_v1alpha1_warehouse_proto_msgTypes[44].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*IngestAssetRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_visionai_v1alpha1_warehouse_proto_msgTypes[45].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*IngestAssetResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_visionai_v1alpha1_warehouse_proto_msgTypes[46].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ClipAssetRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_visionai_v1alpha1_warehouse_proto_msgTypes[47].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ClipAssetResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_visionai_v1alpha1_warehouse_proto_msgTypes[48].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GenerateHlsUriRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_visionai_v1alpha1_warehouse_proto_msgTypes[49].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GenerateHlsUriResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_visionai_v1alpha1_warehouse_proto_msgTypes[50].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SearchAssetsRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_visionai_v1alpha1_warehouse_proto_msgTypes[51].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SchemaKeySortingStrategy); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_visionai_v1alpha1_warehouse_proto_msgTypes[52].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*AnnotationMatchingResult); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_visionai_v1alpha1_warehouse_proto_msgTypes[53].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SearchResultItem); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_visionai_v1alpha1_warehouse_proto_msgTypes[54].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SearchAssetsResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_visionai_v1alpha1_warehouse_proto_msgTypes[55].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*IntRange); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_visionai_v1alpha1_warehouse_proto_msgTypes[56].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*FloatRange); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_visionai_v1alpha1_warehouse_proto_msgTypes[57].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*StringArray); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_visionai_v1alpha1_warehouse_proto_msgTypes[58].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*IntRangeArray); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_visionai_v1alpha1_warehouse_proto_msgTypes[59].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*FloatRangeArray); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_visionai_v1alpha1_warehouse_proto_msgTypes[60].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DateTimeRange); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_visionai_v1alpha1_warehouse_proto_msgTypes[61].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DateTimeRangeArray); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_visionai_v1alpha1_warehouse_proto_msgTypes[62].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CircleArea); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_visionai_v1alpha1_warehouse_proto_msgTypes[63].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GeoLocationArray); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_visionai_v1alpha1_warehouse_proto_msgTypes[64].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*BoolValue); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_visionai_v1alpha1_warehouse_proto_msgTypes[65].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Criteria); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_visionai_v1alpha1_warehouse_proto_msgTypes[66].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Partition); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_visionai_v1alpha1_warehouse_proto_msgTypes[67].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DeleteAssetMetadata); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_visionai_v1alpha1_warehouse_proto_msgTypes[68].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CreateCorpusMetadata); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_visionai_v1alpha1_warehouse_proto_msgTypes[69].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DataSchemaDetails_ProtoAnyConfig); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_visionai_v1alpha1_warehouse_proto_msgTypes[70].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DataSchemaDetails_SearchStrategy); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_visionai_v1alpha1_warehouse_proto_msgTypes[71].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*FacetProperty_FixedRangeBucketSpec); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_visionai_v1alpha1_warehouse_proto_msgTypes[72].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*FacetProperty_CustomRangeBucketSpec); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_visionai_v1alpha1_warehouse_proto_msgTypes[73].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*FacetProperty_DateTimeBucketSpec); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_visionai_v1alpha1_warehouse_proto_msgTypes[74].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*FacetBucket_Range); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_visionai_v1alpha1_warehouse_proto_msgTypes[75].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*IngestAssetRequest_Config); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_visionai_v1alpha1_warehouse_proto_msgTypes[76].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*IngestAssetRequest_TimeIndexedData); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_visionai_v1alpha1_warehouse_proto_msgTypes[77].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*IngestAssetRequest_Config_VideoType); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_visionai_v1alpha1_warehouse_proto_msgTypes[78].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ClipAssetResponse_TimeIndexedUri); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_visionai_v1alpha1_warehouse_proto_msgTypes[79].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SchemaKeySortingStrategy_Option); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_visionai_v1alpha1_warehouse_proto_msgTypes[80].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Partition_TemporalPartition); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_visionai_v1alpha1_warehouse_proto_msgTypes[81].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Partition_SpatialPartition); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	file_google_cloud_visionai_v1alpha1_warehouse_proto_msgTypes[0].OneofWrappers = []interface{}{}
	file_google_cloud_visionai_v1alpha1_warehouse_proto_msgTypes[22].OneofWrappers = []interface{}{}
	file_google_cloud_visionai_v1alpha1_warehouse_proto_msgTypes[26].OneofWrappers = []interface{}{
		(*AnnotationValue_IntValue)(nil),
		(*AnnotationValue_FloatValue)(nil),
		(*AnnotationValue_StrValue)(nil),
		(*AnnotationValue_DatetimeValue)(nil),
		(*AnnotationValue_GeoCoordinate)(nil),
		(*AnnotationValue_ProtoAnyValue)(nil),
		(*AnnotationValue_BoolValue)(nil),
		(*AnnotationValue_CustomizedStructDataValue)(nil),
	}
	file_google_cloud_visionai_v1alpha1_warehouse_proto_msgTypes[39].OneofWrappers = []interface{}{
		(*FacetProperty_FixedRangeBucketSpec_)(nil),
		(*FacetProperty_CustomRangeBucketSpec_)(nil),
		(*FacetProperty_DatetimeBucketSpec)(nil),
	}
	file_google_cloud_visionai_v1alpha1_warehouse_proto_msgTypes[41].OneofWrappers = []interface{}{
		(*FacetValue_StringValue)(nil),
		(*FacetValue_IntegerValue)(nil),
		(*FacetValue_DatetimeValue)(nil),
	}
	file_google_cloud_visionai_v1alpha1_warehouse_proto_msgTypes[42].OneofWrappers = []interface{}{
		(*FacetBucket_Value)(nil),
		(*FacetBucket_Range_)(nil),
	}
	file_google_cloud_visionai_v1alpha1_warehouse_proto_msgTypes[44].OneofWrappers = []interface{}{
		(*IngestAssetRequest_Config_)(nil),
		(*IngestAssetRequest_TimeIndexedData_)(nil),
	}
	file_google_cloud_visionai_v1alpha1_warehouse_proto_msgTypes[50].OneofWrappers = []interface{}{
		(*SearchAssetsRequest_SchemaKeySortingStrategy)(nil),
	}
	file_google_cloud_visionai_v1alpha1_warehouse_proto_msgTypes[55].OneofWrappers = []interface{}{}
	file_google_cloud_visionai_v1alpha1_warehouse_proto_msgTypes[56].OneofWrappers = []interface{}{}
	file_google_cloud_visionai_v1alpha1_warehouse_proto_msgTypes[65].OneofWrappers = []interface{}{
		(*Criteria_TextArray)(nil),
		(*Criteria_IntRangeArray)(nil),
		(*Criteria_FloatRangeArray)(nil),
		(*Criteria_DateTimeRangeArray)(nil),
		(*Criteria_GeoLocationArray)(nil),
		(*Criteria_BoolValue)(nil),
	}
	file_google_cloud_visionai_v1alpha1_warehouse_proto_msgTypes[75].OneofWrappers = []interface{}{
		(*IngestAssetRequest_Config_VideoType_)(nil),
	}
	file_google_cloud_visionai_v1alpha1_warehouse_proto_msgTypes[79].OneofWrappers = []interface{}{}
	file_google_cloud_visionai_v1alpha1_warehouse_proto_msgTypes[81].OneofWrappers = []interface{}{}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_cloud_visionai_v1alpha1_warehouse_proto_rawDesc,
			NumEnums:      7,
			NumMessages:   82,
			NumExtensions: 0,
			NumServices:   1,
		},
		GoTypes:           file_google_cloud_visionai_v1alpha1_warehouse_proto_goTypes,
		DependencyIndexes: file_google_cloud_visionai_v1alpha1_warehouse_proto_depIdxs,
		EnumInfos:         file_google_cloud_visionai_v1alpha1_warehouse_proto_enumTypes,
		MessageInfos:      file_google_cloud_visionai_v1alpha1_warehouse_proto_msgTypes,
	}.Build()
	File_google_cloud_visionai_v1alpha1_warehouse_proto = out.File
	file_google_cloud_visionai_v1alpha1_warehouse_proto_rawDesc = nil
	file_google_cloud_visionai_v1alpha1_warehouse_proto_goTypes = nil
	file_google_cloud_visionai_v1alpha1_warehouse_proto_depIdxs = nil
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConnInterface

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion6

// WarehouseClient is the client API for Warehouse service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type WarehouseClient interface {
	// Creates an asset inside corpus.
	CreateAsset(ctx context.Context, in *CreateAssetRequest, opts ...grpc.CallOption) (*Asset, error)
	// Updates an asset inside corpus.
	UpdateAsset(ctx context.Context, in *UpdateAssetRequest, opts ...grpc.CallOption) (*Asset, error)
	// Reads an asset inside corpus.
	GetAsset(ctx context.Context, in *GetAssetRequest, opts ...grpc.CallOption) (*Asset, error)
	// Lists an list of assets inside corpus.
	ListAssets(ctx context.Context, in *ListAssetsRequest, opts ...grpc.CallOption) (*ListAssetsResponse, error)
	// Deletes asset inside corpus.
	DeleteAsset(ctx context.Context, in *DeleteAssetRequest, opts ...grpc.CallOption) (*longrunning.Operation, error)
	// Creates a corpus inside a project.
	CreateCorpus(ctx context.Context, in *CreateCorpusRequest, opts ...grpc.CallOption) (*longrunning.Operation, error)
	// Gets corpus details inside a project.
	GetCorpus(ctx context.Context, in *GetCorpusRequest, opts ...grpc.CallOption) (*Corpus, error)
	// Updates a corpus in a project.
	UpdateCorpus(ctx context.Context, in *UpdateCorpusRequest, opts ...grpc.CallOption) (*Corpus, error)
	// Lists all corpora in a project.
	ListCorpora(ctx context.Context, in *ListCorporaRequest, opts ...grpc.CallOption) (*ListCorporaResponse, error)
	// Deletes a corpus only if its empty.
	// Returns empty response.
	DeleteCorpus(ctx context.Context, in *DeleteCorpusRequest, opts ...grpc.CallOption) (*emptypb.Empty, error)
	// Creates data schema inside corpus.
	CreateDataSchema(ctx context.Context, in *CreateDataSchemaRequest, opts ...grpc.CallOption) (*DataSchema, error)
	// Updates data schema inside corpus.
	UpdateDataSchema(ctx context.Context, in *UpdateDataSchemaRequest, opts ...grpc.CallOption) (*DataSchema, error)
	// Gets data schema inside corpus.
	GetDataSchema(ctx context.Context, in *GetDataSchemaRequest, opts ...grpc.CallOption) (*DataSchema, error)
	// Deletes data schema inside corpus.
	DeleteDataSchema(ctx context.Context, in *DeleteDataSchemaRequest, opts ...grpc.CallOption) (*emptypb.Empty, error)
	// Lists a list of data schemas inside corpus.
	ListDataSchemas(ctx context.Context, in *ListDataSchemasRequest, opts ...grpc.CallOption) (*ListDataSchemasResponse, error)
	// Creates annotation inside asset.
	CreateAnnotation(ctx context.Context, in *CreateAnnotationRequest, opts ...grpc.CallOption) (*Annotation, error)
	// Reads annotation inside asset.
	GetAnnotation(ctx context.Context, in *GetAnnotationRequest, opts ...grpc.CallOption) (*Annotation, error)
	// Lists a list of annotations inside asset.
	ListAnnotations(ctx context.Context, in *ListAnnotationsRequest, opts ...grpc.CallOption) (*ListAnnotationsResponse, error)
	// Updates annotation inside asset.
	UpdateAnnotation(ctx context.Context, in *UpdateAnnotationRequest, opts ...grpc.CallOption) (*Annotation, error)
	// Deletes annotation inside asset.
	DeleteAnnotation(ctx context.Context, in *DeleteAnnotationRequest, opts ...grpc.CallOption) (*emptypb.Empty, error)
	// Ingests data for the asset. It is not allowed to ingest a data chunk which
	// is already expired according to TTL.
	// This method is only available via the gRPC API (not HTTP since
	// bi-directional streaming is not supported via HTTP).
	IngestAsset(ctx context.Context, opts ...grpc.CallOption) (Warehouse_IngestAssetClient, error)
	// Generates clips for downloading. The api takes in a time range, and
	// generates a clip of the first content available after start_time and
	// before end_time, which may overflow beyond these bounds.
	// Returned clips are truncated if the total size of the clips are larger
	// than 100MB.
	ClipAsset(ctx context.Context, in *ClipAssetRequest, opts ...grpc.CallOption) (*ClipAssetResponse, error)
	// Generates a uri for an HLS manifest. The api takes in a collection of time
	// ranges, and generates a URI for an HLS manifest that covers all the
	// requested time ranges.
	GenerateHlsUri(ctx context.Context, in *GenerateHlsUriRequest, opts ...grpc.CallOption) (*GenerateHlsUriResponse, error)
	// Creates a search configuration inside a corpus.
	//
	// Please follow the rules below to create a valid CreateSearchConfigRequest.
	// --- General Rules ---
	//  1. Request.search_config_id must not be associated with an existing
	//     SearchConfig.
	//  2. Request must contain at least one non-empty search_criteria_property or
	//     facet_property.
	//  3. mapped_fields must not be empty, and must map to existing UGA keys.
	//  4. All mapped_fields must be of the same type.
	//  5. All mapped_fields must share the same granularity.
	//  6. All mapped_fields must share the same semantic SearchConfig match
	//     options.
	//
	// For property-specific rules, please reference the comments for
	// FacetProperty and SearchCriteriaProperty.
	CreateSearchConfig(ctx context.Context, in *CreateSearchConfigRequest, opts ...grpc.CallOption) (*SearchConfig, error)
	// Updates a search configuration inside a corpus.
	//
	// Please follow the rules below to create a valid UpdateSearchConfigRequest.
	// --- General Rules ---
	// 1. Request.search_configuration.name must already exist.
	// 2. Request must contain at least one non-empty search_criteria_property or
	// facet_property.
	//  3. mapped_fields must not be empty, and must map to existing UGA keys.
	//  4. All mapped_fields must be of the same type.
	//  5. All mapped_fields must share the same granularity.
	//  6. All mapped_fields must share the same semantic SearchConfig match
	//     options.
	//
	// For property-specific rules, please reference the comments for
	// FacetProperty and SearchCriteriaProperty.
	UpdateSearchConfig(ctx context.Context, in *UpdateSearchConfigRequest, opts ...grpc.CallOption) (*SearchConfig, error)
	// Gets a search configuration inside a corpus.
	GetSearchConfig(ctx context.Context, in *GetSearchConfigRequest, opts ...grpc.CallOption) (*SearchConfig, error)
	// Deletes a search configuration inside a corpus.
	//
	// For a DeleteSearchConfigRequest to be valid,
	// Request.search_configuration.name must already exist.
	DeleteSearchConfig(ctx context.Context, in *DeleteSearchConfigRequest, opts ...grpc.CallOption) (*emptypb.Empty, error)
	// Lists all search configurations inside a corpus.
	ListSearchConfigs(ctx context.Context, in *ListSearchConfigsRequest, opts ...grpc.CallOption) (*ListSearchConfigsResponse, error)
	// Search media asset.
	SearchAssets(ctx context.Context, in *SearchAssetsRequest, opts ...grpc.CallOption) (*SearchAssetsResponse, error)
}

type warehouseClient struct {
	cc grpc.ClientConnInterface
}

func NewWarehouseClient(cc grpc.ClientConnInterface) WarehouseClient {
	return &warehouseClient{cc}
}

func (c *warehouseClient) CreateAsset(ctx context.Context, in *CreateAssetRequest, opts ...grpc.CallOption) (*Asset, error) {
	out := new(Asset)
	err := c.cc.Invoke(ctx, "/google.cloud.visionai.v1alpha1.Warehouse/CreateAsset", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *warehouseClient) UpdateAsset(ctx context.Context, in *UpdateAssetRequest, opts ...grpc.CallOption) (*Asset, error) {
	out := new(Asset)
	err := c.cc.Invoke(ctx, "/google.cloud.visionai.v1alpha1.Warehouse/UpdateAsset", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *warehouseClient) GetAsset(ctx context.Context, in *GetAssetRequest, opts ...grpc.CallOption) (*Asset, error) {
	out := new(Asset)
	err := c.cc.Invoke(ctx, "/google.cloud.visionai.v1alpha1.Warehouse/GetAsset", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *warehouseClient) ListAssets(ctx context.Context, in *ListAssetsRequest, opts ...grpc.CallOption) (*ListAssetsResponse, error) {
	out := new(ListAssetsResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.visionai.v1alpha1.Warehouse/ListAssets", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *warehouseClient) DeleteAsset(ctx context.Context, in *DeleteAssetRequest, opts ...grpc.CallOption) (*longrunning.Operation, error) {
	out := new(longrunning.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.visionai.v1alpha1.Warehouse/DeleteAsset", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *warehouseClient) CreateCorpus(ctx context.Context, in *CreateCorpusRequest, opts ...grpc.CallOption) (*longrunning.Operation, error) {
	out := new(longrunning.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.visionai.v1alpha1.Warehouse/CreateCorpus", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *warehouseClient) GetCorpus(ctx context.Context, in *GetCorpusRequest, opts ...grpc.CallOption) (*Corpus, error) {
	out := new(Corpus)
	err := c.cc.Invoke(ctx, "/google.cloud.visionai.v1alpha1.Warehouse/GetCorpus", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *warehouseClient) UpdateCorpus(ctx context.Context, in *UpdateCorpusRequest, opts ...grpc.CallOption) (*Corpus, error) {
	out := new(Corpus)
	err := c.cc.Invoke(ctx, "/google.cloud.visionai.v1alpha1.Warehouse/UpdateCorpus", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *warehouseClient) ListCorpora(ctx context.Context, in *ListCorporaRequest, opts ...grpc.CallOption) (*ListCorporaResponse, error) {
	out := new(ListCorporaResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.visionai.v1alpha1.Warehouse/ListCorpora", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *warehouseClient) DeleteCorpus(ctx context.Context, in *DeleteCorpusRequest, opts ...grpc.CallOption) (*emptypb.Empty, error) {
	out := new(emptypb.Empty)
	err := c.cc.Invoke(ctx, "/google.cloud.visionai.v1alpha1.Warehouse/DeleteCorpus", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *warehouseClient) CreateDataSchema(ctx context.Context, in *CreateDataSchemaRequest, opts ...grpc.CallOption) (*DataSchema, error) {
	out := new(DataSchema)
	err := c.cc.Invoke(ctx, "/google.cloud.visionai.v1alpha1.Warehouse/CreateDataSchema", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *warehouseClient) UpdateDataSchema(ctx context.Context, in *UpdateDataSchemaRequest, opts ...grpc.CallOption) (*DataSchema, error) {
	out := new(DataSchema)
	err := c.cc.Invoke(ctx, "/google.cloud.visionai.v1alpha1.Warehouse/UpdateDataSchema", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *warehouseClient) GetDataSchema(ctx context.Context, in *GetDataSchemaRequest, opts ...grpc.CallOption) (*DataSchema, error) {
	out := new(DataSchema)
	err := c.cc.Invoke(ctx, "/google.cloud.visionai.v1alpha1.Warehouse/GetDataSchema", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *warehouseClient) DeleteDataSchema(ctx context.Context, in *DeleteDataSchemaRequest, opts ...grpc.CallOption) (*emptypb.Empty, error) {
	out := new(emptypb.Empty)
	err := c.cc.Invoke(ctx, "/google.cloud.visionai.v1alpha1.Warehouse/DeleteDataSchema", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *warehouseClient) ListDataSchemas(ctx context.Context, in *ListDataSchemasRequest, opts ...grpc.CallOption) (*ListDataSchemasResponse, error) {
	out := new(ListDataSchemasResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.visionai.v1alpha1.Warehouse/ListDataSchemas", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *warehouseClient) CreateAnnotation(ctx context.Context, in *CreateAnnotationRequest, opts ...grpc.CallOption) (*Annotation, error) {
	out := new(Annotation)
	err := c.cc.Invoke(ctx, "/google.cloud.visionai.v1alpha1.Warehouse/CreateAnnotation", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *warehouseClient) GetAnnotation(ctx context.Context, in *GetAnnotationRequest, opts ...grpc.CallOption) (*Annotation, error) {
	out := new(Annotation)
	err := c.cc.Invoke(ctx, "/google.cloud.visionai.v1alpha1.Warehouse/GetAnnotation", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *warehouseClient) ListAnnotations(ctx context.Context, in *ListAnnotationsRequest, opts ...grpc.CallOption) (*ListAnnotationsResponse, error) {
	out := new(ListAnnotationsResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.visionai.v1alpha1.Warehouse/ListAnnotations", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *warehouseClient) UpdateAnnotation(ctx context.Context, in *UpdateAnnotationRequest, opts ...grpc.CallOption) (*Annotation, error) {
	out := new(Annotation)
	err := c.cc.Invoke(ctx, "/google.cloud.visionai.v1alpha1.Warehouse/UpdateAnnotation", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *warehouseClient) DeleteAnnotation(ctx context.Context, in *DeleteAnnotationRequest, opts ...grpc.CallOption) (*emptypb.Empty, error) {
	out := new(emptypb.Empty)
	err := c.cc.Invoke(ctx, "/google.cloud.visionai.v1alpha1.Warehouse/DeleteAnnotation", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *warehouseClient) IngestAsset(ctx context.Context, opts ...grpc.CallOption) (Warehouse_IngestAssetClient, error) {
	stream, err := c.cc.NewStream(ctx, &_Warehouse_serviceDesc.Streams[0], "/google.cloud.visionai.v1alpha1.Warehouse/IngestAsset", opts...)
	if err != nil {
		return nil, err
	}
	x := &warehouseIngestAssetClient{stream}
	return x, nil
}

type Warehouse_IngestAssetClient interface {
	Send(*IngestAssetRequest) error
	Recv() (*IngestAssetResponse, error)
	grpc.ClientStream
}

type warehouseIngestAssetClient struct {
	grpc.ClientStream
}

func (x *warehouseIngestAssetClient) Send(m *IngestAssetRequest) error {
	return x.ClientStream.SendMsg(m)
}

func (x *warehouseIngestAssetClient) Recv() (*IngestAssetResponse, error) {
	m := new(IngestAssetResponse)
	if err := x.ClientStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

func (c *warehouseClient) ClipAsset(ctx context.Context, in *ClipAssetRequest, opts ...grpc.CallOption) (*ClipAssetResponse, error) {
	out := new(ClipAssetResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.visionai.v1alpha1.Warehouse/ClipAsset", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *warehouseClient) GenerateHlsUri(ctx context.Context, in *GenerateHlsUriRequest, opts ...grpc.CallOption) (*GenerateHlsUriResponse, error) {
	out := new(GenerateHlsUriResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.visionai.v1alpha1.Warehouse/GenerateHlsUri", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *warehouseClient) CreateSearchConfig(ctx context.Context, in *CreateSearchConfigRequest, opts ...grpc.CallOption) (*SearchConfig, error) {
	out := new(SearchConfig)
	err := c.cc.Invoke(ctx, "/google.cloud.visionai.v1alpha1.Warehouse/CreateSearchConfig", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *warehouseClient) UpdateSearchConfig(ctx context.Context, in *UpdateSearchConfigRequest, opts ...grpc.CallOption) (*SearchConfig, error) {
	out := new(SearchConfig)
	err := c.cc.Invoke(ctx, "/google.cloud.visionai.v1alpha1.Warehouse/UpdateSearchConfig", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *warehouseClient) GetSearchConfig(ctx context.Context, in *GetSearchConfigRequest, opts ...grpc.CallOption) (*SearchConfig, error) {
	out := new(SearchConfig)
	err := c.cc.Invoke(ctx, "/google.cloud.visionai.v1alpha1.Warehouse/GetSearchConfig", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *warehouseClient) DeleteSearchConfig(ctx context.Context, in *DeleteSearchConfigRequest, opts ...grpc.CallOption) (*emptypb.Empty, error) {
	out := new(emptypb.Empty)
	err := c.cc.Invoke(ctx, "/google.cloud.visionai.v1alpha1.Warehouse/DeleteSearchConfig", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *warehouseClient) ListSearchConfigs(ctx context.Context, in *ListSearchConfigsRequest, opts ...grpc.CallOption) (*ListSearchConfigsResponse, error) {
	out := new(ListSearchConfigsResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.visionai.v1alpha1.Warehouse/ListSearchConfigs", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *warehouseClient) SearchAssets(ctx context.Context, in *SearchAssetsRequest, opts ...grpc.CallOption) (*SearchAssetsResponse, error) {
	out := new(SearchAssetsResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.visionai.v1alpha1.Warehouse/SearchAssets", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// WarehouseServer is the server API for Warehouse service.
type WarehouseServer interface {
	// Creates an asset inside corpus.
	CreateAsset(context.Context, *CreateAssetRequest) (*Asset, error)
	// Updates an asset inside corpus.
	UpdateAsset(context.Context, *UpdateAssetRequest) (*Asset, error)
	// Reads an asset inside corpus.
	GetAsset(context.Context, *GetAssetRequest) (*Asset, error)
	// Lists an list of assets inside corpus.
	ListAssets(context.Context, *ListAssetsRequest) (*ListAssetsResponse, error)
	// Deletes asset inside corpus.
	DeleteAsset(context.Context, *DeleteAssetRequest) (*longrunning.Operation, error)
	// Creates a corpus inside a project.
	CreateCorpus(context.Context, *CreateCorpusRequest) (*longrunning.Operation, error)
	// Gets corpus details inside a project.
	GetCorpus(context.Context, *GetCorpusRequest) (*Corpus, error)
	// Updates a corpus in a project.
	UpdateCorpus(context.Context, *UpdateCorpusRequest) (*Corpus, error)
	// Lists all corpora in a project.
	ListCorpora(context.Context, *ListCorporaRequest) (*ListCorporaResponse, error)
	// Deletes a corpus only if its empty.
	// Returns empty response.
	DeleteCorpus(context.Context, *DeleteCorpusRequest) (*emptypb.Empty, error)
	// Creates data schema inside corpus.
	CreateDataSchema(context.Context, *CreateDataSchemaRequest) (*DataSchema, error)
	// Updates data schema inside corpus.
	UpdateDataSchema(context.Context, *UpdateDataSchemaRequest) (*DataSchema, error)
	// Gets data schema inside corpus.
	GetDataSchema(context.Context, *GetDataSchemaRequest) (*DataSchema, error)
	// Deletes data schema inside corpus.
	DeleteDataSchema(context.Context, *DeleteDataSchemaRequest) (*emptypb.Empty, error)
	// Lists a list of data schemas inside corpus.
	ListDataSchemas(context.Context, *ListDataSchemasRequest) (*ListDataSchemasResponse, error)
	// Creates annotation inside asset.
	CreateAnnotation(context.Context, *CreateAnnotationRequest) (*Annotation, error)
	// Reads annotation inside asset.
	GetAnnotation(context.Context, *GetAnnotationRequest) (*Annotation, error)
	// Lists a list of annotations inside asset.
	ListAnnotations(context.Context, *ListAnnotationsRequest) (*ListAnnotationsResponse, error)
	// Updates annotation inside asset.
	UpdateAnnotation(context.Context, *UpdateAnnotationRequest) (*Annotation, error)
	// Deletes annotation inside asset.
	DeleteAnnotation(context.Context, *DeleteAnnotationRequest) (*emptypb.Empty, error)
	// Ingests data for the asset. It is not allowed to ingest a data chunk which
	// is already expired according to TTL.
	// This method is only available via the gRPC API (not HTTP since
	// bi-directional streaming is not supported via HTTP).
	IngestAsset(Warehouse_IngestAssetServer) error
	// Generates clips for downloading. The api takes in a time range, and
	// generates a clip of the first content available after start_time and
	// before end_time, which may overflow beyond these bounds.
	// Returned clips are truncated if the total size of the clips are larger
	// than 100MB.
	ClipAsset(context.Context, *ClipAssetRequest) (*ClipAssetResponse, error)
	// Generates a uri for an HLS manifest. The api takes in a collection of time
	// ranges, and generates a URI for an HLS manifest that covers all the
	// requested time ranges.
	GenerateHlsUri(context.Context, *GenerateHlsUriRequest) (*GenerateHlsUriResponse, error)
	// Creates a search configuration inside a corpus.
	//
	// Please follow the rules below to create a valid CreateSearchConfigRequest.
	// --- General Rules ---
	//  1. Request.search_config_id must not be associated with an existing
	//     SearchConfig.
	//  2. Request must contain at least one non-empty search_criteria_property or
	//     facet_property.
	//  3. mapped_fields must not be empty, and must map to existing UGA keys.
	//  4. All mapped_fields must be of the same type.
	//  5. All mapped_fields must share the same granularity.
	//  6. All mapped_fields must share the same semantic SearchConfig match
	//     options.
	//
	// For property-specific rules, please reference the comments for
	// FacetProperty and SearchCriteriaProperty.
	CreateSearchConfig(context.Context, *CreateSearchConfigRequest) (*SearchConfig, error)
	// Updates a search configuration inside a corpus.
	//
	// Please follow the rules below to create a valid UpdateSearchConfigRequest.
	// --- General Rules ---
	// 1. Request.search_configuration.name must already exist.
	// 2. Request must contain at least one non-empty search_criteria_property or
	// facet_property.
	//  3. mapped_fields must not be empty, and must map to existing UGA keys.
	//  4. All mapped_fields must be of the same type.
	//  5. All mapped_fields must share the same granularity.
	//  6. All mapped_fields must share the same semantic SearchConfig match
	//     options.
	//
	// For property-specific rules, please reference the comments for
	// FacetProperty and SearchCriteriaProperty.
	UpdateSearchConfig(context.Context, *UpdateSearchConfigRequest) (*SearchConfig, error)
	// Gets a search configuration inside a corpus.
	GetSearchConfig(context.Context, *GetSearchConfigRequest) (*SearchConfig, error)
	// Deletes a search configuration inside a corpus.
	//
	// For a DeleteSearchConfigRequest to be valid,
	// Request.search_configuration.name must already exist.
	DeleteSearchConfig(context.Context, *DeleteSearchConfigRequest) (*emptypb.Empty, error)
	// Lists all search configurations inside a corpus.
	ListSearchConfigs(context.Context, *ListSearchConfigsRequest) (*ListSearchConfigsResponse, error)
	// Search media asset.
	SearchAssets(context.Context, *SearchAssetsRequest) (*SearchAssetsResponse, error)
}

// UnimplementedWarehouseServer can be embedded to have forward compatible implementations.
type UnimplementedWarehouseServer struct {
}

func (*UnimplementedWarehouseServer) CreateAsset(context.Context, *CreateAssetRequest) (*Asset, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method CreateAsset not implemented")
}
func (*UnimplementedWarehouseServer) UpdateAsset(context.Context, *UpdateAssetRequest) (*Asset, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method UpdateAsset not implemented")
}
func (*UnimplementedWarehouseServer) GetAsset(context.Context, *GetAssetRequest) (*Asset, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method GetAsset not implemented")
}
func (*UnimplementedWarehouseServer) ListAssets(context.Context, *ListAssetsRequest) (*ListAssetsResponse, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method ListAssets not implemented")
}
func (*UnimplementedWarehouseServer) DeleteAsset(context.Context, *DeleteAssetRequest) (*longrunning.Operation, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method DeleteAsset not implemented")
}
func (*UnimplementedWarehouseServer) CreateCorpus(context.Context, *CreateCorpusRequest) (*longrunning.Operation, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method CreateCorpus not implemented")
}
func (*UnimplementedWarehouseServer) GetCorpus(context.Context, *GetCorpusRequest) (*Corpus, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method GetCorpus not implemented")
}
func (*UnimplementedWarehouseServer) UpdateCorpus(context.Context, *UpdateCorpusRequest) (*Corpus, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method UpdateCorpus not implemented")
}
func (*UnimplementedWarehouseServer) ListCorpora(context.Context, *ListCorporaRequest) (*ListCorporaResponse, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method ListCorpora not implemented")
}
func (*UnimplementedWarehouseServer) DeleteCorpus(context.Context, *DeleteCorpusRequest) (*emptypb.Empty, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method DeleteCorpus not implemented")
}
func (*UnimplementedWarehouseServer) CreateDataSchema(context.Context, *CreateDataSchemaRequest) (*DataSchema, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method CreateDataSchema not implemented")
}
func (*UnimplementedWarehouseServer) UpdateDataSchema(context.Context, *UpdateDataSchemaRequest) (*DataSchema, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method UpdateDataSchema not implemented")
}
func (*UnimplementedWarehouseServer) GetDataSchema(context.Context, *GetDataSchemaRequest) (*DataSchema, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method GetDataSchema not implemented")
}
func (*UnimplementedWarehouseServer) DeleteDataSchema(context.Context, *DeleteDataSchemaRequest) (*emptypb.Empty, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method DeleteDataSchema not implemented")
}
func (*UnimplementedWarehouseServer) ListDataSchemas(context.Context, *ListDataSchemasRequest) (*ListDataSchemasResponse, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method ListDataSchemas not implemented")
}
func (*UnimplementedWarehouseServer) CreateAnnotation(context.Context, *CreateAnnotationRequest) (*Annotation, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method CreateAnnotation not implemented")
}
func (*UnimplementedWarehouseServer) GetAnnotation(context.Context, *GetAnnotationRequest) (*Annotation, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method GetAnnotation not implemented")
}
func (*UnimplementedWarehouseServer) ListAnnotations(context.Context, *ListAnnotationsRequest) (*ListAnnotationsResponse, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method ListAnnotations not implemented")
}
func (*UnimplementedWarehouseServer) UpdateAnnotation(context.Context, *UpdateAnnotationRequest) (*Annotation, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method UpdateAnnotation not implemented")
}
func (*UnimplementedWarehouseServer) DeleteAnnotation(context.Context, *DeleteAnnotationRequest) (*emptypb.Empty, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method DeleteAnnotation not implemented")
}
func (*UnimplementedWarehouseServer) IngestAsset(Warehouse_IngestAssetServer) error {
	return status1.Errorf(codes.Unimplemented, "method IngestAsset not implemented")
}
func (*UnimplementedWarehouseServer) ClipAsset(context.Context, *ClipAssetRequest) (*ClipAssetResponse, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method ClipAsset not implemented")
}
func (*UnimplementedWarehouseServer) GenerateHlsUri(context.Context, *GenerateHlsUriRequest) (*GenerateHlsUriResponse, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method GenerateHlsUri not implemented")
}
func (*UnimplementedWarehouseServer) CreateSearchConfig(context.Context, *CreateSearchConfigRequest) (*SearchConfig, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method CreateSearchConfig not implemented")
}
func (*UnimplementedWarehouseServer) UpdateSearchConfig(context.Context, *UpdateSearchConfigRequest) (*SearchConfig, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method UpdateSearchConfig not implemented")
}
func (*UnimplementedWarehouseServer) GetSearchConfig(context.Context, *GetSearchConfigRequest) (*SearchConfig, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method GetSearchConfig not implemented")
}
func (*UnimplementedWarehouseServer) DeleteSearchConfig(context.Context, *DeleteSearchConfigRequest) (*emptypb.Empty, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method DeleteSearchConfig not implemented")
}
func (*UnimplementedWarehouseServer) ListSearchConfigs(context.Context, *ListSearchConfigsRequest) (*ListSearchConfigsResponse, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method ListSearchConfigs not implemented")
}
func (*UnimplementedWarehouseServer) SearchAssets(context.Context, *SearchAssetsRequest) (*SearchAssetsResponse, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method SearchAssets not implemented")
}

func RegisterWarehouseServer(s *grpc.Server, srv WarehouseServer) {
	s.RegisterService(&_Warehouse_serviceDesc, srv)
}

func _Warehouse_CreateAsset_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateAssetRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(WarehouseServer).CreateAsset(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.visionai.v1alpha1.Warehouse/CreateAsset",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(WarehouseServer).CreateAsset(ctx, req.(*CreateAssetRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Warehouse_UpdateAsset_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateAssetRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(WarehouseServer).UpdateAsset(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.visionai.v1alpha1.Warehouse/UpdateAsset",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(WarehouseServer).UpdateAsset(ctx, req.(*UpdateAssetRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Warehouse_GetAsset_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetAssetRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(WarehouseServer).GetAsset(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.visionai.v1alpha1.Warehouse/GetAsset",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(WarehouseServer).GetAsset(ctx, req.(*GetAssetRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Warehouse_ListAssets_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListAssetsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(WarehouseServer).ListAssets(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.visionai.v1alpha1.Warehouse/ListAssets",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(WarehouseServer).ListAssets(ctx, req.(*ListAssetsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Warehouse_DeleteAsset_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteAssetRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(WarehouseServer).DeleteAsset(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.visionai.v1alpha1.Warehouse/DeleteAsset",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(WarehouseServer).DeleteAsset(ctx, req.(*DeleteAssetRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Warehouse_CreateCorpus_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateCorpusRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(WarehouseServer).CreateCorpus(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.visionai.v1alpha1.Warehouse/CreateCorpus",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(WarehouseServer).CreateCorpus(ctx, req.(*CreateCorpusRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Warehouse_GetCorpus_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetCorpusRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(WarehouseServer).GetCorpus(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.visionai.v1alpha1.Warehouse/GetCorpus",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(WarehouseServer).GetCorpus(ctx, req.(*GetCorpusRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Warehouse_UpdateCorpus_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateCorpusRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(WarehouseServer).UpdateCorpus(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.visionai.v1alpha1.Warehouse/UpdateCorpus",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(WarehouseServer).UpdateCorpus(ctx, req.(*UpdateCorpusRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Warehouse_ListCorpora_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListCorporaRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(WarehouseServer).ListCorpora(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.visionai.v1alpha1.Warehouse/ListCorpora",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(WarehouseServer).ListCorpora(ctx, req.(*ListCorporaRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Warehouse_DeleteCorpus_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteCorpusRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(WarehouseServer).DeleteCorpus(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.visionai.v1alpha1.Warehouse/DeleteCorpus",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(WarehouseServer).DeleteCorpus(ctx, req.(*DeleteCorpusRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Warehouse_CreateDataSchema_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateDataSchemaRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(WarehouseServer).CreateDataSchema(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.visionai.v1alpha1.Warehouse/CreateDataSchema",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(WarehouseServer).CreateDataSchema(ctx, req.(*CreateDataSchemaRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Warehouse_UpdateDataSchema_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateDataSchemaRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(WarehouseServer).UpdateDataSchema(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.visionai.v1alpha1.Warehouse/UpdateDataSchema",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(WarehouseServer).UpdateDataSchema(ctx, req.(*UpdateDataSchemaRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Warehouse_GetDataSchema_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetDataSchemaRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(WarehouseServer).GetDataSchema(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.visionai.v1alpha1.Warehouse/GetDataSchema",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(WarehouseServer).GetDataSchema(ctx, req.(*GetDataSchemaRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Warehouse_DeleteDataSchema_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteDataSchemaRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(WarehouseServer).DeleteDataSchema(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.visionai.v1alpha1.Warehouse/DeleteDataSchema",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(WarehouseServer).DeleteDataSchema(ctx, req.(*DeleteDataSchemaRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Warehouse_ListDataSchemas_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListDataSchemasRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(WarehouseServer).ListDataSchemas(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.visionai.v1alpha1.Warehouse/ListDataSchemas",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(WarehouseServer).ListDataSchemas(ctx, req.(*ListDataSchemasRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Warehouse_CreateAnnotation_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateAnnotationRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(WarehouseServer).CreateAnnotation(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.visionai.v1alpha1.Warehouse/CreateAnnotation",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(WarehouseServer).CreateAnnotation(ctx, req.(*CreateAnnotationRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Warehouse_GetAnnotation_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetAnnotationRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(WarehouseServer).GetAnnotation(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.visionai.v1alpha1.Warehouse/GetAnnotation",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(WarehouseServer).GetAnnotation(ctx, req.(*GetAnnotationRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Warehouse_ListAnnotations_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListAnnotationsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(WarehouseServer).ListAnnotations(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.visionai.v1alpha1.Warehouse/ListAnnotations",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(WarehouseServer).ListAnnotations(ctx, req.(*ListAnnotationsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Warehouse_UpdateAnnotation_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateAnnotationRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(WarehouseServer).UpdateAnnotation(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.visionai.v1alpha1.Warehouse/UpdateAnnotation",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(WarehouseServer).UpdateAnnotation(ctx, req.(*UpdateAnnotationRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Warehouse_DeleteAnnotation_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteAnnotationRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(WarehouseServer).DeleteAnnotation(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.visionai.v1alpha1.Warehouse/DeleteAnnotation",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(WarehouseServer).DeleteAnnotation(ctx, req.(*DeleteAnnotationRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Warehouse_IngestAsset_Handler(srv interface{}, stream grpc.ServerStream) error {
	return srv.(WarehouseServer).IngestAsset(&warehouseIngestAssetServer{stream})
}

type Warehouse_IngestAssetServer interface {
	Send(*IngestAssetResponse) error
	Recv() (*IngestAssetRequest, error)
	grpc.ServerStream
}

type warehouseIngestAssetServer struct {
	grpc.ServerStream
}

func (x *warehouseIngestAssetServer) Send(m *IngestAssetResponse) error {
	return x.ServerStream.SendMsg(m)
}

func (x *warehouseIngestAssetServer) Recv() (*IngestAssetRequest, error) {
	m := new(IngestAssetRequest)
	if err := x.ServerStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

func _Warehouse_ClipAsset_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ClipAssetRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(WarehouseServer).ClipAsset(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.visionai.v1alpha1.Warehouse/ClipAsset",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(WarehouseServer).ClipAsset(ctx, req.(*ClipAssetRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Warehouse_GenerateHlsUri_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GenerateHlsUriRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(WarehouseServer).GenerateHlsUri(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.visionai.v1alpha1.Warehouse/GenerateHlsUri",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(WarehouseServer).GenerateHlsUri(ctx, req.(*GenerateHlsUriRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Warehouse_CreateSearchConfig_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateSearchConfigRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(WarehouseServer).CreateSearchConfig(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.visionai.v1alpha1.Warehouse/CreateSearchConfig",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(WarehouseServer).CreateSearchConfig(ctx, req.(*CreateSearchConfigRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Warehouse_UpdateSearchConfig_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateSearchConfigRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(WarehouseServer).UpdateSearchConfig(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.visionai.v1alpha1.Warehouse/UpdateSearchConfig",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(WarehouseServer).UpdateSearchConfig(ctx, req.(*UpdateSearchConfigRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Warehouse_GetSearchConfig_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetSearchConfigRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(WarehouseServer).GetSearchConfig(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.visionai.v1alpha1.Warehouse/GetSearchConfig",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(WarehouseServer).GetSearchConfig(ctx, req.(*GetSearchConfigRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Warehouse_DeleteSearchConfig_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteSearchConfigRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(WarehouseServer).DeleteSearchConfig(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.visionai.v1alpha1.Warehouse/DeleteSearchConfig",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(WarehouseServer).DeleteSearchConfig(ctx, req.(*DeleteSearchConfigRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Warehouse_ListSearchConfigs_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListSearchConfigsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(WarehouseServer).ListSearchConfigs(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.visionai.v1alpha1.Warehouse/ListSearchConfigs",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(WarehouseServer).ListSearchConfigs(ctx, req.(*ListSearchConfigsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Warehouse_SearchAssets_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(SearchAssetsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(WarehouseServer).SearchAssets(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.visionai.v1alpha1.Warehouse/SearchAssets",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(WarehouseServer).SearchAssets(ctx, req.(*SearchAssetsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _Warehouse_serviceDesc = grpc.ServiceDesc{
	ServiceName: "google.cloud.visionai.v1alpha1.Warehouse",
	HandlerType: (*WarehouseServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "CreateAsset",
			Handler:    _Warehouse_CreateAsset_Handler,
		},
		{
			MethodName: "UpdateAsset",
			Handler:    _Warehouse_UpdateAsset_Handler,
		},
		{
			MethodName: "GetAsset",
			Handler:    _Warehouse_GetAsset_Handler,
		},
		{
			MethodName: "ListAssets",
			Handler:    _Warehouse_ListAssets_Handler,
		},
		{
			MethodName: "DeleteAsset",
			Handler:    _Warehouse_DeleteAsset_Handler,
		},
		{
			MethodName: "CreateCorpus",
			Handler:    _Warehouse_CreateCorpus_Handler,
		},
		{
			MethodName: "GetCorpus",
			Handler:    _Warehouse_GetCorpus_Handler,
		},
		{
			MethodName: "UpdateCorpus",
			Handler:    _Warehouse_UpdateCorpus_Handler,
		},
		{
			MethodName: "ListCorpora",
			Handler:    _Warehouse_ListCorpora_Handler,
		},
		{
			MethodName: "DeleteCorpus",
			Handler:    _Warehouse_DeleteCorpus_Handler,
		},
		{
			MethodName: "CreateDataSchema",
			Handler:    _Warehouse_CreateDataSchema_Handler,
		},
		{
			MethodName: "UpdateDataSchema",
			Handler:    _Warehouse_UpdateDataSchema_Handler,
		},
		{
			MethodName: "GetDataSchema",
			Handler:    _Warehouse_GetDataSchema_Handler,
		},
		{
			MethodName: "DeleteDataSchema",
			Handler:    _Warehouse_DeleteDataSchema_Handler,
		},
		{
			MethodName: "ListDataSchemas",
			Handler:    _Warehouse_ListDataSchemas_Handler,
		},
		{
			MethodName: "CreateAnnotation",
			Handler:    _Warehouse_CreateAnnotation_Handler,
		},
		{
			MethodName: "GetAnnotation",
			Handler:    _Warehouse_GetAnnotation_Handler,
		},
		{
			MethodName: "ListAnnotations",
			Handler:    _Warehouse_ListAnnotations_Handler,
		},
		{
			MethodName: "UpdateAnnotation",
			Handler:    _Warehouse_UpdateAnnotation_Handler,
		},
		{
			MethodName: "DeleteAnnotation",
			Handler:    _Warehouse_DeleteAnnotation_Handler,
		},
		{
			MethodName: "ClipAsset",
			Handler:    _Warehouse_ClipAsset_Handler,
		},
		{
			MethodName: "GenerateHlsUri",
			Handler:    _Warehouse_GenerateHlsUri_Handler,
		},
		{
			MethodName: "CreateSearchConfig",
			Handler:    _Warehouse_CreateSearchConfig_Handler,
		},
		{
			MethodName: "UpdateSearchConfig",
			Handler:    _Warehouse_UpdateSearchConfig_Handler,
		},
		{
			MethodName: "GetSearchConfig",
			Handler:    _Warehouse_GetSearchConfig_Handler,
		},
		{
			MethodName: "DeleteSearchConfig",
			Handler:    _Warehouse_DeleteSearchConfig_Handler,
		},
		{
			MethodName: "ListSearchConfigs",
			Handler:    _Warehouse_ListSearchConfigs_Handler,
		},
		{
			MethodName: "SearchAssets",
			Handler:    _Warehouse_SearchAssets_Handler,
		},
	},
	Streams: []grpc.StreamDesc{
		{
			StreamName:    "IngestAsset",
			Handler:       _Warehouse_IngestAsset_Handler,
			ServerStreams: true,
			ClientStreams: true,
		},
	},
	Metadata: "google/cloud/visionai/v1alpha1/warehouse.proto",
}
