/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.installer.config;

import com.install4j.api.beans.Anchor;
import com.install4j.api.beans.Bean;
import com.install4j.api.context.WizardIndex;
import com.install4j.api.screens.Screen;
import com.install4j.runtime.installer.config.AbstractBeanConfig;
import com.install4j.runtime.installer.config.ActionBeanConfig;
import com.install4j.runtime.installer.config.FormComponentBeanConfig;
import com.install4j.runtime.installer.config.GroupBeanConfig;
import com.install4j.runtime.installer.config.LinkActionBeanConfig;
import com.install4j.runtime.installer.config.LinkGroupBeanConfig;
import com.install4j.runtime.installer.helper.XmlHelper;
import java.io.File;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.w3c.dom.Element;

public class ScreenBeanConfig
extends AbstractBeanConfig {
    private Screen instance;
    private List actionConfigs;
    private List formComponentConfigs;
    private String preActivationClassName = "";
    private String postActivationClassName = "";
    private String validationClassName = "";
    private int backButtonType = 2;
    private boolean finishScreen = false;
    private int wizardIndexChangeType = 1;
    private String wizardIndexKey = "";
    private WizardIndex wizardIndex;

    public Screen getOrInstantiateScreen(boolean bl) {
        if (this.instance == null) {
            this.instance = (Screen)this.instantiateBean(bl);
        }
        return this.instance;
    }

    public int getBackButtonType() {
        return this.backButtonType;
    }

    public boolean isFinishScreen() {
        return this.finishScreen;
    }

    public String getPreActivationClassName() {
        return this.preActivationClassName;
    }

    public String getPostActivationClassName() {
        return this.postActivationClassName;
    }

    public String getValidationClassName() {
        return this.validationClassName;
    }

    public List getActionConfigs() {
        return this.actionConfigs;
    }

    public List getFormComponentConfigs() {
        return this.formComponentConfigs;
    }

    public int getWizardIndexChangeType() {
        return this.wizardIndexChangeType;
    }

    public String getWizardIndexKey() {
        return this.wizardIndexKey;
    }

    public WizardIndex getWizardIndex() {
        return this.wizardIndex;
    }

    public boolean isInstantiated() {
        return this.instance != null;
    }

    protected void setBean(Bean bean) {
        this.instance = (Screen)bean;
    }

    protected void read(Element element) {
        super.read(element);
        this.backButtonType = ScreenBeanConfig.readAttribute(element, "backButtonType", this.backButtonType);
        this.finishScreen = ScreenBeanConfig.readAttribute(element, "finishScreen", this.finishScreen);
        this.validationClassName = ScreenBeanConfig.readAttribute(element, "validationClass", this.validationClassName);
        this.preActivationClassName = ScreenBeanConfig.readAttribute(element, "preActivationClass", this.preActivationClassName);
        this.postActivationClassName = ScreenBeanConfig.readAttribute(element, "postActivationClass", this.postActivationClassName);
        this.wizardIndexChangeType = ScreenBeanConfig.readAttribute(element, "wizardIndexChangeType", this.wizardIndexChangeType);
        this.wizardIndexKey = ScreenBeanConfig.readAttribute(element, "wizardIndexKey", this.wizardIndexKey);
        this.readWizardIndex(element);
        this.readActionConfigs(element);
        this.readFormComponentConfigs(element);
    }

    private void readActionConfigs(Element element) {
        LinkedList<ActionBeanConfig> linkedList = new LinkedList<ActionBeanConfig>();
        Element element2 = ScreenBeanConfig.findChild(element, "actions");
        if (element2 != null) {
            Iterator iterator = ScreenBeanConfig.childElements(element2);
            while (iterator.hasNext()) {
                AbstractBeanConfig abstractBeanConfig;
                Element element3 = (Element)iterator.next();
                String string = element3.getTagName();
                if (string.equalsIgnoreCase("action")) {
                    abstractBeanConfig = new ActionBeanConfig();
                } else if (string.equalsIgnoreCase("group")) {
                    abstractBeanConfig = new GroupBeanConfig(false);
                } else if (string.equalsIgnoreCase("link")) {
                    abstractBeanConfig = ScreenBeanConfig.readAttribute(element3, "group", false) ? new LinkGroupBeanConfig(false) : new LinkActionBeanConfig();
                } else {
                    return;
                }
                ((AbstractBeanConfig)abstractBeanConfig).read(element3);
                linkedList.add((ActionBeanConfig)abstractBeanConfig);
            }
        }
        this.actionConfigs = Collections.unmodifiableList(linkedList);
    }

    private void readFormComponentConfigs(Element element) {
        LinkedList<FormComponentBeanConfig> linkedList = new LinkedList<FormComponentBeanConfig>();
        Element element2 = ScreenBeanConfig.findChild(element, "formComponents");
        if (element2 == null) {
            return;
        }
        Iterator iterator = ScreenBeanConfig.childElements(element2);
        while (iterator.hasNext()) {
            AbstractBeanConfig abstractBeanConfig;
            Element element3 = (Element)iterator.next();
            String string = element3.getTagName();
            if (string.equalsIgnoreCase("formComponent")) {
                abstractBeanConfig = new FormComponentBeanConfig();
            } else if (string.equalsIgnoreCase("group")) {
                abstractBeanConfig = new GroupBeanConfig(false);
            } else {
                return;
            }
            ((AbstractBeanConfig)abstractBeanConfig).read(element3);
            linkedList.add((FormComponentBeanConfig)abstractBeanConfig);
        }
        this.formComponentConfigs = Collections.unmodifiableList(linkedList);
    }

    private void readWizardIndex(Element element) {
        String string;
        Object object;
        Element element2 = XmlHelper.findChild(element, "wizardIndex");
        if (element2 == null) {
            return;
        }
        LinkedHashMap linkedHashMap = this.readWizardSteps(element2);
        if (linkedHashMap == null) {
            return;
        }
        int n = linkedHashMap.size();
        if (n == 0) {
            return;
        }
        String[] stringArray = new String[n];
        String[] stringArray2 = new String[n];
        int n2 = 0;
        Object object2 = linkedHashMap.entrySet().iterator();
        while (object2.hasNext()) {
            object = object2.next();
            stringArray[n2] = (String)object.getKey();
            stringArray2[n2] = (String)object.getValue();
            ++n2;
        }
        this.wizardIndex = new WizardIndex(stringArray2, stringArray);
        this.wizardIndex.partiallyDefined(ScreenBeanConfig.readAttribute(element2, "partiallyDefined", this.wizardIndex.isPartiallyDefined()));
        this.wizardIndex.maxWidth(ScreenBeanConfig.readAttribute(element2, "maxWidth", this.wizardIndex.getMaxWidth()));
        this.wizardIndex.minWidth(ScreenBeanConfig.readAttribute(element2, "minWidth", this.wizardIndex.getMinWidth()));
        this.wizardIndex.numbered(ScreenBeanConfig.readAttribute(element2, "numbered", this.wizardIndex.isNumbered()));
        this.wizardIndex.background(ScreenBeanConfig.readAttribute(element2, "background", this.wizardIndex.getBackground()));
        this.wizardIndex.foreground(ScreenBeanConfig.readAttribute(element2, "foreground", this.wizardIndex.getForeground()));
        object2 = ScreenBeanConfig.readFileAttribute(element2, "backgroundImage", null);
        if (object2 != null && ((String)object2).length() > 0) {
            this.wizardIndex.backgroundImage(new File((String)object2));
        }
        if ((object = Anchor.getByValue(ScreenBeanConfig.readAttribute(element2, "backgroundImageAnchor", this.wizardIndex.getBackgroundImageAnchor().getValue()))) != null) {
            this.wizardIndex.backgroundImageAnchor((Anchor)object);
        }
        if ((string = ScreenBeanConfig.readAttribute(element2, "initialKey", "")).length() > 0) {
            this.wizardIndex.initialKey(string);
        }
    }

    private LinkedHashMap readWizardSteps(Element element) {
        Element element2 = XmlHelper.findChild(element, "steps");
        LinkedHashMap<String, String> linkedHashMap = new LinkedHashMap<String, String>();
        if (element2 != null) {
            Iterator iterator = XmlHelper.childElements(element2);
            while (iterator.hasNext()) {
                Element element3 = (Element)iterator.next();
                String string = ScreenBeanConfig.readAttribute(element3, "key", "");
                String string2 = ScreenBeanConfig.readAttribute(element3, "name", "");
                if (string.length() <= 0 || string2.length() <= 0) continue;
                linkedHashMap.put(string, string2);
            }
        }
        return linkedHashMap;
    }

    public void addAllTo(Map map) {
        super.addAllTo(map);
        Iterator iterator = this.actionConfigs.iterator();
        while (iterator.hasNext()) {
            ((AbstractBeanConfig)iterator.next()).addAllTo(map);
        }
        if (this.formComponentConfigs != null) {
            iterator = this.formComponentConfigs.iterator();
            while (iterator.hasNext()) {
                ((AbstractBeanConfig)iterator.next()).addAllTo(map);
            }
        }
    }
}

