/* $Id: hash.h,v 1.1.1.1 2004/09/21 15:56:43 iscjonm Exp $
 *
 * Copyright (C) 2004 The Trustees of the University of Pennsylvania
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#ifndef _HASH_H
#define _HASH_H

struct list_elem {
  struct list_elem *next;
  unsigned int key;
  void *item;
};

typedef struct {
  unsigned int sz;
  struct list_elem **t;
} hash_table_t;

hash_table_t *hash_new(int num_items);
int hash_put(hash_table_t *t, unsigned int key, void *item);
void *hash_lookup(hash_table_t *t, unsigned int key);

#endif
