#include <stdlib.h>
#include <stdint.h>
#include <stdio.h>
#include <string.h>

#include "strophe.h"
#include "resolver.h"

void xmpp_initialize(void);

void cbtest_handle_start(char *name, char **attrs, void *userdata)
{
    (void)name;
    (void)attrs;
    (void)userdata;
}

void cbtest_handle_end(char *name, void *userdata)
{
    (void)name;
    (void)userdata;
}

void cbtest_handle_stanza(xmpp_stanza_t *stanza, void *userdata)
{
    (void)stanza;
    (void)userdata;
}

/* res_query("_xmpp-client._tcp.jabber.org", C_IN, T_SRV, ...) */
static const unsigned char data2[] = {
    0xf2, 0x98, 0x81, 0x80, 0x00, 0x01, 0x00, 0x02, 0x00, 0x00, 0x00, 0x00,
    0x0c, 0x5f, 0x78, 0x6d, 0x70, 0x70, 0x2d, 0x63, 0x6c, 0x69, 0x65, 0x6e,
    0x74, 0x04, 0x5f, 0x74, 0x63, 0x70, 0x06, 0x6a, 0x61, 0x62, 0x62, 0x65,
    0x72, 0x03, 0x6f, 0x72, 0x67, 0x00, 0x00, 0x21, 0x00, 0x01, 0xc0, 0x0c,
    0x00, 0x21, 0x00, 0x01, 0x00, 0x00, 0x03, 0x83, 0x00, 0x1a, 0x00, 0x1e,
    0x00, 0x1e, 0x14, 0x66, 0x07, 0x68, 0x65, 0x72, 0x6d, 0x65, 0x73, 0x32,
    0x06, 0x6a, 0x61, 0x62, 0x62, 0x65, 0x72, 0x03, 0x6f, 0x72, 0x67, 0x00,
    0xc0, 0x0c, 0x00, 0x21, 0x00, 0x01, 0x00, 0x00, 0x03, 0x83, 0x00, 0x1c,
    0x00, 0x1f, 0x00, 0x1e, 0x14, 0x66, 0x09, 0x68, 0x65, 0x72, 0x6d, 0x65,
    0x73, 0x32, 0x76, 0x36, 0x06, 0x6a, 0x61, 0x62, 0x62, 0x65, 0x72, 0x03,
    0x6f, 0x72, 0x67, 0x00,
};

int LLVMFuzzerTestOneInput(const uint8_t *Data, size_t Size)
{
    xmpp_ctx_t *ctx;
    resolver_srv_rr_t *srv_rr_list;

    unsigned char *dup = malloc(Size + 64);
    memcpy(dup, data2, 64);
    memcpy(&dup[64], Data, Size);

    ctx = xmpp_ctx_new(NULL, NULL);
    resolver_srv_lookup_buf(ctx, dup, 64 + Size, &srv_rr_list);
    if (srv_rr_list != NULL)
        resolver_srv_free(ctx, srv_rr_list);

    free(dup);
    xmpp_ctx_free(ctx);

    return 0;
}
