/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.textmate.language.syntax;

import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.textmate.Constants;
import org.jetbrains.plugins.textmate.language.TextMateInterner;
import org.jetbrains.plugins.textmate.language.syntax.SyntaxIncludeRawNode;
import org.jetbrains.plugins.textmate.language.syntax.SyntaxNodeDescriptor;
import org.jetbrains.plugins.textmate.language.syntax.SyntaxRawNode;
import org.jetbrains.plugins.textmate.language.syntax.SyntaxRawNodeImpl;
import org.jetbrains.plugins.textmate.language.syntax.TextMateRawCapture;
import org.jetbrains.plugins.textmate.language.syntax.TextMateSyntaxTableCore;
import org.jetbrains.plugins.textmate.plist.PListValue;
import org.jetbrains.plugins.textmate.plist.Plist;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0010\r\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\f\u001a\u0004\u0018\u00010\n2\u0006\u0010\r\u001a\u00020\u000eJ\u0006\u0010\u000f\u001a\u00020\u0010J\u001a\u0010\u0011\u001a\u00020\u00122\u0006\u0010\r\u001a\u00020\u000e2\b\u0010\u0013\u001a\u0004\u0018\u00010\u000bH\u0002J\u0018\u0010\u0014\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0013\u001a\u00020\u0012H\u0002J)\u0010\u0015\u001a\f\u0012\u0006\u0012\u0004\u0018\u00010\u0017\u0018\u00010\u00162\u0006\u0010\u0018\u001a\u00020\u000e2\b\u0010\u0019\u001a\u0004\u0018\u00010\u000bH\u0002\u00a2\u0006\u0002\u0010\u001aR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lorg/jetbrains/plugins/textmate/language/syntax/TextMateSyntaxTableBuilder;", "", "interner", "Lorg/jetbrains/plugins/textmate/language/TextMateInterner;", "<init>", "(Lorg/jetbrains/plugins/textmate/language/TextMateInterner;)V", "currentRuleId", "Ljava/util/concurrent/atomic/AtomicInteger;", "syntaxNodes", "", "", "Lorg/jetbrains/plugins/textmate/language/syntax/SyntaxRawNode;", "addSyntax", "plist", "Lorg/jetbrains/plugins/textmate/plist/Plist;", "build", "Lorg/jetbrains/plugins/textmate/language/syntax/TextMateSyntaxTableCore;", "loadRealNode", "Lorg/jetbrains/plugins/textmate/language/syntax/SyntaxRawNodeImpl;", "parentBuilder", "loadNestedSyntax", "loadCaptures", "", "Lorg/jetbrains/plugins/textmate/language/syntax/TextMateRawCapture;", "captures", "parent", "(Lorg/jetbrains/plugins/textmate/plist/Plist;Lorg/jetbrains/plugins/textmate/language/syntax/SyntaxRawNode;)[Lorg/jetbrains/plugins/textmate/language/syntax/TextMateRawCapture;", "intellij.textmate.core"})
@SourceDebugExtension(value={"SMAP\nTextMateSyntaxTableBuilder.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TextMateSyntaxTableBuilder.kt\norg/jetbrains/plugins/textmate/language/syntax/TextMateSyntaxTableBuilder\n+ 2 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,324:1\n216#2,2:325\n1863#3,2:327\n1863#3,2:329\n1863#3,2:331\n1863#3,2:333\n1863#3,2:335\n1863#3,2:337\n*S KotlinDebug\n*F\n+ 1 TextMateSyntaxTableBuilder.kt\norg/jetbrains/plugins/textmate/language/syntax/TextMateSyntaxTableBuilder\n*L\n40#1:325,2\n49#1:327,2\n84#1:329,2\n89#1:331,2\n94#1:333,2\n117#1:335,2\n134#1:337,2\n*E\n"})
public final class TextMateSyntaxTableBuilder {
    @NotNull
    private final TextMateInterner interner;
    @NotNull
    private final AtomicInteger currentRuleId;
    @NotNull
    private final Map<CharSequence, SyntaxRawNode> syntaxNodes;

    public TextMateSyntaxTableBuilder(@NotNull TextMateInterner interner) {
        Intrinsics.checkNotNullParameter((Object)interner, (String)"interner");
        this.interner = interner;
        this.currentRuleId = new AtomicInteger(0);
        this.syntaxNodes = new ConcurrentHashMap();
    }

    @Nullable
    public final CharSequence addSyntax(@NotNull Plist plist) {
        Intrinsics.checkNotNullParameter((Object)plist, (String)"plist");
        SyntaxRawNodeImpl topLevelNode = this.loadRealNode(plist, null);
        CharSequence scopeName = topLevelNode.getScopeName();
        if (scopeName != null) {
            this.syntaxNodes.put(scopeName, topLevelNode);
        }
        return scopeName;
    }

    @NotNull
    public final TextMateSyntaxTableCore build() {
        Map ruleIdToReferenceRuleId = new LinkedHashMap();
        Map compiledRules = new LinkedHashMap();
        Map rules = new LinkedHashMap();
        TextMateSyntaxTableCore syntaxTable = new TextMateSyntaxTableCore(rules);
        Map<CharSequence, SyntaxRawNode> $this$forEach$iv = this.syntaxNodes;
        boolean $i$f$forEach = false;
        Iterator<Map.Entry<CharSequence, SyntaxRawNode>> iterator = $this$forEach$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<CharSequence, SyntaxRawNode> element$iv;
            Map.Entry<CharSequence, SyntaxRawNode> entry = element$iv = iterator.next();
            boolean bl = false;
            CharSequence scopeName = entry.getKey();
            SyntaxRawNode nodeBuilder = entry.getValue();
            SyntaxNodeDescriptor syntaxNodeDescriptor = nodeBuilder.compile(this.syntaxNodes, compiledRules, ruleIdToReferenceRuleId, syntaxTable);
            if (syntaxNodeDescriptor == null) continue;
            SyntaxNodeDescriptor compiledNode = syntaxNodeDescriptor;
            boolean bl2 = false;
            rules.put(scopeName, compiledNode);
        }
        SyntaxNodeDescriptor[] rulesRepository = new SyntaxNodeDescriptor[ruleIdToReferenceRuleId.size()];
        Iterable $this$forEach$iv2 = ruleIdToReferenceRuleId.entrySet();
        boolean $i$f$forEach2 = false;
        for (Object element$iv : $this$forEach$iv2) {
            Map.Entry it = (Map.Entry)element$iv;
            boolean bl = false;
            rulesRepository[((Number)it.getValue()).intValue()] = compiledRules.get(it.getKey());
        }
        syntaxTable.setRulesRepository$intellij_textmate_core(rulesRepository);
        return syntaxTable;
    }

    private final SyntaxRawNodeImpl loadRealNode(Plist plist, SyntaxRawNode parentBuilder) {
        PListValue scopeNamePlistValue;
        PListValue pListValue = scopeNamePlistValue = plist.getPlistValue(Constants.StringKey.SCOPE_NAME.getValue());
        String scopeNameValue = pListValue != null ? pListValue.getString() : null;
        CharSequence scopeName = scopeNameValue != null ? (CharSequence)this.interner.intern(scopeNameValue) : null;
        int ruleId = this.currentRuleId.getAndIncrement();
        SyntaxRawNodeImpl result = new SyntaxRawNodeImpl(ruleId, parentBuilder, scopeName);
        for (Map.Entry<String, PListValue> entry : plist.entries()) {
            PListValue value;
            String key;
            Map.Entry entry2;
            Iterable $this$forEach$iv;
            PListValue pListValue2 = entry.getValue();
            if (pListValue2 == null) continue;
            String key2 = entry.getKey();
            Constants.StringKey stringKey = Constants.StringKey.Companion.fromName(key2);
            if (stringKey != null) {
                if (pListValue2.getString() != null) {
                    String stringValue;
                    boolean bl = false;
                    result.setStringAttribute(stringKey, this.interner.intern(stringValue));
                }
                continue;
            }
            Constants.CaptureKey captureKey = Constants.CaptureKey.Companion.fromName(key2);
            if (captureKey != null) {
                if (this.loadCaptures(pListValue2.getPlist(), result) != null) {
                    TextMateRawCapture[] captures;
                    boolean bl = false;
                    result.setCaptures(captureKey, captures);
                }
                continue;
            }
            if (StringsKt.equals((String)"repository", (String)key2, (boolean)true)) {
                $this$forEach$iv = pListValue2.getPlist().entries();
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    entry2 = (Map.Entry)element$iv;
                    boolean bl = false;
                    key = (String)entry2.getKey();
                    value = (PListValue)entry2.getValue();
                    result.appendRepository(key, this.loadNestedSyntax(value.getPlist(), result));
                }
                continue;
            }
            if (StringsKt.equals((String)"patterns", (String)key2, (boolean)true)) {
                $this$forEach$iv = pListValue2.getArray();
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    PListValue value2 = (PListValue)element$iv;
                    boolean bl = false;
                    result.addChild(this.loadNestedSyntax(value2.getPlist(), result));
                }
                continue;
            }
            if (!StringsKt.equals((String)"injections", (String)key2, (boolean)true)) continue;
            $this$forEach$iv = pListValue2.getPlist().entries();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                entry2 = (Map.Entry)element$iv;
                boolean bl = false;
                key = (String)entry2.getKey();
                value = (PListValue)entry2.getValue();
                result.addInjection(key, this.loadRealNode(value.getPlist(), result));
            }
        }
        return result;
    }

    private final SyntaxRawNode loadNestedSyntax(Plist plist, SyntaxRawNodeImpl parentBuilder) {
        PListValue pListValue = plist.getPlistValue("include");
        String include = pListValue != null ? pListValue.getString() : null;
        return include != null ? (SyntaxRawNode)new SyntaxIncludeRawNode(this.currentRuleId.getAndIncrement(), parentBuilder, include) : (SyntaxRawNode)this.loadRealNode(plist, parentBuilder);
    }

    private final TextMateRawCapture[] loadCaptures(Plist captures, SyntaxRawNode parent) {
        Map map = new LinkedHashMap();
        int maxGroupIndex = 0;
        maxGroupIndex = -1;
        Iterable $this$forEach$iv = captures.entries();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Map.Entry entry = (Map.Entry)element$iv;
            boolean bl = false;
            String key = (String)entry.getKey();
            PListValue value = (PListValue)entry.getValue();
            Integer n = StringsKt.toIntOrNull((String)key);
            if (n == null) continue;
            int index = ((Number)n).intValue();
            boolean bl2 = false;
            Plist captureDict = value.getPlist();
            PListValue captureName = captureDict.getPlistValue("name");
            if (captureName != null) {
                Integer n2 = index;
                String string = captureName.getString();
                if (string == null) {
                    string = "";
                }
                v3 = map.put(n2, new TextMateRawCapture.Name(this.interner.intern(string)));
            } else {
                v3 = map.put(index, new TextMateRawCapture.Rule(this.loadRealNode(captureDict, parent)));
            }
            maxGroupIndex = Math.max(maxGroupIndex, index);
        }
        if (maxGroupIndex < 0 || map.isEmpty()) {
            return null;
        }
        TextMateRawCapture[] result = new TextMateRawCapture[maxGroupIndex + 1];
        Iterable $this$forEach$iv2 = map.entrySet();
        boolean $i$f$forEach2 = false;
        for (Object element$iv : $this$forEach$iv2) {
            Map.Entry e = (Map.Entry)element$iv;
            boolean bl = false;
            result[((Number)e.getKey()).intValue()] = e.getValue();
        }
        return result;
    }
}

