/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.grazie.utils;

import ai.grazie.nlp.utils.WhiteSpacesKt;
import com.intellij.grazie.text.TextContent;
import com.intellij.grazie.utils.Text;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.util.TextRange;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.ReplaceWith;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import kotlinx.html.ApiKt;
import kotlinx.html.BODY;
import kotlinx.html.Entities;
import kotlinx.html.FlowContent;
import kotlinx.html.HTML;
import kotlinx.html.TABLE;
import kotlinx.html.TD;
import kotlinx.html.Tag;
import kotlinx.html.TagConsumer;
import kotlinx.html.stream.StreamKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000^\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\"\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\f\n\u0002\b\u0003\u001a\u001f\u0010\u0000\u001a\u00020\u00012\u0017\u0010\u0002\u001a\u0013\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003\u00a2\u0006\u0002\b\u0006\u001a\n\u0010\u0017\u001a\u00020\u0005*\u00020\u0018\u001a\u0016\u0010!\u001a\b\u0012\u0004\u0012\u00020#0\"2\b\u0010$\u001a\u0004\u0018\u00010#\u001a\u0014\u0010%\u001a\u0004\u0018\u00010#2\b\u0010&\u001a\u0004\u0018\u00010#H\u0007\u001a\u000e\u0010(\u001a\u00020)2\u0006\u0010*\u001a\u00020\u0001\u001a$\u0010+\u001a\u0004\u0018\u00010#2\b\u0010$\u001a\u0004\u0018\u00010#2\u0006\u0010,\u001a\u00020\u001a2\u0006\u0010-\u001a\u00020.H\u0002\u001a\u0012\u0010/\u001a\u0004\u0018\u00010#2\b\u0010$\u001a\u0004\u0018\u00010#\u001a\u0012\u00100\u001a\u0004\u0018\u00010#2\b\u0010$\u001a\u0004\u0018\u00010#\"(\u0010\b\u001a\u00020\u0001*\u00020\t2\u0006\u0010\u0007\u001a\u00020\u00018F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\r\"(\u0010\u000e\u001a\u00020\u0001*\u00020\t2\u0006\u0010\u0007\u001a\u00020\u00018F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\u000f\u0010\u000b\"\u0004\b\u0010\u0010\r\"(\u0010\u0011\u001a\u00020\u0001*\u00020\u00122\u0006\u0010\u0007\u001a\u00020\u00018F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\u0013\u0010\u0014\"\u0004\b\u0015\u0010\u0016\"\u0018\u0010\u0019\u001a\n \u001b*\u0004\u0018\u00010\u001a0\u001aX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u001c\"\u0018\u0010\u001d\u001a\n \u001b*\u0004\u0018\u00010\u001a0\u001aX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u001c\"\u0016\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u00010\u001f8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\"\u0014\u0010 \u001a\b\u0012\u0004\u0012\u00020\u00010\u001fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u0018\u0010\u0017\u001a\n \u001b*\u0004\u0018\u00010\u001a0\u001aX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u001c\"\u0018\u0010'\u001a\n \u001b*\u0004\u0018\u00010\u001a0\u001aX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u001c\u00a8\u00061"}, d2={"html", "", "body", "Lkotlin/Function1;", "Lkotlinx/html/BODY;", "", "Lkotlin/ExtensionFunctionType;", "value", "cellpading", "Lkotlinx/html/TABLE;", "getCellpading", "(Lkotlinx/html/TABLE;)Ljava/lang/String;", "setCellpading", "(Lkotlinx/html/TABLE;Ljava/lang/String;)V", "cellspacing", "getCellspacing", "setCellspacing", "valign", "Lkotlinx/html/TD;", "getValign", "(Lkotlinx/html/TD;)Ljava/lang/String;", "setValign", "(Lkotlinx/html/TD;Ljava/lang/String;)V", "nbsp", "Lkotlinx/html/FlowContent;", "anyTag", "Ljava/util/regex/Pattern;", "kotlin.jvm.PlatformType", "Ljava/util/regex/Pattern;", "closingTag", "commonBlockElements", "", "commonMarkupElements", "excludeHtml", "", "Lcom/intellij/grazie/text/TextContent;", "content", "removeHtml", "_content", "tab", "isSpaceEntity", "", "text", "inlineEntity", "pattern", "space", "", "inlineSpaceEntities", "nbspToSpace", "intellij.grazie.core"})
@SourceDebugExtension(value={"SMAP\nHtmlUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 HtmlUtils.kt\ncom/intellij/grazie/utils/HtmlUtilsKt\n+ 2 gen-consumer-tags.kt\nkotlinx/html/Gen_consumer_tagsKt\n+ 3 api.kt\nkotlinx/html/ApiKt\n+ 4 visit.kt\nkotlinx/html/VisitKt\n+ 5 gen-tags-h.kt\nkotlinx/html/Gen_tags_hKt\n+ 6 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 7 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,149:1\n782#2,7:150\n79#3:157\n76#3:170\n10#4,5:158\n4#4,2:163\n6#4,2:171\n15#4:174\n200#5,5:165\n205#5:173\n1#6:175\n1#6:186\n1611#7,9:176\n1863#7:185\n1864#7:187\n1620#7:188\n388#7,7:189\n*S KotlinDebug\n*F\n+ 1 HtmlUtils.kt\ncom/intellij/grazie/utils/HtmlUtilsKt\n*L\n14#1:150,7\n14#1:157\n14#1:170\n14#1:158,5\n14#1:163,2\n14#1:171,2\n14#1:174\n14#1:165,5\n14#1:173\n70#1:186\n70#1:176,9\n70#1:185\n70#1:187\n70#1:188\n94#1:189,7\n*E\n"})
public final class HtmlUtilsKt {
    private static final Pattern anyTag = Pattern.compile("</?(\\w+)[^>]*>");
    private static final Pattern closingTag = Pattern.compile("</\\w+\\s*>");
    @JvmField
    @NotNull
    public static final Set<String> commonBlockElements;
    @NotNull
    private static final Set<String> commonMarkupElements;
    private static final Pattern nbsp;
    private static final Pattern tab;

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final String html(@NotNull Function1<? super BODY, Unit> body) {
        void $this$visitAndFinalize$iv$iv;
        Intrinsics.checkNotNullParameter(body, (String)"body");
        TagConsumer $this$html_u24default$iv = StreamKt.createHTML$default((boolean)false, (boolean)false, (int)2, null);
        String namespace$iv = null;
        boolean $i$f$html = false;
        Tag tag = (Tag)new HTML(ApiKt.getEmptyMap(), $this$html_u24default$iv, namespace$iv);
        boolean $i$f$visitAndFinalize = false;
        void $this$visitTagAndFinalize$iv$iv$iv = $this$visitAndFinalize$iv$iv;
        boolean $i$f$visitTagAndFinalize = false;
        if ($this$visitTagAndFinalize$iv$iv$iv.getConsumer() != $this$html_u24default$iv) {
            throw new IllegalArgumentException("Wrong exception");
        }
        void $this$visitTag$iv$iv$iv$iv = $this$visitTagAndFinalize$iv$iv$iv;
        boolean $i$f$visitTag = false;
        $this$visitTag$iv$iv$iv$iv.getConsumer().onTagStart((Tag)$this$visitTag$iv$iv$iv$iv);
        void $this$visitAndFinalize_u24lambda_u241$iv$iv = $this$visitTag$iv$iv$iv$iv;
        boolean bl = false;
        HTML $this$html_u24lambda_u241 = (HTML)$this$visitAndFinalize_u24lambda_u241$iv$iv;
        boolean bl2 = false;
        HTML $this$body_u24default$iv = $this$html_u24lambda_u241;
        String classes$iv = null;
        boolean $i$f$body = false;
        Tag $this$visit$iv$iv = (Tag)new BODY(ApiKt.attributesMapOf((String)"class", classes$iv), $this$body_u24default$iv.getConsumer());
        boolean $i$f$visit = false;
        Tag $this$visitTag$iv$iv$iv = $this$visit$iv$iv;
        boolean $i$f$visitTag2 = false;
        $this$visitTag$iv$iv$iv.getConsumer().onTagStart($this$visitTag$iv$iv$iv);
        Tag $this$visit_u24lambda_u240$iv$iv = $this$visitTag$iv$iv$iv;
        boolean bl3 = false;
        BODY $this$html_u24lambda_u241_u24lambda_u240 = (BODY)$this$visit_u24lambda_u240$iv$iv;
        boolean bl4 = false;
        body.invoke((Object)$this$html_u24lambda_u241_u24lambda_u240);
        $this$visitTag$iv$iv$iv.getConsumer().onTagEnd($this$visitTag$iv$iv$iv);
        $this$visitTag$iv$iv$iv$iv.getConsumer().onTagEnd((Tag)$this$visitTag$iv$iv$iv$iv);
        return (String)$this$html_u24default$iv.finalize();
    }

    @NotNull
    public static final String getCellpading(@NotNull TABLE $this$cellpading) {
        Intrinsics.checkNotNullParameter((Object)$this$cellpading, (String)"<this>");
        String string2 = (String)$this$cellpading.getAttributes().get((Object)"cellpadding");
        if (string2 == null) {
            string2 = "";
        }
        return string2;
    }

    public static final void setCellpading(@NotNull TABLE $this$cellpading, @NotNull String value) {
        Intrinsics.checkNotNullParameter((Object)$this$cellpading, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        ((Map)$this$cellpading.getAttributes()).put("cellpadding", value);
    }

    @NotNull
    public static final String getCellspacing(@NotNull TABLE $this$cellspacing) {
        Intrinsics.checkNotNullParameter((Object)$this$cellspacing, (String)"<this>");
        String string2 = (String)$this$cellspacing.getAttributes().get((Object)"cellspacing");
        if (string2 == null) {
            string2 = "";
        }
        return string2;
    }

    public static final void setCellspacing(@NotNull TABLE $this$cellspacing, @NotNull String value) {
        Intrinsics.checkNotNullParameter((Object)$this$cellspacing, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        ((Map)$this$cellspacing.getAttributes()).put("cellspacing", value);
    }

    @NotNull
    public static final String getValign(@NotNull TD $this$valign) {
        Intrinsics.checkNotNullParameter((Object)$this$valign, (String)"<this>");
        String string2 = (String)$this$valign.getAttributes().get((Object)"valign");
        if (string2 == null) {
            string2 = "";
        }
        return string2;
    }

    public static final void setValign(@NotNull TD $this$valign, @NotNull String value) {
        Intrinsics.checkNotNullParameter((Object)$this$valign, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        ((Map)$this$valign.getAttributes()).put("valign", value);
    }

    public static final void nbsp(@NotNull FlowContent $this$nbsp) {
        Intrinsics.checkNotNullParameter((Object)$this$nbsp, (String)"<this>");
        $this$nbsp.unaryPlus(Entities.nbsp);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final List<TextContent> excludeHtml(@Nullable TextContent content) {
        void $this$mapNotNullTo$iv$iv;
        Object p0;
        if (content == null) {
            return CollectionsKt.emptyList();
        }
        ArrayList<TextContent> components = new ArrayList<TextContent>();
        int lastComponentStart = 0;
        int matchEnd = 0;
        Matcher matcher = anyTag.matcher(content);
        while (matcher.find(matchEnd)) {
            matchEnd = matcher.end();
            ProgressManager.checkCanceled();
            String tagName = matcher.group(1);
            if (!commonBlockElements.contains(tagName)) continue;
            if (content.subText(new TextRange(lastComponentStart, matcher.start())) != null) {
                TextContent p02;
                boolean bl = false;
                components.add(p02);
            }
            lastComponentStart = matcher.end();
        }
        TextContent textContent = content.subText(new TextRange(lastComponentStart, content.length()));
        if (textContent != null) {
            p0 = textContent;
            boolean bl = false;
            components.add((TextContent)p0);
        }
        Iterable $this$mapNotNull$iv = components;
        boolean $i$f$mapNotNull = false;
        p0 = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            TextContent it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            TextContent it = (TextContent)element$iv$iv;
            boolean bl2 = false;
            TextContent textContent2 = HtmlUtilsKt.removeHtml(it);
            if ((textContent2 != null ? textContent2.trimWhitespace() : null) == null) continue;
            it$iv$iv = it$iv$iv;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    @Deprecated(message="use excludeHtml", replaceWith=@ReplaceWith(expression="excludeHtml", imports={}))
    @Nullable
    public static final TextContent removeHtml(@Nullable TextContent _content) {
        Ref.ObjectRef content = new Ref.ObjectRef();
        TextContent textContent = _content;
        if (textContent == null) {
            return null;
        }
        content.element = textContent;
        while (StringsKt.startsWith$default((CharSequence)((CharSequence)content.element), (CharSequence)"<html>", (boolean)false, (int)2, null) || StringsKt.startsWith$default((CharSequence)((CharSequence)content.element), (CharSequence)"<body>", (boolean)false, (int)2, null)) {
            content.element = ((TextContent)content.element).excludeRange(new TextRange(0, 6));
        }
        while (StringsKt.endsWith$default((CharSequence)((CharSequence)content.element), (CharSequence)"</html>", (boolean)false, (int)2, null) || StringsKt.endsWith$default((CharSequence)((CharSequence)content.element), (CharSequence)"</body>", (boolean)false, (int)2, null)) {
            content.element = ((TextContent)content.element).excludeRange(TextRange.from((int)(((TextContent)content.element).length() - 7), (int)7));
        }
        ArrayList<TextContent.Exclusion> exclusions = new ArrayList<TextContent.Exclusion>();
        int matchEnd = 0;
        Matcher matcher = anyTag.matcher((CharSequence)content.element);
        while (matcher.find(matchEnd)) {
            TextContent.ExclusionKind exclusionKind;
            matchEnd = matcher.end();
            ProgressManager.checkCanceled();
            int matchStart = matcher.start();
            String tagName = matcher.group(1);
            if (!Character.isLetterOrDigit(tagName.charAt(0))) continue;
            TextContent.ExclusionKind exclusionKind2 = exclusionKind = commonMarkupElements.contains(tagName) ? TextContent.ExclusionKind.markup : TextContent.ExclusionKind.unknown;
            if (closingTag.matcher(((TextContent)content.element).subSequence(matchStart, matchEnd)).matches()) {
                exclusions.add(new TextContent.Exclusion(matchStart, matchEnd, exclusionKind));
                HtmlUtilsKt.removeHtml$tagClosed(exclusions, (Ref.ObjectRef<TextContent>)content, ((Object)StringsKt.trim((CharSequence)((Object)((CharSequence)content.element).subSequence(matchStart + 2, matchEnd - 1)).toString())).toString());
                continue;
            }
            exclusions.add(new TextContent.Exclusion(matchStart, matchEnd, exclusionKind));
        }
        return ((TextContent)content.element).excludeRanges((List<TextContent.Exclusion>)exclusions);
    }

    public static final boolean isSpaceEntity(@NotNull String text2) {
        Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
        return Intrinsics.areEqual((Object)text2, (Object)nbsp.pattern()) || Intrinsics.areEqual((Object)text2, (Object)tab.pattern());
    }

    private static final TextContent inlineEntity(TextContent content, Pattern pattern, char space) {
        if (content == null) {
            return null;
        }
        List<TextRange> spaces = Text.allOccurrences(pattern, content);
        if (spaces.isEmpty()) {
            return content.trimWhitespace();
        }
        ArrayList<TextContent> components = new ArrayList<TextContent>();
        int n = ((Collection)spaces).size();
        for (int i = 0; i < n; ++i) {
            int prevEnd = i == 0 ? 0 : spaces.get(i - 1).getEndOffset();
            TextContent textContent = content.subText(new TextRange(prevEnd, spaces.get(i).getStartOffset()));
            components.add(textContent != null ? textContent.trimWhitespace() : null);
        }
        TextContent textContent = content.subText(new TextRange(((TextRange)CollectionsKt.last(spaces)).getEndOffset(), content.length()));
        components.add(textContent != null ? textContent.trimWhitespace() : null);
        return TextContent.joinWithWhitespace(space, CollectionsKt.filterNotNull((Iterable)components));
    }

    @Nullable
    public static final TextContent inlineSpaceEntities(@Nullable TextContent content) {
        TextContent textContent = HtmlUtilsKt.nbspToSpace(content);
        Pattern pattern = tab;
        Intrinsics.checkNotNullExpressionValue((Object)pattern, (String)"tab");
        return HtmlUtilsKt.inlineEntity(textContent, pattern, '\t');
    }

    @Nullable
    public static final TextContent nbspToSpace(@Nullable TextContent content) {
        Pattern pattern = nbsp;
        Intrinsics.checkNotNullExpressionValue((Object)pattern, (String)"nbsp");
        return HtmlUtilsKt.inlineEntity(content, pattern, '\u00a0');
    }

    private static final String removeHtml$openingTagName(Ref.ObjectRef<TextContent> content, int tagRangeStart, int tagRangeEnd) {
        return Character.isLetter(((TextContent)content.element).charAt(tagRangeStart + 1)) ? WhiteSpacesKt.takeNonWhitespaces(((Object)((CharSequence)content.element).subSequence(tagRangeStart + 1, tagRangeEnd - 1)).toString()) : null;
    }

    private static final void removeHtml$tagClosed(ArrayList<TextContent.Exclusion> exclusions, Ref.ObjectRef<TextContent> content, String tagName) {
        int openingIndex;
        block3: {
            int n;
            if (commonMarkupElements.contains(tagName)) {
                return;
            }
            List $this$indexOfLast$iv = exclusions;
            boolean $i$f$indexOfLast = false;
            ListIterator iterator$iv = $this$indexOfLast$iv.listIterator($this$indexOfLast$iv.size());
            while (iterator$iv.hasPrevious()) {
                TextContent.Exclusion it = (TextContent.Exclusion)iterator$iv.previous();
                boolean bl = false;
                if (!(Intrinsics.areEqual((Object)HtmlUtilsKt.removeHtml$openingTagName(content, it.start, it.end), (Object)tagName) && ((TextContent)content.element).charAt(it.end - 2) != '/')) continue;
                n = iterator$iv.nextIndex();
                break block3;
            }
            n = openingIndex = -1;
        }
        if (openingIndex >= 0) {
            exclusions.set(openingIndex, TextContent.Exclusion.markUnknown(new TextRange(exclusions.get((int)openingIndex).start, ((TextContent.Exclusion)CollectionsKt.last((List)((List)exclusions))).end)));
            exclusions.subList(openingIndex + 1, exclusions.size()).clear();
        }
    }

    static {
        Object[] objectArray = new String[]{"body", "p", "br", "td", "li", "title", "h1", "h2", "h3", "h4", "h5", "h6", "hr", "table", "ol", "ul"};
        commonBlockElements = SetsKt.setOf((Object[])objectArray);
        objectArray = new String[]{"span", "i", "b", "u", "font", "a", "s", "strong", "sub", "sup"};
        commonMarkupElements = SetsKt.setOf((Object[])objectArray);
        nbsp = Pattern.compile("&nbsp;");
        tab = Pattern.compile("&#9;");
    }
}

