/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.newProject.steps;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.target.TargetEnvironmentConfiguration;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.ValidationInfo;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.util.ExtensionsKt;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.TextAccessor;
import com.intellij.util.PathMappingSettings;
import com.intellij.util.ui.FormBuilder;
import com.jetbrains.python.PyBundle;
import com.jetbrains.python.PySdkBundle;
import com.jetbrains.python.Result;
import com.jetbrains.python.newProject.collector.InterpreterStatisticsInfo;
import com.jetbrains.python.newProject.steps.PyRemotePathField;
import com.jetbrains.python.newProject.steps.PySdkChooserKt;
import com.jetbrains.python.remote.PyProjectSynchronizer;
import com.jetbrains.python.remote.PyProjectSynchronizerProvider;
import com.jetbrains.python.remote.PythonSshInterpreterManager;
import com.jetbrains.python.run.PythonInterpreterTargetEnvironmentFactory;
import com.jetbrains.python.sdk.PySdkExtKt;
import com.jetbrains.python.sdk.PythonSdkUtil;
import com.jetbrains.python.sdk.add.PyAddSdkPanel;
import com.jetbrains.python.statistics.PyStatisticToolsKt;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.Supplier;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\b\u0000\u0018\u0000 22\u00020\u0001:\u00012B=\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u0012\b\u0010\t\u001a\u0004\u0018\u00010\n\u0012\b\u0010\u000b\u001a\u0004\u0018\u00010\b\u00a2\u0006\u0004\b\f\u0010\rJ\u0012\u0010$\u001a\u00020%2\b\u0010&\u001a\u0004\u0018\u00010'H\u0002J\n\u0010(\u001a\u0004\u0018\u00010)H\u0016J\u000e\u0010*\u001a\b\u0012\u0004\u0012\u00020+0\u0007H\u0016J\u0010\u0010,\u001a\u00020\u001b2\u0006\u0010-\u001a\u00020\u001aH\u0016J\n\u0010.\u001a\u0004\u0018\u00010+H\u0002J\n\u0010/\u001a\u0004\u0018\u00010+H\u0002J\b\u00100\u001a\u00020\u001bH\u0002J\b\u00101\u001a\u00020\u001bH\u0002R\u0014\u0010\u000e\u001a\u00020\n8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010R\u0016\u0010\u0011\u001a\n\u0012\u0004\u0012\u00020\u0012\u0018\u00010\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0013\u001a\u0004\u0018\u00010\b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015R\u0012\u0010\u0016\u001a\u0006\u0012\u0002\b\u00030\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0018\u001a\u000e\u0012\u0004\u0012\u00020\u001a\u0012\u0004\u0012\u00020\u001b0\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u001c\u001a\u0004\u0018\u00010\n8F\u00a2\u0006\u0006\u001a\u0004\b\u001d\u0010\u0010R(\u0010\t\u001a\u0004\u0018\u00010\n2\b\u0010\u001e\u001a\u0004\u0018\u00010\n@VX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001f\u0010\u0010\"\u0004\b \u0010!R\u000e\u0010\"\u001a\u00020#X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00063"}, d2={"Lcom/jetbrains/python/newProject/steps/PyAddExistingSdkPanel;", "Lcom/jetbrains/python/sdk/add/PyAddSdkPanel;", "project", "Lcom/intellij/openapi/project/Project;", "module", "Lcom/intellij/openapi/module/Module;", "existingSdks", "", "Lcom/intellij/openapi/projectRoots/Sdk;", "newProjectPath", "", "preferredSdk", "<init>", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/openapi/module/Module;Ljava/util/List;Ljava/lang/String;Lcom/intellij/openapi/projectRoots/Sdk;)V", "panelName", "getPanelName", "()Ljava/lang/String;", "defaultMappings", "Lcom/intellij/util/PathMappingSettings$PathMapping;", "sdk", "getSdk", "()Lcom/intellij/openapi/projectRoots/Sdk;", "sdkComboBox", "Ljavax/swing/JComboBox;", "addSdkChangedListener", "Lkotlin/Function1;", "Ljava/lang/Runnable;", "", "remotePath", "getRemotePath", "value", "getNewProjectPath", "setNewProjectPath", "(Ljava/lang/String;)V", "remotePathField", "Lcom/jetbrains/python/newProject/steps/PyRemotePathField;", "needAssociateConfigurationWithModule", "", "configuration", "Lcom/intellij/execution/target/TargetEnvironmentConfiguration;", "getStatisticInfo", "Lcom/jetbrains/python/newProject/collector/InterpreterStatisticsInfo;", "validateAll", "Lcom/intellij/openapi/ui/ValidationInfo;", "addChangeListener", "listener", "validateSdkChooserField", "validateRemotePathField", "update", "updateRemotePathIfNeeded", "Companion", "intellij.python.community.impl"})
@SourceDebugExtension(value={"SMAP\nPyAddExistingSdkPanel.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PyAddExistingSdkPanel.kt\ncom/jetbrains/python/newProject/steps/PyAddExistingSdkPanel\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,213:1\n774#2:214\n865#2,2:215\n295#2,2:217\n1#3:219\n*S KotlinDebug\n*F\n+ 1 PyAddExistingSdkPanel.kt\ncom/jetbrains/python/newProject/steps/PyAddExistingSdkPanel\n*L\n84#1:214\n84#1:215,2\n87#1:217,2\n*E\n"})
public final class PyAddExistingSdkPanel
extends PyAddSdkPanel {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private List<? extends PathMappingSettings.PathMapping> defaultMappings;
    @NotNull
    private final JComboBox<?> sdkComboBox;
    @NotNull
    private final Function1<Runnable, Unit> addSdkChangedListener;
    @Nullable
    private String newProjectPath;
    @NotNull
    private final PyRemotePathField remotePathField;

    /*
     * WARNING - void declaration
     */
    public PyAddExistingSdkPanel(@Nullable Project project, @Nullable Module module, @NotNull List<? extends Sdk> existingSdks, @Nullable String newProjectPath, @Nullable Sdk preferredSdk) {
        Object v0;
        JComponent interpreterComponent;
        List sdksForNewProject;
        block2: {
            void $this$filterTo$iv$iv;
            void $this$remotePathField_u24lambda_u241;
            PyRemotePathField pyRemotePathField;
            Intrinsics.checkNotNullParameter(existingSdks, (String)"existingSdks");
            this.newProjectPath = newProjectPath;
            PyRemotePathField pyRemotePathField2 = pyRemotePathField = new PyRemotePathField();
            PyAddExistingSdkPanel pyAddExistingSdkPanel = this;
            boolean bl = false;
            $this$remotePathField_u24lambda_u241.addActionListener(arg_0 -> PyAddExistingSdkPanel.remotePathField$lambda$1$lambda$0(this, (PyRemotePathField)$this$remotePathField_u24lambda_u241, arg_0));
            pyAddExistingSdkPanel.remotePathField = pyRemotePathField;
            this.setLayout(new BorderLayout());
            Iterable $this$filter$iv = existingSdks;
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                Sdk it = (Sdk)element$iv$iv;
                boolean bl2 = false;
                if (!(PySdkExtKt.getAssociatedModulePath(it) == null && !this.needAssociateConfigurationWithModule(PySdkExtKt.getTargetEnvConfiguration(it)))) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            sdksForNewProject = (List)destination$iv$iv;
            interpreterComponent = null;
            Iterable $this$firstOrNull$iv = sdksForNewProject;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                Sdk it = (Sdk)element$iv;
                boolean bl3 = false;
                if (!Intrinsics.areEqual((Object)it, (Object)preferredSdk)) continue;
                v0 = element$iv;
                break block2;
            }
            v0 = null;
        }
        Sdk preselectedSdk = v0;
        ComboBox<Sdk> pythonSdkComboBox = PySdkChooserKt.createPythonSdkComboBox(sdksForNewProject, preselectedSdk);
        pythonSdkComboBox.addActionListener(arg_0 -> PyAddExistingSdkPanel._init_$lambda$4(this, arg_0));
        interpreterComponent = PySdkChooserKt.withAddInterpreterLink(pythonSdkComboBox, project, module);
        this.sdkComboBox = (JComboBox)pythonSdkComboBox;
        this.addSdkChangedListener = arg_0 -> PyAddExistingSdkPanel._init_$lambda$6(this, arg_0);
        JPanel formPanel = FormBuilder.createFormBuilder().addLabeledComponent(PySdkBundle.message("python.interpreter.label", new Object[0]), interpreterComponent).addComponent((JComponent)this.remotePathField.getMainPanel()).getPanel();
        this.add((Component)formPanel, "North");
        this.update();
    }

    @Override
    @NotNull
    public String getPanelName() {
        String string = PyBundle.message("python.add.sdk.panel.name.previously.configured.interpreter", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        return string;
    }

    @Override
    @Nullable
    public Sdk getSdk() {
        Object object = this.sdkComboBox.getSelectedItem();
        return object instanceof Sdk ? (Sdk)object : null;
    }

    @Nullable
    public final String getRemotePath() {
        return this.remotePathField.getMainPanel().isVisible() ? this.remotePathField.getTextField().getText() : null;
    }

    @Override
    @Nullable
    public String getNewProjectPath() {
        return this.newProjectPath;
    }

    @Override
    public void setNewProjectPath(@Nullable String value) {
        this.newProjectPath = value;
        this.updateRemotePathIfNeeded();
    }

    private final boolean needAssociateConfigurationWithModule(TargetEnvironmentConfiguration configuration) {
        if (configuration == null) {
            return false;
        }
        PythonInterpreterTargetEnvironmentFactory pythonInterpreterTargetEnvironmentFactory = PythonInterpreterTargetEnvironmentFactory.Companion.by(configuration);
        return pythonInterpreterTargetEnvironmentFactory != null ? pythonInterpreterTargetEnvironmentFactory.needAssociateWithModule() : false;
    }

    @Override
    @Nullable
    public InterpreterStatisticsInfo getStatisticInfo() {
        Sdk sdk2 = this.getSdk();
        if (sdk2 == null) {
            return null;
        }
        Sdk sdk3 = sdk2;
        return new InterpreterStatisticsInfo(PyStatisticToolsKt.getInterpreterType(sdk3), PyStatisticToolsKt.getExecutionType(sdk3), false, false, true, false, null, 96, null);
    }

    @Override
    @NotNull
    public List<ValidationInfo> validateAll() {
        Object[] objectArray = new ValidationInfo[]{this.validateSdkChooserField(), this.validateRemotePathField()};
        return CollectionsKt.filterNotNull((Iterable)CollectionsKt.listOf((Object[])objectArray));
    }

    @Override
    public void addChangeListener(@NotNull Runnable listener2) {
        Intrinsics.checkNotNullParameter((Object)listener2, (String)"listener");
        this.addSdkChangedListener.invoke((Object)listener2);
        this.remotePathField.addTextChangeListener(() -> PyAddExistingSdkPanel.addChangeListener$lambda$7(listener2));
    }

    private final ValidationInfo validateSdkChooserField() {
        String string;
        Sdk selectedSdk = this.getSdk();
        if (selectedSdk == null) {
            string = PyBundle.message("python.sdk.no.interpreter.selection", new Object[0]);
        } else if (!PySdkExtKt.getSdkSeemsValid(selectedSdk)) {
            string = PyBundle.message("python.sdk.choose.valid.interpreter", new Object[0]);
        } else {
            return null;
        }
        String string2 = string;
        Intrinsics.checkNotNull((Object)string2);
        String message = string2;
        return new ValidationInfo(message, (JComponent)this.sdkComboBox);
    }

    private final ValidationInfo validateRemotePathField() {
        String path2 = this.getRemotePath();
        return path2 != null && StringsKt.isBlank((CharSequence)path2) ? new ValidationInfo(PyBundle.message("python.new.project.remote.path.not.provided", new Object[0])) : null;
    }

    private final void update() {
        Sdk sdk2 = this.getSdk();
        PyProjectSynchronizer synchronizer = sdk2 != null ? PyAddExistingSdkPanel.Companion.getProjectSynchronizer(sdk2) : null;
        this.remotePathField.getMainPanel().setVisible(synchronizer != null);
        if (synchronizer != null) {
            boolean bl;
            String defaultRemotePath = synchronizer.getDefaultRemotePath();
            Result<List<PathMappingSettings.PathMapping>, String> result2 = synchronizer.getAutoMappings();
            if (result2 != null) {
                Result<List<PathMappingSettings.PathMapping>, String> it = result2;
                boolean bl2 = false;
                Result<List<PathMappingSettings.PathMapping>, String> result3 = it;
                if (result3 instanceof Result.Success) {
                    this.defaultMappings = (List)((Result.Success)it).getResult();
                } else {
                    if (result3 instanceof Result.Failure) {
                        this.remotePathField.getTextField().setText((String)((Result.Failure)it).getError());
                        this.remotePathField.setReadOnly(true);
                        return;
                    }
                    throw new NoWhenBranchMatchedException();
                }
            }
            boolean bl3 = bl = defaultRemotePath == null || this.defaultMappings == null;
            if (_Assertions.ENABLED && !bl) {
                boolean $i$a$-assert-PyAddExistingSdkPanel$update$42 = false;
                String $i$a$-assert-PyAddExistingSdkPanel$update$42 = "Can't have both: default mappings and default value";
                throw new AssertionError((Object)$i$a$-assert-PyAddExistingSdkPanel$update$42);
            }
            String string = defaultRemotePath;
            boolean bl4 = bl = !(string != null ? ((CharSequence)string).length() == 0 : false);
            if (_Assertions.ENABLED && !bl) {
                boolean bl5 = false;
                String string2 = "Mappings are empty";
                throw new AssertionError((Object)string2);
            }
            TextAccessor textAccessor = this.remotePathField.getTextField();
            Intrinsics.checkNotNullExpressionValue((Object)textAccessor, (String)"getTextField(...)");
            TextAccessor textField = textAccessor;
            if (defaultRemotePath != null && StringUtil.isEmpty((String)textField.getText())) {
                textField.setText(defaultRemotePath);
            }
        }
        this.remotePathField.setReadOnly(this.defaultMappings != null);
        this.updateRemotePathIfNeeded();
    }

    private final void updateRemotePathIfNeeded() {
        Object object;
        Object v2;
        TextAccessor textAccessor;
        String path2;
        block4: {
            String string = this.getNewProjectPath();
            if (string == null) {
                return;
            }
            path2 = string;
            List<? extends PathMappingSettings.PathMapping> list = this.defaultMappings;
            if (list == null) {
                return;
            }
            List<? extends PathMappingSettings.PathMapping> mappings = list;
            Iterable iterable = mappings;
            textAccessor = this.remotePathField.getTextField();
            Iterable iterable2 = iterable;
            for (Object t : iterable2) {
                PathMappingSettings.PathMapping it = (PathMappingSettings.PathMapping)t;
                boolean bl = false;
                if (!it.canReplaceLocal(path2)) continue;
                v2 = t;
                break block4;
            }
            v2 = null;
        }
        if ((object = (PathMappingSettings.PathMapping)v2) == null || (object = object.mapToRemote(path2)) == null) {
            object = "?";
        }
        textAccessor.setText((String)object);
    }

    private static final void remotePathField$lambda$1$lambda$0(PyAddExistingSdkPanel this$0, PyRemotePathField $this_apply, ActionEvent it) {
        Sdk sdk2 = this$0.getSdk();
        if (sdk2 == null) {
            return;
        }
        Sdk currentSdk = sdk2;
        if (!PythonSdkUtil.isRemote(currentSdk)) {
            return;
        }
        TextAccessor textAccessor = $this_apply.getTextField();
        Container container = this$0.getParent();
        Intrinsics.checkNotNullExpressionValue((Object)container, (String)"getParent(...)");
        String string = PyAddExistingSdkPanel.Companion.chooseRemotePath(currentSdk, container);
        if (string == null) {
            return;
        }
        textAccessor.setText(string);
    }

    private static final void _init_$lambda$4(PyAddExistingSdkPanel this$0, ActionEvent it) {
        this$0.update();
    }

    private static final void lambda$6$lambda$5(Runnable $runnable, ActionEvent it) {
        $runnable.run();
    }

    private static final Unit _init_$lambda$6(PyAddExistingSdkPanel this$0, Runnable runnable) {
        Intrinsics.checkNotNullParameter((Object)runnable, (String)"runnable");
        ((ComboBox)this$0.sdkComboBox).addActionListener(arg_0 -> PyAddExistingSdkPanel.lambda$6$lambda$5(runnable, arg_0));
        return Unit.INSTANCE;
    }

    private static final void addChangeListener$lambda$7(Runnable $listener) {
        $listener.run();
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\t\u001a\u0004\u0018\u00010\n*\u00020\u00062\u0006\u0010\u000b\u001a\u00020\fH\u0002R\u001a\u0010\u0004\u001a\u0004\u0018\u00010\u0005*\u00020\u00068BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\r"}, d2={"Lcom/jetbrains/python/newProject/steps/PyAddExistingSdkPanel$Companion;", "", "<init>", "()V", "projectSynchronizer", "Lcom/jetbrains/python/remote/PyProjectSynchronizer;", "Lcom/intellij/openapi/projectRoots/Sdk;", "getProjectSynchronizer", "(Lcom/intellij/openapi/projectRoots/Sdk;)Lcom/jetbrains/python/remote/PyProjectSynchronizer;", "chooseRemotePath", "", "owner", "Ljava/awt/Component;", "intellij.python.community.impl"})
    public static final class Companion {
        private Companion() {
        }

        private final PyProjectSynchronizer getProjectSynchronizer(Sdk $this$projectSynchronizer) {
            return PyProjectSynchronizerProvider.Companion.getSynchronizer($this$projectSynchronizer);
        }

        private final String chooseRemotePath(Sdk $this$chooseRemotePath, Component owner) {
            Pair<Supplier<String>, JPanel> pair;
            PythonSshInterpreterManager pythonSshInterpreterManager = PythonSshInterpreterManager.Factory.getInstance();
            if (pythonSshInterpreterManager == null) {
                return null;
            }
            PythonSshInterpreterManager remoteManager = pythonSshInterpreterManager;
            try {
                Pair<Supplier<String>, JPanel> pair2 = remoteManager.createServerBrowserForm($this$chooseRemotePath);
                if (pair2 == null) {
                    return null;
                }
                pair = pair2;
            }
            catch (Exception e) {
                Exception exception = e;
                if (exception instanceof ExecutionException || exception instanceof InterruptedException) {
                    Logger.getInstance(PyAddExistingSdkPanel.class).warn("Failed to create server browse button", (Throwable)e);
                    JBPopupFactory.getInstance().createMessage(PyBundle.message("remote.interpreter.remote.server.permissions", new Object[0])).show(owner);
                    return null;
                }
                throw e;
            }
            Pair<Supplier<String>, JPanel> pair3 = pair;
            Supplier supplier = (Supplier)ExtensionsKt.component1(pair3);
            JPanel panel2 = (JPanel)ExtensionsKt.component2(pair3);
            panel2.setVisible(true);
            DialogWrapper wrapper2 = new DialogWrapper(panel2){
                final /* synthetic */ JPanel $panel;
                {
                    this.$panel = $panel;
                    super(true);
                    this.init();
                }

                protected JPanel createCenterPanel() {
                    return this.$panel;
                }
            };
            return wrapper2.showAndGet() ? (String)supplier.get() : null;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

