/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sh.run;

import com.intellij.execution.Executor;
import com.intellij.execution.configuration.EnvironmentVariablesData;
import com.intellij.execution.configurations.ConfigurationFactory;
import com.intellij.execution.configurations.LocatableConfigurationBase;
import com.intellij.execution.configurations.RefactoringListenerProvider;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.configurations.RunProfileState;
import com.intellij.execution.configurations.RuntimeConfigurationError;
import com.intellij.execution.configurations.RuntimeConfigurationException;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.openapi.options.SettingsEditor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.JDOMExternalizerUtil;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.util.text.StringUtilRt;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.refactoring.listeners.RefactoringElementAdapter;
import com.intellij.refactoring.listeners.RefactoringElementListener;
import com.intellij.sh.ShBundle;
import com.intellij.sh.psi.ShFile;
import com.intellij.sh.run.ShRunConfigurationEditor;
import com.intellij.sh.run.ShRunConfigurationProfileState;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ShRunConfiguration
extends LocatableConfigurationBase
implements RefactoringListenerProvider {
    @NonNls
    private static final String TAG_PREFIX = "INDEPENDENT_";
    @NonNls
    private static final String SCRIPT_TEXT_TAG = "SCRIPT_TEXT";
    @NonNls
    private static final String SCRIPT_PATH_TAG = "SCRIPT_PATH";
    @NonNls
    private static final String SCRIPT_OPTIONS_TAG = "SCRIPT_OPTIONS";
    @NonNls
    private static final String SCRIPT_WORKING_DIRECTORY_TAG = "SCRIPT_WORKING_DIRECTORY";
    @NonNls
    private static final String INTERPRETER_PATH_TAG = "INTERPRETER_PATH";
    @NonNls
    private static final String INTERPRETER_OPTIONS_TAG = "INTERPRETER_OPTIONS";
    @NonNls
    private static final String EXECUTE_IN_TERMINAL_TAG = "EXECUTE_IN_TERMINAL";
    @NonNls
    private static final String EXECUTE_SCRIPT_FILE_TAG = "EXECUTE_SCRIPT_FILE";
    private String myScriptText;
    private String myScriptPath;
    private String myScriptOptions;
    private String myInterpreterPath;
    private String myInterpreterOptions;
    private String myScriptWorkingDirectory;
    private boolean myExecuteInTerminal;
    private boolean myExecuteScriptFile;
    private EnvironmentVariablesData myEnvData;

    ShRunConfiguration(@NotNull Project project, @NotNull ConfigurationFactory factory, @NotNull String name) {
        if (project == null) {
            ShRunConfiguration.$$$reportNull$$$0(0);
        }
        if (factory == null) {
            ShRunConfiguration.$$$reportNull$$$0(1);
        }
        if (name == null) {
            ShRunConfiguration.$$$reportNull$$$0(2);
        }
        super(project, factory, name);
        this.myScriptText = "";
        this.myScriptPath = "";
        this.myScriptOptions = "";
        this.myInterpreterPath = "";
        this.myInterpreterOptions = "";
        this.myScriptWorkingDirectory = "";
        this.myExecuteInTerminal = true;
        this.myExecuteScriptFile = true;
        this.myEnvData = EnvironmentVariablesData.DEFAULT;
    }

    @NotNull
    public SettingsEditor<? extends RunConfiguration> getConfigurationEditor() {
        return new ShRunConfigurationEditor(this.getProject());
    }

    public void checkConfiguration() throws RuntimeConfigurationException {
        Path scriptPath = Path.of(this.myScriptPath, new String[0]);
        if (this.myExecuteScriptFile) {
            if (!Files.exists(scriptPath, new LinkOption[0])) {
                throw new RuntimeConfigurationError(ShBundle.message("sh.run.script.not.found", new Object[0]));
            }
            if (StringUtil.isNotEmpty((String)this.myInterpreterPath) || !Files.isExecutable(scriptPath)) {
                Path interpreterPath = Path.of(this.myInterpreterPath, new String[0]);
                if (!Files.exists(interpreterPath, new LinkOption[0])) {
                    throw new RuntimeConfigurationError(ShBundle.message("sh.run.interpreter.not.found", new Object[0]));
                }
                if (!Files.isExecutable(interpreterPath)) {
                    throw new RuntimeConfigurationError(ShBundle.message("sh.run.interpreter.should.be.executable", new Object[0]));
                }
            }
        }
        if (!Files.exists(Path.of(this.myScriptWorkingDirectory, new String[0]), new LinkOption[0])) {
            throw new RuntimeConfigurationError(ShBundle.message("sh.run.working.dir.not.found", new Object[0]));
        }
    }

    @NotNull
    public RunProfileState getState(@NotNull Executor executor, @NotNull ExecutionEnvironment environment) {
        if (executor == null) {
            ShRunConfiguration.$$$reportNull$$$0(3);
        }
        if (environment == null) {
            ShRunConfiguration.$$$reportNull$$$0(4);
        }
        return new ShRunConfigurationProfileState(environment.getProject(), this);
    }

    public void writeExternal(@NotNull Element element) {
        if (element == null) {
            ShRunConfiguration.$$$reportNull$$$0(5);
        }
        super.writeExternal(element);
        JDOMExternalizerUtil.writeField((Element)element, (String)SCRIPT_TEXT_TAG, (String)this.myScriptText);
        ShRunConfiguration.writePathWithMetadata(element, this.myScriptPath, SCRIPT_PATH_TAG);
        JDOMExternalizerUtil.writeField((Element)element, (String)SCRIPT_OPTIONS_TAG, (String)this.myScriptOptions);
        ShRunConfiguration.writePathWithMetadata(element, this.myScriptWorkingDirectory, SCRIPT_WORKING_DIRECTORY_TAG);
        ShRunConfiguration.writePathWithMetadata(element, this.myInterpreterPath, INTERPRETER_PATH_TAG);
        JDOMExternalizerUtil.writeField((Element)element, (String)INTERPRETER_OPTIONS_TAG, (String)this.myInterpreterOptions);
        JDOMExternalizerUtil.writeField((Element)element, (String)EXECUTE_IN_TERMINAL_TAG, (String)String.valueOf(this.myExecuteInTerminal));
        JDOMExternalizerUtil.writeField((Element)element, (String)EXECUTE_SCRIPT_FILE_TAG, (String)String.valueOf(this.myExecuteScriptFile));
        this.myEnvData.writeExternal(element);
    }

    public void readExternal(@NotNull Element element) throws InvalidDataException {
        if (element == null) {
            ShRunConfiguration.$$$reportNull$$$0(6);
        }
        super.readExternal(element);
        this.myScriptText = ShRunConfiguration.readStringTagValue(element, SCRIPT_TEXT_TAG);
        this.myScriptPath = ShRunConfiguration.readPathWithMetadata(element, SCRIPT_PATH_TAG);
        this.myScriptOptions = ShRunConfiguration.readStringTagValue(element, SCRIPT_OPTIONS_TAG);
        this.myScriptWorkingDirectory = ShRunConfiguration.readPathWithMetadata(element, SCRIPT_WORKING_DIRECTORY_TAG);
        this.myInterpreterPath = ShRunConfiguration.readPathWithMetadata(element, INTERPRETER_PATH_TAG);
        this.myInterpreterOptions = ShRunConfiguration.readStringTagValue(element, INTERPRETER_OPTIONS_TAG);
        this.myExecuteInTerminal = Boolean.parseBoolean(JDOMExternalizerUtil.readField((Element)element, (String)EXECUTE_IN_TERMINAL_TAG, (String)Boolean.TRUE.toString()));
        this.myExecuteScriptFile = Boolean.parseBoolean(JDOMExternalizerUtil.readField((Element)element, (String)EXECUTE_SCRIPT_FILE_TAG, (String)Boolean.TRUE.toString()));
        this.myEnvData = EnvironmentVariablesData.readExternal((Element)element);
    }

    @Nullable
    public RefactoringElementListener getRefactoringElementListener(PsiElement element) {
        if (StringUtil.isEmpty((String)this.myScriptPath) || !(element instanceof ShFile) || !this.myScriptPath.equals(ShRunConfiguration.getPathByElement(element))) {
            return null;
        }
        return new RefactoringElementAdapter(){

            protected void elementRenamedOrMoved(@NotNull PsiElement newElement) {
                if (newElement == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (newElement instanceof ShFile) {
                    ShRunConfiguration.this.setScriptPath(((ShFile)newElement).getVirtualFile().getPath());
                }
            }

            public void undoElementMovedOrRenamed(@NotNull PsiElement newElement, @NotNull String oldQualifiedName) {
                if (newElement == null) {
                    1.$$$reportNull$$$0(1);
                }
                if (oldQualifiedName == null) {
                    1.$$$reportNull$$$0(2);
                }
                this.elementRenamedOrMoved(newElement);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "newElement";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "oldQualifiedName";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/sh/run/ShRunConfiguration$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "elementRenamedOrMoved";
                        break;
                    }
                    case 1: 
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[2] = "undoElementMovedOrRenamed";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
    }

    @Nullable
    private static String getPathByElement(@NotNull PsiElement element) {
        VirtualFile vfile;
        if (element == null) {
            ShRunConfiguration.$$$reportNull$$$0(7);
        }
        if ((vfile = PsiUtilCore.getVirtualFile((PsiElement)element)) == null) {
            return null;
        }
        return vfile.getPath();
    }

    private static void writePathWithMetadata(@NotNull Element element, @NotNull String path, @NotNull String pathTag) {
        if (element == null) {
            ShRunConfiguration.$$$reportNull$$$0(8);
        }
        if (path == null) {
            ShRunConfiguration.$$$reportNull$$$0(9);
        }
        if (pathTag == null) {
            ShRunConfiguration.$$$reportNull$$$0(10);
        }
        String systemIndependentPath = FileUtil.toSystemIndependentName((String)path);
        JDOMExternalizerUtil.writeField((Element)element, (String)(TAG_PREFIX + pathTag), (String)Boolean.toString(systemIndependentPath.equals(path)));
        JDOMExternalizerUtil.writeField((Element)element, (String)pathTag, (String)systemIndependentPath);
    }

    private static String readPathWithMetadata(@NotNull Element element, @NotNull String pathTag) {
        if (element == null) {
            ShRunConfiguration.$$$reportNull$$$0(11);
        }
        if (pathTag == null) {
            ShRunConfiguration.$$$reportNull$$$0(12);
        }
        return Boolean.parseBoolean(JDOMExternalizerUtil.readField((Element)element, (String)(TAG_PREFIX + pathTag))) ? ShRunConfiguration.readStringTagValue(element, pathTag) : FileUtil.toSystemDependentName((String)ShRunConfiguration.readStringTagValue(element, pathTag));
    }

    @NotNull
    private static String readStringTagValue(@NotNull Element element, @NotNull String tagName) {
        if (element == null) {
            ShRunConfiguration.$$$reportNull$$$0(13);
        }
        if (tagName == null) {
            ShRunConfiguration.$$$reportNull$$$0(14);
        }
        String string = StringUtilRt.notNullize((String)JDOMExternalizerUtil.readField((Element)element, (String)tagName), (String)"");
        if (string == null) {
            ShRunConfiguration.$$$reportNull$$$0(15);
        }
        return string;
    }

    public String getScriptText() {
        return this.myScriptText;
    }

    public void setScriptText(String scriptText) {
        this.myScriptText = scriptText;
    }

    public String getScriptPath() {
        return this.myScriptPath;
    }

    public void setScriptPath(@NotNull String scriptPath) {
        if (scriptPath == null) {
            ShRunConfiguration.$$$reportNull$$$0(16);
        }
        this.myScriptPath = scriptPath.trim();
    }

    public String getScriptOptions() {
        return this.myScriptOptions;
    }

    public void setScriptOptions(@NotNull String scriptOptions) {
        if (scriptOptions == null) {
            ShRunConfiguration.$$$reportNull$$$0(17);
        }
        this.myScriptOptions = scriptOptions.trim();
    }

    public String getScriptWorkingDirectory() {
        return this.myScriptWorkingDirectory;
    }

    public void setScriptWorkingDirectory(String scriptWorkingDirectory) {
        this.myScriptWorkingDirectory = scriptWorkingDirectory.trim();
    }

    public boolean isExecuteInTerminal() {
        return this.myExecuteInTerminal;
    }

    public void setExecuteInTerminal(boolean executeInTerminal) {
        this.myExecuteInTerminal = executeInTerminal;
    }

    public boolean isExecuteScriptFile() {
        return this.myExecuteScriptFile;
    }

    public void setExecuteScriptFile(boolean executeScriptFile) {
        this.myExecuteScriptFile = executeScriptFile;
    }

    public EnvironmentVariablesData getEnvData() {
        return this.myEnvData;
    }

    public void setEnvData(EnvironmentVariablesData envData) {
        this.myEnvData = envData;
    }

    public String getInterpreterPath() {
        return this.myInterpreterPath;
    }

    public void setInterpreterPath(@NotNull String interpreterPath) {
        if (interpreterPath == null) {
            ShRunConfiguration.$$$reportNull$$$0(18);
        }
        this.myInterpreterPath = interpreterPath.trim();
    }

    public String getInterpreterOptions() {
        return this.myInterpreterOptions;
    }

    public void setInterpreterOptions(@NotNull String interpreterOptions) {
        if (interpreterOptions == null) {
            ShRunConfiguration.$$$reportNull$$$0(19);
        }
        this.myInterpreterOptions = interpreterOptions.trim();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 15 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "factory";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "executor";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "environment";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 11: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 10: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pathTag";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tagName";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/sh/run/ShRunConfiguration";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scriptPath";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scriptOptions";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "interpreterPath";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "interpreterOptions";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/sh/run/ShRunConfiguration";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "readStringTagValue";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getState";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "writeExternal";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "readExternal";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getPathByElement";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "writePathWithMetadata";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "readPathWithMetadata";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "readStringTagValue";
                break;
            }
            case 15: {
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "setScriptPath";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "setScriptOptions";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "setInterpreterPath";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "setInterpreterOptions";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 15 -> new IllegalStateException(string);
        };
    }
}

