// Copyright 2023 Google LLC.
// Use of this source code is governed by a BSD-style
// license that can be found in the LICENSE file.

// Code generated file. DO NOT EDIT.

// Package analyticsadmin provides access to the Google Analytics Admin API.
//
// For product documentation, see: http://code.google.com/apis/analytics/docs/mgmt/home.html
//
// # Creating a client
//
// Usage example:
//
//	import "google.golang.org/api/analyticsadmin/v1alpha"
//	...
//	ctx := context.Background()
//	analyticsadminService, err := analyticsadmin.NewService(ctx)
//
// In this example, Google Application Default Credentials are used for authentication.
//
// For information on how to create and obtain Application Default Credentials, see https://developers.google.com/identity/protocols/application-default-credentials.
//
// # Other authentication options
//
// By default, all available scopes (see "Constants") are used to authenticate. To restrict scopes, use option.WithScopes:
//
//	analyticsadminService, err := analyticsadmin.NewService(ctx, option.WithScopes(analyticsadmin.AnalyticsReadonlyScope))
//
// To use an API key for authentication (note: some APIs do not support API keys), use option.WithAPIKey:
//
//	analyticsadminService, err := analyticsadmin.NewService(ctx, option.WithAPIKey("AIza..."))
//
// To use an OAuth token (e.g., a user token obtained via a three-legged OAuth flow), use option.WithTokenSource:
//
//	config := &oauth2.Config{...}
//	// ...
//	token, err := config.Exchange(ctx, ...)
//	analyticsadminService, err := analyticsadmin.NewService(ctx, option.WithTokenSource(config.TokenSource(ctx, token)))
//
// See https://godoc.org/google.golang.org/api/option/ for details on options.
package analyticsadmin // import "google.golang.org/api/analyticsadmin/v1alpha"

import (
	"bytes"
	"context"
	"encoding/json"
	"errors"
	"fmt"
	"io"
	"net/http"
	"net/url"
	"strconv"
	"strings"

	googleapi "google.golang.org/api/googleapi"
	internal "google.golang.org/api/internal"
	gensupport "google.golang.org/api/internal/gensupport"
	option "google.golang.org/api/option"
	internaloption "google.golang.org/api/option/internaloption"
	htransport "google.golang.org/api/transport/http"
)

// Always reference these packages, just in case the auto-generated code
// below doesn't.
var _ = bytes.NewBuffer
var _ = strconv.Itoa
var _ = fmt.Sprintf
var _ = json.NewDecoder
var _ = io.Copy
var _ = url.Parse
var _ = gensupport.MarshalJSON
var _ = googleapi.Version
var _ = errors.New
var _ = strings.Replace
var _ = context.Canceled
var _ = internaloption.WithDefaultEndpoint
var _ = internal.Version

const apiId = "analyticsadmin:v1alpha"
const apiName = "analyticsadmin"
const apiVersion = "v1alpha"
const basePath = "https://analyticsadmin.googleapis.com/"
const mtlsBasePath = "https://analyticsadmin.mtls.googleapis.com/"

// OAuth2 scopes used by this API.
const (
	// Edit Google Analytics management entities
	AnalyticsEditScope = "https://www.googleapis.com/auth/analytics.edit"

	// Manage Google Analytics Account users by email address
	AnalyticsManageUsersScope = "https://www.googleapis.com/auth/analytics.manage.users"

	// View Google Analytics user permissions
	AnalyticsManageUsersReadonlyScope = "https://www.googleapis.com/auth/analytics.manage.users.readonly"

	// See and download your Google Analytics data
	AnalyticsReadonlyScope = "https://www.googleapis.com/auth/analytics.readonly"
)

// NewService creates a new Service.
func NewService(ctx context.Context, opts ...option.ClientOption) (*Service, error) {
	scopesOption := internaloption.WithDefaultScopes(
		"https://www.googleapis.com/auth/analytics.edit",
		"https://www.googleapis.com/auth/analytics.manage.users",
		"https://www.googleapis.com/auth/analytics.manage.users.readonly",
		"https://www.googleapis.com/auth/analytics.readonly",
	)
	// NOTE: prepend, so we don't override user-specified scopes.
	opts = append([]option.ClientOption{scopesOption}, opts...)
	opts = append(opts, internaloption.WithDefaultEndpoint(basePath))
	opts = append(opts, internaloption.WithDefaultMTLSEndpoint(mtlsBasePath))
	client, endpoint, err := htransport.NewClient(ctx, opts...)
	if err != nil {
		return nil, err
	}
	s, err := New(client)
	if err != nil {
		return nil, err
	}
	if endpoint != "" {
		s.BasePath = endpoint
	}
	return s, nil
}

// New creates a new Service. It uses the provided http.Client for requests.
//
// Deprecated: please use NewService instead.
// To provide a custom HTTP client, use option.WithHTTPClient.
// If you are using google.golang.org/api/googleapis/transport.APIKey, use option.WithAPIKey with NewService instead.
func New(client *http.Client) (*Service, error) {
	if client == nil {
		return nil, errors.New("client is nil")
	}
	s := &Service{client: client, BasePath: basePath}
	s.AccountSummaries = NewAccountSummariesService(s)
	s.Accounts = NewAccountsService(s)
	s.Properties = NewPropertiesService(s)
	return s, nil
}

type Service struct {
	client    *http.Client
	BasePath  string // API endpoint base URL
	UserAgent string // optional additional User-Agent fragment

	AccountSummaries *AccountSummariesService

	Accounts *AccountsService

	Properties *PropertiesService
}

func (s *Service) userAgent() string {
	if s.UserAgent == "" {
		return googleapi.UserAgent
	}
	return googleapi.UserAgent + " " + s.UserAgent
}

func NewAccountSummariesService(s *Service) *AccountSummariesService {
	rs := &AccountSummariesService{s: s}
	return rs
}

type AccountSummariesService struct {
	s *Service
}

func NewAccountsService(s *Service) *AccountsService {
	rs := &AccountsService{s: s}
	rs.AccessBindings = NewAccountsAccessBindingsService(s)
	rs.UserLinks = NewAccountsUserLinksService(s)
	return rs
}

type AccountsService struct {
	s *Service

	AccessBindings *AccountsAccessBindingsService

	UserLinks *AccountsUserLinksService
}

func NewAccountsAccessBindingsService(s *Service) *AccountsAccessBindingsService {
	rs := &AccountsAccessBindingsService{s: s}
	return rs
}

type AccountsAccessBindingsService struct {
	s *Service
}

func NewAccountsUserLinksService(s *Service) *AccountsUserLinksService {
	rs := &AccountsUserLinksService{s: s}
	return rs
}

type AccountsUserLinksService struct {
	s *Service
}

func NewPropertiesService(s *Service) *PropertiesService {
	rs := &PropertiesService{s: s}
	rs.AccessBindings = NewPropertiesAccessBindingsService(s)
	rs.Audiences = NewPropertiesAudiencesService(s)
	rs.BigQueryLinks = NewPropertiesBigQueryLinksService(s)
	rs.ChannelGroups = NewPropertiesChannelGroupsService(s)
	rs.ConversionEvents = NewPropertiesConversionEventsService(s)
	rs.CustomDimensions = NewPropertiesCustomDimensionsService(s)
	rs.CustomMetrics = NewPropertiesCustomMetricsService(s)
	rs.DataStreams = NewPropertiesDataStreamsService(s)
	rs.DisplayVideo360AdvertiserLinkProposals = NewPropertiesDisplayVideo360AdvertiserLinkProposalsService(s)
	rs.DisplayVideo360AdvertiserLinks = NewPropertiesDisplayVideo360AdvertiserLinksService(s)
	rs.ExpandedDataSets = NewPropertiesExpandedDataSetsService(s)
	rs.FirebaseLinks = NewPropertiesFirebaseLinksService(s)
	rs.GoogleAdsLinks = NewPropertiesGoogleAdsLinksService(s)
	rs.SearchAds360Links = NewPropertiesSearchAds360LinksService(s)
	rs.UserLinks = NewPropertiesUserLinksService(s)
	return rs
}

type PropertiesService struct {
	s *Service

	AccessBindings *PropertiesAccessBindingsService

	Audiences *PropertiesAudiencesService

	BigQueryLinks *PropertiesBigQueryLinksService

	ChannelGroups *PropertiesChannelGroupsService

	ConversionEvents *PropertiesConversionEventsService

	CustomDimensions *PropertiesCustomDimensionsService

	CustomMetrics *PropertiesCustomMetricsService

	DataStreams *PropertiesDataStreamsService

	DisplayVideo360AdvertiserLinkProposals *PropertiesDisplayVideo360AdvertiserLinkProposalsService

	DisplayVideo360AdvertiserLinks *PropertiesDisplayVideo360AdvertiserLinksService

	ExpandedDataSets *PropertiesExpandedDataSetsService

	FirebaseLinks *PropertiesFirebaseLinksService

	GoogleAdsLinks *PropertiesGoogleAdsLinksService

	SearchAds360Links *PropertiesSearchAds360LinksService

	UserLinks *PropertiesUserLinksService
}

func NewPropertiesAccessBindingsService(s *Service) *PropertiesAccessBindingsService {
	rs := &PropertiesAccessBindingsService{s: s}
	return rs
}

type PropertiesAccessBindingsService struct {
	s *Service
}

func NewPropertiesAudiencesService(s *Service) *PropertiesAudiencesService {
	rs := &PropertiesAudiencesService{s: s}
	return rs
}

type PropertiesAudiencesService struct {
	s *Service
}

func NewPropertiesBigQueryLinksService(s *Service) *PropertiesBigQueryLinksService {
	rs := &PropertiesBigQueryLinksService{s: s}
	return rs
}

type PropertiesBigQueryLinksService struct {
	s *Service
}

func NewPropertiesChannelGroupsService(s *Service) *PropertiesChannelGroupsService {
	rs := &PropertiesChannelGroupsService{s: s}
	return rs
}

type PropertiesChannelGroupsService struct {
	s *Service
}

func NewPropertiesConversionEventsService(s *Service) *PropertiesConversionEventsService {
	rs := &PropertiesConversionEventsService{s: s}
	return rs
}

type PropertiesConversionEventsService struct {
	s *Service
}

func NewPropertiesCustomDimensionsService(s *Service) *PropertiesCustomDimensionsService {
	rs := &PropertiesCustomDimensionsService{s: s}
	return rs
}

type PropertiesCustomDimensionsService struct {
	s *Service
}

func NewPropertiesCustomMetricsService(s *Service) *PropertiesCustomMetricsService {
	rs := &PropertiesCustomMetricsService{s: s}
	return rs
}

type PropertiesCustomMetricsService struct {
	s *Service
}

func NewPropertiesDataStreamsService(s *Service) *PropertiesDataStreamsService {
	rs := &PropertiesDataStreamsService{s: s}
	rs.MeasurementProtocolSecrets = NewPropertiesDataStreamsMeasurementProtocolSecretsService(s)
	return rs
}

type PropertiesDataStreamsService struct {
	s *Service

	MeasurementProtocolSecrets *PropertiesDataStreamsMeasurementProtocolSecretsService
}

func NewPropertiesDataStreamsMeasurementProtocolSecretsService(s *Service) *PropertiesDataStreamsMeasurementProtocolSecretsService {
	rs := &PropertiesDataStreamsMeasurementProtocolSecretsService{s: s}
	return rs
}

type PropertiesDataStreamsMeasurementProtocolSecretsService struct {
	s *Service
}

func NewPropertiesDisplayVideo360AdvertiserLinkProposalsService(s *Service) *PropertiesDisplayVideo360AdvertiserLinkProposalsService {
	rs := &PropertiesDisplayVideo360AdvertiserLinkProposalsService{s: s}
	return rs
}

type PropertiesDisplayVideo360AdvertiserLinkProposalsService struct {
	s *Service
}

func NewPropertiesDisplayVideo360AdvertiserLinksService(s *Service) *PropertiesDisplayVideo360AdvertiserLinksService {
	rs := &PropertiesDisplayVideo360AdvertiserLinksService{s: s}
	return rs
}

type PropertiesDisplayVideo360AdvertiserLinksService struct {
	s *Service
}

func NewPropertiesExpandedDataSetsService(s *Service) *PropertiesExpandedDataSetsService {
	rs := &PropertiesExpandedDataSetsService{s: s}
	return rs
}

type PropertiesExpandedDataSetsService struct {
	s *Service
}

func NewPropertiesFirebaseLinksService(s *Service) *PropertiesFirebaseLinksService {
	rs := &PropertiesFirebaseLinksService{s: s}
	return rs
}

type PropertiesFirebaseLinksService struct {
	s *Service
}

func NewPropertiesGoogleAdsLinksService(s *Service) *PropertiesGoogleAdsLinksService {
	rs := &PropertiesGoogleAdsLinksService{s: s}
	return rs
}

type PropertiesGoogleAdsLinksService struct {
	s *Service
}

func NewPropertiesSearchAds360LinksService(s *Service) *PropertiesSearchAds360LinksService {
	rs := &PropertiesSearchAds360LinksService{s: s}
	return rs
}

type PropertiesSearchAds360LinksService struct {
	s *Service
}

func NewPropertiesUserLinksService(s *Service) *PropertiesUserLinksService {
	rs := &PropertiesUserLinksService{s: s}
	return rs
}

type PropertiesUserLinksService struct {
	s *Service
}

// GoogleAnalyticsAdminV1alphaAccessBetweenFilter: To express that the
// result needs to be between two numbers (inclusive).
type GoogleAnalyticsAdminV1alphaAccessBetweenFilter struct {
	// FromValue: Begins with this number.
	FromValue *GoogleAnalyticsAdminV1alphaNumericValue `json:"fromValue,omitempty"`

	// ToValue: Ends with this number.
	ToValue *GoogleAnalyticsAdminV1alphaNumericValue `json:"toValue,omitempty"`

	// ForceSendFields is a list of field names (e.g. "FromValue") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "FromValue") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleAnalyticsAdminV1alphaAccessBetweenFilter) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleAnalyticsAdminV1alphaAccessBetweenFilter
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleAnalyticsAdminV1alphaAccessBinding: A binding of a user to a
// set of roles.
type GoogleAnalyticsAdminV1alphaAccessBinding struct {
	// Name: Output only. Resource name of this binding. Format:
	// accounts/{account}/accessBindings/{access_binding} or
	// properties/{property}/accessBindings/{access_binding} Example:
	// "accounts/100/accessBindings/200"
	Name string `json:"name,omitempty"`

	// Roles: A list of roles for to grant to the parent resource. Valid
	// values: predefinedRoles/viewer predefinedRoles/analyst
	// predefinedRoles/editor predefinedRoles/admin
	// predefinedRoles/no-cost-data predefinedRoles/no-revenue-data For
	// users, if an empty list of roles is set, this AccessBinding will be
	// deleted.
	Roles []string `json:"roles,omitempty"`

	// User: If set, the email address of the user to set roles for. Format:
	// "someuser@gmail.com"
	User string `json:"user,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "Name") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Name") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleAnalyticsAdminV1alphaAccessBinding) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleAnalyticsAdminV1alphaAccessBinding
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleAnalyticsAdminV1alphaAccessDateRange: A contiguous range of
// days: startDate, startDate + 1, ..., endDate.
type GoogleAnalyticsAdminV1alphaAccessDateRange struct {
	// EndDate: The inclusive end date for the query in the format
	// `YYYY-MM-DD`. Cannot be before `startDate`. The format `NdaysAgo`,
	// `yesterday`, or `today` is also accepted, and in that case, the date
	// is inferred based on the current time in the request's time zone.
	EndDate string `json:"endDate,omitempty"`

	// StartDate: The inclusive start date for the query in the format
	// `YYYY-MM-DD`. Cannot be after `endDate`. The format `NdaysAgo`,
	// `yesterday`, or `today` is also accepted, and in that case, the date
	// is inferred based on the current time in the request's time zone.
	StartDate string `json:"startDate,omitempty"`

	// ForceSendFields is a list of field names (e.g. "EndDate") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "EndDate") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleAnalyticsAdminV1alphaAccessDateRange) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleAnalyticsAdminV1alphaAccessDateRange
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleAnalyticsAdminV1alphaAccessDimension: Dimensions are attributes
// of your data. For example, the dimension `userEmail` indicates the
// email of the user that accessed reporting data. Dimension values in
// report responses are strings.
type GoogleAnalyticsAdminV1alphaAccessDimension struct {
	// DimensionName: The API name of the dimension. See Data Access Schema
	// (https://developers.google.com/analytics/devguides/config/admin/v1/access-api-schema)
	// for the list of dimensions supported in this API. Dimensions are
	// referenced by name in `dimensionFilter` and `orderBys`.
	DimensionName string `json:"dimensionName,omitempty"`

	// ForceSendFields is a list of field names (e.g. "DimensionName") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "DimensionName") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleAnalyticsAdminV1alphaAccessDimension) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleAnalyticsAdminV1alphaAccessDimension
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleAnalyticsAdminV1alphaAccessDimensionHeader: Describes a
// dimension column in the report. Dimensions requested in a report
// produce column entries within rows and DimensionHeaders. However,
// dimensions used exclusively within filters or expressions do not
// produce columns in a report; correspondingly, those dimensions do not
// produce headers.
type GoogleAnalyticsAdminV1alphaAccessDimensionHeader struct {
	// DimensionName: The dimension's name; for example 'userEmail'.
	DimensionName string `json:"dimensionName,omitempty"`

	// ForceSendFields is a list of field names (e.g. "DimensionName") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "DimensionName") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleAnalyticsAdminV1alphaAccessDimensionHeader) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleAnalyticsAdminV1alphaAccessDimensionHeader
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleAnalyticsAdminV1alphaAccessDimensionValue: The value of a
// dimension.
type GoogleAnalyticsAdminV1alphaAccessDimensionValue struct {
	// Value: The dimension value. For example, this value may be 'France'
	// for the 'country' dimension.
	Value string `json:"value,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Value") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Value") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleAnalyticsAdminV1alphaAccessDimensionValue) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleAnalyticsAdminV1alphaAccessDimensionValue
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleAnalyticsAdminV1alphaAccessFilter: An expression to filter
// dimension or metric values.
type GoogleAnalyticsAdminV1alphaAccessFilter struct {
	// BetweenFilter: A filter for two values.
	BetweenFilter *GoogleAnalyticsAdminV1alphaAccessBetweenFilter `json:"betweenFilter,omitempty"`

	// FieldName: The dimension name or metric name.
	FieldName string `json:"fieldName,omitempty"`

	// InListFilter: A filter for in list values.
	InListFilter *GoogleAnalyticsAdminV1alphaAccessInListFilter `json:"inListFilter,omitempty"`

	// NumericFilter: A filter for numeric or date values.
	NumericFilter *GoogleAnalyticsAdminV1alphaAccessNumericFilter `json:"numericFilter,omitempty"`

	// StringFilter: Strings related filter.
	StringFilter *GoogleAnalyticsAdminV1alphaAccessStringFilter `json:"stringFilter,omitempty"`

	// ForceSendFields is a list of field names (e.g. "BetweenFilter") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "BetweenFilter") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleAnalyticsAdminV1alphaAccessFilter) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleAnalyticsAdminV1alphaAccessFilter
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleAnalyticsAdminV1alphaAccessFilterExpression: Expresses
// dimension or metric filters. The fields in the same expression need
// to be either all dimensions or all metrics.
type GoogleAnalyticsAdminV1alphaAccessFilterExpression struct {
	// AccessFilter: A primitive filter. In the same FilterExpression, all
	// of the filter's field names need to be either all dimensions or all
	// metrics.
	AccessFilter *GoogleAnalyticsAdminV1alphaAccessFilter `json:"accessFilter,omitempty"`

	// AndGroup: Each of the FilterExpressions in the and_group has an AND
	// relationship.
	AndGroup *GoogleAnalyticsAdminV1alphaAccessFilterExpressionList `json:"andGroup,omitempty"`

	// NotExpression: The FilterExpression is NOT of not_expression.
	NotExpression *GoogleAnalyticsAdminV1alphaAccessFilterExpression `json:"notExpression,omitempty"`

	// OrGroup: Each of the FilterExpressions in the or_group has an OR
	// relationship.
	OrGroup *GoogleAnalyticsAdminV1alphaAccessFilterExpressionList `json:"orGroup,omitempty"`

	// ForceSendFields is a list of field names (e.g. "AccessFilter") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "AccessFilter") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleAnalyticsAdminV1alphaAccessFilterExpression) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleAnalyticsAdminV1alphaAccessFilterExpression
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleAnalyticsAdminV1alphaAccessFilterExpressionList: A list of
// filter expressions.
type GoogleAnalyticsAdminV1alphaAccessFilterExpressionList struct {
	// Expressions: A list of filter expressions.
	Expressions []*GoogleAnalyticsAdminV1alphaAccessFilterExpression `json:"expressions,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Expressions") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Expressions") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleAnalyticsAdminV1alphaAccessFilterExpressionList) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleAnalyticsAdminV1alphaAccessFilterExpressionList
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleAnalyticsAdminV1alphaAccessInListFilter: The result needs to be
// in a list of string values.
type GoogleAnalyticsAdminV1alphaAccessInListFilter struct {
	// CaseSensitive: If true, the string value is case sensitive.
	CaseSensitive bool `json:"caseSensitive,omitempty"`

	// Values: The list of string values. Must be non-empty.
	Values []string `json:"values,omitempty"`

	// ForceSendFields is a list of field names (e.g. "CaseSensitive") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "CaseSensitive") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleAnalyticsAdminV1alphaAccessInListFilter) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleAnalyticsAdminV1alphaAccessInListFilter
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleAnalyticsAdminV1alphaAccessMetric: The quantitative
// measurements of a report. For example, the metric `accessCount` is
// the total number of data access records.
type GoogleAnalyticsAdminV1alphaAccessMetric struct {
	// MetricName: The API name of the metric. See Data Access Schema
	// (https://developers.google.com/analytics/devguides/config/admin/v1/access-api-schema)
	// for the list of metrics supported in this API. Metrics are referenced
	// by name in `metricFilter` & `orderBys`.
	MetricName string `json:"metricName,omitempty"`

	// ForceSendFields is a list of field names (e.g. "MetricName") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "MetricName") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleAnalyticsAdminV1alphaAccessMetric) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleAnalyticsAdminV1alphaAccessMetric
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleAnalyticsAdminV1alphaAccessMetricHeader: Describes a metric
// column in the report. Visible metrics requested in a report produce
// column entries within rows and MetricHeaders. However, metrics used
// exclusively within filters or expressions do not produce columns in a
// report; correspondingly, those metrics do not produce headers.
type GoogleAnalyticsAdminV1alphaAccessMetricHeader struct {
	// MetricName: The metric's name; for example 'accessCount'.
	MetricName string `json:"metricName,omitempty"`

	// ForceSendFields is a list of field names (e.g. "MetricName") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "MetricName") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleAnalyticsAdminV1alphaAccessMetricHeader) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleAnalyticsAdminV1alphaAccessMetricHeader
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleAnalyticsAdminV1alphaAccessMetricValue: The value of a metric.
type GoogleAnalyticsAdminV1alphaAccessMetricValue struct {
	// Value: The measurement value. For example, this value may be '13'.
	Value string `json:"value,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Value") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Value") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleAnalyticsAdminV1alphaAccessMetricValue) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleAnalyticsAdminV1alphaAccessMetricValue
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleAnalyticsAdminV1alphaAccessNumericFilter: Filters for numeric
// or date values.
type GoogleAnalyticsAdminV1alphaAccessNumericFilter struct {
	// Operation: The operation type for this filter.
	//
	// Possible values:
	//   "OPERATION_UNSPECIFIED" - Unspecified.
	//   "EQUAL" - Equal
	//   "LESS_THAN" - Less than
	//   "LESS_THAN_OR_EQUAL" - Less than or equal
	//   "GREATER_THAN" - Greater than
	//   "GREATER_THAN_OR_EQUAL" - Greater than or equal
	Operation string `json:"operation,omitempty"`

	// Value: A numeric value or a date value.
	Value *GoogleAnalyticsAdminV1alphaNumericValue `json:"value,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Operation") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Operation") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleAnalyticsAdminV1alphaAccessNumericFilter) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleAnalyticsAdminV1alphaAccessNumericFilter
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleAnalyticsAdminV1alphaAccessOrderBy: Order bys define how rows
// will be sorted in the response. For example, ordering rows by
// descending access count is one ordering, and ordering rows by the
// country string is a different ordering.
type GoogleAnalyticsAdminV1alphaAccessOrderBy struct {
	// Desc: If true, sorts by descending order. If false or unspecified,
	// sorts in ascending order.
	Desc bool `json:"desc,omitempty"`

	// Dimension: Sorts results by a dimension's values.
	Dimension *GoogleAnalyticsAdminV1alphaAccessOrderByDimensionOrderBy `json:"dimension,omitempty"`

	// Metric: Sorts results by a metric's values.
	Metric *GoogleAnalyticsAdminV1alphaAccessOrderByMetricOrderBy `json:"metric,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Desc") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Desc") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleAnalyticsAdminV1alphaAccessOrderBy) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleAnalyticsAdminV1alphaAccessOrderBy
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleAnalyticsAdminV1alphaAccessOrderByDimensionOrderBy: Sorts by
// dimension values.
type GoogleAnalyticsAdminV1alphaAccessOrderByDimensionOrderBy struct {
	// DimensionName: A dimension name in the request to order by.
	DimensionName string `json:"dimensionName,omitempty"`

	// OrderType: Controls the rule for dimension value ordering.
	//
	// Possible values:
	//   "ORDER_TYPE_UNSPECIFIED" - Unspecified.
	//   "ALPHANUMERIC" - Alphanumeric sort by Unicode code point. For
	// example, "2" < "A" < "X" < "b" < "z".
	//   "CASE_INSENSITIVE_ALPHANUMERIC" - Case insensitive alphanumeric
	// sort by lower case Unicode code point. For example, "2" < "A" < "b" <
	// "X" < "z".
	//   "NUMERIC" - Dimension values are converted to numbers before
	// sorting. For example in NUMERIC sort, "25" < "100", and in
	// `ALPHANUMERIC` sort, "100" < "25". Non-numeric dimension values all
	// have equal ordering value below all numeric values.
	OrderType string `json:"orderType,omitempty"`

	// ForceSendFields is a list of field names (e.g. "DimensionName") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "DimensionName") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleAnalyticsAdminV1alphaAccessOrderByDimensionOrderBy) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleAnalyticsAdminV1alphaAccessOrderByDimensionOrderBy
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleAnalyticsAdminV1alphaAccessOrderByMetricOrderBy: Sorts by
// metric values.
type GoogleAnalyticsAdminV1alphaAccessOrderByMetricOrderBy struct {
	// MetricName: A metric name in the request to order by.
	MetricName string `json:"metricName,omitempty"`

	// ForceSendFields is a list of field names (e.g. "MetricName") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "MetricName") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleAnalyticsAdminV1alphaAccessOrderByMetricOrderBy) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleAnalyticsAdminV1alphaAccessOrderByMetricOrderBy
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleAnalyticsAdminV1alphaAccessQuota: Current state of all quotas
// for this Analytics property. If any quota for a property is
// exhausted, all requests to that property will return Resource
// Exhausted errors.
type GoogleAnalyticsAdminV1alphaAccessQuota struct {
	// ConcurrentRequests: Properties can use up to 50 concurrent requests.
	ConcurrentRequests *GoogleAnalyticsAdminV1alphaAccessQuotaStatus `json:"concurrentRequests,omitempty"`

	// ServerErrorsPerProjectPerHour: Properties and cloud project pairs can
	// have up to 50 server errors per hour.
	ServerErrorsPerProjectPerHour *GoogleAnalyticsAdminV1alphaAccessQuotaStatus `json:"serverErrorsPerProjectPerHour,omitempty"`

	// TokensPerDay: Properties can use 250,000 tokens per day. Most
	// requests consume fewer than 10 tokens.
	TokensPerDay *GoogleAnalyticsAdminV1alphaAccessQuotaStatus `json:"tokensPerDay,omitempty"`

	// TokensPerHour: Properties can use 50,000 tokens per hour. An API
	// request consumes a single number of tokens, and that number is
	// deducted from all of the hourly, daily, and per project hourly
	// quotas.
	TokensPerHour *GoogleAnalyticsAdminV1alphaAccessQuotaStatus `json:"tokensPerHour,omitempty"`

	// TokensPerProjectPerHour: Properties can use up to 25% of their tokens
	// per project per hour. This amounts to Analytics 360 Properties can
	// use 12,500 tokens per project per hour. An API request consumes a
	// single number of tokens, and that number is deducted from all of the
	// hourly, daily, and per project hourly quotas.
	TokensPerProjectPerHour *GoogleAnalyticsAdminV1alphaAccessQuotaStatus `json:"tokensPerProjectPerHour,omitempty"`

	// ForceSendFields is a list of field names (e.g. "ConcurrentRequests")
	// to unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "ConcurrentRequests") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *GoogleAnalyticsAdminV1alphaAccessQuota) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleAnalyticsAdminV1alphaAccessQuota
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleAnalyticsAdminV1alphaAccessQuotaStatus: Current state for a
// particular quota group.
type GoogleAnalyticsAdminV1alphaAccessQuotaStatus struct {
	// Consumed: Quota consumed by this request.
	Consumed int64 `json:"consumed,omitempty"`

	// Remaining: Quota remaining after this request.
	Remaining int64 `json:"remaining,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Consumed") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Consumed") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleAnalyticsAdminV1alphaAccessQuotaStatus) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleAnalyticsAdminV1alphaAccessQuotaStatus
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleAnalyticsAdminV1alphaAccessRow: Access report data for each
// row.
type GoogleAnalyticsAdminV1alphaAccessRow struct {
	// DimensionValues: List of dimension values. These values are in the
	// same order as specified in the request.
	DimensionValues []*GoogleAnalyticsAdminV1alphaAccessDimensionValue `json:"dimensionValues,omitempty"`

	// MetricValues: List of metric values. These values are in the same
	// order as specified in the request.
	MetricValues []*GoogleAnalyticsAdminV1alphaAccessMetricValue `json:"metricValues,omitempty"`

	// ForceSendFields is a list of field names (e.g. "DimensionValues") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "DimensionValues") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *GoogleAnalyticsAdminV1alphaAccessRow) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleAnalyticsAdminV1alphaAccessRow
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleAnalyticsAdminV1alphaAccessStringFilter: The filter for
// strings.
type GoogleAnalyticsAdminV1alphaAccessStringFilter struct {
	// CaseSensitive: If true, the string value is case sensitive.
	CaseSensitive bool `json:"caseSensitive,omitempty"`

	// MatchType: The match type for this filter.
	//
	// Possible values:
	//   "MATCH_TYPE_UNSPECIFIED" - Unspecified
	//   "EXACT" - Exact match of the string value.
	//   "BEGINS_WITH" - Begins with the string value.
	//   "ENDS_WITH" - Ends with the string value.
	//   "CONTAINS" - Contains the string value.
	//   "FULL_REGEXP" - Full match for the regular expression with the
	// string value.
	//   "PARTIAL_REGEXP" - Partial match for the regular expression with
	// the string value.
	MatchType string `json:"matchType,omitempty"`

	// Value: The string value used for the matching.
	Value string `json:"value,omitempty"`

	// ForceSendFields is a list of field names (e.g. "CaseSensitive") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "CaseSensitive") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleAnalyticsAdminV1alphaAccessStringFilter) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleAnalyticsAdminV1alphaAccessStringFilter
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleAnalyticsAdminV1alphaAccount: A resource message representing a
// Google Analytics account.
type GoogleAnalyticsAdminV1alphaAccount struct {
	// CreateTime: Output only. Time when this account was originally
	// created.
	CreateTime string `json:"createTime,omitempty"`

	// Deleted: Output only. Indicates whether this Account is soft-deleted
	// or not. Deleted accounts are excluded from List results unless
	// specifically requested.
	Deleted bool `json:"deleted,omitempty"`

	// DisplayName: Required. Human-readable display name for this account.
	DisplayName string `json:"displayName,omitempty"`

	// Name: Output only. Resource name of this account. Format:
	// accounts/{account} Example: "accounts/100"
	Name string `json:"name,omitempty"`

	// RegionCode: Country of business. Must be a Unicode CLDR region code.
	RegionCode string `json:"regionCode,omitempty"`

	// UpdateTime: Output only. Time when account payload fields were last
	// updated.
	UpdateTime string `json:"updateTime,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "CreateTime") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "CreateTime") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleAnalyticsAdminV1alphaAccount) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleAnalyticsAdminV1alphaAccount
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleAnalyticsAdminV1alphaAccountSummary: A virtual resource
// representing an overview of an account and all its child GA4
// properties.
type GoogleAnalyticsAdminV1alphaAccountSummary struct {
	// Account: Resource name of account referred to by this account summary
	// Format: accounts/{account_id} Example: "accounts/1000"
	Account string `json:"account,omitempty"`

	// DisplayName: Display name for the account referred to in this account
	// summary.
	DisplayName string `json:"displayName,omitempty"`

	// Name: Resource name for this account summary. Format:
	// accountSummaries/{account_id} Example: "accountSummaries/1000"
	Name string `json:"name,omitempty"`

	// PropertySummaries: List of summaries for child accounts of this
	// account.
	PropertySummaries []*GoogleAnalyticsAdminV1alphaPropertySummary `json:"propertySummaries,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Account") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Account") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleAnalyticsAdminV1alphaAccountSummary) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleAnalyticsAdminV1alphaAccountSummary
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleAnalyticsAdminV1alphaAcknowledgeUserDataCollectionRequest:
// Request message for AcknowledgeUserDataCollection RPC.
type GoogleAnalyticsAdminV1alphaAcknowledgeUserDataCollectionRequest struct {
	// Acknowledgement: Required. An acknowledgement that the caller of this
	// method understands the terms of user data collection. This field must
	// contain the exact value: "I acknowledge that I have the necessary
	// privacy disclosures and rights from my end users for the collection
	// and processing of their data, including the association of such data
	// with the visitation information Google Analytics collects from my
	// site and/or app property."
	Acknowledgement string `json:"acknowledgement,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Acknowledgement") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Acknowledgement") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *GoogleAnalyticsAdminV1alphaAcknowledgeUserDataCollectionRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleAnalyticsAdminV1alphaAcknowledgeUserDataCollectionRequest
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleAnalyticsAdminV1alphaAcknowledgeUserDataCollectionResponse:
// Response message for AcknowledgeUserDataCollection RPC.
type GoogleAnalyticsAdminV1alphaAcknowledgeUserDataCollectionResponse struct {
	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`
}

// GoogleAnalyticsAdminV1alphaApproveDisplayVideo360AdvertiserLinkProposa
// lRequest: Request message for
// ApproveDisplayVideo360AdvertiserLinkProposal RPC.
type GoogleAnalyticsAdminV1alphaApproveDisplayVideo360AdvertiserLinkProposalRequest struct {
}

// GoogleAnalyticsAdminV1alphaApproveDisplayVideo360AdvertiserLinkProposa
// lResponse: Response message for
// ApproveDisplayVideo360AdvertiserLinkProposal RPC.
type GoogleAnalyticsAdminV1alphaApproveDisplayVideo360AdvertiserLinkProposalResponse struct {
	// DisplayVideo360AdvertiserLink: The DisplayVideo360AdvertiserLink
	// created as a result of approving the proposal.
	DisplayVideo360AdvertiserLink *GoogleAnalyticsAdminV1alphaDisplayVideo360AdvertiserLink `json:"displayVideo360AdvertiserLink,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g.
	// "DisplayVideo360AdvertiserLink") to unconditionally include in API
	// requests. By default, fields with empty or default values are omitted
	// from API requests. However, any non-pointer, non-interface field
	// appearing in ForceSendFields will be sent to the server regardless of
	// whether the field is empty or not. This may be used to include empty
	// fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g.
	// "DisplayVideo360AdvertiserLink") to include in API requests with the
	// JSON null value. By default, fields with empty values are omitted
	// from API requests. However, any field with an empty value appearing
	// in NullFields will be sent to the server as null. It is an error if a
	// field in this list has a non-empty value. This may be used to include
	// null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleAnalyticsAdminV1alphaApproveDisplayVideo360AdvertiserLinkProposalResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleAnalyticsAdminV1alphaApproveDisplayVideo360AdvertiserLinkProposalResponse
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleAnalyticsAdminV1alphaArchiveAudienceRequest: Request message
// for ArchiveAudience RPC.
type GoogleAnalyticsAdminV1alphaArchiveAudienceRequest struct {
}

// GoogleAnalyticsAdminV1alphaArchiveCustomDimensionRequest: Request
// message for ArchiveCustomDimension RPC.
type GoogleAnalyticsAdminV1alphaArchiveCustomDimensionRequest struct {
}

// GoogleAnalyticsAdminV1alphaArchiveCustomMetricRequest: Request
// message for ArchiveCustomMetric RPC.
type GoogleAnalyticsAdminV1alphaArchiveCustomMetricRequest struct {
}

// GoogleAnalyticsAdminV1alphaAttributionSettings: The attribution
// settings used for a given property. This is a singleton resource.
type GoogleAnalyticsAdminV1alphaAttributionSettings struct {
	// AcquisitionConversionEventLookbackWindow: Required. The lookback
	// window configuration for acquisition conversion events. The default
	// window size is 30 days.
	//
	// Possible values:
	//   "ACQUISITION_CONVERSION_EVENT_LOOKBACK_WINDOW_UNSPECIFIED" -
	// Lookback window size unspecified.
	//   "ACQUISITION_CONVERSION_EVENT_LOOKBACK_WINDOW_7_DAYS" - 7-day
	// lookback window.
	//   "ACQUISITION_CONVERSION_EVENT_LOOKBACK_WINDOW_30_DAYS" - 30-day
	// lookback window.
	AcquisitionConversionEventLookbackWindow string `json:"acquisitionConversionEventLookbackWindow,omitempty"`

	// Name: Output only. Resource name of this attribution settings
	// resource. Format: properties/{property_id}/attributionSettings
	// Example: "properties/1000/attributionSettings"
	Name string `json:"name,omitempty"`

	// OtherConversionEventLookbackWindow: Required. The lookback window for
	// all other, non-acquisition conversion events. The default window size
	// is 90 days.
	//
	// Possible values:
	//   "OTHER_CONVERSION_EVENT_LOOKBACK_WINDOW_UNSPECIFIED" - Lookback
	// window size unspecified.
	//   "OTHER_CONVERSION_EVENT_LOOKBACK_WINDOW_30_DAYS" - 30-day lookback
	// window.
	//   "OTHER_CONVERSION_EVENT_LOOKBACK_WINDOW_60_DAYS" - 60-day lookback
	// window.
	//   "OTHER_CONVERSION_EVENT_LOOKBACK_WINDOW_90_DAYS" - 90-day lookback
	// window.
	OtherConversionEventLookbackWindow string `json:"otherConversionEventLookbackWindow,omitempty"`

	// ReportingAttributionModel: Required. The reporting attribution model
	// used to calculate conversion credit in this property's reports.
	// Changing the attribution model will apply to both historical and
	// future data. These changes will be reflected in reports with
	// conversion and revenue data. User and session data will be
	// unaffected.
	//
	// Possible values:
	//   "REPORTING_ATTRIBUTION_MODEL_UNSPECIFIED" - Reporting attribution
	// model unspecified.
	//   "CROSS_CHANNEL_DATA_DRIVEN" - Data-driven attribution distributes
	// credit for the conversion based on data for each conversion event.
	// Each Data-driven model is specific to each advertiser and each
	// conversion event.
	//   "CROSS_CHANNEL_LAST_CLICK" - Ignores direct traffic and attributes
	// 100% of the conversion value to the last channel that the customer
	// clicked through (or engaged view through for YouTube) before
	// converting.
	//   "CROSS_CHANNEL_FIRST_CLICK" - Gives all credit for the conversion
	// to the first channel that a customer clicked (or engaged view through
	// for YouTube) before converting.
	//   "CROSS_CHANNEL_LINEAR" - Distributes the credit for the conversion
	// equally across all the channels a customer clicked (or engaged view
	// through for YouTube) before converting.
	//   "CROSS_CHANNEL_POSITION_BASED" - Attributes 40% credit to the first
	// and last interaction, and the remaining 20% credit is distributed
	// evenly to the middle interactions.
	//   "CROSS_CHANNEL_TIME_DECAY" - Gives more credit to the touchpoints
	// that happened closer in time to the conversion.
	//   "ADS_PREFERRED_LAST_CLICK" - Attributes 100% of the conversion
	// value to the last Google Ads channel that the customer clicked
	// through before converting.
	ReportingAttributionModel string `json:"reportingAttributionModel,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g.
	// "AcquisitionConversionEventLookbackWindow") to unconditionally
	// include in API requests. By default, fields with empty or default
	// values are omitted from API requests. However, any non-pointer,
	// non-interface field appearing in ForceSendFields will be sent to the
	// server regardless of whether the field is empty or not. This may be
	// used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g.
	// "AcquisitionConversionEventLookbackWindow") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleAnalyticsAdminV1alphaAttributionSettings) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleAnalyticsAdminV1alphaAttributionSettings
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleAnalyticsAdminV1alphaAudience: A resource message representing
// a GA4 Audience.
type GoogleAnalyticsAdminV1alphaAudience struct {
	// AdsPersonalizationEnabled: Output only. It is automatically set by GA
	// to false if this is an NPA Audience and is excluded from ads
	// personalization.
	AdsPersonalizationEnabled bool `json:"adsPersonalizationEnabled,omitempty"`

	// Description: Required. The description of the Audience.
	Description string `json:"description,omitempty"`

	// DisplayName: Required. The display name of the Audience.
	DisplayName string `json:"displayName,omitempty"`

	// EventTrigger: Optional. Specifies an event to log when a user joins
	// the Audience. If not set, no event is logged when a user joins the
	// Audience.
	EventTrigger *GoogleAnalyticsAdminV1alphaAudienceEventTrigger `json:"eventTrigger,omitempty"`

	// ExclusionDurationMode: Immutable. Specifies how long an exclusion
	// lasts for users that meet the exclusion filter. It is applied to all
	// EXCLUDE filter clauses and is ignored when there is no EXCLUDE filter
	// clause in the Audience.
	//
	// Possible values:
	//   "AUDIENCE_EXCLUSION_DURATION_MODE_UNSPECIFIED" - Not specified.
	//   "EXCLUDE_TEMPORARILY" - Exclude users from the Audience during
	// periods when they meet the filter clause.
	//   "EXCLUDE_PERMANENTLY" - Exclude users from the Audience if they've
	// ever met the filter clause.
	ExclusionDurationMode string `json:"exclusionDurationMode,omitempty"`

	// FilterClauses: Required. Immutable. Unordered list. Filter clauses
	// that define the Audience. All clauses will be AND’ed together.
	FilterClauses []*GoogleAnalyticsAdminV1alphaAudienceFilterClause `json:"filterClauses,omitempty"`

	// MembershipDurationDays: Required. Immutable. The duration a user
	// should stay in an Audience. It cannot be set to more than 540 days.
	MembershipDurationDays int64 `json:"membershipDurationDays,omitempty"`

	// Name: Output only. The resource name for this Audience resource.
	// Format: properties/{propertyId}/audiences/{audienceId}
	Name string `json:"name,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g.
	// "AdsPersonalizationEnabled") to unconditionally include in API
	// requests. By default, fields with empty or default values are omitted
	// from API requests. However, any non-pointer, non-interface field
	// appearing in ForceSendFields will be sent to the server regardless of
	// whether the field is empty or not. This may be used to include empty
	// fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g.
	// "AdsPersonalizationEnabled") to include in API requests with the JSON
	// null value. By default, fields with empty values are omitted from API
	// requests. However, any field with an empty value appearing in
	// NullFields will be sent to the server as null. It is an error if a
	// field in this list has a non-empty value. This may be used to include
	// null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleAnalyticsAdminV1alphaAudience) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleAnalyticsAdminV1alphaAudience
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleAnalyticsAdminV1alphaAudienceDimensionOrMetricFilter: A
// specific filter for a single dimension or metric.
type GoogleAnalyticsAdminV1alphaAudienceDimensionOrMetricFilter struct {
	// AtAnyPointInTime: Optional. Indicates whether this filter needs
	// dynamic evaluation or not. If set to true, users join the Audience if
	// they ever met the condition (static evaluation). If unset or set to
	// false, user evaluation for an Audience is dynamic; users are added to
	// an Audience when they meet the conditions and then removed when they
	// no longer meet them. This can only be set when Audience scope is
	// ACROSS_ALL_SESSIONS.
	AtAnyPointInTime bool `json:"atAnyPointInTime,omitempty"`

	// BetweenFilter: A filter for numeric or date values between certain
	// values on a dimension or metric.
	BetweenFilter *GoogleAnalyticsAdminV1alphaAudienceDimensionOrMetricFilterBetweenFilter `json:"betweenFilter,omitempty"`

	// FieldName: Required. Immutable. The dimension name or metric name to
	// filter. If the field name refers to a custom dimension or metric, a
	// scope prefix will be added to the front of the custom dimensions or
	// metric name. For more on scope prefixes or custom dimensions/metrics,
	// reference the [Google Analytics Data API documentation]
	// (https://developers.google.com/analytics/devguides/reporting/data/v1/api-schema#custom_dimensions).
	FieldName string `json:"fieldName,omitempty"`

	// InAnyNDayPeriod: Optional. If set, specifies the time window for
	// which to evaluate data in number of days. If not set, then audience
	// data is evaluated against lifetime data (For example, infinite time
	// window). For example, if set to 1 day, only the current day's data is
	// evaluated. The reference point is the current day when
	// at_any_point_in_time is unset or false. It can only be set when
	// Audience scope is ACROSS_ALL_SESSIONS and cannot be greater than 60
	// days.
	InAnyNDayPeriod int64 `json:"inAnyNDayPeriod,omitempty"`

	// InListFilter: A filter for a string dimension that matches a
	// particular list of options.
	InListFilter *GoogleAnalyticsAdminV1alphaAudienceDimensionOrMetricFilterInListFilter `json:"inListFilter,omitempty"`

	// NumericFilter: A filter for numeric or date values on a dimension or
	// metric.
	NumericFilter *GoogleAnalyticsAdminV1alphaAudienceDimensionOrMetricFilterNumericFilter `json:"numericFilter,omitempty"`

	// StringFilter: A filter for a string-type dimension that matches a
	// particular pattern.
	StringFilter *GoogleAnalyticsAdminV1alphaAudienceDimensionOrMetricFilterStringFilter `json:"stringFilter,omitempty"`

	// ForceSendFields is a list of field names (e.g. "AtAnyPointInTime") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "AtAnyPointInTime") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *GoogleAnalyticsAdminV1alphaAudienceDimensionOrMetricFilter) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleAnalyticsAdminV1alphaAudienceDimensionOrMetricFilter
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleAnalyticsAdminV1alphaAudienceDimensionOrMetricFilterBetweenFilte
// r: A filter for numeric or date values between certain values on a
// dimension or metric.
type GoogleAnalyticsAdminV1alphaAudienceDimensionOrMetricFilterBetweenFilter struct {
	// FromValue: Required. Begins with this number, inclusive.
	FromValue *GoogleAnalyticsAdminV1alphaAudienceDimensionOrMetricFilterNumericValue `json:"fromValue,omitempty"`

	// ToValue: Required. Ends with this number, inclusive.
	ToValue *GoogleAnalyticsAdminV1alphaAudienceDimensionOrMetricFilterNumericValue `json:"toValue,omitempty"`

	// ForceSendFields is a list of field names (e.g. "FromValue") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "FromValue") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleAnalyticsAdminV1alphaAudienceDimensionOrMetricFilterBetweenFilter) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleAnalyticsAdminV1alphaAudienceDimensionOrMetricFilterBetweenFilter
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleAnalyticsAdminV1alphaAudienceDimensionOrMetricFilterInListFilter
// : A filter for a string dimension that matches a particular list of
// options.
type GoogleAnalyticsAdminV1alphaAudienceDimensionOrMetricFilterInListFilter struct {
	// CaseSensitive: Optional. If true, the match is case-sensitive. If
	// false, the match is case-insensitive.
	CaseSensitive bool `json:"caseSensitive,omitempty"`

	// Values: Required. The list of possible string values to match
	// against. Must be non-empty.
	Values []string `json:"values,omitempty"`

	// ForceSendFields is a list of field names (e.g. "CaseSensitive") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "CaseSensitive") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleAnalyticsAdminV1alphaAudienceDimensionOrMetricFilterInListFilter) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleAnalyticsAdminV1alphaAudienceDimensionOrMetricFilterInListFilter
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleAnalyticsAdminV1alphaAudienceDimensionOrMetricFilterNumericFilte
// r: A filter for numeric or date values on a dimension or metric.
type GoogleAnalyticsAdminV1alphaAudienceDimensionOrMetricFilterNumericFilter struct {
	// Operation: Required. The operation applied to a numeric filter.
	//
	// Possible values:
	//   "OPERATION_UNSPECIFIED" - Unspecified.
	//   "EQUAL" - Equal.
	//   "LESS_THAN" - Less than.
	//   "GREATER_THAN" - Greater than.
	Operation string `json:"operation,omitempty"`

	// Value: Required. The numeric or date value to match against.
	Value *GoogleAnalyticsAdminV1alphaAudienceDimensionOrMetricFilterNumericValue `json:"value,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Operation") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Operation") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleAnalyticsAdminV1alphaAudienceDimensionOrMetricFilterNumericFilter) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleAnalyticsAdminV1alphaAudienceDimensionOrMetricFilterNumericFilter
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleAnalyticsAdminV1alphaAudienceDimensionOrMetricFilterNumericValue
// : To represent a number.
type GoogleAnalyticsAdminV1alphaAudienceDimensionOrMetricFilterNumericValue struct {
	// DoubleValue: Double value.
	DoubleValue float64 `json:"doubleValue,omitempty"`

	// Int64Value: Integer value.
	Int64Value int64 `json:"int64Value,omitempty,string"`

	// ForceSendFields is a list of field names (e.g. "DoubleValue") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "DoubleValue") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleAnalyticsAdminV1alphaAudienceDimensionOrMetricFilterNumericValue) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleAnalyticsAdminV1alphaAudienceDimensionOrMetricFilterNumericValue
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

func (s *GoogleAnalyticsAdminV1alphaAudienceDimensionOrMetricFilterNumericValue) UnmarshalJSON(data []byte) error {
	type NoMethod GoogleAnalyticsAdminV1alphaAudienceDimensionOrMetricFilterNumericValue
	var s1 struct {
		DoubleValue gensupport.JSONFloat64 `json:"doubleValue"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.DoubleValue = float64(s1.DoubleValue)
	return nil
}

// GoogleAnalyticsAdminV1alphaAudienceDimensionOrMetricFilterStringFilter
// : A filter for a string-type dimension that matches a particular
// pattern.
type GoogleAnalyticsAdminV1alphaAudienceDimensionOrMetricFilterStringFilter struct {
	// CaseSensitive: Optional. If true, the match is case-sensitive. If
	// false, the match is case-insensitive.
	CaseSensitive bool `json:"caseSensitive,omitempty"`

	// MatchType: Required. The match type for the string filter.
	//
	// Possible values:
	//   "MATCH_TYPE_UNSPECIFIED" - Unspecified
	//   "EXACT" - Exact match of the string value.
	//   "BEGINS_WITH" - Begins with the string value.
	//   "ENDS_WITH" - Ends with the string value.
	//   "CONTAINS" - Contains the string value.
	//   "FULL_REGEXP" - Full regular expression matches with the string
	// value.
	MatchType string `json:"matchType,omitempty"`

	// Value: Required. The string value to be matched against.
	Value string `json:"value,omitempty"`

	// ForceSendFields is a list of field names (e.g. "CaseSensitive") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "CaseSensitive") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleAnalyticsAdminV1alphaAudienceDimensionOrMetricFilterStringFilter) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleAnalyticsAdminV1alphaAudienceDimensionOrMetricFilterStringFilter
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleAnalyticsAdminV1alphaAudienceEventFilter: A filter that matches
// events of a single event name. If an event parameter is specified,
// only the subset of events that match both the single event name and
// the parameter filter expressions match this event filter.
type GoogleAnalyticsAdminV1alphaAudienceEventFilter struct {
	// EventName: Required. Immutable. The name of the event to match
	// against.
	EventName string `json:"eventName,omitempty"`

	// EventParameterFilterExpression: Optional. If specified, this filter
	// matches events that match both the single event name and the
	// parameter filter expressions. AudienceEventFilter inside the
	// parameter filter expression cannot be set (For example, nested event
	// filters are not supported). This should be a single and_group of
	// dimension_or_metric_filter or not_expression; ANDs of ORs are not
	// supported. Also, if it includes a filter for "eventCount", only that
	// one will be considered; all the other filters will be ignored.
	EventParameterFilterExpression *GoogleAnalyticsAdminV1alphaAudienceFilterExpression `json:"eventParameterFilterExpression,omitempty"`

	// ForceSendFields is a list of field names (e.g. "EventName") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "EventName") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleAnalyticsAdminV1alphaAudienceEventFilter) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleAnalyticsAdminV1alphaAudienceEventFilter
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleAnalyticsAdminV1alphaAudienceEventTrigger: Specifies an event
// to log when a user joins the Audience.
type GoogleAnalyticsAdminV1alphaAudienceEventTrigger struct {
	// EventName: Required. The event name that will be logged.
	EventName string `json:"eventName,omitempty"`

	// LogCondition: Required. When to log the event.
	//
	// Possible values:
	//   "LOG_CONDITION_UNSPECIFIED" - Log condition is not specified.
	//   "AUDIENCE_JOINED" - The event should be logged only when a user is
	// joined.
	//   "AUDIENCE_MEMBERSHIP_RENEWED" - The event should be logged whenever
	// the Audience condition is met, even if the user is already a member
	// of the Audience.
	LogCondition string `json:"logCondition,omitempty"`

	// ForceSendFields is a list of field names (e.g. "EventName") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "EventName") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleAnalyticsAdminV1alphaAudienceEventTrigger) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleAnalyticsAdminV1alphaAudienceEventTrigger
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleAnalyticsAdminV1alphaAudienceFilterClause: A clause for
// defining either a simple or sequence filter. A filter can be
// inclusive (For example, users satisfying the filter clause are
// included in the Audience) or exclusive (For example, users satisfying
// the filter clause are excluded from the Audience).
type GoogleAnalyticsAdminV1alphaAudienceFilterClause struct {
	// ClauseType: Required. Specifies whether this is an include or exclude
	// filter clause.
	//
	// Possible values:
	//   "AUDIENCE_CLAUSE_TYPE_UNSPECIFIED" - Unspecified clause type.
	//   "INCLUDE" - Users will be included in the Audience if the filter
	// clause is met.
	//   "EXCLUDE" - Users will be excluded from the Audience if the filter
	// clause is met.
	ClauseType string `json:"clauseType,omitempty"`

	// SequenceFilter: Filters that must occur in a specific order for the
	// user to be a member of the Audience.
	SequenceFilter *GoogleAnalyticsAdminV1alphaAudienceSequenceFilter `json:"sequenceFilter,omitempty"`

	// SimpleFilter: A simple filter that a user must satisfy to be a member
	// of the Audience.
	SimpleFilter *GoogleAnalyticsAdminV1alphaAudienceSimpleFilter `json:"simpleFilter,omitempty"`

	// ForceSendFields is a list of field names (e.g. "ClauseType") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "ClauseType") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleAnalyticsAdminV1alphaAudienceFilterClause) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleAnalyticsAdminV1alphaAudienceFilterClause
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleAnalyticsAdminV1alphaAudienceFilterExpression: A logical
// expression of Audience dimension, metric, or event filters.
type GoogleAnalyticsAdminV1alphaAudienceFilterExpression struct {
	// AndGroup: A list of expressions to be AND’ed together. It can only
	// contain AudienceFilterExpressions with or_group. This must be set for
	// the top level AudienceFilterExpression.
	AndGroup *GoogleAnalyticsAdminV1alphaAudienceFilterExpressionList `json:"andGroup,omitempty"`

	// DimensionOrMetricFilter: A filter on a single dimension or metric.
	// This cannot be set on the top level AudienceFilterExpression.
	DimensionOrMetricFilter *GoogleAnalyticsAdminV1alphaAudienceDimensionOrMetricFilter `json:"dimensionOrMetricFilter,omitempty"`

	// EventFilter: Creates a filter that matches a specific event. This
	// cannot be set on the top level AudienceFilterExpression.
	EventFilter *GoogleAnalyticsAdminV1alphaAudienceEventFilter `json:"eventFilter,omitempty"`

	// NotExpression: A filter expression to be NOT'ed (For example,
	// inverted, complemented). It can only include a
	// dimension_or_metric_filter. This cannot be set on the top level
	// AudienceFilterExpression.
	NotExpression *GoogleAnalyticsAdminV1alphaAudienceFilterExpression `json:"notExpression,omitempty"`

	// OrGroup: A list of expressions to OR’ed together. It cannot contain
	// AudienceFilterExpressions with and_group or or_group.
	OrGroup *GoogleAnalyticsAdminV1alphaAudienceFilterExpressionList `json:"orGroup,omitempty"`

	// ForceSendFields is a list of field names (e.g. "AndGroup") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "AndGroup") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleAnalyticsAdminV1alphaAudienceFilterExpression) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleAnalyticsAdminV1alphaAudienceFilterExpression
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleAnalyticsAdminV1alphaAudienceFilterExpressionList: A list of
// Audience filter expressions.
type GoogleAnalyticsAdminV1alphaAudienceFilterExpressionList struct {
	// FilterExpressions: A list of Audience filter expressions.
	FilterExpressions []*GoogleAnalyticsAdminV1alphaAudienceFilterExpression `json:"filterExpressions,omitempty"`

	// ForceSendFields is a list of field names (e.g. "FilterExpressions")
	// to unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "FilterExpressions") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *GoogleAnalyticsAdminV1alphaAudienceFilterExpressionList) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleAnalyticsAdminV1alphaAudienceFilterExpressionList
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleAnalyticsAdminV1alphaAudienceSequenceFilter: Defines filters
// that must occur in a specific order for the user to be a member of
// the Audience.
type GoogleAnalyticsAdminV1alphaAudienceSequenceFilter struct {
	// Scope: Required. Immutable. Specifies the scope for this filter.
	//
	// Possible values:
	//   "AUDIENCE_FILTER_SCOPE_UNSPECIFIED" - Scope is not specified.
	//   "AUDIENCE_FILTER_SCOPE_WITHIN_SAME_EVENT" - User joins the Audience
	// if the filter condition is met within one event.
	//   "AUDIENCE_FILTER_SCOPE_WITHIN_SAME_SESSION" - User joins the
	// Audience if the filter condition is met within one session.
	//   "AUDIENCE_FILTER_SCOPE_ACROSS_ALL_SESSIONS" - User joins the
	// Audience if the filter condition is met by any event across any
	// session.
	Scope string `json:"scope,omitempty"`

	// SequenceMaximumDuration: Optional. Defines the time period in which
	// the whole sequence must occur.
	SequenceMaximumDuration string `json:"sequenceMaximumDuration,omitempty"`

	// SequenceSteps: Required. An ordered sequence of steps. A user must
	// complete each step in order to join the sequence filter.
	SequenceSteps []*GoogleAnalyticsAdminV1alphaAudienceSequenceFilterAudienceSequenceStep `json:"sequenceSteps,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Scope") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Scope") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleAnalyticsAdminV1alphaAudienceSequenceFilter) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleAnalyticsAdminV1alphaAudienceSequenceFilter
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleAnalyticsAdminV1alphaAudienceSequenceFilterAudienceSequenceStep:
//
//	A condition that must occur in the specified step order for this
//
// user to match the sequence.
type GoogleAnalyticsAdminV1alphaAudienceSequenceFilterAudienceSequenceStep struct {
	// ConstraintDuration: Optional. When set, this step must be satisfied
	// within the constraint_duration of the previous step (For example,
	// t[i] - t[i-1] <= constraint_duration). If not set, there is no
	// duration requirement (the duration is effectively unlimited). It is
	// ignored for the first step.
	ConstraintDuration string `json:"constraintDuration,omitempty"`

	// FilterExpression: Required. Immutable. A logical expression of
	// Audience dimension, metric, or event filters in each step.
	FilterExpression *GoogleAnalyticsAdminV1alphaAudienceFilterExpression `json:"filterExpression,omitempty"`

	// ImmediatelyFollows: Optional. If true, the event satisfying this step
	// must be the very next event after the event satisfying the last step.
	// If unset or false, this step indirectly follows the prior step; for
	// example, there may be events between the prior step and this step. It
	// is ignored for the first step.
	ImmediatelyFollows bool `json:"immediatelyFollows,omitempty"`

	// Scope: Required. Immutable. Specifies the scope for this step.
	//
	// Possible values:
	//   "AUDIENCE_FILTER_SCOPE_UNSPECIFIED" - Scope is not specified.
	//   "AUDIENCE_FILTER_SCOPE_WITHIN_SAME_EVENT" - User joins the Audience
	// if the filter condition is met within one event.
	//   "AUDIENCE_FILTER_SCOPE_WITHIN_SAME_SESSION" - User joins the
	// Audience if the filter condition is met within one session.
	//   "AUDIENCE_FILTER_SCOPE_ACROSS_ALL_SESSIONS" - User joins the
	// Audience if the filter condition is met by any event across any
	// session.
	Scope string `json:"scope,omitempty"`

	// ForceSendFields is a list of field names (e.g. "ConstraintDuration")
	// to unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "ConstraintDuration") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *GoogleAnalyticsAdminV1alphaAudienceSequenceFilterAudienceSequenceStep) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleAnalyticsAdminV1alphaAudienceSequenceFilterAudienceSequenceStep
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleAnalyticsAdminV1alphaAudienceSimpleFilter: Defines a simple
// filter that a user must satisfy to be a member of the Audience.
type GoogleAnalyticsAdminV1alphaAudienceSimpleFilter struct {
	// FilterExpression: Required. Immutable. A logical expression of
	// Audience dimension, metric, or event filters.
	FilterExpression *GoogleAnalyticsAdminV1alphaAudienceFilterExpression `json:"filterExpression,omitempty"`

	// Scope: Required. Immutable. Specifies the scope for this filter.
	//
	// Possible values:
	//   "AUDIENCE_FILTER_SCOPE_UNSPECIFIED" - Scope is not specified.
	//   "AUDIENCE_FILTER_SCOPE_WITHIN_SAME_EVENT" - User joins the Audience
	// if the filter condition is met within one event.
	//   "AUDIENCE_FILTER_SCOPE_WITHIN_SAME_SESSION" - User joins the
	// Audience if the filter condition is met within one session.
	//   "AUDIENCE_FILTER_SCOPE_ACROSS_ALL_SESSIONS" - User joins the
	// Audience if the filter condition is met by any event across any
	// session.
	Scope string `json:"scope,omitempty"`

	// ForceSendFields is a list of field names (e.g. "FilterExpression") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "FilterExpression") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *GoogleAnalyticsAdminV1alphaAudienceSimpleFilter) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleAnalyticsAdminV1alphaAudienceSimpleFilter
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleAnalyticsAdminV1alphaAuditUserLink: Read-only resource used to
// summarize a principal's effective roles.
type GoogleAnalyticsAdminV1alphaAuditUserLink struct {
	// DirectRoles: Roles directly assigned to this user for this entity.
	// Format: predefinedRoles/viewer Excludes roles that are inherited from
	// an account (if this is for a property), group, or organization admin
	// role.
	DirectRoles []string `json:"directRoles,omitempty"`

	// EffectiveRoles: Union of all permissions a user has at this account
	// or property (includes direct permissions, group-inherited
	// permissions, etc.). Format: predefinedRoles/viewer
	EffectiveRoles []string `json:"effectiveRoles,omitempty"`

	// EmailAddress: Email address of the linked user
	EmailAddress string `json:"emailAddress,omitempty"`

	// Name: Example format: properties/1234/userLinks/5678
	Name string `json:"name,omitempty"`

	// ForceSendFields is a list of field names (e.g. "DirectRoles") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "DirectRoles") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleAnalyticsAdminV1alphaAuditUserLink) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleAnalyticsAdminV1alphaAuditUserLink
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleAnalyticsAdminV1alphaAuditUserLinksRequest: Request message for
// AuditUserLinks RPC.
type GoogleAnalyticsAdminV1alphaAuditUserLinksRequest struct {
	// PageSize: The maximum number of user links to return. The service may
	// return fewer than this value. If unspecified, at most 1000 user links
	// will be returned. The maximum value is 5000; values above 5000 will
	// be coerced to 5000.
	PageSize int64 `json:"pageSize,omitempty"`

	// PageToken: A page token, received from a previous `AuditUserLinks`
	// call. Provide this to retrieve the subsequent page. When paginating,
	// all other parameters provided to `AuditUserLinks` must match the call
	// that provided the page token.
	PageToken string `json:"pageToken,omitempty"`

	// ForceSendFields is a list of field names (e.g. "PageSize") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "PageSize") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleAnalyticsAdminV1alphaAuditUserLinksRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleAnalyticsAdminV1alphaAuditUserLinksRequest
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleAnalyticsAdminV1alphaAuditUserLinksResponse: Response message
// for AuditUserLinks RPC.
type GoogleAnalyticsAdminV1alphaAuditUserLinksResponse struct {
	// NextPageToken: A token, which can be sent as `page_token` to retrieve
	// the next page. If this field is omitted, there are no subsequent
	// pages.
	NextPageToken string `json:"nextPageToken,omitempty"`

	// UserLinks: List of AuditUserLinks. These will be ordered stably, but
	// in an arbitrary order.
	UserLinks []*GoogleAnalyticsAdminV1alphaAuditUserLink `json:"userLinks,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "NextPageToken") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "NextPageToken") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleAnalyticsAdminV1alphaAuditUserLinksResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleAnalyticsAdminV1alphaAuditUserLinksResponse
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleAnalyticsAdminV1alphaBatchCreateAccessBindingsRequest: Request
// message for BatchCreateAccessBindings RPC.
type GoogleAnalyticsAdminV1alphaBatchCreateAccessBindingsRequest struct {
	// Requests: Required. The requests specifying the access bindings to
	// create. A maximum of 1000 access bindings can be created in a batch.
	Requests []*GoogleAnalyticsAdminV1alphaCreateAccessBindingRequest `json:"requests,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Requests") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Requests") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleAnalyticsAdminV1alphaBatchCreateAccessBindingsRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleAnalyticsAdminV1alphaBatchCreateAccessBindingsRequest
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleAnalyticsAdminV1alphaBatchCreateAccessBindingsResponse:
// Response message for BatchCreateAccessBindings RPC.
type GoogleAnalyticsAdminV1alphaBatchCreateAccessBindingsResponse struct {
	// AccessBindings: The access bindings created.
	AccessBindings []*GoogleAnalyticsAdminV1alphaAccessBinding `json:"accessBindings,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "AccessBindings") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "AccessBindings") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *GoogleAnalyticsAdminV1alphaBatchCreateAccessBindingsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleAnalyticsAdminV1alphaBatchCreateAccessBindingsResponse
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleAnalyticsAdminV1alphaBatchCreateUserLinksRequest: Request
// message for BatchCreateUserLinks RPC.
type GoogleAnalyticsAdminV1alphaBatchCreateUserLinksRequest struct {
	// NotifyNewUsers: Optional. If set, then email the new users notifying
	// them that they've been granted permissions to the resource.
	// Regardless of whether this is set or not, notify_new_user field
	// inside each individual request is ignored.
	NotifyNewUsers bool `json:"notifyNewUsers,omitempty"`

	// Requests: Required. The requests specifying the user links to create.
	// A maximum of 1000 user links can be created in a batch.
	Requests []*GoogleAnalyticsAdminV1alphaCreateUserLinkRequest `json:"requests,omitempty"`

	// ForceSendFields is a list of field names (e.g. "NotifyNewUsers") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "NotifyNewUsers") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *GoogleAnalyticsAdminV1alphaBatchCreateUserLinksRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleAnalyticsAdminV1alphaBatchCreateUserLinksRequest
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleAnalyticsAdminV1alphaBatchCreateUserLinksResponse: Response
// message for BatchCreateUserLinks RPC.
type GoogleAnalyticsAdminV1alphaBatchCreateUserLinksResponse struct {
	// UserLinks: The user links created.
	UserLinks []*GoogleAnalyticsAdminV1alphaUserLink `json:"userLinks,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "UserLinks") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "UserLinks") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleAnalyticsAdminV1alphaBatchCreateUserLinksResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleAnalyticsAdminV1alphaBatchCreateUserLinksResponse
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleAnalyticsAdminV1alphaBatchDeleteAccessBindingsRequest: Request
// message for BatchDeleteAccessBindings RPC.
type GoogleAnalyticsAdminV1alphaBatchDeleteAccessBindingsRequest struct {
	// Requests: Required. The requests specifying the access bindings to
	// delete. A maximum of 1000 access bindings can be deleted in a batch.
	Requests []*GoogleAnalyticsAdminV1alphaDeleteAccessBindingRequest `json:"requests,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Requests") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Requests") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleAnalyticsAdminV1alphaBatchDeleteAccessBindingsRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleAnalyticsAdminV1alphaBatchDeleteAccessBindingsRequest
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleAnalyticsAdminV1alphaBatchDeleteUserLinksRequest: Request
// message for BatchDeleteUserLinks RPC.
type GoogleAnalyticsAdminV1alphaBatchDeleteUserLinksRequest struct {
	// Requests: Required. The requests specifying the user links to update.
	// A maximum of 1000 user links can be updated in a batch.
	Requests []*GoogleAnalyticsAdminV1alphaDeleteUserLinkRequest `json:"requests,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Requests") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Requests") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleAnalyticsAdminV1alphaBatchDeleteUserLinksRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleAnalyticsAdminV1alphaBatchDeleteUserLinksRequest
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleAnalyticsAdminV1alphaBatchGetAccessBindingsResponse: Response
// message for BatchGetAccessBindings RPC.
type GoogleAnalyticsAdminV1alphaBatchGetAccessBindingsResponse struct {
	// AccessBindings: The requested access bindings.
	AccessBindings []*GoogleAnalyticsAdminV1alphaAccessBinding `json:"accessBindings,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "AccessBindings") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "AccessBindings") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *GoogleAnalyticsAdminV1alphaBatchGetAccessBindingsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleAnalyticsAdminV1alphaBatchGetAccessBindingsResponse
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleAnalyticsAdminV1alphaBatchGetUserLinksResponse: Response
// message for BatchGetUserLinks RPC.
type GoogleAnalyticsAdminV1alphaBatchGetUserLinksResponse struct {
	// UserLinks: The requested user links.
	UserLinks []*GoogleAnalyticsAdminV1alphaUserLink `json:"userLinks,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "UserLinks") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "UserLinks") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleAnalyticsAdminV1alphaBatchGetUserLinksResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleAnalyticsAdminV1alphaBatchGetUserLinksResponse
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleAnalyticsAdminV1alphaBatchUpdateAccessBindingsRequest: Request
// message for BatchUpdateAccessBindings RPC.
type GoogleAnalyticsAdminV1alphaBatchUpdateAccessBindingsRequest struct {
	// Requests: Required. The requests specifying the access bindings to
	// update. A maximum of 1000 access bindings can be updated in a batch.
	Requests []*GoogleAnalyticsAdminV1alphaUpdateAccessBindingRequest `json:"requests,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Requests") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Requests") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleAnalyticsAdminV1alphaBatchUpdateAccessBindingsRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleAnalyticsAdminV1alphaBatchUpdateAccessBindingsRequest
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleAnalyticsAdminV1alphaBatchUpdateAccessBindingsResponse:
// Response message for BatchUpdateAccessBindings RPC.
type GoogleAnalyticsAdminV1alphaBatchUpdateAccessBindingsResponse struct {
	// AccessBindings: The access bindings updated.
	AccessBindings []*GoogleAnalyticsAdminV1alphaAccessBinding `json:"accessBindings,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "AccessBindings") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "AccessBindings") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *GoogleAnalyticsAdminV1alphaBatchUpdateAccessBindingsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleAnalyticsAdminV1alphaBatchUpdateAccessBindingsResponse
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleAnalyticsAdminV1alphaBatchUpdateUserLinksRequest: Request
// message for BatchUpdateUserLinks RPC.
type GoogleAnalyticsAdminV1alphaBatchUpdateUserLinksRequest struct {
	// Requests: Required. The requests specifying the user links to update.
	// A maximum of 1000 user links can be updated in a batch.
	Requests []*GoogleAnalyticsAdminV1alphaUpdateUserLinkRequest `json:"requests,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Requests") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Requests") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleAnalyticsAdminV1alphaBatchUpdateUserLinksRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleAnalyticsAdminV1alphaBatchUpdateUserLinksRequest
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleAnalyticsAdminV1alphaBatchUpdateUserLinksResponse: Response
// message for BatchUpdateUserLinks RPC.
type GoogleAnalyticsAdminV1alphaBatchUpdateUserLinksResponse struct {
	// UserLinks: The user links updated.
	UserLinks []*GoogleAnalyticsAdminV1alphaUserLink `json:"userLinks,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "UserLinks") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "UserLinks") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleAnalyticsAdminV1alphaBatchUpdateUserLinksResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleAnalyticsAdminV1alphaBatchUpdateUserLinksResponse
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleAnalyticsAdminV1alphaBigQueryLink: A link between a GA4
// Property and BigQuery project.
type GoogleAnalyticsAdminV1alphaBigQueryLink struct {
	// CreateTime: Output only. Time when the link was created.
	CreateTime string `json:"createTime,omitempty"`

	// DailyExportEnabled: If set true, enables daily data export to the
	// linked Google Cloud project.
	DailyExportEnabled bool `json:"dailyExportEnabled,omitempty"`

	// ExcludedEvents: The list of event names that will be excluded from
	// exports.
	ExcludedEvents []string `json:"excludedEvents,omitempty"`

	// ExportStreams: The list of streams under the parent property for
	// which data will be exported. Format:
	// properties/{property_id}/dataStreams/{stream_id} Example:
	// ['properties/1000/dataStreams/2000']
	ExportStreams []string `json:"exportStreams,omitempty"`

	// IncludeAdvertisingId: If set true, exported data will include
	// advertising identifiers for mobile app streams.
	IncludeAdvertisingId bool `json:"includeAdvertisingId,omitempty"`

	// IntradayExportEnabled: If set true, enables intraday export to the
	// linked Google Cloud project.
	IntradayExportEnabled bool `json:"intradayExportEnabled,omitempty"`

	// Name: Output only. Resource name of this BigQuery link. Format:
	// 'properties/{property_id}/bigQueryLinks/{bigquery_link_id}' Format:
	// 'properties/1234/bigQueryLinks/abc567'
	Name string `json:"name,omitempty"`

	// Project: Immutable. The linked Google Cloud project. When creating a
	// BigQueryLink, you may provide this resource name using either a
	// project number or project ID. Once this resource has been created,
	// the returned project will always have a project that contains a
	// project number. Format: 'projects/{project number}' Example:
	// 'projects/1234'
	Project string `json:"project,omitempty"`

	// StreamingExportEnabled: If set true, enables streaming export to the
	// linked Google Cloud project.
	StreamingExportEnabled bool `json:"streamingExportEnabled,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "CreateTime") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "CreateTime") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleAnalyticsAdminV1alphaBigQueryLink) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleAnalyticsAdminV1alphaBigQueryLink
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleAnalyticsAdminV1alphaCancelDisplayVideo360AdvertiserLinkProposal
// Request: Request message for
// CancelDisplayVideo360AdvertiserLinkProposal RPC.
type GoogleAnalyticsAdminV1alphaCancelDisplayVideo360AdvertiserLinkProposalRequest struct {
}

// GoogleAnalyticsAdminV1alphaChangeHistoryChange: A description of a
// change to a single Google Analytics resource.
type GoogleAnalyticsAdminV1alphaChangeHistoryChange struct {
	// Action: The type of action that changed this resource.
	//
	// Possible values:
	//   "ACTION_TYPE_UNSPECIFIED" - Action type unknown or not specified.
	//   "CREATED" - Resource was created in this change.
	//   "UPDATED" - Resource was updated in this change.
	//   "DELETED" - Resource was deleted in this change.
	Action string `json:"action,omitempty"`

	// Resource: Resource name of the resource whose changes are described
	// by this entry.
	Resource string `json:"resource,omitempty"`

	// ResourceAfterChange: Resource contents from after the change was
	// made. If this resource was deleted in this change, this field will be
	// missing.
	ResourceAfterChange *GoogleAnalyticsAdminV1alphaChangeHistoryChangeChangeHistoryResource `json:"resourceAfterChange,omitempty"`

	// ResourceBeforeChange: Resource contents from before the change was
	// made. If this resource was created in this change, this field will be
	// missing.
	ResourceBeforeChange *GoogleAnalyticsAdminV1alphaChangeHistoryChangeChangeHistoryResource `json:"resourceBeforeChange,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Action") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Action") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleAnalyticsAdminV1alphaChangeHistoryChange) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleAnalyticsAdminV1alphaChangeHistoryChange
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleAnalyticsAdminV1alphaChangeHistoryChangeChangeHistoryResource:
// A snapshot of a resource as before or after the result of a change in
// change history.
type GoogleAnalyticsAdminV1alphaChangeHistoryChangeChangeHistoryResource struct {
	// Account: A snapshot of an Account resource in change history.
	Account *GoogleAnalyticsAdminV1alphaAccount `json:"account,omitempty"`

	// AttributionSettings: A snapshot of AttributionSettings resource in
	// change history.
	AttributionSettings *GoogleAnalyticsAdminV1alphaAttributionSettings `json:"attributionSettings,omitempty"`

	// BigqueryLink: A snapshot of a BigQuery link resource in change
	// history.
	BigqueryLink *GoogleAnalyticsAdminV1alphaBigQueryLink `json:"bigqueryLink,omitempty"`

	// ChannelGroup: A snapshot of a ChannelGroup resource in change
	// history.
	ChannelGroup *GoogleAnalyticsAdminV1alphaChannelGroup `json:"channelGroup,omitempty"`

	// ConversionEvent: A snapshot of a ConversionEvent resource in change
	// history.
	ConversionEvent *GoogleAnalyticsAdminV1alphaConversionEvent `json:"conversionEvent,omitempty"`

	// CustomDimension: A snapshot of a CustomDimension resource in change
	// history.
	CustomDimension *GoogleAnalyticsAdminV1alphaCustomDimension `json:"customDimension,omitempty"`

	// CustomMetric: A snapshot of a CustomMetric resource in change
	// history.
	CustomMetric *GoogleAnalyticsAdminV1alphaCustomMetric `json:"customMetric,omitempty"`

	// DataRetentionSettings: A snapshot of a data retention settings
	// resource in change history.
	DataRetentionSettings *GoogleAnalyticsAdminV1alphaDataRetentionSettings `json:"dataRetentionSettings,omitempty"`

	// DataStream: A snapshot of a DataStream resource in change history.
	DataStream *GoogleAnalyticsAdminV1alphaDataStream `json:"dataStream,omitempty"`

	// DisplayVideo360AdvertiserLink: A snapshot of a
	// DisplayVideo360AdvertiserLink resource in change history.
	DisplayVideo360AdvertiserLink *GoogleAnalyticsAdminV1alphaDisplayVideo360AdvertiserLink `json:"displayVideo360AdvertiserLink,omitempty"`

	// DisplayVideo360AdvertiserLinkProposal: A snapshot of a
	// DisplayVideo360AdvertiserLinkProposal resource in change history.
	DisplayVideo360AdvertiserLinkProposal *GoogleAnalyticsAdminV1alphaDisplayVideo360AdvertiserLinkProposal `json:"displayVideo360AdvertiserLinkProposal,omitempty"`

	// EnhancedMeasurementSettings: A snapshot of
	// EnhancedMeasurementSettings resource in change history.
	EnhancedMeasurementSettings *GoogleAnalyticsAdminV1alphaEnhancedMeasurementSettings `json:"enhancedMeasurementSettings,omitempty"`

	// ExpandedDataSet: A snapshot of an ExpandedDataSet resource in change
	// history.
	ExpandedDataSet *GoogleAnalyticsAdminV1alphaExpandedDataSet `json:"expandedDataSet,omitempty"`

	// FirebaseLink: A snapshot of a FirebaseLink resource in change
	// history.
	FirebaseLink *GoogleAnalyticsAdminV1alphaFirebaseLink `json:"firebaseLink,omitempty"`

	// GoogleAdsLink: A snapshot of a GoogleAdsLink resource in change
	// history.
	GoogleAdsLink *GoogleAnalyticsAdminV1alphaGoogleAdsLink `json:"googleAdsLink,omitempty"`

	// GoogleSignalsSettings: A snapshot of a GoogleSignalsSettings resource
	// in change history.
	GoogleSignalsSettings *GoogleAnalyticsAdminV1alphaGoogleSignalsSettings `json:"googleSignalsSettings,omitempty"`

	// MeasurementProtocolSecret: A snapshot of a MeasurementProtocolSecret
	// resource in change history.
	MeasurementProtocolSecret *GoogleAnalyticsAdminV1alphaMeasurementProtocolSecret `json:"measurementProtocolSecret,omitempty"`

	// Property: A snapshot of a Property resource in change history.
	Property *GoogleAnalyticsAdminV1alphaProperty `json:"property,omitempty"`

	// SearchAds360Link: A snapshot of a SearchAds360Link resource in change
	// history.
	SearchAds360Link *GoogleAnalyticsAdminV1alphaSearchAds360Link `json:"searchAds360Link,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Account") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Account") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleAnalyticsAdminV1alphaChangeHistoryChangeChangeHistoryResource) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleAnalyticsAdminV1alphaChangeHistoryChangeChangeHistoryResource
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleAnalyticsAdminV1alphaChangeHistoryEvent: A set of changes
// within a Google Analytics account or its child properties that
// resulted from the same cause. Common causes would be updates made in
// the Google Analytics UI, changes from customer support, or automatic
// Google Analytics system changes.
type GoogleAnalyticsAdminV1alphaChangeHistoryEvent struct {
	// ActorType: The type of actor that made this change.
	//
	// Possible values:
	//   "ACTOR_TYPE_UNSPECIFIED" - Unknown or unspecified actor type.
	//   "USER" - Changes made by the user specified in actor_email.
	//   "SYSTEM" - Changes made by the Google Analytics system.
	//   "SUPPORT" - Changes made by Google Analytics support team staff.
	ActorType string `json:"actorType,omitempty"`

	// ChangeTime: Time when change was made.
	ChangeTime string `json:"changeTime,omitempty"`

	// Changes: A list of changes made in this change history event that fit
	// the filters specified in SearchChangeHistoryEventsRequest.
	Changes []*GoogleAnalyticsAdminV1alphaChangeHistoryChange `json:"changes,omitempty"`

	// ChangesFiltered: If true, then the list of changes returned was
	// filtered, and does not represent all changes that occurred in this
	// event.
	ChangesFiltered bool `json:"changesFiltered,omitempty"`

	// Id: ID of this change history event. This ID is unique across Google
	// Analytics.
	Id string `json:"id,omitempty"`

	// UserActorEmail: Email address of the Google account that made the
	// change. This will be a valid email address if the actor field is set
	// to USER, and empty otherwise. Google accounts that have been deleted
	// will cause an error.
	UserActorEmail string `json:"userActorEmail,omitempty"`

	// ForceSendFields is a list of field names (e.g. "ActorType") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "ActorType") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleAnalyticsAdminV1alphaChangeHistoryEvent) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleAnalyticsAdminV1alphaChangeHistoryEvent
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleAnalyticsAdminV1alphaChannelGroup: A resource message
// representing a Channel Group.
type GoogleAnalyticsAdminV1alphaChannelGroup struct {
	// Description: The description of the Channel Group. Max length of 256
	// characters.
	Description string `json:"description,omitempty"`

	// DisplayName: Required. The display name of the Channel Group. Max
	// length of 80 characters.
	DisplayName string `json:"displayName,omitempty"`

	// GroupingRule: Required. The grouping rules of channels. Maximum
	// number of rules is 25.
	GroupingRule []*GoogleAnalyticsAdminV1alphaGroupingRule `json:"groupingRule,omitempty"`

	// Name: Output only. The resource name for this Channel Group resource.
	// Format: properties/{property}/channelGroups/{channel_group}
	Name string `json:"name,omitempty"`

	// SystemDefined: Output only. Default Channel Group defined by Google,
	// which cannot be updated.
	SystemDefined bool `json:"systemDefined,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "Description") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Description") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleAnalyticsAdminV1alphaChannelGroup) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleAnalyticsAdminV1alphaChannelGroup
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleAnalyticsAdminV1alphaChannelGroupFilter: A specific filter for
// a single dimension.
type GoogleAnalyticsAdminV1alphaChannelGroupFilter struct {
	// FieldName: Required. Immutable. The dimension name to filter.
	FieldName string `json:"fieldName,omitempty"`

	// InListFilter: A filter for a string dimension that matches a
	// particular list of options.
	InListFilter *GoogleAnalyticsAdminV1alphaChannelGroupFilterInListFilter `json:"inListFilter,omitempty"`

	// StringFilter: A filter for a string-type dimension that matches a
	// particular pattern.
	StringFilter *GoogleAnalyticsAdminV1alphaChannelGroupFilterStringFilter `json:"stringFilter,omitempty"`

	// ForceSendFields is a list of field names (e.g. "FieldName") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "FieldName") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleAnalyticsAdminV1alphaChannelGroupFilter) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleAnalyticsAdminV1alphaChannelGroupFilter
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleAnalyticsAdminV1alphaChannelGroupFilterExpression: A logical
// expression of Channel Group dimension filters.
type GoogleAnalyticsAdminV1alphaChannelGroupFilterExpression struct {
	// AndGroup: A list of expressions to be AND’ed together. It can only
	// contain ChannelGroupFilterExpressions with or_group. This must be set
	// for the top level ChannelGroupFilterExpression.
	AndGroup *GoogleAnalyticsAdminV1alphaChannelGroupFilterExpressionList `json:"andGroup,omitempty"`

	// Filter: A filter on a single dimension. This cannot be set on the top
	// level ChannelGroupFilterExpression.
	Filter *GoogleAnalyticsAdminV1alphaChannelGroupFilter `json:"filter,omitempty"`

	// NotExpression: A filter expression to be NOT'ed (that is inverted,
	// complemented). It can only include a dimension_or_metric_filter. This
	// cannot be set on the top level ChannelGroupFilterExpression.
	NotExpression *GoogleAnalyticsAdminV1alphaChannelGroupFilterExpression `json:"notExpression,omitempty"`

	// OrGroup: A list of expressions to OR’ed together. It cannot contain
	// ChannelGroupFilterExpressions with and_group or or_group.
	OrGroup *GoogleAnalyticsAdminV1alphaChannelGroupFilterExpressionList `json:"orGroup,omitempty"`

	// ForceSendFields is a list of field names (e.g. "AndGroup") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "AndGroup") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleAnalyticsAdminV1alphaChannelGroupFilterExpression) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleAnalyticsAdminV1alphaChannelGroupFilterExpression
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleAnalyticsAdminV1alphaChannelGroupFilterExpressionList: A list
// of Channel Group filter expressions.
type GoogleAnalyticsAdminV1alphaChannelGroupFilterExpressionList struct {
	// FilterExpressions: A list of Channel Group filter expressions.
	FilterExpressions []*GoogleAnalyticsAdminV1alphaChannelGroupFilterExpression `json:"filterExpressions,omitempty"`

	// ForceSendFields is a list of field names (e.g. "FilterExpressions")
	// to unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "FilterExpressions") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *GoogleAnalyticsAdminV1alphaChannelGroupFilterExpressionList) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleAnalyticsAdminV1alphaChannelGroupFilterExpressionList
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleAnalyticsAdminV1alphaChannelGroupFilterInListFilter: A filter
// for a string dimension that matches a particular list of options. The
// match is case insensitive.
type GoogleAnalyticsAdminV1alphaChannelGroupFilterInListFilter struct {
	// Values: Required. The list of possible string values to match
	// against. Must be non-empty.
	Values []string `json:"values,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Values") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Values") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleAnalyticsAdminV1alphaChannelGroupFilterInListFilter) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleAnalyticsAdminV1alphaChannelGroupFilterInListFilter
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleAnalyticsAdminV1alphaChannelGroupFilterStringFilter: Filter
// where the field value is a String. The match is case insensitive.
type GoogleAnalyticsAdminV1alphaChannelGroupFilterStringFilter struct {
	// MatchType: Required. The match type for the string filter.
	//
	// Possible values:
	//   "MATCH_TYPE_UNSPECIFIED" - Default match type.
	//   "EXACT" - Exact match of the string value.
	//   "BEGINS_WITH" - Begins with the string value.
	//   "ENDS_WITH" - Ends with the string value.
	//   "CONTAINS" - Contains the string value.
	//   "FULL_REGEXP" - Full regular expression match with the string
	// value.
	//   "PARTIAL_REGEXP" - Partial regular expression match with the string
	// value.
	MatchType string `json:"matchType,omitempty"`

	// Value: Required. The string value to be matched against.
	Value string `json:"value,omitempty"`

	// ForceSendFields is a list of field names (e.g. "MatchType") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "MatchType") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleAnalyticsAdminV1alphaChannelGroupFilterStringFilter) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleAnalyticsAdminV1alphaChannelGroupFilterStringFilter
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleAnalyticsAdminV1alphaConnectedSiteTag: Configuration for a
// specific Connected Site Tag.
type GoogleAnalyticsAdminV1alphaConnectedSiteTag struct {
	// DisplayName: Required. User-provided display name for the connected
	// site tag. Must be less than 256 characters.
	DisplayName string `json:"displayName,omitempty"`

	// TagId: Required. "Tag ID to forward events to. Also known as the
	// Measurement ID, or the "G-ID" (For example: G-12345).
	TagId string `json:"tagId,omitempty"`

	// ForceSendFields is a list of field names (e.g. "DisplayName") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "DisplayName") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleAnalyticsAdminV1alphaConnectedSiteTag) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleAnalyticsAdminV1alphaConnectedSiteTag
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleAnalyticsAdminV1alphaConversionEvent: A conversion event in a
// Google Analytics property.
type GoogleAnalyticsAdminV1alphaConversionEvent struct {
	// CreateTime: Output only. Time when this conversion event was created
	// in the property.
	CreateTime string `json:"createTime,omitempty"`

	// Custom: Output only. If set to true, this conversion event refers to
	// a custom event. If set to false, this conversion event refers to a
	// default event in GA. Default events typically have special meaning in
	// GA. Default events are usually created for you by the GA system, but
	// in some cases can be created by property admins. Custom events count
	// towards the maximum number of custom conversion events that may be
	// created per property.
	Custom bool `json:"custom,omitempty"`

	// Deletable: Output only. If set, this event can currently be deleted
	// with DeleteConversionEvent.
	Deletable bool `json:"deletable,omitempty"`

	// EventName: Immutable. The event name for this conversion event.
	// Examples: 'click', 'purchase'
	EventName string `json:"eventName,omitempty"`

	// Name: Output only. Resource name of this conversion event. Format:
	// properties/{property}/conversionEvents/{conversion_event}
	Name string `json:"name,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "CreateTime") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "CreateTime") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleAnalyticsAdminV1alphaConversionEvent) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleAnalyticsAdminV1alphaConversionEvent
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleAnalyticsAdminV1alphaCreateAccessBindingRequest: Request
// message for CreateAccessBinding RPC.
type GoogleAnalyticsAdminV1alphaCreateAccessBindingRequest struct {
	// AccessBinding: Required. The access binding to create.
	AccessBinding *GoogleAnalyticsAdminV1alphaAccessBinding `json:"accessBinding,omitempty"`

	// Parent: Required. Formats: - accounts/{account} -
	// properties/{property}
	Parent string `json:"parent,omitempty"`

	// ForceSendFields is a list of field names (e.g. "AccessBinding") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "AccessBinding") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleAnalyticsAdminV1alphaCreateAccessBindingRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleAnalyticsAdminV1alphaCreateAccessBindingRequest
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleAnalyticsAdminV1alphaCreateConnectedSiteTagRequest: Request
// message for CreateConnectedSiteTag RPC.
type GoogleAnalyticsAdminV1alphaCreateConnectedSiteTagRequest struct {
	// ConnectedSiteTag: Required. The tag to add to the Universal Analytics
	// property
	ConnectedSiteTag *GoogleAnalyticsAdminV1alphaConnectedSiteTag `json:"connectedSiteTag,omitempty"`

	// Property: The Universal Analytics property to create connected site
	// tags for. This API does not support GA4 properties. Format:
	// properties/{universalAnalyticsPropertyId} Example: properties/1234
	Property string `json:"property,omitempty"`

	// ForceSendFields is a list of field names (e.g. "ConnectedSiteTag") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "ConnectedSiteTag") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *GoogleAnalyticsAdminV1alphaCreateConnectedSiteTagRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleAnalyticsAdminV1alphaCreateConnectedSiteTagRequest
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleAnalyticsAdminV1alphaCreateConnectedSiteTagResponse: Response
// message for CreateConnectedSiteTag RPC.
type GoogleAnalyticsAdminV1alphaCreateConnectedSiteTagResponse struct {
	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`
}

// GoogleAnalyticsAdminV1alphaCreateUserLinkRequest: Request message for
// CreateUserLink RPC. Users can have multiple email addresses
// associated with their Google account, and one of these email
// addresses is the "primary" email address. Any of the email addresses
// associated with a Google account may be used for a new UserLink, but
// the returned UserLink will always contain the "primary" email
// address. As a result, the input and output email address for this
// request may differ.
type GoogleAnalyticsAdminV1alphaCreateUserLinkRequest struct {
	// NotifyNewUser: Optional. If set, then email the new user notifying
	// them that they've been granted permissions to the resource.
	NotifyNewUser bool `json:"notifyNewUser,omitempty"`

	// Parent: Required. Example format: accounts/1234
	Parent string `json:"parent,omitempty"`

	// UserLink: Required. The user link to create.
	UserLink *GoogleAnalyticsAdminV1alphaUserLink `json:"userLink,omitempty"`

	// ForceSendFields is a list of field names (e.g. "NotifyNewUser") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "NotifyNewUser") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleAnalyticsAdminV1alphaCreateUserLinkRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleAnalyticsAdminV1alphaCreateUserLinkRequest
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleAnalyticsAdminV1alphaCustomDimension: A definition for a
// CustomDimension.
type GoogleAnalyticsAdminV1alphaCustomDimension struct {
	// Description: Optional. Description for this custom dimension. Max
	// length of 150 characters.
	Description string `json:"description,omitempty"`

	// DisallowAdsPersonalization: Optional. If set to true, sets this
	// dimension as NPA and excludes it from ads personalization. This is
	// currently only supported by user-scoped custom dimensions.
	DisallowAdsPersonalization bool `json:"disallowAdsPersonalization,omitempty"`

	// DisplayName: Required. Display name for this custom dimension as
	// shown in the Analytics UI. Max length of 82 characters, alphanumeric
	// plus space and underscore starting with a letter. Legacy
	// system-generated display names may contain square brackets, but
	// updates to this field will never permit square brackets.
	DisplayName string `json:"displayName,omitempty"`

	// Name: Output only. Resource name for this CustomDimension resource.
	// Format: properties/{property}/customDimensions/{customDimension}
	Name string `json:"name,omitempty"`

	// ParameterName: Required. Immutable. Tagging parameter name for this
	// custom dimension. If this is a user-scoped dimension, then this is
	// the user property name. If this is an event-scoped dimension, then
	// this is the event parameter name. If this is an item-scoped
	// dimension, then this is the parameter name found in the eCommerce
	// items array. May only contain alphanumeric and underscore characters,
	// starting with a letter. Max length of 24 characters for user-scoped
	// dimensions, 40 characters for event-scoped dimensions.
	ParameterName string `json:"parameterName,omitempty"`

	// Scope: Required. Immutable. The scope of this dimension.
	//
	// Possible values:
	//   "DIMENSION_SCOPE_UNSPECIFIED" - Scope unknown or not specified.
	//   "EVENT" - Dimension scoped to an event.
	//   "USER" - Dimension scoped to a user.
	//   "ITEM" - Dimension scoped to eCommerce items
	Scope string `json:"scope,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "Description") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Description") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleAnalyticsAdminV1alphaCustomDimension) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleAnalyticsAdminV1alphaCustomDimension
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleAnalyticsAdminV1alphaCustomMetric: A definition for a custom
// metric.
type GoogleAnalyticsAdminV1alphaCustomMetric struct {
	// Description: Optional. Description for this custom dimension. Max
	// length of 150 characters.
	Description string `json:"description,omitempty"`

	// DisplayName: Required. Display name for this custom metric as shown
	// in the Analytics UI. Max length of 82 characters, alphanumeric plus
	// space and underscore starting with a letter. Legacy system-generated
	// display names may contain square brackets, but updates to this field
	// will never permit square brackets.
	DisplayName string `json:"displayName,omitempty"`

	// MeasurementUnit: Required. The type for the custom metric's value.
	//
	// Possible values:
	//   "MEASUREMENT_UNIT_UNSPECIFIED" - MeasurementUnit unspecified or
	// missing.
	//   "STANDARD" - This metric uses default units.
	//   "CURRENCY" - This metric measures a currency.
	//   "FEET" - This metric measures feet.
	//   "METERS" - This metric measures meters.
	//   "KILOMETERS" - This metric measures kilometers.
	//   "MILES" - This metric measures miles.
	//   "MILLISECONDS" - This metric measures milliseconds.
	//   "SECONDS" - This metric measures seconds.
	//   "MINUTES" - This metric measures minutes.
	//   "HOURS" - This metric measures hours.
	MeasurementUnit string `json:"measurementUnit,omitempty"`

	// Name: Output only. Resource name for this CustomMetric resource.
	// Format: properties/{property}/customMetrics/{customMetric}
	Name string `json:"name,omitempty"`

	// ParameterName: Required. Immutable. Tagging name for this custom
	// metric. If this is an event-scoped metric, then this is the event
	// parameter name. May only contain alphanumeric and underscore
	// charactes, starting with a letter. Max length of 40 characters for
	// event-scoped metrics.
	ParameterName string `json:"parameterName,omitempty"`

	// RestrictedMetricType: Optional. Types of restricted data that this
	// metric may contain. Required for metrics with CURRENCY measurement
	// unit. Must be empty for metrics with a non-CURRENCY measurement unit.
	//
	// Possible values:
	//   "RESTRICTED_METRIC_TYPE_UNSPECIFIED" - Type unknown or unspecified.
	//   "COST_DATA" - Metric reports cost data.
	//   "REVENUE_DATA" - Metric reports revenue data.
	RestrictedMetricType []string `json:"restrictedMetricType,omitempty"`

	// Scope: Required. Immutable. The scope of this custom metric.
	//
	// Possible values:
	//   "METRIC_SCOPE_UNSPECIFIED" - Scope unknown or not specified.
	//   "EVENT" - Metric scoped to an event.
	Scope string `json:"scope,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "Description") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Description") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleAnalyticsAdminV1alphaCustomMetric) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleAnalyticsAdminV1alphaCustomMetric
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleAnalyticsAdminV1alphaDataRetentionSettings: Settings values for
// data retention. This is a singleton resource.
type GoogleAnalyticsAdminV1alphaDataRetentionSettings struct {
	// EventDataRetention: The length of time that event-level data is
	// retained.
	//
	// Possible values:
	//   "RETENTION_DURATION_UNSPECIFIED" - Data retention time duration is
	// not specified.
	//   "TWO_MONTHS" - The data retention time duration is 2 months.
	//   "FOURTEEN_MONTHS" - The data retention time duration is 14 months.
	//   "TWENTY_SIX_MONTHS" - The data retention time duration is 26
	// months. Available to 360 properties only.
	//   "THIRTY_EIGHT_MONTHS" - The data retention time duration is 38
	// months. Available to 360 properties only.
	//   "FIFTY_MONTHS" - The data retention time duration is 50 months.
	// Available to 360 properties only.
	EventDataRetention string `json:"eventDataRetention,omitempty"`

	// Name: Output only. Resource name for this DataRetentionSetting
	// resource. Format: properties/{property}/dataRetentionSettings
	Name string `json:"name,omitempty"`

	// ResetUserDataOnNewActivity: If true, reset the retention period for
	// the user identifier with every event from that user.
	ResetUserDataOnNewActivity bool `json:"resetUserDataOnNewActivity,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "EventDataRetention")
	// to unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "EventDataRetention") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *GoogleAnalyticsAdminV1alphaDataRetentionSettings) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleAnalyticsAdminV1alphaDataRetentionSettings
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleAnalyticsAdminV1alphaDataSharingSettings: A resource message
// representing data sharing settings of a Google Analytics account.
type GoogleAnalyticsAdminV1alphaDataSharingSettings struct {
	// Name: Output only. Resource name. Format:
	// accounts/{account}/dataSharingSettings Example:
	// "accounts/1000/dataSharingSettings"
	Name string `json:"name,omitempty"`

	// SharingWithGoogleAnySalesEnabled: Allows any of Google sales to
	// access the data in order to suggest configuration changes to improve
	// results.
	SharingWithGoogleAnySalesEnabled bool `json:"sharingWithGoogleAnySalesEnabled,omitempty"`

	// SharingWithGoogleAssignedSalesEnabled: Allows Google sales teams that
	// are assigned to the customer to access the data in order to suggest
	// configuration changes to improve results. Sales team restrictions
	// still apply when enabled.
	SharingWithGoogleAssignedSalesEnabled bool `json:"sharingWithGoogleAssignedSalesEnabled,omitempty"`

	// SharingWithGoogleProductsEnabled: Allows Google to use the data to
	// improve other Google products or services.
	SharingWithGoogleProductsEnabled bool `json:"sharingWithGoogleProductsEnabled,omitempty"`

	// SharingWithGoogleSupportEnabled: Allows Google support to access the
	// data in order to help troubleshoot issues.
	SharingWithGoogleSupportEnabled bool `json:"sharingWithGoogleSupportEnabled,omitempty"`

	// SharingWithOthersEnabled: Allows Google to share the data anonymously
	// in aggregate form with others.
	SharingWithOthersEnabled bool `json:"sharingWithOthersEnabled,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "Name") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Name") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleAnalyticsAdminV1alphaDataSharingSettings) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleAnalyticsAdminV1alphaDataSharingSettings
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleAnalyticsAdminV1alphaDataStream: A resource message
// representing a data stream.
type GoogleAnalyticsAdminV1alphaDataStream struct {
	// AndroidAppStreamData: Data specific to Android app streams. Must be
	// populated if type is ANDROID_APP_DATA_STREAM.
	AndroidAppStreamData *GoogleAnalyticsAdminV1alphaDataStreamAndroidAppStreamData `json:"androidAppStreamData,omitempty"`

	// CreateTime: Output only. Time when this stream was originally
	// created.
	CreateTime string `json:"createTime,omitempty"`

	// DisplayName: Human-readable display name for the Data Stream.
	// Required for web data streams. The max allowed display name length is
	// 255 UTF-16 code units.
	DisplayName string `json:"displayName,omitempty"`

	// IosAppStreamData: Data specific to iOS app streams. Must be populated
	// if type is IOS_APP_DATA_STREAM.
	IosAppStreamData *GoogleAnalyticsAdminV1alphaDataStreamIosAppStreamData `json:"iosAppStreamData,omitempty"`

	// Name: Output only. Resource name of this Data Stream. Format:
	// properties/{property_id}/dataStreams/{stream_id} Example:
	// "properties/1000/dataStreams/2000"
	Name string `json:"name,omitempty"`

	// Type: Required. Immutable. The type of this DataStream resource.
	//
	// Possible values:
	//   "DATA_STREAM_TYPE_UNSPECIFIED" - Type unknown or not specified.
	//   "WEB_DATA_STREAM" - Web data stream.
	//   "ANDROID_APP_DATA_STREAM" - Android app data stream.
	//   "IOS_APP_DATA_STREAM" - iOS app data stream.
	Type string `json:"type,omitempty"`

	// UpdateTime: Output only. Time when stream payload fields were last
	// updated.
	UpdateTime string `json:"updateTime,omitempty"`

	// WebStreamData: Data specific to web streams. Must be populated if
	// type is WEB_DATA_STREAM.
	WebStreamData *GoogleAnalyticsAdminV1alphaDataStreamWebStreamData `json:"webStreamData,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g.
	// "AndroidAppStreamData") to unconditionally include in API requests.
	// By default, fields with empty or default values are omitted from API
	// requests. However, any non-pointer, non-interface field appearing in
	// ForceSendFields will be sent to the server regardless of whether the
	// field is empty or not. This may be used to include empty fields in
	// Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "AndroidAppStreamData") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *GoogleAnalyticsAdminV1alphaDataStream) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleAnalyticsAdminV1alphaDataStream
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleAnalyticsAdminV1alphaDataStreamAndroidAppStreamData: Data
// specific to Android app streams.
type GoogleAnalyticsAdminV1alphaDataStreamAndroidAppStreamData struct {
	// FirebaseAppId: Output only. ID of the corresponding Android app in
	// Firebase, if any. This ID can change if the Android app is deleted
	// and recreated.
	FirebaseAppId string `json:"firebaseAppId,omitempty"`

	// PackageName: Immutable. The package name for the app being measured.
	// Example: "com.example.myandroidapp"
	PackageName string `json:"packageName,omitempty"`

	// ForceSendFields is a list of field names (e.g. "FirebaseAppId") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "FirebaseAppId") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleAnalyticsAdminV1alphaDataStreamAndroidAppStreamData) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleAnalyticsAdminV1alphaDataStreamAndroidAppStreamData
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleAnalyticsAdminV1alphaDataStreamIosAppStreamData: Data specific
// to iOS app streams.
type GoogleAnalyticsAdminV1alphaDataStreamIosAppStreamData struct {
	// BundleId: Required. Immutable. The Apple App Store Bundle ID for the
	// app Example: "com.example.myiosapp"
	BundleId string `json:"bundleId,omitempty"`

	// FirebaseAppId: Output only. ID of the corresponding iOS app in
	// Firebase, if any. This ID can change if the iOS app is deleted and
	// recreated.
	FirebaseAppId string `json:"firebaseAppId,omitempty"`

	// ForceSendFields is a list of field names (e.g. "BundleId") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "BundleId") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleAnalyticsAdminV1alphaDataStreamIosAppStreamData) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleAnalyticsAdminV1alphaDataStreamIosAppStreamData
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleAnalyticsAdminV1alphaDataStreamWebStreamData: Data specific to
// web streams.
type GoogleAnalyticsAdminV1alphaDataStreamWebStreamData struct {
	// DefaultUri: Immutable. Domain name of the web app being measured, or
	// empty. Example: "http://www.google.com", "https://www.google.com"
	DefaultUri string `json:"defaultUri,omitempty"`

	// FirebaseAppId: Output only. ID of the corresponding web app in
	// Firebase, if any. This ID can change if the web app is deleted and
	// recreated.
	FirebaseAppId string `json:"firebaseAppId,omitempty"`

	// MeasurementId: Output only. Analytics "Measurement ID", without the
	// "G-" prefix. Example: "G-1A2BCD345E" would just be "1A2BCD345E"
	MeasurementId string `json:"measurementId,omitempty"`

	// ForceSendFields is a list of field names (e.g. "DefaultUri") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "DefaultUri") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleAnalyticsAdminV1alphaDataStreamWebStreamData) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleAnalyticsAdminV1alphaDataStreamWebStreamData
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleAnalyticsAdminV1alphaDeleteAccessBindingRequest: Request
// message for DeleteAccessBinding RPC.
type GoogleAnalyticsAdminV1alphaDeleteAccessBindingRequest struct {
	// Name: Required. Formats: -
	// accounts/{account}/accessBindings/{accessBinding} -
	// properties/{property}/accessBindings/{accessBinding}
	Name string `json:"name,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Name") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Name") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleAnalyticsAdminV1alphaDeleteAccessBindingRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleAnalyticsAdminV1alphaDeleteAccessBindingRequest
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleAnalyticsAdminV1alphaDeleteConnectedSiteTagRequest: Request
// message for DeleteConnectedSiteTag RPC.
type GoogleAnalyticsAdminV1alphaDeleteConnectedSiteTagRequest struct {
	// Property: The Universal Analytics property to delete connected site
	// tags for. This API does not support GA4 properties. Format:
	// properties/{universalAnalyticsPropertyId} Example: properties/1234
	Property string `json:"property,omitempty"`

	// TagId: Tag ID to forward events to. Also known as the Measurement ID,
	// or the "G-ID" (For example: G-12345).
	TagId string `json:"tagId,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Property") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Property") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleAnalyticsAdminV1alphaDeleteConnectedSiteTagRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleAnalyticsAdminV1alphaDeleteConnectedSiteTagRequest
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleAnalyticsAdminV1alphaDeleteUserLinkRequest: Request message for
// DeleteUserLink RPC.
type GoogleAnalyticsAdminV1alphaDeleteUserLinkRequest struct {
	// Name: Required. Example format: accounts/1234/userLinks/5678
	Name string `json:"name,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Name") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Name") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleAnalyticsAdminV1alphaDeleteUserLinkRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleAnalyticsAdminV1alphaDeleteUserLinkRequest
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleAnalyticsAdminV1alphaDisplayVideo360AdvertiserLink: A link
// between a GA4 property and a Display & Video 360 advertiser.
type GoogleAnalyticsAdminV1alphaDisplayVideo360AdvertiserLink struct {
	// AdsPersonalizationEnabled: Enables personalized advertising features
	// with this integration. If this field is not set on create/update, it
	// will be defaulted to true.
	AdsPersonalizationEnabled bool `json:"adsPersonalizationEnabled,omitempty"`

	// AdvertiserDisplayName: Output only. The display name of the Display &
	// Video 360 Advertiser.
	AdvertiserDisplayName string `json:"advertiserDisplayName,omitempty"`

	// AdvertiserId: Immutable. The Display & Video 360 Advertiser's
	// advertiser ID.
	AdvertiserId string `json:"advertiserId,omitempty"`

	// CampaignDataSharingEnabled: Immutable. Enables the import of campaign
	// data from Display & Video 360 into the GA4 property. After link
	// creation, this can only be updated from the Display & Video 360
	// product. If this field is not set on create, it will be defaulted to
	// true.
	CampaignDataSharingEnabled bool `json:"campaignDataSharingEnabled,omitempty"`

	// CostDataSharingEnabled: Immutable. Enables the import of cost data
	// from Display & Video 360 into the GA4 property. This can only be
	// enabled if campaign_data_sharing_enabled is enabled. After link
	// creation, this can only be updated from the Display & Video 360
	// product. If this field is not set on create, it will be defaulted to
	// true.
	CostDataSharingEnabled bool `json:"costDataSharingEnabled,omitempty"`

	// Name: Output only. The resource name for this
	// DisplayVideo360AdvertiserLink resource. Format:
	// properties/{propertyId}/displayVideo360AdvertiserLinks/{linkId} Note:
	// linkId is not the Display & Video 360 Advertiser ID
	Name string `json:"name,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g.
	// "AdsPersonalizationEnabled") to unconditionally include in API
	// requests. By default, fields with empty or default values are omitted
	// from API requests. However, any non-pointer, non-interface field
	// appearing in ForceSendFields will be sent to the server regardless of
	// whether the field is empty or not. This may be used to include empty
	// fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g.
	// "AdsPersonalizationEnabled") to include in API requests with the JSON
	// null value. By default, fields with empty values are omitted from API
	// requests. However, any field with an empty value appearing in
	// NullFields will be sent to the server as null. It is an error if a
	// field in this list has a non-empty value. This may be used to include
	// null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleAnalyticsAdminV1alphaDisplayVideo360AdvertiserLink) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleAnalyticsAdminV1alphaDisplayVideo360AdvertiserLink
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleAnalyticsAdminV1alphaDisplayVideo360AdvertiserLinkProposal: A
// proposal for a link between a GA4 property and a Display & Video 360
// advertiser. A proposal is converted to a
// DisplayVideo360AdvertiserLink once approved. Google Analytics admins
// approve inbound proposals while Display & Video 360 admins approve
// outbound proposals.
type GoogleAnalyticsAdminV1alphaDisplayVideo360AdvertiserLinkProposal struct {
	// AdsPersonalizationEnabled: Immutable. Enables personalized
	// advertising features with this integration. If this field is not set
	// on create, it will be defaulted to true.
	AdsPersonalizationEnabled bool `json:"adsPersonalizationEnabled,omitempty"`

	// AdvertiserDisplayName: Output only. The display name of the Display &
	// Video Advertiser. Only populated for proposals that originated from
	// Display & Video 360.
	AdvertiserDisplayName string `json:"advertiserDisplayName,omitempty"`

	// AdvertiserId: Immutable. The Display & Video 360 Advertiser's
	// advertiser ID.
	AdvertiserId string `json:"advertiserId,omitempty"`

	// CampaignDataSharingEnabled: Immutable. Enables the import of campaign
	// data from Display & Video 360. If this field is not set on create, it
	// will be defaulted to true.
	CampaignDataSharingEnabled bool `json:"campaignDataSharingEnabled,omitempty"`

	// CostDataSharingEnabled: Immutable. Enables the import of cost data
	// from Display & Video 360. This can only be enabled if
	// campaign_data_sharing_enabled is enabled. If this field is not set on
	// create, it will be defaulted to true.
	CostDataSharingEnabled bool `json:"costDataSharingEnabled,omitempty"`

	// LinkProposalStatusDetails: Output only. The status information for
	// this link proposal.
	LinkProposalStatusDetails *GoogleAnalyticsAdminV1alphaLinkProposalStatusDetails `json:"linkProposalStatusDetails,omitempty"`

	// Name: Output only. The resource name for this
	// DisplayVideo360AdvertiserLinkProposal resource. Format:
	// properties/{propertyId}/displayVideo360AdvertiserLinkProposals/{propos
	// alId} Note: proposalId is not the Display & Video 360 Advertiser ID
	Name string `json:"name,omitempty"`

	// ValidationEmail: Input only. On a proposal being sent to Display &
	// Video 360, this field must be set to the email address of an admin on
	// the target advertiser. This is used to verify that the Google
	// Analytics admin is aware of at least one admin on the Display & Video
	// 360 Advertiser. This does not restrict approval of the proposal to a
	// single user. Any admin on the Display & Video 360 Advertiser may
	// approve the proposal.
	ValidationEmail string `json:"validationEmail,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g.
	// "AdsPersonalizationEnabled") to unconditionally include in API
	// requests. By default, fields with empty or default values are omitted
	// from API requests. However, any non-pointer, non-interface field
	// appearing in ForceSendFields will be sent to the server regardless of
	// whether the field is empty or not. This may be used to include empty
	// fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g.
	// "AdsPersonalizationEnabled") to include in API requests with the JSON
	// null value. By default, fields with empty values are omitted from API
	// requests. However, any field with an empty value appearing in
	// NullFields will be sent to the server as null. It is an error if a
	// field in this list has a non-empty value. This may be used to include
	// null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleAnalyticsAdminV1alphaDisplayVideo360AdvertiserLinkProposal) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleAnalyticsAdminV1alphaDisplayVideo360AdvertiserLinkProposal
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleAnalyticsAdminV1alphaEnhancedMeasurementSettings: Singleton
// resource under a WebDataStream, configuring measurement of additional
// site interactions and content.
type GoogleAnalyticsAdminV1alphaEnhancedMeasurementSettings struct {
	// FileDownloadsEnabled: If enabled, capture a file download event each
	// time a link is clicked with a common document, compressed file,
	// application, video, or audio extension.
	FileDownloadsEnabled bool `json:"fileDownloadsEnabled,omitempty"`

	// FormInteractionsEnabled: If enabled, capture a form interaction event
	// each time a visitor interacts with a form on your website. False by
	// default.
	FormInteractionsEnabled bool `json:"formInteractionsEnabled,omitempty"`

	// Name: Output only. Resource name of the Enhanced Measurement
	// Settings. Format:
	// properties/{property_id}/dataStreams/{data_stream}/enhancedMeasurement
	// Settings Example:
	// "properties/1000/dataStreams/2000/enhancedMeasurementSettings"
	Name string `json:"name,omitempty"`

	// OutboundClicksEnabled: If enabled, capture an outbound click event
	// each time a visitor clicks a link that leads them away from your
	// domain.
	OutboundClicksEnabled bool `json:"outboundClicksEnabled,omitempty"`

	// PageChangesEnabled: If enabled, capture a page view event each time
	// the website changes the browser history state.
	PageChangesEnabled bool `json:"pageChangesEnabled,omitempty"`

	// ScrollsEnabled: If enabled, capture scroll events each time a visitor
	// gets to the bottom of a page.
	ScrollsEnabled bool `json:"scrollsEnabled,omitempty"`

	// SearchQueryParameter: Required. URL query parameters to interpret as
	// site search parameters. Max length is 1024 characters. Must not be
	// empty.
	SearchQueryParameter string `json:"searchQueryParameter,omitempty"`

	// SiteSearchEnabled: If enabled, capture a view search results event
	// each time a visitor performs a search on your site (based on a query
	// parameter).
	SiteSearchEnabled bool `json:"siteSearchEnabled,omitempty"`

	// StreamEnabled: Indicates whether Enhanced Measurement Settings will
	// be used to automatically measure interactions and content on this web
	// stream. Changing this value does not affect the settings themselves,
	// but determines whether they are respected.
	StreamEnabled bool `json:"streamEnabled,omitempty"`

	// UriQueryParameter: Additional URL query parameters. Max length is
	// 1024 characters.
	UriQueryParameter string `json:"uriQueryParameter,omitempty"`

	// VideoEngagementEnabled: If enabled, capture video play, progress, and
	// complete events as visitors view embedded videos on your site.
	VideoEngagementEnabled bool `json:"videoEngagementEnabled,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g.
	// "FileDownloadsEnabled") to unconditionally include in API requests.
	// By default, fields with empty or default values are omitted from API
	// requests. However, any non-pointer, non-interface field appearing in
	// ForceSendFields will be sent to the server regardless of whether the
	// field is empty or not. This may be used to include empty fields in
	// Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "FileDownloadsEnabled") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *GoogleAnalyticsAdminV1alphaEnhancedMeasurementSettings) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleAnalyticsAdminV1alphaEnhancedMeasurementSettings
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleAnalyticsAdminV1alphaExpandedDataSet: A resource message
// representing a GA4 ExpandedDataSet.
type GoogleAnalyticsAdminV1alphaExpandedDataSet struct {
	// DataCollectionStartTime: Output only. Time when expanded data set
	// began (or will begin) collecing data.
	DataCollectionStartTime string `json:"dataCollectionStartTime,omitempty"`

	// Description: Optional. The description of the ExpandedDataSet. Max 50
	// chars.
	Description string `json:"description,omitempty"`

	// DimensionFilterExpression: Immutable. A logical expression of
	// ExpandedDataSet filters applied to dimension included in the
	// ExpandedDataSet. This filter is used to reduce the number of rows and
	// thus the chance of encountering `other` row.
	DimensionFilterExpression *GoogleAnalyticsAdminV1alphaExpandedDataSetFilterExpression `json:"dimensionFilterExpression,omitempty"`

	// DimensionNames: Immutable. The list of dimensions included in the
	// ExpandedDataSet. See the API Dimensions
	// (https://developers.google.com/analytics/devguides/reporting/data/v1/api-schema#dimensions)
	// for the list of dimension names.
	DimensionNames []string `json:"dimensionNames,omitempty"`

	// DisplayName: Required. The display name of the ExpandedDataSet. Max
	// 200 chars.
	DisplayName string `json:"displayName,omitempty"`

	// MetricNames: Immutable. The list of metrics included in the
	// ExpandedDataSet. See the API Metrics
	// (https://developers.google.com/analytics/devguides/reporting/data/v1/api-schema#metrics)
	// for the list of dimension names.
	MetricNames []string `json:"metricNames,omitempty"`

	// Name: Output only. The resource name for this ExpandedDataSet
	// resource. Format:
	// properties/{property_id}/expandedDataSets/{expanded_data_set}
	Name string `json:"name,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g.
	// "DataCollectionStartTime") to unconditionally include in API
	// requests. By default, fields with empty or default values are omitted
	// from API requests. However, any non-pointer, non-interface field
	// appearing in ForceSendFields will be sent to the server regardless of
	// whether the field is empty or not. This may be used to include empty
	// fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "DataCollectionStartTime")
	// to include in API requests with the JSON null value. By default,
	// fields with empty values are omitted from API requests. However, any
	// field with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *GoogleAnalyticsAdminV1alphaExpandedDataSet) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleAnalyticsAdminV1alphaExpandedDataSet
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleAnalyticsAdminV1alphaExpandedDataSetFilter: A specific filter
// for a single dimension
type GoogleAnalyticsAdminV1alphaExpandedDataSetFilter struct {
	// FieldName: Required. The dimension name to filter.
	FieldName string `json:"fieldName,omitempty"`

	// InListFilter: A filter for a string dimension that matches a
	// particular list of options.
	InListFilter *GoogleAnalyticsAdminV1alphaExpandedDataSetFilterInListFilter `json:"inListFilter,omitempty"`

	// StringFilter: A filter for a string-type dimension that matches a
	// particular pattern.
	StringFilter *GoogleAnalyticsAdminV1alphaExpandedDataSetFilterStringFilter `json:"stringFilter,omitempty"`

	// ForceSendFields is a list of field names (e.g. "FieldName") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "FieldName") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleAnalyticsAdminV1alphaExpandedDataSetFilter) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleAnalyticsAdminV1alphaExpandedDataSetFilter
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleAnalyticsAdminV1alphaExpandedDataSetFilterExpression: A logical
// expression of EnhancedDataSet dimension filters.
type GoogleAnalyticsAdminV1alphaExpandedDataSetFilterExpression struct {
	// AndGroup: A list of expressions to be AND’ed together. It must
	// contain a ExpandedDataSetFilterExpression with either not_expression
	// or dimension_filter. This must be set for the top level
	// ExpandedDataSetFilterExpression.
	AndGroup *GoogleAnalyticsAdminV1alphaExpandedDataSetFilterExpressionList `json:"andGroup,omitempty"`

	// Filter: A filter on a single dimension. This cannot be set on the top
	// level ExpandedDataSetFilterExpression.
	Filter *GoogleAnalyticsAdminV1alphaExpandedDataSetFilter `json:"filter,omitempty"`

	// NotExpression: A filter expression to be NOT'ed (that is, inverted,
	// complemented). It must include a dimension_filter. This cannot be set
	// on the top level ExpandedDataSetFilterExpression.
	NotExpression *GoogleAnalyticsAdminV1alphaExpandedDataSetFilterExpression `json:"notExpression,omitempty"`

	// ForceSendFields is a list of field names (e.g. "AndGroup") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "AndGroup") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleAnalyticsAdminV1alphaExpandedDataSetFilterExpression) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleAnalyticsAdminV1alphaExpandedDataSetFilterExpression
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleAnalyticsAdminV1alphaExpandedDataSetFilterExpressionList: A
// list of ExpandedDataSet filter expressions.
type GoogleAnalyticsAdminV1alphaExpandedDataSetFilterExpressionList struct {
	// FilterExpressions: A list of ExpandedDataSet filter expressions.
	FilterExpressions []*GoogleAnalyticsAdminV1alphaExpandedDataSetFilterExpression `json:"filterExpressions,omitempty"`

	// ForceSendFields is a list of field names (e.g. "FilterExpressions")
	// to unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "FilterExpressions") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *GoogleAnalyticsAdminV1alphaExpandedDataSetFilterExpressionList) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleAnalyticsAdminV1alphaExpandedDataSetFilterExpressionList
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleAnalyticsAdminV1alphaExpandedDataSetFilterInListFilter: A
// filter for a string dimension that matches a particular list of
// options.
type GoogleAnalyticsAdminV1alphaExpandedDataSetFilterInListFilter struct {
	// CaseSensitive: Optional. If true, the match is case-sensitive. If
	// false, the match is case-insensitive. Must be true.
	CaseSensitive bool `json:"caseSensitive,omitempty"`

	// Values: Required. The list of possible string values to match
	// against. Must be non-empty.
	Values []string `json:"values,omitempty"`

	// ForceSendFields is a list of field names (e.g. "CaseSensitive") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "CaseSensitive") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleAnalyticsAdminV1alphaExpandedDataSetFilterInListFilter) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleAnalyticsAdminV1alphaExpandedDataSetFilterInListFilter
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleAnalyticsAdminV1alphaExpandedDataSetFilterStringFilter: A
// filter for a string-type dimension that matches a particular pattern.
type GoogleAnalyticsAdminV1alphaExpandedDataSetFilterStringFilter struct {
	// CaseSensitive: Optional. If true, the match is case-sensitive. If
	// false, the match is case-insensitive. Must be true when match_type is
	// EXACT. Must be false when match_type is CONTAINS.
	CaseSensitive bool `json:"caseSensitive,omitempty"`

	// MatchType: Required. The match type for the string filter.
	//
	// Possible values:
	//   "MATCH_TYPE_UNSPECIFIED" - Unspecified
	//   "EXACT" - Exact match of the string value.
	//   "CONTAINS" - Contains the string value.
	MatchType string `json:"matchType,omitempty"`

	// Value: Required. The string value to be matched against.
	Value string `json:"value,omitempty"`

	// ForceSendFields is a list of field names (e.g. "CaseSensitive") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "CaseSensitive") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleAnalyticsAdminV1alphaExpandedDataSetFilterStringFilter) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleAnalyticsAdminV1alphaExpandedDataSetFilterStringFilter
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleAnalyticsAdminV1alphaFetchAutomatedGa4ConfigurationOptOutRequest
// : Request for fetching the opt out status for the automated GA4 setup
// process.
type GoogleAnalyticsAdminV1alphaFetchAutomatedGa4ConfigurationOptOutRequest struct {
	// Property: Required. The UA property to get the opt out status. Note
	// this request uses the internal property ID, not the tracking ID of
	// the form UA-XXXXXX-YY. Format: properties/{internalWebPropertyId}
	// Example: properties/1234
	Property string `json:"property,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Property") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Property") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleAnalyticsAdminV1alphaFetchAutomatedGa4ConfigurationOptOutRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleAnalyticsAdminV1alphaFetchAutomatedGa4ConfigurationOptOutRequest
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleAnalyticsAdminV1alphaFetchAutomatedGa4ConfigurationOptOutRespons
// e: Response message for fetching the opt out status for the automated
// GA4 setup process.
type GoogleAnalyticsAdminV1alphaFetchAutomatedGa4ConfigurationOptOutResponse struct {
	// OptOut: The opt out status for the UA property.
	OptOut bool `json:"optOut,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "OptOut") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "OptOut") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleAnalyticsAdminV1alphaFetchAutomatedGa4ConfigurationOptOutResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleAnalyticsAdminV1alphaFetchAutomatedGa4ConfigurationOptOutResponse
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleAnalyticsAdminV1alphaFetchConnectedGa4PropertyResponse:
// Response for looking up GA4 property connected to a UA property.
type GoogleAnalyticsAdminV1alphaFetchConnectedGa4PropertyResponse struct {
	// Property: The GA4 property connected to the UA property. An empty
	// string is returned when there is no connected GA4 property. Format:
	// properties/{property_id} Example: properties/1234
	Property string `json:"property,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "Property") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Property") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleAnalyticsAdminV1alphaFetchConnectedGa4PropertyResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleAnalyticsAdminV1alphaFetchConnectedGa4PropertyResponse
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleAnalyticsAdminV1alphaFirebaseLink: A link between a GA4
// property and a Firebase project.
type GoogleAnalyticsAdminV1alphaFirebaseLink struct {
	// CreateTime: Output only. Time when this FirebaseLink was originally
	// created.
	CreateTime string `json:"createTime,omitempty"`

	// Name: Output only. Example format: properties/1234/firebaseLinks/5678
	Name string `json:"name,omitempty"`

	// Project: Immutable. Firebase project resource name. When creating a
	// FirebaseLink, you may provide this resource name using either a
	// project number or project ID. Once this resource has been created,
	// returned FirebaseLinks will always have a project_name that contains
	// a project number. Format: 'projects/{project number}' Example:
	// 'projects/1234'
	Project string `json:"project,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "CreateTime") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "CreateTime") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleAnalyticsAdminV1alphaFirebaseLink) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleAnalyticsAdminV1alphaFirebaseLink
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleAnalyticsAdminV1alphaGlobalSiteTag: Read-only resource with the
// tag for sending data from a website to a DataStream. Only present for
// web DataStream resources.
type GoogleAnalyticsAdminV1alphaGlobalSiteTag struct {
	// Name: Output only. Resource name for this GlobalSiteTag resource.
	// Format:
	// properties/{property_id}/dataStreams/{stream_id}/globalSiteTag
	// Example: "properties/123/dataStreams/456/globalSiteTag"
	Name string `json:"name,omitempty"`

	// Snippet: Immutable. JavaScript code snippet to be pasted as the first
	// item into the head tag of every webpage to measure.
	Snippet string `json:"snippet,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "Name") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Name") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleAnalyticsAdminV1alphaGlobalSiteTag) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleAnalyticsAdminV1alphaGlobalSiteTag
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleAnalyticsAdminV1alphaGoogleAdsLink: A link between a GA4
// property and a Google Ads account.
type GoogleAnalyticsAdminV1alphaGoogleAdsLink struct {
	// AdsPersonalizationEnabled: Enable personalized advertising features
	// with this integration. Automatically publish my Google Analytics
	// audience lists and Google Analytics remarketing events/parameters to
	// the linked Google Ads account. If this field is not set on
	// create/update, it will be defaulted to true.
	AdsPersonalizationEnabled bool `json:"adsPersonalizationEnabled,omitempty"`

	// CanManageClients: Output only. If true, this link is for a Google Ads
	// manager account.
	CanManageClients bool `json:"canManageClients,omitempty"`

	// CreateTime: Output only. Time when this link was originally created.
	CreateTime string `json:"createTime,omitempty"`

	// CreatorEmailAddress: Output only. Email address of the user that
	// created the link. An empty string will be returned if the email
	// address can't be retrieved.
	CreatorEmailAddress string `json:"creatorEmailAddress,omitempty"`

	// CustomerId: Immutable. Google Ads customer ID.
	CustomerId string `json:"customerId,omitempty"`

	// Name: Output only. Format:
	// properties/{propertyId}/googleAdsLinks/{googleAdsLinkId} Note:
	// googleAdsLinkId is not the Google Ads customer ID.
	Name string `json:"name,omitempty"`

	// UpdateTime: Output only. Time when this link was last updated.
	UpdateTime string `json:"updateTime,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g.
	// "AdsPersonalizationEnabled") to unconditionally include in API
	// requests. By default, fields with empty or default values are omitted
	// from API requests. However, any non-pointer, non-interface field
	// appearing in ForceSendFields will be sent to the server regardless of
	// whether the field is empty or not. This may be used to include empty
	// fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g.
	// "AdsPersonalizationEnabled") to include in API requests with the JSON
	// null value. By default, fields with empty values are omitted from API
	// requests. However, any field with an empty value appearing in
	// NullFields will be sent to the server as null. It is an error if a
	// field in this list has a non-empty value. This may be used to include
	// null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleAnalyticsAdminV1alphaGoogleAdsLink) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleAnalyticsAdminV1alphaGoogleAdsLink
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleAnalyticsAdminV1alphaGoogleSignalsSettings: Settings values for
// Google Signals. This is a singleton resource.
type GoogleAnalyticsAdminV1alphaGoogleSignalsSettings struct {
	// Consent: Output only. Terms of Service acceptance.
	//
	// Possible values:
	//   "GOOGLE_SIGNALS_CONSENT_UNSPECIFIED" - Google Signals consent value
	// defaults to GOOGLE_SIGNALS_CONSENT_UNSPECIFIED. This will be treated
	// as GOOGLE_SIGNALS_CONSENT_NOT_CONSENTED.
	//   "GOOGLE_SIGNALS_CONSENT_CONSENTED" - Terms of service have been
	// accepted
	//   "GOOGLE_SIGNALS_CONSENT_NOT_CONSENTED" - Terms of service have not
	// been accepted
	Consent string `json:"consent,omitempty"`

	// Name: Output only. Resource name of this setting. Format:
	// properties/{property_id}/googleSignalsSettings Example:
	// "properties/1000/googleSignalsSettings"
	Name string `json:"name,omitempty"`

	// State: Status of this setting.
	//
	// Possible values:
	//   "GOOGLE_SIGNALS_STATE_UNSPECIFIED" - Google Signals status defaults
	// to GOOGLE_SIGNALS_STATE_UNSPECIFIED to represent that the user has
	// not made an explicit choice.
	//   "GOOGLE_SIGNALS_ENABLED" - Google Signals is enabled.
	//   "GOOGLE_SIGNALS_DISABLED" - Google Signals is disabled.
	State string `json:"state,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "Consent") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Consent") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleAnalyticsAdminV1alphaGoogleSignalsSettings) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleAnalyticsAdminV1alphaGoogleSignalsSettings
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleAnalyticsAdminV1alphaGroupingRule: The rules that govern how
// traffic is grouped into one channel.
type GoogleAnalyticsAdminV1alphaGroupingRule struct {
	// DisplayName: Required. Customer defined display name for the channel.
	DisplayName string `json:"displayName,omitempty"`

	// Expression: Required. The Filter Expression that defines the Grouping
	// Rule.
	Expression *GoogleAnalyticsAdminV1alphaChannelGroupFilterExpression `json:"expression,omitempty"`

	// ForceSendFields is a list of field names (e.g. "DisplayName") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "DisplayName") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleAnalyticsAdminV1alphaGroupingRule) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleAnalyticsAdminV1alphaGroupingRule
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleAnalyticsAdminV1alphaLinkProposalStatusDetails: Status
// information for a link proposal.
type GoogleAnalyticsAdminV1alphaLinkProposalStatusDetails struct {
	// LinkProposalInitiatingProduct: Output only. The source of this
	// proposal.
	//
	// Possible values:
	//   "LINK_PROPOSAL_INITIATING_PRODUCT_UNSPECIFIED" - Unspecified
	// product.
	//   "GOOGLE_ANALYTICS" - This proposal was created by a user from
	// Google Analytics.
	//   "LINKED_PRODUCT" - This proposal was created by a user from a
	// linked product (not Google Analytics).
	LinkProposalInitiatingProduct string `json:"linkProposalInitiatingProduct,omitempty"`

	// LinkProposalState: Output only. The state of this proposal.
	//
	// Possible values:
	//   "LINK_PROPOSAL_STATE_UNSPECIFIED" - Unspecified state
	//   "AWAITING_REVIEW_FROM_GOOGLE_ANALYTICS" - This proposal is awaiting
	// review from a Google Analytics user. This proposal will automatically
	// expire after some time.
	//   "AWAITING_REVIEW_FROM_LINKED_PRODUCT" - This proposal is awaiting
	// review from a user of a linked product. This proposal will
	// automatically expire after some time.
	//   "WITHDRAWN" - This proposal has been withdrawn by an admin on the
	// initiating product. This proposal will be automatically deleted after
	// some time.
	//   "DECLINED" - This proposal has been declined by an admin on the
	// receiving product. This proposal will be automatically deleted after
	// some time.
	//   "EXPIRED" - This proposal expired due to lack of response from an
	// admin on the receiving product. This proposal will be automatically
	// deleted after some time.
	//   "OBSOLETE" - This proposal has become obsolete because a link was
	// directly created to the same external product resource that this
	// proposal specifies. This proposal will be automatically deleted after
	// some time.
	LinkProposalState string `json:"linkProposalState,omitempty"`

	// RequestorEmail: Output only. The email address of the user that
	// proposed this linkage.
	RequestorEmail string `json:"requestorEmail,omitempty"`

	// ForceSendFields is a list of field names (e.g.
	// "LinkProposalInitiatingProduct") to unconditionally include in API
	// requests. By default, fields with empty or default values are omitted
	// from API requests. However, any non-pointer, non-interface field
	// appearing in ForceSendFields will be sent to the server regardless of
	// whether the field is empty or not. This may be used to include empty
	// fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g.
	// "LinkProposalInitiatingProduct") to include in API requests with the
	// JSON null value. By default, fields with empty values are omitted
	// from API requests. However, any field with an empty value appearing
	// in NullFields will be sent to the server as null. It is an error if a
	// field in this list has a non-empty value. This may be used to include
	// null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleAnalyticsAdminV1alphaLinkProposalStatusDetails) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleAnalyticsAdminV1alphaLinkProposalStatusDetails
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleAnalyticsAdminV1alphaListAccessBindingsResponse: Response
// message for ListAccessBindings RPC.
type GoogleAnalyticsAdminV1alphaListAccessBindingsResponse struct {
	// AccessBindings: List of AccessBindings. These will be ordered stably,
	// but in an arbitrary order.
	AccessBindings []*GoogleAnalyticsAdminV1alphaAccessBinding `json:"accessBindings,omitempty"`

	// NextPageToken: A token, which can be sent as `page_token` to retrieve
	// the next page. If this field is omitted, there are no subsequent
	// pages.
	NextPageToken string `json:"nextPageToken,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "AccessBindings") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "AccessBindings") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *GoogleAnalyticsAdminV1alphaListAccessBindingsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleAnalyticsAdminV1alphaListAccessBindingsResponse
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleAnalyticsAdminV1alphaListAccountSummariesResponse: Response
// message for ListAccountSummaries RPC.
type GoogleAnalyticsAdminV1alphaListAccountSummariesResponse struct {
	// AccountSummaries: Account summaries of all accounts the caller has
	// access to.
	AccountSummaries []*GoogleAnalyticsAdminV1alphaAccountSummary `json:"accountSummaries,omitempty"`

	// NextPageToken: A token, which can be sent as `page_token` to retrieve
	// the next page. If this field is omitted, there are no subsequent
	// pages.
	NextPageToken string `json:"nextPageToken,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "AccountSummaries") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "AccountSummaries") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *GoogleAnalyticsAdminV1alphaListAccountSummariesResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleAnalyticsAdminV1alphaListAccountSummariesResponse
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleAnalyticsAdminV1alphaListAccountsResponse: Request message for
// ListAccounts RPC.
type GoogleAnalyticsAdminV1alphaListAccountsResponse struct {
	// Accounts: Results that were accessible to the caller.
	Accounts []*GoogleAnalyticsAdminV1alphaAccount `json:"accounts,omitempty"`

	// NextPageToken: A token, which can be sent as `page_token` to retrieve
	// the next page. If this field is omitted, there are no subsequent
	// pages.
	NextPageToken string `json:"nextPageToken,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "Accounts") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Accounts") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleAnalyticsAdminV1alphaListAccountsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleAnalyticsAdminV1alphaListAccountsResponse
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleAnalyticsAdminV1alphaListAudiencesResponse: Response message
// for ListAudiences RPC.
type GoogleAnalyticsAdminV1alphaListAudiencesResponse struct {
	// Audiences: List of Audiences.
	Audiences []*GoogleAnalyticsAdminV1alphaAudience `json:"audiences,omitempty"`

	// NextPageToken: A token, which can be sent as `page_token` to retrieve
	// the next page. If this field is omitted, there are no subsequent
	// pages.
	NextPageToken string `json:"nextPageToken,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "Audiences") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Audiences") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleAnalyticsAdminV1alphaListAudiencesResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleAnalyticsAdminV1alphaListAudiencesResponse
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleAnalyticsAdminV1alphaListBigQueryLinksResponse: Response
// message for ListBigQueryLinks RPC
type GoogleAnalyticsAdminV1alphaListBigQueryLinksResponse struct {
	// BigqueryLinks: List of BigQueryLinks.
	BigqueryLinks []*GoogleAnalyticsAdminV1alphaBigQueryLink `json:"bigqueryLinks,omitempty"`

	// NextPageToken: A token, which can be sent as `page_token` to retrieve
	// the next page. If this field is omitted, there are no subsequent
	// pages.
	NextPageToken string `json:"nextPageToken,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "BigqueryLinks") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "BigqueryLinks") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleAnalyticsAdminV1alphaListBigQueryLinksResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleAnalyticsAdminV1alphaListBigQueryLinksResponse
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleAnalyticsAdminV1alphaListChannelGroupsResponse: Response
// message for ListChannelGroups RPC.
type GoogleAnalyticsAdminV1alphaListChannelGroupsResponse struct {
	// ChannelGroups: List of ChannelGroup. These will be ordered stably,
	// but in an arbitrary order.
	ChannelGroups []*GoogleAnalyticsAdminV1alphaChannelGroup `json:"channelGroups,omitempty"`

	// NextPageToken: A token, which can be sent as `page_token` to retrieve
	// the next page. If this field is omitted, there are no subsequent
	// pages.
	NextPageToken string `json:"nextPageToken,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "ChannelGroups") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "ChannelGroups") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleAnalyticsAdminV1alphaListChannelGroupsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleAnalyticsAdminV1alphaListChannelGroupsResponse
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleAnalyticsAdminV1alphaListConnectedSiteTagsRequest: Request
// message for ListConnectedSiteTags RPC.
type GoogleAnalyticsAdminV1alphaListConnectedSiteTagsRequest struct {
	// Property: The Universal Analytics property to fetch connected site
	// tags for. This does not work on GA4 properties. A maximum of 20
	// connected site tags will be returned. Example Format:
	// `properties/1234`
	Property string `json:"property,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Property") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Property") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleAnalyticsAdminV1alphaListConnectedSiteTagsRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleAnalyticsAdminV1alphaListConnectedSiteTagsRequest
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleAnalyticsAdminV1alphaListConnectedSiteTagsResponse: Response
// message for ListConnectedSiteTags RPC.
type GoogleAnalyticsAdminV1alphaListConnectedSiteTagsResponse struct {
	// ConnectedSiteTags: The site tags for the Universal Analytics
	// property. A maximum of 20 connected site tags will be returned.
	ConnectedSiteTags []*GoogleAnalyticsAdminV1alphaConnectedSiteTag `json:"connectedSiteTags,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "ConnectedSiteTags")
	// to unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "ConnectedSiteTags") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *GoogleAnalyticsAdminV1alphaListConnectedSiteTagsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleAnalyticsAdminV1alphaListConnectedSiteTagsResponse
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleAnalyticsAdminV1alphaListConversionEventsResponse: Response
// message for ListConversionEvents RPC.
type GoogleAnalyticsAdminV1alphaListConversionEventsResponse struct {
	// ConversionEvents: The requested conversion events
	ConversionEvents []*GoogleAnalyticsAdminV1alphaConversionEvent `json:"conversionEvents,omitempty"`

	// NextPageToken: A token, which can be sent as `page_token` to retrieve
	// the next page. If this field is omitted, there are no subsequent
	// pages.
	NextPageToken string `json:"nextPageToken,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "ConversionEvents") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "ConversionEvents") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *GoogleAnalyticsAdminV1alphaListConversionEventsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleAnalyticsAdminV1alphaListConversionEventsResponse
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleAnalyticsAdminV1alphaListCustomDimensionsResponse: Response
// message for ListCustomDimensions RPC.
type GoogleAnalyticsAdminV1alphaListCustomDimensionsResponse struct {
	// CustomDimensions: List of CustomDimensions.
	CustomDimensions []*GoogleAnalyticsAdminV1alphaCustomDimension `json:"customDimensions,omitempty"`

	// NextPageToken: A token, which can be sent as `page_token` to retrieve
	// the next page. If this field is omitted, there are no subsequent
	// pages.
	NextPageToken string `json:"nextPageToken,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "CustomDimensions") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "CustomDimensions") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *GoogleAnalyticsAdminV1alphaListCustomDimensionsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleAnalyticsAdminV1alphaListCustomDimensionsResponse
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleAnalyticsAdminV1alphaListCustomMetricsResponse: Response
// message for ListCustomMetrics RPC.
type GoogleAnalyticsAdminV1alphaListCustomMetricsResponse struct {
	// CustomMetrics: List of CustomMetrics.
	CustomMetrics []*GoogleAnalyticsAdminV1alphaCustomMetric `json:"customMetrics,omitempty"`

	// NextPageToken: A token, which can be sent as `page_token` to retrieve
	// the next page. If this field is omitted, there are no subsequent
	// pages.
	NextPageToken string `json:"nextPageToken,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "CustomMetrics") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "CustomMetrics") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleAnalyticsAdminV1alphaListCustomMetricsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleAnalyticsAdminV1alphaListCustomMetricsResponse
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleAnalyticsAdminV1alphaListDataStreamsResponse: Response message
// for ListDataStreams RPC.
type GoogleAnalyticsAdminV1alphaListDataStreamsResponse struct {
	// DataStreams: List of DataStreams.
	DataStreams []*GoogleAnalyticsAdminV1alphaDataStream `json:"dataStreams,omitempty"`

	// NextPageToken: A token, which can be sent as `page_token` to retrieve
	// the next page. If this field is omitted, there are no subsequent
	// pages.
	NextPageToken string `json:"nextPageToken,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "DataStreams") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "DataStreams") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleAnalyticsAdminV1alphaListDataStreamsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleAnalyticsAdminV1alphaListDataStreamsResponse
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleAnalyticsAdminV1alphaListDisplayVideo360AdvertiserLinkProposalsR
// esponse: Response message for
// ListDisplayVideo360AdvertiserLinkProposals RPC.
type GoogleAnalyticsAdminV1alphaListDisplayVideo360AdvertiserLinkProposalsResponse struct {
	// DisplayVideo360AdvertiserLinkProposals: List of
	// DisplayVideo360AdvertiserLinkProposals.
	DisplayVideo360AdvertiserLinkProposals []*GoogleAnalyticsAdminV1alphaDisplayVideo360AdvertiserLinkProposal `json:"displayVideo360AdvertiserLinkProposals,omitempty"`

	// NextPageToken: A token, which can be sent as `page_token` to retrieve
	// the next page. If this field is omitted, there are no subsequent
	// pages.
	NextPageToken string `json:"nextPageToken,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g.
	// "DisplayVideo360AdvertiserLinkProposals") to unconditionally include
	// in API requests. By default, fields with empty or default values are
	// omitted from API requests. However, any non-pointer, non-interface
	// field appearing in ForceSendFields will be sent to the server
	// regardless of whether the field is empty or not. This may be used to
	// include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g.
	// "DisplayVideo360AdvertiserLinkProposals") to include in API requests
	// with the JSON null value. By default, fields with empty values are
	// omitted from API requests. However, any field with an empty value
	// appearing in NullFields will be sent to the server as null. It is an
	// error if a field in this list has a non-empty value. This may be used
	// to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleAnalyticsAdminV1alphaListDisplayVideo360AdvertiserLinkProposalsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleAnalyticsAdminV1alphaListDisplayVideo360AdvertiserLinkProposalsResponse
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleAnalyticsAdminV1alphaListDisplayVideo360AdvertiserLinksResponse:
//
//	Response message for ListDisplayVideo360AdvertiserLinks RPC.
type GoogleAnalyticsAdminV1alphaListDisplayVideo360AdvertiserLinksResponse struct {
	// DisplayVideo360AdvertiserLinks: List of
	// DisplayVideo360AdvertiserLinks.
	DisplayVideo360AdvertiserLinks []*GoogleAnalyticsAdminV1alphaDisplayVideo360AdvertiserLink `json:"displayVideo360AdvertiserLinks,omitempty"`

	// NextPageToken: A token, which can be sent as `page_token` to retrieve
	// the next page. If this field is omitted, there are no subsequent
	// pages.
	NextPageToken string `json:"nextPageToken,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g.
	// "DisplayVideo360AdvertiserLinks") to unconditionally include in API
	// requests. By default, fields with empty or default values are omitted
	// from API requests. However, any non-pointer, non-interface field
	// appearing in ForceSendFields will be sent to the server regardless of
	// whether the field is empty or not. This may be used to include empty
	// fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g.
	// "DisplayVideo360AdvertiserLinks") to include in API requests with the
	// JSON null value. By default, fields with empty values are omitted
	// from API requests. However, any field with an empty value appearing
	// in NullFields will be sent to the server as null. It is an error if a
	// field in this list has a non-empty value. This may be used to include
	// null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleAnalyticsAdminV1alphaListDisplayVideo360AdvertiserLinksResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleAnalyticsAdminV1alphaListDisplayVideo360AdvertiserLinksResponse
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleAnalyticsAdminV1alphaListExpandedDataSetsResponse: Response
// message for ListExpandedDataSets RPC.
type GoogleAnalyticsAdminV1alphaListExpandedDataSetsResponse struct {
	// ExpandedDataSets: List of ExpandedDataSet. These will be ordered
	// stably, but in an arbitrary order.
	ExpandedDataSets []*GoogleAnalyticsAdminV1alphaExpandedDataSet `json:"expandedDataSets,omitempty"`

	// NextPageToken: A token, which can be sent as `page_token` to retrieve
	// the next page. If this field is omitted, there are no subsequent
	// pages.
	NextPageToken string `json:"nextPageToken,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "ExpandedDataSets") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "ExpandedDataSets") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *GoogleAnalyticsAdminV1alphaListExpandedDataSetsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleAnalyticsAdminV1alphaListExpandedDataSetsResponse
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleAnalyticsAdminV1alphaListFirebaseLinksResponse: Response
// message for ListFirebaseLinks RPC
type GoogleAnalyticsAdminV1alphaListFirebaseLinksResponse struct {
	// FirebaseLinks: List of FirebaseLinks. This will have at most one
	// value.
	FirebaseLinks []*GoogleAnalyticsAdminV1alphaFirebaseLink `json:"firebaseLinks,omitempty"`

	// NextPageToken: A token, which can be sent as `page_token` to retrieve
	// the next page. If this field is omitted, there are no subsequent
	// pages. Currently, Google Analytics supports only one FirebaseLink per
	// property, so this will never be populated.
	NextPageToken string `json:"nextPageToken,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "FirebaseLinks") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "FirebaseLinks") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleAnalyticsAdminV1alphaListFirebaseLinksResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleAnalyticsAdminV1alphaListFirebaseLinksResponse
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleAnalyticsAdminV1alphaListGoogleAdsLinksResponse: Response
// message for ListGoogleAdsLinks RPC.
type GoogleAnalyticsAdminV1alphaListGoogleAdsLinksResponse struct {
	// GoogleAdsLinks: List of GoogleAdsLinks.
	GoogleAdsLinks []*GoogleAnalyticsAdminV1alphaGoogleAdsLink `json:"googleAdsLinks,omitempty"`

	// NextPageToken: A token, which can be sent as `page_token` to retrieve
	// the next page. If this field is omitted, there are no subsequent
	// pages.
	NextPageToken string `json:"nextPageToken,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "GoogleAdsLinks") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "GoogleAdsLinks") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *GoogleAnalyticsAdminV1alphaListGoogleAdsLinksResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleAnalyticsAdminV1alphaListGoogleAdsLinksResponse
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleAnalyticsAdminV1alphaListMeasurementProtocolSecretsResponse:
// Response message for ListMeasurementProtocolSecret RPC
type GoogleAnalyticsAdminV1alphaListMeasurementProtocolSecretsResponse struct {
	// MeasurementProtocolSecrets: A list of secrets for the parent stream
	// specified in the request.
	MeasurementProtocolSecrets []*GoogleAnalyticsAdminV1alphaMeasurementProtocolSecret `json:"measurementProtocolSecrets,omitempty"`

	// NextPageToken: A token, which can be sent as `page_token` to retrieve
	// the next page. If this field is omitted, there are no subsequent
	// pages.
	NextPageToken string `json:"nextPageToken,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g.
	// "MeasurementProtocolSecrets") to unconditionally include in API
	// requests. By default, fields with empty or default values are omitted
	// from API requests. However, any non-pointer, non-interface field
	// appearing in ForceSendFields will be sent to the server regardless of
	// whether the field is empty or not. This may be used to include empty
	// fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g.
	// "MeasurementProtocolSecrets") to include in API requests with the
	// JSON null value. By default, fields with empty values are omitted
	// from API requests. However, any field with an empty value appearing
	// in NullFields will be sent to the server as null. It is an error if a
	// field in this list has a non-empty value. This may be used to include
	// null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleAnalyticsAdminV1alphaListMeasurementProtocolSecretsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleAnalyticsAdminV1alphaListMeasurementProtocolSecretsResponse
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleAnalyticsAdminV1alphaListPropertiesResponse: Response message
// for ListProperties RPC.
type GoogleAnalyticsAdminV1alphaListPropertiesResponse struct {
	// NextPageToken: A token, which can be sent as `page_token` to retrieve
	// the next page. If this field is omitted, there are no subsequent
	// pages.
	NextPageToken string `json:"nextPageToken,omitempty"`

	// Properties: Results that matched the filter criteria and were
	// accessible to the caller.
	Properties []*GoogleAnalyticsAdminV1alphaProperty `json:"properties,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "NextPageToken") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "NextPageToken") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleAnalyticsAdminV1alphaListPropertiesResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleAnalyticsAdminV1alphaListPropertiesResponse
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleAnalyticsAdminV1alphaListSearchAds360LinksResponse: Response
// message for ListSearchAds360Links RPC.
type GoogleAnalyticsAdminV1alphaListSearchAds360LinksResponse struct {
	// NextPageToken: A token, which can be sent as `page_token` to retrieve
	// the next page. If this field is omitted, there are no subsequent
	// pages.
	NextPageToken string `json:"nextPageToken,omitempty"`

	// SearchAds360Links: List of SearchAds360Links.
	SearchAds360Links []*GoogleAnalyticsAdminV1alphaSearchAds360Link `json:"searchAds360Links,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "NextPageToken") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "NextPageToken") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleAnalyticsAdminV1alphaListSearchAds360LinksResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleAnalyticsAdminV1alphaListSearchAds360LinksResponse
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleAnalyticsAdminV1alphaListUserLinksResponse: Response message
// for ListUserLinks RPC.
type GoogleAnalyticsAdminV1alphaListUserLinksResponse struct {
	// NextPageToken: A token, which can be sent as `page_token` to retrieve
	// the next page. If this field is omitted, there are no subsequent
	// pages.
	NextPageToken string `json:"nextPageToken,omitempty"`

	// UserLinks: List of UserLinks. These will be ordered stably, but in an
	// arbitrary order.
	UserLinks []*GoogleAnalyticsAdminV1alphaUserLink `json:"userLinks,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "NextPageToken") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "NextPageToken") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleAnalyticsAdminV1alphaListUserLinksResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleAnalyticsAdminV1alphaListUserLinksResponse
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleAnalyticsAdminV1alphaMeasurementProtocolSecret: A secret value
// used for sending hits to Measurement Protocol.
type GoogleAnalyticsAdminV1alphaMeasurementProtocolSecret struct {
	// DisplayName: Required. Human-readable display name for this secret.
	DisplayName string `json:"displayName,omitempty"`

	// Name: Output only. Resource name of this secret. This secret may be a
	// child of any type of stream. Format:
	// properties/{property}/dataStreams/{dataStream}/measurementProtocolSecr
	// ets/{measurementProtocolSecret}
	Name string `json:"name,omitempty"`

	// SecretValue: Output only. The measurement protocol secret value. Pass
	// this value to the api_secret field of the Measurement Protocol API
	// when sending hits to this secret's parent property.
	SecretValue string `json:"secretValue,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "DisplayName") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "DisplayName") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleAnalyticsAdminV1alphaMeasurementProtocolSecret) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleAnalyticsAdminV1alphaMeasurementProtocolSecret
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleAnalyticsAdminV1alphaNumericValue: To represent a number.
type GoogleAnalyticsAdminV1alphaNumericValue struct {
	// DoubleValue: Double value
	DoubleValue float64 `json:"doubleValue,omitempty"`

	// Int64Value: Integer value
	Int64Value int64 `json:"int64Value,omitempty,string"`

	// ForceSendFields is a list of field names (e.g. "DoubleValue") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "DoubleValue") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleAnalyticsAdminV1alphaNumericValue) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleAnalyticsAdminV1alphaNumericValue
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

func (s *GoogleAnalyticsAdminV1alphaNumericValue) UnmarshalJSON(data []byte) error {
	type NoMethod GoogleAnalyticsAdminV1alphaNumericValue
	var s1 struct {
		DoubleValue gensupport.JSONFloat64 `json:"doubleValue"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.DoubleValue = float64(s1.DoubleValue)
	return nil
}

// GoogleAnalyticsAdminV1alphaProperty: A resource message representing
// a Google Analytics GA4 property.
type GoogleAnalyticsAdminV1alphaProperty struct {
	// Account: Immutable. The resource name of the parent account Format:
	// accounts/{account_id} Example: "accounts/123"
	Account string `json:"account,omitempty"`

	// CreateTime: Output only. Time when the entity was originally created.
	CreateTime string `json:"createTime,omitempty"`

	// CurrencyCode: The currency type used in reports involving monetary
	// values. Format: https://en.wikipedia.org/wiki/ISO_4217 Examples:
	// "USD", "EUR", "JPY"
	CurrencyCode string `json:"currencyCode,omitempty"`

	// DeleteTime: Output only. If set, the time at which this property was
	// trashed. If not set, then this property is not currently in the trash
	// can.
	DeleteTime string `json:"deleteTime,omitempty"`

	// DisplayName: Required. Human-readable display name for this property.
	// The max allowed display name length is 100 UTF-16 code units.
	DisplayName string `json:"displayName,omitempty"`

	// ExpireTime: Output only. If set, the time at which this trashed
	// property will be permanently deleted. If not set, then this property
	// is not currently in the trash can and is not slated to be deleted.
	ExpireTime string `json:"expireTime,omitempty"`

	// IndustryCategory: Industry associated with this property Example:
	// AUTOMOTIVE, FOOD_AND_DRINK
	//
	// Possible values:
	//   "INDUSTRY_CATEGORY_UNSPECIFIED" - Industry category unspecified
	//   "AUTOMOTIVE" - Automotive
	//   "BUSINESS_AND_INDUSTRIAL_MARKETS" - Business and industrial markets
	//   "FINANCE" - Finance
	//   "HEALTHCARE" - Healthcare
	//   "TECHNOLOGY" - Technology
	//   "TRAVEL" - Travel
	//   "OTHER" - Other
	//   "ARTS_AND_ENTERTAINMENT" - Arts and entertainment
	//   "BEAUTY_AND_FITNESS" - Beauty and fitness
	//   "BOOKS_AND_LITERATURE" - Books and literature
	//   "FOOD_AND_DRINK" - Food and drink
	//   "GAMES" - Games
	//   "HOBBIES_AND_LEISURE" - Hobbies and leisure
	//   "HOME_AND_GARDEN" - Home and garden
	//   "INTERNET_AND_TELECOM" - Internet and telecom
	//   "LAW_AND_GOVERNMENT" - Law and government
	//   "NEWS" - News
	//   "ONLINE_COMMUNITIES" - Online communities
	//   "PEOPLE_AND_SOCIETY" - People and society
	//   "PETS_AND_ANIMALS" - Pets and animals
	//   "REAL_ESTATE" - Real estate
	//   "REFERENCE" - Reference
	//   "SCIENCE" - Science
	//   "SPORTS" - Sports
	//   "JOBS_AND_EDUCATION" - Jobs and education
	//   "SHOPPING" - Shopping
	IndustryCategory string `json:"industryCategory,omitempty"`

	// Name: Output only. Resource name of this property. Format:
	// properties/{property_id} Example: "properties/1000"
	Name string `json:"name,omitempty"`

	// Parent: Immutable. Resource name of this property's logical parent.
	// Note: The Property-Moving UI can be used to change the parent.
	// Format: accounts/{account}, properties/{property} Example:
	// "accounts/100", "properties/101"
	Parent string `json:"parent,omitempty"`

	// PropertyType: Immutable. The property type for this Property
	// resource. When creating a property, if the type is
	// "PROPERTY_TYPE_UNSPECIFIED", then "ORDINARY_PROPERTY" will be
	// implied. "SUBPROPERTY" and "ROLLUP_PROPERTY" types cannot yet be
	// created with the Google Analytics Admin API.
	//
	// Possible values:
	//   "PROPERTY_TYPE_UNSPECIFIED" - Unknown or unspecified property type
	//   "PROPERTY_TYPE_ORDINARY" - Ordinary GA4 property
	//   "PROPERTY_TYPE_SUBPROPERTY" - GA4 subproperty
	//   "PROPERTY_TYPE_ROLLUP" - GA4 rollup property
	PropertyType string `json:"propertyType,omitempty"`

	// ServiceLevel: Output only. The Google Analytics service level that
	// applies to this property.
	//
	// Possible values:
	//   "SERVICE_LEVEL_UNSPECIFIED" - Service level not specified or
	// invalid.
	//   "GOOGLE_ANALYTICS_STANDARD" - The standard version of Google
	// Analytics.
	//   "GOOGLE_ANALYTICS_360" - The paid, premium version of Google
	// Analytics.
	ServiceLevel string `json:"serviceLevel,omitempty"`

	// TimeZone: Required. Reporting Time Zone, used as the day boundary for
	// reports, regardless of where the data originates. If the time zone
	// honors DST, Analytics will automatically adjust for the changes.
	// NOTE: Changing the time zone only affects data going forward, and is
	// not applied retroactively. Format: https://www.iana.org/time-zones
	// Example: "America/Los_Angeles"
	TimeZone string `json:"timeZone,omitempty"`

	// UpdateTime: Output only. Time when entity payload fields were last
	// updated.
	UpdateTime string `json:"updateTime,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "Account") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Account") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleAnalyticsAdminV1alphaProperty) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleAnalyticsAdminV1alphaProperty
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleAnalyticsAdminV1alphaPropertySummary: A virtual resource
// representing metadata for a GA4 property.
type GoogleAnalyticsAdminV1alphaPropertySummary struct {
	// DisplayName: Display name for the property referred to in this
	// property summary.
	DisplayName string `json:"displayName,omitempty"`

	// Parent: Resource name of this property's logical parent. Note: The
	// Property-Moving UI can be used to change the parent. Format:
	// accounts/{account}, properties/{property} Example: "accounts/100",
	// "properties/200"
	Parent string `json:"parent,omitempty"`

	// Property: Resource name of property referred to by this property
	// summary Format: properties/{property_id} Example: "properties/1000"
	Property string `json:"property,omitempty"`

	// PropertyType: The property's property type.
	//
	// Possible values:
	//   "PROPERTY_TYPE_UNSPECIFIED" - Unknown or unspecified property type
	//   "PROPERTY_TYPE_ORDINARY" - Ordinary GA4 property
	//   "PROPERTY_TYPE_SUBPROPERTY" - GA4 subproperty
	//   "PROPERTY_TYPE_ROLLUP" - GA4 rollup property
	PropertyType string `json:"propertyType,omitempty"`

	// ForceSendFields is a list of field names (e.g. "DisplayName") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "DisplayName") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleAnalyticsAdminV1alphaPropertySummary) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleAnalyticsAdminV1alphaPropertySummary
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleAnalyticsAdminV1alphaProvisionAccountTicketRequest: Request
// message for ProvisionAccountTicket RPC.
type GoogleAnalyticsAdminV1alphaProvisionAccountTicketRequest struct {
	// Account: The account to create.
	Account *GoogleAnalyticsAdminV1alphaAccount `json:"account,omitempty"`

	// RedirectUri: Redirect URI where the user will be sent after accepting
	// Terms of Service. Must be configured in Cloud Console as a Redirect
	// URI.
	RedirectUri string `json:"redirectUri,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Account") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Account") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleAnalyticsAdminV1alphaProvisionAccountTicketRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleAnalyticsAdminV1alphaProvisionAccountTicketRequest
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleAnalyticsAdminV1alphaProvisionAccountTicketResponse: Response
// message for ProvisionAccountTicket RPC.
type GoogleAnalyticsAdminV1alphaProvisionAccountTicketResponse struct {
	// AccountTicketId: The param to be passed in the ToS link.
	AccountTicketId string `json:"accountTicketId,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "AccountTicketId") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "AccountTicketId") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *GoogleAnalyticsAdminV1alphaProvisionAccountTicketResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleAnalyticsAdminV1alphaProvisionAccountTicketResponse
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleAnalyticsAdminV1alphaRunAccessReportRequest: The request for a
// Data Access Record Report.
type GoogleAnalyticsAdminV1alphaRunAccessReportRequest struct {
	// DateRanges: Date ranges of access records to read. If multiple date
	// ranges are requested, each response row will contain a zero based
	// date range index. If two date ranges overlap, the access records for
	// the overlapping days is included in the response rows for both date
	// ranges. Requests are allowed up to 2 date ranges.
	DateRanges []*GoogleAnalyticsAdminV1alphaAccessDateRange `json:"dateRanges,omitempty"`

	// DimensionFilter: Dimension filters let you restrict report response
	// to specific dimension values which match the filter. For example,
	// filtering on access records of a single user. To learn more, see
	// Fundamentals of Dimension Filters
	// (https://developers.google.com/analytics/devguides/reporting/data/v1/basics#dimension_filters)
	// for examples. Metrics cannot be used in this filter.
	DimensionFilter *GoogleAnalyticsAdminV1alphaAccessFilterExpression `json:"dimensionFilter,omitempty"`

	// Dimensions: The dimensions requested and displayed in the response.
	// Requests are allowed up to 9 dimensions.
	Dimensions []*GoogleAnalyticsAdminV1alphaAccessDimension `json:"dimensions,omitempty"`

	// Limit: The number of rows to return. If unspecified, 10,000 rows are
	// returned. The API returns a maximum of 100,000 rows per request, no
	// matter how many you ask for. `limit` must be positive. The API may
	// return fewer rows than the requested `limit`, if there aren't as many
	// remaining rows as the `limit`. For instance, there are fewer than 300
	// possible values for the dimension `country`, so when reporting on
	// only `country`, you can't get more than 300 rows, even if you set
	// `limit` to a higher value. To learn more about this pagination
	// parameter, see Pagination
	// (https://developers.google.com/analytics/devguides/reporting/data/v1/basics#pagination).
	Limit int64 `json:"limit,omitempty,string"`

	// MetricFilter: Metric filters allow you to restrict report response to
	// specific metric values which match the filter. Metric filters are
	// applied after aggregating the report's rows, similar to SQL
	// having-clause. Dimensions cannot be used in this filter.
	MetricFilter *GoogleAnalyticsAdminV1alphaAccessFilterExpression `json:"metricFilter,omitempty"`

	// Metrics: The metrics requested and displayed in the response.
	// Requests are allowed up to 10 metrics.
	Metrics []*GoogleAnalyticsAdminV1alphaAccessMetric `json:"metrics,omitempty"`

	// Offset: The row count of the start row. The first row is counted as
	// row 0. If offset is unspecified, it is treated as 0. If offset is
	// zero, then this method will return the first page of results with
	// `limit` entries. To learn more about this pagination parameter, see
	// Pagination
	// (https://developers.google.com/analytics/devguides/reporting/data/v1/basics#pagination).
	Offset int64 `json:"offset,omitempty,string"`

	// OrderBys: Specifies how rows are ordered in the response.
	OrderBys []*GoogleAnalyticsAdminV1alphaAccessOrderBy `json:"orderBys,omitempty"`

	// ReturnEntityQuota: Toggles whether to return the current state of
	// this Analytics Property's quota. Quota is returned in AccessQuota
	// (#AccessQuota). For account-level requests, this field must be false.
	ReturnEntityQuota bool `json:"returnEntityQuota,omitempty"`

	// TimeZone: This request's time zone if specified. If unspecified, the
	// property's time zone is used. The request's time zone is used to
	// interpret the start & end dates of the report. Formatted as strings
	// from the IANA Time Zone database (https://www.iana.org/time-zones);
	// for example "America/New_York" or "Asia/Tokyo".
	TimeZone string `json:"timeZone,omitempty"`

	// ForceSendFields is a list of field names (e.g. "DateRanges") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "DateRanges") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleAnalyticsAdminV1alphaRunAccessReportRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleAnalyticsAdminV1alphaRunAccessReportRequest
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleAnalyticsAdminV1alphaRunAccessReportResponse: The customized
// Data Access Record Report response.
type GoogleAnalyticsAdminV1alphaRunAccessReportResponse struct {
	// DimensionHeaders: The header for a column in the report that
	// corresponds to a specific dimension. The number of DimensionHeaders
	// and ordering of DimensionHeaders matches the dimensions present in
	// rows.
	DimensionHeaders []*GoogleAnalyticsAdminV1alphaAccessDimensionHeader `json:"dimensionHeaders,omitempty"`

	// MetricHeaders: The header for a column in the report that corresponds
	// to a specific metric. The number of MetricHeaders and ordering of
	// MetricHeaders matches the metrics present in rows.
	MetricHeaders []*GoogleAnalyticsAdminV1alphaAccessMetricHeader `json:"metricHeaders,omitempty"`

	// Quota: The quota state for this Analytics property including this
	// request. This field doesn't work with account-level requests.
	Quota *GoogleAnalyticsAdminV1alphaAccessQuota `json:"quota,omitempty"`

	// RowCount: The total number of rows in the query result. `rowCount` is
	// independent of the number of rows returned in the response, the
	// `limit` request parameter, and the `offset` request parameter. For
	// example if a query returns 175 rows and includes `limit` of 50 in the
	// API request, the response will contain `rowCount` of 175 but only 50
	// rows. To learn more about this pagination parameter, see Pagination
	// (https://developers.google.com/analytics/devguides/reporting/data/v1/basics#pagination).
	RowCount int64 `json:"rowCount,omitempty"`

	// Rows: Rows of dimension value combinations and metric values in the
	// report.
	Rows []*GoogleAnalyticsAdminV1alphaAccessRow `json:"rows,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "DimensionHeaders") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "DimensionHeaders") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *GoogleAnalyticsAdminV1alphaRunAccessReportResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleAnalyticsAdminV1alphaRunAccessReportResponse
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleAnalyticsAdminV1alphaSearchAds360Link: A link between a GA4
// property and a Search Ads 360 entity.
type GoogleAnalyticsAdminV1alphaSearchAds360Link struct {
	// AdsPersonalizationEnabled: Enables personalized advertising features
	// with this integration. If this field is not set on create, it will be
	// defaulted to true.
	AdsPersonalizationEnabled bool `json:"adsPersonalizationEnabled,omitempty"`

	// AdvertiserDisplayName: Output only. The display name of the Search
	// Ads 360 Advertiser. Allows users to easily identify the linked
	// resource.
	AdvertiserDisplayName string `json:"advertiserDisplayName,omitempty"`

	// AdvertiserId: Immutable. This field represents the Advertiser ID of
	// the Search Ads 360 Advertiser. that has been linked.
	AdvertiserId string `json:"advertiserId,omitempty"`

	// CampaignDataSharingEnabled: Immutable. Enables the import of campaign
	// data from Search Ads 360 into the GA4 property. After link creation,
	// this can only be updated from the Search Ads 360 product. If this
	// field is not set on create, it will be defaulted to true.
	CampaignDataSharingEnabled bool `json:"campaignDataSharingEnabled,omitempty"`

	// CostDataSharingEnabled: Immutable. Enables the import of cost data
	// from Search Ads 360 to the GA4 property. This can only be enabled if
	// campaign_data_sharing_enabled is enabled. After link creation, this
	// can only be updated from the Search Ads 360 product. If this field is
	// not set on create, it will be defaulted to true.
	CostDataSharingEnabled bool `json:"costDataSharingEnabled,omitempty"`

	// Name: Output only. The resource name for this SearchAds360Link
	// resource. Format: properties/{propertyId}/searchAds360Links/{linkId}
	// Note: linkId is not the Search Ads 360 advertiser ID
	Name string `json:"name,omitempty"`

	// SiteStatsSharingEnabled: Enables export of site stats with this
	// integration. If this field is not set on create, it will be defaulted
	// to true.
	SiteStatsSharingEnabled bool `json:"siteStatsSharingEnabled,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g.
	// "AdsPersonalizationEnabled") to unconditionally include in API
	// requests. By default, fields with empty or default values are omitted
	// from API requests. However, any non-pointer, non-interface field
	// appearing in ForceSendFields will be sent to the server regardless of
	// whether the field is empty or not. This may be used to include empty
	// fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g.
	// "AdsPersonalizationEnabled") to include in API requests with the JSON
	// null value. By default, fields with empty values are omitted from API
	// requests. However, any field with an empty value appearing in
	// NullFields will be sent to the server as null. It is an error if a
	// field in this list has a non-empty value. This may be used to include
	// null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleAnalyticsAdminV1alphaSearchAds360Link) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleAnalyticsAdminV1alphaSearchAds360Link
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleAnalyticsAdminV1alphaSearchChangeHistoryEventsRequest: Request
// message for SearchChangeHistoryEvents RPC.
type GoogleAnalyticsAdminV1alphaSearchChangeHistoryEventsRequest struct {
	// Action: Optional. If set, only return changes that match one or more
	// of these types of actions.
	//
	// Possible values:
	//   "ACTION_TYPE_UNSPECIFIED" - Action type unknown or not specified.
	//   "CREATED" - Resource was created in this change.
	//   "UPDATED" - Resource was updated in this change.
	//   "DELETED" - Resource was deleted in this change.
	Action []string `json:"action,omitempty"`

	// ActorEmail: Optional. If set, only return changes if they are made by
	// a user in this list.
	ActorEmail []string `json:"actorEmail,omitempty"`

	// EarliestChangeTime: Optional. If set, only return changes made after
	// this time (inclusive).
	EarliestChangeTime string `json:"earliestChangeTime,omitempty"`

	// LatestChangeTime: Optional. If set, only return changes made before
	// this time (inclusive).
	LatestChangeTime string `json:"latestChangeTime,omitempty"`

	// PageSize: Optional. The maximum number of ChangeHistoryEvent items to
	// return. The service may return fewer than this value, even if there
	// are additional pages. If unspecified, at most 50 items will be
	// returned. The maximum value is 200 (higher values will be coerced to
	// the maximum).
	PageSize int64 `json:"pageSize,omitempty"`

	// PageToken: Optional. A page token, received from a previous
	// `SearchChangeHistoryEvents` call. Provide this to retrieve the
	// subsequent page. When paginating, all other parameters provided to
	// `SearchChangeHistoryEvents` must match the call that provided the
	// page token.
	PageToken string `json:"pageToken,omitempty"`

	// Property: Optional. Resource name for a child property. If set, only
	// return changes made to this property or its child resources.
	Property string `json:"property,omitempty"`

	// ResourceType: Optional. If set, only return changes if they are for a
	// resource that matches at least one of these types.
	//
	// Possible values:
	//   "CHANGE_HISTORY_RESOURCE_TYPE_UNSPECIFIED" - Resource type unknown
	// or not specified.
	//   "ACCOUNT" - Account resource
	//   "PROPERTY" - Property resource
	//   "FIREBASE_LINK" - FirebaseLink resource
	//   "GOOGLE_ADS_LINK" - GoogleAdsLink resource
	//   "GOOGLE_SIGNALS_SETTINGS" - GoogleSignalsSettings resource
	//   "CONVERSION_EVENT" - ConversionEvent resource
	//   "MEASUREMENT_PROTOCOL_SECRET" - MeasurementProtocolSecret resource
	//   "CUSTOM_DIMENSION" - CustomDimension resource
	//   "CUSTOM_METRIC" - CustomMetric resource
	//   "DATA_RETENTION_SETTINGS" - DataRetentionSettings resource
	//   "DISPLAY_VIDEO_360_ADVERTISER_LINK" - DisplayVideo360AdvertiserLink
	// resource
	//   "DISPLAY_VIDEO_360_ADVERTISER_LINK_PROPOSAL" -
	// DisplayVideo360AdvertiserLinkProposal resource
	//   "SEARCH_ADS_360_LINK" - SearchAds360Link resource
	//   "DATA_STREAM" - DataStream resource
	//   "ATTRIBUTION_SETTINGS" - AttributionSettings resource
	//   "EXPANDED_DATA_SET" - ExpandedDataSet resource
	//   "CHANNEL_GROUP" - ChannelGroup resource
	//   "ENHANCED_MEASUREMENT_SETTINGS" - EnhancedMeasurementSettings
	// resource
	ResourceType []string `json:"resourceType,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Action") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Action") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleAnalyticsAdminV1alphaSearchChangeHistoryEventsRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleAnalyticsAdminV1alphaSearchChangeHistoryEventsRequest
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleAnalyticsAdminV1alphaSearchChangeHistoryEventsResponse:
// Response message for SearchAccounts RPC.
type GoogleAnalyticsAdminV1alphaSearchChangeHistoryEventsResponse struct {
	// ChangeHistoryEvents: Results that were accessible to the caller.
	ChangeHistoryEvents []*GoogleAnalyticsAdminV1alphaChangeHistoryEvent `json:"changeHistoryEvents,omitempty"`

	// NextPageToken: A token, which can be sent as `page_token` to retrieve
	// the next page. If this field is omitted, there are no subsequent
	// pages.
	NextPageToken string `json:"nextPageToken,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "ChangeHistoryEvents")
	// to unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "ChangeHistoryEvents") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *GoogleAnalyticsAdminV1alphaSearchChangeHistoryEventsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleAnalyticsAdminV1alphaSearchChangeHistoryEventsResponse
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleAnalyticsAdminV1alphaSetAutomatedGa4ConfigurationOptOutRequest:
// Request for setting the opt out status for the automated GA4 setup
// process.
type GoogleAnalyticsAdminV1alphaSetAutomatedGa4ConfigurationOptOutRequest struct {
	// OptOut: The status to set.
	OptOut bool `json:"optOut,omitempty"`

	// Property: Required. The UA property to set the opt out status. Note
	// this request uses the internal property ID, not the tracking ID of
	// the form UA-XXXXXX-YY. Format: properties/{internalWebPropertyId}
	// Example: properties/1234
	Property string `json:"property,omitempty"`

	// ForceSendFields is a list of field names (e.g. "OptOut") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "OptOut") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleAnalyticsAdminV1alphaSetAutomatedGa4ConfigurationOptOutRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleAnalyticsAdminV1alphaSetAutomatedGa4ConfigurationOptOutRequest
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleAnalyticsAdminV1alphaSetAutomatedGa4ConfigurationOptOutResponse:
//
//	Response message for setting the opt out status for the automated
//
// GA4 setup process.
type GoogleAnalyticsAdminV1alphaSetAutomatedGa4ConfigurationOptOutResponse struct {
	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`
}

// GoogleAnalyticsAdminV1alphaUpdateAccessBindingRequest: Request
// message for UpdateAccessBinding RPC.
type GoogleAnalyticsAdminV1alphaUpdateAccessBindingRequest struct {
	// AccessBinding: Required. The access binding to update.
	AccessBinding *GoogleAnalyticsAdminV1alphaAccessBinding `json:"accessBinding,omitempty"`

	// ForceSendFields is a list of field names (e.g. "AccessBinding") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "AccessBinding") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleAnalyticsAdminV1alphaUpdateAccessBindingRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleAnalyticsAdminV1alphaUpdateAccessBindingRequest
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleAnalyticsAdminV1alphaUpdateUserLinkRequest: Request message for
// UpdateUserLink RPC.
type GoogleAnalyticsAdminV1alphaUpdateUserLinkRequest struct {
	// UserLink: Required. The user link to update.
	UserLink *GoogleAnalyticsAdminV1alphaUserLink `json:"userLink,omitempty"`

	// ForceSendFields is a list of field names (e.g. "UserLink") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "UserLink") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleAnalyticsAdminV1alphaUpdateUserLinkRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleAnalyticsAdminV1alphaUpdateUserLinkRequest
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleAnalyticsAdminV1alphaUserLink: A resource message representing
// a user's permissions on an Account or Property resource.
type GoogleAnalyticsAdminV1alphaUserLink struct {
	// DirectRoles: Roles directly assigned to this user for this account or
	// property. Valid values: predefinedRoles/viewer
	// predefinedRoles/analyst predefinedRoles/editor predefinedRoles/admin
	// predefinedRoles/no-cost-data predefinedRoles/no-revenue-data Excludes
	// roles that are inherited from a higher-level entity, group, or
	// organization admin role. A UserLink that is updated to have an empty
	// list of direct_roles will be deleted.
	DirectRoles []string `json:"directRoles,omitempty"`

	// EmailAddress: Immutable. Email address of the user to link
	EmailAddress string `json:"emailAddress,omitempty"`

	// Name: Output only. Example format: properties/1234/userLinks/5678
	Name string `json:"name,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "DirectRoles") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "DirectRoles") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleAnalyticsAdminV1alphaUserLink) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleAnalyticsAdminV1alphaUserLink
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleProtobufEmpty: A generic empty message that you can re-use to
// avoid defining duplicated empty messages in your APIs. A typical
// example is to use it as the request or the response type of an API
// method. For instance: service Foo { rpc Bar(google.protobuf.Empty)
// returns (google.protobuf.Empty); }
type GoogleProtobufEmpty struct {
	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`
}

// method id "analyticsadmin.accountSummaries.list":

type AccountSummariesListCall struct {
	s            *Service
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Returns summaries of all accounts accessible by the caller.
func (r *AccountSummariesService) List() *AccountSummariesListCall {
	c := &AccountSummariesListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	return c
}

// PageSize sets the optional parameter "pageSize": The maximum number
// of AccountSummary resources to return. The service may return fewer
// than this value, even if there are additional pages. If unspecified,
// at most 50 resources will be returned. The maximum value is 200;
// (higher values will be coerced to the maximum)
func (c *AccountSummariesListCall) PageSize(pageSize int64) *AccountSummariesListCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": A page token,
// received from a previous `ListAccountSummaries` call. Provide this to
// retrieve the subsequent page. When paginating, all other parameters
// provided to `ListAccountSummaries` must match the call that provided
// the page token.
func (c *AccountSummariesListCall) PageToken(pageToken string) *AccountSummariesListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *AccountSummariesListCall) Fields(s ...googleapi.Field) *AccountSummariesListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets the optional parameter which makes the operation
// fail if the object's ETag matches the given value. This is useful for
// getting updates only after the object has changed since the last
// request. Use googleapi.IsNotModified to check whether the response
// error from Do is the result of In-None-Match.
func (c *AccountSummariesListCall) IfNoneMatch(entityTag string) *AccountSummariesListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *AccountSummariesListCall) Context(ctx context.Context) *AccountSummariesListCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *AccountSummariesListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *AccountSummariesListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1alpha/accountSummaries")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "analyticsadmin.accountSummaries.list" call.
// Exactly one of
// *GoogleAnalyticsAdminV1alphaListAccountSummariesResponse or error
// will be non-nil. Any non-2xx status code is an error. Response
// headers are in either
// *GoogleAnalyticsAdminV1alphaListAccountSummariesResponse.ServerRespons
// e.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was
// returned.
func (c *AccountSummariesListCall) Do(opts ...googleapi.CallOption) (*GoogleAnalyticsAdminV1alphaListAccountSummariesResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleAnalyticsAdminV1alphaListAccountSummariesResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Returns summaries of all accounts accessible by the caller.",
	//   "flatPath": "v1alpha/accountSummaries",
	//   "httpMethod": "GET",
	//   "id": "analyticsadmin.accountSummaries.list",
	//   "parameterOrder": [],
	//   "parameters": {
	//     "pageSize": {
	//       "description": "The maximum number of AccountSummary resources to return. The service may return fewer than this value, even if there are additional pages. If unspecified, at most 50 resources will be returned. The maximum value is 200; (higher values will be coerced to the maximum)",
	//       "format": "int32",
	//       "location": "query",
	//       "type": "integer"
	//     },
	//     "pageToken": {
	//       "description": "A page token, received from a previous `ListAccountSummaries` call. Provide this to retrieve the subsequent page. When paginating, all other parameters provided to `ListAccountSummaries` must match the call that provided the page token.",
	//       "location": "query",
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1alpha/accountSummaries",
	//   "response": {
	//     "$ref": "GoogleAnalyticsAdminV1alphaListAccountSummariesResponse"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/analytics.edit",
	//     "https://www.googleapis.com/auth/analytics.readonly"
	//   ]
	// }

}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *AccountSummariesListCall) Pages(ctx context.Context, f func(*GoogleAnalyticsAdminV1alphaListAccountSummariesResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken")) // reset paging to original point
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

// method id "analyticsadmin.accounts.delete":

type AccountsDeleteCall struct {
	s          *Service
	name       string
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Delete: Marks target Account as soft-deleted (ie: "trashed") and
// returns it. This API does not have a method to restore soft-deleted
// accounts. However, they can be restored using the Trash Can UI. If
// the accounts are not restored before the expiration time, the account
// and all child resources (eg: Properties, GoogleAdsLinks, Streams,
// UserLinks) will be permanently purged.
// https://support.google.com/analytics/answer/6154772 Returns an error
// if the target is not found.
//
//   - name: The name of the Account to soft-delete. Format:
//     accounts/{account} Example: "accounts/100".
func (r *AccountsService) Delete(name string) *AccountsDeleteCall {
	c := &AccountsDeleteCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *AccountsDeleteCall) Fields(s ...googleapi.Field) *AccountsDeleteCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *AccountsDeleteCall) Context(ctx context.Context) *AccountsDeleteCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *AccountsDeleteCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *AccountsDeleteCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1alpha/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("DELETE", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "analyticsadmin.accounts.delete" call.
// Exactly one of *GoogleProtobufEmpty or error will be non-nil. Any
// non-2xx status code is an error. Response headers are in either
// *GoogleProtobufEmpty.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was
// because http.StatusNotModified was returned.
func (c *AccountsDeleteCall) Do(opts ...googleapi.CallOption) (*GoogleProtobufEmpty, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleProtobufEmpty{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Marks target Account as soft-deleted (ie: \"trashed\") and returns it. This API does not have a method to restore soft-deleted accounts. However, they can be restored using the Trash Can UI. If the accounts are not restored before the expiration time, the account and all child resources (eg: Properties, GoogleAdsLinks, Streams, UserLinks) will be permanently purged. https://support.google.com/analytics/answer/6154772 Returns an error if the target is not found.",
	//   "flatPath": "v1alpha/accounts/{accountsId}",
	//   "httpMethod": "DELETE",
	//   "id": "analyticsadmin.accounts.delete",
	//   "parameterOrder": [
	//     "name"
	//   ],
	//   "parameters": {
	//     "name": {
	//       "description": "Required. The name of the Account to soft-delete. Format: accounts/{account} Example: \"accounts/100\"",
	//       "location": "path",
	//       "pattern": "^accounts/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1alpha/{+name}",
	//   "response": {
	//     "$ref": "GoogleProtobufEmpty"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/analytics.edit"
	//   ]
	// }

}

// method id "analyticsadmin.accounts.get":

type AccountsGetCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Lookup for a single Account.
//
//   - name: The name of the account to lookup. Format: accounts/{account}
//     Example: "accounts/100".
func (r *AccountsService) Get(name string) *AccountsGetCall {
	c := &AccountsGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *AccountsGetCall) Fields(s ...googleapi.Field) *AccountsGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets the optional parameter which makes the operation
// fail if the object's ETag matches the given value. This is useful for
// getting updates only after the object has changed since the last
// request. Use googleapi.IsNotModified to check whether the response
// error from Do is the result of In-None-Match.
func (c *AccountsGetCall) IfNoneMatch(entityTag string) *AccountsGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *AccountsGetCall) Context(ctx context.Context) *AccountsGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *AccountsGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *AccountsGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1alpha/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "analyticsadmin.accounts.get" call.
// Exactly one of *GoogleAnalyticsAdminV1alphaAccount or error will be
// non-nil. Any non-2xx status code is an error. Response headers are in
// either *GoogleAnalyticsAdminV1alphaAccount.ServerResponse.Header or
// (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was
// returned.
func (c *AccountsGetCall) Do(opts ...googleapi.CallOption) (*GoogleAnalyticsAdminV1alphaAccount, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleAnalyticsAdminV1alphaAccount{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Lookup for a single Account.",
	//   "flatPath": "v1alpha/accounts/{accountsId}",
	//   "httpMethod": "GET",
	//   "id": "analyticsadmin.accounts.get",
	//   "parameterOrder": [
	//     "name"
	//   ],
	//   "parameters": {
	//     "name": {
	//       "description": "Required. The name of the account to lookup. Format: accounts/{account} Example: \"accounts/100\"",
	//       "location": "path",
	//       "pattern": "^accounts/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1alpha/{+name}",
	//   "response": {
	//     "$ref": "GoogleAnalyticsAdminV1alphaAccount"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/analytics.edit",
	//     "https://www.googleapis.com/auth/analytics.readonly"
	//   ]
	// }

}

// method id "analyticsadmin.accounts.getDataSharingSettings":

type AccountsGetDataSharingSettingsCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// GetDataSharingSettings: Get data sharing settings on an account. Data
// sharing settings are singletons.
//
//   - name: The name of the settings to lookup. Format:
//     accounts/{account}/dataSharingSettings Example:
//     "accounts/1000/dataSharingSettings".
func (r *AccountsService) GetDataSharingSettings(name string) *AccountsGetDataSharingSettingsCall {
	c := &AccountsGetDataSharingSettingsCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *AccountsGetDataSharingSettingsCall) Fields(s ...googleapi.Field) *AccountsGetDataSharingSettingsCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets the optional parameter which makes the operation
// fail if the object's ETag matches the given value. This is useful for
// getting updates only after the object has changed since the last
// request. Use googleapi.IsNotModified to check whether the response
// error from Do is the result of In-None-Match.
func (c *AccountsGetDataSharingSettingsCall) IfNoneMatch(entityTag string) *AccountsGetDataSharingSettingsCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *AccountsGetDataSharingSettingsCall) Context(ctx context.Context) *AccountsGetDataSharingSettingsCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *AccountsGetDataSharingSettingsCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *AccountsGetDataSharingSettingsCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1alpha/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "analyticsadmin.accounts.getDataSharingSettings" call.
// Exactly one of *GoogleAnalyticsAdminV1alphaDataSharingSettings or
// error will be non-nil. Any non-2xx status code is an error. Response
// headers are in either
// *GoogleAnalyticsAdminV1alphaDataSharingSettings.ServerResponse.Header
// or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was
// returned.
func (c *AccountsGetDataSharingSettingsCall) Do(opts ...googleapi.CallOption) (*GoogleAnalyticsAdminV1alphaDataSharingSettings, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleAnalyticsAdminV1alphaDataSharingSettings{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Get data sharing settings on an account. Data sharing settings are singletons.",
	//   "flatPath": "v1alpha/accounts/{accountsId}/dataSharingSettings",
	//   "httpMethod": "GET",
	//   "id": "analyticsadmin.accounts.getDataSharingSettings",
	//   "parameterOrder": [
	//     "name"
	//   ],
	//   "parameters": {
	//     "name": {
	//       "description": "Required. The name of the settings to lookup. Format: accounts/{account}/dataSharingSettings Example: \"accounts/1000/dataSharingSettings\"",
	//       "location": "path",
	//       "pattern": "^accounts/[^/]+/dataSharingSettings$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1alpha/{+name}",
	//   "response": {
	//     "$ref": "GoogleAnalyticsAdminV1alphaDataSharingSettings"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/analytics.edit",
	//     "https://www.googleapis.com/auth/analytics.readonly"
	//   ]
	// }

}

// method id "analyticsadmin.accounts.list":

type AccountsListCall struct {
	s            *Service
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Returns all accounts accessible by the caller. Note that these
// accounts might not currently have GA4 properties. Soft-deleted (ie:
// "trashed") accounts are excluded by default. Returns an empty list if
// no relevant accounts are found.
func (r *AccountsService) List() *AccountsListCall {
	c := &AccountsListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	return c
}

// PageSize sets the optional parameter "pageSize": The maximum number
// of resources to return. The service may return fewer than this value,
// even if there are additional pages. If unspecified, at most 50
// resources will be returned. The maximum value is 200; (higher values
// will be coerced to the maximum)
func (c *AccountsListCall) PageSize(pageSize int64) *AccountsListCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": A page token,
// received from a previous `ListAccounts` call. Provide this to
// retrieve the subsequent page. When paginating, all other parameters
// provided to `ListAccounts` must match the call that provided the page
// token.
func (c *AccountsListCall) PageToken(pageToken string) *AccountsListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// ShowDeleted sets the optional parameter "showDeleted": Whether to
// include soft-deleted (ie: "trashed") Accounts in the results.
// Accounts can be inspected to determine whether they are deleted or
// not.
func (c *AccountsListCall) ShowDeleted(showDeleted bool) *AccountsListCall {
	c.urlParams_.Set("showDeleted", fmt.Sprint(showDeleted))
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *AccountsListCall) Fields(s ...googleapi.Field) *AccountsListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets the optional parameter which makes the operation
// fail if the object's ETag matches the given value. This is useful for
// getting updates only after the object has changed since the last
// request. Use googleapi.IsNotModified to check whether the response
// error from Do is the result of In-None-Match.
func (c *AccountsListCall) IfNoneMatch(entityTag string) *AccountsListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *AccountsListCall) Context(ctx context.Context) *AccountsListCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *AccountsListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *AccountsListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1alpha/accounts")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "analyticsadmin.accounts.list" call.
// Exactly one of *GoogleAnalyticsAdminV1alphaListAccountsResponse or
// error will be non-nil. Any non-2xx status code is an error. Response
// headers are in either
// *GoogleAnalyticsAdminV1alphaListAccountsResponse.ServerResponse.Header
//
//	or (if a response was returned at all) in
//
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was
// returned.
func (c *AccountsListCall) Do(opts ...googleapi.CallOption) (*GoogleAnalyticsAdminV1alphaListAccountsResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleAnalyticsAdminV1alphaListAccountsResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Returns all accounts accessible by the caller. Note that these accounts might not currently have GA4 properties. Soft-deleted (ie: \"trashed\") accounts are excluded by default. Returns an empty list if no relevant accounts are found.",
	//   "flatPath": "v1alpha/accounts",
	//   "httpMethod": "GET",
	//   "id": "analyticsadmin.accounts.list",
	//   "parameterOrder": [],
	//   "parameters": {
	//     "pageSize": {
	//       "description": "The maximum number of resources to return. The service may return fewer than this value, even if there are additional pages. If unspecified, at most 50 resources will be returned. The maximum value is 200; (higher values will be coerced to the maximum)",
	//       "format": "int32",
	//       "location": "query",
	//       "type": "integer"
	//     },
	//     "pageToken": {
	//       "description": "A page token, received from a previous `ListAccounts` call. Provide this to retrieve the subsequent page. When paginating, all other parameters provided to `ListAccounts` must match the call that provided the page token.",
	//       "location": "query",
	//       "type": "string"
	//     },
	//     "showDeleted": {
	//       "description": "Whether to include soft-deleted (ie: \"trashed\") Accounts in the results. Accounts can be inspected to determine whether they are deleted or not.",
	//       "location": "query",
	//       "type": "boolean"
	//     }
	//   },
	//   "path": "v1alpha/accounts",
	//   "response": {
	//     "$ref": "GoogleAnalyticsAdminV1alphaListAccountsResponse"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/analytics.edit",
	//     "https://www.googleapis.com/auth/analytics.readonly"
	//   ]
	// }

}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *AccountsListCall) Pages(ctx context.Context, f func(*GoogleAnalyticsAdminV1alphaListAccountsResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken")) // reset paging to original point
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

// method id "analyticsadmin.accounts.patch":

type AccountsPatchCall struct {
	s                                  *Service
	name                               string
	googleanalyticsadminv1alphaaccount *GoogleAnalyticsAdminV1alphaAccount
	urlParams_                         gensupport.URLParams
	ctx_                               context.Context
	header_                            http.Header
}

// Patch: Updates an account.
//
//   - name: Output only. Resource name of this account. Format:
//     accounts/{account} Example: "accounts/100".
func (r *AccountsService) Patch(name string, googleanalyticsadminv1alphaaccount *GoogleAnalyticsAdminV1alphaAccount) *AccountsPatchCall {
	c := &AccountsPatchCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	c.googleanalyticsadminv1alphaaccount = googleanalyticsadminv1alphaaccount
	return c
}

// UpdateMask sets the optional parameter "updateMask": Required. The
// list of fields to be updated. Field names must be in snake case (for
// example, "field_to_update"). Omitted fields will not be updated. To
// replace the entire entity, use one path with the string "*" to match
// all fields.
func (c *AccountsPatchCall) UpdateMask(updateMask string) *AccountsPatchCall {
	c.urlParams_.Set("updateMask", updateMask)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *AccountsPatchCall) Fields(s ...googleapi.Field) *AccountsPatchCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *AccountsPatchCall) Context(ctx context.Context) *AccountsPatchCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *AccountsPatchCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *AccountsPatchCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.googleanalyticsadminv1alphaaccount)
	if err != nil {
		return nil, err
	}
	reqHeaders.Set("Content-Type", "application/json")
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1alpha/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("PATCH", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "analyticsadmin.accounts.patch" call.
// Exactly one of *GoogleAnalyticsAdminV1alphaAccount or error will be
// non-nil. Any non-2xx status code is an error. Response headers are in
// either *GoogleAnalyticsAdminV1alphaAccount.ServerResponse.Header or
// (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was
// returned.
func (c *AccountsPatchCall) Do(opts ...googleapi.CallOption) (*GoogleAnalyticsAdminV1alphaAccount, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleAnalyticsAdminV1alphaAccount{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Updates an account.",
	//   "flatPath": "v1alpha/accounts/{accountsId}",
	//   "httpMethod": "PATCH",
	//   "id": "analyticsadmin.accounts.patch",
	//   "parameterOrder": [
	//     "name"
	//   ],
	//   "parameters": {
	//     "name": {
	//       "description": "Output only. Resource name of this account. Format: accounts/{account} Example: \"accounts/100\"",
	//       "location": "path",
	//       "pattern": "^accounts/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     },
	//     "updateMask": {
	//       "description": "Required. The list of fields to be updated. Field names must be in snake case (for example, \"field_to_update\"). Omitted fields will not be updated. To replace the entire entity, use one path with the string \"*\" to match all fields.",
	//       "format": "google-fieldmask",
	//       "location": "query",
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1alpha/{+name}",
	//   "request": {
	//     "$ref": "GoogleAnalyticsAdminV1alphaAccount"
	//   },
	//   "response": {
	//     "$ref": "GoogleAnalyticsAdminV1alphaAccount"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/analytics.edit"
	//   ]
	// }

}

// method id "analyticsadmin.accounts.provisionAccountTicket":

type AccountsProvisionAccountTicketCall struct {
	s                                                        *Service
	googleanalyticsadminv1alphaprovisionaccountticketrequest *GoogleAnalyticsAdminV1alphaProvisionAccountTicketRequest
	urlParams_                                               gensupport.URLParams
	ctx_                                                     context.Context
	header_                                                  http.Header
}

// ProvisionAccountTicket: Requests a ticket for creating an account.
func (r *AccountsService) ProvisionAccountTicket(googleanalyticsadminv1alphaprovisionaccountticketrequest *GoogleAnalyticsAdminV1alphaProvisionAccountTicketRequest) *AccountsProvisionAccountTicketCall {
	c := &AccountsProvisionAccountTicketCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.googleanalyticsadminv1alphaprovisionaccountticketrequest = googleanalyticsadminv1alphaprovisionaccountticketrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *AccountsProvisionAccountTicketCall) Fields(s ...googleapi.Field) *AccountsProvisionAccountTicketCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *AccountsProvisionAccountTicketCall) Context(ctx context.Context) *AccountsProvisionAccountTicketCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *AccountsProvisionAccountTicketCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *AccountsProvisionAccountTicketCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.googleanalyticsadminv1alphaprovisionaccountticketrequest)
	if err != nil {
		return nil, err
	}
	reqHeaders.Set("Content-Type", "application/json")
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1alpha/accounts:provisionAccountTicket")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "analyticsadmin.accounts.provisionAccountTicket" call.
// Exactly one of
// *GoogleAnalyticsAdminV1alphaProvisionAccountTicketResponse or error
// will be non-nil. Any non-2xx status code is an error. Response
// headers are in either
// *GoogleAnalyticsAdminV1alphaProvisionAccountTicketResponse.ServerRespo
// nse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was
// returned.
func (c *AccountsProvisionAccountTicketCall) Do(opts ...googleapi.CallOption) (*GoogleAnalyticsAdminV1alphaProvisionAccountTicketResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleAnalyticsAdminV1alphaProvisionAccountTicketResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Requests a ticket for creating an account.",
	//   "flatPath": "v1alpha/accounts:provisionAccountTicket",
	//   "httpMethod": "POST",
	//   "id": "analyticsadmin.accounts.provisionAccountTicket",
	//   "parameterOrder": [],
	//   "parameters": {},
	//   "path": "v1alpha/accounts:provisionAccountTicket",
	//   "request": {
	//     "$ref": "GoogleAnalyticsAdminV1alphaProvisionAccountTicketRequest"
	//   },
	//   "response": {
	//     "$ref": "GoogleAnalyticsAdminV1alphaProvisionAccountTicketResponse"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/analytics.edit"
	//   ]
	// }

}

// method id "analyticsadmin.accounts.runAccessReport":

type AccountsRunAccessReportCall struct {
	s                                                 *Service
	entity                                            string
	googleanalyticsadminv1alpharunaccessreportrequest *GoogleAnalyticsAdminV1alphaRunAccessReportRequest
	urlParams_                                        gensupport.URLParams
	ctx_                                              context.Context
	header_                                           http.Header
}

// RunAccessReport: Returns a customized report of data access records.
// The report provides records of each time a user reads Google
// Analytics reporting data. Access records are retained for up to 2
// years. Data Access Reports can be requested for a property. The
// property must be in Google Analytics 360. This method is only
// available to Administrators. These data access records include GA4 UI
// Reporting, GA4 UI Explorations, GA4 Data API, and other products like
// Firebase & Admob that can retrieve data from Google Analytics through
// a linkage. These records don't include property configuration changes
// like adding a stream or changing a property's time zone. For
// configuration change history, see searchChangeHistoryEvents
// (https://developers.google.com/analytics/devguides/config/admin/v1/rest/v1alpha/accounts/searchChangeHistoryEvents).
//
//   - entity: The Data Access Report supports requesting at the property
//     level or account level. If requested at the account level, Data
//     Access Reports include all access for all properties under that
//     account. To request at the property level, entity should be for
//     example 'properties/123' if "123" is your GA4 property ID. To
//     request at the account level, entity should be for example
//     'accounts/1234' if "1234" is your GA4 Account ID.
func (r *AccountsService) RunAccessReport(entity string, googleanalyticsadminv1alpharunaccessreportrequest *GoogleAnalyticsAdminV1alphaRunAccessReportRequest) *AccountsRunAccessReportCall {
	c := &AccountsRunAccessReportCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.entity = entity
	c.googleanalyticsadminv1alpharunaccessreportrequest = googleanalyticsadminv1alpharunaccessreportrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *AccountsRunAccessReportCall) Fields(s ...googleapi.Field) *AccountsRunAccessReportCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *AccountsRunAccessReportCall) Context(ctx context.Context) *AccountsRunAccessReportCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *AccountsRunAccessReportCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *AccountsRunAccessReportCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.googleanalyticsadminv1alpharunaccessreportrequest)
	if err != nil {
		return nil, err
	}
	reqHeaders.Set("Content-Type", "application/json")
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1alpha/{+entity}:runAccessReport")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"entity": c.entity,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "analyticsadmin.accounts.runAccessReport" call.
// Exactly one of *GoogleAnalyticsAdminV1alphaRunAccessReportResponse or
// error will be non-nil. Any non-2xx status code is an error. Response
// headers are in either
// *GoogleAnalyticsAdminV1alphaRunAccessReportResponse.ServerResponse.Hea
// der or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was
// returned.
func (c *AccountsRunAccessReportCall) Do(opts ...googleapi.CallOption) (*GoogleAnalyticsAdminV1alphaRunAccessReportResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleAnalyticsAdminV1alphaRunAccessReportResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Returns a customized report of data access records. The report provides records of each time a user reads Google Analytics reporting data. Access records are retained for up to 2 years. Data Access Reports can be requested for a property. The property must be in Google Analytics 360. This method is only available to Administrators. These data access records include GA4 UI Reporting, GA4 UI Explorations, GA4 Data API, and other products like Firebase \u0026 Admob that can retrieve data from Google Analytics through a linkage. These records don't include property configuration changes like adding a stream or changing a property's time zone. For configuration change history, see [searchChangeHistoryEvents](https://developers.google.com/analytics/devguides/config/admin/v1/rest/v1alpha/accounts/searchChangeHistoryEvents).",
	//   "flatPath": "v1alpha/accounts/{accountsId}:runAccessReport",
	//   "httpMethod": "POST",
	//   "id": "analyticsadmin.accounts.runAccessReport",
	//   "parameterOrder": [
	//     "entity"
	//   ],
	//   "parameters": {
	//     "entity": {
	//       "description": "The Data Access Report supports requesting at the property level or account level. If requested at the account level, Data Access Reports include all access for all properties under that account. To request at the property level, entity should be for example 'properties/123' if \"123\" is your GA4 property ID. To request at the account level, entity should be for example 'accounts/1234' if \"1234\" is your GA4 Account ID.",
	//       "location": "path",
	//       "pattern": "^accounts/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1alpha/{+entity}:runAccessReport",
	//   "request": {
	//     "$ref": "GoogleAnalyticsAdminV1alphaRunAccessReportRequest"
	//   },
	//   "response": {
	//     "$ref": "GoogleAnalyticsAdminV1alphaRunAccessReportResponse"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/analytics.edit",
	//     "https://www.googleapis.com/auth/analytics.readonly"
	//   ]
	// }

}

// method id "analyticsadmin.accounts.searchChangeHistoryEvents":

type AccountsSearchChangeHistoryEventsCall struct {
	s                                                           *Service
	account                                                     string
	googleanalyticsadminv1alphasearchchangehistoryeventsrequest *GoogleAnalyticsAdminV1alphaSearchChangeHistoryEventsRequest
	urlParams_                                                  gensupport.URLParams
	ctx_                                                        context.Context
	header_                                                     http.Header
}

// SearchChangeHistoryEvents: Searches through all changes to an account
// or its children given the specified set of filters.
//
//   - account: The account resource for which to return change history
//     resources.
func (r *AccountsService) SearchChangeHistoryEvents(account string, googleanalyticsadminv1alphasearchchangehistoryeventsrequest *GoogleAnalyticsAdminV1alphaSearchChangeHistoryEventsRequest) *AccountsSearchChangeHistoryEventsCall {
	c := &AccountsSearchChangeHistoryEventsCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.account = account
	c.googleanalyticsadminv1alphasearchchangehistoryeventsrequest = googleanalyticsadminv1alphasearchchangehistoryeventsrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *AccountsSearchChangeHistoryEventsCall) Fields(s ...googleapi.Field) *AccountsSearchChangeHistoryEventsCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *AccountsSearchChangeHistoryEventsCall) Context(ctx context.Context) *AccountsSearchChangeHistoryEventsCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *AccountsSearchChangeHistoryEventsCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *AccountsSearchChangeHistoryEventsCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.googleanalyticsadminv1alphasearchchangehistoryeventsrequest)
	if err != nil {
		return nil, err
	}
	reqHeaders.Set("Content-Type", "application/json")
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1alpha/{+account}:searchChangeHistoryEvents")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"account": c.account,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "analyticsadmin.accounts.searchChangeHistoryEvents" call.
// Exactly one of
// *GoogleAnalyticsAdminV1alphaSearchChangeHistoryEventsResponse or
// error will be non-nil. Any non-2xx status code is an error. Response
// headers are in either
// *GoogleAnalyticsAdminV1alphaSearchChangeHistoryEventsResponse.ServerRe
// sponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was
// returned.
func (c *AccountsSearchChangeHistoryEventsCall) Do(opts ...googleapi.CallOption) (*GoogleAnalyticsAdminV1alphaSearchChangeHistoryEventsResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleAnalyticsAdminV1alphaSearchChangeHistoryEventsResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Searches through all changes to an account or its children given the specified set of filters.",
	//   "flatPath": "v1alpha/accounts/{accountsId}:searchChangeHistoryEvents",
	//   "httpMethod": "POST",
	//   "id": "analyticsadmin.accounts.searchChangeHistoryEvents",
	//   "parameterOrder": [
	//     "account"
	//   ],
	//   "parameters": {
	//     "account": {
	//       "description": "Required. The account resource for which to return change history resources.",
	//       "location": "path",
	//       "pattern": "^accounts/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1alpha/{+account}:searchChangeHistoryEvents",
	//   "request": {
	//     "$ref": "GoogleAnalyticsAdminV1alphaSearchChangeHistoryEventsRequest"
	//   },
	//   "response": {
	//     "$ref": "GoogleAnalyticsAdminV1alphaSearchChangeHistoryEventsResponse"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/analytics.edit"
	//   ]
	// }

}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *AccountsSearchChangeHistoryEventsCall) Pages(ctx context.Context, f func(*GoogleAnalyticsAdminV1alphaSearchChangeHistoryEventsResponse) error) error {
	c.ctx_ = ctx
	defer func(pt string) { c.googleanalyticsadminv1alphasearchchangehistoryeventsrequest.PageToken = pt }(c.googleanalyticsadminv1alphasearchchangehistoryeventsrequest.PageToken) // reset paging to original point
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.googleanalyticsadminv1alphasearchchangehistoryeventsrequest.PageToken = x.NextPageToken
	}
}

// method id "analyticsadmin.accounts.accessBindings.batchCreate":

type AccountsAccessBindingsBatchCreateCall struct {
	s                                                           *Service
	parent                                                      string
	googleanalyticsadminv1alphabatchcreateaccessbindingsrequest *GoogleAnalyticsAdminV1alphaBatchCreateAccessBindingsRequest
	urlParams_                                                  gensupport.URLParams
	ctx_                                                        context.Context
	header_                                                     http.Header
}

// BatchCreate: Creates information about multiple access bindings to an
// account or property. This method is transactional. If any
// AccessBinding cannot be created, none of the AccessBindings will be
// created.
//
//   - parent: The account or property that owns the access bindings. The
//     parent field in the CreateAccessBindingRequest messages must either
//     be empty or match this field. Formats: - accounts/{account} -
//     properties/{property}.
func (r *AccountsAccessBindingsService) BatchCreate(parent string, googleanalyticsadminv1alphabatchcreateaccessbindingsrequest *GoogleAnalyticsAdminV1alphaBatchCreateAccessBindingsRequest) *AccountsAccessBindingsBatchCreateCall {
	c := &AccountsAccessBindingsBatchCreateCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	c.googleanalyticsadminv1alphabatchcreateaccessbindingsrequest = googleanalyticsadminv1alphabatchcreateaccessbindingsrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *AccountsAccessBindingsBatchCreateCall) Fields(s ...googleapi.Field) *AccountsAccessBindingsBatchCreateCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *AccountsAccessBindingsBatchCreateCall) Context(ctx context.Context) *AccountsAccessBindingsBatchCreateCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *AccountsAccessBindingsBatchCreateCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *AccountsAccessBindingsBatchCreateCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.googleanalyticsadminv1alphabatchcreateaccessbindingsrequest)
	if err != nil {
		return nil, err
	}
	reqHeaders.Set("Content-Type", "application/json")
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1alpha/{+parent}/accessBindings:batchCreate")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "analyticsadmin.accounts.accessBindings.batchCreate" call.
// Exactly one of
// *GoogleAnalyticsAdminV1alphaBatchCreateAccessBindingsResponse or
// error will be non-nil. Any non-2xx status code is an error. Response
// headers are in either
// *GoogleAnalyticsAdminV1alphaBatchCreateAccessBindingsResponse.ServerRe
// sponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was
// returned.
func (c *AccountsAccessBindingsBatchCreateCall) Do(opts ...googleapi.CallOption) (*GoogleAnalyticsAdminV1alphaBatchCreateAccessBindingsResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleAnalyticsAdminV1alphaBatchCreateAccessBindingsResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Creates information about multiple access bindings to an account or property. This method is transactional. If any AccessBinding cannot be created, none of the AccessBindings will be created.",
	//   "flatPath": "v1alpha/accounts/{accountsId}/accessBindings:batchCreate",
	//   "httpMethod": "POST",
	//   "id": "analyticsadmin.accounts.accessBindings.batchCreate",
	//   "parameterOrder": [
	//     "parent"
	//   ],
	//   "parameters": {
	//     "parent": {
	//       "description": "Required. The account or property that owns the access bindings. The parent field in the CreateAccessBindingRequest messages must either be empty or match this field. Formats: - accounts/{account} - properties/{property}",
	//       "location": "path",
	//       "pattern": "^accounts/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1alpha/{+parent}/accessBindings:batchCreate",
	//   "request": {
	//     "$ref": "GoogleAnalyticsAdminV1alphaBatchCreateAccessBindingsRequest"
	//   },
	//   "response": {
	//     "$ref": "GoogleAnalyticsAdminV1alphaBatchCreateAccessBindingsResponse"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/analytics.manage.users"
	//   ]
	// }

}

// method id "analyticsadmin.accounts.accessBindings.batchDelete":

type AccountsAccessBindingsBatchDeleteCall struct {
	s                                                           *Service
	parent                                                      string
	googleanalyticsadminv1alphabatchdeleteaccessbindingsrequest *GoogleAnalyticsAdminV1alphaBatchDeleteAccessBindingsRequest
	urlParams_                                                  gensupport.URLParams
	ctx_                                                        context.Context
	header_                                                     http.Header
}

// BatchDelete: Deletes information about multiple users' links to an
// account or property.
//
//   - parent: The account or property that owns the access bindings. The
//     parent of all provided values for the 'names' field in
//     DeleteAccessBindingRequest messages must match this field. Formats:
//   - accounts/{account} - properties/{property}.
func (r *AccountsAccessBindingsService) BatchDelete(parent string, googleanalyticsadminv1alphabatchdeleteaccessbindingsrequest *GoogleAnalyticsAdminV1alphaBatchDeleteAccessBindingsRequest) *AccountsAccessBindingsBatchDeleteCall {
	c := &AccountsAccessBindingsBatchDeleteCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	c.googleanalyticsadminv1alphabatchdeleteaccessbindingsrequest = googleanalyticsadminv1alphabatchdeleteaccessbindingsrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *AccountsAccessBindingsBatchDeleteCall) Fields(s ...googleapi.Field) *AccountsAccessBindingsBatchDeleteCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *AccountsAccessBindingsBatchDeleteCall) Context(ctx context.Context) *AccountsAccessBindingsBatchDeleteCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *AccountsAccessBindingsBatchDeleteCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *AccountsAccessBindingsBatchDeleteCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.googleanalyticsadminv1alphabatchdeleteaccessbindingsrequest)
	if err != nil {
		return nil, err
	}
	reqHeaders.Set("Content-Type", "application/json")
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1alpha/{+parent}/accessBindings:batchDelete")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "analyticsadmin.accounts.accessBindings.batchDelete" call.
// Exactly one of *GoogleProtobufEmpty or error will be non-nil. Any
// non-2xx status code is an error. Response headers are in either
// *GoogleProtobufEmpty.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was
// because http.StatusNotModified was returned.
func (c *AccountsAccessBindingsBatchDeleteCall) Do(opts ...googleapi.CallOption) (*GoogleProtobufEmpty, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleProtobufEmpty{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Deletes information about multiple users' links to an account or property.",
	//   "flatPath": "v1alpha/accounts/{accountsId}/accessBindings:batchDelete",
	//   "httpMethod": "POST",
	//   "id": "analyticsadmin.accounts.accessBindings.batchDelete",
	//   "parameterOrder": [
	//     "parent"
	//   ],
	//   "parameters": {
	//     "parent": {
	//       "description": "Required. The account or property that owns the access bindings. The parent of all provided values for the 'names' field in DeleteAccessBindingRequest messages must match this field. Formats: - accounts/{account} - properties/{property}",
	//       "location": "path",
	//       "pattern": "^accounts/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1alpha/{+parent}/accessBindings:batchDelete",
	//   "request": {
	//     "$ref": "GoogleAnalyticsAdminV1alphaBatchDeleteAccessBindingsRequest"
	//   },
	//   "response": {
	//     "$ref": "GoogleProtobufEmpty"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/analytics.manage.users"
	//   ]
	// }

}

// method id "analyticsadmin.accounts.accessBindings.batchGet":

type AccountsAccessBindingsBatchGetCall struct {
	s            *Service
	parent       string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// BatchGet: Gets information about multiple access bindings to an
// account or property.
//
//   - parent: The account or property that owns the access bindings. The
//     parent of all provided values for the 'names' field must match this
//     field. Formats: - accounts/{account} - properties/{property}.
func (r *AccountsAccessBindingsService) BatchGet(parent string) *AccountsAccessBindingsBatchGetCall {
	c := &AccountsAccessBindingsBatchGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	return c
}

// Names sets the optional parameter "names": Required. The names of the
// access bindings to retrieve. A maximum of 1000 access bindings can be
// retrieved in a batch. Formats: -
// accounts/{account}/accessBindings/{accessBinding} -
// properties/{property}/accessBindings/{accessBinding}
func (c *AccountsAccessBindingsBatchGetCall) Names(names ...string) *AccountsAccessBindingsBatchGetCall {
	c.urlParams_.SetMulti("names", append([]string{}, names...))
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *AccountsAccessBindingsBatchGetCall) Fields(s ...googleapi.Field) *AccountsAccessBindingsBatchGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets the optional parameter which makes the operation
// fail if the object's ETag matches the given value. This is useful for
// getting updates only after the object has changed since the last
// request. Use googleapi.IsNotModified to check whether the response
// error from Do is the result of In-None-Match.
func (c *AccountsAccessBindingsBatchGetCall) IfNoneMatch(entityTag string) *AccountsAccessBindingsBatchGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *AccountsAccessBindingsBatchGetCall) Context(ctx context.Context) *AccountsAccessBindingsBatchGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *AccountsAccessBindingsBatchGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *AccountsAccessBindingsBatchGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1alpha/{+parent}/accessBindings:batchGet")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "analyticsadmin.accounts.accessBindings.batchGet" call.
// Exactly one of
// *GoogleAnalyticsAdminV1alphaBatchGetAccessBindingsResponse or error
// will be non-nil. Any non-2xx status code is an error. Response
// headers are in either
// *GoogleAnalyticsAdminV1alphaBatchGetAccessBindingsResponse.ServerRespo
// nse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was
// returned.
func (c *AccountsAccessBindingsBatchGetCall) Do(opts ...googleapi.CallOption) (*GoogleAnalyticsAdminV1alphaBatchGetAccessBindingsResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleAnalyticsAdminV1alphaBatchGetAccessBindingsResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Gets information about multiple access bindings to an account or property.",
	//   "flatPath": "v1alpha/accounts/{accountsId}/accessBindings:batchGet",
	//   "httpMethod": "GET",
	//   "id": "analyticsadmin.accounts.accessBindings.batchGet",
	//   "parameterOrder": [
	//     "parent"
	//   ],
	//   "parameters": {
	//     "names": {
	//       "description": "Required. The names of the access bindings to retrieve. A maximum of 1000 access bindings can be retrieved in a batch. Formats: - accounts/{account}/accessBindings/{accessBinding} - properties/{property}/accessBindings/{accessBinding}",
	//       "location": "query",
	//       "repeated": true,
	//       "type": "string"
	//     },
	//     "parent": {
	//       "description": "Required. The account or property that owns the access bindings. The parent of all provided values for the 'names' field must match this field. Formats: - accounts/{account} - properties/{property}",
	//       "location": "path",
	//       "pattern": "^accounts/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1alpha/{+parent}/accessBindings:batchGet",
	//   "response": {
	//     "$ref": "GoogleAnalyticsAdminV1alphaBatchGetAccessBindingsResponse"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/analytics.manage.users",
	//     "https://www.googleapis.com/auth/analytics.manage.users.readonly"
	//   ]
	// }

}

// method id "analyticsadmin.accounts.accessBindings.batchUpdate":

type AccountsAccessBindingsBatchUpdateCall struct {
	s                                                           *Service
	parent                                                      string
	googleanalyticsadminv1alphabatchupdateaccessbindingsrequest *GoogleAnalyticsAdminV1alphaBatchUpdateAccessBindingsRequest
	urlParams_                                                  gensupport.URLParams
	ctx_                                                        context.Context
	header_                                                     http.Header
}

// BatchUpdate: Updates information about multiple access bindings to an
// account or property.
//
//   - parent: The account or property that owns the access bindings. The
//     parent of all provided AccessBinding in UpdateAccessBindingRequest
//     messages must match this field. Formats: - accounts/{account} -
//     properties/{property}.
func (r *AccountsAccessBindingsService) BatchUpdate(parent string, googleanalyticsadminv1alphabatchupdateaccessbindingsrequest *GoogleAnalyticsAdminV1alphaBatchUpdateAccessBindingsRequest) *AccountsAccessBindingsBatchUpdateCall {
	c := &AccountsAccessBindingsBatchUpdateCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	c.googleanalyticsadminv1alphabatchupdateaccessbindingsrequest = googleanalyticsadminv1alphabatchupdateaccessbindingsrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *AccountsAccessBindingsBatchUpdateCall) Fields(s ...googleapi.Field) *AccountsAccessBindingsBatchUpdateCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *AccountsAccessBindingsBatchUpdateCall) Context(ctx context.Context) *AccountsAccessBindingsBatchUpdateCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *AccountsAccessBindingsBatchUpdateCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *AccountsAccessBindingsBatchUpdateCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.googleanalyticsadminv1alphabatchupdateaccessbindingsrequest)
	if err != nil {
		return nil, err
	}
	reqHeaders.Set("Content-Type", "application/json")
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1alpha/{+parent}/accessBindings:batchUpdate")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "analyticsadmin.accounts.accessBindings.batchUpdate" call.
// Exactly one of
// *GoogleAnalyticsAdminV1alphaBatchUpdateAccessBindingsResponse or
// error will be non-nil. Any non-2xx status code is an error. Response
// headers are in either
// *GoogleAnalyticsAdminV1alphaBatchUpdateAccessBindingsResponse.ServerRe
// sponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was
// returned.
func (c *AccountsAccessBindingsBatchUpdateCall) Do(opts ...googleapi.CallOption) (*GoogleAnalyticsAdminV1alphaBatchUpdateAccessBindingsResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleAnalyticsAdminV1alphaBatchUpdateAccessBindingsResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Updates information about multiple access bindings to an account or property.",
	//   "flatPath": "v1alpha/accounts/{accountsId}/accessBindings:batchUpdate",
	//   "httpMethod": "POST",
	//   "id": "analyticsadmin.accounts.accessBindings.batchUpdate",
	//   "parameterOrder": [
	//     "parent"
	//   ],
	//   "parameters": {
	//     "parent": {
	//       "description": "Required. The account or property that owns the access bindings. The parent of all provided AccessBinding in UpdateAccessBindingRequest messages must match this field. Formats: - accounts/{account} - properties/{property}",
	//       "location": "path",
	//       "pattern": "^accounts/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1alpha/{+parent}/accessBindings:batchUpdate",
	//   "request": {
	//     "$ref": "GoogleAnalyticsAdminV1alphaBatchUpdateAccessBindingsRequest"
	//   },
	//   "response": {
	//     "$ref": "GoogleAnalyticsAdminV1alphaBatchUpdateAccessBindingsResponse"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/analytics.manage.users"
	//   ]
	// }

}

// method id "analyticsadmin.accounts.accessBindings.create":

type AccountsAccessBindingsCreateCall struct {
	s                                        *Service
	parent                                   string
	googleanalyticsadminv1alphaaccessbinding *GoogleAnalyticsAdminV1alphaAccessBinding
	urlParams_                               gensupport.URLParams
	ctx_                                     context.Context
	header_                                  http.Header
}

// Create: Creates an access binding on an account or property.
//
// - parent: Formats: - accounts/{account} - properties/{property}.
func (r *AccountsAccessBindingsService) Create(parent string, googleanalyticsadminv1alphaaccessbinding *GoogleAnalyticsAdminV1alphaAccessBinding) *AccountsAccessBindingsCreateCall {
	c := &AccountsAccessBindingsCreateCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	c.googleanalyticsadminv1alphaaccessbinding = googleanalyticsadminv1alphaaccessbinding
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *AccountsAccessBindingsCreateCall) Fields(s ...googleapi.Field) *AccountsAccessBindingsCreateCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *AccountsAccessBindingsCreateCall) Context(ctx context.Context) *AccountsAccessBindingsCreateCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *AccountsAccessBindingsCreateCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *AccountsAccessBindingsCreateCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.googleanalyticsadminv1alphaaccessbinding)
	if err != nil {
		return nil, err
	}
	reqHeaders.Set("Content-Type", "application/json")
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1alpha/{+parent}/accessBindings")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "analyticsadmin.accounts.accessBindings.create" call.
// Exactly one of *GoogleAnalyticsAdminV1alphaAccessBinding or error
// will be non-nil. Any non-2xx status code is an error. Response
// headers are in either
// *GoogleAnalyticsAdminV1alphaAccessBinding.ServerResponse.Header or
// (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was
// returned.
func (c *AccountsAccessBindingsCreateCall) Do(opts ...googleapi.CallOption) (*GoogleAnalyticsAdminV1alphaAccessBinding, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleAnalyticsAdminV1alphaAccessBinding{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Creates an access binding on an account or property.",
	//   "flatPath": "v1alpha/accounts/{accountsId}/accessBindings",
	//   "httpMethod": "POST",
	//   "id": "analyticsadmin.accounts.accessBindings.create",
	//   "parameterOrder": [
	//     "parent"
	//   ],
	//   "parameters": {
	//     "parent": {
	//       "description": "Required. Formats: - accounts/{account} - properties/{property}",
	//       "location": "path",
	//       "pattern": "^accounts/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1alpha/{+parent}/accessBindings",
	//   "request": {
	//     "$ref": "GoogleAnalyticsAdminV1alphaAccessBinding"
	//   },
	//   "response": {
	//     "$ref": "GoogleAnalyticsAdminV1alphaAccessBinding"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/analytics.manage.users"
	//   ]
	// }

}

// method id "analyticsadmin.accounts.accessBindings.delete":

type AccountsAccessBindingsDeleteCall struct {
	s          *Service
	name       string
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Delete: Deletes an access binding on an account or property.
//
// - name: Formats: - accounts/{account}/accessBindings/{accessBinding}
//   - properties/{property}/accessBindings/{accessBinding}.
func (r *AccountsAccessBindingsService) Delete(name string) *AccountsAccessBindingsDeleteCall {
	c := &AccountsAccessBindingsDeleteCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *AccountsAccessBindingsDeleteCall) Fields(s ...googleapi.Field) *AccountsAccessBindingsDeleteCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *AccountsAccessBindingsDeleteCall) Context(ctx context.Context) *AccountsAccessBindingsDeleteCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *AccountsAccessBindingsDeleteCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *AccountsAccessBindingsDeleteCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1alpha/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("DELETE", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "analyticsadmin.accounts.accessBindings.delete" call.
// Exactly one of *GoogleProtobufEmpty or error will be non-nil. Any
// non-2xx status code is an error. Response headers are in either
// *GoogleProtobufEmpty.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was
// because http.StatusNotModified was returned.
func (c *AccountsAccessBindingsDeleteCall) Do(opts ...googleapi.CallOption) (*GoogleProtobufEmpty, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleProtobufEmpty{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Deletes an access binding on an account or property.",
	//   "flatPath": "v1alpha/accounts/{accountsId}/accessBindings/{accessBindingsId}",
	//   "httpMethod": "DELETE",
	//   "id": "analyticsadmin.accounts.accessBindings.delete",
	//   "parameterOrder": [
	//     "name"
	//   ],
	//   "parameters": {
	//     "name": {
	//       "description": "Required. Formats: - accounts/{account}/accessBindings/{accessBinding} - properties/{property}/accessBindings/{accessBinding}",
	//       "location": "path",
	//       "pattern": "^accounts/[^/]+/accessBindings/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1alpha/{+name}",
	//   "response": {
	//     "$ref": "GoogleProtobufEmpty"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/analytics.manage.users"
	//   ]
	// }

}

// method id "analyticsadmin.accounts.accessBindings.get":

type AccountsAccessBindingsGetCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Gets information about an access binding.
//
//   - name: The name of the access binding to retrieve. Formats: -
//     accounts/{account}/accessBindings/{accessBinding} -
//     properties/{property}/accessBindings/{accessBinding}.
func (r *AccountsAccessBindingsService) Get(name string) *AccountsAccessBindingsGetCall {
	c := &AccountsAccessBindingsGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *AccountsAccessBindingsGetCall) Fields(s ...googleapi.Field) *AccountsAccessBindingsGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets the optional parameter which makes the operation
// fail if the object's ETag matches the given value. This is useful for
// getting updates only after the object has changed since the last
// request. Use googleapi.IsNotModified to check whether the response
// error from Do is the result of In-None-Match.
func (c *AccountsAccessBindingsGetCall) IfNoneMatch(entityTag string) *AccountsAccessBindingsGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *AccountsAccessBindingsGetCall) Context(ctx context.Context) *AccountsAccessBindingsGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *AccountsAccessBindingsGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *AccountsAccessBindingsGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1alpha/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "analyticsadmin.accounts.accessBindings.get" call.
// Exactly one of *GoogleAnalyticsAdminV1alphaAccessBinding or error
// will be non-nil. Any non-2xx status code is an error. Response
// headers are in either
// *GoogleAnalyticsAdminV1alphaAccessBinding.ServerResponse.Header or
// (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was
// returned.
func (c *AccountsAccessBindingsGetCall) Do(opts ...googleapi.CallOption) (*GoogleAnalyticsAdminV1alphaAccessBinding, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleAnalyticsAdminV1alphaAccessBinding{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Gets information about an access binding.",
	//   "flatPath": "v1alpha/accounts/{accountsId}/accessBindings/{accessBindingsId}",
	//   "httpMethod": "GET",
	//   "id": "analyticsadmin.accounts.accessBindings.get",
	//   "parameterOrder": [
	//     "name"
	//   ],
	//   "parameters": {
	//     "name": {
	//       "description": "Required. The name of the access binding to retrieve. Formats: - accounts/{account}/accessBindings/{accessBinding} - properties/{property}/accessBindings/{accessBinding}",
	//       "location": "path",
	//       "pattern": "^accounts/[^/]+/accessBindings/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1alpha/{+name}",
	//   "response": {
	//     "$ref": "GoogleAnalyticsAdminV1alphaAccessBinding"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/analytics.manage.users",
	//     "https://www.googleapis.com/auth/analytics.manage.users.readonly"
	//   ]
	// }

}

// method id "analyticsadmin.accounts.accessBindings.list":

type AccountsAccessBindingsListCall struct {
	s            *Service
	parent       string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Lists all access bindings on an account or property.
//
// - parent: Formats: - accounts/{account} - properties/{property}.
func (r *AccountsAccessBindingsService) List(parent string) *AccountsAccessBindingsListCall {
	c := &AccountsAccessBindingsListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	return c
}

// PageSize sets the optional parameter "pageSize": The maximum number
// of access bindings to return. The service may return fewer than this
// value. If unspecified, at most 200 access bindings will be returned.
// The maximum value is 500; values above 500 will be coerced to 500.
func (c *AccountsAccessBindingsListCall) PageSize(pageSize int64) *AccountsAccessBindingsListCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": A page token,
// received from a previous `ListAccessBindings` call. Provide this to
// retrieve the subsequent page. When paginating, all other parameters
// provided to `ListAccessBindings` must match the call that provided
// the page token.
func (c *AccountsAccessBindingsListCall) PageToken(pageToken string) *AccountsAccessBindingsListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *AccountsAccessBindingsListCall) Fields(s ...googleapi.Field) *AccountsAccessBindingsListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets the optional parameter which makes the operation
// fail if the object's ETag matches the given value. This is useful for
// getting updates only after the object has changed since the last
// request. Use googleapi.IsNotModified to check whether the response
// error from Do is the result of In-None-Match.
func (c *AccountsAccessBindingsListCall) IfNoneMatch(entityTag string) *AccountsAccessBindingsListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *AccountsAccessBindingsListCall) Context(ctx context.Context) *AccountsAccessBindingsListCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *AccountsAccessBindingsListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *AccountsAccessBindingsListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1alpha/{+parent}/accessBindings")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "analyticsadmin.accounts.accessBindings.list" call.
// Exactly one of *GoogleAnalyticsAdminV1alphaListAccessBindingsResponse
// or error will be non-nil. Any non-2xx status code is an error.
// Response headers are in either
// *GoogleAnalyticsAdminV1alphaListAccessBindingsResponse.ServerResponse.
// Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was
// returned.
func (c *AccountsAccessBindingsListCall) Do(opts ...googleapi.CallOption) (*GoogleAnalyticsAdminV1alphaListAccessBindingsResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleAnalyticsAdminV1alphaListAccessBindingsResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Lists all access bindings on an account or property.",
	//   "flatPath": "v1alpha/accounts/{accountsId}/accessBindings",
	//   "httpMethod": "GET",
	//   "id": "analyticsadmin.accounts.accessBindings.list",
	//   "parameterOrder": [
	//     "parent"
	//   ],
	//   "parameters": {
	//     "pageSize": {
	//       "description": "The maximum number of access bindings to return. The service may return fewer than this value. If unspecified, at most 200 access bindings will be returned. The maximum value is 500; values above 500 will be coerced to 500.",
	//       "format": "int32",
	//       "location": "query",
	//       "type": "integer"
	//     },
	//     "pageToken": {
	//       "description": "A page token, received from a previous `ListAccessBindings` call. Provide this to retrieve the subsequent page. When paginating, all other parameters provided to `ListAccessBindings` must match the call that provided the page token.",
	//       "location": "query",
	//       "type": "string"
	//     },
	//     "parent": {
	//       "description": "Required. Formats: - accounts/{account} - properties/{property}",
	//       "location": "path",
	//       "pattern": "^accounts/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1alpha/{+parent}/accessBindings",
	//   "response": {
	//     "$ref": "GoogleAnalyticsAdminV1alphaListAccessBindingsResponse"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/analytics.manage.users",
	//     "https://www.googleapis.com/auth/analytics.manage.users.readonly"
	//   ]
	// }

}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *AccountsAccessBindingsListCall) Pages(ctx context.Context, f func(*GoogleAnalyticsAdminV1alphaListAccessBindingsResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken")) // reset paging to original point
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

// method id "analyticsadmin.accounts.accessBindings.patch":

type AccountsAccessBindingsPatchCall struct {
	s                                        *Service
	name                                     string
	googleanalyticsadminv1alphaaccessbinding *GoogleAnalyticsAdminV1alphaAccessBinding
	urlParams_                               gensupport.URLParams
	ctx_                                     context.Context
	header_                                  http.Header
}

// Patch: Updates an access binding on an account or property.
//
//   - name: Output only. Resource name of this binding. Format:
//     accounts/{account}/accessBindings/{access_binding} or
//     properties/{property}/accessBindings/{access_binding} Example:
//     "accounts/100/accessBindings/200".
func (r *AccountsAccessBindingsService) Patch(name string, googleanalyticsadminv1alphaaccessbinding *GoogleAnalyticsAdminV1alphaAccessBinding) *AccountsAccessBindingsPatchCall {
	c := &AccountsAccessBindingsPatchCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	c.googleanalyticsadminv1alphaaccessbinding = googleanalyticsadminv1alphaaccessbinding
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *AccountsAccessBindingsPatchCall) Fields(s ...googleapi.Field) *AccountsAccessBindingsPatchCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *AccountsAccessBindingsPatchCall) Context(ctx context.Context) *AccountsAccessBindingsPatchCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *AccountsAccessBindingsPatchCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *AccountsAccessBindingsPatchCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.googleanalyticsadminv1alphaaccessbinding)
	if err != nil {
		return nil, err
	}
	reqHeaders.Set("Content-Type", "application/json")
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1alpha/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("PATCH", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "analyticsadmin.accounts.accessBindings.patch" call.
// Exactly one of *GoogleAnalyticsAdminV1alphaAccessBinding or error
// will be non-nil. Any non-2xx status code is an error. Response
// headers are in either
// *GoogleAnalyticsAdminV1alphaAccessBinding.ServerResponse.Header or
// (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was
// returned.
func (c *AccountsAccessBindingsPatchCall) Do(opts ...googleapi.CallOption) (*GoogleAnalyticsAdminV1alphaAccessBinding, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleAnalyticsAdminV1alphaAccessBinding{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Updates an access binding on an account or property.",
	//   "flatPath": "v1alpha/accounts/{accountsId}/accessBindings/{accessBindingsId}",
	//   "httpMethod": "PATCH",
	//   "id": "analyticsadmin.accounts.accessBindings.patch",
	//   "parameterOrder": [
	//     "name"
	//   ],
	//   "parameters": {
	//     "name": {
	//       "description": "Output only. Resource name of this binding. Format: accounts/{account}/accessBindings/{access_binding} or properties/{property}/accessBindings/{access_binding} Example: \"accounts/100/accessBindings/200\"",
	//       "location": "path",
	//       "pattern": "^accounts/[^/]+/accessBindings/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1alpha/{+name}",
	//   "request": {
	//     "$ref": "GoogleAnalyticsAdminV1alphaAccessBinding"
	//   },
	//   "response": {
	//     "$ref": "GoogleAnalyticsAdminV1alphaAccessBinding"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/analytics.manage.users"
	//   ]
	// }

}

// method id "analyticsadmin.accounts.userLinks.audit":

type AccountsUserLinksAuditCall struct {
	s                                                *Service
	parent                                           string
	googleanalyticsadminv1alphaaudituserlinksrequest *GoogleAnalyticsAdminV1alphaAuditUserLinksRequest
	urlParams_                                       gensupport.URLParams
	ctx_                                             context.Context
	header_                                          http.Header
}

// Audit: Lists all user links on an account or property, including
// implicit ones that come from effective permissions granted by groups
// or organization admin roles. If a returned user link does not have
// direct permissions, they cannot be removed from the account or
// property directly with the DeleteUserLink command. They have to be
// removed from the group/etc that gives them permissions, which is
// currently only usable/discoverable in the GA or GMP UIs.
//
// - parent: Example format: accounts/1234.
func (r *AccountsUserLinksService) Audit(parent string, googleanalyticsadminv1alphaaudituserlinksrequest *GoogleAnalyticsAdminV1alphaAuditUserLinksRequest) *AccountsUserLinksAuditCall {
	c := &AccountsUserLinksAuditCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	c.googleanalyticsadminv1alphaaudituserlinksrequest = googleanalyticsadminv1alphaaudituserlinksrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *AccountsUserLinksAuditCall) Fields(s ...googleapi.Field) *AccountsUserLinksAuditCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *AccountsUserLinksAuditCall) Context(ctx context.Context) *AccountsUserLinksAuditCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *AccountsUserLinksAuditCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *AccountsUserLinksAuditCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.googleanalyticsadminv1alphaaudituserlinksrequest)
	if err != nil {
		return nil, err
	}
	reqHeaders.Set("Content-Type", "application/json")
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1alpha/{+parent}/userLinks:audit")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "analyticsadmin.accounts.userLinks.audit" call.
// Exactly one of *GoogleAnalyticsAdminV1alphaAuditUserLinksResponse or
// error will be non-nil. Any non-2xx status code is an error. Response
// headers are in either
// *GoogleAnalyticsAdminV1alphaAuditUserLinksResponse.ServerResponse.Head
// er or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was
// returned.
func (c *AccountsUserLinksAuditCall) Do(opts ...googleapi.CallOption) (*GoogleAnalyticsAdminV1alphaAuditUserLinksResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleAnalyticsAdminV1alphaAuditUserLinksResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Lists all user links on an account or property, including implicit ones that come from effective permissions granted by groups or organization admin roles. If a returned user link does not have direct permissions, they cannot be removed from the account or property directly with the DeleteUserLink command. They have to be removed from the group/etc that gives them permissions, which is currently only usable/discoverable in the GA or GMP UIs.",
	//   "flatPath": "v1alpha/accounts/{accountsId}/userLinks:audit",
	//   "httpMethod": "POST",
	//   "id": "analyticsadmin.accounts.userLinks.audit",
	//   "parameterOrder": [
	//     "parent"
	//   ],
	//   "parameters": {
	//     "parent": {
	//       "description": "Required. Example format: accounts/1234",
	//       "location": "path",
	//       "pattern": "^accounts/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1alpha/{+parent}/userLinks:audit",
	//   "request": {
	//     "$ref": "GoogleAnalyticsAdminV1alphaAuditUserLinksRequest"
	//   },
	//   "response": {
	//     "$ref": "GoogleAnalyticsAdminV1alphaAuditUserLinksResponse"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/analytics.manage.users",
	//     "https://www.googleapis.com/auth/analytics.manage.users.readonly"
	//   ]
	// }

}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *AccountsUserLinksAuditCall) Pages(ctx context.Context, f func(*GoogleAnalyticsAdminV1alphaAuditUserLinksResponse) error) error {
	c.ctx_ = ctx
	defer func(pt string) { c.googleanalyticsadminv1alphaaudituserlinksrequest.PageToken = pt }(c.googleanalyticsadminv1alphaaudituserlinksrequest.PageToken) // reset paging to original point
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.googleanalyticsadminv1alphaaudituserlinksrequest.PageToken = x.NextPageToken
	}
}

// method id "analyticsadmin.accounts.userLinks.batchCreate":

type AccountsUserLinksBatchCreateCall struct {
	s                                                      *Service
	parent                                                 string
	googleanalyticsadminv1alphabatchcreateuserlinksrequest *GoogleAnalyticsAdminV1alphaBatchCreateUserLinksRequest
	urlParams_                                             gensupport.URLParams
	ctx_                                                   context.Context
	header_                                                http.Header
}

// BatchCreate: Creates information about multiple users' links to an
// account or property. This method is transactional. If any UserLink
// cannot be created, none of the UserLinks will be created.
//
//   - parent: The account or property that all user links in the request
//     are for. This field is required. The parent field in the
//     CreateUserLinkRequest messages must either be empty or match this
//     field. Example format: accounts/1234.
func (r *AccountsUserLinksService) BatchCreate(parent string, googleanalyticsadminv1alphabatchcreateuserlinksrequest *GoogleAnalyticsAdminV1alphaBatchCreateUserLinksRequest) *AccountsUserLinksBatchCreateCall {
	c := &AccountsUserLinksBatchCreateCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	c.googleanalyticsadminv1alphabatchcreateuserlinksrequest = googleanalyticsadminv1alphabatchcreateuserlinksrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *AccountsUserLinksBatchCreateCall) Fields(s ...googleapi.Field) *AccountsUserLinksBatchCreateCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *AccountsUserLinksBatchCreateCall) Context(ctx context.Context) *AccountsUserLinksBatchCreateCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *AccountsUserLinksBatchCreateCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *AccountsUserLinksBatchCreateCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.googleanalyticsadminv1alphabatchcreateuserlinksrequest)
	if err != nil {
		return nil, err
	}
	reqHeaders.Set("Content-Type", "application/json")
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1alpha/{+parent}/userLinks:batchCreate")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "analyticsadmin.accounts.userLinks.batchCreate" call.
// Exactly one of
// *GoogleAnalyticsAdminV1alphaBatchCreateUserLinksResponse or error
// will be non-nil. Any non-2xx status code is an error. Response
// headers are in either
// *GoogleAnalyticsAdminV1alphaBatchCreateUserLinksResponse.ServerRespons
// e.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was
// returned.
func (c *AccountsUserLinksBatchCreateCall) Do(opts ...googleapi.CallOption) (*GoogleAnalyticsAdminV1alphaBatchCreateUserLinksResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleAnalyticsAdminV1alphaBatchCreateUserLinksResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Creates information about multiple users' links to an account or property. This method is transactional. If any UserLink cannot be created, none of the UserLinks will be created.",
	//   "flatPath": "v1alpha/accounts/{accountsId}/userLinks:batchCreate",
	//   "httpMethod": "POST",
	//   "id": "analyticsadmin.accounts.userLinks.batchCreate",
	//   "parameterOrder": [
	//     "parent"
	//   ],
	//   "parameters": {
	//     "parent": {
	//       "description": "Required. The account or property that all user links in the request are for. This field is required. The parent field in the CreateUserLinkRequest messages must either be empty or match this field. Example format: accounts/1234",
	//       "location": "path",
	//       "pattern": "^accounts/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1alpha/{+parent}/userLinks:batchCreate",
	//   "request": {
	//     "$ref": "GoogleAnalyticsAdminV1alphaBatchCreateUserLinksRequest"
	//   },
	//   "response": {
	//     "$ref": "GoogleAnalyticsAdminV1alphaBatchCreateUserLinksResponse"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/analytics.manage.users"
	//   ]
	// }

}

// method id "analyticsadmin.accounts.userLinks.batchDelete":

type AccountsUserLinksBatchDeleteCall struct {
	s                                                      *Service
	parent                                                 string
	googleanalyticsadminv1alphabatchdeleteuserlinksrequest *GoogleAnalyticsAdminV1alphaBatchDeleteUserLinksRequest
	urlParams_                                             gensupport.URLParams
	ctx_                                                   context.Context
	header_                                                http.Header
}

// BatchDelete: Deletes information about multiple users' links to an
// account or property.
//
//   - parent: The account or property that all user links in the request
//     are for. The parent of all values for user link names to delete
//     must match this field. Example format: accounts/1234.
func (r *AccountsUserLinksService) BatchDelete(parent string, googleanalyticsadminv1alphabatchdeleteuserlinksrequest *GoogleAnalyticsAdminV1alphaBatchDeleteUserLinksRequest) *AccountsUserLinksBatchDeleteCall {
	c := &AccountsUserLinksBatchDeleteCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	c.googleanalyticsadminv1alphabatchdeleteuserlinksrequest = googleanalyticsadminv1alphabatchdeleteuserlinksrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *AccountsUserLinksBatchDeleteCall) Fields(s ...googleapi.Field) *AccountsUserLinksBatchDeleteCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *AccountsUserLinksBatchDeleteCall) Context(ctx context.Context) *AccountsUserLinksBatchDeleteCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *AccountsUserLinksBatchDeleteCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *AccountsUserLinksBatchDeleteCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.googleanalyticsadminv1alphabatchdeleteuserlinksrequest)
	if err != nil {
		return nil, err
	}
	reqHeaders.Set("Content-Type", "application/json")
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1alpha/{+parent}/userLinks:batchDelete")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "analyticsadmin.accounts.userLinks.batchDelete" call.
// Exactly one of *GoogleProtobufEmpty or error will be non-nil. Any
// non-2xx status code is an error. Response headers are in either
// *GoogleProtobufEmpty.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was
// because http.StatusNotModified was returned.
func (c *AccountsUserLinksBatchDeleteCall) Do(opts ...googleapi.CallOption) (*GoogleProtobufEmpty, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleProtobufEmpty{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Deletes information about multiple users' links to an account or property.",
	//   "flatPath": "v1alpha/accounts/{accountsId}/userLinks:batchDelete",
	//   "httpMethod": "POST",
	//   "id": "analyticsadmin.accounts.userLinks.batchDelete",
	//   "parameterOrder": [
	//     "parent"
	//   ],
	//   "parameters": {
	//     "parent": {
	//       "description": "Required. The account or property that all user links in the request are for. The parent of all values for user link names to delete must match this field. Example format: accounts/1234",
	//       "location": "path",
	//       "pattern": "^accounts/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1alpha/{+parent}/userLinks:batchDelete",
	//   "request": {
	//     "$ref": "GoogleAnalyticsAdminV1alphaBatchDeleteUserLinksRequest"
	//   },
	//   "response": {
	//     "$ref": "GoogleProtobufEmpty"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/analytics.manage.users"
	//   ]
	// }

}

// method id "analyticsadmin.accounts.userLinks.batchGet":

type AccountsUserLinksBatchGetCall struct {
	s            *Service
	parent       string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// BatchGet: Gets information about multiple users' links to an account
// or property.
//
//   - parent: The account or property that all user links in the request
//     are for. The parent of all provided values for the 'names' field
//     must match this field. Example format: accounts/1234.
func (r *AccountsUserLinksService) BatchGet(parent string) *AccountsUserLinksBatchGetCall {
	c := &AccountsUserLinksBatchGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	return c
}

// Names sets the optional parameter "names": Required. The names of the
// user links to retrieve. A maximum of 1000 user links can be retrieved
// in a batch. Format: accounts/{accountId}/userLinks/{userLinkId}
func (c *AccountsUserLinksBatchGetCall) Names(names ...string) *AccountsUserLinksBatchGetCall {
	c.urlParams_.SetMulti("names", append([]string{}, names...))
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *AccountsUserLinksBatchGetCall) Fields(s ...googleapi.Field) *AccountsUserLinksBatchGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets the optional parameter which makes the operation
// fail if the object's ETag matches the given value. This is useful for
// getting updates only after the object has changed since the last
// request. Use googleapi.IsNotModified to check whether the response
// error from Do is the result of In-None-Match.
func (c *AccountsUserLinksBatchGetCall) IfNoneMatch(entityTag string) *AccountsUserLinksBatchGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *AccountsUserLinksBatchGetCall) Context(ctx context.Context) *AccountsUserLinksBatchGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *AccountsUserLinksBatchGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *AccountsUserLinksBatchGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1alpha/{+parent}/userLinks:batchGet")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "analyticsadmin.accounts.userLinks.batchGet" call.
// Exactly one of *GoogleAnalyticsAdminV1alphaBatchGetUserLinksResponse
// or error will be non-nil. Any non-2xx status code is an error.
// Response headers are in either
// *GoogleAnalyticsAdminV1alphaBatchGetUserLinksResponse.ServerResponse.H
// eader or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was
// returned.
func (c *AccountsUserLinksBatchGetCall) Do(opts ...googleapi.CallOption) (*GoogleAnalyticsAdminV1alphaBatchGetUserLinksResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleAnalyticsAdminV1alphaBatchGetUserLinksResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Gets information about multiple users' links to an account or property.",
	//   "flatPath": "v1alpha/accounts/{accountsId}/userLinks:batchGet",
	//   "httpMethod": "GET",
	//   "id": "analyticsadmin.accounts.userLinks.batchGet",
	//   "parameterOrder": [
	//     "parent"
	//   ],
	//   "parameters": {
	//     "names": {
	//       "description": "Required. The names of the user links to retrieve. A maximum of 1000 user links can be retrieved in a batch. Format: accounts/{accountId}/userLinks/{userLinkId}",
	//       "location": "query",
	//       "repeated": true,
	//       "type": "string"
	//     },
	//     "parent": {
	//       "description": "Required. The account or property that all user links in the request are for. The parent of all provided values for the 'names' field must match this field. Example format: accounts/1234",
	//       "location": "path",
	//       "pattern": "^accounts/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1alpha/{+parent}/userLinks:batchGet",
	//   "response": {
	//     "$ref": "GoogleAnalyticsAdminV1alphaBatchGetUserLinksResponse"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/analytics.manage.users",
	//     "https://www.googleapis.com/auth/analytics.manage.users.readonly"
	//   ]
	// }

}

// method id "analyticsadmin.accounts.userLinks.batchUpdate":

type AccountsUserLinksBatchUpdateCall struct {
	s                                                      *Service
	parent                                                 string
	googleanalyticsadminv1alphabatchupdateuserlinksrequest *GoogleAnalyticsAdminV1alphaBatchUpdateUserLinksRequest
	urlParams_                                             gensupport.URLParams
	ctx_                                                   context.Context
	header_                                                http.Header
}

// BatchUpdate: Updates information about multiple users' links to an
// account or property.
//
//   - parent: The account or property that all user links in the request
//     are for. The parent field in the UpdateUserLinkRequest messages
//     must either be empty or match this field. Example format:
//     accounts/1234.
func (r *AccountsUserLinksService) BatchUpdate(parent string, googleanalyticsadminv1alphabatchupdateuserlinksrequest *GoogleAnalyticsAdminV1alphaBatchUpdateUserLinksRequest) *AccountsUserLinksBatchUpdateCall {
	c := &AccountsUserLinksBatchUpdateCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	c.googleanalyticsadminv1alphabatchupdateuserlinksrequest = googleanalyticsadminv1alphabatchupdateuserlinksrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *AccountsUserLinksBatchUpdateCall) Fields(s ...googleapi.Field) *AccountsUserLinksBatchUpdateCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *AccountsUserLinksBatchUpdateCall) Context(ctx context.Context) *AccountsUserLinksBatchUpdateCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *AccountsUserLinksBatchUpdateCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *AccountsUserLinksBatchUpdateCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.googleanalyticsadminv1alphabatchupdateuserlinksrequest)
	if err != nil {
		return nil, err
	}
	reqHeaders.Set("Content-Type", "application/json")
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1alpha/{+parent}/userLinks:batchUpdate")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "analyticsadmin.accounts.userLinks.batchUpdate" call.
// Exactly one of
// *GoogleAnalyticsAdminV1alphaBatchUpdateUserLinksResponse or error
// will be non-nil. Any non-2xx status code is an error. Response
// headers are in either
// *GoogleAnalyticsAdminV1alphaBatchUpdateUserLinksResponse.ServerRespons
// e.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was
// returned.
func (c *AccountsUserLinksBatchUpdateCall) Do(opts ...googleapi.CallOption) (*GoogleAnalyticsAdminV1alphaBatchUpdateUserLinksResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleAnalyticsAdminV1alphaBatchUpdateUserLinksResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Updates information about multiple users' links to an account or property.",
	//   "flatPath": "v1alpha/accounts/{accountsId}/userLinks:batchUpdate",
	//   "httpMethod": "POST",
	//   "id": "analyticsadmin.accounts.userLinks.batchUpdate",
	//   "parameterOrder": [
	//     "parent"
	//   ],
	//   "parameters": {
	//     "parent": {
	//       "description": "Required. The account or property that all user links in the request are for. The parent field in the UpdateUserLinkRequest messages must either be empty or match this field. Example format: accounts/1234",
	//       "location": "path",
	//       "pattern": "^accounts/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1alpha/{+parent}/userLinks:batchUpdate",
	//   "request": {
	//     "$ref": "GoogleAnalyticsAdminV1alphaBatchUpdateUserLinksRequest"
	//   },
	//   "response": {
	//     "$ref": "GoogleAnalyticsAdminV1alphaBatchUpdateUserLinksResponse"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/analytics.manage.users"
	//   ]
	// }

}

// method id "analyticsadmin.accounts.userLinks.create":

type AccountsUserLinksCreateCall struct {
	s                                   *Service
	parent                              string
	googleanalyticsadminv1alphauserlink *GoogleAnalyticsAdminV1alphaUserLink
	urlParams_                          gensupport.URLParams
	ctx_                                context.Context
	header_                             http.Header
}

// Create: Creates a user link on an account or property. If the user
// with the specified email already has permissions on the account or
// property, then the user's existing permissions will be unioned with
// the permissions specified in the new UserLink.
//
// - parent: Example format: accounts/1234.
func (r *AccountsUserLinksService) Create(parent string, googleanalyticsadminv1alphauserlink *GoogleAnalyticsAdminV1alphaUserLink) *AccountsUserLinksCreateCall {
	c := &AccountsUserLinksCreateCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	c.googleanalyticsadminv1alphauserlink = googleanalyticsadminv1alphauserlink
	return c
}

// NotifyNewUser sets the optional parameter "notifyNewUser": If set,
// then email the new user notifying them that they've been granted
// permissions to the resource.
func (c *AccountsUserLinksCreateCall) NotifyNewUser(notifyNewUser bool) *AccountsUserLinksCreateCall {
	c.urlParams_.Set("notifyNewUser", fmt.Sprint(notifyNewUser))
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *AccountsUserLinksCreateCall) Fields(s ...googleapi.Field) *AccountsUserLinksCreateCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *AccountsUserLinksCreateCall) Context(ctx context.Context) *AccountsUserLinksCreateCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *AccountsUserLinksCreateCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *AccountsUserLinksCreateCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.googleanalyticsadminv1alphauserlink)
	if err != nil {
		return nil, err
	}
	reqHeaders.Set("Content-Type", "application/json")
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1alpha/{+parent}/userLinks")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "analyticsadmin.accounts.userLinks.create" call.
// Exactly one of *GoogleAnalyticsAdminV1alphaUserLink or error will be
// non-nil. Any non-2xx status code is an error. Response headers are in
// either *GoogleAnalyticsAdminV1alphaUserLink.ServerResponse.Header or
// (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was
// returned.
func (c *AccountsUserLinksCreateCall) Do(opts ...googleapi.CallOption) (*GoogleAnalyticsAdminV1alphaUserLink, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleAnalyticsAdminV1alphaUserLink{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Creates a user link on an account or property. If the user with the specified email already has permissions on the account or property, then the user's existing permissions will be unioned with the permissions specified in the new UserLink.",
	//   "flatPath": "v1alpha/accounts/{accountsId}/userLinks",
	//   "httpMethod": "POST",
	//   "id": "analyticsadmin.accounts.userLinks.create",
	//   "parameterOrder": [
	//     "parent"
	//   ],
	//   "parameters": {
	//     "notifyNewUser": {
	//       "description": "Optional. If set, then email the new user notifying them that they've been granted permissions to the resource.",
	//       "location": "query",
	//       "type": "boolean"
	//     },
	//     "parent": {
	//       "description": "Required. Example format: accounts/1234",
	//       "location": "path",
	//       "pattern": "^accounts/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1alpha/{+parent}/userLinks",
	//   "request": {
	//     "$ref": "GoogleAnalyticsAdminV1alphaUserLink"
	//   },
	//   "response": {
	//     "$ref": "GoogleAnalyticsAdminV1alphaUserLink"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/analytics.manage.users"
	//   ]
	// }

}

// method id "analyticsadmin.accounts.userLinks.delete":

type AccountsUserLinksDeleteCall struct {
	s          *Service
	name       string
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Delete: Deletes a user link on an account or property.
//
// - name: Example format: accounts/1234/userLinks/5678.
func (r *AccountsUserLinksService) Delete(name string) *AccountsUserLinksDeleteCall {
	c := &AccountsUserLinksDeleteCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *AccountsUserLinksDeleteCall) Fields(s ...googleapi.Field) *AccountsUserLinksDeleteCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *AccountsUserLinksDeleteCall) Context(ctx context.Context) *AccountsUserLinksDeleteCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *AccountsUserLinksDeleteCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *AccountsUserLinksDeleteCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1alpha/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("DELETE", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "analyticsadmin.accounts.userLinks.delete" call.
// Exactly one of *GoogleProtobufEmpty or error will be non-nil. Any
// non-2xx status code is an error. Response headers are in either
// *GoogleProtobufEmpty.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was
// because http.StatusNotModified was returned.
func (c *AccountsUserLinksDeleteCall) Do(opts ...googleapi.CallOption) (*GoogleProtobufEmpty, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleProtobufEmpty{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Deletes a user link on an account or property.",
	//   "flatPath": "v1alpha/accounts/{accountsId}/userLinks/{userLinksId}",
	//   "httpMethod": "DELETE",
	//   "id": "analyticsadmin.accounts.userLinks.delete",
	//   "parameterOrder": [
	//     "name"
	//   ],
	//   "parameters": {
	//     "name": {
	//       "description": "Required. Example format: accounts/1234/userLinks/5678",
	//       "location": "path",
	//       "pattern": "^accounts/[^/]+/userLinks/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1alpha/{+name}",
	//   "response": {
	//     "$ref": "GoogleProtobufEmpty"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/analytics.manage.users"
	//   ]
	// }

}

// method id "analyticsadmin.accounts.userLinks.get":

type AccountsUserLinksGetCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Gets information about a user's link to an account or property.
//
// - name: Example format: accounts/1234/userLinks/5678.
func (r *AccountsUserLinksService) Get(name string) *AccountsUserLinksGetCall {
	c := &AccountsUserLinksGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *AccountsUserLinksGetCall) Fields(s ...googleapi.Field) *AccountsUserLinksGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets the optional parameter which makes the operation
// fail if the object's ETag matches the given value. This is useful for
// getting updates only after the object has changed since the last
// request. Use googleapi.IsNotModified to check whether the response
// error from Do is the result of In-None-Match.
func (c *AccountsUserLinksGetCall) IfNoneMatch(entityTag string) *AccountsUserLinksGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *AccountsUserLinksGetCall) Context(ctx context.Context) *AccountsUserLinksGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *AccountsUserLinksGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *AccountsUserLinksGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1alpha/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "analyticsadmin.accounts.userLinks.get" call.
// Exactly one of *GoogleAnalyticsAdminV1alphaUserLink or error will be
// non-nil. Any non-2xx status code is an error. Response headers are in
// either *GoogleAnalyticsAdminV1alphaUserLink.ServerResponse.Header or
// (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was
// returned.
func (c *AccountsUserLinksGetCall) Do(opts ...googleapi.CallOption) (*GoogleAnalyticsAdminV1alphaUserLink, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleAnalyticsAdminV1alphaUserLink{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Gets information about a user's link to an account or property.",
	//   "flatPath": "v1alpha/accounts/{accountsId}/userLinks/{userLinksId}",
	//   "httpMethod": "GET",
	//   "id": "analyticsadmin.accounts.userLinks.get",
	//   "parameterOrder": [
	//     "name"
	//   ],
	//   "parameters": {
	//     "name": {
	//       "description": "Required. Example format: accounts/1234/userLinks/5678",
	//       "location": "path",
	//       "pattern": "^accounts/[^/]+/userLinks/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1alpha/{+name}",
	//   "response": {
	//     "$ref": "GoogleAnalyticsAdminV1alphaUserLink"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/analytics.manage.users",
	//     "https://www.googleapis.com/auth/analytics.manage.users.readonly"
	//   ]
	// }

}

// method id "analyticsadmin.accounts.userLinks.list":

type AccountsUserLinksListCall struct {
	s            *Service
	parent       string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Lists all user links on an account or property.
//
// - parent: Example format: accounts/1234.
func (r *AccountsUserLinksService) List(parent string) *AccountsUserLinksListCall {
	c := &AccountsUserLinksListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	return c
}

// PageSize sets the optional parameter "pageSize": The maximum number
// of user links to return. The service may return fewer than this
// value. If unspecified, at most 200 user links will be returned. The
// maximum value is 500; values above 500 will be coerced to 500.
func (c *AccountsUserLinksListCall) PageSize(pageSize int64) *AccountsUserLinksListCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": A page token,
// received from a previous `ListUserLinks` call. Provide this to
// retrieve the subsequent page. When paginating, all other parameters
// provided to `ListUserLinks` must match the call that provided the
// page token.
func (c *AccountsUserLinksListCall) PageToken(pageToken string) *AccountsUserLinksListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *AccountsUserLinksListCall) Fields(s ...googleapi.Field) *AccountsUserLinksListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets the optional parameter which makes the operation
// fail if the object's ETag matches the given value. This is useful for
// getting updates only after the object has changed since the last
// request. Use googleapi.IsNotModified to check whether the response
// error from Do is the result of In-None-Match.
func (c *AccountsUserLinksListCall) IfNoneMatch(entityTag string) *AccountsUserLinksListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *AccountsUserLinksListCall) Context(ctx context.Context) *AccountsUserLinksListCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *AccountsUserLinksListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *AccountsUserLinksListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1alpha/{+parent}/userLinks")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "analyticsadmin.accounts.userLinks.list" call.
// Exactly one of *GoogleAnalyticsAdminV1alphaListUserLinksResponse or
// error will be non-nil. Any non-2xx status code is an error. Response
// headers are in either
// *GoogleAnalyticsAdminV1alphaListUserLinksResponse.ServerResponse.Heade
// r or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was
// returned.
func (c *AccountsUserLinksListCall) Do(opts ...googleapi.CallOption) (*GoogleAnalyticsAdminV1alphaListUserLinksResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleAnalyticsAdminV1alphaListUserLinksResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Lists all user links on an account or property.",
	//   "flatPath": "v1alpha/accounts/{accountsId}/userLinks",
	//   "httpMethod": "GET",
	//   "id": "analyticsadmin.accounts.userLinks.list",
	//   "parameterOrder": [
	//     "parent"
	//   ],
	//   "parameters": {
	//     "pageSize": {
	//       "description": "The maximum number of user links to return. The service may return fewer than this value. If unspecified, at most 200 user links will be returned. The maximum value is 500; values above 500 will be coerced to 500.",
	//       "format": "int32",
	//       "location": "query",
	//       "type": "integer"
	//     },
	//     "pageToken": {
	//       "description": "A page token, received from a previous `ListUserLinks` call. Provide this to retrieve the subsequent page. When paginating, all other parameters provided to `ListUserLinks` must match the call that provided the page token.",
	//       "location": "query",
	//       "type": "string"
	//     },
	//     "parent": {
	//       "description": "Required. Example format: accounts/1234",
	//       "location": "path",
	//       "pattern": "^accounts/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1alpha/{+parent}/userLinks",
	//   "response": {
	//     "$ref": "GoogleAnalyticsAdminV1alphaListUserLinksResponse"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/analytics.manage.users",
	//     "https://www.googleapis.com/auth/analytics.manage.users.readonly"
	//   ]
	// }

}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *AccountsUserLinksListCall) Pages(ctx context.Context, f func(*GoogleAnalyticsAdminV1alphaListUserLinksResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken")) // reset paging to original point
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

// method id "analyticsadmin.accounts.userLinks.patch":

type AccountsUserLinksPatchCall struct {
	s                                   *Service
	name                                string
	googleanalyticsadminv1alphauserlink *GoogleAnalyticsAdminV1alphaUserLink
	urlParams_                          gensupport.URLParams
	ctx_                                context.Context
	header_                             http.Header
}

// Patch: Updates a user link on an account or property.
//
// - name: Output only. Example format: properties/1234/userLinks/5678.
func (r *AccountsUserLinksService) Patch(name string, googleanalyticsadminv1alphauserlink *GoogleAnalyticsAdminV1alphaUserLink) *AccountsUserLinksPatchCall {
	c := &AccountsUserLinksPatchCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	c.googleanalyticsadminv1alphauserlink = googleanalyticsadminv1alphauserlink
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *AccountsUserLinksPatchCall) Fields(s ...googleapi.Field) *AccountsUserLinksPatchCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *AccountsUserLinksPatchCall) Context(ctx context.Context) *AccountsUserLinksPatchCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *AccountsUserLinksPatchCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *AccountsUserLinksPatchCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.googleanalyticsadminv1alphauserlink)
	if err != nil {
		return nil, err
	}
	reqHeaders.Set("Content-Type", "application/json")
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1alpha/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("PATCH", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "analyticsadmin.accounts.userLinks.patch" call.
// Exactly one of *GoogleAnalyticsAdminV1alphaUserLink or error will be
// non-nil. Any non-2xx status code is an error. Response headers are in
// either *GoogleAnalyticsAdminV1alphaUserLink.ServerResponse.Header or
// (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was
// returned.
func (c *AccountsUserLinksPatchCall) Do(opts ...googleapi.CallOption) (*GoogleAnalyticsAdminV1alphaUserLink, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleAnalyticsAdminV1alphaUserLink{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Updates a user link on an account or property.",
	//   "flatPath": "v1alpha/accounts/{accountsId}/userLinks/{userLinksId}",
	//   "httpMethod": "PATCH",
	//   "id": "analyticsadmin.accounts.userLinks.patch",
	//   "parameterOrder": [
	//     "name"
	//   ],
	//   "parameters": {
	//     "name": {
	//       "description": "Output only. Example format: properties/1234/userLinks/5678",
	//       "location": "path",
	//       "pattern": "^accounts/[^/]+/userLinks/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1alpha/{+name}",
	//   "request": {
	//     "$ref": "GoogleAnalyticsAdminV1alphaUserLink"
	//   },
	//   "response": {
	//     "$ref": "GoogleAnalyticsAdminV1alphaUserLink"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/analytics.manage.users"
	//   ]
	// }

}

// method id "analyticsadmin.properties.acknowledgeUserDataCollection":

type PropertiesAcknowledgeUserDataCollectionCall struct {
	s                                                               *Service
	property                                                        string
	googleanalyticsadminv1alphaacknowledgeuserdatacollectionrequest *GoogleAnalyticsAdminV1alphaAcknowledgeUserDataCollectionRequest
	urlParams_                                                      gensupport.URLParams
	ctx_                                                            context.Context
	header_                                                         http.Header
}

// AcknowledgeUserDataCollection: Acknowledges the terms of user data
// collection for the specified property. This acknowledgement must be
// completed (either in the Google Analytics UI or through this API)
// before MeasurementProtocolSecret resources may be created.
//
//   - property: The property for which to acknowledge user data
//     collection.
func (r *PropertiesService) AcknowledgeUserDataCollection(property string, googleanalyticsadminv1alphaacknowledgeuserdatacollectionrequest *GoogleAnalyticsAdminV1alphaAcknowledgeUserDataCollectionRequest) *PropertiesAcknowledgeUserDataCollectionCall {
	c := &PropertiesAcknowledgeUserDataCollectionCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.property = property
	c.googleanalyticsadminv1alphaacknowledgeuserdatacollectionrequest = googleanalyticsadminv1alphaacknowledgeuserdatacollectionrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *PropertiesAcknowledgeUserDataCollectionCall) Fields(s ...googleapi.Field) *PropertiesAcknowledgeUserDataCollectionCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *PropertiesAcknowledgeUserDataCollectionCall) Context(ctx context.Context) *PropertiesAcknowledgeUserDataCollectionCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *PropertiesAcknowledgeUserDataCollectionCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *PropertiesAcknowledgeUserDataCollectionCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.googleanalyticsadminv1alphaacknowledgeuserdatacollectionrequest)
	if err != nil {
		return nil, err
	}
	reqHeaders.Set("Content-Type", "application/json")
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1alpha/{+property}:acknowledgeUserDataCollection")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"property": c.property,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "analyticsadmin.properties.acknowledgeUserDataCollection" call.
// Exactly one of
// *GoogleAnalyticsAdminV1alphaAcknowledgeUserDataCollectionResponse or
// error will be non-nil. Any non-2xx status code is an error. Response
// headers are in either
// *GoogleAnalyticsAdminV1alphaAcknowledgeUserDataCollectionResponse.Serv
// erResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was
// returned.
func (c *PropertiesAcknowledgeUserDataCollectionCall) Do(opts ...googleapi.CallOption) (*GoogleAnalyticsAdminV1alphaAcknowledgeUserDataCollectionResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleAnalyticsAdminV1alphaAcknowledgeUserDataCollectionResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Acknowledges the terms of user data collection for the specified property. This acknowledgement must be completed (either in the Google Analytics UI or through this API) before MeasurementProtocolSecret resources may be created.",
	//   "flatPath": "v1alpha/properties/{propertiesId}:acknowledgeUserDataCollection",
	//   "httpMethod": "POST",
	//   "id": "analyticsadmin.properties.acknowledgeUserDataCollection",
	//   "parameterOrder": [
	//     "property"
	//   ],
	//   "parameters": {
	//     "property": {
	//       "description": "Required. The property for which to acknowledge user data collection.",
	//       "location": "path",
	//       "pattern": "^properties/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1alpha/{+property}:acknowledgeUserDataCollection",
	//   "request": {
	//     "$ref": "GoogleAnalyticsAdminV1alphaAcknowledgeUserDataCollectionRequest"
	//   },
	//   "response": {
	//     "$ref": "GoogleAnalyticsAdminV1alphaAcknowledgeUserDataCollectionResponse"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/analytics.edit"
	//   ]
	// }

}

// method id "analyticsadmin.properties.create":

type PropertiesCreateCall struct {
	s                                   *Service
	googleanalyticsadminv1alphaproperty *GoogleAnalyticsAdminV1alphaProperty
	urlParams_                          gensupport.URLParams
	ctx_                                context.Context
	header_                             http.Header
}

// Create: Creates an "GA4" property with the specified location and
// attributes.
func (r *PropertiesService) Create(googleanalyticsadminv1alphaproperty *GoogleAnalyticsAdminV1alphaProperty) *PropertiesCreateCall {
	c := &PropertiesCreateCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.googleanalyticsadminv1alphaproperty = googleanalyticsadminv1alphaproperty
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *PropertiesCreateCall) Fields(s ...googleapi.Field) *PropertiesCreateCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *PropertiesCreateCall) Context(ctx context.Context) *PropertiesCreateCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *PropertiesCreateCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *PropertiesCreateCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.googleanalyticsadminv1alphaproperty)
	if err != nil {
		return nil, err
	}
	reqHeaders.Set("Content-Type", "application/json")
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1alpha/properties")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "analyticsadmin.properties.create" call.
// Exactly one of *GoogleAnalyticsAdminV1alphaProperty or error will be
// non-nil. Any non-2xx status code is an error. Response headers are in
// either *GoogleAnalyticsAdminV1alphaProperty.ServerResponse.Header or
// (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was
// returned.
func (c *PropertiesCreateCall) Do(opts ...googleapi.CallOption) (*GoogleAnalyticsAdminV1alphaProperty, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleAnalyticsAdminV1alphaProperty{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Creates an \"GA4\" property with the specified location and attributes.",
	//   "flatPath": "v1alpha/properties",
	//   "httpMethod": "POST",
	//   "id": "analyticsadmin.properties.create",
	//   "parameterOrder": [],
	//   "parameters": {},
	//   "path": "v1alpha/properties",
	//   "request": {
	//     "$ref": "GoogleAnalyticsAdminV1alphaProperty"
	//   },
	//   "response": {
	//     "$ref": "GoogleAnalyticsAdminV1alphaProperty"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/analytics.edit"
	//   ]
	// }

}

// method id "analyticsadmin.properties.createConnectedSiteTag":

type PropertiesCreateConnectedSiteTagCall struct {
	s                                                        *Service
	googleanalyticsadminv1alphacreateconnectedsitetagrequest *GoogleAnalyticsAdminV1alphaCreateConnectedSiteTagRequest
	urlParams_                                               gensupport.URLParams
	ctx_                                                     context.Context
	header_                                                  http.Header
}

// CreateConnectedSiteTag: Creates a connected site tag for a Universal
// Analytics property. You can create a maximum of 20 connected site
// tags per property. Note: This API cannot be used on GA4 properties.
func (r *PropertiesService) CreateConnectedSiteTag(googleanalyticsadminv1alphacreateconnectedsitetagrequest *GoogleAnalyticsAdminV1alphaCreateConnectedSiteTagRequest) *PropertiesCreateConnectedSiteTagCall {
	c := &PropertiesCreateConnectedSiteTagCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.googleanalyticsadminv1alphacreateconnectedsitetagrequest = googleanalyticsadminv1alphacreateconnectedsitetagrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *PropertiesCreateConnectedSiteTagCall) Fields(s ...googleapi.Field) *PropertiesCreateConnectedSiteTagCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *PropertiesCreateConnectedSiteTagCall) Context(ctx context.Context) *PropertiesCreateConnectedSiteTagCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *PropertiesCreateConnectedSiteTagCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *PropertiesCreateConnectedSiteTagCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.googleanalyticsadminv1alphacreateconnectedsitetagrequest)
	if err != nil {
		return nil, err
	}
	reqHeaders.Set("Content-Type", "application/json")
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1alpha/properties:createConnectedSiteTag")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "analyticsadmin.properties.createConnectedSiteTag" call.
// Exactly one of
// *GoogleAnalyticsAdminV1alphaCreateConnectedSiteTagResponse or error
// will be non-nil. Any non-2xx status code is an error. Response
// headers are in either
// *GoogleAnalyticsAdminV1alphaCreateConnectedSiteTagResponse.ServerRespo
// nse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was
// returned.
func (c *PropertiesCreateConnectedSiteTagCall) Do(opts ...googleapi.CallOption) (*GoogleAnalyticsAdminV1alphaCreateConnectedSiteTagResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleAnalyticsAdminV1alphaCreateConnectedSiteTagResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Creates a connected site tag for a Universal Analytics property. You can create a maximum of 20 connected site tags per property. Note: This API cannot be used on GA4 properties.",
	//   "flatPath": "v1alpha/properties:createConnectedSiteTag",
	//   "httpMethod": "POST",
	//   "id": "analyticsadmin.properties.createConnectedSiteTag",
	//   "parameterOrder": [],
	//   "parameters": {},
	//   "path": "v1alpha/properties:createConnectedSiteTag",
	//   "request": {
	//     "$ref": "GoogleAnalyticsAdminV1alphaCreateConnectedSiteTagRequest"
	//   },
	//   "response": {
	//     "$ref": "GoogleAnalyticsAdminV1alphaCreateConnectedSiteTagResponse"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/analytics.edit"
	//   ]
	// }

}

// method id "analyticsadmin.properties.delete":

type PropertiesDeleteCall struct {
	s          *Service
	name       string
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Delete: Marks target Property as soft-deleted (ie: "trashed") and
// returns it. This API does not have a method to restore soft-deleted
// properties. However, they can be restored using the Trash Can UI. If
// the properties are not restored before the expiration time, the
// Property and all child resources (eg: GoogleAdsLinks, Streams,
// UserLinks) will be permanently purged.
// https://support.google.com/analytics/answer/6154772 Returns an error
// if the target is not found, or is not a GA4 Property.
//
//   - name: The name of the Property to soft-delete. Format:
//     properties/{property_id} Example: "properties/1000".
func (r *PropertiesService) Delete(name string) *PropertiesDeleteCall {
	c := &PropertiesDeleteCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *PropertiesDeleteCall) Fields(s ...googleapi.Field) *PropertiesDeleteCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *PropertiesDeleteCall) Context(ctx context.Context) *PropertiesDeleteCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *PropertiesDeleteCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *PropertiesDeleteCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1alpha/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("DELETE", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "analyticsadmin.properties.delete" call.
// Exactly one of *GoogleAnalyticsAdminV1alphaProperty or error will be
// non-nil. Any non-2xx status code is an error. Response headers are in
// either *GoogleAnalyticsAdminV1alphaProperty.ServerResponse.Header or
// (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was
// returned.
func (c *PropertiesDeleteCall) Do(opts ...googleapi.CallOption) (*GoogleAnalyticsAdminV1alphaProperty, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleAnalyticsAdminV1alphaProperty{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Marks target Property as soft-deleted (ie: \"trashed\") and returns it. This API does not have a method to restore soft-deleted properties. However, they can be restored using the Trash Can UI. If the properties are not restored before the expiration time, the Property and all child resources (eg: GoogleAdsLinks, Streams, UserLinks) will be permanently purged. https://support.google.com/analytics/answer/6154772 Returns an error if the target is not found, or is not a GA4 Property.",
	//   "flatPath": "v1alpha/properties/{propertiesId}",
	//   "httpMethod": "DELETE",
	//   "id": "analyticsadmin.properties.delete",
	//   "parameterOrder": [
	//     "name"
	//   ],
	//   "parameters": {
	//     "name": {
	//       "description": "Required. The name of the Property to soft-delete. Format: properties/{property_id} Example: \"properties/1000\"",
	//       "location": "path",
	//       "pattern": "^properties/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1alpha/{+name}",
	//   "response": {
	//     "$ref": "GoogleAnalyticsAdminV1alphaProperty"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/analytics.edit"
	//   ]
	// }

}

// method id "analyticsadmin.properties.deleteConnectedSiteTag":

type PropertiesDeleteConnectedSiteTagCall struct {
	s                                                        *Service
	googleanalyticsadminv1alphadeleteconnectedsitetagrequest *GoogleAnalyticsAdminV1alphaDeleteConnectedSiteTagRequest
	urlParams_                                               gensupport.URLParams
	ctx_                                                     context.Context
	header_                                                  http.Header
}

// DeleteConnectedSiteTag: Deletes a connected site tag for a Universal
// Analytics property. Note: this has no effect on GA4 properties.
func (r *PropertiesService) DeleteConnectedSiteTag(googleanalyticsadminv1alphadeleteconnectedsitetagrequest *GoogleAnalyticsAdminV1alphaDeleteConnectedSiteTagRequest) *PropertiesDeleteConnectedSiteTagCall {
	c := &PropertiesDeleteConnectedSiteTagCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.googleanalyticsadminv1alphadeleteconnectedsitetagrequest = googleanalyticsadminv1alphadeleteconnectedsitetagrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *PropertiesDeleteConnectedSiteTagCall) Fields(s ...googleapi.Field) *PropertiesDeleteConnectedSiteTagCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *PropertiesDeleteConnectedSiteTagCall) Context(ctx context.Context) *PropertiesDeleteConnectedSiteTagCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *PropertiesDeleteConnectedSiteTagCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *PropertiesDeleteConnectedSiteTagCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.googleanalyticsadminv1alphadeleteconnectedsitetagrequest)
	if err != nil {
		return nil, err
	}
	reqHeaders.Set("Content-Type", "application/json")
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1alpha/properties:deleteConnectedSiteTag")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "analyticsadmin.properties.deleteConnectedSiteTag" call.
// Exactly one of *GoogleProtobufEmpty or error will be non-nil. Any
// non-2xx status code is an error. Response headers are in either
// *GoogleProtobufEmpty.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was
// because http.StatusNotModified was returned.
func (c *PropertiesDeleteConnectedSiteTagCall) Do(opts ...googleapi.CallOption) (*GoogleProtobufEmpty, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleProtobufEmpty{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Deletes a connected site tag for a Universal Analytics property. Note: this has no effect on GA4 properties.",
	//   "flatPath": "v1alpha/properties:deleteConnectedSiteTag",
	//   "httpMethod": "POST",
	//   "id": "analyticsadmin.properties.deleteConnectedSiteTag",
	//   "parameterOrder": [],
	//   "parameters": {},
	//   "path": "v1alpha/properties:deleteConnectedSiteTag",
	//   "request": {
	//     "$ref": "GoogleAnalyticsAdminV1alphaDeleteConnectedSiteTagRequest"
	//   },
	//   "response": {
	//     "$ref": "GoogleProtobufEmpty"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/analytics.edit"
	//   ]
	// }

}

// method id "analyticsadmin.properties.fetchAutomatedGa4ConfigurationOptOut":

type PropertiesFetchAutomatedGa4ConfigurationOptOutCall struct {
	s                                                                      *Service
	googleanalyticsadminv1alphafetchautomatedga4configurationoptoutrequest *GoogleAnalyticsAdminV1alphaFetchAutomatedGa4ConfigurationOptOutRequest
	urlParams_                                                             gensupport.URLParams
	ctx_                                                                   context.Context
	header_                                                                http.Header
}

// FetchAutomatedGa4ConfigurationOptOut: Fetches the opt out status for
// the automated GA4 setup process for a UA property. Note: this has no
// effect on GA4 property.
func (r *PropertiesService) FetchAutomatedGa4ConfigurationOptOut(googleanalyticsadminv1alphafetchautomatedga4configurationoptoutrequest *GoogleAnalyticsAdminV1alphaFetchAutomatedGa4ConfigurationOptOutRequest) *PropertiesFetchAutomatedGa4ConfigurationOptOutCall {
	c := &PropertiesFetchAutomatedGa4ConfigurationOptOutCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.googleanalyticsadminv1alphafetchautomatedga4configurationoptoutrequest = googleanalyticsadminv1alphafetchautomatedga4configurationoptoutrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *PropertiesFetchAutomatedGa4ConfigurationOptOutCall) Fields(s ...googleapi.Field) *PropertiesFetchAutomatedGa4ConfigurationOptOutCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *PropertiesFetchAutomatedGa4ConfigurationOptOutCall) Context(ctx context.Context) *PropertiesFetchAutomatedGa4ConfigurationOptOutCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *PropertiesFetchAutomatedGa4ConfigurationOptOutCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *PropertiesFetchAutomatedGa4ConfigurationOptOutCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.googleanalyticsadminv1alphafetchautomatedga4configurationoptoutrequest)
	if err != nil {
		return nil, err
	}
	reqHeaders.Set("Content-Type", "application/json")
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1alpha/properties:fetchAutomatedGa4ConfigurationOptOut")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "analyticsadmin.properties.fetchAutomatedGa4ConfigurationOptOut" call.
// Exactly one of
// *GoogleAnalyticsAdminV1alphaFetchAutomatedGa4ConfigurationOptOutRespon
// se or error will be non-nil. Any non-2xx status code is an error.
// Response headers are in either
// *GoogleAnalyticsAdminV1alphaFetchAutomatedGa4ConfigurationOptOutRespon
// se.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was
// returned.
func (c *PropertiesFetchAutomatedGa4ConfigurationOptOutCall) Do(opts ...googleapi.CallOption) (*GoogleAnalyticsAdminV1alphaFetchAutomatedGa4ConfigurationOptOutResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleAnalyticsAdminV1alphaFetchAutomatedGa4ConfigurationOptOutResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Fetches the opt out status for the automated GA4 setup process for a UA property. Note: this has no effect on GA4 property.",
	//   "flatPath": "v1alpha/properties:fetchAutomatedGa4ConfigurationOptOut",
	//   "httpMethod": "POST",
	//   "id": "analyticsadmin.properties.fetchAutomatedGa4ConfigurationOptOut",
	//   "parameterOrder": [],
	//   "parameters": {},
	//   "path": "v1alpha/properties:fetchAutomatedGa4ConfigurationOptOut",
	//   "request": {
	//     "$ref": "GoogleAnalyticsAdminV1alphaFetchAutomatedGa4ConfigurationOptOutRequest"
	//   },
	//   "response": {
	//     "$ref": "GoogleAnalyticsAdminV1alphaFetchAutomatedGa4ConfigurationOptOutResponse"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/analytics.edit",
	//     "https://www.googleapis.com/auth/analytics.readonly"
	//   ]
	// }

}

// method id "analyticsadmin.properties.fetchConnectedGa4Property":

type PropertiesFetchConnectedGa4PropertyCall struct {
	s            *Service
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// FetchConnectedGa4Property: Given a specified UA property, looks up
// the GA4 property connected to it. Note: this cannot be used with GA4
// properties.
func (r *PropertiesService) FetchConnectedGa4Property() *PropertiesFetchConnectedGa4PropertyCall {
	c := &PropertiesFetchConnectedGa4PropertyCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	return c
}

// Property sets the optional parameter "property": Required. The UA
// property for which to look up the connected GA4 property. Note this
// request uses the internal property ID, not the tracking ID of the
// form UA-XXXXXX-YY. Format: properties/{internal_web_property_id}
// Example: properties/1234
func (c *PropertiesFetchConnectedGa4PropertyCall) Property(property string) *PropertiesFetchConnectedGa4PropertyCall {
	c.urlParams_.Set("property", property)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *PropertiesFetchConnectedGa4PropertyCall) Fields(s ...googleapi.Field) *PropertiesFetchConnectedGa4PropertyCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets the optional parameter which makes the operation
// fail if the object's ETag matches the given value. This is useful for
// getting updates only after the object has changed since the last
// request. Use googleapi.IsNotModified to check whether the response
// error from Do is the result of In-None-Match.
func (c *PropertiesFetchConnectedGa4PropertyCall) IfNoneMatch(entityTag string) *PropertiesFetchConnectedGa4PropertyCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *PropertiesFetchConnectedGa4PropertyCall) Context(ctx context.Context) *PropertiesFetchConnectedGa4PropertyCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *PropertiesFetchConnectedGa4PropertyCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *PropertiesFetchConnectedGa4PropertyCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1alpha/properties:fetchConnectedGa4Property")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "analyticsadmin.properties.fetchConnectedGa4Property" call.
// Exactly one of
// *GoogleAnalyticsAdminV1alphaFetchConnectedGa4PropertyResponse or
// error will be non-nil. Any non-2xx status code is an error. Response
// headers are in either
// *GoogleAnalyticsAdminV1alphaFetchConnectedGa4PropertyResponse.ServerRe
// sponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was
// returned.
func (c *PropertiesFetchConnectedGa4PropertyCall) Do(opts ...googleapi.CallOption) (*GoogleAnalyticsAdminV1alphaFetchConnectedGa4PropertyResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleAnalyticsAdminV1alphaFetchConnectedGa4PropertyResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Given a specified UA property, looks up the GA4 property connected to it. Note: this cannot be used with GA4 properties.",
	//   "flatPath": "v1alpha/properties:fetchConnectedGa4Property",
	//   "httpMethod": "GET",
	//   "id": "analyticsadmin.properties.fetchConnectedGa4Property",
	//   "parameterOrder": [],
	//   "parameters": {
	//     "property": {
	//       "description": "Required. The UA property for which to look up the connected GA4 property. Note this request uses the internal property ID, not the tracking ID of the form UA-XXXXXX-YY. Format: properties/{internal_web_property_id} Example: properties/1234",
	//       "location": "query",
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1alpha/properties:fetchConnectedGa4Property",
	//   "response": {
	//     "$ref": "GoogleAnalyticsAdminV1alphaFetchConnectedGa4PropertyResponse"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/analytics.edit",
	//     "https://www.googleapis.com/auth/analytics.readonly"
	//   ]
	// }

}

// method id "analyticsadmin.properties.get":

type PropertiesGetCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Lookup for a single "GA4" Property.
//
//   - name: The name of the property to lookup. Format:
//     properties/{property_id} Example: "properties/1000".
func (r *PropertiesService) Get(name string) *PropertiesGetCall {
	c := &PropertiesGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *PropertiesGetCall) Fields(s ...googleapi.Field) *PropertiesGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets the optional parameter which makes the operation
// fail if the object's ETag matches the given value. This is useful for
// getting updates only after the object has changed since the last
// request. Use googleapi.IsNotModified to check whether the response
// error from Do is the result of In-None-Match.
func (c *PropertiesGetCall) IfNoneMatch(entityTag string) *PropertiesGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *PropertiesGetCall) Context(ctx context.Context) *PropertiesGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *PropertiesGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *PropertiesGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1alpha/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "analyticsadmin.properties.get" call.
// Exactly one of *GoogleAnalyticsAdminV1alphaProperty or error will be
// non-nil. Any non-2xx status code is an error. Response headers are in
// either *GoogleAnalyticsAdminV1alphaProperty.ServerResponse.Header or
// (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was
// returned.
func (c *PropertiesGetCall) Do(opts ...googleapi.CallOption) (*GoogleAnalyticsAdminV1alphaProperty, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleAnalyticsAdminV1alphaProperty{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Lookup for a single \"GA4\" Property.",
	//   "flatPath": "v1alpha/properties/{propertiesId}",
	//   "httpMethod": "GET",
	//   "id": "analyticsadmin.properties.get",
	//   "parameterOrder": [
	//     "name"
	//   ],
	//   "parameters": {
	//     "name": {
	//       "description": "Required. The name of the property to lookup. Format: properties/{property_id} Example: \"properties/1000\"",
	//       "location": "path",
	//       "pattern": "^properties/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1alpha/{+name}",
	//   "response": {
	//     "$ref": "GoogleAnalyticsAdminV1alphaProperty"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/analytics.edit",
	//     "https://www.googleapis.com/auth/analytics.readonly"
	//   ]
	// }

}

// method id "analyticsadmin.properties.getAttributionSettings":

type PropertiesGetAttributionSettingsCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// GetAttributionSettings: Lookup for a AttributionSettings singleton.
//
//   - name: The name of the attribution settings to retrieve. Format:
//     properties/{property}/attributionSettings.
func (r *PropertiesService) GetAttributionSettings(name string) *PropertiesGetAttributionSettingsCall {
	c := &PropertiesGetAttributionSettingsCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *PropertiesGetAttributionSettingsCall) Fields(s ...googleapi.Field) *PropertiesGetAttributionSettingsCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets the optional parameter which makes the operation
// fail if the object's ETag matches the given value. This is useful for
// getting updates only after the object has changed since the last
// request. Use googleapi.IsNotModified to check whether the response
// error from Do is the result of In-None-Match.
func (c *PropertiesGetAttributionSettingsCall) IfNoneMatch(entityTag string) *PropertiesGetAttributionSettingsCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *PropertiesGetAttributionSettingsCall) Context(ctx context.Context) *PropertiesGetAttributionSettingsCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *PropertiesGetAttributionSettingsCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *PropertiesGetAttributionSettingsCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1alpha/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "analyticsadmin.properties.getAttributionSettings" call.
// Exactly one of *GoogleAnalyticsAdminV1alphaAttributionSettings or
// error will be non-nil. Any non-2xx status code is an error. Response
// headers are in either
// *GoogleAnalyticsAdminV1alphaAttributionSettings.ServerResponse.Header
// or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was
// returned.
func (c *PropertiesGetAttributionSettingsCall) Do(opts ...googleapi.CallOption) (*GoogleAnalyticsAdminV1alphaAttributionSettings, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleAnalyticsAdminV1alphaAttributionSettings{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Lookup for a AttributionSettings singleton.",
	//   "flatPath": "v1alpha/properties/{propertiesId}/attributionSettings",
	//   "httpMethod": "GET",
	//   "id": "analyticsadmin.properties.getAttributionSettings",
	//   "parameterOrder": [
	//     "name"
	//   ],
	//   "parameters": {
	//     "name": {
	//       "description": "Required. The name of the attribution settings to retrieve. Format: properties/{property}/attributionSettings",
	//       "location": "path",
	//       "pattern": "^properties/[^/]+/attributionSettings$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1alpha/{+name}",
	//   "response": {
	//     "$ref": "GoogleAnalyticsAdminV1alphaAttributionSettings"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/analytics.edit",
	//     "https://www.googleapis.com/auth/analytics.readonly"
	//   ]
	// }

}

// method id "analyticsadmin.properties.getDataRetentionSettings":

type PropertiesGetDataRetentionSettingsCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// GetDataRetentionSettings: Returns the singleton data retention
// settings for this property.
//
//   - name: The name of the settings to lookup. Format:
//     properties/{property}/dataRetentionSettings Example:
//     "properties/1000/dataRetentionSettings".
func (r *PropertiesService) GetDataRetentionSettings(name string) *PropertiesGetDataRetentionSettingsCall {
	c := &PropertiesGetDataRetentionSettingsCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *PropertiesGetDataRetentionSettingsCall) Fields(s ...googleapi.Field) *PropertiesGetDataRetentionSettingsCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets the optional parameter which makes the operation
// fail if the object's ETag matches the given value. This is useful for
// getting updates only after the object has changed since the last
// request. Use googleapi.IsNotModified to check whether the response
// error from Do is the result of In-None-Match.
func (c *PropertiesGetDataRetentionSettingsCall) IfNoneMatch(entityTag string) *PropertiesGetDataRetentionSettingsCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *PropertiesGetDataRetentionSettingsCall) Context(ctx context.Context) *PropertiesGetDataRetentionSettingsCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *PropertiesGetDataRetentionSettingsCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *PropertiesGetDataRetentionSettingsCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1alpha/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "analyticsadmin.properties.getDataRetentionSettings" call.
// Exactly one of *GoogleAnalyticsAdminV1alphaDataRetentionSettings or
// error will be non-nil. Any non-2xx status code is an error. Response
// headers are in either
// *GoogleAnalyticsAdminV1alphaDataRetentionSettings.ServerResponse.Heade
// r or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was
// returned.
func (c *PropertiesGetDataRetentionSettingsCall) Do(opts ...googleapi.CallOption) (*GoogleAnalyticsAdminV1alphaDataRetentionSettings, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleAnalyticsAdminV1alphaDataRetentionSettings{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Returns the singleton data retention settings for this property.",
	//   "flatPath": "v1alpha/properties/{propertiesId}/dataRetentionSettings",
	//   "httpMethod": "GET",
	//   "id": "analyticsadmin.properties.getDataRetentionSettings",
	//   "parameterOrder": [
	//     "name"
	//   ],
	//   "parameters": {
	//     "name": {
	//       "description": "Required. The name of the settings to lookup. Format: properties/{property}/dataRetentionSettings Example: \"properties/1000/dataRetentionSettings\"",
	//       "location": "path",
	//       "pattern": "^properties/[^/]+/dataRetentionSettings$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1alpha/{+name}",
	//   "response": {
	//     "$ref": "GoogleAnalyticsAdminV1alphaDataRetentionSettings"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/analytics.edit",
	//     "https://www.googleapis.com/auth/analytics.readonly"
	//   ]
	// }

}

// method id "analyticsadmin.properties.getGoogleSignalsSettings":

type PropertiesGetGoogleSignalsSettingsCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// GetGoogleSignalsSettings: Lookup for Google Signals settings for a
// property.
//
//   - name: The name of the google signals settings to retrieve. Format:
//     properties/{property}/googleSignalsSettings.
func (r *PropertiesService) GetGoogleSignalsSettings(name string) *PropertiesGetGoogleSignalsSettingsCall {
	c := &PropertiesGetGoogleSignalsSettingsCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *PropertiesGetGoogleSignalsSettingsCall) Fields(s ...googleapi.Field) *PropertiesGetGoogleSignalsSettingsCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets the optional parameter which makes the operation
// fail if the object's ETag matches the given value. This is useful for
// getting updates only after the object has changed since the last
// request. Use googleapi.IsNotModified to check whether the response
// error from Do is the result of In-None-Match.
func (c *PropertiesGetGoogleSignalsSettingsCall) IfNoneMatch(entityTag string) *PropertiesGetGoogleSignalsSettingsCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *PropertiesGetGoogleSignalsSettingsCall) Context(ctx context.Context) *PropertiesGetGoogleSignalsSettingsCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *PropertiesGetGoogleSignalsSettingsCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *PropertiesGetGoogleSignalsSettingsCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1alpha/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "analyticsadmin.properties.getGoogleSignalsSettings" call.
// Exactly one of *GoogleAnalyticsAdminV1alphaGoogleSignalsSettings or
// error will be non-nil. Any non-2xx status code is an error. Response
// headers are in either
// *GoogleAnalyticsAdminV1alphaGoogleSignalsSettings.ServerResponse.Heade
// r or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was
// returned.
func (c *PropertiesGetGoogleSignalsSettingsCall) Do(opts ...googleapi.CallOption) (*GoogleAnalyticsAdminV1alphaGoogleSignalsSettings, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleAnalyticsAdminV1alphaGoogleSignalsSettings{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Lookup for Google Signals settings for a property.",
	//   "flatPath": "v1alpha/properties/{propertiesId}/googleSignalsSettings",
	//   "httpMethod": "GET",
	//   "id": "analyticsadmin.properties.getGoogleSignalsSettings",
	//   "parameterOrder": [
	//     "name"
	//   ],
	//   "parameters": {
	//     "name": {
	//       "description": "Required. The name of the google signals settings to retrieve. Format: properties/{property}/googleSignalsSettings",
	//       "location": "path",
	//       "pattern": "^properties/[^/]+/googleSignalsSettings$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1alpha/{+name}",
	//   "response": {
	//     "$ref": "GoogleAnalyticsAdminV1alphaGoogleSignalsSettings"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/analytics.edit",
	//     "https://www.googleapis.com/auth/analytics.readonly"
	//   ]
	// }

}

// method id "analyticsadmin.properties.list":

type PropertiesListCall struct {
	s            *Service
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Returns child Properties under the specified parent Account.
// Only "GA4" properties will be returned. Properties will be excluded
// if the caller does not have access. Soft-deleted (ie: "trashed")
// properties are excluded by default. Returns an empty list if no
// relevant properties are found.
func (r *PropertiesService) List() *PropertiesListCall {
	c := &PropertiesListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	return c
}

// Filter sets the optional parameter "filter": Required. An expression
// for filtering the results of the request. Fields eligible for
// filtering are: `parent:`(The resource name of the parent
// account/property) or `ancestor:`(The resource name of the parent
// account) or `firebase_project:`(The id or number of the linked
// firebase project). Some examples of filters: ``` | Filter |
// Description |
// |-----------------------------|---------------------------------------
// ----| | parent:accounts/123 | The account with account id: 123. | |
// parent:properties/123 | The property with property id: 123. | |
// ancestor:accounts/123 | The account with account id: 123. | |
// firebase_project:project-id | The firebase project with id:
// project-id. | | firebase_project:123 | The firebase project with
// number: 123. | ```
func (c *PropertiesListCall) Filter(filter string) *PropertiesListCall {
	c.urlParams_.Set("filter", filter)
	return c
}

// PageSize sets the optional parameter "pageSize": The maximum number
// of resources to return. The service may return fewer than this value,
// even if there are additional pages. If unspecified, at most 50
// resources will be returned. The maximum value is 200; (higher values
// will be coerced to the maximum)
func (c *PropertiesListCall) PageSize(pageSize int64) *PropertiesListCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": A page token,
// received from a previous `ListProperties` call. Provide this to
// retrieve the subsequent page. When paginating, all other parameters
// provided to `ListProperties` must match the call that provided the
// page token.
func (c *PropertiesListCall) PageToken(pageToken string) *PropertiesListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// ShowDeleted sets the optional parameter "showDeleted": Whether to
// include soft-deleted (ie: "trashed") Properties in the results.
// Properties can be inspected to determine whether they are deleted or
// not.
func (c *PropertiesListCall) ShowDeleted(showDeleted bool) *PropertiesListCall {
	c.urlParams_.Set("showDeleted", fmt.Sprint(showDeleted))
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *PropertiesListCall) Fields(s ...googleapi.Field) *PropertiesListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets the optional parameter which makes the operation
// fail if the object's ETag matches the given value. This is useful for
// getting updates only after the object has changed since the last
// request. Use googleapi.IsNotModified to check whether the response
// error from Do is the result of In-None-Match.
func (c *PropertiesListCall) IfNoneMatch(entityTag string) *PropertiesListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *PropertiesListCall) Context(ctx context.Context) *PropertiesListCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *PropertiesListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *PropertiesListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1alpha/properties")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "analyticsadmin.properties.list" call.
// Exactly one of *GoogleAnalyticsAdminV1alphaListPropertiesResponse or
// error will be non-nil. Any non-2xx status code is an error. Response
// headers are in either
// *GoogleAnalyticsAdminV1alphaListPropertiesResponse.ServerResponse.Head
// er or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was
// returned.
func (c *PropertiesListCall) Do(opts ...googleapi.CallOption) (*GoogleAnalyticsAdminV1alphaListPropertiesResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleAnalyticsAdminV1alphaListPropertiesResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Returns child Properties under the specified parent Account. Only \"GA4\" properties will be returned. Properties will be excluded if the caller does not have access. Soft-deleted (ie: \"trashed\") properties are excluded by default. Returns an empty list if no relevant properties are found.",
	//   "flatPath": "v1alpha/properties",
	//   "httpMethod": "GET",
	//   "id": "analyticsadmin.properties.list",
	//   "parameterOrder": [],
	//   "parameters": {
	//     "filter": {
	//       "description": "Required. An expression for filtering the results of the request. Fields eligible for filtering are: `parent:`(The resource name of the parent account/property) or `ancestor:`(The resource name of the parent account) or `firebase_project:`(The id or number of the linked firebase project). Some examples of filters: ``` | Filter | Description | |-----------------------------|-------------------------------------------| | parent:accounts/123 | The account with account id: 123. | | parent:properties/123 | The property with property id: 123. | | ancestor:accounts/123 | The account with account id: 123. | | firebase_project:project-id | The firebase project with id: project-id. | | firebase_project:123 | The firebase project with number: 123. | ```",
	//       "location": "query",
	//       "type": "string"
	//     },
	//     "pageSize": {
	//       "description": "The maximum number of resources to return. The service may return fewer than this value, even if there are additional pages. If unspecified, at most 50 resources will be returned. The maximum value is 200; (higher values will be coerced to the maximum)",
	//       "format": "int32",
	//       "location": "query",
	//       "type": "integer"
	//     },
	//     "pageToken": {
	//       "description": "A page token, received from a previous `ListProperties` call. Provide this to retrieve the subsequent page. When paginating, all other parameters provided to `ListProperties` must match the call that provided the page token.",
	//       "location": "query",
	//       "type": "string"
	//     },
	//     "showDeleted": {
	//       "description": "Whether to include soft-deleted (ie: \"trashed\") Properties in the results. Properties can be inspected to determine whether they are deleted or not.",
	//       "location": "query",
	//       "type": "boolean"
	//     }
	//   },
	//   "path": "v1alpha/properties",
	//   "response": {
	//     "$ref": "GoogleAnalyticsAdminV1alphaListPropertiesResponse"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/analytics.edit",
	//     "https://www.googleapis.com/auth/analytics.readonly"
	//   ]
	// }

}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *PropertiesListCall) Pages(ctx context.Context, f func(*GoogleAnalyticsAdminV1alphaListPropertiesResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken")) // reset paging to original point
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

// method id "analyticsadmin.properties.listConnectedSiteTags":

type PropertiesListConnectedSiteTagsCall struct {
	s                                                       *Service
	googleanalyticsadminv1alphalistconnectedsitetagsrequest *GoogleAnalyticsAdminV1alphaListConnectedSiteTagsRequest
	urlParams_                                              gensupport.URLParams
	ctx_                                                    context.Context
	header_                                                 http.Header
}

// ListConnectedSiteTags: Lists the connected site tags for a Universal
// Analytics property. A maximum of 20 connected site tags will be
// returned. Note: this has no effect on GA4 property.
func (r *PropertiesService) ListConnectedSiteTags(googleanalyticsadminv1alphalistconnectedsitetagsrequest *GoogleAnalyticsAdminV1alphaListConnectedSiteTagsRequest) *PropertiesListConnectedSiteTagsCall {
	c := &PropertiesListConnectedSiteTagsCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.googleanalyticsadminv1alphalistconnectedsitetagsrequest = googleanalyticsadminv1alphalistconnectedsitetagsrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *PropertiesListConnectedSiteTagsCall) Fields(s ...googleapi.Field) *PropertiesListConnectedSiteTagsCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *PropertiesListConnectedSiteTagsCall) Context(ctx context.Context) *PropertiesListConnectedSiteTagsCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *PropertiesListConnectedSiteTagsCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *PropertiesListConnectedSiteTagsCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.googleanalyticsadminv1alphalistconnectedsitetagsrequest)
	if err != nil {
		return nil, err
	}
	reqHeaders.Set("Content-Type", "application/json")
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1alpha/properties:listConnectedSiteTags")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "analyticsadmin.properties.listConnectedSiteTags" call.
// Exactly one of
// *GoogleAnalyticsAdminV1alphaListConnectedSiteTagsResponse or error
// will be non-nil. Any non-2xx status code is an error. Response
// headers are in either
// *GoogleAnalyticsAdminV1alphaListConnectedSiteTagsResponse.ServerRespon
// se.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was
// returned.
func (c *PropertiesListConnectedSiteTagsCall) Do(opts ...googleapi.CallOption) (*GoogleAnalyticsAdminV1alphaListConnectedSiteTagsResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleAnalyticsAdminV1alphaListConnectedSiteTagsResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Lists the connected site tags for a Universal Analytics property. A maximum of 20 connected site tags will be returned. Note: this has no effect on GA4 property.",
	//   "flatPath": "v1alpha/properties:listConnectedSiteTags",
	//   "httpMethod": "POST",
	//   "id": "analyticsadmin.properties.listConnectedSiteTags",
	//   "parameterOrder": [],
	//   "parameters": {},
	//   "path": "v1alpha/properties:listConnectedSiteTags",
	//   "request": {
	//     "$ref": "GoogleAnalyticsAdminV1alphaListConnectedSiteTagsRequest"
	//   },
	//   "response": {
	//     "$ref": "GoogleAnalyticsAdminV1alphaListConnectedSiteTagsResponse"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/analytics.edit",
	//     "https://www.googleapis.com/auth/analytics.readonly"
	//   ]
	// }

}

// method id "analyticsadmin.properties.patch":

type PropertiesPatchCall struct {
	s                                   *Service
	name                                string
	googleanalyticsadminv1alphaproperty *GoogleAnalyticsAdminV1alphaProperty
	urlParams_                          gensupport.URLParams
	ctx_                                context.Context
	header_                             http.Header
}

// Patch: Updates a property.
//
//   - name: Output only. Resource name of this property. Format:
//     properties/{property_id} Example: "properties/1000".
func (r *PropertiesService) Patch(name string, googleanalyticsadminv1alphaproperty *GoogleAnalyticsAdminV1alphaProperty) *PropertiesPatchCall {
	c := &PropertiesPatchCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	c.googleanalyticsadminv1alphaproperty = googleanalyticsadminv1alphaproperty
	return c
}

// UpdateMask sets the optional parameter "updateMask": Required. The
// list of fields to be updated. Field names must be in snake case
// (e.g., "field_to_update"). Omitted fields will not be updated. To
// replace the entire entity, use one path with the string "*" to match
// all fields.
func (c *PropertiesPatchCall) UpdateMask(updateMask string) *PropertiesPatchCall {
	c.urlParams_.Set("updateMask", updateMask)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *PropertiesPatchCall) Fields(s ...googleapi.Field) *PropertiesPatchCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *PropertiesPatchCall) Context(ctx context.Context) *PropertiesPatchCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *PropertiesPatchCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *PropertiesPatchCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.googleanalyticsadminv1alphaproperty)
	if err != nil {
		return nil, err
	}
	reqHeaders.Set("Content-Type", "application/json")
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1alpha/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("PATCH", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "analyticsadmin.properties.patch" call.
// Exactly one of *GoogleAnalyticsAdminV1alphaProperty or error will be
// non-nil. Any non-2xx status code is an error. Response headers are in
// either *GoogleAnalyticsAdminV1alphaProperty.ServerResponse.Header or
// (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was
// returned.
func (c *PropertiesPatchCall) Do(opts ...googleapi.CallOption) (*GoogleAnalyticsAdminV1alphaProperty, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleAnalyticsAdminV1alphaProperty{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Updates a property.",
	//   "flatPath": "v1alpha/properties/{propertiesId}",
	//   "httpMethod": "PATCH",
	//   "id": "analyticsadmin.properties.patch",
	//   "parameterOrder": [
	//     "name"
	//   ],
	//   "parameters": {
	//     "name": {
	//       "description": "Output only. Resource name of this property. Format: properties/{property_id} Example: \"properties/1000\"",
	//       "location": "path",
	//       "pattern": "^properties/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     },
	//     "updateMask": {
	//       "description": "Required. The list of fields to be updated. Field names must be in snake case (e.g., \"field_to_update\"). Omitted fields will not be updated. To replace the entire entity, use one path with the string \"*\" to match all fields.",
	//       "format": "google-fieldmask",
	//       "location": "query",
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1alpha/{+name}",
	//   "request": {
	//     "$ref": "GoogleAnalyticsAdminV1alphaProperty"
	//   },
	//   "response": {
	//     "$ref": "GoogleAnalyticsAdminV1alphaProperty"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/analytics.edit"
	//   ]
	// }

}

// method id "analyticsadmin.properties.runAccessReport":

type PropertiesRunAccessReportCall struct {
	s                                                 *Service
	entity                                            string
	googleanalyticsadminv1alpharunaccessreportrequest *GoogleAnalyticsAdminV1alphaRunAccessReportRequest
	urlParams_                                        gensupport.URLParams
	ctx_                                              context.Context
	header_                                           http.Header
}

// RunAccessReport: Returns a customized report of data access records.
// The report provides records of each time a user reads Google
// Analytics reporting data. Access records are retained for up to 2
// years. Data Access Reports can be requested for a property. The
// property must be in Google Analytics 360. This method is only
// available to Administrators. These data access records include GA4 UI
// Reporting, GA4 UI Explorations, GA4 Data API, and other products like
// Firebase & Admob that can retrieve data from Google Analytics through
// a linkage. These records don't include property configuration changes
// like adding a stream or changing a property's time zone. For
// configuration change history, see searchChangeHistoryEvents
// (https://developers.google.com/analytics/devguides/config/admin/v1/rest/v1alpha/accounts/searchChangeHistoryEvents).
//
//   - entity: The Data Access Report supports requesting at the property
//     level or account level. If requested at the account level, Data
//     Access Reports include all access for all properties under that
//     account. To request at the property level, entity should be for
//     example 'properties/123' if "123" is your GA4 property ID. To
//     request at the account level, entity should be for example
//     'accounts/1234' if "1234" is your GA4 Account ID.
func (r *PropertiesService) RunAccessReport(entity string, googleanalyticsadminv1alpharunaccessreportrequest *GoogleAnalyticsAdminV1alphaRunAccessReportRequest) *PropertiesRunAccessReportCall {
	c := &PropertiesRunAccessReportCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.entity = entity
	c.googleanalyticsadminv1alpharunaccessreportrequest = googleanalyticsadminv1alpharunaccessreportrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *PropertiesRunAccessReportCall) Fields(s ...googleapi.Field) *PropertiesRunAccessReportCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *PropertiesRunAccessReportCall) Context(ctx context.Context) *PropertiesRunAccessReportCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *PropertiesRunAccessReportCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *PropertiesRunAccessReportCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.googleanalyticsadminv1alpharunaccessreportrequest)
	if err != nil {
		return nil, err
	}
	reqHeaders.Set("Content-Type", "application/json")
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1alpha/{+entity}:runAccessReport")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"entity": c.entity,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "analyticsadmin.properties.runAccessReport" call.
// Exactly one of *GoogleAnalyticsAdminV1alphaRunAccessReportResponse or
// error will be non-nil. Any non-2xx status code is an error. Response
// headers are in either
// *GoogleAnalyticsAdminV1alphaRunAccessReportResponse.ServerResponse.Hea
// der or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was
// returned.
func (c *PropertiesRunAccessReportCall) Do(opts ...googleapi.CallOption) (*GoogleAnalyticsAdminV1alphaRunAccessReportResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleAnalyticsAdminV1alphaRunAccessReportResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Returns a customized report of data access records. The report provides records of each time a user reads Google Analytics reporting data. Access records are retained for up to 2 years. Data Access Reports can be requested for a property. The property must be in Google Analytics 360. This method is only available to Administrators. These data access records include GA4 UI Reporting, GA4 UI Explorations, GA4 Data API, and other products like Firebase \u0026 Admob that can retrieve data from Google Analytics through a linkage. These records don't include property configuration changes like adding a stream or changing a property's time zone. For configuration change history, see [searchChangeHistoryEvents](https://developers.google.com/analytics/devguides/config/admin/v1/rest/v1alpha/accounts/searchChangeHistoryEvents).",
	//   "flatPath": "v1alpha/properties/{propertiesId}:runAccessReport",
	//   "httpMethod": "POST",
	//   "id": "analyticsadmin.properties.runAccessReport",
	//   "parameterOrder": [
	//     "entity"
	//   ],
	//   "parameters": {
	//     "entity": {
	//       "description": "The Data Access Report supports requesting at the property level or account level. If requested at the account level, Data Access Reports include all access for all properties under that account. To request at the property level, entity should be for example 'properties/123' if \"123\" is your GA4 property ID. To request at the account level, entity should be for example 'accounts/1234' if \"1234\" is your GA4 Account ID.",
	//       "location": "path",
	//       "pattern": "^properties/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1alpha/{+entity}:runAccessReport",
	//   "request": {
	//     "$ref": "GoogleAnalyticsAdminV1alphaRunAccessReportRequest"
	//   },
	//   "response": {
	//     "$ref": "GoogleAnalyticsAdminV1alphaRunAccessReportResponse"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/analytics.edit",
	//     "https://www.googleapis.com/auth/analytics.readonly"
	//   ]
	// }

}

// method id "analyticsadmin.properties.setAutomatedGa4ConfigurationOptOut":

type PropertiesSetAutomatedGa4ConfigurationOptOutCall struct {
	s                                                                    *Service
	googleanalyticsadminv1alphasetautomatedga4configurationoptoutrequest *GoogleAnalyticsAdminV1alphaSetAutomatedGa4ConfigurationOptOutRequest
	urlParams_                                                           gensupport.URLParams
	ctx_                                                                 context.Context
	header_                                                              http.Header
}

// SetAutomatedGa4ConfigurationOptOut: Sets the opt out status for the
// automated GA4 setup process for a UA property. Note: this has no
// effect on GA4 property.
func (r *PropertiesService) SetAutomatedGa4ConfigurationOptOut(googleanalyticsadminv1alphasetautomatedga4configurationoptoutrequest *GoogleAnalyticsAdminV1alphaSetAutomatedGa4ConfigurationOptOutRequest) *PropertiesSetAutomatedGa4ConfigurationOptOutCall {
	c := &PropertiesSetAutomatedGa4ConfigurationOptOutCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.googleanalyticsadminv1alphasetautomatedga4configurationoptoutrequest = googleanalyticsadminv1alphasetautomatedga4configurationoptoutrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *PropertiesSetAutomatedGa4ConfigurationOptOutCall) Fields(s ...googleapi.Field) *PropertiesSetAutomatedGa4ConfigurationOptOutCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *PropertiesSetAutomatedGa4ConfigurationOptOutCall) Context(ctx context.Context) *PropertiesSetAutomatedGa4ConfigurationOptOutCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *PropertiesSetAutomatedGa4ConfigurationOptOutCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *PropertiesSetAutomatedGa4ConfigurationOptOutCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.googleanalyticsadminv1alphasetautomatedga4configurationoptoutrequest)
	if err != nil {
		return nil, err
	}
	reqHeaders.Set("Content-Type", "application/json")
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1alpha/properties:setAutomatedGa4ConfigurationOptOut")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "analyticsadmin.properties.setAutomatedGa4ConfigurationOptOut" call.
// Exactly one of
// *GoogleAnalyticsAdminV1alphaSetAutomatedGa4ConfigurationOptOutResponse
//
//	or error will be non-nil. Any non-2xx status code is an error.
//
// Response headers are in either
// *GoogleAnalyticsAdminV1alphaSetAutomatedGa4ConfigurationOptOutResponse
// .ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was
// returned.
func (c *PropertiesSetAutomatedGa4ConfigurationOptOutCall) Do(opts ...googleapi.CallOption) (*GoogleAnalyticsAdminV1alphaSetAutomatedGa4ConfigurationOptOutResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleAnalyticsAdminV1alphaSetAutomatedGa4ConfigurationOptOutResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Sets the opt out status for the automated GA4 setup process for a UA property. Note: this has no effect on GA4 property.",
	//   "flatPath": "v1alpha/properties:setAutomatedGa4ConfigurationOptOut",
	//   "httpMethod": "POST",
	//   "id": "analyticsadmin.properties.setAutomatedGa4ConfigurationOptOut",
	//   "parameterOrder": [],
	//   "parameters": {},
	//   "path": "v1alpha/properties:setAutomatedGa4ConfigurationOptOut",
	//   "request": {
	//     "$ref": "GoogleAnalyticsAdminV1alphaSetAutomatedGa4ConfigurationOptOutRequest"
	//   },
	//   "response": {
	//     "$ref": "GoogleAnalyticsAdminV1alphaSetAutomatedGa4ConfigurationOptOutResponse"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/analytics.edit"
	//   ]
	// }

}

// method id "analyticsadmin.properties.updateAttributionSettings":

type PropertiesUpdateAttributionSettingsCall struct {
	s                                              *Service
	name                                           string
	googleanalyticsadminv1alphaattributionsettings *GoogleAnalyticsAdminV1alphaAttributionSettings
	urlParams_                                     gensupport.URLParams
	ctx_                                           context.Context
	header_                                        http.Header
}

// UpdateAttributionSettings: Updates attribution settings on a
// property.
//
//   - name: Output only. Resource name of this attribution settings
//     resource. Format: properties/{property_id}/attributionSettings
//     Example: "properties/1000/attributionSettings".
func (r *PropertiesService) UpdateAttributionSettings(name string, googleanalyticsadminv1alphaattributionsettings *GoogleAnalyticsAdminV1alphaAttributionSettings) *PropertiesUpdateAttributionSettingsCall {
	c := &PropertiesUpdateAttributionSettingsCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	c.googleanalyticsadminv1alphaattributionsettings = googleanalyticsadminv1alphaattributionsettings
	return c
}

// UpdateMask sets the optional parameter "updateMask": Required. The
// list of fields to be updated. Field names must be in snake case
// (e.g., "field_to_update"). Omitted fields will not be updated. To
// replace the entire entity, use one path with the string "*" to match
// all fields.
func (c *PropertiesUpdateAttributionSettingsCall) UpdateMask(updateMask string) *PropertiesUpdateAttributionSettingsCall {
	c.urlParams_.Set("updateMask", updateMask)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *PropertiesUpdateAttributionSettingsCall) Fields(s ...googleapi.Field) *PropertiesUpdateAttributionSettingsCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *PropertiesUpdateAttributionSettingsCall) Context(ctx context.Context) *PropertiesUpdateAttributionSettingsCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *PropertiesUpdateAttributionSettingsCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *PropertiesUpdateAttributionSettingsCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.googleanalyticsadminv1alphaattributionsettings)
	if err != nil {
		return nil, err
	}
	reqHeaders.Set("Content-Type", "application/json")
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1alpha/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("PATCH", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "analyticsadmin.properties.updateAttributionSettings" call.
// Exactly one of *GoogleAnalyticsAdminV1alphaAttributionSettings or
// error will be non-nil. Any non-2xx status code is an error. Response
// headers are in either
// *GoogleAnalyticsAdminV1alphaAttributionSettings.ServerResponse.Header
// or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was
// returned.
func (c *PropertiesUpdateAttributionSettingsCall) Do(opts ...googleapi.CallOption) (*GoogleAnalyticsAdminV1alphaAttributionSettings, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleAnalyticsAdminV1alphaAttributionSettings{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Updates attribution settings on a property.",
	//   "flatPath": "v1alpha/properties/{propertiesId}/attributionSettings",
	//   "httpMethod": "PATCH",
	//   "id": "analyticsadmin.properties.updateAttributionSettings",
	//   "parameterOrder": [
	//     "name"
	//   ],
	//   "parameters": {
	//     "name": {
	//       "description": "Output only. Resource name of this attribution settings resource. Format: properties/{property_id}/attributionSettings Example: \"properties/1000/attributionSettings\"",
	//       "location": "path",
	//       "pattern": "^properties/[^/]+/attributionSettings$",
	//       "required": true,
	//       "type": "string"
	//     },
	//     "updateMask": {
	//       "description": "Required. The list of fields to be updated. Field names must be in snake case (e.g., \"field_to_update\"). Omitted fields will not be updated. To replace the entire entity, use one path with the string \"*\" to match all fields.",
	//       "format": "google-fieldmask",
	//       "location": "query",
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1alpha/{+name}",
	//   "request": {
	//     "$ref": "GoogleAnalyticsAdminV1alphaAttributionSettings"
	//   },
	//   "response": {
	//     "$ref": "GoogleAnalyticsAdminV1alphaAttributionSettings"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/analytics.edit"
	//   ]
	// }

}

// method id "analyticsadmin.properties.updateDataRetentionSettings":

type PropertiesUpdateDataRetentionSettingsCall struct {
	s                                                *Service
	name                                             string
	googleanalyticsadminv1alphadataretentionsettings *GoogleAnalyticsAdminV1alphaDataRetentionSettings
	urlParams_                                       gensupport.URLParams
	ctx_                                             context.Context
	header_                                          http.Header
}

// UpdateDataRetentionSettings: Updates the singleton data retention
// settings for this property.
//
//   - name: Output only. Resource name for this DataRetentionSetting
//     resource. Format: properties/{property}/dataRetentionSettings.
func (r *PropertiesService) UpdateDataRetentionSettings(name string, googleanalyticsadminv1alphadataretentionsettings *GoogleAnalyticsAdminV1alphaDataRetentionSettings) *PropertiesUpdateDataRetentionSettingsCall {
	c := &PropertiesUpdateDataRetentionSettingsCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	c.googleanalyticsadminv1alphadataretentionsettings = googleanalyticsadminv1alphadataretentionsettings
	return c
}

// UpdateMask sets the optional parameter "updateMask": Required. The
// list of fields to be updated. Field names must be in snake case
// (e.g., "field_to_update"). Omitted fields will not be updated. To
// replace the entire entity, use one path with the string "*" to match
// all fields.
func (c *PropertiesUpdateDataRetentionSettingsCall) UpdateMask(updateMask string) *PropertiesUpdateDataRetentionSettingsCall {
	c.urlParams_.Set("updateMask", updateMask)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *PropertiesUpdateDataRetentionSettingsCall) Fields(s ...googleapi.Field) *PropertiesUpdateDataRetentionSettingsCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *PropertiesUpdateDataRetentionSettingsCall) Context(ctx context.Context) *PropertiesUpdateDataRetentionSettingsCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *PropertiesUpdateDataRetentionSettingsCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *PropertiesUpdateDataRetentionSettingsCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.googleanalyticsadminv1alphadataretentionsettings)
	if err != nil {
		return nil, err
	}
	reqHeaders.Set("Content-Type", "application/json")
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1alpha/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("PATCH", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "analyticsadmin.properties.updateDataRetentionSettings" call.
// Exactly one of *GoogleAnalyticsAdminV1alphaDataRetentionSettings or
// error will be non-nil. Any non-2xx status code is an error. Response
// headers are in either
// *GoogleAnalyticsAdminV1alphaDataRetentionSettings.ServerResponse.Heade
// r or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was
// returned.
func (c *PropertiesUpdateDataRetentionSettingsCall) Do(opts ...googleapi.CallOption) (*GoogleAnalyticsAdminV1alphaDataRetentionSettings, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleAnalyticsAdminV1alphaDataRetentionSettings{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Updates the singleton data retention settings for this property.",
	//   "flatPath": "v1alpha/properties/{propertiesId}/dataRetentionSettings",
	//   "httpMethod": "PATCH",
	//   "id": "analyticsadmin.properties.updateDataRetentionSettings",
	//   "parameterOrder": [
	//     "name"
	//   ],
	//   "parameters": {
	//     "name": {
	//       "description": "Output only. Resource name for this DataRetentionSetting resource. Format: properties/{property}/dataRetentionSettings",
	//       "location": "path",
	//       "pattern": "^properties/[^/]+/dataRetentionSettings$",
	//       "required": true,
	//       "type": "string"
	//     },
	//     "updateMask": {
	//       "description": "Required. The list of fields to be updated. Field names must be in snake case (e.g., \"field_to_update\"). Omitted fields will not be updated. To replace the entire entity, use one path with the string \"*\" to match all fields.",
	//       "format": "google-fieldmask",
	//       "location": "query",
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1alpha/{+name}",
	//   "request": {
	//     "$ref": "GoogleAnalyticsAdminV1alphaDataRetentionSettings"
	//   },
	//   "response": {
	//     "$ref": "GoogleAnalyticsAdminV1alphaDataRetentionSettings"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/analytics.edit"
	//   ]
	// }

}

// method id "analyticsadmin.properties.updateGoogleSignalsSettings":

type PropertiesUpdateGoogleSignalsSettingsCall struct {
	s                                                *Service
	name                                             string
	googleanalyticsadminv1alphagooglesignalssettings *GoogleAnalyticsAdminV1alphaGoogleSignalsSettings
	urlParams_                                       gensupport.URLParams
	ctx_                                             context.Context
	header_                                          http.Header
}

// UpdateGoogleSignalsSettings: Updates Google Signals settings for a
// property.
//
//   - name: Output only. Resource name of this setting. Format:
//     properties/{property_id}/googleSignalsSettings Example:
//     "properties/1000/googleSignalsSettings".
func (r *PropertiesService) UpdateGoogleSignalsSettings(name string, googleanalyticsadminv1alphagooglesignalssettings *GoogleAnalyticsAdminV1alphaGoogleSignalsSettings) *PropertiesUpdateGoogleSignalsSettingsCall {
	c := &PropertiesUpdateGoogleSignalsSettingsCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	c.googleanalyticsadminv1alphagooglesignalssettings = googleanalyticsadminv1alphagooglesignalssettings
	return c
}

// UpdateMask sets the optional parameter "updateMask": Required. The
// list of fields to be updated. Field names must be in snake case
// (e.g., "field_to_update"). Omitted fields will not be updated. To
// replace the entire entity, use one path with the string "*" to match
// all fields.
func (c *PropertiesUpdateGoogleSignalsSettingsCall) UpdateMask(updateMask string) *PropertiesUpdateGoogleSignalsSettingsCall {
	c.urlParams_.Set("updateMask", updateMask)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *PropertiesUpdateGoogleSignalsSettingsCall) Fields(s ...googleapi.Field) *PropertiesUpdateGoogleSignalsSettingsCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *PropertiesUpdateGoogleSignalsSettingsCall) Context(ctx context.Context) *PropertiesUpdateGoogleSignalsSettingsCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *PropertiesUpdateGoogleSignalsSettingsCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *PropertiesUpdateGoogleSignalsSettingsCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.googleanalyticsadminv1alphagooglesignalssettings)
	if err != nil {
		return nil, err
	}
	reqHeaders.Set("Content-Type", "application/json")
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1alpha/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("PATCH", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "analyticsadmin.properties.updateGoogleSignalsSettings" call.
// Exactly one of *GoogleAnalyticsAdminV1alphaGoogleSignalsSettings or
// error will be non-nil. Any non-2xx status code is an error. Response
// headers are in either
// *GoogleAnalyticsAdminV1alphaGoogleSignalsSettings.ServerResponse.Heade
// r or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was
// returned.
func (c *PropertiesUpdateGoogleSignalsSettingsCall) Do(opts ...googleapi.CallOption) (*GoogleAnalyticsAdminV1alphaGoogleSignalsSettings, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleAnalyticsAdminV1alphaGoogleSignalsSettings{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Updates Google Signals settings for a property.",
	//   "flatPath": "v1alpha/properties/{propertiesId}/googleSignalsSettings",
	//   "httpMethod": "PATCH",
	//   "id": "analyticsadmin.properties.updateGoogleSignalsSettings",
	//   "parameterOrder": [
	//     "name"
	//   ],
	//   "parameters": {
	//     "name": {
	//       "description": "Output only. Resource name of this setting. Format: properties/{property_id}/googleSignalsSettings Example: \"properties/1000/googleSignalsSettings\"",
	//       "location": "path",
	//       "pattern": "^properties/[^/]+/googleSignalsSettings$",
	//       "required": true,
	//       "type": "string"
	//     },
	//     "updateMask": {
	//       "description": "Required. The list of fields to be updated. Field names must be in snake case (e.g., \"field_to_update\"). Omitted fields will not be updated. To replace the entire entity, use one path with the string \"*\" to match all fields.",
	//       "format": "google-fieldmask",
	//       "location": "query",
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1alpha/{+name}",
	//   "request": {
	//     "$ref": "GoogleAnalyticsAdminV1alphaGoogleSignalsSettings"
	//   },
	//   "response": {
	//     "$ref": "GoogleAnalyticsAdminV1alphaGoogleSignalsSettings"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/analytics.edit"
	//   ]
	// }

}

// method id "analyticsadmin.properties.accessBindings.batchCreate":

type PropertiesAccessBindingsBatchCreateCall struct {
	s                                                           *Service
	parent                                                      string
	googleanalyticsadminv1alphabatchcreateaccessbindingsrequest *GoogleAnalyticsAdminV1alphaBatchCreateAccessBindingsRequest
	urlParams_                                                  gensupport.URLParams
	ctx_                                                        context.Context
	header_                                                     http.Header
}

// BatchCreate: Creates information about multiple access bindings to an
// account or property. This method is transactional. If any
// AccessBinding cannot be created, none of the AccessBindings will be
// created.
//
//   - parent: The account or property that owns the access bindings. The
//     parent field in the CreateAccessBindingRequest messages must either
//     be empty or match this field. Formats: - accounts/{account} -
//     properties/{property}.
func (r *PropertiesAccessBindingsService) BatchCreate(parent string, googleanalyticsadminv1alphabatchcreateaccessbindingsrequest *GoogleAnalyticsAdminV1alphaBatchCreateAccessBindingsRequest) *PropertiesAccessBindingsBatchCreateCall {
	c := &PropertiesAccessBindingsBatchCreateCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	c.googleanalyticsadminv1alphabatchcreateaccessbindingsrequest = googleanalyticsadminv1alphabatchcreateaccessbindingsrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *PropertiesAccessBindingsBatchCreateCall) Fields(s ...googleapi.Field) *PropertiesAccessBindingsBatchCreateCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *PropertiesAccessBindingsBatchCreateCall) Context(ctx context.Context) *PropertiesAccessBindingsBatchCreateCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *PropertiesAccessBindingsBatchCreateCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *PropertiesAccessBindingsBatchCreateCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.googleanalyticsadminv1alphabatchcreateaccessbindingsrequest)
	if err != nil {
		return nil, err
	}
	reqHeaders.Set("Content-Type", "application/json")
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1alpha/{+parent}/accessBindings:batchCreate")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "analyticsadmin.properties.accessBindings.batchCreate" call.
// Exactly one of
// *GoogleAnalyticsAdminV1alphaBatchCreateAccessBindingsResponse or
// error will be non-nil. Any non-2xx status code is an error. Response
// headers are in either
// *GoogleAnalyticsAdminV1alphaBatchCreateAccessBindingsResponse.ServerRe
// sponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was
// returned.
func (c *PropertiesAccessBindingsBatchCreateCall) Do(opts ...googleapi.CallOption) (*GoogleAnalyticsAdminV1alphaBatchCreateAccessBindingsResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleAnalyticsAdminV1alphaBatchCreateAccessBindingsResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Creates information about multiple access bindings to an account or property. This method is transactional. If any AccessBinding cannot be created, none of the AccessBindings will be created.",
	//   "flatPath": "v1alpha/properties/{propertiesId}/accessBindings:batchCreate",
	//   "httpMethod": "POST",
	//   "id": "analyticsadmin.properties.accessBindings.batchCreate",
	//   "parameterOrder": [
	//     "parent"
	//   ],
	//   "parameters": {
	//     "parent": {
	//       "description": "Required. The account or property that owns the access bindings. The parent field in the CreateAccessBindingRequest messages must either be empty or match this field. Formats: - accounts/{account} - properties/{property}",
	//       "location": "path",
	//       "pattern": "^properties/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1alpha/{+parent}/accessBindings:batchCreate",
	//   "request": {
	//     "$ref": "GoogleAnalyticsAdminV1alphaBatchCreateAccessBindingsRequest"
	//   },
	//   "response": {
	//     "$ref": "GoogleAnalyticsAdminV1alphaBatchCreateAccessBindingsResponse"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/analytics.manage.users"
	//   ]
	// }

}

// method id "analyticsadmin.properties.accessBindings.batchDelete":

type PropertiesAccessBindingsBatchDeleteCall struct {
	s                                                           *Service
	parent                                                      string
	googleanalyticsadminv1alphabatchdeleteaccessbindingsrequest *GoogleAnalyticsAdminV1alphaBatchDeleteAccessBindingsRequest
	urlParams_                                                  gensupport.URLParams
	ctx_                                                        context.Context
	header_                                                     http.Header
}

// BatchDelete: Deletes information about multiple users' links to an
// account or property.
//
//   - parent: The account or property that owns the access bindings. The
//     parent of all provided values for the 'names' field in
//     DeleteAccessBindingRequest messages must match this field. Formats:
//   - accounts/{account} - properties/{property}.
func (r *PropertiesAccessBindingsService) BatchDelete(parent string, googleanalyticsadminv1alphabatchdeleteaccessbindingsrequest *GoogleAnalyticsAdminV1alphaBatchDeleteAccessBindingsRequest) *PropertiesAccessBindingsBatchDeleteCall {
	c := &PropertiesAccessBindingsBatchDeleteCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	c.googleanalyticsadminv1alphabatchdeleteaccessbindingsrequest = googleanalyticsadminv1alphabatchdeleteaccessbindingsrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *PropertiesAccessBindingsBatchDeleteCall) Fields(s ...googleapi.Field) *PropertiesAccessBindingsBatchDeleteCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *PropertiesAccessBindingsBatchDeleteCall) Context(ctx context.Context) *PropertiesAccessBindingsBatchDeleteCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *PropertiesAccessBindingsBatchDeleteCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *PropertiesAccessBindingsBatchDeleteCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.googleanalyticsadminv1alphabatchdeleteaccessbindingsrequest)
	if err != nil {
		return nil, err
	}
	reqHeaders.Set("Content-Type", "application/json")
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1alpha/{+parent}/accessBindings:batchDelete")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "analyticsadmin.properties.accessBindings.batchDelete" call.
// Exactly one of *GoogleProtobufEmpty or error will be non-nil. Any
// non-2xx status code is an error. Response headers are in either
// *GoogleProtobufEmpty.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was
// because http.StatusNotModified was returned.
func (c *PropertiesAccessBindingsBatchDeleteCall) Do(opts ...googleapi.CallOption) (*GoogleProtobufEmpty, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleProtobufEmpty{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Deletes information about multiple users' links to an account or property.",
	//   "flatPath": "v1alpha/properties/{propertiesId}/accessBindings:batchDelete",
	//   "httpMethod": "POST",
	//   "id": "analyticsadmin.properties.accessBindings.batchDelete",
	//   "parameterOrder": [
	//     "parent"
	//   ],
	//   "parameters": {
	//     "parent": {
	//       "description": "Required. The account or property that owns the access bindings. The parent of all provided values for the 'names' field in DeleteAccessBindingRequest messages must match this field. Formats: - accounts/{account} - properties/{property}",
	//       "location": "path",
	//       "pattern": "^properties/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1alpha/{+parent}/accessBindings:batchDelete",
	//   "request": {
	//     "$ref": "GoogleAnalyticsAdminV1alphaBatchDeleteAccessBindingsRequest"
	//   },
	//   "response": {
	//     "$ref": "GoogleProtobufEmpty"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/analytics.manage.users"
	//   ]
	// }

}

// method id "analyticsadmin.properties.accessBindings.batchGet":

type PropertiesAccessBindingsBatchGetCall struct {
	s            *Service
	parent       string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// BatchGet: Gets information about multiple access bindings to an
// account or property.
//
//   - parent: The account or property that owns the access bindings. The
//     parent of all provided values for the 'names' field must match this
//     field. Formats: - accounts/{account} - properties/{property}.
func (r *PropertiesAccessBindingsService) BatchGet(parent string) *PropertiesAccessBindingsBatchGetCall {
	c := &PropertiesAccessBindingsBatchGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	return c
}

// Names sets the optional parameter "names": Required. The names of the
// access bindings to retrieve. A maximum of 1000 access bindings can be
// retrieved in a batch. Formats: -
// accounts/{account}/accessBindings/{accessBinding} -
// properties/{property}/accessBindings/{accessBinding}
func (c *PropertiesAccessBindingsBatchGetCall) Names(names ...string) *PropertiesAccessBindingsBatchGetCall {
	c.urlParams_.SetMulti("names", append([]string{}, names...))
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *PropertiesAccessBindingsBatchGetCall) Fields(s ...googleapi.Field) *PropertiesAccessBindingsBatchGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets the optional parameter which makes the operation
// fail if the object's ETag matches the given value. This is useful for
// getting updates only after the object has changed since the last
// request. Use googleapi.IsNotModified to check whether the response
// error from Do is the result of In-None-Match.
func (c *PropertiesAccessBindingsBatchGetCall) IfNoneMatch(entityTag string) *PropertiesAccessBindingsBatchGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *PropertiesAccessBindingsBatchGetCall) Context(ctx context.Context) *PropertiesAccessBindingsBatchGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *PropertiesAccessBindingsBatchGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *PropertiesAccessBindingsBatchGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1alpha/{+parent}/accessBindings:batchGet")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "analyticsadmin.properties.accessBindings.batchGet" call.
// Exactly one of
// *GoogleAnalyticsAdminV1alphaBatchGetAccessBindingsResponse or error
// will be non-nil. Any non-2xx status code is an error. Response
// headers are in either
// *GoogleAnalyticsAdminV1alphaBatchGetAccessBindingsResponse.ServerRespo
// nse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was
// returned.
func (c *PropertiesAccessBindingsBatchGetCall) Do(opts ...googleapi.CallOption) (*GoogleAnalyticsAdminV1alphaBatchGetAccessBindingsResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleAnalyticsAdminV1alphaBatchGetAccessBindingsResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Gets information about multiple access bindings to an account or property.",
	//   "flatPath": "v1alpha/properties/{propertiesId}/accessBindings:batchGet",
	//   "httpMethod": "GET",
	//   "id": "analyticsadmin.properties.accessBindings.batchGet",
	//   "parameterOrder": [
	//     "parent"
	//   ],
	//   "parameters": {
	//     "names": {
	//       "description": "Required. The names of the access bindings to retrieve. A maximum of 1000 access bindings can be retrieved in a batch. Formats: - accounts/{account}/accessBindings/{accessBinding} - properties/{property}/accessBindings/{accessBinding}",
	//       "location": "query",
	//       "repeated": true,
	//       "type": "string"
	//     },
	//     "parent": {
	//       "description": "Required. The account or property that owns the access bindings. The parent of all provided values for the 'names' field must match this field. Formats: - accounts/{account} - properties/{property}",
	//       "location": "path",
	//       "pattern": "^properties/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1alpha/{+parent}/accessBindings:batchGet",
	//   "response": {
	//     "$ref": "GoogleAnalyticsAdminV1alphaBatchGetAccessBindingsResponse"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/analytics.manage.users",
	//     "https://www.googleapis.com/auth/analytics.manage.users.readonly"
	//   ]
	// }

}

// method id "analyticsadmin.properties.accessBindings.batchUpdate":

type PropertiesAccessBindingsBatchUpdateCall struct {
	s                                                           *Service
	parent                                                      string
	googleanalyticsadminv1alphabatchupdateaccessbindingsrequest *GoogleAnalyticsAdminV1alphaBatchUpdateAccessBindingsRequest
	urlParams_                                                  gensupport.URLParams
	ctx_                                                        context.Context
	header_                                                     http.Header
}

// BatchUpdate: Updates information about multiple access bindings to an
// account or property.
//
//   - parent: The account or property that owns the access bindings. The
//     parent of all provided AccessBinding in UpdateAccessBindingRequest
//     messages must match this field. Formats: - accounts/{account} -
//     properties/{property}.
func (r *PropertiesAccessBindingsService) BatchUpdate(parent string, googleanalyticsadminv1alphabatchupdateaccessbindingsrequest *GoogleAnalyticsAdminV1alphaBatchUpdateAccessBindingsRequest) *PropertiesAccessBindingsBatchUpdateCall {
	c := &PropertiesAccessBindingsBatchUpdateCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	c.googleanalyticsadminv1alphabatchupdateaccessbindingsrequest = googleanalyticsadminv1alphabatchupdateaccessbindingsrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *PropertiesAccessBindingsBatchUpdateCall) Fields(s ...googleapi.Field) *PropertiesAccessBindingsBatchUpdateCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *PropertiesAccessBindingsBatchUpdateCall) Context(ctx context.Context) *PropertiesAccessBindingsBatchUpdateCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *PropertiesAccessBindingsBatchUpdateCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *PropertiesAccessBindingsBatchUpdateCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.googleanalyticsadminv1alphabatchupdateaccessbindingsrequest)
	if err != nil {
		return nil, err
	}
	reqHeaders.Set("Content-Type", "application/json")
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1alpha/{+parent}/accessBindings:batchUpdate")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "analyticsadmin.properties.accessBindings.batchUpdate" call.
// Exactly one of
// *GoogleAnalyticsAdminV1alphaBatchUpdateAccessBindingsResponse or
// error will be non-nil. Any non-2xx status code is an error. Response
// headers are in either
// *GoogleAnalyticsAdminV1alphaBatchUpdateAccessBindingsResponse.ServerRe
// sponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was
// returned.
func (c *PropertiesAccessBindingsBatchUpdateCall) Do(opts ...googleapi.CallOption) (*GoogleAnalyticsAdminV1alphaBatchUpdateAccessBindingsResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleAnalyticsAdminV1alphaBatchUpdateAccessBindingsResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Updates information about multiple access bindings to an account or property.",
	//   "flatPath": "v1alpha/properties/{propertiesId}/accessBindings:batchUpdate",
	//   "httpMethod": "POST",
	//   "id": "analyticsadmin.properties.accessBindings.batchUpdate",
	//   "parameterOrder": [
	//     "parent"
	//   ],
	//   "parameters": {
	//     "parent": {
	//       "description": "Required. The account or property that owns the access bindings. The parent of all provided AccessBinding in UpdateAccessBindingRequest messages must match this field. Formats: - accounts/{account} - properties/{property}",
	//       "location": "path",
	//       "pattern": "^properties/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1alpha/{+parent}/accessBindings:batchUpdate",
	//   "request": {
	//     "$ref": "GoogleAnalyticsAdminV1alphaBatchUpdateAccessBindingsRequest"
	//   },
	//   "response": {
	//     "$ref": "GoogleAnalyticsAdminV1alphaBatchUpdateAccessBindingsResponse"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/analytics.manage.users"
	//   ]
	// }

}

// method id "analyticsadmin.properties.accessBindings.create":

type PropertiesAccessBindingsCreateCall struct {
	s                                        *Service
	parent                                   string
	googleanalyticsadminv1alphaaccessbinding *GoogleAnalyticsAdminV1alphaAccessBinding
	urlParams_                               gensupport.URLParams
	ctx_                                     context.Context
	header_                                  http.Header
}

// Create: Creates an access binding on an account or property.
//
// - parent: Formats: - accounts/{account} - properties/{property}.
func (r *PropertiesAccessBindingsService) Create(parent string, googleanalyticsadminv1alphaaccessbinding *GoogleAnalyticsAdminV1alphaAccessBinding) *PropertiesAccessBindingsCreateCall {
	c := &PropertiesAccessBindingsCreateCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	c.googleanalyticsadminv1alphaaccessbinding = googleanalyticsadminv1alphaaccessbinding
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *PropertiesAccessBindingsCreateCall) Fields(s ...googleapi.Field) *PropertiesAccessBindingsCreateCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *PropertiesAccessBindingsCreateCall) Context(ctx context.Context) *PropertiesAccessBindingsCreateCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *PropertiesAccessBindingsCreateCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *PropertiesAccessBindingsCreateCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.googleanalyticsadminv1alphaaccessbinding)
	if err != nil {
		return nil, err
	}
	reqHeaders.Set("Content-Type", "application/json")
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1alpha/{+parent}/accessBindings")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "analyticsadmin.properties.accessBindings.create" call.
// Exactly one of *GoogleAnalyticsAdminV1alphaAccessBinding or error
// will be non-nil. Any non-2xx status code is an error. Response
// headers are in either
// *GoogleAnalyticsAdminV1alphaAccessBinding.ServerResponse.Header or
// (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was
// returned.
func (c *PropertiesAccessBindingsCreateCall) Do(opts ...googleapi.CallOption) (*GoogleAnalyticsAdminV1alphaAccessBinding, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleAnalyticsAdminV1alphaAccessBinding{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Creates an access binding on an account or property.",
	//   "flatPath": "v1alpha/properties/{propertiesId}/accessBindings",
	//   "httpMethod": "POST",
	//   "id": "analyticsadmin.properties.accessBindings.create",
	//   "parameterOrder": [
	//     "parent"
	//   ],
	//   "parameters": {
	//     "parent": {
	//       "description": "Required. Formats: - accounts/{account} - properties/{property}",
	//       "location": "path",
	//       "pattern": "^properties/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1alpha/{+parent}/accessBindings",
	//   "request": {
	//     "$ref": "GoogleAnalyticsAdminV1alphaAccessBinding"
	//   },
	//   "response": {
	//     "$ref": "GoogleAnalyticsAdminV1alphaAccessBinding"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/analytics.manage.users"
	//   ]
	// }

}

// method id "analyticsadmin.properties.accessBindings.delete":

type PropertiesAccessBindingsDeleteCall struct {
	s          *Service
	name       string
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Delete: Deletes an access binding on an account or property.
//
// - name: Formats: - accounts/{account}/accessBindings/{accessBinding}
//   - properties/{property}/accessBindings/{accessBinding}.
func (r *PropertiesAccessBindingsService) Delete(name string) *PropertiesAccessBindingsDeleteCall {
	c := &PropertiesAccessBindingsDeleteCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *PropertiesAccessBindingsDeleteCall) Fields(s ...googleapi.Field) *PropertiesAccessBindingsDeleteCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *PropertiesAccessBindingsDeleteCall) Context(ctx context.Context) *PropertiesAccessBindingsDeleteCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *PropertiesAccessBindingsDeleteCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *PropertiesAccessBindingsDeleteCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1alpha/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("DELETE", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "analyticsadmin.properties.accessBindings.delete" call.
// Exactly one of *GoogleProtobufEmpty or error will be non-nil. Any
// non-2xx status code is an error. Response headers are in either
// *GoogleProtobufEmpty.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was
// because http.StatusNotModified was returned.
func (c *PropertiesAccessBindingsDeleteCall) Do(opts ...googleapi.CallOption) (*GoogleProtobufEmpty, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleProtobufEmpty{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Deletes an access binding on an account or property.",
	//   "flatPath": "v1alpha/properties/{propertiesId}/accessBindings/{accessBindingsId}",
	//   "httpMethod": "DELETE",
	//   "id": "analyticsadmin.properties.accessBindings.delete",
	//   "parameterOrder": [
	//     "name"
	//   ],
	//   "parameters": {
	//     "name": {
	//       "description": "Required. Formats: - accounts/{account}/accessBindings/{accessBinding} - properties/{property}/accessBindings/{accessBinding}",
	//       "location": "path",
	//       "pattern": "^properties/[^/]+/accessBindings/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1alpha/{+name}",
	//   "response": {
	//     "$ref": "GoogleProtobufEmpty"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/analytics.manage.users"
	//   ]
	// }

}

// method id "analyticsadmin.properties.accessBindings.get":

type PropertiesAccessBindingsGetCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Gets information about an access binding.
//
//   - name: The name of the access binding to retrieve. Formats: -
//     accounts/{account}/accessBindings/{accessBinding} -
//     properties/{property}/accessBindings/{accessBinding}.
func (r *PropertiesAccessBindingsService) Get(name string) *PropertiesAccessBindingsGetCall {
	c := &PropertiesAccessBindingsGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *PropertiesAccessBindingsGetCall) Fields(s ...googleapi.Field) *PropertiesAccessBindingsGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets the optional parameter which makes the operation
// fail if the object's ETag matches the given value. This is useful for
// getting updates only after the object has changed since the last
// request. Use googleapi.IsNotModified to check whether the response
// error from Do is the result of In-None-Match.
func (c *PropertiesAccessBindingsGetCall) IfNoneMatch(entityTag string) *PropertiesAccessBindingsGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *PropertiesAccessBindingsGetCall) Context(ctx context.Context) *PropertiesAccessBindingsGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *PropertiesAccessBindingsGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *PropertiesAccessBindingsGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1alpha/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "analyticsadmin.properties.accessBindings.get" call.
// Exactly one of *GoogleAnalyticsAdminV1alphaAccessBinding or error
// will be non-nil. Any non-2xx status code is an error. Response
// headers are in either
// *GoogleAnalyticsAdminV1alphaAccessBinding.ServerResponse.Header or
// (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was
// returned.
func (c *PropertiesAccessBindingsGetCall) Do(opts ...googleapi.CallOption) (*GoogleAnalyticsAdminV1alphaAccessBinding, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleAnalyticsAdminV1alphaAccessBinding{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Gets information about an access binding.",
	//   "flatPath": "v1alpha/properties/{propertiesId}/accessBindings/{accessBindingsId}",
	//   "httpMethod": "GET",
	//   "id": "analyticsadmin.properties.accessBindings.get",
	//   "parameterOrder": [
	//     "name"
	//   ],
	//   "parameters": {
	//     "name": {
	//       "description": "Required. The name of the access binding to retrieve. Formats: - accounts/{account}/accessBindings/{accessBinding} - properties/{property}/accessBindings/{accessBinding}",
	//       "location": "path",
	//       "pattern": "^properties/[^/]+/accessBindings/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1alpha/{+name}",
	//   "response": {
	//     "$ref": "GoogleAnalyticsAdminV1alphaAccessBinding"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/analytics.manage.users",
	//     "https://www.googleapis.com/auth/analytics.manage.users.readonly"
	//   ]
	// }

}

// method id "analyticsadmin.properties.accessBindings.list":

type PropertiesAccessBindingsListCall struct {
	s            *Service
	parent       string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Lists all access bindings on an account or property.
//
// - parent: Formats: - accounts/{account} - properties/{property}.
func (r *PropertiesAccessBindingsService) List(parent string) *PropertiesAccessBindingsListCall {
	c := &PropertiesAccessBindingsListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	return c
}

// PageSize sets the optional parameter "pageSize": The maximum number
// of access bindings to return. The service may return fewer than this
// value. If unspecified, at most 200 access bindings will be returned.
// The maximum value is 500; values above 500 will be coerced to 500.
func (c *PropertiesAccessBindingsListCall) PageSize(pageSize int64) *PropertiesAccessBindingsListCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": A page token,
// received from a previous `ListAccessBindings` call. Provide this to
// retrieve the subsequent page. When paginating, all other parameters
// provided to `ListAccessBindings` must match the call that provided
// the page token.
func (c *PropertiesAccessBindingsListCall) PageToken(pageToken string) *PropertiesAccessBindingsListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *PropertiesAccessBindingsListCall) Fields(s ...googleapi.Field) *PropertiesAccessBindingsListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets the optional parameter which makes the operation
// fail if the object's ETag matches the given value. This is useful for
// getting updates only after the object has changed since the last
// request. Use googleapi.IsNotModified to check whether the response
// error from Do is the result of In-None-Match.
func (c *PropertiesAccessBindingsListCall) IfNoneMatch(entityTag string) *PropertiesAccessBindingsListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *PropertiesAccessBindingsListCall) Context(ctx context.Context) *PropertiesAccessBindingsListCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *PropertiesAccessBindingsListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *PropertiesAccessBindingsListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1alpha/{+parent}/accessBindings")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "analyticsadmin.properties.accessBindings.list" call.
// Exactly one of *GoogleAnalyticsAdminV1alphaListAccessBindingsResponse
// or error will be non-nil. Any non-2xx status code is an error.
// Response headers are in either
// *GoogleAnalyticsAdminV1alphaListAccessBindingsResponse.ServerResponse.
// Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was
// returned.
func (c *PropertiesAccessBindingsListCall) Do(opts ...googleapi.CallOption) (*GoogleAnalyticsAdminV1alphaListAccessBindingsResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleAnalyticsAdminV1alphaListAccessBindingsResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Lists all access bindings on an account or property.",
	//   "flatPath": "v1alpha/properties/{propertiesId}/accessBindings",
	//   "httpMethod": "GET",
	//   "id": "analyticsadmin.properties.accessBindings.list",
	//   "parameterOrder": [
	//     "parent"
	//   ],
	//   "parameters": {
	//     "pageSize": {
	//       "description": "The maximum number of access bindings to return. The service may return fewer than this value. If unspecified, at most 200 access bindings will be returned. The maximum value is 500; values above 500 will be coerced to 500.",
	//       "format": "int32",
	//       "location": "query",
	//       "type": "integer"
	//     },
	//     "pageToken": {
	//       "description": "A page token, received from a previous `ListAccessBindings` call. Provide this to retrieve the subsequent page. When paginating, all other parameters provided to `ListAccessBindings` must match the call that provided the page token.",
	//       "location": "query",
	//       "type": "string"
	//     },
	//     "parent": {
	//       "description": "Required. Formats: - accounts/{account} - properties/{property}",
	//       "location": "path",
	//       "pattern": "^properties/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1alpha/{+parent}/accessBindings",
	//   "response": {
	//     "$ref": "GoogleAnalyticsAdminV1alphaListAccessBindingsResponse"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/analytics.manage.users",
	//     "https://www.googleapis.com/auth/analytics.manage.users.readonly"
	//   ]
	// }

}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *PropertiesAccessBindingsListCall) Pages(ctx context.Context, f func(*GoogleAnalyticsAdminV1alphaListAccessBindingsResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken")) // reset paging to original point
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

// method id "analyticsadmin.properties.accessBindings.patch":

type PropertiesAccessBindingsPatchCall struct {
	s                                        *Service
	name                                     string
	googleanalyticsadminv1alphaaccessbinding *GoogleAnalyticsAdminV1alphaAccessBinding
	urlParams_                               gensupport.URLParams
	ctx_                                     context.Context
	header_                                  http.Header
}

// Patch: Updates an access binding on an account or property.
//
//   - name: Output only. Resource name of this binding. Format:
//     accounts/{account}/accessBindings/{access_binding} or
//     properties/{property}/accessBindings/{access_binding} Example:
//     "accounts/100/accessBindings/200".
func (r *PropertiesAccessBindingsService) Patch(name string, googleanalyticsadminv1alphaaccessbinding *GoogleAnalyticsAdminV1alphaAccessBinding) *PropertiesAccessBindingsPatchCall {
	c := &PropertiesAccessBindingsPatchCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	c.googleanalyticsadminv1alphaaccessbinding = googleanalyticsadminv1alphaaccessbinding
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *PropertiesAccessBindingsPatchCall) Fields(s ...googleapi.Field) *PropertiesAccessBindingsPatchCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *PropertiesAccessBindingsPatchCall) Context(ctx context.Context) *PropertiesAccessBindingsPatchCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *PropertiesAccessBindingsPatchCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *PropertiesAccessBindingsPatchCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.googleanalyticsadminv1alphaaccessbinding)
	if err != nil {
		return nil, err
	}
	reqHeaders.Set("Content-Type", "application/json")
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1alpha/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("PATCH", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "analyticsadmin.properties.accessBindings.patch" call.
// Exactly one of *GoogleAnalyticsAdminV1alphaAccessBinding or error
// will be non-nil. Any non-2xx status code is an error. Response
// headers are in either
// *GoogleAnalyticsAdminV1alphaAccessBinding.ServerResponse.Header or
// (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was
// returned.
func (c *PropertiesAccessBindingsPatchCall) Do(opts ...googleapi.CallOption) (*GoogleAnalyticsAdminV1alphaAccessBinding, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleAnalyticsAdminV1alphaAccessBinding{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Updates an access binding on an account or property.",
	//   "flatPath": "v1alpha/properties/{propertiesId}/accessBindings/{accessBindingsId}",
	//   "httpMethod": "PATCH",
	//   "id": "analyticsadmin.properties.accessBindings.patch",
	//   "parameterOrder": [
	//     "name"
	//   ],
	//   "parameters": {
	//     "name": {
	//       "description": "Output only. Resource name of this binding. Format: accounts/{account}/accessBindings/{access_binding} or properties/{property}/accessBindings/{access_binding} Example: \"accounts/100/accessBindings/200\"",
	//       "location": "path",
	//       "pattern": "^properties/[^/]+/accessBindings/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1alpha/{+name}",
	//   "request": {
	//     "$ref": "GoogleAnalyticsAdminV1alphaAccessBinding"
	//   },
	//   "response": {
	//     "$ref": "GoogleAnalyticsAdminV1alphaAccessBinding"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/analytics.manage.users"
	//   ]
	// }

}

// method id "analyticsadmin.properties.audiences.archive":

type PropertiesAudiencesArchiveCall struct {
	s                                                 *Service
	name                                              string
	googleanalyticsadminv1alphaarchiveaudiencerequest *GoogleAnalyticsAdminV1alphaArchiveAudienceRequest
	urlParams_                                        gensupport.URLParams
	ctx_                                              context.Context
	header_                                           http.Header
}

// Archive: Archives an Audience on a property.
//
// - name: Example format: properties/1234/audiences/5678.
func (r *PropertiesAudiencesService) Archive(name string, googleanalyticsadminv1alphaarchiveaudiencerequest *GoogleAnalyticsAdminV1alphaArchiveAudienceRequest) *PropertiesAudiencesArchiveCall {
	c := &PropertiesAudiencesArchiveCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	c.googleanalyticsadminv1alphaarchiveaudiencerequest = googleanalyticsadminv1alphaarchiveaudiencerequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *PropertiesAudiencesArchiveCall) Fields(s ...googleapi.Field) *PropertiesAudiencesArchiveCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *PropertiesAudiencesArchiveCall) Context(ctx context.Context) *PropertiesAudiencesArchiveCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *PropertiesAudiencesArchiveCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *PropertiesAudiencesArchiveCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.googleanalyticsadminv1alphaarchiveaudiencerequest)
	if err != nil {
		return nil, err
	}
	reqHeaders.Set("Content-Type", "application/json")
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1alpha/{+name}:archive")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "analyticsadmin.properties.audiences.archive" call.
// Exactly one of *GoogleProtobufEmpty or error will be non-nil. Any
// non-2xx status code is an error. Response headers are in either
// *GoogleProtobufEmpty.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was
// because http.StatusNotModified was returned.
func (c *PropertiesAudiencesArchiveCall) Do(opts ...googleapi.CallOption) (*GoogleProtobufEmpty, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleProtobufEmpty{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Archives an Audience on a property.",
	//   "flatPath": "v1alpha/properties/{propertiesId}/audiences/{audiencesId}:archive",
	//   "httpMethod": "POST",
	//   "id": "analyticsadmin.properties.audiences.archive",
	//   "parameterOrder": [
	//     "name"
	//   ],
	//   "parameters": {
	//     "name": {
	//       "description": "Required. Example format: properties/1234/audiences/5678",
	//       "location": "path",
	//       "pattern": "^properties/[^/]+/audiences/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1alpha/{+name}:archive",
	//   "request": {
	//     "$ref": "GoogleAnalyticsAdminV1alphaArchiveAudienceRequest"
	//   },
	//   "response": {
	//     "$ref": "GoogleProtobufEmpty"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/analytics.edit"
	//   ]
	// }

}

// method id "analyticsadmin.properties.audiences.create":

type PropertiesAudiencesCreateCall struct {
	s                                   *Service
	parent                              string
	googleanalyticsadminv1alphaaudience *GoogleAnalyticsAdminV1alphaAudience
	urlParams_                          gensupport.URLParams
	ctx_                                context.Context
	header_                             http.Header
}

// Create: Creates an Audience.
//
// - parent: Example format: properties/1234.
func (r *PropertiesAudiencesService) Create(parent string, googleanalyticsadminv1alphaaudience *GoogleAnalyticsAdminV1alphaAudience) *PropertiesAudiencesCreateCall {
	c := &PropertiesAudiencesCreateCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	c.googleanalyticsadminv1alphaaudience = googleanalyticsadminv1alphaaudience
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *PropertiesAudiencesCreateCall) Fields(s ...googleapi.Field) *PropertiesAudiencesCreateCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *PropertiesAudiencesCreateCall) Context(ctx context.Context) *PropertiesAudiencesCreateCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *PropertiesAudiencesCreateCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *PropertiesAudiencesCreateCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.googleanalyticsadminv1alphaaudience)
	if err != nil {
		return nil, err
	}
	reqHeaders.Set("Content-Type", "application/json")
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1alpha/{+parent}/audiences")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "analyticsadmin.properties.audiences.create" call.
// Exactly one of *GoogleAnalyticsAdminV1alphaAudience or error will be
// non-nil. Any non-2xx status code is an error. Response headers are in
// either *GoogleAnalyticsAdminV1alphaAudience.ServerResponse.Header or
// (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was
// returned.
func (c *PropertiesAudiencesCreateCall) Do(opts ...googleapi.CallOption) (*GoogleAnalyticsAdminV1alphaAudience, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleAnalyticsAdminV1alphaAudience{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Creates an Audience.",
	//   "flatPath": "v1alpha/properties/{propertiesId}/audiences",
	//   "httpMethod": "POST",
	//   "id": "analyticsadmin.properties.audiences.create",
	//   "parameterOrder": [
	//     "parent"
	//   ],
	//   "parameters": {
	//     "parent": {
	//       "description": "Required. Example format: properties/1234",
	//       "location": "path",
	//       "pattern": "^properties/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1alpha/{+parent}/audiences",
	//   "request": {
	//     "$ref": "GoogleAnalyticsAdminV1alphaAudience"
	//   },
	//   "response": {
	//     "$ref": "GoogleAnalyticsAdminV1alphaAudience"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/analytics.edit"
	//   ]
	// }

}

// method id "analyticsadmin.properties.audiences.get":

type PropertiesAudiencesGetCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Lookup for a single Audience. Audiences created before 2020 may
// not be supported. Default audiences will not show filter definitions.
//
//   - name: The name of the Audience to get. Example format:
//     properties/1234/audiences/5678.
func (r *PropertiesAudiencesService) Get(name string) *PropertiesAudiencesGetCall {
	c := &PropertiesAudiencesGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *PropertiesAudiencesGetCall) Fields(s ...googleapi.Field) *PropertiesAudiencesGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets the optional parameter which makes the operation
// fail if the object's ETag matches the given value. This is useful for
// getting updates only after the object has changed since the last
// request. Use googleapi.IsNotModified to check whether the response
// error from Do is the result of In-None-Match.
func (c *PropertiesAudiencesGetCall) IfNoneMatch(entityTag string) *PropertiesAudiencesGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *PropertiesAudiencesGetCall) Context(ctx context.Context) *PropertiesAudiencesGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *PropertiesAudiencesGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *PropertiesAudiencesGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1alpha/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "analyticsadmin.properties.audiences.get" call.
// Exactly one of *GoogleAnalyticsAdminV1alphaAudience or error will be
// non-nil. Any non-2xx status code is an error. Response headers are in
// either *GoogleAnalyticsAdminV1alphaAudience.ServerResponse.Header or
// (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was
// returned.
func (c *PropertiesAudiencesGetCall) Do(opts ...googleapi.CallOption) (*GoogleAnalyticsAdminV1alphaAudience, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleAnalyticsAdminV1alphaAudience{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Lookup for a single Audience. Audiences created before 2020 may not be supported. Default audiences will not show filter definitions.",
	//   "flatPath": "v1alpha/properties/{propertiesId}/audiences/{audiencesId}",
	//   "httpMethod": "GET",
	//   "id": "analyticsadmin.properties.audiences.get",
	//   "parameterOrder": [
	//     "name"
	//   ],
	//   "parameters": {
	//     "name": {
	//       "description": "Required. The name of the Audience to get. Example format: properties/1234/audiences/5678",
	//       "location": "path",
	//       "pattern": "^properties/[^/]+/audiences/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1alpha/{+name}",
	//   "response": {
	//     "$ref": "GoogleAnalyticsAdminV1alphaAudience"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/analytics.edit",
	//     "https://www.googleapis.com/auth/analytics.readonly"
	//   ]
	// }

}

// method id "analyticsadmin.properties.audiences.list":

type PropertiesAudiencesListCall struct {
	s            *Service
	parent       string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Lists Audiences on a property. Audiences created before 2020
// may not be supported. Default audiences will not show filter
// definitions.
//
// - parent: Example format: properties/1234.
func (r *PropertiesAudiencesService) List(parent string) *PropertiesAudiencesListCall {
	c := &PropertiesAudiencesListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	return c
}

// PageSize sets the optional parameter "pageSize": The maximum number
// of resources to return. If unspecified, at most 50 resources will be
// returned. The maximum value is 200 (higher values will be coerced to
// the maximum).
func (c *PropertiesAudiencesListCall) PageSize(pageSize int64) *PropertiesAudiencesListCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": A page token,
// received from a previous `ListAudiences` call. Provide this to
// retrieve the subsequent page. When paginating, all other parameters
// provided to `ListAudiences` must match the call that provided the
// page token.
func (c *PropertiesAudiencesListCall) PageToken(pageToken string) *PropertiesAudiencesListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *PropertiesAudiencesListCall) Fields(s ...googleapi.Field) *PropertiesAudiencesListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets the optional parameter which makes the operation
// fail if the object's ETag matches the given value. This is useful for
// getting updates only after the object has changed since the last
// request. Use googleapi.IsNotModified to check whether the response
// error from Do is the result of In-None-Match.
func (c *PropertiesAudiencesListCall) IfNoneMatch(entityTag string) *PropertiesAudiencesListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *PropertiesAudiencesListCall) Context(ctx context.Context) *PropertiesAudiencesListCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *PropertiesAudiencesListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *PropertiesAudiencesListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1alpha/{+parent}/audiences")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "analyticsadmin.properties.audiences.list" call.
// Exactly one of *GoogleAnalyticsAdminV1alphaListAudiencesResponse or
// error will be non-nil. Any non-2xx status code is an error. Response
// headers are in either
// *GoogleAnalyticsAdminV1alphaListAudiencesResponse.ServerResponse.Heade
// r or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was
// returned.
func (c *PropertiesAudiencesListCall) Do(opts ...googleapi.CallOption) (*GoogleAnalyticsAdminV1alphaListAudiencesResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleAnalyticsAdminV1alphaListAudiencesResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Lists Audiences on a property. Audiences created before 2020 may not be supported. Default audiences will not show filter definitions.",
	//   "flatPath": "v1alpha/properties/{propertiesId}/audiences",
	//   "httpMethod": "GET",
	//   "id": "analyticsadmin.properties.audiences.list",
	//   "parameterOrder": [
	//     "parent"
	//   ],
	//   "parameters": {
	//     "pageSize": {
	//       "description": "The maximum number of resources to return. If unspecified, at most 50 resources will be returned. The maximum value is 200 (higher values will be coerced to the maximum).",
	//       "format": "int32",
	//       "location": "query",
	//       "type": "integer"
	//     },
	//     "pageToken": {
	//       "description": "A page token, received from a previous `ListAudiences` call. Provide this to retrieve the subsequent page. When paginating, all other parameters provided to `ListAudiences` must match the call that provided the page token.",
	//       "location": "query",
	//       "type": "string"
	//     },
	//     "parent": {
	//       "description": "Required. Example format: properties/1234",
	//       "location": "path",
	//       "pattern": "^properties/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1alpha/{+parent}/audiences",
	//   "response": {
	//     "$ref": "GoogleAnalyticsAdminV1alphaListAudiencesResponse"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/analytics.edit",
	//     "https://www.googleapis.com/auth/analytics.readonly"
	//   ]
	// }

}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *PropertiesAudiencesListCall) Pages(ctx context.Context, f func(*GoogleAnalyticsAdminV1alphaListAudiencesResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken")) // reset paging to original point
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

// method id "analyticsadmin.properties.audiences.patch":

type PropertiesAudiencesPatchCall struct {
	s                                   *Service
	name                                string
	googleanalyticsadminv1alphaaudience *GoogleAnalyticsAdminV1alphaAudience
	urlParams_                          gensupport.URLParams
	ctx_                                context.Context
	header_                             http.Header
}

// Patch: Updates an Audience on a property.
//
//   - name: Output only. The resource name for this Audience resource.
//     Format: properties/{propertyId}/audiences/{audienceId}.
func (r *PropertiesAudiencesService) Patch(name string, googleanalyticsadminv1alphaaudience *GoogleAnalyticsAdminV1alphaAudience) *PropertiesAudiencesPatchCall {
	c := &PropertiesAudiencesPatchCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	c.googleanalyticsadminv1alphaaudience = googleanalyticsadminv1alphaaudience
	return c
}

// UpdateMask sets the optional parameter "updateMask": Required. The
// list of fields to be updated. Field names must be in snake case
// (e.g., "field_to_update"). Omitted fields will not be updated. To
// replace the entire entity, use one path with the string "*" to match
// all fields.
func (c *PropertiesAudiencesPatchCall) UpdateMask(updateMask string) *PropertiesAudiencesPatchCall {
	c.urlParams_.Set("updateMask", updateMask)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *PropertiesAudiencesPatchCall) Fields(s ...googleapi.Field) *PropertiesAudiencesPatchCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *PropertiesAudiencesPatchCall) Context(ctx context.Context) *PropertiesAudiencesPatchCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *PropertiesAudiencesPatchCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *PropertiesAudiencesPatchCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.googleanalyticsadminv1alphaaudience)
	if err != nil {
		return nil, err
	}
	reqHeaders.Set("Content-Type", "application/json")
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1alpha/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("PATCH", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "analyticsadmin.properties.audiences.patch" call.
// Exactly one of *GoogleAnalyticsAdminV1alphaAudience or error will be
// non-nil. Any non-2xx status code is an error. Response headers are in
// either *GoogleAnalyticsAdminV1alphaAudience.ServerResponse.Header or
// (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was
// returned.
func (c *PropertiesAudiencesPatchCall) Do(opts ...googleapi.CallOption) (*GoogleAnalyticsAdminV1alphaAudience, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleAnalyticsAdminV1alphaAudience{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Updates an Audience on a property.",
	//   "flatPath": "v1alpha/properties/{propertiesId}/audiences/{audiencesId}",
	//   "httpMethod": "PATCH",
	//   "id": "analyticsadmin.properties.audiences.patch",
	//   "parameterOrder": [
	//     "name"
	//   ],
	//   "parameters": {
	//     "name": {
	//       "description": "Output only. The resource name for this Audience resource. Format: properties/{propertyId}/audiences/{audienceId}",
	//       "location": "path",
	//       "pattern": "^properties/[^/]+/audiences/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     },
	//     "updateMask": {
	//       "description": "Required. The list of fields to be updated. Field names must be in snake case (e.g., \"field_to_update\"). Omitted fields will not be updated. To replace the entire entity, use one path with the string \"*\" to match all fields.",
	//       "format": "google-fieldmask",
	//       "location": "query",
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1alpha/{+name}",
	//   "request": {
	//     "$ref": "GoogleAnalyticsAdminV1alphaAudience"
	//   },
	//   "response": {
	//     "$ref": "GoogleAnalyticsAdminV1alphaAudience"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/analytics.edit"
	//   ]
	// }

}

// method id "analyticsadmin.properties.bigQueryLinks.get":

type PropertiesBigQueryLinksGetCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Lookup for a single BigQuery Link.
//
//   - name: The name of the BigQuery link to lookup. Format:
//     properties/{property_id}/bigQueryLinks/{bigquery_link_id} Example:
//     properties/123/bigQueryLinks/456.
func (r *PropertiesBigQueryLinksService) Get(name string) *PropertiesBigQueryLinksGetCall {
	c := &PropertiesBigQueryLinksGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *PropertiesBigQueryLinksGetCall) Fields(s ...googleapi.Field) *PropertiesBigQueryLinksGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets the optional parameter which makes the operation
// fail if the object's ETag matches the given value. This is useful for
// getting updates only after the object has changed since the last
// request. Use googleapi.IsNotModified to check whether the response
// error from Do is the result of In-None-Match.
func (c *PropertiesBigQueryLinksGetCall) IfNoneMatch(entityTag string) *PropertiesBigQueryLinksGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *PropertiesBigQueryLinksGetCall) Context(ctx context.Context) *PropertiesBigQueryLinksGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *PropertiesBigQueryLinksGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *PropertiesBigQueryLinksGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1alpha/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "analyticsadmin.properties.bigQueryLinks.get" call.
// Exactly one of *GoogleAnalyticsAdminV1alphaBigQueryLink or error will
// be non-nil. Any non-2xx status code is an error. Response headers are
// in either
// *GoogleAnalyticsAdminV1alphaBigQueryLink.ServerResponse.Header or (if
// a response was returned at all) in error.(*googleapi.Error).Header.
// Use googleapi.IsNotModified to check whether the returned error was
// because http.StatusNotModified was returned.
func (c *PropertiesBigQueryLinksGetCall) Do(opts ...googleapi.CallOption) (*GoogleAnalyticsAdminV1alphaBigQueryLink, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleAnalyticsAdminV1alphaBigQueryLink{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Lookup for a single BigQuery Link.",
	//   "flatPath": "v1alpha/properties/{propertiesId}/bigQueryLinks/{bigQueryLinksId}",
	//   "httpMethod": "GET",
	//   "id": "analyticsadmin.properties.bigQueryLinks.get",
	//   "parameterOrder": [
	//     "name"
	//   ],
	//   "parameters": {
	//     "name": {
	//       "description": "Required. The name of the BigQuery link to lookup. Format: properties/{property_id}/bigQueryLinks/{bigquery_link_id} Example: properties/123/bigQueryLinks/456",
	//       "location": "path",
	//       "pattern": "^properties/[^/]+/bigQueryLinks/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1alpha/{+name}",
	//   "response": {
	//     "$ref": "GoogleAnalyticsAdminV1alphaBigQueryLink"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/analytics.edit",
	//     "https://www.googleapis.com/auth/analytics.readonly"
	//   ]
	// }

}

// method id "analyticsadmin.properties.bigQueryLinks.list":

type PropertiesBigQueryLinksListCall struct {
	s            *Service
	parent       string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Lists BigQuery Links on a property.
//
//   - parent: The name of the property to list BigQuery links under.
//     Format: properties/{property_id} Example: properties/1234.
func (r *PropertiesBigQueryLinksService) List(parent string) *PropertiesBigQueryLinksListCall {
	c := &PropertiesBigQueryLinksListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	return c
}

// PageSize sets the optional parameter "pageSize": The maximum number
// of resources to return. The service may return fewer than this value,
// even if there are additional pages. If unspecified, at most 50
// resources will be returned. The maximum value is 200; (higher values
// will be coerced to the maximum)
func (c *PropertiesBigQueryLinksListCall) PageSize(pageSize int64) *PropertiesBigQueryLinksListCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": A page token,
// received from a previous `ListBigQueryLinks` call. Provide this to
// retrieve the subsequent page. When paginating, all other parameters
// provided to `ListBigQueryLinks` must match the call that provided the
// page token.
func (c *PropertiesBigQueryLinksListCall) PageToken(pageToken string) *PropertiesBigQueryLinksListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *PropertiesBigQueryLinksListCall) Fields(s ...googleapi.Field) *PropertiesBigQueryLinksListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets the optional parameter which makes the operation
// fail if the object's ETag matches the given value. This is useful for
// getting updates only after the object has changed since the last
// request. Use googleapi.IsNotModified to check whether the response
// error from Do is the result of In-None-Match.
func (c *PropertiesBigQueryLinksListCall) IfNoneMatch(entityTag string) *PropertiesBigQueryLinksListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *PropertiesBigQueryLinksListCall) Context(ctx context.Context) *PropertiesBigQueryLinksListCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *PropertiesBigQueryLinksListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *PropertiesBigQueryLinksListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1alpha/{+parent}/bigQueryLinks")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "analyticsadmin.properties.bigQueryLinks.list" call.
// Exactly one of *GoogleAnalyticsAdminV1alphaListBigQueryLinksResponse
// or error will be non-nil. Any non-2xx status code is an error.
// Response headers are in either
// *GoogleAnalyticsAdminV1alphaListBigQueryLinksResponse.ServerResponse.H
// eader or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was
// returned.
func (c *PropertiesBigQueryLinksListCall) Do(opts ...googleapi.CallOption) (*GoogleAnalyticsAdminV1alphaListBigQueryLinksResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleAnalyticsAdminV1alphaListBigQueryLinksResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Lists BigQuery Links on a property.",
	//   "flatPath": "v1alpha/properties/{propertiesId}/bigQueryLinks",
	//   "httpMethod": "GET",
	//   "id": "analyticsadmin.properties.bigQueryLinks.list",
	//   "parameterOrder": [
	//     "parent"
	//   ],
	//   "parameters": {
	//     "pageSize": {
	//       "description": "The maximum number of resources to return. The service may return fewer than this value, even if there are additional pages. If unspecified, at most 50 resources will be returned. The maximum value is 200; (higher values will be coerced to the maximum)",
	//       "format": "int32",
	//       "location": "query",
	//       "type": "integer"
	//     },
	//     "pageToken": {
	//       "description": "A page token, received from a previous `ListBigQueryLinks` call. Provide this to retrieve the subsequent page. When paginating, all other parameters provided to `ListBigQueryLinks` must match the call that provided the page token.",
	//       "location": "query",
	//       "type": "string"
	//     },
	//     "parent": {
	//       "description": "Required. The name of the property to list BigQuery links under. Format: properties/{property_id} Example: properties/1234",
	//       "location": "path",
	//       "pattern": "^properties/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1alpha/{+parent}/bigQueryLinks",
	//   "response": {
	//     "$ref": "GoogleAnalyticsAdminV1alphaListBigQueryLinksResponse"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/analytics.edit",
	//     "https://www.googleapis.com/auth/analytics.readonly"
	//   ]
	// }

}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *PropertiesBigQueryLinksListCall) Pages(ctx context.Context, f func(*GoogleAnalyticsAdminV1alphaListBigQueryLinksResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken")) // reset paging to original point
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

// method id "analyticsadmin.properties.channelGroups.create":

type PropertiesChannelGroupsCreateCall struct {
	s                                       *Service
	parent                                  string
	googleanalyticsadminv1alphachannelgroup *GoogleAnalyticsAdminV1alphaChannelGroup
	urlParams_                              gensupport.URLParams
	ctx_                                    context.Context
	header_                                 http.Header
}

// Create: Creates a ChannelGroup.
//
//   - parent: The property for which to create a ChannelGroup. Example
//     format: properties/1234.
func (r *PropertiesChannelGroupsService) Create(parent string, googleanalyticsadminv1alphachannelgroup *GoogleAnalyticsAdminV1alphaChannelGroup) *PropertiesChannelGroupsCreateCall {
	c := &PropertiesChannelGroupsCreateCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	c.googleanalyticsadminv1alphachannelgroup = googleanalyticsadminv1alphachannelgroup
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *PropertiesChannelGroupsCreateCall) Fields(s ...googleapi.Field) *PropertiesChannelGroupsCreateCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *PropertiesChannelGroupsCreateCall) Context(ctx context.Context) *PropertiesChannelGroupsCreateCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *PropertiesChannelGroupsCreateCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *PropertiesChannelGroupsCreateCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.googleanalyticsadminv1alphachannelgroup)
	if err != nil {
		return nil, err
	}
	reqHeaders.Set("Content-Type", "application/json")
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1alpha/{+parent}/channelGroups")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "analyticsadmin.properties.channelGroups.create" call.
// Exactly one of *GoogleAnalyticsAdminV1alphaChannelGroup or error will
// be non-nil. Any non-2xx status code is an error. Response headers are
// in either
// *GoogleAnalyticsAdminV1alphaChannelGroup.ServerResponse.Header or (if
// a response was returned at all) in error.(*googleapi.Error).Header.
// Use googleapi.IsNotModified to check whether the returned error was
// because http.StatusNotModified was returned.
func (c *PropertiesChannelGroupsCreateCall) Do(opts ...googleapi.CallOption) (*GoogleAnalyticsAdminV1alphaChannelGroup, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleAnalyticsAdminV1alphaChannelGroup{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Creates a ChannelGroup.",
	//   "flatPath": "v1alpha/properties/{propertiesId}/channelGroups",
	//   "httpMethod": "POST",
	//   "id": "analyticsadmin.properties.channelGroups.create",
	//   "parameterOrder": [
	//     "parent"
	//   ],
	//   "parameters": {
	//     "parent": {
	//       "description": "Required. The property for which to create a ChannelGroup. Example format: properties/1234",
	//       "location": "path",
	//       "pattern": "^properties/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1alpha/{+parent}/channelGroups",
	//   "request": {
	//     "$ref": "GoogleAnalyticsAdminV1alphaChannelGroup"
	//   },
	//   "response": {
	//     "$ref": "GoogleAnalyticsAdminV1alphaChannelGroup"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/analytics.edit"
	//   ]
	// }

}

// method id "analyticsadmin.properties.channelGroups.delete":

type PropertiesChannelGroupsDeleteCall struct {
	s          *Service
	name       string
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Delete: Deletes a ChannelGroup on a property.
//
//   - name: The ChannelGroup to delete. Example format:
//     properties/1234/channelGroups/5678.
func (r *PropertiesChannelGroupsService) Delete(name string) *PropertiesChannelGroupsDeleteCall {
	c := &PropertiesChannelGroupsDeleteCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *PropertiesChannelGroupsDeleteCall) Fields(s ...googleapi.Field) *PropertiesChannelGroupsDeleteCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *PropertiesChannelGroupsDeleteCall) Context(ctx context.Context) *PropertiesChannelGroupsDeleteCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *PropertiesChannelGroupsDeleteCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *PropertiesChannelGroupsDeleteCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1alpha/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("DELETE", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "analyticsadmin.properties.channelGroups.delete" call.
// Exactly one of *GoogleProtobufEmpty or error will be non-nil. Any
// non-2xx status code is an error. Response headers are in either
// *GoogleProtobufEmpty.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was
// because http.StatusNotModified was returned.
func (c *PropertiesChannelGroupsDeleteCall) Do(opts ...googleapi.CallOption) (*GoogleProtobufEmpty, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleProtobufEmpty{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Deletes a ChannelGroup on a property.",
	//   "flatPath": "v1alpha/properties/{propertiesId}/channelGroups/{channelGroupsId}",
	//   "httpMethod": "DELETE",
	//   "id": "analyticsadmin.properties.channelGroups.delete",
	//   "parameterOrder": [
	//     "name"
	//   ],
	//   "parameters": {
	//     "name": {
	//       "description": "Required. The ChannelGroup to delete. Example format: properties/1234/channelGroups/5678",
	//       "location": "path",
	//       "pattern": "^properties/[^/]+/channelGroups/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1alpha/{+name}",
	//   "response": {
	//     "$ref": "GoogleProtobufEmpty"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/analytics.edit"
	//   ]
	// }

}

// method id "analyticsadmin.properties.channelGroups.get":

type PropertiesChannelGroupsGetCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Lookup for a single ChannelGroup.
//
//   - name: The ChannelGroup to get. Example format:
//     properties/1234/channelGroups/5678.
func (r *PropertiesChannelGroupsService) Get(name string) *PropertiesChannelGroupsGetCall {
	c := &PropertiesChannelGroupsGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *PropertiesChannelGroupsGetCall) Fields(s ...googleapi.Field) *PropertiesChannelGroupsGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets the optional parameter which makes the operation
// fail if the object's ETag matches the given value. This is useful for
// getting updates only after the object has changed since the last
// request. Use googleapi.IsNotModified to check whether the response
// error from Do is the result of In-None-Match.
func (c *PropertiesChannelGroupsGetCall) IfNoneMatch(entityTag string) *PropertiesChannelGroupsGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *PropertiesChannelGroupsGetCall) Context(ctx context.Context) *PropertiesChannelGroupsGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *PropertiesChannelGroupsGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *PropertiesChannelGroupsGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1alpha/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "analyticsadmin.properties.channelGroups.get" call.
// Exactly one of *GoogleAnalyticsAdminV1alphaChannelGroup or error will
// be non-nil. Any non-2xx status code is an error. Response headers are
// in either
// *GoogleAnalyticsAdminV1alphaChannelGroup.ServerResponse.Header or (if
// a response was returned at all) in error.(*googleapi.Error).Header.
// Use googleapi.IsNotModified to check whether the returned error was
// because http.StatusNotModified was returned.
func (c *PropertiesChannelGroupsGetCall) Do(opts ...googleapi.CallOption) (*GoogleAnalyticsAdminV1alphaChannelGroup, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleAnalyticsAdminV1alphaChannelGroup{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Lookup for a single ChannelGroup.",
	//   "flatPath": "v1alpha/properties/{propertiesId}/channelGroups/{channelGroupsId}",
	//   "httpMethod": "GET",
	//   "id": "analyticsadmin.properties.channelGroups.get",
	//   "parameterOrder": [
	//     "name"
	//   ],
	//   "parameters": {
	//     "name": {
	//       "description": "Required. The ChannelGroup to get. Example format: properties/1234/channelGroups/5678",
	//       "location": "path",
	//       "pattern": "^properties/[^/]+/channelGroups/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1alpha/{+name}",
	//   "response": {
	//     "$ref": "GoogleAnalyticsAdminV1alphaChannelGroup"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/analytics.edit",
	//     "https://www.googleapis.com/auth/analytics.readonly"
	//   ]
	// }

}

// method id "analyticsadmin.properties.channelGroups.list":

type PropertiesChannelGroupsListCall struct {
	s            *Service
	parent       string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Lists ChannelGroups on a property.
//
//   - parent: The property for which to list ChannelGroups. Example
//     format: properties/1234.
func (r *PropertiesChannelGroupsService) List(parent string) *PropertiesChannelGroupsListCall {
	c := &PropertiesChannelGroupsListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	return c
}

// PageSize sets the optional parameter "pageSize": The maximum number
// of resources to return. If unspecified, at most 50 resources will be
// returned. The maximum value is 200 (higher values will be coerced to
// the maximum).
func (c *PropertiesChannelGroupsListCall) PageSize(pageSize int64) *PropertiesChannelGroupsListCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": A page token,
// received from a previous `ListChannelGroups` call. Provide this to
// retrieve the subsequent page. When paginating, all other parameters
// provided to `ListChannelGroups` must match the call that provided the
// page token.
func (c *PropertiesChannelGroupsListCall) PageToken(pageToken string) *PropertiesChannelGroupsListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *PropertiesChannelGroupsListCall) Fields(s ...googleapi.Field) *PropertiesChannelGroupsListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets the optional parameter which makes the operation
// fail if the object's ETag matches the given value. This is useful for
// getting updates only after the object has changed since the last
// request. Use googleapi.IsNotModified to check whether the response
// error from Do is the result of In-None-Match.
func (c *PropertiesChannelGroupsListCall) IfNoneMatch(entityTag string) *PropertiesChannelGroupsListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *PropertiesChannelGroupsListCall) Context(ctx context.Context) *PropertiesChannelGroupsListCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *PropertiesChannelGroupsListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *PropertiesChannelGroupsListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1alpha/{+parent}/channelGroups")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "analyticsadmin.properties.channelGroups.list" call.
// Exactly one of *GoogleAnalyticsAdminV1alphaListChannelGroupsResponse
// or error will be non-nil. Any non-2xx status code is an error.
// Response headers are in either
// *GoogleAnalyticsAdminV1alphaListChannelGroupsResponse.ServerResponse.H
// eader or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was
// returned.
func (c *PropertiesChannelGroupsListCall) Do(opts ...googleapi.CallOption) (*GoogleAnalyticsAdminV1alphaListChannelGroupsResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleAnalyticsAdminV1alphaListChannelGroupsResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Lists ChannelGroups on a property.",
	//   "flatPath": "v1alpha/properties/{propertiesId}/channelGroups",
	//   "httpMethod": "GET",
	//   "id": "analyticsadmin.properties.channelGroups.list",
	//   "parameterOrder": [
	//     "parent"
	//   ],
	//   "parameters": {
	//     "pageSize": {
	//       "description": "The maximum number of resources to return. If unspecified, at most 50 resources will be returned. The maximum value is 200 (higher values will be coerced to the maximum).",
	//       "format": "int32",
	//       "location": "query",
	//       "type": "integer"
	//     },
	//     "pageToken": {
	//       "description": "A page token, received from a previous `ListChannelGroups` call. Provide this to retrieve the subsequent page. When paginating, all other parameters provided to `ListChannelGroups` must match the call that provided the page token.",
	//       "location": "query",
	//       "type": "string"
	//     },
	//     "parent": {
	//       "description": "Required. The property for which to list ChannelGroups. Example format: properties/1234",
	//       "location": "path",
	//       "pattern": "^properties/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1alpha/{+parent}/channelGroups",
	//   "response": {
	//     "$ref": "GoogleAnalyticsAdminV1alphaListChannelGroupsResponse"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/analytics.edit",
	//     "https://www.googleapis.com/auth/analytics.readonly"
	//   ]
	// }

}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *PropertiesChannelGroupsListCall) Pages(ctx context.Context, f func(*GoogleAnalyticsAdminV1alphaListChannelGroupsResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken")) // reset paging to original point
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

// method id "analyticsadmin.properties.channelGroups.patch":

type PropertiesChannelGroupsPatchCall struct {
	s                                       *Service
	name                                    string
	googleanalyticsadminv1alphachannelgroup *GoogleAnalyticsAdminV1alphaChannelGroup
	urlParams_                              gensupport.URLParams
	ctx_                                    context.Context
	header_                                 http.Header
}

// Patch: Updates a ChannelGroup.
//
//   - name: Output only. The resource name for this Channel Group
//     resource. Format:
//     properties/{property}/channelGroups/{channel_group}.
func (r *PropertiesChannelGroupsService) Patch(name string, googleanalyticsadminv1alphachannelgroup *GoogleAnalyticsAdminV1alphaChannelGroup) *PropertiesChannelGroupsPatchCall {
	c := &PropertiesChannelGroupsPatchCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	c.googleanalyticsadminv1alphachannelgroup = googleanalyticsadminv1alphachannelgroup
	return c
}

// UpdateMask sets the optional parameter "updateMask": Required. The
// list of fields to be updated. Field names must be in snake case
// (e.g., "field_to_update"). Omitted fields will not be updated. To
// replace the entire entity, use one path with the string "*" to match
// all fields.
func (c *PropertiesChannelGroupsPatchCall) UpdateMask(updateMask string) *PropertiesChannelGroupsPatchCall {
	c.urlParams_.Set("updateMask", updateMask)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *PropertiesChannelGroupsPatchCall) Fields(s ...googleapi.Field) *PropertiesChannelGroupsPatchCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *PropertiesChannelGroupsPatchCall) Context(ctx context.Context) *PropertiesChannelGroupsPatchCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *PropertiesChannelGroupsPatchCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *PropertiesChannelGroupsPatchCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.googleanalyticsadminv1alphachannelgroup)
	if err != nil {
		return nil, err
	}
	reqHeaders.Set("Content-Type", "application/json")
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1alpha/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("PATCH", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "analyticsadmin.properties.channelGroups.patch" call.
// Exactly one of *GoogleAnalyticsAdminV1alphaChannelGroup or error will
// be non-nil. Any non-2xx status code is an error. Response headers are
// in either
// *GoogleAnalyticsAdminV1alphaChannelGroup.ServerResponse.Header or (if
// a response was returned at all) in error.(*googleapi.Error).Header.
// Use googleapi.IsNotModified to check whether the returned error was
// because http.StatusNotModified was returned.
func (c *PropertiesChannelGroupsPatchCall) Do(opts ...googleapi.CallOption) (*GoogleAnalyticsAdminV1alphaChannelGroup, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleAnalyticsAdminV1alphaChannelGroup{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Updates a ChannelGroup.",
	//   "flatPath": "v1alpha/properties/{propertiesId}/channelGroups/{channelGroupsId}",
	//   "httpMethod": "PATCH",
	//   "id": "analyticsadmin.properties.channelGroups.patch",
	//   "parameterOrder": [
	//     "name"
	//   ],
	//   "parameters": {
	//     "name": {
	//       "description": "Output only. The resource name for this Channel Group resource. Format: properties/{property}/channelGroups/{channel_group}",
	//       "location": "path",
	//       "pattern": "^properties/[^/]+/channelGroups/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     },
	//     "updateMask": {
	//       "description": "Required. The list of fields to be updated. Field names must be in snake case (e.g., \"field_to_update\"). Omitted fields will not be updated. To replace the entire entity, use one path with the string \"*\" to match all fields.",
	//       "format": "google-fieldmask",
	//       "location": "query",
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1alpha/{+name}",
	//   "request": {
	//     "$ref": "GoogleAnalyticsAdminV1alphaChannelGroup"
	//   },
	//   "response": {
	//     "$ref": "GoogleAnalyticsAdminV1alphaChannelGroup"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/analytics.edit"
	//   ]
	// }

}

// method id "analyticsadmin.properties.conversionEvents.create":

type PropertiesConversionEventsCreateCall struct {
	s                                          *Service
	parent                                     string
	googleanalyticsadminv1alphaconversionevent *GoogleAnalyticsAdminV1alphaConversionEvent
	urlParams_                                 gensupport.URLParams
	ctx_                                       context.Context
	header_                                    http.Header
}

// Create: Creates a conversion event with the specified attributes.
//
//   - parent: The resource name of the parent property where this
//     conversion event will be created. Format: properties/123.
func (r *PropertiesConversionEventsService) Create(parent string, googleanalyticsadminv1alphaconversionevent *GoogleAnalyticsAdminV1alphaConversionEvent) *PropertiesConversionEventsCreateCall {
	c := &PropertiesConversionEventsCreateCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	c.googleanalyticsadminv1alphaconversionevent = googleanalyticsadminv1alphaconversionevent
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *PropertiesConversionEventsCreateCall) Fields(s ...googleapi.Field) *PropertiesConversionEventsCreateCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *PropertiesConversionEventsCreateCall) Context(ctx context.Context) *PropertiesConversionEventsCreateCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *PropertiesConversionEventsCreateCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *PropertiesConversionEventsCreateCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.googleanalyticsadminv1alphaconversionevent)
	if err != nil {
		return nil, err
	}
	reqHeaders.Set("Content-Type", "application/json")
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1alpha/{+parent}/conversionEvents")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "analyticsadmin.properties.conversionEvents.create" call.
// Exactly one of *GoogleAnalyticsAdminV1alphaConversionEvent or error
// will be non-nil. Any non-2xx status code is an error. Response
// headers are in either
// *GoogleAnalyticsAdminV1alphaConversionEvent.ServerResponse.Header or
// (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was
// returned.
func (c *PropertiesConversionEventsCreateCall) Do(opts ...googleapi.CallOption) (*GoogleAnalyticsAdminV1alphaConversionEvent, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleAnalyticsAdminV1alphaConversionEvent{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Creates a conversion event with the specified attributes.",
	//   "flatPath": "v1alpha/properties/{propertiesId}/conversionEvents",
	//   "httpMethod": "POST",
	//   "id": "analyticsadmin.properties.conversionEvents.create",
	//   "parameterOrder": [
	//     "parent"
	//   ],
	//   "parameters": {
	//     "parent": {
	//       "description": "Required. The resource name of the parent property where this conversion event will be created. Format: properties/123",
	//       "location": "path",
	//       "pattern": "^properties/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1alpha/{+parent}/conversionEvents",
	//   "request": {
	//     "$ref": "GoogleAnalyticsAdminV1alphaConversionEvent"
	//   },
	//   "response": {
	//     "$ref": "GoogleAnalyticsAdminV1alphaConversionEvent"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/analytics.edit"
	//   ]
	// }

}

// method id "analyticsadmin.properties.conversionEvents.delete":

type PropertiesConversionEventsDeleteCall struct {
	s          *Service
	name       string
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Delete: Deletes a conversion event in a property.
//
//   - name: The resource name of the conversion event to delete. Format:
//     properties/{property}/conversionEvents/{conversion_event} Example:
//     "properties/123/conversionEvents/456".
func (r *PropertiesConversionEventsService) Delete(name string) *PropertiesConversionEventsDeleteCall {
	c := &PropertiesConversionEventsDeleteCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *PropertiesConversionEventsDeleteCall) Fields(s ...googleapi.Field) *PropertiesConversionEventsDeleteCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *PropertiesConversionEventsDeleteCall) Context(ctx context.Context) *PropertiesConversionEventsDeleteCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *PropertiesConversionEventsDeleteCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *PropertiesConversionEventsDeleteCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1alpha/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("DELETE", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "analyticsadmin.properties.conversionEvents.delete" call.
// Exactly one of *GoogleProtobufEmpty or error will be non-nil. Any
// non-2xx status code is an error. Response headers are in either
// *GoogleProtobufEmpty.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was
// because http.StatusNotModified was returned.
func (c *PropertiesConversionEventsDeleteCall) Do(opts ...googleapi.CallOption) (*GoogleProtobufEmpty, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleProtobufEmpty{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Deletes a conversion event in a property.",
	//   "flatPath": "v1alpha/properties/{propertiesId}/conversionEvents/{conversionEventsId}",
	//   "httpMethod": "DELETE",
	//   "id": "analyticsadmin.properties.conversionEvents.delete",
	//   "parameterOrder": [
	//     "name"
	//   ],
	//   "parameters": {
	//     "name": {
	//       "description": "Required. The resource name of the conversion event to delete. Format: properties/{property}/conversionEvents/{conversion_event} Example: \"properties/123/conversionEvents/456\"",
	//       "location": "path",
	//       "pattern": "^properties/[^/]+/conversionEvents/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1alpha/{+name}",
	//   "response": {
	//     "$ref": "GoogleProtobufEmpty"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/analytics.edit"
	//   ]
	// }

}

// method id "analyticsadmin.properties.conversionEvents.get":

type PropertiesConversionEventsGetCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Retrieve a single conversion event.
//
//   - name: The resource name of the conversion event to retrieve.
//     Format: properties/{property}/conversionEvents/{conversion_event}
//     Example: "properties/123/conversionEvents/456".
func (r *PropertiesConversionEventsService) Get(name string) *PropertiesConversionEventsGetCall {
	c := &PropertiesConversionEventsGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *PropertiesConversionEventsGetCall) Fields(s ...googleapi.Field) *PropertiesConversionEventsGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets the optional parameter which makes the operation
// fail if the object's ETag matches the given value. This is useful for
// getting updates only after the object has changed since the last
// request. Use googleapi.IsNotModified to check whether the response
// error from Do is the result of In-None-Match.
func (c *PropertiesConversionEventsGetCall) IfNoneMatch(entityTag string) *PropertiesConversionEventsGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *PropertiesConversionEventsGetCall) Context(ctx context.Context) *PropertiesConversionEventsGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *PropertiesConversionEventsGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *PropertiesConversionEventsGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1alpha/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "analyticsadmin.properties.conversionEvents.get" call.
// Exactly one of *GoogleAnalyticsAdminV1alphaConversionEvent or error
// will be non-nil. Any non-2xx status code is an error. Response
// headers are in either
// *GoogleAnalyticsAdminV1alphaConversionEvent.ServerResponse.Header or
// (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was
// returned.
func (c *PropertiesConversionEventsGetCall) Do(opts ...googleapi.CallOption) (*GoogleAnalyticsAdminV1alphaConversionEvent, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleAnalyticsAdminV1alphaConversionEvent{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Retrieve a single conversion event.",
	//   "flatPath": "v1alpha/properties/{propertiesId}/conversionEvents/{conversionEventsId}",
	//   "httpMethod": "GET",
	//   "id": "analyticsadmin.properties.conversionEvents.get",
	//   "parameterOrder": [
	//     "name"
	//   ],
	//   "parameters": {
	//     "name": {
	//       "description": "Required. The resource name of the conversion event to retrieve. Format: properties/{property}/conversionEvents/{conversion_event} Example: \"properties/123/conversionEvents/456\"",
	//       "location": "path",
	//       "pattern": "^properties/[^/]+/conversionEvents/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1alpha/{+name}",
	//   "response": {
	//     "$ref": "GoogleAnalyticsAdminV1alphaConversionEvent"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/analytics.edit",
	//     "https://www.googleapis.com/auth/analytics.readonly"
	//   ]
	// }

}

// method id "analyticsadmin.properties.conversionEvents.list":

type PropertiesConversionEventsListCall struct {
	s            *Service
	parent       string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Returns a list of conversion events in the specified parent
// property. Returns an empty list if no conversion events are found.
//
//   - parent: The resource name of the parent property. Example:
//     'properties/123'.
func (r *PropertiesConversionEventsService) List(parent string) *PropertiesConversionEventsListCall {
	c := &PropertiesConversionEventsListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	return c
}

// PageSize sets the optional parameter "pageSize": The maximum number
// of resources to return. If unspecified, at most 50 resources will be
// returned. The maximum value is 200; (higher values will be coerced to
// the maximum)
func (c *PropertiesConversionEventsListCall) PageSize(pageSize int64) *PropertiesConversionEventsListCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": A page token,
// received from a previous `ListConversionEvents` call. Provide this to
// retrieve the subsequent page. When paginating, all other parameters
// provided to `ListConversionEvents` must match the call that provided
// the page token.
func (c *PropertiesConversionEventsListCall) PageToken(pageToken string) *PropertiesConversionEventsListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *PropertiesConversionEventsListCall) Fields(s ...googleapi.Field) *PropertiesConversionEventsListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets the optional parameter which makes the operation
// fail if the object's ETag matches the given value. This is useful for
// getting updates only after the object has changed since the last
// request. Use googleapi.IsNotModified to check whether the response
// error from Do is the result of In-None-Match.
func (c *PropertiesConversionEventsListCall) IfNoneMatch(entityTag string) *PropertiesConversionEventsListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *PropertiesConversionEventsListCall) Context(ctx context.Context) *PropertiesConversionEventsListCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *PropertiesConversionEventsListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *PropertiesConversionEventsListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1alpha/{+parent}/conversionEvents")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "analyticsadmin.properties.conversionEvents.list" call.
// Exactly one of
// *GoogleAnalyticsAdminV1alphaListConversionEventsResponse or error
// will be non-nil. Any non-2xx status code is an error. Response
// headers are in either
// *GoogleAnalyticsAdminV1alphaListConversionEventsResponse.ServerRespons
// e.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was
// returned.
func (c *PropertiesConversionEventsListCall) Do(opts ...googleapi.CallOption) (*GoogleAnalyticsAdminV1alphaListConversionEventsResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleAnalyticsAdminV1alphaListConversionEventsResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Returns a list of conversion events in the specified parent property. Returns an empty list if no conversion events are found.",
	//   "flatPath": "v1alpha/properties/{propertiesId}/conversionEvents",
	//   "httpMethod": "GET",
	//   "id": "analyticsadmin.properties.conversionEvents.list",
	//   "parameterOrder": [
	//     "parent"
	//   ],
	//   "parameters": {
	//     "pageSize": {
	//       "description": "The maximum number of resources to return. If unspecified, at most 50 resources will be returned. The maximum value is 200; (higher values will be coerced to the maximum)",
	//       "format": "int32",
	//       "location": "query",
	//       "type": "integer"
	//     },
	//     "pageToken": {
	//       "description": "A page token, received from a previous `ListConversionEvents` call. Provide this to retrieve the subsequent page. When paginating, all other parameters provided to `ListConversionEvents` must match the call that provided the page token.",
	//       "location": "query",
	//       "type": "string"
	//     },
	//     "parent": {
	//       "description": "Required. The resource name of the parent property. Example: 'properties/123'",
	//       "location": "path",
	//       "pattern": "^properties/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1alpha/{+parent}/conversionEvents",
	//   "response": {
	//     "$ref": "GoogleAnalyticsAdminV1alphaListConversionEventsResponse"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/analytics.edit",
	//     "https://www.googleapis.com/auth/analytics.readonly"
	//   ]
	// }

}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *PropertiesConversionEventsListCall) Pages(ctx context.Context, f func(*GoogleAnalyticsAdminV1alphaListConversionEventsResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken")) // reset paging to original point
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

// method id "analyticsadmin.properties.customDimensions.archive":

type PropertiesCustomDimensionsArchiveCall struct {
	s                                                        *Service
	name                                                     string
	googleanalyticsadminv1alphaarchivecustomdimensionrequest *GoogleAnalyticsAdminV1alphaArchiveCustomDimensionRequest
	urlParams_                                               gensupport.URLParams
	ctx_                                                     context.Context
	header_                                                  http.Header
}

// Archive: Archives a CustomDimension on a property.
//
//   - name: The name of the CustomDimension to archive. Example format:
//     properties/1234/customDimensions/5678.
func (r *PropertiesCustomDimensionsService) Archive(name string, googleanalyticsadminv1alphaarchivecustomdimensionrequest *GoogleAnalyticsAdminV1alphaArchiveCustomDimensionRequest) *PropertiesCustomDimensionsArchiveCall {
	c := &PropertiesCustomDimensionsArchiveCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	c.googleanalyticsadminv1alphaarchivecustomdimensionrequest = googleanalyticsadminv1alphaarchivecustomdimensionrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *PropertiesCustomDimensionsArchiveCall) Fields(s ...googleapi.Field) *PropertiesCustomDimensionsArchiveCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *PropertiesCustomDimensionsArchiveCall) Context(ctx context.Context) *PropertiesCustomDimensionsArchiveCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *PropertiesCustomDimensionsArchiveCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *PropertiesCustomDimensionsArchiveCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.googleanalyticsadminv1alphaarchivecustomdimensionrequest)
	if err != nil {
		return nil, err
	}
	reqHeaders.Set("Content-Type", "application/json")
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1alpha/{+name}:archive")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "analyticsadmin.properties.customDimensions.archive" call.
// Exactly one of *GoogleProtobufEmpty or error will be non-nil. Any
// non-2xx status code is an error. Response headers are in either
// *GoogleProtobufEmpty.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was
// because http.StatusNotModified was returned.
func (c *PropertiesCustomDimensionsArchiveCall) Do(opts ...googleapi.CallOption) (*GoogleProtobufEmpty, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleProtobufEmpty{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Archives a CustomDimension on a property.",
	//   "flatPath": "v1alpha/properties/{propertiesId}/customDimensions/{customDimensionsId}:archive",
	//   "httpMethod": "POST",
	//   "id": "analyticsadmin.properties.customDimensions.archive",
	//   "parameterOrder": [
	//     "name"
	//   ],
	//   "parameters": {
	//     "name": {
	//       "description": "Required. The name of the CustomDimension to archive. Example format: properties/1234/customDimensions/5678",
	//       "location": "path",
	//       "pattern": "^properties/[^/]+/customDimensions/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1alpha/{+name}:archive",
	//   "request": {
	//     "$ref": "GoogleAnalyticsAdminV1alphaArchiveCustomDimensionRequest"
	//   },
	//   "response": {
	//     "$ref": "GoogleProtobufEmpty"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/analytics.edit"
	//   ]
	// }

}

// method id "analyticsadmin.properties.customDimensions.create":

type PropertiesCustomDimensionsCreateCall struct {
	s                                          *Service
	parent                                     string
	googleanalyticsadminv1alphacustomdimension *GoogleAnalyticsAdminV1alphaCustomDimension
	urlParams_                                 gensupport.URLParams
	ctx_                                       context.Context
	header_                                    http.Header
}

// Create: Creates a CustomDimension.
//
// - parent: Example format: properties/1234.
func (r *PropertiesCustomDimensionsService) Create(parent string, googleanalyticsadminv1alphacustomdimension *GoogleAnalyticsAdminV1alphaCustomDimension) *PropertiesCustomDimensionsCreateCall {
	c := &PropertiesCustomDimensionsCreateCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	c.googleanalyticsadminv1alphacustomdimension = googleanalyticsadminv1alphacustomdimension
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *PropertiesCustomDimensionsCreateCall) Fields(s ...googleapi.Field) *PropertiesCustomDimensionsCreateCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *PropertiesCustomDimensionsCreateCall) Context(ctx context.Context) *PropertiesCustomDimensionsCreateCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *PropertiesCustomDimensionsCreateCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *PropertiesCustomDimensionsCreateCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.googleanalyticsadminv1alphacustomdimension)
	if err != nil {
		return nil, err
	}
	reqHeaders.Set("Content-Type", "application/json")
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1alpha/{+parent}/customDimensions")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "analyticsadmin.properties.customDimensions.create" call.
// Exactly one of *GoogleAnalyticsAdminV1alphaCustomDimension or error
// will be non-nil. Any non-2xx status code is an error. Response
// headers are in either
// *GoogleAnalyticsAdminV1alphaCustomDimension.ServerResponse.Header or
// (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was
// returned.
func (c *PropertiesCustomDimensionsCreateCall) Do(opts ...googleapi.CallOption) (*GoogleAnalyticsAdminV1alphaCustomDimension, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleAnalyticsAdminV1alphaCustomDimension{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Creates a CustomDimension.",
	//   "flatPath": "v1alpha/properties/{propertiesId}/customDimensions",
	//   "httpMethod": "POST",
	//   "id": "analyticsadmin.properties.customDimensions.create",
	//   "parameterOrder": [
	//     "parent"
	//   ],
	//   "parameters": {
	//     "parent": {
	//       "description": "Required. Example format: properties/1234",
	//       "location": "path",
	//       "pattern": "^properties/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1alpha/{+parent}/customDimensions",
	//   "request": {
	//     "$ref": "GoogleAnalyticsAdminV1alphaCustomDimension"
	//   },
	//   "response": {
	//     "$ref": "GoogleAnalyticsAdminV1alphaCustomDimension"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/analytics.edit"
	//   ]
	// }

}

// method id "analyticsadmin.properties.customDimensions.get":

type PropertiesCustomDimensionsGetCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Lookup for a single CustomDimension.
//
//   - name: The name of the CustomDimension to get. Example format:
//     properties/1234/customDimensions/5678.
func (r *PropertiesCustomDimensionsService) Get(name string) *PropertiesCustomDimensionsGetCall {
	c := &PropertiesCustomDimensionsGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *PropertiesCustomDimensionsGetCall) Fields(s ...googleapi.Field) *PropertiesCustomDimensionsGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets the optional parameter which makes the operation
// fail if the object's ETag matches the given value. This is useful for
// getting updates only after the object has changed since the last
// request. Use googleapi.IsNotModified to check whether the response
// error from Do is the result of In-None-Match.
func (c *PropertiesCustomDimensionsGetCall) IfNoneMatch(entityTag string) *PropertiesCustomDimensionsGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *PropertiesCustomDimensionsGetCall) Context(ctx context.Context) *PropertiesCustomDimensionsGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *PropertiesCustomDimensionsGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *PropertiesCustomDimensionsGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1alpha/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "analyticsadmin.properties.customDimensions.get" call.
// Exactly one of *GoogleAnalyticsAdminV1alphaCustomDimension or error
// will be non-nil. Any non-2xx status code is an error. Response
// headers are in either
// *GoogleAnalyticsAdminV1alphaCustomDimension.ServerResponse.Header or
// (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was
// returned.
func (c *PropertiesCustomDimensionsGetCall) Do(opts ...googleapi.CallOption) (*GoogleAnalyticsAdminV1alphaCustomDimension, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleAnalyticsAdminV1alphaCustomDimension{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Lookup for a single CustomDimension.",
	//   "flatPath": "v1alpha/properties/{propertiesId}/customDimensions/{customDimensionsId}",
	//   "httpMethod": "GET",
	//   "id": "analyticsadmin.properties.customDimensions.get",
	//   "parameterOrder": [
	//     "name"
	//   ],
	//   "parameters": {
	//     "name": {
	//       "description": "Required. The name of the CustomDimension to get. Example format: properties/1234/customDimensions/5678",
	//       "location": "path",
	//       "pattern": "^properties/[^/]+/customDimensions/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1alpha/{+name}",
	//   "response": {
	//     "$ref": "GoogleAnalyticsAdminV1alphaCustomDimension"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/analytics.edit",
	//     "https://www.googleapis.com/auth/analytics.readonly"
	//   ]
	// }

}

// method id "analyticsadmin.properties.customDimensions.list":

type PropertiesCustomDimensionsListCall struct {
	s            *Service
	parent       string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Lists CustomDimensions on a property.
//
// - parent: Example format: properties/1234.
func (r *PropertiesCustomDimensionsService) List(parent string) *PropertiesCustomDimensionsListCall {
	c := &PropertiesCustomDimensionsListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	return c
}

// PageSize sets the optional parameter "pageSize": The maximum number
// of resources to return. If unspecified, at most 50 resources will be
// returned. The maximum value is 200 (higher values will be coerced to
// the maximum).
func (c *PropertiesCustomDimensionsListCall) PageSize(pageSize int64) *PropertiesCustomDimensionsListCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": A page token,
// received from a previous `ListCustomDimensions` call. Provide this to
// retrieve the subsequent page. When paginating, all other parameters
// provided to `ListCustomDimensions` must match the call that provided
// the page token.
func (c *PropertiesCustomDimensionsListCall) PageToken(pageToken string) *PropertiesCustomDimensionsListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *PropertiesCustomDimensionsListCall) Fields(s ...googleapi.Field) *PropertiesCustomDimensionsListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets the optional parameter which makes the operation
// fail if the object's ETag matches the given value. This is useful for
// getting updates only after the object has changed since the last
// request. Use googleapi.IsNotModified to check whether the response
// error from Do is the result of In-None-Match.
func (c *PropertiesCustomDimensionsListCall) IfNoneMatch(entityTag string) *PropertiesCustomDimensionsListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *PropertiesCustomDimensionsListCall) Context(ctx context.Context) *PropertiesCustomDimensionsListCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *PropertiesCustomDimensionsListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *PropertiesCustomDimensionsListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1alpha/{+parent}/customDimensions")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "analyticsadmin.properties.customDimensions.list" call.
// Exactly one of
// *GoogleAnalyticsAdminV1alphaListCustomDimensionsResponse or error
// will be non-nil. Any non-2xx status code is an error. Response
// headers are in either
// *GoogleAnalyticsAdminV1alphaListCustomDimensionsResponse.ServerRespons
// e.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was
// returned.
func (c *PropertiesCustomDimensionsListCall) Do(opts ...googleapi.CallOption) (*GoogleAnalyticsAdminV1alphaListCustomDimensionsResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleAnalyticsAdminV1alphaListCustomDimensionsResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Lists CustomDimensions on a property.",
	//   "flatPath": "v1alpha/properties/{propertiesId}/customDimensions",
	//   "httpMethod": "GET",
	//   "id": "analyticsadmin.properties.customDimensions.list",
	//   "parameterOrder": [
	//     "parent"
	//   ],
	//   "parameters": {
	//     "pageSize": {
	//       "description": "The maximum number of resources to return. If unspecified, at most 50 resources will be returned. The maximum value is 200 (higher values will be coerced to the maximum).",
	//       "format": "int32",
	//       "location": "query",
	//       "type": "integer"
	//     },
	//     "pageToken": {
	//       "description": "A page token, received from a previous `ListCustomDimensions` call. Provide this to retrieve the subsequent page. When paginating, all other parameters provided to `ListCustomDimensions` must match the call that provided the page token.",
	//       "location": "query",
	//       "type": "string"
	//     },
	//     "parent": {
	//       "description": "Required. Example format: properties/1234",
	//       "location": "path",
	//       "pattern": "^properties/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1alpha/{+parent}/customDimensions",
	//   "response": {
	//     "$ref": "GoogleAnalyticsAdminV1alphaListCustomDimensionsResponse"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/analytics.edit",
	//     "https://www.googleapis.com/auth/analytics.readonly"
	//   ]
	// }

}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *PropertiesCustomDimensionsListCall) Pages(ctx context.Context, f func(*GoogleAnalyticsAdminV1alphaListCustomDimensionsResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken")) // reset paging to original point
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

// method id "analyticsadmin.properties.customDimensions.patch":

type PropertiesCustomDimensionsPatchCall struct {
	s                                          *Service
	name                                       string
	googleanalyticsadminv1alphacustomdimension *GoogleAnalyticsAdminV1alphaCustomDimension
	urlParams_                                 gensupport.URLParams
	ctx_                                       context.Context
	header_                                    http.Header
}

// Patch: Updates a CustomDimension on a property.
//
//   - name: Output only. Resource name for this CustomDimension resource.
//     Format: properties/{property}/customDimensions/{customDimension}.
func (r *PropertiesCustomDimensionsService) Patch(name string, googleanalyticsadminv1alphacustomdimension *GoogleAnalyticsAdminV1alphaCustomDimension) *PropertiesCustomDimensionsPatchCall {
	c := &PropertiesCustomDimensionsPatchCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	c.googleanalyticsadminv1alphacustomdimension = googleanalyticsadminv1alphacustomdimension
	return c
}

// UpdateMask sets the optional parameter "updateMask": Required. The
// list of fields to be updated. Omitted fields will not be updated. To
// replace the entire entity, use one path with the string "*" to match
// all fields.
func (c *PropertiesCustomDimensionsPatchCall) UpdateMask(updateMask string) *PropertiesCustomDimensionsPatchCall {
	c.urlParams_.Set("updateMask", updateMask)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *PropertiesCustomDimensionsPatchCall) Fields(s ...googleapi.Field) *PropertiesCustomDimensionsPatchCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *PropertiesCustomDimensionsPatchCall) Context(ctx context.Context) *PropertiesCustomDimensionsPatchCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *PropertiesCustomDimensionsPatchCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *PropertiesCustomDimensionsPatchCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.googleanalyticsadminv1alphacustomdimension)
	if err != nil {
		return nil, err
	}
	reqHeaders.Set("Content-Type", "application/json")
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1alpha/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("PATCH", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "analyticsadmin.properties.customDimensions.patch" call.
// Exactly one of *GoogleAnalyticsAdminV1alphaCustomDimension or error
// will be non-nil. Any non-2xx status code is an error. Response
// headers are in either
// *GoogleAnalyticsAdminV1alphaCustomDimension.ServerResponse.Header or
// (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was
// returned.
func (c *PropertiesCustomDimensionsPatchCall) Do(opts ...googleapi.CallOption) (*GoogleAnalyticsAdminV1alphaCustomDimension, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleAnalyticsAdminV1alphaCustomDimension{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Updates a CustomDimension on a property.",
	//   "flatPath": "v1alpha/properties/{propertiesId}/customDimensions/{customDimensionsId}",
	//   "httpMethod": "PATCH",
	//   "id": "analyticsadmin.properties.customDimensions.patch",
	//   "parameterOrder": [
	//     "name"
	//   ],
	//   "parameters": {
	//     "name": {
	//       "description": "Output only. Resource name for this CustomDimension resource. Format: properties/{property}/customDimensions/{customDimension}",
	//       "location": "path",
	//       "pattern": "^properties/[^/]+/customDimensions/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     },
	//     "updateMask": {
	//       "description": "Required. The list of fields to be updated. Omitted fields will not be updated. To replace the entire entity, use one path with the string \"*\" to match all fields.",
	//       "format": "google-fieldmask",
	//       "location": "query",
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1alpha/{+name}",
	//   "request": {
	//     "$ref": "GoogleAnalyticsAdminV1alphaCustomDimension"
	//   },
	//   "response": {
	//     "$ref": "GoogleAnalyticsAdminV1alphaCustomDimension"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/analytics.edit"
	//   ]
	// }

}

// method id "analyticsadmin.properties.customMetrics.archive":

type PropertiesCustomMetricsArchiveCall struct {
	s                                                     *Service
	name                                                  string
	googleanalyticsadminv1alphaarchivecustommetricrequest *GoogleAnalyticsAdminV1alphaArchiveCustomMetricRequest
	urlParams_                                            gensupport.URLParams
	ctx_                                                  context.Context
	header_                                               http.Header
}

// Archive: Archives a CustomMetric on a property.
//
//   - name: The name of the CustomMetric to archive. Example format:
//     properties/1234/customMetrics/5678.
func (r *PropertiesCustomMetricsService) Archive(name string, googleanalyticsadminv1alphaarchivecustommetricrequest *GoogleAnalyticsAdminV1alphaArchiveCustomMetricRequest) *PropertiesCustomMetricsArchiveCall {
	c := &PropertiesCustomMetricsArchiveCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	c.googleanalyticsadminv1alphaarchivecustommetricrequest = googleanalyticsadminv1alphaarchivecustommetricrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *PropertiesCustomMetricsArchiveCall) Fields(s ...googleapi.Field) *PropertiesCustomMetricsArchiveCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *PropertiesCustomMetricsArchiveCall) Context(ctx context.Context) *PropertiesCustomMetricsArchiveCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *PropertiesCustomMetricsArchiveCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *PropertiesCustomMetricsArchiveCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.googleanalyticsadminv1alphaarchivecustommetricrequest)
	if err != nil {
		return nil, err
	}
	reqHeaders.Set("Content-Type", "application/json")
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1alpha/{+name}:archive")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "analyticsadmin.properties.customMetrics.archive" call.
// Exactly one of *GoogleProtobufEmpty or error will be non-nil. Any
// non-2xx status code is an error. Response headers are in either
// *GoogleProtobufEmpty.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was
// because http.StatusNotModified was returned.
func (c *PropertiesCustomMetricsArchiveCall) Do(opts ...googleapi.CallOption) (*GoogleProtobufEmpty, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleProtobufEmpty{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Archives a CustomMetric on a property.",
	//   "flatPath": "v1alpha/properties/{propertiesId}/customMetrics/{customMetricsId}:archive",
	//   "httpMethod": "POST",
	//   "id": "analyticsadmin.properties.customMetrics.archive",
	//   "parameterOrder": [
	//     "name"
	//   ],
	//   "parameters": {
	//     "name": {
	//       "description": "Required. The name of the CustomMetric to archive. Example format: properties/1234/customMetrics/5678",
	//       "location": "path",
	//       "pattern": "^properties/[^/]+/customMetrics/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1alpha/{+name}:archive",
	//   "request": {
	//     "$ref": "GoogleAnalyticsAdminV1alphaArchiveCustomMetricRequest"
	//   },
	//   "response": {
	//     "$ref": "GoogleProtobufEmpty"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/analytics.edit"
	//   ]
	// }

}

// method id "analyticsadmin.properties.customMetrics.create":

type PropertiesCustomMetricsCreateCall struct {
	s                                       *Service
	parent                                  string
	googleanalyticsadminv1alphacustommetric *GoogleAnalyticsAdminV1alphaCustomMetric
	urlParams_                              gensupport.URLParams
	ctx_                                    context.Context
	header_                                 http.Header
}

// Create: Creates a CustomMetric.
//
// - parent: Example format: properties/1234.
func (r *PropertiesCustomMetricsService) Create(parent string, googleanalyticsadminv1alphacustommetric *GoogleAnalyticsAdminV1alphaCustomMetric) *PropertiesCustomMetricsCreateCall {
	c := &PropertiesCustomMetricsCreateCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	c.googleanalyticsadminv1alphacustommetric = googleanalyticsadminv1alphacustommetric
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *PropertiesCustomMetricsCreateCall) Fields(s ...googleapi.Field) *PropertiesCustomMetricsCreateCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *PropertiesCustomMetricsCreateCall) Context(ctx context.Context) *PropertiesCustomMetricsCreateCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *PropertiesCustomMetricsCreateCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *PropertiesCustomMetricsCreateCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.googleanalyticsadminv1alphacustommetric)
	if err != nil {
		return nil, err
	}
	reqHeaders.Set("Content-Type", "application/json")
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1alpha/{+parent}/customMetrics")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "analyticsadmin.properties.customMetrics.create" call.
// Exactly one of *GoogleAnalyticsAdminV1alphaCustomMetric or error will
// be non-nil. Any non-2xx status code is an error. Response headers are
// in either
// *GoogleAnalyticsAdminV1alphaCustomMetric.ServerResponse.Header or (if
// a response was returned at all) in error.(*googleapi.Error).Header.
// Use googleapi.IsNotModified to check whether the returned error was
// because http.StatusNotModified was returned.
func (c *PropertiesCustomMetricsCreateCall) Do(opts ...googleapi.CallOption) (*GoogleAnalyticsAdminV1alphaCustomMetric, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleAnalyticsAdminV1alphaCustomMetric{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Creates a CustomMetric.",
	//   "flatPath": "v1alpha/properties/{propertiesId}/customMetrics",
	//   "httpMethod": "POST",
	//   "id": "analyticsadmin.properties.customMetrics.create",
	//   "parameterOrder": [
	//     "parent"
	//   ],
	//   "parameters": {
	//     "parent": {
	//       "description": "Required. Example format: properties/1234",
	//       "location": "path",
	//       "pattern": "^properties/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1alpha/{+parent}/customMetrics",
	//   "request": {
	//     "$ref": "GoogleAnalyticsAdminV1alphaCustomMetric"
	//   },
	//   "response": {
	//     "$ref": "GoogleAnalyticsAdminV1alphaCustomMetric"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/analytics.edit"
	//   ]
	// }

}

// method id "analyticsadmin.properties.customMetrics.get":

type PropertiesCustomMetricsGetCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Lookup for a single CustomMetric.
//
//   - name: The name of the CustomMetric to get. Example format:
//     properties/1234/customMetrics/5678.
func (r *PropertiesCustomMetricsService) Get(name string) *PropertiesCustomMetricsGetCall {
	c := &PropertiesCustomMetricsGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *PropertiesCustomMetricsGetCall) Fields(s ...googleapi.Field) *PropertiesCustomMetricsGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets the optional parameter which makes the operation
// fail if the object's ETag matches the given value. This is useful for
// getting updates only after the object has changed since the last
// request. Use googleapi.IsNotModified to check whether the response
// error from Do is the result of In-None-Match.
func (c *PropertiesCustomMetricsGetCall) IfNoneMatch(entityTag string) *PropertiesCustomMetricsGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *PropertiesCustomMetricsGetCall) Context(ctx context.Context) *PropertiesCustomMetricsGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *PropertiesCustomMetricsGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *PropertiesCustomMetricsGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1alpha/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "analyticsadmin.properties.customMetrics.get" call.
// Exactly one of *GoogleAnalyticsAdminV1alphaCustomMetric or error will
// be non-nil. Any non-2xx status code is an error. Response headers are
// in either
// *GoogleAnalyticsAdminV1alphaCustomMetric.ServerResponse.Header or (if
// a response was returned at all) in error.(*googleapi.Error).Header.
// Use googleapi.IsNotModified to check whether the returned error was
// because http.StatusNotModified was returned.
func (c *PropertiesCustomMetricsGetCall) Do(opts ...googleapi.CallOption) (*GoogleAnalyticsAdminV1alphaCustomMetric, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleAnalyticsAdminV1alphaCustomMetric{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Lookup for a single CustomMetric.",
	//   "flatPath": "v1alpha/properties/{propertiesId}/customMetrics/{customMetricsId}",
	//   "httpMethod": "GET",
	//   "id": "analyticsadmin.properties.customMetrics.get",
	//   "parameterOrder": [
	//     "name"
	//   ],
	//   "parameters": {
	//     "name": {
	//       "description": "Required. The name of the CustomMetric to get. Example format: properties/1234/customMetrics/5678",
	//       "location": "path",
	//       "pattern": "^properties/[^/]+/customMetrics/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1alpha/{+name}",
	//   "response": {
	//     "$ref": "GoogleAnalyticsAdminV1alphaCustomMetric"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/analytics.edit",
	//     "https://www.googleapis.com/auth/analytics.readonly"
	//   ]
	// }

}

// method id "analyticsadmin.properties.customMetrics.list":

type PropertiesCustomMetricsListCall struct {
	s            *Service
	parent       string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Lists CustomMetrics on a property.
//
// - parent: Example format: properties/1234.
func (r *PropertiesCustomMetricsService) List(parent string) *PropertiesCustomMetricsListCall {
	c := &PropertiesCustomMetricsListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	return c
}

// PageSize sets the optional parameter "pageSize": The maximum number
// of resources to return. If unspecified, at most 50 resources will be
// returned. The maximum value is 200 (higher values will be coerced to
// the maximum).
func (c *PropertiesCustomMetricsListCall) PageSize(pageSize int64) *PropertiesCustomMetricsListCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": A page token,
// received from a previous `ListCustomMetrics` call. Provide this to
// retrieve the subsequent page. When paginating, all other parameters
// provided to `ListCustomMetrics` must match the call that provided the
// page token.
func (c *PropertiesCustomMetricsListCall) PageToken(pageToken string) *PropertiesCustomMetricsListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *PropertiesCustomMetricsListCall) Fields(s ...googleapi.Field) *PropertiesCustomMetricsListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets the optional parameter which makes the operation
// fail if the object's ETag matches the given value. This is useful for
// getting updates only after the object has changed since the last
// request. Use googleapi.IsNotModified to check whether the response
// error from Do is the result of In-None-Match.
func (c *PropertiesCustomMetricsListCall) IfNoneMatch(entityTag string) *PropertiesCustomMetricsListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *PropertiesCustomMetricsListCall) Context(ctx context.Context) *PropertiesCustomMetricsListCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *PropertiesCustomMetricsListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *PropertiesCustomMetricsListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1alpha/{+parent}/customMetrics")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "analyticsadmin.properties.customMetrics.list" call.
// Exactly one of *GoogleAnalyticsAdminV1alphaListCustomMetricsResponse
// or error will be non-nil. Any non-2xx status code is an error.
// Response headers are in either
// *GoogleAnalyticsAdminV1alphaListCustomMetricsResponse.ServerResponse.H
// eader or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was
// returned.
func (c *PropertiesCustomMetricsListCall) Do(opts ...googleapi.CallOption) (*GoogleAnalyticsAdminV1alphaListCustomMetricsResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleAnalyticsAdminV1alphaListCustomMetricsResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Lists CustomMetrics on a property.",
	//   "flatPath": "v1alpha/properties/{propertiesId}/customMetrics",
	//   "httpMethod": "GET",
	//   "id": "analyticsadmin.properties.customMetrics.list",
	//   "parameterOrder": [
	//     "parent"
	//   ],
	//   "parameters": {
	//     "pageSize": {
	//       "description": "The maximum number of resources to return. If unspecified, at most 50 resources will be returned. The maximum value is 200 (higher values will be coerced to the maximum).",
	//       "format": "int32",
	//       "location": "query",
	//       "type": "integer"
	//     },
	//     "pageToken": {
	//       "description": "A page token, received from a previous `ListCustomMetrics` call. Provide this to retrieve the subsequent page. When paginating, all other parameters provided to `ListCustomMetrics` must match the call that provided the page token.",
	//       "location": "query",
	//       "type": "string"
	//     },
	//     "parent": {
	//       "description": "Required. Example format: properties/1234",
	//       "location": "path",
	//       "pattern": "^properties/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1alpha/{+parent}/customMetrics",
	//   "response": {
	//     "$ref": "GoogleAnalyticsAdminV1alphaListCustomMetricsResponse"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/analytics.edit",
	//     "https://www.googleapis.com/auth/analytics.readonly"
	//   ]
	// }

}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *PropertiesCustomMetricsListCall) Pages(ctx context.Context, f func(*GoogleAnalyticsAdminV1alphaListCustomMetricsResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken")) // reset paging to original point
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

// method id "analyticsadmin.properties.customMetrics.patch":

type PropertiesCustomMetricsPatchCall struct {
	s                                       *Service
	name                                    string
	googleanalyticsadminv1alphacustommetric *GoogleAnalyticsAdminV1alphaCustomMetric
	urlParams_                              gensupport.URLParams
	ctx_                                    context.Context
	header_                                 http.Header
}

// Patch: Updates a CustomMetric on a property.
//
//   - name: Output only. Resource name for this CustomMetric resource.
//     Format: properties/{property}/customMetrics/{customMetric}.
func (r *PropertiesCustomMetricsService) Patch(name string, googleanalyticsadminv1alphacustommetric *GoogleAnalyticsAdminV1alphaCustomMetric) *PropertiesCustomMetricsPatchCall {
	c := &PropertiesCustomMetricsPatchCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	c.googleanalyticsadminv1alphacustommetric = googleanalyticsadminv1alphacustommetric
	return c
}

// UpdateMask sets the optional parameter "updateMask": Required. The
// list of fields to be updated. Omitted fields will not be updated. To
// replace the entire entity, use one path with the string "*" to match
// all fields.
func (c *PropertiesCustomMetricsPatchCall) UpdateMask(updateMask string) *PropertiesCustomMetricsPatchCall {
	c.urlParams_.Set("updateMask", updateMask)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *PropertiesCustomMetricsPatchCall) Fields(s ...googleapi.Field) *PropertiesCustomMetricsPatchCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *PropertiesCustomMetricsPatchCall) Context(ctx context.Context) *PropertiesCustomMetricsPatchCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *PropertiesCustomMetricsPatchCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *PropertiesCustomMetricsPatchCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.googleanalyticsadminv1alphacustommetric)
	if err != nil {
		return nil, err
	}
	reqHeaders.Set("Content-Type", "application/json")
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1alpha/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("PATCH", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "analyticsadmin.properties.customMetrics.patch" call.
// Exactly one of *GoogleAnalyticsAdminV1alphaCustomMetric or error will
// be non-nil. Any non-2xx status code is an error. Response headers are
// in either
// *GoogleAnalyticsAdminV1alphaCustomMetric.ServerResponse.Header or (if
// a response was returned at all) in error.(*googleapi.Error).Header.
// Use googleapi.IsNotModified to check whether the returned error was
// because http.StatusNotModified was returned.
func (c *PropertiesCustomMetricsPatchCall) Do(opts ...googleapi.CallOption) (*GoogleAnalyticsAdminV1alphaCustomMetric, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleAnalyticsAdminV1alphaCustomMetric{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Updates a CustomMetric on a property.",
	//   "flatPath": "v1alpha/properties/{propertiesId}/customMetrics/{customMetricsId}",
	//   "httpMethod": "PATCH",
	//   "id": "analyticsadmin.properties.customMetrics.patch",
	//   "parameterOrder": [
	//     "name"
	//   ],
	//   "parameters": {
	//     "name": {
	//       "description": "Output only. Resource name for this CustomMetric resource. Format: properties/{property}/customMetrics/{customMetric}",
	//       "location": "path",
	//       "pattern": "^properties/[^/]+/customMetrics/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     },
	//     "updateMask": {
	//       "description": "Required. The list of fields to be updated. Omitted fields will not be updated. To replace the entire entity, use one path with the string \"*\" to match all fields.",
	//       "format": "google-fieldmask",
	//       "location": "query",
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1alpha/{+name}",
	//   "request": {
	//     "$ref": "GoogleAnalyticsAdminV1alphaCustomMetric"
	//   },
	//   "response": {
	//     "$ref": "GoogleAnalyticsAdminV1alphaCustomMetric"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/analytics.edit"
	//   ]
	// }

}

// method id "analyticsadmin.properties.dataStreams.create":

type PropertiesDataStreamsCreateCall struct {
	s                                     *Service
	parent                                string
	googleanalyticsadminv1alphadatastream *GoogleAnalyticsAdminV1alphaDataStream
	urlParams_                            gensupport.URLParams
	ctx_                                  context.Context
	header_                               http.Header
}

// Create: Creates a DataStream.
//
// - parent: Example format: properties/1234.
func (r *PropertiesDataStreamsService) Create(parent string, googleanalyticsadminv1alphadatastream *GoogleAnalyticsAdminV1alphaDataStream) *PropertiesDataStreamsCreateCall {
	c := &PropertiesDataStreamsCreateCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	c.googleanalyticsadminv1alphadatastream = googleanalyticsadminv1alphadatastream
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *PropertiesDataStreamsCreateCall) Fields(s ...googleapi.Field) *PropertiesDataStreamsCreateCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *PropertiesDataStreamsCreateCall) Context(ctx context.Context) *PropertiesDataStreamsCreateCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *PropertiesDataStreamsCreateCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *PropertiesDataStreamsCreateCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.googleanalyticsadminv1alphadatastream)
	if err != nil {
		return nil, err
	}
	reqHeaders.Set("Content-Type", "application/json")
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1alpha/{+parent}/dataStreams")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "analyticsadmin.properties.dataStreams.create" call.
// Exactly one of *GoogleAnalyticsAdminV1alphaDataStream or error will
// be non-nil. Any non-2xx status code is an error. Response headers are
// in either
// *GoogleAnalyticsAdminV1alphaDataStream.ServerResponse.Header or (if a
// response was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was
// because http.StatusNotModified was returned.
func (c *PropertiesDataStreamsCreateCall) Do(opts ...googleapi.CallOption) (*GoogleAnalyticsAdminV1alphaDataStream, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleAnalyticsAdminV1alphaDataStream{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Creates a DataStream.",
	//   "flatPath": "v1alpha/properties/{propertiesId}/dataStreams",
	//   "httpMethod": "POST",
	//   "id": "analyticsadmin.properties.dataStreams.create",
	//   "parameterOrder": [
	//     "parent"
	//   ],
	//   "parameters": {
	//     "parent": {
	//       "description": "Required. Example format: properties/1234",
	//       "location": "path",
	//       "pattern": "^properties/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1alpha/{+parent}/dataStreams",
	//   "request": {
	//     "$ref": "GoogleAnalyticsAdminV1alphaDataStream"
	//   },
	//   "response": {
	//     "$ref": "GoogleAnalyticsAdminV1alphaDataStream"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/analytics.edit"
	//   ]
	// }

}

// method id "analyticsadmin.properties.dataStreams.delete":

type PropertiesDataStreamsDeleteCall struct {
	s          *Service
	name       string
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Delete: Deletes a DataStream on a property.
//
//   - name: The name of the DataStream to delete. Example format:
//     properties/1234/dataStreams/5678.
func (r *PropertiesDataStreamsService) Delete(name string) *PropertiesDataStreamsDeleteCall {
	c := &PropertiesDataStreamsDeleteCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *PropertiesDataStreamsDeleteCall) Fields(s ...googleapi.Field) *PropertiesDataStreamsDeleteCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *PropertiesDataStreamsDeleteCall) Context(ctx context.Context) *PropertiesDataStreamsDeleteCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *PropertiesDataStreamsDeleteCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *PropertiesDataStreamsDeleteCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1alpha/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("DELETE", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "analyticsadmin.properties.dataStreams.delete" call.
// Exactly one of *GoogleProtobufEmpty or error will be non-nil. Any
// non-2xx status code is an error. Response headers are in either
// *GoogleProtobufEmpty.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was
// because http.StatusNotModified was returned.
func (c *PropertiesDataStreamsDeleteCall) Do(opts ...googleapi.CallOption) (*GoogleProtobufEmpty, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleProtobufEmpty{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Deletes a DataStream on a property.",
	//   "flatPath": "v1alpha/properties/{propertiesId}/dataStreams/{dataStreamsId}",
	//   "httpMethod": "DELETE",
	//   "id": "analyticsadmin.properties.dataStreams.delete",
	//   "parameterOrder": [
	//     "name"
	//   ],
	//   "parameters": {
	//     "name": {
	//       "description": "Required. The name of the DataStream to delete. Example format: properties/1234/dataStreams/5678",
	//       "location": "path",
	//       "pattern": "^properties/[^/]+/dataStreams/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1alpha/{+name}",
	//   "response": {
	//     "$ref": "GoogleProtobufEmpty"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/analytics.edit"
	//   ]
	// }

}

// method id "analyticsadmin.properties.dataStreams.get":

type PropertiesDataStreamsGetCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Lookup for a single DataStream.
//
//   - name: The name of the DataStream to get. Example format:
//     properties/1234/dataStreams/5678.
func (r *PropertiesDataStreamsService) Get(name string) *PropertiesDataStreamsGetCall {
	c := &PropertiesDataStreamsGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *PropertiesDataStreamsGetCall) Fields(s ...googleapi.Field) *PropertiesDataStreamsGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets the optional parameter which makes the operation
// fail if the object's ETag matches the given value. This is useful for
// getting updates only after the object has changed since the last
// request. Use googleapi.IsNotModified to check whether the response
// error from Do is the result of In-None-Match.
func (c *PropertiesDataStreamsGetCall) IfNoneMatch(entityTag string) *PropertiesDataStreamsGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *PropertiesDataStreamsGetCall) Context(ctx context.Context) *PropertiesDataStreamsGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *PropertiesDataStreamsGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *PropertiesDataStreamsGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1alpha/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "analyticsadmin.properties.dataStreams.get" call.
// Exactly one of *GoogleAnalyticsAdminV1alphaDataStream or error will
// be non-nil. Any non-2xx status code is an error. Response headers are
// in either
// *GoogleAnalyticsAdminV1alphaDataStream.ServerResponse.Header or (if a
// response was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was
// because http.StatusNotModified was returned.
func (c *PropertiesDataStreamsGetCall) Do(opts ...googleapi.CallOption) (*GoogleAnalyticsAdminV1alphaDataStream, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleAnalyticsAdminV1alphaDataStream{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Lookup for a single DataStream.",
	//   "flatPath": "v1alpha/properties/{propertiesId}/dataStreams/{dataStreamsId}",
	//   "httpMethod": "GET",
	//   "id": "analyticsadmin.properties.dataStreams.get",
	//   "parameterOrder": [
	//     "name"
	//   ],
	//   "parameters": {
	//     "name": {
	//       "description": "Required. The name of the DataStream to get. Example format: properties/1234/dataStreams/5678",
	//       "location": "path",
	//       "pattern": "^properties/[^/]+/dataStreams/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1alpha/{+name}",
	//   "response": {
	//     "$ref": "GoogleAnalyticsAdminV1alphaDataStream"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/analytics.edit",
	//     "https://www.googleapis.com/auth/analytics.readonly"
	//   ]
	// }

}

// method id "analyticsadmin.properties.dataStreams.getEnhancedMeasurementSettings":

type PropertiesDataStreamsGetEnhancedMeasurementSettingsCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// GetEnhancedMeasurementSettings: Returns the enhanced measurement
// settings for this data stream. Note that the stream must enable
// enhanced measurement for these settings to take effect.
//
//   - name: The name of the settings to lookup. Format:
//     properties/{property}/dataStreams/{data_stream}/enhancedMeasurementS
//     ettings Example:
//     "properties/1000/dataStreams/2000/enhancedMeasurementSettings".
func (r *PropertiesDataStreamsService) GetEnhancedMeasurementSettings(name string) *PropertiesDataStreamsGetEnhancedMeasurementSettingsCall {
	c := &PropertiesDataStreamsGetEnhancedMeasurementSettingsCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *PropertiesDataStreamsGetEnhancedMeasurementSettingsCall) Fields(s ...googleapi.Field) *PropertiesDataStreamsGetEnhancedMeasurementSettingsCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets the optional parameter which makes the operation
// fail if the object's ETag matches the given value. This is useful for
// getting updates only after the object has changed since the last
// request. Use googleapi.IsNotModified to check whether the response
// error from Do is the result of In-None-Match.
func (c *PropertiesDataStreamsGetEnhancedMeasurementSettingsCall) IfNoneMatch(entityTag string) *PropertiesDataStreamsGetEnhancedMeasurementSettingsCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *PropertiesDataStreamsGetEnhancedMeasurementSettingsCall) Context(ctx context.Context) *PropertiesDataStreamsGetEnhancedMeasurementSettingsCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *PropertiesDataStreamsGetEnhancedMeasurementSettingsCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *PropertiesDataStreamsGetEnhancedMeasurementSettingsCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1alpha/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "analyticsadmin.properties.dataStreams.getEnhancedMeasurementSettings" call.
// Exactly one of
// *GoogleAnalyticsAdminV1alphaEnhancedMeasurementSettings or error will
// be non-nil. Any non-2xx status code is an error. Response headers are
// in either
// *GoogleAnalyticsAdminV1alphaEnhancedMeasurementSettings.ServerResponse
// .Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was
// returned.
func (c *PropertiesDataStreamsGetEnhancedMeasurementSettingsCall) Do(opts ...googleapi.CallOption) (*GoogleAnalyticsAdminV1alphaEnhancedMeasurementSettings, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleAnalyticsAdminV1alphaEnhancedMeasurementSettings{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Returns the enhanced measurement settings for this data stream. Note that the stream must enable enhanced measurement for these settings to take effect.",
	//   "flatPath": "v1alpha/properties/{propertiesId}/dataStreams/{dataStreamsId}/enhancedMeasurementSettings",
	//   "httpMethod": "GET",
	//   "id": "analyticsadmin.properties.dataStreams.getEnhancedMeasurementSettings",
	//   "parameterOrder": [
	//     "name"
	//   ],
	//   "parameters": {
	//     "name": {
	//       "description": "Required. The name of the settings to lookup. Format: properties/{property}/dataStreams/{data_stream}/enhancedMeasurementSettings Example: \"properties/1000/dataStreams/2000/enhancedMeasurementSettings\"",
	//       "location": "path",
	//       "pattern": "^properties/[^/]+/dataStreams/[^/]+/enhancedMeasurementSettings$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1alpha/{+name}",
	//   "response": {
	//     "$ref": "GoogleAnalyticsAdminV1alphaEnhancedMeasurementSettings"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/analytics.edit",
	//     "https://www.googleapis.com/auth/analytics.readonly"
	//   ]
	// }

}

// method id "analyticsadmin.properties.dataStreams.getGlobalSiteTag":

type PropertiesDataStreamsGetGlobalSiteTagCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// GetGlobalSiteTag: Returns the Site Tag for the specified web stream.
// Site Tags are immutable singletons.
//
//   - name: The name of the site tag to lookup. Note that site tags are
//     singletons and do not have unique IDs. Format:
//     properties/{property_id}/dataStreams/{stream_id}/globalSiteTag
//     Example: "properties/123/dataStreams/456/globalSiteTag".
func (r *PropertiesDataStreamsService) GetGlobalSiteTag(name string) *PropertiesDataStreamsGetGlobalSiteTagCall {
	c := &PropertiesDataStreamsGetGlobalSiteTagCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *PropertiesDataStreamsGetGlobalSiteTagCall) Fields(s ...googleapi.Field) *PropertiesDataStreamsGetGlobalSiteTagCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets the optional parameter which makes the operation
// fail if the object's ETag matches the given value. This is useful for
// getting updates only after the object has changed since the last
// request. Use googleapi.IsNotModified to check whether the response
// error from Do is the result of In-None-Match.
func (c *PropertiesDataStreamsGetGlobalSiteTagCall) IfNoneMatch(entityTag string) *PropertiesDataStreamsGetGlobalSiteTagCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *PropertiesDataStreamsGetGlobalSiteTagCall) Context(ctx context.Context) *PropertiesDataStreamsGetGlobalSiteTagCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *PropertiesDataStreamsGetGlobalSiteTagCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *PropertiesDataStreamsGetGlobalSiteTagCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1alpha/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "analyticsadmin.properties.dataStreams.getGlobalSiteTag" call.
// Exactly one of *GoogleAnalyticsAdminV1alphaGlobalSiteTag or error
// will be non-nil. Any non-2xx status code is an error. Response
// headers are in either
// *GoogleAnalyticsAdminV1alphaGlobalSiteTag.ServerResponse.Header or
// (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was
// returned.
func (c *PropertiesDataStreamsGetGlobalSiteTagCall) Do(opts ...googleapi.CallOption) (*GoogleAnalyticsAdminV1alphaGlobalSiteTag, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleAnalyticsAdminV1alphaGlobalSiteTag{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Returns the Site Tag for the specified web stream. Site Tags are immutable singletons.",
	//   "flatPath": "v1alpha/properties/{propertiesId}/dataStreams/{dataStreamsId}/globalSiteTag",
	//   "httpMethod": "GET",
	//   "id": "analyticsadmin.properties.dataStreams.getGlobalSiteTag",
	//   "parameterOrder": [
	//     "name"
	//   ],
	//   "parameters": {
	//     "name": {
	//       "description": "Required. The name of the site tag to lookup. Note that site tags are singletons and do not have unique IDs. Format: properties/{property_id}/dataStreams/{stream_id}/globalSiteTag Example: \"properties/123/dataStreams/456/globalSiteTag\"",
	//       "location": "path",
	//       "pattern": "^properties/[^/]+/dataStreams/[^/]+/globalSiteTag$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1alpha/{+name}",
	//   "response": {
	//     "$ref": "GoogleAnalyticsAdminV1alphaGlobalSiteTag"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/analytics.edit",
	//     "https://www.googleapis.com/auth/analytics.readonly"
	//   ]
	// }

}

// method id "analyticsadmin.properties.dataStreams.list":

type PropertiesDataStreamsListCall struct {
	s            *Service
	parent       string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Lists DataStreams on a property.
//
// - parent: Example format: properties/1234.
func (r *PropertiesDataStreamsService) List(parent string) *PropertiesDataStreamsListCall {
	c := &PropertiesDataStreamsListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	return c
}

// PageSize sets the optional parameter "pageSize": The maximum number
// of resources to return. If unspecified, at most 50 resources will be
// returned. The maximum value is 200 (higher values will be coerced to
// the maximum).
func (c *PropertiesDataStreamsListCall) PageSize(pageSize int64) *PropertiesDataStreamsListCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": A page token,
// received from a previous `ListDataStreams` call. Provide this to
// retrieve the subsequent page. When paginating, all other parameters
// provided to `ListDataStreams` must match the call that provided the
// page token.
func (c *PropertiesDataStreamsListCall) PageToken(pageToken string) *PropertiesDataStreamsListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *PropertiesDataStreamsListCall) Fields(s ...googleapi.Field) *PropertiesDataStreamsListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets the optional parameter which makes the operation
// fail if the object's ETag matches the given value. This is useful for
// getting updates only after the object has changed since the last
// request. Use googleapi.IsNotModified to check whether the response
// error from Do is the result of In-None-Match.
func (c *PropertiesDataStreamsListCall) IfNoneMatch(entityTag string) *PropertiesDataStreamsListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *PropertiesDataStreamsListCall) Context(ctx context.Context) *PropertiesDataStreamsListCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *PropertiesDataStreamsListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *PropertiesDataStreamsListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1alpha/{+parent}/dataStreams")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "analyticsadmin.properties.dataStreams.list" call.
// Exactly one of *GoogleAnalyticsAdminV1alphaListDataStreamsResponse or
// error will be non-nil. Any non-2xx status code is an error. Response
// headers are in either
// *GoogleAnalyticsAdminV1alphaListDataStreamsResponse.ServerResponse.Hea
// der or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was
// returned.
func (c *PropertiesDataStreamsListCall) Do(opts ...googleapi.CallOption) (*GoogleAnalyticsAdminV1alphaListDataStreamsResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleAnalyticsAdminV1alphaListDataStreamsResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Lists DataStreams on a property.",
	//   "flatPath": "v1alpha/properties/{propertiesId}/dataStreams",
	//   "httpMethod": "GET",
	//   "id": "analyticsadmin.properties.dataStreams.list",
	//   "parameterOrder": [
	//     "parent"
	//   ],
	//   "parameters": {
	//     "pageSize": {
	//       "description": "The maximum number of resources to return. If unspecified, at most 50 resources will be returned. The maximum value is 200 (higher values will be coerced to the maximum).",
	//       "format": "int32",
	//       "location": "query",
	//       "type": "integer"
	//     },
	//     "pageToken": {
	//       "description": "A page token, received from a previous `ListDataStreams` call. Provide this to retrieve the subsequent page. When paginating, all other parameters provided to `ListDataStreams` must match the call that provided the page token.",
	//       "location": "query",
	//       "type": "string"
	//     },
	//     "parent": {
	//       "description": "Required. Example format: properties/1234",
	//       "location": "path",
	//       "pattern": "^properties/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1alpha/{+parent}/dataStreams",
	//   "response": {
	//     "$ref": "GoogleAnalyticsAdminV1alphaListDataStreamsResponse"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/analytics.edit",
	//     "https://www.googleapis.com/auth/analytics.readonly"
	//   ]
	// }

}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *PropertiesDataStreamsListCall) Pages(ctx context.Context, f func(*GoogleAnalyticsAdminV1alphaListDataStreamsResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken")) // reset paging to original point
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

// method id "analyticsadmin.properties.dataStreams.patch":

type PropertiesDataStreamsPatchCall struct {
	s                                     *Service
	name                                  string
	googleanalyticsadminv1alphadatastream *GoogleAnalyticsAdminV1alphaDataStream
	urlParams_                            gensupport.URLParams
	ctx_                                  context.Context
	header_                               http.Header
}

// Patch: Updates a DataStream on a property.
//
//   - name: Output only. Resource name of this Data Stream. Format:
//     properties/{property_id}/dataStreams/{stream_id} Example:
//     "properties/1000/dataStreams/2000".
func (r *PropertiesDataStreamsService) Patch(name string, googleanalyticsadminv1alphadatastream *GoogleAnalyticsAdminV1alphaDataStream) *PropertiesDataStreamsPatchCall {
	c := &PropertiesDataStreamsPatchCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	c.googleanalyticsadminv1alphadatastream = googleanalyticsadminv1alphadatastream
	return c
}

// UpdateMask sets the optional parameter "updateMask": Required. The
// list of fields to be updated. Omitted fields will not be updated. To
// replace the entire entity, use one path with the string "*" to match
// all fields.
func (c *PropertiesDataStreamsPatchCall) UpdateMask(updateMask string) *PropertiesDataStreamsPatchCall {
	c.urlParams_.Set("updateMask", updateMask)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *PropertiesDataStreamsPatchCall) Fields(s ...googleapi.Field) *PropertiesDataStreamsPatchCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *PropertiesDataStreamsPatchCall) Context(ctx context.Context) *PropertiesDataStreamsPatchCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *PropertiesDataStreamsPatchCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *PropertiesDataStreamsPatchCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.googleanalyticsadminv1alphadatastream)
	if err != nil {
		return nil, err
	}
	reqHeaders.Set("Content-Type", "application/json")
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1alpha/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("PATCH", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "analyticsadmin.properties.dataStreams.patch" call.
// Exactly one of *GoogleAnalyticsAdminV1alphaDataStream or error will
// be non-nil. Any non-2xx status code is an error. Response headers are
// in either
// *GoogleAnalyticsAdminV1alphaDataStream.ServerResponse.Header or (if a
// response was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was
// because http.StatusNotModified was returned.
func (c *PropertiesDataStreamsPatchCall) Do(opts ...googleapi.CallOption) (*GoogleAnalyticsAdminV1alphaDataStream, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleAnalyticsAdminV1alphaDataStream{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Updates a DataStream on a property.",
	//   "flatPath": "v1alpha/properties/{propertiesId}/dataStreams/{dataStreamsId}",
	//   "httpMethod": "PATCH",
	//   "id": "analyticsadmin.properties.dataStreams.patch",
	//   "parameterOrder": [
	//     "name"
	//   ],
	//   "parameters": {
	//     "name": {
	//       "description": "Output only. Resource name of this Data Stream. Format: properties/{property_id}/dataStreams/{stream_id} Example: \"properties/1000/dataStreams/2000\"",
	//       "location": "path",
	//       "pattern": "^properties/[^/]+/dataStreams/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     },
	//     "updateMask": {
	//       "description": "Required. The list of fields to be updated. Omitted fields will not be updated. To replace the entire entity, use one path with the string \"*\" to match all fields.",
	//       "format": "google-fieldmask",
	//       "location": "query",
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1alpha/{+name}",
	//   "request": {
	//     "$ref": "GoogleAnalyticsAdminV1alphaDataStream"
	//   },
	//   "response": {
	//     "$ref": "GoogleAnalyticsAdminV1alphaDataStream"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/analytics.edit"
	//   ]
	// }

}

// method id "analyticsadmin.properties.dataStreams.updateEnhancedMeasurementSettings":

type PropertiesDataStreamsUpdateEnhancedMeasurementSettingsCall struct {
	s                                                      *Service
	name                                                   string
	googleanalyticsadminv1alphaenhancedmeasurementsettings *GoogleAnalyticsAdminV1alphaEnhancedMeasurementSettings
	urlParams_                                             gensupport.URLParams
	ctx_                                                   context.Context
	header_                                                http.Header
}

// UpdateEnhancedMeasurementSettings: Updates the enhanced measurement
// settings for this data stream. Note that the stream must enable
// enhanced measurement for these settings to take effect.
//
//   - name: Output only. Resource name of the Enhanced Measurement
//     Settings. Format:
//     properties/{property_id}/dataStreams/{data_stream}/enhancedMeasureme
//     ntSettings Example:
//     "properties/1000/dataStreams/2000/enhancedMeasurementSettings".
func (r *PropertiesDataStreamsService) UpdateEnhancedMeasurementSettings(name string, googleanalyticsadminv1alphaenhancedmeasurementsettings *GoogleAnalyticsAdminV1alphaEnhancedMeasurementSettings) *PropertiesDataStreamsUpdateEnhancedMeasurementSettingsCall {
	c := &PropertiesDataStreamsUpdateEnhancedMeasurementSettingsCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	c.googleanalyticsadminv1alphaenhancedmeasurementsettings = googleanalyticsadminv1alphaenhancedmeasurementsettings
	return c
}

// UpdateMask sets the optional parameter "updateMask": Required. The
// list of fields to be updated. Field names must be in snake case
// (e.g., "field_to_update"). Omitted fields will not be updated. To
// replace the entire entity, use one path with the string "*" to match
// all fields.
func (c *PropertiesDataStreamsUpdateEnhancedMeasurementSettingsCall) UpdateMask(updateMask string) *PropertiesDataStreamsUpdateEnhancedMeasurementSettingsCall {
	c.urlParams_.Set("updateMask", updateMask)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *PropertiesDataStreamsUpdateEnhancedMeasurementSettingsCall) Fields(s ...googleapi.Field) *PropertiesDataStreamsUpdateEnhancedMeasurementSettingsCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *PropertiesDataStreamsUpdateEnhancedMeasurementSettingsCall) Context(ctx context.Context) *PropertiesDataStreamsUpdateEnhancedMeasurementSettingsCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *PropertiesDataStreamsUpdateEnhancedMeasurementSettingsCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *PropertiesDataStreamsUpdateEnhancedMeasurementSettingsCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.googleanalyticsadminv1alphaenhancedmeasurementsettings)
	if err != nil {
		return nil, err
	}
	reqHeaders.Set("Content-Type", "application/json")
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1alpha/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("PATCH", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "analyticsadmin.properties.dataStreams.updateEnhancedMeasurementSettings" call.
// Exactly one of
// *GoogleAnalyticsAdminV1alphaEnhancedMeasurementSettings or error will
// be non-nil. Any non-2xx status code is an error. Response headers are
// in either
// *GoogleAnalyticsAdminV1alphaEnhancedMeasurementSettings.ServerResponse
// .Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was
// returned.
func (c *PropertiesDataStreamsUpdateEnhancedMeasurementSettingsCall) Do(opts ...googleapi.CallOption) (*GoogleAnalyticsAdminV1alphaEnhancedMeasurementSettings, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleAnalyticsAdminV1alphaEnhancedMeasurementSettings{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Updates the enhanced measurement settings for this data stream. Note that the stream must enable enhanced measurement for these settings to take effect.",
	//   "flatPath": "v1alpha/properties/{propertiesId}/dataStreams/{dataStreamsId}/enhancedMeasurementSettings",
	//   "httpMethod": "PATCH",
	//   "id": "analyticsadmin.properties.dataStreams.updateEnhancedMeasurementSettings",
	//   "parameterOrder": [
	//     "name"
	//   ],
	//   "parameters": {
	//     "name": {
	//       "description": "Output only. Resource name of the Enhanced Measurement Settings. Format: properties/{property_id}/dataStreams/{data_stream}/enhancedMeasurementSettings Example: \"properties/1000/dataStreams/2000/enhancedMeasurementSettings\"",
	//       "location": "path",
	//       "pattern": "^properties/[^/]+/dataStreams/[^/]+/enhancedMeasurementSettings$",
	//       "required": true,
	//       "type": "string"
	//     },
	//     "updateMask": {
	//       "description": "Required. The list of fields to be updated. Field names must be in snake case (e.g., \"field_to_update\"). Omitted fields will not be updated. To replace the entire entity, use one path with the string \"*\" to match all fields.",
	//       "format": "google-fieldmask",
	//       "location": "query",
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1alpha/{+name}",
	//   "request": {
	//     "$ref": "GoogleAnalyticsAdminV1alphaEnhancedMeasurementSettings"
	//   },
	//   "response": {
	//     "$ref": "GoogleAnalyticsAdminV1alphaEnhancedMeasurementSettings"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/analytics.edit"
	//   ]
	// }

}

// method id "analyticsadmin.properties.dataStreams.measurementProtocolSecrets.create":

type PropertiesDataStreamsMeasurementProtocolSecretsCreateCall struct {
	s                                                    *Service
	parent                                               string
	googleanalyticsadminv1alphameasurementprotocolsecret *GoogleAnalyticsAdminV1alphaMeasurementProtocolSecret
	urlParams_                                           gensupport.URLParams
	ctx_                                                 context.Context
	header_                                              http.Header
}

// Create: Creates a measurement protocol secret.
//
//   - parent: The parent resource where this secret will be created.
//     Format: properties/{property}/dataStreams/{dataStream}.
func (r *PropertiesDataStreamsMeasurementProtocolSecretsService) Create(parent string, googleanalyticsadminv1alphameasurementprotocolsecret *GoogleAnalyticsAdminV1alphaMeasurementProtocolSecret) *PropertiesDataStreamsMeasurementProtocolSecretsCreateCall {
	c := &PropertiesDataStreamsMeasurementProtocolSecretsCreateCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	c.googleanalyticsadminv1alphameasurementprotocolsecret = googleanalyticsadminv1alphameasurementprotocolsecret
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *PropertiesDataStreamsMeasurementProtocolSecretsCreateCall) Fields(s ...googleapi.Field) *PropertiesDataStreamsMeasurementProtocolSecretsCreateCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *PropertiesDataStreamsMeasurementProtocolSecretsCreateCall) Context(ctx context.Context) *PropertiesDataStreamsMeasurementProtocolSecretsCreateCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *PropertiesDataStreamsMeasurementProtocolSecretsCreateCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *PropertiesDataStreamsMeasurementProtocolSecretsCreateCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.googleanalyticsadminv1alphameasurementprotocolsecret)
	if err != nil {
		return nil, err
	}
	reqHeaders.Set("Content-Type", "application/json")
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1alpha/{+parent}/measurementProtocolSecrets")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "analyticsadmin.properties.dataStreams.measurementProtocolSecrets.create" call.
// Exactly one of *GoogleAnalyticsAdminV1alphaMeasurementProtocolSecret
// or error will be non-nil. Any non-2xx status code is an error.
// Response headers are in either
// *GoogleAnalyticsAdminV1alphaMeasurementProtocolSecret.ServerResponse.H
// eader or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was
// returned.
func (c *PropertiesDataStreamsMeasurementProtocolSecretsCreateCall) Do(opts ...googleapi.CallOption) (*GoogleAnalyticsAdminV1alphaMeasurementProtocolSecret, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleAnalyticsAdminV1alphaMeasurementProtocolSecret{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Creates a measurement protocol secret.",
	//   "flatPath": "v1alpha/properties/{propertiesId}/dataStreams/{dataStreamsId}/measurementProtocolSecrets",
	//   "httpMethod": "POST",
	//   "id": "analyticsadmin.properties.dataStreams.measurementProtocolSecrets.create",
	//   "parameterOrder": [
	//     "parent"
	//   ],
	//   "parameters": {
	//     "parent": {
	//       "description": "Required. The parent resource where this secret will be created. Format: properties/{property}/dataStreams/{dataStream}",
	//       "location": "path",
	//       "pattern": "^properties/[^/]+/dataStreams/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1alpha/{+parent}/measurementProtocolSecrets",
	//   "request": {
	//     "$ref": "GoogleAnalyticsAdminV1alphaMeasurementProtocolSecret"
	//   },
	//   "response": {
	//     "$ref": "GoogleAnalyticsAdminV1alphaMeasurementProtocolSecret"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/analytics.edit"
	//   ]
	// }

}

// method id "analyticsadmin.properties.dataStreams.measurementProtocolSecrets.delete":

type PropertiesDataStreamsMeasurementProtocolSecretsDeleteCall struct {
	s          *Service
	name       string
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Delete: Deletes target MeasurementProtocolSecret.
//
//   - name: The name of the MeasurementProtocolSecret to delete. Format:
//     properties/{property}/dataStreams/{dataStream}/measurementProtocolSe
//     crets/{measurementProtocolSecret}.
func (r *PropertiesDataStreamsMeasurementProtocolSecretsService) Delete(name string) *PropertiesDataStreamsMeasurementProtocolSecretsDeleteCall {
	c := &PropertiesDataStreamsMeasurementProtocolSecretsDeleteCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *PropertiesDataStreamsMeasurementProtocolSecretsDeleteCall) Fields(s ...googleapi.Field) *PropertiesDataStreamsMeasurementProtocolSecretsDeleteCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *PropertiesDataStreamsMeasurementProtocolSecretsDeleteCall) Context(ctx context.Context) *PropertiesDataStreamsMeasurementProtocolSecretsDeleteCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *PropertiesDataStreamsMeasurementProtocolSecretsDeleteCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *PropertiesDataStreamsMeasurementProtocolSecretsDeleteCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1alpha/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("DELETE", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "analyticsadmin.properties.dataStreams.measurementProtocolSecrets.delete" call.
// Exactly one of *GoogleProtobufEmpty or error will be non-nil. Any
// non-2xx status code is an error. Response headers are in either
// *GoogleProtobufEmpty.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was
// because http.StatusNotModified was returned.
func (c *PropertiesDataStreamsMeasurementProtocolSecretsDeleteCall) Do(opts ...googleapi.CallOption) (*GoogleProtobufEmpty, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleProtobufEmpty{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Deletes target MeasurementProtocolSecret.",
	//   "flatPath": "v1alpha/properties/{propertiesId}/dataStreams/{dataStreamsId}/measurementProtocolSecrets/{measurementProtocolSecretsId}",
	//   "httpMethod": "DELETE",
	//   "id": "analyticsadmin.properties.dataStreams.measurementProtocolSecrets.delete",
	//   "parameterOrder": [
	//     "name"
	//   ],
	//   "parameters": {
	//     "name": {
	//       "description": "Required. The name of the MeasurementProtocolSecret to delete. Format: properties/{property}/dataStreams/{dataStream}/measurementProtocolSecrets/{measurementProtocolSecret}",
	//       "location": "path",
	//       "pattern": "^properties/[^/]+/dataStreams/[^/]+/measurementProtocolSecrets/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1alpha/{+name}",
	//   "response": {
	//     "$ref": "GoogleProtobufEmpty"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/analytics.edit"
	//   ]
	// }

}

// method id "analyticsadmin.properties.dataStreams.measurementProtocolSecrets.get":

type PropertiesDataStreamsMeasurementProtocolSecretsGetCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Lookup for a single "GA4" MeasurementProtocolSecret.
//
//   - name: The name of the measurement protocol secret to lookup.
//     Format:
//     properties/{property}/dataStreams/{dataStream}/measurementProtocolSe
//     crets/{measurementProtocolSecret}.
func (r *PropertiesDataStreamsMeasurementProtocolSecretsService) Get(name string) *PropertiesDataStreamsMeasurementProtocolSecretsGetCall {
	c := &PropertiesDataStreamsMeasurementProtocolSecretsGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *PropertiesDataStreamsMeasurementProtocolSecretsGetCall) Fields(s ...googleapi.Field) *PropertiesDataStreamsMeasurementProtocolSecretsGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets the optional parameter which makes the operation
// fail if the object's ETag matches the given value. This is useful for
// getting updates only after the object has changed since the last
// request. Use googleapi.IsNotModified to check whether the response
// error from Do is the result of In-None-Match.
func (c *PropertiesDataStreamsMeasurementProtocolSecretsGetCall) IfNoneMatch(entityTag string) *PropertiesDataStreamsMeasurementProtocolSecretsGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *PropertiesDataStreamsMeasurementProtocolSecretsGetCall) Context(ctx context.Context) *PropertiesDataStreamsMeasurementProtocolSecretsGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *PropertiesDataStreamsMeasurementProtocolSecretsGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *PropertiesDataStreamsMeasurementProtocolSecretsGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1alpha/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "analyticsadmin.properties.dataStreams.measurementProtocolSecrets.get" call.
// Exactly one of *GoogleAnalyticsAdminV1alphaMeasurementProtocolSecret
// or error will be non-nil. Any non-2xx status code is an error.
// Response headers are in either
// *GoogleAnalyticsAdminV1alphaMeasurementProtocolSecret.ServerResponse.H
// eader or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was
// returned.
func (c *PropertiesDataStreamsMeasurementProtocolSecretsGetCall) Do(opts ...googleapi.CallOption) (*GoogleAnalyticsAdminV1alphaMeasurementProtocolSecret, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleAnalyticsAdminV1alphaMeasurementProtocolSecret{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Lookup for a single \"GA4\" MeasurementProtocolSecret.",
	//   "flatPath": "v1alpha/properties/{propertiesId}/dataStreams/{dataStreamsId}/measurementProtocolSecrets/{measurementProtocolSecretsId}",
	//   "httpMethod": "GET",
	//   "id": "analyticsadmin.properties.dataStreams.measurementProtocolSecrets.get",
	//   "parameterOrder": [
	//     "name"
	//   ],
	//   "parameters": {
	//     "name": {
	//       "description": "Required. The name of the measurement protocol secret to lookup. Format: properties/{property}/dataStreams/{dataStream}/measurementProtocolSecrets/{measurementProtocolSecret}",
	//       "location": "path",
	//       "pattern": "^properties/[^/]+/dataStreams/[^/]+/measurementProtocolSecrets/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1alpha/{+name}",
	//   "response": {
	//     "$ref": "GoogleAnalyticsAdminV1alphaMeasurementProtocolSecret"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/analytics.edit",
	//     "https://www.googleapis.com/auth/analytics.readonly"
	//   ]
	// }

}

// method id "analyticsadmin.properties.dataStreams.measurementProtocolSecrets.list":

type PropertiesDataStreamsMeasurementProtocolSecretsListCall struct {
	s            *Service
	parent       string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Returns child MeasurementProtocolSecrets under the specified
// parent Property.
//
//   - parent: The resource name of the parent stream. Format:
//     properties/{property}/dataStreams/{dataStream}/measurementProtocolSe
//     crets.
func (r *PropertiesDataStreamsMeasurementProtocolSecretsService) List(parent string) *PropertiesDataStreamsMeasurementProtocolSecretsListCall {
	c := &PropertiesDataStreamsMeasurementProtocolSecretsListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	return c
}

// PageSize sets the optional parameter "pageSize": The maximum number
// of resources to return. If unspecified, at most 10 resources will be
// returned. The maximum value is 10. Higher values will be coerced to
// the maximum.
func (c *PropertiesDataStreamsMeasurementProtocolSecretsListCall) PageSize(pageSize int64) *PropertiesDataStreamsMeasurementProtocolSecretsListCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": A page token,
// received from a previous `ListMeasurementProtocolSecrets` call.
// Provide this to retrieve the subsequent page. When paginating, all
// other parameters provided to `ListMeasurementProtocolSecrets` must
// match the call that provided the page token.
func (c *PropertiesDataStreamsMeasurementProtocolSecretsListCall) PageToken(pageToken string) *PropertiesDataStreamsMeasurementProtocolSecretsListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *PropertiesDataStreamsMeasurementProtocolSecretsListCall) Fields(s ...googleapi.Field) *PropertiesDataStreamsMeasurementProtocolSecretsListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets the optional parameter which makes the operation
// fail if the object's ETag matches the given value. This is useful for
// getting updates only after the object has changed since the last
// request. Use googleapi.IsNotModified to check whether the response
// error from Do is the result of In-None-Match.
func (c *PropertiesDataStreamsMeasurementProtocolSecretsListCall) IfNoneMatch(entityTag string) *PropertiesDataStreamsMeasurementProtocolSecretsListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *PropertiesDataStreamsMeasurementProtocolSecretsListCall) Context(ctx context.Context) *PropertiesDataStreamsMeasurementProtocolSecretsListCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *PropertiesDataStreamsMeasurementProtocolSecretsListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *PropertiesDataStreamsMeasurementProtocolSecretsListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1alpha/{+parent}/measurementProtocolSecrets")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "analyticsadmin.properties.dataStreams.measurementProtocolSecrets.list" call.
// Exactly one of
// *GoogleAnalyticsAdminV1alphaListMeasurementProtocolSecretsResponse or
// error will be non-nil. Any non-2xx status code is an error. Response
// headers are in either
// *GoogleAnalyticsAdminV1alphaListMeasurementProtocolSecretsResponse.Ser
// verResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was
// returned.
func (c *PropertiesDataStreamsMeasurementProtocolSecretsListCall) Do(opts ...googleapi.CallOption) (*GoogleAnalyticsAdminV1alphaListMeasurementProtocolSecretsResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleAnalyticsAdminV1alphaListMeasurementProtocolSecretsResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Returns child MeasurementProtocolSecrets under the specified parent Property.",
	//   "flatPath": "v1alpha/properties/{propertiesId}/dataStreams/{dataStreamsId}/measurementProtocolSecrets",
	//   "httpMethod": "GET",
	//   "id": "analyticsadmin.properties.dataStreams.measurementProtocolSecrets.list",
	//   "parameterOrder": [
	//     "parent"
	//   ],
	//   "parameters": {
	//     "pageSize": {
	//       "description": "The maximum number of resources to return. If unspecified, at most 10 resources will be returned. The maximum value is 10. Higher values will be coerced to the maximum.",
	//       "format": "int32",
	//       "location": "query",
	//       "type": "integer"
	//     },
	//     "pageToken": {
	//       "description": "A page token, received from a previous `ListMeasurementProtocolSecrets` call. Provide this to retrieve the subsequent page. When paginating, all other parameters provided to `ListMeasurementProtocolSecrets` must match the call that provided the page token.",
	//       "location": "query",
	//       "type": "string"
	//     },
	//     "parent": {
	//       "description": "Required. The resource name of the parent stream. Format: properties/{property}/dataStreams/{dataStream}/measurementProtocolSecrets",
	//       "location": "path",
	//       "pattern": "^properties/[^/]+/dataStreams/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1alpha/{+parent}/measurementProtocolSecrets",
	//   "response": {
	//     "$ref": "GoogleAnalyticsAdminV1alphaListMeasurementProtocolSecretsResponse"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/analytics.edit",
	//     "https://www.googleapis.com/auth/analytics.readonly"
	//   ]
	// }

}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *PropertiesDataStreamsMeasurementProtocolSecretsListCall) Pages(ctx context.Context, f func(*GoogleAnalyticsAdminV1alphaListMeasurementProtocolSecretsResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken")) // reset paging to original point
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

// method id "analyticsadmin.properties.dataStreams.measurementProtocolSecrets.patch":

type PropertiesDataStreamsMeasurementProtocolSecretsPatchCall struct {
	s                                                    *Service
	name                                                 string
	googleanalyticsadminv1alphameasurementprotocolsecret *GoogleAnalyticsAdminV1alphaMeasurementProtocolSecret
	urlParams_                                           gensupport.URLParams
	ctx_                                                 context.Context
	header_                                              http.Header
}

// Patch: Updates a measurement protocol secret.
//
//   - name: Output only. Resource name of this secret. This secret may be
//     a child of any type of stream. Format:
//     properties/{property}/dataStreams/{dataStream}/measurementProtocolSe
//     crets/{measurementProtocolSecret}.
func (r *PropertiesDataStreamsMeasurementProtocolSecretsService) Patch(name string, googleanalyticsadminv1alphameasurementprotocolsecret *GoogleAnalyticsAdminV1alphaMeasurementProtocolSecret) *PropertiesDataStreamsMeasurementProtocolSecretsPatchCall {
	c := &PropertiesDataStreamsMeasurementProtocolSecretsPatchCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	c.googleanalyticsadminv1alphameasurementprotocolsecret = googleanalyticsadminv1alphameasurementprotocolsecret
	return c
}

// UpdateMask sets the optional parameter "updateMask": The list of
// fields to be updated. Omitted fields will not be updated.
func (c *PropertiesDataStreamsMeasurementProtocolSecretsPatchCall) UpdateMask(updateMask string) *PropertiesDataStreamsMeasurementProtocolSecretsPatchCall {
	c.urlParams_.Set("updateMask", updateMask)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *PropertiesDataStreamsMeasurementProtocolSecretsPatchCall) Fields(s ...googleapi.Field) *PropertiesDataStreamsMeasurementProtocolSecretsPatchCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *PropertiesDataStreamsMeasurementProtocolSecretsPatchCall) Context(ctx context.Context) *PropertiesDataStreamsMeasurementProtocolSecretsPatchCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *PropertiesDataStreamsMeasurementProtocolSecretsPatchCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *PropertiesDataStreamsMeasurementProtocolSecretsPatchCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.googleanalyticsadminv1alphameasurementprotocolsecret)
	if err != nil {
		return nil, err
	}
	reqHeaders.Set("Content-Type", "application/json")
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1alpha/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("PATCH", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "analyticsadmin.properties.dataStreams.measurementProtocolSecrets.patch" call.
// Exactly one of *GoogleAnalyticsAdminV1alphaMeasurementProtocolSecret
// or error will be non-nil. Any non-2xx status code is an error.
// Response headers are in either
// *GoogleAnalyticsAdminV1alphaMeasurementProtocolSecret.ServerResponse.H
// eader or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was
// returned.
func (c *PropertiesDataStreamsMeasurementProtocolSecretsPatchCall) Do(opts ...googleapi.CallOption) (*GoogleAnalyticsAdminV1alphaMeasurementProtocolSecret, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleAnalyticsAdminV1alphaMeasurementProtocolSecret{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Updates a measurement protocol secret.",
	//   "flatPath": "v1alpha/properties/{propertiesId}/dataStreams/{dataStreamsId}/measurementProtocolSecrets/{measurementProtocolSecretsId}",
	//   "httpMethod": "PATCH",
	//   "id": "analyticsadmin.properties.dataStreams.measurementProtocolSecrets.patch",
	//   "parameterOrder": [
	//     "name"
	//   ],
	//   "parameters": {
	//     "name": {
	//       "description": "Output only. Resource name of this secret. This secret may be a child of any type of stream. Format: properties/{property}/dataStreams/{dataStream}/measurementProtocolSecrets/{measurementProtocolSecret}",
	//       "location": "path",
	//       "pattern": "^properties/[^/]+/dataStreams/[^/]+/measurementProtocolSecrets/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     },
	//     "updateMask": {
	//       "description": "The list of fields to be updated. Omitted fields will not be updated.",
	//       "format": "google-fieldmask",
	//       "location": "query",
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1alpha/{+name}",
	//   "request": {
	//     "$ref": "GoogleAnalyticsAdminV1alphaMeasurementProtocolSecret"
	//   },
	//   "response": {
	//     "$ref": "GoogleAnalyticsAdminV1alphaMeasurementProtocolSecret"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/analytics.edit"
	//   ]
	// }

}

// method id "analyticsadmin.properties.displayVideo360AdvertiserLinkProposals.approve":

type PropertiesDisplayVideo360AdvertiserLinkProposalsApproveCall struct {
	s                                                                              *Service
	name                                                                           string
	googleanalyticsadminv1alphaapprovedisplayvideo360advertiserlinkproposalrequest *GoogleAnalyticsAdminV1alphaApproveDisplayVideo360AdvertiserLinkProposalRequest
	urlParams_                                                                     gensupport.URLParams
	ctx_                                                                           context.Context
	header_                                                                        http.Header
}

// Approve: Approves a DisplayVideo360AdvertiserLinkProposal. The
// DisplayVideo360AdvertiserLinkProposal will be deleted and a new
// DisplayVideo360AdvertiserLink will be created.
//
//   - name: The name of the DisplayVideo360AdvertiserLinkProposal to
//     approve. Example format:
//     properties/1234/displayVideo360AdvertiserLinkProposals/5678.
func (r *PropertiesDisplayVideo360AdvertiserLinkProposalsService) Approve(name string, googleanalyticsadminv1alphaapprovedisplayvideo360advertiserlinkproposalrequest *GoogleAnalyticsAdminV1alphaApproveDisplayVideo360AdvertiserLinkProposalRequest) *PropertiesDisplayVideo360AdvertiserLinkProposalsApproveCall {
	c := &PropertiesDisplayVideo360AdvertiserLinkProposalsApproveCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	c.googleanalyticsadminv1alphaapprovedisplayvideo360advertiserlinkproposalrequest = googleanalyticsadminv1alphaapprovedisplayvideo360advertiserlinkproposalrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *PropertiesDisplayVideo360AdvertiserLinkProposalsApproveCall) Fields(s ...googleapi.Field) *PropertiesDisplayVideo360AdvertiserLinkProposalsApproveCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *PropertiesDisplayVideo360AdvertiserLinkProposalsApproveCall) Context(ctx context.Context) *PropertiesDisplayVideo360AdvertiserLinkProposalsApproveCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *PropertiesDisplayVideo360AdvertiserLinkProposalsApproveCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *PropertiesDisplayVideo360AdvertiserLinkProposalsApproveCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.googleanalyticsadminv1alphaapprovedisplayvideo360advertiserlinkproposalrequest)
	if err != nil {
		return nil, err
	}
	reqHeaders.Set("Content-Type", "application/json")
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1alpha/{+name}:approve")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "analyticsadmin.properties.displayVideo360AdvertiserLinkProposals.approve" call.
// Exactly one of
// *GoogleAnalyticsAdminV1alphaApproveDisplayVideo360AdvertiserLinkPropos
// alResponse or error will be non-nil. Any non-2xx status code is an
// error. Response headers are in either
// *GoogleAnalyticsAdminV1alphaApproveDisplayVideo360AdvertiserLinkPropos
// alResponse.ServerResponse.Header or (if a response was returned at
// all) in error.(*googleapi.Error).Header. Use googleapi.IsNotModified
// to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *PropertiesDisplayVideo360AdvertiserLinkProposalsApproveCall) Do(opts ...googleapi.CallOption) (*GoogleAnalyticsAdminV1alphaApproveDisplayVideo360AdvertiserLinkProposalResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleAnalyticsAdminV1alphaApproveDisplayVideo360AdvertiserLinkProposalResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Approves a DisplayVideo360AdvertiserLinkProposal. The DisplayVideo360AdvertiserLinkProposal will be deleted and a new DisplayVideo360AdvertiserLink will be created.",
	//   "flatPath": "v1alpha/properties/{propertiesId}/displayVideo360AdvertiserLinkProposals/{displayVideo360AdvertiserLinkProposalsId}:approve",
	//   "httpMethod": "POST",
	//   "id": "analyticsadmin.properties.displayVideo360AdvertiserLinkProposals.approve",
	//   "parameterOrder": [
	//     "name"
	//   ],
	//   "parameters": {
	//     "name": {
	//       "description": "Required. The name of the DisplayVideo360AdvertiserLinkProposal to approve. Example format: properties/1234/displayVideo360AdvertiserLinkProposals/5678",
	//       "location": "path",
	//       "pattern": "^properties/[^/]+/displayVideo360AdvertiserLinkProposals/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1alpha/{+name}:approve",
	//   "request": {
	//     "$ref": "GoogleAnalyticsAdminV1alphaApproveDisplayVideo360AdvertiserLinkProposalRequest"
	//   },
	//   "response": {
	//     "$ref": "GoogleAnalyticsAdminV1alphaApproveDisplayVideo360AdvertiserLinkProposalResponse"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/analytics.edit"
	//   ]
	// }

}

// method id "analyticsadmin.properties.displayVideo360AdvertiserLinkProposals.cancel":

type PropertiesDisplayVideo360AdvertiserLinkProposalsCancelCall struct {
	s                                                                             *Service
	name                                                                          string
	googleanalyticsadminv1alphacanceldisplayvideo360advertiserlinkproposalrequest *GoogleAnalyticsAdminV1alphaCancelDisplayVideo360AdvertiserLinkProposalRequest
	urlParams_                                                                    gensupport.URLParams
	ctx_                                                                          context.Context
	header_                                                                       http.Header
}

// Cancel: Cancels a DisplayVideo360AdvertiserLinkProposal. Cancelling
// can mean either: - Declining a proposal initiated from Display &
// Video 360 - Withdrawing a proposal initiated from Google Analytics
// After being cancelled, a proposal will eventually be deleted
// automatically.
//
//   - name: The name of the DisplayVideo360AdvertiserLinkProposal to
//     cancel. Example format:
//     properties/1234/displayVideo360AdvertiserLinkProposals/5678.
func (r *PropertiesDisplayVideo360AdvertiserLinkProposalsService) Cancel(name string, googleanalyticsadminv1alphacanceldisplayvideo360advertiserlinkproposalrequest *GoogleAnalyticsAdminV1alphaCancelDisplayVideo360AdvertiserLinkProposalRequest) *PropertiesDisplayVideo360AdvertiserLinkProposalsCancelCall {
	c := &PropertiesDisplayVideo360AdvertiserLinkProposalsCancelCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	c.googleanalyticsadminv1alphacanceldisplayvideo360advertiserlinkproposalrequest = googleanalyticsadminv1alphacanceldisplayvideo360advertiserlinkproposalrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *PropertiesDisplayVideo360AdvertiserLinkProposalsCancelCall) Fields(s ...googleapi.Field) *PropertiesDisplayVideo360AdvertiserLinkProposalsCancelCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *PropertiesDisplayVideo360AdvertiserLinkProposalsCancelCall) Context(ctx context.Context) *PropertiesDisplayVideo360AdvertiserLinkProposalsCancelCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *PropertiesDisplayVideo360AdvertiserLinkProposalsCancelCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *PropertiesDisplayVideo360AdvertiserLinkProposalsCancelCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.googleanalyticsadminv1alphacanceldisplayvideo360advertiserlinkproposalrequest)
	if err != nil {
		return nil, err
	}
	reqHeaders.Set("Content-Type", "application/json")
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1alpha/{+name}:cancel")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "analyticsadmin.properties.displayVideo360AdvertiserLinkProposals.cancel" call.
// Exactly one of
// *GoogleAnalyticsAdminV1alphaDisplayVideo360AdvertiserLinkProposal or
// error will be non-nil. Any non-2xx status code is an error. Response
// headers are in either
// *GoogleAnalyticsAdminV1alphaDisplayVideo360AdvertiserLinkProposal.Serv
// erResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was
// returned.
func (c *PropertiesDisplayVideo360AdvertiserLinkProposalsCancelCall) Do(opts ...googleapi.CallOption) (*GoogleAnalyticsAdminV1alphaDisplayVideo360AdvertiserLinkProposal, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleAnalyticsAdminV1alphaDisplayVideo360AdvertiserLinkProposal{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Cancels a DisplayVideo360AdvertiserLinkProposal. Cancelling can mean either: - Declining a proposal initiated from Display \u0026 Video 360 - Withdrawing a proposal initiated from Google Analytics After being cancelled, a proposal will eventually be deleted automatically.",
	//   "flatPath": "v1alpha/properties/{propertiesId}/displayVideo360AdvertiserLinkProposals/{displayVideo360AdvertiserLinkProposalsId}:cancel",
	//   "httpMethod": "POST",
	//   "id": "analyticsadmin.properties.displayVideo360AdvertiserLinkProposals.cancel",
	//   "parameterOrder": [
	//     "name"
	//   ],
	//   "parameters": {
	//     "name": {
	//       "description": "Required. The name of the DisplayVideo360AdvertiserLinkProposal to cancel. Example format: properties/1234/displayVideo360AdvertiserLinkProposals/5678",
	//       "location": "path",
	//       "pattern": "^properties/[^/]+/displayVideo360AdvertiserLinkProposals/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1alpha/{+name}:cancel",
	//   "request": {
	//     "$ref": "GoogleAnalyticsAdminV1alphaCancelDisplayVideo360AdvertiserLinkProposalRequest"
	//   },
	//   "response": {
	//     "$ref": "GoogleAnalyticsAdminV1alphaDisplayVideo360AdvertiserLinkProposal"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/analytics.edit"
	//   ]
	// }

}

// method id "analyticsadmin.properties.displayVideo360AdvertiserLinkProposals.create":

type PropertiesDisplayVideo360AdvertiserLinkProposalsCreateCall struct {
	s                                                                *Service
	parent                                                           string
	googleanalyticsadminv1alphadisplayvideo360advertiserlinkproposal *GoogleAnalyticsAdminV1alphaDisplayVideo360AdvertiserLinkProposal
	urlParams_                                                       gensupport.URLParams
	ctx_                                                             context.Context
	header_                                                          http.Header
}

// Create: Creates a DisplayVideo360AdvertiserLinkProposal.
//
// - parent: Example format: properties/1234.
func (r *PropertiesDisplayVideo360AdvertiserLinkProposalsService) Create(parent string, googleanalyticsadminv1alphadisplayvideo360advertiserlinkproposal *GoogleAnalyticsAdminV1alphaDisplayVideo360AdvertiserLinkProposal) *PropertiesDisplayVideo360AdvertiserLinkProposalsCreateCall {
	c := &PropertiesDisplayVideo360AdvertiserLinkProposalsCreateCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	c.googleanalyticsadminv1alphadisplayvideo360advertiserlinkproposal = googleanalyticsadminv1alphadisplayvideo360advertiserlinkproposal
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *PropertiesDisplayVideo360AdvertiserLinkProposalsCreateCall) Fields(s ...googleapi.Field) *PropertiesDisplayVideo360AdvertiserLinkProposalsCreateCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *PropertiesDisplayVideo360AdvertiserLinkProposalsCreateCall) Context(ctx context.Context) *PropertiesDisplayVideo360AdvertiserLinkProposalsCreateCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *PropertiesDisplayVideo360AdvertiserLinkProposalsCreateCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *PropertiesDisplayVideo360AdvertiserLinkProposalsCreateCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.googleanalyticsadminv1alphadisplayvideo360advertiserlinkproposal)
	if err != nil {
		return nil, err
	}
	reqHeaders.Set("Content-Type", "application/json")
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1alpha/{+parent}/displayVideo360AdvertiserLinkProposals")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "analyticsadmin.properties.displayVideo360AdvertiserLinkProposals.create" call.
// Exactly one of
// *GoogleAnalyticsAdminV1alphaDisplayVideo360AdvertiserLinkProposal or
// error will be non-nil. Any non-2xx status code is an error. Response
// headers are in either
// *GoogleAnalyticsAdminV1alphaDisplayVideo360AdvertiserLinkProposal.Serv
// erResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was
// returned.
func (c *PropertiesDisplayVideo360AdvertiserLinkProposalsCreateCall) Do(opts ...googleapi.CallOption) (*GoogleAnalyticsAdminV1alphaDisplayVideo360AdvertiserLinkProposal, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleAnalyticsAdminV1alphaDisplayVideo360AdvertiserLinkProposal{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Creates a DisplayVideo360AdvertiserLinkProposal.",
	//   "flatPath": "v1alpha/properties/{propertiesId}/displayVideo360AdvertiserLinkProposals",
	//   "httpMethod": "POST",
	//   "id": "analyticsadmin.properties.displayVideo360AdvertiserLinkProposals.create",
	//   "parameterOrder": [
	//     "parent"
	//   ],
	//   "parameters": {
	//     "parent": {
	//       "description": "Required. Example format: properties/1234",
	//       "location": "path",
	//       "pattern": "^properties/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1alpha/{+parent}/displayVideo360AdvertiserLinkProposals",
	//   "request": {
	//     "$ref": "GoogleAnalyticsAdminV1alphaDisplayVideo360AdvertiserLinkProposal"
	//   },
	//   "response": {
	//     "$ref": "GoogleAnalyticsAdminV1alphaDisplayVideo360AdvertiserLinkProposal"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/analytics.edit"
	//   ]
	// }

}

// method id "analyticsadmin.properties.displayVideo360AdvertiserLinkProposals.delete":

type PropertiesDisplayVideo360AdvertiserLinkProposalsDeleteCall struct {
	s          *Service
	name       string
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Delete: Deletes a DisplayVideo360AdvertiserLinkProposal on a
// property. This can only be used on cancelled proposals.
//
//   - name: The name of the DisplayVideo360AdvertiserLinkProposal to
//     delete. Example format:
//     properties/1234/displayVideo360AdvertiserLinkProposals/5678.
func (r *PropertiesDisplayVideo360AdvertiserLinkProposalsService) Delete(name string) *PropertiesDisplayVideo360AdvertiserLinkProposalsDeleteCall {
	c := &PropertiesDisplayVideo360AdvertiserLinkProposalsDeleteCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *PropertiesDisplayVideo360AdvertiserLinkProposalsDeleteCall) Fields(s ...googleapi.Field) *PropertiesDisplayVideo360AdvertiserLinkProposalsDeleteCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *PropertiesDisplayVideo360AdvertiserLinkProposalsDeleteCall) Context(ctx context.Context) *PropertiesDisplayVideo360AdvertiserLinkProposalsDeleteCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *PropertiesDisplayVideo360AdvertiserLinkProposalsDeleteCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *PropertiesDisplayVideo360AdvertiserLinkProposalsDeleteCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1alpha/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("DELETE", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "analyticsadmin.properties.displayVideo360AdvertiserLinkProposals.delete" call.
// Exactly one of *GoogleProtobufEmpty or error will be non-nil. Any
// non-2xx status code is an error. Response headers are in either
// *GoogleProtobufEmpty.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was
// because http.StatusNotModified was returned.
func (c *PropertiesDisplayVideo360AdvertiserLinkProposalsDeleteCall) Do(opts ...googleapi.CallOption) (*GoogleProtobufEmpty, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleProtobufEmpty{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Deletes a DisplayVideo360AdvertiserLinkProposal on a property. This can only be used on cancelled proposals.",
	//   "flatPath": "v1alpha/properties/{propertiesId}/displayVideo360AdvertiserLinkProposals/{displayVideo360AdvertiserLinkProposalsId}",
	//   "httpMethod": "DELETE",
	//   "id": "analyticsadmin.properties.displayVideo360AdvertiserLinkProposals.delete",
	//   "parameterOrder": [
	//     "name"
	//   ],
	//   "parameters": {
	//     "name": {
	//       "description": "Required. The name of the DisplayVideo360AdvertiserLinkProposal to delete. Example format: properties/1234/displayVideo360AdvertiserLinkProposals/5678",
	//       "location": "path",
	//       "pattern": "^properties/[^/]+/displayVideo360AdvertiserLinkProposals/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1alpha/{+name}",
	//   "response": {
	//     "$ref": "GoogleProtobufEmpty"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/analytics.edit"
	//   ]
	// }

}

// method id "analyticsadmin.properties.displayVideo360AdvertiserLinkProposals.get":

type PropertiesDisplayVideo360AdvertiserLinkProposalsGetCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Lookup for a single DisplayVideo360AdvertiserLinkProposal.
//
//   - name: The name of the DisplayVideo360AdvertiserLinkProposal to get.
//     Example format:
//     properties/1234/displayVideo360AdvertiserLinkProposals/5678.
func (r *PropertiesDisplayVideo360AdvertiserLinkProposalsService) Get(name string) *PropertiesDisplayVideo360AdvertiserLinkProposalsGetCall {
	c := &PropertiesDisplayVideo360AdvertiserLinkProposalsGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *PropertiesDisplayVideo360AdvertiserLinkProposalsGetCall) Fields(s ...googleapi.Field) *PropertiesDisplayVideo360AdvertiserLinkProposalsGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets the optional parameter which makes the operation
// fail if the object's ETag matches the given value. This is useful for
// getting updates only after the object has changed since the last
// request. Use googleapi.IsNotModified to check whether the response
// error from Do is the result of In-None-Match.
func (c *PropertiesDisplayVideo360AdvertiserLinkProposalsGetCall) IfNoneMatch(entityTag string) *PropertiesDisplayVideo360AdvertiserLinkProposalsGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *PropertiesDisplayVideo360AdvertiserLinkProposalsGetCall) Context(ctx context.Context) *PropertiesDisplayVideo360AdvertiserLinkProposalsGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *PropertiesDisplayVideo360AdvertiserLinkProposalsGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *PropertiesDisplayVideo360AdvertiserLinkProposalsGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1alpha/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "analyticsadmin.properties.displayVideo360AdvertiserLinkProposals.get" call.
// Exactly one of
// *GoogleAnalyticsAdminV1alphaDisplayVideo360AdvertiserLinkProposal or
// error will be non-nil. Any non-2xx status code is an error. Response
// headers are in either
// *GoogleAnalyticsAdminV1alphaDisplayVideo360AdvertiserLinkProposal.Serv
// erResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was
// returned.
func (c *PropertiesDisplayVideo360AdvertiserLinkProposalsGetCall) Do(opts ...googleapi.CallOption) (*GoogleAnalyticsAdminV1alphaDisplayVideo360AdvertiserLinkProposal, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleAnalyticsAdminV1alphaDisplayVideo360AdvertiserLinkProposal{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Lookup for a single DisplayVideo360AdvertiserLinkProposal.",
	//   "flatPath": "v1alpha/properties/{propertiesId}/displayVideo360AdvertiserLinkProposals/{displayVideo360AdvertiserLinkProposalsId}",
	//   "httpMethod": "GET",
	//   "id": "analyticsadmin.properties.displayVideo360AdvertiserLinkProposals.get",
	//   "parameterOrder": [
	//     "name"
	//   ],
	//   "parameters": {
	//     "name": {
	//       "description": "Required. The name of the DisplayVideo360AdvertiserLinkProposal to get. Example format: properties/1234/displayVideo360AdvertiserLinkProposals/5678",
	//       "location": "path",
	//       "pattern": "^properties/[^/]+/displayVideo360AdvertiserLinkProposals/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1alpha/{+name}",
	//   "response": {
	//     "$ref": "GoogleAnalyticsAdminV1alphaDisplayVideo360AdvertiserLinkProposal"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/analytics.edit",
	//     "https://www.googleapis.com/auth/analytics.readonly"
	//   ]
	// }

}

// method id "analyticsadmin.properties.displayVideo360AdvertiserLinkProposals.list":

type PropertiesDisplayVideo360AdvertiserLinkProposalsListCall struct {
	s            *Service
	parent       string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Lists DisplayVideo360AdvertiserLinkProposals on a property.
//
// - parent: Example format: properties/1234.
func (r *PropertiesDisplayVideo360AdvertiserLinkProposalsService) List(parent string) *PropertiesDisplayVideo360AdvertiserLinkProposalsListCall {
	c := &PropertiesDisplayVideo360AdvertiserLinkProposalsListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	return c
}

// PageSize sets the optional parameter "pageSize": The maximum number
// of resources to return. If unspecified, at most 50 resources will be
// returned. The maximum value is 200 (higher values will be coerced to
// the maximum).
func (c *PropertiesDisplayVideo360AdvertiserLinkProposalsListCall) PageSize(pageSize int64) *PropertiesDisplayVideo360AdvertiserLinkProposalsListCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": A page token,
// received from a previous `ListDisplayVideo360AdvertiserLinkProposals`
// call. Provide this to retrieve the subsequent page. When paginating,
// all other parameters provided to
// `ListDisplayVideo360AdvertiserLinkProposals` must match the call that
// provided the page token.
func (c *PropertiesDisplayVideo360AdvertiserLinkProposalsListCall) PageToken(pageToken string) *PropertiesDisplayVideo360AdvertiserLinkProposalsListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *PropertiesDisplayVideo360AdvertiserLinkProposalsListCall) Fields(s ...googleapi.Field) *PropertiesDisplayVideo360AdvertiserLinkProposalsListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets the optional parameter which makes the operation
// fail if the object's ETag matches the given value. This is useful for
// getting updates only after the object has changed since the last
// request. Use googleapi.IsNotModified to check whether the response
// error from Do is the result of In-None-Match.
func (c *PropertiesDisplayVideo360AdvertiserLinkProposalsListCall) IfNoneMatch(entityTag string) *PropertiesDisplayVideo360AdvertiserLinkProposalsListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *PropertiesDisplayVideo360AdvertiserLinkProposalsListCall) Context(ctx context.Context) *PropertiesDisplayVideo360AdvertiserLinkProposalsListCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *PropertiesDisplayVideo360AdvertiserLinkProposalsListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *PropertiesDisplayVideo360AdvertiserLinkProposalsListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1alpha/{+parent}/displayVideo360AdvertiserLinkProposals")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "analyticsadmin.properties.displayVideo360AdvertiserLinkProposals.list" call.
// Exactly one of
// *GoogleAnalyticsAdminV1alphaListDisplayVideo360AdvertiserLinkProposals
// Response or error will be non-nil. Any non-2xx status code is an
// error. Response headers are in either
// *GoogleAnalyticsAdminV1alphaListDisplayVideo360AdvertiserLinkProposals
// Response.ServerResponse.Header or (if a response was returned at all)
// in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to
// check whether the returned error was because http.StatusNotModified
// was returned.
func (c *PropertiesDisplayVideo360AdvertiserLinkProposalsListCall) Do(opts ...googleapi.CallOption) (*GoogleAnalyticsAdminV1alphaListDisplayVideo360AdvertiserLinkProposalsResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleAnalyticsAdminV1alphaListDisplayVideo360AdvertiserLinkProposalsResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Lists DisplayVideo360AdvertiserLinkProposals on a property.",
	//   "flatPath": "v1alpha/properties/{propertiesId}/displayVideo360AdvertiserLinkProposals",
	//   "httpMethod": "GET",
	//   "id": "analyticsadmin.properties.displayVideo360AdvertiserLinkProposals.list",
	//   "parameterOrder": [
	//     "parent"
	//   ],
	//   "parameters": {
	//     "pageSize": {
	//       "description": "The maximum number of resources to return. If unspecified, at most 50 resources will be returned. The maximum value is 200 (higher values will be coerced to the maximum).",
	//       "format": "int32",
	//       "location": "query",
	//       "type": "integer"
	//     },
	//     "pageToken": {
	//       "description": "A page token, received from a previous `ListDisplayVideo360AdvertiserLinkProposals` call. Provide this to retrieve the subsequent page. When paginating, all other parameters provided to `ListDisplayVideo360AdvertiserLinkProposals` must match the call that provided the page token.",
	//       "location": "query",
	//       "type": "string"
	//     },
	//     "parent": {
	//       "description": "Required. Example format: properties/1234",
	//       "location": "path",
	//       "pattern": "^properties/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1alpha/{+parent}/displayVideo360AdvertiserLinkProposals",
	//   "response": {
	//     "$ref": "GoogleAnalyticsAdminV1alphaListDisplayVideo360AdvertiserLinkProposalsResponse"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/analytics.edit",
	//     "https://www.googleapis.com/auth/analytics.readonly"
	//   ]
	// }

}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *PropertiesDisplayVideo360AdvertiserLinkProposalsListCall) Pages(ctx context.Context, f func(*GoogleAnalyticsAdminV1alphaListDisplayVideo360AdvertiserLinkProposalsResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken")) // reset paging to original point
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

// method id "analyticsadmin.properties.displayVideo360AdvertiserLinks.create":

type PropertiesDisplayVideo360AdvertiserLinksCreateCall struct {
	s                                                        *Service
	parent                                                   string
	googleanalyticsadminv1alphadisplayvideo360advertiserlink *GoogleAnalyticsAdminV1alphaDisplayVideo360AdvertiserLink
	urlParams_                                               gensupport.URLParams
	ctx_                                                     context.Context
	header_                                                  http.Header
}

// Create: Creates a DisplayVideo360AdvertiserLink. This can only be
// utilized by users who have proper authorization both on the Google
// Analytics property and on the Display & Video 360 advertiser. Users
// who do not have access to the Display & Video 360 advertiser should
// instead seek to create a DisplayVideo360LinkProposal.
//
// - parent: Example format: properties/1234.
func (r *PropertiesDisplayVideo360AdvertiserLinksService) Create(parent string, googleanalyticsadminv1alphadisplayvideo360advertiserlink *GoogleAnalyticsAdminV1alphaDisplayVideo360AdvertiserLink) *PropertiesDisplayVideo360AdvertiserLinksCreateCall {
	c := &PropertiesDisplayVideo360AdvertiserLinksCreateCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	c.googleanalyticsadminv1alphadisplayvideo360advertiserlink = googleanalyticsadminv1alphadisplayvideo360advertiserlink
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *PropertiesDisplayVideo360AdvertiserLinksCreateCall) Fields(s ...googleapi.Field) *PropertiesDisplayVideo360AdvertiserLinksCreateCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *PropertiesDisplayVideo360AdvertiserLinksCreateCall) Context(ctx context.Context) *PropertiesDisplayVideo360AdvertiserLinksCreateCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *PropertiesDisplayVideo360AdvertiserLinksCreateCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *PropertiesDisplayVideo360AdvertiserLinksCreateCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.googleanalyticsadminv1alphadisplayvideo360advertiserlink)
	if err != nil {
		return nil, err
	}
	reqHeaders.Set("Content-Type", "application/json")
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1alpha/{+parent}/displayVideo360AdvertiserLinks")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "analyticsadmin.properties.displayVideo360AdvertiserLinks.create" call.
// Exactly one of
// *GoogleAnalyticsAdminV1alphaDisplayVideo360AdvertiserLink or error
// will be non-nil. Any non-2xx status code is an error. Response
// headers are in either
// *GoogleAnalyticsAdminV1alphaDisplayVideo360AdvertiserLink.ServerRespon
// se.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was
// returned.
func (c *PropertiesDisplayVideo360AdvertiserLinksCreateCall) Do(opts ...googleapi.CallOption) (*GoogleAnalyticsAdminV1alphaDisplayVideo360AdvertiserLink, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleAnalyticsAdminV1alphaDisplayVideo360AdvertiserLink{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Creates a DisplayVideo360AdvertiserLink. This can only be utilized by users who have proper authorization both on the Google Analytics property and on the Display \u0026 Video 360 advertiser. Users who do not have access to the Display \u0026 Video 360 advertiser should instead seek to create a DisplayVideo360LinkProposal.",
	//   "flatPath": "v1alpha/properties/{propertiesId}/displayVideo360AdvertiserLinks",
	//   "httpMethod": "POST",
	//   "id": "analyticsadmin.properties.displayVideo360AdvertiserLinks.create",
	//   "parameterOrder": [
	//     "parent"
	//   ],
	//   "parameters": {
	//     "parent": {
	//       "description": "Required. Example format: properties/1234",
	//       "location": "path",
	//       "pattern": "^properties/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1alpha/{+parent}/displayVideo360AdvertiserLinks",
	//   "request": {
	//     "$ref": "GoogleAnalyticsAdminV1alphaDisplayVideo360AdvertiserLink"
	//   },
	//   "response": {
	//     "$ref": "GoogleAnalyticsAdminV1alphaDisplayVideo360AdvertiserLink"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/analytics.edit"
	//   ]
	// }

}

// method id "analyticsadmin.properties.displayVideo360AdvertiserLinks.delete":

type PropertiesDisplayVideo360AdvertiserLinksDeleteCall struct {
	s          *Service
	name       string
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Delete: Deletes a DisplayVideo360AdvertiserLink on a property.
//
//   - name: The name of the DisplayVideo360AdvertiserLink to delete.
//     Example format: properties/1234/displayVideo360AdvertiserLinks/5678.
func (r *PropertiesDisplayVideo360AdvertiserLinksService) Delete(name string) *PropertiesDisplayVideo360AdvertiserLinksDeleteCall {
	c := &PropertiesDisplayVideo360AdvertiserLinksDeleteCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *PropertiesDisplayVideo360AdvertiserLinksDeleteCall) Fields(s ...googleapi.Field) *PropertiesDisplayVideo360AdvertiserLinksDeleteCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *PropertiesDisplayVideo360AdvertiserLinksDeleteCall) Context(ctx context.Context) *PropertiesDisplayVideo360AdvertiserLinksDeleteCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *PropertiesDisplayVideo360AdvertiserLinksDeleteCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *PropertiesDisplayVideo360AdvertiserLinksDeleteCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1alpha/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("DELETE", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "analyticsadmin.properties.displayVideo360AdvertiserLinks.delete" call.
// Exactly one of *GoogleProtobufEmpty or error will be non-nil. Any
// non-2xx status code is an error. Response headers are in either
// *GoogleProtobufEmpty.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was
// because http.StatusNotModified was returned.
func (c *PropertiesDisplayVideo360AdvertiserLinksDeleteCall) Do(opts ...googleapi.CallOption) (*GoogleProtobufEmpty, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleProtobufEmpty{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Deletes a DisplayVideo360AdvertiserLink on a property.",
	//   "flatPath": "v1alpha/properties/{propertiesId}/displayVideo360AdvertiserLinks/{displayVideo360AdvertiserLinksId}",
	//   "httpMethod": "DELETE",
	//   "id": "analyticsadmin.properties.displayVideo360AdvertiserLinks.delete",
	//   "parameterOrder": [
	//     "name"
	//   ],
	//   "parameters": {
	//     "name": {
	//       "description": "Required. The name of the DisplayVideo360AdvertiserLink to delete. Example format: properties/1234/displayVideo360AdvertiserLinks/5678",
	//       "location": "path",
	//       "pattern": "^properties/[^/]+/displayVideo360AdvertiserLinks/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1alpha/{+name}",
	//   "response": {
	//     "$ref": "GoogleProtobufEmpty"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/analytics.edit"
	//   ]
	// }

}

// method id "analyticsadmin.properties.displayVideo360AdvertiserLinks.get":

type PropertiesDisplayVideo360AdvertiserLinksGetCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Look up a single DisplayVideo360AdvertiserLink
//
//   - name: The name of the DisplayVideo360AdvertiserLink to get. Example
//     format: properties/1234/displayVideo360AdvertiserLink/5678.
func (r *PropertiesDisplayVideo360AdvertiserLinksService) Get(name string) *PropertiesDisplayVideo360AdvertiserLinksGetCall {
	c := &PropertiesDisplayVideo360AdvertiserLinksGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *PropertiesDisplayVideo360AdvertiserLinksGetCall) Fields(s ...googleapi.Field) *PropertiesDisplayVideo360AdvertiserLinksGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets the optional parameter which makes the operation
// fail if the object's ETag matches the given value. This is useful for
// getting updates only after the object has changed since the last
// request. Use googleapi.IsNotModified to check whether the response
// error from Do is the result of In-None-Match.
func (c *PropertiesDisplayVideo360AdvertiserLinksGetCall) IfNoneMatch(entityTag string) *PropertiesDisplayVideo360AdvertiserLinksGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *PropertiesDisplayVideo360AdvertiserLinksGetCall) Context(ctx context.Context) *PropertiesDisplayVideo360AdvertiserLinksGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *PropertiesDisplayVideo360AdvertiserLinksGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *PropertiesDisplayVideo360AdvertiserLinksGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1alpha/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "analyticsadmin.properties.displayVideo360AdvertiserLinks.get" call.
// Exactly one of
// *GoogleAnalyticsAdminV1alphaDisplayVideo360AdvertiserLink or error
// will be non-nil. Any non-2xx status code is an error. Response
// headers are in either
// *GoogleAnalyticsAdminV1alphaDisplayVideo360AdvertiserLink.ServerRespon
// se.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was
// returned.
func (c *PropertiesDisplayVideo360AdvertiserLinksGetCall) Do(opts ...googleapi.CallOption) (*GoogleAnalyticsAdminV1alphaDisplayVideo360AdvertiserLink, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleAnalyticsAdminV1alphaDisplayVideo360AdvertiserLink{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Look up a single DisplayVideo360AdvertiserLink",
	//   "flatPath": "v1alpha/properties/{propertiesId}/displayVideo360AdvertiserLinks/{displayVideo360AdvertiserLinksId}",
	//   "httpMethod": "GET",
	//   "id": "analyticsadmin.properties.displayVideo360AdvertiserLinks.get",
	//   "parameterOrder": [
	//     "name"
	//   ],
	//   "parameters": {
	//     "name": {
	//       "description": "Required. The name of the DisplayVideo360AdvertiserLink to get. Example format: properties/1234/displayVideo360AdvertiserLink/5678",
	//       "location": "path",
	//       "pattern": "^properties/[^/]+/displayVideo360AdvertiserLinks/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1alpha/{+name}",
	//   "response": {
	//     "$ref": "GoogleAnalyticsAdminV1alphaDisplayVideo360AdvertiserLink"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/analytics.edit",
	//     "https://www.googleapis.com/auth/analytics.readonly"
	//   ]
	// }

}

// method id "analyticsadmin.properties.displayVideo360AdvertiserLinks.list":

type PropertiesDisplayVideo360AdvertiserLinksListCall struct {
	s            *Service
	parent       string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Lists all DisplayVideo360AdvertiserLinks on a property.
//
// - parent: Example format: properties/1234.
func (r *PropertiesDisplayVideo360AdvertiserLinksService) List(parent string) *PropertiesDisplayVideo360AdvertiserLinksListCall {
	c := &PropertiesDisplayVideo360AdvertiserLinksListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	return c
}

// PageSize sets the optional parameter "pageSize": The maximum number
// of resources to return. If unspecified, at most 50 resources will be
// returned. The maximum value is 200 (higher values will be coerced to
// the maximum).
func (c *PropertiesDisplayVideo360AdvertiserLinksListCall) PageSize(pageSize int64) *PropertiesDisplayVideo360AdvertiserLinksListCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": A page token,
// received from a previous `ListDisplayVideo360AdvertiserLinks` call.
// Provide this to retrieve the subsequent page. When paginating, all
// other parameters provided to `ListDisplayVideo360AdvertiserLinks`
// must match the call that provided the page token.
func (c *PropertiesDisplayVideo360AdvertiserLinksListCall) PageToken(pageToken string) *PropertiesDisplayVideo360AdvertiserLinksListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *PropertiesDisplayVideo360AdvertiserLinksListCall) Fields(s ...googleapi.Field) *PropertiesDisplayVideo360AdvertiserLinksListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets the optional parameter which makes the operation
// fail if the object's ETag matches the given value. This is useful for
// getting updates only after the object has changed since the last
// request. Use googleapi.IsNotModified to check whether the response
// error from Do is the result of In-None-Match.
func (c *PropertiesDisplayVideo360AdvertiserLinksListCall) IfNoneMatch(entityTag string) *PropertiesDisplayVideo360AdvertiserLinksListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *PropertiesDisplayVideo360AdvertiserLinksListCall) Context(ctx context.Context) *PropertiesDisplayVideo360AdvertiserLinksListCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *PropertiesDisplayVideo360AdvertiserLinksListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *PropertiesDisplayVideo360AdvertiserLinksListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1alpha/{+parent}/displayVideo360AdvertiserLinks")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "analyticsadmin.properties.displayVideo360AdvertiserLinks.list" call.
// Exactly one of
// *GoogleAnalyticsAdminV1alphaListDisplayVideo360AdvertiserLinksResponse
//
//	or error will be non-nil. Any non-2xx status code is an error.
//
// Response headers are in either
// *GoogleAnalyticsAdminV1alphaListDisplayVideo360AdvertiserLinksResponse
// .ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was
// returned.
func (c *PropertiesDisplayVideo360AdvertiserLinksListCall) Do(opts ...googleapi.CallOption) (*GoogleAnalyticsAdminV1alphaListDisplayVideo360AdvertiserLinksResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleAnalyticsAdminV1alphaListDisplayVideo360AdvertiserLinksResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Lists all DisplayVideo360AdvertiserLinks on a property.",
	//   "flatPath": "v1alpha/properties/{propertiesId}/displayVideo360AdvertiserLinks",
	//   "httpMethod": "GET",
	//   "id": "analyticsadmin.properties.displayVideo360AdvertiserLinks.list",
	//   "parameterOrder": [
	//     "parent"
	//   ],
	//   "parameters": {
	//     "pageSize": {
	//       "description": "The maximum number of resources to return. If unspecified, at most 50 resources will be returned. The maximum value is 200 (higher values will be coerced to the maximum).",
	//       "format": "int32",
	//       "location": "query",
	//       "type": "integer"
	//     },
	//     "pageToken": {
	//       "description": "A page token, received from a previous `ListDisplayVideo360AdvertiserLinks` call. Provide this to retrieve the subsequent page. When paginating, all other parameters provided to `ListDisplayVideo360AdvertiserLinks` must match the call that provided the page token.",
	//       "location": "query",
	//       "type": "string"
	//     },
	//     "parent": {
	//       "description": "Required. Example format: properties/1234",
	//       "location": "path",
	//       "pattern": "^properties/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1alpha/{+parent}/displayVideo360AdvertiserLinks",
	//   "response": {
	//     "$ref": "GoogleAnalyticsAdminV1alphaListDisplayVideo360AdvertiserLinksResponse"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/analytics.edit",
	//     "https://www.googleapis.com/auth/analytics.readonly"
	//   ]
	// }

}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *PropertiesDisplayVideo360AdvertiserLinksListCall) Pages(ctx context.Context, f func(*GoogleAnalyticsAdminV1alphaListDisplayVideo360AdvertiserLinksResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken")) // reset paging to original point
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

// method id "analyticsadmin.properties.displayVideo360AdvertiserLinks.patch":

type PropertiesDisplayVideo360AdvertiserLinksPatchCall struct {
	s                                                        *Service
	name                                                     string
	googleanalyticsadminv1alphadisplayvideo360advertiserlink *GoogleAnalyticsAdminV1alphaDisplayVideo360AdvertiserLink
	urlParams_                                               gensupport.URLParams
	ctx_                                                     context.Context
	header_                                                  http.Header
}

// Patch: Updates a DisplayVideo360AdvertiserLink on a property.
//
//   - name: Output only. The resource name for this
//     DisplayVideo360AdvertiserLink resource. Format:
//     properties/{propertyId}/displayVideo360AdvertiserLinks/{linkId}
//     Note: linkId is not the Display & Video 360 Advertiser ID.
func (r *PropertiesDisplayVideo360AdvertiserLinksService) Patch(name string, googleanalyticsadminv1alphadisplayvideo360advertiserlink *GoogleAnalyticsAdminV1alphaDisplayVideo360AdvertiserLink) *PropertiesDisplayVideo360AdvertiserLinksPatchCall {
	c := &PropertiesDisplayVideo360AdvertiserLinksPatchCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	c.googleanalyticsadminv1alphadisplayvideo360advertiserlink = googleanalyticsadminv1alphadisplayvideo360advertiserlink
	return c
}

// UpdateMask sets the optional parameter "updateMask": Required. The
// list of fields to be updated. Omitted fields will not be updated. To
// replace the entire entity, use one path with the string "*" to match
// all fields.
func (c *PropertiesDisplayVideo360AdvertiserLinksPatchCall) UpdateMask(updateMask string) *PropertiesDisplayVideo360AdvertiserLinksPatchCall {
	c.urlParams_.Set("updateMask", updateMask)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *PropertiesDisplayVideo360AdvertiserLinksPatchCall) Fields(s ...googleapi.Field) *PropertiesDisplayVideo360AdvertiserLinksPatchCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *PropertiesDisplayVideo360AdvertiserLinksPatchCall) Context(ctx context.Context) *PropertiesDisplayVideo360AdvertiserLinksPatchCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *PropertiesDisplayVideo360AdvertiserLinksPatchCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *PropertiesDisplayVideo360AdvertiserLinksPatchCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.googleanalyticsadminv1alphadisplayvideo360advertiserlink)
	if err != nil {
		return nil, err
	}
	reqHeaders.Set("Content-Type", "application/json")
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1alpha/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("PATCH", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "analyticsadmin.properties.displayVideo360AdvertiserLinks.patch" call.
// Exactly one of
// *GoogleAnalyticsAdminV1alphaDisplayVideo360AdvertiserLink or error
// will be non-nil. Any non-2xx status code is an error. Response
// headers are in either
// *GoogleAnalyticsAdminV1alphaDisplayVideo360AdvertiserLink.ServerRespon
// se.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was
// returned.
func (c *PropertiesDisplayVideo360AdvertiserLinksPatchCall) Do(opts ...googleapi.CallOption) (*GoogleAnalyticsAdminV1alphaDisplayVideo360AdvertiserLink, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleAnalyticsAdminV1alphaDisplayVideo360AdvertiserLink{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Updates a DisplayVideo360AdvertiserLink on a property.",
	//   "flatPath": "v1alpha/properties/{propertiesId}/displayVideo360AdvertiserLinks/{displayVideo360AdvertiserLinksId}",
	//   "httpMethod": "PATCH",
	//   "id": "analyticsadmin.properties.displayVideo360AdvertiserLinks.patch",
	//   "parameterOrder": [
	//     "name"
	//   ],
	//   "parameters": {
	//     "name": {
	//       "description": "Output only. The resource name for this DisplayVideo360AdvertiserLink resource. Format: properties/{propertyId}/displayVideo360AdvertiserLinks/{linkId} Note: linkId is not the Display \u0026 Video 360 Advertiser ID",
	//       "location": "path",
	//       "pattern": "^properties/[^/]+/displayVideo360AdvertiserLinks/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     },
	//     "updateMask": {
	//       "description": "Required. The list of fields to be updated. Omitted fields will not be updated. To replace the entire entity, use one path with the string \"*\" to match all fields.",
	//       "format": "google-fieldmask",
	//       "location": "query",
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1alpha/{+name}",
	//   "request": {
	//     "$ref": "GoogleAnalyticsAdminV1alphaDisplayVideo360AdvertiserLink"
	//   },
	//   "response": {
	//     "$ref": "GoogleAnalyticsAdminV1alphaDisplayVideo360AdvertiserLink"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/analytics.edit"
	//   ]
	// }

}

// method id "analyticsadmin.properties.expandedDataSets.create":

type PropertiesExpandedDataSetsCreateCall struct {
	s                                          *Service
	parent                                     string
	googleanalyticsadminv1alphaexpandeddataset *GoogleAnalyticsAdminV1alphaExpandedDataSet
	urlParams_                                 gensupport.URLParams
	ctx_                                       context.Context
	header_                                    http.Header
}

// Create: Creates a ExpandedDataSet.
//
// - parent: Example format: properties/1234.
func (r *PropertiesExpandedDataSetsService) Create(parent string, googleanalyticsadminv1alphaexpandeddataset *GoogleAnalyticsAdminV1alphaExpandedDataSet) *PropertiesExpandedDataSetsCreateCall {
	c := &PropertiesExpandedDataSetsCreateCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	c.googleanalyticsadminv1alphaexpandeddataset = googleanalyticsadminv1alphaexpandeddataset
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *PropertiesExpandedDataSetsCreateCall) Fields(s ...googleapi.Field) *PropertiesExpandedDataSetsCreateCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *PropertiesExpandedDataSetsCreateCall) Context(ctx context.Context) *PropertiesExpandedDataSetsCreateCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *PropertiesExpandedDataSetsCreateCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *PropertiesExpandedDataSetsCreateCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.googleanalyticsadminv1alphaexpandeddataset)
	if err != nil {
		return nil, err
	}
	reqHeaders.Set("Content-Type", "application/json")
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1alpha/{+parent}/expandedDataSets")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "analyticsadmin.properties.expandedDataSets.create" call.
// Exactly one of *GoogleAnalyticsAdminV1alphaExpandedDataSet or error
// will be non-nil. Any non-2xx status code is an error. Response
// headers are in either
// *GoogleAnalyticsAdminV1alphaExpandedDataSet.ServerResponse.Header or
// (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was
// returned.
func (c *PropertiesExpandedDataSetsCreateCall) Do(opts ...googleapi.CallOption) (*GoogleAnalyticsAdminV1alphaExpandedDataSet, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleAnalyticsAdminV1alphaExpandedDataSet{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Creates a ExpandedDataSet.",
	//   "flatPath": "v1alpha/properties/{propertiesId}/expandedDataSets",
	//   "httpMethod": "POST",
	//   "id": "analyticsadmin.properties.expandedDataSets.create",
	//   "parameterOrder": [
	//     "parent"
	//   ],
	//   "parameters": {
	//     "parent": {
	//       "description": "Required. Example format: properties/1234",
	//       "location": "path",
	//       "pattern": "^properties/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1alpha/{+parent}/expandedDataSets",
	//   "request": {
	//     "$ref": "GoogleAnalyticsAdminV1alphaExpandedDataSet"
	//   },
	//   "response": {
	//     "$ref": "GoogleAnalyticsAdminV1alphaExpandedDataSet"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/analytics.edit"
	//   ]
	// }

}

// method id "analyticsadmin.properties.expandedDataSets.delete":

type PropertiesExpandedDataSetsDeleteCall struct {
	s          *Service
	name       string
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Delete: Deletes a ExpandedDataSet on a property.
//
// - name: Example format: properties/1234/expandedDataSets/5678.
func (r *PropertiesExpandedDataSetsService) Delete(name string) *PropertiesExpandedDataSetsDeleteCall {
	c := &PropertiesExpandedDataSetsDeleteCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *PropertiesExpandedDataSetsDeleteCall) Fields(s ...googleapi.Field) *PropertiesExpandedDataSetsDeleteCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *PropertiesExpandedDataSetsDeleteCall) Context(ctx context.Context) *PropertiesExpandedDataSetsDeleteCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *PropertiesExpandedDataSetsDeleteCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *PropertiesExpandedDataSetsDeleteCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1alpha/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("DELETE", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "analyticsadmin.properties.expandedDataSets.delete" call.
// Exactly one of *GoogleProtobufEmpty or error will be non-nil. Any
// non-2xx status code is an error. Response headers are in either
// *GoogleProtobufEmpty.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was
// because http.StatusNotModified was returned.
func (c *PropertiesExpandedDataSetsDeleteCall) Do(opts ...googleapi.CallOption) (*GoogleProtobufEmpty, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleProtobufEmpty{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Deletes a ExpandedDataSet on a property.",
	//   "flatPath": "v1alpha/properties/{propertiesId}/expandedDataSets/{expandedDataSetsId}",
	//   "httpMethod": "DELETE",
	//   "id": "analyticsadmin.properties.expandedDataSets.delete",
	//   "parameterOrder": [
	//     "name"
	//   ],
	//   "parameters": {
	//     "name": {
	//       "description": "Required. Example format: properties/1234/expandedDataSets/5678",
	//       "location": "path",
	//       "pattern": "^properties/[^/]+/expandedDataSets/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1alpha/{+name}",
	//   "response": {
	//     "$ref": "GoogleProtobufEmpty"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/analytics.edit"
	//   ]
	// }

}

// method id "analyticsadmin.properties.expandedDataSets.get":

type PropertiesExpandedDataSetsGetCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Lookup for a single ExpandedDataSet.
//
//   - name: The name of the ExpandedDataSet to get. Example format:
//     properties/1234/expandedDataSets/5678.
func (r *PropertiesExpandedDataSetsService) Get(name string) *PropertiesExpandedDataSetsGetCall {
	c := &PropertiesExpandedDataSetsGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *PropertiesExpandedDataSetsGetCall) Fields(s ...googleapi.Field) *PropertiesExpandedDataSetsGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets the optional parameter which makes the operation
// fail if the object's ETag matches the given value. This is useful for
// getting updates only after the object has changed since the last
// request. Use googleapi.IsNotModified to check whether the response
// error from Do is the result of In-None-Match.
func (c *PropertiesExpandedDataSetsGetCall) IfNoneMatch(entityTag string) *PropertiesExpandedDataSetsGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *PropertiesExpandedDataSetsGetCall) Context(ctx context.Context) *PropertiesExpandedDataSetsGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *PropertiesExpandedDataSetsGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *PropertiesExpandedDataSetsGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1alpha/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "analyticsadmin.properties.expandedDataSets.get" call.
// Exactly one of *GoogleAnalyticsAdminV1alphaExpandedDataSet or error
// will be non-nil. Any non-2xx status code is an error. Response
// headers are in either
// *GoogleAnalyticsAdminV1alphaExpandedDataSet.ServerResponse.Header or
// (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was
// returned.
func (c *PropertiesExpandedDataSetsGetCall) Do(opts ...googleapi.CallOption) (*GoogleAnalyticsAdminV1alphaExpandedDataSet, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleAnalyticsAdminV1alphaExpandedDataSet{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Lookup for a single ExpandedDataSet.",
	//   "flatPath": "v1alpha/properties/{propertiesId}/expandedDataSets/{expandedDataSetsId}",
	//   "httpMethod": "GET",
	//   "id": "analyticsadmin.properties.expandedDataSets.get",
	//   "parameterOrder": [
	//     "name"
	//   ],
	//   "parameters": {
	//     "name": {
	//       "description": "Required. The name of the ExpandedDataSet to get. Example format: properties/1234/expandedDataSets/5678",
	//       "location": "path",
	//       "pattern": "^properties/[^/]+/expandedDataSets/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1alpha/{+name}",
	//   "response": {
	//     "$ref": "GoogleAnalyticsAdminV1alphaExpandedDataSet"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/analytics.edit",
	//     "https://www.googleapis.com/auth/analytics.readonly"
	//   ]
	// }

}

// method id "analyticsadmin.properties.expandedDataSets.list":

type PropertiesExpandedDataSetsListCall struct {
	s            *Service
	parent       string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Lists ExpandedDataSets on a property.
//
// - parent: Example format: properties/1234.
func (r *PropertiesExpandedDataSetsService) List(parent string) *PropertiesExpandedDataSetsListCall {
	c := &PropertiesExpandedDataSetsListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	return c
}

// PageSize sets the optional parameter "pageSize": The maximum number
// of resources to return. If unspecified, at most 50 resources will be
// returned. The maximum value is 200 (higher values will be coerced to
// the maximum).
func (c *PropertiesExpandedDataSetsListCall) PageSize(pageSize int64) *PropertiesExpandedDataSetsListCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": A page token,
// received from a previous `ListExpandedDataSets` call. Provide this to
// retrieve the subsequent page. When paginating, all other parameters
// provided to `ListExpandedDataSet` must match the call that provided
// the page token.
func (c *PropertiesExpandedDataSetsListCall) PageToken(pageToken string) *PropertiesExpandedDataSetsListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *PropertiesExpandedDataSetsListCall) Fields(s ...googleapi.Field) *PropertiesExpandedDataSetsListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets the optional parameter which makes the operation
// fail if the object's ETag matches the given value. This is useful for
// getting updates only after the object has changed since the last
// request. Use googleapi.IsNotModified to check whether the response
// error from Do is the result of In-None-Match.
func (c *PropertiesExpandedDataSetsListCall) IfNoneMatch(entityTag string) *PropertiesExpandedDataSetsListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *PropertiesExpandedDataSetsListCall) Context(ctx context.Context) *PropertiesExpandedDataSetsListCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *PropertiesExpandedDataSetsListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *PropertiesExpandedDataSetsListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1alpha/{+parent}/expandedDataSets")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "analyticsadmin.properties.expandedDataSets.list" call.
// Exactly one of
// *GoogleAnalyticsAdminV1alphaListExpandedDataSetsResponse or error
// will be non-nil. Any non-2xx status code is an error. Response
// headers are in either
// *GoogleAnalyticsAdminV1alphaListExpandedDataSetsResponse.ServerRespons
// e.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was
// returned.
func (c *PropertiesExpandedDataSetsListCall) Do(opts ...googleapi.CallOption) (*GoogleAnalyticsAdminV1alphaListExpandedDataSetsResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleAnalyticsAdminV1alphaListExpandedDataSetsResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Lists ExpandedDataSets on a property.",
	//   "flatPath": "v1alpha/properties/{propertiesId}/expandedDataSets",
	//   "httpMethod": "GET",
	//   "id": "analyticsadmin.properties.expandedDataSets.list",
	//   "parameterOrder": [
	//     "parent"
	//   ],
	//   "parameters": {
	//     "pageSize": {
	//       "description": "The maximum number of resources to return. If unspecified, at most 50 resources will be returned. The maximum value is 200 (higher values will be coerced to the maximum).",
	//       "format": "int32",
	//       "location": "query",
	//       "type": "integer"
	//     },
	//     "pageToken": {
	//       "description": "A page token, received from a previous `ListExpandedDataSets` call. Provide this to retrieve the subsequent page. When paginating, all other parameters provided to `ListExpandedDataSet` must match the call that provided the page token.",
	//       "location": "query",
	//       "type": "string"
	//     },
	//     "parent": {
	//       "description": "Required. Example format: properties/1234",
	//       "location": "path",
	//       "pattern": "^properties/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1alpha/{+parent}/expandedDataSets",
	//   "response": {
	//     "$ref": "GoogleAnalyticsAdminV1alphaListExpandedDataSetsResponse"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/analytics.edit",
	//     "https://www.googleapis.com/auth/analytics.readonly"
	//   ]
	// }

}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *PropertiesExpandedDataSetsListCall) Pages(ctx context.Context, f func(*GoogleAnalyticsAdminV1alphaListExpandedDataSetsResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken")) // reset paging to original point
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

// method id "analyticsadmin.properties.expandedDataSets.patch":

type PropertiesExpandedDataSetsPatchCall struct {
	s                                          *Service
	name                                       string
	googleanalyticsadminv1alphaexpandeddataset *GoogleAnalyticsAdminV1alphaExpandedDataSet
	urlParams_                                 gensupport.URLParams
	ctx_                                       context.Context
	header_                                    http.Header
}

// Patch: Updates a ExpandedDataSet on a property.
//
//   - name: Output only. The resource name for this ExpandedDataSet
//     resource. Format:
//     properties/{property_id}/expandedDataSets/{expanded_data_set}.
func (r *PropertiesExpandedDataSetsService) Patch(name string, googleanalyticsadminv1alphaexpandeddataset *GoogleAnalyticsAdminV1alphaExpandedDataSet) *PropertiesExpandedDataSetsPatchCall {
	c := &PropertiesExpandedDataSetsPatchCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	c.googleanalyticsadminv1alphaexpandeddataset = googleanalyticsadminv1alphaexpandeddataset
	return c
}

// UpdateMask sets the optional parameter "updateMask": Required. The
// list of fields to be updated. Field names must be in snake case
// (e.g., "field_to_update"). Omitted fields will not be updated. To
// replace the entire entity, use one path with the string "*" to match
// all fields.
func (c *PropertiesExpandedDataSetsPatchCall) UpdateMask(updateMask string) *PropertiesExpandedDataSetsPatchCall {
	c.urlParams_.Set("updateMask", updateMask)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *PropertiesExpandedDataSetsPatchCall) Fields(s ...googleapi.Field) *PropertiesExpandedDataSetsPatchCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *PropertiesExpandedDataSetsPatchCall) Context(ctx context.Context) *PropertiesExpandedDataSetsPatchCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *PropertiesExpandedDataSetsPatchCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *PropertiesExpandedDataSetsPatchCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.googleanalyticsadminv1alphaexpandeddataset)
	if err != nil {
		return nil, err
	}
	reqHeaders.Set("Content-Type", "application/json")
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1alpha/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("PATCH", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "analyticsadmin.properties.expandedDataSets.patch" call.
// Exactly one of *GoogleAnalyticsAdminV1alphaExpandedDataSet or error
// will be non-nil. Any non-2xx status code is an error. Response
// headers are in either
// *GoogleAnalyticsAdminV1alphaExpandedDataSet.ServerResponse.Header or
// (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was
// returned.
func (c *PropertiesExpandedDataSetsPatchCall) Do(opts ...googleapi.CallOption) (*GoogleAnalyticsAdminV1alphaExpandedDataSet, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleAnalyticsAdminV1alphaExpandedDataSet{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Updates a ExpandedDataSet on a property.",
	//   "flatPath": "v1alpha/properties/{propertiesId}/expandedDataSets/{expandedDataSetsId}",
	//   "httpMethod": "PATCH",
	//   "id": "analyticsadmin.properties.expandedDataSets.patch",
	//   "parameterOrder": [
	//     "name"
	//   ],
	//   "parameters": {
	//     "name": {
	//       "description": "Output only. The resource name for this ExpandedDataSet resource. Format: properties/{property_id}/expandedDataSets/{expanded_data_set}",
	//       "location": "path",
	//       "pattern": "^properties/[^/]+/expandedDataSets/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     },
	//     "updateMask": {
	//       "description": "Required. The list of fields to be updated. Field names must be in snake case (e.g., \"field_to_update\"). Omitted fields will not be updated. To replace the entire entity, use one path with the string \"*\" to match all fields.",
	//       "format": "google-fieldmask",
	//       "location": "query",
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1alpha/{+name}",
	//   "request": {
	//     "$ref": "GoogleAnalyticsAdminV1alphaExpandedDataSet"
	//   },
	//   "response": {
	//     "$ref": "GoogleAnalyticsAdminV1alphaExpandedDataSet"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/analytics.edit"
	//   ]
	// }

}

// method id "analyticsadmin.properties.firebaseLinks.create":

type PropertiesFirebaseLinksCreateCall struct {
	s                                       *Service
	parent                                  string
	googleanalyticsadminv1alphafirebaselink *GoogleAnalyticsAdminV1alphaFirebaseLink
	urlParams_                              gensupport.URLParams
	ctx_                                    context.Context
	header_                                 http.Header
}

// Create: Creates a FirebaseLink. Properties can have at most one
// FirebaseLink.
//
// - parent: Format: properties/{property_id} Example: properties/1234.
func (r *PropertiesFirebaseLinksService) Create(parent string, googleanalyticsadminv1alphafirebaselink *GoogleAnalyticsAdminV1alphaFirebaseLink) *PropertiesFirebaseLinksCreateCall {
	c := &PropertiesFirebaseLinksCreateCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	c.googleanalyticsadminv1alphafirebaselink = googleanalyticsadminv1alphafirebaselink
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *PropertiesFirebaseLinksCreateCall) Fields(s ...googleapi.Field) *PropertiesFirebaseLinksCreateCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *PropertiesFirebaseLinksCreateCall) Context(ctx context.Context) *PropertiesFirebaseLinksCreateCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *PropertiesFirebaseLinksCreateCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *PropertiesFirebaseLinksCreateCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.googleanalyticsadminv1alphafirebaselink)
	if err != nil {
		return nil, err
	}
	reqHeaders.Set("Content-Type", "application/json")
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1alpha/{+parent}/firebaseLinks")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "analyticsadmin.properties.firebaseLinks.create" call.
// Exactly one of *GoogleAnalyticsAdminV1alphaFirebaseLink or error will
// be non-nil. Any non-2xx status code is an error. Response headers are
// in either
// *GoogleAnalyticsAdminV1alphaFirebaseLink.ServerResponse.Header or (if
// a response was returned at all) in error.(*googleapi.Error).Header.
// Use googleapi.IsNotModified to check whether the returned error was
// because http.StatusNotModified was returned.
func (c *PropertiesFirebaseLinksCreateCall) Do(opts ...googleapi.CallOption) (*GoogleAnalyticsAdminV1alphaFirebaseLink, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleAnalyticsAdminV1alphaFirebaseLink{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Creates a FirebaseLink. Properties can have at most one FirebaseLink.",
	//   "flatPath": "v1alpha/properties/{propertiesId}/firebaseLinks",
	//   "httpMethod": "POST",
	//   "id": "analyticsadmin.properties.firebaseLinks.create",
	//   "parameterOrder": [
	//     "parent"
	//   ],
	//   "parameters": {
	//     "parent": {
	//       "description": "Required. Format: properties/{property_id} Example: properties/1234",
	//       "location": "path",
	//       "pattern": "^properties/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1alpha/{+parent}/firebaseLinks",
	//   "request": {
	//     "$ref": "GoogleAnalyticsAdminV1alphaFirebaseLink"
	//   },
	//   "response": {
	//     "$ref": "GoogleAnalyticsAdminV1alphaFirebaseLink"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/analytics.edit"
	//   ]
	// }

}

// method id "analyticsadmin.properties.firebaseLinks.delete":

type PropertiesFirebaseLinksDeleteCall struct {
	s          *Service
	name       string
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Delete: Deletes a FirebaseLink on a property
//
//   - name: Format:
//     properties/{property_id}/firebaseLinks/{firebase_link_id} Example:
//     properties/1234/firebaseLinks/5678.
func (r *PropertiesFirebaseLinksService) Delete(name string) *PropertiesFirebaseLinksDeleteCall {
	c := &PropertiesFirebaseLinksDeleteCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *PropertiesFirebaseLinksDeleteCall) Fields(s ...googleapi.Field) *PropertiesFirebaseLinksDeleteCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *PropertiesFirebaseLinksDeleteCall) Context(ctx context.Context) *PropertiesFirebaseLinksDeleteCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *PropertiesFirebaseLinksDeleteCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *PropertiesFirebaseLinksDeleteCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1alpha/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("DELETE", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "analyticsadmin.properties.firebaseLinks.delete" call.
// Exactly one of *GoogleProtobufEmpty or error will be non-nil. Any
// non-2xx status code is an error. Response headers are in either
// *GoogleProtobufEmpty.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was
// because http.StatusNotModified was returned.
func (c *PropertiesFirebaseLinksDeleteCall) Do(opts ...googleapi.CallOption) (*GoogleProtobufEmpty, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleProtobufEmpty{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Deletes a FirebaseLink on a property",
	//   "flatPath": "v1alpha/properties/{propertiesId}/firebaseLinks/{firebaseLinksId}",
	//   "httpMethod": "DELETE",
	//   "id": "analyticsadmin.properties.firebaseLinks.delete",
	//   "parameterOrder": [
	//     "name"
	//   ],
	//   "parameters": {
	//     "name": {
	//       "description": "Required. Format: properties/{property_id}/firebaseLinks/{firebase_link_id} Example: properties/1234/firebaseLinks/5678",
	//       "location": "path",
	//       "pattern": "^properties/[^/]+/firebaseLinks/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1alpha/{+name}",
	//   "response": {
	//     "$ref": "GoogleProtobufEmpty"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/analytics.edit"
	//   ]
	// }

}

// method id "analyticsadmin.properties.firebaseLinks.list":

type PropertiesFirebaseLinksListCall struct {
	s            *Service
	parent       string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Lists FirebaseLinks on a property. Properties can have at most
// one FirebaseLink.
//
// - parent: Format: properties/{property_id} Example: properties/1234.
func (r *PropertiesFirebaseLinksService) List(parent string) *PropertiesFirebaseLinksListCall {
	c := &PropertiesFirebaseLinksListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	return c
}

// PageSize sets the optional parameter "pageSize": The maximum number
// of resources to return. The service may return fewer than this value,
// even if there are additional pages. If unspecified, at most 50
// resources will be returned. The maximum value is 200; (higher values
// will be coerced to the maximum)
func (c *PropertiesFirebaseLinksListCall) PageSize(pageSize int64) *PropertiesFirebaseLinksListCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": A page token,
// received from a previous `ListFirebaseLinks` call. Provide this to
// retrieve the subsequent page. When paginating, all other parameters
// provided to `ListFirebaseLinks` must match the call that provided the
// page token.
func (c *PropertiesFirebaseLinksListCall) PageToken(pageToken string) *PropertiesFirebaseLinksListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *PropertiesFirebaseLinksListCall) Fields(s ...googleapi.Field) *PropertiesFirebaseLinksListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets the optional parameter which makes the operation
// fail if the object's ETag matches the given value. This is useful for
// getting updates only after the object has changed since the last
// request. Use googleapi.IsNotModified to check whether the response
// error from Do is the result of In-None-Match.
func (c *PropertiesFirebaseLinksListCall) IfNoneMatch(entityTag string) *PropertiesFirebaseLinksListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *PropertiesFirebaseLinksListCall) Context(ctx context.Context) *PropertiesFirebaseLinksListCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *PropertiesFirebaseLinksListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *PropertiesFirebaseLinksListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1alpha/{+parent}/firebaseLinks")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "analyticsadmin.properties.firebaseLinks.list" call.
// Exactly one of *GoogleAnalyticsAdminV1alphaListFirebaseLinksResponse
// or error will be non-nil. Any non-2xx status code is an error.
// Response headers are in either
// *GoogleAnalyticsAdminV1alphaListFirebaseLinksResponse.ServerResponse.H
// eader or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was
// returned.
func (c *PropertiesFirebaseLinksListCall) Do(opts ...googleapi.CallOption) (*GoogleAnalyticsAdminV1alphaListFirebaseLinksResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleAnalyticsAdminV1alphaListFirebaseLinksResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Lists FirebaseLinks on a property. Properties can have at most one FirebaseLink.",
	//   "flatPath": "v1alpha/properties/{propertiesId}/firebaseLinks",
	//   "httpMethod": "GET",
	//   "id": "analyticsadmin.properties.firebaseLinks.list",
	//   "parameterOrder": [
	//     "parent"
	//   ],
	//   "parameters": {
	//     "pageSize": {
	//       "description": "The maximum number of resources to return. The service may return fewer than this value, even if there are additional pages. If unspecified, at most 50 resources will be returned. The maximum value is 200; (higher values will be coerced to the maximum)",
	//       "format": "int32",
	//       "location": "query",
	//       "type": "integer"
	//     },
	//     "pageToken": {
	//       "description": "A page token, received from a previous `ListFirebaseLinks` call. Provide this to retrieve the subsequent page. When paginating, all other parameters provided to `ListFirebaseLinks` must match the call that provided the page token.",
	//       "location": "query",
	//       "type": "string"
	//     },
	//     "parent": {
	//       "description": "Required. Format: properties/{property_id} Example: properties/1234",
	//       "location": "path",
	//       "pattern": "^properties/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1alpha/{+parent}/firebaseLinks",
	//   "response": {
	//     "$ref": "GoogleAnalyticsAdminV1alphaListFirebaseLinksResponse"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/analytics.edit",
	//     "https://www.googleapis.com/auth/analytics.readonly"
	//   ]
	// }

}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *PropertiesFirebaseLinksListCall) Pages(ctx context.Context, f func(*GoogleAnalyticsAdminV1alphaListFirebaseLinksResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken")) // reset paging to original point
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

// method id "analyticsadmin.properties.googleAdsLinks.create":

type PropertiesGoogleAdsLinksCreateCall struct {
	s                                        *Service
	parent                                   string
	googleanalyticsadminv1alphagoogleadslink *GoogleAnalyticsAdminV1alphaGoogleAdsLink
	urlParams_                               gensupport.URLParams
	ctx_                                     context.Context
	header_                                  http.Header
}

// Create: Creates a GoogleAdsLink.
//
// - parent: Example format: properties/1234.
func (r *PropertiesGoogleAdsLinksService) Create(parent string, googleanalyticsadminv1alphagoogleadslink *GoogleAnalyticsAdminV1alphaGoogleAdsLink) *PropertiesGoogleAdsLinksCreateCall {
	c := &PropertiesGoogleAdsLinksCreateCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	c.googleanalyticsadminv1alphagoogleadslink = googleanalyticsadminv1alphagoogleadslink
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *PropertiesGoogleAdsLinksCreateCall) Fields(s ...googleapi.Field) *PropertiesGoogleAdsLinksCreateCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *PropertiesGoogleAdsLinksCreateCall) Context(ctx context.Context) *PropertiesGoogleAdsLinksCreateCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *PropertiesGoogleAdsLinksCreateCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *PropertiesGoogleAdsLinksCreateCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.googleanalyticsadminv1alphagoogleadslink)
	if err != nil {
		return nil, err
	}
	reqHeaders.Set("Content-Type", "application/json")
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1alpha/{+parent}/googleAdsLinks")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "analyticsadmin.properties.googleAdsLinks.create" call.
// Exactly one of *GoogleAnalyticsAdminV1alphaGoogleAdsLink or error
// will be non-nil. Any non-2xx status code is an error. Response
// headers are in either
// *GoogleAnalyticsAdminV1alphaGoogleAdsLink.ServerResponse.Header or
// (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was
// returned.
func (c *PropertiesGoogleAdsLinksCreateCall) Do(opts ...googleapi.CallOption) (*GoogleAnalyticsAdminV1alphaGoogleAdsLink, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleAnalyticsAdminV1alphaGoogleAdsLink{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Creates a GoogleAdsLink.",
	//   "flatPath": "v1alpha/properties/{propertiesId}/googleAdsLinks",
	//   "httpMethod": "POST",
	//   "id": "analyticsadmin.properties.googleAdsLinks.create",
	//   "parameterOrder": [
	//     "parent"
	//   ],
	//   "parameters": {
	//     "parent": {
	//       "description": "Required. Example format: properties/1234",
	//       "location": "path",
	//       "pattern": "^properties/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1alpha/{+parent}/googleAdsLinks",
	//   "request": {
	//     "$ref": "GoogleAnalyticsAdminV1alphaGoogleAdsLink"
	//   },
	//   "response": {
	//     "$ref": "GoogleAnalyticsAdminV1alphaGoogleAdsLink"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/analytics.edit"
	//   ]
	// }

}

// method id "analyticsadmin.properties.googleAdsLinks.delete":

type PropertiesGoogleAdsLinksDeleteCall struct {
	s          *Service
	name       string
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Delete: Deletes a GoogleAdsLink on a property
//
// - name: Example format: properties/1234/googleAdsLinks/5678.
func (r *PropertiesGoogleAdsLinksService) Delete(name string) *PropertiesGoogleAdsLinksDeleteCall {
	c := &PropertiesGoogleAdsLinksDeleteCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *PropertiesGoogleAdsLinksDeleteCall) Fields(s ...googleapi.Field) *PropertiesGoogleAdsLinksDeleteCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *PropertiesGoogleAdsLinksDeleteCall) Context(ctx context.Context) *PropertiesGoogleAdsLinksDeleteCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *PropertiesGoogleAdsLinksDeleteCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *PropertiesGoogleAdsLinksDeleteCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1alpha/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("DELETE", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "analyticsadmin.properties.googleAdsLinks.delete" call.
// Exactly one of *GoogleProtobufEmpty or error will be non-nil. Any
// non-2xx status code is an error. Response headers are in either
// *GoogleProtobufEmpty.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was
// because http.StatusNotModified was returned.
func (c *PropertiesGoogleAdsLinksDeleteCall) Do(opts ...googleapi.CallOption) (*GoogleProtobufEmpty, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleProtobufEmpty{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Deletes a GoogleAdsLink on a property",
	//   "flatPath": "v1alpha/properties/{propertiesId}/googleAdsLinks/{googleAdsLinksId}",
	//   "httpMethod": "DELETE",
	//   "id": "analyticsadmin.properties.googleAdsLinks.delete",
	//   "parameterOrder": [
	//     "name"
	//   ],
	//   "parameters": {
	//     "name": {
	//       "description": "Required. Example format: properties/1234/googleAdsLinks/5678",
	//       "location": "path",
	//       "pattern": "^properties/[^/]+/googleAdsLinks/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1alpha/{+name}",
	//   "response": {
	//     "$ref": "GoogleProtobufEmpty"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/analytics.edit"
	//   ]
	// }

}

// method id "analyticsadmin.properties.googleAdsLinks.list":

type PropertiesGoogleAdsLinksListCall struct {
	s            *Service
	parent       string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Lists GoogleAdsLinks on a property.
//
// - parent: Example format: properties/1234.
func (r *PropertiesGoogleAdsLinksService) List(parent string) *PropertiesGoogleAdsLinksListCall {
	c := &PropertiesGoogleAdsLinksListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	return c
}

// PageSize sets the optional parameter "pageSize": The maximum number
// of resources to return. If unspecified, at most 50 resources will be
// returned. The maximum value is 200 (higher values will be coerced to
// the maximum).
func (c *PropertiesGoogleAdsLinksListCall) PageSize(pageSize int64) *PropertiesGoogleAdsLinksListCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": A page token,
// received from a previous `ListGoogleAdsLinks` call. Provide this to
// retrieve the subsequent page. When paginating, all other parameters
// provided to `ListGoogleAdsLinks` must match the call that provided
// the page token.
func (c *PropertiesGoogleAdsLinksListCall) PageToken(pageToken string) *PropertiesGoogleAdsLinksListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *PropertiesGoogleAdsLinksListCall) Fields(s ...googleapi.Field) *PropertiesGoogleAdsLinksListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets the optional parameter which makes the operation
// fail if the object's ETag matches the given value. This is useful for
// getting updates only after the object has changed since the last
// request. Use googleapi.IsNotModified to check whether the response
// error from Do is the result of In-None-Match.
func (c *PropertiesGoogleAdsLinksListCall) IfNoneMatch(entityTag string) *PropertiesGoogleAdsLinksListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *PropertiesGoogleAdsLinksListCall) Context(ctx context.Context) *PropertiesGoogleAdsLinksListCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *PropertiesGoogleAdsLinksListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *PropertiesGoogleAdsLinksListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1alpha/{+parent}/googleAdsLinks")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "analyticsadmin.properties.googleAdsLinks.list" call.
// Exactly one of *GoogleAnalyticsAdminV1alphaListGoogleAdsLinksResponse
// or error will be non-nil. Any non-2xx status code is an error.
// Response headers are in either
// *GoogleAnalyticsAdminV1alphaListGoogleAdsLinksResponse.ServerResponse.
// Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was
// returned.
func (c *PropertiesGoogleAdsLinksListCall) Do(opts ...googleapi.CallOption) (*GoogleAnalyticsAdminV1alphaListGoogleAdsLinksResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleAnalyticsAdminV1alphaListGoogleAdsLinksResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Lists GoogleAdsLinks on a property.",
	//   "flatPath": "v1alpha/properties/{propertiesId}/googleAdsLinks",
	//   "httpMethod": "GET",
	//   "id": "analyticsadmin.properties.googleAdsLinks.list",
	//   "parameterOrder": [
	//     "parent"
	//   ],
	//   "parameters": {
	//     "pageSize": {
	//       "description": "The maximum number of resources to return. If unspecified, at most 50 resources will be returned. The maximum value is 200 (higher values will be coerced to the maximum).",
	//       "format": "int32",
	//       "location": "query",
	//       "type": "integer"
	//     },
	//     "pageToken": {
	//       "description": "A page token, received from a previous `ListGoogleAdsLinks` call. Provide this to retrieve the subsequent page. When paginating, all other parameters provided to `ListGoogleAdsLinks` must match the call that provided the page token.",
	//       "location": "query",
	//       "type": "string"
	//     },
	//     "parent": {
	//       "description": "Required. Example format: properties/1234",
	//       "location": "path",
	//       "pattern": "^properties/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1alpha/{+parent}/googleAdsLinks",
	//   "response": {
	//     "$ref": "GoogleAnalyticsAdminV1alphaListGoogleAdsLinksResponse"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/analytics.edit",
	//     "https://www.googleapis.com/auth/analytics.readonly"
	//   ]
	// }

}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *PropertiesGoogleAdsLinksListCall) Pages(ctx context.Context, f func(*GoogleAnalyticsAdminV1alphaListGoogleAdsLinksResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken")) // reset paging to original point
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

// method id "analyticsadmin.properties.googleAdsLinks.patch":

type PropertiesGoogleAdsLinksPatchCall struct {
	s                                        *Service
	name                                     string
	googleanalyticsadminv1alphagoogleadslink *GoogleAnalyticsAdminV1alphaGoogleAdsLink
	urlParams_                               gensupport.URLParams
	ctx_                                     context.Context
	header_                                  http.Header
}

// Patch: Updates a GoogleAdsLink on a property
//
//   - name: Output only. Format:
//     properties/{propertyId}/googleAdsLinks/{googleAdsLinkId} Note:
//     googleAdsLinkId is not the Google Ads customer ID.
func (r *PropertiesGoogleAdsLinksService) Patch(name string, googleanalyticsadminv1alphagoogleadslink *GoogleAnalyticsAdminV1alphaGoogleAdsLink) *PropertiesGoogleAdsLinksPatchCall {
	c := &PropertiesGoogleAdsLinksPatchCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	c.googleanalyticsadminv1alphagoogleadslink = googleanalyticsadminv1alphagoogleadslink
	return c
}

// UpdateMask sets the optional parameter "updateMask": Required. The
// list of fields to be updated. Field names must be in snake case
// (e.g., "field_to_update"). Omitted fields will not be updated. To
// replace the entire entity, use one path with the string "*" to match
// all fields.
func (c *PropertiesGoogleAdsLinksPatchCall) UpdateMask(updateMask string) *PropertiesGoogleAdsLinksPatchCall {
	c.urlParams_.Set("updateMask", updateMask)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *PropertiesGoogleAdsLinksPatchCall) Fields(s ...googleapi.Field) *PropertiesGoogleAdsLinksPatchCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *PropertiesGoogleAdsLinksPatchCall) Context(ctx context.Context) *PropertiesGoogleAdsLinksPatchCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *PropertiesGoogleAdsLinksPatchCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *PropertiesGoogleAdsLinksPatchCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.googleanalyticsadminv1alphagoogleadslink)
	if err != nil {
		return nil, err
	}
	reqHeaders.Set("Content-Type", "application/json")
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1alpha/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("PATCH", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "analyticsadmin.properties.googleAdsLinks.patch" call.
// Exactly one of *GoogleAnalyticsAdminV1alphaGoogleAdsLink or error
// will be non-nil. Any non-2xx status code is an error. Response
// headers are in either
// *GoogleAnalyticsAdminV1alphaGoogleAdsLink.ServerResponse.Header or
// (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was
// returned.
func (c *PropertiesGoogleAdsLinksPatchCall) Do(opts ...googleapi.CallOption) (*GoogleAnalyticsAdminV1alphaGoogleAdsLink, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleAnalyticsAdminV1alphaGoogleAdsLink{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Updates a GoogleAdsLink on a property",
	//   "flatPath": "v1alpha/properties/{propertiesId}/googleAdsLinks/{googleAdsLinksId}",
	//   "httpMethod": "PATCH",
	//   "id": "analyticsadmin.properties.googleAdsLinks.patch",
	//   "parameterOrder": [
	//     "name"
	//   ],
	//   "parameters": {
	//     "name": {
	//       "description": "Output only. Format: properties/{propertyId}/googleAdsLinks/{googleAdsLinkId} Note: googleAdsLinkId is not the Google Ads customer ID.",
	//       "location": "path",
	//       "pattern": "^properties/[^/]+/googleAdsLinks/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     },
	//     "updateMask": {
	//       "description": "Required. The list of fields to be updated. Field names must be in snake case (e.g., \"field_to_update\"). Omitted fields will not be updated. To replace the entire entity, use one path with the string \"*\" to match all fields.",
	//       "format": "google-fieldmask",
	//       "location": "query",
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1alpha/{+name}",
	//   "request": {
	//     "$ref": "GoogleAnalyticsAdminV1alphaGoogleAdsLink"
	//   },
	//   "response": {
	//     "$ref": "GoogleAnalyticsAdminV1alphaGoogleAdsLink"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/analytics.edit"
	//   ]
	// }

}

// method id "analyticsadmin.properties.searchAds360Links.create":

type PropertiesSearchAds360LinksCreateCall struct {
	s                                           *Service
	parent                                      string
	googleanalyticsadminv1alphasearchads360link *GoogleAnalyticsAdminV1alphaSearchAds360Link
	urlParams_                                  gensupport.URLParams
	ctx_                                        context.Context
	header_                                     http.Header
}

// Create: Creates a SearchAds360Link.
//
// - parent: Example format: properties/1234.
func (r *PropertiesSearchAds360LinksService) Cr