// Copyright 2024 gRPC authors.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

//
// Automatically generated by tools/codegen/core/gen_trace_flags.py
//

#include "${absl_prefix}absl/container/flat_hash_map.h"

#include "src/core/lib/debug/trace.h"
#include "src/core/util/no_destruct.h"

namespace grpc_core {

% for flag, settings in trace_flags.items():
% if "debug_only" in settings and settings["debug_only"]:
DebugOnlyTraceFlag ${flag}_trace(${str(settings["default"]).lower()}, "${flag}");
% endif
% endfor
% for flag, settings in trace_flags.items():
% if "debug_only" not in settings or not settings["debug_only"]:
TraceFlag ${flag}_trace(${str(settings["default"]).lower()}, "${flag}");
% endif
% endfor

const absl::flat_hash_map<std::string, TraceFlag*>& GetAllTraceFlags() {
  static const NoDestruct<absl::flat_hash_map<std::string, TraceFlag*>>
      all(absl::flat_hash_map<std::string, TraceFlag*>({
% for flag, settings in trace_flags.items():
% if "debug_only" not in settings or not settings["debug_only"]:
    {"${flag}", &${flag}_trace},
% endif
% endfor
#ifndef NDEBUG
% for flag, settings in trace_flags.items():
% if "debug_only" in settings and settings["debug_only"]:
    {"${flag}", &${flag}_trace},
% endif
% endfor
#endif
  }));
  return *all;
}

}  // namespace grpc_core
