/* automatically generated by rust-bindgen 0.71.1 */

#[repr(C)]
#[derive(Copy, Clone, Debug, Default, Eq, Hash, Ord, PartialEq, PartialOrd)]
pub struct __BindgenBitfieldUnit<Storage> {
    storage: Storage,
}
impl<Storage> __BindgenBitfieldUnit<Storage> {
    #[inline]
    pub const fn new(storage: Storage) -> Self {
        Self { storage }
    }
}
impl<Storage> __BindgenBitfieldUnit<Storage>
where
    Storage: AsRef<[u8]> + AsMut<[u8]>,
{
    #[inline]
    fn extract_bit(byte: u8, index: usize) -> bool {
        let bit_index = if cfg!(target_endian = "big") {
            7 - (index % 8)
        } else {
            index % 8
        };
        let mask = 1 << bit_index;
        byte & mask == mask
    }
    #[inline]
    pub fn get_bit(&self, index: usize) -> bool {
        debug_assert!(index / 8 < self.storage.as_ref().len());
        let byte_index = index / 8;
        let byte = self.storage.as_ref()[byte_index];
        Self::extract_bit(byte, index)
    }
    #[inline]
    pub unsafe fn raw_get_bit(this: *const Self, index: usize) -> bool { unsafe {
        debug_assert!(index / 8 < core::mem::size_of::<Storage>());
        let byte_index = index / 8;
        let byte = *(core::ptr::addr_of!((*this).storage) as *const u8).offset(byte_index as isize);
        Self::extract_bit(byte, index)
    }}
    #[inline]
    fn change_bit(byte: u8, index: usize, val: bool) -> u8 {
        let bit_index = if cfg!(target_endian = "big") {
            7 - (index % 8)
        } else {
            index % 8
        };
        let mask = 1 << bit_index;
        if val {
            byte | mask
        } else {
            byte & !mask
        }
    }
    #[inline]
    pub fn set_bit(&mut self, index: usize, val: bool) {
        debug_assert!(index / 8 < self.storage.as_ref().len());
        let byte_index = index / 8;
        let byte = &mut self.storage.as_mut()[byte_index];
        *byte = Self::change_bit(*byte, index, val);
    }
    #[inline]
    pub unsafe fn raw_set_bit(this: *mut Self, index: usize, val: bool) { unsafe {
        debug_assert!(index / 8 < core::mem::size_of::<Storage>());
        let byte_index = index / 8;
        let byte =
            (core::ptr::addr_of_mut!((*this).storage) as *mut u8).offset(byte_index as isize);
        *byte = Self::change_bit(*byte, index, val);
    }}
    #[inline]
    pub fn get(&self, bit_offset: usize, bit_width: u8) -> u64 {
        debug_assert!(bit_width <= 64);
        debug_assert!(bit_offset / 8 < self.storage.as_ref().len());
        debug_assert!((bit_offset + (bit_width as usize)) / 8 <= self.storage.as_ref().len());
        let mut val = 0;
        for i in 0..(bit_width as usize) {
            if self.get_bit(i + bit_offset) {
                let index = if cfg!(target_endian = "big") {
                    bit_width as usize - 1 - i
                } else {
                    i
                };
                val |= 1 << index;
            }
        }
        val
    }
    #[inline]
    pub unsafe fn raw_get(this: *const Self, bit_offset: usize, bit_width: u8) -> u64 { unsafe {
        debug_assert!(bit_width <= 64);
        debug_assert!(bit_offset / 8 < core::mem::size_of::<Storage>());
        debug_assert!((bit_offset + (bit_width as usize)) / 8 <= core::mem::size_of::<Storage>());
        let mut val = 0;
        for i in 0..(bit_width as usize) {
            if Self::raw_get_bit(this, i + bit_offset) {
                let index = if cfg!(target_endian = "big") {
                    bit_width as usize - 1 - i
                } else {
                    i
                };
                val |= 1 << index;
            }
        }
        val
    }}
    #[inline]
    pub fn set(&mut self, bit_offset: usize, bit_width: u8, val: u64) {
        debug_assert!(bit_width <= 64);
        debug_assert!(bit_offset / 8 < self.storage.as_ref().len());
        debug_assert!((bit_offset + (bit_width as usize)) / 8 <= self.storage.as_ref().len());
        for i in 0..(bit_width as usize) {
            let mask = 1 << i;
            let val_bit_is_set = val & mask == mask;
            let index = if cfg!(target_endian = "big") {
                bit_width as usize - 1 - i
            } else {
                i
            };
            self.set_bit(index + bit_offset, val_bit_is_set);
        }
    }
    #[inline]
    pub unsafe fn raw_set(this: *mut Self, bit_offset: usize, bit_width: u8, val: u64) { unsafe {
        debug_assert!(bit_width <= 64);
        debug_assert!(bit_offset / 8 < core::mem::size_of::<Storage>());
        debug_assert!((bit_offset + (bit_width as usize)) / 8 <= core::mem::size_of::<Storage>());
        for i in 0..(bit_width as usize) {
            let mask = 1 << i;
            let val_bit_is_set = val & mask == mask;
            let index = if cfg!(target_endian = "big") {
                bit_width as usize - 1 - i
            } else {
                i
            };
            Self::raw_set_bit(this, index + bit_offset, val_bit_is_set);
        }
    }}
}
pub const _STDINT_H: u32 = 1;
pub const _FEATURES_H: u32 = 1;
pub const _DEFAULT_SOURCE: u32 = 1;
pub const __GLIBC_USE_ISOC2X: u32 = 0;
pub const __USE_ISOC11: u32 = 1;
pub const __USE_ISOC99: u32 = 1;
pub const __USE_ISOC95: u32 = 1;
pub const __USE_POSIX_IMPLICITLY: u32 = 1;
pub const _POSIX_SOURCE: u32 = 1;
pub const _POSIX_C_SOURCE: u32 = 200809;
pub const __USE_POSIX: u32 = 1;
pub const __USE_POSIX2: u32 = 1;
pub const __USE_POSIX199309: u32 = 1;
pub const __USE_POSIX199506: u32 = 1;
pub const __USE_XOPEN2K: u32 = 1;
pub const __USE_XOPEN2K8: u32 = 1;
pub const _ATFILE_SOURCE: u32 = 1;
pub const __WORDSIZE: u32 = 64;
pub const __WORDSIZE_TIME64_COMPAT32: u32 = 1;
pub const __SYSCALL_WORDSIZE: u32 = 64;
pub const __TIMESIZE: u32 = 64;
pub const __USE_MISC: u32 = 1;
pub const __USE_ATFILE: u32 = 1;
pub const __USE_FORTIFY_LEVEL: u32 = 0;
pub const __GLIBC_USE_DEPRECATED_GETS: u32 = 0;
pub const __GLIBC_USE_DEPRECATED_SCANF: u32 = 0;
pub const _STDC_PREDEF_H: u32 = 1;
pub const __STDC_IEC_559__: u32 = 1;
pub const __STDC_IEC_60559_BFP__: u32 = 201404;
pub const __STDC_IEC_559_COMPLEX__: u32 = 1;
pub const __STDC_IEC_60559_COMPLEX__: u32 = 201404;
pub const __STDC_ISO_10646__: u32 = 201706;
pub const __GNU_LIBRARY__: u32 = 6;
pub const __GLIBC__: u32 = 2;
pub const __GLIBC_MINOR__: u32 = 36;
pub const _SYS_CDEFS_H: u32 = 1;
pub const __glibc_c99_flexarr_available: u32 = 1;
pub const __LDOUBLE_REDIRECTS_TO_FLOAT128_ABI: u32 = 0;
pub const __HAVE_GENERIC_SELECTION: u32 = 1;
pub const __GLIBC_USE_LIB_EXT2: u32 = 0;
pub const __GLIBC_USE_IEC_60559_BFP_EXT: u32 = 0;
pub const __GLIBC_USE_IEC_60559_BFP_EXT_C2X: u32 = 0;
pub const __GLIBC_USE_IEC_60559_EXT: u32 = 0;
pub const __GLIBC_USE_IEC_60559_FUNCS_EXT: u32 = 0;
pub const __GLIBC_USE_IEC_60559_FUNCS_EXT_C2X: u32 = 0;
pub const __GLIBC_USE_IEC_60559_TYPES_EXT: u32 = 0;
pub const _BITS_TYPES_H: u32 = 1;
pub const _BITS_TYPESIZES_H: u32 = 1;
pub const __OFF_T_MATCHES_OFF64_T: u32 = 1;
pub const __INO_T_MATCHES_INO64_T: u32 = 1;
pub const __RLIM_T_MATCHES_RLIM64_T: u32 = 1;
pub const __STATFS_MATCHES_STATFS64: u32 = 1;
pub const __KERNEL_OLD_TIMEVAL_MATCHES_TIMEVAL64: u32 = 1;
pub const __FD_SETSIZE: u32 = 1024;
pub const _BITS_TIME64_H: u32 = 1;
pub const _BITS_WCHAR_H: u32 = 1;
pub const _BITS_STDINT_INTN_H: u32 = 1;
pub const _BITS_STDINT_UINTN_H: u32 = 1;
pub const INT8_MIN: i32 = -128;
pub const INT16_MIN: i32 = -32768;
pub const INT32_MIN: i32 = -2147483648;
pub const INT8_MAX: u32 = 127;
pub const INT16_MAX: u32 = 32767;
pub const INT32_MAX: u32 = 2147483647;
pub const UINT8_MAX: u32 = 255;
pub const UINT16_MAX: u32 = 65535;
pub const UINT32_MAX: u32 = 4294967295;
pub const INT_LEAST8_MIN: i32 = -128;
pub const INT_LEAST16_MIN: i32 = -32768;
pub const INT_LEAST32_MIN: i32 = -2147483648;
pub const INT_LEAST8_MAX: u32 = 127;
pub const INT_LEAST16_MAX: u32 = 32767;
pub const INT_LEAST32_MAX: u32 = 2147483647;
pub const UINT_LEAST8_MAX: u32 = 255;
pub const UINT_LEAST16_MAX: u32 = 65535;
pub const UINT_LEAST32_MAX: u32 = 4294967295;
pub const INT_FAST8_MIN: i32 = -128;
pub const INT_FAST16_MIN: i64 = -9223372036854775808;
pub const INT_FAST32_MIN: i64 = -9223372036854775808;
pub const INT_FAST8_MAX: u32 = 127;
pub const INT_FAST16_MAX: u64 = 9223372036854775807;
pub const INT_FAST32_MAX: u64 = 9223372036854775807;
pub const UINT_FAST8_MAX: u32 = 255;
pub const UINT_FAST16_MAX: i32 = -1;
pub const UINT_FAST32_MAX: i32 = -1;
pub const INTPTR_MIN: i64 = -9223372036854775808;
pub const INTPTR_MAX: u64 = 9223372036854775807;
pub const UINTPTR_MAX: i32 = -1;
pub const PTRDIFF_MIN: i64 = -9223372036854775808;
pub const PTRDIFF_MAX: u64 = 9223372036854775807;
pub const SIG_ATOMIC_MIN: i32 = -2147483648;
pub const SIG_ATOMIC_MAX: u32 = 2147483647;
pub const SIZE_MAX: i32 = -1;
pub const WINT_MIN: u32 = 0;
pub const WINT_MAX: u32 = 4294967295;
pub const BIOS_ATOM_PREFIX: &[u8; 9] = b"ATOMBIOS\0";
pub const BIOS_VERSION_PREFIX: &[u8; 15] = b"ATOMBIOSBK-AMD\0";
pub const BIOS_STRING_LENGTH: u32 = 43;
pub const PPTABLE_NV10_SMU_VERSION: u32 = 8;
pub const NUM_GFXCLK_DPM_LEVELS: u32 = 16;
pub const NUM_SMNCLK_DPM_LEVELS: u32 = 2;
pub const NUM_SOCCLK_DPM_LEVELS: u32 = 8;
pub const NUM_MP0CLK_DPM_LEVELS: u32 = 2;
pub const NUM_DCLK_DPM_LEVELS: u32 = 8;
pub const NUM_VCLK_DPM_LEVELS: u32 = 8;
pub const NUM_DCEFCLK_DPM_LEVELS: u32 = 8;
pub const NUM_PHYCLK_DPM_LEVELS: u32 = 8;
pub const NUM_DISPCLK_DPM_LEVELS: u32 = 8;
pub const NUM_PIXCLK_DPM_LEVELS: u32 = 8;
pub const NUM_UCLK_DPM_LEVELS: u32 = 4;
pub const NUM_MP1CLK_DPM_LEVELS: u32 = 2;
pub const NUM_LINK_LEVELS: u32 = 2;
pub const MAX_GFXCLK_DPM_LEVEL: u32 = 15;
pub const MAX_SMNCLK_DPM_LEVEL: u32 = 1;
pub const MAX_SOCCLK_DPM_LEVEL: u32 = 7;
pub const MAX_MP0CLK_DPM_LEVEL: u32 = 1;
pub const MAX_DCLK_DPM_LEVEL: u32 = 7;
pub const MAX_VCLK_DPM_LEVEL: u32 = 7;
pub const MAX_DCEFCLK_DPM_LEVEL: u32 = 7;
pub const MAX_DISPCLK_DPM_LEVEL: u32 = 7;
pub const MAX_PIXCLK_DPM_LEVEL: u32 = 7;
pub const MAX_PHYCLK_DPM_LEVEL: u32 = 7;
pub const MAX_UCLK_DPM_LEVEL: u32 = 3;
pub const MAX_MP1CLK_DPM_LEVEL: u32 = 1;
pub const MAX_LINK_LEVEL: u32 = 1;
pub const PPSMC_GeminiModeNone: u32 = 0;
pub const PPSMC_GeminiModeMaster: u32 = 1;
pub const PPSMC_GeminiModeSlave: u32 = 2;
pub const FEATURE_DPM_PREFETCHER_BIT: u32 = 0;
pub const FEATURE_DPM_GFXCLK_BIT: u32 = 1;
pub const FEATURE_DPM_GFX_PACE_BIT: u32 = 2;
pub const FEATURE_DPM_UCLK_BIT: u32 = 3;
pub const FEATURE_DPM_SOCCLK_BIT: u32 = 4;
pub const FEATURE_DPM_MP0CLK_BIT: u32 = 5;
pub const FEATURE_DPM_LINK_BIT: u32 = 6;
pub const FEATURE_DPM_DCEFCLK_BIT: u32 = 7;
pub const FEATURE_MEM_VDDCI_SCALING_BIT: u32 = 8;
pub const FEATURE_MEM_MVDD_SCALING_BIT: u32 = 9;
pub const FEATURE_DS_GFXCLK_BIT: u32 = 10;
pub const FEATURE_DS_SOCCLK_BIT: u32 = 11;
pub const FEATURE_DS_LCLK_BIT: u32 = 12;
pub const FEATURE_DS_DCEFCLK_BIT: u32 = 13;
pub const FEATURE_DS_UCLK_BIT: u32 = 14;
pub const FEATURE_GFX_ULV_BIT: u32 = 15;
pub const FEATURE_FW_DSTATE_BIT: u32 = 16;
pub const FEATURE_GFXOFF_BIT: u32 = 17;
pub const FEATURE_BACO_BIT: u32 = 18;
pub const FEATURE_VCN_PG_BIT: u32 = 19;
pub const FEATURE_JPEG_PG_BIT: u32 = 20;
pub const FEATURE_USB_PG_BIT: u32 = 21;
pub const FEATURE_RSMU_SMN_CG_BIT: u32 = 22;
pub const FEATURE_PPT_BIT: u32 = 23;
pub const FEATURE_TDC_BIT: u32 = 24;
pub const FEATURE_GFX_EDC_BIT: u32 = 25;
pub const FEATURE_APCC_PLUS_BIT: u32 = 26;
pub const FEATURE_GTHR_BIT: u32 = 27;
pub const FEATURE_ACDC_BIT: u32 = 28;
pub const FEATURE_VR0HOT_BIT: u32 = 29;
pub const FEATURE_VR1HOT_BIT: u32 = 30;
pub const FEATURE_FW_CTF_BIT: u32 = 31;
pub const FEATURE_FAN_CONTROL_BIT: u32 = 32;
pub const FEATURE_THERMAL_BIT: u32 = 33;
pub const FEATURE_GFX_DCS_BIT: u32 = 34;
pub const FEATURE_RM_BIT: u32 = 35;
pub const FEATURE_LED_DISPLAY_BIT: u32 = 36;
pub const FEATURE_GFX_SS_BIT: u32 = 37;
pub const FEATURE_OUT_OF_BAND_MONITOR_BIT: u32 = 38;
pub const FEATURE_TEMP_DEPENDENT_VMIN_BIT: u32 = 39;
pub const FEATURE_MMHUB_PG_BIT: u32 = 40;
pub const FEATURE_ATHUB_PG_BIT: u32 = 41;
pub const FEATURE_APCC_DFLL_BIT: u32 = 42;
pub const FEATURE_SPARE_43_BIT: u32 = 43;
pub const FEATURE_SPARE_44_BIT: u32 = 44;
pub const FEATURE_SPARE_45_BIT: u32 = 45;
pub const FEATURE_SPARE_46_BIT: u32 = 46;
pub const FEATURE_SPARE_47_BIT: u32 = 47;
pub const FEATURE_SPARE_48_BIT: u32 = 48;
pub const FEATURE_SPARE_49_BIT: u32 = 49;
pub const FEATURE_SPARE_50_BIT: u32 = 50;
pub const FEATURE_SPARE_51_BIT: u32 = 51;
pub const FEATURE_SPARE_52_BIT: u32 = 52;
pub const FEATURE_SPARE_53_BIT: u32 = 53;
pub const FEATURE_SPARE_54_BIT: u32 = 54;
pub const FEATURE_SPARE_55_BIT: u32 = 55;
pub const FEATURE_SPARE_56_BIT: u32 = 56;
pub const FEATURE_SPARE_57_BIT: u32 = 57;
pub const FEATURE_SPARE_58_BIT: u32 = 58;
pub const FEATURE_SPARE_59_BIT: u32 = 59;
pub const FEATURE_SPARE_60_BIT: u32 = 60;
pub const FEATURE_SPARE_61_BIT: u32 = 61;
pub const FEATURE_SPARE_62_BIT: u32 = 62;
pub const FEATURE_SPARE_63_BIT: u32 = 63;
pub const NUM_FEATURES: u32 = 64;
pub const DPM_OVERRIDE_DISABLE_SOCCLK_PID: u32 = 1;
pub const DPM_OVERRIDE_DISABLE_UCLK_PID: u32 = 2;
pub const DPM_OVERRIDE_DISABLE_VOLT_LINK_VCN_SOCCLK: u32 = 4;
pub const DPM_OVERRIDE_ENABLE_FREQ_LINK_VCLK_SOCCLK: u32 = 8;
pub const DPM_OVERRIDE_ENABLE_FREQ_LINK_DCLK_SOCCLK: u32 = 16;
pub const DPM_OVERRIDE_ENABLE_FREQ_LINK_GFXCLK_SOCCLK: u32 = 32;
pub const DPM_OVERRIDE_ENABLE_FREQ_LINK_GFXCLK_UCLK: u32 = 64;
pub const DPM_OVERRIDE_DISABLE_VOLT_LINK_DCE_SOCCLK: u32 = 128;
pub const DPM_OVERRIDE_DISABLE_VOLT_LINK_MP0_SOCCLK: u32 = 256;
pub const DPM_OVERRIDE_DISABLE_DFLL_PLL_SHUTDOWN: u32 = 512;
pub const DPM_OVERRIDE_DISABLE_MEMORY_TEMPERATURE_READ: u32 = 1024;
pub const VR_MAPPING_VR_SELECT_MASK: u32 = 1;
pub const VR_MAPPING_VR_SELECT_SHIFT: u32 = 0;
pub const VR_MAPPING_PLANE_SELECT_MASK: u32 = 2;
pub const VR_MAPPING_PLANE_SELECT_SHIFT: u32 = 1;
pub const PSI_SEL_VR0_PLANE0_PSI0: u32 = 1;
pub const PSI_SEL_VR0_PLANE0_PSI1: u32 = 2;
pub const PSI_SEL_VR0_PLANE1_PSI0: u32 = 4;
pub const PSI_SEL_VR0_PLANE1_PSI1: u32 = 8;
pub const PSI_SEL_VR1_PLANE0_PSI0: u32 = 16;
pub const PSI_SEL_VR1_PLANE0_PSI1: u32 = 32;
pub const PSI_SEL_VR1_PLANE1_PSI0: u32 = 64;
pub const PSI_SEL_VR1_PLANE1_PSI1: u32 = 128;
pub const THROTTLER_PADDING_BIT: u32 = 0;
pub const THROTTLER_TEMP_EDGE_BIT: u32 = 1;
pub const THROTTLER_TEMP_HOTSPOT_BIT: u32 = 2;
pub const THROTTLER_TEMP_MEM_BIT: u32 = 3;
pub const THROTTLER_TEMP_VR_GFX_BIT: u32 = 4;
pub const THROTTLER_TEMP_VR_MEM0_BIT: u32 = 5;
pub const THROTTLER_TEMP_VR_MEM1_BIT: u32 = 6;
pub const THROTTLER_TEMP_VR_SOC_BIT: u32 = 7;
pub const THROTTLER_TEMP_LIQUID0_BIT: u32 = 8;
pub const THROTTLER_TEMP_LIQUID1_BIT: u32 = 9;
pub const THROTTLER_TEMP_PLX_BIT: u32 = 10;
pub const THROTTLER_TEMP_SKIN_BIT: u32 = 11;
pub const THROTTLER_TDC_GFX_BIT: u32 = 12;
pub const THROTTLER_TDC_SOC_BIT: u32 = 13;
pub const THROTTLER_PPT0_BIT: u32 = 14;
pub const THROTTLER_PPT1_BIT: u32 = 15;
pub const THROTTLER_PPT2_BIT: u32 = 16;
pub const THROTTLER_PPT3_BIT: u32 = 17;
pub const THROTTLER_FIT_BIT: u32 = 18;
pub const THROTTLER_PPM_BIT: u32 = 19;
pub const THROTTLER_APCC_BIT: u32 = 20;
pub const FW_DSTATE_SOC_ULV_BIT: u32 = 0;
pub const FW_DSTATE_G6_HSR_BIT: u32 = 1;
pub const FW_DSTATE_G6_PHY_VDDCI_OFF_BIT: u32 = 2;
pub const FW_DSTATE_MP0_DS_BIT: u32 = 3;
pub const FW_DSTATE_SMN_DS_BIT: u32 = 4;
pub const FW_DSTATE_MP1_DS_BIT: u32 = 5;
pub const FW_DSTATE_MP1_WHISPER_MODE_BIT: u32 = 6;
pub const FW_DSTATE_LIV_MIN_BIT: u32 = 7;
pub const FW_DSTATE_SOC_PLL_PWRDN_BIT: u32 = 8;
pub const FW_DSTATE_SOC_ULV_MASK: u32 = 1;
pub const FW_DSTATE_G6_HSR_MASK: u32 = 2;
pub const FW_DSTATE_G6_PHY_VDDCI_OFF_MASK: u32 = 4;
pub const FW_DSTATE_MP1_DS_MASK: u32 = 32;
pub const FW_DSTATE_MP0_DS_MASK: u32 = 8;
pub const FW_DSTATE_SMN_DS_MASK: u32 = 16;
pub const FW_DSTATE_MP1_WHISPER_MODE_MASK: u32 = 64;
pub const FW_DSTATE_LIV_MIN_MASK: u32 = 128;
pub const FW_DSTATE_SOC_PLL_PWRDN_MASK: u32 = 256;
pub const NUM_I2C_CONTROLLERS: u32 = 8;
pub const I2C_CONTROLLER_ENABLED: u32 = 1;
pub const I2C_CONTROLLER_DISABLED: u32 = 0;
pub const MAX_SW_I2C_COMMANDS: u32 = 8;
pub const CMDCONFIG_STOP_BIT: u32 = 0;
pub const CMDCONFIG_RESTART_BIT: u32 = 1;
pub const CMDCONFIG_STOP_MASK: u32 = 1;
pub const CMDCONFIG_RESTART_MASK: u32 = 2;
pub const POWER_MANAGER_CONTROLLER_NOT_RUNNING: u32 = 0;
pub const POWER_MANAGER_CONTROLLER_RUNNING: u32 = 1;
pub const POWER_MANAGER_CONTROLLER_BIT: u32 = 0;
pub const MAXIMUM_DPM_STATE_GFX_ENGINE_RESTRICTED_BIT: u32 = 8;
pub const GPU_DIE_TEMPERATURE_THROTTLING_BIT: u32 = 9;
pub const HBM_DIE_TEMPERATURE_THROTTLING_BIT: u32 = 10;
pub const TGP_THROTTLING_BIT: u32 = 11;
pub const PCC_THROTTLING_BIT: u32 = 12;
pub const HBM_TEMPERATURE_EXCEEDING_TEMPERATURE_LIMIT_BIT: u32 = 13;
pub const HBM_TEMPERATURE_EXCEEDING_MAX_MEMORY_TEMPERATURE_BIT: u32 = 14;
pub const POWER_MANAGER_CONTROLLER_MASK: u32 = 1;
pub const MAXIMUM_DPM_STATE_GFX_ENGINE_RESTRICTED_MASK: u32 = 256;
pub const GPU_DIE_TEMPERATURE_THROTTLING_MASK: u32 = 512;
pub const HBM_DIE_TEMPERATURE_THROTTLING_MASK: u32 = 1024;
pub const TGP_THROTTLING_MASK: u32 = 2048;
pub const PCC_THROTTLING_MASK: u32 = 4096;
pub const HBM_TEMPERATURE_EXCEEDING_TEMPERATURE_LIMIT_MASK: u32 = 8192;
pub const HBM_TEMPERATURE_EXCEEDING_MAX_MEMORY_TEMPERATURE_MASK: u32 = 16384;
pub const NUM_WM_RANGES: u32 = 4;
pub const WORKLOAD_PPLIB_DEFAULT_BIT: u32 = 0;
pub const WORKLOAD_PPLIB_FULL_SCREEN_3D_BIT: u32 = 1;
pub const WORKLOAD_PPLIB_POWER_SAVING_BIT: u32 = 2;
pub const WORKLOAD_PPLIB_VIDEO_BIT: u32 = 3;
pub const WORKLOAD_PPLIB_VR_BIT: u32 = 4;
pub const WORKLOAD_PPLIB_COMPUTE_BIT: u32 = 5;
pub const WORKLOAD_PPLIB_CUSTOM_BIT: u32 = 6;
pub const WORKLOAD_PPLIB_COUNT: u32 = 7;
pub const TABLE_TRANSFER_OK: u32 = 0;
pub const TABLE_TRANSFER_FAILED: u32 = 255;
pub const TABLE_PPTABLE: u32 = 0;
pub const TABLE_WATERMARKS: u32 = 1;
pub const TABLE_AVFS: u32 = 2;
pub const TABLE_AVFS_PSM_DEBUG: u32 = 3;
pub const TABLE_AVFS_FUSE_OVERRIDE: u32 = 4;
pub const TABLE_PMSTATUSLOG: u32 = 5;
pub const TABLE_SMU_METRICS: u32 = 6;
pub const TABLE_DRIVER_SMU_CONFIG: u32 = 7;
pub const TABLE_ACTIVITY_MONITOR_COEFF: u32 = 8;
pub const TABLE_OVERDRIVE: u32 = 9;
pub const TABLE_I2C_COMMANDS: u32 = 10;
pub const TABLE_PACE: u32 = 11;
pub const TABLE_COUNT: u32 = 12;
pub const RLC_PACE_TABLE_NUM_LEVELS: u32 = 16;
pub const UCLK_SWITCH_SLOW: u32 = 0;
pub const UCLK_SWITCH_FAST: u32 = 1;
pub const SMU_11_0_TABLE_FORMAT_REVISION: u32 = 12;
pub const SMU_11_0_PP_PLATFORM_CAP_POWERPLAY: u32 = 1;
pub const SMU_11_0_PP_PLATFORM_CAP_SBIOSPOWERSOURCE: u32 = 2;
pub const SMU_11_0_PP_PLATFORM_CAP_HARDWAREDC: u32 = 4;
pub const SMU_11_0_PP_PLATFORM_CAP_BACO: u32 = 8;
pub const SMU_11_0_PP_PLATFORM_CAP_MACO: u32 = 16;
pub const SMU_11_0_PP_PLATFORM_CAP_SHADOWPSTATE: u32 = 32;
pub const SMU_11_0_PP_THERMALCONTROLLER_NONE: u32 = 0;
pub const SMU_11_0_PP_OVERDRIVE_VERSION: u32 = 2048;
pub const SMU_11_0_PP_POWERSAVINGCLOCK_VERSION: u32 = 256;
pub const SMU_11_0_MAX_ODFEATURE: u32 = 32;
pub const SMU_11_0_MAX_ODSETTING: u32 = 32;
pub const SMU_11_0_MAX_PPCLOCK: u32 = 16;
pub type __u_char = ::core::ffi::c_uchar;
pub type __u_short = ::core::ffi::c_ushort;
pub type __u_int = ::core::ffi::c_uint;
pub type __u_long = ::core::ffi::c_ulong;
pub type __int8_t = ::core::ffi::c_schar;
pub type __uint8_t = ::core::ffi::c_uchar;
pub type __int16_t = ::core::ffi::c_short;
pub type __uint16_t = ::core::ffi::c_ushort;
pub type __int32_t = ::core::ffi::c_int;
pub type __uint32_t = ::core::ffi::c_uint;
pub type __int64_t = ::core::ffi::c_long;
pub type __uint64_t = ::core::ffi::c_ulong;
pub type __int_least8_t = __int8_t;
pub type __uint_least8_t = __uint8_t;
pub type __int_least16_t = __int16_t;
pub type __uint_least16_t = __uint16_t;
pub type __int_least32_t = __int32_t;
pub type __uint_least32_t = __uint32_t;
pub type __int_least64_t = __int64_t;
pub type __uint_least64_t = __uint64_t;
pub type __quad_t = ::core::ffi::c_long;
pub type __u_quad_t = ::core::ffi::c_ulong;
pub type __intmax_t = ::core::ffi::c_long;
pub type __uintmax_t = ::core::ffi::c_ulong;
pub type __dev_t = ::core::ffi::c_ulong;
pub type __uid_t = ::core::ffi::c_uint;
pub type __gid_t = ::core::ffi::c_uint;
pub type __ino_t = ::core::ffi::c_ulong;
pub type __ino64_t = ::core::ffi::c_ulong;
pub type __mode_t = ::core::ffi::c_uint;
pub type __nlink_t = ::core::ffi::c_ulong;
pub type __off_t = ::core::ffi::c_long;
pub type __off64_t = ::core::ffi::c_long;
pub type __pid_t = ::core::ffi::c_int;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __fsid_t {
    pub __val: [::core::ffi::c_int; 2usize],
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of __fsid_t"][::core::mem::size_of::<__fsid_t>() - 8usize];
    ["Alignment of __fsid_t"][::core::mem::align_of::<__fsid_t>() - 4usize];
    ["Offset of field: __fsid_t::__val"][::core::mem::offset_of!(__fsid_t, __val) - 0usize];
};
pub type __clock_t = ::core::ffi::c_long;
pub type __rlim_t = ::core::ffi::c_ulong;
pub type __rlim64_t = ::core::ffi::c_ulong;
pub type __id_t = ::core::ffi::c_uint;
pub type __time_t = ::core::ffi::c_long;
pub type __useconds_t = ::core::ffi::c_uint;
pub type __suseconds_t = ::core::ffi::c_long;
pub type __suseconds64_t = ::core::ffi::c_long;
pub type __daddr_t = ::core::ffi::c_int;
pub type __key_t = ::core::ffi::c_int;
pub type __clockid_t = ::core::ffi::c_int;
pub type __timer_t = *mut ::core::ffi::c_void;
pub type __blksize_t = ::core::ffi::c_long;
pub type __blkcnt_t = ::core::ffi::c_long;
pub type __blkcnt64_t = ::core::ffi::c_long;
pub type __fsblkcnt_t = ::core::ffi::c_ulong;
pub type __fsblkcnt64_t = ::core::ffi::c_ulong;
pub type __fsfilcnt_t = ::core::ffi::c_ulong;
pub type __fsfilcnt64_t = ::core::ffi::c_ulong;
pub type __fsword_t = ::core::ffi::c_long;
pub type __ssize_t = ::core::ffi::c_long;
pub type __syscall_slong_t = ::core::ffi::c_long;
pub type __syscall_ulong_t = ::core::ffi::c_ulong;
pub type __loff_t = __off64_t;
pub type __caddr_t = *mut ::core::ffi::c_char;
pub type __intptr_t = ::core::ffi::c_long;
pub type __socklen_t = ::core::ffi::c_uint;
pub type __sig_atomic_t = ::core::ffi::c_int;
pub type int_least8_t = __int_least8_t;
pub type int_least16_t = __int_least16_t;
pub type int_least32_t = __int_least32_t;
pub type int_least64_t = __int_least64_t;
pub type uint_least8_t = __uint_least8_t;
pub type uint_least16_t = __uint_least16_t;
pub type uint_least32_t = __uint_least32_t;
pub type uint_least64_t = __uint_least64_t;
pub type int_fast8_t = ::core::ffi::c_schar;
pub type int_fast16_t = ::core::ffi::c_long;
pub type int_fast32_t = ::core::ffi::c_long;
pub type int_fast64_t = ::core::ffi::c_long;
pub type uint_fast8_t = ::core::ffi::c_uchar;
pub type uint_fast16_t = ::core::ffi::c_ulong;
pub type uint_fast32_t = ::core::ffi::c_ulong;
pub type uint_fast64_t = ::core::ffi::c_ulong;
pub type intmax_t = __intmax_t;
pub type uintmax_t = __uintmax_t;
pub const atom_bios_header_version_def_ATOM_MAJOR_VERSION: atom_bios_header_version_def = 3;
pub const atom_bios_header_version_def_ATOM_MINOR_VERSION: atom_bios_header_version_def = 3;
pub type atom_bios_header_version_def = ::core::ffi::c_uint;
pub const atom_crtc_def_ATOM_CRTC1: atom_crtc_def = 0;
pub const atom_crtc_def_ATOM_CRTC2: atom_crtc_def = 1;
pub const atom_crtc_def_ATOM_CRTC3: atom_crtc_def = 2;
pub const atom_crtc_def_ATOM_CRTC4: atom_crtc_def = 3;
pub const atom_crtc_def_ATOM_CRTC5: atom_crtc_def = 4;
pub const atom_crtc_def_ATOM_CRTC6: atom_crtc_def = 5;
pub const atom_crtc_def_ATOM_CRTC_INVALID: atom_crtc_def = 255;
pub type atom_crtc_def = ::core::ffi::c_uint;
pub const atom_ppll_def_ATOM_PPLL0: atom_ppll_def = 2;
pub const atom_ppll_def_ATOM_GCK_DFS: atom_ppll_def = 8;
pub const atom_ppll_def_ATOM_FCH_CLK: atom_ppll_def = 9;
pub const atom_ppll_def_ATOM_DP_DTO: atom_ppll_def = 11;
pub const atom_ppll_def_ATOM_COMBOPHY_PLL0: atom_ppll_def = 20;
pub const atom_ppll_def_ATOM_COMBOPHY_PLL1: atom_ppll_def = 21;
pub const atom_ppll_def_ATOM_COMBOPHY_PLL2: atom_ppll_def = 22;
pub const atom_ppll_def_ATOM_COMBOPHY_PLL3: atom_ppll_def = 23;
pub const atom_ppll_def_ATOM_COMBOPHY_PLL4: atom_ppll_def = 24;
pub const atom_ppll_def_ATOM_COMBOPHY_PLL5: atom_ppll_def = 25;
pub const atom_ppll_def_ATOM_PPLL_INVALID: atom_ppll_def = 255;
pub type atom_ppll_def = ::core::ffi::c_uint;
pub const atom_dig_def_ASIC_INT_DIG1_ENCODER_ID: atom_dig_def = 3;
pub const atom_dig_def_ASIC_INT_DIG2_ENCODER_ID: atom_dig_def = 9;
pub const atom_dig_def_ASIC_INT_DIG3_ENCODER_ID: atom_dig_def = 10;
pub const atom_dig_def_ASIC_INT_DIG4_ENCODER_ID: atom_dig_def = 11;
pub const atom_dig_def_ASIC_INT_DIG5_ENCODER_ID: atom_dig_def = 12;
pub const atom_dig_def_ASIC_INT_DIG6_ENCODER_ID: atom_dig_def = 13;
pub const atom_dig_def_ASIC_INT_DIG7_ENCODER_ID: atom_dig_def = 14;
pub type atom_dig_def = ::core::ffi::c_uint;
pub const atom_encode_mode_def_ATOM_ENCODER_MODE_DP: atom_encode_mode_def = 0;
pub const atom_encode_mode_def_ATOM_ENCODER_MODE_DP_SST: atom_encode_mode_def = 0;
pub const atom_encode_mode_def_ATOM_ENCODER_MODE_LVDS: atom_encode_mode_def = 1;
pub const atom_encode_mode_def_ATOM_ENCODER_MODE_DVI: atom_encode_mode_def = 2;
pub const atom_encode_mode_def_ATOM_ENCODER_MODE_HDMI: atom_encode_mode_def = 3;
pub const atom_encode_mode_def_ATOM_ENCODER_MODE_DP_AUDIO: atom_encode_mode_def = 5;
pub const atom_encode_mode_def_ATOM_ENCODER_MODE_DP_MST: atom_encode_mode_def = 5;
pub const atom_encode_mode_def_ATOM_ENCODER_MODE_CRT: atom_encode_mode_def = 15;
pub const atom_encode_mode_def_ATOM_ENCODER_MODE_DVO: atom_encode_mode_def = 16;
pub type atom_encode_mode_def = ::core::ffi::c_uint;
pub const atom_encoder_refclk_src_def_ENCODER_REFCLK_SRC_P1PLL: atom_encoder_refclk_src_def = 0;
pub const atom_encoder_refclk_src_def_ENCODER_REFCLK_SRC_P2PLL: atom_encoder_refclk_src_def = 1;
pub const atom_encoder_refclk_src_def_ENCODER_REFCLK_SRC_P3PLL: atom_encoder_refclk_src_def = 2;
pub const atom_encoder_refclk_src_def_ENCODER_REFCLK_SRC_EXTCLK: atom_encoder_refclk_src_def = 3;
pub const atom_encoder_refclk_src_def_ENCODER_REFCLK_SRC_INVALID: atom_encoder_refclk_src_def = 255;
pub type atom_encoder_refclk_src_def = ::core::ffi::c_uint;
pub const atom_scaler_def_ATOM_SCALER_DISABLE: atom_scaler_def = 0;
pub const atom_scaler_def_ATOM_SCALER_CENTER: atom_scaler_def = 1;
pub const atom_scaler_def_ATOM_SCALER_EXPANSION: atom_scaler_def = 2;
pub type atom_scaler_def = ::core::ffi::c_uint;
pub const atom_operation_def_ATOM_DISABLE: atom_operation_def = 0;
pub const atom_operation_def_ATOM_ENABLE: atom_operation_def = 1;
pub const atom_operation_def_ATOM_INIT: atom_operation_def = 7;
pub const atom_operation_def_ATOM_GET_STATUS: atom_operation_def = 8;
pub type atom_operation_def = ::core::ffi::c_uint;
pub const atom_embedded_display_op_def_ATOM_LCD_BL_OFF: atom_embedded_display_op_def = 2;
pub const atom_embedded_display_op_def_ATOM_LCD_BL_OM: atom_embedded_display_op_def = 3;
pub const atom_embedded_display_op_def_ATOM_LCD_BL_BRIGHTNESS_CONTROL:
    atom_embedded_display_op_def = 4;
pub const atom_embedded_display_op_def_ATOM_LCD_SELFTEST_START: atom_embedded_display_op_def = 5;
pub const atom_embedded_display_op_def_ATOM_LCD_SELFTEST_STOP: atom_embedded_display_op_def = 6;
pub type atom_embedded_display_op_def = ::core::ffi::c_uint;
pub const atom_spread_spectrum_mode_ATOM_SS_CENTER_OR_DOWN_MODE_MASK: atom_spread_spectrum_mode = 1;
pub const atom_spread_spectrum_mode_ATOM_SS_DOWN_SPREAD_MODE: atom_spread_spectrum_mode = 0;
pub const atom_spread_spectrum_mode_ATOM_SS_CENTRE_SPREAD_MODE: atom_spread_spectrum_mode = 1;
pub const atom_spread_spectrum_mode_ATOM_INT_OR_EXT_SS_MASK: atom_spread_spectrum_mode = 2;
pub const atom_spread_spectrum_mode_ATOM_INTERNAL_SS_MASK: atom_spread_spectrum_mode = 0;
pub const atom_spread_spectrum_mode_ATOM_EXTERNAL_SS_MASK: atom_spread_spectrum_mode = 2;
pub type atom_spread_spectrum_mode = ::core::ffi::c_uint;
pub const atom_panel_bit_per_color_PANEL_BPC_UNDEFINE: atom_panel_bit_per_color = 0;
pub const atom_panel_bit_per_color_PANEL_6BIT_PER_COLOR: atom_panel_bit_per_color = 1;
pub const atom_panel_bit_per_color_PANEL_8BIT_PER_COLOR: atom_panel_bit_per_color = 2;
pub const atom_panel_bit_per_color_PANEL_10BIT_PER_COLOR: atom_panel_bit_per_color = 3;
pub const atom_panel_bit_per_color_PANEL_12BIT_PER_COLOR: atom_panel_bit_per_color = 4;
pub const atom_panel_bit_per_color_PANEL_16BIT_PER_COLOR: atom_panel_bit_per_color = 5;
pub type atom_panel_bit_per_color = ::core::ffi::c_uint;
pub const atom_voltage_type_VOLTAGE_TYPE_VDDC: atom_voltage_type = 1;
pub const atom_voltage_type_VOLTAGE_TYPE_MVDDC: atom_voltage_type = 2;
pub const atom_voltage_type_VOLTAGE_TYPE_MVDDQ: atom_voltage_type = 3;
pub const atom_voltage_type_VOLTAGE_TYPE_VDDCI: atom_voltage_type = 4;
pub const atom_voltage_type_VOLTAGE_TYPE_VDDGFX: atom_voltage_type = 5;
pub const atom_voltage_type_VOLTAGE_TYPE_PCC: atom_voltage_type = 6;
pub const atom_voltage_type_VOLTAGE_TYPE_MVPP: atom_voltage_type = 7;
pub const atom_voltage_type_VOLTAGE_TYPE_LEDDPM: atom_voltage_type = 8;
pub const atom_voltage_type_VOLTAGE_TYPE_PCC_MVDD: atom_voltage_type = 9;
pub const atom_voltage_type_VOLTAGE_TYPE_PCIE_VDDC: atom_voltage_type = 10;
pub const atom_voltage_type_VOLTAGE_TYPE_PCIE_VDDR: atom_voltage_type = 11;
pub const atom_voltage_type_VOLTAGE_TYPE_GENERIC_I2C_1: atom_voltage_type = 17;
pub const atom_voltage_type_VOLTAGE_TYPE_GENERIC_I2C_2: atom_voltage_type = 18;
pub const atom_voltage_type_VOLTAGE_TYPE_GENERIC_I2C_3: atom_voltage_type = 19;
pub const atom_voltage_type_VOLTAGE_TYPE_GENERIC_I2C_4: atom_voltage_type = 20;
pub const atom_voltage_type_VOLTAGE_TYPE_GENERIC_I2C_5: atom_voltage_type = 21;
pub const atom_voltage_type_VOLTAGE_TYPE_GENERIC_I2C_6: atom_voltage_type = 22;
pub const atom_voltage_type_VOLTAGE_TYPE_GENERIC_I2C_7: atom_voltage_type = 23;
pub const atom_voltage_type_VOLTAGE_TYPE_GENERIC_I2C_8: atom_voltage_type = 24;
pub const atom_voltage_type_VOLTAGE_TYPE_GENERIC_I2C_9: atom_voltage_type = 25;
pub const atom_voltage_type_VOLTAGE_TYPE_GENERIC_I2C_10: atom_voltage_type = 26;
pub type atom_voltage_type = ::core::ffi::c_uint;
pub const atom_dgpu_vram_type_ATOM_DGPU_VRAM_TYPE_GDDR5: atom_dgpu_vram_type = 80;
pub const atom_dgpu_vram_type_ATOM_DGPU_VRAM_TYPE_HBM2: atom_dgpu_vram_type = 96;
pub const atom_dgpu_vram_type_ATOM_DGPU_VRAM_TYPE_HBM2E: atom_dgpu_vram_type = 97;
pub const atom_dgpu_vram_type_ATOM_DGPU_VRAM_TYPE_GDDR6: atom_dgpu_vram_type = 112;
pub const atom_dgpu_vram_type_ATOM_DGPU_VRAM_TYPE_HBM3: atom_dgpu_vram_type = 128;
pub type atom_dgpu_vram_type = ::core::ffi::c_uint;
pub const atom_dp_vs_preemph_def_DP_VS_LEVEL0_PREEMPH_LEVEL0: atom_dp_vs_preemph_def = 0;
pub const atom_dp_vs_preemph_def_DP_VS_LEVEL1_PREEMPH_LEVEL0: atom_dp_vs_preemph_def = 1;
pub const atom_dp_vs_preemph_def_DP_VS_LEVEL2_PREEMPH_LEVEL0: atom_dp_vs_preemph_def = 2;
pub const atom_dp_vs_preemph_def_DP_VS_LEVEL3_PREEMPH_LEVEL0: atom_dp_vs_preemph_def = 3;
pub const atom_dp_vs_preemph_def_DP_VS_LEVEL0_PREEMPH_LEVEL1: atom_dp_vs_preemph_def = 8;
pub const atom_dp_vs_preemph_def_DP_VS_LEVEL1_PREEMPH_LEVEL1: atom_dp_vs_preemph_def = 9;
pub const atom_dp_vs_preemph_def_DP_VS_LEVEL2_PREEMPH_LEVEL1: atom_dp_vs_preemph_def = 10;
pub const atom_dp_vs_preemph_def_DP_VS_LEVEL0_PREEMPH_LEVEL2: atom_dp_vs_preemph_def = 16;
pub const atom_dp_vs_preemph_def_DP_VS_LEVEL1_PREEMPH_LEVEL2: atom_dp_vs_preemph_def = 17;
pub const atom_dp_vs_preemph_def_DP_VS_LEVEL0_PREEMPH_LEVEL3: atom_dp_vs_preemph_def = 24;
pub type atom_dp_vs_preemph_def = ::core::ffi::c_uint;
pub const atombios_image_offset_OFFSET_TO_ATOM_ROM_HEADER_POINTER: atombios_image_offset = 72;
pub const atombios_image_offset_OFFSET_TO_ATOM_ROM_IMAGE_SIZE: atombios_image_offset = 2;
pub const atombios_image_offset_OFFSET_TO_ATOMBIOS_ASIC_BUS_MEM_TYPE: atombios_image_offset = 148;
pub const atombios_image_offset_MAXSIZE_OF_ATOMBIOS_ASIC_BUS_MEM_TYPE: atombios_image_offset = 20;
pub const atombios_image_offset_OFFSET_TO_GET_ATOMBIOS_NUMBER_OF_STRINGS: atombios_image_offset =
    47;
pub const atombios_image_offset_OFFSET_TO_GET_ATOMBIOS_STRING_START: atombios_image_offset = 110;
pub const atombios_image_offset_OFFSET_TO_VBIOS_PART_NUMBER: atombios_image_offset = 128;
pub const atombios_image_offset_OFFSET_TO_VBIOS_DATE: atombios_image_offset = 80;
pub type atombios_image_offset = ::core::ffi::c_uint;
#[doc = " Common header for all tables (Data table, Command function).\n Every table pointed in _ATOM_MASTER_DATA_TABLE has this common header.\n And the pointer actually points to this header."]
#[repr(C, packed)]
#[derive(Debug, Copy, Clone)]
pub struct atom_common_table_header {
    pub structuresize: u16,
    pub format_revision: u8,
    pub content_revision: u8,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of atom_common_table_header"]
        [::core::mem::size_of::<atom_common_table_header>() - 4usize];
    ["Alignment of atom_common_table_header"]
        [::core::mem::align_of::<atom_common_table_header>() - 1usize];
    ["Offset of field: atom_common_table_header::structuresize"]
        [::core::mem::offset_of!(atom_common_table_header, structuresize) - 0usize];
    ["Offset of field: atom_common_table_header::format_revision"]
        [::core::mem::offset_of!(atom_common_table_header, format_revision) - 2usize];
    ["Offset of field: atom_common_table_header::content_revision"]
        [::core::mem::offset_of!(atom_common_table_header, content_revision) - 3usize];
};
#[doc = " Structure stores the ROM header."]
#[repr(C, packed)]
#[derive(Debug, Copy, Clone)]
pub struct atom_rom_header_v2_2 {
    pub table_header: atom_common_table_header,
    pub atom_bios_string: [u8; 4usize],
    pub bios_segment_address: u16,
    pub protectedmodeoffset: u16,
    pub configfilenameoffset: u16,
    pub crc_block_offset: u16,
    pub vbios_bootupmessageoffset: u16,
    pub int10_offset: u16,
    pub pcibusdevinitcode: u16,
    pub iobaseaddress: u16,
    pub subsystem_vendor_id: u16,
    pub subsystem_id: u16,
    pub pci_info_offset: u16,
    pub masterhwfunction_offset: u16,
    pub masterdatatable_offset: u16,
    pub reserved: u16,
    pub pspdirtableoffset: u32,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of atom_rom_header_v2_2"][::core::mem::size_of::<atom_rom_header_v2_2>() - 40usize];
    ["Alignment of atom_rom_header_v2_2"][::core::mem::align_of::<atom_rom_header_v2_2>() - 1usize];
    ["Offset of field: atom_rom_header_v2_2::table_header"]
        [::core::mem::offset_of!(atom_rom_header_v2_2, table_header) - 0usize];
    ["Offset of field: atom_rom_header_v2_2::atom_bios_string"]
        [::core::mem::offset_of!(atom_rom_header_v2_2, atom_bios_string) - 4usize];
    ["Offset of field: atom_rom_header_v2_2::bios_segment_address"]
        [::core::mem::offset_of!(atom_rom_header_v2_2, bios_segment_address) - 8usize];
    ["Offset of field: atom_rom_header_v2_2::protectedmodeoffset"]
        [::core::mem::offset_of!(atom_rom_header_v2_2, protectedmodeoffset) - 10usize];
    ["Offset of field: atom_rom_header_v2_2::configfilenameoffset"]
        [::core::mem::offset_of!(atom_rom_header_v2_2, configfilenameoffset) - 12usize];
    ["Offset of field: atom_rom_header_v2_2::crc_block_offset"]
        [::core::mem::offset_of!(atom_rom_header_v2_2, crc_block_offset) - 14usize];
    ["Offset of field: atom_rom_header_v2_2::vbios_bootupmessageoffset"]
        [::core::mem::offset_of!(atom_rom_header_v2_2, vbios_bootupmessageoffset) - 16usize];
    ["Offset of field: atom_rom_header_v2_2::int10_offset"]
        [::core::mem::offset_of!(atom_rom_header_v2_2, int10_offset) - 18usize];
    ["Offset of field: atom_rom_header_v2_2::pcibusdevinitcode"]
        [::core::mem::offset_of!(atom_rom_header_v2_2, pcibusdevinitcode) - 20usize];
    ["Offset of field: atom_rom_header_v2_2::iobaseaddress"]
        [::core::mem::offset_of!(atom_rom_header_v2_2, iobaseaddress) - 22usize];
    ["Offset of field: atom_rom_header_v2_2::subsystem_vendor_id"]
        [::core::mem::offset_of!(atom_rom_header_v2_2, subsystem_vendor_id) - 24usize];
    ["Offset of field: atom_rom_header_v2_2::subsystem_id"]
        [::core::mem::offset_of!(atom_rom_header_v2_2, subsystem_id) - 26usize];
    ["Offset of field: atom_rom_header_v2_2::pci_info_offset"]
        [::core::mem::offset_of!(atom_rom_header_v2_2, pci_info_offset) - 28usize];
    ["Offset of field: atom_rom_header_v2_2::masterhwfunction_offset"]
        [::core::mem::offset_of!(atom_rom_header_v2_2, masterhwfunction_offset) - 30usize];
    ["Offset of field: atom_rom_header_v2_2::masterdatatable_offset"]
        [::core::mem::offset_of!(atom_rom_header_v2_2, masterdatatable_offset) - 32usize];
    ["Offset of field: atom_rom_header_v2_2::reserved"]
        [::core::mem::offset_of!(atom_rom_header_v2_2, reserved) - 34usize];
    ["Offset of field: atom_rom_header_v2_2::pspdirtableoffset"]
        [::core::mem::offset_of!(atom_rom_header_v2_2, pspdirtableoffset) - 36usize];
};
#[doc = " Structures used in Command.mtb, each function name is not given here since those function could change from time to time\n The real functionality of each function is associated with the parameter structure version when defined\n For all internal cmd function definitions, please reference to atomstruct.h"]
#[repr(C, packed)]
#[derive(Debug, Copy, Clone)]
pub struct atom_master_list_of_command_functions_v2_1 {
    pub asic_init: u16,
    pub cmd_function1: u16,
    pub cmd_function2: u16,
    pub cmd_function3: u16,
    pub digxencodercontrol: u16,
    pub cmd_function5: u16,
    pub cmd_function6: u16,
    pub cmd_function7: u16,
    pub cmd_function8: u16,
    pub cmd_function9: u16,
    pub setengineclock: u16,
    pub setmemoryclock: u16,
    pub setpixelclock: u16,
    pub enabledisppowergating: u16,
    pub cmd_function14: u16,
    pub cmd_function15: u16,
    pub cmd_function16: u16,
    pub cmd_function17: u16,
    pub cmd_function18: u16,
    pub cmd_function19: u16,
    pub cmd_function20: u16,
    pub cmd_function21: u16,
    pub cmd_function22: u16,
    pub cmd_function23: u16,
    pub cmd_function24: u16,
    pub cmd_function25: u16,
    pub cmd_function26: u16,
    pub cmd_function27: u16,
    pub cmd_function28: u16,
    pub cmd_function29: u16,
    pub cmd_function30: u16,
    pub cmd_function31: u16,
    pub cmd_function32: u16,
    pub cmd_function33: u16,
    pub blankcrtc: u16,
    pub enablecrtc: u16,
    pub cmd_function36: u16,
    pub cmd_function37: u16,
    pub cmd_function38: u16,
    pub cmd_function39: u16,
    pub cmd_function40: u16,
    pub getsmuclockinfo: u16,
    pub selectcrtc_source: u16,
    pub cmd_function43: u16,
    pub cmd_function44: u16,
    pub cmd_function45: u16,
    pub setdceclock: u16,
    pub getmemoryclock: u16,
    pub getengineclock: u16,
    pub setcrtc_usingdtdtiming: u16,
    pub externalencodercontrol: u16,
    pub cmd_function51: u16,
    pub cmd_function52: u16,
    pub cmd_function53: u16,
    pub processi2cchanneltransaction: u16,
    pub cmd_function55: u16,
    pub cmd_function56: u16,
    pub cmd_function57: u16,
    pub cmd_function58: u16,
    pub cmd_function59: u16,
    pub computegpuclockparam: u16,
    pub cmd_function61: u16,
    pub cmd_function62: u16,
    pub dynamicmemorysettings: u16,
    pub memorytraining: u16,
    pub cmd_function65: u16,
    pub cmd_function66: u16,
    pub setvoltage: u16,
    pub cmd_function68: u16,
    pub readefusevalue: u16,
    pub cmd_function70: u16,
    pub cmd_function71: u16,
    pub cmd_function72: u16,
    pub cmd_function73: u16,
    pub cmd_function74: u16,
    pub cmd_function75: u16,
    pub dig1transmittercontrol: u16,
    pub cmd_function77: u16,
    pub processauxchanneltransaction: u16,
    pub cmd_function79: u16,
    pub getvoltageinfo: u16,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of atom_master_list_of_command_functions_v2_1"]
        [::core::mem::size_of::<atom_master_list_of_command_functions_v2_1>() - 162usize];
    ["Alignment of atom_master_list_of_command_functions_v2_1"]
        [::core::mem::align_of::<atom_master_list_of_command_functions_v2_1>() - 1usize];
    ["Offset of field: atom_master_list_of_command_functions_v2_1::asic_init"]
        [::core::mem::offset_of!(atom_master_list_of_command_functions_v2_1, asic_init) - 0usize];
    ["Offset of field: atom_master_list_of_command_functions_v2_1::cmd_function1"][::core::mem::offset_of!(
        atom_master_list_of_command_functions_v2_1,
        cmd_function1
    ) - 2usize];
    ["Offset of field: atom_master_list_of_command_functions_v2_1::cmd_function2"][::core::mem::offset_of!(
        atom_master_list_of_command_functions_v2_1,
        cmd_function2
    ) - 4usize];
    ["Offset of field: atom_master_list_of_command_functions_v2_1::cmd_function3"][::core::mem::offset_of!(
        atom_master_list_of_command_functions_v2_1,
        cmd_function3
    ) - 6usize];
    ["Offset of field: atom_master_list_of_command_functions_v2_1::digxencodercontrol"][::core::mem::offset_of!(
        atom_master_list_of_command_functions_v2_1,
        digxencodercontrol
    ) - 8usize];
    ["Offset of field: atom_master_list_of_command_functions_v2_1::cmd_function5"][::core::mem::offset_of!(
        atom_master_list_of_command_functions_v2_1,
        cmd_function5
    ) - 10usize];
    ["Offset of field: atom_master_list_of_command_functions_v2_1::cmd_function6"][::core::mem::offset_of!(
        atom_master_list_of_command_functions_v2_1,
        cmd_function6
    ) - 12usize];
    ["Offset of field: atom_master_list_of_command_functions_v2_1::cmd_function7"][::core::mem::offset_of!(
        atom_master_list_of_command_functions_v2_1,
        cmd_function7
    ) - 14usize];
    ["Offset of field: atom_master_list_of_command_functions_v2_1::cmd_function8"][::core::mem::offset_of!(
        atom_master_list_of_command_functions_v2_1,
        cmd_function8
    ) - 16usize];
    ["Offset of field: atom_master_list_of_command_functions_v2_1::cmd_function9"][::core::mem::offset_of!(
        atom_master_list_of_command_functions_v2_1,
        cmd_function9
    ) - 18usize];
    ["Offset of field: atom_master_list_of_command_functions_v2_1::setengineclock"][::core::mem::offset_of!(
        atom_master_list_of_command_functions_v2_1,
        setengineclock
    ) - 20usize];
    ["Offset of field: atom_master_list_of_command_functions_v2_1::setmemoryclock"][::core::mem::offset_of!(
        atom_master_list_of_command_functions_v2_1,
        setmemoryclock
    ) - 22usize];
    ["Offset of field: atom_master_list_of_command_functions_v2_1::setpixelclock"][::core::mem::offset_of!(
        atom_master_list_of_command_functions_v2_1,
        setpixelclock
    ) - 24usize];
    ["Offset of field: atom_master_list_of_command_functions_v2_1::enabledisppowergating"][::core::mem::offset_of!(
        atom_master_list_of_command_functions_v2_1,
        enabledisppowergating
    )
        - 26usize];
    ["Offset of field: atom_master_list_of_command_functions_v2_1::cmd_function14"][::core::mem::offset_of!(
        atom_master_list_of_command_functions_v2_1,
        cmd_function14
    ) - 28usize];
    ["Offset of field: atom_master_list_of_command_functions_v2_1::cmd_function15"][::core::mem::offset_of!(
        atom_master_list_of_command_functions_v2_1,
        cmd_function15
    ) - 30usize];
    ["Offset of field: atom_master_list_of_command_functions_v2_1::cmd_function16"][::core::mem::offset_of!(
        atom_master_list_of_command_functions_v2_1,
        cmd_function16
    ) - 32usize];
    ["Offset of field: atom_master_list_of_command_functions_v2_1::cmd_function17"][::core::mem::offset_of!(
        atom_master_list_of_command_functions_v2_1,
        cmd_function17
    ) - 34usize];
    ["Offset of field: atom_master_list_of_command_functions_v2_1::cmd_function18"][::core::mem::offset_of!(
        atom_master_list_of_command_functions_v2_1,
        cmd_function18
    ) - 36usize];
    ["Offset of field: atom_master_list_of_command_functions_v2_1::cmd_function19"][::core::mem::offset_of!(
        atom_master_list_of_command_functions_v2_1,
        cmd_function19
    ) - 38usize];
    ["Offset of field: atom_master_list_of_command_functions_v2_1::cmd_function20"][::core::mem::offset_of!(
        atom_master_list_of_command_functions_v2_1,
        cmd_function20
    ) - 40usize];
    ["Offset of field: atom_master_list_of_command_functions_v2_1::cmd_function21"][::core::mem::offset_of!(
        atom_master_list_of_command_functions_v2_1,
        cmd_function21
    ) - 42usize];
    ["Offset of field: atom_master_list_of_command_functions_v2_1::cmd_function22"][::core::mem::offset_of!(
        atom_master_list_of_command_functions_v2_1,
        cmd_function22
    ) - 44usize];
    ["Offset of field: atom_master_list_of_command_functions_v2_1::cmd_function23"][::core::mem::offset_of!(
        atom_master_list_of_command_functions_v2_1,
        cmd_function23
    ) - 46usize];
    ["Offset of field: atom_master_list_of_command_functions_v2_1::cmd_function24"][::core::mem::offset_of!(
        atom_master_list_of_command_functions_v2_1,
        cmd_function24
    ) - 48usize];
    ["Offset of field: atom_master_list_of_command_functions_v2_1::cmd_function25"][::core::mem::offset_of!(
        atom_master_list_of_command_functions_v2_1,
        cmd_function25
    ) - 50usize];
    ["Offset of field: atom_master_list_of_command_functions_v2_1::cmd_function26"][::core::mem::offset_of!(
        atom_master_list_of_command_functions_v2_1,
        cmd_function26
    ) - 52usize];
    ["Offset of field: atom_master_list_of_command_functions_v2_1::cmd_function27"][::core::mem::offset_of!(
        atom_master_list_of_command_functions_v2_1,
        cmd_function27
    ) - 54usize];
    ["Offset of field: atom_master_list_of_command_functions_v2_1::cmd_function28"][::core::mem::offset_of!(
        atom_master_list_of_command_functions_v2_1,
        cmd_function28
    ) - 56usize];
    ["Offset of field: atom_master_list_of_command_functions_v2_1::cmd_function29"][::core::mem::offset_of!(
        atom_master_list_of_command_functions_v2_1,
        cmd_function29
    ) - 58usize];
    ["Offset of field: atom_master_list_of_command_functions_v2_1::cmd_function30"][::core::mem::offset_of!(
        atom_master_list_of_command_functions_v2_1,
        cmd_function30
    ) - 60usize];
    ["Offset of field: atom_master_list_of_command_functions_v2_1::cmd_function31"][::core::mem::offset_of!(
        atom_master_list_of_command_functions_v2_1,
        cmd_function31
    ) - 62usize];
    ["Offset of field: atom_master_list_of_command_functions_v2_1::cmd_function32"][::core::mem::offset_of!(
        atom_master_list_of_command_functions_v2_1,
        cmd_function32
    ) - 64usize];
    ["Offset of field: atom_master_list_of_command_functions_v2_1::cmd_function33"][::core::mem::offset_of!(
        atom_master_list_of_command_functions_v2_1,
        cmd_function33
    ) - 66usize];
    ["Offset of field: atom_master_list_of_command_functions_v2_1::blankcrtc"]
        [::core::mem::offset_of!(atom_master_list_of_command_functions_v2_1, blankcrtc) - 68usize];
    ["Offset of field: atom_master_list_of_command_functions_v2_1::enablecrtc"]
        [::core::mem::offset_of!(atom_master_list_of_command_functions_v2_1, enablecrtc) - 70usize];
    ["Offset of field: atom_master_list_of_command_functions_v2_1::cmd_function36"][::core::mem::offset_of!(
        atom_master_list_of_command_functions_v2_1,
        cmd_function36
    ) - 72usize];
    ["Offset of field: atom_master_list_of_command_functions_v2_1::cmd_function37"][::core::mem::offset_of!(
        atom_master_list_of_command_functions_v2_1,
        cmd_function37
    ) - 74usize];
    ["Offset of field: atom_master_list_of_command_functions_v2_1::cmd_function38"][::core::mem::offset_of!(
        atom_master_list_of_command_functions_v2_1,
        cmd_function38
    ) - 76usize];
    ["Offset of field: atom_master_list_of_command_functions_v2_1::cmd_function39"][::core::mem::offset_of!(
        atom_master_list_of_command_functions_v2_1,
        cmd_function39
    ) - 78usize];
    ["Offset of field: atom_master_list_of_command_functions_v2_1::cmd_function40"][::core::mem::offset_of!(
        atom_master_list_of_command_functions_v2_1,
        cmd_function40
    ) - 80usize];
    ["Offset of field: atom_master_list_of_command_functions_v2_1::getsmuclockinfo"][::core::mem::offset_of!(
        atom_master_list_of_command_functions_v2_1,
        getsmuclockinfo
    ) - 82usize];
    ["Offset of field: atom_master_list_of_command_functions_v2_1::selectcrtc_source"][::core::mem::offset_of!(
        atom_master_list_of_command_functions_v2_1,
        selectcrtc_source
    ) - 84usize];
    ["Offset of field: atom_master_list_of_command_functions_v2_1::cmd_function43"][::core::mem::offset_of!(
        atom_master_list_of_command_functions_v2_1,
        cmd_function43
    ) - 86usize];
    ["Offset of field: atom_master_list_of_command_functions_v2_1::cmd_function44"][::core::mem::offset_of!(
        atom_master_list_of_command_functions_v2_1,
        cmd_function44
    ) - 88usize];
    ["Offset of field: atom_master_list_of_command_functions_v2_1::cmd_function45"][::core::mem::offset_of!(
        atom_master_list_of_command_functions_v2_1,
        cmd_function45
    ) - 90usize];
    ["Offset of field: atom_master_list_of_command_functions_v2_1::setdceclock"][::core::mem::offset_of!(
        atom_master_list_of_command_functions_v2_1,
        setdceclock
    ) - 92usize];
    ["Offset of field: atom_master_list_of_command_functions_v2_1::getmemoryclock"][::core::mem::offset_of!(
        atom_master_list_of_command_functions_v2_1,
        getmemoryclock
    ) - 94usize];
    ["Offset of field: atom_master_list_of_command_functions_v2_1::getengineclock"][::core::mem::offset_of!(
        atom_master_list_of_command_functions_v2_1,
        getengineclock
    ) - 96usize];
    ["Offset of field: atom_master_list_of_command_functions_v2_1::setcrtc_usingdtdtiming"][::core::mem::offset_of!(
        atom_master_list_of_command_functions_v2_1,
        setcrtc_usingdtdtiming
    )
        - 98usize];
    ["Offset of field: atom_master_list_of_command_functions_v2_1::externalencodercontrol"][::core::mem::offset_of!(
        atom_master_list_of_command_functions_v2_1,
        externalencodercontrol
    )
        - 100usize];
    ["Offset of field: atom_master_list_of_command_functions_v2_1::cmd_function51"][::core::mem::offset_of!(
        atom_master_list_of_command_functions_v2_1,
        cmd_function51
    ) - 102usize];
    ["Offset of field: atom_master_list_of_command_functions_v2_1::cmd_function52"][::core::mem::offset_of!(
        atom_master_list_of_command_functions_v2_1,
        cmd_function52
    ) - 104usize];
    ["Offset of field: atom_master_list_of_command_functions_v2_1::cmd_function53"][::core::mem::offset_of!(
        atom_master_list_of_command_functions_v2_1,
        cmd_function53
    ) - 106usize];
    ["Offset of field: atom_master_list_of_command_functions_v2_1::processi2cchanneltransaction"][::core::mem::offset_of!(
        atom_master_list_of_command_functions_v2_1,
        processi2cchanneltransaction
    )
        - 108usize];
    ["Offset of field: atom_master_list_of_command_functions_v2_1::cmd_function55"][::core::mem::offset_of!(
        atom_master_list_of_command_functions_v2_1,
        cmd_function55
    ) - 110usize];
    ["Offset of field: atom_master_list_of_command_functions_v2_1::cmd_function56"][::core::mem::offset_of!(
        atom_master_list_of_command_functions_v2_1,
        cmd_function56
    ) - 112usize];
    ["Offset of field: atom_master_list_of_command_functions_v2_1::cmd_function57"][::core::mem::offset_of!(
        atom_master_list_of_command_functions_v2_1,
        cmd_function57
    ) - 114usize];
    ["Offset of field: atom_master_list_of_command_functions_v2_1::cmd_function58"][::core::mem::offset_of!(
        atom_master_list_of_command_functions_v2_1,
        cmd_function58
    ) - 116usize];
    ["Offset of field: atom_master_list_of_command_functions_v2_1::cmd_function59"][::core::mem::offset_of!(
        atom_master_list_of_command_functions_v2_1,
        cmd_function59
    ) - 118usize];
    ["Offset of field: atom_master_list_of_command_functions_v2_1::computegpuclockparam"][::core::mem::offset_of!(
        atom_master_list_of_command_functions_v2_1,
        computegpuclockparam
    )
        - 120usize];
    ["Offset of field: atom_master_list_of_command_functions_v2_1::cmd_function61"][::core::mem::offset_of!(
        atom_master_list_of_command_functions_v2_1,
        cmd_function61
    ) - 122usize];
    ["Offset of field: atom_master_list_of_command_functions_v2_1::cmd_function62"][::core::mem::offset_of!(
        atom_master_list_of_command_functions_v2_1,
        cmd_function62
    ) - 124usize];
    ["Offset of field: atom_master_list_of_command_functions_v2_1::dynamicmemorysettings"][::core::mem::offset_of!(
        atom_master_list_of_command_functions_v2_1,
        dynamicmemorysettings
    )
        - 126usize];
    ["Offset of field: atom_master_list_of_command_functions_v2_1::memorytraining"][::core::mem::offset_of!(
        atom_master_list_of_command_functions_v2_1,
        memorytraining
    ) - 128usize];
    ["Offset of field: atom_master_list_of_command_functions_v2_1::cmd_function65"][::core::mem::offset_of!(
        atom_master_list_of_command_functions_v2_1,
        cmd_function65
    ) - 130usize];
    ["Offset of field: atom_master_list_of_command_functions_v2_1::cmd_function66"][::core::mem::offset_of!(
        atom_master_list_of_command_functions_v2_1,
        cmd_function66
    ) - 132usize];
    ["Offset of field: atom_master_list_of_command_functions_v2_1::setvoltage"][::core::mem::offset_of!(
        atom_master_list_of_command_functions_v2_1,
        setvoltage
    ) - 134usize];
    ["Offset of field: atom_master_list_of_command_functions_v2_1::cmd_function68"][::core::mem::offset_of!(
        atom_master_list_of_command_functions_v2_1,
        cmd_function68
    ) - 136usize];
    ["Offset of field: atom_master_list_of_command_functions_v2_1::readefusevalue"][::core::mem::offset_of!(
        atom_master_list_of_command_functions_v2_1,
        readefusevalue
    ) - 138usize];
    ["Offset of field: atom_master_list_of_command_functions_v2_1::cmd_function70"][::core::mem::offset_of!(
        atom_master_list_of_command_functions_v2_1,
        cmd_function70
    ) - 140usize];
    ["Offset of field: atom_master_list_of_command_functions_v2_1::cmd_function71"][::core::mem::offset_of!(
        atom_master_list_of_command_functions_v2_1,
        cmd_function71
    ) - 142usize];
    ["Offset of field: atom_master_list_of_command_functions_v2_1::cmd_function72"][::core::mem::offset_of!(
        atom_master_list_of_command_functions_v2_1,
        cmd_function72
    ) - 144usize];
    ["Offset of field: atom_master_list_of_command_functions_v2_1::cmd_function73"][::core::mem::offset_of!(
        atom_master_list_of_command_functions_v2_1,
        cmd_function73
    ) - 146usize];
    ["Offset of field: atom_master_list_of_command_functions_v2_1::cmd_function74"][::core::mem::offset_of!(
        atom_master_list_of_command_functions_v2_1,
        cmd_function74
    ) - 148usize];
    ["Offset of field: atom_master_list_of_command_functions_v2_1::cmd_function75"][::core::mem::offset_of!(
        atom_master_list_of_command_functions_v2_1,
        cmd_function75
    ) - 150usize];
    ["Offset of field: atom_master_list_of_command_functions_v2_1::dig1transmittercontrol"][::core::mem::offset_of!(
        atom_master_list_of_command_functions_v2_1,
        dig1transmittercontrol
    )
        - 152usize];
    ["Offset of field: atom_master_list_of_command_functions_v2_1::cmd_function77"][::core::mem::offset_of!(
        atom_master_list_of_command_functions_v2_1,
        cmd_function77
    ) - 154usize];
    ["Offset of field: atom_master_list_of_command_functions_v2_1::processauxchanneltransaction"][::core::mem::offset_of!(
        atom_master_list_of_command_functions_v2_1,
        processauxchanneltransaction
    )
        - 156usize];
    ["Offset of field: atom_master_list_of_command_functions_v2_1::cmd_function79"][::core::mem::offset_of!(
        atom_master_list_of_command_functions_v2_1,
        cmd_function79
    ) - 158usize];
    ["Offset of field: atom_master_list_of_command_functions_v2_1::getvoltageinfo"][::core::mem::offset_of!(
        atom_master_list_of_command_functions_v2_1,
        getvoltageinfo
    ) - 160usize];
};
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct atom_master_command_function_v2_1 {
    pub table_header: atom_common_table_header,
    pub listofcmdfunctions: atom_master_list_of_command_functions_v2_1,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of atom_master_command_function_v2_1"]
        [::core::mem::size_of::<atom_master_command_function_v2_1>() - 166usize];
    ["Alignment of atom_master_command_function_v2_1"]
        [::core::mem::align_of::<atom_master_command_function_v2_1>() - 1usize];
    ["Offset of field: atom_master_command_function_v2_1::table_header"]
        [::core::mem::offset_of!(atom_master_command_function_v2_1, table_header) - 0usize];
    ["Offset of field: atom_master_command_function_v2_1::listofcmdfunctions"]
        [::core::mem::offset_of!(atom_master_command_function_v2_1, listofcmdfunctions) - 4usize];
};
#[doc = " Structures used in every command function"]
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct atom_function_attribute {
    pub _bitfield_align_1: [u8; 0],
    pub _bitfield_1: __BindgenBitfieldUnit<[u8; 2usize]>,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of atom_function_attribute"][::core::mem::size_of::<atom_function_attribute>() - 2usize];
    ["Alignment of atom_function_attribute"]
        [::core::mem::align_of::<atom_function_attribute>() - 1usize];
};
impl atom_function_attribute {
    #[inline]
    pub fn ws_in_bytes(&self) -> u16 {
        unsafe { ::core::mem::transmute(self._bitfield_1.get(0usize, 8u8) as u16) }
    }
    #[inline]
    pub fn set_ws_in_bytes(&mut self, val: u16) {
        unsafe {
            let val: u16 = ::core::mem::transmute(val);
            self._bitfield_1.set(0usize, 8u8, val as u64)
        }
    }
    #[inline]
    pub unsafe fn ws_in_bytes_raw(this: *const Self) -> u16 {
        unsafe {
            ::core::mem::transmute(<__BindgenBitfieldUnit<[u8; 2usize]>>::raw_get(
                ::core::ptr::addr_of!((*this)._bitfield_1),
                0usize,
                8u8,
            ) as u16)
        }
    }
    #[inline]
    pub unsafe fn set_ws_in_bytes_raw(this: *mut Self, val: u16) {
        unsafe {
            let val: u16 = ::core::mem::transmute(val);
            <__BindgenBitfieldUnit<[u8; 2usize]>>::raw_set(
                ::core::ptr::addr_of_mut!((*this)._bitfield_1),
                0usize,
                8u8,
                val as u64,
            )
        }
    }
    #[inline]
    pub fn ps_in_bytes(&self) -> u16 {
        unsafe { ::core::mem::transmute(self._bitfield_1.get(8usize, 7u8) as u16) }
    }
    #[inline]
    pub fn set_ps_in_bytes(&mut self, val: u16) {
        unsafe {
            let val: u16 = ::core::mem::transmute(val);
            self._bitfield_1.set(8usize, 7u8, val as u64)
        }
    }
    #[inline]
    pub unsafe fn ps_in_bytes_raw(this: *const Self) -> u16 {
        unsafe {
            ::core::mem::transmute(<__BindgenBitfieldUnit<[u8; 2usize]>>::raw_get(
                ::core::ptr::addr_of!((*this)._bitfield_1),
                8usize,
                7u8,
            ) as u16)
        }
    }
    #[inline]
    pub unsafe fn set_ps_in_bytes_raw(this: *mut Self, val: u16) {
        unsafe {
            let val: u16 = ::core::mem::transmute(val);
            <__BindgenBitfieldUnit<[u8; 2usize]>>::raw_set(
                ::core::ptr::addr_of_mut!((*this)._bitfield_1),
                8usize,
                7u8,
                val as u64,
            )
        }
    }
    #[inline]
    pub fn updated_by_util(&self) -> u16 {
        unsafe { ::core::mem::transmute(self._bitfield_1.get(15usize, 1u8) as u16) }
    }
    #[inline]
    pub fn set_updated_by_util(&mut self, val: u16) {
        unsafe {
            let val: u16 = ::core::mem::transmute(val);
            self._bitfield_1.set(15usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub unsafe fn updated_by_util_raw(this: *const Self) -> u16 {
        unsafe {
            ::core::mem::transmute(<__BindgenBitfieldUnit<[u8; 2usize]>>::raw_get(
                ::core::ptr::addr_of!((*this)._bitfield_1),
                15usize,
                1u8,
            ) as u16)
        }
    }
    #[inline]
    pub unsafe fn set_updated_by_util_raw(this: *mut Self, val: u16) {
        unsafe {
            let val: u16 = ::core::mem::transmute(val);
            <__BindgenBitfieldUnit<[u8; 2usize]>>::raw_set(
                ::core::ptr::addr_of_mut!((*this)._bitfield_1),
                15usize,
                1u8,
                val as u64,
            )
        }
    }
    #[inline]
    pub fn new_bitfield_1(
        ws_in_bytes: u16,
        ps_in_bytes: u16,
        updated_by_util: u16,
    ) -> __BindgenBitfieldUnit<[u8; 2usize]> {
        let mut __bindgen_bitfield_unit: __BindgenBitfieldUnit<[u8; 2usize]> = Default::default();
        __bindgen_bitfield_unit.set(0usize, 8u8, {
            let ws_in_bytes: u16 = unsafe { ::core::mem::transmute(ws_in_bytes) };
            ws_in_bytes as u64
        });
        __bindgen_bitfield_unit.set(8usize, 7u8, {
            let ps_in_bytes: u16 = unsafe { ::core::mem::transmute(ps_in_bytes) };
            ps_in_bytes as u64
        });
        __bindgen_bitfield_unit.set(15usize, 1u8, {
            let updated_by_util: u16 = unsafe { ::core::mem::transmute(updated_by_util) };
            updated_by_util as u64
        });
        __bindgen_bitfield_unit
    }
}
#[doc = " Common header for all hw functions.\n Every function pointed by _master_list_of_hw_function has this common header.\n And the pointer actually points to this header."]
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct atom_rom_hw_function_header {
    pub func_header: atom_common_table_header,
    pub func_attrib: atom_function_attribute,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of atom_rom_hw_function_header"]
        [::core::mem::size_of::<atom_rom_hw_function_header>() - 6usize];
    ["Alignment of atom_rom_hw_function_header"]
        [::core::mem::align_of::<atom_rom_hw_function_header>() - 1usize];
    ["Offset of field: atom_rom_hw_function_header::func_header"]
        [::core::mem::offset_of!(atom_rom_hw_function_header, func_header) - 0usize];
    ["Offset of field: atom_rom_hw_function_header::func_attrib"]
        [::core::mem::offset_of!(atom_rom_hw_function_header, func_attrib) - 4usize];
};
#[doc = " Structures used in data.mtb, each data table name is not given here since those data table could change from time to time\n The real name of each table is given when its data structure version is defined"]
#[repr(C, packed)]
#[derive(Debug, Copy, Clone)]
pub struct atom_master_list_of_data_tables_v2_1 {
    pub utilitypipeline: u16,
    pub multimedia_info: u16,
    pub smc_dpm_info: u16,
    pub sw_datatable3: u16,
    pub firmwareinfo: u16,
    pub sw_datatable5: u16,
    pub lcd_info: u16,
    pub sw_datatable7: u16,
    pub smu_info: u16,
    pub sw_datatable9: u16,
    pub sw_datatable10: u16,
    pub vram_usagebyfirmware: u16,
    pub gpio_pin_lut: u16,
    pub sw_datatable13: u16,
    pub gfx_info: u16,
    pub powerplayinfo: u16,
    pub sw_datatable16: u16,
    pub sw_datatable17: u16,
    pub sw_datatable18: u16,
    pub sw_datatable19: u16,
    pub sw_datatable20: u16,
    pub sw_datatable21: u16,
    pub displayobjectinfo: u16,
    pub indirectioaccess: u16,
    pub umc_info: u16,
    pub sw_datatable25: u16,
    pub sw_datatable26: u16,
    pub dce_info: u16,
    pub vram_info: u16,
    pub sw_datatable29: u16,
    pub integratedsysteminfo: u16,
    pub asic_profiling_info: u16,
    pub voltageobject_info: u16,
    pub sw_datatable33: u16,
    pub sw_datatable34: u16,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of atom_master_list_of_data_tables_v2_1"]
        [::core::mem::size_of::<atom_master_list_of_data_tables_v2_1>() - 70usize];
    ["Alignment of atom_master_list_of_data_tables_v2_1"]
        [::core::mem::align_of::<atom_master_list_of_data_tables_v2_1>() - 1usize];
    ["Offset of field: atom_master_list_of_data_tables_v2_1::utilitypipeline"]
        [::core::mem::offset_of!(atom_master_list_of_data_tables_v2_1, utilitypipeline) - 0usize];
    ["Offset of field: atom_master_list_of_data_tables_v2_1::multimedia_info"]
        [::core::mem::offset_of!(atom_master_list_of_data_tables_v2_1, multimedia_info) - 2usize];
    ["Offset of field: atom_master_list_of_data_tables_v2_1::smc_dpm_info"]
        [::core::mem::offset_of!(atom_master_list_of_data_tables_v2_1, smc_dpm_info) - 4usize];
    ["Offset of field: atom_master_list_of_data_tables_v2_1::sw_datatable3"]
        [::core::mem::offset_of!(atom_master_list_of_data_tables_v2_1, sw_datatable3) - 6usize];
    ["Offset of field: atom_master_list_of_data_tables_v2_1::firmwareinfo"]
        [::core::mem::offset_of!(atom_master_list_of_data_tables_v2_1, firmwareinfo) - 8usize];
    ["Offset of field: atom_master_list_of_data_tables_v2_1::sw_datatable5"]
        [::core::mem::offset_of!(atom_master_list_of_data_tables_v2_1, sw_datatable5) - 10usize];
    ["Offset of field: atom_master_list_of_data_tables_v2_1::lcd_info"]
        [::core::mem::offset_of!(atom_master_list_of_data_tables_v2_1, lcd_info) - 12usize];
    ["Offset of field: atom_master_list_of_data_tables_v2_1::sw_datatable7"]
        [::core::mem::offset_of!(atom_master_list_of_data_tables_v2_1, sw_datatable7) - 14usize];
    ["Offset of field: atom_master_list_of_data_tables_v2_1::smu_info"]
        [::core::mem::offset_of!(atom_master_list_of_data_tables_v2_1, smu_info) - 16usize];
    ["Offset of field: atom_master_list_of_data_tables_v2_1::sw_datatable9"]
        [::core::mem::offset_of!(atom_master_list_of_data_tables_v2_1, sw_datatable9) - 18usize];
    ["Offset of field: atom_master_list_of_data_tables_v2_1::sw_datatable10"]
        [::core::mem::offset_of!(atom_master_list_of_data_tables_v2_1, sw_datatable10) - 20usize];
    ["Offset of field: atom_master_list_of_data_tables_v2_1::vram_usagebyfirmware"][::core::mem::offset_of!(
        atom_master_list_of_data_tables_v2_1,
        vram_usagebyfirmware
    ) - 22usize];
    ["Offset of field: atom_master_list_of_data_tables_v2_1::gpio_pin_lut"]
        [::core::mem::offset_of!(atom_master_list_of_data_tables_v2_1, gpio_pin_lut) - 24usize];
    ["Offset of field: atom_master_list_of_data_tables_v2_1::sw_datatable13"]
        [::core::mem::offset_of!(atom_master_list_of_data_tables_v2_1, sw_datatable13) - 26usize];
    ["Offset of field: atom_master_list_of_data_tables_v2_1::gfx_info"]
        [::core::mem::offset_of!(atom_master_list_of_data_tables_v2_1, gfx_info) - 28usize];
    ["Offset of field: atom_master_list_of_data_tables_v2_1::powerplayinfo"]
        [::core::mem::offset_of!(atom_master_list_of_data_tables_v2_1, powerplayinfo) - 30usize];
    ["Offset of field: atom_master_list_of_data_tables_v2_1::sw_datatable16"]
        [::core::mem::offset_of!(atom_master_list_of_data_tables_v2_1, sw_datatable16) - 32usize];
    ["Offset of field: atom_master_list_of_data_tables_v2_1::sw_datatable17"]
        [::core::mem::offset_of!(atom_master_list_of_data_tables_v2_1, sw_datatable17) - 34usize];
    ["Offset of field: atom_master_list_of_data_tables_v2_1::sw_datatable18"]
        [::core::mem::offset_of!(atom_master_list_of_data_tables_v2_1, sw_datatable18) - 36usize];
    ["Offset of field: atom_master_list_of_data_tables_v2_1::sw_datatable19"]
        [::core::mem::offset_of!(atom_master_list_of_data_tables_v2_1, sw_datatable19) - 38usize];
    ["Offset of field: atom_master_list_of_data_tables_v2_1::sw_datatable20"]
        [::core::mem::offset_of!(atom_master_list_of_data_tables_v2_1, sw_datatable20) - 40usize];
    ["Offset of field: atom_master_list_of_data_tables_v2_1::sw_datatable21"]
        [::core::mem::offset_of!(atom_master_list_of_data_tables_v2_1, sw_datatable21) - 42usize];
    ["Offset of field: atom_master_list_of_data_tables_v2_1::displayobjectinfo"][::core::mem::offset_of!(
        atom_master_list_of_data_tables_v2_1,
        displayobjectinfo
    ) - 44usize];
    ["Offset of field: atom_master_list_of_data_tables_v2_1::indirectioaccess"]
        [::core::mem::offset_of!(atom_master_list_of_data_tables_v2_1, indirectioaccess) - 46usize];
    ["Offset of field: atom_master_list_of_data_tables_v2_1::umc_info"]
        [::core::mem::offset_of!(atom_master_list_of_data_tables_v2_1, umc_info) - 48usize];
    ["Offset of field: atom_master_list_of_data_tables_v2_1::sw_datatable25"]
        [::core::mem::offset_of!(atom_master_list_of_data_tables_v2_1, sw_datatable25) - 50usize];
    ["Offset of field: atom_master_list_of_data_tables_v2_1::sw_datatable26"]
        [::core::mem::offset_of!(atom_master_list_of_data_tables_v2_1, sw_datatable26) - 52usize];
    ["Offset of field: atom_master_list_of_data_tables_v2_1::dce_info"]
        [::core::mem::offset_of!(atom_master_list_of_data_tables_v2_1, dce_info) - 54usize];
    ["Offset of field: atom_master_list_of_data_tables_v2_1::vram_info"]
        [::core::mem::offset_of!(atom_master_list_of_data_tables_v2_1, vram_info) - 56usize];
    ["Offset of field: atom_master_list_of_data_tables_v2_1::sw_datatable29"]
        [::core::mem::offset_of!(atom_master_list_of_data_tables_v2_1, sw_datatable29) - 58usize];
    ["Offset of field: atom_master_list_of_data_tables_v2_1::integratedsysteminfo"][::core::mem::offset_of!(
        atom_master_list_of_data_tables_v2_1,
        integratedsysteminfo
    ) - 60usize];
    ["Offset of field: atom_master_list_of_data_tables_v2_1::asic_profiling_info"][::core::mem::offset_of!(
        atom_master_list_of_data_tables_v2_1,
        asic_profiling_info
    ) - 62usize];
    ["Offset of field: atom_master_list_of_data_tables_v2_1::voltageobject_info"][::core::mem::offset_of!(
        atom_master_list_of_data_tables_v2_1,
        voltageobject_info
    ) - 64usize];
    ["Offset of field: atom_master_list_of_data_tables_v2_1::sw_datatable33"]
        [::core::mem::offset_of!(atom_master_list_of_data_tables_v2_1, sw_datatable33) - 66usize];
    ["Offset of field: atom_master_list_of_data_tables_v2_1::sw_datatable34"]
        [::core::mem::offset_of!(atom_master_list_of_data_tables_v2_1, sw_datatable34) - 68usize];
};
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct atom_master_data_table_v2_1 {
    pub table_header: atom_common_table_header,
    pub listOfdatatables: atom_master_list_of_data_tables_v2_1,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of atom_master_data_table_v2_1"]
        [::core::mem::size_of::<atom_master_data_table_v2_1>() - 74usize];
    ["Alignment of atom_master_data_table_v2_1"]
        [::core::mem::align_of::<atom_master_data_table_v2_1>() - 1usize];
    ["Offset of field: atom_master_data_table_v2_1::table_header"]
        [::core::mem::offset_of!(atom_master_data_table_v2_1, table_header) - 0usize];
    ["Offset of field: atom_master_data_table_v2_1::listOfdatatables"]
        [::core::mem::offset_of!(atom_master_data_table_v2_1, listOfdatatables) - 4usize];
};
#[repr(C, packed)]
#[derive(Debug, Copy, Clone)]
pub struct atom_dtd_format {
    pub pixclk: u16,
    pub h_active: u16,
    pub h_blanking_time: u16,
    pub v_active: u16,
    pub v_blanking_time: u16,
    pub h_sync_offset: u16,
    pub h_sync_width: u16,
    pub v_sync_offset: u16,
    pub v_syncwidth: u16,
    pub reserved: u16,
    pub reserved0: u16,
    pub h_border: u8,
    pub v_border: u8,
    pub miscinfo: u16,
    pub atom_mode_id: u8,
    pub refreshrate: u8,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of atom_dtd_format"][::core::mem::size_of::<atom_dtd_format>() - 28usize];
    ["Alignment of atom_dtd_format"][::core::mem::align_of::<atom_dtd_format>() - 1usize];
    ["Offset of field: atom_dtd_format::pixclk"]
        [::core::mem::offset_of!(atom_dtd_format, pixclk) - 0usize];
    ["Offset of field: atom_dtd_format::h_active"]
        [::core::mem::offset_of!(atom_dtd_format, h_active) - 2usize];
    ["Offset of field: atom_dtd_format::h_blanking_time"]
        [::core::mem::offset_of!(atom_dtd_format, h_blanking_time) - 4usize];
    ["Offset of field: atom_dtd_format::v_active"]
        [::core::mem::offset_of!(atom_dtd_format, v_active) - 6usize];
    ["Offset of field: atom_dtd_format::v_blanking_time"]
        [::core::mem::offset_of!(atom_dtd_format, v_blanking_time) - 8usize];
    ["Offset of field: atom_dtd_format::h_sync_offset"]
        [::core::mem::offset_of!(atom_dtd_format, h_sync_offset) - 10usize];
    ["Offset of field: atom_dtd_format::h_sync_width"]
        [::core::mem::offset_of!(atom_dtd_format, h_sync_width) - 12usize];
    ["Offset of field: atom_dtd_format::v_sync_offset"]
        [::core::mem::offset_of!(atom_dtd_format, v_sync_offset) - 14usize];
    ["Offset of field: atom_dtd_format::v_syncwidth"]
        [::core::mem::offset_of!(atom_dtd_format, v_syncwidth) - 16usize];
    ["Offset of field: atom_dtd_format::reserved"]
        [::core::mem::offset_of!(atom_dtd_format, reserved) - 18usize];
    ["Offset of field: atom_dtd_format::reserved0"]
        [::core::mem::offset_of!(atom_dtd_format, reserved0) - 20usize];
    ["Offset of field: atom_dtd_format::h_border"]
        [::core::mem::offset_of!(atom_dtd_format, h_border) - 22usize];
    ["Offset of field: atom_dtd_format::v_border"]
        [::core::mem::offset_of!(atom_dtd_format, v_border) - 23usize];
    ["Offset of field: atom_dtd_format::miscinfo"]
        [::core::mem::offset_of!(atom_dtd_format, miscinfo) - 24usize];
    ["Offset of field: atom_dtd_format::atom_mode_id"]
        [::core::mem::offset_of!(atom_dtd_format, atom_mode_id) - 26usize];
    ["Offset of field: atom_dtd_format::refreshrate"]
        [::core::mem::offset_of!(atom_dtd_format, refreshrate) - 27usize];
};
pub const atom_dtd_format_modemiscinfo_ATOM_HSYNC_POLARITY: atom_dtd_format_modemiscinfo = 2;
pub const atom_dtd_format_modemiscinfo_ATOM_VSYNC_POLARITY: atom_dtd_format_modemiscinfo = 4;
pub const atom_dtd_format_modemiscinfo_ATOM_H_REPLICATIONBY2: atom_dtd_format_modemiscinfo = 16;
pub const atom_dtd_format_modemiscinfo_ATOM_V_REPLICATIONBY2: atom_dtd_format_modemiscinfo = 32;
pub const atom_dtd_format_modemiscinfo_ATOM_INTERLACE: atom_dtd_format_modemiscinfo = 128;
pub const atom_dtd_format_modemiscinfo_ATOM_COMPOSITESYNC: atom_dtd_format_modemiscinfo = 64;
pub type atom_dtd_format_modemiscinfo = ::core::ffi::c_uint;
#[repr(C, packed)]
#[derive(Debug, Copy, Clone)]
pub struct atom_firmware_info_v3_1 {
    pub table_header: atom_common_table_header,
    pub firmware_revision: u32,
    pub bootup_sclk_in10khz: u32,
    pub bootup_mclk_in10khz: u32,
    pub firmware_capability: u32,
    pub main_call_parser_entry: u32,
    pub bios_scratch_reg_startaddr: u32,
    pub bootup_vddc_mv: u16,
    pub bootup_vddci_mv: u16,
    pub bootup_mvddc_mv: u16,
    pub bootup_vddgfx_mv: u16,
    pub mem_module_id: u8,
    pub coolingsolution_id: u8,
    pub reserved1: [u8; 2usize],
    pub mc_baseaddr_high: u32,
    pub mc_baseaddr_low: u32,
    pub reserved2: [u32; 6usize],
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of atom_firmware_info_v3_1"]
        [::core::mem::size_of::<atom_firmware_info_v3_1>() - 72usize];
    ["Alignment of atom_firmware_info_v3_1"]
        [::core::mem::align_of::<atom_firmware_info_v3_1>() - 1usize];
    ["Offset of field: atom_firmware_info_v3_1::table_header"]
        [::core::mem::offset_of!(atom_firmware_info_v3_1, table_header) - 0usize];
    ["Offset of field: atom_firmware_info_v3_1::firmware_revision"]
        [::core::mem::offset_of!(atom_firmware_info_v3_1, firmware_revision) - 4usize];
    ["Offset of field: atom_firmware_info_v3_1::bootup_sclk_in10khz"]
        [::core::mem::offset_of!(atom_firmware_info_v3_1, bootup_sclk_in10khz) - 8usize];
    ["Offset of field: atom_firmware_info_v3_1::bootup_mclk_in10khz"]
        [::core::mem::offset_of!(atom_firmware_info_v3_1, bootup_mclk_in10khz) - 12usize];
    ["Offset of field: atom_firmware_info_v3_1::firmware_capability"]
        [::core::mem::offset_of!(atom_firmware_info_v3_1, firmware_capability) - 16usize];
    ["Offset of field: atom_firmware_info_v3_1::main_call_parser_entry"]
        [::core::mem::offset_of!(atom_firmware_info_v3_1, main_call_parser_entry) - 20usize];
    ["Offset of field: atom_firmware_info_v3_1::bios_scratch_reg_startaddr"]
        [::core::mem::offset_of!(atom_firmware_info_v3_1, bios_scratch_reg_startaddr) - 24usize];
    ["Offset of field: atom_firmware_info_v3_1::bootup_vddc_mv"]
        [::core::mem::offset_of!(atom_firmware_info_v3_1, bootup_vddc_mv) - 28usize];
    ["Offset of field: atom_firmware_info_v3_1::bootup_vddci_mv"]
        [::core::mem::offset_of!(atom_firmware_info_v3_1, bootup_vddci_mv) - 30usize];
    ["Offset of field: atom_firmware_info_v3_1::bootup_mvddc_mv"]
        [::core::mem::offset_of!(atom_firmware_info_v3_1, bootup_mvddc_mv) - 32usize];
    ["Offset of field: atom_firmware_info_v3_1::bootup_vddgfx_mv"]
        [::core::mem::offset_of!(atom_firmware_info_v3_1, bootup_vddgfx_mv) - 34usize];
    ["Offset of field: atom_firmware_info_v3_1::mem_module_id"]
        [::core::mem::offset_of!(atom_firmware_info_v3_1, mem_module_id) - 36usize];
    ["Offset of field: atom_firmware_info_v3_1::coolingsolution_id"]
        [::core::mem::offset_of!(atom_firmware_info_v3_1, coolingsolution_id) - 37usize];
    ["Offset of field: atom_firmware_info_v3_1::reserved1"]
        [::core::mem::offset_of!(atom_firmware_info_v3_1, reserved1) - 38usize];
    ["Offset of field: atom_firmware_info_v3_1::mc_baseaddr_high"]
        [::core::mem::offset_of!(atom_firmware_info_v3_1, mc_baseaddr_high) - 40usize];
    ["Offset of field: atom_firmware_info_v3_1::mc_baseaddr_low"]
        [::core::mem::offset_of!(atom_firmware_info_v3_1, mc_baseaddr_low) - 44usize];
    ["Offset of field: atom_firmware_info_v3_1::reserved2"]
        [::core::mem::offset_of!(atom_firmware_info_v3_1, reserved2) - 48usize];
};
pub const atombios_firmware_capability_ATOM_FIRMWARE_CAP_FIRMWARE_POSTED:
    atombios_firmware_capability = 1;
pub const atombios_firmware_capability_ATOM_FIRMWARE_CAP_GPU_VIRTUALIZATION:
    atombios_firmware_capability = 2;
pub const atombios_firmware_capability_ATOM_FIRMWARE_CAP_WMI_SUPPORT: atombios_firmware_capability =
    64;
pub const atombios_firmware_capability_ATOM_FIRMWARE_CAP_HWEMU_ENABLE:
    atombios_firmware_capability = 128;
pub const atombios_firmware_capability_ATOM_FIRMWARE_CAP_HWEMU_UMC_CFG:
    atombios_firmware_capability = 256;
pub const atombios_firmware_capability_ATOM_FIRMWARE_CAP_SRAM_ECC: atombios_firmware_capability =
    512;
pub const atombios_firmware_capability_ATOM_FIRMWARE_CAP_ENABLE_2STAGE_BIST_TRAINING:
    atombios_firmware_capability = 1024;
pub const atombios_firmware_capability_ATOM_FIRMWARE_CAP_ENABLE_2ND_USB20PORT:
    atombios_firmware_capability = 32768;
pub const atombios_firmware_capability_ATOM_FIRMWARE_CAP_DYNAMIC_BOOT_CFG_ENABLE:
    atombios_firmware_capability = 131072;
pub type atombios_firmware_capability = ::core::ffi::c_uint;
pub const atom_cooling_solution_id_AIR_COOLING: atom_cooling_solution_id = 0;
pub const atom_cooling_solution_id_LIQUID_COOLING: atom_cooling_solution_id = 1;
pub type atom_cooling_solution_id = ::core::ffi::c_uint;
#[repr(C, packed)]
#[derive(Debug, Copy, Clone)]
pub struct atom_firmware_info_v3_2 {
    pub table_header: atom_common_table_header,
    pub firmware_revision: u32,
    pub bootup_sclk_in10khz: u32,
    pub bootup_mclk_in10khz: u32,
    pub firmware_capability: u32,
    pub main_call_parser_entry: u32,
    pub bios_scratch_reg_startaddr: u32,
    pub bootup_vddc_mv: u16,
    pub bootup_vddci_mv: u16,
    pub bootup_mvddc_mv: u16,
    pub bootup_vddgfx_mv: u16,
    pub mem_module_id: u8,
    pub coolingsolution_id: u8,
    pub reserved1: [u8; 2usize],
    pub mc_baseaddr_high: u32,
    pub mc_baseaddr_low: u32,
    pub board_i2c_feature_id: u8,
    pub board_i2c_feature_gpio_id: u8,
    pub board_i2c_feature_slave_addr: u8,
    pub reserved3: u8,
    pub bootup_mvddq_mv: u16,
    pub bootup_mvpp_mv: u16,
    pub zfbstartaddrin16mb: u32,
    pub reserved2: [u32; 3usize],
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of atom_firmware_info_v3_2"]
        [::core::mem::size_of::<atom_firmware_info_v3_2>() - 72usize];
    ["Alignment of atom_firmware_info_v3_2"]
        [::core::mem::align_of::<atom_firmware_info_v3_2>() - 1usize];
    ["Offset of field: atom_firmware_info_v3_2::table_header"]
        [::core::mem::offset_of!(atom_firmware_info_v3_2, table_header) - 0usize];
    ["Offset of field: atom_firmware_info_v3_2::firmware_revision"]
        [::core::mem::offset_of!(atom_firmware_info_v3_2, firmware_revision) - 4usize];
    ["Offset of field: atom_firmware_info_v3_2::bootup_sclk_in10khz"]
        [::core::mem::offset_of!(atom_firmware_info_v3_2, bootup_sclk_in10khz) - 8usize];
    ["Offset of field: atom_firmware_info_v3_2::bootup_mclk_in10khz"]
        [::core::mem::offset_of!(atom_firmware_info_v3_2, bootup_mclk_in10khz) - 12usize];
    ["Offset of field: atom_firmware_info_v3_2::firmware_capability"]
        [::core::mem::offset_of!(atom_firmware_info_v3_2, firmware_capability) - 16usize];
    ["Offset of field: atom_firmware_info_v3_2::main_call_parser_entry"]
        [::core::mem::offset_of!(atom_firmware_info_v3_2, main_call_parser_entry) - 20usize];
    ["Offset of field: atom_firmware_info_v3_2::bios_scratch_reg_startaddr"]
        [::core::mem::offset_of!(atom_firmware_info_v3_2, bios_scratch_reg_startaddr) - 24usize];
    ["Offset of field: atom_firmware_info_v3_2::bootup_vddc_mv"]
        [::core::mem::offset_of!(atom_firmware_info_v3_2, bootup_vddc_mv) - 28usize];
    ["Offset of field: atom_firmware_info_v3_2::bootup_vddci_mv"]
        [::core::mem::offset_of!(atom_firmware_info_v3_2, bootup_vddci_mv) - 30usize];
    ["Offset of field: atom_firmware_info_v3_2::bootup_mvddc_mv"]
        [::core::mem::offset_of!(atom_firmware_info_v3_2, bootup_mvddc_mv) - 32usize];
    ["Offset of field: atom_firmware_info_v3_2::bootup_vddgfx_mv"]
        [::core::mem::offset_of!(atom_firmware_info_v3_2, bootup_vddgfx_mv) - 34usize];
    ["Offset of field: atom_firmware_info_v3_2::mem_module_id"]
        [::core::mem::offset_of!(atom_firmware_info_v3_2, mem_module_id) - 36usize];
    ["Offset of field: atom_firmware_info_v3_2::coolingsolution_id"]
        [::core::mem::offset_of!(atom_firmware_info_v3_2, coolingsolution_id) - 37usize];
    ["Offset of field: atom_firmware_info_v3_2::reserved1"]
        [::core::mem::offset_of!(atom_firmware_info_v3_2, reserved1) - 38usize];
    ["Offset of field: atom_firmware_info_v3_2::mc_baseaddr_high"]
        [::core::mem::offset_of!(atom_firmware_info_v3_2, mc_baseaddr_high) - 40usize];
    ["Offset of field: atom_firmware_info_v3_2::mc_baseaddr_low"]
        [::core::mem::offset_of!(atom_firmware_info_v3_2, mc_baseaddr_low) - 44usize];
    ["Offset of field: atom_firmware_info_v3_2::board_i2c_feature_id"]
        [::core::mem::offset_of!(atom_firmware_info_v3_2, board_i2c_feature_id) - 48usize];
    ["Offset of field: atom_firmware_info_v3_2::board_i2c_feature_gpio_id"]
        [::core::mem::offset_of!(atom_firmware_info_v3_2, board_i2c_feature_gpio_id) - 49usize];
    ["Offset of field: atom_firmware_info_v3_2::board_i2c_feature_slave_addr"]
        [::core::mem::offset_of!(atom_firmware_info_v3_2, board_i2c_feature_slave_addr) - 50usize];
    ["Offset of field: atom_firmware_info_v3_2::reserved3"]
        [::core::mem::offset_of!(atom_firmware_info_v3_2, reserved3) - 51usize];
    ["Offset of field: atom_firmware_info_v3_2::bootup_mvddq_mv"]
        [::core::mem::offset_of!(atom_firmware_info_v3_2, bootup_mvddq_mv) - 52usize];
    ["Offset of field: atom_firmware_info_v3_2::bootup_mvpp_mv"]
        [::core::mem::offset_of!(atom_firmware_info_v3_2, bootup_mvpp_mv) - 54usize];
    ["Offset of field: atom_firmware_info_v3_2::zfbstartaddrin16mb"]
        [::core::mem::offset_of!(atom_firmware_info_v3_2, zfbstartaddrin16mb) - 56usize];
    ["Offset of field: atom_firmware_info_v3_2::reserved2"]
        [::core::mem::offset_of!(atom_firmware_info_v3_2, reserved2) - 60usize];
};
#[repr(C, packed)]
#[derive(Debug, Copy, Clone)]
pub struct atom_firmware_info_v3_3 {
    pub table_header: atom_common_table_header,
    pub firmware_revision: u32,
    pub bootup_sclk_in10khz: u32,
    pub bootup_mclk_in10khz: u32,
    pub firmware_capability: u32,
    pub main_call_parser_entry: u32,
    pub bios_scratch_reg_startaddr: u32,
    pub bootup_vddc_mv: u16,
    pub bootup_vddci_mv: u16,
    pub bootup_mvddc_mv: u16,
    pub bootup_vddgfx_mv: u16,
    pub mem_module_id: u8,
    pub coolingsolution_id: u8,
    pub reserved1: [u8; 2usize],
    pub mc_baseaddr_high: u32,
    pub mc_baseaddr_low: u32,
    pub board_i2c_feature_id: u8,
    pub board_i2c_feature_gpio_id: u8,
    pub board_i2c_feature_slave_addr: u8,
    pub reserved3: u8,
    pub bootup_mvddq_mv: u16,
    pub bootup_mvpp_mv: u16,
    pub zfbstartaddrin16mb: u32,
    pub pplib_pptable_id: u32,
    pub reserved2: [u32; 2usize],
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of atom_firmware_info_v3_3"]
        [::core::mem::size_of::<atom_firmware_info_v3_3>() - 72usize];
    ["Alignment of atom_firmware_info_v3_3"]
        [::core::mem::align_of::<atom_firmware_info_v3_3>() - 1usize];
    ["Offset of field: atom_firmware_info_v3_3::table_header"]
        [::core::mem::offset_of!(atom_firmware_info_v3_3, table_header) - 0usize];
    ["Offset of field: atom_firmware_info_v3_3::firmware_revision"]
        [::core::mem::offset_of!(atom_firmware_info_v3_3, firmware_revision) - 4usize];
    ["Offset of field: atom_firmware_info_v3_3::bootup_sclk_in10khz"]
        [::core::mem::offset_of!(atom_firmware_info_v3_3, bootup_sclk_in10khz) - 8usize];
    ["Offset of field: atom_firmware_info_v3_3::bootup_mclk_in10khz"]
        [::core::mem::offset_of!(atom_firmware_info_v3_3, bootup_mclk_in10khz) - 12usize];
    ["Offset of field: atom_firmware_info_v3_3::firmware_capability"]
        [::core::mem::offset_of!(atom_firmware_info_v3_3, firmware_capability) - 16usize];
    ["Offset of field: atom_firmware_info_v3_3::main_call_parser_entry"]
        [::core::mem::offset_of!(atom_firmware_info_v3_3, main_call_parser_entry) - 20usize];
    ["Offset of field: atom_firmware_info_v3_3::bios_scratch_reg_startaddr"]
        [::core::mem::offset_of!(atom_firmware_info_v3_3, bios_scratch_reg_startaddr) - 24usize];
    ["Offset of field: atom_firmware_info_v3_3::bootup_vddc_mv"]
        [::core::mem::offset_of!(atom_firmware_info_v3_3, bootup_vddc_mv) - 28usize];
    ["Offset of field: atom_firmware_info_v3_3::bootup_vddci_mv"]
        [::core::mem::offset_of!(atom_firmware_info_v3_3, bootup_vddci_mv) - 30usize];
    ["Offset of field: atom_firmware_info_v3_3::bootup_mvddc_mv"]
        [::core::mem::offset_of!(atom_firmware_info_v3_3, bootup_mvddc_mv) - 32usize];
    ["Offset of field: atom_firmware_info_v3_3::bootup_vddgfx_mv"]
        [::core::mem::offset_of!(atom_firmware_info_v3_3, bootup_vddgfx_mv) - 34usize];
    ["Offset of field: atom_firmware_info_v3_3::mem_module_id"]
        [::core::mem::offset_of!(atom_firmware_info_v3_3, mem_module_id) - 36usize];
    ["Offset of field: atom_firmware_info_v3_3::coolingsolution_id"]
        [::core::mem::offset_of!(atom_firmware_info_v3_3, coolingsolution_id) - 37usize];
    ["Offset of field: atom_firmware_info_v3_3::reserved1"]
        [::core::mem::offset_of!(atom_firmware_info_v3_3, reserved1) - 38usize];
    ["Offset of field: atom_firmware_info_v3_3::mc_baseaddr_high"]
        [::core::mem::offset_of!(atom_firmware_info_v3_3, mc_baseaddr_high) - 40usize];
    ["Offset of field: atom_firmware_info_v3_3::mc_baseaddr_low"]
        [::core::mem::offset_of!(atom_firmware_info_v3_3, mc_baseaddr_low) - 44usize];
    ["Offset of field: atom_firmware_info_v3_3::board_i2c_feature_id"]
        [::core::mem::offset_of!(atom_firmware_info_v3_3, board_i2c_feature_id) - 48usize];
    ["Offset of field: atom_firmware_info_v3_3::board_i2c_feature_gpio_id"]
        [::core::mem::offset_of!(atom_firmware_info_v3_3, board_i2c_feature_gpio_id) - 49usize];
    ["Offset of field: atom_firmware_info_v3_3::board_i2c_feature_slave_addr"]
        [::core::mem::offset_of!(atom_firmware_info_v3_3, board_i2c_feature_slave_addr) - 50usize];
    ["Offset of field: atom_firmware_info_v3_3::reserved3"]
        [::core::mem::offset_of!(atom_firmware_info_v3_3, reserved3) - 51usize];
    ["Offset of field: atom_firmware_info_v3_3::bootup_mvddq_mv"]
        [::core::mem::offset_of!(atom_firmware_info_v3_3, bootup_mvddq_mv) - 52usize];
    ["Offset of field: atom_firmware_info_v3_3::bootup_mvpp_mv"]
        [::core::mem::offset_of!(atom_firmware_info_v3_3, bootup_mvpp_mv) - 54usize];
    ["Offset of field: atom_firmware_info_v3_3::zfbstartaddrin16mb"]
        [::core::mem::offset_of!(atom_firmware_info_v3_3, zfbstartaddrin16mb) - 56usize];
    ["Offset of field: atom_firmware_info_v3_3::pplib_pptable_id"]
        [::core::mem::offset_of!(atom_firmware_info_v3_3, pplib_pptable_id) - 60usize];
    ["Offset of field: atom_firmware_info_v3_3::reserved2"]
        [::core::mem::offset_of!(atom_firmware_info_v3_3, reserved2) - 64usize];
};
#[repr(C, packed)]
#[derive(Debug, Copy, Clone)]
pub struct atom_firmware_info_v3_4 {
    pub table_header: atom_common_table_header,
    pub firmware_revision: u32,
    pub bootup_sclk_in10khz: u32,
    pub bootup_mclk_in10khz: u32,
    pub firmware_capability: u32,
    pub main_call_parser_entry: u32,
    pub bios_scratch_reg_startaddr: u32,
    pub bootup_vddc_mv: u16,
    pub bootup_vddci_mv: u16,
    pub bootup_mvddc_mv: u16,
    pub bootup_vddgfx_mv: u16,
    pub mem_module_id: u8,
    pub coolingsolution_id: u8,
    pub reserved1: [u8; 2usize],
    pub mc_baseaddr_high: u32,
    pub mc_baseaddr_low: u32,
    pub board_i2c_feature_id: u8,
    pub board_i2c_feature_gpio_id: u8,
    pub board_i2c_feature_slave_addr: u8,
    pub ras_rom_i2c_slave_addr: u8,
    pub bootup_mvddq_mv: u16,
    pub bootup_mvpp_mv: u16,
    pub zfbstartaddrin16mb: u32,
    pub pplib_pptable_id: u32,
    pub mvdd_ratio: u32,
    pub hw_bootup_vddgfx_mv: u16,
    pub hw_bootup_vddc_mv: u16,
    pub hw_bootup_mvddc_mv: u16,
    pub hw_bootup_vddci_mv: u16,
    pub maco_pwrlimit_mw: u32,
    pub usb_pwrlimit_mw: u32,
    pub fw_reserved_size_in_kb: u32,
    pub pspbl_init_done_reg_addr: u32,
    pub pspbl_init_done_value: u32,
    pub pspbl_init_done_check_timeout: u32,
    pub reserved: [u32; 2usize],
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of atom_firmware_info_v3_4"]
        [::core::mem::size_of::<atom_firmware_info_v3_4>() - 108usize];
    ["Alignment of atom_firmware_info_v3_4"]
        [::core::mem::align_of::<atom_firmware_info_v3_4>() - 1usize];
    ["Offset of field: atom_firmware_info_v3_4::table_header"]
        [::core::mem::offset_of!(atom_firmware_info_v3_4, table_header) - 0usize];
    ["Offset of field: atom_firmware_info_v3_4::firmware_revision"]
        [::core::mem::offset_of!(atom_firmware_info_v3_4, firmware_revision) - 4usize];
    ["Offset of field: atom_firmware_info_v3_4::bootup_sclk_in10khz"]
        [::core::mem::offset_of!(atom_firmware_info_v3_4, bootup_sclk_in10khz) - 8usize];
    ["Offset of field: atom_firmware_info_v3_4::bootup_mclk_in10khz"]
        [::core::mem::offset_of!(atom_firmware_info_v3_4, bootup_mclk_in10khz) - 12usize];
    ["Offset of field: atom_firmware_info_v3_4::firmware_capability"]
        [::core::mem::offset_of!(atom_firmware_info_v3_4, firmware_capability) - 16usize];
    ["Offset of field: atom_firmware_info_v3_4::main_call_parser_entry"]
        [::core::mem::offset_of!(atom_firmware_info_v3_4, main_call_parser_entry) - 20usize];
    ["Offset of field: atom_firmware_info_v3_4::bios_scratch_reg_startaddr"]
        [::core::mem::offset_of!(atom_firmware_info_v3_4, bios_scratch_reg_startaddr) - 24usize];
    ["Offset of field: atom_firmware_info_v3_4::bootup_vddc_mv"]
        [::core::mem::offset_of!(atom_firmware_info_v3_4, bootup_vddc_mv) - 28usize];
    ["Offset of field: atom_firmware_info_v3_4::bootup_vddci_mv"]
        [::core::mem::offset_of!(atom_firmware_info_v3_4, bootup_vddci_mv) - 30usize];
    ["Offset of field: atom_firmware_info_v3_4::bootup_mvddc_mv"]
        [::core::mem::offset_of!(atom_firmware_info_v3_4, bootup_mvddc_mv) - 32usize];
    ["Offset of field: atom_firmware_info_v3_4::bootup_vddgfx_mv"]
        [::core::mem::offset_of!(atom_firmware_info_v3_4, bootup_vddgfx_mv) - 34usize];
    ["Offset of field: atom_firmware_info_v3_4::mem_module_id"]
        [::core::mem::offset_of!(atom_firmware_info_v3_4, mem_module_id) - 36usize];
    ["Offset of field: atom_firmware_info_v3_4::coolingsolution_id"]
        [::core::mem::offset_of!(atom_firmware_info_v3_4, coolingsolution_id) - 37usize];
    ["Offset of field: atom_firmware_info_v3_4::reserved1"]
        [::core::mem::offset_of!(atom_firmware_info_v3_4, reserved1) - 38usize];
    ["Offset of field: atom_firmware_info_v3_4::mc_baseaddr_high"]
        [::core::mem::offset_of!(atom_firmware_info_v3_4, mc_baseaddr_high) - 40usize];
    ["Offset of field: atom_firmware_info_v3_4::mc_baseaddr_low"]
        [::core::mem::offset_of!(atom_firmware_info_v3_4, mc_baseaddr_low) - 44usize];
    ["Offset of field: atom_firmware_info_v3_4::board_i2c_feature_id"]
        [::core::mem::offset_of!(atom_firmware_info_v3_4, board_i2c_feature_id) - 48usize];
    ["Offset of field: atom_firmware_info_v3_4::board_i2c_feature_gpio_id"]
        [::core::mem::offset_of!(atom_firmware_info_v3_4, board_i2c_feature_gpio_id) - 49usize];
    ["Offset of field: atom_firmware_info_v3_4::board_i2c_feature_slave_addr"]
        [::core::mem::offset_of!(atom_firmware_info_v3_4, board_i2c_feature_slave_addr) - 50usize];
    ["Offset of field: atom_firmware_info_v3_4::ras_rom_i2c_slave_addr"]
        [::core::mem::offset_of!(atom_firmware_info_v3_4, ras_rom_i2c_slave_addr) - 51usize];
    ["Offset of field: atom_firmware_info_v3_4::bootup_mvddq_mv"]
        [::core::mem::offset_of!(atom_firmware_info_v3_4, bootup_mvddq_mv) - 52usize];
    ["Offset of field: atom_firmware_info_v3_4::bootup_mvpp_mv"]
        [::core::mem::offset_of!(atom_firmware_info_v3_4, bootup_mvpp_mv) - 54usize];
    ["Offset of field: atom_firmware_info_v3_4::zfbstartaddrin16mb"]
        [::core::mem::offset_of!(atom_firmware_info_v3_4, zfbstartaddrin16mb) - 56usize];
    ["Offset of field: atom_firmware_info_v3_4::pplib_pptable_id"]
        [::core::mem::offset_of!(atom_firmware_info_v3_4, pplib_pptable_id) - 60usize];
    ["Offset of field: atom_firmware_info_v3_4::mvdd_ratio"]
        [::core::mem::offset_of!(atom_firmware_info_v3_4, mvdd_ratio) - 64usize];
    ["Offset of field: atom_firmware_info_v3_4::hw_bootup_vddgfx_mv"]
        [::core::mem::offset_of!(atom_firmware_info_v3_4, hw_bootup_vddgfx_mv) - 68usize];
    ["Offset of field: atom_firmware_info_v3_4::hw_bootup_vddc_mv"]
        [::core::mem::offset_of!(atom_firmware_info_v3_4, hw_bootup_vddc_mv) - 70usize];
    ["Offset of field: atom_firmware_info_v3_4::hw_bootup_mvddc_mv"]
        [::core::mem::offset_of!(atom_firmware_info_v3_4, hw_bootup_mvddc_mv) - 72usize];
    ["Offset of field: atom_firmware_info_v3_4::hw_bootup_vddci_mv"]
        [::core::mem::offset_of!(atom_firmware_info_v3_4, hw_bootup_vddci_mv) - 74usize];
    ["Offset of field: atom_firmware_info_v3_4::maco_pwrlimit_mw"]
        [::core::mem::offset_of!(atom_firmware_info_v3_4, maco_pwrlimit_mw) - 76usize];
    ["Offset of field: atom_firmware_info_v3_4::usb_pwrlimit_mw"]
        [::core::mem::offset_of!(atom_firmware_info_v3_4, usb_pwrlimit_mw) - 80usize];
    ["Offset of field: atom_firmware_info_v3_4::fw_reserved_size_in_kb"]
        [::core::mem::offset_of!(atom_firmware_info_v3_4, fw_reserved_size_in_kb) - 84usize];
    ["Offset of field: atom_firmware_info_v3_4::pspbl_init_done_reg_addr"]
        [::core::mem::offset_of!(atom_firmware_info_v3_4, pspbl_init_done_reg_addr) - 88usize];
    ["Offset of field: atom_firmware_info_v3_4::pspbl_init_done_value"]
        [::core::mem::offset_of!(atom_firmware_info_v3_4, pspbl_init_done_value) - 92usize];
    ["Offset of field: atom_firmware_info_v3_4::pspbl_init_done_check_timeout"]
        [::core::mem::offset_of!(atom_firmware_info_v3_4, pspbl_init_done_check_timeout) - 96usize];
    ["Offset of field: atom_firmware_info_v3_4::reserved"]
        [::core::mem::offset_of!(atom_firmware_info_v3_4, reserved) - 100usize];
};
#[repr(C, packed)]
#[derive(Debug, Copy, Clone)]
pub struct lcd_info_v2_1 {
    pub table_header: atom_common_table_header,
    pub lcd_timing: atom_dtd_format,
    pub backlight_pwm: u16,
    pub special_handle_cap: u16,
    pub panel_misc: u16,
    pub lvds_max_slink_pclk: u16,
    pub lvds_ss_percentage: u16,
    pub lvds_ss_rate_10hz: u16,
    pub pwr_on_digon_to_de: u8,
    pub pwr_on_de_to_vary_bl: u8,
    pub pwr_down_vary_bloff_to_de: u8,
    pub pwr_down_de_to_digoff: u8,
    pub pwr_off_delay: u8,
    pub pwr_on_vary_bl_to_blon: u8,
    pub pwr_down_bloff_to_vary_bloff: u8,
    pub panel_bpc: u8,
    pub dpcd_edp_config_cap: u8,
    pub dpcd_max_link_rate: u8,
    pub dpcd_max_lane_count: u8,
    pub dpcd_max_downspread: u8,
    pub min_allowed_bl_level: u8,
    pub max_allowed_bl_level: u8,
    pub bootup_bl_level: u8,
    pub dplvdsrxid: u8,
    pub reserved1: [u32; 8usize],
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of lcd_info_v2_1"][::core::mem::size_of::<lcd_info_v2_1>() - 92usize];
    ["Alignment of lcd_info_v2_1"][::core::mem::align_of::<lcd_info_v2_1>() - 1usize];
    ["Offset of field: lcd_info_v2_1::table_header"]
        [::core::mem::offset_of!(lcd_info_v2_1, table_header) - 0usize];
    ["Offset of field: lcd_info_v2_1::lcd_timing"]
        [::core::mem::offset_of!(lcd_info_v2_1, lcd_timing) - 4usize];
    ["Offset of field: lcd_info_v2_1::backlight_pwm"]
        [::core::mem::offset_of!(lcd_info_v2_1, backlight_pwm) - 32usize];
    ["Offset of field: lcd_info_v2_1::special_handle_cap"]
        [::core::mem::offset_of!(lcd_info_v2_1, special_handle_cap) - 34usize];
    ["Offset of field: lcd_info_v2_1::panel_misc"]
        [::core::mem::offset_of!(lcd_info_v2_1, panel_misc) - 36usize];
    ["Offset of field: lcd_info_v2_1::lvds_max_slink_pclk"]
        [::core::mem::offset_of!(lcd_info_v2_1, lvds_max_slink_pclk) - 38usize];
    ["Offset of field: lcd_info_v2_1::lvds_ss_percentage"]
        [::core::mem::offset_of!(lcd_info_v2_1, lvds_ss_percentage) - 40usize];
    ["Offset of field: lcd_info_v2_1::lvds_ss_rate_10hz"]
        [::core::mem::offset_of!(lcd_info_v2_1, lvds_ss_rate_10hz) - 42usize];
    ["Offset of field: lcd_info_v2_1::pwr_on_digon_to_de"]
        [::core::mem::offset_of!(lcd_info_v2_1, pwr_on_digon_to_de) - 44usize];
    ["Offset of field: lcd_info_v2_1::pwr_on_de_to_vary_bl"]
        [::core::mem::offset_of!(lcd_info_v2_1, pwr_on_de_to_vary_bl) - 45usize];
    ["Offset of field: lcd_info_v2_1::pwr_down_vary_bloff_to_de"]
        [::core::mem::offset_of!(lcd_info_v2_1, pwr_down_vary_bloff_to_de) - 46usize];
    ["Offset of field: lcd_info_v2_1::pwr_down_de_to_digoff"]
        [::core::mem::offset_of!(lcd_info_v2_1, pwr_down_de_to_digoff) - 47usize];
    ["Offset of field: lcd_info_v2_1::pwr_off_delay"]
        [::core::mem::offset_of!(lcd_info_v2_1, pwr_off_delay) - 48usize];
    ["Offset of field: lcd_info_v2_1::pwr_on_vary_bl_to_blon"]
        [::core::mem::offset_of!(lcd_info_v2_1, pwr_on_vary_bl_to_blon) - 49usize];
    ["Offset of field: lcd_info_v2_1::pwr_down_bloff_to_vary_bloff"]
        [::core::mem::offset_of!(lcd_info_v2_1, pwr_down_bloff_to_vary_bloff) - 50usize];
    ["Offset of field: lcd_info_v2_1::panel_bpc"]
        [::core::mem::offset_of!(lcd_info_v2_1, panel_bpc) - 51usize];
    ["Offset of field: lcd_info_v2_1::dpcd_edp_config_cap"]
        [::core::mem::offset_of!(lcd_info_v2_1, dpcd_edp_config_cap) - 52usize];
    ["Offset of field: lcd_info_v2_1::dpcd_max_link_rate"]
        [::core::mem::offset_of!(lcd_info_v2_1, dpcd_max_link_rate) - 53usize];
    ["Offset of field: lcd_info_v2_1::dpcd_max_lane_count"]
        [::core::mem::offset_of!(lcd_info_v2_1, dpcd_max_lane_count) - 54usize];
    ["Offset of field: lcd_info_v2_1::dpcd_max_downspread"]
        [::core::mem::offset_of!(lcd_info_v2_1, dpcd_max_downspread) - 55usize];
    ["Offset of field: lcd_info_v2_1::min_allowed_bl_level"]
        [::core::mem::offset_of!(lcd_info_v2_1, min_allowed_bl_level) - 56usize];
    ["Offset of field: lcd_info_v2_1::max_allowed_bl_level"]
        [::core::mem::offset_of!(lcd_info_v2_1, max_allowed_bl_level) - 57usize];
    ["Offset of field: lcd_info_v2_1::bootup_bl_level"]
        [::core::mem::offset_of!(lcd_info_v2_1, bootup_bl_level) - 58usize];
    ["Offset of field: lcd_info_v2_1::dplvdsrxid"]
        [::core::mem::offset_of!(lcd_info_v2_1, dplvdsrxid) - 59usize];
    ["Offset of field: lcd_info_v2_1::reserved1"]
        [::core::mem::offset_of!(lcd_info_v2_1, reserved1) - 60usize];
};
pub const atom_lcd_info_panel_misc_ATOM_PANEL_MISC_FPDI: atom_lcd_info_panel_misc = 2;
pub type atom_lcd_info_panel_misc = ::core::ffi::c_uint;
pub const atom_lcd_info_dptolvds_rx_id_eDP_TO_LVDS_RX_DISABLE: atom_lcd_info_dptolvds_rx_id = 0;
pub const atom_lcd_info_dptolvds_rx_id_eDP_TO_LVDS_COMMON_ID: atom_lcd_info_dptolvds_rx_id = 1;
pub const atom_lcd_info_dptolvds_rx_id_eDP_TO_LVDS_REALTEK_ID: atom_lcd_info_dptolvds_rx_id = 2;
pub type atom_lcd_info_dptolvds_rx_id = ::core::ffi::c_uint;
#[repr(C, packed)]
#[derive(Debug, Copy, Clone)]
pub struct atom_gpio_pin_assignment {
    pub data_a_reg_index: u32,
    pub gpio_bitshift: u8,
    pub gpio_mask_bitshift: u8,
    pub gpio_id: u8,
    pub reserved: u8,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of atom_gpio_pin_assignment"]
        [::core::mem::size_of::<atom_gpio_pin_assignment>() - 8usize];
    ["Alignment of atom_gpio_pin_assignment"]
        [::core::mem::align_of::<atom_gpio_pin_assignment>() - 1usize];
    ["Offset of field: atom_gpio_pin_assignment::data_a_reg_index"]
        [::core::mem::offset_of!(atom_gpio_pin_assignment, data_a_reg_index) - 0usize];
    ["Offset of field: atom_gpio_pin_assignment::gpio_bitshift"]
        [::core::mem::offset_of!(atom_gpio_pin_assignment, gpio_bitshift) - 4usize];
    ["Offset of field: atom_gpio_pin_assignment::gpio_mask_bitshift"]
        [::core::mem::offset_of!(atom_gpio_pin_assignment, gpio_mask_bitshift) - 5usize];
    ["Offset of field: atom_gpio_pin_assignment::gpio_id"]
        [::core::mem::offset_of!(atom_gpio_pin_assignment, gpio_id) - 6usize];
    ["Offset of field: atom_gpio_pin_assignment::reserved"]
        [::core::mem::offset_of!(atom_gpio_pin_assignment, reserved) - 7usize];
};
pub const atom_gpio_pin_assignment_gpio_id_I2C_HW_LANE_MUX: atom_gpio_pin_assignment_gpio_id = 15;
pub const atom_gpio_pin_assignment_gpio_id_I2C_HW_ENGINE_ID_MASK: atom_gpio_pin_assignment_gpio_id =
    112;
pub const atom_gpio_pin_assignment_gpio_id_I2C_HW_CAP: atom_gpio_pin_assignment_gpio_id = 128;
pub const atom_gpio_pin_assignment_gpio_id_PCIE_VDDC_CONTROL_GPIO_PINID:
    atom_gpio_pin_assignment_gpio_id = 56;
pub const atom_gpio_pin_assignment_gpio_id_PP_AC_DC_SWITCH_GPIO_PINID:
    atom_gpio_pin_assignment_gpio_id = 60;
pub const atom_gpio_pin_assignment_gpio_id_VDDC_VRHOT_GPIO_PINID: atom_gpio_pin_assignment_gpio_id =
    61;
pub const atom_gpio_pin_assignment_gpio_id_VDDC_PCC_GPIO_PINID: atom_gpio_pin_assignment_gpio_id =
    62;
pub const atom_gpio_pin_assignment_gpio_id_EFUSE_CUT_ENABLE_GPIO_PINID:
    atom_gpio_pin_assignment_gpio_id = 63;
pub const atom_gpio_pin_assignment_gpio_id_DRAM_SELF_REFRESH_GPIO_PINID:
    atom_gpio_pin_assignment_gpio_id = 64;
pub const atom_gpio_pin_assignment_gpio_id_THERMAL_INT_OUTPUT_GPIO_PINID:
    atom_gpio_pin_assignment_gpio_id = 65;
pub type atom_gpio_pin_assignment_gpio_id = ::core::ffi::c_uint;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct atom_gpio_pin_lut_v2_1 {
    pub table_header: atom_common_table_header,
    pub gpio_pin: [atom_gpio_pin_assignment; 8usize],
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of atom_gpio_pin_lut_v2_1"][::core::mem::size_of::<atom_gpio_pin_lut_v2_1>() - 68usize];
    ["Alignment of atom_gpio_pin_lut_v2_1"]
        [::core::mem::align_of::<atom_gpio_pin_lut_v2_1>() - 1usize];
    ["Offset of field: atom_gpio_pin_lut_v2_1::table_header"]
        [::core::mem::offset_of!(atom_gpio_pin_lut_v2_1, table_header) - 0usize];
    ["Offset of field: atom_gpio_pin_lut_v2_1::gpio_pin"]
        [::core::mem::offset_of!(atom_gpio_pin_lut_v2_1, gpio_pin) - 4usize];
};
#[repr(C, packed)]
#[derive(Debug, Copy, Clone)]
pub struct vram_usagebyfirmware_v2_1 {
    pub table_header: atom_common_table_header,
    pub start_address_in_kb: u32,
    pub used_by_firmware_in_kb: u16,
    pub used_by_driver_in_kb: u16,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of vram_usagebyfirmware_v2_1"]
        [::core::mem::size_of::<vram_usagebyfirmware_v2_1>() - 12usize];
    ["Alignment of vram_usagebyfirmware_v2_1"]
        [::core::mem::align_of::<vram_usagebyfirmware_v2_1>() - 1usize];
    ["Offset of field: vram_usagebyfirmware_v2_1::table_header"]
        [::core::mem::offset_of!(vram_usagebyfirmware_v2_1, table_header) - 0usize];
    ["Offset of field: vram_usagebyfirmware_v2_1::start_address_in_kb"]
        [::core::mem::offset_of!(vram_usagebyfirmware_v2_1, start_address_in_kb) - 4usize];
    ["Offset of field: vram_usagebyfirmware_v2_1::used_by_firmware_in_kb"]
        [::core::mem::offset_of!(vram_usagebyfirmware_v2_1, used_by_firmware_in_kb) - 8usize];
    ["Offset of field: vram_usagebyfirmware_v2_1::used_by_driver_in_kb"]
        [::core::mem::offset_of!(vram_usagebyfirmware_v2_1, used_by_driver_in_kb) - 10usize];
};
#[repr(C, packed)]
#[derive(Debug, Copy, Clone)]
pub struct vram_usagebyfirmware_v2_2 {
    pub table_header: atom_common_table_header,
    pub fw_region_start_address_in_kb: u32,
    pub used_by_firmware_in_kb: u16,
    pub reserved: u16,
    pub driver_region0_start_address_in_kb: u32,
    pub used_by_driver_region0_in_kb: u32,
    pub reserved32: [u32; 7usize],
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of vram_usagebyfirmware_v2_2"]
        [::core::mem::size_of::<vram_usagebyfirmware_v2_2>() - 48usize];
    ["Alignment of vram_usagebyfirmware_v2_2"]
        [::core::mem::align_of::<vram_usagebyfirmware_v2_2>() - 1usize];
    ["Offset of field: vram_usagebyfirmware_v2_2::table_header"]
        [::core::mem::offset_of!(vram_usagebyfirmware_v2_2, table_header) - 0usize];
    ["Offset of field: vram_usagebyfirmware_v2_2::fw_region_start_address_in_kb"][::core::mem::offset_of!(
        vram_usagebyfirmware_v2_2,
        fw_region_start_address_in_kb
    ) - 4usize];
    ["Offset of field: vram_usagebyfirmware_v2_2::used_by_firmware_in_kb"]
        [::core::mem::offset_of!(vram_usagebyfirmware_v2_2, used_by_firmware_in_kb) - 8usize];
    ["Offset of field: vram_usagebyfirmware_v2_2::reserved"]
        [::core::mem::offset_of!(vram_usagebyfirmware_v2_2, reserved) - 10usize];
    ["Offset of field: vram_usagebyfirmware_v2_2::driver_region0_start_address_in_kb"][::core::mem::offset_of!(
        vram_usagebyfirmware_v2_2,
        driver_region0_start_address_in_kb
    ) - 12usize];
    ["Offset of field: vram_usagebyfirmware_v2_2::used_by_driver_region0_in_kb"][::core::mem::offset_of!(
        vram_usagebyfirmware_v2_2,
        used_by_driver_region0_in_kb
    ) - 16usize];
    ["Offset of field: vram_usagebyfirmware_v2_2::reserved32"]
        [::core::mem::offset_of!(vram_usagebyfirmware_v2_2, reserved32) - 20usize];
};
pub const atom_object_record_type_id_ATOM_I2C_RECORD_TYPE: atom_object_record_type_id = 1;
pub const atom_object_record_type_id_ATOM_HPD_INT_RECORD_TYPE: atom_object_record_type_id = 2;
pub const atom_object_record_type_id_ATOM_CONNECTOR_CAP_RECORD_TYPE: atom_object_record_type_id = 3;
pub const atom_object_record_type_id_ATOM_CONNECTOR_SPEED_UPTO: atom_object_record_type_id = 4;
pub const atom_object_record_type_id_ATOM_OBJECT_GPIO_CNTL_RECORD_TYPE: atom_object_record_type_id =
    9;
pub const atom_object_record_type_id_ATOM_CONNECTOR_HPDPIN_LUT_RECORD_TYPE:
    atom_object_record_type_id = 16;
pub const atom_object_record_type_id_ATOM_CONNECTOR_AUXDDC_LUT_RECORD_TYPE:
    atom_object_record_type_id = 17;
pub const atom_object_record_type_id_ATOM_ENCODER_CAP_RECORD_TYPE: atom_object_record_type_id = 20;
pub const atom_object_record_type_id_ATOM_BRACKET_LAYOUT_RECORD_TYPE: atom_object_record_type_id =
    21;
pub const atom_object_record_type_id_ATOM_CONNECTOR_FORCED_TMDS_CAP_RECORD_TYPE:
    atom_object_record_type_id = 22;
pub const atom_object_record_type_id_ATOM_DISP_CONNECTOR_CAPS_RECORD_TYPE:
    atom_object_record_type_id = 23;
pub const atom_object_record_type_id_ATOM_BRACKET_LAYOUT_V2_RECORD_TYPE:
    atom_object_record_type_id = 25;
pub const atom_object_record_type_id_ATOM_RECORD_END_TYPE: atom_object_record_type_id = 255;
pub type atom_object_record_type_id = ::core::ffi::c_uint;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct atom_common_record_header {
    pub record_type: u8,
    pub record_size: u8,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of atom_common_record_header"]
        [::core::mem::size_of::<atom_common_record_header>() - 2usize];
    ["Alignment of atom_common_record_header"]
        [::core::mem::align_of::<atom_common_record_header>() - 1usize];
    ["Offset of field: atom_common_record_header::record_type"]
        [::core::mem::offset_of!(atom_common_record_header, record_type) - 0usize];
    ["Offset of field: atom_common_record_header::record_size"]
        [::core::mem::offset_of!(atom_common_record_header, record_size) - 1usize];
};
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct atom_i2c_record {
    pub record_header: atom_common_record_header,
    pub i2c_id: u8,
    pub i2c_slave_addr: u8,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of atom_i2c_record"][::core::mem::size_of::<atom_i2c_record>() - 4usize];
    ["Alignment of atom_i2c_record"][::core::mem::align_of::<atom_i2c_record>() - 1usize];
    ["Offset of field: atom_i2c_record::record_header"]
        [::core::mem::offset_of!(atom_i2c_record, record_header) - 0usize];
    ["Offset of field: atom_i2c_record::i2c_id"]
        [::core::mem::offset_of!(atom_i2c_record, i2c_id) - 2usize];
    ["Offset of field: atom_i2c_record::i2c_slave_addr"]
        [::core::mem::offset_of!(atom_i2c_record, i2c_slave_addr) - 3usize];
};
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct atom_hpd_int_record {
    pub record_header: atom_common_record_header,
    pub pin_id: u8,
    pub plugin_pin_state: u8,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of atom_hpd_int_record"][::core::mem::size_of::<atom_hpd_int_record>() - 4usize];
    ["Alignment of atom_hpd_int_record"][::core::mem::align_of::<atom_hpd_int_record>() - 1usize];
    ["Offset of field: atom_hpd_int_record::record_header"]
        [::core::mem::offset_of!(atom_hpd_int_record, record_header) - 0usize];
    ["Offset of field: atom_hpd_int_record::pin_id"]
        [::core::mem::offset_of!(atom_hpd_int_record, pin_id) - 2usize];
    ["Offset of field: atom_hpd_int_record::plugin_pin_state"]
        [::core::mem::offset_of!(atom_hpd_int_record, plugin_pin_state) - 3usize];
};
#[repr(C, packed)]
#[derive(Debug, Copy, Clone)]
pub struct atom_connector_caps_record {
    pub record_header: atom_common_record_header,
    pub connector_caps: u16,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of atom_connector_caps_record"]
        [::core::mem::size_of::<atom_connector_caps_record>() - 4usize];
    ["Alignment of atom_connector_caps_record"]
        [::core::mem::align_of::<atom_connector_caps_record>() - 1usize];
    ["Offset of field: atom_connector_caps_record::record_header"]
        [::core::mem::offset_of!(atom_connector_caps_record, record_header) - 0usize];
    ["Offset of field: atom_connector_caps_record::connector_caps"]
        [::core::mem::offset_of!(atom_connector_caps_record, connector_caps) - 2usize];
};
#[repr(C, packed)]
#[derive(Debug, Copy, Clone)]
pub struct atom_connector_speed_record {
    pub record_header: atom_common_record_header,
    pub connector_max_speed: u32,
    pub reserved: u16,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of atom_connector_speed_record"]
        [::core::mem::size_of::<atom_connector_speed_record>() - 8usize];
    ["Alignment of atom_connector_speed_record"]
        [::core::mem::align_of::<atom_connector_speed_record>() - 1usize];
    ["Offset of field: atom_connector_speed_record::record_header"]
        [::core::mem::offset_of!(atom_connector_speed_record, record_header) - 0usize];
    ["Offset of field: atom_connector_speed_record::connector_max_speed"]
        [::core::mem::offset_of!(atom_connector_speed_record, connector_max_speed) - 2usize];
    ["Offset of field: atom_connector_speed_record::reserved"]
        [::core::mem::offset_of!(atom_connector_speed_record, reserved) - 6usize];
};
pub const atom_encoder_caps_def_ATOM_ENCODER_CAP_RECORD_HBR2: atom_encoder_caps_def = 1;
pub const atom_encoder_caps_def_ATOM_ENCODER_CAP_RECORD_MST_EN: atom_encoder_caps_def = 1;
pub const atom_encoder_caps_def_ATOM_ENCODER_CAP_RECORD_HBR2_EN: atom_encoder_caps_def = 2;
pub const atom_encoder_caps_def_ATOM_ENCODER_CAP_RECORD_HDMI6Gbps_EN: atom_encoder_caps_def = 4;
pub const atom_encoder_caps_def_ATOM_ENCODER_CAP_RECORD_HBR3_EN: atom_encoder_caps_def = 8;
pub const atom_encoder_caps_def_ATOM_ENCODER_CAP_RECORD_DP2: atom_encoder_caps_def = 16;
pub const atom_encoder_caps_def_ATOM_ENCODER_CAP_RECORD_UHBR10_EN: atom_encoder_caps_def = 32;
pub const atom_encoder_caps_def_ATOM_ENCODER_CAP_RECORD_UHBR13_5_EN: atom_encoder_caps_def = 64;
pub const atom_encoder_caps_def_ATOM_ENCODER_CAP_RECORD_UHBR20_EN: atom_encoder_caps_def = 128;
pub const atom_encoder_caps_def_ATOM_ENCODER_CAP_RECORD_USB_C_TYPE: atom_encoder_caps_def = 256;
pub type atom_encoder_caps_def = ::core::ffi::c_uint;
#[repr(C, packed)]
#[derive(Debug, Copy, Clone)]
pub struct atom_encoder_caps_record {
    pub record_header: atom_common_record_header,
    pub encodercaps: u32,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of atom_encoder_caps_record"]
        [::core::mem::size_of::<atom_encoder_caps_record>() - 6usize];
    ["Alignment of atom_encoder_caps_record"]
        [::core::mem::align_of::<atom_encoder_caps_record>() - 1usize];
    ["Offset of field: atom_encoder_caps_record::record_header"]
        [::core::mem::offset_of!(atom_encoder_caps_record, record_header) - 0usize];
    ["Offset of field: atom_encoder_caps_record::encodercaps"]
        [::core::mem::offset_of!(atom_encoder_caps_record, encodercaps) - 2usize];
};
pub const atom_connector_caps_def_ATOM_CONNECTOR_CAP_INTERNAL_DISPLAY: atom_connector_caps_def = 1;
pub const atom_connector_caps_def_ATOM_CONNECTOR_CAP_INTERNAL_DISPLAY_BL: atom_connector_caps_def =
    2;
pub type atom_connector_caps_def = ::core::ffi::c_uint;
#[repr(C, packed)]
#[derive(Debug, Copy, Clone)]
pub struct atom_disp_connector_caps_record {
    pub record_header: atom_common_record_header,
    pub connectcaps: u32,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of atom_disp_connector_caps_record"]
        [::core::mem::size_of::<atom_disp_connector_caps_record>() - 6usize];
    ["Alignment of atom_disp_connector_caps_record"]
        [::core::mem::align_of::<atom_disp_connector_caps_record>() - 1usize];
    ["Offset of field: atom_disp_connector_caps_record::record_header"]
        [::core::mem::offset_of!(atom_disp_connector_caps_record, record_header) - 0usize];
    ["Offset of field: atom_disp_connector_caps_record::connectcaps"]
        [::core::mem::offset_of!(atom_disp_connector_caps_record, connectcaps) - 2usize];
};
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct atom_gpio_pin_control_pair {
    pub gpio_id: u8,
    pub gpio_pinstate: u8,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of atom_gpio_pin_control_pair"]
        [::core::mem::size_of::<atom_gpio_pin_control_pair>() - 2usize];
    ["Alignment of atom_gpio_pin_control_pair"]
        [::core::mem::align_of::<atom_gpio_pin_control_pair>() - 1usize];
    ["Offset of field: atom_gpio_pin_control_pair::gpio_id"]
        [::core::mem::offset_of!(atom_gpio_pin_control_pair, gpio_id) - 0usize];
    ["Offset of field: atom_gpio_pin_control_pair::gpio_pinstate"]
        [::core::mem::offset_of!(atom_gpio_pin_control_pair, gpio_pinstate) - 1usize];
};
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct atom_object_gpio_cntl_record {
    pub record_header: atom_common_record_header,
    pub flag: u8,
    pub number_of_pins: u8,
    pub gpio: [atom_gpio_pin_control_pair; 1usize],
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of atom_object_gpio_cntl_record"]
        [::core::mem::size_of::<atom_object_gpio_cntl_record>() - 6usize];
    ["Alignment of atom_object_gpio_cntl_record"]
        [::core::mem::align_of::<atom_object_gpio_cntl_record>() - 1usize];
    ["Offset of field: atom_object_gpio_cntl_record::record_header"]
        [::core::mem::offset_of!(atom_object_gpio_cntl_record, record_header) - 0usize];
    ["Offset of field: atom_object_gpio_cntl_record::flag"]
        [::core::mem::offset_of!(atom_object_gpio_cntl_record, flag) - 2usize];
    ["Offset of field: atom_object_gpio_cntl_record::number_of_pins"]
        [::core::mem::offset_of!(atom_object_gpio_cntl_record, number_of_pins) - 3usize];
    ["Offset of field: atom_object_gpio_cntl_record::gpio"]
        [::core::mem::offset_of!(atom_object_gpio_cntl_record, gpio) - 4usize];
};
pub const atom_gpio_pin_control_pinstate_def_GPIO_PIN_TYPE_INPUT:
    atom_gpio_pin_control_pinstate_def = 0;
pub const atom_gpio_pin_control_pinstate_def_GPIO_PIN_TYPE_OUTPUT:
    atom_gpio_pin_control_pinstate_def = 16;
pub const atom_gpio_pin_control_pinstate_def_GPIO_PIN_TYPE_HW_CONTROL:
    atom_gpio_pin_control_pinstate_def = 32;
pub const atom_gpio_pin_control_pinstate_def_GPIO_PIN_OUTPUT_STATE_MASK:
    atom_gpio_pin_control_pinstate_def = 1;
pub const atom_gpio_pin_control_pinstate_def_GPIO_PIN_OUTPUT_STATE_SHIFT:
    atom_gpio_pin_control_pinstate_def = 0;
pub const atom_gpio_pin_control_pinstate_def_GPIO_PIN_STATE_ACTIVE_LOW:
    atom_gpio_pin_control_pinstate_def = 0;
pub const atom_gpio_pin_control_pinstate_def_GPIO_PIN_STATE_ACTIVE_HIGH:
    atom_gpio_pin_control_pinstate_def = 1;
pub type atom_gpio_pin_control_pinstate_def = ::core::ffi::c_uint;
pub const atom_glsync_record_gpio_index_def_ATOM_GPIO_INDEX_GLSYNC_REFCLK:
    atom_glsync_record_gpio_index_def = 0;
pub const atom_glsync_record_gpio_index_def_ATOM_GPIO_INDEX_GLSYNC_HSYNC:
    atom_glsync_record_gpio_index_def = 1;
pub const atom_glsync_record_gpio_index_def_ATOM_GPIO_INDEX_GLSYNC_VSYNC:
    atom_glsync_record_gpio_index_def = 2;
pub const atom_glsync_record_gpio_index_def_ATOM_GPIO_INDEX_GLSYNC_SWAP_REQ:
    atom_glsync_record_gpio_index_def = 3;
pub const atom_glsync_record_gpio_index_def_ATOM_GPIO_INDEX_GLSYNC_SWAP_GNT:
    atom_glsync_record_gpio_index_def = 4;
pub const atom_glsync_record_gpio_index_def_ATOM_GPIO_INDEX_GLSYNC_INTERRUPT:
    atom_glsync_record_gpio_index_def = 5;
pub const atom_glsync_record_gpio_index_def_ATOM_GPIO_INDEX_GLSYNC_V_RESET:
    atom_glsync_record_gpio_index_def = 6;
pub const atom_glsync_record_gpio_index_def_ATOM_GPIO_INDEX_GLSYNC_SWAP_CNTL:
    atom_glsync_record_gpio_index_def = 7;
pub const atom_glsync_record_gpio_index_def_ATOM_GPIO_INDEX_GLSYNC_SWAP_SEL:
    atom_glsync_record_gpio_index_def = 8;
pub const atom_glsync_record_gpio_index_def_ATOM_GPIO_INDEX_GLSYNC_MAX:
    atom_glsync_record_gpio_index_def = 9;
pub type atom_glsync_record_gpio_index_def = ::core::ffi::c_uint;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct atom_connector_hpdpin_lut_record {
    pub record_header: atom_common_record_header,
    pub hpd_pin_map: [u8; 8usize],
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of atom_connector_hpdpin_lut_record"]
        [::core::mem::size_of::<atom_connector_hpdpin_lut_record>() - 10usize];
    ["Alignment of atom_connector_hpdpin_lut_record"]
        [::core::mem::align_of::<atom_connector_hpdpin_lut_record>() - 1usize];
    ["Offset of field: atom_connector_hpdpin_lut_record::record_header"]
        [::core::mem::offset_of!(atom_connector_hpdpin_lut_record, record_header) - 0usize];
    ["Offset of field: atom_connector_hpdpin_lut_record::hpd_pin_map"]
        [::core::mem::offset_of!(atom_connector_hpdpin_lut_record, hpd_pin_map) - 2usize];
};
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct atom_connector_auxddc_lut_record {
    pub record_header: atom_common_record_header,
    pub aux_ddc_map: [u8; 8usize],
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of atom_connector_auxddc_lut_record"]
        [::core::mem::size_of::<atom_connector_auxddc_lut_record>() - 10usize];
    ["Alignment of atom_connector_auxddc_lut_record"]
        [::core::mem::align_of::<atom_connector_auxddc_lut_record>() - 1usize];
    ["Offset of field: atom_connector_auxddc_lut_record::record_header"]
        [::core::mem::offset_of!(atom_connector_auxddc_lut_record, record_header) - 0usize];
    ["Offset of field: atom_connector_auxddc_lut_record::aux_ddc_map"]
        [::core::mem::offset_of!(atom_connector_auxddc_lut_record, aux_ddc_map) - 2usize];
};
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct atom_connector_forced_tmds_cap_record {
    pub record_header: atom_common_record_header,
    pub maxtmdsclkrate_in2_5mhz: u8,
    pub reserved: u8,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of atom_connector_forced_tmds_cap_record"]
        [::core::mem::size_of::<atom_connector_forced_tmds_cap_record>() - 4usize];
    ["Alignment of atom_connector_forced_tmds_cap_record"]
        [::core::mem::align_of::<atom_connector_forced_tmds_cap_record>() - 1usize];
    ["Offset of field: atom_connector_forced_tmds_cap_record::record_header"]
        [::core::mem::offset_of!(atom_connector_forced_tmds_cap_record, record_header) - 0usize];
    ["Offset of field: atom_connector_forced_tmds_cap_record::maxtmdsclkrate_in2_5mhz"][::core::mem::offset_of!(
        atom_connector_forced_tmds_cap_record,
        maxtmdsclkrate_in2_5mhz
    ) - 2usize];
    ["Offset of field: atom_connector_forced_tmds_cap_record::reserved"]
        [::core::mem::offset_of!(atom_connector_forced_tmds_cap_record, reserved) - 3usize];
};
#[repr(C, packed)]
#[derive(Debug, Copy, Clone)]
pub struct atom_connector_layout_info {
    pub connectorobjid: u16,
    pub connector_type: u8,
    pub position: u8,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of atom_connector_layout_info"]
        [::core::mem::size_of::<atom_connector_layout_info>() - 4usize];
    ["Alignment of atom_connector_layout_info"]
        [::core::mem::align_of::<atom_connector_layout_info>() - 1usize];
    ["Offset of field: atom_connector_layout_info::connectorobjid"]
        [::core::mem::offset_of!(atom_connector_layout_info, connectorobjid) - 0usize];
    ["Offset of field: atom_connector_layout_info::connector_type"]
        [::core::mem::offset_of!(atom_connector_layout_info, connector_type) - 2usize];
    ["Offset of field: atom_connector_layout_info::position"]
        [::core::mem::offset_of!(atom_connector_layout_info, position) - 3usize];
};
pub const atom_connector_layout_info_connector_type_def_CONNECTOR_TYPE_DVI_D:
    atom_connector_layout_info_connector_type_def = 1;
pub const atom_connector_layout_info_connector_type_def_CONNECTOR_TYPE_HDMI:
    atom_connector_layout_info_connector_type_def = 4;
pub const atom_connector_layout_info_connector_type_def_CONNECTOR_TYPE_DISPLAY_PORT:
    atom_connector_layout_info_connector_type_def = 5;
pub const atom_connector_layout_info_connector_type_def_CONNECTOR_TYPE_MINI_DISPLAY_PORT:
    atom_connector_layout_info_connector_type_def = 6;
pub type atom_connector_layout_info_connector_type_def = ::core::ffi::c_uint;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct atom_bracket_layout_record {
    pub record_header: atom_common_record_header,
    pub bracketlen: u8,
    pub bracketwidth: u8,
    pub conn_num: u8,
    pub reserved: u8,
    pub conn_info: [atom_connector_layout_info; 1usize],
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of atom_bracket_layout_record"]
        [::core::mem::size_of::<atom_bracket_layout_record>() - 10usize];
    ["Alignment of atom_bracket_layout_record"]
        [::core::mem::align_of::<atom_bracket_layout_record>() - 1usize];
    ["Offset of field: atom_bracket_layout_record::record_header"]
        [::core::mem::offset_of!(atom_bracket_layout_record, record_header) - 0usize];
    ["Offset of field: atom_bracket_layout_record::bracketlen"]
        [::core::mem::offset_of!(atom_bracket_layout_record, bracketlen) - 2usize];
    ["Offset of field: atom_bracket_layout_record::bracketwidth"]
        [::core::mem::offset_of!(atom_bracket_layout_record, bracketwidth) - 3usize];
    ["Offset of field: atom_bracket_layout_record::conn_num"]
        [::core::mem::offset_of!(atom_bracket_layout_record, conn_num) - 4usize];
    ["Offset of field: atom_bracket_layout_record::reserved"]
        [::core::mem::offset_of!(atom_bracket_layout_record, reserved) - 5usize];
    ["Offset of field: atom_bracket_layout_record::conn_info"]
        [::core::mem::offset_of!(atom_bracket_layout_record, conn_info) - 6usize];
};
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct atom_bracket_layout_record_v2 {
    pub record_header: atom_common_record_header,
    pub bracketlen: u8,
    pub bracketwidth: u8,
    pub conn_num: u8,
    pub mini_type: u8,
    pub reserved1: u8,
    pub reserved2: u8,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of atom_bracket_layout_record_v2"]
        [::core::mem::size_of::<atom_bracket_layout_record_v2>() - 8usize];
    ["Alignment of atom_bracket_layout_record_v2"]
        [::core::mem::align_of::<atom_bracket_layout_record_v2>() - 1usize];
    ["Offset of field: atom_bracket_layout_record_v2::record_header"]
        [::core::mem::offset_of!(atom_bracket_layout_record_v2, record_header) - 0usize];
    ["Offset of field: atom_bracket_layout_record_v2::bracketlen"]
        [::core::mem::offset_of!(atom_bracket_layout_record_v2, bracketlen) - 2usize];
    ["Offset of field: atom_bracket_layout_record_v2::bracketwidth"]
        [::core::mem::offset_of!(atom_bracket_layout_record_v2, bracketwidth) - 3usize];
    ["Offset of field: atom_bracket_layout_record_v2::conn_num"]
        [::core::mem::offset_of!(atom_bracket_layout_record_v2, conn_num) - 4usize];
    ["Offset of field: atom_bracket_layout_record_v2::mini_type"]
        [::core::mem::offset_of!(atom_bracket_layout_record_v2, mini_type) - 5usize];
    ["Offset of field: atom_bracket_layout_record_v2::reserved1"]
        [::core::mem::offset_of!(atom_bracket_layout_record_v2, reserved1) - 6usize];
    ["Offset of field: atom_bracket_layout_record_v2::reserved2"]
        [::core::mem::offset_of!(atom_bracket_layout_record_v2, reserved2) - 7usize];
};
pub const atom_connector_layout_info_mini_type_def_MINI_TYPE_NORMAL:
    atom_connector_layout_info_mini_type_def = 0;
pub const atom_connector_layout_info_mini_type_def_MINI_TYPE_MINI:
    atom_connector_layout_info_mini_type_def = 1;
pub type atom_connector_layout_info_mini_type_def = ::core::ffi::c_uint;
pub const atom_display_device_tag_def_ATOM_DISPLAY_LCD1_SUPPORT: atom_display_device_tag_def = 2;
pub const atom_display_device_tag_def_ATOM_DISPLAY_LCD2_SUPPORT: atom_display_device_tag_def = 32;
pub const atom_display_device_tag_def_ATOM_DISPLAY_DFP1_SUPPORT: atom_display_device_tag_def = 8;
pub const atom_display_device_tag_def_ATOM_DISPLAY_DFP2_SUPPORT: atom_display_device_tag_def = 128;
pub const atom_display_device_tag_def_ATOM_DISPLAY_DFP3_SUPPORT: atom_display_device_tag_def = 512;
pub const atom_display_device_tag_def_ATOM_DISPLAY_DFP4_SUPPORT: atom_display_device_tag_def = 1024;
pub const atom_display_device_tag_def_ATOM_DISPLAY_DFP5_SUPPORT: atom_display_device_tag_def = 2048;
pub const atom_display_device_tag_def_ATOM_DISPLAY_DFP6_SUPPORT: atom_display_device_tag_def = 64;
pub const atom_display_device_tag_def_ATOM_DISPLAY_DFPx_SUPPORT: atom_display_device_tag_def = 3784;
pub type atom_display_device_tag_def = ::core::ffi::c_uint;
#[repr(C, packed)]
#[derive(Debug, Copy, Clone)]
pub struct atom_display_object_path_v2 {
    pub display_objid: u16,
    pub disp_recordoffset: u16,
    pub encoderobjid: u16,
    pub extencoderobjid: u16,
    pub encoder_recordoffset: u16,
    pub extencoder_recordoffset: u16,
    pub device_tag: u16,
    pub priority_id: u8,
    pub reserved: u8,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of atom_display_object_path_v2"]
        [::core::mem::size_of::<atom_display_object_path_v2>() - 16usize];
    ["Alignment of atom_display_object_path_v2"]
        [::core::mem::align_of::<atom_display_object_path_v2>() - 1usize];
    ["Offset of field: atom_display_object_path_v2::display_objid"]
        [::core::mem::offset_of!(atom_display_object_path_v2, display_objid) - 0usize];
    ["Offset of field: atom_display_object_path_v2::disp_recordoffset"]
        [::core::mem::offset_of!(atom_display_object_path_v2, disp_recordoffset) - 2usize];
    ["Offset of field: atom_display_object_path_v2::encoderobjid"]
        [::core::mem::offset_of!(atom_display_object_path_v2, encoderobjid) - 4usize];
    ["Offset of field: atom_display_object_path_v2::extencoderobjid"]
        [::core::mem::offset_of!(atom_display_object_path_v2, extencoderobjid) - 6usize];
    ["Offset of field: atom_display_object_path_v2::encoder_recordoffset"]
        [::core::mem::offset_of!(atom_display_object_path_v2, encoder_recordoffset) - 8usize];
    ["Offset of field: atom_display_object_path_v2::extencoder_recordoffset"]
        [::core::mem::offset_of!(atom_display_object_path_v2, extencoder_recordoffset) - 10usize];
    ["Offset of field: atom_display_object_path_v2::device_tag"]
        [::core::mem::offset_of!(atom_display_object_path_v2, device_tag) - 12usize];
    ["Offset of field: atom_display_object_path_v2::priority_id"]
        [::core::mem::offset_of!(atom_display_object_path_v2, priority_id) - 14usize];
    ["Offset of field: atom_display_object_path_v2::reserved"]
        [::core::mem::offset_of!(atom_display_object_path_v2, reserved) - 15usize];
};
#[repr(C, packed)]
#[derive(Debug, Copy, Clone)]
pub struct atom_display_object_path_v3 {
    pub display_objid: u16,
    pub disp_recordoffset: u16,
    pub encoderobjid: u16,
    pub reserved1: u16,
    pub reserved2: u16,
    pub reserved3: u16,
    pub device_tag: u16,
    pub reserved4: u16,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of atom_display_object_path_v3"]
        [::core::mem::size_of::<atom_display_object_path_v3>() - 16usize];
    ["Alignment of atom_display_object_path_v3"]
        [::core::mem::align_of::<atom_display_object_path_v3>() - 1usize];
    ["Offset of field: atom_display_object_path_v3::display_objid"]
        [::core::mem::offset_of!(atom_display_object_path_v3, display_objid) - 0usize];
    ["Offset of field: atom_display_object_path_v3::disp_recordoffset"]
        [::core::mem::offset_of!(atom_display_object_path_v3, disp_recordoffset) - 2usize];
    ["Offset of field: atom_display_object_path_v3::encoderobjid"]
        [::core::mem::offset_of!(atom_display_object_path_v3, encoderobjid) - 4usize];
    ["Offset of field: atom_display_object_path_v3::reserved1"]
        [::core::mem::offset_of!(atom_display_object_path_v3, reserved1) - 6usize];
    ["Offset of field: atom_display_object_path_v3::reserved2"]
        [::core::mem::offset_of!(atom_display_object_path_v3, reserved2) - 8usize];
    ["Offset of field: atom_display_object_path_v3::reserved3"]
        [::core::mem::offset_of!(atom_display_object_path_v3, reserved3) - 10usize];
    ["Offset of field: atom_display_object_path_v3::device_tag"]
        [::core::mem::offset_of!(atom_display_object_path_v3, device_tag) - 12usize];
    ["Offset of field: atom_display_object_path_v3::reserved4"]
        [::core::mem::offset_of!(atom_display_object_path_v3, reserved4) - 14usize];
};
#[repr(C, packed)]
#[derive(Debug, Copy, Clone)]
pub struct display_object_info_table_v1_4 {
    pub table_header: atom_common_table_header,
    pub supporteddevices: u16,
    pub number_of_path: u8,
    pub reserved: u8,
    pub display_path: [atom_display_object_path_v2; 8usize],
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of display_object_info_table_v1_4"]
        [::core::mem::size_of::<display_object_info_table_v1_4>() - 136usize];
    ["Alignment of display_object_info_table_v1_4"]
        [::core::mem::align_of::<display_object_info_table_v1_4>() - 1usize];
    ["Offset of field: display_object_info_table_v1_4::table_header"]
        [::core::mem::offset_of!(display_object_info_table_v1_4, table_header) - 0usize];
    ["Offset of field: display_object_info_table_v1_4::supporteddevices"]
        [::core::mem::offset_of!(display_object_info_table_v1_4, supporteddevices) - 4usize];
    ["Offset of field: display_object_info_table_v1_4::number_of_path"]
        [::core::mem::offset_of!(display_object_info_table_v1_4, number_of_path) - 6usize];
    ["Offset of field: display_object_info_table_v1_4::reserved"]
        [::core::mem::offset_of!(display_object_info_table_v1_4, reserved) - 7usize];
    ["Offset of field: display_object_info_table_v1_4::display_path"]
        [::core::mem::offset_of!(display_object_info_table_v1_4, display_path) - 8usize];
};
#[repr(C, packed)]
#[derive(Debug, Copy, Clone)]
pub struct display_object_info_table_v1_5 {
    pub table_header: atom_common_table_header,
    pub supporteddevices: u16,
    pub number_of_path: u8,
    pub reserved: u8,
    pub display_path: [atom_display_object_path_v3; 8usize],
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of display_object_info_table_v1_5"]
        [::core::mem::size_of::<display_object_info_table_v1_5>() - 136usize];
    ["Alignment of display_object_info_table_v1_5"]
        [::core::mem::align_of::<display_object_info_table_v1_5>() - 1usize];
    ["Offset of field: display_object_info_table_v1_5::table_header"]
        [::core::mem::offset_of!(display_object_info_table_v1_5, table_header) - 0usize];
    ["Offset of field: display_object_info_table_v1_5::supporteddevices"]
        [::core::mem::offset_of!(display_object_info_table_v1_5, supporteddevices) - 4usize];
    ["Offset of field: display_object_info_table_v1_5::number_of_path"]
        [::core::mem::offset_of!(display_object_info_table_v1_5, number_of_path) - 6usize];
    ["Offset of field: display_object_info_table_v1_5::reserved"]
        [::core::mem::offset_of!(display_object_info_table_v1_5, reserved) - 7usize];
    ["Offset of field: display_object_info_table_v1_5::display_path"]
        [::core::mem::offset_of!(display_object_info_table_v1_5, display_path) - 8usize];
};
#[repr(C, packed)]
#[derive(Debug, Copy, Clone)]
pub struct atom_display_controller_info_v4_1 {
    pub table_header: atom_common_table_header,
    pub display_caps: u32,
    pub bootup_dispclk_10khz: u32,
    pub dce_refclk_10khz: u16,
    pub i2c_engine_refclk_10khz: u16,
    pub dvi_ss_percentage: u16,
    pub dvi_ss_rate_10hz: u16,
    pub hdmi_ss_percentage: u16,
    pub hdmi_ss_rate_10hz: u16,
    pub dp_ss_percentage: u16,
    pub dp_ss_rate_10hz: u16,
    pub dvi_ss_mode: u8,
    pub hdmi_ss_mode: u8,
    pub dp_ss_mode: u8,
    pub ss_reserved: u8,
    pub hardcode_mode_num: u8,
    pub reserved1: [u8; 3usize],
    pub dpphy_refclk_10khz: u16,
    pub reserved2: u16,
    pub dceip_min_ver: u8,
    pub dceip_max_ver: u8,
    pub max_disp_pipe_num: u8,
    pub max_vbios_active_disp_pipe_num: u8,
    pub max_ppll_num: u8,
    pub max_disp_phy_num: u8,
    pub max_aux_pairs: u8,
    pub remotedisplayconfig: u8,
    pub reserved3: [u8; 8usize],
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of atom_display_controller_info_v4_1"]
        [::core::mem::size_of::<atom_display_controller_info_v4_1>() - 56usize];
    ["Alignment of atom_display_controller_info_v4_1"]
        [::core::mem::align_of::<atom_display_controller_info_v4_1>() - 1usize];
    ["Offset of field: atom_display_controller_info_v4_1::table_header"]
        [::core::mem::offset_of!(atom_display_controller_info_v4_1, table_header) - 0usize];
    ["Offset of field: atom_display_controller_info_v4_1::display_caps"]
        [::core::mem::offset_of!(atom_display_controller_info_v4_1, display_caps) - 4usize];
    ["Offset of field: atom_display_controller_info_v4_1::bootup_dispclk_10khz"]
        [::core::mem::offset_of!(atom_display_controller_info_v4_1, bootup_dispclk_10khz) - 8usize];
    ["Offset of field: atom_display_controller_info_v4_1::dce_refclk_10khz"]
        [::core::mem::offset_of!(atom_display_controller_info_v4_1, dce_refclk_10khz) - 12usize];
    ["Offset of field: atom_display_controller_info_v4_1::i2c_engine_refclk_10khz"][::core::mem::offset_of!(
        atom_display_controller_info_v4_1,
        i2c_engine_refclk_10khz
    ) - 14usize];
    ["Offset of field: atom_display_controller_info_v4_1::dvi_ss_percentage"]
        [::core::mem::offset_of!(atom_display_controller_info_v4_1, dvi_ss_percentage) - 16usize];
    ["Offset of field: atom_display_controller_info_v4_1::dvi_ss_rate_10hz"]
        [::core::mem::offset_of!(atom_display_controller_info_v4_1, dvi_ss_rate_10hz) - 18usize];
    ["Offset of field: atom_display_controller_info_v4_1::hdmi_ss_percentage"]
        [::core::mem::offset_of!(atom_display_controller_info_v4_1, hdmi_ss_percentage) - 20usize];
    ["Offset of field: atom_display_controller_info_v4_1::hdmi_ss_rate_10hz"]
        [::core::mem::offset_of!(atom_display_controller_info_v4_1, hdmi_ss_rate_10hz) - 22usize];
    ["Offset of field: atom_display_controller_info_v4_1::dp_ss_percentage"]
        [::core::mem::offset_of!(atom_display_controller_info_v4_1, dp_ss_percentage) - 24usize];
    ["Offset of field: atom_display_controller_info_v4_1::dp_ss_rate_10hz"]
        [::core::mem::offset_of!(atom_display_controller_info_v4_1, dp_ss_rate_10hz) - 26usize];
    ["Offset of field: atom_display_controller_info_v4_1::dvi_ss_mode"]
        [::core::mem::offset_of!(atom_display_controller_info_v4_1, dvi_ss_mode) - 28usize];
    ["Offset of field: atom_display_controller_info_v4_1::hdmi_ss_mode"]
        [::core::mem::offset_of!(atom_display_controller_info_v4_1, hdmi_ss_mode) - 29usize];
    ["Offset of field: atom_display_controller_info_v4_1::dp_ss_mode"]
        [::core::mem::offset_of!(atom_display_controller_info_v4_1, dp_ss_mode) - 30usize];
    ["Offset of field: atom_display_controller_info_v4_1::ss_reserved"]
        [::core::mem::offset_of!(atom_display_controller_info_v4_1, ss_reserved) - 31usize];
    ["Offset of field: atom_display_controller_info_v4_1::hardcode_mode_num"]
        [::core::mem::offset_of!(atom_display_controller_info_v4_1, hardcode_mode_num) - 32usize];
    ["Offset of field: atom_display_controller_info_v4_1::reserved1"]
        [::core::mem::offset_of!(atom_display_controller_info_v4_1, reserved1) - 33usize];
    ["Offset of field: atom_display_controller_info_v4_1::dpphy_refclk_10khz"]
        [::core::mem::offset_of!(atom_display_controller_info_v4_1, dpphy_refclk_10khz) - 36usize];
    ["Offset of field: atom_display_controller_info_v4_1::reserved2"]
        [::core::mem::offset_of!(atom_display_controller_info_v4_1, reserved2) - 38usize];
    ["Offset of field: atom_display_controller_info_v4_1::dceip_min_ver"]
        [::core::mem::offset_of!(atom_display_controller_info_v4_1, dceip_min_ver) - 40usize];
    ["Offset of field: atom_display_controller_info_v4_1::dceip_max_ver"]
        [::core::mem::offset_of!(atom_display_controller_info_v4_1, dceip_max_ver) - 41usize];
    ["Offset of field: atom_display_controller_info_v4_1::max_disp_pipe_num"]
        [::core::mem::offset_of!(atom_display_controller_info_v4_1, max_disp_pipe_num) - 42usize];
    ["Offset of field: atom_display_controller_info_v4_1::max_vbios_active_disp_pipe_num"][::core::mem::offset_of!(
        atom_display_controller_info_v4_1,
        max_vbios_active_disp_pipe_num
    )
        - 43usize];
    ["Offset of field: atom_display_controller_info_v4_1::max_ppll_num"]
        [::core::mem::offset_of!(atom_display_controller_info_v4_1, max_ppll_num) - 44usize];
    ["Offset of field: atom_display_controller_info_v4_1::max_disp_phy_num"]
        [::core::mem::offset_of!(atom_display_controller_info_v4_1, max_disp_phy_num) - 45usize];
    ["Offset of field: atom_display_controller_info_v4_1::max_aux_pairs"]
        [::core::mem::offset_of!(atom_display_controller_info_v4_1, max_aux_pairs) - 46usize];
    ["Offset of field: atom_display_controller_info_v4_1::remotedisplayconfig"]
        [::core::mem::offset_of!(atom_display_controller_info_v4_1, remotedisplayconfig) - 47usize];
    ["Offset of field: atom_display_controller_info_v4_1::reserved3"]
        [::core::mem::offset_of!(atom_display_controller_info_v4_1, reserved3) - 48usize];
};
#[repr(C, packed)]
#[derive(Debug, Copy, Clone)]
pub struct atom_display_controller_info_v4_2 {
    pub table_header: atom_common_table_header,
    pub display_caps: u32,
    pub bootup_dispclk_10khz: u32,
    pub dce_refclk_10khz: u16,
    pub i2c_engine_refclk_10khz: u16,
    pub dvi_ss_percentage: u16,
    pub dvi_ss_rate_10hz: u16,
    pub hdmi_ss_percentage: u16,
    pub hdmi_ss_rate_10hz: u16,
    pub dp_ss_percentage: u16,
    pub dp_ss_rate_10hz: u16,
    pub dvi_ss_mode: u8,
    pub hdmi_ss_mode: u8,
    pub dp_ss_mode: u8,
    pub ss_reserved: u8,
    pub dfp_hardcode_mode_num: u8,
    pub dfp_hardcode_refreshrate: u8,
    pub vga_hardcode_mode_num: u8,
    pub vga_hardcode_refreshrate: u8,
    pub dpphy_refclk_10khz: u16,
    pub reserved2: u16,
    pub dcnip_min_ver: u8,
    pub dcnip_max_ver: u8,
    pub max_disp_pipe_num: u8,
    pub max_vbios_active_disp_pipe_num: u8,
    pub max_ppll_num: u8,
    pub max_disp_phy_num: u8,
    pub max_aux_pairs: u8,
    pub remotedisplayconfig: u8,
    pub reserved3: [u8; 8usize],
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of atom_display_controller_info_v4_2"]
        [::core::mem::size_of::<atom_display_controller_info_v4_2>() - 56usize];
    ["Alignment of atom_display_controller_info_v4_2"]
        [::core::mem::align_of::<atom_display_controller_info_v4_2>() - 1usize];
    ["Offset of field: atom_display_controller_info_v4_2::table_header"]
        [::core::mem::offset_of!(atom_display_controller_info_v4_2, table_header) - 0usize];
    ["Offset of field: atom_display_controller_info_v4_2::display_caps"]
        [::core::mem::offset_of!(atom_display_controller_info_v4_2, display_caps) - 4usize];
    ["Offset of field: atom_display_controller_info_v4_2::bootup_dispclk_10khz"]
        [::core::mem::offset_of!(atom_display_controller_info_v4_2, bootup_dispclk_10khz) - 8usize];
    ["Offset of field: atom_display_controller_info_v4_2::dce_refclk_10khz"]
        [::core::mem::offset_of!(atom_display_controller_info_v4_2, dce_refclk_10khz) - 12usize];
    ["Offset of field: atom_display_controller_info_v4_2::i2c_engine_refclk_10khz"][::core::mem::offset_of!(
        atom_display_controller_info_v4_2,
        i2c_engine_refclk_10khz
    ) - 14usize];
    ["Offset of field: atom_display_controller_info_v4_2::dvi_ss_percentage"]
        [::core::mem::offset_of!(atom_display_controller_info_v4_2, dvi_ss_percentage) - 16usize];
    ["Offset of field: atom_display_controller_info_v4_2::dvi_ss_rate_10hz"]
        [::core::mem::offset_of!(atom_display_controller_info_v4_2, dvi_ss_rate_10hz) - 18usize];
    ["Offset of field: atom_display_controller_info_v4_2::hdmi_ss_percentage"]
        [::core::mem::offset_of!(atom_display_controller_info_v4_2, hdmi_ss_percentage) - 20usize];
    ["Offset of field: atom_display_controller_info_v4_2::hdmi_ss_rate_10hz"]
        [::core::mem::offset_of!(atom_display_controller_info_v4_2, hdmi_ss_rate_10hz) - 22usize];
    ["Offset of field: atom_display_controller_info_v4_2::dp_ss_percentage"]
        [::core::mem::offset_of!(atom_display_controller_info_v4_2, dp_ss_percentage) - 24usize];
    ["Offset of field: atom_display_controller_info_v4_2::dp_ss_rate_10hz"]
        [::core::mem::offset_of!(atom_display_controller_info_v4_2, dp_ss_rate_10hz) - 26usize];
    ["Offset of field: atom_display_controller_info_v4_2::dvi_ss_mode"]
        [::core::mem::offset_of!(atom_display_controller_info_v4_2, dvi_ss_mode) - 28usize];
    ["Offset of field: atom_display_controller_info_v4_2::hdmi_ss_mode"]
        [::core::mem::offset_of!(atom_display_controller_info_v4_2, hdmi_ss_mode) - 29usize];
    ["Offset of field: atom_display_controller_info_v4_2::dp_ss_mode"]
        [::core::mem::offset_of!(atom_display_controller_info_v4_2, dp_ss_mode) - 30usize];
    ["Offset of field: atom_display_controller_info_v4_2::ss_reserved"]
        [::core::mem::offset_of!(atom_display_controller_info_v4_2, ss_reserved) - 31usize];
    ["Offset of field: atom_display_controller_info_v4_2::dfp_hardcode_mode_num"][::core::mem::offset_of!(
        atom_display_controller_info_v4_2,
        dfp_hardcode_mode_num
    ) - 32usize];
    ["Offset of field: atom_display_controller_info_v4_2::dfp_hardcode_refreshrate"][::core::mem::offset_of!(
        atom_display_controller_info_v4_2,
        dfp_hardcode_refreshrate
    ) - 33usize];
    ["Offset of field: atom_display_controller_info_v4_2::vga_hardcode_mode_num"][::core::mem::offset_of!(
        atom_display_controller_info_v4_2,
        vga_hardcode_mode_num
    ) - 34usize];
    ["Offset of field: atom_display_controller_info_v4_2::vga_hardcode_refreshrate"][::core::mem::offset_of!(
        atom_display_controller_info_v4_2,
        vga_hardcode_refreshrate
    ) - 35usize];
    ["Offset of field: atom_display_controller_info_v4_2::dpphy_refclk_10khz"]
        [::core::mem::offset_of!(atom_display_controller_info_v4_2, dpphy_refclk_10khz) - 36usize];
    ["Offset of field: atom_display_controller_info_v4_2::reserved2"]
        [::core::mem::offset_of!(atom_display_controller_info_v4_2, reserved2) - 38usize];
    ["Offset of field: atom_display_controller_info_v4_2::dcnip_min_ver"]
        [::core::mem::offset_of!(atom_display_controller_info_v4_2, dcnip_min_ver) - 40usize];
    ["Offset of field: atom_display_controller_info_v4_2::dcnip_max_ver"]
        [::core::mem::offset_of!(atom_display_controller_info_v4_2, dcnip_max_ver) - 41usize];
    ["Offset of field: atom_display_controller_info_v4_2::max_disp_pipe_num"]
        [::core::mem::offset_of!(atom_display_controller_info_v4_2, max_disp_pipe_num) - 42usize];
    ["Offset of field: atom_display_controller_info_v4_2::max_vbios_active_disp_pipe_num"][::core::mem::offset_of!(
        atom_display_controller_info_v4_2,
        max_vbios_active_disp_pipe_num
    )
        - 43usize];
    ["Offset of field: atom_display_controller_info_v4_2::max_ppll_num"]
        [::core::mem::offset_of!(atom_display_controller_info_v4_2, max_ppll_num) - 44usize];
    ["Offset of field: atom_display_controller_info_v4_2::max_disp_phy_num"]
        [::core::mem::offset_of!(atom_display_controller_info_v4_2, max_disp_phy_num) - 45usize];
    ["Offset of field: atom_display_controller_info_v4_2::max_aux_pairs"]
        [::core::mem::offset_of!(atom_display_controller_info_v4_2, max_aux_pairs) - 46usize];
    ["Offset of field: atom_display_controller_info_v4_2::remotedisplayconfig"]
        [::core::mem::offset_of!(atom_display_controller_info_v4_2, remotedisplayconfig) - 47usize];
    ["Offset of field: atom_display_controller_info_v4_2::reserved3"]
        [::core::mem::offset_of!(atom_display_controller_info_v4_2, reserved3) - 48usize];
};
#[repr(C, packed)]
#[derive(Debug, Copy, Clone)]
pub struct atom_display_controller_info_v4_3 {
    pub table_header: atom_common_table_header,
    pub display_caps: u32,
    pub bootup_dispclk_10khz: u32,
    pub dce_refclk_10khz: u16,
    pub i2c_engine_refclk_10khz: u16,
    pub dvi_ss_percentage: u16,
    pub dvi_ss_rate_10hz: u16,
    pub hdmi_ss_percentage: u16,
    pub hdmi_ss_rate_10hz: u16,
    pub dp_ss_percentage: u16,
    pub dp_ss_rate_10hz: u16,
    pub dvi_ss_mode: u8,
    pub hdmi_ss_mode: u8,
    pub dp_ss_mode: u8,
    pub ss_reserved: u8,
    pub dfp_hardcode_mode_num: u8,
    pub dfp_hardcode_refreshrate: u8,
    pub vga_hardcode_mode_num: u8,
    pub vga_hardcode_refreshrate: u8,
    pub dpphy_refclk_10khz: u16,
    pub reserved2: u16,
    pub dcnip_min_ver: u8,
    pub dcnip_max_ver: u8,
    pub max_disp_pipe_num: u8,
    pub max_vbios_active_disp_pipe_num: u8,
    pub max_ppll_num: u8,
    pub max_disp_phy_num: u8,
    pub max_aux_pairs: u8,
    pub remotedisplayconfig: u8,
    pub reserved3: [u8; 8usize],
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of atom_display_controller_info_v4_3"]
        [::core::mem::size_of::<atom_display_controller_info_v4_3>() - 56usize];
    ["Alignment of atom_display_controller_info_v4_3"]
        [::core::mem::align_of::<atom_display_controller_info_v4_3>() - 1usize];
    ["Offset of field: atom_display_controller_info_v4_3::table_header"]
        [::core::mem::offset_of!(atom_display_controller_info_v4_3, table_header) - 0usize];
    ["Offset of field: atom_display_controller_info_v4_3::display_caps"]
        [::core::mem::offset_of!(atom_display_controller_info_v4_3, display_caps) - 4usize];
    ["Offset of field: atom_display_controller_info_v4_3::bootup_dispclk_10khz"]
        [::core::mem::offset_of!(atom_display_controller_info_v4_3, bootup_dispclk_10khz) - 8usize];
    ["Offset of field: atom_display_controller_info_v4_3::dce_refclk_10khz"]
        [::core::mem::offset_of!(atom_display_controller_info_v4_3, dce_refclk_10khz) - 12usize];
    ["Offset of field: atom_display_controller_info_v4_3::i2c_engine_refclk_10khz"][::core::mem::offset_of!(
        atom_display_controller_info_v4_3,
        i2c_engine_refclk_10khz
    ) - 14usize];
    ["Offset of field: atom_display_controller_info_v4_3::dvi_ss_percentage"]
        [::core::mem::offset_of!(atom_display_controller_info_v4_3, dvi_ss_percentage) - 16usize];
    ["Offset of field: atom_display_controller_info_v4_3::dvi_ss_rate_10hz"]
        [::core::mem::offset_of!(atom_display_controller_info_v4_3, dvi_ss_rate_10hz) - 18usize];
    ["Offset of field: atom_display_controller_info_v4_3::hdmi_ss_percentage"]
        [::core::mem::offset_of!(atom_display_controller_info_v4_3, hdmi_ss_percentage) - 20usize];
    ["Offset of field: atom_display_controller_info_v4_3::hdmi_ss_rate_10hz"]
        [::core::mem::offset_of!(atom_display_controller_info_v4_3, hdmi_ss_rate_10hz) - 22usize];
    ["Offset of field: atom_display_controller_info_v4_3::dp_ss_percentage"]
        [::core::mem::offset_of!(atom_display_controller_info_v4_3, dp_ss_percentage) - 24usize];
    ["Offset of field: atom_display_controller_info_v4_3::dp_ss_rate_10hz"]
        [::core::mem::offset_of!(atom_display_controller_info_v4_3, dp_ss_rate_10hz) - 26usize];
    ["Offset of field: atom_display_controller_info_v4_3::dvi_ss_mode"]
        [::core::mem::offset_of!(atom_display_controller_info_v4_3, dvi_ss_mode) - 28usize];
    ["Offset of field: atom_display_controller_info_v4_3::hdmi_ss_mode"]
        [::core::mem::offset_of!(atom_display_controller_info_v4_3, hdmi_ss_mode) - 29usize];
    ["Offset of field: atom_display_controller_info_v4_3::dp_ss_mode"]
        [::core::mem::offset_of!(atom_display_controller_info_v4_3, dp_ss_mode) - 30usize];
    ["Offset of field: atom_display_controller_info_v4_3::ss_reserved"]
        [::core::mem::offset_of!(atom_display_controller_info_v4_3, ss_reserved) - 31usize];
    ["Offset of field: atom_display_controller_info_v4_3::dfp_hardcode_mode_num"][::core::mem::offset_of!(
        atom_display_controller_info_v4_3,
        dfp_hardcode_mode_num
    ) - 32usize];
    ["Offset of field: atom_display_controller_info_v4_3::dfp_hardcode_refreshrate"][::core::mem::offset_of!(
        atom_display_controller_info_v4_3,
        dfp_hardcode_refreshrate
    ) - 33usize];
    ["Offset of field: atom_display_controller_info_v4_3::vga_hardcode_mode_num"][::core::mem::offset_of!(
        atom_display_controller_info_v4_3,
        vga_hardcode_mode_num
    ) - 34usize];
    ["Offset of field: atom_display_controller_info_v4_3::vga_hardcode_refreshrate"][::core::mem::offset_of!(
        atom_display_controller_info_v4_3,
        vga_hardcode_refreshrate
    ) - 35usize];
    ["Offset of field: atom_display_controller_info_v4_3::dpphy_refclk_10khz"]
        [::core::mem::offset_of!(atom_display_controller_info_v4_3, dpphy_refclk_10khz) - 36usize];
    ["Offset of field: atom_display_controller_info_v4_3::reserved2"]
        [::core::mem::offset_of!(atom_display_controller_info_v4_3, reserved2) - 38usize];
    ["Offset of field: atom_display_controller_info_v4_3::dcnip_min_ver"]
        [::core::mem::offset_of!(atom_display_controller_info_v4_3, dcnip_min_ver) - 40usize];
    ["Offset of field: atom_display_controller_info_v4_3::dcnip_max_ver"]
        [::core::mem::offset_of!(atom_display_controller_info_v4_3, dcnip_max_ver) - 41usize];
    ["Offset of field: atom_display_controller_info_v4_3::max_disp_pipe_num"]
        [::core::mem::offset_of!(atom_display_controller_info_v4_3, max_disp_pipe_num) - 42usize];
    ["Offset of field: atom_display_controller_info_v4_3::max_vbios_active_disp_pipe_num"][::core::mem::offset_of!(
        atom_display_controller_info_v4_3,
        max_vbios_active_disp_pipe_num
    )
        - 43usize];
    ["Offset of field: atom_display_controller_info_v4_3::max_ppll_num"]
        [::core::mem::offset_of!(atom_display_controller_info_v4_3, max_ppll_num) - 44usize];
    ["Offset of field: atom_display_controller_info_v4_3::max_disp_phy_num"]
        [::core::mem::offset_of!(atom_display_controller_info_v4_3, max_disp_phy_num) - 45usize];
    ["Offset of field: atom_display_controller_info_v4_3::max_aux_pairs"]
        [::core::mem::offset_of!(atom_display_controller_info_v4_3, max_aux_pairs) - 46usize];
    ["Offset of field: atom_display_controller_info_v4_3::remotedisplayconfig"]
        [::core::mem::offset_of!(atom_display_controller_info_v4_3, remotedisplayconfig) - 47usize];
    ["Offset of field: atom_display_controller_info_v4_3::reserved3"]
        [::core::mem::offset_of!(atom_display_controller_info_v4_3, reserved3) - 48usize];
};
#[repr(C, packed)]
#[derive(Debug, Copy, Clone)]
pub struct atom_display_controller_info_v4_4 {
    pub table_header: atom_common_table_header,
    pub display_caps: u32,
    pub bootup_dispclk_10khz: u32,
    pub dce_refclk_10khz: u16,
    pub i2c_engine_refclk_10khz: u16,
    pub dvi_ss_percentage: u16,
    pub dvi_ss_rate_10hz: u16,
    pub hdmi_ss_percentage: u16,
    pub hdmi_ss_rate_10hz: u16,
    pub dp_ss_percentage: u16,
    pub dp_ss_rate_10hz: u16,
    pub dvi_ss_mode: u8,
    pub hdmi_ss_mode: u8,
    pub dp_ss_mode: u8,
    pub ss_reserved: u8,
    pub dfp_hardcode_mode_num: u8,
    pub dfp_hardcode_refreshrate: u8,
    pub vga_hardcode_mode_num: u8,
    pub vga_hardcode_refreshrate: u8,
    pub dpphy_refclk_10khz: u16,
    pub hw_chip_id: u16,
    pub dcnip_min_ver: u8,
    pub dcnip_max_ver: u8,
    pub max_disp_pipe_num: u8,
    pub max_vbios_active_disp_pipum: u8,
    pub max_ppll_num: u8,
    pub max_disp_phy_num: u8,
    pub max_aux_pairs: u8,
    pub remotedisplayconfig: u8,
    pub dispclk_pll_vco_freq: u32,
    pub dp_ref_clk_freq: u32,
    pub max_mclk_chg_lat: u32,
    pub max_sr_exit_lat: u32,
    pub max_sr_enter_exit_lat: u32,
    pub dc_golden_table_offset: u16,
    pub dc_golden_table_ver: u16,
    pub reserved3: [u32; 3usize],
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of atom_display_controller_info_v4_4"]
        [::core::mem::size_of::<atom_display_controller_info_v4_4>() - 84usize];
    ["Alignment of atom_display_controller_info_v4_4"]
        [::core::mem::align_of::<atom_display_controller_info_v4_4>() - 1usize];
    ["Offset of field: atom_display_controller_info_v4_4::table_header"]
        [::core::mem::offset_of!(atom_display_controller_info_v4_4, table_header) - 0usize];
    ["Offset of field: atom_display_controller_info_v4_4::display_caps"]
        [::core::mem::offset_of!(atom_display_controller_info_v4_4, display_caps) - 4usize];
    ["Offset of field: atom_display_controller_info_v4_4::bootup_dispclk_10khz"]
        [::core::mem::offset_of!(atom_display_controller_info_v4_4, bootup_dispclk_10khz) - 8usize];
    ["Offset of field: atom_display_controller_info_v4_4::dce_refclk_10khz"]
        [::core::mem::offset_of!(atom_display_controller_info_v4_4, dce_refclk_10khz) - 12usize];
    ["Offset of field: atom_display_controller_info_v4_4::i2c_engine_refclk_10khz"][::core::mem::offset_of!(
        atom_display_controller_info_v4_4,
        i2c_engine_refclk_10khz
    ) - 14usize];
    ["Offset of field: atom_display_controller_info_v4_4::dvi_ss_percentage"]
        [::core::mem::offset_of!(atom_display_controller_info_v4_4, dvi_ss_percentage) - 16usize];
    ["Offset of field: atom_display_controller_info_v4_4::dvi_ss_rate_10hz"]
        [::core::mem::offset_of!(atom_display_controller_info_v4_4, dvi_ss_rate_10hz) - 18usize];
    ["Offset of field: atom_display_controller_info_v4_4::hdmi_ss_percentage"]
        [::core::mem::offset_of!(atom_display_controller_info_v4_4, hdmi_ss_percentage) - 20usize];
    ["Offset of field: atom_display_controller_info_v4_4::hdmi_ss_rate_10hz"]
        [::core::mem::offset_of!(atom_display_controller_info_v4_4, hdmi_ss_rate_10hz) - 22usize];
    ["Offset of field: atom_display_controller_info_v4_4::dp_ss_percentage"]
        [::core::mem::offset_of!(atom_display_controller_info_v4_4, dp_ss_percentage) - 24usize];
    ["Offset of field: atom_display_controller_info_v4_4::dp_ss_rate_10hz"]
        [::core::mem::offset_of!(atom_display_controller_info_v4_4, dp_ss_rate_10hz) - 26usize];
    ["Offset of field: atom_display_controller_info_v4_4::dvi_ss_mode"]
        [::core::mem::offset_of!(atom_display_controller_info_v4_4, dvi_ss_mode) - 28usize];
    ["Offset of field: atom_display_controller_info_v4_4::hdmi_ss_mode"]
        [::core::mem::offset_of!(atom_display_controller_info_v4_4, hdmi_ss_mode) - 29usize];
    ["Offset of field: atom_display_controller_info_v4_4::dp_ss_mode"]
        [::core::mem::offset_of!(atom_display_controller_info_v4_4, dp_ss_mode) - 30usize];
    ["Offset of field: atom_display_controller_info_v4_4::ss_reserved"]
        [::core::mem::offset_of!(atom_display_controller_info_v4_4, ss_reserved) - 31usize];
    ["Offset of field: atom_display_controller_info_v4_4::dfp_hardcode_mode_num"][::core::mem::offset_of!(
        atom_display_controller_info_v4_4,
        dfp_hardcode_mode_num
    ) - 32usize];
    ["Offset of field: atom_display_controller_info_v4_4::dfp_hardcode_refreshrate"][::core::mem::offset_of!(
        atom_display_controller_info_v4_4,
        dfp_hardcode_refreshrate
    ) - 33usize];
    ["Offset of field: atom_display_controller_info_v4_4::vga_hardcode_mode_num"][::core::mem::offset_of!(
        atom_display_controller_info_v4_4,
        vga_hardcode_mode_num
    ) - 34usize];
    ["Offset of field: atom_display_controller_info_v4_4::vga_hardcode_refreshrate"][::core::mem::offset_of!(
        atom_display_controller_info_v4_4,
        vga_hardcode_refreshrate
    ) - 35usize];
    ["Offset of field: atom_display_controller_info_v4_4::dpphy_refclk_10khz"]
        [::core::mem::offset_of!(atom_display_controller_info_v4_4, dpphy_refclk_10khz) - 36usize];
    ["Offset of field: atom_display_controller_info_v4_4::hw_chip_id"]
        [::core::mem::offset_of!(atom_display_controller_info_v4_4, hw_chip_id) - 38usize];
    ["Offset of field: atom_display_controller_info_v4_4::dcnip_min_ver"]
        [::core::mem::offset_of!(atom_display_controller_info_v4_4, dcnip_min_ver) - 40usize];
    ["Offset of field: atom_display_controller_info_v4_4::dcnip_max_ver"]
        [::core::mem::offset_of!(atom_display_controller_info_v4_4, dcnip_max_ver) - 41usize];
    ["Offset of field: atom_display_controller_info_v4_4::max_disp_pipe_num"]
        [::core::mem::offset_of!(atom_display_controller_info_v4_4, max_disp_pipe_num) - 42usize];
    ["Offset of field: atom_display_controller_info_v4_4::max_vbios_active_disp_pipum"][::core::mem::offset_of!(
        atom_display_controller_info_v4_4,
        max_vbios_active_disp_pipum
    )
        - 43usize];
    ["Offset of field: atom_display_controller_info_v4_4::max_ppll_num"]
        [::core::mem::offset_of!(atom_display_controller_info_v4_4, max_ppll_num) - 44usize];
    ["Offset of field: atom_display_controller_info_v4_4::max_disp_phy_num"]
        [::core::mem::offset_of!(atom_display_controller_info_v4_4, max_disp_phy_num) - 45usize];
    ["Offset of field: atom_display_controller_info_v4_4::max_aux_pairs"]
        [::core::mem::offset_of!(atom_display_controller_info_v4_4, max_aux_pairs) - 46usize];
    ["Offset of field: atom_display_controller_info_v4_4::remotedisplayconfig"]
        [::core::mem::offset_of!(atom_display_controller_info_v4_4, remotedisplayconfig) - 47usize];
    ["Offset of field: atom_display_controller_info_v4_4::dispclk_pll_vco_freq"][::core::mem::offset_of!(
        atom_display_controller_info_v4_4,
        dispclk_pll_vco_freq
    ) - 48usize];
    ["Offset of field: atom_display_controller_info_v4_4::dp_ref_clk_freq"]
        [::core::mem::offset_of!(atom_display_controller_info_v4_4, dp_ref_clk_freq) - 52usize];
    ["Offset of field: atom_display_controller_info_v4_4::max_mclk_chg_lat"]
        [::core::mem::offset_of!(atom_display_controller_info_v4_4, max_mclk_chg_lat) - 56usize];
    ["Offset of field: atom_display_controller_info_v4_4::max_sr_exit_lat"]
        [::core::mem::offset_of!(atom_display_controller_info_v4_4, max_sr_exit_lat) - 60usize];
    ["Offset of field: atom_display_controller_info_v4_4::max_sr_enter_exit_lat"][::core::mem::offset_of!(
        atom_display_controller_info_v4_4,
        max_sr_enter_exit_lat
    ) - 64usize];
    ["Offset of field: atom_display_controller_info_v4_4::dc_golden_table_offset"][::core::mem::offset_of!(
        atom_display_controller_info_v4_4,
        dc_golden_table_offset
    ) - 68usize];
    ["Offset of field: atom_display_controller_info_v4_4::dc_golden_table_ver"]
        [::core::mem::offset_of!(atom_display_controller_info_v4_4, dc_golden_table_ver) - 70usize];
    ["Offset of field: atom_display_controller_info_v4_4::reserved3"]
        [::core::mem::offset_of!(atom_display_controller_info_v4_4, reserved3) - 72usize];
};
#[repr(C, packed)]
#[derive(Debug, Copy, Clone)]
pub struct atom_dc_golden_table_v1 {
    pub aux_dphy_rx_control0_val: u32,
    pub aux_dphy_tx_control_val: u32,
    pub aux_dphy_rx_control1_val: u32,
    pub dc_gpio_aux_ctrl_0_val: u32,
    pub dc_gpio_aux_ctrl_1_val: u32,
    pub dc_gpio_aux_ctrl_2_val: u32,
    pub dc_gpio_aux_ctrl_3_val: u32,
    pub dc_gpio_aux_ctrl_4_val: u32,
    pub dc_gpio_aux_ctrl_5_val: u32,
    pub reserved: [u32; 23usize],
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of atom_dc_golden_table_v1"]
        [::core::mem::size_of::<atom_dc_golden_table_v1>() - 128usize];
    ["Alignment of atom_dc_golden_table_v1"]
        [::core::mem::align_of::<atom_dc_golden_table_v1>() - 1usize];
    ["Offset of field: atom_dc_golden_table_v1::aux_dphy_rx_control0_val"]
        [::core::mem::offset_of!(atom_dc_golden_table_v1, aux_dphy_rx_control0_val) - 0usize];
    ["Offset of field: atom_dc_golden_table_v1::aux_dphy_tx_control_val"]
        [::core::mem::offset_of!(atom_dc_golden_table_v1, aux_dphy_tx_control_val) - 4usize];
    ["Offset of field: atom_dc_golden_table_v1::aux_dphy_rx_control1_val"]
        [::core::mem::offset_of!(atom_dc_golden_table_v1, aux_dphy_rx_control1_val) - 8usize];
    ["Offset of field: atom_dc_golden_table_v1::dc_gpio_aux_ctrl_0_val"]
        [::core::mem::offset_of!(atom_dc_golden_table_v1, dc_gpio_aux_ctrl_0_val) - 12usize];
    ["Offset of field: atom_dc_golden_table_v1::dc_gpio_aux_ctrl_1_val"]
        [::core::mem::offset_of!(atom_dc_golden_table_v1, dc_gpio_aux_ctrl_1_val) - 16usize];
    ["Offset of field: atom_dc_golden_table_v1::dc_gpio_aux_ctrl_2_val"]
        [::core::mem::offset_of!(atom_dc_golden_table_v1, dc_gpio_aux_ctrl_2_val) - 20usize];
    ["Offset of field: atom_dc_golden_table_v1::dc_gpio_aux_ctrl_3_val"]
        [::core::mem::offset_of!(atom_dc_golden_table_v1, dc_gpio_aux_ctrl_3_val) - 24usize];
    ["Offset of field: atom_dc_golden_table_v1::dc_gpio_aux_ctrl_4_val"]
        [::core::mem::offset_of!(atom_dc_golden_table_v1, dc_gpio_aux_ctrl_4_val) - 28usize];
    ["Offset of field: atom_dc_golden_table_v1::dc_gpio_aux_ctrl_5_val"]
        [::core::mem::offset_of!(atom_dc_golden_table_v1, dc_gpio_aux_ctrl_5_val) - 32usize];
    ["Offset of field: atom_dc_golden_table_v1::reserved"]
        [::core::mem::offset_of!(atom_dc_golden_table_v1, reserved) - 36usize];
};
pub const dce_info_caps_def_DCE_INFO_CAPS_FORCE_DISPDEV_CONNECTED: dce_info_caps_def = 2;
pub const dce_info_caps_def_DCE_INFO_CAPS_DISABLE_DFP_DP_HBR2: dce_info_caps_def = 4;
pub const dce_info_caps_def_DCE_INFO_CAPS_ENABLE_INTERLAC_TIMING: dce_info_caps_def = 8;
pub const dce_info_caps_def_DCE_INFO_CAPS_LTTPR_SUPPORT_ENABLE: dce_info_caps_def = 32;
pub const dce_info_caps_def_DCE_INFO_CAPS_VBIOS_LTTPR_TRANSPARENT_ENABLE: dce_info_caps_def = 64;
pub type dce_info_caps_def = ::core::ffi::c_uint;
#[repr(C, packed)]
#[derive(Debug, Copy, Clone)]
pub struct atom_display_controller_info_v4_5 {
    pub table_header: atom_common_table_header,
    pub display_caps: u32,
    pub bootup_dispclk_10khz: u32,
    pub dce_refclk_10khz: u16,
    pub i2c_engine_refclk_10khz: u16,
    pub dvi_ss_percentage: u16,
    pub dvi_ss_rate_10hz: u16,
    pub hdmi_ss_percentage: u16,
    pub hdmi_ss_rate_10hz: u16,
    pub dp_ss_percentage: u16,
    pub dp_ss_rate_10hz: u16,
    pub dvi_ss_mode: u8,
    pub hdmi_ss_mode: u8,
    pub dp_ss_mode: u8,
    pub ss_reserved: u8,
    pub dfp_hardcode_mode_num: u8,
    pub dfp_hardcode_refreshrate: u8,
    pub vga_hardcode_mode_num: u8,
    pub vga_hardcode_refreshrate: u8,
    pub dpphy_refclk_10khz: u16,
    pub hw_chip_id: u16,
    pub dcnip_min_ver: u8,
    pub dcnip_max_ver: u8,
    pub max_disp_pipe_num: u8,
    pub max_vbios_active_disp_pipe_num: u8,
    pub max_ppll_num: u8,
    pub max_disp_phy_num: u8,
    pub max_aux_pairs: u8,
    pub remotedisplayconfig: u8,
    pub dispclk_pll_vco_freq: u32,
    pub dp_ref_clk_freq: u32,
    pub max_mclk_chg_lat: u32,
    pub max_sr_exit_lat: u32,
    pub max_sr_enter_exit_lat: u32,
    pub dc_golden_table_offset: u16,
    pub dc_golden_table_ver: u16,
    pub aux_dphy_rx_control0_val: u32,
    pub aux_dphy_tx_control_val: u32,
    pub aux_dphy_rx_control1_val: u32,
    pub dc_gpio_aux_ctrl_0_val: u32,
    pub dc_gpio_aux_ctrl_1_val: u32,
    pub dc_gpio_aux_ctrl_2_val: u32,
    pub dc_gpio_aux_ctrl_3_val: u32,
    pub dc_gpio_aux_ctrl_4_val: u32,
    pub dc_gpio_aux_ctrl_5_val: u32,
    pub reserved: [u32; 26usize],
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of atom_display_controller_info_v4_5"]
        [::core::mem::size_of::<atom_display_controller_info_v4_5>() - 212usize];
    ["Alignment of atom_display_controller_info_v4_5"]
        [::core::mem::align_of::<atom_display_controller_info_v4_5>() - 1usize];
    ["Offset of field: atom_display_controller_info_v4_5::table_header"]
        [::core::mem::offset_of!(atom_display_controller_info_v4_5, table_header) - 0usize];
    ["Offset of field: atom_display_controller_info_v4_5::display_caps"]
        [::core::mem::offset_of!(atom_display_controller_info_v4_5, display_caps) - 4usize];
    ["Offset of field: atom_display_controller_info_v4_5::bootup_dispclk_10khz"]
        [::core::mem::offset_of!(atom_display_controller_info_v4_5, bootup_dispclk_10khz) - 8usize];
    ["Offset of field: atom_display_controller_info_v4_5::dce_refclk_10khz"]
        [::core::mem::offset_of!(atom_display_controller_info_v4_5, dce_refclk_10khz) - 12usize];
    ["Offset of field: atom_display_controller_info_v4_5::i2c_engine_refclk_10khz"][::core::mem::offset_of!(
        atom_display_controller_info_v4_5,
        i2c_engine_refclk_10khz
    ) - 14usize];
    ["Offset of field: atom_display_controller_info_v4_5::dvi_ss_percentage"]
        [::core::mem::offset_of!(atom_display_controller_info_v4_5, dvi_ss_percentage) - 16usize];
    ["Offset of field: atom_display_controller_info_v4_5::dvi_ss_rate_10hz"]
        [::core::mem::offset_of!(atom_display_controller_info_v4_5, dvi_ss_rate_10hz) - 18usize];
    ["Offset of field: atom_display_controller_info_v4_5::hdmi_ss_percentage"]
        [::core::mem::offset_of!(atom_display_controller_info_v4_5, hdmi_ss_percentage) - 20usize];
    ["Offset of field: atom_display_controller_info_v4_5::hdmi_ss_rate_10hz"]
        [::core::mem::offset_of!(atom_display_controller_info_v4_5, hdmi_ss_rate_10hz) - 22usize];
    ["Offset of field: atom_display_controller_info_v4_5::dp_ss_percentage"]
        [::core::mem::offset_of!(atom_display_controller_info_v4_5, dp_ss_percentage) - 24usize];
    ["Offset of field: atom_display_controller_info_v4_5::dp_ss_rate_10hz"]
        [::core::mem::offset_of!(atom_display_controller_info_v4_5, dp_ss_rate_10hz) - 26usize];
    ["Offset of field: atom_display_controller_info_v4_5::dvi_ss_mode"]
        [::core::mem::offset_of!(atom_display_controller_info_v4_5, dvi_ss_mode) - 28usize];
    ["Offset of field: atom_display_controller_info_v4_5::hdmi_ss_mode"]
        [::core::mem::offset_of!(atom_display_controller_info_v4_5, hdmi_ss_mode) - 29usize];
    ["Offset of field: atom_display_controller_info_v4_5::dp_ss_mode"]
        [::core::mem::offset_of!(atom_display_controller_info_v4_5, dp_ss_mode) - 30usize];
    ["Offset of field: atom_display_controller_info_v4_5::ss_reserved"]
        [::core::mem::offset_of!(atom_display_controller_info_v4_5, ss_reserved) - 31usize];
    ["Offset of field: atom_display_controller_info_v4_5::dfp_hardcode_mode_num"][::core::mem::offset_of!(
        atom_display_controller_info_v4_5,
        dfp_hardcode_mode_num
    ) - 32usize];
    ["Offset of field: atom_display_controller_info_v4_5::dfp_hardcode_refreshrate"][::core::mem::offset_of!(
        atom_display_controller_info_v4_5,
        dfp_hardcode_refreshrate
    ) - 33usize];
    ["Offset of field: atom_display_controller_info_v4_5::vga_hardcode_mode_num"][::core::mem::offset_of!(
        atom_display_controller_info_v4_5,
        vga_hardcode_mode_num
    ) - 34usize];
    ["Offset of field: atom_display_controller_info_v4_5::vga_hardcode_refreshrate"][::core::mem::offset_of!(
        atom_display_controller_info_v4_5,
        vga_hardcode_refreshrate
    ) - 35usize];
    ["Offset of field: atom_display_controller_info_v4_5::dpphy_refclk_10khz"]
        [::core::mem::offset_of!(atom_display_controller_info_v4_5, dpphy_refclk_10khz) - 36usize];
    ["Offset of field: atom_display_controller_info_v4_5::hw_chip_id"]
        [::core::mem::offset_of!(atom_display_controller_info_v4_5, hw_chip_id) - 38usize];
    ["Offset of field: atom_display_controller_info_v4_5::dcnip_min_ver"]
        [::core::mem::offset_of!(atom_display_controller_info_v4_5, dcnip_min_ver) - 40usize];
    ["Offset of field: atom_display_controller_info_v4_5::dcnip_max_ver"]
        [::core::mem::offset_of!(atom_display_controller_info_v4_5, dcnip_max_ver) - 41usize];
    ["Offset of field: atom_display_controller_info_v4_5::max_disp_pipe_num"]
        [::core::mem::offset_of!(atom_display_controller_info_v4_5, max_disp_pipe_num) - 42usize];
    ["Offset of field: atom_display_controller_info_v4_5::max_vbios_active_disp_pipe_num"][::core::mem::offset_of!(
        atom_display_controller_info_v4_5,
        max_vbios_active_disp_pipe_num
    )
        - 43usize];
    ["Offset of field: atom_display_controller_info_v4_5::max_ppll_num"]
        [::core::mem::offset_of!(atom_display_controller_info_v4_5, max_ppll_num) - 44usize];
    ["Offset of field: atom_display_controller_info_v4_5::max_disp_phy_num"]
        [::core::mem::offset_of!(atom_display_controller_info_v4_5, max_disp_phy_num) - 45usize];
    ["Offset of field: atom_display_controller_info_v4_5::max_aux_pairs"]
        [::core::mem::offset_of!(atom_display_controller_info_v4_5, max_aux_pairs) - 46usize];
    ["Offset of field: atom_display_controller_info_v4_5::remotedisplayconfig"]
        [::core::mem::offset_of!(atom_display_controller_info_v4_5, remotedisplayconfig) - 47usize];
    ["Offset of field: atom_display_controller_info_v4_5::dispclk_pll_vco_freq"][::core::mem::offset_of!(
        atom_display_controller_info_v4_5,
        dispclk_pll_vco_freq
    ) - 48usize];
    ["Offset of field: atom_display_controller_info_v4_5::dp_ref_clk_freq"]
        [::core::mem::offset_of!(atom_display_controller_info_v4_5, dp_ref_clk_freq) - 52usize];
    ["Offset of field: atom_display_controller_info_v4_5::max_mclk_chg_lat"]
        [::core::mem::offset_of!(atom_display_controller_info_v4_5, max_mclk_chg_lat) - 56usize];
    ["Offset of field: atom_display_controller_info_v4_5::max_sr_exit_lat"]
        [::core::mem::offset_of!(atom_display_controller_info_v4_5, max_sr_exit_lat) - 60usize];
    ["Offset of field: atom_display_controller_info_v4_5::max_sr_enter_exit_lat"][::core::mem::offset_of!(
        atom_display_controller_info_v4_5,
        max_sr_enter_exit_lat
    ) - 64usize];
    ["Offset of field: atom_display_controller_info_v4_5::dc_golden_table_offset"][::core::mem::offset_of!(
        atom_display_controller_info_v4_5,
        dc_golden_table_offset
    ) - 68usize];
    ["Offset of field: atom_display_controller_info_v4_5::dc_golden_table_ver"]
        [::core::mem::offset_of!(atom_display_controller_info_v4_5, dc_golden_table_ver) - 70usize];
    ["Offset of field: atom_display_controller_info_v4_5::aux_dphy_rx_control0_val"][::core::mem::offset_of!(
        atom_display_controller_info_v4_5,
        aux_dphy_rx_control0_val
    ) - 72usize];
    ["Offset of field: atom_display_controller_info_v4_5::aux_dphy_tx_control_val"][::core::mem::offset_of!(
        atom_display_controller_info_v4_5,
        aux_dphy_tx_control_val
    ) - 76usize];
    ["Offset of field: atom_display_controller_info_v4_5::aux_dphy_rx_control1_val"][::core::mem::offset_of!(
        atom_display_controller_info_v4_5,
        aux_dphy_rx_control1_val
    ) - 80usize];
    ["Offset of field: atom_display_controller_info_v4_5::dc_gpio_aux_ctrl_0_val"][::core::mem::offset_of!(
        atom_display_controller_info_v4_5,
        dc_gpio_aux_ctrl_0_val
    ) - 84usize];
    ["Offset of field: atom_display_controller_info_v4_5::dc_gpio_aux_ctrl_1_val"][::core::mem::offset_of!(
        atom_display_controller_info_v4_5,
        dc_gpio_aux_ctrl_1_val
    ) - 88usize];
    ["Offset of field: atom_display_controller_info_v4_5::dc_gpio_aux_ctrl_2_val"][::core::mem::offset_of!(
        atom_display_controller_info_v4_5,
        dc_gpio_aux_ctrl_2_val
    ) - 92usize];
    ["Offset of field: atom_display_controller_info_v4_5::dc_gpio_aux_ctrl_3_val"][::core::mem::offset_of!(
        atom_display_controller_info_v4_5,
        dc_gpio_aux_ctrl_3_val
    ) - 96usize];
    ["Offset of field: atom_display_controller_info_v4_5::dc_gpio_aux_ctrl_4_val"][::core::mem::offset_of!(
        atom_display_controller_info_v4_5,
        dc_gpio_aux_ctrl_4_val
    ) - 100usize];
    ["Offset of field: atom_display_controller_info_v4_5::dc_gpio_aux_ctrl_5_val"][::core::mem::offset_of!(
        atom_display_controller_info_v4_5,
        dc_gpio_aux_ctrl_5_val
    ) - 104usize];
    ["Offset of field: atom_display_controller_info_v4_5::reserved"]
        [::core::mem::offset_of!(atom_display_controller_info_v4_5, reserved) - 108usize];
};
#[repr(C, packed)]
#[derive(Debug, Copy, Clone)]
pub struct atom_ext_display_path {
    pub device_tag: u16,
    pub device_acpi_enum: u16,
    pub connectorobjid: u16,
    pub auxddclut_index: u8,
    pub hpdlut_index: u8,
    pub ext_encoder_objid: u16,
    pub channelmapping: u8,
    pub chpninvert: u8,
    pub caps: u16,
    pub reserved: u16,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of atom_ext_display_path"][::core::mem::size_of::<atom_ext_display_path>() - 16usize];
    ["Alignment of atom_ext_display_path"]
        [::core::mem::align_of::<atom_ext_display_path>() - 1usize];
    ["Offset of field: atom_ext_display_path::device_tag"]
        [::core::mem::offset_of!(atom_ext_display_path, device_tag) - 0usize];
    ["Offset of field: atom_ext_display_path::device_acpi_enum"]
        [::core::mem::offset_of!(atom_ext_display_path, device_acpi_enum) - 2usize];
    ["Offset of field: atom_ext_display_path::connectorobjid"]
        [::core::mem::offset_of!(atom_ext_display_path, connectorobjid) - 4usize];
    ["Offset of field: atom_ext_display_path::auxddclut_index"]
        [::core::mem::offset_of!(atom_ext_display_path, auxddclut_index) - 6usize];
    ["Offset of field: atom_ext_display_path::hpdlut_index"]
        [::core::mem::offset_of!(atom_ext_display_path, hpdlut_index) - 7usize];
    ["Offset of field: atom_ext_display_path::ext_encoder_objid"]
        [::core::mem::offset_of!(atom_ext_display_path, ext_encoder_objid) - 8usize];
    ["Offset of field: atom_ext_display_path::channelmapping"]
        [::core::mem::offset_of!(atom_ext_display_path, channelmapping) - 10usize];
    ["Offset of field: atom_ext_display_path::chpninvert"]
        [::core::mem::offset_of!(atom_ext_display_path, chpninvert) - 11usize];
    ["Offset of field: atom_ext_display_path::caps"]
        [::core::mem::offset_of!(atom_ext_display_path, caps) - 12usize];
    ["Offset of field: atom_ext_display_path::reserved"]
        [::core::mem::offset_of!(atom_ext_display_path, reserved) - 14usize];
};
pub const ext_display_path_cap_def_EXT_DISPLAY_PATH_CAPS__HBR2_DISABLE: ext_display_path_cap_def =
    1;
pub const ext_display_path_cap_def_EXT_DISPLAY_PATH_CAPS__DP_FIXED_VS_EN: ext_display_path_cap_def =
    2;
pub const ext_display_path_cap_def_EXT_DISPLAY_PATH_CAPS__EXT_CHIP_MASK: ext_display_path_cap_def =
    124;
pub const ext_display_path_cap_def_EXT_DISPLAY_PATH_CAPS__HDMI20_PI3EQX1204:
    ext_display_path_cap_def = 4;
pub const ext_display_path_cap_def_EXT_DISPLAY_PATH_CAPS__HDMI20_TISN65DP159RSBT:
    ext_display_path_cap_def = 8;
pub const ext_display_path_cap_def_EXT_DISPLAY_PATH_CAPS__HDMI20_PARADE_PS175:
    ext_display_path_cap_def = 12;
pub type ext_display_path_cap_def = ::core::ffi::c_uint;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct atom_external_display_connection_info {
    pub table_header: atom_common_table_header,
    pub guid: [u8; 16usize],
    pub path: [atom_ext_display_path; 7usize],
    pub checksum: u8,
    pub stereopinid: u8,
    pub remotedisplayconfig: u8,
    pub edptolvdsrxid: u8,
    pub fixdpvoltageswing: u8,
    pub reserved: [u8; 3usize],
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of atom_external_display_connection_info"]
        [::core::mem::size_of::<atom_external_display_connection_info>() - 140usize];
    ["Alignment of atom_external_display_connection_info"]
        [::core::mem::align_of::<atom_external_display_connection_info>() - 1usize];
    ["Offset of field: atom_external_display_connection_info::table_header"]
        [::core::mem::offset_of!(atom_external_display_connection_info, table_header) - 0usize];
    ["Offset of field: atom_external_display_connection_info::guid"]
        [::core::mem::offset_of!(atom_external_display_connection_info, guid) - 4usize];
    ["Offset of field: atom_external_display_connection_info::path"]
        [::core::mem::offset_of!(atom_external_display_connection_info, path) - 20usize];
    ["Offset of field: atom_external_display_connection_info::checksum"]
        [::core::mem::offset_of!(atom_external_display_connection_info, checksum) - 132usize];
    ["Offset of field: atom_external_display_connection_info::stereopinid"]
        [::core::mem::offset_of!(atom_external_display_connection_info, stereopinid) - 133usize];
    ["Offset of field: atom_external_display_connection_info::remotedisplayconfig"][::core::mem::offset_of!(
        atom_external_display_connection_info,
        remotedisplayconfig
    ) - 134usize];
    ["Offset of field: atom_external_display_connection_info::edptolvdsrxid"]
        [::core::mem::offset_of!(atom_external_display_connection_info, edptolvdsrxid) - 135usize];
    ["Offset of field: atom_external_display_connection_info::fixdpvoltageswing"][::core::mem::offset_of!(
        atom_external_display_connection_info,
        fixdpvoltageswing
    ) - 136usize];
    ["Offset of field: atom_external_display_connection_info::reserved"]
        [::core::mem::offset_of!(atom_external_display_connection_info, reserved) - 137usize];
};
#[repr(C, packed)]
#[derive(Debug, Copy, Clone)]
pub struct atom_camera_dphy_timing_param {
    pub profile_id: u8,
    pub param: u32,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of atom_camera_dphy_timing_param"]
        [::core::mem::size_of::<atom_camera_dphy_timing_param>() - 5usize];
    ["Alignment of atom_camera_dphy_timing_param"]
        [::core::mem::align_of::<atom_camera_dphy_timing_param>() - 1usize];
    ["Offset of field: atom_camera_dphy_timing_param::profile_id"]
        [::core::mem::offset_of!(atom_camera_dphy_timing_param, profile_id) - 0usize];
    ["Offset of field: atom_camera_dphy_timing_param::param"]
        [::core::mem::offset_of!(atom_camera_dphy_timing_param, param) - 1usize];
};
#[repr(C, packed)]
#[derive(Debug, Copy, Clone)]
pub struct atom_camera_dphy_elec_param {
    pub param: [u16; 3usize],
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of atom_camera_dphy_elec_param"]
        [::core::mem::size_of::<atom_camera_dphy_elec_param>() - 6usize];
    ["Alignment of atom_camera_dphy_elec_param"]
        [::core::mem::align_of::<atom_camera_dphy_elec_param>() - 1usize];
    ["Offset of field: atom_camera_dphy_elec_param::param"]
        [::core::mem::offset_of!(atom_camera_dphy_elec_param, param) - 0usize];
};
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct atom_camera_module_info {
    pub module_id: u8,
    pub module_name: [u8; 8usize],
    pub timingparam: [atom_camera_dphy_timing_param; 6usize],
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of atom_camera_module_info"]
        [::core::mem::size_of::<atom_camera_module_info>() - 39usize];
    ["Alignment of atom_camera_module_info"]
        [::core::mem::align_of::<atom_camera_module_info>() - 1usize];
    ["Offset of field: atom_camera_module_info::module_id"]
        [::core::mem::offset_of!(atom_camera_module_info, module_id) - 0usize];
    ["Offset of field: atom_camera_module_info::module_name"]
        [::core::mem::offset_of!(atom_camera_module_info, module_name) - 1usize];
    ["Offset of field: atom_camera_module_info::timingparam"]
        [::core::mem::offset_of!(atom_camera_module_info, timingparam) - 9usize];
};
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct atom_camera_flashlight_info {
    pub flashlight_id: u8,
    pub name: [u8; 8usize],
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of atom_camera_flashlight_info"]
        [::core::mem::size_of::<atom_camera_flashlight_info>() - 9usize];
    ["Alignment of atom_camera_flashlight_info"]
        [::core::mem::align_of::<atom_camera_flashlight_info>() - 1usize];
    ["Offset of field: atom_camera_flashlight_info::flashlight_id"]
        [::core::mem::offset_of!(atom_camera_flashlight_info, flashlight_id) - 0usize];
    ["Offset of field: atom_camera_flashlight_info::name"]
        [::core::mem::offset_of!(atom_camera_flashlight_info, name) - 1usize];
};
#[repr(C, packed)]
#[derive(Debug, Copy, Clone)]
pub struct atom_camera_data {
    pub versionCode: u32,
    pub cameraInfo: [atom_camera_module_info; 3usize],
    pub flashInfo: atom_camera_flashlight_info,
    pub dphy_param: atom_camera_dphy_elec_param,
    pub crc_val: u32,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of atom_camera_data"][::core::mem::size_of::<atom_camera_data>() - 140usize];
    ["Alignment of atom_camera_data"][::core::mem::align_of::<atom_camera_data>() - 1usize];
    ["Offset of field: atom_camera_data::versionCode"]
        [::core::mem::offset_of!(atom_camera_data, versionCode) - 0usize];
    ["Offset of field: atom_camera_data::cameraInfo"]
        [::core::mem::offset_of!(atom_camera_data, cameraInfo) - 4usize];
    ["Offset of field: atom_camera_data::flashInfo"]
        [::core::mem::offset_of!(atom_camera_data, flashInfo) - 121usize];
    ["Offset of field: atom_camera_data::dphy_param"]
        [::core::mem::offset_of!(atom_camera_data, dphy_param) - 130usize];
    ["Offset of field: atom_camera_data::crc_val"]
        [::core::mem::offset_of!(atom_camera_data, crc_val) - 136usize];
};
#[repr(C, packed)]
#[derive(Debug, Copy, Clone)]
pub struct atom_14nm_dpphy_dvihdmi_tuningset {
    pub max_symclk_in10khz: u32,
    pub encoder_mode: u8,
    pub phy_sel: u8,
    pub margindeemph: u16,
    pub deemph_6db_4: u8,
    pub boostadj: u8,
    pub tx_driver_fifty_ohms: u8,
    pub deemph_sel: u8,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of atom_14nm_dpphy_dvihdmi_tuningset"]
        [::core::mem::size_of::<atom_14nm_dpphy_dvihdmi_tuningset>() - 12usize];
    ["Alignment of atom_14nm_dpphy_dvihdmi_tuningset"]
        [::core::mem::align_of::<atom_14nm_dpphy_dvihdmi_tuningset>() - 1usize];
    ["Offset of field: atom_14nm_dpphy_dvihdmi_tuningset::max_symclk_in10khz"]
        [::core::mem::offset_of!(atom_14nm_dpphy_dvihdmi_tuningset, max_symclk_in10khz) - 0usize];
    ["Offset of field: atom_14nm_dpphy_dvihdmi_tuningset::encoder_mode"]
        [::core::mem::offset_of!(atom_14nm_dpphy_dvihdmi_tuningset, encoder_mode) - 4usize];
    ["Offset of field: atom_14nm_dpphy_dvihdmi_tuningset::phy_sel"]
        [::core::mem::offset_of!(atom_14nm_dpphy_dvihdmi_tuningset, phy_sel) - 5usize];
    ["Offset of field: atom_14nm_dpphy_dvihdmi_tuningset::margindeemph"]
        [::core::mem::offset_of!(atom_14nm_dpphy_dvihdmi_tuningset, margindeemph) - 6usize];
    ["Offset of field: atom_14nm_dpphy_dvihdmi_tuningset::deemph_6db_4"]
        [::core::mem::offset_of!(atom_14nm_dpphy_dvihdmi_tuningset, deemph_6db_4) - 8usize];
    ["Offset of field: atom_14nm_dpphy_dvihdmi_tuningset::boostadj"]
        [::core::mem::offset_of!(atom_14nm_dpphy_dvihdmi_tuningset, boostadj) - 9usize];
    ["Offset of field: atom_14nm_dpphy_dvihdmi_tuningset::tx_driver_fifty_ohms"][::core::mem::offset_of!(
        atom_14nm_dpphy_dvihdmi_tuningset,
        tx_driver_fifty_ohms
    ) - 10usize];
    ["Offset of field: atom_14nm_dpphy_dvihdmi_tuningset::deemph_sel"]
        [::core::mem::offset_of!(atom_14nm_dpphy_dvihdmi_tuningset, deemph_sel) - 11usize];
};
#[repr(C, packed)]
#[derive(Debug, Copy, Clone)]
pub struct atom_14nm_dpphy_dp_setting {
    pub dp_vs_pemph_level: u8,
    pub margindeemph: u16,
    pub deemph_6db_4: u8,
    pub boostadj: u8,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of atom_14nm_dpphy_dp_setting"]
        [::core::mem::size_of::<atom_14nm_dpphy_dp_setting>() - 5usize];
    ["Alignment of atom_14nm_dpphy_dp_setting"]
        [::core::mem::align_of::<atom_14nm_dpphy_dp_setting>() - 1usize];
    ["Offset of field: atom_14nm_dpphy_dp_setting::dp_vs_pemph_level"]
        [::core::mem::offset_of!(atom_14nm_dpphy_dp_setting, dp_vs_pemph_level) - 0usize];
    ["Offset of field: atom_14nm_dpphy_dp_setting::margindeemph"]
        [::core::mem::offset_of!(atom_14nm_dpphy_dp_setting, margindeemph) - 1usize];
    ["Offset of field: atom_14nm_dpphy_dp_setting::deemph_6db_4"]
        [::core::mem::offset_of!(atom_14nm_dpphy_dp_setting, deemph_6db_4) - 3usize];
    ["Offset of field: atom_14nm_dpphy_dp_setting::boostadj"]
        [::core::mem::offset_of!(atom_14nm_dpphy_dp_setting, boostadj) - 4usize];
};
#[repr(C, packed)]
#[derive(Debug, Copy, Clone)]
pub struct atom_14nm_dpphy_dp_tuningset {
    pub phy_sel: u8,
    pub version: u8,
    pub table_size: u16,
    pub reserved: u16,
    pub dptuning: [atom_14nm_dpphy_dp_setting; 10usize],
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of atom_14nm_dpphy_dp_tuningset"]
        [::core::mem::size_of::<atom_14nm_dpphy_dp_tuningset>() - 56usize];
    ["Alignment of atom_14nm_dpphy_dp_tuningset"]
        [::core::mem::align_of::<atom_14nm_dpphy_dp_tuningset>() - 1usize];
    ["Offset of field: atom_14nm_dpphy_dp_tuningset::phy_sel"]
        [::core::mem::offset_of!(atom_14nm_dpphy_dp_tuningset, phy_sel) - 0usize];
    ["Offset of field: atom_14nm_dpphy_dp_tuningset::version"]
        [::core::mem::offset_of!(atom_14nm_dpphy_dp_tuningset, version) - 1usize];
    ["Offset of field: atom_14nm_dpphy_dp_tuningset::table_size"]
        [::core::mem::offset_of!(atom_14nm_dpphy_dp_tuningset, table_size) - 2usize];
    ["Offset of field: atom_14nm_dpphy_dp_tuningset::reserved"]
        [::core::mem::offset_of!(atom_14nm_dpphy_dp_tuningset, reserved) - 4usize];
    ["Offset of field: atom_14nm_dpphy_dp_tuningset::dptuning"]
        [::core::mem::offset_of!(atom_14nm_dpphy_dp_tuningset, dptuning) - 6usize];
};
#[repr(C, packed)]
#[derive(Debug, Copy, Clone)]
pub struct atom_14nm_dig_transmitter_info_header_v4_0 {
    pub table_header: atom_common_table_header,
    pub pcie_phy_tmds_hdmi_macro_settings_offset: u16,
    pub uniphy_vs_emph_lookup_table_offset: u16,
    pub uniphy_xbar_settings_table_offset: u16,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of atom_14nm_dig_transmitter_info_header_v4_0"]
        [::core::mem::size_of::<atom_14nm_dig_transmitter_info_header_v4_0>() - 10usize];
    ["Alignment of atom_14nm_dig_transmitter_info_header_v4_0"]
        [::core::mem::align_of::<atom_14nm_dig_transmitter_info_header_v4_0>() - 1usize];
    ["Offset of field: atom_14nm_dig_transmitter_info_header_v4_0::table_header"][::core::mem::offset_of!(
        atom_14nm_dig_transmitter_info_header_v4_0,
        table_header
    ) - 0usize];
    ["Offset of field: atom_14nm_dig_transmitter_info_header_v4_0::pcie_phy_tmds_hdmi_macro_settings_offset"] [:: core :: mem :: offset_of ! (atom_14nm_dig_transmitter_info_header_v4_0 , pcie_phy_tmds_hdmi_macro_settings_offset) - 4usize] ;
    ["Offset of field: atom_14nm_dig_transmitter_info_header_v4_0::uniphy_vs_emph_lookup_table_offset"] [:: core :: mem :: offset_of ! (atom_14nm_dig_transmitter_info_header_v4_0 , uniphy_vs_emph_lookup_table_offset) - 6usize] ;
    ["Offset of field: atom_14nm_dig_transmitter_info_header_v4_0::uniphy_xbar_settings_table_offset"] [:: core :: mem :: offset_of ! (atom_14nm_dig_transmitter_info_header_v4_0 , uniphy_xbar_settings_table_offset) - 8usize] ;
};
#[repr(C, packed)]
#[derive(Debug, Copy, Clone)]
pub struct atom_14nm_combphy_tmds_vs_set {
    pub sym_clk: u8,
    pub dig_mode: u8,
    pub phy_sel: u8,
    pub common_mar_deemph_nom__margin_deemph_val: u16,
    pub common_seldeemph60__deemph_6db_4_val: u8,
    pub cmd_bus_global_for_tx_lane0__boostadj_val: u8,
    pub common_zcalcode_ctrl__tx_driver_fifty_ohms_val: u8,
    pub margin_deemph_lane0__deemph_sel_val: u8,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of atom_14nm_combphy_tmds_vs_set"]
        [::core::mem::size_of::<atom_14nm_combphy_tmds_vs_set>() - 9usize];
    ["Alignment of atom_14nm_combphy_tmds_vs_set"]
        [::core::mem::align_of::<atom_14nm_combphy_tmds_vs_set>() - 1usize];
    ["Offset of field: atom_14nm_combphy_tmds_vs_set::sym_clk"]
        [::core::mem::offset_of!(atom_14nm_combphy_tmds_vs_set, sym_clk) - 0usize];
    ["Offset of field: atom_14nm_combphy_tmds_vs_set::dig_mode"]
        [::core::mem::offset_of!(atom_14nm_combphy_tmds_vs_set, dig_mode) - 1usize];
    ["Offset of field: atom_14nm_combphy_tmds_vs_set::phy_sel"]
        [::core::mem::offset_of!(atom_14nm_combphy_tmds_vs_set, phy_sel) - 2usize];
    ["Offset of field: atom_14nm_combphy_tmds_vs_set::common_mar_deemph_nom__margin_deemph_val"][::core::mem::offset_of!(
        atom_14nm_combphy_tmds_vs_set,
        common_mar_deemph_nom__margin_deemph_val
    )
        - 3usize];
    ["Offset of field: atom_14nm_combphy_tmds_vs_set::common_seldeemph60__deemph_6db_4_val"][::core::mem::offset_of!(
        atom_14nm_combphy_tmds_vs_set,
        common_seldeemph60__deemph_6db_4_val
    )
        - 5usize];
    ["Offset of field: atom_14nm_combphy_tmds_vs_set::cmd_bus_global_for_tx_lane0__boostadj_val"][::core::mem::offset_of!(
        atom_14nm_combphy_tmds_vs_set,
        cmd_bus_global_for_tx_lane0__boostadj_val
    )
        - 6usize];
    ["Offset of field: atom_14nm_combphy_tmds_vs_set::common_zcalcode_ctrl__tx_driver_fifty_ohms_val"] [:: core :: mem :: offset_of ! (atom_14nm_combphy_tmds_vs_set , common_zcalcode_ctrl__tx_driver_fifty_ohms_val) - 7usize] ;
    ["Offset of field: atom_14nm_combphy_tmds_vs_set::margin_deemph_lane0__deemph_sel_val"][::core::mem::offset_of!(
        atom_14nm_combphy_tmds_vs_set,
        margin_deemph_lane0__deemph_sel_val
    )
        - 8usize];
};
#[repr(C, packed)]
#[derive(Debug, Copy, Clone)]
pub struct atom_DCN_dpphy_dvihdmi_tuningset {
    pub max_symclk_in10khz: u32,
    pub encoder_mode: u8,
    pub phy_sel: u8,
    pub tx_eq_main: u8,
    pub tx_eq_pre: u8,
    pub tx_eq_post: u8,
    pub reserved1: u8,
    pub tx_vboost_lvl: u8,
    pub reserved2: u8,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of atom_DCN_dpphy_dvihdmi_tuningset"]
        [::core::mem::size_of::<atom_DCN_dpphy_dvihdmi_tuningset>() - 12usize];
    ["Alignment of atom_DCN_dpphy_dvihdmi_tuningset"]
        [::core::mem::align_of::<atom_DCN_dpphy_dvihdmi_tuningset>() - 1usize];
    ["Offset of field: atom_DCN_dpphy_dvihdmi_tuningset::max_symclk_in10khz"]
        [::core::mem::offset_of!(atom_DCN_dpphy_dvihdmi_tuningset, max_symclk_in10khz) - 0usize];
    ["Offset of field: atom_DCN_dpphy_dvihdmi_tuningset::encoder_mode"]
        [::core::mem::offset_of!(atom_DCN_dpphy_dvihdmi_tuningset, encoder_mode) - 4usize];
    ["Offset of field: atom_DCN_dpphy_dvihdmi_tuningset::phy_sel"]
        [::core::mem::offset_of!(atom_DCN_dpphy_dvihdmi_tuningset, phy_sel) - 5usize];
    ["Offset of field: atom_DCN_dpphy_dvihdmi_tuningset::tx_eq_main"]
        [::core::mem::offset_of!(atom_DCN_dpphy_dvihdmi_tuningset, tx_eq_main) - 6usize];
    ["Offset of field: atom_DCN_dpphy_dvihdmi_tuningset::tx_eq_pre"]
        [::core::mem::offset_of!(atom_DCN_dpphy_dvihdmi_tuningset, tx_eq_pre) - 7usize];
    ["Offset of field: atom_DCN_dpphy_dvihdmi_tuningset::tx_eq_post"]
        [::core::mem::offset_of!(atom_DCN_dpphy_dvihdmi_tuningset, tx_eq_post) - 8usize];
    ["Offset of field: atom_DCN_dpphy_dvihdmi_tuningset::reserved1"]
        [::core::mem::offset_of!(atom_DCN_dpphy_dvihdmi_tuningset, reserved1) - 9usize];
    ["Offset of field: atom_DCN_dpphy_dvihdmi_tuningset::tx_vboost_lvl"]
        [::core::mem::offset_of!(atom_DCN_dpphy_dvihdmi_tuningset, tx_vboost_lvl) - 10usize];
    ["Offset of field: atom_DCN_dpphy_dvihdmi_tuningset::reserved2"]
        [::core::mem::offset_of!(atom_DCN_dpphy_dvihdmi_tuningset, reserved2) - 11usize];
};
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct atom_DCN_dpphy_dp_setting {
    pub dp_vs_pemph_level: u8,
    pub tx_eq_main: u8,
    pub tx_eq_pre: u8,
    pub tx_eq_post: u8,
    pub tx_vboost_lvl: u8,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of atom_DCN_dpphy_dp_setting"]
        [::core::mem::size_of::<atom_DCN_dpphy_dp_setting>() - 5usize];
    ["Alignment of atom_DCN_dpphy_dp_setting"]
        [::core::mem::align_of::<atom_DCN_dpphy_dp_setting>() - 1usize];
    ["Offset of field: atom_DCN_dpphy_dp_setting::dp_vs_pemph_level"]
        [::core::mem::offset_of!(atom_DCN_dpphy_dp_setting, dp_vs_pemph_level) - 0usize];
    ["Offset of field: atom_DCN_dpphy_dp_setting::tx_eq_main"]
        [::core::mem::offset_of!(atom_DCN_dpphy_dp_setting, tx_eq_main) - 1usize];
    ["Offset of field: atom_DCN_dpphy_dp_setting::tx_eq_pre"]
        [::core::mem::offset_of!(atom_DCN_dpphy_dp_setting, tx_eq_pre) - 2usize];
    ["Offset of field: atom_DCN_dpphy_dp_setting::tx_eq_post"]
        [::core::mem::offset_of!(atom_DCN_dpphy_dp_setting, tx_eq_post) - 3usize];
    ["Offset of field: atom_DCN_dpphy_dp_setting::tx_vboost_lvl"]
        [::core::mem::offset_of!(atom_DCN_dpphy_dp_setting, tx_vboost_lvl) - 4usize];
};
#[repr(C, packed)]
#[derive(Debug, Copy, Clone)]
pub struct atom_DCN_dpphy_dp_tuningset {
    pub phy_sel: u8,
    pub version: u8,
    pub table_size: u16,
    pub reserved: u16,
    pub dptunings: [atom_DCN_dpphy_dp_setting; 10usize],
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of atom_DCN_dpphy_dp_tuningset"]
        [::core::mem::size_of::<atom_DCN_dpphy_dp_tuningset>() - 56usize];
    ["Alignment of atom_DCN_dpphy_dp_tuningset"]
        [::core::mem::align_of::<atom_DCN_dpphy_dp_tuningset>() - 1usize];
    ["Offset of field: atom_DCN_dpphy_dp_tuningset::phy_sel"]
        [::core::mem::offset_of!(atom_DCN_dpphy_dp_tuningset, phy_sel) - 0usize];
    ["Offset of field: atom_DCN_dpphy_dp_tuningset::version"]
        [::core::mem::offset_of!(atom_DCN_dpphy_dp_tuningset, version) - 1usize];
    ["Offset of field: atom_DCN_dpphy_dp_tuningset::table_size"]
        [::core::mem::offset_of!(atom_DCN_dpphy_dp_tuningset, table_size) - 2usize];
    ["Offset of field: atom_DCN_dpphy_dp_tuningset::reserved"]
        [::core::mem::offset_of!(atom_DCN_dpphy_dp_tuningset, reserved) - 4usize];
    ["Offset of field: atom_DCN_dpphy_dp_tuningset::dptunings"]
        [::core::mem::offset_of!(atom_DCN_dpphy_dp_tuningset, dptunings) - 6usize];
};
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct atom_i2c_reg_info {
    pub ucI2cRegIndex: u8,
    pub ucI2cRegVal: u8,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of atom_i2c_reg_info"][::core::mem::size_of::<atom_i2c_reg_info>() - 2usize];
    ["Alignment of atom_i2c_reg_info"][::core::mem::align_of::<atom_i2c_reg_info>() - 1usize];
    ["Offset of field: atom_i2c_reg_info::ucI2cRegIndex"]
        [::core::mem::offset_of!(atom_i2c_reg_info, ucI2cRegIndex) - 0usize];
    ["Offset of field: atom_i2c_reg_info::ucI2cRegVal"]
        [::core::mem::offset_of!(atom_i2c_reg_info, ucI2cRegVal) - 1usize];
};
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct atom_hdmi_retimer_redriver_set {
    pub HdmiSlvAddr: u8,
    pub HdmiRegNum: u8,
    pub Hdmi6GRegNum: u8,
    pub HdmiRegSetting: [atom_i2c_reg_info; 9usize],
    pub Hdmi6GhzRegSetting: [atom_i2c_reg_info; 3usize],
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of atom_hdmi_retimer_redriver_set"]
        [::core::mem::size_of::<atom_hdmi_retimer_redriver_set>() - 27usize];
    ["Alignment of atom_hdmi_retimer_redriver_set"]
        [::core::mem::align_of::<atom_hdmi_retimer_redriver_set>() - 1usize];
    ["Offset of field: atom_hdmi_retimer_redriver_set::HdmiSlvAddr"]
        [::core::mem::offset_of!(atom_hdmi_retimer_redriver_set, HdmiSlvAddr) - 0usize];
    ["Offset of field: atom_hdmi_retimer_redriver_set::HdmiRegNum"]
        [::core::mem::offset_of!(atom_hdmi_retimer_redriver_set, HdmiRegNum) - 1usize];
    ["Offset of field: atom_hdmi_retimer_redriver_set::Hdmi6GRegNum"]
        [::core::mem::offset_of!(atom_hdmi_retimer_redriver_set, Hdmi6GRegNum) - 2usize];
    ["Offset of field: atom_hdmi_retimer_redriver_set::HdmiRegSetting"]
        [::core::mem::offset_of!(atom_hdmi_retimer_redriver_set, HdmiRegSetting) - 3usize];
    ["Offset of field: atom_hdmi_retimer_redriver_set::Hdmi6GhzRegSetting"]
        [::core::mem::offset_of!(atom_hdmi_retimer_redriver_set, Hdmi6GhzRegSetting) - 21usize];
};
#[repr(C, packed)]
#[derive(Debug, Copy, Clone)]
pub struct atom_integrated_system_info_v1_11 {
    pub table_header: atom_common_table_header,
    pub vbios_misc: u32,
    pub gpucapinfo: u32,
    pub system_config: u32,
    pub cpucapinfo: u32,
    pub gpuclk_ss_percentage: u16,
    pub gpuclk_ss_type: u16,
    pub lvds_ss_percentage: u16,
    pub lvds_ss_rate_10hz: u16,
    pub hdmi_ss_percentage: u16,
    pub hdmi_ss_rate_10hz: u16,
    pub dvi_ss_percentage: u16,
    pub dvi_ss_rate_10hz: u16,
    pub dpphy_override: u16,
    pub lvds_misc: u16,
    pub backlight_pwm_hz: u16,
    pub memorytype: u8,
    pub umachannelnumber: u8,
    pub pwr_on_digon_to_de: u8,
    pub pwr_on_de_to_vary_bl: u8,
    pub pwr_down_vary_bloff_to_de: u8,
    pub pwr_down_de_to_digoff: u8,
    pub pwr_off_delay: u8,
    pub pwr_on_vary_bl_to_blon: u8,
    pub pwr_down_bloff_to_vary_bloff: u8,
    pub min_allowed_bl_level: u8,
    pub htc_hyst_limit: u8,
    pub htc_tmp_limit: u8,
    pub reserved1: u8,
    pub reserved2: u8,
    pub extdispconninfo: atom_external_display_connection_info,
    pub dvi_tuningset: atom_14nm_dpphy_dvihdmi_tuningset,
    pub hdmi_tuningset: atom_14nm_dpphy_dvihdmi_tuningset,
    pub hdmi6g_tuningset: atom_14nm_dpphy_dvihdmi_tuningset,
    pub dp_tuningset: atom_14nm_dpphy_dp_tuningset,
    pub dp_hbr3_tuningset: atom_14nm_dpphy_dp_tuningset,
    pub camera_info: atom_camera_data,
    pub dp0_retimer_set: atom_hdmi_retimer_redriver_set,
    pub dp1_retimer_set: atom_hdmi_retimer_redriver_set,
    pub dp2_retimer_set: atom_hdmi_retimer_redriver_set,
    pub dp3_retimer_set: atom_hdmi_retimer_redriver_set,
    pub dp_hbr_tuningset: atom_14nm_dpphy_dp_tuningset,
    pub dp_hbr2_tuningset: atom_14nm_dpphy_dp_tuningset,
    pub edp_tuningset: atom_14nm_dpphy_dp_tuningset,
    pub reserved: [u32; 66usize],
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of atom_integrated_system_info_v1_11"]
        [::core::mem::size_of::<atom_integrated_system_info_v1_11>() - 1024usize];
    ["Alignment of atom_integrated_system_info_v1_11"]
        [::core::mem::align_of::<atom_integrated_system_info_v1_11>() - 1usize];
    ["Offset of field: atom_integrated_system_info_v1_11::table_header"]
        [::core::mem::offset_of!(atom_integrated_system_info_v1_11, table_header) - 0usize];
    ["Offset of field: atom_integrated_system_info_v1_11::vbios_misc"]
        [::core::mem::offset_of!(atom_integrated_system_info_v1_11, vbios_misc) - 4usize];
    ["Offset of field: atom_integrated_system_info_v1_11::gpucapinfo"]
        [::core::mem::offset_of!(atom_integrated_system_info_v1_11, gpucapinfo) - 8usize];
    ["Offset of field: atom_integrated_system_info_v1_11::system_config"]
        [::core::mem::offset_of!(atom_integrated_system_info_v1_11, system_config) - 12usize];
    ["Offset of field: atom_integrated_system_info_v1_11::cpucapinfo"]
        [::core::mem::offset_of!(atom_integrated_system_info_v1_11, cpucapinfo) - 16usize];
    ["Offset of field: atom_integrated_system_info_v1_11::gpuclk_ss_percentage"][::core::mem::offset_of!(
        atom_integrated_system_info_v1_11,
        gpuclk_ss_percentage
    ) - 20usize];
    ["Offset of field: atom_integrated_system_info_v1_11::gpuclk_ss_type"]
        [::core::mem::offset_of!(atom_integrated_system_info_v1_11, gpuclk_ss_type) - 22usize];
    ["Offset of field: atom_integrated_system_info_v1_11::lvds_ss_percentage"]
        [::core::mem::offset_of!(atom_integrated_system_info_v1_11, lvds_ss_percentage) - 24usize];
    ["Offset of field: atom_integrated_system_info_v1_11::lvds_ss_rate_10hz"]
        [::core::mem::offset_of!(atom_integrated_system_info_v1_11, lvds_ss_rate_10hz) - 26usize];
    ["Offset of field: atom_integrated_system_info_v1_11::hdmi_ss_percentage"]
        [::core::mem::offset_of!(atom_integrated_system_info_v1_11, hdmi_ss_percentage) - 28usize];
    ["Offset of field: atom_integrated_system_info_v1_11::hdmi_ss_rate_10hz"]
        [::core::mem::offset_of!(atom_integrated_system_info_v1_11, hdmi_ss_rate_10hz) - 30usize];
    ["Offset of field: atom_integrated_system_info_v1_11::dvi_ss_percentage"]
        [::core::mem::offset_of!(atom_integrated_system_info_v1_11, dvi_ss_percentage) - 32usize];
    ["Offset of field: atom_integrated_system_info_v1_11::dvi_ss_rate_10hz"]
        [::core::mem::offset_of!(atom_integrated_system_info_v1_11, dvi_ss_rate_10hz) - 34usize];
    ["Offset of field: atom_integrated_system_info_v1_11::dpphy_override"]
        [::core::mem::offset_of!(atom_integrated_system_info_v1_11, dpphy_override) - 36usize];
    ["Offset of field: atom_integrated_system_info_v1_11::lvds_misc"]
        [::core::mem::offset_of!(atom_integrated_system_info_v1_11, lvds_misc) - 38usize];
    ["Offset of field: atom_integrated_system_info_v1_11::backlight_pwm_hz"]
        [::core::mem::offset_of!(atom_integrated_system_info_v1_11, backlight_pwm_hz) - 40usize];
    ["Offset of field: atom_integrated_system_info_v1_11::memorytype"]
        [::core::mem::offset_of!(atom_integrated_system_info_v1_11, memorytype) - 42usize];
    ["Offset of field: atom_integrated_system_info_v1_11::umachannelnumber"]
        [::core::mem::offset_of!(atom_integrated_system_info_v1_11, umachannelnumber) - 43usize];
    ["Offset of field: atom_integrated_system_info_v1_11::pwr_on_digon_to_de"]
        [::core::mem::offset_of!(atom_integrated_system_info_v1_11, pwr_on_digon_to_de) - 44usize];
    ["Offset of field: atom_integrated_system_info_v1_11::pwr_on_de_to_vary_bl"][::core::mem::offset_of!(
        atom_integrated_system_info_v1_11,
        pwr_on_de_to_vary_bl
    ) - 45usize];
    ["Offset of field: atom_integrated_system_info_v1_11::pwr_down_vary_bloff_to_de"][::core::mem::offset_of!(
        atom_integrated_system_info_v1_11,
        pwr_down_vary_bloff_to_de
    ) - 46usize];
    ["Offset of field: atom_integrated_system_info_v1_11::pwr_down_de_to_digoff"][::core::mem::offset_of!(
        atom_integrated_system_info_v1_11,
        pwr_down_de_to_digoff
    ) - 47usize];
    ["Offset of field: atom_integrated_system_info_v1_11::pwr_off_delay"]
        [::core::mem::offset_of!(atom_integrated_system_info_v1_11, pwr_off_delay) - 48usize];
    ["Offset of field: atom_integrated_system_info_v1_11::pwr_on_vary_bl_to_blon"][::core::mem::offset_of!(
        atom_integrated_system_info_v1_11,
        pwr_on_vary_bl_to_blon
    ) - 49usize];
    ["Offset of field: atom_integrated_system_info_v1_11::pwr_down_bloff_to_vary_bloff"][::core::mem::offset_of!(
        atom_integrated_system_info_v1_11,
        pwr_down_bloff_to_vary_bloff
    )
        - 50usize];
    ["Offset of field: atom_integrated_system_info_v1_11::min_allowed_bl_level"][::core::mem::offset_of!(
        atom_integrated_system_info_v1_11,
        min_allowed_bl_level
    ) - 51usize];
    ["Offset of field: atom_integrated_system_info_v1_11::htc_hyst_limit"]
        [::core::mem::offset_of!(atom_integrated_system_info_v1_11, htc_hyst_limit) - 52usize];
    ["Offset of field: atom_integrated_system_info_v1_11::htc_tmp_limit"]
        [::core::mem::offset_of!(atom_integrated_system_info_v1_11, htc_tmp_limit) - 53usize];
    ["Offset of field: atom_integrated_system_info_v1_11::reserved1"]
        [::core::mem::offset_of!(atom_integrated_system_info_v1_11, reserved1) - 54usize];
    ["Offset of field: atom_integrated_system_info_v1_11::reserved2"]
        [::core::mem::offset_of!(atom_integrated_system_info_v1_11, reserved2) - 55usize];
    ["Offset of field: atom_integrated_system_info_v1_11::extdispconninfo"]
        [::core::mem::offset_of!(atom_integrated_system_info_v1_11, extdispconninfo) - 56usize];
    ["Offset of field: atom_integrated_system_info_v1_11::dvi_tuningset"]
        [::core::mem::offset_of!(atom_integrated_system_info_v1_11, dvi_tuningset) - 196usize];
    ["Offset of field: atom_integrated_system_info_v1_11::hdmi_tuningset"]
        [::core::mem::offset_of!(atom_integrated_system_info_v1_11, hdmi_tuningset) - 208usize];
    ["Offset of field: atom_integrated_system_info_v1_11::hdmi6g_tuningset"]
        [::core::mem::offset_of!(atom_integrated_system_info_v1_11, hdmi6g_tuningset) - 220usize];
    ["Offset of field: atom_integrated_system_info_v1_11::dp_tuningset"]
        [::core::mem::offset_of!(atom_integrated_system_info_v1_11, dp_tuningset) - 232usize];
    ["Offset of field: atom_integrated_system_info_v1_11::dp_hbr3_tuningset"]
        [::core::mem::offset_of!(atom_integrated_system_info_v1_11, dp_hbr3_tuningset) - 288usize];
    ["Offset of field: atom_integrated_system_info_v1_11::camera_info"]
        [::core::mem::offset_of!(atom_integrated_system_info_v1_11, camera_info) - 344usize];
    ["Offset of field: atom_integrated_system_info_v1_11::dp0_retimer_set"]
        [::core::mem::offset_of!(atom_integrated_system_info_v1_11, dp0_retimer_set) - 484usize];
    ["Offset of field: atom_integrated_system_info_v1_11::dp1_retimer_set"]
        [::core::mem::offset_of!(atom_integrated_system_info_v1_11, dp1_retimer_set) - 511usize];
    ["Offset of field: atom_integrated_system_info_v1_11::dp2_retimer_set"]
        [::core::mem::offset_of!(atom_integrated_system_info_v1_11, dp2_retimer_set) - 538usize];
    ["Offset of field: atom_integrated_system_info_v1_11::dp3_retimer_set"]
        [::core::mem::offset_of!(atom_integrated_system_info_v1_11, dp3_retimer_set) - 565usize];
    ["Offset of field: atom_integrated_system_info_v1_11::dp_hbr_tuningset"]
        [::core::mem::offset_of!(atom_integrated_system_info_v1_11, dp_hbr_tuningset) - 592usize];
    ["Offset of field: atom_integrated_system_info_v1_11::dp_hbr2_tuningset"]
        [::core::mem::offset_of!(atom_integrated_system_info_v1_11, dp_hbr2_tuningset) - 648usize];
    ["Offset of field: atom_integrated_system_info_v1_11::edp_tuningset"]
        [::core::mem::offset_of!(atom_integrated_system_info_v1_11, edp_tuningset) - 704usize];
    ["Offset of field: atom_integrated_system_info_v1_11::reserved"]
        [::core::mem::offset_of!(atom_integrated_system_info_v1_11, reserved) - 760usize];
};
#[repr(C, packed)]
#[derive(Debug, Copy, Clone)]
pub struct atom_integrated_system_info_v1_12 {
    pub table_header: atom_common_table_header,
    pub vbios_misc: u32,
    pub gpucapinfo: u32,
    pub system_config: u32,
    pub cpucapinfo: u32,
    pub gpuclk_ss_percentage: u16,
    pub gpuclk_ss_type: u16,
    pub lvds_ss_percentage: u16,
    pub lvds_ss_rate_10hz: u16,
    pub hdmi_ss_percentage: u16,
    pub hdmi_ss_rate_10hz: u16,
    pub dvi_ss_percentage: u16,
    pub dvi_ss_rate_10hz: u16,
    pub dpphy_override: u16,
    pub lvds_misc: u16,
    pub backlight_pwm_hz: u16,
    pub memorytype: u8,
    pub umachannelnumber: u8,
    pub pwr_on_digon_to_de: u8,
    pub pwr_on_de_to_vary_bl: u8,
    pub pwr_down_vary_bloff_to_de: u8,
    pub pwr_down_de_to_digoff: u8,
    pub pwr_off_delay: u8,
    pub pwr_on_vary_bl_to_blon: u8,
    pub pwr_down_bloff_to_vary_bloff: u8,
    pub min_allowed_bl_level: u8,
    pub htc_hyst_limit: u8,
    pub htc_tmp_limit: u8,
    pub reserved1: u8,
    pub reserved2: u8,
    pub extdispconninfo: atom_external_display_connection_info,
    pub TMDS_tuningset: atom_DCN_dpphy_dvihdmi_tuningset,
    pub hdmiCLK5_tuningset: atom_DCN_dpphy_dvihdmi_tuningset,
    pub hdmiCLK8_tuningset: atom_DCN_dpphy_dvihdmi_tuningset,
    pub rbr_tuningset: atom_DCN_dpphy_dp_tuningset,
    pub hbr3_tuningset: atom_DCN_dpphy_dp_tuningset,
    pub camera_info: atom_camera_data,
    pub dp0_retimer_set: atom_hdmi_retimer_redriver_set,
    pub dp1_retimer_set: atom_hdmi_retimer_redriver_set,
    pub dp2_retimer_set: atom_hdmi_retimer_redriver_set,
    pub dp3_retimer_set: atom_hdmi_retimer_redriver_set,
    pub hbr_tuningset: atom_DCN_dpphy_dp_tuningset,
    pub hbr2_tuningset: atom_DCN_dpphy_dp_tuningset,
    pub edp_tunings: atom_DCN_dpphy_dp_tuningset,
    pub hdmiCLK6_tuningset: atom_DCN_dpphy_dvihdmi_tuningset,
    pub reserved: [u32; 63usize],
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of atom_integrated_system_info_v1_12"]
        [::core::mem::size_of::<atom_integrated_system_info_v1_12>() - 1024usize];
    ["Alignment of atom_integrated_system_info_v1_12"]
        [::core::mem::align_of::<atom_integrated_system_info_v1_12>() - 1usize];
    ["Offset of field: atom_integrated_system_info_v1_12::table_header"]
        [::core::mem::offset_of!(atom_integrated_system_info_v1_12, table_header) - 0usize];
    ["Offset of field: atom_integrated_system_info_v1_12::vbios_misc"]
        [::core::mem::offset_of!(atom_integrated_system_info_v1_12, vbios_misc) - 4usize];
    ["Offset of field: atom_integrated_system_info_v1_12::gpucapinfo"]
        [::core::mem::offset_of!(atom_integrated_system_info_v1_12, gpucapinfo) - 8usize];
    ["Offset of field: atom_integrated_system_info_v1_12::system_config"]
        [::core::mem::offset_of!(atom_integrated_system_info_v1_12, system_config) - 12usize];
    ["Offset of field: atom_integrated_system_info_v1_12::cpucapinfo"]
        [::core::mem::offset_of!(atom_integrated_system_info_v1_12, cpucapinfo) - 16usize];
    ["Offset of field: atom_integrated_system_info_v1_12::gpuclk_ss_percentage"][::core::mem::offset_of!(
        atom_integrated_system_info_v1_12,
        gpuclk_ss_percentage
    ) - 20usize];
    ["Offset of field: atom_integrated_system_info_v1_12::gpuclk_ss_type"]
        [::core::mem::offset_of!(atom_integrated_system_info_v1_12, gpuclk_ss_type) - 22usize];
    ["Offset of field: atom_integrated_system_info_v1_12::lvds_ss_percentage"]
        [::core::mem::offset_of!(atom_integrated_system_info_v1_12, lvds_ss_percentage) - 24usize];
    ["Offset of field: atom_integrated_system_info_v1_12::lvds_ss_rate_10hz"]
        [::core::mem::offset_of!(atom_integrated_system_info_v1_12, lvds_ss_rate_10hz) - 26usize];
    ["Offset of field: atom_integrated_system_info_v1_12::hdmi_ss_percentage"]
        [::core::mem::offset_of!(atom_integrated_system_info_v1_12, hdmi_ss_percentage) - 28usize];
    ["Offset of field: atom_integrated_system_info_v1_12::hdmi_ss_rate_10hz"]
        [::core::mem::offset_of!(atom_integrated_system_info_v1_12, hdmi_ss_rate_10hz) - 30usize];
    ["Offset of field: atom_integrated_system_info_v1_12::dvi_ss_percentage"]
        [::core::mem::offset_of!(atom_integrated_system_info_v1_12, dvi_ss_percentage) - 32usize];
    ["Offset of field: atom_integrated_system_info_v1_12::dvi_ss_rate_10hz"]
        [::core::mem::offset_of!(atom_integrated_system_info_v1_12, dvi_ss_rate_10hz) - 34usize];
    ["Offset of field: atom_integrated_system_info_v1_12::dpphy_override"]
        [::core::mem::offset_of!(atom_integrated_system_info_v1_12, dpphy_override) - 36usize];
    ["Offset of field: atom_integrated_system_info_v1_12::lvds_misc"]
        [::core::mem::offset_of!(atom_integrated_system_info_v1_12, lvds_misc) - 38usize];
    ["Offset of field: atom_integrated_system_info_v1_12::backlight_pwm_hz"]
        [::core::mem::offset_of!(atom_integrated_system_info_v1_12, backlight_pwm_hz) - 40usize];
    ["Offset of field: atom_integrated_system_info_v1_12::memorytype"]
        [::core::mem::offset_of!(atom_integrated_system_info_v1_12, memorytype) - 42usize];
    ["Offset of field: atom_integrated_system_info_v1_12::umachannelnumber"]
        [::core::mem::offset_of!(atom_integrated_system_info_v1_12, umachannelnumber) - 43usize];
    ["Offset of field: atom_integrated_system_info_v1_12::pwr_on_digon_to_de"]
        [::core::mem::offset_of!(atom_integrated_system_info_v1_12, pwr_on_digon_to_de) - 44usize];
    ["Offset of field: atom_integrated_system_info_v1_12::pwr_on_de_to_vary_bl"][::core::mem::offset_of!(
        atom_integrated_system_info_v1_12,
        pwr_on_de_to_vary_bl
    ) - 45usize];
    ["Offset of field: atom_integrated_system_info_v1_12::pwr_down_vary_bloff_to_de"][::core::mem::offset_of!(
        atom_integrated_system_info_v1_12,
        pwr_down_vary_bloff_to_de
    ) - 46usize];
    ["Offset of field: atom_integrated_system_info_v1_12::pwr_down_de_to_digoff"][::core::mem::offset_of!(
        atom_integrated_system_info_v1_12,
        pwr_down_de_to_digoff
    ) - 47usize];
    ["Offset of field: atom_integrated_system_info_v1_12::pwr_off_delay"]
        [::core::mem::offset_of!(atom_integrated_system_info_v1_12, pwr_off_delay) - 48usize];
    ["Offset of field: atom_integrated_system_info_v1_12::pwr_on_vary_bl_to_blon"][::core::mem::offset_of!(
        atom_integrated_system_info_v1_12,
        pwr_on_vary_bl_to_blon
    ) - 49usize];
    ["Offset of field: atom_integrated_system_info_v1_12::pwr_down_bloff_to_vary_bloff"][::core::mem::offset_of!(
        atom_integrated_system_info_v1_12,
        pwr_down_bloff_to_vary_bloff
    )
        - 50usize];
    ["Offset of field: atom_integrated_system_info_v1_12::min_allowed_bl_level"][::core::mem::offset_of!(
        atom_integrated_system_info_v1_12,
        min_allowed_bl_level
    ) - 51usize];
    ["Offset of field: atom_integrated_system_info_v1_12::htc_hyst_limit"]
        [::core::mem::offset_of!(atom_integrated_system_info_v1_12, htc_hyst_limit) - 52usize];
    ["Offset of field: atom_integrated_system_info_v1_12::htc_tmp_limit"]
        [::core::mem::offset_of!(atom_integrated_system_info_v1_12, htc_tmp_limit) - 53usize];
    ["Offset of field: atom_integrated_system_info_v1_12::reserved1"]
        [::core::mem::offset_of!(atom_integrated_system_info_v1_12, reserved1) - 54usize];
    ["Offset of field: atom_integrated_system_info_v1_12::reserved2"]
        [::core::mem::offset_of!(atom_integrated_system_info_v1_12, reserved2) - 55usize];
    ["Offset of field: atom_integrated_system_info_v1_12::extdispconninfo"]
        [::core::mem::offset_of!(atom_integrated_system_info_v1_12, extdispconninfo) - 56usize];
    ["Offset of field: atom_integrated_system_info_v1_12::TMDS_tuningset"]
        [::core::mem::offset_of!(atom_integrated_system_info_v1_12, TMDS_tuningset) - 196usize];
    ["Offset of field: atom_integrated_system_info_v1_12::hdmiCLK5_tuningset"]
        [::core::mem::offset_of!(atom_integrated_system_info_v1_12, hdmiCLK5_tuningset) - 208usize];
    ["Offset of field: atom_integrated_system_info_v1_12::hdmiCLK8_tuningset"]
        [::core::mem::offset_of!(atom_integrated_system_info_v1_12, hdmiCLK8_tuningset) - 220usize];
    ["Offset of field: atom_integrated_system_info_v1_12::rbr_tuningset"]
        [::core::mem::offset_of!(atom_integrated_system_info_v1_12, rbr_tuningset) - 232usize];
    ["Offset of field: atom_integrated_system_info_v1_12::hbr3_tuningset"]
        [::core::mem::offset_of!(atom_integrated_system_info_v1_12, hbr3_tuningset) - 288usize];
    ["Offset of field: atom_integrated_system_info_v1_12::camera_info"]
        [::core::mem::offset_of!(atom_integrated_system_info_v1_12, camera_info) - 344usize];
    ["Offset of field: atom_integrated_system_info_v1_12::dp0_retimer_set"]
        [::core::mem::offset_of!(atom_integrated_system_info_v1_12, dp0_retimer_set) - 484usize];
    ["Offset of field: atom_integrated_system_info_v1_12::dp1_retimer_set"]
        [::core::mem::offset_of!(atom_integrated_system_info_v1_12, dp1_retimer_set) - 511usize];
    ["Offset of field: atom_integrated_system_info_v1_12::dp2_retimer_set"]
        [::core::mem::offset_of!(atom_integrated_system_info_v1_12, dp2_retimer_set) - 538usize];
    ["Offset of field: atom_integrated_system_info_v1_12::dp3_retimer_set"]
        [::core::mem::offset_of!(atom_integrated_system_info_v1_12, dp3_retimer_set) - 565usize];
    ["Offset of field: atom_integrated_system_info_v1_12::hbr_tuningset"]
        [::core::mem::offset_of!(atom_integrated_system_info_v1_12, hbr_tuningset) - 592usize];
    ["Offset of field: atom_integrated_system_info_v1_12::hbr2_tuningset"]
        [::core::mem::offset_of!(atom_integrated_system_info_v1_12, hbr2_tuningset) - 648usize];
    ["Offset of field: atom_integrated_system_info_v1_12::edp_tunings"]
        [::core::mem::offset_of!(atom_integrated_system_info_v1_12, edp_tunings) - 704usize];
    ["Offset of field: atom_integrated_system_info_v1_12::hdmiCLK6_tuningset"]
        [::core::mem::offset_of!(atom_integrated_system_info_v1_12, hdmiCLK6_tuningset) - 760usize];
    ["Offset of field: atom_integrated_system_info_v1_12::reserved"]
        [::core::mem::offset_of!(atom_integrated_system_info_v1_12, reserved) - 772usize];
};
#[repr(C, packed)]
#[derive(Debug, Copy, Clone)]
pub struct edp_info_table {
    pub edp_backlight_pwm_hz: u16,
    pub edp_ss_percentage: u16,
    pub edp_ss_rate_10hz: u16,
    pub reserved1: u16,
    pub reserved2: u32,
    pub edp_pwr_on_off_delay: u8,
    pub edp_pwr_on_vary_bl_to_blon: u8,
    pub edp_pwr_down_bloff_to_vary_bloff: u8,
    pub edp_panel_bpc: u8,
    pub edp_bootup_bl_level: u8,
    pub reserved3: [u8; 3usize],
    pub reserved4: [u32; 3usize],
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of edp_info_table"][::core::mem::size_of::<edp_info_table>() - 32usize];
    ["Alignment of edp_info_table"][::core::mem::align_of::<edp_info_table>() - 1usize];
    ["Offset of field: edp_info_table::edp_backlight_pwm_hz"]
        [::core::mem::offset_of!(edp_info_table, edp_backlight_pwm_hz) - 0usize];
    ["Offset of field: edp_info_table::edp_ss_percentage"]
        [::core::mem::offset_of!(edp_info_table, edp_ss_percentage) - 2usize];
    ["Offset of field: edp_info_table::edp_ss_rate_10hz"]
        [::core::mem::offset_of!(edp_info_table, edp_ss_rate_10hz) - 4usize];
    ["Offset of field: edp_info_table::reserved1"]
        [::core::mem::offset_of!(edp_info_table, reserved1) - 6usize];
    ["Offset of field: edp_info_table::reserved2"]
        [::core::mem::offset_of!(edp_info_table, reserved2) - 8usize];
    ["Offset of field: edp_info_table::edp_pwr_on_off_delay"]
        [::core::mem::offset_of!(edp_info_table, edp_pwr_on_off_delay) - 12usize];
    ["Offset of field: edp_info_table::edp_pwr_on_vary_bl_to_blon"]
        [::core::mem::offset_of!(edp_info_table, edp_pwr_on_vary_bl_to_blon) - 13usize];
    ["Offset of field: edp_info_table::edp_pwr_down_bloff_to_vary_bloff"]
        [::core::mem::offset_of!(edp_info_table, edp_pwr_down_bloff_to_vary_bloff) - 14usize];
    ["Offset of field: edp_info_table::edp_panel_bpc"]
        [::core::mem::offset_of!(edp_info_table, edp_panel_bpc) - 15usize];
    ["Offset of field: edp_info_table::edp_bootup_bl_level"]
        [::core::mem::offset_of!(edp_info_table, edp_bootup_bl_level) - 16usize];
    ["Offset of field: edp_info_table::reserved3"]
        [::core::mem::offset_of!(edp_info_table, reserved3) - 17usize];
    ["Offset of field: edp_info_table::reserved4"]
        [::core::mem::offset_of!(edp_info_table, reserved4) - 20usize];
};
#[repr(C, packed)]
#[derive(Debug, Copy, Clone)]
pub struct atom_integrated_system_info_v2_1 {
    pub table_header: atom_common_table_header,
    pub vbios_misc: u32,
    pub gpucapinfo: u32,
    pub system_config: u32,
    pub cpucapinfo: u32,
    pub gpuclk_ss_percentage: u16,
    pub gpuclk_ss_type: u16,
    pub dpphy_override: u16,
    pub memorytype: u8,
    pub umachannelnumber: u8,
    pub htc_hyst_limit: u8,
    pub htc_tmp_limit: u8,
    pub reserved1: u8,
    pub reserved2: u8,
    pub edp1_info: edp_info_table,
    pub edp2_info: edp_info_table,
    pub reserved3: [u32; 8usize],
    pub extdispconninfo: atom_external_display_connection_info,
    pub TMDS_tuningset: atom_DCN_dpphy_dvihdmi_tuningset,
    pub hdmiCLK5_tuningset: atom_DCN_dpphy_dvihdmi_tuningset,
    pub hdmiCLK6_tuningset: atom_DCN_dpphy_dvihdmi_tuningset,
    pub hdmiCLK8_tuningset: atom_DCN_dpphy_dvihdmi_tuningset,
    pub reserved4: [u32; 6usize],
    pub rbr_tuningset: atom_DCN_dpphy_dp_tuningset,
    pub hbr_tuningset: atom_DCN_dpphy_dp_tuningset,
    pub hbr2_tuningset: atom_DCN_dpphy_dp_tuningset,
    pub hbr3_tuningset: atom_DCN_dpphy_dp_tuningset,
    pub edp_tunings: atom_DCN_dpphy_dp_tuningset,
    pub reserved5: [u32; 28usize],
    pub dp0_retimer_set: atom_hdmi_retimer_redriver_set,
    pub dp1_retimer_set: atom_hdmi_retimer_redriver_set,
    pub dp2_retimer_set: atom_hdmi_retimer_redriver_set,
    pub dp3_retimer_set: atom_hdmi_retimer_redriver_set,
    pub reserved6: [u32; 30usize],
    pub reserved7: [u32; 32usize],
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of atom_integrated_system_info_v2_1"]
        [::core::mem::size_of::<atom_integrated_system_info_v2_1>() - 1088usize];
    ["Alignment of atom_integrated_system_info_v2_1"]
        [::core::mem::align_of::<atom_integrated_system_info_v2_1>() - 1usize];
    ["Offset of field: atom_integrated_system_info_v2_1::table_header"]
        [::core::mem::offset_of!(atom_integrated_system_info_v2_1, table_header) - 0usize];
    ["Offset of field: atom_integrated_system_info_v2_1::vbios_misc"]
        [::core::mem::offset_of!(atom_integrated_system_info_v2_1, vbios_misc) - 4usize];
    ["Offset of field: atom_integrated_system_info_v2_1::gpucapinfo"]
        [::core::mem::offset_of!(atom_integrated_system_info_v2_1, gpucapinfo) - 8usize];
    ["Offset of field: atom_integrated_system_info_v2_1::system_config"]
        [::core::mem::offset_of!(atom_integrated_system_info_v2_1, system_config) - 12usize];
    ["Offset of field: atom_integrated_system_info_v2_1::cpucapinfo"]
        [::core::mem::offset_of!(atom_integrated_system_info_v2_1, cpucapinfo) - 16usize];
    ["Offset of field: atom_integrated_system_info_v2_1::gpuclk_ss_percentage"]
        [::core::mem::offset_of!(atom_integrated_system_info_v2_1, gpuclk_ss_percentage) - 20usize];
    ["Offset of field: atom_integrated_system_info_v2_1::gpuclk_ss_type"]
        [::core::mem::offset_of!(atom_integrated_system_info_v2_1, gpuclk_ss_type) - 22usize];
    ["Offset of field: atom_integrated_system_info_v2_1::dpphy_override"]
        [::core::mem::offset_of!(atom_integrated_system_info_v2_1, dpphy_override) - 24usize];
    ["Offset of field: atom_integrated_system_info_v2_1::memorytype"]
        [::core::mem::offset_of!(atom_integrated_system_info_v2_1, memorytype) - 26usize];
    ["Offset of field: atom_integrated_system_info_v2_1::umachannelnumber"]
        [::core::mem::offset_of!(atom_integrated_system_info_v2_1, umachannelnumber) - 27usize];
    ["Offset of field: atom_integrated_system_info_v2_1::htc_hyst_limit"]
        [::core::mem::offset_of!(atom_integrated_system_info_v2_1, htc_hyst_limit) - 28usize];
    ["Offset of field: atom_integrated_system_info_v2_1::htc_tmp_limit"]
        [::core::mem::offset_of!(atom_integrated_system_info_v2_1, htc_tmp_limit) - 29usize];
    ["Offset of field: atom_integrated_system_info_v2_1::reserved1"]
        [::core::mem::offset_of!(atom_integrated_system_info_v2_1, reserved1) - 30usize];
    ["Offset of field: atom_integrated_system_info_v2_1::reserved2"]
        [::core::mem::offset_of!(atom_integrated_system_info_v2_1, reserved2) - 31usize];
    ["Offset of field: atom_integrated_system_info_v2_1::edp1_info"]
        [::core::mem::offset_of!(atom_integrated_system_info_v2_1, edp1_info) - 32usize];
    ["Offset of field: atom_integrated_system_info_v2_1::edp2_info"]
        [::core::mem::offset_of!(atom_integrated_system_info_v2_1, edp2_info) - 64usize];
    ["Offset of field: atom_integrated_system_info_v2_1::reserved3"]
        [::core::mem::offset_of!(atom_integrated_system_info_v2_1, reserved3) - 96usize];
    ["Offset of field: atom_integrated_system_info_v2_1::extdispconninfo"]
        [::core::mem::offset_of!(atom_integrated_system_info_v2_1, extdispconninfo) - 128usize];
    ["Offset of field: atom_integrated_system_info_v2_1::TMDS_tuningset"]
        [::core::mem::offset_of!(atom_integrated_system_info_v2_1, TMDS_tuningset) - 268usize];
    ["Offset of field: atom_integrated_system_info_v2_1::hdmiCLK5_tuningset"]
        [::core::mem::offset_of!(atom_integrated_system_info_v2_1, hdmiCLK5_tuningset) - 280usize];
    ["Offset of field: atom_integrated_system_info_v2_1::hdmiCLK6_tuningset"]
        [::core::mem::offset_of!(atom_integrated_system_info_v2_1, hdmiCLK6_tuningset) - 292usize];
    ["Offset of field: atom_integrated_system_info_v2_1::hdmiCLK8_tuningset"]
        [::core::mem::offset_of!(atom_integrated_system_info_v2_1, hdmiCLK8_tuningset) - 304usize];
    ["Offset of field: atom_integrated_system_info_v2_1::reserved4"]
        [::core::mem::offset_of!(atom_integrated_system_info_v2_1, reserved4) - 316usize];
    ["Offset of field: atom_integrated_system_info_v2_1::rbr_tuningset"]
        [::core::mem::offset_of!(atom_integrated_system_info_v2_1, rbr_tuningset) - 340usize];
    ["Offset of field: atom_integrated_system_info_v2_1::hbr_tuningset"]
        [::core::mem::offset_of!(atom_integrated_system_info_v2_1, hbr_tuningset) - 396usize];
    ["Offset of field: atom_integrated_system_info_v2_1::hbr2_tuningset"]
        [::core::mem::offset_of!(atom_integrated_system_info_v2_1, hbr2_tuningset) - 452usize];
    ["Offset of field: atom_integrated_system_info_v2_1::hbr3_tuningset"]
        [::core::mem::offset_of!(atom_integrated_system_info_v2_1, hbr3_tuningset) - 508usize];
    ["Offset of field: atom_integrated_system_info_v2_1::edp_tunings"]
        [::core::mem::offset_of!(atom_integrated_system_info_v2_1, edp_tunings) - 564usize];
    ["Offset of field: atom_integrated_system_info_v2_1::reserved5"]
        [::core::mem::offset_of!(atom_integrated_system_info_v2_1, reserved5) - 620usize];
    ["Offset of field: atom_integrated_system_info_v2_1::dp0_retimer_set"]
        [::core::mem::offset_of!(atom_integrated_system_info_v2_1, dp0_retimer_set) - 732usize];
    ["Offset of field: atom_integrated_system_info_v2_1::dp1_retimer_set"]
        [::core::mem::offset_of!(atom_integrated_system_info_v2_1, dp1_retimer_set) - 759usize];
    ["Offset of field: atom_integrated_system_info_v2_1::dp2_retimer_set"]
        [::core::mem::offset_of!(atom_integrated_system_info_v2_1, dp2_retimer_set) - 786usize];
    ["Offset of field: atom_integrated_system_info_v2_1::dp3_retimer_set"]
        [::core::mem::offset_of!(atom_integrated_system_info_v2_1, dp3_retimer_set) - 813usize];
    ["Offset of field: atom_integrated_system_info_v2_1::reserved6"]
        [::core::mem::offset_of!(atom_integrated_system_info_v2_1, reserved6) - 840usize];
    ["Offset of field: atom_integrated_system_info_v2_1::reserved7"]
        [::core::mem::offset_of!(atom_integrated_system_info_v2_1, reserved7) - 960usize];
};
#[repr(C, packed)]
#[derive(Debug, Copy, Clone)]
pub struct atom_n6_display_phy_tuning_set {
    pub display_signal_type: u8,
    pub phy_sel: u8,
    pub preset_level: u8,
    pub reserved1: u8,
    pub reserved2: u32,
    pub speed_upto: u32,
    pub tx_vboost_level: u8,
    pub tx_vreg_v2i: u8,
    pub tx_vregdrv_byp: u8,
    pub tx_term_cntl: u8,
    pub tx_peak_level: u8,
    pub tx_slew_en: u8,
    pub tx_eq_pre: u8,
    pub tx_eq_main: u8,
    pub tx_eq_post: u8,
    pub tx_en_inv_pre: u8,
    pub tx_en_inv_post: u8,
    pub reserved3: u8,
    pub reserved4: u32,
    pub reserved5: u32,
    pub reserved6: u32,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of atom_n6_display_phy_tuning_set"]
        [::core::mem::size_of::<atom_n6_display_phy_tuning_set>() - 36usize];
    ["Alignment of atom_n6_display_phy_tuning_set"]
        [::core::mem::align_of::<atom_n6_display_phy_tuning_set>() - 1usize];
    ["Offset of field: atom_n6_display_phy_tuning_set::display_signal_type"]
        [::core::mem::offset_of!(atom_n6_display_phy_tuning_set, display_signal_type) - 0usize];
    ["Offset of field: atom_n6_display_phy_tuning_set::phy_sel"]
        [::core::mem::offset_of!(atom_n6_display_phy_tuning_set, phy_sel) - 1usize];
    ["Offset of field: atom_n6_display_phy_tuning_set::preset_level"]
        [::core::mem::offset_of!(atom_n6_display_phy_tuning_set, preset_level) - 2usize];
    ["Offset of field: atom_n6_display_phy_tuning_set::reserved1"]
        [::core::mem::offset_of!(atom_n6_display_phy_tuning_set, reserved1) - 3usize];
    ["Offset of field: atom_n6_display_phy_tuning_set::reserved2"]
        [::core::mem::offset_of!(atom_n6_display_phy_tuning_set, reserved2) - 4usize];
    ["Offset of field: atom_n6_display_phy_tuning_set::speed_upto"]
        [::core::mem::offset_of!(atom_n6_display_phy_tuning_set, speed_upto) - 8usize];
    ["Offset of field: atom_n6_display_phy_tuning_set::tx_vboost_level"]
        [::core::mem::offset_of!(atom_n6_display_phy_tuning_set, tx_vboost_level) - 12usize];
    ["Offset of field: atom_n6_display_phy_tuning_set::tx_vreg_v2i"]
        [::core::mem::offset_of!(atom_n6_display_phy_tuning_set, tx_vreg_v2i) - 13usize];
    ["Offset of field: atom_n6_display_phy_tuning_set::tx_vregdrv_byp"]
        [::core::mem::offset_of!(atom_n6_display_phy_tuning_set, tx_vregdrv_byp) - 14usize];
    ["Offset of field: atom_n6_display_phy_tuning_set::tx_term_cntl"]
        [::core::mem::offset_of!(atom_n6_display_phy_tuning_set, tx_term_cntl) - 15usize];
    ["Offset of field: atom_n6_display_phy_tuning_set::tx_peak_level"]
        [::core::mem::offset_of!(atom_n6_display_phy_tuning_set, tx_peak_level) - 16usize];
    ["Offset of field: atom_n6_display_phy_tuning_set::tx_slew_en"]
        [::core::mem::offset_of!(atom_n6_display_phy_tuning_set, tx_slew_en) - 17usize];
    ["Offset of field: atom_n6_display_phy_tuning_set::tx_eq_pre"]
        [::core::mem::offset_of!(atom_n6_display_phy_tuning_set, tx_eq_pre) - 18usize];
    ["Offset of field: atom_n6_display_phy_tuning_set::tx_eq_main"]
        [::core::mem::offset_of!(atom_n6_display_phy_tuning_set, tx_eq_main) - 19usize];
    ["Offset of field: atom_n6_display_phy_tuning_set::tx_eq_post"]
        [::core::mem::offset_of!(atom_n6_display_phy_tuning_set, tx_eq_post) - 20usize];
    ["Offset of field: atom_n6_display_phy_tuning_set::tx_en_inv_pre"]
        [::core::mem::offset_of!(atom_n6_display_phy_tuning_set, tx_en_inv_pre) - 21usize];
    ["Offset of field: atom_n6_display_phy_tuning_set::tx_en_inv_post"]
        [::core::mem::offset_of!(atom_n6_display_phy_tuning_set, tx_en_inv_post) - 22usize];
    ["Offset of field: atom_n6_display_phy_tuning_set::reserved3"]
        [::core::mem::offset_of!(atom_n6_display_phy_tuning_set, reserved3) - 23usize];
    ["Offset of field: atom_n6_display_phy_tuning_set::reserved4"]
        [::core::mem::offset_of!(atom_n6_display_phy_tuning_set, reserved4) - 24usize];
    ["Offset of field: atom_n6_display_phy_tuning_set::reserved5"]
        [::core::mem::offset_of!(atom_n6_display_phy_tuning_set, reserved5) - 28usize];
    ["Offset of field: atom_n6_display_phy_tuning_set::reserved6"]
        [::core::mem::offset_of!(atom_n6_display_phy_tuning_set, reserved6) - 32usize];
};
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct atom_display_phy_tuning_info {
    pub table_header: atom_common_table_header,
    pub disp_phy_tuning: [atom_n6_display_phy_tuning_set; 1usize],
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of atom_display_phy_tuning_info"]
        [::core::mem::size_of::<atom_display_phy_tuning_info>() - 40usize];
    ["Alignment of atom_display_phy_tuning_info"]
        [::core::mem::align_of::<atom_display_phy_tuning_info>() - 1usize];
    ["Offset of field: atom_display_phy_tuning_info::table_header"]
        [::core::mem::offset_of!(atom_display_phy_tuning_info, table_header) - 0usize];
    ["Offset of field: atom_display_phy_tuning_info::disp_phy_tuning"]
        [::core::mem::offset_of!(atom_display_phy_tuning_info, disp_phy_tuning) - 4usize];
};
#[repr(C, packed)]
#[derive(Debug, Copy, Clone)]
pub struct atom_integrated_system_info_v2_2 {
    pub table_header: atom_common_table_header,
    pub vbios_misc: u32,
    pub gpucapinfo: u32,
    pub system_config: u32,
    pub cpucapinfo: u32,
    pub gpuclk_ss_percentage: u16,
    pub gpuclk_ss_type: u16,
    pub dpphy_override: u16,
    pub memorytype: u8,
    pub umachannelnumber: u8,
    pub htc_hyst_limit: u8,
    pub htc_tmp_limit: u8,
    pub reserved1: u8,
    pub reserved2: u8,
    pub edp1_info: edp_info_table,
    pub edp2_info: edp_info_table,
    pub reserved3: [u32; 8usize],
    pub extdispconninfo: atom_external_display_connection_info,
    pub reserved4: [u32; 189usize],
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of atom_integrated_system_info_v2_2"]
        [::core::mem::size_of::<atom_integrated_system_info_v2_2>() - 1024usize];
    ["Alignment of atom_integrated_system_info_v2_2"]
        [::core::mem::align_of::<atom_integrated_system_info_v2_2>() - 1usize];
    ["Offset of field: atom_integrated_system_info_v2_2::table_header"]
        [::core::mem::offset_of!(atom_integrated_system_info_v2_2, table_header) - 0usize];
    ["Offset of field: atom_integrated_system_info_v2_2::vbios_misc"]
        [::core::mem::offset_of!(atom_integrated_system_info_v2_2, vbios_misc) - 4usize];
    ["Offset of field: atom_integrated_system_info_v2_2::gpucapinfo"]
        [::core::mem::offset_of!(atom_integrated_system_info_v2_2, gpucapinfo) - 8usize];
    ["Offset of field: atom_integrated_system_info_v2_2::system_config"]
        [::core::mem::offset_of!(atom_integrated_system_info_v2_2, system_config) - 12usize];
    ["Offset of field: atom_integrated_system_info_v2_2::cpucapinfo"]
        [::core::mem::offset_of!(atom_integrated_system_info_v2_2, cpucapinfo) - 16usize];
    ["Offset of field: atom_integrated_system_info_v2_2::gpuclk_ss_percentage"]
        [::core::mem::offset_of!(atom_integrated_system_info_v2_2, gpuclk_ss_percentage) - 20usize];
    ["Offset of field: atom_integrated_system_info_v2_2::gpuclk_ss_type"]
        [::core::mem::offset_of!(atom_integrated_system_info_v2_2, gpuclk_ss_type) - 22usize];
    ["Offset of field: atom_integrated_system_info_v2_2::dpphy_override"]
        [::core::mem::offset_of!(atom_integrated_system_info_v2_2, dpphy_override) - 24usize];
    ["Offset of field: atom_integrated_system_info_v2_2::memorytype"]
        [::core::mem::offset_of!(atom_integrated_system_info_v2_2, memorytype) - 26usize];
    ["Offset of field: atom_integrated_system_info_v2_2::umachannelnumber"]
        [::core::mem::offset_of!(atom_integrated_system_info_v2_2, umachannelnumber) - 27usize];
    ["Offset of field: atom_integrated_system_info_v2_2::htc_hyst_limit"]
        [::core::mem::offset_of!(atom_integrated_system_info_v2_2, htc_hyst_limit) - 28usize];
    ["Offset of field: atom_integrated_system_info_v2_2::htc_tmp_limit"]
        [::core::mem::offset_of!(atom_integrated_system_info_v2_2, htc_tmp_limit) - 29usize];
    ["Offset of field: atom_integrated_system_info_v2_2::reserved1"]
        [::core::mem::offset_of!(atom_integrated_system_info_v2_2, reserved1) - 30usize];
    ["Offset of field: atom_integrated_system_info_v2_2::reserved2"]
        [::core::mem::offset_of!(atom_integrated_system_info_v2_2, reserved2) - 31usize];
    ["Offset of field: atom_integrated_system_info_v2_2::edp1_info"]
        [::core::mem::offset_of!(atom_integrated_system_info_v2_2, edp1_info) - 32usize];
    ["Offset of field: atom_integrated_system_info_v2_2::edp2_info"]
        [::core::mem::offset_of!(atom_integrated_system_info_v2_2, edp2_info) - 64usize];
    ["Offset of field: atom_integrated_system_info_v2_2::reserved3"]
        [::core::mem::offset_of!(atom_integrated_system_info_v2_2, reserved3) - 96usize];
    ["Offset of field: atom_integrated_system_info_v2_2::extdispconninfo"]
        [::core::mem::offset_of!(atom_integrated_system_info_v2_2, extdispconninfo) - 128usize];
    ["Offset of field: atom_integrated_system_info_v2_2::reserved4"]
        [::core::mem::offset_of!(atom_integrated_system_info_v2_2, reserved4) - 268usize];
};
pub const atom_system_vbiosmisc_def_INTEGRATED_SYSTEM_INFO__GET_EDID_CALLBACK_FUNC_SUPPORT:
    atom_system_vbiosmisc_def = 1;
pub type atom_system_vbiosmisc_def = ::core::ffi::c_uint;
pub const atom_system_gpucapinf_def_SYS_INFO_GPUCAPS__ENABEL_DFS_BYPASS: atom_system_gpucapinf_def =
    16;
pub type atom_system_gpucapinf_def = ::core::ffi::c_uint;
pub const atom_sysinfo_dpphy_override_def_ATOM_ENABLE_DVI_TUNINGSET:
    atom_sysinfo_dpphy_override_def = 1;
pub const atom_sysinfo_dpphy_override_def_ATOM_ENABLE_HDMI_TUNINGSET:
    atom_sysinfo_dpphy_override_def = 2;
pub const atom_sysinfo_dpphy_override_def_ATOM_ENABLE_HDMI6G_TUNINGSET:
    atom_sysinfo_dpphy_override_def = 4;
pub const atom_sysinfo_dpphy_override_def_ATOM_ENABLE_DP_TUNINGSET:
    atom_sysinfo_dpphy_override_def = 8;
pub const atom_sysinfo_dpphy_override_def_ATOM_ENABLE_DP_HBR3_TUNINGSET:
    atom_sysinfo_dpphy_override_def = 16;
pub type atom_sysinfo_dpphy_override_def = ::core::ffi::c_uint;
pub const atom_sys_info_lvds_misc_def_SYS_INFO_LVDS_MISC_888_FPDI_MODE:
    atom_sys_info_lvds_misc_def = 1;
pub const atom_sys_info_lvds_misc_def_SYS_INFO_LVDS_MISC_888_BPC_MODE: atom_sys_info_lvds_misc_def =
    4;
pub const atom_sys_info_lvds_misc_def_SYS_INFO_LVDS_MISC_OVERRIDE_EN: atom_sys_info_lvds_misc_def =
    8;
pub type atom_sys_info_lvds_misc_def = ::core::ffi::c_uint;
#[doc = "< Assign 01 to Other"]
pub const atom_dmi_t17_mem_type_def_OtherMemType: atom_dmi_t17_mem_type_def = 1;
#[doc = "< Assign 02 to Unknown"]
pub const atom_dmi_t17_mem_type_def_UnknownMemType: atom_dmi_t17_mem_type_def = 2;
#[doc = "< Assign 03 to DRAM"]
pub const atom_dmi_t17_mem_type_def_DramMemType: atom_dmi_t17_mem_type_def = 3;
#[doc = "< Assign 04 to EDRAM"]
pub const atom_dmi_t17_mem_type_def_EdramMemType: atom_dmi_t17_mem_type_def = 4;
#[doc = "< Assign 05 to VRAM"]
pub const atom_dmi_t17_mem_type_def_VramMemType: atom_dmi_t17_mem_type_def = 5;
#[doc = "< Assign 06 to SRAM"]
pub const atom_dmi_t17_mem_type_def_SramMemType: atom_dmi_t17_mem_type_def = 6;
#[doc = "< Assign 07 to RAM"]
pub const atom_dmi_t17_mem_type_def_RamMemType: atom_dmi_t17_mem_type_def = 7;
#[doc = "< Assign 08 to ROM"]
pub const atom_dmi_t17_mem_type_def_RomMemType: atom_dmi_t17_mem_type_def = 8;
#[doc = "< Assign 09 to Flash"]
pub const atom_dmi_t17_mem_type_def_FlashMemType: atom_dmi_t17_mem_type_def = 9;
#[doc = "< Assign 10 to EEPROM"]
pub const atom_dmi_t17_mem_type_def_EepromMemType: atom_dmi_t17_mem_type_def = 10;
#[doc = "< Assign 11 to FEPROM"]
pub const atom_dmi_t17_mem_type_def_FepromMemType: atom_dmi_t17_mem_type_def = 11;
#[doc = "< Assign 12 to EPROM"]
pub const atom_dmi_t17_mem_type_def_EpromMemType: atom_dmi_t17_mem_type_def = 12;
#[doc = "< Assign 13 to CDRAM"]
pub const atom_dmi_t17_mem_type_def_CdramMemType: atom_dmi_t17_mem_type_def = 13;
#[doc = "< Assign 14 to 3DRAM"]
pub const atom_dmi_t17_mem_type_def_ThreeDramMemType: atom_dmi_t17_mem_type_def = 14;
#[doc = "< Assign 15 to SDRAM"]
pub const atom_dmi_t17_mem_type_def_SdramMemType: atom_dmi_t17_mem_type_def = 15;
#[doc = "< Assign 16 to SGRAM"]
pub const atom_dmi_t17_mem_type_def_SgramMemType: atom_dmi_t17_mem_type_def = 16;
#[doc = "< Assign 17 to RDRAM"]
pub const atom_dmi_t17_mem_type_def_RdramMemType: atom_dmi_t17_mem_type_def = 17;
#[doc = "< Assign 18 to DDR"]
pub const atom_dmi_t17_mem_type_def_DdrMemType: atom_dmi_t17_mem_type_def = 18;
#[doc = "< Assign 19 to DDR2"]
pub const atom_dmi_t17_mem_type_def_Ddr2MemType: atom_dmi_t17_mem_type_def = 19;
#[doc = "< Assign 20 to DDR2 FB-DIMM"]
pub const atom_dmi_t17_mem_type_def_Ddr2FbdimmMemType: atom_dmi_t17_mem_type_def = 20;
#[doc = "< Assign 24 to DDR3"]
pub const atom_dmi_t17_mem_type_def_Ddr3MemType: atom_dmi_t17_mem_type_def = 24;
#[doc = "< Assign 25 to FBD2"]
pub const atom_dmi_t17_mem_type_def_Fbd2MemType: atom_dmi_t17_mem_type_def = 25;
#[doc = "< Assign 26 to DDR4"]
pub const atom_dmi_t17_mem_type_def_Ddr4MemType: atom_dmi_t17_mem_type_def = 26;
#[doc = "< Assign 27 to LPDDR"]
pub const atom_dmi_t17_mem_type_def_LpDdrMemType: atom_dmi_t17_mem_type_def = 27;
#[doc = "< Assign 28 to LPDDR2"]
pub const atom_dmi_t17_mem_type_def_LpDdr2MemType: atom_dmi_t17_mem_type_def = 28;
#[doc = "< Assign 29 to LPDDR3"]
pub const atom_dmi_t17_mem_type_def_LpDdr3MemType: atom_dmi_t17_mem_type_def = 29;
#[doc = "< Assign 30 to LPDDR4"]
pub const atom_dmi_t17_mem_type_def_LpDdr4MemType: atom_dmi_t17_mem_type_def = 30;
#[doc = "< Assign 31 to GDDR6"]
pub const atom_dmi_t17_mem_type_def_GDdr6MemType: atom_dmi_t17_mem_type_def = 31;
#[doc = "< Assign 32 to HBM"]
pub const atom_dmi_t17_mem_type_def_HbmMemType: atom_dmi_t17_mem_type_def = 32;
#[doc = "< Assign 33 to HBM2"]
pub const atom_dmi_t17_mem_type_def_Hbm2MemType: atom_dmi_t17_mem_type_def = 33;
#[doc = "< Assign 34 to DDR5"]
pub const atom_dmi_t17_mem_type_def_Ddr5MemType: atom_dmi_t17_mem_type_def = 34;
#[doc = "< Assign 35 to LPDDR5"]
pub const atom_dmi_t17_mem_type_def_LpDdr5MemType: atom_dmi_t17_mem_type_def = 35;
pub type atom_dmi_t17_mem_type_def = ::core::ffi::c_uint;
#[repr(C, packed)]
#[derive(Debug, Copy, Clone)]
pub struct atom_fusion_system_info_v4 {
    pub sysinfo: atom_integrated_system_info_v1_11,
    pub powerplayinfo: [u32; 256usize],
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of atom_fusion_system_info_v4"]
        [::core::mem::size_of::<atom_fusion_system_info_v4>() - 2048usize];
    ["Alignment of atom_fusion_system_info_v4"]
        [::core::mem::align_of::<atom_fusion_system_info_v4>() - 1usize];
    ["Offset of field: atom_fusion_system_info_v4::sysinfo"]
        [::core::mem::offset_of!(atom_fusion_system_info_v4, sysinfo) - 0usize];
    ["Offset of field: atom_fusion_system_info_v4::powerplayinfo"]
        [::core::mem::offset_of!(atom_fusion_system_info_v4, powerplayinfo) - 1024usize];
};
#[repr(C, packed)]
#[derive(Debug, Copy, Clone)]
pub struct atom_gfx_info_v2_2 {
    pub table_header: atom_common_table_header,
    pub gfxip_min_ver: u8,
    pub gfxip_max_ver: u8,
    pub max_shader_engines: u8,
    pub max_tile_pipes: u8,
    pub max_cu_per_sh: u8,
    pub max_sh_per_se: u8,
    pub max_backends_per_se: u8,
    pub max_texture_channel_caches: u8,
    pub regaddr_cp_dma_src_addr: u32,
    pub regaddr_cp_dma_src_addr_hi: u32,
    pub regaddr_cp_dma_dst_addr: u32,
    pub regaddr_cp_dma_dst_addr_hi: u32,
    pub regaddr_cp_dma_command: u32,
    pub regaddr_cp_status: u32,
    pub regaddr_rlc_gpu_clock_32: u32,
    pub rlc_gpu_timer_refclk: u32,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of atom_gfx_info_v2_2"][::core::mem::size_of::<atom_gfx_info_v2_2>() - 44usize];
    ["Alignment of atom_gfx_info_v2_2"][::core::mem::align_of::<atom_gfx_info_v2_2>() - 1usize];
    ["Offset of field: atom_gfx_info_v2_2::table_header"]
        [::core::mem::offset_of!(atom_gfx_info_v2_2, table_header) - 0usize];
    ["Offset of field: atom_gfx_info_v2_2::gfxip_min_ver"]
        [::core::mem::offset_of!(atom_gfx_info_v2_2, gfxip_min_ver) - 4usize];
    ["Offset of field: atom_gfx_info_v2_2::gfxip_max_ver"]
        [::core::mem::offset_of!(atom_gfx_info_v2_2, gfxip_max_ver) - 5usize];
    ["Offset of field: atom_gfx_info_v2_2::max_shader_engines"]
        [::core::mem::offset_of!(atom_gfx_info_v2_2, max_shader_engines) - 6usize];
    ["Offset of field: atom_gfx_info_v2_2::max_tile_pipes"]
        [::core::mem::offset_of!(atom_gfx_info_v2_2, max_tile_pipes) - 7usize];
    ["Offset of field: atom_gfx_info_v2_2::max_cu_per_sh"]
        [::core::mem::offset_of!(atom_gfx_info_v2_2, max_cu_per_sh) - 8usize];
    ["Offset of field: atom_gfx_info_v2_2::max_sh_per_se"]
        [::core::mem::offset_of!(atom_gfx_info_v2_2, max_sh_per_se) - 9usize];
    ["Offset of field: atom_gfx_info_v2_2::max_backends_per_se"]
        [::core::mem::offset_of!(atom_gfx_info_v2_2, max_backends_per_se) - 10usize];
    ["Offset of field: atom_gfx_info_v2_2::max_texture_channel_caches"]
        [::core::mem::offset_of!(atom_gfx_info_v2_2, max_texture_channel_caches) - 11usize];
    ["Offset of field: atom_gfx_info_v2_2::regaddr_cp_dma_src_addr"]
        [::core::mem::offset_of!(atom_gfx_info_v2_2, regaddr_cp_dma_src_addr) - 12usize];
    ["Offset of field: atom_gfx_info_v2_2::regaddr_cp_dma_src_addr_hi"]
        [::core::mem::offset_of!(atom_gfx_info_v2_2, regaddr_cp_dma_src_addr_hi) - 16usize];
    ["Offset of field: atom_gfx_info_v2_2::regaddr_cp_dma_dst_addr"]
        [::core::mem::offset_of!(atom_gfx_info_v2_2, regaddr_cp_dma_dst_addr) - 20usize];
    ["Offset of field: atom_gfx_info_v2_2::regaddr_cp_dma_dst_addr_hi"]
        [::core::mem::offset_of!(atom_gfx_info_v2_2, regaddr_cp_dma_dst_addr_hi) - 24usize];
    ["Offset of field: atom_gfx_info_v2_2::regaddr_cp_dma_command"]
        [::core::mem::offset_of!(atom_gfx_info_v2_2, regaddr_cp_dma_command) - 28usize];
    ["Offset of field: atom_gfx_info_v2_2::regaddr_cp_status"]
        [::core::mem::offset_of!(atom_gfx_info_v2_2, regaddr_cp_status) - 32usize];
    ["Offset of field: atom_gfx_info_v2_2::regaddr_rlc_gpu_clock_32"]
        [::core::mem::offset_of!(atom_gfx_info_v2_2, regaddr_rlc_gpu_clock_32) - 36usize];
    ["Offset of field: atom_gfx_info_v2_2::rlc_gpu_timer_refclk"]
        [::core::mem::offset_of!(atom_gfx_info_v2_2, rlc_gpu_timer_refclk) - 40usize];
};
#[repr(C, packed)]
#[derive(Debug, Copy, Clone)]
pub struct atom_gfx_info_v2_3 {
    pub table_header: atom_common_table_header,
    pub gfxip_min_ver: u8,
    pub gfxip_max_ver: u8,
    pub max_shader_engines: u8,
    pub max_tile_pipes: u8,
    pub max_cu_per_sh: u8,
    pub max_sh_per_se: u8,
    pub max_backends_per_se: u8,
    pub max_texture_channel_caches: u8,
    pub regaddr_cp_dma_src_addr: u32,
    pub regaddr_cp_dma_src_addr_hi: u32,
    pub regaddr_cp_dma_dst_addr: u32,
    pub regaddr_cp_dma_dst_addr_hi: u32,
    pub regaddr_cp_dma_command: u32,
    pub regaddr_cp_status: u32,
    pub regaddr_rlc_gpu_clock_32: u32,
    pub rlc_gpu_timer_refclk: u32,
    pub active_cu_per_sh: u8,
    pub active_rb_per_se: u8,
    pub gcgoldenoffset: u16,
    pub rm21_sram_vmin_value: u32,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of atom_gfx_info_v2_3"][::core::mem::size_of::<atom_gfx_info_v2_3>() - 52usize];
    ["Alignment of atom_gfx_info_v2_3"][::core::mem::align_of::<atom_gfx_info_v2_3>() - 1usize];
    ["Offset of field: atom_gfx_info_v2_3::table_header"]
        [::core::mem::offset_of!(atom_gfx_info_v2_3, table_header) - 0usize];
    ["Offset of field: atom_gfx_info_v2_3::gfxip_min_ver"]
        [::core::mem::offset_of!(atom_gfx_info_v2_3, gfxip_min_ver) - 4usize];
    ["Offset of field: atom_gfx_info_v2_3::gfxip_max_ver"]
        [::core::mem::offset_of!(atom_gfx_info_v2_3, gfxip_max_ver) - 5usize];
    ["Offset of field: atom_gfx_info_v2_3::max_shader_engines"]
        [::core::mem::offset_of!(atom_gfx_info_v2_3, max_shader_engines) - 6usize];
    ["Offset of field: atom_gfx_info_v2_3::max_tile_pipes"]
        [::core::mem::offset_of!(atom_gfx_info_v2_3, max_tile_pipes) - 7usize];
    ["Offset of field: atom_gfx_info_v2_3::max_cu_per_sh"]
        [::core::mem::offset_of!(atom_gfx_info_v2_3, max_cu_per_sh) - 8usize];
    ["Offset of field: atom_gfx_info_v2_3::max_sh_per_se"]
        [::core::mem::offset_of!(atom_gfx_info_v2_3, max_sh_per_se) - 9usize];
    ["Offset of field: atom_gfx_info_v2_3::max_backends_per_se"]
        [::core::mem::offset_of!(atom_gfx_info_v2_3, max_backends_per_se) - 10usize];
    ["Offset of field: atom_gfx_info_v2_3::max_texture_channel_caches"]
        [::core::mem::offset_of!(atom_gfx_info_v2_3, max_texture_channel_caches) - 11usize];
    ["Offset of field: atom_gfx_info_v2_3::regaddr_cp_dma_src_addr"]
        [::core::mem::offset_of!(atom_gfx_info_v2_3, regaddr_cp_dma_src_addr) - 12usize];
    ["Offset of field: atom_gfx_info_v2_3::regaddr_cp_dma_src_addr_hi"]
        [::core::mem::offset_of!(atom_gfx_info_v2_3, regaddr_cp_dma_src_addr_hi) - 16usize];
    ["Offset of field: atom_gfx_info_v2_3::regaddr_cp_dma_dst_addr"]
        [::core::mem::offset_of!(atom_gfx_info_v2_3, regaddr_cp_dma_dst_addr) - 20usize];
    ["Offset of field: atom_gfx_info_v2_3::regaddr_cp_dma_dst_addr_hi"]
        [::core::mem::offset_of!(atom_gfx_info_v2_3, regaddr_cp_dma_dst_addr_hi) - 24usize];
    ["Offset of field: atom_gfx_info_v2_3::regaddr_cp_dma_command"]
        [::core::mem::offset_of!(atom_gfx_info_v2_3, regaddr_cp_dma_command) - 28usize];
    ["Offset of field: atom_gfx_info_v2_3::regaddr_cp_status"]
        [::core::mem::offset_of!(atom_gfx_info_v2_3, regaddr_cp_status) - 32usize];
    ["Offset of field: atom_gfx_info_v2_3::regaddr_rlc_gpu_clock_32"]
        [::core::mem::offset_of!(atom_gfx_info_v2_3, regaddr_rlc_gpu_clock_32) - 36usize];
    ["Offset of field: atom_gfx_info_v2_3::rlc_gpu_timer_refclk"]
        [::core::mem::offset_of!(atom_gfx_info_v2_3, rlc_gpu_timer_refclk) - 40usize];
    ["Offset of field: atom_gfx_info_v2_3::active_cu_per_sh"]
        [::core::mem::offset_of!(atom_gfx_info_v2_3, active_cu_per_sh) - 44usize];
    ["Offset of field: atom_gfx_info_v2_3::active_rb_per_se"]
        [::core::mem::offset_of!(atom_gfx_info_v2_3, active_rb_per_se) - 45usize];
    ["Offset of field: atom_gfx_info_v2_3::gcgoldenoffset"]
        [::core::mem::offset_of!(atom_gfx_info_v2_3, gcgoldenoffset) - 46usize];
    ["Offset of field: atom_gfx_info_v2_3::rm21_sram_vmin_value"]
        [::core::mem::offset_of!(atom_gfx_info_v2_3, rm21_sram_vmin_value) - 48usize];
};
#[repr(C, packed)]
#[derive(Debug, Copy, Clone)]
pub struct atom_gfx_info_v2_4 {
    pub table_header: atom_common_table_header,
    pub gfxip_min_ver: u8,
    pub gfxip_max_ver: u8,
    pub max_shader_engines: u8,
    pub reserved: u8,
    pub max_cu_per_sh: u8,
    pub max_sh_per_se: u8,
    pub max_backends_per_se: u8,
    pub max_texture_channel_caches: u8,
    pub regaddr_cp_dma_src_addr: u32,
    pub regaddr_cp_dma_src_addr_hi: u32,
    pub regaddr_cp_dma_dst_addr: u32,
    pub regaddr_cp_dma_dst_addr_hi: u32,
    pub regaddr_cp_dma_command: u32,
    pub regaddr_cp_status: u32,
    pub regaddr_rlc_gpu_clock_32: u32,
    pub rlc_gpu_timer_refclk: u32,
    pub active_cu_per_sh: u8,
    pub active_rb_per_se: u8,
    pub gcgoldenoffset: u16,
    pub gc_num_gprs: u16,
    pub gc_gsprim_buff_depth: u16,
    pub gc_parameter_cache_depth: u16,
    pub gc_wave_size: u16,
    pub gc_max_waves_per_simd: u16,
    pub gc_lds_size: u16,
    pub gc_num_max_gs_thds: u8,
    pub gc_gs_table_depth: u8,
    pub gc_double_offchip_lds_buffer: u8,
    pub gc_max_scratch_slots_per_cu: u8,
    pub sram_rm_fuses_val: u32,
    pub sram_custom_rm_fuses_val: u32,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of atom_gfx_info_v2_4"][::core::mem::size_of::<atom_gfx_info_v2_4>() - 72usize];
    ["Alignment of atom_gfx_info_v2_4"][::core::mem::align_of::<atom_gfx_info_v2_4>() - 1usize];
    ["Offset of field: atom_gfx_info_v2_4::table_header"]
        [::core::mem::offset_of!(atom_gfx_info_v2_4, table_header) - 0usize];
    ["Offset of field: atom_gfx_info_v2_4::gfxip_min_ver"]
        [::core::mem::offset_of!(atom_gfx_info_v2_4, gfxip_min_ver) - 4usize];
    ["Offset of field: atom_gfx_info_v2_4::gfxip_max_ver"]
        [::core::mem::offset_of!(atom_gfx_info_v2_4, gfxip_max_ver) - 5usize];
    ["Offset of field: atom_gfx_info_v2_4::max_shader_engines"]
        [::core::mem::offset_of!(atom_gfx_info_v2_4, max_shader_engines) - 6usize];
    ["Offset of field: atom_gfx_info_v2_4::reserved"]
        [::core::mem::offset_of!(atom_gfx_info_v2_4, reserved) - 7usize];
    ["Offset of field: atom_gfx_info_v2_4::max_cu_per_sh"]
        [::core::mem::offset_of!(atom_gfx_info_v2_4, max_cu_per_sh) - 8usize];
    ["Offset of field: atom_gfx_info_v2_4::max_sh_per_se"]
        [::core::mem::offset_of!(atom_gfx_info_v2_4, max_sh_per_se) - 9usize];
    ["Offset of field: atom_gfx_info_v2_4::max_backends_per_se"]
        [::core::mem::offset_of!(atom_gfx_info_v2_4, max_backends_per_se) - 10usize];
    ["Offset of field: atom_gfx_info_v2_4::max_texture_channel_caches"]
        [::core::mem::offset_of!(atom_gfx_info_v2_4, max_texture_channel_caches) - 11usize];
    ["Offset of field: atom_gfx_info_v2_4::regaddr_cp_dma_src_addr"]
        [::core::mem::offset_of!(atom_gfx_info_v2_4, regaddr_cp_dma_src_addr) - 12usize];
    ["Offset of field: atom_gfx_info_v2_4::regaddr_cp_dma_src_addr_hi"]
        [::core::mem::offset_of!(atom_gfx_info_v2_4, regaddr_cp_dma_src_addr_hi) - 16usize];
    ["Offset of field: atom_gfx_info_v2_4::regaddr_cp_dma_dst_addr"]
        [::core::mem::offset_of!(atom_gfx_info_v2_4, regaddr_cp_dma_dst_addr) - 20usize];
    ["Offset of field: atom_gfx_info_v2_4::regaddr_cp_dma_dst_addr_hi"]
        [::core::mem::offset_of!(atom_gfx_info_v2_4, regaddr_cp_dma_dst_addr_hi) - 24usize];
    ["Offset of field: atom_gfx_info_v2_4::regaddr_cp_dma_command"]
        [::core::mem::offset_of!(atom_gfx_info_v2_4, regaddr_cp_dma_command) - 28usize];
    ["Offset of field: atom_gfx_info_v2_4::regaddr_cp_status"]
        [::core::mem::offset_of!(atom_gfx_info_v2_4, regaddr_cp_status) - 32usize];
    ["Offset of field: atom_gfx_info_v2_4::regaddr_rlc_gpu_clock_32"]
        [::core::mem::offset_of!(atom_gfx_info_v2_4, regaddr_rlc_gpu_clock_32) - 36usize];
    ["Offset of field: atom_gfx_info_v2_4::rlc_gpu_timer_refclk"]
        [::core::mem::offset_of!(atom_gfx_info_v2_4, rlc_gpu_timer_refclk) - 40usize];
    ["Offset of field: atom_gfx_info_v2_4::active_cu_per_sh"]
        [::core::mem::offset_of!(atom_gfx_info_v2_4, active_cu_per_sh) - 44usize];
    ["Offset of field: atom_gfx_info_v2_4::active_rb_per_se"]
        [::core::mem::offset_of!(atom_gfx_info_v2_4, active_rb_per_se) - 45usize];
    ["Offset of field: atom_gfx_info_v2_4::gcgoldenoffset"]
        [::core::mem::offset_of!(atom_gfx_info_v2_4, gcgoldenoffset) - 46usize];
    ["Offset of field: atom_gfx_info_v2_4::gc_num_gprs"]
        [::core::mem::offset_of!(atom_gfx_info_v2_4, gc_num_gprs) - 48usize];
    ["Offset of field: atom_gfx_info_v2_4::gc_gsprim_buff_depth"]
        [::core::mem::offset_of!(atom_gfx_info_v2_4, gc_gsprim_buff_depth) - 50usize];
    ["Offset of field: atom_gfx_info_v2_4::gc_parameter_cache_depth"]
        [::core::mem::offset_of!(atom_gfx_info_v2_4, gc_parameter_cache_depth) - 52usize];
    ["Offset of field: atom_gfx_info_v2_4::gc_wave_size"]
        [::core::mem::offset_of!(atom_gfx_info_v2_4, gc_wave_size) - 54usize];
    ["Offset of field: atom_gfx_info_v2_4::gc_max_waves_per_simd"]
        [::core::mem::offset_of!(atom_gfx_info_v2_4, gc_max_waves_per_simd) - 56usize];
    ["Offset of field: atom_gfx_info_v2_4::gc_lds_size"]
        [::core::mem::offset_of!(atom_gfx_info_v2_4, gc_lds_size) - 58usize];
    ["Offset of field: atom_gfx_info_v2_4::gc_num_max_gs_thds"]
        [::core::mem::offset_of!(atom_gfx_info_v2_4, gc_num_max_gs_thds) - 60usize];
    ["Offset of field: atom_gfx_info_v2_4::gc_gs_table_depth"]
        [::core::mem::offset_of!(atom_gfx_info_v2_4, gc_gs_table_depth) - 61usize];
    ["Offset of field: atom_gfx_info_v2_4::gc_double_offchip_lds_buffer"]
        [::core::mem::offset_of!(atom_gfx_info_v2_4, gc_double_offchip_lds_buffer) - 62usize];
    ["Offset of field: atom_gfx_info_v2_4::gc_max_scratch_slots_per_cu"]
        [::core::mem::offset_of!(atom_gfx_info_v2_4, gc_max_scratch_slots_per_cu) - 63usize];
    ["Offset of field: atom_gfx_info_v2_4::sram_rm_fuses_val"]
        [::core::mem::offset_of!(atom_gfx_info_v2_4, sram_rm_fuses_val) - 64usize];
    ["Offset of field: atom_gfx_info_v2_4::sram_custom_rm_fuses_val"]
        [::core::mem::offset_of!(atom_gfx_info_v2_4, sram_custom_rm_fuses_val) - 68usize];
};
#[repr(C, packed)]
#[derive(Debug, Copy, Clone)]
pub struct atom_gfx_info_v2_7 {
    pub table_header: atom_common_table_header,
    pub gfxip_min_ver: u8,
    pub gfxip_max_ver: u8,
    pub max_shader_engines: u8,
    pub reserved: u8,
    pub max_cu_per_sh: u8,
    pub max_sh_per_se: u8,
    pub max_backends_per_se: u8,
    pub max_texture_channel_caches: u8,
    pub regaddr_cp_dma_src_addr: u32,
    pub regaddr_cp_dma_src_addr_hi: u32,
    pub regaddr_cp_dma_dst_addr: u32,
    pub regaddr_cp_dma_dst_addr_hi: u32,
    pub regaddr_cp_dma_command: u32,
    pub regaddr_cp_status: u32,
    pub regaddr_rlc_gpu_clock_32: u32,
    pub rlc_gpu_timer_refclk: u32,
    pub active_cu_per_sh: u8,
    pub active_rb_per_se: u8,
    pub gcgoldenoffset: u16,
    pub gc_num_gprs: u16,
    pub gc_gsprim_buff_depth: u16,
    pub gc_parameter_cache_depth: u16,
    pub gc_wave_size: u16,
    pub gc_max_waves_per_simd: u16,
    pub gc_lds_size: u16,
    pub gc_num_max_gs_thds: u8,
    pub gc_gs_table_depth: u8,
    pub gc_double_offchip_lds_buffer: u8,
    pub gc_max_scratch_slots_per_cu: u8,
    pub sram_rm_fuses_val: u32,
    pub sram_custom_rm_fuses_val: u32,
    pub cut_cu: u8,
    pub active_cu_total: u8,
    pub cu_reserved: [u8; 2usize],
    pub gc_config: u32,
    pub inactive_cu_per_se: [u8; 8usize],
    pub reserved2: [u32; 6usize],
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of atom_gfx_info_v2_7"][::core::mem::size_of::<atom_gfx_info_v2_7>() - 112usize];
    ["Alignment of atom_gfx_info_v2_7"][::core::mem::align_of::<atom_gfx_info_v2_7>() - 1usize];
    ["Offset of field: atom_gfx_info_v2_7::table_header"]
        [::core::mem::offset_of!(atom_gfx_info_v2_7, table_header) - 0usize];
    ["Offset of field: atom_gfx_info_v2_7::gfxip_min_ver"]
        [::core::mem::offset_of!(atom_gfx_info_v2_7, gfxip_min_ver) - 4usize];
    ["Offset of field: atom_gfx_info_v2_7::gfxip_max_ver"]
        [::core::mem::offset_of!(atom_gfx_info_v2_7, gfxip_max_ver) - 5usize];
    ["Offset of field: atom_gfx_info_v2_7::max_shader_engines"]
        [::core::mem::offset_of!(atom_gfx_info_v2_7, max_shader_engines) - 6usize];
    ["Offset of field: atom_gfx_info_v2_7::reserved"]
        [::core::mem::offset_of!(atom_gfx_info_v2_7, reserved) - 7usize];
    ["Offset of field: atom_gfx_info_v2_7::max_cu_per_sh"]
        [::core::mem::offset_of!(atom_gfx_info_v2_7, max_cu_per_sh) - 8usize];
    ["Offset of field: atom_gfx_info_v2_7::max_sh_per_se"]
        [::core::mem::offset_of!(atom_gfx_info_v2_7, max_sh_per_se) - 9usize];
    ["Offset of field: atom_gfx_info_v2_7::max_backends_per_se"]
        [::core::mem::offset_of!(atom_gfx_info_v2_7, max_backends_per_se) - 10usize];
    ["Offset of field: atom_gfx_info_v2_7::max_texture_channel_caches"]
        [::core::mem::offset_of!(atom_gfx_info_v2_7, max_texture_channel_caches) - 11usize];
    ["Offset of field: atom_gfx_info_v2_7::regaddr_cp_dma_src_addr"]
        [::core::mem::offset_of!(atom_gfx_info_v2_7, regaddr_cp_dma_src_addr) - 12usize];
    ["Offset of field: atom_gfx_info_v2_7::regaddr_cp_dma_src_addr_hi"]
        [::core::mem::offset_of!(atom_gfx_info_v2_7, regaddr_cp_dma_src_addr_hi) - 16usize];
    ["Offset of field: atom_gfx_info_v2_7::regaddr_cp_dma_dst_addr"]
        [::core::mem::offset_of!(atom_gfx_info_v2_7, regaddr_cp_dma_dst_addr) - 20usize];
    ["Offset of field: atom_gfx_info_v2_7::regaddr_cp_dma_dst_addr_hi"]
        [::core::mem::offset_of!(atom_gfx_info_v2_7, regaddr_cp_dma_dst_addr_hi) - 24usize];
    ["Offset of field: atom_gfx_info_v2_7::regaddr_cp_dma_command"]
        [::core::mem::offset_of!(atom_gfx_info_v2_7, regaddr_cp_dma_command) - 28usize];
    ["Offset of field: atom_gfx_info_v2_7::regaddr_cp_status"]
        [::core::mem::offset_of!(atom_gfx_info_v2_7, regaddr_cp_status) - 32usize];
    ["Offset of field: atom_gfx_info_v2_7::regaddr_rlc_gpu_clock_32"]
        [::core::mem::offset_of!(atom_gfx_info_v2_7, regaddr_rlc_gpu_clock_32) - 36usize];
    ["Offset of field: atom_gfx_info_v2_7::rlc_gpu_timer_refclk"]
        [::core::mem::offset_of!(atom_gfx_info_v2_7, rlc_gpu_timer_refclk) - 40usize];
    ["Offset of field: atom_gfx_info_v2_7::active_cu_per_sh"]
        [::core::mem::offset_of!(atom_gfx_info_v2_7, active_cu_per_sh) - 44usize];
    ["Offset of field: atom_gfx_info_v2_7::active_rb_per_se"]
        [::core::mem::offset_of!(atom_gfx_info_v2_7, active_rb_per_se) - 45usize];
    ["Offset of field: atom_gfx_info_v2_7::gcgoldenoffset"]
        [::core::mem::offset_of!(atom_gfx_info_v2_7, gcgoldenoffset) - 46usize];
    ["Offset of field: atom_gfx_info_v2_7::gc_num_gprs"]
        [::core::mem::offset_of!(atom_gfx_info_v2_7, gc_num_gprs) - 48usize];
    ["Offset of field: atom_gfx_info_v2_7::gc_gsprim_buff_depth"]
        [::core::mem::offset_of!(atom_gfx_info_v2_7, gc_gsprim_buff_depth) - 50usize];
    ["Offset of field: atom_gfx_info_v2_7::gc_parameter_cache_depth"]
        [::core::mem::offset_of!(atom_gfx_info_v2_7, gc_parameter_cache_depth) - 52usize];
    ["Offset of field: atom_gfx_info_v2_7::gc_wave_size"]
        [::core::mem::offset_of!(atom_gfx_info_v2_7, gc_wave_size) - 54usize];
    ["Offset of field: atom_gfx_info_v2_7::gc_max_waves_per_simd"]
        [::core::mem::offset_of!(atom_gfx_info_v2_7, gc_max_waves_per_simd) - 56usize];
    ["Offset of field: atom_gfx_info_v2_7::gc_lds_size"]
        [::core::mem::offset_of!(atom_gfx_info_v2_7, gc_lds_size) - 58usize];
    ["Offset of field: atom_gfx_info_v2_7::gc_num_max_gs_thds"]
        [::core::mem::offset_of!(atom_gfx_info_v2_7, gc_num_max_gs_thds) - 60usize];
    ["Offset of field: atom_gfx_info_v2_7::gc_gs_table_depth"]
        [::core::mem::offset_of!(atom_gfx_info_v2_7, gc_gs_table_depth) - 61usize];
    ["Offset of field: atom_gfx_info_v2_7::gc_double_offchip_lds_buffer"]
        [::core::mem::offset_of!(atom_gfx_info_v2_7, gc_double_offchip_lds_buffer) - 62usize];
    ["Offset of field: atom_gfx_info_v2_7::gc_max_scratch_slots_per_cu"]
        [::core::mem::offset_of!(atom_gfx_info_v2_7, gc_max_scratch_slots_per_cu) - 63usize];
    ["Offset of field: atom_gfx_info_v2_7::sram_rm_fuses_val"]
        [::core::mem::offset_of!(atom_gfx_info_v2_7, sram_rm_fuses_val) - 64usize];
    ["Offset of field: atom_gfx_info_v2_7::sram_custom_rm_fuses_val"]
        [::core::mem::offset_of!(atom_gfx_info_v2_7, sram_custom_rm_fuses_val) - 68usize];
    ["Offset of field: atom_gfx_info_v2_7::cut_cu"]
        [::core::mem::offset_of!(atom_gfx_info_v2_7, cut_cu) - 72usize];
    ["Offset of field: atom_gfx_info_v2_7::active_cu_total"]
        [::core::mem::offset_of!(atom_gfx_info_v2_7, active_cu_total) - 73usize];
    ["Offset of field: atom_gfx_info_v2_7::cu_reserved"]
        [::core::mem::offset_of!(atom_gfx_info_v2_7, cu_reserved) - 74usize];
    ["Offset of field: atom_gfx_info_v2_7::gc_config"]
        [::core::mem::offset_of!(atom_gfx_info_v2_7, gc_config) - 76usize];
    ["Offset of field: atom_gfx_info_v2_7::inactive_cu_per_se"]
        [::core::mem::offset_of!(atom_gfx_info_v2_7, inactive_cu_per_se) - 80usize];
    ["Offset of field: atom_gfx_info_v2_7::reserved2"]
        [::core::mem::offset_of!(atom_gfx_info_v2_7, reserved2) - 88usize];
};
#[repr(C, packed)]
#[derive(Debug, Copy, Clone)]
pub struct atom_gfx_info_v3_0 {
    pub table_header: atom_common_table_header,
    pub gfxip_min_ver: u8,
    pub gfxip_max_ver: u8,
    pub max_shader_engines: u8,
    pub max_tile_pipes: u8,
    pub max_cu_per_sh: u8,
    pub max_sh_per_se: u8,
    pub max_backends_per_se: u8,
    pub max_texture_channel_caches: u8,
    pub regaddr_lsdma_queue0_rb_rptr: u32,
    pub regaddr_lsdma_queue0_rb_rptr_hi: u32,
    pub regaddr_lsdma_queue0_rb_wptr: u32,
    pub regaddr_lsdma_queue0_rb_wptr_hi: u32,
    pub regaddr_lsdma_command: u32,
    pub regaddr_lsdma_status: u32,
    pub regaddr_golden_tsc_count_lower: u32,
    pub golden_tsc_count_lower_refclk: u32,
    pub active_wgp_per_se: u8,
    pub active_rb_per_se: u8,
    pub active_se: u8,
    pub reserved1: u8,
    pub sram_rm_fuses_val: u32,
    pub sram_custom_rm_fuses_val: u32,
    pub inactive_sa_mask: u32,
    pub gc_config: u32,
    pub inactive_wgp: [u8; 16usize],
    pub inactive_rb: [u8; 16usize],
    pub gdfll_as_wait_ctrl_val: u32,
    pub gdfll_as_step_ctrl_val: u32,
    pub reserved: [u32; 8usize],
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of atom_gfx_info_v3_0"][::core::mem::size_of::<atom_gfx_info_v3_0>() - 136usize];
    ["Alignment of atom_gfx_info_v3_0"][::core::mem::align_of::<atom_gfx_info_v3_0>() - 1usize];
    ["Offset of field: atom_gfx_info_v3_0::table_header"]
        [::core::mem::offset_of!(atom_gfx_info_v3_0, table_header) - 0usize];
    ["Offset of field: atom_gfx_info_v3_0::gfxip_min_ver"]
        [::core::mem::offset_of!(atom_gfx_info_v3_0, gfxip_min_ver) - 4usize];
    ["Offset of field: atom_gfx_info_v3_0::gfxip_max_ver"]
        [::core::mem::offset_of!(atom_gfx_info_v3_0, gfxip_max_ver) - 5usize];
    ["Offset of field: atom_gfx_info_v3_0::max_shader_engines"]
        [::core::mem::offset_of!(atom_gfx_info_v3_0, max_shader_engines) - 6usize];
    ["Offset of field: atom_gfx_info_v3_0::max_tile_pipes"]
        [::core::mem::offset_of!(atom_gfx_info_v3_0, max_tile_pipes) - 7usize];
    ["Offset of field: atom_gfx_info_v3_0::max_cu_per_sh"]
        [::core::mem::offset_of!(atom_gfx_info_v3_0, max_cu_per_sh) - 8usize];
    ["Offset of field: atom_gfx_info_v3_0::max_sh_per_se"]
        [::core::mem::offset_of!(atom_gfx_info_v3_0, max_sh_per_se) - 9usize];
    ["Offset of field: atom_gfx_info_v3_0::max_backends_per_se"]
        [::core::mem::offset_of!(atom_gfx_info_v3_0, max_backends_per_se) - 10usize];
    ["Offset of field: atom_gfx_info_v3_0::max_texture_channel_caches"]
        [::core::mem::offset_of!(atom_gfx_info_v3_0, max_texture_channel_caches) - 11usize];
    ["Offset of field: atom_gfx_info_v3_0::regaddr_lsdma_queue0_rb_rptr"]
        [::core::mem::offset_of!(atom_gfx_info_v3_0, regaddr_lsdma_queue0_rb_rptr) - 12usize];
    ["Offset of field: atom_gfx_info_v3_0::regaddr_lsdma_queue0_rb_rptr_hi"]
        [::core::mem::offset_of!(atom_gfx_info_v3_0, regaddr_lsdma_queue0_rb_rptr_hi) - 16usize];
    ["Offset of field: atom_gfx_info_v3_0::regaddr_lsdma_queue0_rb_wptr"]
        [::core::mem::offset_of!(atom_gfx_info_v3_0, regaddr_lsdma_queue0_rb_wptr) - 20usize];
    ["Offset of field: atom_gfx_info_v3_0::regaddr_lsdma_queue0_rb_wptr_hi"]
        [::core::mem::offset_of!(atom_gfx_info_v3_0, regaddr_lsdma_queue0_rb_wptr_hi) - 24usize];
    ["Offset of field: atom_gfx_info_v3_0::regaddr_lsdma_command"]
        [::core::mem::offset_of!(atom_gfx_info_v3_0, regaddr_lsdma_command) - 28usize];
    ["Offset of field: atom_gfx_info_v3_0::regaddr_lsdma_status"]
        [::core::mem::offset_of!(atom_gfx_info_v3_0, regaddr_lsdma_status) - 32usize];
    ["Offset of field: atom_gfx_info_v3_0::regaddr_golden_tsc_count_lower"]
        [::core::mem::offset_of!(atom_gfx_info_v3_0, regaddr_golden_tsc_count_lower) - 36usize];
    ["Offset of field: atom_gfx_info_v3_0::golden_tsc_count_lower_refclk"]
        [::core::mem::offset_of!(atom_gfx_info_v3_0, golden_tsc_count_lower_refclk) - 40usize];
    ["Offset of field: atom_gfx_info_v3_0::active_wgp_per_se"]
        [::core::mem::offset_of!(atom_gfx_info_v3_0, active_wgp_per_se) - 44usize];
    ["Offset of field: atom_gfx_info_v3_0::active_rb_per_se"]
        [::core::mem::offset_of!(atom_gfx_info_v3_0, active_rb_per_se) - 45usize];
    ["Offset of field: atom_gfx_info_v3_0::active_se"]
        [::core::mem::offset_of!(atom_gfx_info_v3_0, active_se) - 46usize];
    ["Offset of field: atom_gfx_info_v3_0::reserved1"]
        [::core::mem::offset_of!(atom_gfx_info_v3_0, reserved1) - 47usize];
    ["Offset of field: atom_gfx_info_v3_0::sram_rm_fuses_val"]
        [::core::mem::offset_of!(atom_gfx_info_v3_0, sram_rm_fuses_val) - 48usize];
    ["Offset of field: atom_gfx_info_v3_0::sram_custom_rm_fuses_val"]
        [::core::mem::offset_of!(atom_gfx_info_v3_0, sram_custom_rm_fuses_val) - 52usize];
    ["Offset of field: atom_gfx_info_v3_0::inactive_sa_mask"]
        [::core::mem::offset_of!(atom_gfx_info_v3_0, inactive_sa_mask) - 56usize];
    ["Offset of field: atom_gfx_info_v3_0::gc_config"]
        [::core::mem::offset_of!(atom_gfx_info_v3_0, gc_config) - 60usize];
    ["Offset of field: atom_gfx_info_v3_0::inactive_wgp"]
        [::core::mem::offset_of!(atom_gfx_info_v3_0, inactive_wgp) - 64usize];
    ["Offset of field: atom_gfx_info_v3_0::inactive_rb"]
        [::core::mem::offset_of!(atom_gfx_info_v3_0, inactive_rb) - 80usize];
    ["Offset of field: atom_gfx_info_v3_0::gdfll_as_wait_ctrl_val"]
        [::core::mem::offset_of!(atom_gfx_info_v3_0, gdfll_as_wait_ctrl_val) - 96usize];
    ["Offset of field: atom_gfx_info_v3_0::gdfll_as_step_ctrl_val"]
        [::core::mem::offset_of!(atom_gfx_info_v3_0, gdfll_as_step_ctrl_val) - 100usize];
    ["Offset of field: atom_gfx_info_v3_0::reserved"]
        [::core::mem::offset_of!(atom_gfx_info_v3_0, reserved) - 104usize];
};
#[repr(C, packed)]
#[derive(Debug, Copy, Clone)]
pub struct atom_smu_info_v3_1 {
    pub table_header: atom_common_table_header,
    pub smuip_min_ver: u8,
    pub smuip_max_ver: u8,
    pub smu_rsd1: u8,
    pub gpuclk_ss_mode: u8,
    pub sclk_ss_percentage: u16,
    pub sclk_ss_rate_10hz: u16,
    pub gpuclk_ss_percentage: u16,
    pub gpuclk_ss_rate_10hz: u16,
    pub core_refclk_10khz: u32,
    pub ac_dc_gpio_bit: u8,
    pub ac_dc_polarity: u8,
    pub vr0hot_gpio_bit: u8,
    pub vr0hot_polarity: u8,
    pub vr1hot_gpio_bit: u8,
    pub vr1hot_polarity: u8,
    pub fw_ctf_gpio_bit: u8,
    pub fw_ctf_polarity: u8,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of atom_smu_info_v3_1"][::core::mem::size_of::<atom_smu_info_v3_1>() - 28usize];
    ["Alignment of atom_smu_info_v3_1"][::core::mem::align_of::<atom_smu_info_v3_1>() - 1usize];
    ["Offset of field: atom_smu_info_v3_1::table_header"]
        [::core::mem::offset_of!(atom_smu_info_v3_1, table_header) - 0usize];
    ["Offset of field: atom_smu_info_v3_1::smuip_min_ver"]
        [::core::mem::offset_of!(atom_smu_info_v3_1, smuip_min_ver) - 4usize];
    ["Offset of field: atom_smu_info_v3_1::smuip_max_ver"]
        [::core::mem::offset_of!(atom_smu_info_v3_1, smuip_max_ver) - 5usize];
    ["Offset of field: atom_smu_info_v3_1::smu_rsd1"]
        [::core::mem::offset_of!(atom_smu_info_v3_1, smu_rsd1) - 6usize];
    ["Offset of field: atom_smu_info_v3_1::gpuclk_ss_mode"]
        [::core::mem::offset_of!(atom_smu_info_v3_1, gpuclk_ss_mode) - 7usize];
    ["Offset of field: atom_smu_info_v3_1::sclk_ss_percentage"]
        [::core::mem::offset_of!(atom_smu_info_v3_1, sclk_ss_percentage) - 8usize];
    ["Offset of field: atom_smu_info_v3_1::sclk_ss_rate_10hz"]
        [::core::mem::offset_of!(atom_smu_info_v3_1, sclk_ss_rate_10hz) - 10usize];
    ["Offset of field: atom_smu_info_v3_1::gpuclk_ss_percentage"]
        [::core::mem::offset_of!(atom_smu_info_v3_1, gpuclk_ss_percentage) - 12usize];
    ["Offset of field: atom_smu_info_v3_1::gpuclk_ss_rate_10hz"]
        [::core::mem::offset_of!(atom_smu_info_v3_1, gpuclk_ss_rate_10hz) - 14usize];
    ["Offset of field: atom_smu_info_v3_1::core_refclk_10khz"]
        [::core::mem::offset_of!(atom_smu_info_v3_1, core_refclk_10khz) - 16usize];
    ["Offset of field: atom_smu_info_v3_1::ac_dc_gpio_bit"]
        [::core::mem::offset_of!(atom_smu_info_v3_1, ac_dc_gpio_bit) - 20usize];
    ["Offset of field: atom_smu_info_v3_1::ac_dc_polarity"]
        [::core::mem::offset_of!(atom_smu_info_v3_1, ac_dc_polarity) - 21usize];
    ["Offset of field: atom_smu_info_v3_1::vr0hot_gpio_bit"]
        [::core::mem::offset_of!(atom_smu_info_v3_1, vr0hot_gpio_bit) - 22usize];
    ["Offset of field: atom_smu_info_v3_1::vr0hot_polarity"]
        [::core::mem::offset_of!(atom_smu_info_v3_1, vr0hot_polarity) - 23usize];
    ["Offset of field: atom_smu_info_v3_1::vr1hot_gpio_bit"]
        [::core::mem::offset_of!(atom_smu_info_v3_1, vr1hot_gpio_bit) - 24usize];
    ["Offset of field: atom_smu_info_v3_1::vr1hot_polarity"]
        [::core::mem::offset_of!(atom_smu_info_v3_1, vr1hot_polarity) - 25usize];
    ["Offset of field: atom_smu_info_v3_1::fw_ctf_gpio_bit"]
        [::core::mem::offset_of!(atom_smu_info_v3_1, fw_ctf_gpio_bit) - 26usize];
    ["Offset of field: atom_smu_info_v3_1::fw_ctf_polarity"]
        [::core::mem::offset_of!(atom_smu_info_v3_1, fw_ctf_polarity) - 27usize];
};
#[repr(C, packed)]
#[derive(Debug, Copy, Clone)]
pub struct atom_smu_info_v3_2 {
    pub table_header: atom_common_table_header,
    pub smuip_min_ver: u8,
    pub smuip_max_ver: u8,
    pub smu_rsd1: u8,
    pub gpuclk_ss_mode: u8,
    pub sclk_ss_percentage: u16,
    pub sclk_ss_rate_10hz: u16,
    pub gpuclk_ss_percentage: u16,
    pub gpuclk_ss_rate_10hz: u16,
    pub core_refclk_10khz: u32,
    pub ac_dc_gpio_bit: u8,
    pub ac_dc_polarity: u8,
    pub vr0hot_gpio_bit: u8,
    pub vr0hot_polarity: u8,
    pub vr1hot_gpio_bit: u8,
    pub vr1hot_polarity: u8,
    pub fw_ctf_gpio_bit: u8,
    pub fw_ctf_polarity: u8,
    pub pcc_gpio_bit: u8,
    pub pcc_gpio_polarity: u8,
    pub smugoldenoffset: u16,
    pub gpupll_vco_freq_10khz: u32,
    pub bootup_smnclk_10khz: u32,
    pub bootup_socclk_10khz: u32,
    pub bootup_mp0clk_10khz: u32,
    pub bootup_mp1clk_10khz: u32,
    pub bootup_lclk_10khz: u32,
    pub bootup_dcefclk_10khz: u32,
    pub ctf_threshold_override_value: u32,
    pub reserved: [u32; 5usize],
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of atom_smu_info_v3_2"][::core::mem::size_of::<atom_smu_info_v3_2>() - 84usize];
    ["Alignment of atom_smu_info_v3_2"][::core::mem::align_of::<atom_smu_info_v3_2>() - 1usize];
    ["Offset of field: atom_smu_info_v3_2::table_header"]
        [::core::mem::offset_of!(atom_smu_info_v3_2, table_header) - 0usize];
    ["Offset of field: atom_smu_info_v3_2::smuip_min_ver"]
        [::core::mem::offset_of!(atom_smu_info_v3_2, smuip_min_ver) - 4usize];
    ["Offset of field: atom_smu_info_v3_2::smuip_max_ver"]
        [::core::mem::offset_of!(atom_smu_info_v3_2, smuip_max_ver) - 5usize];
    ["Offset of field: atom_smu_info_v3_2::smu_rsd1"]
        [::core::mem::offset_of!(atom_smu_info_v3_2, smu_rsd1) - 6usize];
    ["Offset of field: atom_smu_info_v3_2::gpuclk_ss_mode"]
        [::core::mem::offset_of!(atom_smu_info_v3_2, gpuclk_ss_mode) - 7usize];
    ["Offset of field: atom_smu_info_v3_2::sclk_ss_percentage"]
        [::core::mem::offset_of!(atom_smu_info_v3_2, sclk_ss_percentage) - 8usize];
    ["Offset of field: atom_smu_info_v3_2::sclk_ss_rate_10hz"]
        [::core::mem::offset_of!(atom_smu_info_v3_2, sclk_ss_rate_10hz) - 10usize];
    ["Offset of field: atom_smu_info_v3_2::gpuclk_ss_percentage"]
        [::core::mem::offset_of!(atom_smu_info_v3_2, gpuclk_ss_percentage) - 12usize];
    ["Offset of field: atom_smu_info_v3_2::gpuclk_ss_rate_10hz"]
        [::core::mem::offset_of!(atom_smu_info_v3_2, gpuclk_ss_rate_10hz) - 14usize];
    ["Offset of field: atom_smu_info_v3_2::core_refclk_10khz"]
        [::core::mem::offset_of!(atom_smu_info_v3_2, core_refclk_10khz) - 16usize];
    ["Offset of field: atom_smu_info_v3_2::ac_dc_gpio_bit"]
        [::core::mem::offset_of!(atom_smu_info_v3_2, ac_dc_gpio_bit) - 20usize];
    ["Offset of field: atom_smu_info_v3_2::ac_dc_polarity"]
        [::core::mem::offset_of!(atom_smu_info_v3_2, ac_dc_polarity) - 21usize];
    ["Offset of field: atom_smu_info_v3_2::vr0hot_gpio_bit"]
        [::core::mem::offset_of!(atom_smu_info_v3_2, vr0hot_gpio_bit) - 22usize];
    ["Offset of field: atom_smu_info_v3_2::vr0hot_polarity"]
        [::core::mem::offset_of!(atom_smu_info_v3_2, vr0hot_polarity) - 23usize];
    ["Offset of field: atom_smu_info_v3_2::vr1hot_gpio_bit"]
        [::core::mem::offset_of!(atom_smu_info_v3_2, vr1hot_gpio_bit) - 24usize];
    ["Offset of field: atom_smu_info_v3_2::vr1hot_polarity"]
        [::core::mem::offset_of!(atom_smu_info_v3_2, vr1hot_polarity) - 25usize];
    ["Offset of field: atom_smu_info_v3_2::fw_ctf_gpio_bit"]
        [::core::mem::offset_of!(atom_smu_info_v3_2, fw_ctf_gpio_bit) - 26usize];
    ["Offset of field: atom_smu_info_v3_2::fw_ctf_polarity"]
        [::core::mem::offset_of!(atom_smu_info_v3_2, fw_ctf_polarity) - 27usize];
    ["Offset of field: atom_smu_info_v3_2::pcc_gpio_bit"]
        [::core::mem::offset_of!(atom_smu_info_v3_2, pcc_gpio_bit) - 28usize];
    ["Offset of field: atom_smu_info_v3_2::pcc_gpio_polarity"]
        [::core::mem::offset_of!(atom_smu_info_v3_2, pcc_gpio_polarity) - 29usize];
    ["Offset of field: atom_smu_info_v3_2::smugoldenoffset"]
        [::core::mem::offset_of!(atom_smu_info_v3_2, smugoldenoffset) - 30usize];
    ["Offset of field: atom_smu_info_v3_2::gpupll_vco_freq_10khz"]
        [::core::mem::offset_of!(atom_smu_info_v3_2, gpupll_vco_freq_10khz) - 32usize];
    ["Offset of field: atom_smu_info_v3_2::bootup_smnclk_10khz"]
        [::core::mem::offset_of!(atom_smu_info_v3_2, bootup_smnclk_10khz) - 36usize];
    ["Offset of field: atom_smu_info_v3_2::bootup_socclk_10khz"]
        [::core::mem::offset_of!(atom_smu_info_v3_2, bootup_socclk_10khz) - 40usize];
    ["Offset of field: atom_smu_info_v3_2::bootup_mp0clk_10khz"]
        [::core::mem::offset_of!(atom_smu_info_v3_2, bootup_mp0clk_10khz) - 44usize];
    ["Offset of field: atom_smu_info_v3_2::bootup_mp1clk_10khz"]
        [::core::mem::offset_of!(atom_smu_info_v3_2, bootup_mp1clk_10khz) - 48usize];
    ["Offset of field: atom_smu_info_v3_2::bootup_lclk_10khz"]
        [::core::mem::offset_of!(atom_smu_info_v3_2, bootup_lclk_10khz) - 52usize];
    ["Offset of field: atom_smu_info_v3_2::bootup_dcefclk_10khz"]
        [::core::mem::offset_of!(atom_smu_info_v3_2, bootup_dcefclk_10khz) - 56usize];
    ["Offset of field: atom_smu_info_v3_2::ctf_threshold_override_value"]
        [::core::mem::offset_of!(atom_smu_info_v3_2, ctf_threshold_override_value) - 60usize];
    ["Offset of field: atom_smu_info_v3_2::reserved"]
        [::core::mem::offset_of!(atom_smu_info_v3_2, reserved) - 64usize];
};
#[repr(C, packed)]
#[derive(Debug, Copy, Clone)]
pub struct atom_smu_info_v3_3 {
    pub table_header: atom_common_table_header,
    pub smuip_min_ver: u8,
    pub smuip_max_ver: u8,
    pub waflclk_ss_mode: u8,
    pub gpuclk_ss_mode: u8,
    pub sclk_ss_percentage: u16,
    pub sclk_ss_rate_10hz: u16,
    pub gpuclk_ss_percentage: u16,
    pub gpuclk_ss_rate_10hz: u16,
    pub core_refclk_10khz: u32,
    pub ac_dc_gpio_bit: u8,
    pub ac_dc_polarity: u8,
    pub vr0hot_gpio_bit: u8,
    pub vr0hot_polarity: u8,
    pub vr1hot_gpio_bit: u8,
    pub vr1hot_polarity: u8,
    pub fw_ctf_gpio_bit: u8,
    pub fw_ctf_polarity: u8,
    pub pcc_gpio_bit: u8,
    pub pcc_gpio_polarity: u8,
    pub smugoldenoffset: u16,
    pub gpupll_vco_freq_10khz: u32,
    pub bootup_smnclk_10khz: u32,
    pub bootup_socclk_10khz: u32,
    pub bootup_mp0clk_10khz: u32,
    pub bootup_mp1clk_10khz: u32,
    pub bootup_lclk_10khz: u32,
    pub bootup_dcefclk_10khz: u32,
    pub ctf_threshold_override_value: u32,
    pub syspll3_0_vco_freq_10khz: u32,
    pub syspll3_1_vco_freq_10khz: u32,
    pub bootup_fclk_10khz: u32,
    pub bootup_waflclk_10khz: u32,
    pub smu_info_caps: u32,
    pub waflclk_ss_percentage: u16,
    pub smuinitoffset: u16,
    pub reserved: u32,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of atom_smu_info_v3_3"][::core::mem::size_of::<atom_smu_info_v3_3>() - 92usize];
    ["Alignment of atom_smu_info_v3_3"][::core::mem::align_of::<atom_smu_info_v3_3>() - 1usize];
    ["Offset of field: atom_smu_info_v3_3::table_header"]
        [::core::mem::offset_of!(atom_smu_info_v3_3, table_header) - 0usize];
    ["Offset of field: atom_smu_info_v3_3::smuip_min_ver"]
        [::core::mem::offset_of!(atom_smu_info_v3_3, smuip_min_ver) - 4usize];
    ["Offset of field: atom_smu_info_v3_3::smuip_max_ver"]
        [::core::mem::offset_of!(atom_smu_info_v3_3, smuip_max_ver) - 5usize];
    ["Offset of field: atom_smu_info_v3_3::waflclk_ss_mode"]
        [::core::mem::offset_of!(atom_smu_info_v3_3, waflclk_ss_mode) - 6usize];
    ["Offset of field: atom_smu_info_v3_3::gpuclk_ss_mode"]
        [::core::mem::offset_of!(atom_smu_info_v3_3, gpuclk_ss_mode) - 7usize];
    ["Offset of field: atom_smu_info_v3_3::sclk_ss_percentage"]
        [::core::mem::offset_of!(atom_smu_info_v3_3, sclk_ss_percentage) - 8usize];
    ["Offset of field: atom_smu_info_v3_3::sclk_ss_rate_10hz"]
        [::core::mem::offset_of!(atom_smu_info_v3_3, sclk_ss_rate_10hz) - 10usize];
    ["Offset of field: atom_smu_info_v3_3::gpuclk_ss_percentage"]
        [::core::mem::offset_of!(atom_smu_info_v3_3, gpuclk_ss_percentage) - 12usize];
    ["Offset of field: atom_smu_info_v3_3::gpuclk_ss_rate_10hz"]
        [::core::mem::offset_of!(atom_smu_info_v3_3, gpuclk_ss_rate_10hz) - 14usize];
    ["Offset of field: atom_smu_info_v3_3::core_refclk_10khz"]
        [::core::mem::offset_of!(atom_smu_info_v3_3, core_refclk_10khz) - 16usize];
    ["Offset of field: atom_smu_info_v3_3::ac_dc_gpio_bit"]
        [::core::mem::offset_of!(atom_smu_info_v3_3, ac_dc_gpio_bit) - 20usize];
    ["Offset of field: atom_smu_info_v3_3::ac_dc_polarity"]
        [::core::mem::offset_of!(atom_smu_info_v3_3, ac_dc_polarity) - 21usize];
    ["Offset of field: atom_smu_info_v3_3::vr0hot_gpio_bit"]
        [::core::mem::offset_of!(atom_smu_info_v3_3, vr0hot_gpio_bit) - 22usize];
    ["Offset of field: atom_smu_info_v3_3::vr0hot_polarity"]
        [::core::mem::offset_of!(atom_smu_info_v3_3, vr0hot_polarity) - 23usize];
    ["Offset of field: atom_smu_info_v3_3::vr1hot_gpio_bit"]
        [::core::mem::offset_of!(atom_smu_info_v3_3, vr1hot_gpio_bit) - 24usize];
    ["Offset of field: atom_smu_info_v3_3::vr1hot_polarity"]
        [::core::mem::offset_of!(atom_smu_info_v3_3, vr1hot_polarity) - 25usize];
    ["Offset of field: atom_smu_info_v3_3::fw_ctf_gpio_bit"]
        [::core::mem::offset_of!(atom_smu_info_v3_3, fw_ctf_gpio_bit) - 26usize];
    ["Offset of field: atom_smu_info_v3_3::fw_ctf_polarity"]
        [::core::mem::offset_of!(atom_smu_info_v3_3, fw_ctf_polarity) - 27usize];
    ["Offset of field: atom_smu_info_v3_3::pcc_gpio_bit"]
        [::core::mem::offset_of!(atom_smu_info_v3_3, pcc_gpio_bit) - 28usize];
    ["Offset of field: atom_smu_info_v3_3::pcc_gpio_polarity"]
        [::core::mem::offset_of!(atom_smu_info_v3_3, pcc_gpio_polarity) - 29usize];
    ["Offset of field: atom_smu_info_v3_3::smugoldenoffset"]
        [::core::mem::offset_of!(atom_smu_info_v3_3, smugoldenoffset) - 30usize];
    ["Offset of field: atom_smu_info_v3_3::gpupll_vco_freq_10khz"]
        [::core::mem::offset_of!(atom_smu_info_v3_3, gpupll_vco_freq_10khz) - 32usize];
    ["Offset of field: atom_smu_info_v3_3::bootup_smnclk_10khz"]
        [::core::mem::offset_of!(atom_smu_info_v3_3, bootup_smnclk_10khz) - 36usize];
    ["Offset of field: atom_smu_info_v3_3::bootup_socclk_10khz"]
        [::core::mem::offset_of!(atom_smu_info_v3_3, bootup_socclk_10khz) - 40usize];
    ["Offset of field: atom_smu_info_v3_3::bootup_mp0clk_10khz"]
        [::core::mem::offset_of!(atom_smu_info_v3_3, bootup_mp0clk_10khz) - 44usize];
    ["Offset of field: atom_smu_info_v3_3::bootup_mp1clk_10khz"]
        [::core::mem::offset_of!(atom_smu_info_v3_3, bootup_mp1clk_10khz) - 48usize];
    ["Offset of field: atom_smu_info_v3_3::bootup_lclk_10khz"]
        [::core::mem::offset_of!(atom_smu_info_v3_3, bootup_lclk_10khz) - 52usize];
    ["Offset of field: atom_smu_info_v3_3::bootup_dcefclk_10khz"]
        [::core::mem::offset_of!(atom_smu_info_v3_3, bootup_dcefclk_10khz) - 56usize];
    ["Offset of field: atom_smu_info_v3_3::ctf_threshold_override_value"]
        [::core::mem::offset_of!(atom_smu_info_v3_3, ctf_threshold_override_value) - 60usize];
    ["Offset of field: atom_smu_info_v3_3::syspll3_0_vco_freq_10khz"]
        [::core::mem::offset_of!(atom_smu_info_v3_3, syspll3_0_vco_freq_10khz) - 64usize];
    ["Offset of field: atom_smu_info_v3_3::syspll3_1_vco_freq_10khz"]
        [::core::mem::offset_of!(atom_smu_info_v3_3, syspll3_1_vco_freq_10khz) - 68usize];
    ["Offset of field: atom_smu_info_v3_3::bootup_fclk_10khz"]
        [::core::mem::offset_of!(atom_smu_info_v3_3, bootup_fclk_10khz) - 72usize];
    ["Offset of field: atom_smu_info_v3_3::bootup_waflclk_10khz"]
        [::core::mem::offset_of!(atom_smu_info_v3_3, bootup_waflclk_10khz) - 76usize];
    ["Offset of field: atom_smu_info_v3_3::smu_info_caps"]
        [::core::mem::offset_of!(atom_smu_info_v3_3, smu_info_caps) - 80usize];
    ["Offset of field: atom_smu_info_v3_3::waflclk_ss_percentage"]
        [::core::mem::offset_of!(atom_smu_info_v3_3, waflclk_ss_percentage) - 84usize];
    ["Offset of field: atom_smu_info_v3_3::smuinitoffset"]
        [::core::mem::offset_of!(atom_smu_info_v3_3, smuinitoffset) - 86usize];
    ["Offset of field: atom_smu_info_v3_3::reserved"]
        [::core::mem::offset_of!(atom_smu_info_v3_3, reserved) - 88usize];
};
#[repr(C, packed)]
#[derive(Debug, Copy, Clone)]
pub struct atom_smu_info_v3_5 {
    pub table_header: atom_common_table_header,
    pub smuip_min_ver: u8,
    pub smuip_max_ver: u8,
    pub waflclk_ss_mode: u8,
    pub gpuclk_ss_mode: u8,
    pub sclk_ss_percentage: u16,
    pub sclk_ss_rate_10hz: u16,
    pub gpuclk_ss_percentage: u16,
    pub gpuclk_ss_rate_10hz: u16,
    pub core_refclk_10khz: u32,
    pub syspll0_1_vco_freq_10khz: u32,
    pub syspll0_2_vco_freq_10khz: u32,
    pub pcc_gpio_bit: u8,
    pub pcc_gpio_polarity: u8,
    pub smugoldenoffset: u16,
    pub syspll0_0_vco_freq_10khz: u32,
    pub bootup_smnclk_10khz: u32,
    pub bootup_socclk_10khz: u32,
    pub bootup_mp0clk_10khz: u32,
    pub bootup_mp1clk_10khz: u32,
    pub bootup_lclk_10khz: u32,
    pub bootup_dcefclk_10khz: u32,
    pub ctf_threshold_override_value: u32,
    pub syspll3_0_vco_freq_10khz: u32,
    pub syspll3_1_vco_freq_10khz: u32,
    pub bootup_fclk_10khz: u32,
    pub bootup_waflclk_10khz: u32,
    pub smu_info_caps: u32,
    pub waflclk_ss_percentage: u16,
    pub smuinitoffset: u16,
    pub bootup_dprefclk_10khz: u32,
    pub bootup_usbclk_10khz: u32,
    pub smb_slave_address: u32,
    pub cg_fdo_ctrl0_val: u32,
    pub cg_fdo_ctrl1_val: u32,
    pub cg_fdo_ctrl2_val: u32,
    pub gdfll_as_wait_ctrl_val: u32,
    pub gdfll_as_step_ctrl_val: u32,
    pub bootup_dtbclk_10khz: u32,
    pub fclk_syspll_refclk_10khz: u32,
    pub smusvi_svc0_val: u32,
    pub smusvi_svc1_val: u32,
    pub smusvi_svd0_val: u32,
    pub smusvi_svd1_val: u32,
    pub smusvi_svt0_val: u32,
    pub smusvi_svt1_val: u32,
    pub cg_tach_ctrl_val: u32,
    pub cg_pump_ctrl1_val: u32,
    pub cg_pump_tach_ctrl_val: u32,
    pub thm_ctf_delay_val: u32,
    pub thm_thermal_int_ctrl_val: u32,
    pub thm_tmon_config_val: u32,
    pub reserved: [u32; 16usize],
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of atom_smu_info_v3_5"][::core::mem::size_of::<atom_smu_info_v3_5>() - 240usize];
    ["Alignment of atom_smu_info_v3_5"][::core::mem::align_of::<atom_smu_info_v3_5>() - 1usize];
    ["Offset of field: atom_smu_info_v3_5::table_header"]
        [::core::mem::offset_of!(atom_smu_info_v3_5, table_header) - 0usize];
    ["Offset of field: atom_smu_info_v3_5::smuip_min_ver"]
        [::core::mem::offset_of!(atom_smu_info_v3_5, smuip_min_ver) - 4usize];
    ["Offset of field: atom_smu_info_v3_5::smuip_max_ver"]
        [::core::mem::offset_of!(atom_smu_info_v3_5, smuip_max_ver) - 5usize];
    ["Offset of field: atom_smu_info_v3_5::waflclk_ss_mode"]
        [::core::mem::offset_of!(atom_smu_info_v3_5, waflclk_ss_mode) - 6usize];
    ["Offset of field: atom_smu_info_v3_5::gpuclk_ss_mode"]
        [::core::mem::offset_of!(atom_smu_info_v3_5, gpuclk_ss_mode) - 7usize];
    ["Offset of field: atom_smu_info_v3_5::sclk_ss_percentage"]
        [::core::mem::offset_of!(atom_smu_info_v3_5, sclk_ss_percentage) - 8usize];
    ["Offset of field: atom_smu_info_v3_5::sclk_ss_rate_10hz"]
        [::core::mem::offset_of!(atom_smu_info_v3_5, sclk_ss_rate_10hz) - 10usize];
    ["Offset of field: atom_smu_info_v3_5::gpuclk_ss_percentage"]
        [::core::mem::offset_of!(atom_smu_info_v3_5, gpuclk_ss_percentage) - 12usize];
    ["Offset of field: atom_smu_info_v3_5::gpuclk_ss_rate_10hz"]
        [::core::mem::offset_of!(atom_smu_info_v3_5, gpuclk_ss_rate_10hz) - 14usize];
    ["Offset of field: atom_smu_info_v3_5::core_refclk_10khz"]
        [::core::mem::offset_of!(atom_smu_info_v3_5, core_refclk_10khz) - 16usize];
    ["Offset of field: atom_smu_info_v3_5::syspll0_1_vco_freq_10khz"]
        [::core::mem::offset_of!(atom_smu_info_v3_5, syspll0_1_vco_freq_10khz) - 20usize];
    ["Offset of field: atom_smu_info_v3_5::syspll0_2_vco_freq_10khz"]
        [::core::mem::offset_of!(atom_smu_info_v3_5, syspll0_2_vco_freq_10khz) - 24usize];
    ["Offset of field: atom_smu_info_v3_5::pcc_gpio_bit"]
        [::core::mem::offset_of!(atom_smu_info_v3_5, pcc_gpio_bit) - 28usize];
    ["Offset of field: atom_smu_info_v3_5::pcc_gpio_polarity"]
        [::core::mem::offset_of!(atom_smu_info_v3_5, pcc_gpio_polarity) - 29usize];
    ["Offset of field: atom_smu_info_v3_5::smugoldenoffset"]
        [::core::mem::offset_of!(atom_smu_info_v3_5, smugoldenoffset) - 30usize];
    ["Offset of field: atom_smu_info_v3_5::syspll0_0_vco_freq_10khz"]
        [::core::mem::offset_of!(atom_smu_info_v3_5, syspll0_0_vco_freq_10khz) - 32usize];
    ["Offset of field: atom_smu_info_v3_5::bootup_smnclk_10khz"]
        [::core::mem::offset_of!(atom_smu_info_v3_5, bootup_smnclk_10khz) - 36usize];
    ["Offset of field: atom_smu_info_v3_5::bootup_socclk_10khz"]
        [::core::mem::offset_of!(atom_smu_info_v3_5, bootup_socclk_10khz) - 40usize];
    ["Offset of field: atom_smu_info_v3_5::bootup_mp0clk_10khz"]
        [::core::mem::offset_of!(atom_smu_info_v3_5, bootup_mp0clk_10khz) - 44usize];
    ["Offset of field: atom_smu_info_v3_5::bootup_mp1clk_10khz"]
        [::core::mem::offset_of!(atom_smu_info_v3_5, bootup_mp1clk_10khz) - 48usize];
    ["Offset of field: atom_smu_info_v3_5::bootup_lclk_10khz"]
        [::core::mem::offset_of!(atom_smu_info_v3_5, bootup_lclk_10khz) - 52usize];
    ["Offset of field: atom_smu_info_v3_5::bootup_dcefclk_10khz"]
        [::core::mem::offset_of!(atom_smu_info_v3_5, bootup_dcefclk_10khz) - 56usize];
    ["Offset of field: atom_smu_info_v3_5::ctf_threshold_override_value"]
        [::core::mem::offset_of!(atom_smu_info_v3_5, ctf_threshold_override_value) - 60usize];
    ["Offset of field: atom_smu_info_v3_5::syspll3_0_vco_freq_10khz"]
        [::core::mem::offset_of!(atom_smu_info_v3_5, syspll3_0_vco_freq_10khz) - 64usize];
    ["Offset of field: atom_smu_info_v3_5::syspll3_1_vco_freq_10khz"]
        [::core::mem::offset_of!(atom_smu_info_v3_5, syspll3_1_vco_freq_10khz) - 68usize];
    ["Offset of field: atom_smu_info_v3_5::bootup_fclk_10khz"]
        [::core::mem::offset_of!(atom_smu_info_v3_5, bootup_fclk_10khz) - 72usize];
    ["Offset of field: atom_smu_info_v3_5::bootup_waflclk_10khz"]
        [::core::mem::offset_of!(atom_smu_info_v3_5, bootup_waflclk_10khz) - 76usize];
    ["Offset of field: atom_smu_info_v3_5::smu_info_caps"]
        [::core::mem::offset_of!(atom_smu_info_v3_5, smu_info_caps) - 80usize];
    ["Offset of field: atom_smu_info_v3_5::waflclk_ss_percentage"]
        [::core::mem::offset_of!(atom_smu_info_v3_5, waflclk_ss_percentage) - 84usize];
    ["Offset of field: atom_smu_info_v3_5::smuinitoffset"]
        [::core::mem::offset_of!(atom_smu_info_v3_5, smuinitoffset) - 86usize];
    ["Offset of field: atom_smu_info_v3_5::bootup_dprefclk_10khz"]
        [::core::mem::offset_of!(atom_smu_info_v3_5, bootup_dprefclk_10khz) - 88usize];
    ["Offset of field: atom_smu_info_v3_5::bootup_usbclk_10khz"]
        [::core::mem::offset_of!(atom_smu_info_v3_5, bootup_usbclk_10khz) - 92usize];
    ["Offset of field: atom_smu_info_v3_5::smb_slave_address"]
        [::core::mem::offset_of!(atom_smu_info_v3_5, smb_slave_address) - 96usize];
    ["Offset of field: atom_smu_info_v3_5::cg_fdo_ctrl0_val"]
        [::core::mem::offset_of!(atom_smu_info_v3_5, cg_fdo_ctrl0_val) - 100usize];
    ["Offset of field: atom_smu_info_v3_5::cg_fdo_ctrl1_val"]
        [::core::mem::offset_of!(atom_smu_info_v3_5, cg_fdo_ctrl1_val) - 104usize];
    ["Offset of field: atom_smu_info_v3_5::cg_fdo_ctrl2_val"]
        [::core::mem::offset_of!(atom_smu_info_v3_5, cg_fdo_ctrl2_val) - 108usize];
    ["Offset of field: atom_smu_info_v3_5::gdfll_as_wait_ctrl_val"]
        [::core::mem::offset_of!(atom_smu_info_v3_5, gdfll_as_wait_ctrl_val) - 112usize];
    ["Offset of field: atom_smu_info_v3_5::gdfll_as_step_ctrl_val"]
        [::core::mem::offset_of!(atom_smu_info_v3_5, gdfll_as_step_ctrl_val) - 116usize];
    ["Offset of field: atom_smu_info_v3_5::bootup_dtbclk_10khz"]
        [::core::mem::offset_of!(atom_smu_info_v3_5, bootup_dtbclk_10khz) - 120usize];
    ["Offset of field: atom_smu_info_v3_5::fclk_syspll_refclk_10khz"]
        [::core::mem::offset_of!(atom_smu_info_v3_5, fclk_syspll_refclk_10khz) - 124usize];
    ["Offset of field: atom_smu_info_v3_5::smusvi_svc0_val"]
        [::core::mem::offset_of!(atom_smu_info_v3_5, smusvi_svc0_val) - 128usize];
    ["Offset of field: atom_smu_info_v3_5::smusvi_svc1_val"]
        [::core::mem::offset_of!(atom_smu_info_v3_5, smusvi_svc1_val) - 132usize];
    ["Offset of field: atom_smu_info_v3_5::smusvi_svd0_val"]
        [::core::mem::offset_of!(atom_smu_info_v3_5, smusvi_svd0_val) - 136usize];
    ["Offset of field: atom_smu_info_v3_5::smusvi_svd1_val"]
        [::core::mem::offset_of!(atom_smu_info_v3_5, smusvi_svd1_val) - 140usize];
    ["Offset of field: atom_smu_info_v3_5::smusvi_svt0_val"]
        [::core::mem::offset_of!(atom_smu_info_v3_5, smusvi_svt0_val) - 144usize];
    ["Offset of field: atom_smu_info_v3_5::smusvi_svt1_val"]
        [::core::mem::offset_of!(atom_smu_info_v3_5, smusvi_svt1_val) - 148usize];
    ["Offset of field: atom_smu_info_v3_5::cg_tach_ctrl_val"]
        [::core::mem::offset_of!(atom_smu_info_v3_5, cg_tach_ctrl_val) - 152usize];
    ["Offset of field: atom_smu_info_v3_5::cg_pump_ctrl1_val"]
        [::core::mem::offset_of!(atom_smu_info_v3_5, cg_pump_ctrl1_val) - 156usize];
    ["Offset of field: atom_smu_info_v3_5::cg_pump_tach_ctrl_val"]
        [::core::mem::offset_of!(atom_smu_info_v3_5, cg_pump_tach_ctrl_val) - 160usize];
    ["Offset of field: atom_smu_info_v3_5::thm_ctf_delay_val"]
        [::core::mem::offset_of!(atom_smu_info_v3_5, thm_ctf_delay_val) - 164usize];
    ["Offset of field: atom_smu_info_v3_5::thm_thermal_int_ctrl_val"]
        [::core::mem::offset_of!(atom_smu_info_v3_5, thm_thermal_int_ctrl_val) - 168usize];
    ["Offset of field: atom_smu_info_v3_5::thm_tmon_config_val"]
        [::core::mem::offset_of!(atom_smu_info_v3_5, thm_tmon_config_val) - 172usize];
    ["Offset of field: atom_smu_info_v3_5::reserved"]
        [::core::mem::offset_of!(atom_smu_info_v3_5, reserved) - 176usize];
};
#[repr(C, packed)]
#[derive(Debug, Copy, Clone)]
pub struct atom_smu_info_v3_6 {
    pub table_header: atom_common_table_header,
    pub smuip_min_ver: u8,
    pub smuip_max_ver: u8,
    pub waflclk_ss_mode: u8,
    pub gpuclk_ss_mode: u8,
    pub sclk_ss_percentage: u16,
    pub sclk_ss_rate_10hz: u16,
    pub gpuclk_ss_percentage: u16,
    pub gpuclk_ss_rate_10hz: u16,
    pub core_refclk_10khz: u32,
    pub syspll0_1_vco_freq_10khz: u32,
    pub syspll0_2_vco_freq_10khz: u32,
    pub pcc_gpio_bit: u8,
    pub pcc_gpio_polarity: u8,
    pub smugoldenoffset: u16,
    pub syspll0_0_vco_freq_10khz: u32,
    pub bootup_smnclk_10khz: u32,
    pub bootup_socclk_10khz: u32,
    pub bootup_mp0clk_10khz: u32,
    pub bootup_mp1clk_10khz: u32,
    pub bootup_lclk_10khz: u32,
    pub bootup_dxioclk_10khz: u32,
    pub ctf_threshold_override_value: u32,
    pub syspll3_0_vco_freq_10khz: u32,
    pub syspll3_1_vco_freq_10khz: u32,
    pub bootup_fclk_10khz: u32,
    pub bootup_waflclk_10khz: u32,
    pub smu_info_caps: u32,
    pub waflclk_ss_percentage: u16,
    pub smuinitoffset: u16,
    pub bootup_gfxavsclk_10khz: u32,
    pub bootup_mpioclk_10khz: u32,
    pub smb_slave_address: u32,
    pub cg_fdo_ctrl0_val: u32,
    pub cg_fdo_ctrl1_val: u32,
    pub cg_fdo_ctrl2_val: u32,
    pub gdfll_as_wait_ctrl_val: u32,
    pub gdfll_as_step_ctrl_val: u32,
    pub reserved_clk: u32,
    pub fclk_syspll_refclk_10khz: u32,
    pub smusvi_svc0_val: u32,
    pub smusvi_svc1_val: u32,
    pub smusvi_svd0_val: u32,
    pub smusvi_svd1_val: u32,
    pub smusvi_svt0_val: u32,
    pub smusvi_svt1_val: u32,
    pub cg_tach_ctrl_val: u32,
    pub cg_pump_ctrl1_val: u32,
    pub cg_pump_tach_ctrl_val: u32,
    pub thm_ctf_delay_val: u32,
    pub thm_thermal_int_ctrl_val: u32,
    pub thm_tmon_config_val: u32,
    pub bootup_vclk_10khz: u32,
    pub bootup_dclk_10khz: u32,
    pub smu_gpiopad_pu_en_val: u32,
    pub smu_gpiopad_pd_en_val: u32,
    pub reserved: [u32; 12usize],
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of atom_smu_info_v3_6"][::core::mem::size_of::<atom_smu_info_v3_6>() - 240usize];
    ["Alignment of atom_smu_info_v3_6"][::core::mem::align_of::<atom_smu_info_v3_6>() - 1usize];
    ["Offset of field: atom_smu_info_v3_6::table_header"]
        [::core::mem::offset_of!(atom_smu_info_v3_6, table_header) - 0usize];
    ["Offset of field: atom_smu_info_v3_6::smuip_min_ver"]
        [::core::mem::offset_of!(atom_smu_info_v3_6, smuip_min_ver) - 4usize];
    ["Offset of field: atom_smu_info_v3_6::smuip_max_ver"]
        [::core::mem::offset_of!(atom_smu_info_v3_6, smuip_max_ver) - 5usize];
    ["Offset of field: atom_smu_info_v3_6::waflclk_ss_mode"]
        [::core::mem::offset_of!(atom_smu_info_v3_6, waflclk_ss_mode) - 6usize];
    ["Offset of field: atom_smu_info_v3_6::gpuclk_ss_mode"]
        [::core::mem::offset_of!(atom_smu_info_v3_6, gpuclk_ss_mode) - 7usize];
    ["Offset of field: atom_smu_info_v3_6::sclk_ss_percentage"]
        [::core::mem::offset_of!(atom_smu_info_v3_6, sclk_ss_percentage) - 8usize];
    ["Offset of field: atom_smu_info_v3_6::sclk_ss_rate_10hz"]
        [::core::mem::offset_of!(atom_smu_info_v3_6, sclk_ss_rate_10hz) - 10usize];
    ["Offset of field: atom_smu_info_v3_6::gpuclk_ss_percentage"]
        [::core::mem::offset_of!(atom_smu_info_v3_6, gpuclk_ss_percentage) - 12usize];
    ["Offset of field: atom_smu_info_v3_6::gpuclk_ss_rate_10hz"]
        [::core::mem::offset_of!(atom_smu_info_v3_6, gpuclk_ss_rate_10hz) - 14usize];
    ["Offset of field: atom_smu_info_v3_6::core_refclk_10khz"]
        [::core::mem::offset_of!(atom_smu_info_v3_6, core_refclk_10khz) - 16usize];
    ["Offset of field: atom_smu_info_v3_6::syspll0_1_vco_freq_10khz"]
        [::core::mem::offset_of!(atom_smu_info_v3_6, syspll0_1_vco_freq_10khz) - 20usize];
    ["Offset of field: atom_smu_info_v3_6::syspll0_2_vco_freq_10khz"]
        [::core::mem::offset_of!(atom_smu_info_v3_6, syspll0_2_vco_freq_10khz) - 24usize];
    ["Offset of field: atom_smu_info_v3_6::pcc_gpio_bit"]
        [::core::mem::offset_of!(atom_smu_info_v3_6, pcc_gpio_bit) - 28usize];
    ["Offset of field: atom_smu_info_v3_6::pcc_gpio_polarity"]
        [::core::mem::offset_of!(atom_smu_info_v3_6, pcc_gpio_polarity) - 29usize];
    ["Offset of field: atom_smu_info_v3_6::smugoldenoffset"]
        [::core::mem::offset_of!(atom_smu_info_v3_6, smugoldenoffset) - 30usize];
    ["Offset of field: atom_smu_info_v3_6::syspll0_0_vco_freq_10khz"]
        [::core::mem::offset_of!(atom_smu_info_v3_6, syspll0_0_vco_freq_10khz) - 32usize];
    ["Offset of field: atom_smu_info_v3_6::bootup_smnclk_10khz"]
        [::core::mem::offset_of!(atom_smu_info_v3_6, bootup_smnclk_10khz) - 36usize];
    ["Offset of field: atom_smu_info_v3_6::bootup_socclk_10khz"]
        [::core::mem::offset_of!(atom_smu_info_v3_6, bootup_socclk_10khz) - 40usize];
    ["Offset of field: atom_smu_info_v3_6::bootup_mp0clk_10khz"]
        [::core::mem::offset_of!(atom_smu_info_v3_6, bootup_mp0clk_10khz) - 44usize];
    ["Offset of field: atom_smu_info_v3_6::bootup_mp1clk_10khz"]
        [::core::mem::offset_of!(atom_smu_info_v3_6, bootup_mp1clk_10khz) - 48usize];
    ["Offset of field: atom_smu_info_v3_6::bootup_lclk_10khz"]
        [::core::mem::offset_of!(atom_smu_info_v3_6, bootup_lclk_10khz) - 52usize];
    ["Offset of field: atom_smu_info_v3_6::bootup_dxioclk_10khz"]
        [::core::mem::offset_of!(atom_smu_info_v3_6, bootup_dxioclk_10khz) - 56usize];
    ["Offset of field: atom_smu_info_v3_6::ctf_threshold_override_value"]
        [::core::mem::offset_of!(atom_smu_info_v3_6, ctf_threshold_override_value) - 60usize];
    ["Offset of field: atom_smu_info_v3_6::syspll3_0_vco_freq_10khz"]
        [::core::mem::offset_of!(atom_smu_info_v3_6, syspll3_0_vco_freq_10khz) - 64usize];
    ["Offset of field: atom_smu_info_v3_6::syspll3_1_vco_freq_10khz"]
        [::core::mem::offset_of!(atom_smu_info_v3_6, syspll3_1_vco_freq_10khz) - 68usize];
    ["Offset of field: atom_smu_info_v3_6::bootup_fclk_10khz"]
        [::core::mem::offset_of!(atom_smu_info_v3_6, bootup_fclk_10khz) - 72usize];
    ["Offset of field: atom_smu_info_v3_6::bootup_waflclk_10khz"]
        [::core::mem::offset_of!(atom_smu_info_v3_6, bootup_waflclk_10khz) - 76usize];
    ["Offset of field: atom_smu_info_v3_6::smu_info_caps"]
        [::core::mem::offset_of!(atom_smu_info_v3_6, smu_info_caps) - 80usize];
    ["Offset of field: atom_smu_info_v3_6::waflclk_ss_percentage"]
        [::core::mem::offset_of!(atom_smu_info_v3_6, waflclk_ss_percentage) - 84usize];
    ["Offset of field: atom_smu_info_v3_6::smuinitoffset"]
        [::core::mem::offset_of!(atom_smu_info_v3_6, smuinitoffset) - 86usize];
    ["Offset of field: atom_smu_info_v3_6::bootup_gfxavsclk_10khz"]
        [::core::mem::offset_of!(atom_smu_info_v3_6, bootup_gfxavsclk_10khz) - 88usize];
    ["Offset of field: atom_smu_info_v3_6::bootup_mpioclk_10khz"]
        [::core::mem::offset_of!(atom_smu_info_v3_6, bootup_mpioclk_10khz) - 92usize];
    ["Offset of field: atom_smu_info_v3_6::smb_slave_address"]
        [::core::mem::offset_of!(atom_smu_info_v3_6, smb_slave_address) - 96usize];
    ["Offset of field: atom_smu_info_v3_6::cg_fdo_ctrl0_val"]
        [::core::mem::offset_of!(atom_smu_info_v3_6, cg_fdo_ctrl0_val) - 100usize];
    ["Offset of field: atom_smu_info_v3_6::cg_fdo_ctrl1_val"]
        [::core::mem::offset_of!(atom_smu_info_v3_6, cg_fdo_ctrl1_val) - 104usize];
    ["Offset of field: atom_smu_info_v3_6::cg_fdo_ctrl2_val"]
        [::core::mem::offset_of!(atom_smu_info_v3_6, cg_fdo_ctrl2_val) - 108usize];
    ["Offset of field: atom_smu_info_v3_6::gdfll_as_wait_ctrl_val"]
        [::core::mem::offset_of!(atom_smu_info_v3_6, gdfll_as_wait_ctrl_val) - 112usize];
    ["Offset of field: atom_smu_info_v3_6::gdfll_as_step_ctrl_val"]
        [::core::mem::offset_of!(atom_smu_info_v3_6, gdfll_as_step_ctrl_val) - 116usize];
    ["Offset of field: atom_smu_info_v3_6::reserved_clk"]
        [::core::mem::offset_of!(atom_smu_info_v3_6, reserved_clk) - 120usize];
    ["Offset of field: atom_smu_info_v3_6::fclk_syspll_refclk_10khz"]
        [::core::mem::offset_of!(atom_smu_info_v3_6, fclk_syspll_refclk_10khz) - 124usize];
    ["Offset of field: atom_smu_info_v3_6::smusvi_svc0_val"]
        [::core::mem::offset_of!(atom_smu_info_v3_6, smusvi_svc0_val) - 128usize];
    ["Offset of field: atom_smu_info_v3_6::smusvi_svc1_val"]
        [::core::mem::offset_of!(atom_smu_info_v3_6, smusvi_svc1_val) - 132usize];
    ["Offset of field: atom_smu_info_v3_6::smusvi_svd0_val"]
        [::core::mem::offset_of!(atom_smu_info_v3_6, smusvi_svd0_val) - 136usize];
    ["Offset of field: atom_smu_info_v3_6::smusvi_svd1_val"]
        [::core::mem::offset_of!(atom_smu_info_v3_6, smusvi_svd1_val) - 140usize];
    ["Offset of field: atom_smu_info_v3_6::smusvi_svt0_val"]
        [::core::mem::offset_of!(atom_smu_info_v3_6, smusvi_svt0_val) - 144usize];
    ["Offset of field: atom_smu_info_v3_6::smusvi_svt1_val"]
        [::core::mem::offset_of!(atom_smu_info_v3_6, smusvi_svt1_val) - 148usize];
    ["Offset of field: atom_smu_info_v3_6::cg_tach_ctrl_val"]
        [::core::mem::offset_of!(atom_smu_info_v3_6, cg_tach_ctrl_val) - 152usize];
    ["Offset of field: atom_smu_info_v3_6::cg_pump_ctrl1_val"]
        [::core::mem::offset_of!(atom_smu_info_v3_6, cg_pump_ctrl1_val) - 156usize];
    ["Offset of field: atom_smu_info_v3_6::cg_pump_tach_ctrl_val"]
        [::core::mem::offset_of!(atom_smu_info_v3_6, cg_pump_tach_ctrl_val) - 160usize];
    ["Offset of field: atom_smu_info_v3_6::thm_ctf_delay_val"]
        [::core::mem::offset_of!(atom_smu_info_v3_6, thm_ctf_delay_val) - 164usize];
    ["Offset of field: atom_smu_info_v3_6::thm_thermal_int_ctrl_val"]
        [::core::mem::offset_of!(atom_smu_info_v3_6, thm_thermal_int_ctrl_val) - 168usize];
    ["Offset of field: atom_smu_info_v3_6::thm_tmon_config_val"]
        [::core::mem::offset_of!(atom_smu_info_v3_6, thm_tmon_config_val) - 172usize];
    ["Offset of field: atom_smu_info_v3_6::bootup_vclk_10khz"]
        [::core::mem::offset_of!(atom_smu_info_v3_6, bootup_vclk_10khz) - 176usize];
    ["Offset of field: atom_smu_info_v3_6::bootup_dclk_10khz"]
        [::core::mem::offset_of!(atom_smu_info_v3_6, bootup_dclk_10khz) - 180usize];
    ["Offset of field: atom_smu_info_v3_6::smu_gpiopad_pu_en_val"]
        [::core::mem::offset_of!(atom_smu_info_v3_6, smu_gpiopad_pu_en_val) - 184usize];
    ["Offset of field: atom_smu_info_v3_6::smu_gpiopad_pd_en_val"]
        [::core::mem::offset_of!(atom_smu_info_v3_6, smu_gpiopad_pd_en_val) - 188usize];
    ["Offset of field: atom_smu_info_v3_6::reserved"]
        [::core::mem::offset_of!(atom_smu_info_v3_6, reserved) - 192usize];
};
#[repr(C, packed)]
#[derive(Debug, Copy, Clone)]
pub struct atom_smu_info_v4_0 {
    pub table_header: atom_common_table_header,
    pub bootup_gfxclk_bypass_10khz: u32,
    pub bootup_usrclk_10khz: u32,
    pub bootup_csrclk_10khz: u32,
    pub core_refclk_10khz: u32,
    pub syspll1_vco_freq_10khz: u32,
    pub syspll2_vco_freq_10khz: u32,
    pub pcc_gpio_bit: u8,
    pub pcc_gpio_polarity: u8,
    pub bootup_vddusr_mv: u16,
    pub syspll0_vco_freq_10khz: u32,
    pub bootup_smnclk_10khz: u32,
    pub bootup_socclk_10khz: u32,
    pub bootup_mp0clk_10khz: u32,
    pub bootup_mp1clk_10khz: u32,
    pub bootup_lclk_10khz: u32,
    pub bootup_dcefclk_10khz: u32,
    pub ctf_threshold_override_value: u32,
    pub syspll3_vco_freq_10khz: u32,
    pub mm_syspll_vco_freq_10khz: u32,
    pub bootup_fclk_10khz: u32,
    pub bootup_waflclk_10khz: u32,
    pub smu_info_caps: u32,
    pub waflclk_ss_percentage: u16,
    pub smuinitoffset: u16,
    pub bootup_dprefclk_10khz: u32,
    pub bootup_usbclk_10khz: u32,
    pub smb_slave_address: u32,
    pub cg_fdo_ctrl0_val: u32,
    pub cg_fdo_ctrl1_val: u32,
    pub cg_fdo_ctrl2_val: u32,
    pub gdfll_as_wait_ctrl_val: u32,
    pub gdfll_as_step_ctrl_val: u32,
    pub bootup_dtbclk_10khz: u32,
    pub fclk_syspll_refclk_10khz: u32,
    pub smusvi_svc0_val: u32,
    pub smusvi_svc1_val: u32,
    pub smusvi_svd0_val: u32,
    pub smusvi_svd1_val: u32,
    pub smusvi_svt0_val: u32,
    pub smusvi_svt1_val: u32,
    pub cg_tach_ctrl_val: u32,
    pub cg_pump_ctrl1_val: u32,
    pub cg_pump_tach_ctrl_val: u32,
    pub thm_ctf_delay_val: u32,
    pub thm_thermal_int_ctrl_val: u32,
    pub thm_tmon_config_val: u32,
    pub smbus_timing_cntrl0_val: u32,
    pub smbus_timing_cntrl1_val: u32,
    pub smbus_timing_cntrl2_val: u32,
    pub pwr_disp_timer_global_control_val: u32,
    pub bootup_mpioclk_10khz: u32,
    pub bootup_dclk0_10khz: u32,
    pub bootup_vclk0_10khz: u32,
    pub bootup_dclk1_10khz: u32,
    pub bootup_vclk1_10khz: u32,
    pub bootup_baco400clk_10khz: u32,
    pub bootup_baco1200clk_bypass_10khz: u32,
    pub bootup_baco700clk_bypass_10khz: u32,
    pub reserved: [u32; 16usize],
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of atom_smu_info_v4_0"][::core::mem::size_of::<atom_smu_info_v4_0>() - 288usize];
    ["Alignment of atom_smu_info_v4_0"][::core::mem::align_of::<atom_smu_info_v4_0>() - 1usize];
    ["Offset of field: atom_smu_info_v4_0::table_header"]
        [::core::mem::offset_of!(atom_smu_info_v4_0, table_header) - 0usize];
    ["Offset of field: atom_smu_info_v4_0::bootup_gfxclk_bypass_10khz"]
        [::core::mem::offset_of!(atom_smu_info_v4_0, bootup_gfxclk_bypass_10khz) - 4usize];
    ["Offset of field: atom_smu_info_v4_0::bootup_usrclk_10khz"]
        [::core::mem::offset_of!(atom_smu_info_v4_0, bootup_usrclk_10khz) - 8usize];
    ["Offset of field: atom_smu_info_v4_0::bootup_csrclk_10khz"]
        [::core::mem::offset_of!(atom_smu_info_v4_0, bootup_csrclk_10khz) - 12usize];
    ["Offset of field: atom_smu_info_v4_0::core_refclk_10khz"]
        [::core::mem::offset_of!(atom_smu_info_v4_0, core_refclk_10khz) - 16usize];
    ["Offset of field: atom_smu_info_v4_0::syspll1_vco_freq_10khz"]
        [::core::mem::offset_of!(atom_smu_info_v4_0, syspll1_vco_freq_10khz) - 20usize];
    ["Offset of field: atom_smu_info_v4_0::syspll2_vco_freq_10khz"]
        [::core::mem::offset_of!(atom_smu_info_v4_0, syspll2_vco_freq_10khz) - 24usize];
    ["Offset of field: atom_smu_info_v4_0::pcc_gpio_bit"]
        [::core::mem::offset_of!(atom_smu_info_v4_0, pcc_gpio_bit) - 28usize];
    ["Offset of field: atom_smu_info_v4_0::pcc_gpio_polarity"]
        [::core::mem::offset_of!(atom_smu_info_v4_0, pcc_gpio_polarity) - 29usize];
    ["Offset of field: atom_smu_info_v4_0::bootup_vddusr_mv"]
        [::core::mem::offset_of!(atom_smu_info_v4_0, bootup_vddusr_mv) - 30usize];
    ["Offset of field: atom_smu_info_v4_0::syspll0_vco_freq_10khz"]
        [::core::mem::offset_of!(atom_smu_info_v4_0, syspll0_vco_freq_10khz) - 32usize];
    ["Offset of field: atom_smu_info_v4_0::bootup_smnclk_10khz"]
        [::core::mem::offset_of!(atom_smu_info_v4_0, bootup_smnclk_10khz) - 36usize];
    ["Offset of field: atom_smu_info_v4_0::bootup_socclk_10khz"]
        [::core::mem::offset_of!(atom_smu_info_v4_0, bootup_socclk_10khz) - 40usize];
    ["Offset of field: atom_smu_info_v4_0::bootup_mp0clk_10khz"]
        [::core::mem::offset_of!(atom_smu_info_v4_0, bootup_mp0clk_10khz) - 44usize];
    ["Offset of field: atom_smu_info_v4_0::bootup_mp1clk_10khz"]
        [::core::mem::offset_of!(atom_smu_info_v4_0, bootup_mp1clk_10khz) - 48usize];
    ["Offset of field: atom_smu_info_v4_0::bootup_lclk_10khz"]
        [::core::mem::offset_of!(atom_smu_info_v4_0, bootup_lclk_10khz) - 52usize];
    ["Offset of field: atom_smu_info_v4_0::bootup_dcefclk_10khz"]
        [::core::mem::offset_of!(atom_smu_info_v4_0, bootup_dcefclk_10khz) - 56usize];
    ["Offset of field: atom_smu_info_v4_0::ctf_threshold_override_value"]
        [::core::mem::offset_of!(atom_smu_info_v4_0, ctf_threshold_override_value) - 60usize];
    ["Offset of field: atom_smu_info_v4_0::syspll3_vco_freq_10khz"]
        [::core::mem::offset_of!(atom_smu_info_v4_0, syspll3_vco_freq_10khz) - 64usize];
    ["Offset of field: atom_smu_info_v4_0::mm_syspll_vco_freq_10khz"]
        [::core::mem::offset_of!(atom_smu_info_v4_0, mm_syspll_vco_freq_10khz) - 68usize];
    ["Offset of field: atom_smu_info_v4_0::bootup_fclk_10khz"]
        [::core::mem::offset_of!(atom_smu_info_v4_0, bootup_fclk_10khz) - 72usize];
    ["Offset of field: atom_smu_info_v4_0::bootup_waflclk_10khz"]
        [::core::mem::offset_of!(atom_smu_info_v4_0, bootup_waflclk_10khz) - 76usize];
    ["Offset of field: atom_smu_info_v4_0::smu_info_caps"]
        [::core::mem::offset_of!(atom_smu_info_v4_0, smu_info_caps) - 80usize];
    ["Offset of field: atom_smu_info_v4_0::waflclk_ss_percentage"]
        [::core::mem::offset_of!(atom_smu_info_v4_0, waflclk_ss_percentage) - 84usize];
    ["Offset of field: atom_smu_info_v4_0::smuinitoffset"]
        [::core::mem::offset_of!(atom_smu_info_v4_0, smuinitoffset) - 86usize];
    ["Offset of field: atom_smu_info_v4_0::bootup_dprefclk_10khz"]
        [::core::mem::offset_of!(atom_smu_info_v4_0, bootup_dprefclk_10khz) - 88usize];
    ["Offset of field: atom_smu_info_v4_0::bootup_usbclk_10khz"]
        [::core::mem::offset_of!(atom_smu_info_v4_0, bootup_usbclk_10khz) - 92usize];
    ["Offset of field: atom_smu_info_v4_0::smb_slave_address"]
        [::core::mem::offset_of!(atom_smu_info_v4_0, smb_slave_address) - 96usize];
    ["Offset of field: atom_smu_info_v4_0::cg_fdo_ctrl0_val"]
        [::core::mem::offset_of!(atom_smu_info_v4_0, cg_fdo_ctrl0_val) - 100usize];
    ["Offset of field: atom_smu_info_v4_0::cg_fdo_ctrl1_val"]
        [::core::mem::offset_of!(atom_smu_info_v4_0, cg_fdo_ctrl1_val) - 104usize];
    ["Offset of field: atom_smu_info_v4_0::cg_fdo_ctrl2_val"]
        [::core::mem::offset_of!(atom_smu_info_v4_0, cg_fdo_ctrl2_val) - 108usize];
    ["Offset of field: atom_smu_info_v4_0::gdfll_as_wait_ctrl_val"]
        [::core::mem::offset_of!(atom_smu_info_v4_0, gdfll_as_wait_ctrl_val) - 112usize];
    ["Offset of field: atom_smu_info_v4_0::gdfll_as_step_ctrl_val"]
        [::core::mem::offset_of!(atom_smu_info_v4_0, gdfll_as_step_ctrl_val) - 116usize];
    ["Offset of field: atom_smu_info_v4_0::bootup_dtbclk_10khz"]
        [::core::mem::offset_of!(atom_smu_info_v4_0, bootup_dtbclk_10khz) - 120usize];
    ["Offset of field: atom_smu_info_v4_0::fclk_syspll_refclk_10khz"]
        [::core::mem::offset_of!(atom_smu_info_v4_0, fclk_syspll_refclk_10khz) - 124usize];
    ["Offset of field: atom_smu_info_v4_0::smusvi_svc0_val"]
        [::core::mem::offset_of!(atom_smu_info_v4_0, smusvi_svc0_val) - 128usize];
    ["Offset of field: atom_smu_info_v4_0::smusvi_svc1_val"]
        [::core::mem::offset_of!(atom_smu_info_v4_0, smusvi_svc1_val) - 132usize];
    ["Offset of field: atom_smu_info_v4_0::smusvi_svd0_val"]
        [::core::mem::offset_of!(atom_smu_info_v4_0, smusvi_svd0_val) - 136usize];
    ["Offset of field: atom_smu_info_v4_0::smusvi_svd1_val"]
        [::core::mem::offset_of!(atom_smu_info_v4_0, smusvi_svd1_val) - 140usize];
    ["Offset of field: atom_smu_info_v4_0::smusvi_svt0_val"]
        [::core::mem::offset_of!(atom_smu_info_v4_0, smusvi_svt0_val) - 144usize];
    ["Offset of field: atom_smu_info_v4_0::smusvi_svt1_val"]
        [::core::mem::offset_of!(atom_smu_info_v4_0, smusvi_svt1_val) - 148usize];
    ["Offset of field: atom_smu_info_v4_0::cg_tach_ctrl_val"]
        [::core::mem::offset_of!(atom_smu_info_v4_0, cg_tach_ctrl_val) - 152usize];
    ["Offset of field: atom_smu_info_v4_0::cg_pump_ctrl1_val"]
        [::core::mem::offset_of!(atom_smu_info_v4_0, cg_pump_ctrl1_val) - 156usize];
    ["Offset of field: atom_smu_info_v4_0::cg_pump_tach_ctrl_val"]
        [::core::mem::offset_of!(atom_smu_info_v4_0, cg_pump_tach_ctrl_val) - 160usize];
    ["Offset of field: atom_smu_info_v4_0::thm_ctf_delay_val"]
        [::core::mem::offset_of!(atom_smu_info_v4_0, thm_ctf_delay_val) - 164usize];
    ["Offset of field: atom_smu_info_v4_0::thm_thermal_int_ctrl_val"]
        [::core::mem::offset_of!(atom_smu_info_v4_0, thm_thermal_int_ctrl_val) - 168usize];
    ["Offset of field: atom_smu_info_v4_0::thm_tmon_config_val"]
        [::core::mem::offset_of!(atom_smu_info_v4_0, thm_tmon_config_val) - 172usize];
    ["Offset of field: atom_smu_info_v4_0::smbus_timing_cntrl0_val"]
        [::core::mem::offset_of!(atom_smu_info_v4_0, smbus_timing_cntrl0_val) - 176usize];
    ["Offset of field: atom_smu_info_v4_0::smbus_timing_cntrl1_val"]
        [::core::mem::offset_of!(atom_smu_info_v4_0, smbus_timing_cntrl1_val) - 180usize];
    ["Offset of field: atom_smu_info_v4_0::smbus_timing_cntrl2_val"]
        [::core::mem::offset_of!(atom_smu_info_v4_0, smbus_timing_cntrl2_val) - 184usize];
    ["Offset of field: atom_smu_info_v4_0::pwr_disp_timer_global_control_val"]
        [::core::mem::offset_of!(atom_smu_info_v4_0, pwr_disp_timer_global_control_val) - 188usize];
    ["Offset of field: atom_smu_info_v4_0::bootup_mpioclk_10khz"]
        [::core::mem::offset_of!(atom_smu_info_v4_0, bootup_mpioclk_10khz) - 192usize];
    ["Offset of field: atom_smu_info_v4_0::bootup_dclk0_10khz"]
        [::core::mem::offset_of!(atom_smu_info_v4_0, bootup_dclk0_10khz) - 196usize];
    ["Offset of field: atom_smu_info_v4_0::bootup_vclk0_10khz"]
        [::core::mem::offset_of!(atom_smu_info_v4_0, bootup_vclk0_10khz) - 200usize];
    ["Offset of field: atom_smu_info_v4_0::bootup_dclk1_10khz"]
        [::core::mem::offset_of!(atom_smu_info_v4_0, bootup_dclk1_10khz) - 204usize];
    ["Offset of field: atom_smu_info_v4_0::bootup_vclk1_10khz"]
        [::core::mem::offset_of!(atom_smu_info_v4_0, bootup_vclk1_10khz) - 208usize];
    ["Offset of field: atom_smu_info_v4_0::bootup_baco400clk_10khz"]
        [::core::mem::offset_of!(atom_smu_info_v4_0, bootup_baco400clk_10khz) - 212usize];
    ["Offset of field: atom_smu_info_v4_0::bootup_baco1200clk_bypass_10khz"]
        [::core::mem::offset_of!(atom_smu_info_v4_0, bootup_baco1200clk_bypass_10khz) - 216usize];
    ["Offset of field: atom_smu_info_v4_0::bootup_baco700clk_bypass_10khz"]
        [::core::mem::offset_of!(atom_smu_info_v4_0, bootup_baco700clk_bypass_10khz) - 220usize];
    ["Offset of field: atom_smu_info_v4_0::reserved"]
        [::core::mem::offset_of!(atom_smu_info_v4_0, reserved) - 224usize];
};
#[repr(C, packed)]
#[derive(Debug, Copy, Clone)]
pub struct atom_smc_dpm_info_v4_1 {
    pub table_header: atom_common_table_header,
    pub liquid1_i2c_address: u8,
    pub liquid2_i2c_address: u8,
    pub vr_i2c_address: u8,
    pub plx_i2c_address: u8,
    pub liquid_i2c_linescl: u8,
    pub liquid_i2c_linesda: u8,
    pub vr_i2c_linescl: u8,
    pub vr_i2c_linesda: u8,
    pub plx_i2c_linescl: u8,
    pub plx_i2c_linesda: u8,
    pub vrsensorpresent: u8,
    pub liquidsensorpresent: u8,
    pub maxvoltagestepgfx: u16,
    pub maxvoltagestepsoc: u16,
    pub vddgfxvrmapping: u8,
    pub vddsocvrmapping: u8,
    pub vddmem0vrmapping: u8,
    pub vddmem1vrmapping: u8,
    pub gfxulvphasesheddingmask: u8,
    pub soculvphasesheddingmask: u8,
    pub padding8_v: [u8; 2usize],
    pub gfxmaxcurrent: u16,
    pub gfxoffset: u8,
    pub padding_telemetrygfx: u8,
    pub socmaxcurrent: u16,
    pub socoffset: u8,
    pub padding_telemetrysoc: u8,
    pub mem0maxcurrent: u16,
    pub mem0offset: u8,
    pub padding_telemetrymem0: u8,
    pub mem1maxcurrent: u16,
    pub mem1offset: u8,
    pub padding_telemetrymem1: u8,
    pub acdcgpio: u8,
    pub acdcpolarity: u8,
    pub vr0hotgpio: u8,
    pub vr0hotpolarity: u8,
    pub vr1hotgpio: u8,
    pub vr1hotpolarity: u8,
    pub padding1: u8,
    pub padding2: u8,
    pub ledpin0: u8,
    pub ledpin1: u8,
    pub ledpin2: u8,
    pub padding8_4: u8,
    pub pllgfxclkspreadenabled: u8,
    pub pllgfxclkspreadpercent: u8,
    pub pllgfxclkspreadfreq: u16,
    pub uclkspreadenabled: u8,
    pub uclkspreadpercent: u8,
    pub uclkspreadfreq: u16,
    pub socclkspreadenabled: u8,
    pub socclkspreadpercent: u8,
    pub socclkspreadfreq: u16,
    pub acggfxclkspreadenabled: u8,
    pub acggfxclkspreadpercent: u8,
    pub acggfxclkspreadfreq: u16,
    pub Vr2_I2C_address: u8,
    pub padding_vr2: [u8; 3usize],
    pub boardreserved: [u32; 9usize],
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of atom_smc_dpm_info_v4_1"][::core::mem::size_of::<atom_smc_dpm_info_v4_1>() - 112usize];
    ["Alignment of atom_smc_dpm_info_v4_1"]
        [::core::mem::align_of::<atom_smc_dpm_info_v4_1>() - 1usize];
    ["Offset of field: atom_smc_dpm_info_v4_1::table_header"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_1, table_header) - 0usize];
    ["Offset of field: atom_smc_dpm_info_v4_1::liquid1_i2c_address"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_1, liquid1_i2c_address) - 4usize];
    ["Offset of field: atom_smc_dpm_info_v4_1::liquid2_i2c_address"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_1, liquid2_i2c_address) - 5usize];
    ["Offset of field: atom_smc_dpm_info_v4_1::vr_i2c_address"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_1, vr_i2c_address) - 6usize];
    ["Offset of field: atom_smc_dpm_info_v4_1::plx_i2c_address"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_1, plx_i2c_address) - 7usize];
    ["Offset of field: atom_smc_dpm_info_v4_1::liquid_i2c_linescl"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_1, liquid_i2c_linescl) - 8usize];
    ["Offset of field: atom_smc_dpm_info_v4_1::liquid_i2c_linesda"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_1, liquid_i2c_linesda) - 9usize];
    ["Offset of field: atom_smc_dpm_info_v4_1::vr_i2c_linescl"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_1, vr_i2c_linescl) - 10usize];
    ["Offset of field: atom_smc_dpm_info_v4_1::vr_i2c_linesda"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_1, vr_i2c_linesda) - 11usize];
    ["Offset of field: atom_smc_dpm_info_v4_1::plx_i2c_linescl"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_1, plx_i2c_linescl) - 12usize];
    ["Offset of field: atom_smc_dpm_info_v4_1::plx_i2c_linesda"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_1, plx_i2c_linesda) - 13usize];
    ["Offset of field: atom_smc_dpm_info_v4_1::vrsensorpresent"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_1, vrsensorpresent) - 14usize];
    ["Offset of field: atom_smc_dpm_info_v4_1::liquidsensorpresent"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_1, liquidsensorpresent) - 15usize];
    ["Offset of field: atom_smc_dpm_info_v4_1::maxvoltagestepgfx"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_1, maxvoltagestepgfx) - 16usize];
    ["Offset of field: atom_smc_dpm_info_v4_1::maxvoltagestepsoc"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_1, maxvoltagestepsoc) - 18usize];
    ["Offset of field: atom_smc_dpm_info_v4_1::vddgfxvrmapping"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_1, vddgfxvrmapping) - 20usize];
    ["Offset of field: atom_smc_dpm_info_v4_1::vddsocvrmapping"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_1, vddsocvrmapping) - 21usize];
    ["Offset of field: atom_smc_dpm_info_v4_1::vddmem0vrmapping"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_1, vddmem0vrmapping) - 22usize];
    ["Offset of field: atom_smc_dpm_info_v4_1::vddmem1vrmapping"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_1, vddmem1vrmapping) - 23usize];
    ["Offset of field: atom_smc_dpm_info_v4_1::gfxulvphasesheddingmask"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_1, gfxulvphasesheddingmask) - 24usize];
    ["Offset of field: atom_smc_dpm_info_v4_1::soculvphasesheddingmask"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_1, soculvphasesheddingmask) - 25usize];
    ["Offset of field: atom_smc_dpm_info_v4_1::padding8_v"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_1, padding8_v) - 26usize];
    ["Offset of field: atom_smc_dpm_info_v4_1::gfxmaxcurrent"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_1, gfxmaxcurrent) - 28usize];
    ["Offset of field: atom_smc_dpm_info_v4_1::gfxoffset"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_1, gfxoffset) - 30usize];
    ["Offset of field: atom_smc_dpm_info_v4_1::padding_telemetrygfx"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_1, padding_telemetrygfx) - 31usize];
    ["Offset of field: atom_smc_dpm_info_v4_1::socmaxcurrent"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_1, socmaxcurrent) - 32usize];
    ["Offset of field: atom_smc_dpm_info_v4_1::socoffset"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_1, socoffset) - 34usize];
    ["Offset of field: atom_smc_dpm_info_v4_1::padding_telemetrysoc"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_1, padding_telemetrysoc) - 35usize];
    ["Offset of field: atom_smc_dpm_info_v4_1::mem0maxcurrent"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_1, mem0maxcurrent) - 36usize];
    ["Offset of field: atom_smc_dpm_info_v4_1::mem0offset"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_1, mem0offset) - 38usize];
    ["Offset of field: atom_smc_dpm_info_v4_1::padding_telemetrymem0"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_1, padding_telemetrymem0) - 39usize];
    ["Offset of field: atom_smc_dpm_info_v4_1::mem1maxcurrent"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_1, mem1maxcurrent) - 40usize];
    ["Offset of field: atom_smc_dpm_info_v4_1::mem1offset"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_1, mem1offset) - 42usize];
    ["Offset of field: atom_smc_dpm_info_v4_1::padding_telemetrymem1"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_1, padding_telemetrymem1) - 43usize];
    ["Offset of field: atom_smc_dpm_info_v4_1::acdcgpio"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_1, acdcgpio) - 44usize];
    ["Offset of field: atom_smc_dpm_info_v4_1::acdcpolarity"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_1, acdcpolarity) - 45usize];
    ["Offset of field: atom_smc_dpm_info_v4_1::vr0hotgpio"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_1, vr0hotgpio) - 46usize];
    ["Offset of field: atom_smc_dpm_info_v4_1::vr0hotpolarity"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_1, vr0hotpolarity) - 47usize];
    ["Offset of field: atom_smc_dpm_info_v4_1::vr1hotgpio"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_1, vr1hotgpio) - 48usize];
    ["Offset of field: atom_smc_dpm_info_v4_1::vr1hotpolarity"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_1, vr1hotpolarity) - 49usize];
    ["Offset of field: atom_smc_dpm_info_v4_1::padding1"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_1, padding1) - 50usize];
    ["Offset of field: atom_smc_dpm_info_v4_1::padding2"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_1, padding2) - 51usize];
    ["Offset of field: atom_smc_dpm_info_v4_1::ledpin0"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_1, ledpin0) - 52usize];
    ["Offset of field: atom_smc_dpm_info_v4_1::ledpin1"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_1, ledpin1) - 53usize];
    ["Offset of field: atom_smc_dpm_info_v4_1::ledpin2"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_1, ledpin2) - 54usize];
    ["Offset of field: atom_smc_dpm_info_v4_1::padding8_4"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_1, padding8_4) - 55usize];
    ["Offset of field: atom_smc_dpm_info_v4_1::pllgfxclkspreadenabled"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_1, pllgfxclkspreadenabled) - 56usize];
    ["Offset of field: atom_smc_dpm_info_v4_1::pllgfxclkspreadpercent"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_1, pllgfxclkspreadpercent) - 57usize];
    ["Offset of field: atom_smc_dpm_info_v4_1::pllgfxclkspreadfreq"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_1, pllgfxclkspreadfreq) - 58usize];
    ["Offset of field: atom_smc_dpm_info_v4_1::uclkspreadenabled"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_1, uclkspreadenabled) - 60usize];
    ["Offset of field: atom_smc_dpm_info_v4_1::uclkspreadpercent"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_1, uclkspreadpercent) - 61usize];
    ["Offset of field: atom_smc_dpm_info_v4_1::uclkspreadfreq"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_1, uclkspreadfreq) - 62usize];
    ["Offset of field: atom_smc_dpm_info_v4_1::socclkspreadenabled"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_1, socclkspreadenabled) - 64usize];
    ["Offset of field: atom_smc_dpm_info_v4_1::socclkspreadpercent"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_1, socclkspreadpercent) - 65usize];
    ["Offset of field: atom_smc_dpm_info_v4_1::socclkspreadfreq"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_1, socclkspreadfreq) - 66usize];
    ["Offset of field: atom_smc_dpm_info_v4_1::acggfxclkspreadenabled"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_1, acggfxclkspreadenabled) - 68usize];
    ["Offset of field: atom_smc_dpm_info_v4_1::acggfxclkspreadpercent"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_1, acggfxclkspreadpercent) - 69usize];
    ["Offset of field: atom_smc_dpm_info_v4_1::acggfxclkspreadfreq"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_1, acggfxclkspreadfreq) - 70usize];
    ["Offset of field: atom_smc_dpm_info_v4_1::Vr2_I2C_address"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_1, Vr2_I2C_address) - 72usize];
    ["Offset of field: atom_smc_dpm_info_v4_1::padding_vr2"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_1, padding_vr2) - 73usize];
    ["Offset of field: atom_smc_dpm_info_v4_1::boardreserved"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_1, boardreserved) - 76usize];
};
#[repr(C, packed)]
#[derive(Debug, Copy, Clone)]
pub struct atom_smc_dpm_info_v4_3 {
    pub table_header: atom_common_table_header,
    pub liquid1_i2c_address: u8,
    pub liquid2_i2c_address: u8,
    pub vr_i2c_address: u8,
    pub plx_i2c_address: u8,
    pub liquid_i2c_linescl: u8,
    pub liquid_i2c_linesda: u8,
    pub vr_i2c_linescl: u8,
    pub vr_i2c_linesda: u8,
    pub plx_i2c_linescl: u8,
    pub plx_i2c_linesda: u8,
    pub vrsensorpresent: u8,
    pub liquidsensorpresent: u8,
    pub maxvoltagestepgfx: u16,
    pub maxvoltagestepsoc: u16,
    pub vddgfxvrmapping: u8,
    pub vddsocvrmapping: u8,
    pub vddmem0vrmapping: u8,
    pub vddmem1vrmapping: u8,
    pub gfxulvphasesheddingmask: u8,
    pub soculvphasesheddingmask: u8,
    pub externalsensorpresent: u8,
    pub padding8_v: u8,
    pub gfxmaxcurrent: u16,
    pub gfxoffset: u8,
    pub padding_telemetrygfx: u8,
    pub socmaxcurrent: u16,
    pub socoffset: u8,
    pub padding_telemetrysoc: u8,
    pub mem0maxcurrent: u16,
    pub mem0offset: u8,
    pub padding_telemetrymem0: u8,
    pub mem1maxcurrent: u16,
    pub mem1offset: u8,
    pub padding_telemetrymem1: u8,
    pub acdcgpio: u8,
    pub acdcpolarity: u8,
    pub vr0hotgpio: u8,
    pub vr0hotpolarity: u8,
    pub vr1hotgpio: u8,
    pub vr1hotpolarity: u8,
    pub padding1: u8,
    pub padding2: u8,
    pub ledpin0: u8,
    pub ledpin1: u8,
    pub ledpin2: u8,
    pub padding8_4: u8,
    pub pllgfxclkspreadenabled: u8,
    pub pllgfxclkspreadpercent: u8,
    pub pllgfxclkspreadfreq: u16,
    pub uclkspreadenabled: u8,
    pub uclkspreadpercent: u8,
    pub uclkspreadfreq: u16,
    pub fclkspreadenabled: u8,
    pub fclkspreadpercent: u8,
    pub fclkspreadfreq: u16,
    pub fllgfxclkspreadenabled: u8,
    pub fllgfxclkspreadpercent: u8,
    pub fllgfxclkspreadfreq: u16,
    pub boardreserved: [u32; 10usize],
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of atom_smc_dpm_info_v4_3"][::core::mem::size_of::<atom_smc_dpm_info_v4_3>() - 112usize];
    ["Alignment of atom_smc_dpm_info_v4_3"]
        [::core::mem::align_of::<atom_smc_dpm_info_v4_3>() - 1usize];
    ["Offset of field: atom_smc_dpm_info_v4_3::table_header"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_3, table_header) - 0usize];
    ["Offset of field: atom_smc_dpm_info_v4_3::liquid1_i2c_address"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_3, liquid1_i2c_address) - 4usize];
    ["Offset of field: atom_smc_dpm_info_v4_3::liquid2_i2c_address"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_3, liquid2_i2c_address) - 5usize];
    ["Offset of field: atom_smc_dpm_info_v4_3::vr_i2c_address"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_3, vr_i2c_address) - 6usize];
    ["Offset of field: atom_smc_dpm_info_v4_3::plx_i2c_address"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_3, plx_i2c_address) - 7usize];
    ["Offset of field: atom_smc_dpm_info_v4_3::liquid_i2c_linescl"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_3, liquid_i2c_linescl) - 8usize];
    ["Offset of field: atom_smc_dpm_info_v4_3::liquid_i2c_linesda"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_3, liquid_i2c_linesda) - 9usize];
    ["Offset of field: atom_smc_dpm_info_v4_3::vr_i2c_linescl"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_3, vr_i2c_linescl) - 10usize];
    ["Offset of field: atom_smc_dpm_info_v4_3::vr_i2c_linesda"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_3, vr_i2c_linesda) - 11usize];
    ["Offset of field: atom_smc_dpm_info_v4_3::plx_i2c_linescl"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_3, plx_i2c_linescl) - 12usize];
    ["Offset of field: atom_smc_dpm_info_v4_3::plx_i2c_linesda"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_3, plx_i2c_linesda) - 13usize];
    ["Offset of field: atom_smc_dpm_info_v4_3::vrsensorpresent"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_3, vrsensorpresent) - 14usize];
    ["Offset of field: atom_smc_dpm_info_v4_3::liquidsensorpresent"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_3, liquidsensorpresent) - 15usize];
    ["Offset of field: atom_smc_dpm_info_v4_3::maxvoltagestepgfx"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_3, maxvoltagestepgfx) - 16usize];
    ["Offset of field: atom_smc_dpm_info_v4_3::maxvoltagestepsoc"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_3, maxvoltagestepsoc) - 18usize];
    ["Offset of field: atom_smc_dpm_info_v4_3::vddgfxvrmapping"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_3, vddgfxvrmapping) - 20usize];
    ["Offset of field: atom_smc_dpm_info_v4_3::vddsocvrmapping"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_3, vddsocvrmapping) - 21usize];
    ["Offset of field: atom_smc_dpm_info_v4_3::vddmem0vrmapping"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_3, vddmem0vrmapping) - 22usize];
    ["Offset of field: atom_smc_dpm_info_v4_3::vddmem1vrmapping"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_3, vddmem1vrmapping) - 23usize];
    ["Offset of field: atom_smc_dpm_info_v4_3::gfxulvphasesheddingmask"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_3, gfxulvphasesheddingmask) - 24usize];
    ["Offset of field: atom_smc_dpm_info_v4_3::soculvphasesheddingmask"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_3, soculvphasesheddingmask) - 25usize];
    ["Offset of field: atom_smc_dpm_info_v4_3::externalsensorpresent"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_3, externalsensorpresent) - 26usize];
    ["Offset of field: atom_smc_dpm_info_v4_3::padding8_v"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_3, padding8_v) - 27usize];
    ["Offset of field: atom_smc_dpm_info_v4_3::gfxmaxcurrent"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_3, gfxmaxcurrent) - 28usize];
    ["Offset of field: atom_smc_dpm_info_v4_3::gfxoffset"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_3, gfxoffset) - 30usize];
    ["Offset of field: atom_smc_dpm_info_v4_3::padding_telemetrygfx"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_3, padding_telemetrygfx) - 31usize];
    ["Offset of field: atom_smc_dpm_info_v4_3::socmaxcurrent"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_3, socmaxcurrent) - 32usize];
    ["Offset of field: atom_smc_dpm_info_v4_3::socoffset"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_3, socoffset) - 34usize];
    ["Offset of field: atom_smc_dpm_info_v4_3::padding_telemetrysoc"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_3, padding_telemetrysoc) - 35usize];
    ["Offset of field: atom_smc_dpm_info_v4_3::mem0maxcurrent"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_3, mem0maxcurrent) - 36usize];
    ["Offset of field: atom_smc_dpm_info_v4_3::mem0offset"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_3, mem0offset) - 38usize];
    ["Offset of field: atom_smc_dpm_info_v4_3::padding_telemetrymem0"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_3, padding_telemetrymem0) - 39usize];
    ["Offset of field: atom_smc_dpm_info_v4_3::mem1maxcurrent"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_3, mem1maxcurrent) - 40usize];
    ["Offset of field: atom_smc_dpm_info_v4_3::mem1offset"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_3, mem1offset) - 42usize];
    ["Offset of field: atom_smc_dpm_info_v4_3::padding_telemetrymem1"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_3, padding_telemetrymem1) - 43usize];
    ["Offset of field: atom_smc_dpm_info_v4_3::acdcgpio"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_3, acdcgpio) - 44usize];
    ["Offset of field: atom_smc_dpm_info_v4_3::acdcpolarity"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_3, acdcpolarity) - 45usize];
    ["Offset of field: atom_smc_dpm_info_v4_3::vr0hotgpio"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_3, vr0hotgpio) - 46usize];
    ["Offset of field: atom_smc_dpm_info_v4_3::vr0hotpolarity"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_3, vr0hotpolarity) - 47usize];
    ["Offset of field: atom_smc_dpm_info_v4_3::vr1hotgpio"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_3, vr1hotgpio) - 48usize];
    ["Offset of field: atom_smc_dpm_info_v4_3::vr1hotpolarity"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_3, vr1hotpolarity) - 49usize];
    ["Offset of field: atom_smc_dpm_info_v4_3::padding1"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_3, padding1) - 50usize];
    ["Offset of field: atom_smc_dpm_info_v4_3::padding2"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_3, padding2) - 51usize];
    ["Offset of field: atom_smc_dpm_info_v4_3::ledpin0"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_3, ledpin0) - 52usize];
    ["Offset of field: atom_smc_dpm_info_v4_3::ledpin1"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_3, ledpin1) - 53usize];
    ["Offset of field: atom_smc_dpm_info_v4_3::ledpin2"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_3, ledpin2) - 54usize];
    ["Offset of field: atom_smc_dpm_info_v4_3::padding8_4"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_3, padding8_4) - 55usize];
    ["Offset of field: atom_smc_dpm_info_v4_3::pllgfxclkspreadenabled"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_3, pllgfxclkspreadenabled) - 56usize];
    ["Offset of field: atom_smc_dpm_info_v4_3::pllgfxclkspreadpercent"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_3, pllgfxclkspreadpercent) - 57usize];
    ["Offset of field: atom_smc_dpm_info_v4_3::pllgfxclkspreadfreq"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_3, pllgfxclkspreadfreq) - 58usize];
    ["Offset of field: atom_smc_dpm_info_v4_3::uclkspreadenabled"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_3, uclkspreadenabled) - 60usize];
    ["Offset of field: atom_smc_dpm_info_v4_3::uclkspreadpercent"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_3, uclkspreadpercent) - 61usize];
    ["Offset of field: atom_smc_dpm_info_v4_3::uclkspreadfreq"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_3, uclkspreadfreq) - 62usize];
    ["Offset of field: atom_smc_dpm_info_v4_3::fclkspreadenabled"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_3, fclkspreadenabled) - 64usize];
    ["Offset of field: atom_smc_dpm_info_v4_3::fclkspreadpercent"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_3, fclkspreadpercent) - 65usize];
    ["Offset of field: atom_smc_dpm_info_v4_3::fclkspreadfreq"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_3, fclkspreadfreq) - 66usize];
    ["Offset of field: atom_smc_dpm_info_v4_3::fllgfxclkspreadenabled"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_3, fllgfxclkspreadenabled) - 68usize];
    ["Offset of field: atom_smc_dpm_info_v4_3::fllgfxclkspreadpercent"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_3, fllgfxclkspreadpercent) - 69usize];
    ["Offset of field: atom_smc_dpm_info_v4_3::fllgfxclkspreadfreq"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_3, fllgfxclkspreadfreq) - 70usize];
    ["Offset of field: atom_smc_dpm_info_v4_3::boardreserved"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_3, boardreserved) - 72usize];
};
#[repr(C, packed)]
#[derive(Debug, Copy, Clone)]
pub struct smudpm_i2ccontrollerconfig_t {
    pub enabled: u32,
    pub slaveaddress: u32,
    pub controllerport: u32,
    pub controllername: u32,
    pub thermalthrottler: u32,
    pub i2cprotocol: u32,
    pub i2cspeed: u32,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of smudpm_i2ccontrollerconfig_t"]
        [::core::mem::size_of::<smudpm_i2ccontrollerconfig_t>() - 28usize];
    ["Alignment of smudpm_i2ccontrollerconfig_t"]
        [::core::mem::align_of::<smudpm_i2ccontrollerconfig_t>() - 1usize];
    ["Offset of field: smudpm_i2ccontrollerconfig_t::enabled"]
        [::core::mem::offset_of!(smudpm_i2ccontrollerconfig_t, enabled) - 0usize];
    ["Offset of field: smudpm_i2ccontrollerconfig_t::slaveaddress"]
        [::core::mem::offset_of!(smudpm_i2ccontrollerconfig_t, slaveaddress) - 4usize];
    ["Offset of field: smudpm_i2ccontrollerconfig_t::controllerport"]
        [::core::mem::offset_of!(smudpm_i2ccontrollerconfig_t, controllerport) - 8usize];
    ["Offset of field: smudpm_i2ccontrollerconfig_t::controllername"]
        [::core::mem::offset_of!(smudpm_i2ccontrollerconfig_t, controllername) - 12usize];
    ["Offset of field: smudpm_i2ccontrollerconfig_t::thermalthrottler"]
        [::core::mem::offset_of!(smudpm_i2ccontrollerconfig_t, thermalthrottler) - 16usize];
    ["Offset of field: smudpm_i2ccontrollerconfig_t::i2cprotocol"]
        [::core::mem::offset_of!(smudpm_i2ccontrollerconfig_t, i2cprotocol) - 20usize];
    ["Offset of field: smudpm_i2ccontrollerconfig_t::i2cspeed"]
        [::core::mem::offset_of!(smudpm_i2ccontrollerconfig_t, i2cspeed) - 24usize];
};
#[repr(C, packed)]
#[derive(Debug, Copy, Clone)]
pub struct atom_smc_dpm_info_v4_4 {
    pub table_header: atom_common_table_header,
    pub i2c_padding: [u32; 3usize],
    pub maxvoltagestepgfx: u16,
    pub maxvoltagestepsoc: u16,
    pub vddgfxvrmapping: u8,
    pub vddsocvrmapping: u8,
    pub vddmem0vrmapping: u8,
    pub vddmem1vrmapping: u8,
    pub gfxulvphasesheddingmask: u8,
    pub soculvphasesheddingmask: u8,
    pub externalsensorpresent: u8,
    pub padding8_v: u8,
    pub gfxmaxcurrent: u16,
    pub gfxoffset: u8,
    pub padding_telemetrygfx: u8,
    pub socmaxcurrent: u16,
    pub socoffset: u8,
    pub padding_telemetrysoc: u8,
    pub mem0maxcurrent: u16,
    pub mem0offset: u8,
    pub padding_telemetrymem0: u8,
    pub mem1maxcurrent: u16,
    pub mem1offset: u8,
    pub padding_telemetrymem1: u8,
    pub acdcgpio: u8,
    pub acdcpolarity: u8,
    pub vr0hotgpio: u8,
    pub vr0hotpolarity: u8,
    pub vr1hotgpio: u8,
    pub vr1hotpolarity: u8,
    pub padding1: u8,
    pub padding2: u8,
    pub ledpin0: u8,
    pub ledpin1: u8,
    pub ledpin2: u8,
    pub padding8_4: u8,
    pub pllgfxclkspreadenabled: u8,
    pub pllgfxclkspreadpercent: u8,
    pub pllgfxclkspreadfreq: u16,
    pub uclkspreadenabled: u8,
    pub uclkspreadpercent: u8,
    pub uclkspreadfreq: u16,
    pub fclkspreadenabled: u8,
    pub fclkspreadpercent: u8,
    pub fclkspreadfreq: u16,
    pub fllgfxclkspreadenabled: u8,
    pub fllgfxclkspreadpercent: u8,
    pub fllgfxclkspreadfreq: u16,
    pub i2ccontrollers: [smudpm_i2ccontrollerconfig_t; 7usize],
    pub boardreserved: [u32; 10usize],
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of atom_smc_dpm_info_v4_4"][::core::mem::size_of::<atom_smc_dpm_info_v4_4>() - 308usize];
    ["Alignment of atom_smc_dpm_info_v4_4"]
        [::core::mem::align_of::<atom_smc_dpm_info_v4_4>() - 1usize];
    ["Offset of field: atom_smc_dpm_info_v4_4::table_header"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_4, table_header) - 0usize];
    ["Offset of field: atom_smc_dpm_info_v4_4::i2c_padding"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_4, i2c_padding) - 4usize];
    ["Offset of field: atom_smc_dpm_info_v4_4::maxvoltagestepgfx"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_4, maxvoltagestepgfx) - 16usize];
    ["Offset of field: atom_smc_dpm_info_v4_4::maxvoltagestepsoc"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_4, maxvoltagestepsoc) - 18usize];
    ["Offset of field: atom_smc_dpm_info_v4_4::vddgfxvrmapping"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_4, vddgfxvrmapping) - 20usize];
    ["Offset of field: atom_smc_dpm_info_v4_4::vddsocvrmapping"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_4, vddsocvrmapping) - 21usize];
    ["Offset of field: atom_smc_dpm_info_v4_4::vddmem0vrmapping"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_4, vddmem0vrmapping) - 22usize];
    ["Offset of field: atom_smc_dpm_info_v4_4::vddmem1vrmapping"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_4, vddmem1vrmapping) - 23usize];
    ["Offset of field: atom_smc_dpm_info_v4_4::gfxulvphasesheddingmask"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_4, gfxulvphasesheddingmask) - 24usize];
    ["Offset of field: atom_smc_dpm_info_v4_4::soculvphasesheddingmask"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_4, soculvphasesheddingmask) - 25usize];
    ["Offset of field: atom_smc_dpm_info_v4_4::externalsensorpresent"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_4, externalsensorpresent) - 26usize];
    ["Offset of field: atom_smc_dpm_info_v4_4::padding8_v"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_4, padding8_v) - 27usize];
    ["Offset of field: atom_smc_dpm_info_v4_4::gfxmaxcurrent"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_4, gfxmaxcurrent) - 28usize];
    ["Offset of field: atom_smc_dpm_info_v4_4::gfxoffset"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_4, gfxoffset) - 30usize];
    ["Offset of field: atom_smc_dpm_info_v4_4::padding_telemetrygfx"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_4, padding_telemetrygfx) - 31usize];
    ["Offset of field: atom_smc_dpm_info_v4_4::socmaxcurrent"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_4, socmaxcurrent) - 32usize];
    ["Offset of field: atom_smc_dpm_info_v4_4::socoffset"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_4, socoffset) - 34usize];
    ["Offset of field: atom_smc_dpm_info_v4_4::padding_telemetrysoc"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_4, padding_telemetrysoc) - 35usize];
    ["Offset of field: atom_smc_dpm_info_v4_4::mem0maxcurrent"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_4, mem0maxcurrent) - 36usize];
    ["Offset of field: atom_smc_dpm_info_v4_4::mem0offset"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_4, mem0offset) - 38usize];
    ["Offset of field: atom_smc_dpm_info_v4_4::padding_telemetrymem0"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_4, padding_telemetrymem0) - 39usize];
    ["Offset of field: atom_smc_dpm_info_v4_4::mem1maxcurrent"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_4, mem1maxcurrent) - 40usize];
    ["Offset of field: atom_smc_dpm_info_v4_4::mem1offset"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_4, mem1offset) - 42usize];
    ["Offset of field: atom_smc_dpm_info_v4_4::padding_telemetrymem1"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_4, padding_telemetrymem1) - 43usize];
    ["Offset of field: atom_smc_dpm_info_v4_4::acdcgpio"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_4, acdcgpio) - 44usize];
    ["Offset of field: atom_smc_dpm_info_v4_4::acdcpolarity"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_4, acdcpolarity) - 45usize];
    ["Offset of field: atom_smc_dpm_info_v4_4::vr0hotgpio"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_4, vr0hotgpio) - 46usize];
    ["Offset of field: atom_smc_dpm_info_v4_4::vr0hotpolarity"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_4, vr0hotpolarity) - 47usize];
    ["Offset of field: atom_smc_dpm_info_v4_4::vr1hotgpio"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_4, vr1hotgpio) - 48usize];
    ["Offset of field: atom_smc_dpm_info_v4_4::vr1hotpolarity"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_4, vr1hotpolarity) - 49usize];
    ["Offset of field: atom_smc_dpm_info_v4_4::padding1"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_4, padding1) - 50usize];
    ["Offset of field: atom_smc_dpm_info_v4_4::padding2"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_4, padding2) - 51usize];
    ["Offset of field: atom_smc_dpm_info_v4_4::ledpin0"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_4, ledpin0) - 52usize];
    ["Offset of field: atom_smc_dpm_info_v4_4::ledpin1"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_4, ledpin1) - 53usize];
    ["Offset of field: atom_smc_dpm_info_v4_4::ledpin2"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_4, ledpin2) - 54usize];
    ["Offset of field: atom_smc_dpm_info_v4_4::padding8_4"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_4, padding8_4) - 55usize];
    ["Offset of field: atom_smc_dpm_info_v4_4::pllgfxclkspreadenabled"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_4, pllgfxclkspreadenabled) - 56usize];
    ["Offset of field: atom_smc_dpm_info_v4_4::pllgfxclkspreadpercent"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_4, pllgfxclkspreadpercent) - 57usize];
    ["Offset of field: atom_smc_dpm_info_v4_4::pllgfxclkspreadfreq"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_4, pllgfxclkspreadfreq) - 58usize];
    ["Offset of field: atom_smc_dpm_info_v4_4::uclkspreadenabled"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_4, uclkspreadenabled) - 60usize];
    ["Offset of field: atom_smc_dpm_info_v4_4::uclkspreadpercent"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_4, uclkspreadpercent) - 61usize];
    ["Offset of field: atom_smc_dpm_info_v4_4::uclkspreadfreq"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_4, uclkspreadfreq) - 62usize];
    ["Offset of field: atom_smc_dpm_info_v4_4::fclkspreadenabled"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_4, fclkspreadenabled) - 64usize];
    ["Offset of field: atom_smc_dpm_info_v4_4::fclkspreadpercent"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_4, fclkspreadpercent) - 65usize];
    ["Offset of field: atom_smc_dpm_info_v4_4::fclkspreadfreq"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_4, fclkspreadfreq) - 66usize];
    ["Offset of field: atom_smc_dpm_info_v4_4::fllgfxclkspreadenabled"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_4, fllgfxclkspreadenabled) - 68usize];
    ["Offset of field: atom_smc_dpm_info_v4_4::fllgfxclkspreadpercent"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_4, fllgfxclkspreadpercent) - 69usize];
    ["Offset of field: atom_smc_dpm_info_v4_4::fllgfxclkspreadfreq"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_4, fllgfxclkspreadfreq) - 70usize];
    ["Offset of field: atom_smc_dpm_info_v4_4::i2ccontrollers"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_4, i2ccontrollers) - 72usize];
    ["Offset of field: atom_smc_dpm_info_v4_4::boardreserved"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_4, boardreserved) - 268usize];
};
pub const smudpm_v4_5_i2ccontrollername_e_SMC_V4_5_I2C_CONTROLLER_NAME_VR_GFX:
    smudpm_v4_5_i2ccontrollername_e = 0;
pub const smudpm_v4_5_i2ccontrollername_e_SMC_V4_5_I2C_CONTROLLER_NAME_VR_SOC:
    smudpm_v4_5_i2ccontrollername_e = 1;
pub const smudpm_v4_5_i2ccontrollername_e_SMC_V4_5_I2C_CONTROLLER_NAME_VR_VDDCI:
    smudpm_v4_5_i2ccontrollername_e = 2;
pub const smudpm_v4_5_i2ccontrollername_e_SMC_V4_5_I2C_CONTROLLER_NAME_VR_MVDD:
    smudpm_v4_5_i2ccontrollername_e = 3;
pub const smudpm_v4_5_i2ccontrollername_e_SMC_V4_5_I2C_CONTROLLER_NAME_LIQUID0:
    smudpm_v4_5_i2ccontrollername_e = 4;
pub const smudpm_v4_5_i2ccontrollername_e_SMC_V4_5_I2C_CONTROLLER_NAME_LIQUID1:
    smudpm_v4_5_i2ccontrollername_e = 5;
pub const smudpm_v4_5_i2ccontrollername_e_SMC_V4_5_I2C_CONTROLLER_NAME_PLX:
    smudpm_v4_5_i2ccontrollername_e = 6;
pub const smudpm_v4_5_i2ccontrollername_e_SMC_V4_5_I2C_CONTROLLER_NAME_SPARE:
    smudpm_v4_5_i2ccontrollername_e = 7;
pub const smudpm_v4_5_i2ccontrollername_e_SMC_V4_5_I2C_CONTROLLER_NAME_COUNT:
    smudpm_v4_5_i2ccontrollername_e = 8;
pub type smudpm_v4_5_i2ccontrollername_e = ::core::ffi::c_uint;
pub const smudpm_v4_5_i2ccontrollerthrottler_e_SMC_V4_5_I2C_CONTROLLER_THROTTLER_TYPE_NONE:
    smudpm_v4_5_i2ccontrollerthrottler_e = 0;
pub const smudpm_v4_5_i2ccontrollerthrottler_e_SMC_V4_5_I2C_CONTROLLER_THROTTLER_VR_GFX:
    smudpm_v4_5_i2ccontrollerthrottler_e = 1;
pub const smudpm_v4_5_i2ccontrollerthrottler_e_SMC_V4_5_I2C_CONTROLLER_THROTTLER_VR_SOC:
    smudpm_v4_5_i2ccontrollerthrottler_e = 2;
pub const smudpm_v4_5_i2ccontrollerthrottler_e_SMC_V4_5_I2C_CONTROLLER_THROTTLER_VR_VDDCI:
    smudpm_v4_5_i2ccontrollerthrottler_e = 3;
pub const smudpm_v4_5_i2ccontrollerthrottler_e_SMC_V4_5_I2C_CONTROLLER_THROTTLER_VR_MVDD:
    smudpm_v4_5_i2ccontrollerthrottler_e = 4;
pub const smudpm_v4_5_i2ccontrollerthrottler_e_SMC_V4_5_I2C_CONTROLLER_THROTTLER_LIQUID0:
    smudpm_v4_5_i2ccontrollerthrottler_e = 5;
pub const smudpm_v4_5_i2ccontrollerthrottler_e_SMC_V4_5_I2C_CONTROLLER_THROTTLER_LIQUID1:
    smudpm_v4_5_i2ccontrollerthrottler_e = 6;
pub const smudpm_v4_5_i2ccontrollerthrottler_e_SMC_V4_5_I2C_CONTROLLER_THROTTLER_PLX:
    smudpm_v4_5_i2ccontrollerthrottler_e = 7;
pub const smudpm_v4_5_i2ccontrollerthrottler_e_SMC_V4_5_I2C_CONTROLLER_THROTTLER_COUNT:
    smudpm_v4_5_i2ccontrollerthrottler_e = 8;
pub type smudpm_v4_5_i2ccontrollerthrottler_e = ::core::ffi::c_uint;
pub const smudpm_v4_5_i2ccontrollerprotocol_e_SMC_V4_5_I2C_CONTROLLER_PROTOCOL_VR_0:
    smudpm_v4_5_i2ccontrollerprotocol_e = 0;
pub const smudpm_v4_5_i2ccontrollerprotocol_e_SMC_V4_5_I2C_CONTROLLER_PROTOCOL_VR_1:
    smudpm_v4_5_i2ccontrollerprotocol_e = 1;
pub const smudpm_v4_5_i2ccontrollerprotocol_e_SMC_V4_5_I2C_CONTROLLER_PROTOCOL_TMP_0:
    smudpm_v4_5_i2ccontrollerprotocol_e = 2;
pub const smudpm_v4_5_i2ccontrollerprotocol_e_SMC_V4_5_I2C_CONTROLLER_PROTOCOL_TMP_1:
    smudpm_v4_5_i2ccontrollerprotocol_e = 3;
pub const smudpm_v4_5_i2ccontrollerprotocol_e_SMC_V4_5_I2C_CONTROLLER_PROTOCOL_SPARE_0:
    smudpm_v4_5_i2ccontrollerprotocol_e = 4;
pub const smudpm_v4_5_i2ccontrollerprotocol_e_SMC_V4_5_I2C_CONTROLLER_PROTOCOL_SPARE_1:
    smudpm_v4_5_i2ccontrollerprotocol_e = 5;
pub const smudpm_v4_5_i2ccontrollerprotocol_e_SMC_V4_5_I2C_CONTROLLER_PROTOCOL_COUNT:
    smudpm_v4_5_i2ccontrollerprotocol_e = 6;
pub type smudpm_v4_5_i2ccontrollerprotocol_e = ::core::ffi::c_uint;
#[repr(C, packed)]
#[derive(Debug, Copy, Clone)]
pub struct smudpm_i2c_controller_config_v2 {
    pub Enabled: u8,
    pub Speed: u8,
    pub Padding: [u8; 2usize],
    pub SlaveAddress: u32,
    pub ControllerPort: u8,
    pub ControllerName: u8,
    pub ThermalThrotter: u8,
    pub I2cProtocol: u8,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of smudpm_i2c_controller_config_v2"]
        [::core::mem::size_of::<smudpm_i2c_controller_config_v2>() - 12usize];
    ["Alignment of smudpm_i2c_controller_config_v2"]
        [::core::mem::align_of::<smudpm_i2c_controller_config_v2>() - 1usize];
    ["Offset of field: smudpm_i2c_controller_config_v2::Enabled"]
        [::core::mem::offset_of!(smudpm_i2c_controller_config_v2, Enabled) - 0usize];
    ["Offset of field: smudpm_i2c_controller_config_v2::Speed"]
        [::core::mem::offset_of!(smudpm_i2c_controller_config_v2, Speed) - 1usize];
    ["Offset of field: smudpm_i2c_controller_config_v2::Padding"]
        [::core::mem::offset_of!(smudpm_i2c_controller_config_v2, Padding) - 2usize];
    ["Offset of field: smudpm_i2c_controller_config_v2::SlaveAddress"]
        [::core::mem::offset_of!(smudpm_i2c_controller_config_v2, SlaveAddress) - 4usize];
    ["Offset of field: smudpm_i2c_controller_config_v2::ControllerPort"]
        [::core::mem::offset_of!(smudpm_i2c_controller_config_v2, ControllerPort) - 8usize];
    ["Offset of field: smudpm_i2c_controller_config_v2::ControllerName"]
        [::core::mem::offset_of!(smudpm_i2c_controller_config_v2, ControllerName) - 9usize];
    ["Offset of field: smudpm_i2c_controller_config_v2::ThermalThrotter"]
        [::core::mem::offset_of!(smudpm_i2c_controller_config_v2, ThermalThrotter) - 10usize];
    ["Offset of field: smudpm_i2c_controller_config_v2::I2cProtocol"]
        [::core::mem::offset_of!(smudpm_i2c_controller_config_v2, I2cProtocol) - 11usize];
};
#[repr(C, packed)]
#[derive(Debug, Copy, Clone)]
pub struct atom_smc_dpm_info_v4_5 {
    pub table_header: atom_common_table_header,
    pub I2cControllers: [smudpm_i2c_controller_config_v2; 8usize],
    pub MaxVoltageStepGfx: u16,
    pub MaxVoltageStepSoc: u16,
    pub VddGfxVrMapping: u8,
    pub VddSocVrMapping: u8,
    pub VddMem0VrMapping: u8,
    pub VddMem1VrMapping: u8,
    pub GfxUlvPhaseSheddingMask: u8,
    pub SocUlvPhaseSheddingMask: u8,
    pub ExternalSensorPresent: u8,
    pub Padding8_V: u8,
    pub GfxMaxCurrent: u16,
    pub GfxOffset: u8,
    pub Padding_TelemetryGfx: u8,
    pub SocMaxCurrent: u16,
    pub SocOffset: u8,
    pub Padding_TelemetrySoc: u8,
    pub Mem0MaxCurrent: u16,
    pub Mem0Offset: u8,
    pub Padding_TelemetryMem0: u8,
    pub Mem1MaxCurrent: u16,
    pub Mem1Offset: u8,
    pub Padding_TelemetryMem1: u8,
    pub AcDcGpio: u8,
    pub AcDcPolarity: u8,
    pub VR0HotGpio: u8,
    pub VR0HotPolarity: u8,
    pub VR1HotGpio: u8,
    pub VR1HotPolarity: u8,
    pub GthrGpio: u8,
    pub GthrPolarity: u8,
    pub LedPin0: u8,
    pub LedPin1: u8,
    pub LedPin2: u8,
    pub padding8_4: u8,
    pub PllGfxclkSpreadEnabled: u8,
    pub PllGfxclkSpreadPercent: u8,
    pub PllGfxclkSpreadFreq: u16,
    pub DfllGfxclkSpreadEnabled: u8,
    pub DfllGfxclkSpreadPercent: u8,
    pub DfllGfxclkSpreadFreq: u16,
    pub UclkSpreadEnabled: u8,
    pub UclkSpreadPercent: u8,
    pub UclkSpreadFreq: u16,
    pub SoclkSpreadEnabled: u8,
    pub SocclkSpreadPercent: u8,
    pub SocclkSpreadFreq: u16,
    pub TotalBoardPower: u16,
    pub BoardPadding: u16,
    pub MvddRatio: u32,
    pub BoardReserved: [u32; 9usize],
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of atom_smc_dpm_info_v4_5"][::core::mem::size_of::<atom_smc_dpm_info_v4_5>() - 200usize];
    ["Alignment of atom_smc_dpm_info_v4_5"]
        [::core::mem::align_of::<atom_smc_dpm_info_v4_5>() - 1usize];
    ["Offset of field: atom_smc_dpm_info_v4_5::table_header"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_5, table_header) - 0usize];
    ["Offset of field: atom_smc_dpm_info_v4_5::I2cControllers"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_5, I2cControllers) - 4usize];
    ["Offset of field: atom_smc_dpm_info_v4_5::MaxVoltageStepGfx"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_5, MaxVoltageStepGfx) - 100usize];
    ["Offset of field: atom_smc_dpm_info_v4_5::MaxVoltageStepSoc"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_5, MaxVoltageStepSoc) - 102usize];
    ["Offset of field: atom_smc_dpm_info_v4_5::VddGfxVrMapping"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_5, VddGfxVrMapping) - 104usize];
    ["Offset of field: atom_smc_dpm_info_v4_5::VddSocVrMapping"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_5, VddSocVrMapping) - 105usize];
    ["Offset of field: atom_smc_dpm_info_v4_5::VddMem0VrMapping"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_5, VddMem0VrMapping) - 106usize];
    ["Offset of field: atom_smc_dpm_info_v4_5::VddMem1VrMapping"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_5, VddMem1VrMapping) - 107usize];
    ["Offset of field: atom_smc_dpm_info_v4_5::GfxUlvPhaseSheddingMask"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_5, GfxUlvPhaseSheddingMask) - 108usize];
    ["Offset of field: atom_smc_dpm_info_v4_5::SocUlvPhaseSheddingMask"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_5, SocUlvPhaseSheddingMask) - 109usize];
    ["Offset of field: atom_smc_dpm_info_v4_5::ExternalSensorPresent"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_5, ExternalSensorPresent) - 110usize];
    ["Offset of field: atom_smc_dpm_info_v4_5::Padding8_V"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_5, Padding8_V) - 111usize];
    ["Offset of field: atom_smc_dpm_info_v4_5::GfxMaxCurrent"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_5, GfxMaxCurrent) - 112usize];
    ["Offset of field: atom_smc_dpm_info_v4_5::GfxOffset"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_5, GfxOffset) - 114usize];
    ["Offset of field: atom_smc_dpm_info_v4_5::Padding_TelemetryGfx"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_5, Padding_TelemetryGfx) - 115usize];
    ["Offset of field: atom_smc_dpm_info_v4_5::SocMaxCurrent"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_5, SocMaxCurrent) - 116usize];
    ["Offset of field: atom_smc_dpm_info_v4_5::SocOffset"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_5, SocOffset) - 118usize];
    ["Offset of field: atom_smc_dpm_info_v4_5::Padding_TelemetrySoc"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_5, Padding_TelemetrySoc) - 119usize];
    ["Offset of field: atom_smc_dpm_info_v4_5::Mem0MaxCurrent"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_5, Mem0MaxCurrent) - 120usize];
    ["Offset of field: atom_smc_dpm_info_v4_5::Mem0Offset"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_5, Mem0Offset) - 122usize];
    ["Offset of field: atom_smc_dpm_info_v4_5::Padding_TelemetryMem0"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_5, Padding_TelemetryMem0) - 123usize];
    ["Offset of field: atom_smc_dpm_info_v4_5::Mem1MaxCurrent"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_5, Mem1MaxCurrent) - 124usize];
    ["Offset of field: atom_smc_dpm_info_v4_5::Mem1Offset"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_5, Mem1Offset) - 126usize];
    ["Offset of field: atom_smc_dpm_info_v4_5::Padding_TelemetryMem1"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_5, Padding_TelemetryMem1) - 127usize];
    ["Offset of field: atom_smc_dpm_info_v4_5::AcDcGpio"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_5, AcDcGpio) - 128usize];
    ["Offset of field: atom_smc_dpm_info_v4_5::AcDcPolarity"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_5, AcDcPolarity) - 129usize];
    ["Offset of field: atom_smc_dpm_info_v4_5::VR0HotGpio"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_5, VR0HotGpio) - 130usize];
    ["Offset of field: atom_smc_dpm_info_v4_5::VR0HotPolarity"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_5, VR0HotPolarity) - 131usize];
    ["Offset of field: atom_smc_dpm_info_v4_5::VR1HotGpio"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_5, VR1HotGpio) - 132usize];
    ["Offset of field: atom_smc_dpm_info_v4_5::VR1HotPolarity"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_5, VR1HotPolarity) - 133usize];
    ["Offset of field: atom_smc_dpm_info_v4_5::GthrGpio"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_5, GthrGpio) - 134usize];
    ["Offset of field: atom_smc_dpm_info_v4_5::GthrPolarity"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_5, GthrPolarity) - 135usize];
    ["Offset of field: atom_smc_dpm_info_v4_5::LedPin0"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_5, LedPin0) - 136usize];
    ["Offset of field: atom_smc_dpm_info_v4_5::LedPin1"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_5, LedPin1) - 137usize];
    ["Offset of field: atom_smc_dpm_info_v4_5::LedPin2"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_5, LedPin2) - 138usize];
    ["Offset of field: atom_smc_dpm_info_v4_5::padding8_4"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_5, padding8_4) - 139usize];
    ["Offset of field: atom_smc_dpm_info_v4_5::PllGfxclkSpreadEnabled"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_5, PllGfxclkSpreadEnabled) - 140usize];
    ["Offset of field: atom_smc_dpm_info_v4_5::PllGfxclkSpreadPercent"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_5, PllGfxclkSpreadPercent) - 141usize];
    ["Offset of field: atom_smc_dpm_info_v4_5::PllGfxclkSpreadFreq"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_5, PllGfxclkSpreadFreq) - 142usize];
    ["Offset of field: atom_smc_dpm_info_v4_5::DfllGfxclkSpreadEnabled"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_5, DfllGfxclkSpreadEnabled) - 144usize];
    ["Offset of field: atom_smc_dpm_info_v4_5::DfllGfxclkSpreadPercent"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_5, DfllGfxclkSpreadPercent) - 145usize];
    ["Offset of field: atom_smc_dpm_info_v4_5::DfllGfxclkSpreadFreq"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_5, DfllGfxclkSpreadFreq) - 146usize];
    ["Offset of field: atom_smc_dpm_info_v4_5::UclkSpreadEnabled"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_5, UclkSpreadEnabled) - 148usize];
    ["Offset of field: atom_smc_dpm_info_v4_5::UclkSpreadPercent"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_5, UclkSpreadPercent) - 149usize];
    ["Offset of field: atom_smc_dpm_info_v4_5::UclkSpreadFreq"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_5, UclkSpreadFreq) - 150usize];
    ["Offset of field: atom_smc_dpm_info_v4_5::SoclkSpreadEnabled"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_5, SoclkSpreadEnabled) - 152usize];
    ["Offset of field: atom_smc_dpm_info_v4_5::SocclkSpreadPercent"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_5, SocclkSpreadPercent) - 153usize];
    ["Offset of field: atom_smc_dpm_info_v4_5::SocclkSpreadFreq"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_5, SocclkSpreadFreq) - 154usize];
    ["Offset of field: atom_smc_dpm_info_v4_5::TotalBoardPower"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_5, TotalBoardPower) - 156usize];
    ["Offset of field: atom_smc_dpm_info_v4_5::BoardPadding"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_5, BoardPadding) - 158usize];
    ["Offset of field: atom_smc_dpm_info_v4_5::MvddRatio"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_5, MvddRatio) - 160usize];
    ["Offset of field: atom_smc_dpm_info_v4_5::BoardReserved"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_5, BoardReserved) - 164usize];
};
#[repr(C, packed)]
#[derive(Debug, Copy, Clone)]
pub struct atom_smc_dpm_info_v4_6 {
    pub table_header: atom_common_table_header,
    pub i2c_padding: [u32; 3usize],
    pub maxvoltagestepgfx: u16,
    pub maxvoltagestepsoc: u16,
    pub vddgfxvrmapping: u8,
    pub vddsocvrmapping: u8,
    pub vddmemvrmapping: u8,
    pub boardvrmapping: u8,
    pub gfxulvphasesheddingmask: u8,
    pub externalsensorpresent: u8,
    pub padding8_v: [u8; 2usize],
    pub gfxmaxcurrent: u16,
    pub gfxoffset: u8,
    pub padding_telemetrygfx: u8,
    pub socmaxcurrent: u16,
    pub socoffset: u8,
    pub padding_telemetrysoc: u8,
    pub memmaxcurrent: u16,
    pub memoffset: u8,
    pub padding_telemetrymem: u8,
    pub boardmaxcurrent: u16,
    pub boardoffset: u8,
    pub padding_telemetryboardinput: u8,
    pub vr0hotgpio: u8,
    pub vr0hotpolarity: u8,
    pub vr1hotgpio: u8,
    pub vr1hotpolarity: u8,
    pub pllgfxclkspreadenabled: u8,
    pub pllgfxclkspreadpercent: u8,
    pub pllgfxclkspreadfreq: u16,
    pub uclkspreadenabled: u8,
    pub uclkspreadpercent: u8,
    pub uclkspreadfreq: u16,
    pub fclkspreadenabled: u8,
    pub fclkspreadpercent: u8,
    pub fclkspreadfreq: u16,
    pub fllgfxclkspreadenabled: u8,
    pub fllgfxclkspreadpercent: u8,
    pub fllgfxclkspreadfreq: u16,
    pub i2ccontrollers: [smudpm_i2c_controller_config_v2; 8usize],
    pub memorychannelenabled: u32,
    pub drambitwidth: u8,
    pub paddingmem: [u8; 3usize],
    pub totalboardpower: u16,
    pub boardpadding: u16,
    pub xgmilinkspeed: [u8; 4usize],
    pub xgmilinkwidth: [u8; 4usize],
    pub xgmifclkfreq: [u16; 4usize],
    pub xgmisocvoltage: [u16; 4usize],
    pub boardreserved: [u32; 10usize],
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of atom_smc_dpm_info_v4_6"][::core::mem::size_of::<atom_smc_dpm_info_v4_6>() - 236usize];
    ["Alignment of atom_smc_dpm_info_v4_6"]
        [::core::mem::align_of::<atom_smc_dpm_info_v4_6>() - 1usize];
    ["Offset of field: atom_smc_dpm_info_v4_6::table_header"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_6, table_header) - 0usize];
    ["Offset of field: atom_smc_dpm_info_v4_6::i2c_padding"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_6, i2c_padding) - 4usize];
    ["Offset of field: atom_smc_dpm_info_v4_6::maxvoltagestepgfx"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_6, maxvoltagestepgfx) - 16usize];
    ["Offset of field: atom_smc_dpm_info_v4_6::maxvoltagestepsoc"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_6, maxvoltagestepsoc) - 18usize];
    ["Offset of field: atom_smc_dpm_info_v4_6::vddgfxvrmapping"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_6, vddgfxvrmapping) - 20usize];
    ["Offset of field: atom_smc_dpm_info_v4_6::vddsocvrmapping"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_6, vddsocvrmapping) - 21usize];
    ["Offset of field: atom_smc_dpm_info_v4_6::vddmemvrmapping"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_6, vddmemvrmapping) - 22usize];
    ["Offset of field: atom_smc_dpm_info_v4_6::boardvrmapping"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_6, boardvrmapping) - 23usize];
    ["Offset of field: atom_smc_dpm_info_v4_6::gfxulvphasesheddingmask"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_6, gfxulvphasesheddingmask) - 24usize];
    ["Offset of field: atom_smc_dpm_info_v4_6::externalsensorpresent"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_6, externalsensorpresent) - 25usize];
    ["Offset of field: atom_smc_dpm_info_v4_6::padding8_v"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_6, padding8_v) - 26usize];
    ["Offset of field: atom_smc_dpm_info_v4_6::gfxmaxcurrent"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_6, gfxmaxcurrent) - 28usize];
    ["Offset of field: atom_smc_dpm_info_v4_6::gfxoffset"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_6, gfxoffset) - 30usize];
    ["Offset of field: atom_smc_dpm_info_v4_6::padding_telemetrygfx"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_6, padding_telemetrygfx) - 31usize];
    ["Offset of field: atom_smc_dpm_info_v4_6::socmaxcurrent"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_6, socmaxcurrent) - 32usize];
    ["Offset of field: atom_smc_dpm_info_v4_6::socoffset"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_6, socoffset) - 34usize];
    ["Offset of field: atom_smc_dpm_info_v4_6::padding_telemetrysoc"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_6, padding_telemetrysoc) - 35usize];
    ["Offset of field: atom_smc_dpm_info_v4_6::memmaxcurrent"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_6, memmaxcurrent) - 36usize];
    ["Offset of field: atom_smc_dpm_info_v4_6::memoffset"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_6, memoffset) - 38usize];
    ["Offset of field: atom_smc_dpm_info_v4_6::padding_telemetrymem"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_6, padding_telemetrymem) - 39usize];
    ["Offset of field: atom_smc_dpm_info_v4_6::boardmaxcurrent"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_6, boardmaxcurrent) - 40usize];
    ["Offset of field: atom_smc_dpm_info_v4_6::boardoffset"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_6, boardoffset) - 42usize];
    ["Offset of field: atom_smc_dpm_info_v4_6::padding_telemetryboardinput"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_6, padding_telemetryboardinput) - 43usize];
    ["Offset of field: atom_smc_dpm_info_v4_6::vr0hotgpio"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_6, vr0hotgpio) - 44usize];
    ["Offset of field: atom_smc_dpm_info_v4_6::vr0hotpolarity"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_6, vr0hotpolarity) - 45usize];
    ["Offset of field: atom_smc_dpm_info_v4_6::vr1hotgpio"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_6, vr1hotgpio) - 46usize];
    ["Offset of field: atom_smc_dpm_info_v4_6::vr1hotpolarity"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_6, vr1hotpolarity) - 47usize];
    ["Offset of field: atom_smc_dpm_info_v4_6::pllgfxclkspreadenabled"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_6, pllgfxclkspreadenabled) - 48usize];
    ["Offset of field: atom_smc_dpm_info_v4_6::pllgfxclkspreadpercent"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_6, pllgfxclkspreadpercent) - 49usize];
    ["Offset of field: atom_smc_dpm_info_v4_6::pllgfxclkspreadfreq"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_6, pllgfxclkspreadfreq) - 50usize];
    ["Offset of field: atom_smc_dpm_info_v4_6::uclkspreadenabled"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_6, uclkspreadenabled) - 52usize];
    ["Offset of field: atom_smc_dpm_info_v4_6::uclkspreadpercent"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_6, uclkspreadpercent) - 53usize];
    ["Offset of field: atom_smc_dpm_info_v4_6::uclkspreadfreq"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_6, uclkspreadfreq) - 54usize];
    ["Offset of field: atom_smc_dpm_info_v4_6::fclkspreadenabled"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_6, fclkspreadenabled) - 56usize];
    ["Offset of field: atom_smc_dpm_info_v4_6::fclkspreadpercent"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_6, fclkspreadpercent) - 57usize];
    ["Offset of field: atom_smc_dpm_info_v4_6::fclkspreadfreq"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_6, fclkspreadfreq) - 58usize];
    ["Offset of field: atom_smc_dpm_info_v4_6::fllgfxclkspreadenabled"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_6, fllgfxclkspreadenabled) - 60usize];
    ["Offset of field: atom_smc_dpm_info_v4_6::fllgfxclkspreadpercent"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_6, fllgfxclkspreadpercent) - 61usize];
    ["Offset of field: atom_smc_dpm_info_v4_6::fllgfxclkspreadfreq"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_6, fllgfxclkspreadfreq) - 62usize];
    ["Offset of field: atom_smc_dpm_info_v4_6::i2ccontrollers"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_6, i2ccontrollers) - 64usize];
    ["Offset of field: atom_smc_dpm_info_v4_6::memorychannelenabled"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_6, memorychannelenabled) - 160usize];
    ["Offset of field: atom_smc_dpm_info_v4_6::drambitwidth"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_6, drambitwidth) - 164usize];
    ["Offset of field: atom_smc_dpm_info_v4_6::paddingmem"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_6, paddingmem) - 165usize];
    ["Offset of field: atom_smc_dpm_info_v4_6::totalboardpower"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_6, totalboardpower) - 168usize];
    ["Offset of field: atom_smc_dpm_info_v4_6::boardpadding"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_6, boardpadding) - 170usize];
    ["Offset of field: atom_smc_dpm_info_v4_6::xgmilinkspeed"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_6, xgmilinkspeed) - 172usize];
    ["Offset of field: atom_smc_dpm_info_v4_6::xgmilinkwidth"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_6, xgmilinkwidth) - 176usize];
    ["Offset of field: atom_smc_dpm_info_v4_6::xgmifclkfreq"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_6, xgmifclkfreq) - 180usize];
    ["Offset of field: atom_smc_dpm_info_v4_6::xgmisocvoltage"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_6, xgmisocvoltage) - 188usize];
    ["Offset of field: atom_smc_dpm_info_v4_6::boardreserved"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_6, boardreserved) - 196usize];
};
#[repr(C, packed)]
#[derive(Debug, Copy, Clone)]
pub struct atom_smc_dpm_info_v4_7 {
    pub table_header: atom_common_table_header,
    pub I2cControllers: [smudpm_i2c_controller_config_v2; 8usize],
    pub MaxVoltageStepGfx: u16,
    pub MaxVoltageStepSoc: u16,
    pub VddGfxVrMapping: u8,
    pub VddSocVrMapping: u8,
    pub VddMem0VrMapping: u8,
    pub VddMem1VrMapping: u8,
    pub GfxUlvPhaseSheddingMask: u8,
    pub SocUlvPhaseSheddingMask: u8,
    pub ExternalSensorPresent: u8,
    pub Padding8_V: u8,
    pub GfxMaxCurrent: u16,
    pub GfxOffset: u8,
    pub Padding_TelemetryGfx: u8,
    pub SocMaxCurrent: u16,
    pub SocOffset: u8,
    pub Padding_TelemetrySoc: u8,
    pub Mem0MaxCurrent: u16,
    pub Mem0Offset: u8,
    pub Padding_TelemetryMem0: u8,
    pub Mem1MaxCurrent: u16,
    pub Mem1Offset: u8,
    pub Padding_TelemetryMem1: u8,
    pub AcDcGpio: u8,
    pub AcDcPolarity: u8,
    pub VR0HotGpio: u8,
    pub VR0HotPolarity: u8,
    pub VR1HotGpio: u8,
    pub VR1HotPolarity: u8,
    pub GthrGpio: u8,
    pub GthrPolarity: u8,
    pub LedPin0: u8,
    pub LedPin1: u8,
    pub LedPin2: u8,
    pub padding8_4: u8,
    pub PllGfxclkSpreadEnabled: u8,
    pub PllGfxclkSpreadPercent: u8,
    pub PllGfxclkSpreadFreq: u16,
    pub DfllGfxclkSpreadEnabled: u8,
    pub DfllGfxclkSpreadPercent: u8,
    pub DfllGfxclkSpreadFreq: u16,
    pub UclkSpreadEnabled: u8,
    pub UclkSpreadPercent: u8,
    pub UclkSpreadFreq: u16,
    pub SoclkSpreadEnabled: u8,
    pub SocclkSpreadPercent: u8,
    pub SocclkSpreadFreq: u16,
    pub TotalBoardPower: u16,
    pub BoardPadding: u16,
    pub MvddRatio: u32,
    pub GpioI2cScl: u8,
    pub GpioI2cSda: u8,
    pub GpioPadding: u16,
    pub LedPin3: u8,
    pub LedPin4: u8,
    pub LedEnableMask: u16,
    pub PowerLimitScalar: [u8; 4usize],
    pub MvddUlvPhaseSheddingMask: u8,
    pub VddciUlvPhaseSheddingMask: u8,
    pub Padding8_Psi1: u8,
    pub Padding8_Psi2: u8,
    pub BoardReserved: [u32; 5usize],
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of atom_smc_dpm_info_v4_7"][::core::mem::size_of::<atom_smc_dpm_info_v4_7>() - 200usize];
    ["Alignment of atom_smc_dpm_info_v4_7"]
        [::core::mem::align_of::<atom_smc_dpm_info_v4_7>() - 1usize];
    ["Offset of field: atom_smc_dpm_info_v4_7::table_header"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_7, table_header) - 0usize];
    ["Offset of field: atom_smc_dpm_info_v4_7::I2cControllers"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_7, I2cControllers) - 4usize];
    ["Offset of field: atom_smc_dpm_info_v4_7::MaxVoltageStepGfx"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_7, MaxVoltageStepGfx) - 100usize];
    ["Offset of field: atom_smc_dpm_info_v4_7::MaxVoltageStepSoc"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_7, MaxVoltageStepSoc) - 102usize];
    ["Offset of field: atom_smc_dpm_info_v4_7::VddGfxVrMapping"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_7, VddGfxVrMapping) - 104usize];
    ["Offset of field: atom_smc_dpm_info_v4_7::VddSocVrMapping"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_7, VddSocVrMapping) - 105usize];
    ["Offset of field: atom_smc_dpm_info_v4_7::VddMem0VrMapping"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_7, VddMem0VrMapping) - 106usize];
    ["Offset of field: atom_smc_dpm_info_v4_7::VddMem1VrMapping"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_7, VddMem1VrMapping) - 107usize];
    ["Offset of field: atom_smc_dpm_info_v4_7::GfxUlvPhaseSheddingMask"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_7, GfxUlvPhaseSheddingMask) - 108usize];
    ["Offset of field: atom_smc_dpm_info_v4_7::SocUlvPhaseSheddingMask"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_7, SocUlvPhaseSheddingMask) - 109usize];
    ["Offset of field: atom_smc_dpm_info_v4_7::ExternalSensorPresent"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_7, ExternalSensorPresent) - 110usize];
    ["Offset of field: atom_smc_dpm_info_v4_7::Padding8_V"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_7, Padding8_V) - 111usize];
    ["Offset of field: atom_smc_dpm_info_v4_7::GfxMaxCurrent"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_7, GfxMaxCurrent) - 112usize];
    ["Offset of field: atom_smc_dpm_info_v4_7::GfxOffset"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_7, GfxOffset) - 114usize];
    ["Offset of field: atom_smc_dpm_info_v4_7::Padding_TelemetryGfx"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_7, Padding_TelemetryGfx) - 115usize];
    ["Offset of field: atom_smc_dpm_info_v4_7::SocMaxCurrent"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_7, SocMaxCurrent) - 116usize];
    ["Offset of field: atom_smc_dpm_info_v4_7::SocOffset"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_7, SocOffset) - 118usize];
    ["Offset of field: atom_smc_dpm_info_v4_7::Padding_TelemetrySoc"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_7, Padding_TelemetrySoc) - 119usize];
    ["Offset of field: atom_smc_dpm_info_v4_7::Mem0MaxCurrent"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_7, Mem0MaxCurrent) - 120usize];
    ["Offset of field: atom_smc_dpm_info_v4_7::Mem0Offset"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_7, Mem0Offset) - 122usize];
    ["Offset of field: atom_smc_dpm_info_v4_7::Padding_TelemetryMem0"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_7, Padding_TelemetryMem0) - 123usize];
    ["Offset of field: atom_smc_dpm_info_v4_7::Mem1MaxCurrent"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_7, Mem1MaxCurrent) - 124usize];
    ["Offset of field: atom_smc_dpm_info_v4_7::Mem1Offset"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_7, Mem1Offset) - 126usize];
    ["Offset of field: atom_smc_dpm_info_v4_7::Padding_TelemetryMem1"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_7, Padding_TelemetryMem1) - 127usize];
    ["Offset of field: atom_smc_dpm_info_v4_7::AcDcGpio"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_7, AcDcGpio) - 128usize];
    ["Offset of field: atom_smc_dpm_info_v4_7::AcDcPolarity"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_7, AcDcPolarity) - 129usize];
    ["Offset of field: atom_smc_dpm_info_v4_7::VR0HotGpio"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_7, VR0HotGpio) - 130usize];
    ["Offset of field: atom_smc_dpm_info_v4_7::VR0HotPolarity"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_7, VR0HotPolarity) - 131usize];
    ["Offset of field: atom_smc_dpm_info_v4_7::VR1HotGpio"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_7, VR1HotGpio) - 132usize];
    ["Offset of field: atom_smc_dpm_info_v4_7::VR1HotPolarity"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_7, VR1HotPolarity) - 133usize];
    ["Offset of field: atom_smc_dpm_info_v4_7::GthrGpio"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_7, GthrGpio) - 134usize];
    ["Offset of field: atom_smc_dpm_info_v4_7::GthrPolarity"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_7, GthrPolarity) - 135usize];
    ["Offset of field: atom_smc_dpm_info_v4_7::LedPin0"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_7, LedPin0) - 136usize];
    ["Offset of field: atom_smc_dpm_info_v4_7::LedPin1"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_7, LedPin1) - 137usize];
    ["Offset of field: atom_smc_dpm_info_v4_7::LedPin2"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_7, LedPin2) - 138usize];
    ["Offset of field: atom_smc_dpm_info_v4_7::padding8_4"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_7, padding8_4) - 139usize];
    ["Offset of field: atom_smc_dpm_info_v4_7::PllGfxclkSpreadEnabled"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_7, PllGfxclkSpreadEnabled) - 140usize];
    ["Offset of field: atom_smc_dpm_info_v4_7::PllGfxclkSpreadPercent"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_7, PllGfxclkSpreadPercent) - 141usize];
    ["Offset of field: atom_smc_dpm_info_v4_7::PllGfxclkSpreadFreq"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_7, PllGfxclkSpreadFreq) - 142usize];
    ["Offset of field: atom_smc_dpm_info_v4_7::DfllGfxclkSpreadEnabled"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_7, DfllGfxclkSpreadEnabled) - 144usize];
    ["Offset of field: atom_smc_dpm_info_v4_7::DfllGfxclkSpreadPercent"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_7, DfllGfxclkSpreadPercent) - 145usize];
    ["Offset of field: atom_smc_dpm_info_v4_7::DfllGfxclkSpreadFreq"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_7, DfllGfxclkSpreadFreq) - 146usize];
    ["Offset of field: atom_smc_dpm_info_v4_7::UclkSpreadEnabled"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_7, UclkSpreadEnabled) - 148usize];
    ["Offset of field: atom_smc_dpm_info_v4_7::UclkSpreadPercent"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_7, UclkSpreadPercent) - 149usize];
    ["Offset of field: atom_smc_dpm_info_v4_7::UclkSpreadFreq"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_7, UclkSpreadFreq) - 150usize];
    ["Offset of field: atom_smc_dpm_info_v4_7::SoclkSpreadEnabled"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_7, SoclkSpreadEnabled) - 152usize];
    ["Offset of field: atom_smc_dpm_info_v4_7::SocclkSpreadPercent"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_7, SocclkSpreadPercent) - 153usize];
    ["Offset of field: atom_smc_dpm_info_v4_7::SocclkSpreadFreq"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_7, SocclkSpreadFreq) - 154usize];
    ["Offset of field: atom_smc_dpm_info_v4_7::TotalBoardPower"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_7, TotalBoardPower) - 156usize];
    ["Offset of field: atom_smc_dpm_info_v4_7::BoardPadding"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_7, BoardPadding) - 158usize];
    ["Offset of field: atom_smc_dpm_info_v4_7::MvddRatio"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_7, MvddRatio) - 160usize];
    ["Offset of field: atom_smc_dpm_info_v4_7::GpioI2cScl"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_7, GpioI2cScl) - 164usize];
    ["Offset of field: atom_smc_dpm_info_v4_7::GpioI2cSda"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_7, GpioI2cSda) - 165usize];
    ["Offset of field: atom_smc_dpm_info_v4_7::GpioPadding"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_7, GpioPadding) - 166usize];
    ["Offset of field: atom_smc_dpm_info_v4_7::LedPin3"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_7, LedPin3) - 168usize];
    ["Offset of field: atom_smc_dpm_info_v4_7::LedPin4"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_7, LedPin4) - 169usize];
    ["Offset of field: atom_smc_dpm_info_v4_7::LedEnableMask"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_7, LedEnableMask) - 170usize];
    ["Offset of field: atom_smc_dpm_info_v4_7::PowerLimitScalar"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_7, PowerLimitScalar) - 172usize];
    ["Offset of field: atom_smc_dpm_info_v4_7::MvddUlvPhaseSheddingMask"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_7, MvddUlvPhaseSheddingMask) - 176usize];
    ["Offset of field: atom_smc_dpm_info_v4_7::VddciUlvPhaseSheddingMask"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_7, VddciUlvPhaseSheddingMask) - 177usize];
    ["Offset of field: atom_smc_dpm_info_v4_7::Padding8_Psi1"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_7, Padding8_Psi1) - 178usize];
    ["Offset of field: atom_smc_dpm_info_v4_7::Padding8_Psi2"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_7, Padding8_Psi2) - 179usize];
    ["Offset of field: atom_smc_dpm_info_v4_7::BoardReserved"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_7, BoardReserved) - 180usize];
};
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct smudpm_i2c_controller_config_v3 {
    pub Enabled: u8,
    pub Speed: u8,
    pub SlaveAddress: u8,
    pub ControllerPort: u8,
    pub ControllerName: u8,
    pub ThermalThrotter: u8,
    pub I2cProtocol: u8,
    pub PaddingConfig: u8,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of smudpm_i2c_controller_config_v3"]
        [::core::mem::size_of::<smudpm_i2c_controller_config_v3>() - 8usize];
    ["Alignment of smudpm_i2c_controller_config_v3"]
        [::core::mem::align_of::<smudpm_i2c_controller_config_v3>() - 1usize];
    ["Offset of field: smudpm_i2c_controller_config_v3::Enabled"]
        [::core::mem::offset_of!(smudpm_i2c_controller_config_v3, Enabled) - 0usize];
    ["Offset of field: smudpm_i2c_controller_config_v3::Speed"]
        [::core::mem::offset_of!(smudpm_i2c_controller_config_v3, Speed) - 1usize];
    ["Offset of field: smudpm_i2c_controller_config_v3::SlaveAddress"]
        [::core::mem::offset_of!(smudpm_i2c_controller_config_v3, SlaveAddress) - 2usize];
    ["Offset of field: smudpm_i2c_controller_config_v3::ControllerPort"]
        [::core::mem::offset_of!(smudpm_i2c_controller_config_v3, ControllerPort) - 3usize];
    ["Offset of field: smudpm_i2c_controller_config_v3::ControllerName"]
        [::core::mem::offset_of!(smudpm_i2c_controller_config_v3, ControllerName) - 4usize];
    ["Offset of field: smudpm_i2c_controller_config_v3::ThermalThrotter"]
        [::core::mem::offset_of!(smudpm_i2c_controller_config_v3, ThermalThrotter) - 5usize];
    ["Offset of field: smudpm_i2c_controller_config_v3::I2cProtocol"]
        [::core::mem::offset_of!(smudpm_i2c_controller_config_v3, I2cProtocol) - 6usize];
    ["Offset of field: smudpm_i2c_controller_config_v3::PaddingConfig"]
        [::core::mem::offset_of!(smudpm_i2c_controller_config_v3, PaddingConfig) - 7usize];
};
#[repr(C, packed)]
#[derive(Debug, Copy, Clone)]
pub struct atom_smc_dpm_info_v4_9 {
    pub table_header: atom_common_table_header,
    pub I2cControllers: [smudpm_i2c_controller_config_v3; 16usize],
    pub GpioScl: u8,
    pub GpioSda: u8,
    pub FchUsbPdSlaveAddr: u8,
    pub I2cSpare: u8,
    pub VddGfxVrMapping: u8,
    pub VddSocVrMapping: u8,
    pub VddMem0VrMapping: u8,
    pub VddMem1VrMapping: u8,
    pub GfxUlvPhaseSheddingMask: u8,
    pub SocUlvPhaseSheddingMask: u8,
    pub VddciUlvPhaseSheddingMask: u8,
    pub MvddUlvPhaseSheddingMask: u8,
    pub GfxMaxCurrent: u16,
    pub GfxOffset: u8,
    pub Padding_TelemetryGfx: u8,
    pub SocMaxCurrent: u16,
    pub SocOffset: u8,
    pub Padding_TelemetrySoc: u8,
    pub Mem0MaxCurrent: u16,
    pub Mem0Offset: u8,
    pub Padding_TelemetryMem0: u8,
    pub Mem1MaxCurrent: u16,
    pub Mem1Offset: u8,
    pub Padding_TelemetryMem1: u8,
    pub MvddRatio: u32,
    pub AcDcGpio: u8,
    pub AcDcPolarity: u8,
    pub VR0HotGpio: u8,
    pub VR0HotPolarity: u8,
    pub VR1HotGpio: u8,
    pub VR1HotPolarity: u8,
    pub GthrGpio: u8,
    pub GthrPolarity: u8,
    pub LedPin0: u8,
    pub LedPin1: u8,
    pub LedPin2: u8,
    pub LedEnableMask: u8,
    pub LedPcie: u8,
    pub LedError: u8,
    pub LedSpare1: [u8; 2usize],
    pub PllGfxclkSpreadEnabled: u8,
    pub PllGfxclkSpreadPercent: u8,
    pub PllGfxclkSpreadFreq: u16,
    pub DfllGfxclkSpreadEnabled: u8,
    pub DfllGfxclkSpreadPercent: u8,
    pub DfllGfxclkSpreadFreq: u16,
    pub UclkSpreadEnabled: u8,
    pub UclkSpreadPercent: u8,
    pub UclkSpreadFreq: u16,
    pub FclkSpreadEnabled: u8,
    pub FclkSpreadPercent: u8,
    pub FclkSpreadFreq: u16,
    pub MemoryChannelEnabled: u32,
    pub DramBitWidth: u8,
    pub PaddingMem1: [u8; 3usize],
    pub TotalBoardPower: u16,
    pub BoardPowerPadding: u16,
    pub XgmiLinkSpeed: [u8; 4usize],
    pub XgmiLinkWidth: [u8; 4usize],
    pub XgmiFclkFreq: [u16; 4usize],
    pub XgmiSocVoltage: [u16; 4usize],
    pub BoardReserved: [u32; 16usize],
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of atom_smc_dpm_info_v4_9"][::core::mem::size_of::<atom_smc_dpm_info_v4_9>() - 296usize];
    ["Alignment of atom_smc_dpm_info_v4_9"]
        [::core::mem::align_of::<atom_smc_dpm_info_v4_9>() - 1usize];
    ["Offset of field: atom_smc_dpm_info_v4_9::table_header"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_9, table_header) - 0usize];
    ["Offset of field: atom_smc_dpm_info_v4_9::I2cControllers"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_9, I2cControllers) - 4usize];
    ["Offset of field: atom_smc_dpm_info_v4_9::GpioScl"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_9, GpioScl) - 132usize];
    ["Offset of field: atom_smc_dpm_info_v4_9::GpioSda"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_9, GpioSda) - 133usize];
    ["Offset of field: atom_smc_dpm_info_v4_9::FchUsbPdSlaveAddr"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_9, FchUsbPdSlaveAddr) - 134usize];
    ["Offset of field: atom_smc_dpm_info_v4_9::I2cSpare"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_9, I2cSpare) - 135usize];
    ["Offset of field: atom_smc_dpm_info_v4_9::VddGfxVrMapping"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_9, VddGfxVrMapping) - 136usize];
    ["Offset of field: atom_smc_dpm_info_v4_9::VddSocVrMapping"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_9, VddSocVrMapping) - 137usize];
    ["Offset of field: atom_smc_dpm_info_v4_9::VddMem0VrMapping"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_9, VddMem0VrMapping) - 138usize];
    ["Offset of field: atom_smc_dpm_info_v4_9::VddMem1VrMapping"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_9, VddMem1VrMapping) - 139usize];
    ["Offset of field: atom_smc_dpm_info_v4_9::GfxUlvPhaseSheddingMask"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_9, GfxUlvPhaseSheddingMask) - 140usize];
    ["Offset of field: atom_smc_dpm_info_v4_9::SocUlvPhaseSheddingMask"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_9, SocUlvPhaseSheddingMask) - 141usize];
    ["Offset of field: atom_smc_dpm_info_v4_9::VddciUlvPhaseSheddingMask"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_9, VddciUlvPhaseSheddingMask) - 142usize];
    ["Offset of field: atom_smc_dpm_info_v4_9::MvddUlvPhaseSheddingMask"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_9, MvddUlvPhaseSheddingMask) - 143usize];
    ["Offset of field: atom_smc_dpm_info_v4_9::GfxMaxCurrent"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_9, GfxMaxCurrent) - 144usize];
    ["Offset of field: atom_smc_dpm_info_v4_9::GfxOffset"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_9, GfxOffset) - 146usize];
    ["Offset of field: atom_smc_dpm_info_v4_9::Padding_TelemetryGfx"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_9, Padding_TelemetryGfx) - 147usize];
    ["Offset of field: atom_smc_dpm_info_v4_9::SocMaxCurrent"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_9, SocMaxCurrent) - 148usize];
    ["Offset of field: atom_smc_dpm_info_v4_9::SocOffset"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_9, SocOffset) - 150usize];
    ["Offset of field: atom_smc_dpm_info_v4_9::Padding_TelemetrySoc"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_9, Padding_TelemetrySoc) - 151usize];
    ["Offset of field: atom_smc_dpm_info_v4_9::Mem0MaxCurrent"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_9, Mem0MaxCurrent) - 152usize];
    ["Offset of field: atom_smc_dpm_info_v4_9::Mem0Offset"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_9, Mem0Offset) - 154usize];
    ["Offset of field: atom_smc_dpm_info_v4_9::Padding_TelemetryMem0"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_9, Padding_TelemetryMem0) - 155usize];
    ["Offset of field: atom_smc_dpm_info_v4_9::Mem1MaxCurrent"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_9, Mem1MaxCurrent) - 156usize];
    ["Offset of field: atom_smc_dpm_info_v4_9::Mem1Offset"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_9, Mem1Offset) - 158usize];
    ["Offset of field: atom_smc_dpm_info_v4_9::Padding_TelemetryMem1"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_9, Padding_TelemetryMem1) - 159usize];
    ["Offset of field: atom_smc_dpm_info_v4_9::MvddRatio"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_9, MvddRatio) - 160usize];
    ["Offset of field: atom_smc_dpm_info_v4_9::AcDcGpio"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_9, AcDcGpio) - 164usize];
    ["Offset of field: atom_smc_dpm_info_v4_9::AcDcPolarity"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_9, AcDcPolarity) - 165usize];
    ["Offset of field: atom_smc_dpm_info_v4_9::VR0HotGpio"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_9, VR0HotGpio) - 166usize];
    ["Offset of field: atom_smc_dpm_info_v4_9::VR0HotPolarity"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_9, VR0HotPolarity) - 167usize];
    ["Offset of field: atom_smc_dpm_info_v4_9::VR1HotGpio"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_9, VR1HotGpio) - 168usize];
    ["Offset of field: atom_smc_dpm_info_v4_9::VR1HotPolarity"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_9, VR1HotPolarity) - 169usize];
    ["Offset of field: atom_smc_dpm_info_v4_9::GthrGpio"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_9, GthrGpio) - 170usize];
    ["Offset of field: atom_smc_dpm_info_v4_9::GthrPolarity"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_9, GthrPolarity) - 171usize];
    ["Offset of field: atom_smc_dpm_info_v4_9::LedPin0"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_9, LedPin0) - 172usize];
    ["Offset of field: atom_smc_dpm_info_v4_9::LedPin1"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_9, LedPin1) - 173usize];
    ["Offset of field: atom_smc_dpm_info_v4_9::LedPin2"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_9, LedPin2) - 174usize];
    ["Offset of field: atom_smc_dpm_info_v4_9::LedEnableMask"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_9, LedEnableMask) - 175usize];
    ["Offset of field: atom_smc_dpm_info_v4_9::LedPcie"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_9, LedPcie) - 176usize];
    ["Offset of field: atom_smc_dpm_info_v4_9::LedError"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_9, LedError) - 177usize];
    ["Offset of field: atom_smc_dpm_info_v4_9::LedSpare1"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_9, LedSpare1) - 178usize];
    ["Offset of field: atom_smc_dpm_info_v4_9::PllGfxclkSpreadEnabled"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_9, PllGfxclkSpreadEnabled) - 180usize];
    ["Offset of field: atom_smc_dpm_info_v4_9::PllGfxclkSpreadPercent"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_9, PllGfxclkSpreadPercent) - 181usize];
    ["Offset of field: atom_smc_dpm_info_v4_9::PllGfxclkSpreadFreq"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_9, PllGfxclkSpreadFreq) - 182usize];
    ["Offset of field: atom_smc_dpm_info_v4_9::DfllGfxclkSpreadEnabled"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_9, DfllGfxclkSpreadEnabled) - 184usize];
    ["Offset of field: atom_smc_dpm_info_v4_9::DfllGfxclkSpreadPercent"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_9, DfllGfxclkSpreadPercent) - 185usize];
    ["Offset of field: atom_smc_dpm_info_v4_9::DfllGfxclkSpreadFreq"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_9, DfllGfxclkSpreadFreq) - 186usize];
    ["Offset of field: atom_smc_dpm_info_v4_9::UclkSpreadEnabled"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_9, UclkSpreadEnabled) - 188usize];
    ["Offset of field: atom_smc_dpm_info_v4_9::UclkSpreadPercent"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_9, UclkSpreadPercent) - 189usize];
    ["Offset of field: atom_smc_dpm_info_v4_9::UclkSpreadFreq"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_9, UclkSpreadFreq) - 190usize];
    ["Offset of field: atom_smc_dpm_info_v4_9::FclkSpreadEnabled"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_9, FclkSpreadEnabled) - 192usize];
    ["Offset of field: atom_smc_dpm_info_v4_9::FclkSpreadPercent"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_9, FclkSpreadPercent) - 193usize];
    ["Offset of field: atom_smc_dpm_info_v4_9::FclkSpreadFreq"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_9, FclkSpreadFreq) - 194usize];
    ["Offset of field: atom_smc_dpm_info_v4_9::MemoryChannelEnabled"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_9, MemoryChannelEnabled) - 196usize];
    ["Offset of field: atom_smc_dpm_info_v4_9::DramBitWidth"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_9, DramBitWidth) - 200usize];
    ["Offset of field: atom_smc_dpm_info_v4_9::PaddingMem1"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_9, PaddingMem1) - 201usize];
    ["Offset of field: atom_smc_dpm_info_v4_9::TotalBoardPower"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_9, TotalBoardPower) - 204usize];
    ["Offset of field: atom_smc_dpm_info_v4_9::BoardPowerPadding"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_9, BoardPowerPadding) - 206usize];
    ["Offset of field: atom_smc_dpm_info_v4_9::XgmiLinkSpeed"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_9, XgmiLinkSpeed) - 208usize];
    ["Offset of field: atom_smc_dpm_info_v4_9::XgmiLinkWidth"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_9, XgmiLinkWidth) - 212usize];
    ["Offset of field: atom_smc_dpm_info_v4_9::XgmiFclkFreq"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_9, XgmiFclkFreq) - 216usize];
    ["Offset of field: atom_smc_dpm_info_v4_9::XgmiSocVoltage"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_9, XgmiSocVoltage) - 224usize];
    ["Offset of field: atom_smc_dpm_info_v4_9::BoardReserved"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_9, BoardReserved) - 232usize];
};
#[repr(C, packed)]
#[derive(Debug, Copy, Clone)]
pub struct atom_smc_dpm_info_v4_10 {
    pub table_header: atom_common_table_header,
    pub GfxMaxCurrent: u16,
    pub GfxOffset: u8,
    pub Padding_TelemetryGfx: u8,
    pub SocMaxCurrent: u16,
    pub SocOffset: u8,
    pub Padding_TelemetrySoc: u8,
    pub MemMaxCurrent: u16,
    pub MemOffset: u8,
    pub Padding_TelemetryMem: u8,
    pub BoardMaxCurrent: u16,
    pub BoardOffset: u8,
    pub Padding_TelemetryBoardInput: u8,
    pub BoardVoltageCoeffA: u32,
    pub BoardVoltageCoeffB: u32,
    pub VR0HotGpio: u8,
    pub VR0HotPolarity: u8,
    pub VR1HotGpio: u8,
    pub VR1HotPolarity: u8,
    pub UclkSpreadEnabled: u8,
    pub UclkSpreadPercent: u8,
    pub UclkSpreadFreq: u16,
    pub FclkSpreadEnabled: u8,
    pub FclkSpreadPercent: u8,
    pub FclkSpreadFreq: u16,
    pub I2cControllers: [smudpm_i2c_controller_config_v3; 8usize],
    pub GpioI2cScl: u8,
    pub GpioI2cSda: u8,
    pub spare5: u16,
    pub reserved: [u32; 16usize],
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of atom_smc_dpm_info_v4_10"]
        [::core::mem::size_of::<atom_smc_dpm_info_v4_10>() - 172usize];
    ["Alignment of atom_smc_dpm_info_v4_10"]
        [::core::mem::align_of::<atom_smc_dpm_info_v4_10>() - 1usize];
    ["Offset of field: atom_smc_dpm_info_v4_10::table_header"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_10, table_header) - 0usize];
    ["Offset of field: atom_smc_dpm_info_v4_10::GfxMaxCurrent"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_10, GfxMaxCurrent) - 4usize];
    ["Offset of field: atom_smc_dpm_info_v4_10::GfxOffset"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_10, GfxOffset) - 6usize];
    ["Offset of field: atom_smc_dpm_info_v4_10::Padding_TelemetryGfx"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_10, Padding_TelemetryGfx) - 7usize];
    ["Offset of field: atom_smc_dpm_info_v4_10::SocMaxCurrent"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_10, SocMaxCurrent) - 8usize];
    ["Offset of field: atom_smc_dpm_info_v4_10::SocOffset"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_10, SocOffset) - 10usize];
    ["Offset of field: atom_smc_dpm_info_v4_10::Padding_TelemetrySoc"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_10, Padding_TelemetrySoc) - 11usize];
    ["Offset of field: atom_smc_dpm_info_v4_10::MemMaxCurrent"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_10, MemMaxCurrent) - 12usize];
    ["Offset of field: atom_smc_dpm_info_v4_10::MemOffset"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_10, MemOffset) - 14usize];
    ["Offset of field: atom_smc_dpm_info_v4_10::Padding_TelemetryMem"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_10, Padding_TelemetryMem) - 15usize];
    ["Offset of field: atom_smc_dpm_info_v4_10::BoardMaxCurrent"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_10, BoardMaxCurrent) - 16usize];
    ["Offset of field: atom_smc_dpm_info_v4_10::BoardOffset"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_10, BoardOffset) - 18usize];
    ["Offset of field: atom_smc_dpm_info_v4_10::Padding_TelemetryBoardInput"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_10, Padding_TelemetryBoardInput) - 19usize];
    ["Offset of field: atom_smc_dpm_info_v4_10::BoardVoltageCoeffA"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_10, BoardVoltageCoeffA) - 20usize];
    ["Offset of field: atom_smc_dpm_info_v4_10::BoardVoltageCoeffB"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_10, BoardVoltageCoeffB) - 24usize];
    ["Offset of field: atom_smc_dpm_info_v4_10::VR0HotGpio"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_10, VR0HotGpio) - 28usize];
    ["Offset of field: atom_smc_dpm_info_v4_10::VR0HotPolarity"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_10, VR0HotPolarity) - 29usize];
    ["Offset of field: atom_smc_dpm_info_v4_10::VR1HotGpio"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_10, VR1HotGpio) - 30usize];
    ["Offset of field: atom_smc_dpm_info_v4_10::VR1HotPolarity"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_10, VR1HotPolarity) - 31usize];
    ["Offset of field: atom_smc_dpm_info_v4_10::UclkSpreadEnabled"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_10, UclkSpreadEnabled) - 32usize];
    ["Offset of field: atom_smc_dpm_info_v4_10::UclkSpreadPercent"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_10, UclkSpreadPercent) - 33usize];
    ["Offset of field: atom_smc_dpm_info_v4_10::UclkSpreadFreq"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_10, UclkSpreadFreq) - 34usize];
    ["Offset of field: atom_smc_dpm_info_v4_10::FclkSpreadEnabled"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_10, FclkSpreadEnabled) - 36usize];
    ["Offset of field: atom_smc_dpm_info_v4_10::FclkSpreadPercent"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_10, FclkSpreadPercent) - 37usize];
    ["Offset of field: atom_smc_dpm_info_v4_10::FclkSpreadFreq"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_10, FclkSpreadFreq) - 38usize];
    ["Offset of field: atom_smc_dpm_info_v4_10::I2cControllers"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_10, I2cControllers) - 40usize];
    ["Offset of field: atom_smc_dpm_info_v4_10::GpioI2cScl"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_10, GpioI2cScl) - 104usize];
    ["Offset of field: atom_smc_dpm_info_v4_10::GpioI2cSda"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_10, GpioI2cSda) - 105usize];
    ["Offset of field: atom_smc_dpm_info_v4_10::spare5"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_10, spare5) - 106usize];
    ["Offset of field: atom_smc_dpm_info_v4_10::reserved"]
        [::core::mem::offset_of!(atom_smc_dpm_info_v4_10, reserved) - 108usize];
};
#[repr(C, packed)]
#[derive(Debug, Copy, Clone)]
pub struct atom_asic_profiling_info_v4_1 {
    pub table_header: atom_common_table_header,
    pub maxvddc: u32,
    pub minvddc: u32,
    pub avfs_meannsigma_acontant0: u32,
    pub avfs_meannsigma_acontant1: u32,
    pub avfs_meannsigma_acontant2: u32,
    pub avfs_meannsigma_dc_tol_sigma: u16,
    pub avfs_meannsigma_platform_mean: u16,
    pub avfs_meannsigma_platform_sigma: u16,
    pub gb_vdroop_table_cksoff_a0: u32,
    pub gb_vdroop_table_cksoff_a1: u32,
    pub gb_vdroop_table_cksoff_a2: u32,
    pub gb_vdroop_table_ckson_a0: u32,
    pub gb_vdroop_table_ckson_a1: u32,
    pub gb_vdroop_table_ckson_a2: u32,
    pub avfsgb_fuse_table_cksoff_m1: u32,
    pub avfsgb_fuse_table_cksoff_m2: u32,
    pub avfsgb_fuse_table_cksoff_b: u32,
    pub avfsgb_fuse_table_ckson_m1: u32,
    pub avfsgb_fuse_table_ckson_m2: u32,
    pub avfsgb_fuse_table_ckson_b: u32,
    pub max_voltage_0_25mv: u16,
    pub enable_gb_vdroop_table_cksoff: u8,
    pub enable_gb_vdroop_table_ckson: u8,
    pub enable_gb_fuse_table_cksoff: u8,
    pub enable_gb_fuse_table_ckson: u8,
    pub psm_age_comfactor: u16,
    pub enable_apply_avfs_cksoff_voltage: u8,
    pub reserved: u8,
    pub dispclk2gfxclk_a: u32,
    pub dispclk2gfxclk_b: u32,
    pub dispclk2gfxclk_c: u32,
    pub pixclk2gfxclk_a: u32,
    pub pixclk2gfxclk_b: u32,
    pub pixclk2gfxclk_c: u32,
    pub dcefclk2gfxclk_a: u32,
    pub dcefclk2gfxclk_b: u32,
    pub dcefclk2gfxclk_c: u32,
    pub phyclk2gfxclk_a: u32,
    pub phyclk2gfxclk_b: u32,
    pub phyclk2gfxclk_c: u32,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of atom_asic_profiling_info_v4_1"]
        [::core::mem::size_of::<atom_asic_profiling_info_v4_1>() - 136usize];
    ["Alignment of atom_asic_profiling_info_v4_1"]
        [::core::mem::align_of::<atom_asic_profiling_info_v4_1>() - 1usize];
    ["Offset of field: atom_asic_profiling_info_v4_1::table_header"]
        [::core::mem::offset_of!(atom_asic_profiling_info_v4_1, table_header) - 0usize];
    ["Offset of field: atom_asic_profiling_info_v4_1::maxvddc"]
        [::core::mem::offset_of!(atom_asic_profiling_info_v4_1, maxvddc) - 4usize];
    ["Offset of field: atom_asic_profiling_info_v4_1::minvddc"]
        [::core::mem::offset_of!(atom_asic_profiling_info_v4_1, minvddc) - 8usize];
    ["Offset of field: atom_asic_profiling_info_v4_1::avfs_meannsigma_acontant0"][::core::mem::offset_of!(
        atom_asic_profiling_info_v4_1,
        avfs_meannsigma_acontant0
    ) - 12usize];
    ["Offset of field: atom_asic_profiling_info_v4_1::avfs_meannsigma_acontant1"][::core::mem::offset_of!(
        atom_asic_profiling_info_v4_1,
        avfs_meannsigma_acontant1
    ) - 16usize];
    ["Offset of field: atom_asic_profiling_info_v4_1::avfs_meannsigma_acontant2"][::core::mem::offset_of!(
        atom_asic_profiling_info_v4_1,
        avfs_meannsigma_acontant2
    ) - 20usize];
    ["Offset of field: atom_asic_profiling_info_v4_1::avfs_meannsigma_dc_tol_sigma"][::core::mem::offset_of!(
        atom_asic_profiling_info_v4_1,
        avfs_meannsigma_dc_tol_sigma
    ) - 24usize];
    ["Offset of field: atom_asic_profiling_info_v4_1::avfs_meannsigma_platform_mean"][::core::mem::offset_of!(
        atom_asic_profiling_info_v4_1,
        avfs_meannsigma_platform_mean
    ) - 26usize];
    ["Offset of field: atom_asic_profiling_info_v4_1::avfs_meannsigma_platform_sigma"][::core::mem::offset_of!(
        atom_asic_profiling_info_v4_1,
        avfs_meannsigma_platform_sigma
    ) - 28usize];
    ["Offset of field: atom_asic_profiling_info_v4_1::gb_vdroop_table_cksoff_a0"][::core::mem::offset_of!(
        atom_asic_profiling_info_v4_1,
        gb_vdroop_table_cksoff_a0
    ) - 30usize];
    ["Offset of field: atom_asic_profiling_info_v4_1::gb_vdroop_table_cksoff_a1"][::core::mem::offset_of!(
        atom_asic_profiling_info_v4_1,
        gb_vdroop_table_cksoff_a1
    ) - 34usize];
    ["Offset of field: atom_asic_profiling_info_v4_1::gb_vdroop_table_cksoff_a2"][::core::mem::offset_of!(
        atom_asic_profiling_info_v4_1,
        gb_vdroop_table_cksoff_a2
    ) - 38usize];
    ["Offset of field: atom_asic_profiling_info_v4_1::gb_vdroop_table_ckson_a0"][::core::mem::offset_of!(
        atom_asic_profiling_info_v4_1,
        gb_vdroop_table_ckson_a0
    ) - 42usize];
    ["Offset of field: atom_asic_profiling_info_v4_1::gb_vdroop_table_ckson_a1"][::core::mem::offset_of!(
        atom_asic_profiling_info_v4_1,
        gb_vdroop_table_ckson_a1
    ) - 46usize];
    ["Offset of field: atom_asic_profiling_info_v4_1::gb_vdroop_table_ckson_a2"][::core::mem::offset_of!(
        atom_asic_profiling_info_v4_1,
        gb_vdroop_table_ckson_a2
    ) - 50usize];
    ["Offset of field: atom_asic_profiling_info_v4_1::avfsgb_fuse_table_cksoff_m1"][::core::mem::offset_of!(
        atom_asic_profiling_info_v4_1,
        avfsgb_fuse_table_cksoff_m1
    ) - 54usize];
    ["Offset of field: atom_asic_profiling_info_v4_1::avfsgb_fuse_table_cksoff_m2"][::core::mem::offset_of!(
        atom_asic_profiling_info_v4_1,
        avfsgb_fuse_table_cksoff_m2
    ) - 58usize];
    ["Offset of field: atom_asic_profiling_info_v4_1::avfsgb_fuse_table_cksoff_b"][::core::mem::offset_of!(
        atom_asic_profiling_info_v4_1,
        avfsgb_fuse_table_cksoff_b
    ) - 62usize];
    ["Offset of field: atom_asic_profiling_info_v4_1::avfsgb_fuse_table_ckson_m1"][::core::mem::offset_of!(
        atom_asic_profiling_info_v4_1,
        avfsgb_fuse_table_ckson_m1
    ) - 66usize];
    ["Offset of field: atom_asic_profiling_info_v4_1::avfsgb_fuse_table_ckson_m2"][::core::mem::offset_of!(
        atom_asic_profiling_info_v4_1,
        avfsgb_fuse_table_ckson_m2
    ) - 70usize];
    ["Offset of field: atom_asic_profiling_info_v4_1::avfsgb_fuse_table_ckson_b"][::core::mem::offset_of!(
        atom_asic_profiling_info_v4_1,
        avfsgb_fuse_table_ckson_b
    ) - 74usize];
    ["Offset of field: atom_asic_profiling_info_v4_1::max_voltage_0_25mv"]
        [::core::mem::offset_of!(atom_asic_profiling_info_v4_1, max_voltage_0_25mv) - 78usize];
    ["Offset of field: atom_asic_profiling_info_v4_1::enable_gb_vdroop_table_cksoff"][::core::mem::offset_of!(
        atom_asic_profiling_info_v4_1,
        enable_gb_vdroop_table_cksoff
    ) - 80usize];
    ["Offset of field: atom_asic_profiling_info_v4_1::enable_gb_vdroop_table_ckson"][::core::mem::offset_of!(
        atom_asic_profiling_info_v4_1,
        enable_gb_vdroop_table_ckson
    ) - 81usize];
    ["Offset of field: atom_asic_profiling_info_v4_1::enable_gb_fuse_table_cksoff"][::core::mem::offset_of!(
        atom_asic_profiling_info_v4_1,
        enable_gb_fuse_table_cksoff
    ) - 82usize];
    ["Offset of field: atom_asic_profiling_info_v4_1::enable_gb_fuse_table_ckson"][::core::mem::offset_of!(
        atom_asic_profiling_info_v4_1,
        enable_gb_fuse_table_ckson
    ) - 83usize];
    ["Offset of field: atom_asic_profiling_info_v4_1::psm_age_comfactor"]
        [::core::mem::offset_of!(atom_asic_profiling_info_v4_1, psm_age_comfactor) - 84usize];
    ["Offset of field: atom_asic_profiling_info_v4_1::enable_apply_avfs_cksoff_voltage"][::core::mem::offset_of!(
        atom_asic_profiling_info_v4_1,
        enable_apply_avfs_cksoff_voltage
    )
        - 86usize];
    ["Offset of field: atom_asic_profiling_info_v4_1::reserved"]
        [::core::mem::offset_of!(atom_asic_profiling_info_v4_1, reserved) - 87usize];
    ["Offset of field: atom_asic_profiling_info_v4_1::dispclk2gfxclk_a"]
        [::core::mem::offset_of!(atom_asic_profiling_info_v4_1, dispclk2gfxclk_a) - 88usize];
    ["Offset of field: atom_asic_profiling_info_v4_1::dispclk2gfxclk_b"]
        [::core::mem::offset_of!(atom_asic_profiling_info_v4_1, dispclk2gfxclk_b) - 92usize];
    ["Offset of field: atom_asic_profiling_info_v4_1::dispclk2gfxclk_c"]
        [::core::mem::offset_of!(atom_asic_profiling_info_v4_1, dispclk2gfxclk_c) - 96usize];
    ["Offset of field: atom_asic_profiling_info_v4_1::pixclk2gfxclk_a"]
        [::core::mem::offset_of!(atom_asic_profiling_info_v4_1, pixclk2gfxclk_a) - 100usize];
    ["Offset of field: atom_asic_profiling_info_v4_1::pixclk2gfxclk_b"]
        [::core::mem::offset_of!(atom_asic_profiling_info_v4_1, pixclk2gfxclk_b) - 104usize];
    ["Offset of field: atom_asic_profiling_info_v4_1::pixclk2gfxclk_c"]
        [::core::mem::offset_of!(atom_asic_profiling_info_v4_1, pixclk2gfxclk_c) - 108usize];
    ["Offset of field: atom_asic_profiling_info_v4_1::dcefclk2gfxclk_a"]
        [::core::mem::offset_of!(atom_asic_profiling_info_v4_1, dcefclk2gfxclk_a) - 112usize];
    ["Offset of field: atom_asic_profiling_info_v4_1::dcefclk2gfxclk_b"]
        [::core::mem::offset_of!(atom_asic_profiling_info_v4_1, dcefclk2gfxclk_b) - 116usize];
    ["Offset of field: atom_asic_profiling_info_v4_1::dcefclk2gfxclk_c"]
        [::core::mem::offset_of!(atom_asic_profiling_info_v4_1, dcefclk2gfxclk_c) - 120usize];
    ["Offset of field: atom_asic_profiling_info_v4_1::phyclk2gfxclk_a"]
        [::core::mem::offset_of!(atom_asic_profiling_info_v4_1, phyclk2gfxclk_a) - 124usize];
    ["Offset of field: atom_asic_profiling_info_v4_1::phyclk2gfxclk_b"]
        [::core::mem::offset_of!(atom_asic_profiling_info_v4_1, phyclk2gfxclk_b) - 128usize];
    ["Offset of field: atom_asic_profiling_info_v4_1::phyclk2gfxclk_c"]
        [::core::mem::offset_of!(atom_asic_profiling_info_v4_1, phyclk2gfxclk_c) - 132usize];
};
#[repr(C, packed)]
#[derive(Debug, Copy, Clone)]
pub struct atom_asic_profiling_info_v4_2 {
    pub table_header: atom_common_table_header,
    pub maxvddc: u32,
    pub minvddc: u32,
    pub avfs_meannsigma_acontant0: u32,
    pub avfs_meannsigma_acontant1: u32,
    pub avfs_meannsigma_acontant2: u32,
    pub avfs_meannsigma_dc_tol_sigma: u16,
    pub avfs_meannsigma_platform_mean: u16,
    pub avfs_meannsigma_platform_sigma: u16,
    pub gb_vdroop_table_cksoff_a0: u32,
    pub gb_vdroop_table_cksoff_a1: u32,
    pub gb_vdroop_table_cksoff_a2: u32,
    pub gb_vdroop_table_ckson_a0: u32,
    pub gb_vdroop_table_ckson_a1: u32,
    pub gb_vdroop_table_ckson_a2: u32,
    pub avfsgb_fuse_table_cksoff_m1: u32,
    pub avfsgb_fuse_table_cksoff_m2: u32,
    pub avfsgb_fuse_table_cksoff_b: u32,
    pub avfsgb_fuse_table_ckson_m1: u32,
    pub avfsgb_fuse_table_ckson_m2: u32,
    pub avfsgb_fuse_table_ckson_b: u32,
    pub max_voltage_0_25mv: u16,
    pub enable_gb_vdroop_table_cksoff: u8,
    pub enable_gb_vdroop_table_ckson: u8,
    pub enable_gb_fuse_table_cksoff: u8,
    pub enable_gb_fuse_table_ckson: u8,
    pub psm_age_comfactor: u16,
    pub enable_apply_avfs_cksoff_voltage: u8,
    pub reserved: u8,
    pub dispclk2gfxclk_a: u32,
    pub dispclk2gfxclk_b: u32,
    pub dispclk2gfxclk_c: u32,
    pub pixclk2gfxclk_a: u32,
    pub pixclk2gfxclk_b: u32,
    pub pixclk2gfxclk_c: u32,
    pub dcefclk2gfxclk_a: u32,
    pub dcefclk2gfxclk_b: u32,
    pub dcefclk2gfxclk_c: u32,
    pub phyclk2gfxclk_a: u32,
    pub phyclk2gfxclk_b: u32,
    pub phyclk2gfxclk_c: u32,
    pub acg_gb_vdroop_table_a0: u32,
    pub acg_gb_vdroop_table_a1: u32,
    pub acg_gb_vdroop_table_a2: u32,
    pub acg_avfsgb_fuse_table_m1: u32,
    pub acg_avfsgb_fuse_table_m2: u32,
    pub acg_avfsgb_fuse_table_b: u32,
    pub enable_acg_gb_vdroop_table: u8,
    pub enable_acg_gb_fuse_table: u8,
    pub acg_dispclk2gfxclk_a: u32,
    pub acg_dispclk2gfxclk_b: u32,
    pub acg_dispclk2gfxclk_c: u32,
    pub acg_pixclk2gfxclk_a: u32,
    pub acg_pixclk2gfxclk_b: u32,
    pub acg_pixclk2gfxclk_c: u32,
    pub acg_dcefclk2gfxclk_a: u32,
    pub acg_dcefclk2gfxclk_b: u32,
    pub acg_dcefclk2gfxclk_c: u32,
    pub acg_phyclk2gfxclk_a: u32,
    pub acg_phyclk2gfxclk_b: u32,
    pub acg_phyclk2gfxclk_c: u32,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of atom_asic_profiling_info_v4_2"]
        [::core::mem::size_of::<atom_asic_profiling_info_v4_2>() - 210usize];
    ["Alignment of atom_asic_profiling_info_v4_2"]
        [::core::mem::align_of::<atom_asic_profiling_info_v4_2>() - 1usize];
    ["Offset of field: atom_asic_profiling_info_v4_2::table_header"]
        [::core::mem::offset_of!(atom_asic_profiling_info_v4_2, table_header) - 0usize];
    ["Offset of field: atom_asic_profiling_info_v4_2::maxvddc"]
        [::core::mem::offset_of!(atom_asic_profiling_info_v4_2, maxvddc) - 4usize];
    ["Offset of field: atom_asic_profiling_info_v4_2::minvddc"]
        [::core::mem::offset_of!(atom_asic_profiling_info_v4_2, minvddc) - 8usize];
    ["Offset of field: atom_asic_profiling_info_v4_2::avfs_meannsigma_acontant0"][::core::mem::offset_of!(
        atom_asic_profiling_info_v4_2,
        avfs_meannsigma_acontant0
    ) - 12usize];
    ["Offset of field: atom_asic_profiling_info_v4_2::avfs_meannsigma_acontant1"][::core::mem::offset_of!(
        atom_asic_profiling_info_v4_2,
        avfs_meannsigma_acontant1
    ) - 16usize];
    ["Offset of field: atom_asic_profiling_info_v4_2::avfs_meannsigma_acontant2"][::core::mem::offset_of!(
        atom_asic_profiling_info_v4_2,
        avfs_meannsigma_acontant2
    ) - 20usize];
    ["Offset of field: atom_asic_profiling_info_v4_2::avfs_meannsigma_dc_tol_sigma"][::core::mem::offset_of!(
        atom_asic_profiling_info_v4_2,
        avfs_meannsigma_dc_tol_sigma
    ) - 24usize];
    ["Offset of field: atom_asic_profiling_info_v4_2::avfs_meannsigma_platform_mean"][::core::mem::offset_of!(
        atom_asic_profiling_info_v4_2,
        avfs_meannsigma_platform_mean
    ) - 26usize];
    ["Offset of field: atom_asic_profiling_info_v4_2::avfs_meannsigma_platform_sigma"][::core::mem::offset_of!(
        atom_asic_profiling_info_v4_2,
        avfs_meannsigma_platform_sigma
    ) - 28usize];
    ["Offset of field: atom_asic_profiling_info_v4_2::gb_vdroop_table_cksoff_a0"][::core::mem::offset_of!(
        atom_asic_profiling_info_v4_2,
        gb_vdroop_table_cksoff_a0
    ) - 30usize];
    ["Offset of field: atom_asic_profiling_info_v4_2::gb_vdroop_table_cksoff_a1"][::core::mem::offset_of!(
        atom_asic_profiling_info_v4_2,
        gb_vdroop_table_cksoff_a1
    ) - 34usize];
    ["Offset of field: atom_asic_profiling_info_v4_2::gb_vdroop_table_cksoff_a2"][::core::mem::offset_of!(
        atom_asic_profiling_info_v4_2,
        gb_vdroop_table_cksoff_a2
    ) - 38usize];
    ["Offset of field: atom_asic_profiling_info_v4_2::gb_vdroop_table_ckson_a0"][::core::mem::offset_of!(
        atom_asic_profiling_info_v4_2,
        gb_vdroop_table_ckson_a0
    ) - 42usize];
    ["Offset of field: atom_asic_profiling_info_v4_2::gb_vdroop_table_ckson_a1"][::core::mem::offset_of!(
        atom_asic_profiling_info_v4_2,
        gb_vdroop_table_ckson_a1
    ) - 46usize];
    ["Offset of field: atom_asic_profiling_info_v4_2::gb_vdroop_table_ckson_a2"][::core::mem::offset_of!(
        atom_asic_profiling_info_v4_2,
        gb_vdroop_table_ckson_a2
    ) - 50usize];
    ["Offset of field: atom_asic_profiling_info_v4_2::avfsgb_fuse_table_cksoff_m1"][::core::mem::offset_of!(
        atom_asic_profiling_info_v4_2,
        avfsgb_fuse_table_cksoff_m1
    ) - 54usize];
    ["Offset of field: atom_asic_profiling_info_v4_2::avfsgb_fuse_table_cksoff_m2"][::core::mem::offset_of!(
        atom_asic_profiling_info_v4_2,
        avfsgb_fuse_table_cksoff_m2
    ) - 58usize];
    ["Offset of field: atom_asic_profiling_info_v4_2::avfsgb_fuse_table_cksoff_b"][::core::mem::offset_of!(
        atom_asic_profiling_info_v4_2,
        avfsgb_fuse_table_cksoff_b
    ) - 62usize];
    ["Offset of field: atom_asic_profiling_info_v4_2::avfsgb_fuse_table_ckson_m1"][::core::mem::offset_of!(
        atom_asic_profiling_info_v4_2,
        avfsgb_fuse_table_ckson_m1
    ) - 66usize];
    ["Offset of field: atom_asic_profiling_info_v4_2::avfsgb_fuse_table_ckson_m2"][::core::mem::offset_of!(
        atom_asic_profiling_info_v4_2,
        avfsgb_fuse_table_ckson_m2
    ) - 70usize];
    ["Offset of field: atom_asic_profiling_info_v4_2::avfsgb_fuse_table_ckson_b"][::core::mem::offset_of!(
        atom_asic_profiling_info_v4_2,
        avfsgb_fuse_table_ckson_b
    ) - 74usize];
    ["Offset of field: atom_asic_profiling_info_v4_2::max_voltage_0_25mv"]
        [::core::mem::offset_of!(atom_asic_profiling_info_v4_2, max_voltage_0_25mv) - 78usize];
    ["Offset of field: atom_asic_profiling_info_v4_2::enable_gb_vdroop_table_cksoff"][::core::mem::offset_of!(
        atom_asic_profiling_info_v4_2,
        enable_gb_vdroop_table_cksoff
    ) - 80usize];
    ["Offset of field: atom_asic_profiling_info_v4_2::enable_gb_vdroop_table_ckson"][::core::mem::offset_of!(
        atom_asic_profiling_info_v4_2,
        enable_gb_vdroop_table_ckson
    ) - 81usize];
    ["Offset of field: atom_asic_profiling_info_v4_2::enable_gb_fuse_table_cksoff"][::core::mem::offset_of!(
        atom_asic_profiling_info_v4_2,
        enable_gb_fuse_table_cksoff
    ) - 82usize];
    ["Offset of field: atom_asic_profiling_info_v4_2::enable_gb_fuse_table_ckson"][::core::mem::offset_of!(
        atom_asic_profiling_info_v4_2,
        enable_gb_fuse_table_ckson
    ) - 83usize];
    ["Offset of field: atom_asic_profiling_info_v4_2::psm_age_comfactor"]
        [::core::mem::offset_of!(atom_asic_profiling_info_v4_2, psm_age_comfactor) - 84usize];
    ["Offset of field: atom_asic_profiling_info_v4_2::enable_apply_avfs_cksoff_voltage"][::core::mem::offset_of!(
        atom_asic_profiling_info_v4_2,
        enable_apply_avfs_cksoff_voltage
    )
        - 86usize];
    ["Offset of field: atom_asic_profiling_info_v4_2::reserved"]
        [::core::mem::offset_of!(atom_asic_profiling_info_v4_2, reserved) - 87usize];
    ["Offset of field: atom_asic_profiling_info_v4_2::dispclk2gfxclk_a"]
        [::core::mem::offset_of!(atom_asic_profiling_info_v4_2, dispclk2gfxclk_a) - 88usize];
    ["Offset of field: atom_asic_profiling_info_v4_2::dispclk2gfxclk_b"]
        [::core::mem::offset_of!(atom_asic_profiling_info_v4_2, dispclk2gfxclk_b) - 92usize];
    ["Offset of field: atom_asic_profiling_info_v4_2::dispclk2gfxclk_c"]
        [::core::mem::offset_of!(atom_asic_profiling_info_v4_2, dispclk2gfxclk_c) - 96usize];
    ["Offset of field: atom_asic_profiling_info_v4_2::pixclk2gfxclk_a"]
        [::core::mem::offset_of!(atom_asic_profiling_info_v4_2, pixclk2gfxclk_a) - 100usize];
    ["Offset of field: atom_asic_profiling_info_v4_2::pixclk2gfxclk_b"]
        [::core::mem::offset_of!(atom_asic_profiling_info_v4_2, pixclk2gfxclk_b) - 104usize];
    ["Offset of field: atom_asic_profiling_info_v4_2::pixclk2gfxclk_c"]
        [::core::mem::offset_of!(atom_asic_profiling_info_v4_2, pixclk2gfxclk_c) - 108usize];
    ["Offset of field: atom_asic_profiling_info_v4_2::dcefclk2gfxclk_a"]
        [::core::mem::offset_of!(atom_asic_profiling_info_v4_2, dcefclk2gfxclk_a) - 112usize];
    ["Offset of field: atom_asic_profiling_info_v4_2::dcefclk2gfxclk_b"]
        [::core::mem::offset_of!(atom_asic_profiling_info_v4_2, dcefclk2gfxclk_b) - 116usize];
    ["Offset of field: atom_asic_profiling_info_v4_2::dcefclk2gfxclk_c"]
        [::core::mem::offset_of!(atom_asic_profiling_info_v4_2, dcefclk2gfxclk_c) - 120usize];
    ["Offset of field: atom_asic_profiling_info_v4_2::phyclk2gfxclk_a"]
        [::core::mem::offset_of!(atom_asic_profiling_info_v4_2, phyclk2gfxclk_a) - 124usize];
    ["Offset of field: atom_asic_profiling_info_v4_2::phyclk2gfxclk_b"]
        [::core::mem::offset_of!(atom_asic_profiling_info_v4_2, phyclk2gfxclk_b) - 128usize];
    ["Offset of field: atom_asic_profiling_info_v4_2::phyclk2gfxclk_c"]
        [::core::mem::offset_of!(atom_asic_profiling_info_v4_2, phyclk2gfxclk_c) - 132usize];
    ["Offset of field: atom_asic_profiling_info_v4_2::acg_gb_vdroop_table_a0"]
        [::core::mem::offset_of!(atom_asic_profiling_info_v4_2, acg_gb_vdroop_table_a0) - 136usize];
    ["Offset of field: atom_asic_profiling_info_v4_2::acg_gb_vdroop_table_a1"]
        [::core::mem::offset_of!(atom_asic_profiling_info_v4_2, acg_gb_vdroop_table_a1) - 140usize];
    ["Offset of field: atom_asic_profiling_info_v4_2::acg_gb_vdroop_table_a2"]
        [::core::mem::offset_of!(atom_asic_profiling_info_v4_2, acg_gb_vdroop_table_a2) - 144usize];
    ["Offset of field: atom_asic_profiling_info_v4_2::acg_avfsgb_fuse_table_m1"][::core::mem::offset_of!(
        atom_asic_profiling_info_v4_2,
        acg_avfsgb_fuse_table_m1
    ) - 148usize];
    ["Offset of field: atom_asic_profiling_info_v4_2::acg_avfsgb_fuse_table_m2"][::core::mem::offset_of!(
        atom_asic_profiling_info_v4_2,
        acg_avfsgb_fuse_table_m2
    ) - 152usize];
    ["Offset of field: atom_asic_profiling_info_v4_2::acg_avfsgb_fuse_table_b"][::core::mem::offset_of!(
        atom_asic_profiling_info_v4_2,
        acg_avfsgb_fuse_table_b
    ) - 156usize];
    ["Offset of field: atom_asic_profiling_info_v4_2::enable_acg_gb_vdroop_table"][::core::mem::offset_of!(
        atom_asic_profiling_info_v4_2,
        enable_acg_gb_vdroop_table
    ) - 160usize];
    ["Offset of field: atom_asic_profiling_info_v4_2::enable_acg_gb_fuse_table"][::core::mem::offset_of!(
        atom_asic_profiling_info_v4_2,
        enable_acg_gb_fuse_table
    ) - 161usize];
    ["Offset of field: atom_asic_profiling_info_v4_2::acg_dispclk2gfxclk_a"]
        [::core::mem::offset_of!(atom_asic_profiling_info_v4_2, acg_dispclk2gfxclk_a) - 162usize];
    ["Offset of field: atom_asic_profiling_info_v4_2::acg_dispclk2gfxclk_b"]
        [::core::mem::offset_of!(atom_asic_profiling_info_v4_2, acg_dispclk2gfxclk_b) - 166usize];
    ["Offset of field: atom_asic_profiling_info_v4_2::acg_dispclk2gfxclk_c"]
        [::core::mem::offset_of!(atom_asic_profiling_info_v4_2, acg_dispclk2gfxclk_c) - 170usize];
    ["Offset of field: atom_asic_profiling_info_v4_2::acg_pixclk2gfxclk_a"]
        [::core::mem::offset_of!(atom_asic_profiling_info_v4_2, acg_pixclk2gfxclk_a) - 174usize];
    ["Offset of field: atom_asic_profiling_info_v4_2::acg_pixclk2gfxclk_b"]
        [::core::mem::offset_of!(atom_asic_profiling_info_v4_2, acg_pixclk2gfxclk_b) - 178usize];
    ["Offset of field: atom_asic_profiling_info_v4_2::acg_pixclk2gfxclk_c"]
        [::core::mem::offset_of!(atom_asic_profiling_info_v4_2, acg_pixclk2gfxclk_c) - 182usize];
    ["Offset of field: atom_asic_profiling_info_v4_2::acg_dcefclk2gfxclk_a"]
        [::core::mem::offset_of!(atom_asic_profiling_info_v4_2, acg_dcefclk2gfxclk_a) - 186usize];
    ["Offset of field: atom_asic_profiling_info_v4_2::acg_dcefclk2gfxclk_b"]
        [::core::mem::offset_of!(atom_asic_profiling_info_v4_2, acg_dcefclk2gfxclk_b) - 190usize];
    ["Offset of field: atom_asic_profiling_info_v4_2::acg_dcefclk2gfxclk_c"]
        [::core::mem::offset_of!(atom_asic_profiling_info_v4_2, acg_dcefclk2gfxclk_c) - 194usize];
    ["Offset of field: atom_asic_profiling_info_v4_2::acg_phyclk2gfxclk_a"]
        [::core::mem::offset_of!(atom_asic_profiling_info_v4_2, acg_phyclk2gfxclk_a) - 198usize];
    ["Offset of field: atom_asic_profiling_info_v4_2::acg_phyclk2gfxclk_b"]
        [::core::mem::offset_of!(atom_asic_profiling_info_v4_2, acg_phyclk2gfxclk_b) - 202usize];
    ["Offset of field: atom_asic_profiling_info_v4_2::acg_phyclk2gfxclk_c"]
        [::core::mem::offset_of!(atom_asic_profiling_info_v4_2, acg_phyclk2gfxclk_c) - 206usize];
};
#[repr(C, packed)]
#[derive(Debug, Copy, Clone)]
pub struct atom_multimedia_info_v2_1 {
    pub table_header: atom_common_table_header,
    pub uvdip_min_ver: u8,
    pub uvdip_max_ver: u8,
    pub vceip_min_ver: u8,
    pub vceip_max_ver: u8,
    pub uvd_enc_max_input_width_pixels: u16,
    pub uvd_enc_max_input_height_pixels: u16,
    pub vce_enc_max_input_width_pixels: u16,
    pub vce_enc_max_input_height_pixels: u16,
    pub uvd_enc_max_bandwidth: u32,
    pub vce_enc_max_bandwidth: u32,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of atom_multimedia_info_v2_1"]
        [::core::mem::size_of::<atom_multimedia_info_v2_1>() - 24usize];
    ["Alignment of atom_multimedia_info_v2_1"]
        [::core::mem::align_of::<atom_multimedia_info_v2_1>() - 1usize];
    ["Offset of field: atom_multimedia_info_v2_1::table_header"]
        [::core::mem::offset_of!(atom_multimedia_info_v2_1, table_header) - 0usize];
    ["Offset of field: atom_multimedia_info_v2_1::uvdip_min_ver"]
        [::core::mem::offset_of!(atom_multimedia_info_v2_1, uvdip_min_ver) - 4usize];
    ["Offset of field: atom_multimedia_info_v2_1::uvdip_max_ver"]
        [::core::mem::offset_of!(atom_multimedia_info_v2_1, uvdip_max_ver) - 5usize];
    ["Offset of field: atom_multimedia_info_v2_1::vceip_min_ver"]
        [::core::mem::offset_of!(atom_multimedia_info_v2_1, vceip_min_ver) - 6usize];
    ["Offset of field: atom_multimedia_info_v2_1::vceip_max_ver"]
        [::core::mem::offset_of!(atom_multimedia_info_v2_1, vceip_max_ver) - 7usize];
    ["Offset of field: atom_multimedia_info_v2_1::uvd_enc_max_input_width_pixels"][::core::mem::offset_of!(
        atom_multimedia_info_v2_1,
        uvd_enc_max_input_width_pixels
    ) - 8usize];
    ["Offset of field: atom_multimedia_info_v2_1::uvd_enc_max_input_height_pixels"][::core::mem::offset_of!(
        atom_multimedia_info_v2_1,
        uvd_enc_max_input_height_pixels
    ) - 10usize];
    ["Offset of field: atom_multimedia_info_v2_1::vce_enc_max_input_width_pixels"][::core::mem::offset_of!(
        atom_multimedia_info_v2_1,
        vce_enc_max_input_width_pixels
    ) - 12usize];
    ["Offset of field: atom_multimedia_info_v2_1::vce_enc_max_input_height_pixels"][::core::mem::offset_of!(
        atom_multimedia_info_v2_1,
        vce_enc_max_input_height_pixels
    ) - 14usize];
    ["Offset of field: atom_multimedia_info_v2_1::uvd_enc_max_bandwidth"]
        [::core::mem::offset_of!(atom_multimedia_info_v2_1, uvd_enc_max_bandwidth) - 16usize];
    ["Offset of field: atom_multimedia_info_v2_1::vce_enc_max_bandwidth"]
        [::core::mem::offset_of!(atom_multimedia_info_v2_1, vce_enc_max_bandwidth) - 20usize];
};
#[repr(C, packed)]
#[derive(Debug, Copy, Clone)]
pub struct atom_umc_info_v3_1 {
    pub table_header: atom_common_table_header,
    pub ucode_version: u32,
    pub ucode_rom_startaddr: u32,
    pub ucode_length: u32,
    pub umc_reg_init_offset: u16,
    pub customer_ucode_name_offset: u16,
    pub mclk_ss_percentage: u16,
    pub mclk_ss_rate_10hz: u16,
    pub umcip_min_ver: u8,
    pub umcip_max_ver: u8,
    pub vram_type: u8,
    pub umc_config: u8,
    pub mem_refclk_10khz: u32,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of atom_umc_info_v3_1"][::core::mem::size_of::<atom_umc_info_v3_1>() - 32usize];
    ["Alignment of atom_umc_info_v3_1"][::core::mem::align_of::<atom_umc_info_v3_1>() - 1usize];
    ["Offset of field: atom_umc_info_v3_1::table_header"]
        [::core::mem::offset_of!(atom_umc_info_v3_1, table_header) - 0usize];
    ["Offset of field: atom_umc_info_v3_1::ucode_version"]
        [::core::mem::offset_of!(atom_umc_info_v3_1, ucode_version) - 4usize];
    ["Offset of field: atom_umc_info_v3_1::ucode_rom_startaddr"]
        [::core::mem::offset_of!(atom_umc_info_v3_1, ucode_rom_startaddr) - 8usize];
    ["Offset of field: atom_umc_info_v3_1::ucode_length"]
        [::core::mem::offset_of!(atom_umc_info_v3_1, ucode_length) - 12usize];
    ["Offset of field: atom_umc_info_v3_1::umc_reg_init_offset"]
        [::core::mem::offset_of!(atom_umc_info_v3_1, umc_reg_init_offset) - 16usize];
    ["Offset of field: atom_umc_info_v3_1::customer_ucode_name_offset"]
        [::core::mem::offset_of!(atom_umc_info_v3_1, customer_ucode_name_offset) - 18usize];
    ["Offset of field: atom_umc_info_v3_1::mclk_ss_percentage"]
        [::core::mem::offset_of!(atom_umc_info_v3_1, mclk_ss_percentage) - 20usize];
    ["Offset of field: atom_umc_info_v3_1::mclk_ss_rate_10hz"]
        [::core::mem::offset_of!(atom_umc_info_v3_1, mclk_ss_rate_10hz) - 22usize];
    ["Offset of field: atom_umc_info_v3_1::umcip_min_ver"]
        [::core::mem::offset_of!(atom_umc_info_v3_1, umcip_min_ver) - 24usize];
    ["Offset of field: atom_umc_info_v3_1::umcip_max_ver"]
        [::core::mem::offset_of!(atom_umc_info_v3_1, umcip_max_ver) - 25usize];
    ["Offset of field: atom_umc_info_v3_1::vram_type"]
        [::core::mem::offset_of!(atom_umc_info_v3_1, vram_type) - 26usize];
    ["Offset of field: atom_umc_info_v3_1::umc_config"]
        [::core::mem::offset_of!(atom_umc_info_v3_1, umc_config) - 27usize];
    ["Offset of field: atom_umc_info_v3_1::mem_refclk_10khz"]
        [::core::mem::offset_of!(atom_umc_info_v3_1, mem_refclk_10khz) - 28usize];
};
pub const atom_umc_config_def_UMC_CONFIG__ENABLE_1KB_INTERLEAVE_MODE: atom_umc_config_def = 1;
pub const atom_umc_config_def_UMC_CONFIG__DEFAULT_MEM_ECC_ENABLE: atom_umc_config_def = 2;
pub const atom_umc_config_def_UMC_CONFIG__ENABLE_HBM_LANE_REPAIR: atom_umc_config_def = 4;
pub const atom_umc_config_def_UMC_CONFIG__ENABLE_BANK_HARVESTING: atom_umc_config_def = 8;
pub const atom_umc_config_def_UMC_CONFIG__ENABLE_PHY_REINIT: atom_umc_config_def = 16;
pub const atom_umc_config_def_UMC_CONFIG__DISABLE_UCODE_CHKSTATUS: atom_umc_config_def = 32;
pub type atom_umc_config_def = ::core::ffi::c_uint;
#[repr(C, packed)]
#[derive(Debug, Copy, Clone)]
pub struct atom_umc_info_v3_2 {
    pub table_header: atom_common_table_header,
    pub ucode_version: u32,
    pub ucode_rom_startaddr: u32,
    pub ucode_length: u32,
    pub umc_reg_init_offset: u16,
    pub customer_ucode_name_offset: u16,
    pub mclk_ss_percentage: u16,
    pub mclk_ss_rate_10hz: u16,
    pub umcip_min_ver: u8,
    pub umcip_max_ver: u8,
    pub vram_type: u8,
    pub umc_config: u8,
    pub mem_refclk_10khz: u32,
    pub pstate_uclk_10khz: [u32; 4usize],
    pub umcgoldenoffset: u16,
    pub densitygoldenoffset: u16,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of atom_umc_info_v3_2"][::core::mem::size_of::<atom_umc_info_v3_2>() - 52usize];
    ["Alignment of atom_umc_info_v3_2"][::core::mem::align_of::<atom_umc_info_v3_2>() - 1usize];
    ["Offset of field: atom_umc_info_v3_2::table_header"]
        [::core::mem::offset_of!(atom_umc_info_v3_2, table_header) - 0usize];
    ["Offset of field: atom_umc_info_v3_2::ucode_version"]
        [::core::mem::offset_of!(atom_umc_info_v3_2, ucode_version) - 4usize];
    ["Offset of field: atom_umc_info_v3_2::ucode_rom_startaddr"]
        [::core::mem::offset_of!(atom_umc_info_v3_2, ucode_rom_startaddr) - 8usize];
    ["Offset of field: atom_umc_info_v3_2::ucode_length"]
        [::core::mem::offset_of!(atom_umc_info_v3_2, ucode_length) - 12usize];
    ["Offset of field: atom_umc_info_v3_2::umc_reg_init_offset"]
        [::core::mem::offset_of!(atom_umc_info_v3_2, umc_reg_init_offset) - 16usize];
    ["Offset of field: atom_umc_info_v3_2::customer_ucode_name_offset"]
        [::core::mem::offset_of!(atom_umc_info_v3_2, customer_ucode_name_offset) - 18usize];
    ["Offset of field: atom_umc_info_v3_2::mclk_ss_percentage"]
        [::core::mem::offset_of!(atom_umc_info_v3_2, mclk_ss_percentage) - 20usize];
    ["Offset of field: atom_umc_info_v3_2::mclk_ss_rate_10hz"]
        [::core::mem::offset_of!(atom_umc_info_v3_2, mclk_ss_rate_10hz) - 22usize];
    ["Offset of field: atom_umc_info_v3_2::umcip_min_ver"]
        [::core::mem::offset_of!(atom_umc_info_v3_2, umcip_min_ver) - 24usize];
    ["Offset of field: atom_umc_info_v3_2::umcip_max_ver"]
        [::core::mem::offset_of!(atom_umc_info_v3_2, umcip_max_ver) - 25usize];
    ["Offset of field: atom_umc_info_v3_2::vram_type"]
        [::core::mem::offset_of!(atom_umc_info_v3_2, vram_type) - 26usize];
    ["Offset of field: atom_umc_info_v3_2::umc_config"]
        [::core::mem::offset_of!(atom_umc_info_v3_2, umc_config) - 27usize];
    ["Offset of field: atom_umc_info_v3_2::mem_refclk_10khz"]
        [::core::mem::offset_of!(atom_umc_info_v3_2, mem_refclk_10khz) - 28usize];
    ["Offset of field: atom_umc_info_v3_2::pstate_uclk_10khz"]
        [::core::mem::offset_of!(atom_umc_info_v3_2, pstate_uclk_10khz) - 32usize];
    ["Offset of field: atom_umc_info_v3_2::umcgoldenoffset"]
        [::core::mem::offset_of!(atom_umc_info_v3_2, umcgoldenoffset) - 48usize];
    ["Offset of field: atom_umc_info_v3_2::densitygoldenoffset"]
        [::core::mem::offset_of!(atom_umc_info_v3_2, densitygoldenoffset) - 50usize];
};
#[repr(C, packed)]
#[derive(Debug, Copy, Clone)]
pub struct atom_umc_info_v3_3 {
    pub table_header: atom_common_table_header,
    pub ucode_reserved: u32,
    pub ucode_rom_startaddr: u32,
    pub ucode_length: u32,
    pub umc_reg_init_offset: u16,
    pub customer_ucode_name_offset: u16,
    pub mclk_ss_percentage: u16,
    pub mclk_ss_rate_10hz: u16,
    pub umcip_min_ver: u8,
    pub umcip_max_ver: u8,
    pub vram_type: u8,
    pub umc_config: u8,
    pub mem_refclk_10khz: u32,
    pub pstate_uclk_10khz: [u32; 4usize],
    pub umcgoldenoffset: u16,
    pub densitygoldenoffset: u16,
    pub umc_config1: u32,
    pub bist_data_startaddr: u32,
    pub reserved: [u32; 2usize],
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of atom_umc_info_v3_3"][::core::mem::size_of::<atom_umc_info_v3_3>() - 68usize];
    ["Alignment of atom_umc_info_v3_3"][::core::mem::align_of::<atom_umc_info_v3_3>() - 1usize];
    ["Offset of field: atom_umc_info_v3_3::table_header"]
        [::core::mem::offset_of!(atom_umc_info_v3_3, table_header) - 0usize];
    ["Offset of field: atom_umc_info_v3_3::ucode_reserved"]
        [::core::mem::offset_of!(atom_umc_info_v3_3, ucode_reserved) - 4usize];
    ["Offset of field: atom_umc_info_v3_3::ucode_rom_startaddr"]
        [::core::mem::offset_of!(atom_umc_info_v3_3, ucode_rom_startaddr) - 8usize];
    ["Offset of field: atom_umc_info_v3_3::ucode_length"]
        [::core::mem::offset_of!(atom_umc_info_v3_3, ucode_length) - 12usize];
    ["Offset of field: atom_umc_info_v3_3::umc_reg_init_offset"]
        [::core::mem::offset_of!(atom_umc_info_v3_3, umc_reg_init_offset) - 16usize];
    ["Offset of field: atom_umc_info_v3_3::customer_ucode_name_offset"]
        [::core::mem::offset_of!(atom_umc_info_v3_3, customer_ucode_name_offset) - 18usize];
    ["Offset of field: atom_umc_info_v3_3::mclk_ss_percentage"]
        [::core::mem::offset_of!(atom_umc_info_v3_3, mclk_ss_percentage) - 20usize];
    ["Offset of field: atom_umc_info_v3_3::mclk_ss_rate_10hz"]
        [::core::mem::offset_of!(atom_umc_info_v3_3, mclk_ss_rate_10hz) - 22usize];
    ["Offset of field: atom_umc_info_v3_3::umcip_min_ver"]
        [::core::mem::offset_of!(atom_umc_info_v3_3, umcip_min_ver) - 24usize];
    ["Offset of field: atom_umc_info_v3_3::umcip_max_ver"]
        [::core::mem::offset_of!(atom_umc_info_v3_3, umcip_max_ver) - 25usize];
    ["Offset of field: atom_umc_info_v3_3::vram_type"]
        [::core::mem::offset_of!(atom_umc_info_v3_3, vram_type) - 26usize];
    ["Offset of field: atom_umc_info_v3_3::umc_config"]
        [::core::mem::offset_of!(atom_umc_info_v3_3, umc_config) - 27usize];
    ["Offset of field: atom_umc_info_v3_3::mem_refclk_10khz"]
        [::core::mem::offset_of!(atom_umc_info_v3_3, mem_refclk_10khz) - 28usize];
    ["Offset of field: atom_umc_info_v3_3::pstate_uclk_10khz"]
        [::core::mem::offset_of!(atom_umc_info_v3_3, pstate_uclk_10khz) - 32usize];
    ["Offset of field: atom_umc_info_v3_3::umcgoldenoffset"]
        [::core::mem::offset_of!(atom_umc_info_v3_3, umcgoldenoffset) - 48usize];
    ["Offset of field: atom_umc_info_v3_3::densitygoldenoffset"]
        [::core::mem::offset_of!(atom_umc_info_v3_3, densitygoldenoffset) - 50usize];
    ["Offset of field: atom_umc_info_v3_3::umc_config1"]
        [::core::mem::offset_of!(atom_umc_info_v3_3, umc_config1) - 52usize];
    ["Offset of field: atom_umc_info_v3_3::bist_data_startaddr"]
        [::core::mem::offset_of!(atom_umc_info_v3_3, bist_data_startaddr) - 56usize];
    ["Offset of field: atom_umc_info_v3_3::reserved"]
        [::core::mem::offset_of!(atom_umc_info_v3_3, reserved) - 60usize];
};
pub const atom_umc_config1_def_UMC_CONFIG1__ENABLE_PSTATE_PHASE_STORE_TRAIN: atom_umc_config1_def =
    1;
pub const atom_umc_config1_def_UMC_CONFIG1__ENABLE_AUTO_FRAMING: atom_umc_config1_def = 2;
pub const atom_umc_config1_def_UMC_CONFIG1__ENABLE_RESTORE_BIST_DATA: atom_umc_config1_def = 4;
pub const atom_umc_config1_def_UMC_CONFIG1__DISABLE_STROBE_MODE: atom_umc_config1_def = 8;
pub const atom_umc_config1_def_UMC_CONFIG1__DEBUG_DATA_PARITY_EN: atom_umc_config1_def = 16;
pub const atom_umc_config1_def_UMC_CONFIG1__ENABLE_ECC_CAPABLE: atom_umc_config1_def = 65536;
pub type atom_umc_config1_def = ::core::ffi::c_uint;
#[repr(C, packed)]
#[derive(Debug, Copy, Clone)]
pub struct atom_umc_info_v4_0 {
    pub table_header: atom_common_table_header,
    pub ucode_reserved: [u32; 5usize],
    pub umcip_min_ver: u8,
    pub umcip_max_ver: u8,
    pub vram_type: u8,
    pub umc_config: u8,
    pub mem_refclk_10khz: u32,
    pub clk_reserved: [u32; 4usize],
    pub golden_reserved: u32,
    pub umc_config1: u32,
    pub reserved: [u32; 2usize],
    pub channel_num: u8,
    pub channel_width: u8,
    pub channel_reserve: [u8; 2usize],
    pub umc_info_reserved: [u8; 16usize],
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of atom_umc_info_v4_0"][::core::mem::size_of::<atom_umc_info_v4_0>() - 84usize];
    ["Alignment of atom_umc_info_v4_0"][::core::mem::align_of::<atom_umc_info_v4_0>() - 1usize];
    ["Offset of field: atom_umc_info_v4_0::table_header"]
        [::core::mem::offset_of!(atom_umc_info_v4_0, table_header) - 0usize];
    ["Offset of field: atom_umc_info_v4_0::ucode_reserved"]
        [::core::mem::offset_of!(atom_umc_info_v4_0, ucode_reserved) - 4usize];
    ["Offset of field: atom_umc_info_v4_0::umcip_min_ver"]
        [::core::mem::offset_of!(atom_umc_info_v4_0, umcip_min_ver) - 24usize];
    ["Offset of field: atom_umc_info_v4_0::umcip_max_ver"]
        [::core::mem::offset_of!(atom_umc_info_v4_0, umcip_max_ver) - 25usize];
    ["Offset of field: atom_umc_info_v4_0::vram_type"]
        [::core::mem::offset_of!(atom_umc_info_v4_0, vram_type) - 26usize];
    ["Offset of field: atom_umc_info_v4_0::umc_config"]
        [::core::mem::offset_of!(atom_umc_info_v4_0, umc_config) - 27usize];
    ["Offset of field: atom_umc_info_v4_0::mem_refclk_10khz"]
        [::core::mem::offset_of!(atom_umc_info_v4_0, mem_refclk_10khz) - 28usize];
    ["Offset of field: atom_umc_info_v4_0::clk_reserved"]
        [::core::mem::offset_of!(atom_umc_info_v4_0, clk_reserved) - 32usize];
    ["Offset of field: atom_umc_info_v4_0::golden_reserved"]
        [::core::mem::offset_of!(atom_umc_info_v4_0, golden_reserved) - 48usize];
    ["Offset of field: atom_umc_info_v4_0::umc_config1"]
        [::core::mem::offset_of!(atom_umc_info_v4_0, umc_config1) - 52usize];
    ["Offset of field: atom_umc_info_v4_0::reserved"]
        [::core::mem::offset_of!(atom_umc_info_v4_0, reserved) - 56usize];
    ["Offset of field: atom_umc_info_v4_0::channel_num"]
        [::core::mem::offset_of!(atom_umc_info_v4_0, channel_num) - 64usize];
    ["Offset of field: atom_umc_info_v4_0::channel_width"]
        [::core::mem::offset_of!(atom_umc_info_v4_0, channel_width) - 65usize];
    ["Offset of field: atom_umc_info_v4_0::channel_reserve"]
        [::core::mem::offset_of!(atom_umc_info_v4_0, channel_reserve) - 66usize];
    ["Offset of field: atom_umc_info_v4_0::umc_info_reserved"]
        [::core::mem::offset_of!(atom_umc_info_v4_0, umc_info_reserved) - 68usize];
};
#[repr(C, packed)]
#[derive(Debug, Copy, Clone)]
pub struct atom_vram_module_v9 {
    pub memory_size: u32,
    pub channel_enable: u32,
    pub max_mem_clk: u32,
    pub reserved: [u16; 3usize],
    pub mem_voltage: u16,
    pub vram_module_size: u16,
    pub ext_memory_id: u8,
    pub memory_type: u8,
    pub channel_num: u8,
    pub channel_width: u8,
    pub density: u8,
    pub tunningset_id: u8,
    pub vender_rev_id: u8,
    pub refreshrate: u8,
    pub hbm_ven_rev_id: u8,
    pub vram_rsd2: u8,
    pub dram_pnstring: [::core::ffi::c_char; 20usize],
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of atom_vram_module_v9"][::core::mem::size_of::<atom_vram_module_v9>() - 52usize];
    ["Alignment of atom_vram_module_v9"][::core::mem::align_of::<atom_vram_module_v9>() - 1usize];
    ["Offset of field: atom_vram_module_v9::memory_size"]
        [::core::mem::offset_of!(atom_vram_module_v9, memory_size) - 0usize];
    ["Offset of field: atom_vram_module_v9::channel_enable"]
        [::core::mem::offset_of!(atom_vram_module_v9, channel_enable) - 4usize];
    ["Offset of field: atom_vram_module_v9::max_mem_clk"]
        [::core::mem::offset_of!(atom_vram_module_v9, max_mem_clk) - 8usize];
    ["Offset of field: atom_vram_module_v9::reserved"]
        [::core::mem::offset_of!(atom_vram_module_v9, reserved) - 12usize];
    ["Offset of field: atom_vram_module_v9::mem_voltage"]
        [::core::mem::offset_of!(atom_vram_module_v9, mem_voltage) - 18usize];
    ["Offset of field: atom_vram_module_v9::vram_module_size"]
        [::core::mem::offset_of!(atom_vram_module_v9, vram_module_size) - 20usize];
    ["Offset of field: atom_vram_module_v9::ext_memory_id"]
        [::core::mem::offset_of!(atom_vram_module_v9, ext_memory_id) - 22usize];
    ["Offset of field: atom_vram_module_v9::memory_type"]
        [::core::mem::offset_of!(atom_vram_module_v9, memory_type) - 23usize];
    ["Offset of field: atom_vram_module_v9::channel_num"]
        [::core::mem::offset_of!(atom_vram_module_v9, channel_num) - 24usize];
    ["Offset of field: atom_vram_module_v9::channel_width"]
        [::core::mem::offset_of!(atom_vram_module_v9, channel_width) - 25usize];
    ["Offset of field: atom_vram_module_v9::density"]
        [::core::mem::offset_of!(atom_vram_module_v9, density) - 26usize];
    ["Offset of field: atom_vram_module_v9::tunningset_id"]
        [::core::mem::offset_of!(atom_vram_module_v9, tunningset_id) - 27usize];
    ["Offset of field: atom_vram_module_v9::vender_rev_id"]
        [::core::mem::offset_of!(atom_vram_module_v9, vender_rev_id) - 28usize];
    ["Offset of field: atom_vram_module_v9::refreshrate"]
        [::core::mem::offset_of!(atom_vram_module_v9, refreshrate) - 29usize];
    ["Offset of field: atom_vram_module_v9::hbm_ven_rev_id"]
        [::core::mem::offset_of!(atom_vram_module_v9, hbm_ven_rev_id) - 30usize];
    ["Offset of field: atom_vram_module_v9::vram_rsd2"]
        [::core::mem::offset_of!(atom_vram_module_v9, vram_rsd2) - 31usize];
    ["Offset of field: atom_vram_module_v9::dram_pnstring"]
        [::core::mem::offset_of!(atom_vram_module_v9, dram_pnstring) - 32usize];
};
#[repr(C, packed)]
#[derive(Debug, Copy, Clone)]
pub struct atom_vram_info_header_v2_3 {
    pub table_header: atom_common_table_header,
    pub mem_adjust_tbloffset: u16,
    pub mem_clk_patch_tbloffset: u16,
    pub mc_adjust_pertile_tbloffset: u16,
    pub mc_phyinit_tbloffset: u16,
    pub dram_data_remap_tbloffset: u16,
    pub tmrs_seq_offset: u16,
    pub post_ucode_init_offset: u16,
    pub vram_rsd2: u16,
    pub vram_module_num: u8,
    pub umcip_min_ver: u8,
    pub umcip_max_ver: u8,
    pub mc_phy_tile_num: u8,
    pub vram_module: [atom_vram_module_v9; 16usize],
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of atom_vram_info_header_v2_3"]
        [::core::mem::size_of::<atom_vram_info_header_v2_3>() - 856usize];
    ["Alignment of atom_vram_info_header_v2_3"]
        [::core::mem::align_of::<atom_vram_info_header_v2_3>() - 1usize];
    ["Offset of field: atom_vram_info_header_v2_3::table_header"]
        [::core::mem::offset_of!(atom_vram_info_header_v2_3, table_header) - 0usize];
    ["Offset of field: atom_vram_info_header_v2_3::mem_adjust_tbloffset"]
        [::core::mem::offset_of!(atom_vram_info_header_v2_3, mem_adjust_tbloffset) - 4usize];
    ["Offset of field: atom_vram_info_header_v2_3::mem_clk_patch_tbloffset"]
        [::core::mem::offset_of!(atom_vram_info_header_v2_3, mem_clk_patch_tbloffset) - 6usize];
    ["Offset of field: atom_vram_info_header_v2_3::mc_adjust_pertile_tbloffset"]
        [::core::mem::offset_of!(atom_vram_info_header_v2_3, mc_adjust_pertile_tbloffset) - 8usize];
    ["Offset of field: atom_vram_info_header_v2_3::mc_phyinit_tbloffset"]
        [::core::mem::offset_of!(atom_vram_info_header_v2_3, mc_phyinit_tbloffset) - 10usize];
    ["Offset of field: atom_vram_info_header_v2_3::dram_data_remap_tbloffset"]
        [::core::mem::offset_of!(atom_vram_info_header_v2_3, dram_data_remap_tbloffset) - 12usize];
    ["Offset of field: atom_vram_info_header_v2_3::tmrs_seq_offset"]
        [::core::mem::offset_of!(atom_vram_info_header_v2_3, tmrs_seq_offset) - 14usize];
    ["Offset of field: atom_vram_info_header_v2_3::post_ucode_init_offset"]
        [::core::mem::offset_of!(atom_vram_info_header_v2_3, post_ucode_init_offset) - 16usize];
    ["Offset of field: atom_vram_info_header_v2_3::vram_rsd2"]
        [::core::mem::offset_of!(atom_vram_info_header_v2_3, vram_rsd2) - 18usize];
    ["Offset of field: atom_vram_info_header_v2_3::vram_module_num"]
        [::core::mem::offset_of!(atom_vram_info_header_v2_3, vram_module_num) - 20usize];
    ["Offset of field: atom_vram_info_header_v2_3::umcip_min_ver"]
        [::core::mem::offset_of!(atom_vram_info_header_v2_3, umcip_min_ver) - 21usize];
    ["Offset of field: atom_vram_info_header_v2_3::umcip_max_ver"]
        [::core::mem::offset_of!(atom_vram_info_header_v2_3, umcip_max_ver) - 22usize];
    ["Offset of field: atom_vram_info_header_v2_3::mc_phy_tile_num"]
        [::core::mem::offset_of!(atom_vram_info_header_v2_3, mc_phy_tile_num) - 23usize];
    ["Offset of field: atom_vram_info_header_v2_3::vram_module"]
        [::core::mem::offset_of!(atom_vram_info_header_v2_3, vram_module) - 24usize];
};
#[repr(C, packed)]
#[derive(Debug, Copy, Clone)]
pub struct atom_vram_module_v3_0 {
    pub density: u8,
    pub tunningset_id: u8,
    pub ext_memory_id: u8,
    pub dram_vendor_id: u8,
    pub dram_info_offset: u16,
    pub mem_tuning_offset: u16,
    pub tmrs_seq_offset: u16,
    pub reserved1: u16,
    pub dram_size_per_ch: u32,
    pub reserved: [u32; 3usize],
    pub dram_pnstring: [::core::ffi::c_char; 40usize],
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of atom_vram_module_v3_0"][::core::mem::size_of::<atom_vram_module_v3_0>() - 68usize];
    ["Alignment of atom_vram_module_v3_0"]
        [::core::mem::align_of::<atom_vram_module_v3_0>() - 1usize];
    ["Offset of field: atom_vram_module_v3_0::density"]
        [::core::mem::offset_of!(atom_vram_module_v3_0, density) - 0usize];
    ["Offset of field: atom_vram_module_v3_0::tunningset_id"]
        [::core::mem::offset_of!(atom_vram_module_v3_0, tunningset_id) - 1usize];
    ["Offset of field: atom_vram_module_v3_0::ext_memory_id"]
        [::core::mem::offset_of!(atom_vram_module_v3_0, ext_memory_id) - 2usize];
    ["Offset of field: atom_vram_module_v3_0::dram_vendor_id"]
        [::core::mem::offset_of!(atom_vram_module_v3_0, dram_vendor_id) - 3usize];
    ["Offset of field: atom_vram_module_v3_0::dram_info_offset"]
        [::core::mem::offset_of!(atom_vram_module_v3_0, dram_info_offset) - 4usize];
    ["Offset of field: atom_vram_module_v3_0::mem_tuning_offset"]
        [::core::mem::offset_of!(atom_vram_module_v3_0, mem_tuning_offset) - 6usize];
    ["Offset of field: atom_vram_module_v3_0::tmrs_seq_offset"]
        [::core::mem::offset_of!(atom_vram_module_v3_0, tmrs_seq_offset) - 8usize];
    ["Offset of field: atom_vram_module_v3_0::reserved1"]
        [::core::mem::offset_of!(atom_vram_module_v3_0, reserved1) - 10usize];
    ["Offset of field: atom_vram_module_v3_0::dram_size_per_ch"]
        [::core::mem::offset_of!(atom_vram_module_v3_0, dram_size_per_ch) - 12usize];
    ["Offset of field: atom_vram_module_v3_0::reserved"]
        [::core::mem::offset_of!(atom_vram_module_v3_0, reserved) - 16usize];
    ["Offset of field: atom_vram_module_v3_0::dram_pnstring"]
        [::core::mem::offset_of!(atom_vram_module_v3_0, dram_pnstring) - 28usize];
};
#[repr(C, packed)]
#[derive(Debug, Copy, Clone)]
pub struct atom_vram_info_header_v3_0 {
    pub table_header: atom_common_table_header,
    pub mem_tuning_table_offset: u16,
    pub dram_info_table_offset: u16,
    pub tmrs_table_offset: u16,
    pub mc_init_table_offset: u16,
    pub dram_data_remap_table_offset: u16,
    pub umc_emuinittable_offset: u16,
    pub reserved_sub_table_offset: [u16; 2usize],
    pub vram_module_num: u8,
    pub umcip_min_ver: u8,
    pub umcip_max_ver: u8,
    pub mc_phy_tile_num: u8,
    pub memory_type: u8,
    pub channel_num: u8,
    pub channel_width: u8,
    pub reserved1: u8,
    pub channel_enable: u32,
    pub channel1_enable: u32,
    pub feature_enable: u32,
    pub feature1_enable: u32,
    pub hardcode_mem_size: u32,
    pub reserved4: [u32; 4usize],
    pub vram_module: [atom_vram_module_v3_0; 8usize],
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of atom_vram_info_header_v3_0"]
        [::core::mem::size_of::<atom_vram_info_header_v3_0>() - 608usize];
    ["Alignment of atom_vram_info_header_v3_0"]
        [::core::mem::align_of::<atom_vram_info_header_v3_0>() - 1usize];
    ["Offset of field: atom_vram_info_header_v3_0::table_header"]
        [::core::mem::offset_of!(atom_vram_info_header_v3_0, table_header) - 0usize];
    ["Offset of field: atom_vram_info_header_v3_0::mem_tuning_table_offset"]
        [::core::mem::offset_of!(atom_vram_info_header_v3_0, mem_tuning_table_offset) - 4usize];
    ["Offset of field: atom_vram_info_header_v3_0::dram_info_table_offset"]
        [::core::mem::offset_of!(atom_vram_info_header_v3_0, dram_info_table_offset) - 6usize];
    ["Offset of field: atom_vram_info_header_v3_0::tmrs_table_offset"]
        [::core::mem::offset_of!(atom_vram_info_header_v3_0, tmrs_table_offset) - 8usize];
    ["Offset of field: atom_vram_info_header_v3_0::mc_init_table_offset"]
        [::core::mem::offset_of!(atom_vram_info_header_v3_0, mc_init_table_offset) - 10usize];
    ["Offset of field: atom_vram_info_header_v3_0::dram_data_remap_table_offset"][::core::mem::offset_of!(
        atom_vram_info_header_v3_0,
        dram_data_remap_table_offset
    ) - 12usize];
    ["Offset of field: atom_vram_info_header_v3_0::umc_emuinittable_offset"]
        [::core::mem::offset_of!(atom_vram_info_header_v3_0, umc_emuinittable_offset) - 14usize];
    ["Offset of field: atom_vram_info_header_v3_0::reserved_sub_table_offset"]
        [::core::mem::offset_of!(atom_vram_info_header_v3_0, reserved_sub_table_offset) - 16usize];
    ["Offset of field: atom_vram_info_header_v3_0::vram_module_num"]
        [::core::mem::offset_of!(atom_vram_info_header_v3_0, vram_module_num) - 20usize];
    ["Offset of field: atom_vram_info_header_v3_0::umcip_min_ver"]
        [::core::mem::offset_of!(atom_vram_info_header_v3_0, umcip_min_ver) - 21usize];
    ["Offset of field: atom_vram_info_header_v3_0::umcip_max_ver"]
        [::core::mem::offset_of!(atom_vram_info_header_v3_0, umcip_max_ver) - 22usize];
    ["Offset of field: atom_vram_info_header_v3_0::mc_phy_tile_num"]
        [::core::mem::offset_of!(atom_vram_info_header_v3_0, mc_phy_tile_num) - 23usize];
    ["Offset of field: atom_vram_info_header_v3_0::memory_type"]
        [::core::mem::offset_of!(atom_vram_info_header_v3_0, memory_type) - 24usize];
    ["Offset of field: atom_vram_info_header_v3_0::channel_num"]
        [::core::mem::offset_of!(atom_vram_info_header_v3_0, channel_num) - 25usize];
    ["Offset of field: atom_vram_info_header_v3_0::channel_width"]
        [::core::mem::offset_of!(atom_vram_info_header_v3_0, channel_width) - 26usize];
    ["Offset of field: atom_vram_info_header_v3_0::reserved1"]
        [::core::mem::offset_of!(atom_vram_info_header_v3_0, reserved1) - 27usize];
    ["Offset of field: atom_vram_info_header_v3_0::channel_enable"]
        [::core::mem::offset_of!(atom_vram_info_header_v3_0, channel_enable) - 28usize];
    ["Offset of field: atom_vram_info_header_v3_0::channel1_enable"]
        [::core::mem::offset_of!(atom_vram_info_header_v3_0, channel1_enable) - 32usize];
    ["Offset of field: atom_vram_info_header_v3_0::feature_enable"]
        [::core::mem::offset_of!(atom_vram_info_header_v3_0, feature_enable) - 36usize];
    ["Offset of field: atom_vram_info_header_v3_0::feature1_enable"]
        [::core::mem::offset_of!(atom_vram_info_header_v3_0, feature1_enable) - 40usize];
    ["Offset of field: atom_vram_info_header_v3_0::hardcode_mem_size"]
        [::core::mem::offset_of!(atom_vram_info_header_v3_0, hardcode_mem_size) - 44usize];
    ["Offset of field: atom_vram_info_header_v3_0::reserved4"]
        [::core::mem::offset_of!(atom_vram_info_header_v3_0, reserved4) - 48usize];
    ["Offset of field: atom_vram_info_header_v3_0::vram_module"]
        [::core::mem::offset_of!(atom_vram_info_header_v3_0, vram_module) - 64usize];
};
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct atom_umc_register_addr_info {
    pub _bitfield_align_1: [u8; 0],
    pub _bitfield_1: __BindgenBitfieldUnit<[u8; 4usize]>,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of atom_umc_register_addr_info"]
        [::core::mem::size_of::<atom_umc_register_addr_info>() - 4usize];
    ["Alignment of atom_umc_register_addr_info"]
        [::core::mem::align_of::<atom_umc_register_addr_info>() - 1usize];
};
impl atom_umc_register_addr_info {
    #[inline]
    pub fn umc_register_addr(&self) -> u32 {
        unsafe { ::core::mem::transmute(self._bitfield_1.get(0usize, 24u8) as u32) }
    }
    #[inline]
    pub fn set_umc_register_addr(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::core::mem::transmute(val);
            self._bitfield_1.set(0usize, 24u8, val as u64)
        }
    }
    #[inline]
    pub unsafe fn umc_register_addr_raw(this: *const Self) -> u32 {
        unsafe {
            ::core::mem::transmute(<__BindgenBitfieldUnit<[u8; 4usize]>>::raw_get(
                ::core::ptr::addr_of!((*this)._bitfield_1),
                0usize,
                24u8,
            ) as u32)
        }
    }
    #[inline]
    pub unsafe fn set_umc_register_addr_raw(this: *mut Self, val: u32) {
        unsafe {
            let val: u32 = ::core::mem::transmute(val);
            <__BindgenBitfieldUnit<[u8; 4usize]>>::raw_set(
                ::core::ptr::addr_of_mut!((*this)._bitfield_1),
                0usize,
                24u8,
                val as u64,
            )
        }
    }
    #[inline]
    pub fn umc_reg_type_ind(&self) -> u32 {
        unsafe { ::core::mem::transmute(self._bitfield_1.get(24usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_umc_reg_type_ind(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::core::mem::transmute(val);
            self._bitfield_1.set(24usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub unsafe fn umc_reg_type_ind_raw(this: *const Self) -> u32 {
        unsafe {
            ::core::mem::transmute(<__BindgenBitfieldUnit<[u8; 4usize]>>::raw_get(
                ::core::ptr::addr_of!((*this)._bitfield_1),
                24usize,
                1u8,
            ) as u32)
        }
    }
    #[inline]
    pub unsafe fn set_umc_reg_type_ind_raw(this: *mut Self, val: u32) {
        unsafe {
            let val: u32 = ::core::mem::transmute(val);
            <__BindgenBitfieldUnit<[u8; 4usize]>>::raw_set(
                ::core::ptr::addr_of_mut!((*this)._bitfield_1),
                24usize,
                1u8,
                val as u64,
            )
        }
    }
    #[inline]
    pub fn umc_reg_rsvd(&self) -> u32 {
        unsafe { ::core::mem::transmute(self._bitfield_1.get(25usize, 7u8) as u32) }
    }
    #[inline]
    pub fn set_umc_reg_rsvd(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::core::mem::transmute(val);
            self._bitfield_1.set(25usize, 7u8, val as u64)
        }
    }
    #[inline]
    pub unsafe fn umc_reg_rsvd_raw(this: *const Self) -> u32 {
        unsafe {
            ::core::mem::transmute(<__BindgenBitfieldUnit<[u8; 4usize]>>::raw_get(
                ::core::ptr::addr_of!((*this)._bitfield_1),
                25usize,
                7u8,
            ) as u32)
        }
    }
    #[inline]
    pub unsafe fn set_umc_reg_rsvd_raw(this: *mut Self, val: u32) {
        unsafe {
            let val: u32 = ::core::mem::transmute(val);
            <__BindgenBitfieldUnit<[u8; 4usize]>>::raw_set(
                ::core::ptr::addr_of_mut!((*this)._bitfield_1),
                25usize,
                7u8,
                val as u64,
            )
        }
    }
    #[inline]
    pub fn new_bitfield_1(
        umc_register_addr: u32,
        umc_reg_type_ind: u32,
        umc_reg_rsvd: u32,
    ) -> __BindgenBitfieldUnit<[u8; 4usize]> {
        let mut __bindgen_bitfield_unit: __BindgenBitfieldUnit<[u8; 4usize]> = Default::default();
        __bindgen_bitfield_unit.set(0usize, 24u8, {
            let umc_register_addr: u32 = unsafe { ::core::mem::transmute(umc_register_addr) };
            umc_register_addr as u64
        });
        __bindgen_bitfield_unit.set(24usize, 1u8, {
            let umc_reg_type_ind: u32 = unsafe { ::core::mem::transmute(umc_reg_type_ind) };
            umc_reg_type_ind as u64
        });
        __bindgen_bitfield_unit.set(25usize, 7u8, {
            let umc_reg_rsvd: u32 = unsafe { ::core::mem::transmute(umc_reg_rsvd) };
            umc_reg_rsvd as u64
        });
        __bindgen_bitfield_unit
    }
}
pub const atom_umc_register_addr_info_flag_b3ATOM_UMC_REG_ADD_INFO_INDIRECT_ACCESS:
    atom_umc_register_addr_info_flag = 1;
pub type atom_umc_register_addr_info_flag = ::core::ffi::c_uint;
#[repr(C, packed)]
#[derive(Copy, Clone)]
pub union atom_umc_register_addr_info_access {
    pub umc_reg_addr: atom_umc_register_addr_info,
    pub u32umc_reg_addr: u32,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of atom_umc_register_addr_info_access"]
        [::core::mem::size_of::<atom_umc_register_addr_info_access>() - 4usize];
    ["Alignment of atom_umc_register_addr_info_access"]
        [::core::mem::align_of::<atom_umc_register_addr_info_access>() - 1usize];
    ["Offset of field: atom_umc_register_addr_info_access::umc_reg_addr"]
        [::core::mem::offset_of!(atom_umc_register_addr_info_access, umc_reg_addr) - 0usize];
    ["Offset of field: atom_umc_register_addr_info_access::u32umc_reg_addr"]
        [::core::mem::offset_of!(atom_umc_register_addr_info_access, u32umc_reg_addr) - 0usize];
};
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct atom_umc_reg_setting_id_config {
    pub _bitfield_align_1: [u8; 0],
    pub _bitfield_1: __BindgenBitfieldUnit<[u8; 4usize]>,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of atom_umc_reg_setting_id_config"]
        [::core::mem::size_of::<atom_umc_reg_setting_id_config>() - 4usize];
    ["Alignment of atom_umc_reg_setting_id_config"]
        [::core::mem::align_of::<atom_umc_reg_setting_id_config>() - 1usize];
};
impl atom_umc_reg_setting_id_config {
    #[inline]
    pub fn memclockrange(&self) -> u32 {
        unsafe { ::core::mem::transmute(self._bitfield_1.get(0usize, 24u8) as u32) }
    }
    #[inline]
    pub fn set_memclockrange(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::core::mem::transmute(val);
            self._bitfield_1.set(0usize, 24u8, val as u64)
        }
    }
    #[inline]
    pub unsafe fn memclockrange_raw(this: *const Self) -> u32 {
        unsafe {
            ::core::mem::transmute(<__BindgenBitfieldUnit<[u8; 4usize]>>::raw_get(
                ::core::ptr::addr_of!((*this)._bitfield_1),
                0usize,
                24u8,
            ) as u32)
        }
    }
    #[inline]
    pub unsafe fn set_memclockrange_raw(this: *mut Self, val: u32) {
        unsafe {
            let val: u32 = ::core::mem::transmute(val);
            <__BindgenBitfieldUnit<[u8; 4usize]>>::raw_set(
                ::core::ptr::addr_of_mut!((*this)._bitfield_1),
                0usize,
                24u8,
                val as u64,
            )
        }
    }
    #[inline]
    pub fn mem_blk_id(&self) -> u32 {
        unsafe { ::core::mem::transmute(self._bitfield_1.get(24usize, 8u8) as u32) }
    }
    #[inline]
    pub fn set_mem_blk_id(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::core::mem::transmute(val);
            self._bitfield_1.set(24usize, 8u8, val as u64)
        }
    }
    #[inline]
    pub unsafe fn mem_blk_id_raw(this: *const Self) -> u32 {
        unsafe {
            ::core::mem::transmute(<__BindgenBitfieldUnit<[u8; 4usize]>>::raw_get(
                ::core::ptr::addr_of!((*this)._bitfield_1),
                24usize,
                8u8,
            ) as u32)
        }
    }
    #[inline]
    pub unsafe fn set_mem_blk_id_raw(this: *mut Self, val: u32) {
        unsafe {
            let val: u32 = ::core::mem::transmute(val);
            <__BindgenBitfieldUnit<[u8; 4usize]>>::raw_set(
                ::core::ptr::addr_of_mut!((*this)._bitfield_1),
                24usize,
                8u8,
                val as u64,
            )
        }
    }
    #[inline]
    pub fn new_bitfield_1(
        memclockrange: u32,
        mem_blk_id: u32,
    ) -> __BindgenBitfieldUnit<[u8; 4usize]> {
        let mut __bindgen_bitfield_unit: __BindgenBitfieldUnit<[u8; 4usize]> = Default::default();
        __bindgen_bitfield_unit.set(0usize, 24u8, {
            let memclockrange: u32 = unsafe { ::core::mem::transmute(memclockrange) };
            memclockrange as u64
        });
        __bindgen_bitfield_unit.set(24usize, 8u8, {
            let mem_blk_id: u32 = unsafe { ::core::mem::transmute(mem_blk_id) };
            mem_blk_id as u64
        });
        __bindgen_bitfield_unit
    }
}
#[repr(C, packed)]
#[derive(Copy, Clone)]
pub union atom_umc_reg_setting_id_config_access {
    pub umc_id_access: atom_umc_reg_setting_id_config,
    pub u32umc_id_access: u32,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of atom_umc_reg_setting_id_config_access"]
        [::core::mem::size_of::<atom_umc_reg_setting_id_config_access>() - 4usize];
    ["Alignment of atom_umc_reg_setting_id_config_access"]
        [::core::mem::align_of::<atom_umc_reg_setting_id_config_access>() - 1usize];
    ["Offset of field: atom_umc_reg_setting_id_config_access::umc_id_access"]
        [::core::mem::offset_of!(atom_umc_reg_setting_id_config_access, umc_id_access) - 0usize];
    ["Offset of field: atom_umc_reg_setting_id_config_access::u32umc_id_access"]
        [::core::mem::offset_of!(atom_umc_reg_setting_id_config_access, u32umc_id_access) - 0usize];
};
#[repr(C, packed)]
#[derive(Copy, Clone)]
pub struct atom_umc_reg_setting_data_block {
    pub block_id: atom_umc_reg_setting_id_config_access,
    pub u32umc_reg_data: [u32; 1usize],
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of atom_umc_reg_setting_data_block"]
        [::core::mem::size_of::<atom_umc_reg_setting_data_block>() - 8usize];
    ["Alignment of atom_umc_reg_setting_data_block"]
        [::core::mem::align_of::<atom_umc_reg_setting_data_block>() - 1usize];
    ["Offset of field: atom_umc_reg_setting_data_block::block_id"]
        [::core::mem::offset_of!(atom_umc_reg_setting_data_block, block_id) - 0usize];
    ["Offset of field: atom_umc_reg_setting_data_block::u32umc_reg_data"]
        [::core::mem::offset_of!(atom_umc_reg_setting_data_block, u32umc_reg_data) - 4usize];
};
#[repr(C, packed)]
#[derive(Copy, Clone)]
pub struct atom_umc_init_reg_block {
    pub umc_reg_num: u16,
    pub reserved: u16,
    pub umc_reg_list: [atom_umc_register_addr_info_access; 1usize],
    pub umc_reg_setting_list: [atom_umc_reg_setting_data_block; 1usize],
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of atom_umc_init_reg_block"]
        [::core::mem::size_of::<atom_umc_init_reg_block>() - 16usize];
    ["Alignment of atom_umc_init_reg_block"]
        [::core::mem::align_of::<atom_umc_init_reg_block>() - 1usize];
    ["Offset of field: atom_umc_init_reg_block::umc_reg_num"]
        [::core::mem::offset_of!(atom_umc_init_reg_block, umc_reg_num) - 0usize];
    ["Offset of field: atom_umc_init_reg_block::reserved"]
        [::core::mem::offset_of!(atom_umc_init_reg_block, reserved) - 2usize];
    ["Offset of field: atom_umc_init_reg_block::umc_reg_list"]
        [::core::mem::offset_of!(atom_umc_init_reg_block, umc_reg_list) - 4usize];
    ["Offset of field: atom_umc_init_reg_block::umc_reg_setting_list"]
        [::core::mem::offset_of!(atom_umc_init_reg_block, umc_reg_setting_list) - 8usize];
};
#[repr(C, packed)]
#[derive(Debug, Copy, Clone)]
pub struct atom_vram_module_v10 {
    pub memory_size: u32,
    pub channel_enable: u32,
    pub max_mem_clk: u32,
    pub reserved: [u16; 3usize],
    pub mem_voltage: u16,
    pub vram_module_size: u16,
    pub ext_memory_id: u8,
    pub memory_type: u8,
    pub channel_num: u8,
    pub channel_width: u8,
    pub density: u8,
    pub tunningset_id: u8,
    pub vender_rev_id: u8,
    pub refreshrate: u8,
    pub vram_flags: u8,
    pub vram_rsd2: u8,
    pub gddr6_mr10: u16,
    pub gddr6_mr1: u16,
    pub gddr6_mr2: u16,
    pub gddr6_mr7: u16,
    pub dram_pnstring: [::core::ffi::c_char; 20usize],
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of atom_vram_module_v10"][::core::mem::size_of::<atom_vram_module_v10>() - 60usize];
    ["Alignment of atom_vram_module_v10"][::core::mem::align_of::<atom_vram_module_v10>() - 1usize];
    ["Offset of field: atom_vram_module_v10::memory_size"]
        [::core::mem::offset_of!(atom_vram_module_v10, memory_size) - 0usize];
    ["Offset of field: atom_vram_module_v10::channel_enable"]
        [::core::mem::offset_of!(atom_vram_module_v10, channel_enable) - 4usize];
    ["Offset of field: atom_vram_module_v10::max_mem_clk"]
        [::core::mem::offset_of!(atom_vram_module_v10, max_mem_clk) - 8usize];
    ["Offset of field: atom_vram_module_v10::reserved"]
        [::core::mem::offset_of!(atom_vram_module_v10, reserved) - 12usize];
    ["Offset of field: atom_vram_module_v10::mem_voltage"]
        [::core::mem::offset_of!(atom_vram_module_v10, mem_voltage) - 18usize];
    ["Offset of field: atom_vram_module_v10::vram_module_size"]
        [::core::mem::offset_of!(atom_vram_module_v10, vram_module_size) - 20usize];
    ["Offset of field: atom_vram_module_v10::ext_memory_id"]
        [::core::mem::offset_of!(atom_vram_module_v10, ext_memory_id) - 22usize];
    ["Offset of field: atom_vram_module_v10::memory_type"]
        [::core::mem::offset_of!(atom_vram_module_v10, memory_type) - 23usize];
    ["Offset of field: atom_vram_module_v10::channel_num"]
        [::core::mem::offset_of!(atom_vram_module_v10, channel_num) - 24usize];
    ["Offset of field: atom_vram_module_v10::channel_width"]
        [::core::mem::offset_of!(atom_vram_module_v10, channel_width) - 25usize];
    ["Offset of field: atom_vram_module_v10::density"]
        [::core::mem::offset_of!(atom_vram_module_v10, density) - 26usize];
    ["Offset of field: atom_vram_module_v10::tunningset_id"]
        [::core::mem::offset_of!(atom_vram_module_v10, tunningset_id) - 27usize];
    ["Offset of field: atom_vram_module_v10::vender_rev_id"]
        [::core::mem::offset_of!(atom_vram_module_v10, vender_rev_id) - 28usize];
    ["Offset of field: atom_vram_module_v10::refreshrate"]
        [::core::mem::offset_of!(atom_vram_module_v10, refreshrate) - 29usize];
    ["Offset of field: atom_vram_module_v10::vram_flags"]
        [::core::mem::offset_of!(atom_vram_module_v10, vram_flags) - 30usize];
    ["Offset of field: atom_vram_module_v10::vram_rsd2"]
        [::core::mem::offset_of!(atom_vram_module_v10, vram_rsd2) - 31usize];
    ["Offset of field: atom_vram_module_v10::gddr6_mr10"]
        [::core::mem::offset_of!(atom_vram_module_v10, gddr6_mr10) - 32usize];
    ["Offset of field: atom_vram_module_v10::gddr6_mr1"]
        [::core::mem::offset_of!(atom_vram_module_v10, gddr6_mr1) - 34usize];
    ["Offset of field: atom_vram_module_v10::gddr6_mr2"]
        [::core::mem::offset_of!(atom_vram_module_v10, gddr6_mr2) - 36usize];
    ["Offset of field: atom_vram_module_v10::gddr6_mr7"]
        [::core::mem::offset_of!(atom_vram_module_v10, gddr6_mr7) - 38usize];
    ["Offset of field: atom_vram_module_v10::dram_pnstring"]
        [::core::mem::offset_of!(atom_vram_module_v10, dram_pnstring) - 40usize];
};
#[repr(C, packed)]
#[derive(Debug, Copy, Clone)]
pub struct atom_vram_info_header_v2_4 {
    pub table_header: atom_common_table_header,
    pub mem_adjust_tbloffset: u16,
    pub mem_clk_patch_tbloffset: u16,
    pub mc_adjust_pertile_tbloffset: u16,
    pub mc_phyinit_tbloffset: u16,
    pub dram_data_remap_tbloffset: u16,
    pub reserved: u16,
    pub post_ucode_init_offset: u16,
    pub vram_rsd2: u16,
    pub vram_module_num: u8,
    pub umcip_min_ver: u8,
    pub umcip_max_ver: u8,
    pub mc_phy_tile_num: u8,
    pub vram_module: [atom_vram_module_v10; 16usize],
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of atom_vram_info_header_v2_4"]
        [::core::mem::size_of::<atom_vram_info_header_v2_4>() - 984usize];
    ["Alignment of atom_vram_info_header_v2_4"]
        [::core::mem::align_of::<atom_vram_info_header_v2_4>() - 1usize];
    ["Offset of field: atom_vram_info_header_v2_4::table_header"]
        [::core::mem::offset_of!(atom_vram_info_header_v2_4, table_header) - 0usize];
    ["Offset of field: atom_vram_info_header_v2_4::mem_adjust_tbloffset"]
        [::core::mem::offset_of!(atom_vram_info_header_v2_4, mem_adjust_tbloffset) - 4usize];
    ["Offset of field: atom_vram_info_header_v2_4::mem_clk_patch_tbloffset"]
        [::core::mem::offset_of!(atom_vram_info_header_v2_4, mem_clk_patch_tbloffset) - 6usize];
    ["Offset of field: atom_vram_info_header_v2_4::mc_adjust_pertile_tbloffset"]
        [::core::mem::offset_of!(atom_vram_info_header_v2_4, mc_adjust_pertile_tbloffset) - 8usize];
    ["Offset of field: atom_vram_info_header_v2_4::mc_phyinit_tbloffset"]
        [::core::mem::offset_of!(atom_vram_info_header_v2_4, mc_phyinit_tbloffset) - 10usize];
    ["Offset of field: atom_vram_info_header_v2_4::dram_data_remap_tbloffset"]
        [::core::mem::offset_of!(atom_vram_info_header_v2_4, dram_data_remap_tbloffset) - 12usize];
    ["Offset of field: atom_vram_info_header_v2_4::reserved"]
        [::core::mem::offset_of!(atom_vram_info_header_v2_4, reserved) - 14usize];
    ["Offset of field: atom_vram_info_header_v2_4::post_ucode_init_offset"]
        [::core::mem::offset_of!(atom_vram_info_header_v2_4, post_ucode_init_offset) - 16usize];
    ["Offset of field: atom_vram_info_header_v2_4::vram_rsd2"]
        [::core::mem::offset_of!(atom_vram_info_header_v2_4, vram_rsd2) - 18usize];
    ["Offset of field: atom_vram_info_header_v2_4::vram_module_num"]
        [::core::mem::offset_of!(atom_vram_info_header_v2_4, vram_module_num) - 20usize];
    ["Offset of field: atom_vram_info_header_v2_4::umcip_min_ver"]
        [::core::mem::offset_of!(atom_vram_info_header_v2_4, umcip_min_ver) - 21usize];
    ["Offset of field: atom_vram_info_header_v2_4::umcip_max_ver"]
        [::core::mem::offset_of!(atom_vram_info_header_v2_4, umcip_max_ver) - 22usize];
    ["Offset of field: atom_vram_info_header_v2_4::mc_phy_tile_num"]
        [::core::mem::offset_of!(atom_vram_info_header_v2_4, mc_phy_tile_num) - 23usize];
    ["Offset of field: atom_vram_info_header_v2_4::vram_module"]
        [::core::mem::offset_of!(atom_vram_info_header_v2_4, vram_module) - 24usize];
};
#[repr(C, packed)]
#[derive(Debug, Copy, Clone)]
pub struct atom_vram_module_v11 {
    pub memory_size: u32,
    pub channel_enable: u32,
    pub mem_voltage: u16,
    pub vram_module_size: u16,
    pub ext_memory_id: u8,
    pub memory_type: u8,
    pub channel_num: u8,
    pub channel_width: u8,
    pub density: u8,
    pub tunningset_id: u8,
    pub reserved: [u16; 4usize],
    pub vender_rev_id: u8,
    pub refreshrate: u8,
    pub vram_flags: u8,
    pub vram_rsd2: u8,
    pub gddr6_mr10: u16,
    pub gddr6_mr0: u16,
    pub gddr6_mr1: u16,
    pub gddr6_mr2: u16,
    pub gddr6_mr4: u16,
    pub gddr6_mr7: u16,
    pub gddr6_mr8: u16,
    pub dram_pnstring: [::core::ffi::c_char; 40usize],
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of atom_vram_module_v11"][::core::mem::size_of::<atom_vram_module_v11>() - 84usize];
    ["Alignment of atom_vram_module_v11"][::core::mem::align_of::<atom_vram_module_v11>() - 1usize];
    ["Offset of field: atom_vram_module_v11::memory_size"]
        [::core::mem::offset_of!(atom_vram_module_v11, memory_size) - 0usize];
    ["Offset of field: atom_vram_module_v11::channel_enable"]
        [::core::mem::offset_of!(atom_vram_module_v11, channel_enable) - 4usize];
    ["Offset of field: atom_vram_module_v11::mem_voltage"]
        [::core::mem::offset_of!(atom_vram_module_v11, mem_voltage) - 8usize];
    ["Offset of field: atom_vram_module_v11::vram_module_size"]
        [::core::mem::offset_of!(atom_vram_module_v11, vram_module_size) - 10usize];
    ["Offset of field: atom_vram_module_v11::ext_memory_id"]
        [::core::mem::offset_of!(atom_vram_module_v11, ext_memory_id) - 12usize];
    ["Offset of field: atom_vram_module_v11::memory_type"]
        [::core::mem::offset_of!(atom_vram_module_v11, memory_type) - 13usize];
    ["Offset of field: atom_vram_module_v11::channel_num"]
        [::core::mem::offset_of!(atom_vram_module_v11, channel_num) - 14usize];
    ["Offset of field: atom_vram_module_v11::channel_width"]
        [::core::mem::offset_of!(atom_vram_module_v11, channel_width) - 15usize];
    ["Offset of field: atom_vram_module_v11::density"]
        [::core::mem::offset_of!(atom_vram_module_v11, density) - 16usize];
    ["Offset of field: atom_vram_module_v11::tunningset_id"]
        [::core::mem::offset_of!(atom_vram_module_v11, tunningset_id) - 17usize];
    ["Offset of field: atom_vram_module_v11::reserved"]
        [::core::mem::offset_of!(atom_vram_module_v11, reserved) - 18usize];
    ["Offset of field: atom_vram_module_v11::vender_rev_id"]
        [::core::mem::offset_of!(atom_vram_module_v11, vender_rev_id) - 26usize];
    ["Offset of field: atom_vram_module_v11::refreshrate"]
        [::core::mem::offset_of!(atom_vram_module_v11, refreshrate) - 27usize];
    ["Offset of field: atom_vram_module_v11::vram_flags"]
        [::core::mem::offset_of!(atom_vram_module_v11, vram_flags) - 28usize];
    ["Offset of field: atom_vram_module_v11::vram_rsd2"]
        [::core::mem::offset_of!(atom_vram_module_v11, vram_rsd2) - 29usize];
    ["Offset of field: atom_vram_module_v11::gddr6_mr10"]
        [::core::mem::offset_of!(atom_vram_module_v11, gddr6_mr10) - 30usize];
    ["Offset of field: atom_vram_module_v11::gddr6_mr0"]
        [::core::mem::offset_of!(atom_vram_module_v11, gddr6_mr0) - 32usize];
    ["Offset of field: atom_vram_module_v11::gddr6_mr1"]
        [::core::mem::offset_of!(atom_vram_module_v11, gddr6_mr1) - 34usize];
    ["Offset of field: atom_vram_module_v11::gddr6_mr2"]
        [::core::mem::offset_of!(atom_vram_module_v11, gddr6_mr2) - 36usize];
    ["Offset of field: atom_vram_module_v11::gddr6_mr4"]
        [::core::mem::offset_of!(atom_vram_module_v11, gddr6_mr4) - 38usize];
    ["Offset of field: atom_vram_module_v11::gddr6_mr7"]
        [::core::mem::offset_of!(atom_vram_module_v11, gddr6_mr7) - 40usize];
    ["Offset of field: atom_vram_module_v11::gddr6_mr8"]
        [::core::mem::offset_of!(atom_vram_module_v11, gddr6_mr8) - 42usize];
    ["Offset of field: atom_vram_module_v11::dram_pnstring"]
        [::core::mem::offset_of!(atom_vram_module_v11, dram_pnstring) - 44usize];
};
#[repr(C, packed)]
#[derive(Debug, Copy, Clone)]
pub struct atom_gddr6_ac_timing_v2_5 {
    pub u32umc_id_access: u32,
    pub RL: u8,
    pub WL: u8,
    pub tRAS: u8,
    pub tRC: u8,
    pub tREFI: u16,
    pub tRFC: u8,
    pub tRFCpb: u8,
    pub tRREFD: u8,
    pub tRCDRD: u8,
    pub tRCDWR: u8,
    pub tRP: u8,
    pub tRRDS: u8,
    pub tRRDL: u8,
    pub tWR: u8,
    pub tWTRS: u8,
    pub tWTRL: u8,
    pub tFAW: u8,
    pub tCCDS: u8,
    pub tCCDL: u8,
    pub tCRCRL: u8,
    pub tCRCWL: u8,
    pub tCKE: u8,
    pub tCKSRE: u8,
    pub tCKSRX: u8,
    pub tRTPS: u8,
    pub tRTPL: u8,
    pub tMRD: u8,
    pub tMOD: u8,
    pub tXS: u8,
    pub tXHP: u8,
    pub tXSMRS: u8,
    pub tXSH: u32,
    pub tPD: u8,
    pub tXP: u8,
    pub tCPDED: u8,
    pub tACTPDE: u8,
    pub tPREPDE: u8,
    pub tREFPDE: u8,
    pub tMRSPDEN: u8,
    pub tRDSRE: u8,
    pub tWRSRE: u8,
    pub tPPD: u8,
    pub tCCDMW: u8,
    pub tWTRTR: u8,
    pub tLTLTR: u8,
    pub tREFTR: u8,
    pub VNDR: u8,
    pub reserved: [u8; 9usize],
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of atom_gddr6_ac_timing_v2_5"]
        [::core::mem::size_of::<atom_gddr6_ac_timing_v2_5>() - 64usize];
    ["Alignment of atom_gddr6_ac_timing_v2_5"]
        [::core::mem::align_of::<atom_gddr6_ac_timing_v2_5>() - 1usize];
    ["Offset of field: atom_gddr6_ac_timing_v2_5::u32umc_id_access"]
        [::core::mem::offset_of!(atom_gddr6_ac_timing_v2_5, u32umc_id_access) - 0usize];
    ["Offset of field: atom_gddr6_ac_timing_v2_5::RL"]
        [::core::mem::offset_of!(atom_gddr6_ac_timing_v2_5, RL) - 4usize];
    ["Offset of field: atom_gddr6_ac_timing_v2_5::WL"]
        [::core::mem::offset_of!(atom_gddr6_ac_timing_v2_5, WL) - 5usize];
    ["Offset of field: atom_gddr6_ac_timing_v2_5::tRAS"]
        [::core::mem::offset_of!(atom_gddr6_ac_timing_v2_5, tRAS) - 6usize];
    ["Offset of field: atom_gddr6_ac_timing_v2_5::tRC"]
        [::core::mem::offset_of!(atom_gddr6_ac_timing_v2_5, tRC) - 7usize];
    ["Offset of field: atom_gddr6_ac_timing_v2_5::tREFI"]
        [::core::mem::offset_of!(atom_gddr6_ac_timing_v2_5, tREFI) - 8usize];
    ["Offset of field: atom_gddr6_ac_timing_v2_5::tRFC"]
        [::core::mem::offset_of!(atom_gddr6_ac_timing_v2_5, tRFC) - 10usize];
    ["Offset of field: atom_gddr6_ac_timing_v2_5::tRFCpb"]
        [::core::mem::offset_of!(atom_gddr6_ac_timing_v2_5, tRFCpb) - 11usize];
    ["Offset of field: atom_gddr6_ac_timing_v2_5::tRREFD"]
        [::core::mem::offset_of!(atom_gddr6_ac_timing_v2_5, tRREFD) - 12usize];
    ["Offset of field: atom_gddr6_ac_timing_v2_5::tRCDRD"]
        [::core::mem::offset_of!(atom_gddr6_ac_timing_v2_5, tRCDRD) - 13usize];
    ["Offset of field: atom_gddr6_ac_timing_v2_5::tRCDWR"]
        [::core::mem::offset_of!(atom_gddr6_ac_timing_v2_5, tRCDWR) - 14usize];
    ["Offset of field: atom_gddr6_ac_timing_v2_5::tRP"]
        [::core::mem::offset_of!(atom_gddr6_ac_timing_v2_5, tRP) - 15usize];
    ["Offset of field: atom_gddr6_ac_timing_v2_5::tRRDS"]
        [::core::mem::offset_of!(atom_gddr6_ac_timing_v2_5, tRRDS) - 16usize];
    ["Offset of field: atom_gddr6_ac_timing_v2_5::tRRDL"]
        [::core::mem::offset_of!(atom_gddr6_ac_timing_v2_5, tRRDL) - 17usize];
    ["Offset of field: atom_gddr6_ac_timing_v2_5::tWR"]
        [::core::mem::offset_of!(atom_gddr6_ac_timing_v2_5, tWR) - 18usize];
    ["Offset of field: atom_gddr6_ac_timing_v2_5::tWTRS"]
        [::core::mem::offset_of!(atom_gddr6_ac_timing_v2_5, tWTRS) - 19usize];
    ["Offset of field: atom_gddr6_ac_timing_v2_5::tWTRL"]
        [::core::mem::offset_of!(atom_gddr6_ac_timing_v2_5, tWTRL) - 20usize];
    ["Offset of field: atom_gddr6_ac_timing_v2_5::tFAW"]
        [::core::mem::offset_of!(atom_gddr6_ac_timing_v2_5, tFAW) - 21usize];
    ["Offset of field: atom_gddr6_ac_timing_v2_5::tCCDS"]
        [::core::mem::offset_of!(atom_gddr6_ac_timing_v2_5, tCCDS) - 22usize];
    ["Offset of field: atom_gddr6_ac_timing_v2_5::tCCDL"]
        [::core::mem::offset_of!(atom_gddr6_ac_timing_v2_5, tCCDL) - 23usize];
    ["Offset of field: atom_gddr6_ac_timing_v2_5::tCRCRL"]
        [::core::mem::offset_of!(atom_gddr6_ac_timing_v2_5, tCRCRL) - 24usize];
    ["Offset of field: atom_gddr6_ac_timing_v2_5::tCRCWL"]
        [::core::mem::offset_of!(atom_gddr6_ac_timing_v2_5, tCRCWL) - 25usize];
    ["Offset of field: atom_gddr6_ac_timing_v2_5::tCKE"]
        [::core::mem::offset_of!(atom_gddr6_ac_timing_v2_5, tCKE) - 26usize];
    ["Offset of field: atom_gddr6_ac_timing_v2_5::tCKSRE"]
        [::core::mem::offset_of!(atom_gddr6_ac_timing_v2_5, tCKSRE) - 27usize];
    ["Offset of field: atom_gddr6_ac_timing_v2_5::tCKSRX"]
        [::core::mem::offset_of!(atom_gddr6_ac_timing_v2_5, tCKSRX) - 28usize];
    ["Offset of field: atom_gddr6_ac_timing_v2_5::tRTPS"]
        [::core::mem::offset_of!(atom_gddr6_ac_timing_v2_5, tRTPS) - 29usize];
    ["Offset of field: atom_gddr6_ac_timing_v2_5::tRTPL"]
        [::core::mem::offset_of!(atom_gddr6_ac_timing_v2_5, tRTPL) - 30usize];
    ["Offset of field: atom_gddr6_ac_timing_v2_5::tMRD"]
        [::core::mem::offset_of!(atom_gddr6_ac_timing_v2_5, tMRD) - 31usize];
    ["Offset of field: atom_gddr6_ac_timing_v2_5::tMOD"]
        [::core::mem::offset_of!(atom_gddr6_ac_timing_v2_5, tMOD) - 32usize];
    ["Offset of field: atom_gddr6_ac_timing_v2_5::tXS"]
        [::core::mem::offset_of!(atom_gddr6_ac_timing_v2_5, tXS) - 33usize];
    ["Offset of field: atom_gddr6_ac_timing_v2_5::tXHP"]
        [::core::mem::offset_of!(atom_gddr6_ac_timing_v2_5, tXHP) - 34usize];
    ["Offset of field: atom_gddr6_ac_timing_v2_5::tXSMRS"]
        [::core::mem::offset_of!(atom_gddr6_ac_timing_v2_5, tXSMRS) - 35usize];
    ["Offset of field: atom_gddr6_ac_timing_v2_5::tXSH"]
        [::core::mem::offset_of!(atom_gddr6_ac_timing_v2_5, tXSH) - 36usize];
    ["Offset of field: atom_gddr6_ac_timing_v2_5::tPD"]
        [::core::mem::offset_of!(atom_gddr6_ac_timing_v2_5, tPD) - 40usize];
    ["Offset of field: atom_gddr6_ac_timing_v2_5::tXP"]
        [::core::mem::offset_of!(atom_gddr6_ac_timing_v2_5, tXP) - 41usize];
    ["Offset of field: atom_gddr6_ac_timing_v2_5::tCPDED"]
        [::core::mem::offset_of!(atom_gddr6_ac_timing_v2_5, tCPDED) - 42usize];
    ["Offset of field: atom_gddr6_ac_timing_v2_5::tACTPDE"]
        [::core::mem::offset_of!(atom_gddr6_ac_timing_v2_5, tACTPDE) - 43usize];
    ["Offset of field: atom_gddr6_ac_timing_v2_5::tPREPDE"]
        [::core::mem::offset_of!(atom_gddr6_ac_timing_v2_5, tPREPDE) - 44usize];
    ["Offset of field: atom_gddr6_ac_timing_v2_5::tREFPDE"]
        [::core::mem::offset_of!(atom_gddr6_ac_timing_v2_5, tREFPDE) - 45usize];
    ["Offset of field: atom_gddr6_ac_timing_v2_5::tMRSPDEN"]
        [::core::mem::offset_of!(atom_gddr6_ac_timing_v2_5, tMRSPDEN) - 46usize];
    ["Offset of field: atom_gddr6_ac_timing_v2_5::tRDSRE"]
        [::core::mem::offset_of!(atom_gddr6_ac_timing_v2_5, tRDSRE) - 47usize];
    ["Offset of field: atom_gddr6_ac_timing_v2_5::tWRSRE"]
        [::core::mem::offset_of!(atom_gddr6_ac_timing_v2_5, tWRSRE) - 48usize];
    ["Offset of field: atom_gddr6_ac_timing_v2_5::tPPD"]
        [::core::mem::offset_of!(atom_gddr6_ac_timing_v2_5, tPPD) - 49usize];
    ["Offset of field: atom_gddr6_ac_timing_v2_5::tCCDMW"]
        [::core::mem::offset_of!(atom_gddr6_ac_timing_v2_5, tCCDMW) - 50usize];
    ["Offset of field: atom_gddr6_ac_timing_v2_5::tWTRTR"]
        [::core::mem::offset_of!(atom_gddr6_ac_timing_v2_5, tWTRTR) - 51usize];
    ["Offset of field: atom_gddr6_ac_timing_v2_5::tLTLTR"]
        [::core::mem::offset_of!(atom_gddr6_ac_timing_v2_5, tLTLTR) - 52usize];
    ["Offset of field: atom_gddr6_ac_timing_v2_5::tREFTR"]
        [::core::mem::offset_of!(atom_gddr6_ac_timing_v2_5, tREFTR) - 53usize];
    ["Offset of field: atom_gddr6_ac_timing_v2_5::VNDR"]
        [::core::mem::offset_of!(atom_gddr6_ac_timing_v2_5, VNDR) - 54usize];
    ["Offset of field: atom_gddr6_ac_timing_v2_5::reserved"]
        [::core::mem::offset_of!(atom_gddr6_ac_timing_v2_5, reserved) - 55usize];
};
#[repr(C, packed)]
#[derive(Debug, Copy, Clone)]
pub struct atom_gddr6_bit_byte_remap {
    pub dphy_byteremap: u32,
    pub dphy_bitremap0: u32,
    pub dphy_bitremap1: u32,
    pub dphy_bitremap2: u32,
    pub aphy_bitremap0: u32,
    pub aphy_bitremap1: u32,
    pub phy_dram: u32,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of atom_gddr6_bit_byte_remap"]
        [::core::mem::size_of::<atom_gddr6_bit_byte_remap>() - 28usize];
    ["Alignment of atom_gddr6_bit_byte_remap"]
        [::core::mem::align_of::<atom_gddr6_bit_byte_remap>() - 1usize];
    ["Offset of field: atom_gddr6_bit_byte_remap::dphy_byteremap"]
        [::core::mem::offset_of!(atom_gddr6_bit_byte_remap, dphy_byteremap) - 0usize];
    ["Offset of field: atom_gddr6_bit_byte_remap::dphy_bitremap0"]
        [::core::mem::offset_of!(atom_gddr6_bit_byte_remap, dphy_bitremap0) - 4usize];
    ["Offset of field: atom_gddr6_bit_byte_remap::dphy_bitremap1"]
        [::core::mem::offset_of!(atom_gddr6_bit_byte_remap, dphy_bitremap1) - 8usize];
    ["Offset of field: atom_gddr6_bit_byte_remap::dphy_bitremap2"]
        [::core::mem::offset_of!(atom_gddr6_bit_byte_remap, dphy_bitremap2) - 12usize];
    ["Offset of field: atom_gddr6_bit_byte_remap::aphy_bitremap0"]
        [::core::mem::offset_of!(atom_gddr6_bit_byte_remap, aphy_bitremap0) - 16usize];
    ["Offset of field: atom_gddr6_bit_byte_remap::aphy_bitremap1"]
        [::core::mem::offset_of!(atom_gddr6_bit_byte_remap, aphy_bitremap1) - 20usize];
    ["Offset of field: atom_gddr6_bit_byte_remap::phy_dram"]
        [::core::mem::offset_of!(atom_gddr6_bit_byte_remap, phy_dram) - 24usize];
};
#[repr(C, packed)]
#[derive(Debug, Copy, Clone)]
pub struct atom_gddr6_dram_data_remap {
    pub table_size: u32,
    pub phyintf_ck_inverted: [u8; 8usize],
    pub bit_byte_remap: [atom_gddr6_bit_byte_remap; 16usize],
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of atom_gddr6_dram_data_remap"]
        [::core::mem::size_of::<atom_gddr6_dram_data_remap>() - 460usize];
    ["Alignment of atom_gddr6_dram_data_remap"]
        [::core::mem::align_of::<atom_gddr6_dram_data_remap>() - 1usize];
    ["Offset of field: atom_gddr6_dram_data_remap::table_size"]
        [::core::mem::offset_of!(atom_gddr6_dram_data_remap, table_size) - 0usize];
    ["Offset of field: atom_gddr6_dram_data_remap::phyintf_ck_inverted"]
        [::core::mem::offset_of!(atom_gddr6_dram_data_remap, phyintf_ck_inverted) - 4usize];
    ["Offset of field: atom_gddr6_dram_data_remap::bit_byte_remap"]
        [::core::mem::offset_of!(atom_gddr6_dram_data_remap, bit_byte_remap) - 12usize];
};
#[repr(C, packed)]
#[derive(Debug, Copy, Clone)]
pub struct atom_vram_info_header_v2_5 {
    pub table_header: atom_common_table_header,
    pub mem_adjust_tbloffset: u16,
    pub gddr6_ac_timing_offset: u16,
    pub mc_adjust_pertile_tbloffset: u16,
    pub mc_phyinit_tbloffset: u16,
    pub dram_data_remap_tbloffset: u16,
    pub reserved: u16,
    pub post_ucode_init_offset: u16,
    pub strobe_mode_patch_tbloffset: u16,
    pub vram_module_num: u8,
    pub umcip_min_ver: u8,
    pub umcip_max_ver: u8,
    pub mc_phy_tile_num: u8,
    pub vram_module: [atom_vram_module_v11; 16usize],
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of atom_vram_info_header_v2_5"]
        [::core::mem::size_of::<atom_vram_info_header_v2_5>() - 1368usize];
    ["Alignment of atom_vram_info_header_v2_5"]
        [::core::mem::align_of::<atom_vram_info_header_v2_5>() - 1usize];
    ["Offset of field: atom_vram_info_header_v2_5::table_header"]
        [::core::mem::offset_of!(atom_vram_info_header_v2_5, table_header) - 0usize];
    ["Offset of field: atom_vram_info_header_v2_5::mem_adjust_tbloffset"]
        [::core::mem::offset_of!(atom_vram_info_header_v2_5, mem_adjust_tbloffset) - 4usize];
    ["Offset of field: atom_vram_info_header_v2_5::gddr6_ac_timing_offset"]
        [::core::mem::offset_of!(atom_vram_info_header_v2_5, gddr6_ac_timing_offset) - 6usize];
    ["Offset of field: atom_vram_info_header_v2_5::mc_adjust_pertile_tbloffset"]
        [::core::mem::offset_of!(atom_vram_info_header_v2_5, mc_adjust_pertile_tbloffset) - 8usize];
    ["Offset of field: atom_vram_info_header_v2_5::mc_phyinit_tbloffset"]
        [::core::mem::offset_of!(atom_vram_info_header_v2_5, mc_phyinit_tbloffset) - 10usize];
    ["Offset of field: atom_vram_info_header_v2_5::dram_data_remap_tbloffset"]
        [::core::mem::offset_of!(atom_vram_info_header_v2_5, dram_data_remap_tbloffset) - 12usize];
    ["Offset of field: atom_vram_info_header_v2_5::reserved"]
        [::core::mem::offset_of!(atom_vram_info_header_v2_5, reserved) - 14usize];
    ["Offset of field: atom_vram_info_header_v2_5::post_ucode_init_offset"]
        [::core::mem::offset_of!(atom_vram_info_header_v2_5, post_ucode_init_offset) - 16usize];
    ["Offset of field: atom_vram_info_header_v2_5::strobe_mode_patch_tbloffset"][::core::mem::offset_of!(
        atom_vram_info_header_v2_5,
        strobe_mode_patch_tbloffset
    ) - 18usize];
    ["Offset of field: atom_vram_info_header_v2_5::vram_module_num"]
        [::core::mem::offset_of!(atom_vram_info_header_v2_5, vram_module_num) - 20usize];
    ["Offset of field: atom_vram_info_header_v2_5::umcip_min_ver"]
        [::core::mem::offset_of!(atom_vram_info_header_v2_5, umcip_min_ver) - 21usize];
    ["Offset of field: atom_vram_info_header_v2_5::umcip_max_ver"]
        [::core::mem::offset_of!(atom_vram_info_header_v2_5, umcip_max_ver) - 22usize];
    ["Offset of field: atom_vram_info_header_v2_5::mc_phy_tile_num"]
        [::core::mem::offset_of!(atom_vram_info_header_v2_5, mc_phy_tile_num) - 23usize];
    ["Offset of field: atom_vram_info_header_v2_5::vram_module"]
        [::core::mem::offset_of!(atom_vram_info_header_v2_5, vram_module) - 24usize];
};
#[repr(C, packed)]
#[derive(Debug, Copy, Clone)]
pub struct atom_vram_info_header_v2_6 {
    pub table_header: atom_common_table_header,
    pub mem_adjust_tbloffset: u16,
    pub mem_clk_patch_tbloffset: u16,
    pub mc_adjust_pertile_tbloffset: u16,
    pub mc_phyinit_tbloffset: u16,
    pub dram_data_remap_tbloffset: u16,
    pub tmrs_seq_offset: u16,
    pub post_ucode_init_offset: u16,
    pub vram_rsd2: u16,
    pub vram_module_num: u8,
    pub umcip_min_ver: u8,
    pub umcip_max_ver: u8,
    pub mc_phy_tile_num: u8,
    pub vram_module: [atom_vram_module_v9; 16usize],
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of atom_vram_info_header_v2_6"]
        [::core::mem::size_of::<atom_vram_info_header_v2_6>() - 856usize];
    ["Alignment of atom_vram_info_header_v2_6"]
        [::core::mem::align_of::<atom_vram_info_header_v2_6>() - 1usize];
    ["Offset of field: atom_vram_info_header_v2_6::table_header"]
        [::core::mem::offset_of!(atom_vram_info_header_v2_6, table_header) - 0usize];
    ["Offset of field: atom_vram_info_header_v2_6::mem_adjust_tbloffset"]
        [::core::mem::offset_of!(atom_vram_info_header_v2_6, mem_adjust_tbloffset) - 4usize];
    ["Offset of field: atom_vram_info_header_v2_6::mem_clk_patch_tbloffset"]
        [::core::mem::offset_of!(atom_vram_info_header_v2_6, mem_clk_patch_tbloffset) - 6usize];
    ["Offset of field: atom_vram_info_header_v2_6::mc_adjust_pertile_tbloffset"]
        [::core::mem::offset_of!(atom_vram_info_header_v2_6, mc_adjust_pertile_tbloffset) - 8usize];
    ["Offset of field: atom_vram_info_header_v2_6::mc_phyinit_tbloffset"]
        [::core::mem::offset_of!(atom_vram_info_header_v2_6, mc_phyinit_tbloffset) - 10usize];
    ["Offset of field: atom_vram_info_header_v2_6::dram_data_remap_tbloffset"]
        [::core::mem::offset_of!(atom_vram_info_header_v2_6, dram_data_remap_tbloffset) - 12usize];
    ["Offset of field: atom_vram_info_header_v2_6::tmrs_seq_offset"]
        [::core::mem::offset_of!(atom_vram_info_header_v2_6, tmrs_seq_offset) - 14usize];
    ["Offset of field: atom_vram_info_header_v2_6::post_ucode_init_offset"]
        [::core::mem::offset_of!(atom_vram_info_header_v2_6, post_ucode_init_offset) - 16usize];
    ["Offset of field: atom_vram_info_header_v2_6::vram_rsd2"]
        [::core::mem::offset_of!(atom_vram_info_header_v2_6, vram_rsd2) - 18usize];
    ["Offset of field: atom_vram_info_header_v2_6::vram_module_num"]
        [::core::mem::offset_of!(atom_vram_info_header_v2_6, vram_module_num) - 20usize];
    ["Offset of field: atom_vram_info_header_v2_6::umcip_min_ver"]
        [::core::mem::offset_of!(atom_vram_info_header_v2_6, umcip_min_ver) - 21usize];
    ["Offset of field: atom_vram_info_header_v2_6::umcip_max_ver"]
        [::core::mem::offset_of!(atom_vram_info_header_v2_6, umcip_max_ver) - 22usize];
    ["Offset of field: atom_vram_info_header_v2_6::mc_phy_tile_num"]
        [::core::mem::offset_of!(atom_vram_info_header_v2_6, mc_phy_tile_num) - 23usize];
    ["Offset of field: atom_vram_info_header_v2_6::vram_module"]
        [::core::mem::offset_of!(atom_vram_info_header_v2_6, vram_module) - 24usize];
};
#[repr(C, packed)]
#[derive(Debug, Copy, Clone)]
pub struct atom_i2c_data_entry {
    pub i2c_reg_index: u16,
    pub i2c_reg_data: u16,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of atom_i2c_data_entry"][::core::mem::size_of::<atom_i2c_data_entry>() - 4usize];
    ["Alignment of atom_i2c_data_entry"][::core::mem::align_of::<atom_i2c_data_entry>() - 1usize];
    ["Offset of field: atom_i2c_data_entry::i2c_reg_index"]
        [::core::mem::offset_of!(atom_i2c_data_entry, i2c_reg_index) - 0usize];
    ["Offset of field: atom_i2c_data_entry::i2c_reg_data"]
        [::core::mem::offset_of!(atom_i2c_data_entry, i2c_reg_data) - 2usize];
};
#[repr(C, packed)]
#[derive(Debug, Copy, Clone)]
pub struct atom_voltage_object_header_v4 {
    pub voltage_type: u8,
    pub voltage_mode: u8,
    pub object_size: u16,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of atom_voltage_object_header_v4"]
        [::core::mem::size_of::<atom_voltage_object_header_v4>() - 4usize];
    ["Alignment of atom_voltage_object_header_v4"]
        [::core::mem::align_of::<atom_voltage_object_header_v4>() - 1usize];
    ["Offset of field: atom_voltage_object_header_v4::voltage_type"]
        [::core::mem::offset_of!(atom_voltage_object_header_v4, voltage_type) - 0usize];
    ["Offset of field: atom_voltage_object_header_v4::voltage_mode"]
        [::core::mem::offset_of!(atom_voltage_object_header_v4, voltage_mode) - 1usize];
    ["Offset of field: atom_voltage_object_header_v4::object_size"]
        [::core::mem::offset_of!(atom_voltage_object_header_v4, object_size) - 2usize];
};
pub const atom_voltage_object_mode_VOLTAGE_OBJ_GPIO_LUT: atom_voltage_object_mode = 0;
pub const atom_voltage_object_mode_VOLTAGE_OBJ_VR_I2C_INIT_SEQ: atom_voltage_object_mode = 3;
pub const atom_voltage_object_mode_VOLTAGE_OBJ_PHASE_LUT: atom_voltage_object_mode = 4;
pub const atom_voltage_object_mode_VOLTAGE_OBJ_SVID2: atom_voltage_object_mode = 7;
pub const atom_voltage_object_mode_VOLTAGE_OBJ_EVV: atom_voltage_object_mode = 8;
pub const atom_voltage_object_mode_VOLTAGE_OBJ_MERGED_POWER: atom_voltage_object_mode = 9;
pub type atom_voltage_object_mode = ::core::ffi::c_uint;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct atom_i2c_voltage_object_v4 {
    pub header: atom_voltage_object_header_v4,
    pub regulator_id: u8,
    pub i2c_id: u8,
    pub i2c_slave_addr: u8,
    pub i2c_control_offset: u8,
    pub i2c_flag: u8,
    pub i2c_speed: u8,
    pub reserved: [u8; 2usize],
    pub i2cdatalut: [atom_i2c_data_entry; 1usize],
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of atom_i2c_voltage_object_v4"]
        [::core::mem::size_of::<atom_i2c_voltage_object_v4>() - 16usize];
    ["Alignment of atom_i2c_voltage_object_v4"]
        [::core::mem::align_of::<atom_i2c_voltage_object_v4>() - 1usize];
    ["Offset of field: atom_i2c_voltage_object_v4::header"]
        [::core::mem::offset_of!(atom_i2c_voltage_object_v4, header) - 0usize];
    ["Offset of field: atom_i2c_voltage_object_v4::regulator_id"]
        [::core::mem::offset_of!(atom_i2c_voltage_object_v4, regulator_id) - 4usize];
    ["Offset of field: atom_i2c_voltage_object_v4::i2c_id"]
        [::core::mem::offset_of!(atom_i2c_voltage_object_v4, i2c_id) - 5usize];
    ["Offset of field: atom_i2c_voltage_object_v4::i2c_slave_addr"]
        [::core::mem::offset_of!(atom_i2c_voltage_object_v4, i2c_slave_addr) - 6usize];
    ["Offset of field: atom_i2c_voltage_object_v4::i2c_control_offset"]
        [::core::mem::offset_of!(atom_i2c_voltage_object_v4, i2c_control_offset) - 7usize];
    ["Offset of field: atom_i2c_voltage_object_v4::i2c_flag"]
        [::core::mem::offset_of!(atom_i2c_voltage_object_v4, i2c_flag) - 8usize];
    ["Offset of field: atom_i2c_voltage_object_v4::i2c_speed"]
        [::core::mem::offset_of!(atom_i2c_voltage_object_v4, i2c_speed) - 9usize];
    ["Offset of field: atom_i2c_voltage_object_v4::reserved"]
        [::core::mem::offset_of!(atom_i2c_voltage_object_v4, reserved) - 10usize];
    ["Offset of field: atom_i2c_voltage_object_v4::i2cdatalut"]
        [::core::mem::offset_of!(atom_i2c_voltage_object_v4, i2cdatalut) - 12usize];
};
pub const atom_i2c_voltage_control_flag_VOLTAGE_DATA_ONE_BYTE: atom_i2c_voltage_control_flag = 0;
pub const atom_i2c_voltage_control_flag_VOLTAGE_DATA_TWO_BYTE: atom_i2c_voltage_control_flag = 1;
pub type atom_i2c_voltage_control_flag = ::core::ffi::c_uint;
#[repr(C, packed)]
#[derive(Debug, Copy, Clone)]
pub struct atom_voltage_gpio_map_lut {
    pub voltage_gpio_reg_val: u32,
    pub voltage_level_mv: u16,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of atom_voltage_gpio_map_lut"]
        [::core::mem::size_of::<atom_voltage_gpio_map_lut>() - 6usize];
    ["Alignment of atom_voltage_gpio_map_lut"]
        [::core::mem::align_of::<atom_voltage_gpio_map_lut>() - 1usize];
    ["Offset of field: atom_voltage_gpio_map_lut::voltage_gpio_reg_val"]
        [::core::mem::offset_of!(atom_voltage_gpio_map_lut, voltage_gpio_reg_val) - 0usize];
    ["Offset of field: atom_voltage_gpio_map_lut::voltage_level_mv"]
        [::core::mem::offset_of!(atom_voltage_gpio_map_lut, voltage_level_mv) - 4usize];
};
#[repr(C, packed)]
#[derive(Debug, Copy, Clone)]
pub struct atom_gpio_voltage_object_v4 {
    pub header: atom_voltage_object_header_v4,
    pub gpio_control_id: u8,
    pub gpio_entry_num: u8,
    pub phase_delay_us: u8,
    pub reserved: u8,
    pub gpio_mask_val: u32,
    pub voltage_gpio_lut: [atom_voltage_gpio_map_lut; 1usize],
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of atom_gpio_voltage_object_v4"]
        [::core::mem::size_of::<atom_gpio_voltage_object_v4>() - 18usize];
    ["Alignment of atom_gpio_voltage_object_v4"]
        [::core::mem::align_of::<atom_gpio_voltage_object_v4>() - 1usize];
    ["Offset of field: atom_gpio_voltage_object_v4::header"]
        [::core::mem::offset_of!(atom_gpio_voltage_object_v4, header) - 0usize];
    ["Offset of field: atom_gpio_voltage_object_v4::gpio_control_id"]
        [::core::mem::offset_of!(atom_gpio_voltage_object_v4, gpio_control_id) - 4usize];
    ["Offset of field: atom_gpio_voltage_object_v4::gpio_entry_num"]
        [::core::mem::offset_of!(atom_gpio_voltage_object_v4, gpio_entry_num) - 5usize];
    ["Offset of field: atom_gpio_voltage_object_v4::phase_delay_us"]
        [::core::mem::offset_of!(atom_gpio_voltage_object_v4, phase_delay_us) - 6usize];
    ["Offset of field: atom_gpio_voltage_object_v4::reserved"]
        [::core::mem::offset_of!(atom_gpio_voltage_object_v4, reserved) - 7usize];
    ["Offset of field: atom_gpio_voltage_object_v4::gpio_mask_val"]
        [::core::mem::offset_of!(atom_gpio_voltage_object_v4, gpio_mask_val) - 8usize];
    ["Offset of field: atom_gpio_voltage_object_v4::voltage_gpio_lut"]
        [::core::mem::offset_of!(atom_gpio_voltage_object_v4, voltage_gpio_lut) - 12usize];
};
#[repr(C, packed)]
#[derive(Debug, Copy, Clone)]
pub struct atom_svid2_voltage_object_v4 {
    pub header: atom_voltage_object_header_v4,
    pub loadline_psi1: u8,
    pub psi0_l_vid_thresd: u8,
    pub psi0_enable: u8,
    pub maxvstep: u8,
    pub telemetry_offset: u8,
    pub telemetry_gain: u8,
    pub reserved1: u16,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of atom_svid2_voltage_object_v4"]
        [::core::mem::size_of::<atom_svid2_voltage_object_v4>() - 12usize];
    ["Alignment of atom_svid2_voltage_object_v4"]
        [::core::mem::align_of::<atom_svid2_voltage_object_v4>() - 1usize];
    ["Offset of field: atom_svid2_voltage_object_v4::header"]
        [::core::mem::offset_of!(atom_svid2_voltage_object_v4, header) - 0usize];
    ["Offset of field: atom_svid2_voltage_object_v4::loadline_psi1"]
        [::core::mem::offset_of!(atom_svid2_voltage_object_v4, loadline_psi1) - 4usize];
    ["Offset of field: atom_svid2_voltage_object_v4::psi0_l_vid_thresd"]
        [::core::mem::offset_of!(atom_svid2_voltage_object_v4, psi0_l_vid_thresd) - 5usize];
    ["Offset of field: atom_svid2_voltage_object_v4::psi0_enable"]
        [::core::mem::offset_of!(atom_svid2_voltage_object_v4, psi0_enable) - 6usize];
    ["Offset of field: atom_svid2_voltage_object_v4::maxvstep"]
        [::core::mem::offset_of!(atom_svid2_voltage_object_v4, maxvstep) - 7usize];
    ["Offset of field: atom_svid2_voltage_object_v4::telemetry_offset"]
        [::core::mem::offset_of!(atom_svid2_voltage_object_v4, telemetry_offset) - 8usize];
    ["Offset of field: atom_svid2_voltage_object_v4::telemetry_gain"]
        [::core::mem::offset_of!(atom_svid2_voltage_object_v4, telemetry_gain) - 9usize];
    ["Offset of field: atom_svid2_voltage_object_v4::reserved1"]
        [::core::mem::offset_of!(atom_svid2_voltage_object_v4, reserved1) - 10usize];
};
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct atom_merged_voltage_object_v4 {
    pub header: atom_voltage_object_header_v4,
    pub merged_powerrail_type: u8,
    pub reserved: [u8; 3usize],
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of atom_merged_voltage_object_v4"]
        [::core::mem::size_of::<atom_merged_voltage_object_v4>() - 8usize];
    ["Alignment of atom_merged_voltage_object_v4"]
        [::core::mem::align_of::<atom_merged_voltage_object_v4>() - 1usize];
    ["Offset of field: atom_merged_voltage_object_v4::header"]
        [::core::mem::offset_of!(atom_merged_voltage_object_v4, header) - 0usize];
    ["Offset of field: atom_merged_voltage_object_v4::merged_powerrail_type"]
        [::core::mem::offset_of!(atom_merged_voltage_object_v4, merged_powerrail_type) - 4usize];
    ["Offset of field: atom_merged_voltage_object_v4::reserved"]
        [::core::mem::offset_of!(atom_merged_voltage_object_v4, reserved) - 5usize];
};
#[repr(C)]
#[derive(Copy, Clone)]
pub union atom_voltage_object_v4 {
    pub gpio_voltage_obj: atom_gpio_voltage_object_v4,
    pub i2c_voltage_obj: atom_i2c_voltage_object_v4,
    pub svid2_voltage_obj: atom_svid2_voltage_object_v4,
    pub merged_voltage_obj: atom_merged_voltage_object_v4,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of atom_voltage_object_v4"][::core::mem::size_of::<atom_voltage_object_v4>() - 18usize];
    ["Alignment of atom_voltage_object_v4"]
        [::core::mem::align_of::<atom_voltage_object_v4>() - 1usize];
    ["Offset of field: atom_voltage_object_v4::gpio_voltage_obj"]
        [::core::mem::offset_of!(atom_voltage_object_v4, gpio_voltage_obj) - 0usize];
    ["Offset of field: atom_voltage_object_v4::i2c_voltage_obj"]
        [::core::mem::offset_of!(atom_voltage_object_v4, i2c_voltage_obj) - 0usize];
    ["Offset of field: atom_voltage_object_v4::svid2_voltage_obj"]
        [::core::mem::offset_of!(atom_voltage_object_v4, svid2_voltage_obj) - 0usize];
    ["Offset of field: atom_voltage_object_v4::merged_voltage_obj"]
        [::core::mem::offset_of!(atom_voltage_object_v4, merged_voltage_obj) - 0usize];
};
#[repr(C)]
#[derive(Copy, Clone)]
pub struct atom_voltage_objects_info_v4_1 {
    pub table_header: atom_common_table_header,
    pub voltage_object: [atom_voltage_object_v4; 1usize],
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of atom_voltage_objects_info_v4_1"]
        [::core::mem::size_of::<atom_voltage_objects_info_v4_1>() - 22usize];
    ["Alignment of atom_voltage_objects_info_v4_1"]
        [::core::mem::align_of::<atom_voltage_objects_info_v4_1>() - 1usize];
    ["Offset of field: atom_voltage_objects_info_v4_1::table_header"]
        [::core::mem::offset_of!(atom_voltage_objects_info_v4_1, table_header) - 0usize];
    ["Offset of field: atom_voltage_objects_info_v4_1::voltage_object"]
        [::core::mem::offset_of!(atom_voltage_objects_info_v4_1, voltage_object) - 4usize];
};
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct asic_init_engine_parameters {
    pub _bitfield_align_1: [u8; 0],
    pub _bitfield_1: __BindgenBitfieldUnit<[u8; 4usize]>,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of asic_init_engine_parameters"]
        [::core::mem::size_of::<asic_init_engine_parameters>() - 4usize];
    ["Alignment of asic_init_engine_parameters"]
        [::core::mem::align_of::<asic_init_engine_parameters>() - 1usize];
};
impl asic_init_engine_parameters {
    #[inline]
    pub fn sclkfreqin10khz(&self) -> u32 {
        unsafe { ::core::mem::transmute(self._bitfield_1.get(0usize, 24u8) as u32) }
    }
    #[inline]
    pub fn set_sclkfreqin10khz(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::core::mem::transmute(val);
            self._bitfield_1.set(0usize, 24u8, val as u64)
        }
    }
    #[inline]
    pub unsafe fn sclkfreqin10khz_raw(this: *const Self) -> u32 {
        unsafe {
            ::core::mem::transmute(<__BindgenBitfieldUnit<[u8; 4usize]>>::raw_get(
                ::core::ptr::addr_of!((*this)._bitfield_1),
                0usize,
                24u8,
            ) as u32)
        }
    }
    #[inline]
    pub unsafe fn set_sclkfreqin10khz_raw(this: *mut Self, val: u32) {
        unsafe {
            let val: u32 = ::core::mem::transmute(val);
            <__BindgenBitfieldUnit<[u8; 4usize]>>::raw_set(
                ::core::ptr::addr_of_mut!((*this)._bitfield_1),
                0usize,
                24u8,
                val as u64,
            )
        }
    }
    #[inline]
    pub fn engineflag(&self) -> u32 {
        unsafe { ::core::mem::transmute(self._bitfield_1.get(24usize, 8u8) as u32) }
    }
    #[inline]
    pub fn set_engineflag(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::core::mem::transmute(val);
            self._bitfield_1.set(24usize, 8u8, val as u64)
        }
    }
    #[inline]
    pub unsafe fn engineflag_raw(this: *const Self) -> u32 {
        unsafe {
            ::core::mem::transmute(<__BindgenBitfieldUnit<[u8; 4usize]>>::raw_get(
                ::core::ptr::addr_of!((*this)._bitfield_1),
                24usize,
                8u8,
            ) as u32)
        }
    }
    #[inline]
    pub unsafe fn set_engineflag_raw(this: *mut Self, val: u32) {
        unsafe {
            let val: u32 = ::core::mem::transmute(val);
            <__BindgenBitfieldUnit<[u8; 4usize]>>::raw_set(
                ::core::ptr::addr_of_mut!((*this)._bitfield_1),
                24usize,
                8u8,
                val as u64,
            )
        }
    }
    #[inline]
    pub fn new_bitfield_1(
        sclkfreqin10khz: u32,
        engineflag: u32,
    ) -> __BindgenBitfieldUnit<[u8; 4usize]> {
        let mut __bindgen_bitfield_unit: __BindgenBitfieldUnit<[u8; 4usize]> = Default::default();
        __bindgen_bitfield_unit.set(0usize, 24u8, {
            let sclkfreqin10khz: u32 = unsafe { ::core::mem::transmute(sclkfreqin10khz) };
            sclkfreqin10khz as u64
        });
        __bindgen_bitfield_unit.set(24usize, 8u8, {
            let engineflag: u32 = unsafe { ::core::mem::transmute(engineflag) };
            engineflag as u64
        });
        __bindgen_bitfield_unit
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct asic_init_mem_parameters {
    pub _bitfield_align_1: [u8; 0],
    pub _bitfield_1: __BindgenBitfieldUnit<[u8; 4usize]>,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of asic_init_mem_parameters"]
        [::core::mem::size_of::<asic_init_mem_parameters>() - 4usize];
    ["Alignment of asic_init_mem_parameters"]
        [::core::mem::align_of::<asic_init_mem_parameters>() - 1usize];
};
impl asic_init_mem_parameters {
    #[inline]
    pub fn mclkfreqin10khz(&self) -> u32 {
        unsafe { ::core::mem::transmute(self._bitfield_1.get(0usize, 24u8) as u32) }
    }
    #[inline]
    pub fn set_mclkfreqin10khz(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::core::mem::transmute(val);
            self._bitfield_1.set(0usize, 24u8, val as u64)
        }
    }
    #[inline]
    pub unsafe fn mclkfreqin10khz_raw(this: *const Self) -> u32 {
        unsafe {
            ::core::mem::transmute(<__BindgenBitfieldUnit<[u8; 4usize]>>::raw_get(
                ::core::ptr::addr_of!((*this)._bitfield_1),
                0usize,
                24u8,
            ) as u32)
        }
    }
    #[inline]
    pub unsafe fn set_mclkfreqin10khz_raw(this: *mut Self, val: u32) {
        unsafe {
            let val: u32 = ::core::mem::transmute(val);
            <__BindgenBitfieldUnit<[u8; 4usize]>>::raw_set(
                ::core::ptr::addr_of_mut!((*this)._bitfield_1),
                0usize,
                24u8,
                val as u64,
            )
        }
    }
    #[inline]
    pub fn memflag(&self) -> u32 {
        unsafe { ::core::mem::transmute(self._bitfield_1.get(24usize, 8u8) as u32) }
    }
    #[inline]
    pub fn set_memflag(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::core::mem::transmute(val);
            self._bitfield_1.set(24usize, 8u8, val as u64)
        }
    }
    #[inline]
    pub unsafe fn memflag_raw(this: *const Self) -> u32 {
        unsafe {
            ::core::mem::transmute(<__BindgenBitfieldUnit<[u8; 4usize]>>::raw_get(
                ::core::ptr::addr_of!((*this)._bitfield_1),
                24usize,
                8u8,
            ) as u32)
        }
    }
    #[inline]
    pub unsafe fn set_memflag_raw(this: *mut Self, val: u32) {
        unsafe {
            let val: u32 = ::core::mem::transmute(val);
            <__BindgenBitfieldUnit<[u8; 4usize]>>::raw_set(
                ::core::ptr::addr_of_mut!((*this)._bitfield_1),
                24usize,
                8u8,
                val as u64,
            )
        }
    }
    #[inline]
    pub fn new_bitfield_1(
        mclkfreqin10khz: u32,
        memflag: u32,
    ) -> __BindgenBitfieldUnit<[u8; 4usize]> {
        let mut __bindgen_bitfield_unit: __BindgenBitfieldUnit<[u8; 4usize]> = Default::default();
        __bindgen_bitfield_unit.set(0usize, 24u8, {
            let mclkfreqin10khz: u32 = unsafe { ::core::mem::transmute(mclkfreqin10khz) };
            mclkfreqin10khz as u64
        });
        __bindgen_bitfield_unit.set(24usize, 8u8, {
            let memflag: u32 = unsafe { ::core::mem::transmute(memflag) };
            memflag as u64
        });
        __bindgen_bitfield_unit
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct asic_init_parameters_v2_1 {
    pub engineparam: asic_init_engine_parameters,
    pub memparam: asic_init_mem_parameters,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of asic_init_parameters_v2_1"]
        [::core::mem::size_of::<asic_init_parameters_v2_1>() - 8usize];
    ["Alignment of asic_init_parameters_v2_1"]
        [::core::mem::align_of::<asic_init_parameters_v2_1>() - 1usize];
    ["Offset of field: asic_init_parameters_v2_1::engineparam"]
        [::core::mem::offset_of!(asic_init_parameters_v2_1, engineparam) - 0usize];
    ["Offset of field: asic_init_parameters_v2_1::memparam"]
        [::core::mem::offset_of!(asic_init_parameters_v2_1, memparam) - 4usize];
};
#[repr(C, packed)]
#[derive(Debug, Copy, Clone)]
pub struct asic_init_ps_allocation_v2_1 {
    pub param: asic_init_parameters_v2_1,
    pub reserved: [u32; 16usize],
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of asic_init_ps_allocation_v2_1"]
        [::core::mem::size_of::<asic_init_ps_allocation_v2_1>() - 72usize];
    ["Alignment of asic_init_ps_allocation_v2_1"]
        [::core::mem::align_of::<asic_init_ps_allocation_v2_1>() - 1usize];
    ["Offset of field: asic_init_ps_allocation_v2_1::param"]
        [::core::mem::offset_of!(asic_init_ps_allocation_v2_1, param) - 0usize];
    ["Offset of field: asic_init_ps_allocation_v2_1::reserved"]
        [::core::mem::offset_of!(asic_init_ps_allocation_v2_1, reserved) - 8usize];
};
pub const atom_asic_init_engine_flag_b3NORMAL_ENGINE_INIT: atom_asic_init_engine_flag = 0;
pub const atom_asic_init_engine_flag_b3SRIOV_SKIP_ASIC_INIT: atom_asic_init_engine_flag = 2;
pub const atom_asic_init_engine_flag_b3SRIOV_LOAD_UCODE: atom_asic_init_engine_flag = 64;
pub type atom_asic_init_engine_flag = ::core::ffi::c_uint;
pub const atom_asic_init_mem_flag_b3NORMAL_MEM_INIT: atom_asic_init_mem_flag = 0;
pub const atom_asic_init_mem_flag_b3DRAM_SELF_REFRESH_EXIT: atom_asic_init_mem_flag = 32;
pub type atom_asic_init_mem_flag = ::core::ffi::c_uint;
#[repr(C, packed)]
#[derive(Debug, Copy, Clone)]
pub struct set_engine_clock_parameters_v2_1 {
    pub _bitfield_align_1: [u8; 0],
    pub _bitfield_1: __BindgenBitfieldUnit<[u8; 4usize]>,
    pub reserved: [u32; 10usize],
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of set_engine_clock_parameters_v2_1"]
        [::core::mem::size_of::<set_engine_clock_parameters_v2_1>() - 44usize];
    ["Alignment of set_engine_clock_parameters_v2_1"]
        [::core::mem::align_of::<set_engine_clock_parameters_v2_1>() - 1usize];
    ["Offset of field: set_engine_clock_parameters_v2_1::reserved"]
        [::core::mem::offset_of!(set_engine_clock_parameters_v2_1, reserved) - 4usize];
};
impl set_engine_clock_parameters_v2_1 {
    #[inline]
    pub fn sclkfreqin10khz(&self) -> u32 {
        unsafe { ::core::mem::transmute(self._bitfield_1.get(0usize, 24u8) as u32) }
    }
    #[inline]
    pub fn set_sclkfreqin10khz(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::core::mem::transmute(val);
            self._bitfield_1.set(0usize, 24u8, val as u64)
        }
    }
    #[inline]
    pub unsafe fn sclkfreqin10khz_raw(this: *const Self) -> u32 {
        unsafe {
            ::core::mem::transmute(<__BindgenBitfieldUnit<[u8; 4usize]>>::raw_get(
                ::core::ptr::addr_of!((*this)._bitfield_1),
                0usize,
                24u8,
            ) as u32)
        }
    }
    #[inline]
    pub unsafe fn set_sclkfreqin10khz_raw(this: *mut Self, val: u32) {
        unsafe {
            let val: u32 = ::core::mem::transmute(val);
            <__BindgenBitfieldUnit<[u8; 4usize]>>::raw_set(
                ::core::ptr::addr_of_mut!((*this)._bitfield_1),
                0usize,
                24u8,
                val as u64,
            )
        }
    }
    #[inline]
    pub fn sclkflag(&self) -> u32 {
        unsafe { ::core::mem::transmute(self._bitfield_1.get(24usize, 8u8) as u32) }
    }
    #[inline]
    pub fn set_sclkflag(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::core::mem::transmute(val);
            self._bitfield_1.set(24usize, 8u8, val as u64)
        }
    }
    #[inline]
    pub unsafe fn sclkflag_raw(this: *const Self) -> u32 {
        unsafe {
            ::core::mem::transmute(<__BindgenBitfieldUnit<[u8; 4usize]>>::raw_get(
                ::core::ptr::addr_of!((*this)._bitfield_1),
                24usize,
                8u8,
            ) as u32)
        }
    }
    #[inline]
    pub unsafe fn set_sclkflag_raw(this: *mut Self, val: u32) {
        unsafe {
            let val: u32 = ::core::mem::transmute(val);
            <__BindgenBitfieldUnit<[u8; 4usize]>>::raw_set(
                ::core::ptr::addr_of_mut!((*this)._bitfield_1),
                24usize,
                8u8,
                val as u64,
            )
        }
    }
    #[inline]
    pub fn new_bitfield_1(
        sclkfreqin10khz: u32,
        sclkflag: u32,
    ) -> __BindgenBitfieldUnit<[u8; 4usize]> {
        let mut __bindgen_bitfield_unit: __BindgenBitfieldUnit<[u8; 4usize]> = Default::default();
        __bindgen_bitfield_unit.set(0usize, 24u8, {
            let sclkfreqin10khz: u32 = unsafe { ::core::mem::transmute(sclkfreqin10khz) };
            sclkfreqin10khz as u64
        });
        __bindgen_bitfield_unit.set(24usize, 8u8, {
            let sclkflag: u32 = unsafe { ::core::mem::transmute(sclkflag) };
            sclkflag as u64
        });
        __bindgen_bitfield_unit
    }
}
#[repr(C, packed)]
#[derive(Debug, Copy, Clone)]
pub struct set_engine_clock_ps_allocation_v2_1 {
    pub clockinfo: set_engine_clock_parameters_v2_1,
    pub reserved: [u32; 10usize],
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of set_engine_clock_ps_allocation_v2_1"]
        [::core::mem::size_of::<set_engine_clock_ps_allocation_v2_1>() - 84usize];
    ["Alignment of set_engine_clock_ps_allocation_v2_1"]
        [::core::mem::align_of::<set_engine_clock_ps_allocation_v2_1>() - 1usize];
    ["Offset of field: set_engine_clock_ps_allocation_v2_1::clockinfo"]
        [::core::mem::offset_of!(set_engine_clock_ps_allocation_v2_1, clockinfo) - 0usize];
    ["Offset of field: set_engine_clock_ps_allocation_v2_1::reserved"]
        [::core::mem::offset_of!(set_engine_clock_ps_allocation_v2_1, reserved) - 44usize];
};
pub const atom_set_engine_mem_clock_flag_b3NORMAL_CHANGE_CLOCK: atom_set_engine_mem_clock_flag = 0;
pub const atom_set_engine_mem_clock_flag_b3FIRST_TIME_CHANGE_CLOCK: atom_set_engine_mem_clock_flag =
    8;
pub const atom_set_engine_mem_clock_flag_b3STORE_DPM_TRAINGING: atom_set_engine_mem_clock_flag = 64;
pub type atom_set_engine_mem_clock_flag = ::core::ffi::c_uint;
#[repr(C, packed)]
#[derive(Debug, Copy, Clone)]
pub struct get_engine_clock_parameter {
    pub sclk_10khz: u32,
    pub reserved: u32,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of get_engine_clock_parameter"]
        [::core::mem::size_of::<get_engine_clock_parameter>() - 8usize];
    ["Alignment of get_engine_clock_parameter"]
        [::core::mem::align_of::<get_engine_clock_parameter>() - 1usize];
    ["Offset of field: get_engine_clock_parameter::sclk_10khz"]
        [::core::mem::offset_of!(get_engine_clock_parameter, sclk_10khz) - 0usize];
    ["Offset of field: get_engine_clock_parameter::reserved"]
        [::core::mem::offset_of!(get_engine_clock_parameter, reserved) - 4usize];
};
#[repr(C, packed)]
#[derive(Debug, Copy, Clone)]
pub struct set_memory_clock_parameters_v2_1 {
    pub _bitfield_align_1: [u8; 0],
    pub _bitfield_1: __BindgenBitfieldUnit<[u8; 4usize]>,
    pub reserved: [u32; 10usize],
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of set_memory_clock_parameters_v2_1"]
        [::core::mem::size_of::<set_memory_clock_parameters_v2_1>() - 44usize];
    ["Alignment of set_memory_clock_parameters_v2_1"]
        [::core::mem::align_of::<set_memory_clock_parameters_v2_1>() - 1usize];
    ["Offset of field: set_memory_clock_parameters_v2_1::reserved"]
        [::core::mem::offset_of!(set_memory_clock_parameters_v2_1, reserved) - 4usize];
};
impl set_memory_clock_parameters_v2_1 {
    #[inline]
    pub fn mclkfreqin10khz(&self) -> u32 {
        unsafe { ::core::mem::transmute(self._bitfield_1.get(0usize, 24u8) as u32) }
    }
    #[inline]
    pub fn set_mclkfreqin10khz(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::core::mem::transmute(val);
            self._bitfield_1.set(0usize, 24u8, val as u64)
        }
    }
    #[inline]
    pub unsafe fn mclkfreqin10khz_raw(this: *const Self) -> u32 {
        unsafe {
            ::core::mem::transmute(<__BindgenBitfieldUnit<[u8; 4usize]>>::raw_get(
                ::core::ptr::addr_of!((*this)._bitfield_1),
                0usize,
                24u8,
            ) as u32)
        }
    }
    #[inline]
    pub unsafe fn set_mclkfreqin10khz_raw(this: *mut Self, val: u32) {
        unsafe {
            let val: u32 = ::core::mem::transmute(val);
            <__BindgenBitfieldUnit<[u8; 4usize]>>::raw_set(
                ::core::ptr::addr_of_mut!((*this)._bitfield_1),
                0usize,
                24u8,
                val as u64,
            )
        }
    }
    #[inline]
    pub fn mclkflag(&self) -> u32 {
        unsafe { ::core::mem::transmute(self._bitfield_1.get(24usize, 8u8) as u32) }
    }
    #[inline]
    pub fn set_mclkflag(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::core::mem::transmute(val);
            self._bitfield_1.set(24usize, 8u8, val as u64)
        }
    }
    #[inline]
    pub unsafe fn mclkflag_raw(this: *const Self) -> u32 {
        unsafe {
            ::core::mem::transmute(<__BindgenBitfieldUnit<[u8; 4usize]>>::raw_get(
                ::core::ptr::addr_of!((*this)._bitfield_1),
                24usize,
                8u8,
            ) as u32)
        }
    }
    #[inline]
    pub unsafe fn set_mclkflag_raw(this: *mut Self, val: u32) {
        unsafe {
            let val: u32 = ::core::mem::transmute(val);
            <__BindgenBitfieldUnit<[u8; 4usize]>>::raw_set(
                ::core::ptr::addr_of_mut!((*this)._bitfield_1),
                24usize,
                8u8,
                val as u64,
            )
        }
    }
    #[inline]
    pub fn new_bitfield_1(
        mclkfreqin10khz: u32,
        mclkflag: u32,
    ) -> __BindgenBitfieldUnit<[u8; 4usize]> {
        let mut __bindgen_bitfield_unit: __BindgenBitfieldUnit<[u8; 4usize]> = Default::default();
        __bindgen_bitfield_unit.set(0usize, 24u8, {
            let mclkfreqin10khz: u32 = unsafe { ::core::mem::transmute(mclkfreqin10khz) };
            mclkfreqin10khz as u64
        });
        __bindgen_bitfield_unit.set(24usize, 8u8, {
            let mclkflag: u32 = unsafe { ::core::mem::transmute(mclkflag) };
            mclkflag as u64
        });
        __bindgen_bitfield_unit
    }
}
#[repr(C, packed)]
#[derive(Debug, Copy, Clone)]
pub struct set_memory_clock_ps_allocation_v2_1 {
    pub clockinfo: set_memory_clock_parameters_v2_1,
    pub reserved: [u32; 10usize],
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of set_memory_clock_ps_allocation_v2_1"]
        [::core::mem::size_of::<set_memory_clock_ps_allocation_v2_1>() - 84usize];
    ["Alignment of set_memory_clock_ps_allocation_v2_1"]
        [::core::mem::align_of::<set_memory_clock_ps_allocation_v2_1>() - 1usize];
    ["Offset of field: set_memory_clock_ps_allocation_v2_1::clockinfo"]
        [::core::mem::offset_of!(set_memory_clock_ps_allocation_v2_1, clockinfo) - 0usize];
    ["Offset of field: set_memory_clock_ps_allocation_v2_1::reserved"]
        [::core::mem::offset_of!(set_memory_clock_ps_allocation_v2_1, reserved) - 44usize];
};
#[repr(C, packed)]
#[derive(Debug, Copy, Clone)]
pub struct get_memory_clock_parameter {
    pub mclk_10khz: u32,
    pub reserved: u32,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of get_memory_clock_parameter"]
        [::core::mem::size_of::<get_memory_clock_parameter>() - 8usize];
    ["Alignment of get_memory_clock_parameter"]
        [::core::mem::align_of::<get_memory_clock_parameter>() - 1usize];
    ["Offset of field: get_memory_clock_parameter::mclk_10khz"]
        [::core::mem::offset_of!(get_memory_clock_parameter, mclk_10khz) - 0usize];
    ["Offset of field: get_memory_clock_parameter::reserved"]
        [::core::mem::offset_of!(get_memory_clock_parameter, reserved) - 4usize];
};
#[repr(C, packed)]
#[derive(Debug, Copy, Clone)]
pub struct set_voltage_parameters_v1_4 {
    pub voltagetype: u8,
    pub command: u8,
    pub vlevel_mv: u16,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of set_voltage_parameters_v1_4"]
        [::core::mem::size_of::<set_voltage_parameters_v1_4>() - 4usize];
    ["Alignment of set_voltage_parameters_v1_4"]
        [::core::mem::align_of::<set_voltage_parameters_v1_4>() - 1usize];
    ["Offset of field: set_voltage_parameters_v1_4::voltagetype"]
        [::core::mem::offset_of!(set_voltage_parameters_v1_4, voltagetype) - 0usize];
    ["Offset of field: set_voltage_parameters_v1_4::command"]
        [::core::mem::offset_of!(set_voltage_parameters_v1_4, command) - 1usize];
    ["Offset of field: set_voltage_parameters_v1_4::vlevel_mv"]
        [::core::mem::offset_of!(set_voltage_parameters_v1_4, vlevel_mv) - 2usize];
};
pub const atom_set_voltage_command_ATOM_SET_VOLTAGE: atom_set_voltage_command = 0;
pub const atom_set_voltage_command_ATOM_INIT_VOLTAGE_REGULATOR: atom_set_voltage_command = 3;
pub const atom_set_voltage_command_ATOM_SET_VOLTAGE_PHASE: atom_set_voltage_command = 4;
pub const atom_set_voltage_command_ATOM_GET_LEAKAGE_ID: atom_set_voltage_command = 8;
pub type atom_set_voltage_command = ::core::ffi::c_uint;
#[repr(C, packed)]
#[derive(Debug, Copy, Clone)]
pub struct set_voltage_ps_allocation_v1_4 {
    pub setvoltageparam: set_voltage_parameters_v1_4,
    pub reserved: [u32; 10usize],
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of set_voltage_ps_allocation_v1_4"]
        [::core::mem::size_of::<set_voltage_ps_allocation_v1_4>() - 44usize];
    ["Alignment of set_voltage_ps_allocation_v1_4"]
        [::core::mem::align_of::<set_voltage_ps_allocation_v1_4>() - 1usize];
    ["Offset of field: set_voltage_ps_allocation_v1_4::setvoltageparam"]
        [::core::mem::offset_of!(set_voltage_ps_allocation_v1_4, setvoltageparam) - 0usize];
    ["Offset of field: set_voltage_ps_allocation_v1_4::reserved"]
        [::core::mem::offset_of!(set_voltage_ps_allocation_v1_4, reserved) - 4usize];
};
pub const atom_gpu_clock_type_COMPUTE_GPUCLK_INPUT_FLAG_DEFAULT_GPUCLK: atom_gpu_clock_type = 0;
pub const atom_gpu_clock_type_COMPUTE_GPUCLK_INPUT_FLAG_GFXCLK: atom_gpu_clock_type = 1;
pub const atom_gpu_clock_type_COMPUTE_GPUCLK_INPUT_FLAG_UCLK: atom_gpu_clock_type = 2;
pub type atom_gpu_clock_type = ::core::ffi::c_uint;
#[repr(C, packed)]
#[derive(Debug, Copy, Clone)]
pub struct compute_gpu_clock_input_parameter_v1_8 {
    pub _bitfield_align_1: [u8; 0],
    pub _bitfield_1: __BindgenBitfieldUnit<[u8; 4usize]>,
    pub reserved: [u32; 5usize],
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of compute_gpu_clock_input_parameter_v1_8"]
        [::core::mem::size_of::<compute_gpu_clock_input_parameter_v1_8>() - 24usize];
    ["Alignment of compute_gpu_clock_input_parameter_v1_8"]
        [::core::mem::align_of::<compute_gpu_clock_input_parameter_v1_8>() - 1usize];
    ["Offset of field: compute_gpu_clock_input_parameter_v1_8::reserved"]
        [::core::mem::offset_of!(compute_gpu_clock_input_parameter_v1_8, reserved) - 4usize];
};
impl compute_gpu_clock_input_parameter_v1_8 {
    #[inline]
    pub fn gpuclock_10khz(&self) -> u32 {
        unsafe { ::core::mem::transmute(self._bitfield_1.get(0usize, 24u8) as u32) }
    }
    #[inline]
    pub fn set_gpuclock_10khz(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::core::mem::transmute(val);
            self._bitfield_1.set(0usize, 24u8, val as u64)
        }
    }
    #[inline]
    pub unsafe fn gpuclock_10khz_raw(this: *const Self) -> u32 {
        unsafe {
            ::core::mem::transmute(<__BindgenBitfieldUnit<[u8; 4usize]>>::raw_get(
                ::core::ptr::addr_of!((*this)._bitfield_1),
                0usize,
                24u8,
            ) as u32)
        }
    }
    #[inline]
    pub unsafe fn set_gpuclock_10khz_raw(this: *mut Self, val: u32) {
        unsafe {
            let val: u32 = ::core::mem::transmute(val);
            <__BindgenBitfieldUnit<[u8; 4usize]>>::raw_set(
                ::core::ptr::addr_of_mut!((*this)._bitfield_1),
                0usize,
                24u8,
                val as u64,
            )
        }
    }
    #[inline]
    pub fn gpu_clock_type(&self) -> u32 {
        unsafe { ::core::mem::transmute(self._bitfield_1.get(24usize, 8u8) as u32) }
    }
    #[inline]
    pub fn set_gpu_clock_type(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::core::mem::transmute(val);
            self._bitfield_1.set(24usize, 8u8, val as u64)
        }
    }
    #[inline]
    pub unsafe fn gpu_clock_type_raw(this: *const Self) -> u32 {
        unsafe {
            ::core::mem::transmute(<__BindgenBitfieldUnit<[u8; 4usize]>>::raw_get(
                ::core::ptr::addr_of!((*this)._bitfield_1),
                24usize,
                8u8,
            ) as u32)
        }
    }
    #[inline]
    pub unsafe fn set_gpu_clock_type_raw(this: *mut Self, val: u32) {
        unsafe {
            let val: u32 = ::core::mem::transmute(val);
            <__BindgenBitfieldUnit<[u8; 4usize]>>::raw_set(
                ::core::ptr::addr_of_mut!((*this)._bitfield_1),
                24usize,
                8u8,
                val as u64,
            )
        }
    }
    #[inline]
    pub fn new_bitfield_1(
        gpuclock_10khz: u32,
        gpu_clock_type: u32,
    ) -> __BindgenBitfieldUnit<[u8; 4usize]> {
        let mut __bindgen_bitfield_unit: __BindgenBitfieldUnit<[u8; 4usize]> = Default::default();
        __bindgen_bitfield_unit.set(0usize, 24u8, {
            let gpuclock_10khz: u32 = unsafe { ::core::mem::transmute(gpuclock_10khz) };
            gpuclock_10khz as u64
        });
        __bindgen_bitfield_unit.set(24usize, 8u8, {
            let gpu_clock_type: u32 = unsafe { ::core::mem::transmute(gpu_clock_type) };
            gpu_clock_type as u64
        });
        __bindgen_bitfield_unit
    }
}
#[repr(C, packed)]
#[derive(Debug, Copy, Clone)]
pub struct compute_gpu_clock_output_parameter_v1_8 {
    pub _bitfield_align_1: [u8; 0],
    pub _bitfield_1: __BindgenBitfieldUnit<[u8; 4usize]>,
    pub pll_fb_mult: u32,
    pub pll_ss_fbsmult: u32,
    pub pll_ss_slew_frac: u16,
    pub pll_ss_enable: u8,
    pub reserved: u8,
    pub reserved1: [u32; 2usize],
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of compute_gpu_clock_output_parameter_v1_8"]
        [::core::mem::size_of::<compute_gpu_clock_output_parameter_v1_8>() - 24usize];
    ["Alignment of compute_gpu_clock_output_parameter_v1_8"]
        [::core::mem::align_of::<compute_gpu_clock_output_parameter_v1_8>() - 1usize];
    ["Offset of field: compute_gpu_clock_output_parameter_v1_8::pll_fb_mult"]
        [::core::mem::offset_of!(compute_gpu_clock_output_parameter_v1_8, pll_fb_mult) - 4usize];
    ["Offset of field: compute_gpu_clock_output_parameter_v1_8::pll_ss_fbsmult"]
        [::core::mem::offset_of!(compute_gpu_clock_output_parameter_v1_8, pll_ss_fbsmult) - 8usize];
    ["Offset of field: compute_gpu_clock_output_parameter_v1_8::pll_ss_slew_frac"][::core::mem::offset_of!(
        compute_gpu_clock_output_parameter_v1_8,
        pll_ss_slew_frac
    ) - 12usize];
    ["Offset of field: compute_gpu_clock_output_parameter_v1_8::pll_ss_enable"]
        [::core::mem::offset_of!(compute_gpu_clock_output_parameter_v1_8, pll_ss_enable) - 14usize];
    ["Offset of field: compute_gpu_clock_output_parameter_v1_8::reserved"]
        [::core::mem::offset_of!(compute_gpu_clock_output_parameter_v1_8, reserved) - 15usize];
    ["Offset of field: compute_gpu_clock_output_parameter_v1_8::reserved1"]
        [::core::mem::offset_of!(compute_gpu_clock_output_parameter_v1_8, reserved1) - 16usize];
};
impl compute_gpu_clock_output_parameter_v1_8 {
    #[inline]
    pub fn gpuclock_10khz(&self) -> u32 {
        unsafe { ::core::mem::transmute(self._bitfield_1.get(0usize, 24u8) as u32) }
    }
    #[inline]
    pub fn set_gpuclock_10khz(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::core::mem::transmute(val);
            self._bitfield_1.set(0usize, 24u8, val as u64)
        }
    }
    #[inline]
    pub unsafe fn gpuclock_10khz_raw(this: *const Self) -> u32 {
        unsafe {
            ::core::mem::transmute(<__BindgenBitfieldUnit<[u8; 4usize]>>::raw_get(
                ::core::ptr::addr_of!((*this)._bitfield_1),
                0usize,
                24u8,
            ) as u32)
        }
    }
    #[inline]
    pub unsafe fn set_gpuclock_10khz_raw(this: *mut Self, val: u32) {
        unsafe {
            let val: u32 = ::core::mem::transmute(val);
            <__BindgenBitfieldUnit<[u8; 4usize]>>::raw_set(
                ::core::ptr::addr_of_mut!((*this)._bitfield_1),
                0usize,
                24u8,
                val as u64,
            )
        }
    }
    #[inline]
    pub fn dfs_did(&self) -> u32 {
        unsafe { ::core::mem::transmute(self._bitfield_1.get(24usize, 8u8) as u32) }
    }
    #[inline]
    pub fn set_dfs_did(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::core::mem::transmute(val);
            self._bitfield_1.set(24usize, 8u8, val as u64)
        }
    }
    #[inline]
    pub unsafe fn dfs_did_raw(this: *const Self) -> u32 {
        unsafe {
            ::core::mem::transmute(<__BindgenBitfieldUnit<[u8; 4usize]>>::raw_get(
                ::core::ptr::addr_of!((*this)._bitfield_1),
                24usize,
                8u8,
            ) as u32)
        }
    }
    #[inline]
    pub unsafe fn set_dfs_did_raw(this: *mut Self, val: u32) {
        unsafe {
            let val: u32 = ::core::mem::transmute(val);
            <__BindgenBitfieldUnit<[u8; 4usize]>>::raw_set(
                ::core::ptr::addr_of_mut!((*this)._bitfield_1),
                24usize,
                8u8,
                val as u64,
            )
        }
    }
    #[inline]
    pub fn new_bitfield_1(
        gpuclock_10khz: u32,
        dfs_did: u32,
    ) -> __BindgenBitfieldUnit<[u8; 4usize]> {
        let mut __bindgen_bitfield_unit: __BindgenBitfieldUnit<[u8; 4usize]> = Default::default();
        __bindgen_bitfield_unit.set(0usize, 24u8, {
            let gpuclock_10khz: u32 = unsafe { ::core::mem::transmute(gpuclock_10khz) };
            gpuclock_10khz as u64
        });
        __bindgen_bitfield_unit.set(24usize, 8u8, {
            let dfs_did: u32 = unsafe { ::core::mem::transmute(dfs_did) };
            dfs_did as u64
        });
        __bindgen_bitfield_unit
    }
}
#[repr(C, packed)]
#[derive(Debug, Copy, Clone)]
pub struct read_efuse_input_parameters_v3_1 {
    pub efuse_start_index: u16,
    pub reserved: u8,
    pub bitslen: u8,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of read_efuse_input_parameters_v3_1"]
        [::core::mem::size_of::<read_efuse_input_parameters_v3_1>() - 4usize];
    ["Alignment of read_efuse_input_parameters_v3_1"]
        [::core::mem::align_of::<read_efuse_input_parameters_v3_1>() - 1usize];
    ["Offset of field: read_efuse_input_parameters_v3_1::efuse_start_index"]
        [::core::mem::offset_of!(read_efuse_input_parameters_v3_1, efuse_start_index) - 0usize];
    ["Offset of field: read_efuse_input_parameters_v3_1::reserved"]
        [::core::mem::offset_of!(read_efuse_input_parameters_v3_1, reserved) - 2usize];
    ["Offset of field: read_efuse_input_parameters_v3_1::bitslen"]
        [::core::mem::offset_of!(read_efuse_input_parameters_v3_1, bitslen) - 3usize];
};
#[repr(C, packed)]
#[derive(Copy, Clone)]
pub union read_efuse_value_parameters_v3_1 {
    pub efuse_info: read_efuse_input_parameters_v3_1,
    pub efusevalue: u32,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of read_efuse_value_parameters_v3_1"]
        [::core::mem::size_of::<read_efuse_value_parameters_v3_1>() - 4usize];
    ["Alignment of read_efuse_value_parameters_v3_1"]
        [::core::mem::align_of::<read_efuse_value_parameters_v3_1>() - 1usize];
    ["Offset of field: read_efuse_value_parameters_v3_1::efuse_info"]
        [::core::mem::offset_of!(read_efuse_value_parameters_v3_1, efuse_info) - 0usize];
    ["Offset of field: read_efuse_value_parameters_v3_1::efusevalue"]
        [::core::mem::offset_of!(read_efuse_value_parameters_v3_1, efusevalue) - 0usize];
};
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct atom_get_smu_clock_info_parameters_v3_1 {
    pub syspll_id: u8,
    pub clk_id: u8,
    pub command: u8,
    pub dfsdid: u8,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of atom_get_smu_clock_info_parameters_v3_1"]
        [::core::mem::size_of::<atom_get_smu_clock_info_parameters_v3_1>() - 4usize];
    ["Alignment of atom_get_smu_clock_info_parameters_v3_1"]
        [::core::mem::align_of::<atom_get_smu_clock_info_parameters_v3_1>() - 1usize];
    ["Offset of field: atom_get_smu_clock_info_parameters_v3_1::syspll_id"]
        [::core::mem::offset_of!(atom_get_smu_clock_info_parameters_v3_1, syspll_id) - 0usize];
    ["Offset of field: atom_get_smu_clock_info_parameters_v3_1::clk_id"]
        [::core::mem::offset_of!(atom_get_smu_clock_info_parameters_v3_1, clk_id) - 1usize];
    ["Offset of field: atom_get_smu_clock_info_parameters_v3_1::command"]
        [::core::mem::offset_of!(atom_get_smu_clock_info_parameters_v3_1, command) - 2usize];
    ["Offset of field: atom_get_smu_clock_info_parameters_v3_1::dfsdid"]
        [::core::mem::offset_of!(atom_get_smu_clock_info_parameters_v3_1, dfsdid) - 3usize];
};
pub const atom_get_smu_clock_info_command_GET_SMU_CLOCK_INFO_V3_1_GET_CLOCK_FREQ:
    atom_get_smu_clock_info_command = 0;
pub const atom_get_smu_clock_info_command_GET_SMU_CLOCK_INFO_V3_1_GET_PLLVCO_FREQ:
    atom_get_smu_clock_info_command = 1;
pub const atom_get_smu_clock_info_command_GET_SMU_CLOCK_INFO_V3_1_GET_PLLREFCLK_FREQ:
    atom_get_smu_clock_info_command = 2;
pub type atom_get_smu_clock_info_command = ::core::ffi::c_uint;
pub const atom_smu9_syspll0_clock_id_SMU9_SYSPLL0_SMNCLK_ID: atom_smu9_syspll0_clock_id = 0;
pub const atom_smu9_syspll0_clock_id_SMU9_SYSPLL0_SOCCLK_ID: atom_smu9_syspll0_clock_id = 1;
pub const atom_smu9_syspll0_clock_id_SMU9_SYSPLL0_MP0CLK_ID: atom_smu9_syspll0_clock_id = 2;
pub const atom_smu9_syspll0_clock_id_SMU9_SYSPLL0_MP1CLK_ID: atom_smu9_syspll0_clock_id = 3;
pub const atom_smu9_syspll0_clock_id_SMU9_SYSPLL0_LCLK_ID: atom_smu9_syspll0_clock_id = 4;
pub const atom_smu9_syspll0_clock_id_SMU9_SYSPLL0_DCLK_ID: atom_smu9_syspll0_clock_id = 5;
pub const atom_smu9_syspll0_clock_id_SMU9_SYSPLL0_VCLK_ID: atom_smu9_syspll0_clock_id = 6;
pub const atom_smu9_syspll0_clock_id_SMU9_SYSPLL0_ECLK_ID: atom_smu9_syspll0_clock_id = 7;
pub const atom_smu9_syspll0_clock_id_SMU9_SYSPLL0_DCEFCLK_ID: atom_smu9_syspll0_clock_id = 8;
pub const atom_smu9_syspll0_clock_id_SMU9_SYSPLL0_DPREFCLK_ID: atom_smu9_syspll0_clock_id = 10;
pub const atom_smu9_syspll0_clock_id_SMU9_SYSPLL0_DISPCLK_ID: atom_smu9_syspll0_clock_id = 11;
pub type atom_smu9_syspll0_clock_id = ::core::ffi::c_uint;
pub const atom_smu11_syspll_id_SMU11_SYSPLL0_ID: atom_smu11_syspll_id = 0;
pub const atom_smu11_syspll_id_SMU11_SYSPLL1_0_ID: atom_smu11_syspll_id = 1;
pub const atom_smu11_syspll_id_SMU11_SYSPLL1_1_ID: atom_smu11_syspll_id = 2;
pub const atom_smu11_syspll_id_SMU11_SYSPLL1_2_ID: atom_smu11_syspll_id = 3;
pub const atom_smu11_syspll_id_SMU11_SYSPLL2_ID: atom_smu11_syspll_id = 4;
pub const atom_smu11_syspll_id_SMU11_SYSPLL3_0_ID: atom_smu11_syspll_id = 5;
pub const atom_smu11_syspll_id_SMU11_SYSPLL3_1_ID: atom_smu11_syspll_id = 6;
pub type atom_smu11_syspll_id = ::core::ffi::c_uint;
pub const atom_smu11_syspll0_clock_id_SMU11_SYSPLL0_ECLK_ID: atom_smu11_syspll0_clock_id = 0;
pub const atom_smu11_syspll0_clock_id_SMU11_SYSPLL0_SOCCLK_ID: atom_smu11_syspll0_clock_id = 1;
pub const atom_smu11_syspll0_clock_id_SMU11_SYSPLL0_MP0CLK_ID: atom_smu11_syspll0_clock_id = 2;
pub const atom_smu11_syspll0_clock_id_SMU11_SYSPLL0_DCLK_ID: atom_smu11_syspll0_clock_id = 3;
pub const atom_smu11_syspll0_clock_id_SMU11_SYSPLL0_VCLK_ID: atom_smu11_syspll0_clock_id = 4;
pub const atom_smu11_syspll0_clock_id_SMU11_SYSPLL0_DCEFCLK_ID: atom_smu11_syspll0_clock_id = 5;
pub type atom_smu11_syspll0_clock_id = ::core::ffi::c_uint;
pub const atom_smu11_syspll1_0_clock_id_SMU11_SYSPLL1_0_UCLKA_ID: atom_smu11_syspll1_0_clock_id = 0;
pub type atom_smu11_syspll1_0_clock_id = ::core::ffi::c_uint;
pub const atom_smu11_syspll1_1_clock_id_SMU11_SYSPLL1_0_UCLKB_ID: atom_smu11_syspll1_1_clock_id = 0;
pub type atom_smu11_syspll1_1_clock_id = ::core::ffi::c_uint;
pub const atom_smu11_syspll1_2_clock_id_SMU11_SYSPLL1_0_FCLK_ID: atom_smu11_syspll1_2_clock_id = 0;
pub type atom_smu11_syspll1_2_clock_id = ::core::ffi::c_uint;
pub const atom_smu11_syspll2_clock_id_SMU11_SYSPLL2_GFXCLK_ID: atom_smu11_syspll2_clock_id = 0;
pub type atom_smu11_syspll2_clock_id = ::core::ffi::c_uint;
pub const atom_smu11_syspll3_0_clock_id_SMU11_SYSPLL3_0_WAFCLK_ID: atom_smu11_syspll3_0_clock_id =
    0;
pub const atom_smu11_syspll3_0_clock_id_SMU11_SYSPLL3_0_DISPCLK_ID: atom_smu11_syspll3_0_clock_id =
    1;
pub const atom_smu11_syspll3_0_clock_id_SMU11_SYSPLL3_0_DPREFCLK_ID: atom_smu11_syspll3_0_clock_id =
    2;
pub type atom_smu11_syspll3_0_clock_id = ::core::ffi::c_uint;
pub const atom_smu11_syspll3_1_clock_id_SMU11_SYSPLL3_1_MP1CLK_ID: atom_smu11_syspll3_1_clock_id =
    0;
pub const atom_smu11_syspll3_1_clock_id_SMU11_SYSPLL3_1_SMNCLK_ID: atom_smu11_syspll3_1_clock_id =
    1;
pub const atom_smu11_syspll3_1_clock_id_SMU11_SYSPLL3_1_LCLK_ID: atom_smu11_syspll3_1_clock_id = 2;
pub type atom_smu11_syspll3_1_clock_id = ::core::ffi::c_uint;
pub const atom_smu12_syspll_id_SMU12_SYSPLL0_ID: atom_smu12_syspll_id = 0;
pub const atom_smu12_syspll_id_SMU12_SYSPLL1_ID: atom_smu12_syspll_id = 1;
pub const atom_smu12_syspll_id_SMU12_SYSPLL2_ID: atom_smu12_syspll_id = 2;
pub const atom_smu12_syspll_id_SMU12_SYSPLL3_0_ID: atom_smu12_syspll_id = 3;
pub const atom_smu12_syspll_id_SMU12_SYSPLL3_1_ID: atom_smu12_syspll_id = 4;
pub type atom_smu12_syspll_id = ::core::ffi::c_uint;
pub const atom_smu12_syspll0_clock_id_SMU12_SYSPLL0_SMNCLK_ID: atom_smu12_syspll0_clock_id = 0;
pub const atom_smu12_syspll0_clock_id_SMU12_SYSPLL0_SOCCLK_ID: atom_smu12_syspll0_clock_id = 1;
pub const atom_smu12_syspll0_clock_id_SMU12_SYSPLL0_MP0CLK_ID: atom_smu12_syspll0_clock_id = 2;
pub const atom_smu12_syspll0_clock_id_SMU12_SYSPLL0_MP1CLK_ID: atom_smu12_syspll0_clock_id = 3;
pub const atom_smu12_syspll0_clock_id_SMU12_SYSPLL0_MP2CLK_ID: atom_smu12_syspll0_clock_id = 4;
pub const atom_smu12_syspll0_clock_id_SMU12_SYSPLL0_VCLK_ID: atom_smu12_syspll0_clock_id = 5;
pub const atom_smu12_syspll0_clock_id_SMU12_SYSPLL0_LCLK_ID: atom_smu12_syspll0_clock_id = 6;
pub const atom_smu12_syspll0_clock_id_SMU12_SYSPLL0_DCLK_ID: atom_smu12_syspll0_clock_id = 7;
pub const atom_smu12_syspll0_clock_id_SMU12_SYSPLL0_ACLK_ID: atom_smu12_syspll0_clock_id = 8;
pub const atom_smu12_syspll0_clock_id_SMU12_SYSPLL0_ISPCLK_ID: atom_smu12_syspll0_clock_id = 9;
pub const atom_smu12_syspll0_clock_id_SMU12_SYSPLL0_SHUBCLK_ID: atom_smu12_syspll0_clock_id = 10;
pub type atom_smu12_syspll0_clock_id = ::core::ffi::c_uint;
pub const atom_smu12_syspll1_clock_id_SMU12_SYSPLL1_DISPCLK_ID: atom_smu12_syspll1_clock_id = 0;
pub const atom_smu12_syspll1_clock_id_SMU12_SYSPLL1_DPPCLK_ID: atom_smu12_syspll1_clock_id = 1;
pub const atom_smu12_syspll1_clock_id_SMU12_SYSPLL1_DPREFCLK_ID: atom_smu12_syspll1_clock_id = 2;
pub const atom_smu12_syspll1_clock_id_SMU12_SYSPLL1_DCFCLK_ID: atom_smu12_syspll1_clock_id = 3;
pub type atom_smu12_syspll1_clock_id = ::core::ffi::c_uint;
pub const atom_smu12_syspll2_clock_id_SMU12_SYSPLL2_Pre_GFXCLK_ID: atom_smu12_syspll2_clock_id = 0;
pub type atom_smu12_syspll2_clock_id = ::core::ffi::c_uint;
pub const atom_smu12_syspll3_0_clock_id_SMU12_SYSPLL3_0_FCLK_ID: atom_smu12_syspll3_0_clock_id = 0;
pub type atom_smu12_syspll3_0_clock_id = ::core::ffi::c_uint;
pub const atom_smu12_syspll3_1_clock_id_SMU12_SYSPLL3_1_UMCCLK_ID: atom_smu12_syspll3_1_clock_id =
    0;
pub type atom_smu12_syspll3_1_clock_id = ::core::ffi::c_uint;
#[repr(C)]
#[derive(Copy, Clone)]
pub struct atom_get_smu_clock_info_output_parameters_v3_1 {
    pub atom_smu_outputclkfreq: atom_get_smu_clock_info_output_parameters_v3_1__bindgen_ty_1,
}
#[repr(C, packed)]
#[derive(Copy, Clone)]
pub union atom_get_smu_clock_info_output_parameters_v3_1__bindgen_ty_1 {
    pub smu_clock_freq_hz: u32,
    pub syspllvcofreq_10khz: u32,
    pub sysspllrefclk_10khz: u32,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of atom_get_smu_clock_info_output_parameters_v3_1__bindgen_ty_1"][::core::mem::size_of::<
        atom_get_smu_clock_info_output_parameters_v3_1__bindgen_ty_1,
    >() - 4usize];
    ["Alignment of atom_get_smu_clock_info_output_parameters_v3_1__bindgen_ty_1"]
        [::core::mem::align_of::<atom_get_smu_clock_info_output_parameters_v3_1__bindgen_ty_1>()
            - 1usize];
    ["Offset of field: atom_get_smu_clock_info_output_parameters_v3_1__bindgen_ty_1::smu_clock_freq_hz"] [:: core :: mem :: offset_of ! (atom_get_smu_clock_info_output_parameters_v3_1__bindgen_ty_1 , smu_clock_freq_hz) - 0usize] ;
    ["Offset of field: atom_get_smu_clock_info_output_parameters_v3_1__bindgen_ty_1::syspllvcofreq_10khz"] [:: core :: mem :: offset_of ! (atom_get_smu_clock_info_output_parameters_v3_1__bindgen_ty_1 , syspllvcofreq_10khz) - 0usize] ;
    ["Offset of field: atom_get_smu_clock_info_output_parameters_v3_1__bindgen_ty_1::sysspllrefclk_10khz"] [:: core :: mem :: offset_of ! (atom_get_smu_clock_info_output_parameters_v3_1__bindgen_ty_1 , sysspllrefclk_10khz) - 0usize] ;
};
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of atom_get_smu_clock_info_output_parameters_v3_1"]
        [::core::mem::size_of::<atom_get_smu_clock_info_output_parameters_v3_1>() - 4usize];
    ["Alignment of atom_get_smu_clock_info_output_parameters_v3_1"]
        [::core::mem::align_of::<atom_get_smu_clock_info_output_parameters_v3_1>() - 1usize];
    ["Offset of field: atom_get_smu_clock_info_output_parameters_v3_1::atom_smu_outputclkfreq"][::core::mem::offset_of!(
        atom_get_smu_clock_info_output_parameters_v3_1,
        atom_smu_outputclkfreq
    )
        - 0usize];
};
pub const atom_dynamic_memory_setting_command_COMPUTE_MEMORY_PLL_PARAM:
    atom_dynamic_memory_setting_command = 1;
pub const atom_dynamic_memory_setting_command_COMPUTE_ENGINE_PLL_PARAM:
    atom_dynamic_memory_setting_command = 2;
pub const atom_dynamic_memory_setting_command_ADJUST_MC_SETTING_PARAM:
    atom_dynamic_memory_setting_command = 3;
pub type atom_dynamic_memory_setting_command = ::core::ffi::c_uint;
#[repr(C, packed)]
#[derive(Debug, Copy, Clone)]
pub struct dynamic_mclk_settings_parameters_v2_1 {
    pub _bitfield_align_1: [u8; 0],
    pub _bitfield_1: __BindgenBitfieldUnit<[u8; 4usize]>,
    pub reserved: u32,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of dynamic_mclk_settings_parameters_v2_1"]
        [::core::mem::size_of::<dynamic_mclk_settings_parameters_v2_1>() - 8usize];
    ["Alignment of dynamic_mclk_settings_parameters_v2_1"]
        [::core::mem::align_of::<dynamic_mclk_settings_parameters_v2_1>() - 1usize];
    ["Offset of field: dynamic_mclk_settings_parameters_v2_1::reserved"]
        [::core::mem::offset_of!(dynamic_mclk_settings_parameters_v2_1, reserved) - 4usize];
};
impl dynamic_mclk_settings_parameters_v2_1 {
    #[inline]
    pub fn mclk_10khz(&self) -> u32 {
        unsafe { ::core::mem::transmute(self._bitfield_1.get(0usize, 24u8) as u32) }
    }
    #[inline]
    pub fn set_mclk_10khz(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::core::mem::transmute(val);
            self._bitfield_1.set(0usize, 24u8, val as u64)
        }
    }
    #[inline]
    pub unsafe fn mclk_10khz_raw(this: *const Self) -> u32 {
        unsafe {
            ::core::mem::transmute(<__BindgenBitfieldUnit<[u8; 4usize]>>::raw_get(
                ::core::ptr::addr_of!((*this)._bitfield_1),
                0usize,
                24u8,
            ) as u32)
        }
    }
    #[inline]
    pub unsafe fn set_mclk_10khz_raw(this: *mut Self, val: u32) {
        unsafe {
            let val: u32 = ::core::mem::transmute(val);
            <__BindgenBitfieldUnit<[u8; 4usize]>>::raw_set(
                ::core::ptr::addr_of_mut!((*this)._bitfield_1),
                0usize,
                24u8,
                val as u64,
            )
        }
    }
    #[inline]
    pub fn command(&self) -> u32 {
        unsafe { ::core::mem::transmute(self._bitfield_1.get(24usize, 8u8) as u32) }
    }
    #[inline]
    pub fn set_command(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::core::mem::transmute(val);
            self._bitfield_1.set(24usize, 8u8, val as u64)
        }
    }
    #[inline]
    pub unsafe fn command_raw(this: *const Self) -> u32 {
        unsafe {
            ::core::mem::transmute(<__BindgenBitfieldUnit<[u8; 4usize]>>::raw_get(
                ::core::ptr::addr_of!((*this)._bitfield_1),
                24usize,
                8u8,
            ) as u32)
        }
    }
    #[inline]
    pub unsafe fn set_command_raw(this: *mut Self, val: u32) {
        unsafe {
            let val: u32 = ::core::mem::transmute(val);
            <__BindgenBitfieldUnit<[u8; 4usize]>>::raw_set(
                ::core::ptr::addr_of_mut!((*this)._bitfield_1),
                24usize,
                8u8,
                val as u64,
            )
        }
    }
    #[inline]
    pub fn new_bitfield_1(mclk_10khz: u32, command: u32) -> __BindgenBitfieldUnit<[u8; 4usize]> {
        let mut __bindgen_bitfield_unit: __BindgenBitfieldUnit<[u8; 4usize]> = Default::default();
        __bindgen_bitfield_unit.set(0usize, 24u8, {
            let mclk_10khz: u32 = unsafe { ::core::mem::transmute(mclk_10khz) };
            mclk_10khz as u64
        });
        __bindgen_bitfield_unit.set(24usize, 8u8, {
            let command: u32 = unsafe { ::core::mem::transmute(command) };
            command as u64
        });
        __bindgen_bitfield_unit
    }
}
#[repr(C, packed)]
#[derive(Debug, Copy, Clone)]
pub struct dynamic_sclk_settings_parameters_v2_1 {
    pub _bitfield_align_1: [u8; 0],
    pub _bitfield_1: __BindgenBitfieldUnit<[u8; 4usize]>,
    pub mclk_10khz: u32,
    pub reserved: u32,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of dynamic_sclk_settings_parameters_v2_1"]
        [::core::mem::size_of::<dynamic_sclk_settings_parameters_v2_1>() - 12usize];
    ["Alignment of dynamic_sclk_settings_parameters_v2_1"]
        [::core::mem::align_of::<dynamic_sclk_settings_parameters_v2_1>() - 1usize];
    ["Offset of field: dynamic_sclk_settings_parameters_v2_1::mclk_10khz"]
        [::core::mem::offset_of!(dynamic_sclk_settings_parameters_v2_1, mclk_10khz) - 4usize];
    ["Offset of field: dynamic_sclk_settings_parameters_v2_1::reserved"]
        [::core::mem::offset_of!(dynamic_sclk_settings_parameters_v2_1, reserved) - 8usize];
};
impl dynamic_sclk_settings_parameters_v2_1 {
    #[inline]
    pub fn sclk_10khz(&self) -> u32 {
        unsafe { ::core::mem::transmute(self._bitfield_1.get(0usize, 24u8) as u32) }
    }
    #[inline]
    pub fn set_sclk_10khz(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::core::mem::transmute(val);
            self._bitfield_1.set(0usize, 24u8, val as u64)
        }
    }
    #[inline]
    pub unsafe fn sclk_10khz_raw(this: *const Self) -> u32 {
        unsafe {
            ::core::mem::transmute(<__BindgenBitfieldUnit<[u8; 4usize]>>::raw_get(
                ::core::ptr::addr_of!((*this)._bitfield_1),
                0usize,
                24u8,
            ) as u32)
        }
    }
    #[inline]
    pub unsafe fn set_sclk_10khz_raw(this: *mut Self, val: u32) {
        unsafe {
            let val: u32 = ::core::mem::transmute(val);
            <__BindgenBitfieldUnit<[u8; 4usize]>>::raw_set(
                ::core::ptr::addr_of_mut!((*this)._bitfield_1),
                0usize,
                24u8,
                val as u64,
            )
        }
    }
    #[inline]
    pub fn command(&self) -> u32 {
        unsafe { ::core::mem::transmute(self._bitfield_1.get(24usize, 8u8) as u32) }
    }
    #[inline]
    pub fn set_command(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::core::mem::transmute(val);
            self._bitfield_1.set(24usize, 8u8, val as u64)
        }
    }
    #[inline]
    pub unsafe fn command_raw(this: *const Self) -> u32 {
        unsafe {
            ::core::mem::transmute(<__BindgenBitfieldUnit<[u8; 4usize]>>::raw_get(
                ::core::ptr::addr_of!((*this)._bitfield_1),
                24usize,
                8u8,
            ) as u32)
        }
    }
    #[inline]
    pub unsafe fn set_command_raw(this: *mut Self, val: u32) {
        unsafe {
            let val: u32 = ::core::mem::transmute(val);
            <__BindgenBitfieldUnit<[u8; 4usize]>>::raw_set(
                ::core::ptr::addr_of_mut!((*this)._bitfield_1),
                24usize,
                8u8,
                val as u64,
            )
        }
    }
    #[inline]
    pub fn new_bitfield_1(sclk_10khz: u32, command: u32) -> __BindgenBitfieldUnit<[u8; 4usize]> {
        let mut __bindgen_bitfield_unit: __BindgenBitfieldUnit<[u8; 4usize]> = Default::default();
        __bindgen_bitfield_unit.set(0usize, 24u8, {
            let sclk_10khz: u32 = unsafe { ::core::mem::transmute(sclk_10khz) };
            sclk_10khz as u64
        });
        __bindgen_bitfield_unit.set(24usize, 8u8, {
            let command: u32 = unsafe { ::core::mem::transmute(command) };
            command as u64
        });
        __bindgen_bitfield_unit
    }
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union dynamic_memory_settings_parameters_v2_1 {
    pub mclk_setting: dynamic_mclk_settings_parameters_v2_1,
    pub sclk_setting: dynamic_sclk_settings_parameters_v2_1,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of dynamic_memory_settings_parameters_v2_1"]
        [::core::mem::size_of::<dynamic_memory_settings_parameters_v2_1>() - 12usize];
    ["Alignment of dynamic_memory_settings_parameters_v2_1"]
        [::core::mem::align_of::<dynamic_memory_settings_parameters_v2_1>() - 1usize];
    ["Offset of field: dynamic_memory_settings_parameters_v2_1::mclk_setting"]
        [::core::mem::offset_of!(dynamic_memory_settings_parameters_v2_1, mclk_setting) - 0usize];
    ["Offset of field: dynamic_memory_settings_parameters_v2_1::sclk_setting"]
        [::core::mem::offset_of!(dynamic_memory_settings_parameters_v2_1, sclk_setting) - 0usize];
};
pub const atom_umc6_0_ucode_function_call_enum_id_UMC60_UCODE_FUNC_ID_REINIT:
    atom_umc6_0_ucode_function_call_enum_id = 0;
pub const atom_umc6_0_ucode_function_call_enum_id_UMC60_UCODE_FUNC_ID_ENTER_SELFREFRESH:
    atom_umc6_0_ucode_function_call_enum_id = 1;
pub const atom_umc6_0_ucode_function_call_enum_id_UMC60_UCODE_FUNC_ID_EXIT_SELFREFRESH:
    atom_umc6_0_ucode_function_call_enum_id = 2;
pub type atom_umc6_0_ucode_function_call_enum_id = ::core::ffi::c_uint;
#[repr(C, packed)]
#[derive(Debug, Copy, Clone)]
pub struct memory_training_parameters_v2_1 {
    pub ucode_func_id: u8,
    pub ucode_reserved: [u8; 3usize],
    pub reserved: [u32; 5usize],
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of memory_training_parameters_v2_1"]
        [::core::mem::size_of::<memory_training_parameters_v2_1>() - 24usize];
    ["Alignment of memory_training_parameters_v2_1"]
        [::core::mem::align_of::<memory_training_parameters_v2_1>() - 1usize];
    ["Offset of field: memory_training_parameters_v2_1::ucode_func_id"]
        [::core::mem::offset_of!(memory_training_parameters_v2_1, ucode_func_id) - 0usize];
    ["Offset of field: memory_training_parameters_v2_1::ucode_reserved"]
        [::core::mem::offset_of!(memory_training_parameters_v2_1, ucode_reserved) - 1usize];
    ["Offset of field: memory_training_parameters_v2_1::reserved"]
        [::core::mem::offset_of!(memory_training_parameters_v2_1, reserved) - 4usize];
};
#[repr(C, packed)]
#[derive(Debug, Copy, Clone)]
pub struct set_pixel_clock_parameter_v1_7 {
    pub pixclk_100hz: u32,
    pub pll_id: u8,
    pub encoderobjid: u8,
    pub encoder_mode: u8,
    pub miscinfo: u8,
    pub crtc_id: u8,
    pub deep_color_ratio: u8,
    pub reserved1: [u8; 2usize],
    pub reserved2: u32,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of set_pixel_clock_parameter_v1_7"]
        [::core::mem::size_of::<set_pixel_clock_parameter_v1_7>() - 16usize];
    ["Alignment of set_pixel_clock_parameter_v1_7"]
        [::core::mem::align_of::<set_pixel_clock_parameter_v1_7>() - 1usize];
    ["Offset of field: set_pixel_clock_parameter_v1_7::pixclk_100hz"]
        [::core::mem::offset_of!(set_pixel_clock_parameter_v1_7, pixclk_100hz) - 0usize];
    ["Offset of field: set_pixel_clock_parameter_v1_7::pll_id"]
        [::core::mem::offset_of!(set_pixel_clock_parameter_v1_7, pll_id) - 4usize];
    ["Offset of field: set_pixel_clock_parameter_v1_7::encoderobjid"]
        [::core::mem::offset_of!(set_pixel_clock_parameter_v1_7, encoderobjid) - 5usize];
    ["Offset of field: set_pixel_clock_parameter_v1_7::encoder_mode"]
        [::core::mem::offset_of!(set_pixel_clock_parameter_v1_7, encoder_mode) - 6usize];
    ["Offset of field: set_pixel_clock_parameter_v1_7::miscinfo"]
        [::core::mem::offset_of!(set_pixel_clock_parameter_v1_7, miscinfo) - 7usize];
    ["Offset of field: set_pixel_clock_parameter_v1_7::crtc_id"]
        [::core::mem::offset_of!(set_pixel_clock_parameter_v1_7, crtc_id) - 8usize];
    ["Offset of field: set_pixel_clock_parameter_v1_7::deep_color_ratio"]
        [::core::mem::offset_of!(set_pixel_clock_parameter_v1_7, deep_color_ratio) - 9usize];
    ["Offset of field: set_pixel_clock_parameter_v1_7::reserved1"]
        [::core::mem::offset_of!(set_pixel_clock_parameter_v1_7, reserved1) - 10usize];
    ["Offset of field: set_pixel_clock_parameter_v1_7::reserved2"]
        [::core::mem::offset_of!(set_pixel_clock_parameter_v1_7, reserved2) - 12usize];
};
pub const atom_set_pixel_clock_v1_7_misc_info_PIXEL_CLOCK_V7_MISC_FORCE_PROG_PPLL:
    atom_set_pixel_clock_v1_7_misc_info = 1;
pub const atom_set_pixel_clock_v1_7_misc_info_PIXEL_CLOCK_V7_MISC_PROG_PHYPLL:
    atom_set_pixel_clock_v1_7_misc_info = 2;
pub const atom_set_pixel_clock_v1_7_misc_info_PIXEL_CLOCK_V7_MISC_YUV420_MODE:
    atom_set_pixel_clock_v1_7_misc_info = 4;
pub const atom_set_pixel_clock_v1_7_misc_info_PIXEL_CLOCK_V7_MISC_DVI_DUALLINK_EN:
    atom_set_pixel_clock_v1_7_misc_info = 8;
pub const atom_set_pixel_clock_v1_7_misc_info_PIXEL_CLOCK_V7_MISC_REF_DIV_SRC:
    atom_set_pixel_clock_v1_7_misc_info = 48;
pub const atom_set_pixel_clock_v1_7_misc_info_PIXEL_CLOCK_V7_MISC_REF_DIV_SRC_XTALIN:
    atom_set_pixel_clock_v1_7_misc_info = 0;
pub const atom_set_pixel_clock_v1_7_misc_info_PIXEL_CLOCK_V7_MISC_REF_DIV_SRC_PCIE:
    atom_set_pixel_clock_v1_7_misc_info = 16;
pub const atom_set_pixel_clock_v1_7_misc_info_PIXEL_CLOCK_V7_MISC_REF_DIV_SRC_GENLK:
    atom_set_pixel_clock_v1_7_misc_info = 32;
pub const atom_set_pixel_clock_v1_7_misc_info_PIXEL_CLOCK_V7_MISC_REF_DIV_SRC_REFPAD:
    atom_set_pixel_clock_v1_7_misc_info = 48;
pub const atom_set_pixel_clock_v1_7_misc_info_PIXEL_CLOCK_V7_MISC_ATOMIC_UPDATE:
    atom_set_pixel_clock_v1_7_misc_info = 64;
pub const atom_set_pixel_clock_v1_7_misc_info_PIXEL_CLOCK_V7_MISC_FORCE_SS_DIS:
    atom_set_pixel_clock_v1_7_misc_info = 128;
pub type atom_set_pixel_clock_v1_7_misc_info = ::core::ffi::c_uint;
pub const atom_set_pixel_clock_v1_7_deepcolor_ratio_PIXEL_CLOCK_V7_DEEPCOLOR_RATIO_DIS:
    atom_set_pixel_clock_v1_7_deepcolor_ratio = 0;
pub const atom_set_pixel_clock_v1_7_deepcolor_ratio_PIXEL_CLOCK_V7_DEEPCOLOR_RATIO_5_4:
    atom_set_pixel_clock_v1_7_deepcolor_ratio = 1;
pub const atom_set_pixel_clock_v1_7_deepcolor_ratio_PIXEL_CLOCK_V7_DEEPCOLOR_RATIO_3_2:
    atom_set_pixel_clock_v1_7_deepcolor_ratio = 2;
pub const atom_set_pixel_clock_v1_7_deepcolor_ratio_PIXEL_CLOCK_V7_DEEPCOLOR_RATIO_2_1:
    atom_set_pixel_clock_v1_7_deepcolor_ratio = 3;
pub type atom_set_pixel_clock_v1_7_deepcolor_ratio = ::core::ffi::c_uint;
#[repr(C, packed)]
#[derive(Debug, Copy, Clone)]
pub struct set_dce_clock_parameters_v2_1 {
    pub dceclk_10khz: u32,
    pub dceclktype: u8,
    pub dceclksrc: u8,
    pub dceclkflag: u8,
    pub crtc_id: u8,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of set_dce_clock_parameters_v2_1"]
        [::core::mem::size_of::<set_dce_clock_parameters_v2_1>() - 8usize];
    ["Alignment of set_dce_clock_parameters_v2_1"]
        [::core::mem::align_of::<set_dce_clock_parameters_v2_1>() - 1usize];
    ["Offset of field: set_dce_clock_parameters_v2_1::dceclk_10khz"]
        [::core::mem::offset_of!(set_dce_clock_parameters_v2_1, dceclk_10khz) - 0usize];
    ["Offset of field: set_dce_clock_parameters_v2_1::dceclktype"]
        [::core::mem::offset_of!(set_dce_clock_parameters_v2_1, dceclktype) - 4usize];
    ["Offset of field: set_dce_clock_parameters_v2_1::dceclksrc"]
        [::core::mem::offset_of!(set_dce_clock_parameters_v2_1, dceclksrc) - 5usize];
    ["Offset of field: set_dce_clock_parameters_v2_1::dceclkflag"]
        [::core::mem::offset_of!(set_dce_clock_parameters_v2_1, dceclkflag) - 6usize];
    ["Offset of field: set_dce_clock_parameters_v2_1::crtc_id"]
        [::core::mem::offset_of!(set_dce_clock_parameters_v2_1, crtc_id) - 7usize];
};
pub const atom_set_dce_clock_clock_type_DCE_CLOCK_TYPE_DISPCLK: atom_set_dce_clock_clock_type = 0;
pub const atom_set_dce_clock_clock_type_DCE_CLOCK_TYPE_DPREFCLK: atom_set_dce_clock_clock_type = 1;
pub const atom_set_dce_clock_clock_type_DCE_CLOCK_TYPE_PIXELCLK: atom_set_dce_clock_clock_type = 2;
pub type atom_set_dce_clock_clock_type = ::core::ffi::c_uint;
pub const atom_set_dce_clock_dprefclk_flag_DCE_CLOCK_FLAG_PLL_REFCLK_SRC_MASK:
    atom_set_dce_clock_dprefclk_flag = 3;
pub const atom_set_dce_clock_dprefclk_flag_DCE_CLOCK_FLAG_PLL_REFCLK_SRC_GENERICA:
    atom_set_dce_clock_dprefclk_flag = 0;
pub const atom_set_dce_clock_dprefclk_flag_DCE_CLOCK_FLAG_PLL_REFCLK_SRC_GENLK:
    atom_set_dce_clock_dprefclk_flag = 1;
pub const atom_set_dce_clock_dprefclk_flag_DCE_CLOCK_FLAG_PLL_REFCLK_SRC_PCIE:
    atom_set_dce_clock_dprefclk_flag = 2;
pub const atom_set_dce_clock_dprefclk_flag_DCE_CLOCK_FLAG_PLL_REFCLK_SRC_XTALIN:
    atom_set_dce_clock_dprefclk_flag = 3;
pub type atom_set_dce_clock_dprefclk_flag = ::core::ffi::c_uint;
pub const atom_set_dce_clock_pixclk_flag_DCE_CLOCK_FLAG_PCLK_DEEPCOLOR_RATIO_MASK:
    atom_set_dce_clock_pixclk_flag = 3;
pub const atom_set_dce_clock_pixclk_flag_DCE_CLOCK_FLAG_PCLK_DEEPCOLOR_RATIO_DIS:
    atom_set_dce_clock_pixclk_flag = 0;
pub const atom_set_dce_clock_pixclk_flag_DCE_CLOCK_FLAG_PCLK_DEEPCOLOR_RATIO_5_4:
    atom_set_dce_clock_pixclk_flag = 1;
pub const atom_set_dce_clock_pixclk_flag_DCE_CLOCK_FLAG_PCLK_DEEPCOLOR_RATIO_3_2:
    atom_set_dce_clock_pixclk_flag = 2;
pub const atom_set_dce_clock_pixclk_flag_DCE_CLOCK_FLAG_PCLK_DEEPCOLOR_RATIO_2_1:
    atom_set_dce_clock_pixclk_flag = 3;
pub const atom_set_dce_clock_pixclk_flag_DCE_CLOCK_FLAG_PIXCLK_YUV420_MODE:
    atom_set_dce_clock_pixclk_flag = 4;
pub type atom_set_dce_clock_pixclk_flag = ::core::ffi::c_uint;
#[repr(C, packed)]
#[derive(Debug, Copy, Clone)]
pub struct set_dce_clock_ps_allocation_v2_1 {
    pub param: set_dce_clock_parameters_v2_1,
    pub ulReserved: [u32; 2usize],
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of set_dce_clock_ps_allocation_v2_1"]
        [::core::mem::size_of::<set_dce_clock_ps_allocation_v2_1>() - 16usize];
    ["Alignment of set_dce_clock_ps_allocation_v2_1"]
        [::core::mem::align_of::<set_dce_clock_ps_allocation_v2_1>() - 1usize];
    ["Offset of field: set_dce_clock_ps_allocation_v2_1::param"]
        [::core::mem::offset_of!(set_dce_clock_ps_allocation_v2_1, param) - 0usize];
    ["Offset of field: set_dce_clock_ps_allocation_v2_1::ulReserved"]
        [::core::mem::offset_of!(set_dce_clock_ps_allocation_v2_1, ulReserved) - 8usize];
};
#[repr(C, packed)]
#[derive(Debug, Copy, Clone)]
pub struct blank_crtc_parameters {
    pub crtc_id: u8,
    pub blanking: u8,
    pub reserved: u16,
    pub reserved1: u32,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of blank_crtc_parameters"][::core::mem::size_of::<blank_crtc_parameters>() - 8usize];
    ["Alignment of blank_crtc_parameters"]
        [::core::mem::align_of::<blank_crtc_parameters>() - 1usize];
    ["Offset of field: blank_crtc_parameters::crtc_id"]
        [::core::mem::offset_of!(blank_crtc_parameters, crtc_id) - 0usize];
    ["Offset of field: blank_crtc_parameters::blanking"]
        [::core::mem::offset_of!(blank_crtc_parameters, blanking) - 1usize];
    ["Offset of field: blank_crtc_parameters::reserved"]
        [::core::mem::offset_of!(blank_crtc_parameters, reserved) - 2usize];
    ["Offset of field: blank_crtc_parameters::reserved1"]
        [::core::mem::offset_of!(blank_crtc_parameters, reserved1) - 4usize];
};
pub const atom_blank_crtc_command_ATOM_BLANKING: atom_blank_crtc_command = 1;
pub const atom_blank_crtc_command_ATOM_BLANKING_OFF: atom_blank_crtc_command = 0;
pub type atom_blank_crtc_command = ::core::ffi::c_uint;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct enable_crtc_parameters {
    pub crtc_id: u8,
    pub enable: u8,
    pub padding: [u8; 2usize],
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of enable_crtc_parameters"][::core::mem::size_of::<enable_crtc_parameters>() - 4usize];
    ["Alignment of enable_crtc_parameters"]
        [::core::mem::align_of::<enable_crtc_parameters>() - 1usize];
    ["Offset of field: enable_crtc_parameters::crtc_id"]
        [::core::mem::offset_of!(enable_crtc_parameters, crtc_id) - 0usize];
    ["Offset of field: enable_crtc_parameters::enable"]
        [::core::mem::offset_of!(enable_crtc_parameters, enable) - 1usize];
    ["Offset of field: enable_crtc_parameters::padding"]
        [::core::mem::offset_of!(enable_crtc_parameters, padding) - 2usize];
};
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct enable_disp_power_gating_parameters_v2_1 {
    pub disp_pipe_id: u8,
    pub enable: u8,
    pub padding: [u8; 2usize],
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of enable_disp_power_gating_parameters_v2_1"]
        [::core::mem::size_of::<enable_disp_power_gating_parameters_v2_1>() - 4usize];
    ["Alignment of enable_disp_power_gating_parameters_v2_1"]
        [::core::mem::align_of::<enable_disp_power_gating_parameters_v2_1>() - 1usize];
    ["Offset of field: enable_disp_power_gating_parameters_v2_1::disp_pipe_id"]
        [::core::mem::offset_of!(enable_disp_power_gating_parameters_v2_1, disp_pipe_id) - 0usize];
    ["Offset of field: enable_disp_power_gating_parameters_v2_1::enable"]
        [::core::mem::offset_of!(enable_disp_power_gating_parameters_v2_1, enable) - 1usize];
    ["Offset of field: enable_disp_power_gating_parameters_v2_1::padding"]
        [::core::mem::offset_of!(enable_disp_power_gating_parameters_v2_1, padding) - 2usize];
};
#[repr(C, packed)]
#[derive(Debug, Copy, Clone)]
pub struct enable_disp_power_gating_ps_allocation {
    pub param: enable_disp_power_gating_parameters_v2_1,
    pub ulReserved: [u32; 4usize],
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of enable_disp_power_gating_ps_allocation"]
        [::core::mem::size_of::<enable_disp_power_gating_ps_allocation>() - 20usize];
    ["Alignment of enable_disp_power_gating_ps_allocation"]
        [::core::mem::align_of::<enable_disp_power_gating_ps_allocation>() - 1usize];
    ["Offset of field: enable_disp_power_gating_ps_allocation::param"]
        [::core::mem::offset_of!(enable_disp_power_gating_ps_allocation, param) - 0usize];
    ["Offset of field: enable_disp_power_gating_ps_allocation::ulReserved"]
        [::core::mem::offset_of!(enable_disp_power_gating_ps_allocation, ulReserved) - 4usize];
};
#[repr(C, packed)]
#[derive(Debug, Copy, Clone)]
pub struct set_crtc_using_dtd_timing_parameters {
    pub h_size: u16,
    pub h_blanking_time: u16,
    pub v_size: u16,
    pub v_blanking_time: u16,
    pub h_syncoffset: u16,
    pub h_syncwidth: u16,
    pub v_syncoffset: u16,
    pub v_syncwidth: u16,
    pub modemiscinfo: u16,
    pub h_border: u8,
    pub v_border: u8,
    pub crtc_id: u8,
    pub encoder_mode: u8,
    pub padding: [u8; 2usize],
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of set_crtc_using_dtd_timing_parameters"]
        [::core::mem::size_of::<set_crtc_using_dtd_timing_parameters>() - 24usize];
    ["Alignment of set_crtc_using_dtd_timing_parameters"]
        [::core::mem::align_of::<set_crtc_using_dtd_timing_parameters>() - 1usize];
    ["Offset of field: set_crtc_using_dtd_timing_parameters::h_size"]
        [::core::mem::offset_of!(set_crtc_using_dtd_timing_parameters, h_size) - 0usize];
    ["Offset of field: set_crtc_using_dtd_timing_parameters::h_blanking_time"]
        [::core::mem::offset_of!(set_crtc_using_dtd_timing_parameters, h_blanking_time) - 2usize];
    ["Offset of field: set_crtc_using_dtd_timing_parameters::v_size"]
        [::core::mem::offset_of!(set_crtc_using_dtd_timing_parameters, v_size) - 4usize];
    ["Offset of field: set_crtc_using_dtd_timing_parameters::v_blanking_time"]
        [::core::mem::offset_of!(set_crtc_using_dtd_timing_parameters, v_blanking_time) - 6usize];
    ["Offset of field: set_crtc_using_dtd_timing_parameters::h_syncoffset"]
        [::core::mem::offset_of!(set_crtc_using_dtd_timing_parameters, h_syncoffset) - 8usize];
    ["Offset of field: set_crtc_using_dtd_timing_parameters::h_syncwidth"]
        [::core::mem::offset_of!(set_crtc_using_dtd_timing_parameters, h_syncwidth) - 10usize];
    ["Offset of field: set_crtc_using_dtd_timing_parameters::v_syncoffset"]
        [::core::mem::offset_of!(set_crtc_using_dtd_timing_parameters, v_syncoffset) - 12usize];
    ["Offset of field: set_crtc_using_dtd_timing_parameters::v_syncwidth"]
        [::core::mem::offset_of!(set_crtc_using_dtd_timing_parameters, v_syncwidth) - 14usize];
    ["Offset of field: set_crtc_using_dtd_timing_parameters::modemiscinfo"]
        [::core::mem::offset_of!(set_crtc_using_dtd_timing_parameters, modemiscinfo) - 16usize];
    ["Offset of field: set_crtc_using_dtd_timing_parameters::h_border"]
        [::core::mem::offset_of!(set_crtc_using_dtd_timing_parameters, h_border) - 18usize];
    ["Offset of field: set_crtc_using_dtd_timing_parameters::v_border"]
        [::core::mem::offset_of!(set_crtc_using_dtd_timing_parameters, v_border) - 19usize];
    ["Offset of field: set_crtc_using_dtd_timing_parameters::crtc_id"]
        [::core::mem::offset_of!(set_crtc_using_dtd_timing_parameters, crtc_id) - 20usize];
    ["Offset of field: set_crtc_using_dtd_timing_parameters::encoder_mode"]
        [::core::mem::offset_of!(set_crtc_using_dtd_timing_parameters, encoder_mode) - 21usize];
    ["Offset of field: set_crtc_using_dtd_timing_parameters::padding"]
        [::core::mem::offset_of!(set_crtc_using_dtd_timing_parameters, padding) - 22usize];
};
#[repr(C, packed)]
#[derive(Copy, Clone)]
pub struct process_i2c_channel_transaction_parameters {
    pub i2cspeed_khz: u8,
    pub regind_status: process_i2c_channel_transaction_parameters__bindgen_ty_1,
    pub i2c_data_out: u16,
    pub flag: u8,
    pub trans_bytes: u8,
    pub slave_addr: u8,
    pub i2c_id: u8,
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union process_i2c_channel_transaction_parameters__bindgen_ty_1 {
    pub regindex: u8,
    pub status: u8,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of process_i2c_channel_transaction_parameters__bindgen_ty_1"][::core::mem::size_of::<
        process_i2c_channel_transaction_parameters__bindgen_ty_1,
    >() - 1usize];
    ["Alignment of process_i2c_channel_transaction_parameters__bindgen_ty_1"][::core::mem::align_of::<
        process_i2c_channel_transaction_parameters__bindgen_ty_1,
    >() - 1usize];
    ["Offset of field: process_i2c_channel_transaction_parameters__bindgen_ty_1::regindex"][::core::mem::offset_of!(
        process_i2c_channel_transaction_parameters__bindgen_ty_1,
        regindex
    )
        - 0usize];
    ["Offset of field: process_i2c_channel_transaction_parameters__bindgen_ty_1::status"][::core::mem::offset_of!(
        process_i2c_channel_transaction_parameters__bindgen_ty_1,
        status
    )
        - 0usize];
};
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of process_i2c_channel_transaction_parameters"]
        [::core::mem::size_of::<process_i2c_channel_transaction_parameters>() - 8usize];
    ["Alignment of process_i2c_channel_transaction_parameters"]
        [::core::mem::align_of::<process_i2c_channel_transaction_parameters>() - 1usize];
    ["Offset of field: process_i2c_channel_transaction_parameters::i2cspeed_khz"][::core::mem::offset_of!(
        process_i2c_channel_transaction_parameters,
        i2cspeed_khz
    ) - 0usize];
    ["Offset of field: process_i2c_channel_transaction_parameters::regind_status"][::core::mem::offset_of!(
        process_i2c_channel_transaction_parameters,
        regind_status
    ) - 1usize];
    ["Offset of field: process_i2c_channel_transaction_parameters::i2c_data_out"][::core::mem::offset_of!(
        process_i2c_channel_transaction_parameters,
        i2c_data_out
    ) - 2usize];
    ["Offset of field: process_i2c_channel_transaction_parameters::flag"]
        [::core::mem::offset_of!(process_i2c_channel_transaction_parameters, flag) - 4usize];
    ["Offset of field: process_i2c_channel_transaction_parameters::trans_bytes"]
        [::core::mem::offset_of!(process_i2c_channel_transaction_parameters, trans_bytes) - 5usize];
    ["Offset of field: process_i2c_channel_transaction_parameters::slave_addr"]
        [::core::mem::offset_of!(process_i2c_channel_transaction_parameters, slave_addr) - 6usize];
    ["Offset of field: process_i2c_channel_transaction_parameters::i2c_id"]
        [::core::mem::offset_of!(process_i2c_channel_transaction_parameters, i2c_id) - 7usize];
};
pub const atom_process_i2c_flag_HW_I2C_WRITE: atom_process_i2c_flag = 1;
pub const atom_process_i2c_flag_HW_I2C_READ: atom_process_i2c_flag = 0;
pub const atom_process_i2c_flag_I2C_2BYTE_ADDR: atom_process_i2c_flag = 2;
pub const atom_process_i2c_flag_HW_I2C_SMBUS_BYTE_WR: atom_process_i2c_flag = 4;
pub type atom_process_i2c_flag = ::core::ffi::c_uint;
pub const atom_process_i2c_status_HW_ASSISTED_I2C_STATUS_FAILURE: atom_process_i2c_status = 2;
pub const atom_process_i2c_status_HW_ASSISTED_I2C_STATUS_SUCCESS: atom_process_i2c_status = 1;
pub type atom_process_i2c_status = ::core::ffi::c_uint;
#[repr(C, packed)]
#[derive(Copy, Clone)]
pub struct process_aux_channel_transaction_parameters_v1_2 {
    pub aux_request: u16,
    pub dataout: u16,
    pub channelid: u8,
    pub aux_status_delay: process_aux_channel_transaction_parameters_v1_2__bindgen_ty_1,
    pub dataout_len: u8,
    pub hpd_id: u8,
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union process_aux_channel_transaction_parameters_v1_2__bindgen_ty_1 {
    pub reply_status: u8,
    pub aux_delay: u8,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of process_aux_channel_transaction_parameters_v1_2__bindgen_ty_1"][::core::mem::size_of::<
        process_aux_channel_transaction_parameters_v1_2__bindgen_ty_1,
    >() - 1usize];
    ["Alignment of process_aux_channel_transaction_parameters_v1_2__bindgen_ty_1"]
        [::core::mem::align_of::<process_aux_channel_transaction_parameters_v1_2__bindgen_ty_1>()
            - 1usize];
    ["Offset of field: process_aux_channel_transaction_parameters_v1_2__bindgen_ty_1::reply_status"] [:: core :: mem :: offset_of ! (process_aux_channel_transaction_parameters_v1_2__bindgen_ty_1 , reply_status) - 0usize] ;
    ["Offset of field: process_aux_channel_transaction_parameters_v1_2__bindgen_ty_1::aux_delay"][::core::mem::offset_of!(
        process_aux_channel_transaction_parameters_v1_2__bindgen_ty_1,
        aux_delay
    )
        - 0usize];
};
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of process_aux_channel_transaction_parameters_v1_2"]
        [::core::mem::size_of::<process_aux_channel_transaction_parameters_v1_2>() - 8usize];
    ["Alignment of process_aux_channel_transaction_parameters_v1_2"]
        [::core::mem::align_of::<process_aux_channel_transaction_parameters_v1_2>() - 1usize];
    ["Offset of field: process_aux_channel_transaction_parameters_v1_2::aux_request"][::core::mem::offset_of!(
        process_aux_channel_transaction_parameters_v1_2,
        aux_request
    ) - 0usize];
    ["Offset of field: process_aux_channel_transaction_parameters_v1_2::dataout"][::core::mem::offset_of!(
        process_aux_channel_transaction_parameters_v1_2,
        dataout
    ) - 2usize];
    ["Offset of field: process_aux_channel_transaction_parameters_v1_2::channelid"][::core::mem::offset_of!(
        process_aux_channel_transaction_parameters_v1_2,
        channelid
    ) - 4usize];
    ["Offset of field: process_aux_channel_transaction_parameters_v1_2::aux_status_delay"][::core::mem::offset_of!(
        process_aux_channel_transaction_parameters_v1_2,
        aux_status_delay
    )
        - 5usize];
    ["Offset of field: process_aux_channel_transaction_parameters_v1_2::dataout_len"][::core::mem::offset_of!(
        process_aux_channel_transaction_parameters_v1_2,
        dataout_len
    ) - 6usize];
    ["Offset of field: process_aux_channel_transaction_parameters_v1_2::hpd_id"]
        [::core::mem::offset_of!(process_aux_channel_transaction_parameters_v1_2, hpd_id) - 7usize];
};
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct select_crtc_source_parameters_v2_3 {
    pub crtc_id: u8,
    pub encoder_id: u8,
    pub encode_mode: u8,
    pub dst_bpc: u8,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of select_crtc_source_parameters_v2_3"]
        [::core::mem::size_of::<select_crtc_source_parameters_v2_3>() - 4usize];
    ["Alignment of select_crtc_source_parameters_v2_3"]
        [::core::mem::align_of::<select_crtc_source_parameters_v2_3>() - 1usize];
    ["Offset of field: select_crtc_source_parameters_v2_3::crtc_id"]
        [::core::mem::offset_of!(select_crtc_source_parameters_v2_3, crtc_id) - 0usize];
    ["Offset of field: select_crtc_source_parameters_v2_3::encoder_id"]
        [::core::mem::offset_of!(select_crtc_source_parameters_v2_3, encoder_id) - 1usize];
    ["Offset of field: select_crtc_source_parameters_v2_3::encode_mode"]
        [::core::mem::offset_of!(select_crtc_source_parameters_v2_3, encode_mode) - 2usize];
    ["Offset of field: select_crtc_source_parameters_v2_3::dst_bpc"]
        [::core::mem::offset_of!(select_crtc_source_parameters_v2_3, dst_bpc) - 3usize];
};
pub const atom_dig_encoder_control_action_ATOM_ENCODER_CMD_DISABLE_DIG:
    atom_dig_encoder_control_action = 0;
pub const atom_dig_encoder_control_action_ATOM_ENCODER_CMD_ENABLE_DIG:
    atom_dig_encoder_control_action = 1;
pub const atom_dig_encoder_control_action_ATOM_ENCODER_CMD_DP_LINK_TRAINING_START:
    atom_dig_encoder_control_action = 8;
pub const atom_dig_encoder_control_action_ATOM_ENCODER_CMD_DP_LINK_TRAINING_PATTERN1:
    atom_dig_encoder_control_action = 9;
pub const atom_dig_encoder_control_action_ATOM_ENCODER_CMD_DP_LINK_TRAINING_PATTERN2:
    atom_dig_encoder_control_action = 10;
pub const atom_dig_encoder_control_action_ATOM_ENCODER_CMD_DP_LINK_TRAINING_PATTERN3:
    atom_dig_encoder_control_action = 19;
pub const atom_dig_encoder_control_action_ATOM_ENCODER_CMD_DP_LINK_TRAINING_COMPLETE:
    atom_dig_encoder_control_action = 11;
pub const atom_dig_encoder_control_action_ATOM_ENCODER_CMD_DP_VIDEO_OFF:
    atom_dig_encoder_control_action = 12;
pub const atom_dig_encoder_control_action_ATOM_ENCODER_CMD_DP_VIDEO_ON:
    atom_dig_encoder_control_action = 13;
pub const atom_dig_encoder_control_action_ATOM_ENCODER_CMD_SETUP_PANEL_MODE:
    atom_dig_encoder_control_action = 16;
pub const atom_dig_encoder_control_action_ATOM_ENCODER_CMD_DP_LINK_TRAINING_PATTERN4:
    atom_dig_encoder_control_action = 20;
pub const atom_dig_encoder_control_action_ATOM_ENCODER_CMD_STREAM_SETUP:
    atom_dig_encoder_control_action = 15;
pub const atom_dig_encoder_control_action_ATOM_ENCODER_CMD_LINK_SETUP:
    atom_dig_encoder_control_action = 17;
pub const atom_dig_encoder_control_action_ATOM_ENCODER_CMD_ENCODER_BLANK:
    atom_dig_encoder_control_action = 18;
pub type atom_dig_encoder_control_action = ::core::ffi::c_uint;
pub const atom_dig_encoder_control_panelmode_DP_PANEL_MODE_DISABLE:
    atom_dig_encoder_control_panelmode = 0;
pub const atom_dig_encoder_control_panelmode_DP_PANEL_MODE_ENABLE_eDP_MODE:
    atom_dig_encoder_control_panelmode = 1;
pub const atom_dig_encoder_control_panelmode_DP_PANEL_MODE_ENABLE_LVLINK_MODE:
    atom_dig_encoder_control_panelmode = 17;
pub type atom_dig_encoder_control_panelmode = ::core::ffi::c_uint;
pub const atom_dig_encoder_control_v5_digid_ATOM_ENCODER_CONFIG_V5_DIG0_ENCODER:
    atom_dig_encoder_control_v5_digid = 0;
pub const atom_dig_encoder_control_v5_digid_ATOM_ENCODER_CONFIG_V5_DIG1_ENCODER:
    atom_dig_encoder_control_v5_digid = 1;
pub const atom_dig_encoder_control_v5_digid_ATOM_ENCODER_CONFIG_V5_DIG2_ENCODER:
    atom_dig_encoder_control_v5_digid = 2;
pub const atom_dig_encoder_control_v5_digid_ATOM_ENCODER_CONFIG_V5_DIG3_ENCODER:
    atom_dig_encoder_control_v5_digid = 3;
pub const atom_dig_encoder_control_v5_digid_ATOM_ENCODER_CONFIG_V5_DIG4_ENCODER:
    atom_dig_encoder_control_v5_digid = 4;
pub const atom_dig_encoder_control_v5_digid_ATOM_ENCODER_CONFIG_V5_DIG5_ENCODER:
    atom_dig_encoder_control_v5_digid = 5;
pub const atom_dig_encoder_control_v5_digid_ATOM_ENCODER_CONFIG_V5_DIG6_ENCODER:
    atom_dig_encoder_control_v5_digid = 6;
pub const atom_dig_encoder_control_v5_digid_ATOM_ENCODER_CONFIG_V5_DIG7_ENCODER:
    atom_dig_encoder_control_v5_digid = 7;
pub type atom_dig_encoder_control_v5_digid = ::core::ffi::c_uint;
#[repr(C, packed)]
#[derive(Debug, Copy, Clone)]
pub struct dig_encoder_stream_setup_parameters_v1_5 {
    pub digid: u8,
    pub action: u8,
    pub digmode: u8,
    pub lanenum: u8,
    pub pclk_10khz: u32,
    pub bitpercolor: u8,
    pub dplinkrate_270mhz: u8,
    pub reserved: [u8; 2usize],
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of dig_encoder_stream_setup_parameters_v1_5"]
        [::core::mem::size_of::<dig_encoder_stream_setup_parameters_v1_5>() - 12usize];
    ["Alignment of dig_encoder_stream_setup_parameters_v1_5"]
        [::core::mem::align_of::<dig_encoder_stream_setup_parameters_v1_5>() - 1usize];
    ["Offset of field: dig_encoder_stream_setup_parameters_v1_5::digid"]
        [::core::mem::offset_of!(dig_encoder_stream_setup_parameters_v1_5, digid) - 0usize];
    ["Offset of field: dig_encoder_stream_setup_parameters_v1_5::action"]
        [::core::mem::offset_of!(dig_encoder_stream_setup_parameters_v1_5, action) - 1usize];
    ["Offset of field: dig_encoder_stream_setup_parameters_v1_5::digmode"]
        [::core::mem::offset_of!(dig_encoder_stream_setup_parameters_v1_5, digmode) - 2usize];
    ["Offset of field: dig_encoder_stream_setup_parameters_v1_5::lanenum"]
        [::core::mem::offset_of!(dig_encoder_stream_setup_parameters_v1_5, lanenum) - 3usize];
    ["Offset of field: dig_encoder_stream_setup_parameters_v1_5::pclk_10khz"]
        [::core::mem::offset_of!(dig_encoder_stream_setup_parameters_v1_5, pclk_10khz) - 4usize];
    ["Offset of field: dig_encoder_stream_setup_parameters_v1_5::bitpercolor"]
        [::core::mem::offset_of!(dig_encoder_stream_setup_parameters_v1_5, bitpercolor) - 8usize];
    ["Offset of field: dig_encoder_stream_setup_parameters_v1_5::dplinkrate_270mhz"][::core::mem::offset_of!(
        dig_encoder_stream_setup_parameters_v1_5,
        dplinkrate_270mhz
    ) - 9usize];
    ["Offset of field: dig_encoder_stream_setup_parameters_v1_5::reserved"]
        [::core::mem::offset_of!(dig_encoder_stream_setup_parameters_v1_5, reserved) - 10usize];
};
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct dig_encoder_link_setup_parameters_v1_5 {
    pub digid: u8,
    pub action: u8,
    pub digmode: u8,
    pub lanenum: u8,
    pub symclk_10khz: u8,
    pub hpd_sel: u8,
    pub digfe_sel: u8,
    pub reserved: [u8; 2usize],
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of dig_encoder_link_setup_parameters_v1_5"]
        [::core::mem::size_of::<dig_encoder_link_setup_parameters_v1_5>() - 9usize];
    ["Alignment of dig_encoder_link_setup_parameters_v1_5"]
        [::core::mem::align_of::<dig_encoder_link_setup_parameters_v1_5>() - 1usize];
    ["Offset of field: dig_encoder_link_setup_parameters_v1_5::digid"]
        [::core::mem::offset_of!(dig_encoder_link_setup_parameters_v1_5, digid) - 0usize];
    ["Offset of field: dig_encoder_link_setup_parameters_v1_5::action"]
        [::core::mem::offset_of!(dig_encoder_link_setup_parameters_v1_5, action) - 1usize];
    ["Offset of field: dig_encoder_link_setup_parameters_v1_5::digmode"]
        [::core::mem::offset_of!(dig_encoder_link_setup_parameters_v1_5, digmode) - 2usize];
    ["Offset of field: dig_encoder_link_setup_parameters_v1_5::lanenum"]
        [::core::mem::offset_of!(dig_encoder_link_setup_parameters_v1_5, lanenum) - 3usize];
    ["Offset of field: dig_encoder_link_setup_parameters_v1_5::symclk_10khz"]
        [::core::mem::offset_of!(dig_encoder_link_setup_parameters_v1_5, symclk_10khz) - 4usize];
    ["Offset of field: dig_encoder_link_setup_parameters_v1_5::hpd_sel"]
        [::core::mem::offset_of!(dig_encoder_link_setup_parameters_v1_5, hpd_sel) - 5usize];
    ["Offset of field: dig_encoder_link_setup_parameters_v1_5::digfe_sel"]
        [::core::mem::offset_of!(dig_encoder_link_setup_parameters_v1_5, digfe_sel) - 6usize];
    ["Offset of field: dig_encoder_link_setup_parameters_v1_5::reserved"]
        [::core::mem::offset_of!(dig_encoder_link_setup_parameters_v1_5, reserved) - 7usize];
};
#[repr(C, packed)]
#[derive(Debug, Copy, Clone)]
pub struct dp_panel_mode_set_parameters_v1_5 {
    pub digid: u8,
    pub action: u8,
    pub panelmode: u8,
    pub reserved1: u8,
    pub reserved2: [u32; 2usize],
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of dp_panel_mode_set_parameters_v1_5"]
        [::core::mem::size_of::<dp_panel_mode_set_parameters_v1_5>() - 12usize];
    ["Alignment of dp_panel_mode_set_parameters_v1_5"]
        [::core::mem::align_of::<dp_panel_mode_set_parameters_v1_5>() - 1usize];
    ["Offset of field: dp_panel_mode_set_parameters_v1_5::digid"]
        [::core::mem::offset_of!(dp_panel_mode_set_parameters_v1_5, digid) - 0usize];
    ["Offset of field: dp_panel_mode_set_parameters_v1_5::action"]
        [::core::mem::offset_of!(dp_panel_mode_set_parameters_v1_5, action) - 1usize];
    ["Offset of field: dp_panel_mode_set_parameters_v1_5::panelmode"]
        [::core::mem::offset_of!(dp_panel_mode_set_parameters_v1_5, panelmode) - 2usize];
    ["Offset of field: dp_panel_mode_set_parameters_v1_5::reserved1"]
        [::core::mem::offset_of!(dp_panel_mode_set_parameters_v1_5, reserved1) - 3usize];
    ["Offset of field: dp_panel_mode_set_parameters_v1_5::reserved2"]
        [::core::mem::offset_of!(dp_panel_mode_set_parameters_v1_5, reserved2) - 4usize];
};
#[repr(C, packed)]
#[derive(Debug, Copy, Clone)]
pub struct dig_encoder_generic_cmd_parameters_v1_5 {
    pub digid: u8,
    pub action: u8,
    pub reserved1: [u8; 2usize],
    pub reserved2: [u32; 2usize],
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of dig_encoder_generic_cmd_parameters_v1_5"]
        [::core::mem::size_of::<dig_encoder_generic_cmd_parameters_v1_5>() - 12usize];
    ["Alignment of dig_encoder_generic_cmd_parameters_v1_5"]
        [::core::mem::align_of::<dig_encoder_generic_cmd_parameters_v1_5>() - 1usize];
    ["Offset of field: dig_encoder_generic_cmd_parameters_v1_5::digid"]
        [::core::mem::offset_of!(dig_encoder_generic_cmd_parameters_v1_5, digid) - 0usize];
    ["Offset of field: dig_encoder_generic_cmd_parameters_v1_5::action"]
        [::core::mem::offset_of!(dig_encoder_generic_cmd_parameters_v1_5, action) - 1usize];
    ["Offset of field: dig_encoder_generic_cmd_parameters_v1_5::reserved1"]
        [::core::mem::offset_of!(dig_encoder_generic_cmd_parameters_v1_5, reserved1) - 2usize];
    ["Offset of field: dig_encoder_generic_cmd_parameters_v1_5::reserved2"]
        [::core::mem::offset_of!(dig_encoder_generic_cmd_parameters_v1_5, reserved2) - 4usize];
};
#[repr(C)]
#[derive(Copy, Clone)]
pub union dig_encoder_control_parameters_v1_5 {
    pub cmd_param: dig_encoder_generic_cmd_parameters_v1_5,
    pub stream_param: dig_encoder_stream_setup_parameters_v1_5,
    pub link_param: dig_encoder_link_setup_parameters_v1_5,
    pub dppanel_param: dp_panel_mode_set_parameters_v1_5,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of dig_encoder_control_parameters_v1_5"]
        [::core::mem::size_of::<dig_encoder_control_parameters_v1_5>() - 12usize];
    ["Alignment of dig_encoder_control_parameters_v1_5"]
        [::core::mem::align_of::<dig_encoder_control_parameters_v1_5>() - 1usize];
    ["Offset of field: dig_encoder_control_parameters_v1_5::cmd_param"]
        [::core::mem::offset_of!(dig_encoder_control_parameters_v1_5, cmd_param) - 0usize];
    ["Offset of field: dig_encoder_control_parameters_v1_5::stream_param"]
        [::core::mem::offset_of!(dig_encoder_control_parameters_v1_5, stream_param) - 0usize];
    ["Offset of field: dig_encoder_control_parameters_v1_5::link_param"]
        [::core::mem::offset_of!(dig_encoder_control_parameters_v1_5, link_param) - 0usize];
    ["Offset of field: dig_encoder_control_parameters_v1_5::dppanel_param"]
        [::core::mem::offset_of!(dig_encoder_control_parameters_v1_5, dppanel_param) - 0usize];
};
#[repr(C, packed)]
#[derive(Copy, Clone)]
pub struct dig_transmitter_control_parameters_v1_6 {
    pub phyid: u8,
    pub action: u8,
    pub mode_laneset: dig_transmitter_control_parameters_v1_6__bindgen_ty_1,
    pub lanenum: u8,
    pub symclk_10khz: u32,
    pub hpdsel: u8,
    pub digfe_sel: u8,
    pub connobj_id: u8,
    pub reserved: u8,
    pub reserved1: u32,
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union dig_transmitter_control_parameters_v1_6__bindgen_ty_1 {
    pub digmode: u8,
    pub dplaneset: u8,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of dig_transmitter_control_parameters_v1_6__bindgen_ty_1"]
        [::core::mem::size_of::<dig_transmitter_control_parameters_v1_6__bindgen_ty_1>() - 1usize];
    ["Alignment of dig_transmitter_control_parameters_v1_6__bindgen_ty_1"]
        [::core::mem::align_of::<dig_transmitter_control_parameters_v1_6__bindgen_ty_1>() - 1usize];
    ["Offset of field: dig_transmitter_control_parameters_v1_6__bindgen_ty_1::digmode"][::core::mem::offset_of!(
        dig_transmitter_control_parameters_v1_6__bindgen_ty_1,
        digmode
    ) - 0usize];
    ["Offset of field: dig_transmitter_control_parameters_v1_6__bindgen_ty_1::dplaneset"][::core::mem::offset_of!(
        dig_transmitter_control_parameters_v1_6__bindgen_ty_1,
        dplaneset
    )
        - 0usize];
};
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of dig_transmitter_control_parameters_v1_6"]
        [::core::mem::size_of::<dig_transmitter_control_parameters_v1_6>() - 16usize];
    ["Alignment of dig_transmitter_control_parameters_v1_6"]
        [::core::mem::align_of::<dig_transmitter_control_parameters_v1_6>() - 1usize];
    ["Offset of field: dig_transmitter_control_parameters_v1_6::phyid"]
        [::core::mem::offset_of!(dig_transmitter_control_parameters_v1_6, phyid) - 0usize];
    ["Offset of field: dig_transmitter_control_parameters_v1_6::action"]
        [::core::mem::offset_of!(dig_transmitter_control_parameters_v1_6, action) - 1usize];
    ["Offset of field: dig_transmitter_control_parameters_v1_6::mode_laneset"]
        [::core::mem::offset_of!(dig_transmitter_control_parameters_v1_6, mode_laneset) - 2usize];
    ["Offset of field: dig_transmitter_control_parameters_v1_6::lanenum"]
        [::core::mem::offset_of!(dig_transmitter_control_parameters_v1_6, lanenum) - 3usize];
    ["Offset of field: dig_transmitter_control_parameters_v1_6::symclk_10khz"]
        [::core::mem::offset_of!(dig_transmitter_control_parameters_v1_6, symclk_10khz) - 4usize];
    ["Offset of field: dig_transmitter_control_parameters_v1_6::hpdsel"]
        [::core::mem::offset_of!(dig_transmitter_control_parameters_v1_6, hpdsel) - 8usize];
    ["Offset of field: dig_transmitter_control_parameters_v1_6::digfe_sel"]
        [::core::mem::offset_of!(dig_transmitter_control_parameters_v1_6, digfe_sel) - 9usize];
    ["Offset of field: dig_transmitter_control_parameters_v1_6::connobj_id"]
        [::core::mem::offset_of!(dig_transmitter_control_parameters_v1_6, connobj_id) - 10usize];
    ["Offset of field: dig_transmitter_control_parameters_v1_6::reserved"]
        [::core::mem::offset_of!(dig_transmitter_control_parameters_v1_6, reserved) - 11usize];
    ["Offset of field: dig_transmitter_control_parameters_v1_6::reserved1"]
        [::core::mem::offset_of!(dig_transmitter_control_parameters_v1_6, reserved1) - 12usize];
};
#[repr(C, packed)]
#[derive(Copy, Clone)]
pub struct dig_transmitter_control_ps_allocation_v1_6 {
    pub param: dig_transmitter_control_parameters_v1_6,
    pub reserved: [u32; 4usize],
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of dig_transmitter_control_ps_allocation_v1_6"]
        [::core::mem::size_of::<dig_transmitter_control_ps_allocation_v1_6>() - 32usize];
    ["Alignment of dig_transmitter_control_ps_allocation_v1_6"]
        [::core::mem::align_of::<dig_transmitter_control_ps_allocation_v1_6>() - 1usize];
    ["Offset of field: dig_transmitter_control_ps_allocation_v1_6::param"]
        [::core::mem::offset_of!(dig_transmitter_control_ps_allocation_v1_6, param) - 0usize];
    ["Offset of field: dig_transmitter_control_ps_allocation_v1_6::reserved"]
        [::core::mem::offset_of!(dig_transmitter_control_ps_allocation_v1_6, reserved) - 16usize];
};
pub const atom_dig_transmitter_control_action_ATOM_TRANSMITTER_ACTION_DISABLE:
    atom_dig_transmitter_control_action = 0;
pub const atom_dig_transmitter_control_action_ATOM_TRANSMITTER_ACTION_ENABLE:
    atom_dig_transmitter_control_action = 1;
pub const atom_dig_transmitter_control_action_ATOM_TRANSMITTER_ACTION_LCD_BLOFF:
    atom_dig_transmitter_control_action = 2;
pub const atom_dig_transmitter_control_action_ATOM_TRANSMITTER_ACTION_LCD_BLON:
    atom_dig_transmitter_control_action = 3;
pub const atom_dig_transmitter_control_action_ATOM_TRANSMITTER_ACTION_BL_BRIGHTNESS_CONTROL:
    atom_dig_transmitter_control_action = 4;
pub const atom_dig_transmitter_control_action_ATOM_TRANSMITTER_ACTION_LCD_SELFTEST_START:
    atom_dig_transmitter_control_action = 5;
pub const atom_dig_transmitter_control_action_ATOM_TRANSMITTER_ACTION_LCD_SELFTEST_STOP:
    atom_dig_transmitter_control_action = 6;
pub const atom_dig_transmitter_control_action_ATOM_TRANSMITTER_ACTION_INIT:
    atom_dig_transmitter_control_action = 7;
pub const atom_dig_transmitter_control_action_ATOM_TRANSMITTER_ACTION_DISABLE_OUTPUT:
    atom_dig_transmitter_control_action = 8;
pub const atom_dig_transmitter_control_action_ATOM_TRANSMITTER_ACTION_ENABLE_OUTPUT:
    atom_dig_transmitter_control_action = 9;
pub const atom_dig_transmitter_control_action_ATOM_TRANSMITTER_ACTION_SETUP:
    atom_dig_transmitter_control_action = 10;
pub const atom_dig_transmitter_control_action_ATOM_TRANSMITTER_ACTION_SETUP_VSEMPH:
    atom_dig_transmitter_control_action = 11;
pub const atom_dig_transmitter_control_action_ATOM_TRANSMITTER_ACTION_POWER_ON:
    atom_dig_transmitter_control_action = 12;
pub const atom_dig_transmitter_control_action_ATOM_TRANSMITTER_ACTION_POWER_OFF:
    atom_dig_transmitter_control_action = 13;
pub type atom_dig_transmitter_control_action = ::core::ffi::c_uint;
pub const atom_dig_transmitter_control_digfe_sel_ATOM_TRANMSITTER_V6__DIGA_SEL:
    atom_dig_transmitter_control_digfe_sel = 1;
pub const atom_dig_transmitter_control_digfe_sel_ATOM_TRANMSITTER_V6__DIGB_SEL:
    atom_dig_transmitter_control_digfe_sel = 2;
pub const atom_dig_transmitter_control_digfe_sel_ATOM_TRANMSITTER_V6__DIGC_SEL:
    atom_dig_transmitter_control_digfe_sel = 4;
pub const atom_dig_transmitter_control_digfe_sel_ATOM_TRANMSITTER_V6__DIGD_SEL:
    atom_dig_transmitter_control_digfe_sel = 8;
pub const atom_dig_transmitter_control_digfe_sel_ATOM_TRANMSITTER_V6__DIGE_SEL:
    atom_dig_transmitter_control_digfe_sel = 16;
pub const atom_dig_transmitter_control_digfe_sel_ATOM_TRANMSITTER_V6__DIGF_SEL:
    atom_dig_transmitter_control_digfe_sel = 32;
pub const atom_dig_transmitter_control_digfe_sel_ATOM_TRANMSITTER_V6__DIGG_SEL:
    atom_dig_transmitter_control_digfe_sel = 64;
pub type atom_dig_transmitter_control_digfe_sel = ::core::ffi::c_uint;
pub const atom_dig_transmitter_control_hpd_sel_ATOM_TRANSMITTER_V6_NO_HPD_SEL:
    atom_dig_transmitter_control_hpd_sel = 0;
pub const atom_dig_transmitter_control_hpd_sel_ATOM_TRANSMITTER_V6_HPD1_SEL:
    atom_dig_transmitter_control_hpd_sel = 1;
pub const atom_dig_transmitter_control_hpd_sel_ATOM_TRANSMITTER_V6_HPD2_SEL:
    atom_dig_transmitter_control_hpd_sel = 2;
pub const atom_dig_transmitter_control_hpd_sel_ATOM_TRANSMITTER_V6_HPD3_SEL:
    atom_dig_transmitter_control_hpd_sel = 3;
pub const atom_dig_transmitter_control_hpd_sel_ATOM_TRANSMITTER_V6_HPD4_SEL:
    atom_dig_transmitter_control_hpd_sel = 4;
pub const atom_dig_transmitter_control_hpd_sel_ATOM_TRANSMITTER_V6_HPD5_SEL:
    atom_dig_transmitter_control_hpd_sel = 5;
pub const atom_dig_transmitter_control_hpd_sel_ATOM_TRANSMITTER_V6_HPD6_SEL:
    atom_dig_transmitter_control_hpd_sel = 6;
pub type atom_dig_transmitter_control_hpd_sel = ::core::ffi::c_uint;
pub const atom_dig_transmitter_control_dplaneset_DP_LANE_SET__0DB_0_4V:
    atom_dig_transmitter_control_dplaneset = 0;
pub const atom_dig_transmitter_control_dplaneset_DP_LANE_SET__0DB_0_6V:
    atom_dig_transmitter_control_dplaneset = 1;
pub const atom_dig_transmitter_control_dplaneset_DP_LANE_SET__0DB_0_8V:
    atom_dig_transmitter_control_dplaneset = 2;
pub const atom_dig_transmitter_control_dplaneset_DP_LANE_SET__0DB_1_2V:
    atom_dig_transmitter_control_dplaneset = 3;
pub const atom_dig_transmitter_control_dplaneset_DP_LANE_SET__3_5DB_0_4V:
    atom_dig_transmitter_control_dplaneset = 8;
pub const atom_dig_transmitter_control_dplaneset_DP_LANE_SET__3_5DB_0_6V:
    atom_dig_transmitter_control_dplaneset = 9;
pub const atom_dig_transmitter_control_dplaneset_DP_LANE_SET__3_5DB_0_8V:
    atom_dig_transmitter_control_dplaneset = 10;
pub const atom_dig_transmitter_control_dplaneset_DP_LANE_SET__6DB_0_4V:
    atom_dig_transmitter_control_dplaneset = 16;
pub const atom_dig_transmitter_control_dplaneset_DP_LANE_SET__6DB_0_6V:
    atom_dig_transmitter_control_dplaneset = 17;
pub const atom_dig_transmitter_control_dplaneset_DP_LANE_SET__9_5DB_0_4V:
    atom_dig_transmitter_control_dplaneset = 24;
pub type atom_dig_transmitter_control_dplaneset = ::core::ffi::c_uint;
#[repr(C, packed)]
#[derive(Debug, Copy, Clone)]
pub struct external_encoder_control_parameters_v2_4 {
    pub pixelclock_10khz: u16,
    pub config: u8,
    pub action: u8,
    pub encodermode: u8,
    pub lanenum: u8,
    pub bitpercolor: u8,
    pub hpd_id: u8,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of external_encoder_control_parameters_v2_4"]
        [::core::mem::size_of::<external_encoder_control_parameters_v2_4>() - 8usize];
    ["Alignment of external_encoder_control_parameters_v2_4"]
        [::core::mem::align_of::<external_encoder_control_parameters_v2_4>() - 1usize];
    ["Offset of field: external_encoder_control_parameters_v2_4::pixelclock_10khz"][::core::mem::offset_of!(
        external_encoder_control_parameters_v2_4,
        pixelclock_10khz
    ) - 0usize];
    ["Offset of field: external_encoder_control_parameters_v2_4::config"]
        [::core::mem::offset_of!(external_encoder_control_parameters_v2_4, config) - 2usize];
    ["Offset of field: external_encoder_control_parameters_v2_4::action"]
        [::core::mem::offset_of!(external_encoder_control_parameters_v2_4, action) - 3usize];
    ["Offset of field: external_encoder_control_parameters_v2_4::encodermode"]
        [::core::mem::offset_of!(external_encoder_control_parameters_v2_4, encodermode) - 4usize];
    ["Offset of field: external_encoder_control_parameters_v2_4::lanenum"]
        [::core::mem::offset_of!(external_encoder_control_parameters_v2_4, lanenum) - 5usize];
    ["Offset of field: external_encoder_control_parameters_v2_4::bitpercolor"]
        [::core::mem::offset_of!(external_encoder_control_parameters_v2_4, bitpercolor) - 6usize];
    ["Offset of field: external_encoder_control_parameters_v2_4::hpd_id"]
        [::core::mem::offset_of!(external_encoder_control_parameters_v2_4, hpd_id) - 7usize];
};
pub const external_encoder_control_action_def_EXTERNAL_ENCODER_ACTION_V3_DISABLE_OUTPUT:
    external_encoder_control_action_def = 0;
pub const external_encoder_control_action_def_EXTERNAL_ENCODER_ACTION_V3_ENABLE_OUTPUT:
    external_encoder_control_action_def = 1;
pub const external_encoder_control_action_def_EXTERNAL_ENCODER_ACTION_V3_ENCODER_INIT:
    external_encoder_control_action_def = 7;
pub const external_encoder_control_action_def_EXTERNAL_ENCODER_ACTION_V3_ENCODER_SETUP:
    external_encoder_control_action_def = 15;
pub const external_encoder_control_action_def_EXTERNAL_ENCODER_ACTION_V3_ENCODER_BLANKING_OFF:
    external_encoder_control_action_def = 16;
pub const external_encoder_control_action_def_EXTERNAL_ENCODER_ACTION_V3_ENCODER_BLANKING:
    external_encoder_control_action_def = 17;
pub const external_encoder_control_action_def_EXTERNAL_ENCODER_ACTION_V3_DACLOAD_DETECTION:
    external_encoder_control_action_def = 18;
pub const external_encoder_control_action_def_EXTERNAL_ENCODER_ACTION_V3_DDC_SETUP:
    external_encoder_control_action_def = 20;
pub type external_encoder_control_action_def = ::core::ffi::c_uint;
pub const external_encoder_control_v2_4_config_def_EXTERNAL_ENCODER_CONFIG_V3_DPLINKRATE_MASK:
    external_encoder_control_v2_4_config_def = 3;
pub const external_encoder_control_v2_4_config_def_EXTERNAL_ENCODER_CONFIG_V3_DPLINKRATE_1_62GHZ:
    external_encoder_control_v2_4_config_def = 0;
pub const external_encoder_control_v2_4_config_def_EXTERNAL_ENCODER_CONFIG_V3_DPLINKRATE_2_70GHZ:
    external_encoder_control_v2_4_config_def = 1;
pub const external_encoder_control_v2_4_config_def_EXTERNAL_ENCODER_CONFIG_V3_DPLINKRATE_5_40GHZ:
    external_encoder_control_v2_4_config_def = 2;
pub const external_encoder_control_v2_4_config_def_EXTERNAL_ENCODER_CONFIG_V3_DPLINKRATE_3_24GHZ:
    external_encoder_control_v2_4_config_def = 3;
pub const external_encoder_control_v2_4_config_def_EXTERNAL_ENCODER_CONFIG_V3_ENCODER_SEL_MAKS:
    external_encoder_control_v2_4_config_def = 112;
pub const external_encoder_control_v2_4_config_def_EXTERNAL_ENCODER_CONFIG_V3_ENCODER1:
    external_encoder_control_v2_4_config_def = 0;
pub const external_encoder_control_v2_4_config_def_EXTERNAL_ENCODER_CONFIG_V3_ENCODER2:
    external_encoder_control_v2_4_config_def = 16;
pub const external_encoder_control_v2_4_config_def_EXTERNAL_ENCODER_CONFIG_V3_ENCODER3:
    external_encoder_control_v2_4_config_def = 32;
pub type external_encoder_control_v2_4_config_def = ::core::ffi::c_uint;
#[repr(C, packed)]
#[derive(Debug, Copy, Clone)]
pub struct external_encoder_control_ps_allocation_v2_4 {
    pub sExtEncoder: external_encoder_control_parameters_v2_4,
    pub reserved: [u32; 2usize],
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of external_encoder_control_ps_allocation_v2_4"]
        [::core::mem::size_of::<external_encoder_control_ps_allocation_v2_4>() - 16usize];
    ["Alignment of external_encoder_control_ps_allocation_v2_4"]
        [::core::mem::align_of::<external_encoder_control_ps_allocation_v2_4>() - 1usize];
    ["Offset of field: external_encoder_control_ps_allocation_v2_4::sExtEncoder"][::core::mem::offset_of!(
        external_encoder_control_ps_allocation_v2_4,
        sExtEncoder
    ) - 0usize];
    ["Offset of field: external_encoder_control_ps_allocation_v2_4::reserved"]
        [::core::mem::offset_of!(external_encoder_control_ps_allocation_v2_4, reserved) - 8usize];
};
#[repr(C, packed)]
#[derive(Debug, Copy, Clone)]
pub struct amd_acpi_description_header {
    pub signature: u32,
    pub tableLength: u32,
    pub revision: u8,
    pub checksum: u8,
    pub oemId: [u8; 6usize],
    pub oemTableId: [u8; 8usize],
    pub oemRevision: u32,
    pub creatorId: u32,
    pub creatorRevision: u32,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of amd_acpi_description_header"]
        [::core::mem::size_of::<amd_acpi_description_header>() - 36usize];
    ["Alignment of amd_acpi_description_header"]
        [::core::mem::align_of::<amd_acpi_description_header>() - 1usize];
    ["Offset of field: amd_acpi_description_header::signature"]
        [::core::mem::offset_of!(amd_acpi_description_header, signature) - 0usize];
    ["Offset of field: amd_acpi_description_header::tableLength"]
        [::core::mem::offset_of!(amd_acpi_description_header, tableLength) - 4usize];
    ["Offset of field: amd_acpi_description_header::revision"]
        [::core::mem::offset_of!(amd_acpi_description_header, revision) - 8usize];
    ["Offset of field: amd_acpi_description_header::checksum"]
        [::core::mem::offset_of!(amd_acpi_description_header, checksum) - 9usize];
    ["Offset of field: amd_acpi_description_header::oemId"]
        [::core::mem::offset_of!(amd_acpi_description_header, oemId) - 10usize];
    ["Offset of field: amd_acpi_description_header::oemTableId"]
        [::core::mem::offset_of!(amd_acpi_description_header, oemTableId) - 16usize];
    ["Offset of field: amd_acpi_description_header::oemRevision"]
        [::core::mem::offset_of!(amd_acpi_description_header, oemRevision) - 24usize];
    ["Offset of field: amd_acpi_description_header::creatorId"]
        [::core::mem::offset_of!(amd_acpi_description_header, creatorId) - 28usize];
    ["Offset of field: amd_acpi_description_header::creatorRevision"]
        [::core::mem::offset_of!(amd_acpi_description_header, creatorRevision) - 32usize];
};
#[repr(C, packed)]
#[derive(Debug, Copy, Clone)]
pub struct uefi_acpi_vfct {
    pub sheader: amd_acpi_description_header,
    pub tableUUID: [u8; 16usize],
    pub vbiosimageoffset: u32,
    pub lib1Imageoffset: u32,
    pub reserved: [u32; 4usize],
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of uefi_acpi_vfct"][::core::mem::size_of::<uefi_acpi_vfct>() - 76usize];
    ["Alignment of uefi_acpi_vfct"][::core::mem::align_of::<uefi_acpi_vfct>() - 1usize];
    ["Offset of field: uefi_acpi_vfct::sheader"]
        [::core::mem::offset_of!(uefi_acpi_vfct, sheader) - 0usize];
    ["Offset of field: uefi_acpi_vfct::tableUUID"]
        [::core::mem::offset_of!(uefi_acpi_vfct, tableUUID) - 36usize];
    ["Offset of field: uefi_acpi_vfct::vbiosimageoffset"]
        [::core::mem::offset_of!(uefi_acpi_vfct, vbiosimageoffset) - 52usize];
    ["Offset of field: uefi_acpi_vfct::lib1Imageoffset"]
        [::core::mem::offset_of!(uefi_acpi_vfct, lib1Imageoffset) - 56usize];
    ["Offset of field: uefi_acpi_vfct::reserved"]
        [::core::mem::offset_of!(uefi_acpi_vfct, reserved) - 60usize];
};
#[repr(C, packed)]
#[derive(Debug, Copy, Clone)]
pub struct vfct_image_header {
    pub pcibus: u32,
    pub pcidevice: u32,
    pub pcifunction: u32,
    pub vendorid: u16,
    pub deviceid: u16,
    pub ssvid: u16,
    pub ssid: u16,
    pub revision: u32,
    pub imagelength: u32,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of vfct_image_header"][::core::mem::size_of::<vfct_image_header>() - 28usize];
    ["Alignment of vfct_image_header"][::core::mem::align_of::<vfct_image_header>() - 1usize];
    ["Offset of field: vfct_image_header::pcibus"]
        [::core::mem::offset_of!(vfct_image_header, pcibus) - 0usize];
    ["Offset of field: vfct_image_header::pcidevice"]
        [::core::mem::offset_of!(vfct_image_header, pcidevice) - 4usize];
    ["Offset of field: vfct_image_header::pcifunction"]
        [::core::mem::offset_of!(vfct_image_header, pcifunction) - 8usize];
    ["Offset of field: vfct_image_header::vendorid"]
        [::core::mem::offset_of!(vfct_image_header, vendorid) - 12usize];
    ["Offset of field: vfct_image_header::deviceid"]
        [::core::mem::offset_of!(vfct_image_header, deviceid) - 14usize];
    ["Offset of field: vfct_image_header::ssvid"]
        [::core::mem::offset_of!(vfct_image_header, ssvid) - 16usize];
    ["Offset of field: vfct_image_header::ssid"]
        [::core::mem::offset_of!(vfct_image_header, ssid) - 18usize];
    ["Offset of field: vfct_image_header::revision"]
        [::core::mem::offset_of!(vfct_image_header, revision) - 20usize];
    ["Offset of field: vfct_image_header::imagelength"]
        [::core::mem::offset_of!(vfct_image_header, imagelength) - 24usize];
};
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct gop_vbios_content {
    pub vbiosheader: vfct_image_header,
    pub vbioscontent: [u8; 1usize],
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of gop_vbios_content"][::core::mem::size_of::<gop_vbios_content>() - 29usize];
    ["Alignment of gop_vbios_content"][::core::mem::align_of::<gop_vbios_content>() - 1usize];
    ["Offset of field: gop_vbios_content::vbiosheader"]
        [::core::mem::offset_of!(gop_vbios_content, vbiosheader) - 0usize];
    ["Offset of field: gop_vbios_content::vbioscontent"]
        [::core::mem::offset_of!(gop_vbios_content, vbioscontent) - 28usize];
};
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct gop_lib1_content {
    pub lib1header: vfct_image_header,
    pub lib1content: [u8; 1usize],
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of gop_lib1_content"][::core::mem::size_of::<gop_lib1_content>() - 29usize];
    ["Alignment of gop_lib1_content"][::core::mem::align_of::<gop_lib1_content>() - 1usize];
    ["Offset of field: gop_lib1_content::lib1header"]
        [::core::mem::offset_of!(gop_lib1_content, lib1header) - 0usize];
    ["Offset of field: gop_lib1_content::lib1content"]
        [::core::mem::offset_of!(gop_lib1_content, lib1content) - 28usize];
};
pub const scratch_register_def_ATOM_DEVICE_CONNECT_INFO_DEF: scratch_register_def = 0;
pub const scratch_register_def_ATOM_BL_BRI_LEVEL_INFO_DEF: scratch_register_def = 2;
pub const scratch_register_def_ATOM_ACTIVE_INFO_DEF: scratch_register_def = 3;
pub const scratch_register_def_ATOM_LCD_INFO_DEF: scratch_register_def = 4;
pub const scratch_register_def_ATOM_DEVICE_REQ_INFO_DEF: scratch_register_def = 5;
pub const scratch_register_def_ATOM_ACC_CHANGE_INFO_DEF: scratch_register_def = 6;
pub const scratch_register_def_ATOM_PRE_OS_MODE_INFO_DEF: scratch_register_def = 7;
pub const scratch_register_def_ATOM_PRE_OS_ASSERTION_DEF: scratch_register_def = 8;
pub const scratch_register_def_ATOM_INTERNAL_TIMER_INFO_DEF: scratch_register_def = 10;
pub type scratch_register_def = ::core::ffi::c_uint;
pub const scratch_device_connect_info_bit_def_ATOM_DISPLAY_LCD1_CONNECT:
    scratch_device_connect_info_bit_def = 2;
pub const scratch_device_connect_info_bit_def_ATOM_DISPLAY_DFP1_CONNECT:
    scratch_device_connect_info_bit_def = 8;
pub const scratch_device_connect_info_bit_def_ATOM_DISPLAY_DFP2_CONNECT:
    scratch_device_connect_info_bit_def = 128;
pub const scratch_device_connect_info_bit_def_ATOM_DISPLAY_DFP3_CONNECT:
    scratch_device_connect_info_bit_def = 512;
pub const scratch_device_connect_info_bit_def_ATOM_DISPLAY_DFP4_CONNECT:
    scratch_device_connect_info_bit_def = 1024;
pub const scratch_device_connect_info_bit_def_ATOM_DISPLAY_DFP5_CONNECT:
    scratch_device_connect_info_bit_def = 2048;
pub const scratch_device_connect_info_bit_def_ATOM_DISPLAY_DFP6_CONNECT:
    scratch_device_connect_info_bit_def = 64;
pub const scratch_device_connect_info_bit_def_ATOM_DISPLAY_DFPx_CONNECT:
    scratch_device_connect_info_bit_def = 3784;
pub const scratch_device_connect_info_bit_def_ATOM_CONNECT_INFO_DEVICE_MASK:
    scratch_device_connect_info_bit_def = 4095;
pub type scratch_device_connect_info_bit_def = ::core::ffi::c_uint;
pub const scratch_bl_bri_level_info_bit_def_ATOM_CURRENT_BL_LEVEL_SHIFT:
    scratch_bl_bri_level_info_bit_def = 8;
pub const scratch_bl_bri_level_info_bit_def_ATOM_CURRENT_BL_LEVEL_MASK:
    scratch_bl_bri_level_info_bit_def = 65280;
pub const scratch_bl_bri_level_info_bit_def_ATOM_DEVICE_DPMS_STATE:
    scratch_bl_bri_level_info_bit_def = 65536;
pub type scratch_bl_bri_level_info_bit_def = ::core::ffi::c_uint;
pub const scratch_active_info_bits_def_ATOM_DISPLAY_LCD1_ACTIVE: scratch_active_info_bits_def = 2;
pub const scratch_active_info_bits_def_ATOM_DISPLAY_DFP1_ACTIVE: scratch_active_info_bits_def = 8;
pub const scratch_active_info_bits_def_ATOM_DISPLAY_DFP2_ACTIVE: scratch_active_info_bits_def = 128;
pub const scratch_active_info_bits_def_ATOM_DISPLAY_DFP3_ACTIVE: scratch_active_info_bits_def = 512;
pub const scratch_active_info_bits_def_ATOM_DISPLAY_DFP4_ACTIVE: scratch_active_info_bits_def =
    1024;
pub const scratch_active_info_bits_def_ATOM_DISPLAY_DFP5_ACTIVE: scratch_active_info_bits_def =
    2048;
pub const scratch_active_info_bits_def_ATOM_DISPLAY_DFP6_ACTIVE: scratch_active_info_bits_def = 64;
pub const scratch_active_info_bits_def_ATOM_ACTIVE_INFO_DEVICE_MASK: scratch_active_info_bits_def =
    4095;
pub type scratch_active_info_bits_def = ::core::ffi::c_uint;
pub const scratch_device_req_info_bits_def_ATOM_DISPLAY_LCD1_REQ: scratch_device_req_info_bits_def =
    2;
pub const scratch_device_req_info_bits_def_ATOM_DISPLAY_DFP1_REQ: scratch_device_req_info_bits_def =
    8;
pub const scratch_device_req_info_bits_def_ATOM_DISPLAY_DFP2_REQ: scratch_device_req_info_bits_def =
    128;
pub const scratch_device_req_info_bits_def_ATOM_DISPLAY_DFP3_REQ: scratch_device_req_info_bits_def =
    512;
pub const scratch_device_req_info_bits_def_ATOM_DISPLAY_DFP4_REQ: scratch_device_req_info_bits_def =
    1024;
pub const scratch_device_req_info_bits_def_ATOM_DISPLAY_DFP5_REQ: scratch_device_req_info_bits_def =
    2048;
pub const scratch_device_req_info_bits_def_ATOM_DISPLAY_DFP6_REQ: scratch_device_req_info_bits_def =
    64;
pub const scratch_device_req_info_bits_def_ATOM_REQ_INFO_DEVICE_MASK:
    scratch_device_req_info_bits_def = 4095;
pub type scratch_device_req_info_bits_def = ::core::ffi::c_uint;
pub const scratch_acc_change_info_bitshift_def_ATOM_ACC_CHANGE_ACC_MODE_SHIFT:
    scratch_acc_change_info_bitshift_def = 4;
pub const scratch_acc_change_info_bitshift_def_ATOM_ACC_CHANGE_LID_STATUS_SHIFT:
    scratch_acc_change_info_bitshift_def = 6;
pub type scratch_acc_change_info_bitshift_def = ::core::ffi::c_uint;
pub const scratch_acc_change_info_bits_def_ATOM_ACC_CHANGE_ACC_MODE:
    scratch_acc_change_info_bits_def = 16;
pub const scratch_acc_change_info_bits_def_ATOM_ACC_CHANGE_LID_STATUS:
    scratch_acc_change_info_bits_def = 64;
pub type scratch_acc_change_info_bits_def = ::core::ffi::c_uint;
pub const scratch_pre_os_mode_info_bits_def_ATOM_PRE_OS_MODE_MASK:
    scratch_pre_os_mode_info_bits_def = 3;
pub const scratch_pre_os_mode_info_bits_def_ATOM_PRE_OS_MODE_VGA:
    scratch_pre_os_mode_info_bits_def = 0;
pub const scratch_pre_os_mode_info_bits_def_ATOM_PRE_OS_MODE_VESA:
    scratch_pre_os_mode_info_bits_def = 1;
pub const scratch_pre_os_mode_info_bits_def_ATOM_PRE_OS_MODE_GOP:
    scratch_pre_os_mode_info_bits_def = 2;
pub const scratch_pre_os_mode_info_bits_def_ATOM_PRE_OS_MODE_PIXEL_DEPTH:
    scratch_pre_os_mode_info_bits_def = 12;
pub const scratch_pre_os_mode_info_bits_def_ATOM_PRE_OS_MODE_PIXEL_FORMAT_MASK:
    scratch_pre_os_mode_info_bits_def = 240;
pub const scratch_pre_os_mode_info_bits_def_ATOM_PRE_OS_MODE_8BIT_PAL_EN:
    scratch_pre_os_mode_info_bits_def = 256;
pub const scratch_pre_os_mode_info_bits_def_ATOM_ASIC_INIT_COMPLETE:
    scratch_pre_os_mode_info_bits_def = 512;
pub const scratch_pre_os_mode_info_bits_def_ATOM_PRE_OS_MODE_NUMBER_MASK:
    scratch_pre_os_mode_info_bits_def = 4294901760;
pub type scratch_pre_os_mode_info_bits_def = ::core::ffi::c_uint;
pub const atom_master_data_table_id_VBIOS_DATA_TBL_ID__UTILITY_PIPELINE: atom_master_data_table_id =
    0;
pub const atom_master_data_table_id_VBIOS_DATA_TBL_ID__MULTIMEDIA_INF: atom_master_data_table_id =
    1;
pub const atom_master_data_table_id_VBIOS_DATA_TBL_ID__FIRMWARE_INF: atom_master_data_table_id = 2;
pub const atom_master_data_table_id_VBIOS_DATA_TBL_ID__LCD_INF: atom_master_data_table_id = 3;
pub const atom_master_data_table_id_VBIOS_DATA_TBL_ID__SMU_INF: atom_master_data_table_id = 4;
pub const atom_master_data_table_id_VBIOS_DATA_TBL_ID__VRAM_USAGE_BY_FIRMWARE:
    atom_master_data_table_id = 5;
pub const atom_master_data_table_id_VBIOS_DATA_TBL_ID__GPIO_PIN_LUT: atom_master_data_table_id = 6;
pub const atom_master_data_table_id_VBIOS_DATA_TBL_ID__GFX_INF: atom_master_data_table_id = 7;
pub const atom_master_data_table_id_VBIOS_DATA_TBL_ID__POWER_PLAY_INF: atom_master_data_table_id =
    8;
pub const atom_master_data_table_id_VBIOS_DATA_TBL_ID__DISPLAY_OBJECT_INF:
    atom_master_data_table_id = 9;
pub const atom_master_data_table_id_VBIOS_DATA_TBL_ID__INDIRECT_IO_ACCESS:
    atom_master_data_table_id = 10;
pub const atom_master_data_table_id_VBIOS_DATA_TBL_ID__UMC_INF: atom_master_data_table_id = 11;
pub const atom_master_data_table_id_VBIOS_DATA_TBL_ID__DCE_INF: atom_master_data_table_id = 12;
pub const atom_master_data_table_id_VBIOS_DATA_TBL_ID__VRAM_INF: atom_master_data_table_id = 13;
pub const atom_master_data_table_id_VBIOS_DATA_TBL_ID__INTEGRATED_SYS_INF:
    atom_master_data_table_id = 14;
pub const atom_master_data_table_id_VBIOS_DATA_TBL_ID__ASIC_PROFILING_INF:
    atom_master_data_table_id = 15;
pub const atom_master_data_table_id_VBIOS_DATA_TBL_ID__VOLTAGE_OBJ_INF: atom_master_data_table_id =
    16;
pub const atom_master_data_table_id_VBIOS_DATA_TBL_ID__UNDEFINED: atom_master_data_table_id = 17;
pub type atom_master_data_table_id = ::core::ffi::c_uint;
pub const atom_master_command_table_id_VBIOS_CMD_TBL_ID__ASIC_INIT: atom_master_command_table_id =
    0;
pub const atom_master_command_table_id_VBIOS_CMD_TBL_ID__DIGX_ENCODER_CONTROL:
    atom_master_command_table_id = 1;
pub const atom_master_command_table_id_VBIOS_CMD_TBL_ID__SET_ENGINE_CLOCK:
    atom_master_command_table_id = 2;
pub const atom_master_command_table_id_VBIOS_CMD_TBL_ID__SET_MEMORY_CLOCK:
    atom_master_command_table_id = 3;
pub const atom_master_command_table_id_VBIOS_CMD_TBL_ID__SET_PIXEL_CLOCK:
    atom_master_command_table_id = 4;
pub const atom_master_command_table_id_VBIOS_CMD_TBL_ID__ENABLE_DISP_POWER_GATING:
    atom_master_command_table_id = 5;
pub const atom_master_command_table_id_VBIOS_CMD_TBL_ID__BLANK_CRTC: atom_master_command_table_id =
    6;
pub const atom_master_command_table_id_VBIOS_CMD_TBL_ID__ENABLE_CRTC: atom_master_command_table_id =
    7;
pub const atom_master_command_table_id_VBIOS_CMD_TBL_ID__GET_SMU_CLOCK_INFO:
    atom_master_command_table_id = 8;
pub const atom_master_command_table_id_VBIOS_CMD_TBL_ID__SELECT_CRTC_SOURCE:
    atom_master_command_table_id = 9;
pub const atom_master_command_table_id_VBIOS_CMD_TBL_ID__SET_DCE_CLOCK:
    atom_master_command_table_id = 10;
pub const atom_master_command_table_id_VBIOS_CMD_TBL_ID__GET_MEMORY_CLOCK:
    atom_master_command_table_id = 11;
pub const atom_master_command_table_id_VBIOS_CMD_TBL_ID__GET_ENGINE_CLOCK:
    atom_master_command_table_id = 12;
pub const atom_master_command_table_id_VBIOS_CMD_TBL_ID__SET_CRTC_USING_DTD_TIMING:
    atom_master_command_table_id = 13;
pub const atom_master_command_table_id_VBIOS_CMD_TBL_ID__EXTENAL_ENCODER_CONTROL:
    atom_master_command_table_id = 14;
pub const atom_master_command_table_id_VBIOS_CMD_TBL_ID__PROCESS_I2C_CHANNEL_TRANSACTION:
    atom_master_command_table_id = 15;
pub const atom_master_command_table_id_VBIOS_CMD_TBL_ID__COMPUTE_GPU_CLOCK_PARAM:
    atom_master_command_table_id = 16;
pub const atom_master_command_table_id_VBIOS_CMD_TBL_ID__DYNAMIC_MEMORY_SETTINGS:
    atom_master_command_table_id = 17;
pub const atom_master_command_table_id_VBIOS_CMD_TBL_ID__MEMORY_TRAINING:
    atom_master_command_table_id = 18;
pub const atom_master_command_table_id_VBIOS_CMD_TBL_ID__SET_VOLTAGE: atom_master_command_table_id =
    19;
pub const atom_master_command_table_id_VBIOS_CMD_TBL_ID__DIG1_TRANSMITTER_CONTROL:
    atom_master_command_table_id = 20;
pub const atom_master_command_table_id_VBIOS_CMD_TBL_ID__PROCESS_AUX_CHANNEL_TRANSACTION:
    atom_master_command_table_id = 21;
pub const atom_master_command_table_id_VBIOS_CMD_TBL_ID__GET_VOLTAGE_INF:
    atom_master_command_table_id = 22;
pub const atom_master_command_table_id_VBIOS_CMD_TBL_ID__UNDEFINED: atom_master_command_table_id =
    23;
pub type atom_master_command_table_id = ::core::ffi::c_uint;
pub const I2cControllerPort_e_I2C_CONTROLLER_PORT_0: I2cControllerPort_e = 0;
pub const I2cControllerPort_e_I2C_CONTROLLER_PORT_1: I2cControllerPort_e = 1;
pub const I2cControllerPort_e_I2C_CONTROLLER_PORT_COUNT: I2cControllerPort_e = 2;
pub type I2cControllerPort_e = ::core::ffi::c_uint;
pub const I2cControllerName_e_I2C_CONTROLLER_NAME_VR_GFX: I2cControllerName_e = 0;
pub const I2cControllerName_e_I2C_CONTROLLER_NAME_VR_SOC: I2cControllerName_e = 1;
pub const I2cControllerName_e_I2C_CONTROLLER_NAME_VR_VDDCI: I2cControllerName_e = 2;
pub const I2cControllerName_e_I2C_CONTROLLER_NAME_VR_MVDD: I2cControllerName_e = 3;
pub const I2cControllerName_e_I2C_CONTROLLER_NAME_LIQUID0: I2cControllerName_e = 4;
pub const I2cControllerName_e_I2C_CONTROLLER_NAME_LIQUID1: I2cControllerName_e = 5;
pub const I2cControllerName_e_I2C_CONTROLLER_NAME_PLX: I2cControllerName_e = 6;
pub const I2cControllerName_e_I2C_CONTROLLER_NAME_SPARE: I2cControllerName_e = 7;
pub const I2cControllerName_e_I2C_CONTROLLER_NAME_COUNT: I2cControllerName_e = 8;
pub type I2cControllerName_e = ::core::ffi::c_uint;
pub const I2cControllerThrottler_e_I2C_CONTROLLER_THROTTLER_TYPE_NONE: I2cControllerThrottler_e = 0;
pub const I2cControllerThrottler_e_I2C_CONTROLLER_THROTTLER_VR_GFX: I2cControllerThrottler_e = 1;
pub const I2cControllerThrottler_e_I2C_CONTROLLER_THROTTLER_VR_SOC: I2cControllerThrottler_e = 2;
pub const I2cControllerThrottler_e_I2C_CONTROLLER_THROTTLER_VR_VDDCI: I2cControllerThrottler_e = 3;
pub const I2cControllerThrottler_e_I2C_CONTROLLER_THROTTLER_VR_MVDD: I2cControllerThrottler_e = 4;
pub const I2cControllerThrottler_e_I2C_CONTROLLER_THROTTLER_LIQUID0: I2cControllerThrottler_e = 5;
pub const I2cControllerThrottler_e_I2C_CONTROLLER_THROTTLER_LIQUID1: I2cControllerThrottler_e = 6;
pub const I2cControllerThrottler_e_I2C_CONTROLLER_THROTTLER_PLX: I2cControllerThrottler_e = 7;
pub const I2cControllerThrottler_e_I2C_CONTROLLER_THROTTLER_COUNT: I2cControllerThrottler_e = 8;
pub type I2cControllerThrottler_e = ::core::ffi::c_uint;
pub const I2cControllerProtocol_e_I2C_CONTROLLER_PROTOCOL_VR_0: I2cControllerProtocol_e = 0;
pub const I2cControllerProtocol_e_I2C_CONTROLLER_PROTOCOL_VR_1: I2cControllerProtocol_e = 1;
pub const I2cControllerProtocol_e_I2C_CONTROLLER_PROTOCOL_TMP_0: I2cControllerProtocol_e = 2;
pub const I2cControllerProtocol_e_I2C_CONTROLLER_PROTOCOL_TMP_1: I2cControllerProtocol_e = 3;
pub const I2cControllerProtocol_e_I2C_CONTROLLER_PROTOCOL_SPARE_0: I2cControllerProtocol_e = 4;
pub const I2cControllerProtocol_e_I2C_CONTROLLER_PROTOCOL_SPARE_1: I2cControllerProtocol_e = 5;
pub const I2cControllerProtocol_e_I2C_CONTROLLER_PROTOCOL_COUNT: I2cControllerProtocol_e = 6;
pub type I2cControllerProtocol_e = ::core::ffi::c_uint;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct I2cControllerConfig_t {
    pub Enabled: u8,
    pub Speed: u8,
    pub Padding: [u8; 2usize],
    pub SlaveAddress: u32,
    pub ControllerPort: u8,
    pub ControllerName: u8,
    pub ThermalThrotter: u8,
    pub I2cProtocol: u8,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of I2cControllerConfig_t"][::core::mem::size_of::<I2cControllerConfig_t>() - 12usize];
    ["Alignment of I2cControllerConfig_t"]
        [::core::mem::align_of::<I2cControllerConfig_t>() - 4usize];
    ["Offset of field: I2cControllerConfig_t::Enabled"]
        [::core::mem::offset_of!(I2cControllerConfig_t, Enabled) - 0usize];
    ["Offset of field: I2cControllerConfig_t::Speed"]
        [::core::mem::offset_of!(I2cControllerConfig_t, Speed) - 1usize];
    ["Offset of field: I2cControllerConfig_t::Padding"]
        [::core::mem::offset_of!(I2cControllerConfig_t, Padding) - 2usize];
    ["Offset of field: I2cControllerConfig_t::SlaveAddress"]
        [::core::mem::offset_of!(I2cControllerConfig_t, SlaveAddress) - 4usize];
    ["Offset of field: I2cControllerConfig_t::ControllerPort"]
        [::core::mem::offset_of!(I2cControllerConfig_t, ControllerPort) - 8usize];
    ["Offset of field: I2cControllerConfig_t::ControllerName"]
        [::core::mem::offset_of!(I2cControllerConfig_t, ControllerName) - 9usize];
    ["Offset of field: I2cControllerConfig_t::ThermalThrotter"]
        [::core::mem::offset_of!(I2cControllerConfig_t, ThermalThrotter) - 10usize];
    ["Offset of field: I2cControllerConfig_t::I2cProtocol"]
        [::core::mem::offset_of!(I2cControllerConfig_t, I2cProtocol) - 11usize];
};
pub const I2cPort_e_I2C_PORT_SVD_SCL: I2cPort_e = 0;
pub const I2cPort_e_I2C_PORT_GPIO: I2cPort_e = 1;
pub type I2cPort_e = ::core::ffi::c_uint;
pub const I2cSpeed_e_I2C_SPEED_FAST_50K: I2cSpeed_e = 0;
pub const I2cSpeed_e_I2C_SPEED_FAST_100K: I2cSpeed_e = 1;
pub const I2cSpeed_e_I2C_SPEED_FAST_400K: I2cSpeed_e = 2;
pub const I2cSpeed_e_I2C_SPEED_FAST_PLUS_1M: I2cSpeed_e = 3;
pub const I2cSpeed_e_I2C_SPEED_HIGH_1M: I2cSpeed_e = 4;
pub const I2cSpeed_e_I2C_SPEED_HIGH_2M: I2cSpeed_e = 5;
pub const I2cSpeed_e_I2C_SPEED_COUNT: I2cSpeed_e = 6;
pub type I2cSpeed_e = ::core::ffi::c_uint;
pub const I2cCmdType_e_I2C_CMD_READ: I2cCmdType_e = 0;
pub const I2cCmdType_e_I2C_CMD_WRITE: I2cCmdType_e = 1;
pub const I2cCmdType_e_I2C_CMD_COUNT: I2cCmdType_e = 2;
pub type I2cCmdType_e = ::core::ffi::c_uint;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct SwI2cCmd_t {
    pub RegisterAddr: u8,
    #[doc = "only valid for write, ignored for read"]
    pub Cmd: u8,
    pub Data: u8,
    pub CmdConfig: u8,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of SwI2cCmd_t"][::core::mem::size_of::<SwI2cCmd_t>() - 4usize];
    ["Alignment of SwI2cCmd_t"][::core::mem::align_of::<SwI2cCmd_t>() - 1usize];
    ["Offset of field: SwI2cCmd_t::RegisterAddr"]
        [::core::mem::offset_of!(SwI2cCmd_t, RegisterAddr) - 0usize];
    ["Offset of field: SwI2cCmd_t::Cmd"][::core::mem::offset_of!(SwI2cCmd_t, Cmd) - 1usize];
    ["Offset of field: SwI2cCmd_t::Data"][::core::mem::offset_of!(SwI2cCmd_t, Data) - 2usize];
    ["Offset of field: SwI2cCmd_t::CmdConfig"]
        [::core::mem::offset_of!(SwI2cCmd_t, CmdConfig) - 3usize];
};
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct SwI2cRequest_t {
    pub I2CcontrollerPort: u8,
    pub I2CSpeed: u8,
    pub SlaveAddress: u16,
    pub NumCmds: u8,
    pub Padding: [u8; 3usize],
    pub SwI2cCmds: [SwI2cCmd_t; 8usize],
    pub MmHubPadding: [u32; 8usize],
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of SwI2cRequest_t"][::core::mem::size_of::<SwI2cRequest_t>() - 72usize];
    ["Alignment of SwI2cRequest_t"][::core::mem::align_of::<SwI2cRequest_t>() - 4usize];
    ["Offset of field: SwI2cRequest_t::I2CcontrollerPort"]
        [::core::mem::offset_of!(SwI2cRequest_t, I2CcontrollerPort) - 0usize];
    ["Offset of field: SwI2cRequest_t::I2CSpeed"]
        [::core::mem::offset_of!(SwI2cRequest_t, I2CSpeed) - 1usize];
    ["Offset of field: SwI2cRequest_t::SlaveAddress"]
        [::core::mem::offset_of!(SwI2cRequest_t, SlaveAddress) - 2usize];
    ["Offset of field: SwI2cRequest_t::NumCmds"]
        [::core::mem::offset_of!(SwI2cRequest_t, NumCmds) - 4usize];
    ["Offset of field: SwI2cRequest_t::Padding"]
        [::core::mem::offset_of!(SwI2cRequest_t, Padding) - 5usize];
    ["Offset of field: SwI2cRequest_t::SwI2cCmds"]
        [::core::mem::offset_of!(SwI2cRequest_t, SwI2cCmds) - 8usize];
    ["Offset of field: SwI2cRequest_t::MmHubPadding"]
        [::core::mem::offset_of!(SwI2cRequest_t, MmHubPadding) - 40usize];
};
pub const D3HOTSequence_e_BACO_SEQUENCE: D3HOTSequence_e = 0;
pub const D3HOTSequence_e_MSR_SEQUENCE: D3HOTSequence_e = 1;
pub const D3HOTSequence_e_BAMACO_SEQUENCE: D3HOTSequence_e = 2;
pub const D3HOTSequence_e_ULPS_SEQUENCE: D3HOTSequence_e = 3;
pub const D3HOTSequence_e_D3HOT_SEQUENCE_COUNT: D3HOTSequence_e = 4;
pub type D3HOTSequence_e = ::core::ffi::c_uint;
pub const PowerGatingMode_e_PG_DYNAMIC_MODE: PowerGatingMode_e = 0;
pub const PowerGatingMode_e_PG_STATIC_MODE: PowerGatingMode_e = 1;
pub type PowerGatingMode_e = ::core::ffi::c_uint;
pub const PowerGatingSettings_e_PG_POWER_DOWN: PowerGatingSettings_e = 0;
pub const PowerGatingSettings_e_PG_POWER_UP: PowerGatingSettings_e = 1;
pub type PowerGatingSettings_e = ::core::ffi::c_uint;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct QuadraticInt_t {
    pub a: u32,
    pub b: u32,
    pub c: u32,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of QuadraticInt_t"][::core::mem::size_of::<QuadraticInt_t>() - 12usize];
    ["Alignment of QuadraticInt_t"][::core::mem::align_of::<QuadraticInt_t>() - 4usize];
    ["Offset of field: QuadraticInt_t::a"][::core::mem::offset_of!(QuadraticInt_t, a) - 0usize];
    ["Offset of field: QuadraticInt_t::b"][::core::mem::offset_of!(QuadraticInt_t, b) - 4usize];
    ["Offset of field: QuadraticInt_t::c"][::core::mem::offset_of!(QuadraticInt_t, c) - 8usize];
};
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct LinearInt_t {
    pub m: u32,
    pub b: u32,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of LinearInt_t"][::core::mem::size_of::<LinearInt_t>() - 8usize];
    ["Alignment of LinearInt_t"][::core::mem::align_of::<LinearInt_t>() - 4usize];
    ["Offset of field: LinearInt_t::m"][::core::mem::offset_of!(LinearInt_t, m) - 0usize];
    ["Offset of field: LinearInt_t::b"][::core::mem::offset_of!(LinearInt_t, b) - 4usize];
};
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct DroopInt_t {
    pub a: u32,
    pub b: u32,
    pub c: u32,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of DroopInt_t"][::core::mem::size_of::<DroopInt_t>() - 12usize];
    ["Alignment of DroopInt_t"][::core::mem::align_of::<DroopInt_t>() - 4usize];
    ["Offset of field: DroopInt_t::a"][::core::mem::offset_of!(DroopInt_t, a) - 0usize];
    ["Offset of field: DroopInt_t::b"][::core::mem::offset_of!(DroopInt_t, b) - 4usize];
    ["Offset of field: DroopInt_t::c"][::core::mem::offset_of!(DroopInt_t, c) - 8usize];
};
pub const GfxclkSrc_e_GFXCLK_SOURCE_PLL: GfxclkSrc_e = 0;
pub const GfxclkSrc_e_GFXCLK_SOURCE_DFLL: GfxclkSrc_e = 1;
pub const GfxclkSrc_e_GFXCLK_SOURCE_COUNT: GfxclkSrc_e = 2;
pub type GfxclkSrc_e = ::core::ffi::c_uint;
pub const PPCLK_e_PPCLK_GFXCLK: PPCLK_e = 0;
pub const PPCLK_e_PPCLK_SOCCLK: PPCLK_e = 1;
pub const PPCLK_e_PPCLK_UCLK: PPCLK_e = 2;
pub const PPCLK_e_PPCLK_DCLK: PPCLK_e = 3;
pub const PPCLK_e_PPCLK_VCLK: PPCLK_e = 4;
pub const PPCLK_e_PPCLK_DCEFCLK: PPCLK_e = 5;
pub const PPCLK_e_PPCLK_DISPCLK: PPCLK_e = 6;
pub const PPCLK_e_PPCLK_PIXCLK: PPCLK_e = 7;
pub const PPCLK_e_PPCLK_PHYCLK: PPCLK_e = 8;
pub const PPCLK_e_PPCLK_COUNT: PPCLK_e = 9;
pub type PPCLK_e = ::core::ffi::c_uint;
pub const POWER_SOURCE_e_POWER_SOURCE_AC: POWER_SOURCE_e = 0;
pub const POWER_SOURCE_e_POWER_SOURCE_DC: POWER_SOURCE_e = 1;
pub const POWER_SOURCE_e_POWER_SOURCE_COUNT: POWER_SOURCE_e = 2;
pub type POWER_SOURCE_e = ::core::ffi::c_uint;
pub const PPT_THROTTLER_e_PPT_THROTTLER_PPT0: PPT_THROTTLER_e = 0;
pub const PPT_THROTTLER_e_PPT_THROTTLER_PPT1: PPT_THROTTLER_e = 1;
pub const PPT_THROTTLER_e_PPT_THROTTLER_PPT2: PPT_THROTTLER_e = 2;
pub const PPT_THROTTLER_e_PPT_THROTTLER_PPT3: PPT_THROTTLER_e = 3;
pub const PPT_THROTTLER_e_PPT_THROTTLER_COUNT: PPT_THROTTLER_e = 4;
pub type PPT_THROTTLER_e = ::core::ffi::c_uint;
pub const VOLTAGE_MODE_e_VOLTAGE_MODE_AVFS: VOLTAGE_MODE_e = 0;
pub const VOLTAGE_MODE_e_VOLTAGE_MODE_AVFS_SS: VOLTAGE_MODE_e = 1;
pub const VOLTAGE_MODE_e_VOLTAGE_MODE_SS: VOLTAGE_MODE_e = 2;
pub const VOLTAGE_MODE_e_VOLTAGE_MODE_COUNT: VOLTAGE_MODE_e = 3;
pub type VOLTAGE_MODE_e = ::core::ffi::c_uint;
pub const AVFS_VOLTAGE_TYPE_e_AVFS_VOLTAGE_GFX: AVFS_VOLTAGE_TYPE_e = 0;
pub const AVFS_VOLTAGE_TYPE_e_AVFS_VOLTAGE_SOC: AVFS_VOLTAGE_TYPE_e = 1;
pub const AVFS_VOLTAGE_TYPE_e_AVFS_VOLTAGE_COUNT: AVFS_VOLTAGE_TYPE_e = 2;
pub type AVFS_VOLTAGE_TYPE_e = ::core::ffi::c_uint;
pub const UCLK_DIV_e_UCLK_DIV_BY_1: UCLK_DIV_e = 0;
pub const UCLK_DIV_e_UCLK_DIV_BY_2: UCLK_DIV_e = 1;
pub const UCLK_DIV_e_UCLK_DIV_BY_4: UCLK_DIV_e = 2;
pub const UCLK_DIV_e_UCLK_DIV_BY_8: UCLK_DIV_e = 3;
pub type UCLK_DIV_e = ::core::ffi::c_uint;
pub const GpioIntPolarity_e_GPIO_INT_POLARITY_ACTIVE_LOW: GpioIntPolarity_e = 0;
pub const GpioIntPolarity_e_GPIO_INT_POLARITY_ACTIVE_HIGH: GpioIntPolarity_e = 1;
pub type GpioIntPolarity_e = ::core::ffi::c_uint;
pub const MemoryType_e_MEMORY_TYPE_GDDR6: MemoryType_e = 0;
pub const MemoryType_e_MEMORY_TYPE_HBM: MemoryType_e = 1;
pub type MemoryType_e = ::core::ffi::c_uint;
pub const PwrConfig_e_PWR_CONFIG_TDP: PwrConfig_e = 0;
pub const PwrConfig_e_PWR_CONFIG_TGP: PwrConfig_e = 1;
pub const PwrConfig_e_PWR_CONFIG_TCP_ESTIMATED: PwrConfig_e = 2;
pub const PwrConfig_e_PWR_CONFIG_TCP_MEASURED: PwrConfig_e = 3;
pub type PwrConfig_e = ::core::ffi::c_uint;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct DpmDescriptor_t {
    pub VoltageMode: u8,
    pub SnapToDiscrete: u8,
    pub NumDiscreteLevels: u8,
    pub Padding: u8,
    pub ConversionToAvfsClk: LinearInt_t,
    pub SsCurve: QuadraticInt_t,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of DpmDescriptor_t"][::core::mem::size_of::<DpmDescriptor_t>() - 24usize];
    ["Alignment of DpmDescriptor_t"][::core::mem::align_of::<DpmDescriptor_t>() - 4usize];
    ["Offset of field: DpmDescriptor_t::VoltageMode"]
        [::core::mem::offset_of!(DpmDescriptor_t, VoltageMode) - 0usize];
    ["Offset of field: DpmDescriptor_t::SnapToDiscrete"]
        [::core::mem::offset_of!(DpmDescriptor_t, SnapToDiscrete) - 1usize];
    ["Offset of field: DpmDescriptor_t::NumDiscreteLevels"]
        [::core::mem::offset_of!(DpmDescriptor_t, NumDiscreteLevels) - 2usize];
    ["Offset of field: DpmDescriptor_t::Padding"]
        [::core::mem::offset_of!(DpmDescriptor_t, Padding) - 3usize];
    ["Offset of field: DpmDescriptor_t::ConversionToAvfsClk"]
        [::core::mem::offset_of!(DpmDescriptor_t, ConversionToAvfsClk) - 4usize];
    ["Offset of field: DpmDescriptor_t::SsCurve"]
        [::core::mem::offset_of!(DpmDescriptor_t, SsCurve) - 12usize];
};
pub const TEMP_e_TEMP_EDGE: TEMP_e = 0;
pub const TEMP_e_TEMP_HOTSPOT: TEMP_e = 1;
pub const TEMP_e_TEMP_MEM: TEMP_e = 2;
pub const TEMP_e_TEMP_VR_GFX: TEMP_e = 3;
pub const TEMP_e_TEMP_VR_MEM0: TEMP_e = 4;
pub const TEMP_e_TEMP_VR_MEM1: TEMP_e = 5;
pub const TEMP_e_TEMP_VR_SOC: TEMP_e = 6;
pub const TEMP_e_TEMP_LIQUID0: TEMP_e = 7;
pub const TEMP_e_TEMP_LIQUID1: TEMP_e = 8;
pub const TEMP_e_TEMP_PLX: TEMP_e = 9;
pub const TEMP_e_TEMP_COUNT: TEMP_e = 10;
pub type TEMP_e = ::core::ffi::c_uint;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct OutOfBandMonitor_t {
    pub MinorInfoVersion: u8,
    pub MajorInfoVersion: u8,
    pub TableSize: u8,
    pub Reserved: u8,
    pub Reserved1: u8,
    pub RevID: u8,
    pub DeviceID: u16,
    pub DieTemperatureLimit: u16,
    pub FanTargetTemperature: u16,
    pub MemoryTemperatureLimit: u16,
    pub MemoryTemperatureLimit1: u16,
    pub TGP: u16,
    pub CardPower: u16,
    pub DieTemperatureRegisterOffset: u32,
    pub Reserved2: u32,
    pub Reserved3: u32,
    pub Status: u32,
    pub DieTemperature: u16,
    pub CurrentMemoryTemperature: u16,
    pub MemoryTemperature: u16,
    pub MemoryHotspotPosition: u8,
    pub Reserved4: u8,
    pub BoardLevelEnergyAccumulator: u32,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of OutOfBandMonitor_t"][::core::mem::size_of::<OutOfBandMonitor_t>() - 48usize];
    ["Alignment of OutOfBandMonitor_t"][::core::mem::align_of::<OutOfBandMonitor_t>() - 4usize];
    ["Offset of field: OutOfBandMonitor_t::MinorInfoVersion"]
        [::core::mem::offset_of!(OutOfBandMonitor_t, MinorInfoVersion) - 0usize];
    ["Offset of field: OutOfBandMonitor_t::MajorInfoVersion"]
        [::core::mem::offset_of!(OutOfBandMonitor_t, MajorInfoVersion) - 1usize];
    ["Offset of field: OutOfBandMonitor_t::TableSize"]
        [::core::mem::offset_of!(OutOfBandMonitor_t, TableSize) - 2usize];
    ["Offset of field: OutOfBandMonitor_t::Reserved"]
        [::core::mem::offset_of!(OutOfBandMonitor_t, Reserved) - 3usize];
    ["Offset of field: OutOfBandMonitor_t::Reserved1"]
        [::core::mem::offset_of!(OutOfBandMonitor_t, Reserved1) - 4usize];
    ["Offset of field: OutOfBandMonitor_t::RevID"]
        [::core::mem::offset_of!(OutOfBandMonitor_t, RevID) - 5usize];
    ["Offset of field: OutOfBandMonitor_t::DeviceID"]
        [::core::mem::offset_of!(OutOfBandMonitor_t, DeviceID) - 6usize];
    ["Offset of field: OutOfBandMonitor_t::DieTemperatureLimit"]
        [::core::mem::offset_of!(OutOfBandMonitor_t, DieTemperatureLimit) - 8usize];
    ["Offset of field: OutOfBandMonitor_t::FanTargetTemperature"]
        [::core::mem::offset_of!(OutOfBandMonitor_t, FanTargetTemperature) - 10usize];
    ["Offset of field: OutOfBandMonitor_t::MemoryTemperatureLimit"]
        [::core::mem::offset_of!(OutOfBandMonitor_t, MemoryTemperatureLimit) - 12usize];
    ["Offset of field: OutOfBandMonitor_t::MemoryTemperatureLimit1"]
        [::core::mem::offset_of!(OutOfBandMonitor_t, MemoryTemperatureLimit1) - 14usize];
    ["Offset of field: OutOfBandMonitor_t::TGP"]
        [::core::mem::offset_of!(OutOfBandMonitor_t, TGP) - 16usize];
    ["Offset of field: OutOfBandMonitor_t::CardPower"]
        [::core::mem::offset_of!(OutOfBandMonitor_t, CardPower) - 18usize];
    ["Offset of field: OutOfBandMonitor_t::DieTemperatureRegisterOffset"]
        [::core::mem::offset_of!(OutOfBandMonitor_t, DieTemperatureRegisterOffset) - 20usize];
    ["Offset of field: OutOfBandMonitor_t::Reserved2"]
        [::core::mem::offset_of!(OutOfBandMonitor_t, Reserved2) - 24usize];
    ["Offset of field: OutOfBandMonitor_t::Reserved3"]
        [::core::mem::offset_of!(OutOfBandMonitor_t, Reserved3) - 28usize];
    ["Offset of field: OutOfBandMonitor_t::Status"]
        [::core::mem::offset_of!(OutOfBandMonitor_t, Status) - 32usize];
    ["Offset of field: OutOfBandMonitor_t::DieTemperature"]
        [::core::mem::offset_of!(OutOfBandMonitor_t, DieTemperature) - 36usize];
    ["Offset of field: OutOfBandMonitor_t::CurrentMemoryTemperature"]
        [::core::mem::offset_of!(OutOfBandMonitor_t, CurrentMemoryTemperature) - 38usize];
    ["Offset of field: OutOfBandMonitor_t::MemoryTemperature"]
        [::core::mem::offset_of!(OutOfBandMonitor_t, MemoryTemperature) - 40usize];
    ["Offset of field: OutOfBandMonitor_t::MemoryHotspotPosition"]
        [::core::mem::offset_of!(OutOfBandMonitor_t, MemoryHotspotPosition) - 42usize];
    ["Offset of field: OutOfBandMonitor_t::Reserved4"]
        [::core::mem::offset_of!(OutOfBandMonitor_t, Reserved4) - 43usize];
    ["Offset of field: OutOfBandMonitor_t::BoardLevelEnergyAccumulator"]
        [::core::mem::offset_of!(OutOfBandMonitor_t, BoardLevelEnergyAccumulator) - 44usize];
};
#[repr(C, packed)]
#[derive(Debug, Copy, Clone)]
pub struct PPTable_t {
    pub Version: u32,
    pub FeaturesToRun: [u32; 2usize],
    pub SocketPowerLimitAc: [u16; 4usize],
    pub SocketPowerLimitAcTau: [u16; 4usize],
    pub SocketPowerLimitDc: [u16; 4usize],
    pub SocketPowerLimitDcTau: [u16; 4usize],
    pub TdcLimitSoc: u16,
    pub TdcLimitSocTau: u16,
    pub TdcLimitGfx: u16,
    pub TdcLimitGfxTau: u16,
    pub TedgeLimit: u16,
    pub ThotspotLimit: u16,
    pub TmemLimit: u16,
    pub Tvr_gfxLimit: u16,
    pub Tvr_mem0Limit: u16,
    pub Tvr_mem1Limit: u16,
    pub Tvr_socLimit: u16,
    pub Tliquid0Limit: u16,
    pub Tliquid1Limit: u16,
    pub TplxLimit: u16,
    pub FitLimit: u32,
    pub PpmPowerLimit: u16,
    pub PpmTemperatureThreshold: u16,
    pub ThrottlerControlMask: u32,
    pub FwDStateMask: u32,
    pub UlvVoltageOffsetSoc: u16,
    pub UlvVoltageOffsetGfx: u16,
    pub GceaLinkMgrIdleThreshold: u8,
    pub paddingRlcUlvParams: [u8; 3usize],
    pub UlvSmnclkDid: u8,
    pub UlvMp1clkDid: u8,
    pub UlvGfxclkBypass: u8,
    pub Padding234: u8,
    pub MinVoltageUlvGfx: u16,
    pub MinVoltageUlvSoc: u16,
    pub MinVoltageGfx: u16,
    pub MinVoltageSoc: u16,
    pub MaxVoltageGfx: u16,
    pub MaxVoltageSoc: u16,
    pub LoadLineResistanceGfx: u16,
    pub LoadLineResistanceSoc: u16,
    pub DpmDescriptor: [DpmDescriptor_t; 9usize],
    pub FreqTableGfx: [u16; 16usize],
    pub FreqTableVclk: [u16; 8usize],
    pub FreqTableDclk: [u16; 8usize],
    pub FreqTableSocclk: [u16; 8usize],
    pub FreqTableUclk: [u16; 4usize],
    pub FreqTableDcefclk: [u16; 8usize],
    pub FreqTableDispclk: [u16; 8usize],
    pub FreqTablePixclk: [u16; 8usize],
    pub FreqTablePhyclk: [u16; 8usize],
    pub Paddingclks: [u32; 16usize],
    pub DcModeMaxFreq: [u16; 9usize],
    pub Padding8_Clks: u16,
    pub FreqTableUclkDiv: [u8; 4usize],
    pub Mp0clkFreq: [u16; 2usize],
    pub Mp0DpmVoltage: [u16; 2usize],
    pub MemVddciVoltage: [u16; 4usize],
    pub MemMvddVoltage: [u16; 4usize],
    pub GfxclkFgfxoffEntry: u16,
    pub GfxclkFinit: u16,
    pub GfxclkFidle: u16,
    pub GfxclkSlewRate: u16,
    pub GfxclkFopt: u16,
    pub Padding567: [u8; 2usize],
    pub GfxclkDsMaxFreq: u16,
    pub GfxclkSource: u8,
    pub Padding456: u8,
    pub LowestUclkReservedForUlv: u8,
    pub paddingUclk: [u8; 3usize],
    pub MemoryType: u8,
    pub MemoryChannels: u8,
    pub PaddingMem: [u8; 2usize],
    #[doc = "< 0:PciE-gen1 1:PciE-gen2 2:PciE-gen3 3:PciE-gen4"]
    pub PcieGenSpeed: [u8; 2usize],
    #[doc = "< 1=x1, 2=x2, 3=x4, 4=x8, 5=x12, 6=x16"]
    pub PcieLaneCount: [u8; 2usize],
    pub LclkFreq: [u16; 2usize],
    pub EnableTdpm: u16,
    pub TdpmHighHystTemperature: u16,
    pub TdpmLowHystTemperature: u16,
    pub GfxclkFreqHighTempLimit: u16,
    pub FanStopTemp: u16,
    pub FanStartTemp: u16,
    pub FanGainEdge: u16,
    pub FanGainHotspot: u16,
    pub FanGainLiquid0: u16,
    pub FanGainLiquid1: u16,
    pub FanGainVrGfx: u16,
    pub FanGainVrSoc: u16,
    pub FanGainVrMem0: u16,
    pub FanGainVrMem1: u16,
    pub FanGainPlx: u16,
    pub FanGainMem: u16,
    pub FanPwmMin: u16,
    pub FanAcousticLimitRpm: u16,
    pub FanThrottlingRpm: u16,
    pub FanMaximumRpm: u16,
    pub FanTargetTemperature: u16,
    pub FanTargetGfxclk: u16,
    pub FanTempInputSelect: u8,
    pub FanPadding: u8,
    pub FanZeroRpmEnable: u8,
    pub FanTachEdgePerRev: u8,
    pub FuzzyFan_ErrorSetDelta: i16,
    pub FuzzyFan_ErrorRateSetDelta: i16,
    pub FuzzyFan_PwmSetDelta: i16,
    pub FuzzyFan_Reserved: u16,
    pub OverrideAvfsGb: [u8; 2usize],
    pub Padding8_Avfs: [u8; 2usize],
    pub qAvfsGb: [QuadraticInt_t; 2usize],
    pub dBtcGbGfxPll: DroopInt_t,
    pub dBtcGbGfxDfll: DroopInt_t,
    pub dBtcGbSoc: DroopInt_t,
    pub qAgingGb: [LinearInt_t; 2usize],
    pub qStaticVoltageOffset: [QuadraticInt_t; 2usize],
    pub DcTol: [u16; 2usize],
    pub DcBtcEnabled: [u8; 2usize],
    pub Padding8_GfxBtc: [u8; 2usize],
    pub DcBtcMin: [u16; 2usize],
    pub DcBtcMax: [u16; 2usize],
    pub DebugOverrides: u32,
    pub ReservedEquation0: QuadraticInt_t,
    pub ReservedEquation1: QuadraticInt_t,
    pub ReservedEquation2: QuadraticInt_t,
    pub ReservedEquation3: QuadraticInt_t,
    pub TotalPowerConfig: u8,
    pub TotalPowerSpare1: u8,
    pub TotalPowerSpare2: u16,
    pub PccThresholdLow: u16,
    pub PccThresholdHigh: u16,
    pub MGpuFanBoostLimitRpm: u32,
    pub PaddingAPCC: [u32; 5usize],
    pub VDDGFX_TVmin: u16,
    pub VDDSOC_TVmin: u16,
    pub VDDGFX_Vmin_HiTemp: u16,
    pub VDDGFX_Vmin_LoTemp: u16,
    pub VDDSOC_Vmin_HiTemp: u16,
    pub VDDSOC_Vmin_LoTemp: u16,
    pub VDDGFX_TVminHystersis: u16,
    pub VDDSOC_TVminHystersis: u16,
    pub BtcConfig: u32,
    pub SsFmin: [u16; 10usize],
    pub DcBtcGb: [u16; 2usize],
    pub Reserved: [u32; 8usize],
    pub I2cControllers: [I2cControllerConfig_t; 8usize],
    pub MaxVoltageStepGfx: u16,
    pub MaxVoltageStepSoc: u16,
    pub VddGfxVrMapping: u8,
    pub VddSocVrMapping: u8,
    pub VddMem0VrMapping: u8,
    pub VddMem1VrMapping: u8,
    pub GfxUlvPhaseSheddingMask: u8,
    pub SocUlvPhaseSheddingMask: u8,
    pub ExternalSensorPresent: u8,
    pub Padding8_V: u8,
    pub GfxMaxCurrent: u16,
    pub GfxOffset: i8,
    pub Padding_TelemetryGfx: u8,
    pub SocMaxCurrent: u16,
    pub SocOffset: i8,
    pub Padding_TelemetrySoc: u8,
    pub Mem0MaxCurrent: u16,
    pub Mem0Offset: i8,
    pub Padding_TelemetryMem0: u8,
    pub Mem1MaxCurrent: u16,
    pub Mem1Offset: i8,
    pub Padding_TelemetryMem1: u8,
    pub AcDcGpio: u8,
    pub AcDcPolarity: u8,
    pub VR0HotGpio: u8,
    pub VR0HotPolarity: u8,
    pub VR1HotGpio: u8,
    pub VR1HotPolarity: u8,
    pub GthrGpio: u8,
    pub GthrPolarity: u8,
    pub LedPin0: u8,
    pub LedPin1: u8,
    pub LedPin2: u8,
    pub padding8_4: u8,
    pub PllGfxclkSpreadEnabled: u8,
    pub PllGfxclkSpreadPercent: u8,
    pub PllGfxclkSpreadFreq: u16,
    pub DfllGfxclkSpreadEnabled: u8,
    pub DfllGfxclkSpreadPercent: u8,
    pub DfllGfxclkSpreadFreq: u16,
    pub UclkSpreadEnabled: u8,
    pub UclkSpreadPercent: u8,
    pub UclkSpreadFreq: u16,
    pub SoclkSpreadEnabled: u8,
    pub SocclkSpreadPercent: u8,
    pub SocclkSpreadFreq: u16,
    pub TotalBoardPower: u16,
    pub BoardPadding: u16,
    pub MvddRatio: u32,
    pub RenesesLoadLineEnabled: u8,
    pub GfxLoadlineResistance: u8,
    pub SocLoadlineResistance: u8,
    pub Padding8_Loadline: u8,
    pub BoardReserved: [u32; 8usize],
    pub MmHubPadding: [u32; 8usize],
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of PPTable_t"][::core::mem::size_of::<PPTable_t>() - 1192usize];
    ["Alignment of PPTable_t"][::core::mem::align_of::<PPTable_t>() - 1usize];
    ["Offset of field: PPTable_t::Version"][::core::mem::offset_of!(PPTable_t, Version) - 0usize];
    ["Offset of field: PPTable_t::FeaturesToRun"]
        [::core::mem::offset_of!(PPTable_t, FeaturesToRun) - 4usize];
    ["Offset of field: PPTable_t::SocketPowerLimitAc"]
        [::core::mem::offset_of!(PPTable_t, SocketPowerLimitAc) - 12usize];
    ["Offset of field: PPTable_t::SocketPowerLimitAcTau"]
        [::core::mem::offset_of!(PPTable_t, SocketPowerLimitAcTau) - 20usize];
    ["Offset of field: PPTable_t::SocketPowerLimitDc"]
        [::core::mem::offset_of!(PPTable_t, SocketPowerLimitDc) - 28usize];
    ["Offset of field: PPTable_t::SocketPowerLimitDcTau"]
        [::core::mem::offset_of!(PPTable_t, SocketPowerLimitDcTau) - 36usize];
    ["Offset of field: PPTable_t::TdcLimitSoc"]
        [::core::mem::offset_of!(PPTable_t, TdcLimitSoc) - 44usize];
    ["Offset of field: PPTable_t::TdcLimitSocTau"]
        [::core::mem::offset_of!(PPTable_t, TdcLimitSocTau) - 46usize];
    ["Offset of field: PPTable_t::TdcLimitGfx"]
        [::core::mem::offset_of!(PPTable_t, TdcLimitGfx) - 48usize];
    ["Offset of field: PPTable_t::TdcLimitGfxTau"]
        [::core::mem::offset_of!(PPTable_t, TdcLimitGfxTau) - 50usize];
    ["Offset of field: PPTable_t::TedgeLimit"]
        [::core::mem::offset_of!(PPTable_t, TedgeLimit) - 52usize];
    ["Offset of field: PPTable_t::ThotspotLimit"]
        [::core::mem::offset_of!(PPTable_t, ThotspotLimit) - 54usize];
    ["Offset of field: PPTable_t::TmemLimit"]
        [::core::mem::offset_of!(PPTable_t, TmemLimit) - 56usize];
    ["Offset of field: PPTable_t::Tvr_gfxLimit"]
        [::core::mem::offset_of!(PPTable_t, Tvr_gfxLimit) - 58usize];
    ["Offset of field: PPTable_t::Tvr_mem0Limit"]
        [::core::mem::offset_of!(PPTable_t, Tvr_mem0Limit) - 60usize];
    ["Offset of field: PPTable_t::Tvr_mem1Limit"]
        [::core::mem::offset_of!(PPTable_t, Tvr_mem1Limit) - 62usize];
    ["Offset of field: PPTable_t::Tvr_socLimit"]
        [::core::mem::offset_of!(PPTable_t, Tvr_socLimit) - 64usize];
    ["Offset of field: PPTable_t::Tliquid0Limit"]
        [::core::mem::offset_of!(PPTable_t, Tliquid0Limit) - 66usize];
    ["Offset of field: PPTable_t::Tliquid1Limit"]
        [::core::mem::offset_of!(PPTable_t, Tliquid1Limit) - 68usize];
    ["Offset of field: PPTable_t::TplxLimit"]
        [::core::mem::offset_of!(PPTable_t, TplxLimit) - 70usize];
    ["Offset of field: PPTable_t::FitLimit"]
        [::core::mem::offset_of!(PPTable_t, FitLimit) - 72usize];
    ["Offset of field: PPTable_t::PpmPowerLimit"]
        [::core::mem::offset_of!(PPTable_t, PpmPowerLimit) - 76usize];
    ["Offset of field: PPTable_t::PpmTemperatureThreshold"]
        [::core::mem::offset_of!(PPTable_t, PpmTemperatureThreshold) - 78usize];
    ["Offset of field: PPTable_t::ThrottlerControlMask"]
        [::core::mem::offset_of!(PPTable_t, ThrottlerControlMask) - 80usize];
    ["Offset of field: PPTable_t::FwDStateMask"]
        [::core::mem::offset_of!(PPTable_t, FwDStateMask) - 84usize];
    ["Offset of field: PPTable_t::UlvVoltageOffsetSoc"]
        [::core::mem::offset_of!(PPTable_t, UlvVoltageOffsetSoc) - 88usize];
    ["Offset of field: PPTable_t::UlvVoltageOffsetGfx"]
        [::core::mem::offset_of!(PPTable_t, UlvVoltageOffsetGfx) - 90usize];
    ["Offset of field: PPTable_t::GceaLinkMgrIdleThreshold"]
        [::core::mem::offset_of!(PPTable_t, GceaLinkMgrIdleThreshold) - 92usize];
    ["Offset of field: PPTable_t::paddingRlcUlvParams"]
        [::core::mem::offset_of!(PPTable_t, paddingRlcUlvParams) - 93usize];
    ["Offset of field: PPTable_t::UlvSmnclkDid"]
        [::core::mem::offset_of!(PPTable_t, UlvSmnclkDid) - 96usize];
    ["Offset of field: PPTable_t::UlvMp1clkDid"]
        [::core::mem::offset_of!(PPTable_t, UlvMp1clkDid) - 97usize];
    ["Offset of field: PPTable_t::UlvGfxclkBypass"]
        [::core::mem::offset_of!(PPTable_t, UlvGfxclkBypass) - 98usize];
    ["Offset of field: PPTable_t::Padding234"]
        [::core::mem::offset_of!(PPTable_t, Padding234) - 99usize];
    ["Offset of field: PPTable_t::MinVoltageUlvGfx"]
        [::core::mem::offset_of!(PPTable_t, MinVoltageUlvGfx) - 100usize];
    ["Offset of field: PPTable_t::MinVoltageUlvSoc"]
        [::core::mem::offset_of!(PPTable_t, MinVoltageUlvSoc) - 102usize];
    ["Offset of field: PPTable_t::MinVoltageGfx"]
        [::core::mem::offset_of!(PPTable_t, MinVoltageGfx) - 104usize];
    ["Offset of field: PPTable_t::MinVoltageSoc"]
        [::core::mem::offset_of!(PPTable_t, MinVoltageSoc) - 106usize];
    ["Offset of field: PPTable_t::MaxVoltageGfx"]
        [::core::mem::offset_of!(PPTable_t, MaxVoltageGfx) - 108usize];
    ["Offset of field: PPTable_t::MaxVoltageSoc"]
        [::core::mem::offset_of!(PPTable_t, MaxVoltageSoc) - 110usize];
    ["Offset of field: PPTable_t::LoadLineResistanceGfx"]
        [::core::mem::offset_of!(PPTable_t, LoadLineResistanceGfx) - 112usize];
    ["Offset of field: PPTable_t::LoadLineResistanceSoc"]
        [::core::mem::offset_of!(PPTable_t, LoadLineResistanceSoc) - 114usize];
    ["Offset of field: PPTable_t::DpmDescriptor"]
        [::core::mem::offset_of!(PPTable_t, DpmDescriptor) - 116usize];
    ["Offset of field: PPTable_t::FreqTableGfx"]
        [::core::mem::offset_of!(PPTable_t, FreqTableGfx) - 332usize];
    ["Offset of field: PPTable_t::FreqTableVclk"]
        [::core::mem::offset_of!(PPTable_t, FreqTableVclk) - 364usize];
    ["Offset of field: PPTable_t::FreqTableDclk"]
        [::core::mem::offset_of!(PPTable_t, FreqTableDclk) - 380usize];
    ["Offset of field: PPTable_t::FreqTableSocclk"]
        [::core::mem::offset_of!(PPTable_t, FreqTableSocclk) - 396usize];
    ["Offset of field: PPTable_t::FreqTableUclk"]
        [::core::mem::offset_of!(PPTable_t, FreqTableUclk) - 412usize];
    ["Offset of field: PPTable_t::FreqTableDcefclk"]
        [::core::mem::offset_of!(PPTable_t, FreqTableDcefclk) - 420usize];
    ["Offset of field: PPTable_t::FreqTableDispclk"]
        [::core::mem::offset_of!(PPTable_t, FreqTableDispclk) - 436usize];
    ["Offset of field: PPTable_t::FreqTablePixclk"]
        [::core::mem::offset_of!(PPTable_t, FreqTablePixclk) - 452usize];
    ["Offset of field: PPTable_t::FreqTablePhyclk"]
        [::core::mem::offset_of!(PPTable_t, FreqTablePhyclk) - 468usize];
    ["Offset of field: PPTable_t::Paddingclks"]
        [::core::mem::offset_of!(PPTable_t, Paddingclks) - 484usize];
    ["Offset of field: PPTable_t::DcModeMaxFreq"]
        [::core::mem::offset_of!(PPTable_t, DcModeMaxFreq) - 548usize];
    ["Offset of field: PPTable_t::Padding8_Clks"]
        [::core::mem::offset_of!(PPTable_t, Padding8_Clks) - 566usize];
    ["Offset of field: PPTable_t::FreqTableUclkDiv"]
        [::core::mem::offset_of!(PPTable_t, FreqTableUclkDiv) - 568usize];
    ["Offset of field: PPTable_t::Mp0clkFreq"]
        [::core::mem::offset_of!(PPTable_t, Mp0clkFreq) - 572usize];
    ["Offset of field: PPTable_t::Mp0DpmVoltage"]
        [::core::mem::offset_of!(PPTable_t, Mp0DpmVoltage) - 576usize];
    ["Offset of field: PPTable_t::MemVddciVoltage"]
        [::core::mem::offset_of!(PPTable_t, MemVddciVoltage) - 580usize];
    ["Offset of field: PPTable_t::MemMvddVoltage"]
        [::core::mem::offset_of!(PPTable_t, MemMvddVoltage) - 588usize];
    ["Offset of field: PPTable_t::GfxclkFgfxoffEntry"]
        [::core::mem::offset_of!(PPTable_t, GfxclkFgfxoffEntry) - 596usize];
    ["Offset of field: PPTable_t::GfxclkFinit"]
        [::core::mem::offset_of!(PPTable_t, GfxclkFinit) - 598usize];
    ["Offset of field: PPTable_t::GfxclkFidle"]
        [::core::mem::offset_of!(PPTable_t, GfxclkFidle) - 600usize];
    ["Offset of field: PPTable_t::GfxclkSlewRate"]
        [::core::mem::offset_of!(PPTable_t, GfxclkSlewRate) - 602usize];
    ["Offset of field: PPTable_t::GfxclkFopt"]
        [::core::mem::offset_of!(PPTable_t, GfxclkFopt) - 604usize];
    ["Offset of field: PPTable_t::Padding567"]
        [::core::mem::offset_of!(PPTable_t, Padding567) - 606usize];
    ["Offset of field: PPTable_t::GfxclkDsMaxFreq"]
        [::core::mem::offset_of!(PPTable_t, GfxclkDsMaxFreq) - 608usize];
    ["Offset of field: PPTable_t::GfxclkSource"]
        [::core::mem::offset_of!(PPTable_t, GfxclkSource) - 610usize];
    ["Offset of field: PPTable_t::Padding456"]
        [::core::mem::offset_of!(PPTable_t, Padding456) - 611usize];
    ["Offset of field: PPTable_t::LowestUclkReservedForUlv"]
        [::core::mem::offset_of!(PPTable_t, LowestUclkReservedForUlv) - 612usize];
    ["Offset of field: PPTable_t::paddingUclk"]
        [::core::mem::offset_of!(PPTable_t, paddingUclk) - 613usize];
    ["Offset of field: PPTable_t::MemoryType"]
        [::core::mem::offset_of!(PPTable_t, MemoryType) - 616usize];
    ["Offset of field: PPTable_t::MemoryChannels"]
        [::core::mem::offset_of!(PPTable_t, MemoryChannels) - 617usize];
    ["Offset of field: PPTable_t::PaddingMem"]
        [::core::mem::offset_of!(PPTable_t, PaddingMem) - 618usize];
    ["Offset of field: PPTable_t::PcieGenSpeed"]
        [::core::mem::offset_of!(PPTable_t, PcieGenSpeed) - 620usize];
    ["Offset of field: PPTable_t::PcieLaneCount"]
        [::core::mem::offset_of!(PPTable_t, PcieLaneCount) - 622usize];
    ["Offset of field: PPTable_t::LclkFreq"]
        [::core::mem::offset_of!(PPTable_t, LclkFreq) - 624usize];
    ["Offset of field: PPTable_t::EnableTdpm"]
        [::core::mem::offset_of!(PPTable_t, EnableTdpm) - 628usize];
    ["Offset of field: PPTable_t::TdpmHighHystTemperature"]
        [::core::mem::offset_of!(PPTable_t, TdpmHighHystTemperature) - 630usize];
    ["Offset of field: PPTable_t::TdpmLowHystTemperature"]
        [::core::mem::offset_of!(PPTable_t, TdpmLowHystTemperature) - 632usize];
    ["Offset of field: PPTable_t::GfxclkFreqHighTempLimit"]
        [::core::mem::offset_of!(PPTable_t, GfxclkFreqHighTempLimit) - 634usize];
    ["Offset of field: PPTable_t::FanStopTemp"]
        [::core::mem::offset_of!(PPTable_t, FanStopTemp) - 636usize];
    ["Offset of field: PPTable_t::FanStartTemp"]
        [::core::mem::offset_of!(PPTable_t, FanStartTemp) - 638usize];
    ["Offset of field: PPTable_t::FanGainEdge"]
        [::core::mem::offset_of!(PPTable_t, FanGainEdge) - 640usize];
    ["Offset of field: PPTable_t::FanGainHotspot"]
        [::core::mem::offset_of!(PPTable_t, FanGainHotspot) - 642usize];
    ["Offset of field: PPTable_t::FanGainLiquid0"]
        [::core::mem::offset_of!(PPTable_t, FanGainLiquid0) - 644usize];
    ["Offset of field: PPTable_t::FanGainLiquid1"]
        [::core::mem::offset_of!(PPTable_t, FanGainLiquid1) - 646usize];
    ["Offset of field: PPTable_t::FanGainVrGfx"]
        [::core::mem::offset_of!(PPTable_t, FanGainVrGfx) - 648usize];
    ["Offset of field: PPTable_t::FanGainVrSoc"]
        [::core::mem::offset_of!(PPTable_t, FanGainVrSoc) - 650usize];
    ["Offset of field: PPTable_t::FanGainVrMem0"]
        [::core::mem::offset_of!(PPTable_t, FanGainVrMem0) - 652usize];
    ["Offset of field: PPTable_t::FanGainVrMem1"]
        [::core::mem::offset_of!(PPTable_t, FanGainVrMem1) - 654usize];
    ["Offset of field: PPTable_t::FanGainPlx"]
        [::core::mem::offset_of!(PPTable_t, FanGainPlx) - 656usize];
    ["Offset of field: PPTable_t::FanGainMem"]
        [::core::mem::offset_of!(PPTable_t, FanGainMem) - 658usize];
    ["Offset of field: PPTable_t::FanPwmMin"]
        [::core::mem::offset_of!(PPTable_t, FanPwmMin) - 660usize];
    ["Offset of field: PPTable_t::FanAcousticLimitRpm"]
        [::core::mem::offset_of!(PPTable_t, FanAcousticLimitRpm) - 662usize];
    ["Offset of field: PPTable_t::FanThrottlingRpm"]
        [::core::mem::offset_of!(PPTable_t, FanThrottlingRpm) - 664usize];
    ["Offset of field: PPTable_t::FanMaximumRpm"]
        [::core::mem::offset_of!(PPTable_t, FanMaximumRpm) - 666usize];
    ["Offset of field: PPTable_t::FanTargetTemperature"]
        [::core::mem::offset_of!(PPTable_t, FanTargetTemperature) - 668usize];
    ["Offset of field: PPTable_t::FanTargetGfxclk"]
        [::core::mem::offset_of!(PPTable_t, FanTargetGfxclk) - 670usize];
    ["Offset of field: PPTable_t::FanTempInputSelect"]
        [::core::mem::offset_of!(PPTable_t, FanTempInputSelect) - 672usize];
    ["Offset of field: PPTable_t::FanPadding"]
        [::core::mem::offset_of!(PPTable_t, FanPadding) - 673usize];
    ["Offset of field: PPTable_t::FanZeroRpmEnable"]
        [::core::mem::offset_of!(PPTable_t, FanZeroRpmEnable) - 674usize];
    ["Offset of field: PPTable_t::FanTachEdgePerRev"]
        [::core::mem::offset_of!(PPTable_t, FanTachEdgePerRev) - 675usize];
    ["Offset of field: PPTable_t::FuzzyFan_ErrorSetDelta"]
        [::core::mem::offset_of!(PPTable_t, FuzzyFan_ErrorSetDelta) - 676usize];
    ["Offset of field: PPTable_t::FuzzyFan_ErrorRateSetDelta"]
        [::core::mem::offset_of!(PPTable_t, FuzzyFan_ErrorRateSetDelta) - 678usize];
    ["Offset of field: PPTable_t::FuzzyFan_PwmSetDelta"]
        [::core::mem::offset_of!(PPTable_t, FuzzyFan_PwmSetDelta) - 680usize];
    ["Offset of field: PPTable_t::FuzzyFan_Reserved"]
        [::core::mem::offset_of!(PPTable_t, FuzzyFan_Reserved) - 682usize];
    ["Offset of field: PPTable_t::OverrideAvfsGb"]
        [::core::mem::offset_of!(PPTable_t, OverrideAvfsGb) - 684usize];
    ["Offset of field: PPTable_t::Padding8_Avfs"]
        [::core::mem::offset_of!(PPTable_t, Padding8_Avfs) - 686usize];
    ["Offset of field: PPTable_t::qAvfsGb"][::core::mem::offset_of!(PPTable_t, qAvfsGb) - 688usize];
    ["Offset of field: PPTable_t::dBtcGbGfxPll"]
        [::core::mem::offset_of!(PPTable_t, dBtcGbGfxPll) - 712usize];
    ["Offset of field: PPTable_t::dBtcGbGfxDfll"]
        [::core::mem::offset_of!(PPTable_t, dBtcGbGfxDfll) - 724usize];
    ["Offset of field: PPTable_t::dBtcGbSoc"]
        [::core::mem::offset_of!(PPTable_t, dBtcGbSoc) - 736usize];
    ["Offset of field: PPTable_t::qAgingGb"]
        [::core::mem::offset_of!(PPTable_t, qAgingGb) - 748usize];
    ["Offset of field: PPTable_t::qStaticVoltageOffset"]
        [::core::mem::offset_of!(PPTable_t, qStaticVoltageOffset) - 764usize];
    ["Offset of field: PPTable_t::DcTol"][::core::mem::offset_of!(PPTable_t, DcTol) - 788usize];
    ["Offset of field: PPTable_t::DcBtcEnabled"]
        [::core::mem::offset_of!(PPTable_t, DcBtcEnabled) - 792usize];
    ["Offset of field: PPTable_t::Padding8_GfxBtc"]
        [::core::mem::offset_of!(PPTable_t, Padding8_GfxBtc) - 794usize];
    ["Offset of field: PPTable_t::DcBtcMin"]
        [::core::mem::offset_of!(PPTable_t, DcBtcMin) - 796usize];
    ["Offset of field: PPTable_t::DcBtcMax"]
        [::core::mem::offset_of!(PPTable_t, DcBtcMax) - 800usize];
    ["Offset of field: PPTable_t::DebugOverrides"]
        [::core::mem::offset_of!(PPTable_t, DebugOverrides) - 804usize];
    ["Offset of field: PPTable_t::ReservedEquation0"]
        [::core::mem::offset_of!(PPTable_t, ReservedEquation0) - 808usize];
    ["Offset of field: PPTable_t::ReservedEquation1"]
        [::core::mem::offset_of!(PPTable_t, ReservedEquation1) - 820usize];
    ["Offset of field: PPTable_t::ReservedEquation2"]
        [::core::mem::offset_of!(PPTable_t, ReservedEquation2) - 832usize];
    ["Offset of field: PPTable_t::ReservedEquation3"]
        [::core::mem::offset_of!(PPTable_t, ReservedEquation3) - 844usize];
    ["Offset of field: PPTable_t::TotalPowerConfig"]
        [::core::mem::offset_of!(PPTable_t, TotalPowerConfig) - 856usize];
    ["Offset of field: PPTable_t::TotalPowerSpare1"]
        [::core::mem::offset_of!(PPTable_t, TotalPowerSpare1) - 857usize];
    ["Offset of field: PPTable_t::TotalPowerSpare2"]
        [::core::mem::offset_of!(PPTable_t, TotalPowerSpare2) - 858usize];
    ["Offset of field: PPTable_t::PccThresholdLow"]
        [::core::mem::offset_of!(PPTable_t, PccThresholdLow) - 860usize];
    ["Offset of field: PPTable_t::PccThresholdHigh"]
        [::core::mem::offset_of!(PPTable_t, PccThresholdHigh) - 862usize];
    ["Offset of field: PPTable_t::MGpuFanBoostLimitRpm"]
        [::core::mem::offset_of!(PPTable_t, MGpuFanBoostLimitRpm) - 864usize];
    ["Offset of field: PPTable_t::PaddingAPCC"]
        [::core::mem::offset_of!(PPTable_t, PaddingAPCC) - 868usize];
    ["Offset of field: PPTable_t::VDDGFX_TVmin"]
        [::core::mem::offset_of!(PPTable_t, VDDGFX_TVmin) - 888usize];
    ["Offset of field: PPTable_t::VDDSOC_TVmin"]
        [::core::mem::offset_of!(PPTable_t, VDDSOC_TVmin) - 890usize];
    ["Offset of field: PPTable_t::VDDGFX_Vmin_HiTemp"]
        [::core::mem::offset_of!(PPTable_t, VDDGFX_Vmin_HiTemp) - 892usize];
    ["Offset of field: PPTable_t::VDDGFX_Vmin_LoTemp"]
        [::core::mem::offset_of!(PPTable_t, VDDGFX_Vmin_LoTemp) - 894usize];
    ["Offset of field: PPTable_t::VDDSOC_Vmin_HiTemp"]
        [::core::mem::offset_of!(PPTable_t, VDDSOC_Vmin_HiTemp) - 896usize];
    ["Offset of field: PPTable_t::VDDSOC_Vmin_LoTemp"]
        [::core::mem::offset_of!(PPTable_t, VDDSOC_Vmin_LoTemp) - 898usize];
    ["Offset of field: PPTable_t::VDDGFX_TVminHystersis"]
        [::core::mem::offset_of!(PPTable_t, VDDGFX_TVminHystersis) - 900usize];
    ["Offset of field: PPTable_t::VDDSOC_TVminHystersis"]
        [::core::mem::offset_of!(PPTable_t, VDDSOC_TVminHystersis) - 902usize];
    ["Offset of field: PPTable_t::BtcConfig"]
        [::core::mem::offset_of!(PPTable_t, BtcConfig) - 904usize];
    ["Offset of field: PPTable_t::SsFmin"][::core::mem::offset_of!(PPTable_t, SsFmin) - 908usize];
    ["Offset of field: PPTable_t::DcBtcGb"][::core::mem::offset_of!(PPTable_t, DcBtcGb) - 928usize];
    ["Offset of field: PPTable_t::Reserved"]
        [::core::mem::offset_of!(PPTable_t, Reserved) - 932usize];
    ["Offset of field: PPTable_t::I2cControllers"]
        [::core::mem::offset_of!(PPTable_t, I2cControllers) - 964usize];
    ["Offset of field: PPTable_t::MaxVoltageStepGfx"]
        [::core::mem::offset_of!(PPTable_t, MaxVoltageStepGfx) - 1060usize];
    ["Offset of field: PPTable_t::MaxVoltageStepSoc"]
        [::core::mem::offset_of!(PPTable_t, MaxVoltageStepSoc) - 1062usize];
    ["Offset of field: PPTable_t::VddGfxVrMapping"]
        [::core::mem::offset_of!(PPTable_t, VddGfxVrMapping) - 1064usize];
    ["Offset of field: PPTable_t::VddSocVrMapping"]
        [::core::mem::offset_of!(PPTable_t, VddSocVrMapping) - 1065usize];
    ["Offset of field: PPTable_t::VddMem0VrMapping"]
        [::core::mem::offset_of!(PPTable_t, VddMem0VrMapping) - 1066usize];
    ["Offset of field: PPTable_t::VddMem1VrMapping"]
        [::core::mem::offset_of!(PPTable_t, VddMem1VrMapping) - 1067usize];
    ["Offset of field: PPTable_t::GfxUlvPhaseSheddingMask"]
        [::core::mem::offset_of!(PPTable_t, GfxUlvPhaseSheddingMask) - 1068usize];
    ["Offset of field: PPTable_t::SocUlvPhaseSheddingMask"]
        [::core::mem::offset_of!(PPTable_t, SocUlvPhaseSheddingMask) - 1069usize];
    ["Offset of field: PPTable_t::ExternalSensorPresent"]
        [::core::mem::offset_of!(PPTable_t, ExternalSensorPresent) - 1070usize];
    ["Offset of field: PPTable_t::Padding8_V"]
        [::core::mem::offset_of!(PPTable_t, Padding8_V) - 1071usize];
    ["Offset of field: PPTable_t::GfxMaxCurrent"]
        [::core::mem::offset_of!(PPTable_t, GfxMaxCurrent) - 1072usize];
    ["Offset of field: PPTable_t::GfxOffset"]
        [::core::mem::offset_of!(PPTable_t, GfxOffset) - 1074usize];
    ["Offset of field: PPTable_t::Padding_TelemetryGfx"]
        [::core::mem::offset_of!(PPTable_t, Padding_TelemetryGfx) - 1075usize];
    ["Offset of field: PPTable_t::SocMaxCurrent"]
        [::core::mem::offset_of!(PPTable_t, SocMaxCurrent) - 1076usize];
    ["Offset of field: PPTable_t::SocOffset"]
        [::core::mem::offset_of!(PPTable_t, SocOffset) - 1078usize];
    ["Offset of field: PPTable_t::Padding_TelemetrySoc"]
        [::core::mem::offset_of!(PPTable_t, Padding_TelemetrySoc) - 1079usize];
    ["Offset of field: PPTable_t::Mem0MaxCurrent"]
        [::core::mem::offset_of!(PPTable_t, Mem0MaxCurrent) - 1080usize];
    ["Offset of field: PPTable_t::Mem0Offset"]
        [::core::mem::offset_of!(PPTable_t, Mem0Offset) - 1082usize];
    ["Offset of field: PPTable_t::Padding_TelemetryMem0"]
        [::core::mem::offset_of!(PPTable_t, Padding_TelemetryMem0) - 1083usize];
    ["Offset of field: PPTable_t::Mem1MaxCurrent"]
        [::core::mem::offset_of!(PPTable_t, Mem1MaxCurrent) - 1084usize];
    ["Offset of field: PPTable_t::Mem1Offset"]
        [::core::mem::offset_of!(PPTable_t, Mem1Offset) - 1086usize];
    ["Offset of field: PPTable_t::Padding_TelemetryMem1"]
        [::core::mem::offset_of!(PPTable_t, Padding_TelemetryMem1) - 1087usize];
    ["Offset of field: PPTable_t::AcDcGpio"]
        [::core::mem::offset_of!(PPTable_t, AcDcGpio) - 1088usize];
    ["Offset of field: PPTable_t::AcDcPolarity"]
        [::core::mem::offset_of!(PPTable_t, AcDcPolarity) - 1089usize];
    ["Offset of field: PPTable_t::VR0HotGpio"]
        [::core::mem::offset_of!(PPTable_t, VR0HotGpio) - 1090usize];
    ["Offset of field: PPTable_t::VR0HotPolarity"]
        [::core::mem::offset_of!(PPTable_t, VR0HotPolarity) - 1091usize];
    ["Offset of field: PPTable_t::VR1HotGpio"]
        [::core::mem::offset_of!(PPTable_t, VR1HotGpio) - 1092usize];
    ["Offset of field: PPTable_t::VR1HotPolarity"]
        [::core::mem::offset_of!(PPTable_t, VR1HotPolarity) - 1093usize];
    ["Offset of field: PPTable_t::GthrGpio"]
        [::core::mem::offset_of!(PPTable_t, GthrGpio) - 1094usize];
    ["Offset of field: PPTable_t::GthrPolarity"]
        [::core::mem::offset_of!(PPTable_t, GthrPolarity) - 1095usize];
    ["Offset of field: PPTable_t::LedPin0"]
        [::core::mem::offset_of!(PPTable_t, LedPin0) - 1096usize];
    ["Offset of field: PPTable_t::LedPin1"]
        [::core::mem::offset_of!(PPTable_t, LedPin1) - 1097usize];
    ["Offset of field: PPTable_t::LedPin2"]
        [::core::mem::offset_of!(PPTable_t, LedPin2) - 1098usize];
    ["Offset of field: PPTable_t::padding8_4"]
        [::core::mem::offset_of!(PPTable_t, padding8_4) - 1099usize];
    ["Offset of field: PPTable_t::PllGfxclkSpreadEnabled"]
        [::core::mem::offset_of!(PPTable_t, PllGfxclkSpreadEnabled) - 1100usize];
    ["Offset of field: PPTable_t::PllGfxclkSpreadPercent"]
        [::core::mem::offset_of!(PPTable_t, PllGfxclkSpreadPercent) - 1101usize];
    ["Offset of field: PPTable_t::PllGfxclkSpreadFreq"]
        [::core::mem::offset_of!(PPTable_t, PllGfxclkSpreadFreq) - 1102usize];
    ["Offset of field: PPTable_t::DfllGfxclkSpreadEnabled"]
        [::core::mem::offset_of!(PPTable_t, DfllGfxclkSpreadEnabled) - 1104usize];
    ["Offset of field: PPTable_t::DfllGfxclkSpreadPercent"]
        [::core::mem::offset_of!(PPTable_t, DfllGfxclkSpreadPercent) - 1105usize];
    ["Offset of field: PPTable_t::DfllGfxclkSpreadFreq"]
        [::core::mem::offset_of!(PPTable_t, DfllGfxclkSpreadFreq) - 1106usize];
    ["Offset of field: PPTable_t::UclkSpreadEnabled"]
        [::core::mem::offset_of!(PPTable_t, UclkSpreadEnabled) - 1108usize];
    ["Offset of field: PPTable_t::UclkSpreadPercent"]
        [::core::mem::offset_of!(PPTable_t, UclkSpreadPercent) - 1109usize];
    ["Offset of field: PPTable_t::UclkSpreadFreq"]
        [::core::mem::offset_of!(PPTable_t, UclkSpreadFreq) - 1110usize];
    ["Offset of field: PPTable_t::SoclkSpreadEnabled"]
        [::core::mem::offset_of!(PPTable_t, SoclkSpreadEnabled) - 1112usize];
    ["Offset of field: PPTable_t::SocclkSpreadPercent"]
        [::core::mem::offset_of!(PPTable_t, SocclkSpreadPercent) - 1113usize];
    ["Offset of field: PPTable_t::SocclkSpreadFreq"]
        [::core::mem::offset_of!(PPTable_t, SocclkSpreadFreq) - 1114usize];
    ["Offset of field: PPTable_t::TotalBoardPower"]
        [::core::mem::offset_of!(PPTable_t, TotalBoardPower) - 1116usize];
    ["Offset of field: PPTable_t::BoardPadding"]
        [::core::mem::offset_of!(PPTable_t, BoardPadding) - 1118usize];
    ["Offset of field: PPTable_t::MvddRatio"]
        [::core::mem::offset_of!(PPTable_t, MvddRatio) - 1120usize];
    ["Offset of field: PPTable_t::RenesesLoadLineEnabled"]
        [::core::mem::offset_of!(PPTable_t, RenesesLoadLineEnabled) - 1124usize];
    ["Offset of field: PPTable_t::GfxLoadlineResistance"]
        [::core::mem::offset_of!(PPTable_t, GfxLoadlineResistance) - 1125usize];
    ["Offset of field: PPTable_t::SocLoadlineResistance"]
        [::core::mem::offset_of!(PPTable_t, SocLoadlineResistance) - 1126usize];
    ["Offset of field: PPTable_t::Padding8_Loadline"]
        [::core::mem::offset_of!(PPTable_t, Padding8_Loadline) - 1127usize];
    ["Offset of field: PPTable_t::BoardReserved"]
        [::core::mem::offset_of!(PPTable_t, BoardReserved) - 1128usize];
    ["Offset of field: PPTable_t::MmHubPadding"]
        [::core::mem::offset_of!(PPTable_t, MmHubPadding) - 1160usize];
};
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct DriverSmuConfig_t {
    pub GfxclkAverageLpfTau: u16,
    pub SocclkAverageLpfTau: u16,
    pub UclkAverageLpfTau: u16,
    pub GfxActivityLpfTau: u16,
    pub UclkActivityLpfTau: u16,
    pub SocketPowerLpfTau: u16,
    pub MmHubPadding: [u32; 8usize],
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of DriverSmuConfig_t"][::core::mem::size_of::<DriverSmuConfig_t>() - 44usize];
    ["Alignment of DriverSmuConfig_t"][::core::mem::align_of::<DriverSmuConfig_t>() - 4usize];
    ["Offset of field: DriverSmuConfig_t::GfxclkAverageLpfTau"]
        [::core::mem::offset_of!(DriverSmuConfig_t, GfxclkAverageLpfTau) - 0usize];
    ["Offset of field: DriverSmuConfig_t::SocclkAverageLpfTau"]
        [::core::mem::offset_of!(DriverSmuConfig_t, SocclkAverageLpfTau) - 2usize];
    ["Offset of field: DriverSmuConfig_t::UclkAverageLpfTau"]
        [::core::mem::offset_of!(DriverSmuConfig_t, UclkAverageLpfTau) - 4usize];
    ["Offset of field: DriverSmuConfig_t::GfxActivityLpfTau"]
        [::core::mem::offset_of!(DriverSmuConfig_t, GfxActivityLpfTau) - 6usize];
    ["Offset of field: DriverSmuConfig_t::UclkActivityLpfTau"]
        [::core::mem::offset_of!(DriverSmuConfig_t, UclkActivityLpfTau) - 8usize];
    ["Offset of field: DriverSmuConfig_t::SocketPowerLpfTau"]
        [::core::mem::offset_of!(DriverSmuConfig_t, SocketPowerLpfTau) - 10usize];
    ["Offset of field: DriverSmuConfig_t::MmHubPadding"]
        [::core::mem::offset_of!(DriverSmuConfig_t, MmHubPadding) - 12usize];
};
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct OverDriveTable_t {
    pub GfxclkFmin: u16,
    pub GfxclkFmax: u16,
    pub GfxclkFreq1: u16,
    pub GfxclkVolt1: u16,
    pub GfxclkFreq2: u16,
    pub GfxclkVolt2: u16,
    pub GfxclkFreq3: u16,
    pub GfxclkVolt3: u16,
    pub UclkFmax: u16,
    pub OverDrivePct: i16,
    pub FanMaximumRpm: u16,
    pub FanMinimumPwm: u16,
    pub FanTargetTemperature: u16,
    pub FanMode: u16,
    pub FanMaxPwm: u16,
    pub FanMinPwm: u16,
    pub FanMaxTemp: u16,
    pub FanMinTemp: u16,
    pub MaxOpTemp: u16,
    pub FanZeroRpmEnable: u16,
    pub MmHubPadding: [u32; 6usize],
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of OverDriveTable_t"][::core::mem::size_of::<OverDriveTable_t>() - 64usize];
    ["Alignment of OverDriveTable_t"][::core::mem::align_of::<OverDriveTable_t>() - 4usize];
    ["Offset of field: OverDriveTable_t::GfxclkFmin"]
        [::core::mem::offset_of!(OverDriveTable_t, GfxclkFmin) - 0usize];
    ["Offset of field: OverDriveTable_t::GfxclkFmax"]
        [::core::mem::offset_of!(OverDriveTable_t, GfxclkFmax) - 2usize];
    ["Offset of field: OverDriveTable_t::GfxclkFreq1"]
        [::core::mem::offset_of!(OverDriveTable_t, GfxclkFreq1) - 4usize];
    ["Offset of field: OverDriveTable_t::GfxclkVolt1"]
        [::core::mem::offset_of!(OverDriveTable_t, GfxclkVolt1) - 6usize];
    ["Offset of field: OverDriveTable_t::GfxclkFreq2"]
        [::core::mem::offset_of!(OverDriveTable_t, GfxclkFreq2) - 8usize];
    ["Offset of field: OverDriveTable_t::GfxclkVolt2"]
        [::core::mem::offset_of!(OverDriveTable_t, GfxclkVolt2) - 10usize];
    ["Offset of field: OverDriveTable_t::GfxclkFreq3"]
        [::core::mem::offset_of!(OverDriveTable_t, GfxclkFreq3) - 12usize];
    ["Offset of field: OverDriveTable_t::GfxclkVolt3"]
        [::core::mem::offset_of!(OverDriveTable_t, GfxclkVolt3) - 14usize];
    ["Offset of field: OverDriveTable_t::UclkFmax"]
        [::core::mem::offset_of!(OverDriveTable_t, UclkFmax) - 16usize];
    ["Offset of field: OverDriveTable_t::OverDrivePct"]
        [::core::mem::offset_of!(OverDriveTable_t, OverDrivePct) - 18usize];
    ["Offset of field: OverDriveTable_t::FanMaximumRpm"]
        [::core::mem::offset_of!(OverDriveTable_t, FanMaximumRpm) - 20usize];
    ["Offset of field: OverDriveTable_t::FanMinimumPwm"]
        [::core::mem::offset_of!(OverDriveTable_t, FanMinimumPwm) - 22usize];
    ["Offset of field: OverDriveTable_t::FanTargetTemperature"]
        [::core::mem::offset_of!(OverDriveTable_t, FanTargetTemperature) - 24usize];
    ["Offset of field: OverDriveTable_t::FanMode"]
        [::core::mem::offset_of!(OverDriveTable_t, FanMode) - 26usize];
    ["Offset of field: OverDriveTable_t::FanMaxPwm"]
        [::core::mem::offset_of!(OverDriveTable_t, FanMaxPwm) - 28usize];
    ["Offset of field: OverDriveTable_t::FanMinPwm"]
        [::core::mem::offset_of!(OverDriveTable_t, FanMinPwm) - 30usize];
    ["Offset of field: OverDriveTable_t::FanMaxTemp"]
        [::core::mem::offset_of!(OverDriveTable_t, FanMaxTemp) - 32usize];
    ["Offset of field: OverDriveTable_t::FanMinTemp"]
        [::core::mem::offset_of!(OverDriveTable_t, FanMinTemp) - 34usize];
    ["Offset of field: OverDriveTable_t::MaxOpTemp"]
        [::core::mem::offset_of!(OverDriveTable_t, MaxOpTemp) - 36usize];
    ["Offset of field: OverDriveTable_t::FanZeroRpmEnable"]
        [::core::mem::offset_of!(OverDriveTable_t, FanZeroRpmEnable) - 38usize];
    ["Offset of field: OverDriveTable_t::MmHubPadding"]
        [::core::mem::offset_of!(OverDriveTable_t, MmHubPadding) - 40usize];
};
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct SmuMetrics_legacy_t {
    pub CurrClock: [u16; 9usize],
    pub AverageGfxclkFrequency: u16,
    pub AverageSocclkFrequency: u16,
    pub AverageUclkFrequency: u16,
    pub AverageGfxActivity: u16,
    pub AverageUclkActivity: u16,
    pub CurrSocVoltageOffset: u8,
    pub CurrGfxVoltageOffset: u8,
    pub CurrMemVidOffset: u8,
    pub Padding8: u8,
    pub AverageSocketPower: u16,
    pub TemperatureEdge: u16,
    pub TemperatureHotspot: u16,
    pub TemperatureMem: u16,
    pub TemperatureVrGfx: u16,
    pub TemperatureVrMem0: u16,
    pub TemperatureVrMem1: u16,
    pub TemperatureVrSoc: u16,
    pub TemperatureLiquid0: u16,
    pub TemperatureLiquid1: u16,
    pub TemperaturePlx: u16,
    pub Padding16: u16,
    pub ThrottlerStatus: u32,
    pub LinkDpmLevel: u8,
    pub Padding8_2: u8,
    pub CurrFanSpeed: u16,
    pub MmHubPadding: [u32; 8usize],
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of SmuMetrics_legacy_t"][::core::mem::size_of::<SmuMetrics_legacy_t>() - 96usize];
    ["Alignment of SmuMetrics_legacy_t"][::core::mem::align_of::<SmuMetrics_legacy_t>() - 4usize];
    ["Offset of field: SmuMetrics_legacy_t::CurrClock"]
        [::core::mem::offset_of!(SmuMetrics_legacy_t, CurrClock) - 0usize];
    ["Offset of field: SmuMetrics_legacy_t::AverageGfxclkFrequency"]
        [::core::mem::offset_of!(SmuMetrics_legacy_t, AverageGfxclkFrequency) - 18usize];
    ["Offset of field: SmuMetrics_legacy_t::AverageSocclkFrequency"]
        [::core::mem::offset_of!(SmuMetrics_legacy_t, AverageSocclkFrequency) - 20usize];
    ["Offset of field: SmuMetrics_legacy_t::AverageUclkFrequency"]
        [::core::mem::offset_of!(SmuMetrics_legacy_t, AverageUclkFrequency) - 22usize];
    ["Offset of field: SmuMetrics_legacy_t::AverageGfxActivity"]
        [::core::mem::offset_of!(SmuMetrics_legacy_t, AverageGfxActivity) - 24usize];
    ["Offset of field: SmuMetrics_legacy_t::AverageUclkActivity"]
        [::core::mem::offset_of!(SmuMetrics_legacy_t, AverageUclkActivity) - 26usize];
    ["Offset of field: SmuMetrics_legacy_t::CurrSocVoltageOffset"]
        [::core::mem::offset_of!(SmuMetrics_legacy_t, CurrSocVoltageOffset) - 28usize];
    ["Offset of field: SmuMetrics_legacy_t::CurrGfxVoltageOffset"]
        [::core::mem::offset_of!(SmuMetrics_legacy_t, CurrGfxVoltageOffset) - 29usize];
    ["Offset of field: SmuMetrics_legacy_t::CurrMemVidOffset"]
        [::core::mem::offset_of!(SmuMetrics_legacy_t, CurrMemVidOffset) - 30usize];
    ["Offset of field: SmuMetrics_legacy_t::Padding8"]
        [::core::mem::offset_of!(SmuMetrics_legacy_t, Padding8) - 31usize];
    ["Offset of field: SmuMetrics_legacy_t::AverageSocketPower"]
        [::core::mem::offset_of!(SmuMetrics_legacy_t, AverageSocketPower) - 32usize];
    ["Offset of field: SmuMetrics_legacy_t::TemperatureEdge"]
        [::core::mem::offset_of!(SmuMetrics_legacy_t, TemperatureEdge) - 34usize];
    ["Offset of field: SmuMetrics_legacy_t::TemperatureHotspot"]
        [::core::mem::offset_of!(SmuMetrics_legacy_t, TemperatureHotspot) - 36usize];
    ["Offset of field: SmuMetrics_legacy_t::TemperatureMem"]
        [::core::mem::offset_of!(SmuMetrics_legacy_t, TemperatureMem) - 38usize];
    ["Offset of field: SmuMetrics_legacy_t::TemperatureVrGfx"]
        [::core::mem::offset_of!(SmuMetrics_legacy_t, TemperatureVrGfx) - 40usize];
    ["Offset of field: SmuMetrics_legacy_t::TemperatureVrMem0"]
        [::core::mem::offset_of!(SmuMetrics_legacy_t, TemperatureVrMem0) - 42usize];
    ["Offset of field: SmuMetrics_legacy_t::TemperatureVrMem1"]
        [::core::mem::offset_of!(SmuMetrics_legacy_t, TemperatureVrMem1) - 44usize];
    ["Offset of field: SmuMetrics_legacy_t::TemperatureVrSoc"]
        [::core::mem::offset_of!(SmuMetrics_legacy_t, TemperatureVrSoc) - 46usize];
    ["Offset of field: SmuMetrics_legacy_t::TemperatureLiquid0"]
        [::core::mem::offset_of!(SmuMetrics_legacy_t, TemperatureLiquid0) - 48usize];
    ["Offset of field: SmuMetrics_legacy_t::TemperatureLiquid1"]
        [::core::mem::offset_of!(SmuMetrics_legacy_t, TemperatureLiquid1) - 50usize];
    ["Offset of field: SmuMetrics_legacy_t::TemperaturePlx"]
        [::core::mem::offset_of!(SmuMetrics_legacy_t, TemperaturePlx) - 52usize];
    ["Offset of field: SmuMetrics_legacy_t::Padding16"]
        [::core::mem::offset_of!(SmuMetrics_legacy_t, Padding16) - 54usize];
    ["Offset of field: SmuMetrics_legacy_t::ThrottlerStatus"]
        [::core::mem::offset_of!(SmuMetrics_legacy_t, ThrottlerStatus) - 56usize];
    ["Offset of field: SmuMetrics_legacy_t::LinkDpmLevel"]
        [::core::mem::offset_of!(SmuMetrics_legacy_t, LinkDpmLevel) - 60usize];
    ["Offset of field: SmuMetrics_legacy_t::Padding8_2"]
        [::core::mem::offset_of!(SmuMetrics_legacy_t, Padding8_2) - 61usize];
    ["Offset of field: SmuMetrics_legacy_t::CurrFanSpeed"]
        [::core::mem::offset_of!(SmuMetrics_legacy_t, CurrFanSpeed) - 62usize];
    ["Offset of field: SmuMetrics_legacy_t::MmHubPadding"]
        [::core::mem::offset_of!(SmuMetrics_legacy_t, MmHubPadding) - 64usize];
};
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct SmuMetrics_t {
    pub CurrClock: [u16; 9usize],
    pub AverageGfxclkFrequencyPostDs: u16,
    pub AverageSocclkFrequency: u16,
    pub AverageUclkFrequencyPostDs: u16,
    pub AverageGfxActivity: u16,
    pub AverageUclkActivity: u16,
    pub CurrSocVoltageOffset: u8,
    pub CurrGfxVoltageOffset: u8,
    pub CurrMemVidOffset: u8,
    pub Padding8: u8,
    pub AverageSocketPower: u16,
    pub TemperatureEdge: u16,
    pub TemperatureHotspot: u16,
    pub TemperatureMem: u16,
    pub TemperatureVrGfx: u16,
    pub TemperatureVrMem0: u16,
    pub TemperatureVrMem1: u16,
    pub TemperatureVrSoc: u16,
    pub TemperatureLiquid0: u16,
    pub TemperatureLiquid1: u16,
    pub TemperaturePlx: u16,
    pub Padding16: u16,
    pub ThrottlerStatus: u32,
    pub LinkDpmLevel: u8,
    pub Padding8_2: u8,
    pub CurrFanSpeed: u16,
    pub AverageGfxclkFrequencyPreDs: u16,
    pub AverageUclkFrequencyPreDs: u16,
    pub PcieRate: u8,
    pub PcieWidth: u8,
    pub Padding8_3: [u8; 2usize],
    pub MmHubPadding: [u32; 8usize],
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of SmuMetrics_t"][::core::mem::size_of::<SmuMetrics_t>() - 104usize];
    ["Alignment of SmuMetrics_t"][::core::mem::align_of::<SmuMetrics_t>() - 4usize];
    ["Offset of field: SmuMetrics_t::CurrClock"]
        [::core::mem::offset_of!(SmuMetrics_t, CurrClock) - 0usize];
    ["Offset of field: SmuMetrics_t::AverageGfxclkFrequencyPostDs"]
        [::core::mem::offset_of!(SmuMetrics_t, AverageGfxclkFrequencyPostDs) - 18usize];
    ["Offset of field: SmuMetrics_t::AverageSocclkFrequency"]
        [::core::mem::offset_of!(SmuMetrics_t, AverageSocclkFrequency) - 20usize];
    ["Offset of field: SmuMetrics_t::AverageUclkFrequencyPostDs"]
        [::core::mem::offset_of!(SmuMetrics_t, AverageUclkFrequencyPostDs) - 22usize];
    ["Offset of field: SmuMetrics_t::AverageGfxActivity"]
        [::core::mem::offset_of!(SmuMetrics_t, AverageGfxActivity) - 24usize];
    ["Offset of field: SmuMetrics_t::AverageUclkActivity"]
        [::core::mem::offset_of!(SmuMetrics_t, AverageUclkActivity) - 26usize];
    ["Offset of field: SmuMetrics_t::CurrSocVoltageOffset"]
        [::core::mem::offset_of!(SmuMetrics_t, CurrSocVoltageOffset) - 28usize];
    ["Offset of field: SmuMetrics_t::CurrGfxVoltageOffset"]
        [::core::mem::offset_of!(SmuMetrics_t, CurrGfxVoltageOffset) - 29usize];
    ["Offset of field: SmuMetrics_t::CurrMemVidOffset"]
        [::core::mem::offset_of!(SmuMetrics_t, CurrMemVidOffset) - 30usize];
    ["Offset of field: SmuMetrics_t::Padding8"]
        [::core::mem::offset_of!(SmuMetrics_t, Padding8) - 31usize];
    ["Offset of field: SmuMetrics_t::AverageSocketPower"]
        [::core::mem::offset_of!(SmuMetrics_t, AverageSocketPower) - 32usize];
    ["Offset of field: SmuMetrics_t::TemperatureEdge"]
        [::core::mem::offset_of!(SmuMetrics_t, TemperatureEdge) - 34usize];
    ["Offset of field: SmuMetrics_t::TemperatureHotspot"]
        [::core::mem::offset_of!(SmuMetrics_t, TemperatureHotspot) - 36usize];
    ["Offset of field: SmuMetrics_t::TemperatureMem"]
        [::core::mem::offset_of!(SmuMetrics_t, TemperatureMem) - 38usize];
    ["Offset of field: SmuMetrics_t::TemperatureVrGfx"]
        [::core::mem::offset_of!(SmuMetrics_t, TemperatureVrGfx) - 40usize];
    ["Offset of field: SmuMetrics_t::TemperatureVrMem0"]
        [::core::mem::offset_of!(SmuMetrics_t, TemperatureVrMem0) - 42usize];
    ["Offset of field: SmuMetrics_t::TemperatureVrMem1"]
        [::core::mem::offset_of!(SmuMetrics_t, TemperatureVrMem1) - 44usize];
    ["Offset of field: SmuMetrics_t::TemperatureVrSoc"]
        [::core::mem::offset_of!(SmuMetrics_t, TemperatureVrSoc) - 46usize];
    ["Offset of field: SmuMetrics_t::TemperatureLiquid0"]
        [::core::mem::offset_of!(SmuMetrics_t, TemperatureLiquid0) - 48usize];
    ["Offset of field: SmuMetrics_t::TemperatureLiquid1"]
        [::core::mem::offset_of!(SmuMetrics_t, TemperatureLiquid1) - 50usize];
    ["Offset of field: SmuMetrics_t::TemperaturePlx"]
        [::core::mem::offset_of!(SmuMetrics_t, TemperaturePlx) - 52usize];
    ["Offset of field: SmuMetrics_t::Padding16"]
        [::core::mem::offset_of!(SmuMetrics_t, Padding16) - 54usize];
    ["Offset of field: SmuMetrics_t::ThrottlerStatus"]
        [::core::mem::offset_of!(SmuMetrics_t, ThrottlerStatus) - 56usize];
    ["Offset of field: SmuMetrics_t::LinkDpmLevel"]
        [::core::mem::offset_of!(SmuMetrics_t, LinkDpmLevel) - 60usize];
    ["Offset of field: SmuMetrics_t::Padding8_2"]
        [::core::mem::offset_of!(SmuMetrics_t, Padding8_2) - 61usize];
    ["Offset of field: SmuMetrics_t::CurrFanSpeed"]
        [::core::mem::offset_of!(SmuMetrics_t, CurrFanSpeed) - 62usize];
    ["Offset of field: SmuMetrics_t::AverageGfxclkFrequencyPreDs"]
        [::core::mem::offset_of!(SmuMetrics_t, AverageGfxclkFrequencyPreDs) - 64usize];
    ["Offset of field: SmuMetrics_t::AverageUclkFrequencyPreDs"]
        [::core::mem::offset_of!(SmuMetrics_t, AverageUclkFrequencyPreDs) - 66usize];
    ["Offset of field: SmuMetrics_t::PcieRate"]
        [::core::mem::offset_of!(SmuMetrics_t, PcieRate) - 68usize];
    ["Offset of field: SmuMetrics_t::PcieWidth"]
        [::core::mem::offset_of!(SmuMetrics_t, PcieWidth) - 69usize];
    ["Offset of field: SmuMetrics_t::Padding8_3"]
        [::core::mem::offset_of!(SmuMetrics_t, Padding8_3) - 70usize];
    ["Offset of field: SmuMetrics_t::MmHubPadding"]
        [::core::mem::offset_of!(SmuMetrics_t, MmHubPadding) - 72usize];
};
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct SmuMetrics_NV12_legacy_t {
    pub CurrClock: [u16; 9usize],
    pub AverageGfxclkFrequency: u16,
    pub AverageSocclkFrequency: u16,
    pub AverageUclkFrequency: u16,
    pub AverageGfxActivity: u16,
    pub AverageUclkActivity: u16,
    pub CurrSocVoltageOffset: u8,
    pub CurrGfxVoltageOffset: u8,
    pub CurrMemVidOffset: u8,
    pub Padding8: u8,
    pub AverageSocketPower: u16,
    pub TemperatureEdge: u16,
    pub TemperatureHotspot: u16,
    pub TemperatureMem: u16,
    pub TemperatureVrGfx: u16,
    pub TemperatureVrMem0: u16,
    pub TemperatureVrMem1: u16,
    pub TemperatureVrSoc: u16,
    pub TemperatureLiquid0: u16,
    pub TemperatureLiquid1: u16,
    pub TemperaturePlx: u16,
    pub Padding16: u16,
    pub ThrottlerStatus: u32,
    pub LinkDpmLevel: u8,
    pub Padding8_2: u8,
    pub CurrFanSpeed: u16,
    pub EnergyAccumulator: u32,
    pub AverageVclkFrequency: u16,
    pub AverageDclkFrequency: u16,
    pub VcnActivityPercentage: u16,
    pub padding16_2: u16,
    pub MmHubPadding: [u32; 8usize],
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of SmuMetrics_NV12_legacy_t"]
        [::core::mem::size_of::<SmuMetrics_NV12_legacy_t>() - 108usize];
    ["Alignment of SmuMetrics_NV12_legacy_t"]
        [::core::mem::align_of::<SmuMetrics_NV12_legacy_t>() - 4usize];
    ["Offset of field: SmuMetrics_NV12_legacy_t::CurrClock"]
        [::core::mem::offset_of!(SmuMetrics_NV12_legacy_t, CurrClock) - 0usize];
    ["Offset of field: SmuMetrics_NV12_legacy_t::AverageGfxclkFrequency"]
        [::core::mem::offset_of!(SmuMetrics_NV12_legacy_t, AverageGfxclkFrequency) - 18usize];
    ["Offset of field: SmuMetrics_NV12_legacy_t::AverageSocclkFrequency"]
        [::core::mem::offset_of!(SmuMetrics_NV12_legacy_t, AverageSocclkFrequency) - 20usize];
    ["Offset of field: SmuMetrics_NV12_legacy_t::AverageUclkFrequency"]
        [::core::mem::offset_of!(SmuMetrics_NV12_legacy_t, AverageUclkFrequency) - 22usize];
    ["Offset of field: SmuMetrics_NV12_legacy_t::AverageGfxActivity"]
        [::core::mem::offset_of!(SmuMetrics_NV12_legacy_t, AverageGfxActivity) - 24usize];
    ["Offset of field: SmuMetrics_NV12_legacy_t::AverageUclkActivity"]
        [::core::mem::offset_of!(SmuMetrics_NV12_legacy_t, AverageUclkActivity) - 26usize];
    ["Offset of field: SmuMetrics_NV12_legacy_t::CurrSocVoltageOffset"]
        [::core::mem::offset_of!(SmuMetrics_NV12_legacy_t, CurrSocVoltageOffset) - 28usize];
    ["Offset of field: SmuMetrics_NV12_legacy_t::CurrGfxVoltageOffset"]
        [::core::mem::offset_of!(SmuMetrics_NV12_legacy_t, CurrGfxVoltageOffset) - 29usize];
    ["Offset of field: SmuMetrics_NV12_legacy_t::CurrMemVidOffset"]
        [::core::mem::offset_of!(SmuMetrics_NV12_legacy_t, CurrMemVidOffset) - 30usize];
    ["Offset of field: SmuMetrics_NV12_legacy_t::Padding8"]
        [::core::mem::offset_of!(SmuMetrics_NV12_legacy_t, Padding8) - 31usize];
    ["Offset of field: SmuMetrics_NV12_legacy_t::AverageSocketPower"]
        [::core::mem::offset_of!(SmuMetrics_NV12_legacy_t, AverageSocketPower) - 32usize];
    ["Offset of field: SmuMetrics_NV12_legacy_t::TemperatureEdge"]
        [::core::mem::offset_of!(SmuMetrics_NV12_legacy_t, TemperatureEdge) - 34usize];
    ["Offset of field: SmuMetrics_NV12_legacy_t::TemperatureHotspot"]
        [::core::mem::offset_of!(SmuMetrics_NV12_legacy_t, TemperatureHotspot) - 36usize];
    ["Offset of field: SmuMetrics_NV12_legacy_t::TemperatureMem"]
        [::core::mem::offset_of!(SmuMetrics_NV12_legacy_t, TemperatureMem) - 38usize];
    ["Offset of field: SmuMetrics_NV12_legacy_t::TemperatureVrGfx"]
        [::core::mem::offset_of!(SmuMetrics_NV12_legacy_t, TemperatureVrGfx) - 40usize];
    ["Offset of field: SmuMetrics_NV12_legacy_t::TemperatureVrMem0"]
        [::core::mem::offset_of!(SmuMetrics_NV12_legacy_t, TemperatureVrMem0) - 42usize];
    ["Offset of field: SmuMetrics_NV12_legacy_t::TemperatureVrMem1"]
        [::core::mem::offset_of!(SmuMetrics_NV12_legacy_t, TemperatureVrMem1) - 44usize];
    ["Offset of field: SmuMetrics_NV12_legacy_t::TemperatureVrSoc"]
        [::core::mem::offset_of!(SmuMetrics_NV12_legacy_t, TemperatureVrSoc) - 46usize];
    ["Offset of field: SmuMetrics_NV12_legacy_t::TemperatureLiquid0"]
        [::core::mem::offset_of!(SmuMetrics_NV12_legacy_t, TemperatureLiquid0) - 48usize];
    ["Offset of field: SmuMetrics_NV12_legacy_t::TemperatureLiquid1"]
        [::core::mem::offset_of!(SmuMetrics_NV12_legacy_t, TemperatureLiquid1) - 50usize];
    ["Offset of field: SmuMetrics_NV12_legacy_t::TemperaturePlx"]
        [::core::mem::offset_of!(SmuMetrics_NV12_legacy_t, TemperaturePlx) - 52usize];
    ["Offset of field: SmuMetrics_NV12_legacy_t::Padding16"]
        [::core::mem::offset_of!(SmuMetrics_NV12_legacy_t, Padding16) - 54usize];
    ["Offset of field: SmuMetrics_NV12_legacy_t::ThrottlerStatus"]
        [::core::mem::offset_of!(SmuMetrics_NV12_legacy_t, ThrottlerStatus) - 56usize];
    ["Offset of field: SmuMetrics_NV12_legacy_t::LinkDpmLevel"]
        [::core::mem::offset_of!(SmuMetrics_NV12_legacy_t, LinkDpmLevel) - 60usize];
    ["Offset of field: SmuMetrics_NV12_legacy_t::Padding8_2"]
        [::core::mem::offset_of!(SmuMetrics_NV12_legacy_t, Padding8_2) - 61usize];
    ["Offset of field: SmuMetrics_NV12_legacy_t::CurrFanSpeed"]
        [::core::mem::offset_of!(SmuMetrics_NV12_legacy_t, CurrFanSpeed) - 62usize];
    ["Offset of field: SmuMetrics_NV12_legacy_t::EnergyAccumulator"]
        [::core::mem::offset_of!(SmuMetrics_NV12_legacy_t, EnergyAccumulator) - 64usize];
    ["Offset of field: SmuMetrics_NV12_legacy_t::AverageVclkFrequency"]
        [::core::mem::offset_of!(SmuMetrics_NV12_legacy_t, AverageVclkFrequency) - 68usize];
    ["Offset of field: SmuMetrics_NV12_legacy_t::AverageDclkFrequency"]
        [::core::mem::offset_of!(SmuMetrics_NV12_legacy_t, AverageDclkFrequency) - 70usize];
    ["Offset of field: SmuMetrics_NV12_legacy_t::VcnActivityPercentage"]
        [::core::mem::offset_of!(SmuMetrics_NV12_legacy_t, VcnActivityPercentage) - 72usize];
    ["Offset of field: SmuMetrics_NV12_legacy_t::padding16_2"]
        [::core::mem::offset_of!(SmuMetrics_NV12_legacy_t, padding16_2) - 74usize];
    ["Offset of field: SmuMetrics_NV12_legacy_t::MmHubPadding"]
        [::core::mem::offset_of!(SmuMetrics_NV12_legacy_t, MmHubPadding) - 76usize];
};
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct SmuMetrics_NV12_t {
    pub CurrClock: [u16; 9usize],
    pub AverageGfxclkFrequencyPostDs: u16,
    pub AverageSocclkFrequency: u16,
    pub AverageUclkFrequencyPostDs: u16,
    pub AverageGfxActivity: u16,
    pub AverageUclkActivity: u16,
    pub CurrSocVoltageOffset: u8,
    pub CurrGfxVoltageOffset: u8,
    pub CurrMemVidOffset: u8,
    pub Padding8: u8,
    pub AverageSocketPower: u16,
    pub TemperatureEdge: u16,
    pub TemperatureHotspot: u16,
    pub TemperatureMem: u16,
    pub TemperatureVrGfx: u16,
    pub TemperatureVrMem0: u16,
    pub TemperatureVrMem1: u16,
    pub TemperatureVrSoc: u16,
    pub TemperatureLiquid0: u16,
    pub TemperatureLiquid1: u16,
    pub TemperaturePlx: u16,
    pub Padding16: u16,
    pub ThrottlerStatus: u32,
    pub LinkDpmLevel: u8,
    pub Padding8_2: u8,
    pub CurrFanSpeed: u16,
    pub AverageVclkFrequency: u16,
    pub AverageDclkFrequency: u16,
    pub VcnActivityPercentage: u16,
    pub AverageGfxclkFrequencyPreDs: u16,
    pub AverageUclkFrequencyPreDs: u16,
    pub PcieRate: u8,
    pub PcieWidth: u8,
    pub Padding32_1: u32,
    pub EnergyAccumulator: u64,
    pub MmHubPadding: [u32; 8usize],
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of SmuMetrics_NV12_t"][::core::mem::size_of::<SmuMetrics_NV12_t>() - 120usize];
    ["Alignment of SmuMetrics_NV12_t"][::core::mem::align_of::<SmuMetrics_NV12_t>() - 8usize];
    ["Offset of field: SmuMetrics_NV12_t::CurrClock"]
        [::core::mem::offset_of!(SmuMetrics_NV12_t, CurrClock) - 0usize];
    ["Offset of field: SmuMetrics_NV12_t::AverageGfxclkFrequencyPostDs"]
        [::core::mem::offset_of!(SmuMetrics_NV12_t, AverageGfxclkFrequencyPostDs) - 18usize];
    ["Offset of field: SmuMetrics_NV12_t::AverageSocclkFrequency"]
        [::core::mem::offset_of!(SmuMetrics_NV12_t, AverageSocclkFrequency) - 20usize];
    ["Offset of field: SmuMetrics_NV12_t::AverageUclkFrequencyPostDs"]
        [::core::mem::offset_of!(SmuMetrics_NV12_t, AverageUclkFrequencyPostDs) - 22usize];
    ["Offset of field: SmuMetrics_NV12_t::AverageGfxActivity"]
        [::core::mem::offset_of!(SmuMetrics_NV12_t, AverageGfxActivity) - 24usize];
    ["Offset of field: SmuMetrics_NV12_t::AverageUclkActivity"]
        [::core::mem::offset_of!(SmuMetrics_NV12_t, AverageUclkActivity) - 26usize];
    ["Offset of field: SmuMetrics_NV12_t::CurrSocVoltageOffset"]
        [::core::mem::offset_of!(SmuMetrics_NV12_t, CurrSocVoltageOffset) - 28usize];
    ["Offset of field: SmuMetrics_NV12_t::CurrGfxVoltageOffset"]
        [::core::mem::offset_of!(SmuMetrics_NV12_t, CurrGfxVoltageOffset) - 29usize];
    ["Offset of field: SmuMetrics_NV12_t::CurrMemVidOffset"]
        [::core::mem::offset_of!(SmuMetrics_NV12_t, CurrMemVidOffset) - 30usize];
    ["Offset of field: SmuMetrics_NV12_t::Padding8"]
        [::core::mem::offset_of!(SmuMetrics_NV12_t, Padding8) - 31usize];
    ["Offset of field: SmuMetrics_NV12_t::AverageSocketPower"]
        [::core::mem::offset_of!(SmuMetrics_NV12_t, AverageSocketPower) - 32usize];
    ["Offset of field: SmuMetrics_NV12_t::TemperatureEdge"]
        [::core::mem::offset_of!(SmuMetrics_NV12_t, TemperatureEdge) - 34usize];
    ["Offset of field: SmuMetrics_NV12_t::TemperatureHotspot"]
        [::core::mem::offset_of!(SmuMetrics_NV12_t, TemperatureHotspot) - 36usize];
    ["Offset of field: SmuMetrics_NV12_t::TemperatureMem"]
        [::core::mem::offset_of!(SmuMetrics_NV12_t, TemperatureMem) - 38usize];
    ["Offset of field: SmuMetrics_NV12_t::TemperatureVrGfx"]
        [::core::mem::offset_of!(SmuMetrics_NV12_t, TemperatureVrGfx) - 40usize];
    ["Offset of field: SmuMetrics_NV12_t::TemperatureVrMem0"]
        [::core::mem::offset_of!(SmuMetrics_NV12_t, TemperatureVrMem0) - 42usize];
    ["Offset of field: SmuMetrics_NV12_t::TemperatureVrMem1"]
        [::core::mem::offset_of!(SmuMetrics_NV12_t, TemperatureVrMem1) - 44usize];
    ["Offset of field: SmuMetrics_NV12_t::TemperatureVrSoc"]
        [::core::mem::offset_of!(SmuMetrics_NV12_t, TemperatureVrSoc) - 46usize];
    ["Offset of field: SmuMetrics_NV12_t::TemperatureLiquid0"]
        [::core::mem::offset_of!(SmuMetrics_NV12_t, TemperatureLiquid0) - 48usize];
    ["Offset of field: SmuMetrics_NV12_t::TemperatureLiquid1"]
        [::core::mem::offset_of!(SmuMetrics_NV12_t, TemperatureLiquid1) - 50usize];
    ["Offset of field: SmuMetrics_NV12_t::TemperaturePlx"]
        [::core::mem::offset_of!(SmuMetrics_NV12_t, TemperaturePlx) - 52usize];
    ["Offset of field: SmuMetrics_NV12_t::Padding16"]
        [::core::mem::offset_of!(SmuMetrics_NV12_t, Padding16) - 54usize];
    ["Offset of field: SmuMetrics_NV12_t::ThrottlerStatus"]
        [::core::mem::offset_of!(SmuMetrics_NV12_t, ThrottlerStatus) - 56usize];
    ["Offset of field: SmuMetrics_NV12_t::LinkDpmLevel"]
        [::core::mem::offset_of!(SmuMetrics_NV12_t, LinkDpmLevel) - 60usize];
    ["Offset of field: SmuMetrics_NV12_t::Padding8_2"]
        [::core::mem::offset_of!(SmuMetrics_NV12_t, Padding8_2) - 61usize];
    ["Offset of field: SmuMetrics_NV12_t::CurrFanSpeed"]
        [::core::mem::offset_of!(SmuMetrics_NV12_t, CurrFanSpeed) - 62usize];
    ["Offset of field: SmuMetrics_NV12_t::AverageVclkFrequency"]
        [::core::mem::offset_of!(SmuMetrics_NV12_t, AverageVclkFrequency) - 64usize];
    ["Offset of field: SmuMetrics_NV12_t::AverageDclkFrequency"]
        [::core::mem::offset_of!(SmuMetrics_NV12_t, AverageDclkFrequency) - 66usize];
    ["Offset of field: SmuMetrics_NV12_t::VcnActivityPercentage"]
        [::core::mem::offset_of!(SmuMetrics_NV12_t, VcnActivityPercentage) - 68usize];
    ["Offset of field: SmuMetrics_NV12_t::AverageGfxclkFrequencyPreDs"]
        [::core::mem::offset_of!(SmuMetrics_NV12_t, AverageGfxclkFrequencyPreDs) - 70usize];
    ["Offset of field: SmuMetrics_NV12_t::AverageUclkFrequencyPreDs"]
        [::core::mem::offset_of!(SmuMetrics_NV12_t, AverageUclkFrequencyPreDs) - 72usize];
    ["Offset of field: SmuMetrics_NV12_t::PcieRate"]
        [::core::mem::offset_of!(SmuMetrics_NV12_t, PcieRate) - 74usize];
    ["Offset of field: SmuMetrics_NV12_t::PcieWidth"]
        [::core::mem::offset_of!(SmuMetrics_NV12_t, PcieWidth) - 75usize];
    ["Offset of field: SmuMetrics_NV12_t::Padding32_1"]
        [::core::mem::offset_of!(SmuMetrics_NV12_t, Padding32_1) - 76usize];
    ["Offset of field: SmuMetrics_NV12_t::EnergyAccumulator"]
        [::core::mem::offset_of!(SmuMetrics_NV12_t, EnergyAccumulator) - 80usize];
    ["Offset of field: SmuMetrics_NV12_t::MmHubPadding"]
        [::core::mem::offset_of!(SmuMetrics_NV12_t, MmHubPadding) - 88usize];
};
#[repr(C)]
#[derive(Copy, Clone)]
pub union SmuMetrics {
    pub nv10_legacy_metrics: SmuMetrics_legacy_t,
    pub nv10_metrics: SmuMetrics_t,
    pub nv12_legacy_metrics: SmuMetrics_NV12_legacy_t,
    pub nv12_metrics: SmuMetrics_NV12_t,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of SmuMetrics"][::core::mem::size_of::<SmuMetrics>() - 120usize];
    ["Alignment of SmuMetrics"][::core::mem::align_of::<SmuMetrics>() - 8usize];
    ["Offset of field: SmuMetrics::nv10_legacy_metrics"]
        [::core::mem::offset_of!(SmuMetrics, nv10_legacy_metrics) - 0usize];
    ["Offset of field: SmuMetrics::nv10_metrics"]
        [::core::mem::offset_of!(SmuMetrics, nv10_metrics) - 0usize];
    ["Offset of field: SmuMetrics::nv12_legacy_metrics"]
        [::core::mem::offset_of!(SmuMetrics, nv12_legacy_metrics) - 0usize];
    ["Offset of field: SmuMetrics::nv12_metrics"]
        [::core::mem::offset_of!(SmuMetrics, nv12_metrics) - 0usize];
};
pub type SmuMetrics_NV1X_t = SmuMetrics;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct WatermarkRowGeneric_t {
    pub MinClock: u16,
    pub MaxClock: u16,
    pub MinUclk: u16,
    pub MaxUclk: u16,
    pub WmSetting: u8,
    pub Padding: [u8; 3usize],
    pub MmHubPadding: [u32; 8usize],
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of WatermarkRowGeneric_t"][::core::mem::size_of::<WatermarkRowGeneric_t>() - 44usize];
    ["Alignment of WatermarkRowGeneric_t"]
        [::core::mem::align_of::<WatermarkRowGeneric_t>() - 4usize];
    ["Offset of field: WatermarkRowGeneric_t::MinClock"]
        [::core::mem::offset_of!(WatermarkRowGeneric_t, MinClock) - 0usize];
    ["Offset of field: WatermarkRowGeneric_t::MaxClock"]
        [::core::mem::offset_of!(WatermarkRowGeneric_t, MaxClock) - 2usize];
    ["Offset of field: WatermarkRowGeneric_t::MinUclk"]
        [::core::mem::offset_of!(WatermarkRowGeneric_t, MinUclk) - 4usize];
    ["Offset of field: WatermarkRowGeneric_t::MaxUclk"]
        [::core::mem::offset_of!(WatermarkRowGeneric_t, MaxUclk) - 6usize];
    ["Offset of field: WatermarkRowGeneric_t::WmSetting"]
        [::core::mem::offset_of!(WatermarkRowGeneric_t, WmSetting) - 8usize];
    ["Offset of field: WatermarkRowGeneric_t::Padding"]
        [::core::mem::offset_of!(WatermarkRowGeneric_t, Padding) - 9usize];
    ["Offset of field: WatermarkRowGeneric_t::MmHubPadding"]
        [::core::mem::offset_of!(WatermarkRowGeneric_t, MmHubPadding) - 12usize];
};
pub const WM_CLOCK_e_WM_SOCCLK: WM_CLOCK_e = 0;
pub const WM_CLOCK_e_WM_DCEFCLK: WM_CLOCK_e = 1;
pub const WM_CLOCK_e_WM_COUNT: WM_CLOCK_e = 2;
pub type WM_CLOCK_e = ::core::ffi::c_uint;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct Watermarks_t {
    pub WatermarkRow: [[WatermarkRowGeneric_t; 4usize]; 2usize],
    pub MmHubPadding: [u32; 8usize],
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of Watermarks_t"][::core::mem::size_of::<Watermarks_t>() - 384usize];
    ["Alignment of Watermarks_t"][::core::mem::align_of::<Watermarks_t>() - 4usize];
    ["Offset of field: Watermarks_t::WatermarkRow"]
        [::core::mem::offset_of!(Watermarks_t, WatermarkRow) - 0usize];
    ["Offset of field: Watermarks_t::MmHubPadding"]
        [::core::mem::offset_of!(Watermarks_t, MmHubPadding) - 352usize];
};
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct AvfsDebugTable_t_NV14 {
    pub avgPsmCount: [u16; 28usize],
    pub minPsmCount: [u16; 28usize],
    pub avgPsmVoltage: [f32; 28usize],
    pub minPsmVoltage: [f32; 28usize],
    pub MmHubPadding: [u32; 32usize],
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of AvfsDebugTable_t_NV14"][::core::mem::size_of::<AvfsDebugTable_t_NV14>() - 464usize];
    ["Alignment of AvfsDebugTable_t_NV14"]
        [::core::mem::align_of::<AvfsDebugTable_t_NV14>() - 4usize];
    ["Offset of field: AvfsDebugTable_t_NV14::avgPsmCount"]
        [::core::mem::offset_of!(AvfsDebugTable_t_NV14, avgPsmCount) - 0usize];
    ["Offset of field: AvfsDebugTable_t_NV14::minPsmCount"]
        [::core::mem::offset_of!(AvfsDebugTable_t_NV14, minPsmCount) - 56usize];
    ["Offset of field: AvfsDebugTable_t_NV14::avgPsmVoltage"]
        [::core::mem::offset_of!(AvfsDebugTable_t_NV14, avgPsmVoltage) - 112usize];
    ["Offset of field: AvfsDebugTable_t_NV14::minPsmVoltage"]
        [::core::mem::offset_of!(AvfsDebugTable_t_NV14, minPsmVoltage) - 224usize];
    ["Offset of field: AvfsDebugTable_t_NV14::MmHubPadding"]
        [::core::mem::offset_of!(AvfsDebugTable_t_NV14, MmHubPadding) - 336usize];
};
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct AvfsDebugTable_t_NV10 {
    pub avgPsmCount: [u16; 36usize],
    pub minPsmCount: [u16; 36usize],
    pub avgPsmVoltage: [f32; 36usize],
    pub minPsmVoltage: [f32; 36usize],
    pub MmHubPadding: [u32; 8usize],
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of AvfsDebugTable_t_NV10"][::core::mem::size_of::<AvfsDebugTable_t_NV10>() - 464usize];
    ["Alignment of AvfsDebugTable_t_NV10"]
        [::core::mem::align_of::<AvfsDebugTable_t_NV10>() - 4usize];
    ["Offset of field: AvfsDebugTable_t_NV10::avgPsmCount"]
        [::core::mem::offset_of!(AvfsDebugTable_t_NV10, avgPsmCount) - 0usize];
    ["Offset of field: AvfsDebugTable_t_NV10::minPsmCount"]
        [::core::mem::offset_of!(AvfsDebugTable_t_NV10, minPsmCount) - 72usize];
    ["Offset of field: AvfsDebugTable_t_NV10::avgPsmVoltage"]
        [::core::mem::offset_of!(AvfsDebugTable_t_NV10, avgPsmVoltage) - 144usize];
    ["Offset of field: AvfsDebugTable_t_NV10::minPsmVoltage"]
        [::core::mem::offset_of!(AvfsDebugTable_t_NV10, minPsmVoltage) - 288usize];
    ["Offset of field: AvfsDebugTable_t_NV10::MmHubPadding"]
        [::core::mem::offset_of!(AvfsDebugTable_t_NV10, MmHubPadding) - 432usize];
};
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct AvfsFuseOverride_t {
    pub AvfsVersion: u8,
    pub Padding: u8,
    pub AvfsEn: [u8; 2usize],
    pub OverrideVFT: [u8; 2usize],
    pub OverrideAvfsGb: [u8; 2usize],
    pub OverrideTemperatures: [u8; 2usize],
    pub OverrideVInversion: [u8; 2usize],
    pub OverrideP2V: [u8; 2usize],
    pub OverrideP2VCharzFreq: [u8; 2usize],
    pub VFT0_m1: [i32; 2usize],
    pub VFT0_m2: [i32; 2usize],
    pub VFT0_b: [i32; 2usize],
    pub VFT1_m1: [i32; 2usize],
    pub VFT1_m2: [i32; 2usize],
    pub VFT1_b: [i32; 2usize],
    pub VFT2_m1: [i32; 2usize],
    pub VFT2_m2: [i32; 2usize],
    pub VFT2_b: [i32; 2usize],
    pub AvfsGb0_m1: [i32; 2usize],
    pub AvfsGb0_m2: [i32; 2usize],
    pub AvfsGb0_b: [i32; 2usize],
    pub AcBtcGb_m1: [i32; 2usize],
    pub AcBtcGb_m2: [i32; 2usize],
    pub AcBtcGb_b: [i32; 2usize],
    pub AvfsTempCold: [u32; 2usize],
    pub AvfsTempMid: [u32; 2usize],
    pub AvfsTempHot: [u32; 2usize],
    pub VInversion: [u32; 2usize],
    pub P2V_m1: [i32; 2usize],
    pub P2V_m2: [i32; 2usize],
    pub P2V_b: [i32; 2usize],
    pub P2VCharzFreq: [u32; 2usize],
    pub EnabledAvfsModules: [u32; 2usize],
    pub MmHubPadding: [u32; 8usize],
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of AvfsFuseOverride_t"][::core::mem::size_of::<AvfsFuseOverride_t>() - 240usize];
    ["Alignment of AvfsFuseOverride_t"][::core::mem::align_of::<AvfsFuseOverride_t>() - 4usize];
    ["Offset of field: AvfsFuseOverride_t::AvfsVersion"]
        [::core::mem::offset_of!(AvfsFuseOverride_t, AvfsVersion) - 0usize];
    ["Offset of field: AvfsFuseOverride_t::Padding"]
        [::core::mem::offset_of!(AvfsFuseOverride_t, Padding) - 1usize];
    ["Offset of field: AvfsFuseOverride_t::AvfsEn"]
        [::core::mem::offset_of!(AvfsFuseOverride_t, AvfsEn) - 2usize];
    ["Offset of field: AvfsFuseOverride_t::OverrideVFT"]
        [::core::mem::offset_of!(AvfsFuseOverride_t, OverrideVFT) - 4usize];
    ["Offset of field: AvfsFuseOverride_t::OverrideAvfsGb"]
        [::core::mem::offset_of!(AvfsFuseOverride_t, OverrideAvfsGb) - 6usize];
    ["Offset of field: AvfsFuseOverride_t::OverrideTemperatures"]
        [::core::mem::offset_of!(AvfsFuseOverride_t, OverrideTemperatures) - 8usize];
    ["Offset of field: AvfsFuseOverride_t::OverrideVInversion"]
        [::core::mem::offset_of!(AvfsFuseOverride_t, OverrideVInversion) - 10usize];
    ["Offset of field: AvfsFuseOverride_t::OverrideP2V"]
        [::core::mem::offset_of!(AvfsFuseOverride_t, OverrideP2V) - 12usize];
    ["Offset of field: AvfsFuseOverride_t::OverrideP2VCharzFreq"]
        [::core::mem::offset_of!(AvfsFuseOverride_t, OverrideP2VCharzFreq) - 14usize];
    ["Offset of field: AvfsFuseOverride_t::VFT0_m1"]
        [::core::mem::offset_of!(AvfsFuseOverride_t, VFT0_m1) - 16usize];
    ["Offset of field: AvfsFuseOverride_t::VFT0_m2"]
        [::core::mem::offset_of!(AvfsFuseOverride_t, VFT0_m2) - 24usize];
    ["Offset of field: AvfsFuseOverride_t::VFT0_b"]
        [::core::mem::offset_of!(AvfsFuseOverride_t, VFT0_b) - 32usize];
    ["Offset of field: AvfsFuseOverride_t::VFT1_m1"]
        [::core::mem::offset_of!(AvfsFuseOverride_t, VFT1_m1) - 40usize];
    ["Offset of field: AvfsFuseOverride_t::VFT1_m2"]
        [::core::mem::offset_of!(AvfsFuseOverride_t, VFT1_m2) - 48usize];
    ["Offset of field: AvfsFuseOverride_t::VFT1_b"]
        [::core::mem::offset_of!(AvfsFuseOverride_t, VFT1_b) - 56usize];
    ["Offset of field: AvfsFuseOverride_t::VFT2_m1"]
        [::core::mem::offset_of!(AvfsFuseOverride_t, VFT2_m1) - 64usize];
    ["Offset of field: AvfsFuseOverride_t::VFT2_m2"]
        [::core::mem::offset_of!(AvfsFuseOverride_t, VFT2_m2) - 72usize];
    ["Offset of field: AvfsFuseOverride_t::VFT2_b"]
        [::core::mem::offset_of!(AvfsFuseOverride_t, VFT2_b) - 80usize];
    ["Offset of field: AvfsFuseOverride_t::AvfsGb0_m1"]
        [::core::mem::offset_of!(AvfsFuseOverride_t, AvfsGb0_m1) - 88usize];
    ["Offset of field: AvfsFuseOverride_t::AvfsGb0_m2"]
        [::core::mem::offset_of!(AvfsFuseOverride_t, AvfsGb0_m2) - 96usize];
    ["Offset of field: AvfsFuseOverride_t::AvfsGb0_b"]
        [::core::mem::offset_of!(AvfsFuseOverride_t, AvfsGb0_b) - 104usize];
    ["Offset of field: AvfsFuseOverride_t::AcBtcGb_m1"]
        [::core::mem::offset_of!(AvfsFuseOverride_t, AcBtcGb_m1) - 112usize];
    ["Offset of field: AvfsFuseOverride_t::AcBtcGb_m2"]
        [::core::mem::offset_of!(AvfsFuseOverride_t, AcBtcGb_m2) - 120usize];
    ["Offset of field: AvfsFuseOverride_t::AcBtcGb_b"]
        [::core::mem::offset_of!(AvfsFuseOverride_t, AcBtcGb_b) - 128usize];
    ["Offset of field: AvfsFuseOverride_t::AvfsTempCold"]
        [::core::mem::offset_of!(AvfsFuseOverride_t, AvfsTempCold) - 136usize];
    ["Offset of field: AvfsFuseOverride_t::AvfsTempMid"]
        [::core::mem::offset_of!(AvfsFuseOverride_t, AvfsTempMid) - 144usize];
    ["Offset of field: AvfsFuseOverride_t::AvfsTempHot"]
        [::core::mem::offset_of!(AvfsFuseOverride_t, AvfsTempHot) - 152usize];
    ["Offset of field: AvfsFuseOverride_t::VInversion"]
        [::core::mem::offset_of!(AvfsFuseOverride_t, VInversion) - 160usize];
    ["Offset of field: AvfsFuseOverride_t::P2V_m1"]
        [::core::mem::offset_of!(AvfsFuseOverride_t, P2V_m1) - 168usize];
    ["Offset of field: AvfsFuseOverride_t::P2V_m2"]
        [::core::mem::offset_of!(AvfsFuseOverride_t, P2V_m2) - 176usize];
    ["Offset of field: AvfsFuseOverride_t::P2V_b"]
        [::core::mem::offset_of!(AvfsFuseOverride_t, P2V_b) - 184usize];
    ["Offset of field: AvfsFuseOverride_t::P2VCharzFreq"]
        [::core::mem::offset_of!(AvfsFuseOverride_t, P2VCharzFreq) - 192usize];
    ["Offset of field: AvfsFuseOverride_t::EnabledAvfsModules"]
        [::core::mem::offset_of!(AvfsFuseOverride_t, EnabledAvfsModules) - 200usize];
    ["Offset of field: AvfsFuseOverride_t::MmHubPadding"]
        [::core::mem::offset_of!(AvfsFuseOverride_t, MmHubPadding) - 208usize];
};
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct DpmActivityMonitorCoeffInt_t {
    pub Gfx_ActiveHystLimit: u8,
    pub Gfx_IdleHystLimit: u8,
    pub Gfx_FPS: u8,
    pub Gfx_MinActiveFreqType: u8,
    pub Gfx_BoosterFreqType: u8,
    pub Gfx_MinFreqStep: u8,
    pub Gfx_MinActiveFreq: u16,
    pub Gfx_BoosterFreq: u16,
    pub Gfx_PD_Data_time_constant: u16,
    pub Gfx_PD_Data_limit_a: u32,
    pub Gfx_PD_Data_limit_b: u32,
    pub Gfx_PD_Data_limit_c: u32,
    pub Gfx_PD_Data_error_coeff: u32,
    pub Gfx_PD_Data_error_rate_coeff: u32,
    pub Soc_ActiveHystLimit: u8,
    pub Soc_IdleHystLimit: u8,
    pub Soc_FPS: u8,
    pub Soc_MinActiveFreqType: u8,
    pub Soc_BoosterFreqType: u8,
    pub Soc_MinFreqStep: u8,
    pub Soc_MinActiveFreq: u16,
    pub Soc_BoosterFreq: u16,
    pub Soc_PD_Data_time_constant: u16,
    pub Soc_PD_Data_limit_a: u32,
    pub Soc_PD_Data_limit_b: u32,
    pub Soc_PD_Data_limit_c: u32,
    pub Soc_PD_Data_error_coeff: u32,
    pub Soc_PD_Data_error_rate_coeff: u32,
    pub Mem_ActiveHystLimit: u8,
    pub Mem_IdleHystLimit: u8,
    pub Mem_FPS: u8,
    pub Mem_MinActiveFreqType: u8,
    pub Mem_BoosterFreqType: u8,
    pub Mem_MinFreqStep: u8,
    pub Mem_MinActiveFreq: u16,
    pub Mem_BoosterFreq: u16,
    pub Mem_PD_Data_time_constant: u16,
    pub Mem_PD_Data_limit_a: u32,
    pub Mem_PD_Data_limit_b: u32,
    pub Mem_PD_Data_limit_c: u32,
    pub Mem_PD_Data_error_coeff: u32,
    pub Mem_PD_Data_error_rate_coeff: u32,
    pub Mem_UpThreshold_Limit: u32,
    pub Mem_UpHystLimit: u8,
    pub Mem_DownHystLimit: u8,
    pub Mem_Fps: u16,
    pub MmHubPadding: [u32; 8usize],
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of DpmActivityMonitorCoeffInt_t"]
        [::core::mem::size_of::<DpmActivityMonitorCoeffInt_t>() - 136usize];
    ["Alignment of DpmActivityMonitorCoeffInt_t"]
        [::core::mem::align_of::<DpmActivityMonitorCoeffInt_t>() - 4usize];
    ["Offset of field: DpmActivityMonitorCoeffInt_t::Gfx_ActiveHystLimit"]
        [::core::mem::offset_of!(DpmActivityMonitorCoeffInt_t, Gfx_ActiveHystLimit) - 0usize];
    ["Offset of field: DpmActivityMonitorCoeffInt_t::Gfx_IdleHystLimit"]
        [::core::mem::offset_of!(DpmActivityMonitorCoeffInt_t, Gfx_IdleHystLimit) - 1usize];
    ["Offset of field: DpmActivityMonitorCoeffInt_t::Gfx_FPS"]
        [::core::mem::offset_of!(DpmActivityMonitorCoeffInt_t, Gfx_FPS) - 2usize];
    ["Offset of field: DpmActivityMonitorCoeffInt_t::Gfx_MinActiveFreqType"]
        [::core::mem::offset_of!(DpmActivityMonitorCoeffInt_t, Gfx_MinActiveFreqType) - 3usize];
    ["Offset of field: DpmActivityMonitorCoeffInt_t::Gfx_BoosterFreqType"]
        [::core::mem::offset_of!(DpmActivityMonitorCoeffInt_t, Gfx_BoosterFreqType) - 4usize];
    ["Offset of field: DpmActivityMonitorCoeffInt_t::Gfx_MinFreqStep"]
        [::core::mem::offset_of!(DpmActivityMonitorCoeffInt_t, Gfx_MinFreqStep) - 5usize];
    ["Offset of field: DpmActivityMonitorCoeffInt_t::Gfx_MinActiveFreq"]
        [::core::mem::offset_of!(DpmActivityMonitorCoeffInt_t, Gfx_MinActiveFreq) - 6usize];
    ["Offset of field: DpmActivityMonitorCoeffInt_t::Gfx_BoosterFreq"]
        [::core::mem::offset_of!(DpmActivityMonitorCoeffInt_t, Gfx_BoosterFreq) - 8usize];
    ["Offset of field: DpmActivityMonitorCoeffInt_t::Gfx_PD_Data_time_constant"][::core::mem::offset_of!(
        DpmActivityMonitorCoeffInt_t,
        Gfx_PD_Data_time_constant
    ) - 10usize];
    ["Offset of field: DpmActivityMonitorCoeffInt_t::Gfx_PD_Data_limit_a"]
        [::core::mem::offset_of!(DpmActivityMonitorCoeffInt_t, Gfx_PD_Data_limit_a) - 12usize];
    ["Offset of field: DpmActivityMonitorCoeffInt_t::Gfx_PD_Data_limit_b"]
        [::core::mem::offset_of!(DpmActivityMonitorCoeffInt_t, Gfx_PD_Data_limit_b) - 16usize];
    ["Offset of field: DpmActivityMonitorCoeffInt_t::Gfx_PD_Data_limit_c"]
        [::core::mem::offset_of!(DpmActivityMonitorCoeffInt_t, Gfx_PD_Data_limit_c) - 20usize];
    ["Offset of field: DpmActivityMonitorCoeffInt_t::Gfx_PD_Data_error_coeff"]
        [::core::mem::offset_of!(DpmActivityMonitorCoeffInt_t, Gfx_PD_Data_error_coeff) - 24usize];
    ["Offset of field: DpmActivityMonitorCoeffInt_t::Gfx_PD_Data_error_rate_coeff"][::core::mem::offset_of!(
        DpmActivityMonitorCoeffInt_t,
        Gfx_PD_Data_error_rate_coeff
    ) - 28usize];
    ["Offset of field: DpmActivityMonitorCoeffInt_t::Soc_ActiveHystLimit"]
        [::core::mem::offset_of!(DpmActivityMonitorCoeffInt_t, Soc_ActiveHystLimit) - 32usize];
    ["Offset of field: DpmActivityMonitorCoeffInt_t::Soc_IdleHystLimit"]
        [::core::mem::offset_of!(DpmActivityMonitorCoeffInt_t, Soc_IdleHystLimit) - 33usize];
    ["Offset of field: DpmActivityMonitorCoeffInt_t::Soc_FPS"]
        [::core::mem::offset_of!(DpmActivityMonitorCoeffInt_t, Soc_FPS) - 34usize];
    ["Offset of field: DpmActivityMonitorCoeffInt_t::Soc_MinActiveFreqType"]
        [::core::mem::offset_of!(DpmActivityMonitorCoeffInt_t, Soc_MinActiveFreqType) - 35usize];
    ["Offset of field: DpmActivityMonitorCoeffInt_t::Soc_BoosterFreqType"]
        [::core::mem::offset_of!(DpmActivityMonitorCoeffInt_t, Soc_BoosterFreqType) - 36usize];
    ["Offset of field: DpmActivityMonitorCoeffInt_t::Soc_MinFreqStep"]
        [::core::mem::offset_of!(DpmActivityMonitorCoeffInt_t, Soc_MinFreqStep) - 37usize];
    ["Offset of field: DpmActivityMonitorCoeffInt_t::Soc_MinActiveFreq"]
        [::core::mem::offset_of!(DpmActivityMonitorCoeffInt_t, Soc_MinActiveFreq) - 38usize];
    ["Offset of field: DpmActivityMonitorCoeffInt_t::Soc_BoosterFreq"]
        [::core::mem::offset_of!(DpmActivityMonitorCoeffInt_t, Soc_BoosterFreq) - 40usize];
    ["Offset of field: DpmActivityMonitorCoeffInt_t::Soc_PD_Data_time_constant"][::core::mem::offset_of!(
        DpmActivityMonitorCoeffInt_t,
        Soc_PD_Data_time_constant
    ) - 42usize];
    ["Offset of field: DpmActivityMonitorCoeffInt_t::Soc_PD_Data_limit_a"]
        [::core::mem::offset_of!(DpmActivityMonitorCoeffInt_t, Soc_PD_Data_limit_a) - 44usize];
    ["Offset of field: DpmActivityMonitorCoeffInt_t::Soc_PD_Data_limit_b"]
        [::core::mem::offset_of!(DpmActivityMonitorCoeffInt_t, Soc_PD_Data_limit_b) - 48usize];
    ["Offset of field: DpmActivityMonitorCoeffInt_t::Soc_PD_Data_limit_c"]
        [::core::mem::offset_of!(DpmActivityMonitorCoeffInt_t, Soc_PD_Data_limit_c) - 52usize];
    ["Offset of field: DpmActivityMonitorCoeffInt_t::Soc_PD_Data_error_coeff"]
        [::core::mem::offset_of!(DpmActivityMonitorCoeffInt_t, Soc_PD_Data_error_coeff) - 56usize];
    ["Offset of field: DpmActivityMonitorCoeffInt_t::Soc_PD_Data_error_rate_coeff"][::core::mem::offset_of!(
        DpmActivityMonitorCoeffInt_t,
        Soc_PD_Data_error_rate_coeff
    ) - 60usize];
    ["Offset of field: DpmActivityMonitorCoeffInt_t::Mem_ActiveHystLimit"]
        [::core::mem::offset_of!(DpmActivityMonitorCoeffInt_t, Mem_ActiveHystLimit) - 64usize];
    ["Offset of field: DpmActivityMonitorCoeffInt_t::Mem_IdleHystLimit"]
        [::core::mem::offset_of!(DpmActivityMonitorCoeffInt_t, Mem_IdleHystLimit) - 65usize];
    ["Offset of field: DpmActivityMonitorCoeffInt_t::Mem_FPS"]
        [::core::mem::offset_of!(DpmActivityMonitorCoeffInt_t, Mem_FPS) - 66usize];
    ["Offset of field: DpmActivityMonitorCoeffInt_t::Mem_MinActiveFreqType"]
        [::core::mem::offset_of!(DpmActivityMonitorCoeffInt_t, Mem_MinActiveFreqType) - 67usize];
    ["Offset of field: DpmActivityMonitorCoeffInt_t::Mem_BoosterFreqType"]
        [::core::mem::offset_of!(DpmActivityMonitorCoeffInt_t, Mem_BoosterFreqType) - 68usize];
    ["Offset of field: DpmActivityMonitorCoeffInt_t::Mem_MinFreqStep"]
        [::core::mem::offset_of!(DpmActivityMonitorCoeffInt_t, Mem_MinFreqStep) - 69usize];
    ["Offset of field: DpmActivityMonitorCoeffInt_t::Mem_MinActiveFreq"]
        [::core::mem::offset_of!(DpmActivityMonitorCoeffInt_t, Mem_MinActiveFreq) - 70usize];
    ["Offset of field: DpmActivityMonitorCoeffInt_t::Mem_BoosterFreq"]
        [::core::mem::offset_of!(DpmActivityMonitorCoeffInt_t, Mem_BoosterFreq) - 72usize];
    ["Offset of field: DpmActivityMonitorCoeffInt_t::Mem_PD_Data_time_constant"][::core::mem::offset_of!(
        DpmActivityMonitorCoeffInt_t,
        Mem_PD_Data_time_constant
    ) - 74usize];
    ["Offset of field: DpmActivityMonitorCoeffInt_t::Mem_PD_Data_limit_a"]
        [::core::mem::offset_of!(DpmActivityMonitorCoeffInt_t, Mem_PD_Data_limit_a) - 76usize];
    ["Offset of field: DpmActivityMonitorCoeffInt_t::Mem_PD_Data_limit_b"]
        [::core::mem::offset_of!(DpmActivityMonitorCoeffInt_t, Mem_PD_Data_limit_b) - 80usize];
    ["Offset of field: DpmActivityMonitorCoeffInt_t::Mem_PD_Data_limit_c"]
        [::core::mem::offset_of!(DpmActivityMonitorCoeffInt_t, Mem_PD_Data_limit_c) - 84usize];
    ["Offset of field: DpmActivityMonitorCoeffInt_t::Mem_PD_Data_error_coeff"]
        [::core::mem::offset_of!(DpmActivityMonitorCoeffInt_t, Mem_PD_Data_error_coeff) - 88usize];
    ["Offset of field: DpmActivityMonitorCoeffInt_t::Mem_PD_Data_error_rate_coeff"][::core::mem::offset_of!(
        DpmActivityMonitorCoeffInt_t,
        Mem_PD_Data_error_rate_coeff
    ) - 92usize];
    ["Offset of field: DpmActivityMonitorCoeffInt_t::Mem_UpThreshold_Limit"]
        [::core::mem::offset_of!(DpmActivityMonitorCoeffInt_t, Mem_UpThreshold_Limit) - 96usize];
    ["Offset of field: DpmActivityMonitorCoeffInt_t::Mem_UpHystLimit"]
        [::core::mem::offset_of!(DpmActivityMonitorCoeffInt_t, Mem_UpHystLimit) - 100usize];
    ["Offset of field: DpmActivityMonitorCoeffInt_t::Mem_DownHystLimit"]
        [::core::mem::offset_of!(DpmActivityMonitorCoeffInt_t, Mem_DownHystLimit) - 101usize];
    ["Offset of field: DpmActivityMonitorCoeffInt_t::Mem_Fps"]
        [::core::mem::offset_of!(DpmActivityMonitorCoeffInt_t, Mem_Fps) - 102usize];
    ["Offset of field: DpmActivityMonitorCoeffInt_t::MmHubPadding"]
        [::core::mem::offset_of!(DpmActivityMonitorCoeffInt_t, MmHubPadding) - 104usize];
};
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct RlcPaceFlopsPerByteOverride_t {
    pub FlopsPerByteTable: [f32; 16usize],
    pub MmHubPadding: [u32; 8usize],
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of RlcPaceFlopsPerByteOverride_t"]
        [::core::mem::size_of::<RlcPaceFlopsPerByteOverride_t>() - 96usize];
    ["Alignment of RlcPaceFlopsPerByteOverride_t"]
        [::core::mem::align_of::<RlcPaceFlopsPerByteOverride_t>() - 4usize];
    ["Offset of field: RlcPaceFlopsPerByteOverride_t::FlopsPerByteTable"]
        [::core::mem::offset_of!(RlcPaceFlopsPerByteOverride_t, FlopsPerByteTable) - 0usize];
    ["Offset of field: RlcPaceFlopsPerByteOverride_t::MmHubPadding"]
        [::core::mem::offset_of!(RlcPaceFlopsPerByteOverride_t, MmHubPadding) - 64usize];
};
pub const SMU_11_0_ODFEATURE_CAP_SMU_11_0_ODCAP_GFXCLK_LIMITS: SMU_11_0_ODFEATURE_CAP = 0;
pub const SMU_11_0_ODFEATURE_CAP_SMU_11_0_ODCAP_GFXCLK_CURVE: SMU_11_0_ODFEATURE_CAP = 1;
pub const SMU_11_0_ODFEATURE_CAP_SMU_11_0_ODCAP_UCLK_MAX: SMU_11_0_ODFEATURE_CAP = 2;
pub const SMU_11_0_ODFEATURE_CAP_SMU_11_0_ODCAP_POWER_LIMIT: SMU_11_0_ODFEATURE_CAP = 3;
pub const SMU_11_0_ODFEATURE_CAP_SMU_11_0_ODCAP_FAN_ACOUSTIC_LIMIT: SMU_11_0_ODFEATURE_CAP = 4;
pub const SMU_11_0_ODFEATURE_CAP_SMU_11_0_ODCAP_FAN_SPEED_MIN: SMU_11_0_ODFEATURE_CAP = 5;
pub const SMU_11_0_ODFEATURE_CAP_SMU_11_0_ODCAP_TEMPERATURE_FAN: SMU_11_0_ODFEATURE_CAP = 6;
pub const SMU_11_0_ODFEATURE_CAP_SMU_11_0_ODCAP_TEMPERATURE_SYSTEM: SMU_11_0_ODFEATURE_CAP = 7;
pub const SMU_11_0_ODFEATURE_CAP_SMU_11_0_ODCAP_MEMORY_TIMING_TUNE: SMU_11_0_ODFEATURE_CAP = 8;
pub const SMU_11_0_ODFEATURE_CAP_SMU_11_0_ODCAP_FAN_ZERO_RPM_CONTROL: SMU_11_0_ODFEATURE_CAP = 9;
pub const SMU_11_0_ODFEATURE_CAP_SMU_11_0_ODCAP_AUTO_UV_ENGINE: SMU_11_0_ODFEATURE_CAP = 10;
pub const SMU_11_0_ODFEATURE_CAP_SMU_11_0_ODCAP_AUTO_OC_ENGINE: SMU_11_0_ODFEATURE_CAP = 11;
pub const SMU_11_0_ODFEATURE_CAP_SMU_11_0_ODCAP_AUTO_OC_MEMORY: SMU_11_0_ODFEATURE_CAP = 12;
pub const SMU_11_0_ODFEATURE_CAP_SMU_11_0_ODCAP_FAN_CURVE: SMU_11_0_ODFEATURE_CAP = 13;
pub const SMU_11_0_ODFEATURE_CAP_SMU_11_0_ODCAP_COUNT: SMU_11_0_ODFEATURE_CAP = 14;
pub type SMU_11_0_ODFEATURE_CAP = ::core::ffi::c_uint;
pub const SMU_11_0_ODFEATURE_ID_SMU_11_0_ODFEATURE_GFXCLK_LIMITS: SMU_11_0_ODFEATURE_ID = 1;
pub const SMU_11_0_ODFEATURE_ID_SMU_11_0_ODFEATURE_GFXCLK_CURVE: SMU_11_0_ODFEATURE_ID = 2;
pub const SMU_11_0_ODFEATURE_ID_SMU_11_0_ODFEATURE_UCLK_MAX: SMU_11_0_ODFEATURE_ID = 4;
pub const SMU_11_0_ODFEATURE_ID_SMU_11_0_ODFEATURE_POWER_LIMIT: SMU_11_0_ODFEATURE_ID = 8;
pub const SMU_11_0_ODFEATURE_ID_SMU_11_0_ODFEATURE_FAN_ACOUSTIC_LIMIT: SMU_11_0_ODFEATURE_ID = 16;
pub const SMU_11_0_ODFEATURE_ID_SMU_11_0_ODFEATURE_FAN_SPEED_MIN: SMU_11_0_ODFEATURE_ID = 32;
pub const SMU_11_0_ODFEATURE_ID_SMU_11_0_ODFEATURE_TEMPERATURE_FAN: SMU_11_0_ODFEATURE_ID = 64;
pub const SMU_11_0_ODFEATURE_ID_SMU_11_0_ODFEATURE_TEMPERATURE_SYSTEM: SMU_11_0_ODFEATURE_ID = 128;
pub const SMU_11_0_ODFEATURE_ID_SMU_11_0_ODFEATURE_MEMORY_TIMING_TUNE: SMU_11_0_ODFEATURE_ID = 256;
pub const SMU_11_0_ODFEATURE_ID_SMU_11_0_ODFEATURE_FAN_ZERO_RPM_CONTROL: SMU_11_0_ODFEATURE_ID =
    512;
pub const SMU_11_0_ODFEATURE_ID_SMU_11_0_ODFEATURE_AUTO_UV_ENGINE: SMU_11_0_ODFEATURE_ID = 1024;
pub const SMU_11_0_ODFEATURE_ID_SMU_11_0_ODFEATURE_AUTO_OC_ENGINE: SMU_11_0_ODFEATURE_ID = 2048;
pub const SMU_11_0_ODFEATURE_ID_SMU_11_0_ODFEATURE_AUTO_OC_MEMORY: SMU_11_0_ODFEATURE_ID = 4096;
pub const SMU_11_0_ODFEATURE_ID_SMU_11_0_ODFEATURE_FAN_CURVE: SMU_11_0_ODFEATURE_ID = 8192;
pub const SMU_11_0_ODFEATURE_ID_SMU_11_0_ODFEATURE_COUNT: SMU_11_0_ODFEATURE_ID = 14;
pub type SMU_11_0_ODFEATURE_ID = ::core::ffi::c_uint;
pub const SMU_11_0_ODSETTING_ID_SMU_11_0_ODSETTING_GFXCLKFMAX: SMU_11_0_ODSETTING_ID = 0;
pub const SMU_11_0_ODSETTING_ID_SMU_11_0_ODSETTING_GFXCLKFMIN: SMU_11_0_ODSETTING_ID = 1;
pub const SMU_11_0_ODSETTING_ID_SMU_11_0_ODSETTING_VDDGFXCURVEFREQ_P1: SMU_11_0_ODSETTING_ID = 2;
pub const SMU_11_0_ODSETTING_ID_SMU_11_0_ODSETTING_VDDGFXCURVEVOLTAGE_P1: SMU_11_0_ODSETTING_ID = 3;
pub const SMU_11_0_ODSETTING_ID_SMU_11_0_ODSETTING_VDDGFXCURVEFREQ_P2: SMU_11_0_ODSETTING_ID = 4;
pub const SMU_11_0_ODSETTING_ID_SMU_11_0_ODSETTING_VDDGFXCURVEVOLTAGE_P2: SMU_11_0_ODSETTING_ID = 5;
pub const SMU_11_0_ODSETTING_ID_SMU_11_0_ODSETTING_VDDGFXCURVEFREQ_P3: SMU_11_0_ODSETTING_ID = 6;
pub const SMU_11_0_ODSETTING_ID_SMU_11_0_ODSETTING_VDDGFXCURVEVOLTAGE_P3: SMU_11_0_ODSETTING_ID = 7;
pub const SMU_11_0_ODSETTING_ID_SMU_11_0_ODSETTING_UCLKFMAX: SMU_11_0_ODSETTING_ID = 8;
pub const SMU_11_0_ODSETTING_ID_SMU_11_0_ODSETTING_POWERPERCENTAGE: SMU_11_0_ODSETTING_ID = 9;
pub const SMU_11_0_ODSETTING_ID_SMU_11_0_ODSETTING_FANRPMMIN: SMU_11_0_ODSETTING_ID = 10;
pub const SMU_11_0_ODSETTING_ID_SMU_11_0_ODSETTING_FANRPMACOUSTICLIMIT: SMU_11_0_ODSETTING_ID = 11;
pub const SMU_11_0_ODSETTING_ID_SMU_11_0_ODSETTING_FANTARGETTEMPERATURE: SMU_11_0_ODSETTING_ID = 12;
pub const SMU_11_0_ODSETTING_ID_SMU_11_0_ODSETTING_OPERATINGTEMPMAX: SMU_11_0_ODSETTING_ID = 13;
pub const SMU_11_0_ODSETTING_ID_SMU_11_0_ODSETTING_ACTIMING: SMU_11_0_ODSETTING_ID = 14;
pub const SMU_11_0_ODSETTING_ID_SMU_11_0_ODSETTING_FAN_ZERO_RPM_CONTROL: SMU_11_0_ODSETTING_ID = 15;
pub const SMU_11_0_ODSETTING_ID_SMU_11_0_ODSETTING_AUTOUVENGINE: SMU_11_0_ODSETTING_ID = 16;
pub const SMU_11_0_ODSETTING_ID_SMU_11_0_ODSETTING_AUTOOCENGINE: SMU_11_0_ODSETTING_ID = 17;
pub const SMU_11_0_ODSETTING_ID_SMU_11_0_ODSETTING_AUTOOCMEMORY: SMU_11_0_ODSETTING_ID = 18;
pub const SMU_11_0_ODSETTING_ID_SMU_11_0_ODSETTING_COUNT: SMU_11_0_ODSETTING_ID = 19;
pub type SMU_11_0_ODSETTING_ID = ::core::ffi::c_uint;
#[repr(C, packed)]
#[derive(Debug, Copy, Clone)]
pub struct smu_11_0_overdrive_table {
    pub revision: u8,
    pub reserve: [u8; 3usize],
    pub feature_count: u32,
    pub setting_count: u32,
    pub cap: [u8; 32usize],
    pub max: [u32; 32usize],
    pub min: [u32; 32usize],
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of smu_11_0_overdrive_table"]
        [::core::mem::size_of::<smu_11_0_overdrive_table>() - 300usize];
    ["Alignment of smu_11_0_overdrive_table"]
        [::core::mem::align_of::<smu_11_0_overdrive_table>() - 1usize];
    ["Offset of field: smu_11_0_overdrive_table::revision"]
        [::core::mem::offset_of!(smu_11_0_overdrive_table, revision) - 0usize];
    ["Offset of field: smu_11_0_overdrive_table::reserve"]
        [::core::mem::offset_of!(smu_11_0_overdrive_table, reserve) - 1usize];
    ["Offset of field: smu_11_0_overdrive_table::feature_count"]
        [::core::mem::offset_of!(smu_11_0_overdrive_table, feature_count) - 4usize];
    ["Offset of field: smu_11_0_overdrive_table::setting_count"]
        [::core::mem::offset_of!(smu_11_0_overdrive_table, setting_count) - 8usize];
    ["Offset of field: smu_11_0_overdrive_table::cap"]
        [::core::mem::offset_of!(smu_11_0_overdrive_table, cap) - 12usize];
    ["Offset of field: smu_11_0_overdrive_table::max"]
        [::core::mem::offset_of!(smu_11_0_overdrive_table, max) - 44usize];
    ["Offset of field: smu_11_0_overdrive_table::min"]
        [::core::mem::offset_of!(smu_11_0_overdrive_table, min) - 172usize];
};
pub const SMU_11_0_PPCLOCK_ID_SMU_11_0_PPCLOCK_GFXCLK: SMU_11_0_PPCLOCK_ID = 0;
pub const SMU_11_0_PPCLOCK_ID_SMU_11_0_PPCLOCK_VCLK: SMU_11_0_PPCLOCK_ID = 1;
pub const SMU_11_0_PPCLOCK_ID_SMU_11_0_PPCLOCK_DCLK: SMU_11_0_PPCLOCK_ID = 2;
pub const SMU_11_0_PPCLOCK_ID_SMU_11_0_PPCLOCK_ECLK: SMU_11_0_PPCLOCK_ID = 3;
pub const SMU_11_0_PPCLOCK_ID_SMU_11_0_PPCLOCK_SOCCLK: SMU_11_0_PPCLOCK_ID = 4;
pub const SMU_11_0_PPCLOCK_ID_SMU_11_0_PPCLOCK_UCLK: SMU_11_0_PPCLOCK_ID = 5;
pub const SMU_11_0_PPCLOCK_ID_SMU_11_0_PPCLOCK_DCEFCLK: SMU_11_0_PPCLOCK_ID = 6;
pub const SMU_11_0_PPCLOCK_ID_SMU_11_0_PPCLOCK_DISPCLK: SMU_11_0_PPCLOCK_ID = 7;
pub const SMU_11_0_PPCLOCK_ID_SMU_11_0_PPCLOCK_PIXCLK: SMU_11_0_PPCLOCK_ID = 8;
pub const SMU_11_0_PPCLOCK_ID_SMU_11_0_PPCLOCK_PHYCLK: SMU_11_0_PPCLOCK_ID = 9;
pub const SMU_11_0_PPCLOCK_ID_SMU_11_0_PPCLOCK_COUNT: SMU_11_0_PPCLOCK_ID = 10;
pub type SMU_11_0_PPCLOCK_ID = ::core::ffi::c_uint;
#[repr(C, packed)]
#[derive(Debug, Copy, Clone)]
pub struct smu_11_0_power_saving_clock_table {
    pub revision: u8,
    pub reserve: [u8; 3usize],
    pub count: u32,
    pub max: [u32; 16usize],
    pub min: [u32; 16usize],
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of smu_11_0_power_saving_clock_table"]
        [::core::mem::size_of::<smu_11_0_power_saving_clock_table>() - 136usize];
    ["Alignment of smu_11_0_power_saving_clock_table"]
        [::core::mem::align_of::<smu_11_0_power_saving_clock_table>() - 1usize];
    ["Offset of field: smu_11_0_power_saving_clock_table::revision"]
        [::core::mem::offset_of!(smu_11_0_power_saving_clock_table, revision) - 0usize];
    ["Offset of field: smu_11_0_power_saving_clock_table::reserve"]
        [::core::mem::offset_of!(smu_11_0_power_saving_clock_table, reserve) - 1usize];
    ["Offset of field: smu_11_0_power_saving_clock_table::count"]
        [::core::mem::offset_of!(smu_11_0_power_saving_clock_table, count) - 4usize];
    ["Offset of field: smu_11_0_power_saving_clock_table::max"]
        [::core::mem::offset_of!(smu_11_0_power_saving_clock_table, max) - 8usize];
    ["Offset of field: smu_11_0_power_saving_clock_table::min"]
        [::core::mem::offset_of!(smu_11_0_power_saving_clock_table, min) - 72usize];
};
#[repr(C, packed)]
#[derive(Debug, Copy, Clone)]
pub struct smu_11_0_powerplay_table {
    pub header: atom_common_table_header,
    pub table_revision: u8,
    pub table_size: u16,
    pub golden_pp_id: u32,
    pub golden_revision: u32,
    pub format_id: u16,
    pub platform_caps: u32,
    pub thermal_controller_type: u8,
    pub small_power_limit1: u16,
    pub small_power_limit2: u16,
    pub boost_power_limit: u16,
    pub od_turbo_power_limit: u16,
    pub od_power_save_power_limit: u16,
    pub software_shutdown_temp: u16,
    pub reserve: [u16; 6usize],
    pub power_saving_clock: smu_11_0_power_saving_clock_table,
    pub overdrive_table: smu_11_0_overdrive_table,
    pub smc_pptable: PPTable_t,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of smu_11_0_powerplay_table"]
        [::core::mem::size_of::<smu_11_0_powerplay_table>() - 1674usize];
    ["Alignment of smu_11_0_powerplay_table"]
        [::core::mem::align_of::<smu_11_0_powerplay_table>() - 1usize];
    ["Offset of field: smu_11_0_powerplay_table::header"]
        [::core::mem::offset_of!(smu_11_0_powerplay_table, header) - 0usize];
    ["Offset of field: smu_11_0_powerplay_table::table_revision"]
        [::core::mem::offset_of!(smu_11_0_powerplay_table, table_revision) - 4usize];
    ["Offset of field: smu_11_0_powerplay_table::table_size"]
        [::core::mem::offset_of!(smu_11_0_powerplay_table, table_size) - 5usize];
    ["Offset of field: smu_11_0_powerplay_table::golden_pp_id"]
        [::core::mem::offset_of!(smu_11_0_powerplay_table, golden_pp_id) - 7usize];
    ["Offset of field: smu_11_0_powerplay_table::golden_revision"]
        [::core::mem::offset_of!(smu_11_0_powerplay_table, golden_revision) - 11usize];
    ["Offset of field: smu_11_0_powerplay_table::format_id"]
        [::core::mem::offset_of!(smu_11_0_powerplay_table, format_id) - 15usize];
    ["Offset of field: smu_11_0_powerplay_table::platform_caps"]
        [::core::mem::offset_of!(smu_11_0_powerplay_table, platform_caps) - 17usize];
    ["Offset of field: smu_11_0_powerplay_table::thermal_controller_type"]
        [::core::mem::offset_of!(smu_11_0_powerplay_table, thermal_controller_type) - 21usize];
    ["Offset of field: smu_11_0_powerplay_table::small_power_limit1"]
        [::core::mem::offset_of!(smu_11_0_powerplay_table, small_power_limit1) - 22usize];
    ["Offset of field: smu_11_0_powerplay_table::small_power_limit2"]
        [::core::mem::offset_of!(smu_11_0_powerplay_table, small_power_limit2) - 24usize];
    ["Offset of field: smu_11_0_powerplay_table::boost_power_limit"]
        [::core::mem::offset_of!(smu_11_0_powerplay_table, boost_power_limit) - 26usize];
    ["Offset of field: smu_11_0_powerplay_table::od_turbo_power_limit"]
        [::core::mem::offset_of!(smu_11_0_powerplay_table, od_turbo_power_limit) - 28usize];
    ["Offset of field: smu_11_0_powerplay_table::od_power_save_power_limit"]
        [::core::mem::offset_of!(smu_11_0_powerplay_table, od_power_save_power_limit) - 30usize];
    ["Offset of field: smu_11_0_powerplay_table::software_shutdown_temp"]
        [::core::mem::offset_of!(smu_11_0_powerplay_table, software_shutdown_temp) - 32usize];
    ["Offset of field: smu_11_0_powerplay_table::reserve"]
        [::core::mem::offset_of!(smu_11_0_powerplay_table, reserve) - 34usize];
    ["Offset of field: smu_11_0_powerplay_table::power_saving_clock"]
        [::core::mem::offset_of!(smu_11_0_powerplay_table, power_saving_clock) - 46usize];
    ["Offset of field: smu_11_0_powerplay_table::overdrive_table"]
        [::core::mem::offset_of!(smu_11_0_powerplay_table, overdrive_table) - 182usize];
    ["Offset of field: smu_11_0_powerplay_table::smc_pptable"]
        [::core::mem::offset_of!(smu_11_0_powerplay_table, smc_pptable) - 482usize];
};
