# Privacy

Transparency is at the heart of our sponsorware model, which includes our
funding goals, the features we're working towards, and, importantly, the
acknowledgment of our sponsors. As a sponsor, you can support our project
either [publicly] or [privately], according to your preference.

  [publicly]: #public-sponsors
  [privately]: #private-sponsors

## Public sponsors

By default, GitHub lists all sponsorships publicly. To sponsor privately, you
must explicitly select this option. When sponsoring publicly, your GitHub
account will be listed as part of [our sponsors], @squidfunk's [sponsoring page],
and within the "sponsoring" section of your GitHub account.

  [our sponsors]: our-sponsors.md
  [sponsoring page]: https://github.com/sponsors/squidfunk?metadata_origin=docs

## Private sponsors

For those preferring discretion, [setting your sponsorship to private] during
the sponsorship initiation process ensures your sponsorship remains unlisted,
keeping your affiliation with Material for MkDocs confidential.

This setting can be adjusted at any time through your GitHub account's
sponsorship settings.

For companies concerned about being visible as sponsors of any project due to
their privacy restrictions, creating a [bot account] on GitHub that is solely
used for sponsoring is advised. This account, set to sponsor privately, won't be
linked to any individual within your organization and provides an extra layer of anonymity.

  [setting your sponsorship to private]: https://docs.github.com/en/sponsors/sponsoring-open-source-contributors/managing-your-sponsorship#managing-the-privacy-setting-for-your-sponsorship
  [bot account]: access-management.md/#bot-account

## Administrative requests

To focus on the development of our projects, we aim to reduce administrative
tasks as much as possible for our small team, utilizing GitHub Sponsors for
efficient sponsor management.

### Vendor agreements

Since GitHub Sponsors facilitates our sponsor transactions, they act as your
vendor. For vendor agreements or related queries, especially for organizations
with GitHub enterprise accounts, reaching out to [GitHub Support] is recommended.

  [GitHub Support]: https://github.com/sponsors

### Non-disclosure agreements

Given our limited resources as a small team, we are unable to review and sign
NDAs. We advise those requiring such agreements to consult [our promise] for
reassurance. Additionally, please contact us if you have any questions at
sponsors@squidfunk.com

  [our promise]: #our-promise

## Our promise

We recognize the importance of privacy for our organizational sponsors,
especially in the absence of formal agreements like [NDAs]. "Our Promise" is our
assurance of commitment to your confidentiality and discretion.

- __Confidential sponsorship:__ Your choice between public or private
sponsorship is respected to the fullest. For private sponsors, we guarantee your
relation with us remains confidential at all times, ensuring no public disclosure
of your sponsorship.
- __Logo usage and brand representation:__ Logo display and any form of public
acknowledgment are completely under your control and will only proceed with your
explicit consent. This ensures your brand is represented on your terms.
- __Marketing and communication:__ We commit not to use the details of your
sponsorship for marketing or promotional purposes without your approval.
Your sponsorship details are guarded with the highest level of confidentiality,
with no unauthorized use or disclosure.

  [NDAs]: #non-disclosure-agreements
