/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diagram.state;

import com.intellij.diagram.DiagramBuilder;
import com.intellij.diagram.DiagramDataModel;
import com.intellij.diagram.DiagramNode;
import com.intellij.diagram.DiagramNoteNode;
import com.intellij.diagram.state.DiagramNodeIdentity;
import com.intellij.diagram.state.DiagramSnapshot;
import com.intellij.diagram.state.DiagramSnapshotFactory;
import com.intellij.openapi.util.Pair;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import net.jcip.annotations.Immutable;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

@Immutable
public final class DiagramNotesSnapshot
implements DiagramSnapshot {
    private final @NotNull Map<DiagramNodeIdentity<Object>, @Nls String> myNotesContents;

    private DiagramNotesSnapshot(@NotNull Map<DiagramNodeIdentity<Object>, @Nls String> notesContents) {
        if (notesContents == null) {
            DiagramNotesSnapshot.$$$reportNull$$$0(0);
        }
        this.myNotesContents = notesContents;
    }

    public boolean containsRecordFor(@NotNull DiagramNode<?> node) {
        if (node == null) {
            DiagramNotesSnapshot.$$$reportNull$$$0(1);
        }
        return this.myNotesContents.containsKey(DiagramNodeIdentity.of(node));
    }

    @NotNull
    public Set<DiagramNodeIdentity<Object>> getRecordedNoteElements() {
        Set<DiagramNodeIdentity<Object>> set = this.myNotesContents.keySet();
        if (set == null) {
            DiagramNotesSnapshot.$$$reportNull$$$0(2);
        }
        return set;
    }

    @Override
    @NotNull
    public CompletableFuture<Void> restoreAsync(@NotNull DiagramBuilder builder) {
        if (builder == null) {
            DiagramNotesSnapshot.$$$reportNull$$$0(3);
        }
        CompletableFuture completableFuture = builder.getGraphBuilder().getActionExecutor().runGraphActionAsync(() -> {
            DiagramDataModel<?> model = builder.getDataModel();
            for (DiagramNoteNode diagramNoteNode : new ArrayList<DiagramNoteNode>(model.getNotes().values())) {
                model.removeNote(diagramNoteNode);
            }
            for (DiagramNode<DiagramNode<?>> diagramNode : new ArrayList(model.getNodes())) {
                String noteText = this.myNotesContents.get(DiagramNodeIdentity.of(diagramNode));
                if (noteText == null) continue;
                model.addNote(diagramNode, noteText);
            }
        });
        if (completableFuture == null) {
            DiagramNotesSnapshot.$$$reportNull$$$0(4);
        }
        return completableFuture;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 4 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "notesContents";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/diagram/state/DiagramNotesSnapshot";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/diagram/state/DiagramNotesSnapshot";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getRecordedNoteElements";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "restoreAsync";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "containsRecordFor";
                break;
            }
            case 2: 
            case 4: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "restoreAsync";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 4 -> new IllegalStateException(string);
        };
    }

    public static final class Factory
    implements DiagramSnapshotFactory<DiagramNotesSnapshot> {
        @NotNull
        private static final Factory INSTANCE = new Factory();

        @NotNull
        public static Factory getInstance() {
            Factory factory = INSTANCE;
            if (factory == null) {
                Factory.$$$reportNull$$$0(0);
            }
            return factory;
        }

        @Override
        @NotNull
        public DiagramNotesSnapshot makeSnapshot(@NotNull DiagramBuilder builder) {
            if (builder == null) {
                Factory.$$$reportNull$$$0(1);
            }
            DiagramNotesSnapshot diagramNotesSnapshot = (DiagramNotesSnapshot)builder.getActionExecutor().suppressComputableReadLockAssertion(() -> new DiagramNotesSnapshot(ContainerUtil.map2MapNotNull(builder.getNodeObjects(), node -> node instanceof DiagramNoteNode ? Pair.create(DiagramNodeIdentity.of(node), (Object)node.getTooltip()) : null)));
            if (diagramNotesSnapshot == null) {
                Factory.$$$reportNull$$$0(2);
            }
            return diagramNotesSnapshot;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 1 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/diagram/state/DiagramNotesSnapshot$Factory";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "builder";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getInstance";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/diagram/state/DiagramNotesSnapshot$Factory";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "makeSnapshot";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "makeSnapshot";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 1 -> new IllegalArgumentException(string);
            };
        }
    }
}

