/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diagram.v2.painting;

import com.intellij.diagram.v2.handles.GraphChartHandle;
import com.intellij.openapi.editor.colors.ColorKey;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface GraphChartEdgePainter<N, E> {
    @NotNull
    public EdgeStyle getEdgeStyle(@NotNull GraphChartHandle<N, E> var1, @NotNull E var2);

    public static interface EdgeStyle {
        @Nullable
        public ColorKey getLineColorKey();

        @NotNull
        public EdgeLineType getLineType();

        public int getLineWidth();

        @Nullable
        public EdgeArrow getSourceArrow();

        @Nullable
        public EdgeArrow getTargetArrow();

        @Nullable
        public EdgeLabel getUpperCenterLabel();

        @Nullable
        public EdgeLabel getBottomCenterLabel();

        @Nullable
        public EdgeLabel getUpperSourceLabel();

        @Nullable
        public EdgeLabel getBottomSourceLabel();

        @Nullable
        public EdgeLabel getUpperTargetLabel();

        @Nullable
        public EdgeLabel getBottomTargetLabel();

        public static interface Builder {
            @NotNull
            public Builder setLineColorKey(@Nullable ColorKey var1);

            @NotNull
            public Builder setLineType(@NotNull EdgeLineType var1);

            @NotNull
            public Builder setLineWidth(int var1);

            @NotNull
            public Builder setSourceArrow(@Nullable EdgeArrow var1);

            @NotNull
            public Builder setSourceArrow(@NotNull EdgeArrowType var1, int var2);

            @NotNull
            public Builder setTargetArrow(@Nullable EdgeArrow var1);

            @NotNull
            public Builder setTargetArrow(@NotNull EdgeArrowType var1, int var2);

            @NotNull
            public Builder setUpperCenterLabel(@Nullable EdgeLabel var1);

            @NotNull
            public Builder setUpperCenterLabel(@Nullable @Nls String var1);

            @NotNull
            public Builder setBottomCenterLabel(@Nullable EdgeLabel var1);

            @NotNull
            public Builder setBottomCenterLabel(@Nullable @Nls String var1);

            @NotNull
            public Builder setUpperSourceLabel(@Nullable EdgeLabel var1);

            @NotNull
            public Builder setUpperSourceLabel(@Nullable @Nls String var1);

            @NotNull
            public Builder setBottomSourceLabel(@Nullable EdgeLabel var1);

            @NotNull
            public Builder setBottomSourceLabel(@Nullable @Nls String var1);

            @NotNull
            public Builder setUpperTargetLabel(@Nullable EdgeLabel var1);

            @NotNull
            public Builder setUpperTargetLabel(@Nullable @Nls String var1);

            @NotNull
            public Builder setBottomTargetLabel(@Nullable EdgeLabel var1);

            @NotNull
            public Builder setBottomTargetLabel(@Nullable @Nls String var1);

            @NotNull
            public EdgeStyle create();
        }
    }

    public static interface EdgeLabel {
        @NotNull
        @Nls
        public String getText();

        @Nullable
        public ColorKey getColorKey();
    }

    public static enum EdgeArrowType {
        NONE,
        STANDARD,
        DELTA,
        DELTA_SMALL,
        WHITE_DELTA,
        DIAMOND,
        SHORT,
        WHITE_DIAMOND,
        PLAIN,
        CONCAVE,
        CONVEX,
        CIRCLE,
        TRANSPARENT_CIRCLE,
        DASH,
        SKEWED_DASH,
        T_SHAPE,
        CROWS_FOOT_ONE_MANDATORY,
        CROWS_FOOT_MANY_MANDATORY,
        CROWS_FOOT_ONE_OPTIONAL,
        CROWS_FOOT_MANY_OPTIONAL,
        CROWS_FOOT_ONE,
        CROWS_FOOT_MANY,
        CROWS_FOOT_OPTIONAL;

    }

    public static interface EdgeArrow {
        @NotNull
        public EdgeArrowType getArrowType();

        public int getArrowSize();
    }

    public static enum EdgeLineType {
        SOLID,
        DASHED,
        DOTTED,
        DASHED_DOTTED;

    }
}

