/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.uml;

import com.intellij.concurrency.ThreadContext;
import com.intellij.diagnostic.Checks;
import com.intellij.diagram.DiagramBuilder;
import com.intellij.diagram.DiagramColorManager;
import com.intellij.diagram.DiagramDataKeys;
import com.intellij.diagram.DiagramDataModel;
import com.intellij.diagram.DiagramDataModelWrapper;
import com.intellij.diagram.DiagramEdge;
import com.intellij.diagram.DiagramFileEditor;
import com.intellij.diagram.DiagramNode;
import com.intellij.diagram.DiagramPresentationModel;
import com.intellij.diagram.DiagramProvider;
import com.intellij.diagram.presentation.DiagramState;
import com.intellij.diagram.state.DiagramEdgeIdentity;
import com.intellij.diagram.state.DiagramFullSnapshot;
import com.intellij.diagram.state.DiagramLayoutSnapshot;
import com.intellij.diagram.state.DiagramNodeIdentity;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.command.impl.UndoManagerImpl;
import com.intellij.openapi.command.undo.DocumentReference;
import com.intellij.openapi.command.undo.DocumentReferenceManager;
import com.intellij.openapi.command.undo.UndoManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.graph.GraphDataKeys;
import com.intellij.openapi.graph.base.Edge;
import com.intellij.openapi.graph.base.Node;
import com.intellij.openapi.graph.builder.GraphBuilder;
import com.intellij.openapi.graph.builder.GraphDataModel;
import com.intellij.openapi.graph.builder.GraphIdentifiable;
import com.intellij.openapi.graph.builder.GraphPresentationModel;
import com.intellij.openapi.graph.builder.event.GraphBuilderEvent;
import com.intellij.openapi.graph.builder.event.GraphBuilderListener;
import com.intellij.openapi.graph.builder.util.NodeFactory;
import com.intellij.openapi.graph.impl.builder.GraphBuilderImpl;
import com.intellij.openapi.graph.layout.Layouter;
import com.intellij.openapi.graph.layout.NodeLayout;
import com.intellij.openapi.graph.services.GraphCanvasLocationService;
import com.intellij.openapi.graph.services.GraphExportService;
import com.intellij.openapi.graph.services.GraphLayoutService;
import com.intellij.openapi.graph.threading.GraphThreadingType;
import com.intellij.openapi.graph.util.Futures;
import com.intellij.openapi.graph.view.EdgeRealizer;
import com.intellij.openapi.graph.view.Graph2D;
import com.intellij.openapi.graph.view.Graph2DView;
import com.intellij.openapi.graph.view.NodeRealizer;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectUtil;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.uml.UmlFileEditorImpl;
import com.intellij.uml.undo.UmlRefactoringElementListenerProvider;
import com.intellij.util.ArrayUtil;
import com.intellij.util.concurrency.ThreadingAssertions;
import com.intellij.util.concurrency.annotations.RequiresEdt;
import com.intellij.util.containers.ContainerUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Point;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.function.Supplier;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class UmlGraphBuilder
extends GraphBuilderImpl<DiagramNode<?>, DiagramEdge<?>>
implements GraphBuilderListener,
DiagramBuilder,
DocumentListener {
    @Deprecated(forRemoval=true)
    @NotNull
    public static final Key<VirtualFile> EDITOR_FILE = Key.create((String)"diagram.editor.file");
    private volatile boolean myPopupMode;

    protected UmlGraphBuilder(@NotNull Project project, @NotNull Graph2D graph, @NotNull Graph2DView view, @NotNull DiagramDataModel<?> dataModel, @NotNull GraphThreadingType threadingType, @NotNull DiagramPresentationModel presentationModel) {
        if (project == null) {
            UmlGraphBuilder.$$$reportNull$$$0(0);
        }
        if (graph == null) {
            UmlGraphBuilder.$$$reportNull$$$0(1);
        }
        if (view == null) {
            UmlGraphBuilder.$$$reportNull$$$0(2);
        }
        if (dataModel == null) {
            UmlGraphBuilder.$$$reportNull$$$0(3);
        }
        if (threadingType == null) {
            UmlGraphBuilder.$$$reportNull$$$0(4);
        }
        if (presentationModel == null) {
            UmlGraphBuilder.$$$reportNull$$$0(5);
        }
        super(project, graph, view, (GraphDataModel)new DiagramDataModelWrapper(dataModel), (GraphPresentationModel)presentationModel, threadingType, null);
        presentationModel.setGraphBuilder((GraphBuilder)this);
        this.addGraphBuilderListener(this, this);
        if (dataModel.isPsiListener()) {
            UmlRefactoringElementListenerProvider.getInstance(project).addBuilder(this);
            DocumentListener documentListener = new DocumentListener(){

                public void documentChanged(@NotNull DocumentEvent e) {
                    VirtualFile editorFile;
                    if (e == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    if ((editorFile = UmlGraphBuilder.this.getEditorFile()) != null) {
                        Document document = e.getDocument();
                        VirtualFile virtualFile = FileDocumentManager.getInstance().getFile(document);
                        Project documentProject = virtualFile == null ? null : ProjectUtil.guessProjectForFile((VirtualFile)virtualFile);
                        Project myProject = UmlGraphBuilder.this.getProject();
                        if (myProject.equals(documentProject)) {
                            PsiFile psiFile = PsiDocumentManager.getInstance((Project)myProject).getPsiFile(document);
                            if (!CommandProcessor.getInstance().isUndoTransparentActionInProgress() && CommandProcessor.getInstance().getCurrentCommand() != null && psiFile != null && psiFile.isValid() && UmlGraphBuilder.this.getDataModel().hasFile(psiFile) && UmlGraphBuilder.this.isDiagramEditorActive()) {
                                CommandProcessor.getInstance().addAffectedFiles(myProject, new VirtualFile[]{editorFile});
                            }
                        }
                    }
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/uml/UmlGraphBuilder$1", "documentChanged"));
                }
            };
            EditorFactory.getInstance().getEventMulticaster().addDocumentListener(documentListener, (Disposable)this);
        }
    }

    private boolean isDiagramEditorActive() {
        return ArrayUtil.contains((Object)this.getEditor(), (Object[])FileEditorManager.getInstance((Project)this.getProject()).getSelectedEditors());
    }

    @NotNull
    public DiagramPresentationModel getGraphPresentationModel() {
        DiagramPresentationModel diagramPresentationModel = (DiagramPresentationModel)super.getGraphPresentationModel();
        if (diagramPresentationModel == null) {
            UmlGraphBuilder.$$$reportNull$$$0(6);
        }
        return diagramPresentationModel;
    }

    @Override
    @NotNull
    public DiagramPresentationModel getPresentationModel() {
        DiagramPresentationModel diagramPresentationModel = this.getGraphPresentationModel();
        if (diagramPresentationModel == null) {
            UmlGraphBuilder.$$$reportNull$$$0(7);
        }
        return diagramPresentationModel;
    }

    @Override
    @NotNull
    public GraphBuilder<DiagramNode<?>, DiagramEdge<?>> getGraphBuilder() {
        UmlGraphBuilder umlGraphBuilder = this;
        if (umlGraphBuilder == null) {
            UmlGraphBuilder.$$$reportNull$$$0(8);
        }
        return umlGraphBuilder;
    }

    @Override
    @NotNull
    public EditorColorsScheme getColorScheme() {
        if (GraphExportService.getInstance().isPrintMode()) {
            EditorColorsScheme editorColorsScheme = EditorColorsManager.getInstance().getScheme(EditorColorsScheme.getDefaultSchemeName());
            if (editorColorsScheme == null) {
                UmlGraphBuilder.$$$reportNull$$$0(9);
            }
            return editorColorsScheme;
        }
        EditorColorsScheme editorColorsScheme = EditorColorsManager.getInstance().getGlobalScheme();
        if (editorColorsScheme == null) {
            UmlGraphBuilder.$$$reportNull$$$0(10);
        }
        return editorColorsScheme;
    }

    @Override
    public boolean doAllowEdgeCreation() {
        return this.getEditMode().doAllowEdgeCreation();
    }

    @Override
    public void setAllowEdgeCreation(boolean allow) {
        this.getEditMode().allowEdgeCreation(allow);
    }

    @Override
    @NotNull
    public DiagramDataModel<?> getDataModel() {
        DiagramDataModel diagramDataModel = ((DiagramDataModelWrapper)this.getGraphDataModel()).getModel();
        if (diagramDataModel == null) {
            UmlGraphBuilder.$$$reportNull$$$0(11);
        }
        return diagramDataModel;
    }

    @Override
    @NotNull
    public DiagramProvider<?> getProvider() {
        DiagramProvider provider = (DiagramProvider)this.getUserData(DiagramDataKeys.UML_PROVIDER);
        assert (provider != null) : "Forget to add uml provider to the user data";
        DiagramProvider diagramProvider = provider;
        if (diagramProvider == null) {
            UmlGraphBuilder.$$$reportNull$$$0(12);
        }
        return diagramProvider;
    }

    @Override
    @Nullable
    public DiagramFileEditor getEditor() {
        return (DiagramFileEditor)this.getUserData(DiagramDataKeys.UML_FILE_EDITOR);
    }

    @Override
    public void setEditor(@NotNull DiagramFileEditor editor) {
        if (editor == null) {
            UmlGraphBuilder.$$$reportNull$$$0(13);
        }
        this.putUserData(GraphDataKeys.GRAPH_FILE_EDITOR, editor);
        this.putUserData(DiagramDataKeys.UML_FILE_EDITOR, editor);
        editor.putUserData(DiagramDataKeys.GRAPH_BUILDER, this);
    }

    @Override
    @Nullable
    public DocumentReference getDocumentReference() {
        VirtualFile file;
        DiagramFileEditor editor = this.getEditor();
        if (editor != null && (file = editor.getOriginalVirtualFile()).isValid()) {
            return DocumentReferenceManager.getInstance().create(file);
        }
        return null;
    }

    public void beforeActionPerformed(@NotNull GraphBuilder builder, @NotNull GraphBuilderEvent event) {
        if (builder == null) {
            UmlGraphBuilder.$$$reportNull$$$0(14);
        }
        if (event == null) {
            UmlGraphBuilder.$$$reportNull$$$0(15);
        }
    }

    public void actionPerformed(@NotNull GraphBuilder builder, @NotNull GraphBuilderEvent event) {
        if (builder == null) {
            UmlGraphBuilder.$$$reportNull$$$0(16);
        }
        if (event == null) {
            UmlGraphBuilder.$$$reportNull$$$0(17);
        }
        if (event != GraphBuilderEvent.ZOOM_CHANGED && this == builder) {
            this.notifyOtherBuilders();
        }
    }

    @Override
    public void notifyOtherBuilders() {
        VirtualFile file = this.getEditorFile();
        if (file == null) {
            return;
        }
        FileEditor[] editors2 = FileEditorManager.getInstance((Project)this.getProject()).getAllEditors(file);
        if (editors2.length < 2) {
            return;
        }
        DiagramFullSnapshot snapshot = DiagramFullSnapshot.Factory.getInstance().makeSnapshot(this);
        ApplicationManager.getApplication().invokeLater(() -> {
            for (FileEditor editor : editors2) {
                DiagramBuilder anotherBuilder;
                if (!(editor instanceof UmlFileEditorImpl) || (anotherBuilder = ((UmlFileEditorImpl)editor).getModelBuilder()) == this) continue;
                snapshot.restoreAsync(anotherBuilder).thenRunAsync(ThreadContext.captureThreadContext(() -> anotherBuilder.queryUpdate().withPresentationUpdate().run()));
            }
        });
    }

    @Override
    @NotNull
    public DiagramBuilder.DiagramUpdateQueryParams queryUpdate() {
        return new DiagramUpdateQueryParamsImpl();
    }

    protected void runUpdate(@NotNull DiagramUpdateQueryParamsImpl params) {
        if (params == null) {
            UmlGraphBuilder.$$$reportNull$$$0(18);
        }
        if (params.doReloadData()) {
            this.update(params.doPresentationUpdate(), params.getLayouter(), params.getNodesForSizeUpdate());
        } else {
            if (params.doPresentationUpdate()) {
                this.getGraphPresentationModel().update();
            }
            this.updateView(params.getLayouter(), params.getNodesForSizeUpdate());
        }
    }

    @NotNull
    protected CompletableFuture<Void> runUpdateAsync(@NotNull DiagramUpdateQueryParamsImpl params) {
        if (params == null) {
            UmlGraphBuilder.$$$reportNull$$$0(19);
        }
        if (params.doReloadData()) {
            CompletableFuture<Void> completableFuture = this.updateAsync(params.doPresentationUpdate(), params.getLayouter(), params.getNodesForSizeUpdate());
            if (completableFuture == null) {
                UmlGraphBuilder.$$$reportNull$$$0(20);
            }
            return completableFuture;
        }
        CompletionStage completionStage = this.getGraphBuilder().getActionExecutor().runGraphActionAsync(() -> {
            if (params.doPresentationUpdate()) {
                this.getGraphPresentationModel().update();
            }
        }).thenComposeAsync(ThreadContext.captureThreadContext(__ -> this.updateViewAsync(params.getLayouter(), params.getNodesForSizeUpdate())));
        if (completionStage == null) {
            UmlGraphBuilder.$$$reportNull$$$0(21);
        }
        return completionStage;
    }

    public void updateRealizers(boolean updateAllNodes) {
        super.updateRealizers(updateAllNodes);
        DiagramColorManager colorManager = this.getProvider().getColorManager();
        NodeRealizer.Statics.setHotSpotColor((Color)colorManager.getHotSpotColor(this));
        EdgeRealizer.Statics.setSelectionColor((Color)colorManager.getEdgeSelectionColor(this));
        EdgeRealizer.Statics.setHighlightedBendColor((Color)colorManager.getBendSelectionColor(this));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @RequiresEdt
    public void update(boolean bl, boolean bl2) {
        void updateLayout;
        void increaseModTrackerCounter;
        ThreadingAssertions.assertEventDispatchThread();
        this.update((boolean)increaseModTrackerCounter, updateLayout != false ? this.getPresentationModel().getSettings().getCurrentLayouter() : null, Collections.emptyList());
    }

    protected void update(boolean increaseModTrackerCounter, @Nullable Layouter layouter, @NotNull Collection<DiagramNode<?>> nodesForSizeUpdate) {
        if (nodesForSizeUpdate == null) {
            UmlGraphBuilder.$$$reportNull$$$0(22);
        }
        this.getGraphBuilder().getActionExecutor().assertGraphThread();
        if (increaseModTrackerCounter) {
            this.getGraphPresentationModel().update();
        }
        DiagramLayoutSnapshot currentLayout = DiagramLayoutSnapshot.Factory.getInstance().makeSnapshot(this);
        this.updateGraph(false, nodesForSizeUpdate);
        currentLayout.restore(this);
        if (layouter != null) {
            JBPopup popup;
            this.relayout(layouter);
            if (this.isPopupMode() && (popup = (JBPopup)this.getUserData(DiagramDataKeys.UML_POPUP)) != null && !popup.isDisposed()) {
                GraphCanvasLocationService.getInstance().setBestPopupSizeForGraph(popup, (GraphBuilder)this);
            }
            this.getGraph().updateViews();
        }
    }

    @NotNull
    protected CompletableFuture<Void> updateAsync(final boolean increaseModTrackerCounter, @Nullable Layouter layouter, @NotNull Collection<DiagramNode<?>> nodesForSizeUpdate) {
        if (nodesForSizeUpdate == null) {
            UmlGraphBuilder.$$$reportNull$$$0(23);
        }
        CompletionStage completionStage = ((CompletableFuture)CompletableFuture.supplyAsync(ThreadContext.captureThreadContext((Supplier)new Supplier<DiagramLayoutSnapshot>(){

            @Override
            public DiagramLayoutSnapshot get() {
                if (increaseModTrackerCounter) {
                    UmlGraphBuilder.this.getGraphPresentationModel().update();
                }
                return DiagramLayoutSnapshot.Factory.getInstance().makeSnapshot(UmlGraphBuilder.this);
            }
        })).thenComposeAsync(ThreadContext.captureThreadContext(currentLayout -> this.updateGraphAsync(layouter, nodesForSizeUpdate)))).thenRunAsync(ThreadContext.captureThreadContext(() -> {
            JBPopup popup;
            if (this.isPopupMode() && (popup = (JBPopup)this.getUserData(DiagramDataKeys.UML_POPUP)) != null && !popup.isDisposed()) {
                GraphCanvasLocationService.getInstance().setBestPopupSizeForGraph(popup, (GraphBuilder)this);
            }
            this.getGraph().updateViews();
        }));
        if (completionStage == null) {
            UmlGraphBuilder.$$$reportNull$$$0(24);
        }
        return completionStage;
    }

    @Override
    public boolean isPopupMode() {
        return this.myPopupMode;
    }

    @Override
    @Nullable
    public JBPopup getPopup() {
        return (JBPopup)this.getUserData(DiagramDataKeys.UML_POPUP);
    }

    @Override
    public void setPopup(@NotNull JBPopup popup) {
        if (popup == null) {
            UmlGraphBuilder.$$$reportNull$$$0(25);
        }
        this.putUserData(DiagramDataKeys.UML_POPUP, popup);
        this.setPopupMode(true);
    }

    public void setPopupMode(boolean popupMode) {
        this.myPopupMode = popupMode;
    }

    @Override
    @RequiresEdt
    public void relayout() {
        ThreadingAssertions.assertEventDispatchThread();
        GraphLayoutService.getInstance().queryLayout((GraphBuilder)this).run();
    }

    protected void relayout(@NotNull Layouter layouter) {
        if (layouter == null) {
            UmlGraphBuilder.$$$reportNull$$$0(26);
        }
        GraphLayoutService.getInstance().queryLayout((GraphBuilder)this).withLayouter(layouter).run();
    }

    @NotNull
    protected CompletableFuture<Void> relayoutAsync(@NotNull Layouter layouter) {
        if (layouter == null) {
            UmlGraphBuilder.$$$reportNull$$$0(27);
        }
        CompletableFuture completableFuture = GraphLayoutService.getInstance().queryLayout((GraphBuilder)this).withLayouter(layouter).runAsync();
        if (completableFuture == null) {
            UmlGraphBuilder.$$$reportNull$$$0(28);
        }
        return completableFuture;
    }

    public void createDraggedNode(@NotNull DiagramNode node, @Nullable String nodeName, @NotNull Point point) {
        NodeLayout nodeLayout;
        if (node == null) {
            UmlGraphBuilder.$$$reportNull$$$0(29);
        }
        if (point == null) {
            UmlGraphBuilder.$$$reportNull$$$0(30);
        }
        this.getActionExecutor().assertGraphThread();
        Node nodeObj = (Node)this.getActionExecutor().computeWriteAction(() -> NodeFactory.getInstance().createDraggedNode((GraphBuilder)this, (Object)node, node.getTooltip(), point));
        this.getDataModel().refreshDataModel();
        if (nodeObj != null && (nodeLayout = this.getGraph().getNodeLayout((Object)nodeObj)) != null) {
            nodeLayout.setLocation((double)point.x, (double)point.y);
        }
    }

    @Nullable
    public VirtualFile getEditorFile() {
        return (VirtualFile)this.getUserData(DiagramDataKeys.EDITOR_FILE);
    }

    public void dispose() {
        DocumentReference ref = this.getDocumentReference();
        if (ref != null) {
            ((UndoManagerImpl)UndoManager.getInstance((Project)this.getProject())).invalidateActionsFor(ref);
        }
        DiagramState.invalidateSnapshotsFor(this);
        super.dispose();
    }

    @Override
    public void requestFocus() {
        IdeFocusManager.getInstance((Project)this.getProject()).requestFocus((Component)this.getView().getCanvasComponent(), true);
    }

    @NotNull
    public GraphIdentifiable.Node.Identity getNodeIdentity(@NotNull Node node) {
        DiagramNode modelNode;
        if (node == null) {
            UmlGraphBuilder.$$$reportNull$$$0(31);
        }
        return (modelNode = (DiagramNode)this.getNodeObject(node)) != null ? DiagramNodeIdentity.of(modelNode) : new GraphIdentifiable.Node.OfGraphNode(node);
    }

    @NotNull
    public GraphIdentifiable.Edge.Identity getEdgeIdentity(@NotNull Edge edge) {
        DiagramEdge modelEdge;
        if (edge == null) {
            UmlGraphBuilder.$$$reportNull$$$0(32);
        }
        return (modelEdge = (DiagramEdge)this.getEdgeObject(edge)) != null ? DiagramEdgeIdentity.of(modelEdge) : new GraphIdentifiable.Edge.OfGraphEdge(edge);
    }

    public String toString() {
        return "UmlGraphBuilder@" + this.hashCode();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 6, 7, 8, 9, 10, 11, 12, 20, 21, 24, 28 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "graph";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "view";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataModel";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "threadingType";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "presentationModel";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 20: 
            case 21: 
            case 24: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/uml/UmlGraphBuilder";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 14: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
            case 15: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
            case 18: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "params";
                break;
            }
            case 22: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nodesForSizeUpdate";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "popup";
                break;
            }
            case 26: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "layouter";
                break;
            }
            case 29: 
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "point";
                break;
            }
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "edge";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/uml/UmlGraphBuilder";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getGraphPresentationModel";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getPresentationModel";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getGraphBuilder";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getColorScheme";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getDataModel";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getProvider";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "runUpdateAsync";
                break;
            }
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "updateAsync";
                break;
            }
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "relayoutAsync";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 20: 
            case 21: 
            case 24: 
            case 28: {
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "setEditor";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "beforeActionPerformed";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "actionPerformed";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "runUpdate";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "runUpdateAsync";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "updateAsync";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "setPopup";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "relayout";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "relayoutAsync";
                break;
            }
            case 29: 
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "createDraggedNode";
                break;
            }
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "getNodeIdentity";
                break;
            }
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "getEdgeIdentity";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 6, 7, 8, 9, 10, 11, 12, 20, 21, 24, 28 -> new IllegalStateException(string);
        };
    }

    private class DiagramUpdateQueryParamsImpl
    implements DiagramBuilder.DiagramUpdateQueryParams {
        private boolean myDoReloadData;
        private boolean myDoPresentationUpdate;
        private boolean myDoNodePresentationsUpdate;
        @Nullable
        private Layouter myLayouter;
        @NotNull
        private final List<DiagramNode<?>> myNodesForSizeUpdate = new ArrayList();
        private boolean mySealed;

        private DiagramUpdateQueryParamsImpl() {
        }

        @Override
        @NotNull
        public DiagramUpdateQueryParamsImpl withDataReload() {
            Checks.check((!this.mySealed ? 1 : 0) != 0);
            this.myDoReloadData = true;
            DiagramUpdateQueryParamsImpl diagramUpdateQueryParamsImpl = this;
            if (diagramUpdateQueryParamsImpl == null) {
                DiagramUpdateQueryParamsImpl.$$$reportNull$$$0(0);
            }
            return diagramUpdateQueryParamsImpl;
        }

        @Override
        @NotNull
        public DiagramUpdateQueryParamsImpl withRelayout() {
            Checks.check((!this.mySealed ? 1 : 0) != 0);
            this.myLayouter = UmlGraphBuilder.this.getGraphPresentationModel().getSettings().getCurrentLayouter();
            DiagramUpdateQueryParamsImpl diagramUpdateQueryParamsImpl = this;
            if (diagramUpdateQueryParamsImpl == null) {
                DiagramUpdateQueryParamsImpl.$$$reportNull$$$0(1);
            }
            return diagramUpdateQueryParamsImpl;
        }

        @Override
        @NotNull
        public DiagramUpdateQueryParamsImpl withRelayout(@NotNull Layouter layouter) {
            if (layouter == null) {
                DiagramUpdateQueryParamsImpl.$$$reportNull$$$0(2);
            }
            Checks.check((!this.mySealed ? 1 : 0) != 0);
            this.myLayouter = layouter;
            DiagramUpdateQueryParamsImpl diagramUpdateQueryParamsImpl = this;
            if (diagramUpdateQueryParamsImpl == null) {
                DiagramUpdateQueryParamsImpl.$$$reportNull$$$0(3);
            }
            return diagramUpdateQueryParamsImpl;
        }

        @Override
        @NotNull
        public DiagramUpdateQueryParamsImpl withPresentationUpdate() {
            Checks.check((!this.mySealed ? 1 : 0) != 0);
            this.myDoPresentationUpdate = true;
            DiagramUpdateQueryParamsImpl diagramUpdateQueryParamsImpl = this;
            if (diagramUpdateQueryParamsImpl == null) {
                DiagramUpdateQueryParamsImpl.$$$reportNull$$$0(4);
            }
            return diagramUpdateQueryParamsImpl;
        }

        @Override
        @NotNull
        public DiagramBuilder.DiagramUpdateQueryParams withNodePresentationsUpdate(boolean updateNodePresentations) {
            Checks.check((!this.mySealed ? 1 : 0) != 0);
            this.myDoNodePresentationsUpdate = true;
            DiagramUpdateQueryParamsImpl diagramUpdateQueryParamsImpl = this;
            if (diagramUpdateQueryParamsImpl == null) {
                DiagramUpdateQueryParamsImpl.$$$reportNull$$$0(5);
            }
            return diagramUpdateQueryParamsImpl;
        }

        @Override
        @NotNull
        public DiagramUpdateQueryParamsImpl withAllNodeSizeUpdate() {
            Checks.check((!this.mySealed ? 1 : 0) != 0);
            ContainerUtil.addAll(this.myNodesForSizeUpdate, (Iterable)((Iterable)ReadAction.compute(() -> UmlGraphBuilder.this.getNodeObjects())));
            DiagramUpdateQueryParamsImpl diagramUpdateQueryParamsImpl = this;
            if (diagramUpdateQueryParamsImpl == null) {
                DiagramUpdateQueryParamsImpl.$$$reportNull$$$0(6);
            }
            return diagramUpdateQueryParamsImpl;
        }

        @Override
        @NotNull
        public DiagramBuilder.DiagramUpdateQueryParams withNodeSizeUpdate(DiagramNode<?> ... nodesForSizeUpdate) {
            if (nodesForSizeUpdate == null) {
                DiagramUpdateQueryParamsImpl.$$$reportNull$$$0(7);
            }
            Checks.check((!this.mySealed ? 1 : 0) != 0);
            ContainerUtil.addAll(this.myNodesForSizeUpdate, (Object[])nodesForSizeUpdate);
            DiagramUpdateQueryParamsImpl diagramUpdateQueryParamsImpl = this;
            if (diagramUpdateQueryParamsImpl == null) {
                DiagramUpdateQueryParamsImpl.$$$reportNull$$$0(8);
            }
            return diagramUpdateQueryParamsImpl;
        }

        @Override
        public boolean doReloadData() {
            return this.myDoReloadData;
        }

        @Override
        public boolean doPresentationUpdate() {
            return this.myDoPresentationUpdate;
        }

        @Override
        public boolean doUpdateNodePresentations() {
            return this.myDoNodePresentationsUpdate;
        }

        @NotNull
        public List<DiagramNode<?>> getNodesForSizeUpdate() {
            List<DiagramNode<?>> list = this.myNodesForSizeUpdate;
            if (list == null) {
                DiagramUpdateQueryParamsImpl.$$$reportNull$$$0(9);
            }
            return list;
        }

        @Override
        @Nullable
        public Layouter getLayouter() {
            return this.myLayouter;
        }

        @Override
        public void run() {
            this.endQuery();
            UmlGraphBuilder.this.runUpdate(this);
        }

        @Override
        @NotNull
        public CompletableFuture<Void> runAsync() {
            this.endQuery();
            CompletionStage completionStage = UmlGraphBuilder.this.runUpdateAsync(this).whenComplete(Futures.logIfFailed(UmlGraphBuilder.class));
            if (completionStage == null) {
                DiagramUpdateQueryParamsImpl.$$$reportNull$$$0(10);
            }
            return completionStage;
        }

        @Override
        @NotNull
        public DiagramBuilder.DiagramUpdateQueryParams endQuery() {
            this.mySealed = true;
            DiagramUpdateQueryParamsImpl diagramUpdateQueryParamsImpl = this;
            if (diagramUpdateQueryParamsImpl == null) {
                DiagramUpdateQueryParamsImpl.$$$reportNull$$$0(11);
            }
            return diagramUpdateQueryParamsImpl;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 2, 7 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/uml/UmlGraphBuilder$DiagramUpdateQueryParamsImpl";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "layouter";
                    break;
                }
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "nodesForSizeUpdate";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "withDataReload";
                    break;
                }
                case 1: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "withRelayout";
                    break;
                }
                case 2: 
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/uml/UmlGraphBuilder$DiagramUpdateQueryParamsImpl";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "withPresentationUpdate";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "withNodePresentationsUpdate";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "withAllNodeSizeUpdate";
                    break;
                }
                case 8: {
                    objectArray = objectArray2;
                    objectArray2[1] = "withNodeSizeUpdate";
                    break;
                }
                case 9: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getNodesForSizeUpdate";
                    break;
                }
                case 10: {
                    objectArray = objectArray2;
                    objectArray2[1] = "runAsync";
                    break;
                }
                case 11: {
                    objectArray = objectArray2;
                    objectArray2[1] = "endQuery";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "withRelayout";
                    break;
                }
                case 7: {
                    objectArray = objectArray;
                    objectArray[2] = "withNodeSizeUpdate";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 2, 7 -> new IllegalArgumentException(string);
            };
        }
    }
}

