/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.uml.java;

import com.intellij.openapi.util.NullableLazyValue;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiMethod;
import com.intellij.ui.SimpleColoredText;
import com.intellij.uml.java.JavaProperty;
import com.intellij.uml.java.JavaUmlElementManager;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class JavaUmlNodeItems {
    @NotNull
    private final Map<PsiField, MyItemData<PsiField>> myFields;
    @NotNull
    private final Map<PsiMethod, MyItemData<PsiMethod>> myMethods;
    @NotNull
    private final Map<JavaProperty, MyItemData<JavaProperty>> myProperties;
    @NotNull
    private static final JavaUmlNodeItems EMPTY = new JavaUmlNodeItems(List.of(), List.of(), List.of());

    public JavaUmlNodeItems(@NotNull Collection<PsiField> fields, @NotNull Collection<PsiMethod> methods, @NotNull Collection<JavaProperty> properties) {
        if (fields == null) {
            JavaUmlNodeItems.$$$reportNull$$$0(0);
        }
        if (methods == null) {
            JavaUmlNodeItems.$$$reportNull$$$0(1);
        }
        if (properties == null) {
            JavaUmlNodeItems.$$$reportNull$$$0(2);
        }
        this.myFields = ContainerUtil.map2Map(fields, it -> Pair.create((Object)it, new MyItemData<PsiField>((PsiField)it)));
        this.myMethods = ContainerUtil.map2Map(methods, it -> Pair.create((Object)it, new MyItemData<PsiMethod>((PsiMethod)it)));
        this.myProperties = ContainerUtil.map2Map(properties, it -> Pair.create((Object)it, new MyItemData<JavaProperty>((JavaProperty)((Object)it))));
    }

    @NotNull
    public static JavaUmlNodeItems empty() {
        JavaUmlNodeItems javaUmlNodeItems = EMPTY;
        if (javaUmlNodeItems == null) {
            JavaUmlNodeItems.$$$reportNull$$$0(3);
        }
        return javaUmlNodeItems;
    }

    @NotNull
    public Set<PsiField> getFields() {
        Set<PsiField> set = this.myFields.keySet();
        if (set == null) {
            JavaUmlNodeItems.$$$reportNull$$$0(4);
        }
        return set;
    }

    @NotNull
    public Set<PsiMethod> getMethods() {
        Set<PsiMethod> set = this.myMethods.keySet();
        if (set == null) {
            JavaUmlNodeItems.$$$reportNull$$$0(5);
        }
        return set;
    }

    @NotNull
    public Set<JavaProperty> getProperties() {
        Set<JavaProperty> set = this.myProperties.keySet();
        if (set == null) {
            JavaUmlNodeItems.$$$reportNull$$$0(6);
        }
        return set;
    }

    @Nullable
    public SimpleColoredText getItemName(@Nullable Object element) {
        return Optional.ofNullable(this.getItemData(element)).map(it -> it.getName()).orElse(null);
    }

    @Nullable
    public SimpleColoredText getItemType(@Nullable Object element) {
        return Optional.ofNullable(this.getItemData(element)).map(it -> it.getType()).orElse(null);
    }

    @Nullable
    public Icon getItemIcon(@Nullable Object element) {
        return Optional.ofNullable(this.getItemData(element)).map(it -> it.getIcon()).orElse(null);
    }

    public void forcePresentationEvaluation() {
        JavaUmlNodeItems.forcePresentationEvaluation(this.myFields.values());
        JavaUmlNodeItems.forcePresentationEvaluation(this.myMethods.values());
        JavaUmlNodeItems.forcePresentationEvaluation(this.myProperties.values());
    }

    private static void forcePresentationEvaluation(@NotNull Collection<? extends MyItemData<?>> items) {
        if (items == null) {
            JavaUmlNodeItems.$$$reportNull$$$0(7);
        }
        for (MyItemData<?> value : items) {
            value.getName();
            value.getType();
            value.getIcon();
        }
    }

    @Nullable
    private MyItemData<?> getItemData(@Nullable Object element) {
        if (element instanceof PsiField) {
            return this.myFields.get(element);
        }
        if (element instanceof PsiMethod) {
            return this.myMethods.get(element);
        }
        if (element instanceof JavaProperty) {
            return this.myProperties.get(element);
        }
        return null;
    }

    public PsiElement @NotNull [] toArray() {
        ArrayList<Object> result = new ArrayList<Object>();
        result.addAll(this.getFields());
        result.addAll(this.getMethods());
        result.addAll(this.getProperties());
        PsiElement[] psiElementArray = (PsiElement[])result.toArray(PsiElement[]::new);
        if (psiElementArray == null) {
            JavaUmlNodeItems.$$$reportNull$$$0(8);
        }
        return psiElementArray;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        JavaUmlNodeItems items = (JavaUmlNodeItems)o;
        return this.myFields.equals(items.myFields) && this.myMethods.equals(items.myMethods) && this.myProperties.equals(items.myProperties);
    }

    public int hashCode() {
        return Objects.hash(this.myFields, this.myMethods, this.myProperties);
    }

    public String toString() {
        return "JavaUmlNodeItems{myFields=" + this.myFields + ", myMethods=" + this.myMethods + ", myProperties=" + this.myProperties + "}";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 4, 5, 6, 8 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fields";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "methods";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "properties";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/uml/java/JavaUmlNodeItems";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "items";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/uml/java/JavaUmlNodeItems";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "empty";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getFields";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getMethods";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getProperties";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "toArray";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 8: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "forcePresentationEvaluation";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 4, 5, 6, 8 -> new IllegalStateException(string);
        };
    }

    private static final class MyItemData<T> {
        @NotNull
        private final NullableLazyValue<SimpleColoredText> myName;
        @NotNull
        private final NullableLazyValue<SimpleColoredText> myType;
        @NotNull
        private final NullableLazyValue<Icon> myIcon;

        private MyItemData(@NotNull T item) {
            if (item == null) {
                MyItemData.$$$reportNull$$$0(0);
            }
            this.myName = NullableLazyValue.lazyNullable(() -> MyItemData.computeName(item));
            this.myType = NullableLazyValue.lazyNullable(() -> MyItemData.computeType(item));
            this.myIcon = NullableLazyValue.lazyNullable(() -> MyItemData.computeIcon(item));
        }

        @Nullable
        private static SimpleColoredText computeName(@NotNull Object item) {
            if (item == null) {
                MyItemData.$$$reportNull$$$0(1);
            }
            return JavaUmlElementManager.doGetItemName(item);
        }

        @Nullable
        private static SimpleColoredText computeType(@NotNull Object item) {
            if (item == null) {
                MyItemData.$$$reportNull$$$0(2);
            }
            return JavaUmlElementManager.doGetItemType(item);
        }

        @Nullable
        private static Icon computeIcon(@NotNull Object item) {
            if (item == null) {
                MyItemData.$$$reportNull$$$0(3);
            }
            return JavaUmlElementManager.doGetItemIcon(item);
        }

        @Nullable
        SimpleColoredText getName() {
            return (SimpleColoredText)this.myName.getValue();
        }

        @Nullable
        SimpleColoredText getType() {
            return (SimpleColoredText)this.myType.getValue();
        }

        @Nullable
        Icon getIcon() {
            return (Icon)this.myIcon.getValue();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "item";
            objectArray2[1] = "com/intellij/uml/java/JavaUmlNodeItems$MyItemData";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "computeName";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "computeType";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "computeIcon";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

