/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.uml.utils;

import com.intellij.openapi.util.Couple;
import com.intellij.openapi.util.NullUtils;
import com.intellij.psi.xml.XmlDocument;
import com.intellij.psi.xml.XmlTag;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import org.jdom.Document;
import org.jdom.Element;

public final class UmlFileConverter {
    public static Document convert(XmlDocument xml) throws IllegalArgumentException {
        XmlTag selectedNodes;
        XmlTag settingsTag;
        XmlTag edgesTag;
        XmlTag packages;
        XmlTag root = xml.getRootTag();
        if (root == null) {
            throw new IllegalArgumentException("Can't read xml file");
        }
        if (!"ClassDiagramm".equals(root.getName())) {
            throw new IllegalArgumentException("Unknown format");
        }
        XmlTag classes = root.findFirstSubTag("classes");
        if (NullUtils.hasNull((Object[])new Object[]{classes, packages = root.findFirstSubTag("packages"), edgesTag = root.findFirstSubTag("edges"), settingsTag = root.findFirstSubTag("settings"), selectedNodes = root.findFirstSubTag("SelectedNodes")})) {
            throw new IllegalArgumentException("Wrong format");
        }
        HashMap<String, Couple> nodeObjects = new HashMap<String, Couple>();
        List<XmlTag> nodeTags = Arrays.asList(classes.getSubTags());
        nodeTags.addAll(Arrays.asList(packages.getSubTags()));
        for (XmlTag node : nodeTags) {
            String y;
            String fqn = node.getAttributeValue("fqn");
            String x = node.getAttributeValue("x");
            if (NullUtils.hasNull((Object[])new Object[]{x, y = node.getAttributeValue("y"), fqn})) {
                throw new IllegalArgumentException("Wrong format: x, y or fqn is missed");
            }
            nodeObjects.put(fqn, Couple.of((Object)x, (Object)y));
        }
        Element rootTag = new Element("Diagram");
        Document doc = new Document(rootTag);
        Element id = new Element("ID");
        id.setText("JAVA");
        rootTag.addContent(id);
        Element originalElement = new Element("OriginalElement");
        originalElement.setText(nodeObjects.size() == 0 ? "java.lang.Object" : (String)nodeObjects.keySet().iterator().next());
        rootTag.addContent(originalElement);
        Element nodes = new Element("nodes");
        for (XmlTag[] fqn : nodeObjects.keySet()) {
            Element node = new Element("node");
            Couple coord = (Couple)nodeObjects.get(fqn);
            node.setAttribute("x", (String)coord.first);
            node.setAttribute("y", (String)coord.second);
            node.setText((String)fqn);
            nodes.addContent(node);
        }
        rootTag.addContent(nodes);
        rootTag.addContent(new Element("notes"));
        Element edges = new Element("edges");
        for (XmlTag edgeTag : edgesTag.findSubTags("edge")) {
            String target;
            String source = edgeTag.getAttributeValue("source");
            if (NullUtils.hasNull((Object[])new Object[]{source, target = edgeTag.getAttributeValue("target")})) {
                throw new IllegalArgumentException("Wrong format. Missing source or target attribute.");
            }
            Element edge = new Element("edge");
            edge.setAttribute("source", source);
            edge.setAttribute("target", target);
            for (XmlTag pointTag : edgeTag.findSubTags("point")) {
                String x = pointTag.getAttributeValue("x");
                String y = pointTag.getAttributeValue("y");
                if (x == null || y == null) {
                    throw new IllegalArgumentException("Wrong format. Point shall have x and y attributes");
                }
                Element point = new Element("point");
                point.setAttribute("x", x);
                point.setAttribute("y", y);
                edge.addContent(point);
            }
            edges.addContent(edge);
        }
        rootTag.addContent(edges);
        Element settings = new Element("settings");
        settings.setAttribute("layout", settingsTag.getAttributeValue("layout"));
        settings.setAttribute("zoom", settingsTag.getAttributeValue("zoom"));
        settings.setAttribute("x", settingsTag.getAttributeValue("x"));
        settings.setAttribute("y", settingsTag.getAttributeValue("y"));
        rootTag.addContent(settings);
        rootTag.addContent(new Element("SelectedNodes"));
        Element categories = new Element("Categories");
        UmlFileConverter.checkAndAdd(categories, settingsTag, Arrays.asList(Couple.of((Object)"isFieldsVisible", (Object)"Fields"), Couple.of((Object)"isMethodsVisible", (Object)"Methods"), Couple.of((Object)"isConstructorsVisible", (Object)"Constructors"), Couple.of((Object)"isShowInnerClasses", (Object)"Inner Classes"), Couple.of((Object)"isPropertiesVisible", (Object)"Properties")));
        rootTag.addContent(categories);
        return doc;
    }

    private static void checkAndAdd(Element categories, XmlTag settingsTag, List<Couple<String>> pairs) {
        for (Couple<String> pair : pairs) {
            if (!Boolean.parseBoolean(settingsTag.getAttributeValue((String)pair.first))) continue;
            Element category = new Element("Category");
            category.setText((String)pair.second);
            categories.addContent(category);
        }
    }
}

