/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.notebooks.core.jupyter.remote.vfs;

import com.intellij.notebooks.core.jupyter.remote.vfs.JupyterRemoteFileStrategy;
import com.intellij.notebooks.core.jupyter.remote.vfs.JupyterRemoteFileSystem;
import com.intellij.notebooks.core.jupyter.remote.vfs.JupyterRemoteVirtualFile;
import com.intellij.notebooks.core.jupyter.remote.vfs.JupyterRemoteVirtualFileWriteQueue;
import com.intellij.notebooks.core.jupyter.remote.vfs.UploadingTask;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.vfs.VirtualFileSystem;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.util.concurrent.atomic.AtomicBoolean;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0002\u0010\u0012\n\u0002\b\u0004\b\u0000\u0018\u00002\u00020\u0001B1\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0001\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0004\b\u000b\u0010\fJ\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J \u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00122\u0006\u0010\u0015\u001a\u00020\u0012H\u0016J\b\u0010\u0016\u001a\u00020\u0010H\u0016R\u0010\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lcom/intellij/notebooks/core/jupyter/remote/vfs/UploadingOutputStream;", "Ljava/io/OutputStream;", "requestor", "", "virtualFile", "Lcom/intellij/notebooks/core/jupyter/remote/vfs/JupyterRemoteVirtualFile;", "forward", "createdOnServer", "Ljava/util/concurrent/atomic/AtomicBoolean;", "strategy", "Lcom/intellij/notebooks/core/jupyter/remote/vfs/JupyterRemoteFileStrategy;", "<init>", "(Ljava/lang/Object;Lcom/intellij/notebooks/core/jupyter/remote/vfs/JupyterRemoteVirtualFile;Ljava/io/OutputStream;Ljava/util/concurrent/atomic/AtomicBoolean;Lcom/intellij/notebooks/core/jupyter/remote/vfs/JupyterRemoteFileStrategy;)V", "content", "Ljava/io/ByteArrayOutputStream;", "write", "", "b", "", "", "off", "len", "close", "intellij.notebooks.core"})
@SourceDebugExtension(value={"SMAP\nUploadingOutputStream.kt\nKotlin\n*S Kotlin\n*F\n+ 1 UploadingOutputStream.kt\ncom/intellij/notebooks/core/jupyter/remote/vfs/UploadingOutputStream\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,34:1\n61#2,5:35\n*S KotlinDebug\n*F\n+ 1 UploadingOutputStream.kt\ncom/intellij/notebooks/core/jupyter/remote/vfs/UploadingOutputStream\n*L\n30#1:35,5\n*E\n"})
public final class UploadingOutputStream
extends OutputStream {
    @Nullable
    private final Object requestor;
    @NotNull
    private final JupyterRemoteVirtualFile virtualFile;
    @NotNull
    private final OutputStream forward;
    @NotNull
    private final AtomicBoolean createdOnServer;
    @NotNull
    private final JupyterRemoteFileStrategy strategy;
    @NotNull
    private final ByteArrayOutputStream content;

    public UploadingOutputStream(@Nullable Object requestor, @NotNull JupyterRemoteVirtualFile virtualFile, @NotNull OutputStream forward, @NotNull AtomicBoolean createdOnServer, @NotNull JupyterRemoteFileStrategy strategy) {
        Intrinsics.checkNotNullParameter((Object)((Object)virtualFile), (String)"virtualFile");
        Intrinsics.checkNotNullParameter((Object)forward, (String)"forward");
        Intrinsics.checkNotNullParameter((Object)createdOnServer, (String)"createdOnServer");
        Intrinsics.checkNotNullParameter((Object)strategy, (String)"strategy");
        this.requestor = requestor;
        this.virtualFile = virtualFile;
        this.forward = forward;
        this.createdOnServer = createdOnServer;
        this.strategy = strategy;
        this.content = new ByteArrayOutputStream();
    }

    @Override
    public void write(int b) {
        this.content.write(b);
        this.forward.write(b);
    }

    @Override
    public void write(@NotNull byte[] b, int off, int len) {
        Intrinsics.checkNotNullParameter((Object)b, (String)"b");
        this.content.write(b, off, len);
        this.forward.write(b, off, len);
    }

    @Override
    public void close() {
        this.forward.close();
        byte[] byArray = this.content.toByteArray();
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"toByteArray(...)");
        UploadingTask task2 = new UploadingTask(this.virtualFile, byArray, this.createdOnServer, this.strategy);
        Logger $this$debug_u24default$iv = JupyterRemoteFileSystem.Companion.getJUPYTER_VFS_LOG();
        Throwable e$iv = null;
        boolean $i$f$debug = false;
        if ($this$debug_u24default$iv.isDebugEnabled()) {
            Logger logger = $this$debug_u24default$iv;
            boolean bl = false;
            logger.debug("Enqueuing " + task2 + " first time.", e$iv);
        }
        VirtualFileSystem virtualFileSystem = this.virtualFile.getFileSystem();
        Intrinsics.checkNotNull((Object)virtualFileSystem, (String)"null cannot be cast to non-null type com.intellij.notebooks.core.jupyter.remote.vfs.JupyterRemoteFileSystem");
        ((JupyterRemoteFileSystem)virtualFileSystem)._vfs_private_fileUploadQueued$intellij_notebooks_core(this.virtualFile.getRemotePath());
        JupyterRemoteVirtualFileWriteQueue.Companion.queue(task2);
    }
}

