/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.notebooks.visualization.ui;

import com.intellij.codeInsight.hints.presentation.InlayPresentation;
import com.intellij.codeInsight.hints.presentation.PresentationRenderer;
import com.intellij.notebooks.ui.editor.actions.command.mode.NotebookEditorMode;
import com.intellij.notebooks.ui.editor.actions.command.mode.NotebookEditorModeKt;
import com.intellij.notebooks.visualization.NotebookCellLines;
import com.intellij.notebooks.visualization.UpdateContext;
import com.intellij.notebooks.visualization.ui.ActionToGutterRendererAdapter;
import com.intellij.notebooks.visualization.ui.EditorCell;
import com.intellij.notebooks.visualization.ui.EditorCellViewComponent;
import com.intellij.notebooks.visualization.ui.InputComponent;
import com.intellij.notebooks.visualization.ui.TextEditorCellViewComponent;
import com.intellij.notebooks.visualization.ui.UpdateManager;
import com.intellij.notebooks.visualization.ui.UpdateManagerKt;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorCustomElementRenderer;
import com.intellij.openapi.editor.FoldRegion;
import com.intellij.openapi.editor.Inlay;
import com.intellij.openapi.editor.InlayProperties;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.ex.FoldingModelEx;
import com.intellij.openapi.editor.ex.MarkupModelEx;
import com.intellij.openapi.editor.impl.FoldingModelImpl;
import com.intellij.openapi.editor.markup.GutterIconRenderer;
import com.intellij.openapi.editor.markup.HighlighterTargetArea;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.IntRange;
import kotlin.sequences.Sequence;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000w\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003*\u0001\u0013\u0018\u00002\u00020\u00012\u00020\u0002B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0012\u0010\u001b\u001a\u00020\u001c2\b\u0010\u001d\u001a\u0004\u0018\u00010\u001eH\u0002J\b\u0010\u001f\u001a\u00020\u001cH\u0016J\b\u0010 \u001a\u00020\u001cH\u0002J\u000f\u0010!\u001a\u0004\u0018\u00010\"H\u0002\u00a2\u0006\u0002\u0010#J\u0010\u0010$\u001a\u00020\"2\u0006\u0010\f\u001a\u00020\rH\u0002J\b\u0010%\u001a\u00020&H\u0016J\u0018\u0010'\u001a\u00020\u001c2\u0006\u0010(\u001a\u00020)2\u0006\u0010*\u001a\u00020\u001aH\u0016J\b\u0010+\u001a\u00020\u001cH\u0016J\u0010\u0010,\u001a\u00020\u001c2\u0006\u0010-\u001a\u00020\u0017H\u0016J\u0010\u0010.\u001a\u00020\u001c2\u0006\u0010-\u001a\u00020\u0017H\u0016J\u0012\u0010/\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u001800H\u0016J\b\u00101\u001a\u00020\u001cH\u0016J\b\u00102\u001a\u00020\u001aH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\t\u001a\n\u0012\u0004\u0012\u00020\u000b\u0018\u00010\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\u00020\r8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR\u0016\u0010\u0010\u001a\u0004\u0018\u00010\r8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u000fR\u0010\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0014R\u001e\u0010\u0015\u001a\u0012\u0012\u0004\u0012\u00020\u0017\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00180\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u001aX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00063"}, d2={"Lcom/intellij/notebooks/visualization/ui/TextEditorCellViewComponent;", "Lcom/intellij/notebooks/visualization/ui/EditorCellViewComponent;", "Lcom/intellij/notebooks/visualization/ui/InputComponent;", "editor", "Lcom/intellij/openapi/editor/ex/EditorEx;", "cell", "Lcom/intellij/notebooks/visualization/ui/EditorCell;", "<init>", "(Lcom/intellij/openapi/editor/ex/EditorEx;Lcom/intellij/notebooks/visualization/ui/EditorCell;)V", "highlighters", "", "Lcom/intellij/openapi/editor/markup/RangeHighlighter;", "interval", "Lcom/intellij/notebooks/visualization/NotebookCellLines$Interval;", "getInterval", "()Lcom/intellij/notebooks/visualization/NotebookCellLines$Interval;", "safeInterval", "getSafeInterval", "mouseListener", "com/intellij/notebooks/visualization/ui/TextEditorCellViewComponent$mouseListener$1", "Lcom/intellij/notebooks/visualization/ui/TextEditorCellViewComponent$mouseListener$1;", "presentationToInlay", "", "Lcom/intellij/codeInsight/hints/presentation/InlayPresentation;", "Lcom/intellij/openapi/editor/Inlay;", "gutterIconStickToFirstVisibleLine", "", "updateGutterIcons", "", "gutterAction", "Lcom/intellij/openapi/actionSystem/AnAction;", "dispose", "disposeExistingHighlighter", "getFirstFullyVisibleLogicalLine", "", "()Ljava/lang/Integer;", "computeFirstLineForHighlighter", "calculateBounds", "Ljava/awt/Rectangle;", "updateFolding", "ctx", "Lcom/intellij/notebooks/visualization/UpdateContext;", "folded", "requestCaret", "addInlayBelow", "presentation", "removeInlayBelow", "doGetInlays", "Lkotlin/sequences/Sequence;", "doCheckAndRebuildInlays", "isInlaysBroken", "intellij.notebooks.visualization"})
@SourceDebugExtension(value={"SMAP\nTextEditorCellViewComponent.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TextEditorCellViewComponent.kt\ncom/intellij/notebooks/visualization/ui/TextEditorCellViewComponent\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,219:1\n1863#2,2:220\n1863#2,2:223\n1863#2,2:225\n295#2,2:227\n1#3:222\n*S KotlinDebug\n*F\n+ 1 TextEditorCellViewComponent.kt\ncom/intellij/notebooks/visualization/ui/TextEditorCellViewComponent\n*L\n93#1:220,2\n204#1:223,2\n205#1:225,2\n154#1:227,2\n*E\n"})
public final class TextEditorCellViewComponent
extends EditorCellViewComponent
implements InputComponent {
    @NotNull
    private final EditorEx editor;
    @NotNull
    private final EditorCell cell;
    @Nullable
    private List<? extends RangeHighlighter> highlighters;
    @NotNull
    private final mouseListener.1 mouseListener;
    @NotNull
    private final Map<InlayPresentation, Inlay<?>> presentationToInlay;
    private final boolean gutterIconStickToFirstVisibleLine;

    public TextEditorCellViewComponent(@NotNull EditorEx editor, @NotNull EditorCell cell) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)cell, (String)"cell");
        this.editor = editor;
        this.cell = cell;
        this.mouseListener = new MouseAdapter(this){
            final /* synthetic */ TextEditorCellViewComponent this$0;
            {
                this.this$0 = $receiver;
            }

            public void mousePressed(MouseEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                IntRange intRange = TextEditorCellViewComponent.access$getCell$p(this.this$0).getInterval().getLines();
                int n = intRange.getFirst();
                int n2 = intRange.getLast();
                int n3 = TextEditorCellViewComponent.access$getEditor$p((TextEditorCellViewComponent)this.this$0).xyToLogicalPosition((Point)e.getPoint()).line;
                boolean bl = n <= n3 ? n3 <= n2 : false;
                if (bl) {
                    NotebookEditorModeKt.setMode((Editor)TextEditorCellViewComponent.access$getEditor$p(this.this$0), NotebookEditorMode.EDIT);
                }
            }
        };
        this.presentationToInlay = new LinkedHashMap();
        this.gutterIconStickToFirstVisibleLine = Registry.Companion.is("jupyter.run.cell.button.sticks.first.visible.line");
        this.editor.getContentComponent().addMouseListener(this.mouseListener);
        this.cell.getGutterAction().afterChange((Disposable)this, arg_0 -> TextEditorCellViewComponent._init_$lambda$0(this, arg_0));
        this.updateGutterIcons((AnAction)this.cell.getGutterAction().get());
    }

    private final NotebookCellLines.Interval getInterval() {
        NotebookCellLines.Interval interval = this.cell.getIntervalPointer().get();
        if (interval == null) {
            throw new IllegalStateException("Invalid interval".toString());
        }
        return interval;
    }

    private final NotebookCellLines.Interval getSafeInterval() {
        return this.cell.getIntervalPointer().get();
    }

    private final void updateGutterIcons(AnAction gutterAction) {
        ActionsKt.runInEdt$default(null, () -> TextEditorCellViewComponent.updateGutterIcons$lambda$1(this, gutterAction), (int)1, null);
    }

    @Override
    public void dispose() {
        UpdateManager.update$default(UpdateManagerKt.getUpdateManager((Editor)this.editor), false, arg_0 -> TextEditorCellViewComponent.dispose$lambda$2(this, arg_0), 1, null);
    }

    private final void disposeExistingHighlighter() {
        if (this.highlighters != null) {
            List<? extends RangeHighlighter> list = this.highlighters;
            if (list != null) {
                Iterable $this$forEach$iv = list;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    RangeHighlighter it = (RangeHighlighter)element$iv;
                    boolean bl = false;
                    it.dispose();
                }
            }
            this.highlighters = null;
        }
    }

    private final Integer getFirstFullyVisibleLogicalLine() {
        Rectangle rectangle = this.editor.getScrollingModel().getVisibleArea();
        Intrinsics.checkNotNullExpressionValue((Object)rectangle, (String)"getVisibleArea(...)");
        Rectangle visibleArea = rectangle;
        int startY = visibleArea.y;
        int endY = visibleArea.y + visibleArea.height;
        int firstVisibleLine = this.editor.xyToLogicalPosition((Point)new Point((int)0, (int)startY)).line;
        int lastVisibleLine = this.editor.xyToLogicalPosition((Point)new Point((int)0, (int)endY)).line;
        int line = firstVisibleLine;
        if (line <= lastVisibleLine) {
            while (true) {
                int lineStartY = this.editor.logicalPositionToXY((LogicalPosition)new LogicalPosition((int)line, (int)0)).y;
                int lineEndY = lineStartY + this.editor.getLineHeight();
                if (lineStartY >= startY && lineEndY <= endY) {
                    return line;
                }
                if (line == lastVisibleLine) break;
                ++line;
            }
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    private final int computeFirstLineForHighlighter(NotebookCellLines.Interval interval) {
        int n;
        if (this.gutterIconStickToFirstVisibleLine) {
            void var3_3;
            boolean fullyVisibleCell;
            Integer firstFullyVisibleLine = this.getFirstFullyVisibleLogicalLine();
            int startLine = firstFullyVisibleLine != null && interval.getLines().contains(firstFullyVisibleLine.intValue()) ? firstFullyVisibleLine.intValue() : interval.getLines().getFirst();
            Integer n2 = this.getFirstFullyVisibleLogicalLine();
            int n3 = interval.getLines().getFirst();
            boolean bl = fullyVisibleCell = n2 != null && n2 == n3;
            n = fullyVisibleCell ? interval.getLines().getFirst() : var3_3;
        } else {
            n = interval.getLines().getFirst();
        }
        return n;
    }

    @Override
    @NotNull
    public Rectangle calculateBounds() {
        NotebookCellLines.Interval interval = this.getInterval();
        int startOffset = this.editor.getDocument().getLineStartOffset(interval.getLines().getFirst());
        Point point = this.editor.offsetToXY(startOffset);
        Intrinsics.checkNotNullExpressionValue((Object)point, (String)"offsetToXY(...)");
        Point startLocation = point;
        int endOffset = this.editor.getDocument().getLineEndOffset(interval.getLines().getLast());
        Point point2 = this.editor.offsetToXY(endOffset);
        Intrinsics.checkNotNullExpressionValue((Object)point2, (String)"offsetToXY(...)");
        Point endLocation = point2;
        int height = endLocation.y + this.editor.getLineHeight() - startLocation.y;
        int width = endLocation.x - startLocation.x;
        Dimension dimension = new Dimension(width, height);
        return new Rectangle(startLocation, dimension);
    }

    @Override
    public void updateFolding(@NotNull UpdateContext ctx, boolean folded) {
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        NotebookCellLines.Interval interval = this.getInterval();
        int startOffset = this.editor.getDocument().getLineStartOffset(interval.getLines().getFirst() + 1);
        int endOffset = this.editor.getDocument().getLineEndOffset(interval.getLines().getLast());
        FoldingModelEx foldingModelEx = this.editor.getFoldingModel();
        Intrinsics.checkNotNullExpressionValue((Object)foldingModelEx, (String)"getFoldingModel(...)");
        FoldingModelEx foldingModel = foldingModelEx;
        FoldRegion currentFoldingRegion = foldingModel.getFoldRegion(startOffset, endOffset);
        if (currentFoldingRegion == null) {
            ctx.addFoldingOperation((Function1<? super FoldingModelEx, Unit>)((Function1)arg_0 -> TextEditorCellViewComponent.updateFolding$lambda$6(this, startOffset, endOffset, arg_0)));
        } else {
            ctx.addFoldingOperation((Function1<? super FoldingModelEx, Unit>)((Function1)arg_0 -> TextEditorCellViewComponent.updateFolding$lambda$7(currentFoldingRegion, arg_0)));
        }
    }

    @Override
    public void requestCaret() {
        IntRange lines = this.cell.getInterval().getLines();
        int offset = this.editor.getDocument().getLineStartOffset(lines.getFirst() + 1);
        this.editor.getCaretModel().moveToOffset(offset);
    }

    @Override
    public void addInlayBelow(@NotNull InlayPresentation presentation) {
        block0: {
            Inlay inlay;
            Intrinsics.checkNotNullParameter((Object)presentation, (String)"presentation");
            Inlay inlay2 = this.editor.getInlayModel().addBlockElement(this.editor.getDocument().getLineEndOffset(this.cell.getInterval().getLines().getLast()), new InlayProperties().showAbove(false).showWhenFolded(true), (EditorCustomElementRenderer)new PresentationRenderer(presentation));
            if (inlay2 == null) break block0;
            Inlay inlay3 = inlay = inlay2;
            boolean bl = false;
            this.presentationToInlay.put(presentation, inlay3);
            Disposer.register((Disposable)this, (Disposable)((Disposable)inlay3));
        }
    }

    @Override
    public void removeInlayBelow(@NotNull InlayPresentation presentation) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)presentation, (String)"presentation");
            Inlay<?> inlay = this.presentationToInlay.remove(presentation);
            if (inlay == null) break block0;
            Inlay<?> inlay2 = inlay;
            boolean bl = false;
            Disposer.dispose((Disposable)((Disposable)inlay2));
        }
    }

    @Override
    @NotNull
    public Sequence<Inlay<?>> doGetInlays() {
        return CollectionsKt.asSequence((Iterable)this.presentationToInlay.values());
    }

    @Override
    public void doCheckAndRebuildInlays() {
        if (this.isInlaysBroken()) {
            List presentations = CollectionsKt.toList((Iterable)this.presentationToInlay.keySet());
            Iterable $this$forEach$iv = this.presentationToInlay.values();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Inlay inlay = (Inlay)element$iv;
                boolean bl = false;
                Disposer.dispose((Disposable)((Disposable)inlay));
            }
            $this$forEach$iv = presentations;
            $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                InlayPresentation it = (InlayPresentation)element$iv;
                boolean bl = false;
                this.addInlayBelow(it);
            }
        }
    }

    private final boolean isInlaysBroken() {
        int offset = this.editor.getDocument().getLineEndOffset(this.getInterval().getLines().getLast());
        for (Inlay<?> inlay : this.presentationToInlay.values()) {
            if (inlay.isValid() && inlay.getOffset() == offset) continue;
            return true;
        }
        return false;
    }

    @Override
    public void updateInput(@NotNull UpdateContext ctx) {
        InputComponent.DefaultImpls.updateInput(this, ctx);
    }

    private static final Unit _init_$lambda$0(TextEditorCellViewComponent this$0, AnAction action2) {
        this$0.updateGutterIcons(action2);
        return Unit.INSTANCE;
    }

    private static final Unit updateGutterIcons$lambda$1(TextEditorCellViewComponent this$0, AnAction $gutterAction) {
        this$0.disposeExistingHighlighter();
        if ($gutterAction == null) {
            return Unit.INSTANCE;
        }
        MarkupModelEx markupModelEx = this$0.editor.getMarkupModel();
        Intrinsics.checkNotNullExpressionValue((Object)markupModelEx, (String)"getMarkupModel(...)");
        MarkupModelEx markupModel = markupModelEx;
        NotebookCellLines.Interval interval = this$0.getSafeInterval();
        if (interval == null) {
            return Unit.INSTANCE;
        }
        NotebookCellLines.Interval interval2 = interval;
        int startOffset = this$0.editor.getDocument().getLineStartOffset(this$0.computeFirstLineForHighlighter(interval2));
        int endOffset = this$0.editor.getDocument().getLineEndOffset(interval2.getLines().getLast());
        RangeHighlighter rangeHighlighter = markupModel.addRangeHighlighter(startOffset, endOffset, 900, new TextAttributes(), HighlighterTargetArea.LINES_IN_RANGE);
        Intrinsics.checkNotNullExpressionValue((Object)rangeHighlighter, (String)"addRangeHighlighter(...)");
        RangeHighlighter highlighter = rangeHighlighter;
        highlighter.setGutterIconRenderer((GutterIconRenderer)new ActionToGutterRendererAdapter($gutterAction));
        this$0.highlighters = CollectionsKt.listOf((Object)highlighter);
        return Unit.INSTANCE;
    }

    private static final Unit dispose$lambda$2(TextEditorCellViewComponent this$0, UpdateContext ctx) {
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        this$0.disposeExistingHighlighter();
        this$0.editor.getContentComponent().removeMouseListener(this$0.mouseListener);
        return Unit.INSTANCE;
    }

    private static final Unit updateFolding$lambda$6(TextEditorCellViewComponent this$0, int $startOffset, int $endOffset, FoldingModelEx foldingModel) {
        block3: {
            String firstNotEmptyString;
            String string;
            Object v2;
            FoldRegion foldRegion;
            block2: {
                Intrinsics.checkNotNullParameter((Object)foldingModel, (String)"foldingModel");
                String string2 = this$0.editor.getDocument().getText(new TextRange($startOffset, $endOffset));
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getText(...)");
                String text = string2;
                Iterable $this$firstOrNull$iv = StringsKt.lines((CharSequence)text);
                boolean $i$f$firstOrNull = false;
                foldRegion = $this$firstOrNull$iv.iterator();
                while (foldRegion.hasNext()) {
                    Object element$iv = foldRegion.next();
                    String it = (String)element$iv;
                    boolean bl = false;
                    boolean bl2 = ((CharSequence)((Object)StringsKt.trim((CharSequence)it)).toString()).length() > 0;
                    if (!bl2) continue;
                    v2 = element$iv;
                    break block2;
                }
                v2 = null;
            }
            if ((string = (firstNotEmptyString = (String)v2)) == null) {
                string = "\u2026";
            }
            String string3 = StringUtil.shortenTextWithEllipsis((String)string, (int)20, (int)0);
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"shortenTextWithEllipsis(...)");
            String placeholder = string3;
            FoldRegion foldRegion2 = foldingModel.createFoldRegion($startOffset, $endOffset, placeholder, null, false);
            if (foldRegion2 == null) break block3;
            FoldRegion $this$updateFolding_u24lambda_u246_u24lambda_u245 = foldRegion = foldRegion2;
            boolean bl = false;
            FoldingModelImpl.hideGutterRendererForCollapsedRegion((FoldRegion)$this$updateFolding_u24lambda_u246_u24lambda_u245);
            $this$updateFolding_u24lambda_u246_u24lambda_u245.setExpanded(false);
        }
        return Unit.INSTANCE;
    }

    private static final Unit updateFolding$lambda$7(FoldRegion $currentFoldingRegion, FoldingModelEx foldingModel) {
        Intrinsics.checkNotNullParameter((Object)foldingModel, (String)"foldingModel");
        if ($currentFoldingRegion.isExpanded()) {
            $currentFoldingRegion.setExpanded(false);
        } else {
            foldingModel.removeFoldRegion($currentFoldingRegion);
        }
        return Unit.INSTANCE;
    }

    public static final /* synthetic */ EditorCell access$getCell$p(TextEditorCellViewComponent $this) {
        return $this.cell;
    }

    public static final /* synthetic */ EditorEx access$getEditor$p(TextEditorCellViewComponent $this) {
        return $this.editor;
    }
}

