/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.webcomponents.css;

import com.intellij.psi.PsiElement;
import com.intellij.psi.xml.XmlTag;
import com.intellij.webcomponents.util.WebComponentsUtil;
import com.intellij.xml.XmlAttributeDescriptor;
import com.intellij.xml.XmlAttributeDescriptorsProvider;
import com.intellij.xml.impl.schema.AnyXmlAttributeDescriptor;
import java.util.ArrayList;
import org.jetbrains.annotations.Nullable;

public class PolymerLayoutAttributesDescriptorProvider
implements XmlAttributeDescriptorsProvider {
    public static final AnyXmlAttributeDescriptor UNRESOLVED = new AnyXmlAttributeDescriptor("unresolved");
    public static final AnyXmlAttributeDescriptor NO_SHIM = new AnyXmlAttributeDescriptor("no-shim");
    public static final AnyXmlAttributeDescriptor SHIM_SHADOWDOM = new AnyXmlAttributeDescriptor("shim-shadowdom");

    public XmlAttributeDescriptor[] getAttributeDescriptors(XmlTag context) {
        if (!WebComponentsUtil.hasPolymerJs((PsiElement)context)) {
            return XmlAttributeDescriptor.EMPTY;
        }
        ArrayList<AnyXmlAttributeDescriptor> result = new ArrayList<AnyXmlAttributeDescriptor>();
        result.add(UNRESOLVED);
        String name = context.getName();
        if ("link".equals(name) || "style".equals(name)) {
            result.add(NO_SHIM);
            result.add(SHIM_SHADOWDOM);
        }
        return result.toArray(XmlAttributeDescriptor.EMPTY);
    }

    @Nullable
    public XmlAttributeDescriptor getAttributeDescriptor(String attributeName, XmlTag context) {
        if (!WebComponentsUtil.hasPolymerJs((PsiElement)context)) {
            return null;
        }
        if (UNRESOLVED.getName().equals(attributeName)) {
            return UNRESOLVED;
        }
        String name = context.getName();
        if ("link".equals(name) || "style".equals(name)) {
            if (NO_SHIM.getName().equals(attributeName)) {
                return NO_SHIM;
            }
            if (SHIM_SHADOWDOM.getName().equals(attributeName)) {
                return SHIM_SHADOWDOM;
            }
        }
        return null;
    }
}

