/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.editor;

import com.intellij.configurationStore.XmlSerializer;
import com.intellij.database.csv.CsvFileType;
import com.intellij.database.csv.CsvFormat;
import com.intellij.database.csv.CsvFormatResolver;
import com.intellij.database.csv.CsvFormatResolverCore;
import com.intellij.database.csv.CsvFormats;
import com.intellij.database.editor.CsvTableFileEditor;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorPolicy;
import com.intellij.openapi.fileEditor.FileEditorProvider;
import com.intellij.openapi.fileEditor.FileEditorState;
import com.intellij.openapi.fileEditor.WeighedFileEditorProvider;
import com.intellij.openapi.fileEditor.ex.FileEditorManagerEx;
import com.intellij.openapi.fileEditor.ex.FileEditorProviderManager;
import com.intellij.openapi.fileEditor.impl.EditorComposite;
import com.intellij.openapi.fileEditor.impl.EditorWindow;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeRegistry;
import com.intellij.openapi.progress.util.BackgroundTaskUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.serialization.SerializationException;
import com.intellij.util.containers.ContainerUtil;
import java.util.Objects;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class CsvTableFileEditorProvider
extends WeighedFileEditorProvider {
    public static final String PROVIDER_ID = "csv-data-editor";

    public boolean accept(@NotNull Project project, @NotNull VirtualFile file) {
        if (project == null) {
            CsvTableFileEditorProvider.$$$reportNull$$$0(0);
        }
        if (file == null) {
            CsvTableFileEditorProvider.$$$reportNull$$$0(1);
        }
        return CsvTableFileEditorProvider.isCsvFile(file);
    }

    public boolean acceptRequiresReadAction() {
        return false;
    }

    @NotNull
    public CsvTableFileEditor createEditor(@NotNull Project project, @NotNull VirtualFile file) {
        CsvFormat format;
        if (project == null) {
            CsvTableFileEditorProvider.$$$reportNull$$$0(2);
        }
        if (file == null) {
            CsvTableFileEditorProvider.$$$reportNull$$$0(3);
        }
        if ((format = CsvTableFileEditorProvider.getFormatFast(project, file)) != null) {
            return new CsvTableFileEditor(project, file, format);
        }
        CsvTableFileEditor editor = new CsvTableFileEditor(project, file, (CsvFormat)CsvFormats.CSV_FORMAT.get());
        ModalityState state = ModalityState.current();
        BackgroundTaskUtil.executeOnPooledThread((Disposable)editor, () -> {
            CsvFormat detected = CsvFormatResolverCore.getMoreSuitableCsvFormat((VirtualFile)file, (boolean)true, null);
            ApplicationManager.getApplication().invokeLater(() -> {
                if (detected != null) {
                    editor.setFormat(detected);
                }
            }, state);
        });
        CsvTableFileEditor csvTableFileEditor = editor;
        if (csvTableFileEditor == null) {
            CsvTableFileEditorProvider.$$$reportNull$$$0(4);
        }
        return csvTableFileEditor;
    }

    @NotNull
    public FileEditorState readState(@NotNull Element sourceElement, @NotNull Project project, @NotNull VirtualFile file) {
        if (sourceElement == null) {
            CsvTableFileEditorProvider.$$$reportNull$$$0(5);
        }
        if (project == null) {
            CsvTableFileEditorProvider.$$$reportNull$$$0(6);
        }
        if (file == null) {
            CsvTableFileEditorProvider.$$$reportNull$$$0(7);
        }
        FileEditorState state = null;
        try {
            state = (FileEditorState)XmlSerializer.deserialize((Element)sourceElement, CsvFormatResolver.State.class);
        }
        catch (SerializationException serializationException) {
            // empty catch block
        }
        FileEditorState fileEditorState = state == null ? FileEditorState.INSTANCE : state;
        if (fileEditorState == null) {
            CsvTableFileEditorProvider.$$$reportNull$$$0(8);
        }
        return fileEditorState;
    }

    public void writeState(@NotNull FileEditorState state, @NotNull Project project, @NotNull Element targetElement) {
        if (state == null) {
            CsvTableFileEditorProvider.$$$reportNull$$$0(9);
        }
        if (project == null) {
            CsvTableFileEditorProvider.$$$reportNull$$$0(10);
        }
        if (targetElement == null) {
            CsvTableFileEditorProvider.$$$reportNull$$$0(11);
        }
        if (state instanceof CsvFormatResolver.State) {
            XmlSerializer.serializeObjectInto((Object)state, (Element)targetElement);
        }
    }

    @NotNull
    public String getEditorTypeId() {
        return PROVIDER_ID;
    }

    @NotNull
    public FileEditorPolicy getPolicy() {
        if (Registry.is((String)"csv.open.as.tables.by.default", (boolean)false)) {
            FileEditorPolicy fileEditorPolicy = FileEditorPolicy.PLACE_BEFORE_DEFAULT_EDITOR;
            if (fileEditorPolicy == null) {
                CsvTableFileEditorProvider.$$$reportNull$$$0(12);
            }
            return fileEditorPolicy;
        }
        FileEditorPolicy fileEditorPolicy = FileEditorPolicy.PLACE_AFTER_DEFAULT_EDITOR;
        if (fileEditorPolicy == null) {
            CsvTableFileEditorProvider.$$$reportNull$$$0(13);
        }
        return fileEditorPolicy;
    }

    @Nullable
    private static CsvFormat getFormatFast(@NotNull Project project, @NotNull VirtualFile file) {
        if (project == null) {
            CsvTableFileEditorProvider.$$$reportNull$$$0(14);
        }
        if (file == null) {
            CsvTableFileEditorProvider.$$$reportNull$$$0(15);
        }
        return CsvFormatResolver.getFormat(project, file, true, null, CsvFormatResolver.FormatGetter.FILE, CsvFormatResolver.FormatGetter.STATE);
    }

    private static boolean isCsvFile(@NotNull VirtualFile file) {
        if (file == null) {
            CsvTableFileEditorProvider.$$$reportNull$$$0(16);
        }
        return FileTypeRegistry.getInstance().isFileOfType(file, (FileType)CsvFileType.INSTANCE);
    }

    public static void openEditor(@NotNull Project project, @NotNull VirtualFile file, @NotNull CsvFormat format) {
        FileEditorManagerEx fileEditorManagerEx;
        EditorWindow editorWindow;
        EditorComposite composite;
        if (project == null) {
            CsvTableFileEditorProvider.$$$reportNull$$$0(17);
        }
        if (file == null) {
            CsvTableFileEditorProvider.$$$reportNull$$$0(18);
        }
        if (format == null) {
            CsvTableFileEditorProvider.$$$reportNull$$$0(19);
        }
        EditorComposite editorComposite = composite = (editorWindow = (fileEditorManagerEx = FileEditorManagerEx.getInstanceEx((Project)project)).getSplitters().getCurrentWindow()) == null ? null : editorWindow.getComposite(file);
        if (composite != null) {
            CsvTableFileEditor tableEditor = (CsvTableFileEditor)((Object)ContainerUtil.findInstance((Iterable)composite.getAllEditors(), CsvTableFileEditor.class));
            if (tableEditor != null) {
                tableEditor.setFormat(format);
            } else {
                CsvTableFileEditorProvider provider = CsvTableFileEditorProvider.getProvider();
                composite.addEditor((FileEditor)new CsvTableFileEditor(project, file, format), (FileEditorProvider)Objects.requireNonNull(provider));
            }
            fileEditorManagerEx.setSelectedEditor(file, PROVIDER_ID);
        }
    }

    @Nullable
    public static CsvTableFileEditorProvider getProvider() {
        return (CsvTableFileEditorProvider)FileEditorProviderManager.getInstance().getProvider(PROVIDER_ID);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4, 8, 12, 13 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 3: 
            case 7: 
            case 15: 
            case 16: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 4: 
            case 8: 
            case 12: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/editor/CsvTableFileEditorProvider";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sourceElement";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetElement";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "format";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/editor/CsvTableFileEditorProvider";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "createEditor";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "readState";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getPolicy";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "accept";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "createEditor";
                break;
            }
            case 4: 
            case 8: 
            case 12: 
            case 13: {
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "readState";
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "writeState";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "getFormatFast";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "isCsvFile";
                break;
            }
            case 17: 
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "openEditor";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4, 8, 12, 13 -> new IllegalStateException(string);
        };
    }
}

