/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.coverage;

import com.intellij.concurrency.ConcurrentCollectionFactory;
import com.intellij.coverage.BaseCoverageSuite;
import com.intellij.coverage.CoverageDataSuitesManager;
import com.intellij.coverage.CoverageDataSuitesManagerKt;
import com.intellij.coverage.CoverageEngine;
import com.intellij.coverage.CoverageFileProvider;
import com.intellij.coverage.CoverageRunner;
import com.intellij.coverage.CoverageSuite;
import com.intellij.execution.configurations.coverage.CoverageEnabledConfiguration;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.extensions.ExtensionPointListener;
import com.intellij.openapi.extensions.PluginDescriptor;
import com.intellij.openapi.project.Project;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@State(name="com.intellij.coverage.CoverageDataManagerImpl", storages={@Storage(value="$WORKSPACE_FILE$")})
@Service(value={Service.Level.PROJECT})
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\"\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\b\n\b\u0001\u0018\u0000 +2\b\u0012\u0004\u0012\u00020\u00020\u00012\u00020\u0003:\u0001+B\u000f\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0018\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\n2\b\u0010\u0013\u001a\u0004\u0018\u00010\u0014J(\u0010\u0015\u001a\u0004\u0018\u00010\n2\u0006\u0010\u0016\u001a\u00020\u00142\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cJ\u0010\u0010\u0010\u001a\u0004\u0018\u00010\n2\u0006\u0010\u001d\u001a\u00020\u001eJ\u000e\u0010\u001f\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\nJ\u000e\u0010 \u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\nJ\u0011\u0010!\u001a\b\u0012\u0004\u0012\u00020\n0\"\u00a2\u0006\u0002\u0010#J(\u0010$\u001a\u0004\u0018\u00010\n2\u0006\u0010%\u001a\u00020\u00142\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cJ\u0010\u0010&\u001a\u00020\u00112\u0006\u0010'\u001a\u00020\u0002H\u0016J\b\u0010(\u001a\u00020\u0002H\u0016J\u0012\u0010$\u001a\u0004\u0018\u00010\n2\u0006\u0010\u001d\u001a\u00020\u001eH\u0002J\b\u0010)\u001a\u00020\u0011H\u0002J\b\u0010*\u001a\u00020\u0011H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R@\u0010\b\u001a2\u0012\u000e\u0012\f0\n\u00a2\u0006\u0002\b\u000b\u00a2\u0006\u0002\b\f \u000e*\u0017\u0012\u000e\u0012\f0\n\u00a2\u0006\u0002\b\u000b\u00a2\u0006\u0002\b\f0\r\u00a2\u0006\u0002\b\f0\t\u00a2\u0006\u0002\b\fX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u000f\u00a8\u0006,"}, d2={"Lcom/intellij/coverage/CoverageDataSuitesManager;", "Lcom/intellij/openapi/components/PersistentStateComponent;", "Lorg/jdom/Element;", "Lcom/intellij/openapi/Disposable$Default;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "suites", "", "Lcom/intellij/coverage/CoverageSuite;", "Lkotlin/jvm/internal/EnhancedNullability;", "Lorg/jetbrains/annotations/NotNull;", "", "kotlin.jvm.PlatformType", "Ljava/util/Set;", "addSuite", "", "suite", "suiteToMergeWith", "", "addExternalCoverageSuite", "fileName", "runner", "Lcom/intellij/coverage/CoverageRunner;", "fileProvider", "Lcom/intellij/coverage/CoverageFileProvider;", "timestamp", "", "config", "Lcom/intellij/execution/configurations/coverage/CoverageEnabledConfiguration;", "deleteSuite", "removeSuite", "getSuites", "", "()[Lcom/intellij/coverage/CoverageSuite;", "createCoverageSuite", "name", "loadState", "element", "getState", "setUpRunnerEPRemovedCallback", "setUpEngineEPRemovedCallback", "Companion", "intellij.platform.coverage"})
@SourceDebugExtension(value={"SMAP\nCoverageDataSuitesManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CoverageDataSuitesManager.kt\ncom/intellij/coverage/CoverageDataSuitesManager\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,141:1\n1#2:142\n37#3,2:143\n774#4:145\n865#4,2:146\n774#4:148\n865#4,2:149\n*S KotlinDebug\n*F\n+ 1 CoverageDataSuitesManager.kt\ncom/intellij/coverage/CoverageDataSuitesManager\n*L\n71#1:143,2\n78#1:145\n78#1:146,2\n119#1:148\n119#1:149,2\n*E\n"})
public final class CoverageDataSuitesManager
implements PersistentStateComponent<Element>,
Disposable.Default {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    private final Set<CoverageSuite> suites;

    public CoverageDataSuitesManager(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
        Set set = ConcurrentCollectionFactory.createConcurrentSet();
        Intrinsics.checkNotNullExpressionValue((Object)set, (String)"createConcurrentSet(...)");
        this.suites = set;
        this.setUpRunnerEPRemovedCallback();
        this.setUpEngineEPRemovedCallback();
    }

    public final void addSuite(@NotNull CoverageSuite suite, @Nullable String suiteToMergeWith) {
        Intrinsics.checkNotNullParameter((Object)suite, (String)"suite");
        if (suiteToMergeWith == null || !Intrinsics.areEqual((Object)suite.getPresentableName(), (Object)suiteToMergeWith)) {
            this.deleteSuite(suite);
        }
        this.suites.remove(suite);
        this.suites.add(suite);
    }

    @Nullable
    public final CoverageSuite addExternalCoverageSuite(@NotNull String fileName, @NotNull CoverageRunner runner, @NotNull CoverageFileProvider fileProvider, long timestamp) {
        CoverageSuite coverageSuite;
        Intrinsics.checkNotNullParameter((Object)fileName, (String)"fileName");
        Intrinsics.checkNotNullParameter((Object)runner, (String)"runner");
        Intrinsics.checkNotNullParameter((Object)fileProvider, (String)"fileProvider");
        CoverageSuite coverageSuite2 = this.createCoverageSuite(fileName, runner, fileProvider, timestamp);
        if (coverageSuite2 != null) {
            CoverageSuite coverageSuite3;
            CoverageSuite it = coverageSuite3 = coverageSuite2;
            boolean bl = false;
            this.suites.add(it);
            coverageSuite = coverageSuite3;
        } else {
            coverageSuite = null;
        }
        return coverageSuite;
    }

    @Nullable
    public final CoverageSuite addSuite(@NotNull CoverageEnabledConfiguration config) {
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        CoverageSuite suite = this.createCoverageSuite(config);
        if (suite != null) {
            this.deleteSuite(suite);
            this.suites.add(suite);
        }
        return suite;
    }

    public final void deleteSuite(@NotNull CoverageSuite suite) {
        Intrinsics.checkNotNullParameter((Object)suite, (String)"suite");
        suite.deleteCachedCoverageData();
        this.removeSuite(suite);
    }

    public final void removeSuite(@NotNull CoverageSuite suite) {
        Intrinsics.checkNotNullParameter((Object)suite, (String)"suite");
        this.suites.remove(suite);
    }

    @NotNull
    public final CoverageSuite[] getSuites() {
        Collection $this$toTypedArray$iv = this.suites;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        return thisCollection$iv.toArray(new CoverageSuite[0]);
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final CoverageSuite createCoverageSuite(@NotNull String name, @NotNull CoverageRunner runner, @NotNull CoverageFileProvider fileProvider, long timestamp) {
        Object object;
        Iterable iterable;
        block3: {
            void $this$filterTo$iv$iv;
            void $this$filter$iv;
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Intrinsics.checkNotNullParameter((Object)runner, (String)"runner");
            Intrinsics.checkNotNullParameter((Object)fileProvider, (String)"fileProvider");
            iterable = CoverageEngine.EP_NAME.getExtensionList();
            boolean $i$f$filter = false;
            void var8_8 = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                CoverageEngine p0 = (CoverageEngine)element$iv$iv;
                boolean $i$f$createCoverageSuite$stub_for_inlining = false;
                boolean bl = false;
                if (!runner.acceptsCoverageEngine(p0)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            for (Object it : (Iterable)((List)destination$iv$iv)) {
                boolean bl = false;
                if ((it = ((CoverageEngine)it).createCoverageSuite(name, this.project, runner, fileProvider, timestamp)) == null) continue;
                object = it;
                break block3;
            }
            object = null;
        }
        Iterable it = iterable = object;
        boolean bl = false;
        if (it == null) {
            CoverageDataSuitesManagerKt.access$getLOG$p().error("Cannot create coverage suite for runner: " + runner.getPresentableName());
        }
        return iterable;
    }

    public void loadState(@NotNull Element element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        for (Element suiteElement : element.getChildren("SUITE")) {
            Object object;
            CoverageSuite coverageSuite;
            block5: {
                CoverageRunner coverageRunner;
                if (BaseCoverageSuite.readRunnerAttribute(suiteElement) == null) continue;
                for (CoverageEngine it : SequencesKt.filter((Sequence)CollectionsKt.asSequence((Iterable)CoverageEngine.EP_NAME.getExtensionList()), arg_0 -> CoverageDataSuitesManager.loadState$lambda$3(coverageRunner, arg_0))) {
                    boolean bl = false;
                    CoverageSuite coverageSuite2 = it.createEmptyCoverageSuite(coverageRunner);
                    if (coverageSuite2 == null) continue;
                    coverageSuite = coverageSuite2;
                    break block5;
                }
                coverageSuite = null;
            }
            if (coverageSuite == null) continue;
            CoverageSuite suite = coverageSuite;
            if (suite instanceof BaseCoverageSuite) {
                ((BaseCoverageSuite)suite).setProject(this.project);
            }
            try {
                suite.readExternal(suiteElement);
                object = this.suites.add(suite);
            }
            catch (NumberFormatException e) {
                object = Unit.INSTANCE;
            }
        }
    }

    @NotNull
    public Element getState() {
        Element element = new Element("state");
        Iterator<CoverageSuite> iterator = this.suites.iterator();
        while (iterator.hasNext()) {
            CoverageSuite coverageSuite;
            Intrinsics.checkNotNullExpressionValue((Object)iterator.next(), (String)"next(...)");
            Element suiteElement = new Element("SUITE");
            element.addContent(suiteElement);
            coverageSuite.writeExternal(suiteElement);
        }
        return element;
    }

    /*
     * WARNING - void declaration
     */
    private final CoverageSuite createCoverageSuite(CoverageEnabledConfiguration config) {
        Object object;
        Object object2;
        block2: {
            void $this$filterTo$iv$iv;
            Iterable $this$filter$iv = CoverageEngine.EP_NAME.getExtensionList();
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                CoverageEngine it = (CoverageEngine)element$iv$iv;
                boolean bl = false;
                if (!it.isApplicableTo(config.getConfiguration())) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            for (Object it : (Iterable)((List)destination$iv$iv)) {
                boolean bl = false;
                if ((it = ((CoverageEngine)it).createCoverageSuite(config)) == null) continue;
                object2 = it;
                break block2;
            }
            object2 = null;
        }
        Object it = object = object2;
        boolean bl = false;
        CoverageDataSuitesManagerKt.access$getLOG$p().assertTrue(it != null, (Object)("Cannot create coverage suite for run config: " + config.getClass().getName()));
        return object;
    }

    private final void setUpRunnerEPRemovedCallback() {
        CoverageRunner.EP_NAME.addExtensionPointListener((ExtensionPointListener)new ExtensionPointListener<CoverageRunner>(this){
            final /* synthetic */ CoverageDataSuitesManager this$0;
            {
                this.this$0 = $receiver;
            }

            public void extensionRemoved(CoverageRunner extension, PluginDescriptor pluginDescriptor) {
                Intrinsics.checkNotNullParameter((Object)extension, (String)"extension");
                Intrinsics.checkNotNullParameter((Object)pluginDescriptor, (String)"pluginDescriptor");
                CoverageDataSuitesManager.access$getSuites$p(this.this$0).removeIf(arg_0 -> setUpRunnerEPRemovedCallback.1.extensionRemoved$lambda$1(arg_0 -> setUpRunnerEPRemovedCallback.1.extensionRemoved$lambda$0(extension, arg_0), arg_0));
            }

            private static final boolean extensionRemoved$lambda$0(CoverageRunner $extension, CoverageSuite suite) {
                Intrinsics.checkNotNullParameter((Object)suite, (String)"suite");
                return suite.getRunner() == $extension;
            }

            private static final boolean extensionRemoved$lambda$1(Function1 $tmp0, Object p0) {
                return (Boolean)$tmp0.invoke(p0);
            }
        }, (Disposable)this);
    }

    private final void setUpEngineEPRemovedCallback() {
        CoverageEngine.EP_NAME.addExtensionPointListener((ExtensionPointListener)new ExtensionPointListener<CoverageEngine>(this){
            final /* synthetic */ CoverageDataSuitesManager this$0;
            {
                this.this$0 = $receiver;
            }

            public void extensionRemoved(CoverageEngine extension, PluginDescriptor pluginDescriptor) {
                Intrinsics.checkNotNullParameter((Object)extension, (String)"extension");
                Intrinsics.checkNotNullParameter((Object)pluginDescriptor, (String)"pluginDescriptor");
                CoverageDataSuitesManager.access$getSuites$p(this.this$0).removeIf(arg_0 -> setUpEngineEPRemovedCallback.1.extensionRemoved$lambda$1(arg_0 -> setUpEngineEPRemovedCallback.1.extensionRemoved$lambda$0(extension, arg_0), arg_0));
            }

            private static final boolean extensionRemoved$lambda$0(CoverageEngine $extension, CoverageSuite suite) {
                Intrinsics.checkNotNullParameter((Object)suite, (String)"suite");
                return suite.getCoverageEngine() == $extension;
            }

            private static final boolean extensionRemoved$lambda$1(Function1 $tmp0, Object p0) {
                return (Boolean)$tmp0.invoke(p0);
            }
        }, (Disposable)this);
    }

    private static final boolean loadState$lambda$3(CoverageRunner $coverageRunner, CoverageEngine it) {
        return $coverageRunner.acceptsCoverageEngine(it);
    }

    @JvmStatic
    @NotNull
    public static final CoverageDataSuitesManager getInstance(@NotNull Project project) {
        return Companion.getInstance(project);
    }

    public static final /* synthetic */ Set access$getSuites$p(CoverageDataSuitesManager $this) {
        return $this.suites;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0007\u00a8\u0006\b"}, d2={"Lcom/intellij/coverage/CoverageDataSuitesManager$Companion;", "", "<init>", "()V", "getInstance", "Lcom/intellij/coverage/CoverageDataSuitesManager;", "project", "Lcom/intellij/openapi/project/Project;", "intellij.platform.coverage"})
    @SourceDebugExtension(value={"SMAP\nCoverageDataSuitesManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CoverageDataSuitesManager.kt\ncom/intellij/coverage/CoverageDataSuitesManager$Companion\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n*L\n1#1,141:1\n31#2,2:142\n*S KotlinDebug\n*F\n+ 1 CoverageDataSuitesManager.kt\ncom/intellij/coverage/CoverageDataSuitesManager$Companion\n*L\n34#1:142,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final CoverageDataSuitesManager getInstance(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            ComponentManager $this$service$iv = (ComponentManager)project;
            boolean $i$f$service = false;
            Class<CoverageDataSuitesManager> serviceClass$iv = CoverageDataSuitesManager.class;
            Object object = $this$service$iv.getService(serviceClass$iv);
            if (object == null) {
                throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
            }
            return (CoverageDataSuitesManager)object;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

