/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.swagger.core.providers.httpClient.json;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.swagger.core.providers.httpClient.json.SwJsonSchema;
import com.intellij.swagger.core.providers.httpClient.json.SwSingleDefinition;
import java.io.IOException;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\b\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\u0006\u001a\u00020\u0007J\u0016\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000bJ\u0010\u0010\r\u001a\u00020\t2\u0006\u0010\u000e\u001a\u00020\u0001H\u0002J\u0010\u0010\u000f\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\u000bH\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/intellij/swagger/core/providers/httpClient/json/SwJsonMappingsFactory;", "", "<init>", "()V", "myMapper", "Lcom/fasterxml/jackson/databind/ObjectMapper;", "schemaRoot", "Lcom/fasterxml/jackson/databind/node/ObjectNode;", "definition", "Lcom/fasterxml/jackson/databind/JsonNode;", "name", "", "value", "readAsDynamicObject", "mapping", "readString", "intellij.swagger.core"})
@SourceDebugExtension(value={"SMAP\nSwJsonSchemaJacksonMappings.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SwJsonSchemaJacksonMappings.kt\ncom/intellij/swagger/core/providers/httpClient/json/SwJsonMappingsFactory\n+ 2 KtUtils.kt\ncom/intellij/util/KotlinUtils\n+ 3 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,73:1\n19#2:74\n24#3:75\n24#3:76\n*S KotlinDebug\n*F\n+ 1 SwJsonSchemaJacksonMappings.kt\ncom/intellij/swagger/core/providers/httpClient/json/SwJsonMappingsFactory\n*L\n25#1:74\n35#1:75\n45#1:76\n*E\n"})
public final class SwJsonMappingsFactory {
    @NotNull
    private final ObjectMapper myMapper = new ObjectMapper(new JsonFactory());

    @NotNull
    public final ObjectNode schemaRoot() {
        JsonNode jsonNode = this.readAsDynamicObject(new SwJsonSchema());
        Intrinsics.checkNotNull((Object)jsonNode, (String)"null cannot be cast to non-null type com.fasterxml.jackson.databind.node.ObjectNode");
        return (ObjectNode)jsonNode;
    }

    @NotNull
    public final JsonNode definition(@NotNull String name2, @NotNull String value) {
        JsonNode rootNode;
        block1: {
            Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            rootNode = this.readAsDynamicObject(new SwSingleDefinition(name2));
            JsonNode definitionNode = this.readString(value);
            JsonNode $this$asSafely$iv = rootNode.get("definitions");
            boolean $i$f$asSafely = false;
            JsonNode jsonNode = $this$asSafely$iv;
            if (!(jsonNode instanceof ObjectNode)) {
                jsonNode = null;
            }
            ObjectNode objectNode = (ObjectNode)jsonNode;
            if (objectNode == null) break block1;
            objectNode.set(name2, definitionNode);
        }
        return rootNode;
    }

    private final JsonNode readAsDynamicObject(Object mapping) {
        JsonNode jsonNode;
        try {
            String valueAsString = mapping instanceof String ? (String)mapping : this.myMapper.writeValueAsString(mapping);
            Intrinsics.checkNotNull((Object)valueAsString);
            jsonNode = this.readString(valueAsString);
        }
        catch (IOException exception) {
            SwJsonMappingsFactory $this$thisLogger$iv = this;
            boolean $i$f$thisLogger = false;
            Logger logger = Logger.getInstance(SwJsonMappingsFactory.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
            logger.warn("Unable to create dynamic schema object for mapping of type: " + mapping.getClass(), (Throwable)exception);
            jsonNode = (JsonNode)new ObjectNode(JsonNodeFactory.instance);
        }
        return jsonNode;
    }

    private final JsonNode readString(String value) {
        JsonNode jsonNode;
        try {
            jsonNode = this.myMapper.readTree(value);
        }
        catch (IOException exception) {
            SwJsonMappingsFactory $this$thisLogger$iv = this;
            boolean $i$f$thisLogger = false;
            Logger logger = Logger.getInstance(SwJsonMappingsFactory.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
            logger.warn("Unable to read schema from text", (Throwable)exception);
            jsonNode = (JsonNode)new ObjectNode(JsonNodeFactory.instance);
        }
        return jsonNode;
    }
}

