/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.swagger.core.ui;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.intellij.json.JsonFileType;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.swagger.core.ErrorType;
import com.intellij.swagger.core.SwJacksonObjectMapperFactoryKt;
import com.intellij.swagger.core.SwSpecificationType;
import com.intellij.swagger.core.SwaggerBundle;
import com.intellij.swagger.core.SwaggerFailure;
import com.intellij.swagger.core.SwaggerResult;
import com.intellij.swagger.core.SwaggerValidationError;
import com.intellij.swagger.core.model.SwObjectDefinitionUtilsKt;
import com.intellij.swagger.core.model.api.SwDefinition;
import com.intellij.swagger.core.model.specification.SwSpecificationFile;
import com.intellij.swagger.core.providers.SwJsonSchemaPatchUtils;
import com.intellij.swagger.core.traverser.SwTreeUtil;
import com.intellij.swagger.core.ui.NameMapping;
import com.intellij.swagger.core.ui.NameSuggester;
import com.intellij.swagger.core.ui.ReferenceData;
import com.intellij.swagger.core.ui.SpecificationData;
import com.intellij.swagger.core.ui.SpecificationReferenceValidationHelperKt;
import com.intellij.swagger.core.ui.ValidationData;
import com.intellij.util.containers.FactoryMap;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0098\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010$\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\u000b\n\u0002\b\u000b\b\u0000\u0018\u0000 V2\u00020\u0001:\u0001VB\u0011\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0014\u001a\u00020\u000b2\u0006\u0010\u0015\u001a\u00020\u000eH\u0002J3\u0010\u0016\u001a \u0012\u001c\u0012\u001a\u0012\u0004\u0012\u00020\b\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u00120\u00180\u00172\u0006\u0010\u0019\u001a\u00020\u001aH\u0000\u00a2\u0006\u0002\b\u001bJ\u001b\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\b0\u00172\u0006\u0010\u0019\u001a\u00020\u001aH\u0000\u00a2\u0006\u0002\b\u001dJ\u0016\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u001f0\u00172\u0006\u0010\u0019\u001a\u00020\u001aH\u0002J0\u0010 \u001a\u00020\b2\u0006\u0010!\u001a\u00020\b2\u0006\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020\u000e2\u000e\b\u0002\u0010%\u001a\b\u0012\u0004\u0012\u00020\b0&H\u0002J@\u0010'\u001a\u0004\u0018\u00010\u00102\u0006\u0010(\u001a\u00020\u00102\u0006\u0010)\u001a\u00020\u000e2\u0006\u0010\"\u001a\u00020#2\u0006\u0010*\u001a\u00020+2\n\b\u0002\u0010,\u001a\u0004\u0018\u00010\b2\b\b\u0002\u0010-\u001a\u00020\u0003H\u0002J:\u0010.\u001a\u0004\u0018\u00010\u00102\u0006\u0010-\u001a\u00020\u00032\u0006\u0010/\u001a\u0002002\u0006\u00101\u001a\u00020\b2\u0006\u0010)\u001a\u00020\u000e2\u0006\u00102\u001a\u00020\b2\u0006\u0010*\u001a\u00020+H\u0002J\u0018\u00103\u001a\u0002042\u0006\u00105\u001a\u00020\b2\u0006\u00106\u001a\u00020\tH\u0002J\u001a\u00107\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0015\u001a\u00020\u000e2\u0006\u00108\u001a\u000209H\u0002J\u001e\u0010:\u001a\b\u0012\u0004\u0012\u00020\b0\u00172\u0006\u0010;\u001a\u00020\b2\u0006\u0010)\u001a\u00020\u001aH\u0002J\u001e\u0010<\u001a\b\u0012\u0004\u0012\u00020\b0\u00172\u0006\u0010!\u001a\u00020\b2\u0006\u0010)\u001a\u00020\u001aH\u0002J#\u0010=\u001a\b\u0012\u0004\u0012\u00020\b0\u00172\u0006\u0010!\u001a\u00020\b2\u0006\u0010)\u001a\u00020\u001aH\u0000\u00a2\u0006\u0002\b>J\u0016\u0010?\u001a\b\u0012\u0004\u0012\u00020\b0@2\u0006\u0010A\u001a\u00020\bH\u0002J\u001a\u0010B\u001a\u0004\u0018\u0001002\u0006\u00101\u001a\u00020\b2\u0006\u0010)\u001a\u00020\u000eH\u0002J\u001e\u0010C\u001a\u0010\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\b\u0018\u00010\u00182\u0006\u0010D\u001a\u00020\bH\u0002J\u001a\u0010E\u001a\u0004\u0018\u00010\u000e2\u0006\u0010F\u001a\u00020\b2\u0006\u0010)\u001a\u00020\u000eH\u0002J\u001a\u0010G\u001a\u0004\u0018\u00010\u000e2\u0006\u0010H\u001a\u00020\u000e2\u0006\u0010I\u001a\u00020\bH\u0002J0\u0010J\u001a\u00020\b2\u0006\u0010A\u001a\u00020\b2\u0006\u0010\"\u001a\u00020#2\u0006\u0010K\u001a\u00020L2\u0006\u0010*\u001a\u00020+2\u0006\u0010)\u001a\u00020\u000eH\u0002J\u0010\u0010M\u001a\u00020L2\u0006\u0010N\u001a\u00020\bH\u0002J \u0010O\u001a\u00020\u00102\u0006\u0010P\u001a\u00020\u00102\u0006\u0010\"\u001a\u00020#2\u0006\u0010-\u001a\u00020\u0003H\u0002J\u0018\u0010Q\u001a\u00020\u00102\u0006\u0010P\u001a\u00020\u00102\u0006\u0010\"\u001a\u00020#H\u0002J(\u0010R\u001a\u00020\b2\u0006\u0010N\u001a\u00020\b2\u0006\u0010\"\u001a\u00020#2\u0006\u0010*\u001a\u00020+2\u0006\u0010)\u001a\u00020\u000eH\u0002J \u0010S\u001a\u00020\u00102\u0016\b\u0002\u0010T\u001a\u0010\u0012\u0004\u0012\u00020\b\u0012\u0006\u0012\u0004\u0018\u00010\u00100\u0007H\u0002J\u0010\u0010U\u001a\u00020\b2\u0006\u0010!\u001a\u00020\bH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000RX\u0010\r\u001aJ\u0012\f\u0012\n \u000f*\u0004\u0018\u00010\u000e0\u000e\u0012\f\u0012\n \u000f*\u0004\u0018\u00010\u00100\u0010 \u000f*#\u0012\f\u0012\n \u000f*\u0004\u0018\u00010\u000e0\u000e\u0012\f\u0012\n \u000f*\u0004\u0018\u00010\u00100\u00100\u0012\u00a2\u0006\u0002\b\u00110\u0007\u00a2\u0006\u0002\b\u0011X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0013\u00a8\u0006W"}, d2={"Lcom/intellij/swagger/core/ui/SpecificationReferencesInlineHelper;", "", "inlineDepthLimit", "", "<init>", "(I)V", "unresolvedReferences", "", "", "Lcom/intellij/swagger/core/ui/ValidationData;", "jsonObjectMapper", "Lcom/fasterxml/jackson/databind/ObjectMapper;", "yamlObjectMapper", "jsonFilesCache", "Lcom/intellij/openapi/vfs/VirtualFile;", "kotlin.jvm.PlatformType", "Lcom/fasterxml/jackson/databind/JsonNode;", "Lorg/jetbrains/annotations/NotNull;", "", "Ljava/util/Map;", "suitableMapperFor", "file", "prepareSpecificationTextWithValidation", "Lcom/intellij/swagger/core/SwaggerResult;", "Lkotlin/Pair;", "psiFile", "Lcom/intellij/psi/PsiFile;", "prepareSpecificationTextWithValidation$intellij_swagger_core", "prepareSpecificationText", "prepareSpecificationText$intellij_swagger_core", "readDataFromSpecification", "Lcom/intellij/swagger/core/ui/SpecificationData;", "inlineExternalDefinitions", "specificationText", "specificationType", "Lcom/intellij/swagger/core/SwSpecificationType;", "topLevelSpecificationFile", "knownDefinitionNames", "", "inlineDefinitionsWithDepth", "jsonNode", "containingFile", "nameSuggester", "Lcom/intellij/swagger/core/ui/NameSuggester;", "rootReference", "depth", "getObjectDefinition", "refData", "Lcom/intellij/swagger/core/ui/ReferenceData;", "originalReferenceValue", "rootReferenceName", "putToUnresolved", "", "referenceName", "validationData", "readObjectDefinition", "nameMapping", "Lcom/intellij/swagger/core/ui/NameMapping;", "convertToJsonIfNeeded", "rawFileText", "convertYamlToJson", "convertJsonToYaml", "convertJsonToYaml$intellij_swagger_core", "findAllReferences", "Lkotlin/sequences/Sequence;", "jsonSpecification", "collectReferenceData", "splitReference", "value", "findReferencedFile", "filePath", "resolveRelativeFilePath", "specification", "relativePath", "substituteExternalReferences", "substituteLocalReferences", "", "isLocalReference", "referenceBody", "wrapDefinitionIfNeeded", "definitionsNode", "wrapDefinitions", "suggestInlinedObjectPath", "createJsonNode", "children", "escapeIllegalCharacters", "Companion", "intellij.swagger.core"})
@SourceDebugExtension(value={"SMAP\nSpecificationReferencesInlineHelper.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SpecificationReferencesInlineHelper.kt\ncom/intellij/swagger/core/ui/SpecificationReferencesInlineHelper\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n+ 3 SwTreeUtil.kt\ncom/intellij/swagger/core/traverser/SwTreeUtil\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 5 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 6 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,379:1\n24#2:380\n24#2:387\n14#2:397\n24#2:399\n24#2:400\n14#2:401\n14#2:402\n35#3,2:381\n1557#4:383\n1628#4,3:384\n1797#4,2:395\n1799#4:398\n2284#5,7:388\n1#6:403\n*S KotlinDebug\n*F\n+ 1 SpecificationReferencesInlineHelper.kt\ncom/intellij/swagger/core/ui/SpecificationReferencesInlineHelper\n*L\n87#1:380\n139#1:387\n224#1:397\n244#1:399\n255#1:400\n289#1:401\n45#1:402\n94#1:381,2\n105#1:383\n105#1:384,3\n222#1:395,2\n222#1:398\n170#1:388,7\n*E\n"})
public final class SpecificationReferencesInlineHelper {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final int inlineDepthLimit;
    @NotNull
    private final Map<String, ValidationData> unresolvedReferences;
    @NotNull
    private final ObjectMapper jsonObjectMapper;
    @NotNull
    private final ObjectMapper yamlObjectMapper;
    @NotNull
    private final Map<VirtualFile, JsonNode> jsonFilesCache;
    private static final int MAXIMUM_INLINE_DEPTH = 10;
    @NotNull
    private static final Regex REFERENCE_PATTERN = new Regex("\"\\$ref\"\\s*:\\s*\"([^\"]*)\"");
    private static final int REFERENCE_BODY_GROUP_INDEX = 1;
    @NotNull
    private static final Regex REFERENCE_STRUCTURE_PATTERN = new Regex("(.*)#/(.*)");
    private static final int EXTERNAL_FILE_GROUP_INDEX = 1;
    private static final int DEFINITION_PATH_GROUP_INDEX = 2;

    public SpecificationReferencesInlineHelper(int inlineDepthLimit) {
        this.inlineDepthLimit = inlineDepthLimit;
        this.unresolvedReferences = new LinkedHashMap();
        this.jsonObjectMapper = SwJacksonObjectMapperFactoryKt.createJsonJacksonMapper();
        this.yamlObjectMapper = SwJacksonObjectMapperFactoryKt.createYamlJacksonMapper();
        Map map2 = FactoryMap.create(arg_0 -> SpecificationReferencesInlineHelper.jsonFilesCache$lambda$1(arg_0 -> SpecificationReferencesInlineHelper.jsonFilesCache$lambda$0(this, arg_0), arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)map2, (String)"create(...)");
        this.jsonFilesCache = map2;
    }

    public /* synthetic */ SpecificationReferencesInlineHelper(int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 1) != 0) {
            n = 10;
        }
        this(n);
    }

    private final ObjectMapper suitableMapperFor(VirtualFile file) {
        return file.getFileType() instanceof JsonFileType ? this.jsonObjectMapper : this.yamlObjectMapper;
    }

    @NotNull
    public final SwaggerResult<Pair<String, Map<String, ValidationData>>> prepareSpecificationTextWithValidation$intellij_swagger_core(@NotNull PsiFile psiFile) {
        Intrinsics.checkNotNullParameter((Object)psiFile, (String)"psiFile");
        SwaggerResult<String> specificationResult = this.prepareSpecificationText$intellij_swagger_core(psiFile);
        if (specificationResult.isFailure()) {
            SwaggerFailure swaggerFailure = specificationResult.getSwaggerFailure();
            Intrinsics.checkNotNull((Object)swaggerFailure);
            return SwaggerResult.Companion.failure(swaggerFailure);
        }
        String string = specificationResult.getSuccess();
        Intrinsics.checkNotNull((Object)string);
        return SwaggerResult.Companion.success(TuplesKt.to((Object)string, this.unresolvedReferences));
    }

    @NotNull
    public final SwaggerResult<String> prepareSpecificationText$intellij_swagger_core(@NotNull PsiFile psiFile) {
        String string;
        Intrinsics.checkNotNullParameter((Object)psiFile, (String)"psiFile");
        ProgressManager.checkCanceled();
        Object object = ReadAction.nonBlocking(() -> SpecificationReferencesInlineHelper.prepareSpecificationText$lambda$2(this, psiFile)).withDocumentsCommitted(psiFile.getProject()).executeSynchronously();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"executeSynchronously(...)");
        SwaggerResult result2 = (SwaggerResult)object;
        if (result2.isFailure()) {
            return SwaggerResult.Companion.failure(result2.getFailureOrThrow());
        }
        SpecificationData specificationData = (SpecificationData)result2.getSuccessOrThrow();
        SwSpecificationType specificationType = specificationData.component1();
        Collection<String> ownDefinitionNames = specificationData.component2();
        String specificationText = specificationData.component3();
        SwaggerResult<String> specificationTextJson = this.convertToJsonIfNeeded(specificationText, psiFile);
        if (specificationTextJson.isFailure()) {
            return SwaggerResult.Companion.failure(specificationTextJson.getFailureOrThrow());
        }
        String jsonText = specificationTextJson.getSuccessOrThrow();
        try {
            VirtualFile virtualFile = psiFile.getVirtualFile();
            Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"getVirtualFile(...)");
            string = this.inlineExternalDefinitions(jsonText, specificationType, virtualFile, ownDefinitionNames);
        }
        catch (IOException exception) {
            SpecificationReferencesInlineHelper $this$thisLogger$iv = this;
            boolean $i$f$thisLogger = false;
            Logger logger = Logger.getInstance(SpecificationReferencesInlineHelper.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
            logger.warn("Unable to inline external object definitions. Using raw specification.", (Throwable)exception);
            string = jsonText;
        }
        String specificationWithInlinedDefinitions = string;
        return SwaggerResult.Companion.success(this.escapeIllegalCharacters(specificationWithInlinedDefinitions));
    }

    /*
     * WARNING - void declaration
     */
    private final SwaggerResult<SpecificationData> readDataFromSpecification(PsiFile psiFile) {
        Collection<String> collection;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Object[] $this$iv = SwTreeUtil.INSTANCE;
        boolean withSelf$iv = true;
        boolean $i$f$getParentOfType22 = false;
        SwSpecificationFile specificationModel = $this$iv.getParentOfType((PsiElement)psiFile, SwSpecificationFile.class, withSelf$iv);
        if (specificationModel == null) {
            $this$iv = new Object[]{psiFile.getName()};
            return SwaggerResult.Companion.failure$default(SwaggerResult.Companion, ErrorType.UNABLE_TO_CONVERT, SwaggerBundle.message("preview.error.unable.build.specification.model", $this$iv), null, 4, null);
        }
        $this$iv = specificationModel.getAllLocalObjectDefinitions();
        SwSpecificationType swSpecificationType = specificationModel.getSpecificationType();
        SwaggerResult.Companion companion = SwaggerResult.Companion;
        boolean $i$f$map = false;
        void $i$f$getParentOfType22 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            SwDefinition swDefinition = (SwDefinition)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getName().getValue());
        }
        collection = (List)destination$iv$iv;
        Collection collection2 = collection;
        String string = psiFile.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
        String string2 = string;
        Collection collection3 = collection2;
        SwSpecificationType swSpecificationType2 = swSpecificationType;
        return companion.success(new SpecificationData(swSpecificationType2, collection3, string2));
    }

    private final String inlineExternalDefinitions(String specificationText, SwSpecificationType specificationType, VirtualFile topLevelSpecificationFile, Collection<String> knownDefinitionNames) {
        JsonNode jsonSpecificationRoot = this.suitableMapperFor(topLevelSpecificationFile).readTree(specificationText);
        Intrinsics.checkNotNull((Object)jsonSpecificationRoot);
        JsonNode jsonNode = SpecificationReferencesInlineHelper.inlineDefinitionsWithDepth$default(this, jsonSpecificationRoot, topLevelSpecificationFile, specificationType, new NameSuggester(knownDefinitionNames, topLevelSpecificationFile), null, 0, 48, null);
        if (jsonNode == null) {
            return specificationText;
        }
        JsonNode specificationTree = jsonNode;
        String string = this.jsonObjectMapper.writerWithDefaultPrettyPrinter().writeValueAsString((Object)specificationTree);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"writeValueAsString(...)");
        return string;
    }

    static /* synthetic */ String inlineExternalDefinitions$default(SpecificationReferencesInlineHelper specificationReferencesInlineHelper, String string, SwSpecificationType swSpecificationType, VirtualFile virtualFile, Collection collection, int n, Object object) {
        if ((n & 8) != 0) {
            collection = SetsKt.emptySet();
        }
        return specificationReferencesInlineHelper.inlineExternalDefinitions(string, swSpecificationType, virtualFile, collection);
    }

    /*
     * WARNING - void declaration
     */
    private final JsonNode inlineDefinitionsWithDepth(JsonNode jsonNode, VirtualFile containingFile, SwSpecificationType specificationType, NameSuggester nameSuggester, String rootReference, int depth) {
        JsonNode jsonNode2;
        Object v2;
        void $this$reduceOrNull$iv;
        ProgressManager.checkCanceled();
        if (depth >= this.inlineDepthLimit) {
            SpecificationReferencesInlineHelper $this$thisLogger$iv = this;
            boolean $i$f$thisLogger = false;
            Logger logger = Logger.getInstance(SpecificationReferencesInlineHelper.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
            logger.warn("Inline depth limit was reached for: " + containingFile.getName());
            String string = rootReference;
            if (string != null) {
                String it = string;
                boolean bl = false;
                this.unresolvedReferences.put(it, new ValidationData(SwaggerBundle.message("preview.error.validation.limit.reached", new Object[0]), containingFile, it));
            }
            return jsonNode;
        }
        String effectiveJsonAsString = this.jsonObjectMapper.writerWithDefaultPrettyPrinter().writeValueAsString((Object)jsonNode);
        Intrinsics.checkNotNull((Object)effectiveJsonAsString);
        Sequence bl = SequencesKt.mapNotNull(this.findAllReferences(effectiveJsonAsString), arg_0 -> SpecificationReferencesInlineHelper.inlineDefinitionsWithDepth$lambda$5(this, containingFile, rootReference, depth, nameSuggester, specificationType, arg_0));
        boolean $i$f$reduceOrNull = false;
        Iterator iterator$iv = $this$reduceOrNull$iv.iterator();
        if (!iterator$iv.hasNext()) {
            v2 = null;
        } else {
            Object accumulator$iv = iterator$iv.next();
            while (iterator$iv.hasNext()) {
                void patch;
                JsonNode jsonNode3 = (JsonNode)iterator$iv.next();
                JsonNode targetSchema = (JsonNode)accumulator$iv;
                boolean bl2 = false;
                accumulator$iv = SwJsonSchemaPatchUtils.INSTANCE.mergeTrees(targetSchema, (JsonNode)patch, true);
            }
            v2 = accumulator$iv;
        }
        JsonNode allExternalDefinitions = v2;
        JsonNode targetJsonRootNode = this.jsonObjectMapper.readTree(this.substituteExternalReferences(effectiveJsonAsString, specificationType, depth > 0, nameSuggester, containingFile));
        if (allExternalDefinitions == null) {
            jsonNode2 = targetJsonRootNode;
        } else {
            Intrinsics.checkNotNull((Object)targetJsonRootNode);
            jsonNode2 = SwJsonSchemaPatchUtils.INSTANCE.mergeTrees(targetJsonRootNode, this.wrapDefinitionIfNeeded(allExternalDefinitions, specificationType, depth), true);
        }
        return jsonNode2;
    }

    static /* synthetic */ JsonNode inlineDefinitionsWithDepth$default(SpecificationReferencesInlineHelper specificationReferencesInlineHelper, JsonNode jsonNode, VirtualFile virtualFile, SwSpecificationType swSpecificationType, NameSuggester nameSuggester, String string, int n, int n2, Object object) {
        if ((n2 & 0x10) != 0) {
            string = null;
        }
        if ((n2 & 0x20) != 0) {
            n = 0;
        }
        return specificationReferencesInlineHelper.inlineDefinitionsWithDepth(jsonNode, virtualFile, swSpecificationType, nameSuggester, string, n);
    }

    private final JsonNode getObjectDefinition(int depth, ReferenceData refData, String originalReferenceValue, VirtualFile containingFile, String rootReferenceName, NameSuggester nameSuggester) {
        JsonNode definition;
        boolean isFromTopLevelSpecification = depth == 0 && Intrinsics.areEqual((Object)refData.getTargetFile(), (Object)containingFile);
        NameMapping nameMapping = nameSuggester.createNameMapping$intellij_swagger_core(refData);
        if (((CharSequence)nameMapping.getOriginalPath()).length() == 0 && Intrinsics.areEqual((Object)refData.getTargetFile(), (Object)containingFile)) {
            this.putToUnresolved(rootReferenceName, new ValidationData(SwaggerBundle.message("preview.error.validation.unknown.reference", new Object[0]), containingFile, originalReferenceValue));
        }
        if ((definition = this.readObjectDefinition(refData.getTargetFile(), nameMapping)) == null) {
            this.putToUnresolved(rootReferenceName, new ValidationData(SwaggerBundle.message("preview.error.validation.unknown.reference", new Object[0]), containingFile, originalReferenceValue));
            return null;
        }
        return isFromTopLevelSpecification ? null : definition;
    }

    private final void putToUnresolved(String referenceName, ValidationData validationData) {
        if (((CharSequence)referenceName).length() == 0) {
            return;
        }
        this.unresolvedReferences.put(referenceName, validationData);
    }

    /*
     * WARNING - void declaration
     */
    private final JsonNode readObjectDefinition(VirtualFile file, NameMapping nameMapping) {
        JsonNode jsonNode = this.jsonFilesCache.get(file);
        if (jsonNode == null) {
            return null;
        }
        JsonNode node = jsonNode;
        if (((CharSequence)nameMapping.getOriginalPath()).length() == 0) {
            Pair[] pairArray = new Pair[]{TuplesKt.to((Object)nameMapping.getUniqueName(), (Object)node)};
            return this.createJsonNode(MapsKt.mutableMapOf((Pair[])pairArray));
        }
        Iterable $this$fold$iv = nameMapping.getOriginalPathSegments();
        boolean $i$f$fold = false;
        JsonNode accumulator$iv = node;
        for (Object element$iv : $this$fold$iv) {
            void pathSegment;
            String string = (String)element$iv;
            JsonNode currentNode = accumulator$iv;
            boolean bl = false;
            if (currentNode.get(SwObjectDefinitionUtilsKt.unescapeSpecialSymbols((String)pathSegment)) != null) continue;
            SpecificationReferencesInlineHelper $this$readObjectDefinition_u24lambda_u248_u24lambda_u247 = this;
            boolean bl2 = false;
            boolean $i$f$logger = false;
            Logger logger = Logger.getInstance(SpecificationReferencesInlineHelper.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
            logger.debug("Unable to resolve node " + nameMapping.getOriginalName() + " inside file " + file.getName());
            return null;
        }
        JsonNode foundDefinition = accumulator$iv;
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)SwObjectDefinitionUtilsKt.unescapeSpecialSymbols(nameMapping.getUniqueName()), (Object)foundDefinition)};
        return this.createJsonNode(MapsKt.mutableMapOf((Pair[])pairArray));
    }

    private final SwaggerResult<String> convertToJsonIfNeeded(String rawFileText, PsiFile containingFile) {
        return containingFile.getFileType() instanceof JsonFileType ? SwaggerResult.Companion.success(rawFileText) : this.convertYamlToJson(rawFileText, containingFile);
    }

    private final SwaggerResult<String> convertYamlToJson(String specificationText, PsiFile containingFile) {
        SwaggerResult<String> swaggerResult;
        try {
            Object yamlTree = this.yamlObjectMapper.readValue(specificationText, Object.class);
            swaggerResult = SwaggerResult.Companion.success(this.jsonObjectMapper.writerWithDefaultPrettyPrinter().writeValueAsString(yamlTree));
        }
        catch (JsonProcessingException exception) {
            SpecificationReferencesInlineHelper $this$thisLogger$iv = this;
            boolean $i$f$thisLogger = false;
            Logger logger = Logger.getInstance(SpecificationReferencesInlineHelper.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
            logger.warn("Unable to convert yaml specification to json format", (Throwable)exception);
            SwaggerValidationError validationError = SpecificationReferenceValidationHelperKt.generateValidationError(exception, containingFile);
            swaggerResult = SwaggerResult.Companion.failure(SpecificationReferenceValidationHelperKt.swaggerValidationFailure(containingFile, CollectionsKt.listOf((Object)validationError)));
        }
        return swaggerResult;
    }

    @NotNull
    public final SwaggerResult<String> convertJsonToYaml$intellij_swagger_core(@NotNull String specificationText, @NotNull PsiFile containingFile) {
        SwaggerResult<String> swaggerResult;
        Intrinsics.checkNotNullParameter((Object)specificationText, (String)"specificationText");
        Intrinsics.checkNotNullParameter((Object)containingFile, (String)"containingFile");
        try {
            JsonNode jsonTree = this.jsonObjectMapper.readTree(specificationText);
            swaggerResult = SwaggerResult.Companion.success(this.yamlObjectMapper.writerWithDefaultPrettyPrinter().writeValueAsString((Object)jsonTree));
        }
        catch (JsonProcessingException exception) {
            SpecificationReferencesInlineHelper $this$thisLogger$iv = this;
            boolean $i$f$thisLogger = false;
            Logger logger = Logger.getInstance(SpecificationReferencesInlineHelper.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
            logger.warn("Unable to convert json specification to yaml format", (Throwable)exception);
            SwaggerValidationError validationError = SpecificationReferenceValidationHelperKt.generateValidationError(exception, containingFile);
            swaggerResult = SwaggerResult.Companion.failure(SpecificationReferenceValidationHelperKt.swaggerValidationFailure(containingFile, CollectionsKt.listOf((Object)validationError)));
        }
        return swaggerResult;
    }

    private final Sequence<String> findAllReferences(String jsonSpecification) {
        return SequencesKt.distinct((Sequence)SequencesKt.mapNotNull((Sequence)Regex.findAll$default((Regex)REFERENCE_PATTERN, (CharSequence)jsonSpecification, (int)0, (int)2, null), SpecificationReferencesInlineHelper::findAllReferences$lambda$10));
    }

    private final ReferenceData collectReferenceData(String originalReferenceValue, VirtualFile containingFile) {
        Pair<String, String> pair = this.splitReference(originalReferenceValue);
        if (pair == null) {
            return null;
        }
        Pair<String, String> pair2 = pair;
        String filePath = (String)pair2.component1();
        String objectPath = (String)pair2.component2();
        VirtualFile virtualFile = this.findReferencedFile(filePath, containingFile);
        if (virtualFile == null) {
            return null;
        }
        VirtualFile targetFile = virtualFile;
        return new ReferenceData(targetFile, objectPath);
    }

    private final Pair<String, String> splitReference(String value) {
        MatchResult matchResult = REFERENCE_STRUCTURE_PATTERN.matchEntire((CharSequence)value);
        if (matchResult == null) {
            return TuplesKt.to((Object)value, (Object)"");
        }
        MatchResult matchEntire = matchResult;
        return matchEntire.getGroups().size() < 2 ? null : TuplesKt.to(matchEntire.getGroupValues().get(1), matchEntire.getGroupValues().get(2));
    }

    private final VirtualFile findReferencedFile(String filePath, VirtualFile containingFile) {
        VirtualFile targetFile;
        VirtualFile virtualFile = targetFile = ((CharSequence)filePath).length() > 0 ? this.resolveRelativeFilePath(containingFile, filePath) : containingFile;
        if (targetFile == null || targetFile.isDirectory()) {
            boolean $i$f$logger = false;
            Logger logger = Logger.getInstance(SpecificationReferencesInlineHelper.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
            logger.warn("Unable to resolve external reference because specified file is not found: " + filePath);
            return null;
        }
        return targetFile;
    }

    private final VirtualFile resolveRelativeFilePath(VirtualFile specification, String relativePath) {
        VirtualFile virtualFile = specification.getParent();
        return virtualFile != null ? virtualFile.findFileByRelativePath(relativePath) : null;
    }

    private final String substituteExternalReferences(String jsonSpecification, SwSpecificationType specificationType, boolean substituteLocalReferences, NameSuggester nameSuggester, VirtualFile containingFile) {
        CharSequence charSequence = jsonSpecification;
        Regex regex = REFERENCE_PATTERN;
        Function1 function1 = arg_0 -> SpecificationReferencesInlineHelper.substituteExternalReferences$lambda$11(substituteLocalReferences, this, specificationType, nameSuggester, containingFile, arg_0);
        return regex.replace(charSequence, function1);
    }

    private final boolean isLocalReference(String referenceBody) {
        return StringsKt.startsWith$default((String)referenceBody, (String)"#/", (boolean)false, (int)2, null);
    }

    private final JsonNode wrapDefinitionIfNeeded(JsonNode definitionsNode, SwSpecificationType specificationType, int depth) {
        return depth == 0 ? this.wrapDefinitions(definitionsNode, specificationType) : definitionsNode;
    }

    private final JsonNode wrapDefinitions(JsonNode definitionsNode, SwSpecificationType specificationType) {
        JsonNode jsonNode;
        SwSpecificationType swSpecificationType = specificationType;
        if (swSpecificationType instanceof SwSpecificationType.Swagger2Family) {
            Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"definitions", (Object)definitionsNode)};
            jsonNode = this.createJsonNode(MapsKt.mutableMapOf((Pair[])pairArray));
        } else if (swSpecificationType instanceof SwSpecificationType.OpenAPI3Family || swSpecificationType instanceof SwSpecificationType.AsyncAPIFamily) {
            Pair[] pairArray = new Pair[1];
            Pair[] pairArray2 = new Pair[]{TuplesKt.to((Object)"schemas", (Object)definitionsNode)};
            pairArray[0] = TuplesKt.to((Object)"components", (Object)this.createJsonNode(MapsKt.mutableMapOf((Pair[])pairArray2)));
            jsonNode = this.createJsonNode(MapsKt.mutableMapOf((Pair[])pairArray));
        } else {
            throw new IllegalArgumentException("There is no object definitions storage template for specification type: " + specificationType);
        }
        return jsonNode;
    }

    private final String suggestInlinedObjectPath(String referenceBody, SwSpecificationType specificationType, NameSuggester nameSuggester, VirtualFile containingFile) {
        NameMapping nameMapping = nameSuggester.getNameForReference$intellij_swagger_core(this.collectReferenceData(referenceBody, containingFile));
        String uniqueName = nameMapping != null ? nameMapping.getUniqueName() : null;
        CharSequence charSequence = uniqueName;
        return charSequence == null || charSequence.length() == 0 ? "\"$ref\": \"" + referenceBody + "\"" : (specificationType instanceof SwSpecificationType.Swagger2Family ? "\"$ref\": \"#/definitions/" + uniqueName + "\"" : (specificationType instanceof SwSpecificationType.OpenAPI3Family || specificationType instanceof SwSpecificationType.AsyncAPIFamily ? "\"$ref\": \"#/components/schemas/" + uniqueName + "\"" : "\"$ref\": \"" + referenceBody + "\""));
    }

    private final JsonNode createJsonNode(Map<String, JsonNode> children) {
        return (JsonNode)new ObjectNode(this.jsonObjectMapper.getNodeFactory(), children);
    }

    static /* synthetic */ JsonNode createJsonNode$default(SpecificationReferencesInlineHelper specificationReferencesInlineHelper, Map map2, int n, Object object) {
        if ((n & 1) != 0) {
            map2 = new LinkedHashMap();
        }
        return specificationReferencesInlineHelper.createJsonNode(map2);
    }

    private final String escapeIllegalCharacters(String specificationText) {
        return StringsKt.replace$default((String)specificationText, (String)"</", (String)"<\\/", (boolean)false, (int)4, null);
    }

    private static final JsonNode jsonFilesCache$lambda$0(SpecificationReferencesInlineHelper this$0, VirtualFile it) {
        JsonNode jsonNode;
        try {
            Intrinsics.checkNotNull((Object)it);
            jsonNode = this$0.suitableMapperFor(it).readTree(it.getInputStream());
        }
        catch (IOException exception) {
            boolean $i$f$logger = false;
            Logger logger = Logger.getInstance(SpecificationReferencesInlineHelper.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
            logger.warn("Unable to parse external file with object definitions: " + it.getName(), (Throwable)exception);
            jsonNode = null;
        }
        return jsonNode;
    }

    private static final JsonNode jsonFilesCache$lambda$1(Function1 $tmp0, Object p0) {
        return (JsonNode)$tmp0.invoke(p0);
    }

    private static final SwaggerResult prepareSpecificationText$lambda$2(SpecificationReferencesInlineHelper this$0, PsiFile $psiFile) {
        return this$0.readDataFromSpecification($psiFile);
    }

    private static final JsonNode inlineDefinitionsWithDepth$lambda$5(SpecificationReferencesInlineHelper this$0, VirtualFile $containingFile, String $rootReference, int $depth, NameSuggester $nameSuggester, SwSpecificationType $specificationType, String referenceName) {
        String rootReferenceValue;
        Intrinsics.checkNotNullParameter((Object)referenceName, (String)"referenceName");
        ReferenceData referenceData = this$0.collectReferenceData(referenceName, $containingFile);
        String string = $rootReference;
        if (string == null) {
            string = rootReferenceValue = referenceName;
        }
        if (referenceData == null) {
            if (!StringsKt.startsWith$default((String)referenceName, (String)"http", (boolean)false, (int)2, null)) {
                this$0.putToUnresolved(rootReferenceValue, new ValidationData(SwaggerBundle.message("preview.error.validation.unknown.reference", new Object[0]), $containingFile, referenceName));
            }
            return null;
        }
        JsonNode jsonNode = this$0.getObjectDefinition($depth, referenceData, referenceName, $containingFile, rootReferenceValue, $nameSuggester);
        if (jsonNode == null) {
            return null;
        }
        JsonNode definition = jsonNode;
        return this$0.inlineDefinitionsWithDepth(definition, referenceData.getTargetFile(), $specificationType, $nameSuggester, rootReferenceValue, $depth + 1);
    }

    private static final String findAllReferences$lambda$10(MatchResult matchResult) {
        List list;
        Intrinsics.checkNotNullParameter((Object)matchResult, (String)"matchResult");
        List values = list = matchResult.getGroupValues();
        boolean bl = false;
        List list2 = values.size() >= 1 ? list : null;
        return list2 != null ? (String)list2.get(1) : null;
    }

    private static final CharSequence substituteExternalReferences$lambda$11(boolean $substituteLocalReferences, SpecificationReferencesInlineHelper this$0, SwSpecificationType $specificationType, NameSuggester $nameSuggester, VirtualFile $containingFile, MatchResult it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        if (it.getGroups().size() < 1) {
            return it.getValue();
        }
        String referenceBody = (String)it.getGroupValues().get(1);
        if (((CharSequence)referenceBody).length() == 0 || !$substituteLocalReferences && this$0.isLocalReference(referenceBody)) {
            return it.getValue();
        }
        return this$0.suggestInlinedObjectPath(referenceBody, $specificationType, $nameSuggester, $containingFile);
    }

    public SpecificationReferencesInlineHelper() {
        this(0, 1, null);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lcom/intellij/swagger/core/ui/SpecificationReferencesInlineHelper$Companion;", "", "<init>", "()V", "MAXIMUM_INLINE_DEPTH", "", "REFERENCE_PATTERN", "Lkotlin/text/Regex;", "REFERENCE_BODY_GROUP_INDEX", "REFERENCE_STRUCTURE_PATTERN", "EXTERNAL_FILE_GROUP_INDEX", "DEFINITION_PATH_GROUP_INDEX", "intellij.swagger.core"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

