/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.remote.jdbc.helpers;

import com.intellij.database.remote.jdbc.helpers.JdbcHelperImpl;
import com.intellij.database.remote.jdbc.helpers.JdbcNativeUtil;
import com.intellij.database.remote.jdbc.helpers.JdbcSettings;
import com.intellij.database.remote.jdbc.helpers.MysqlBaseJdbcHelper;
import com.intellij.database.remote.jdbc.helpers.RemoteLogHelper;
import com.intellij.database.remote.jdbc.impl.ReflectionHelper;
import com.intellij.util.ArrayUtilRt;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Properties;
import java.util.logging.Level;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class MariaJdbcHelper
extends MysqlBaseJdbcHelper {
    private static final Pattern MYSQL_PREFIXED_VERSION_PATTERN = Pattern.compile("(?:\\d+(?:\\.\\d+)+)-(\\d+(?:\\.\\d+)+)");

    public MariaJdbcHelper(@NotNull String dbmsName, @Nullable String version, @Nullable Connection connection) {
        if (dbmsName == null) {
            MariaJdbcHelper.$$$reportNull$$$0(0);
        }
        super(dbmsName, version, connection);
    }

    @Override
    public JdbcHelperImpl create(@Nullable String version, @Nullable Connection connection) {
        return new MariaJdbcHelper(version, connection);
    }

    public MariaJdbcHelper(@Nullable String version, @Nullable Connection connection) {
        this("MARIADB", version, connection);
    }

    public MariaJdbcHelper() {
        this(null, null);
    }

    @Override
    @Nullable
    public String parseVersion(@Nullable String version) {
        return MariaJdbcHelper.extractVersion(version);
    }

    @Override
    public int getPrecision(ResultSetMetaData delegate, int column) throws SQLException {
        int type;
        try {
            type = delegate.getColumnType(column);
        }
        catch (Throwable th) {
            type = -1;
        }
        return type == 12 || type == 1 ? delegate.getColumnDisplaySize(column) : super.getPrecision(delegate, column);
    }

    @Override
    public int getRow(@NotNull ResultSet rs) throws SQLException {
        Object pointer;
        if (rs == null) {
            MariaJdbcHelper.$$$reportNull$$$0(1);
        }
        if ((pointer = ReflectionHelper.tryInvokeMethod(rs, "getRowPointer", ArrayUtilRt.EMPTY_CLASS_ARRAY, ArrayUtilRt.EMPTY_OBJECT_ARRAY)) instanceof Integer) {
            return (Integer)pointer + 1;
        }
        return super.getRow(rs);
    }

    @Override
    protected void enableSsl(@NotNull Driver driver, @NotNull Properties properties, @NotNull JdbcSettings.SslMode sslMode) {
        if (driver == null) {
            MariaJdbcHelper.$$$reportNull$$$0(2);
        }
        if (properties == null) {
            MariaJdbcHelper.$$$reportNull$$$0(3);
        }
        if (sslMode == null) {
            MariaJdbcHelper.$$$reportNull$$$0(4);
        }
        MariaJdbcHelper.setIfEmpty(properties, "useSsl", "true");
        if (sslMode == JdbcSettings.SslMode.VERIFY_FULL) {
            MariaJdbcHelper.setIfEmpty(properties, "disableSslHostnameVerification", "false");
            MariaJdbcHelper.setIfEmpty(properties, "trustServerCertificate", "false");
        } else if (sslMode == JdbcSettings.SslMode.VERIFY_CA) {
            MariaJdbcHelper.setIfEmpty(properties, "disableSslHostnameVerification", "true");
            MariaJdbcHelper.setIfEmpty(properties, "trustServerCertificate", "false");
        } else {
            MariaJdbcHelper.setIfEmpty(properties, "disableSslHostnameVerification", "true");
            MariaJdbcHelper.setIfEmpty(properties, "trustServerCertificate", "true");
        }
    }

    @Override
    protected void setDriverLogLevel(Driver driver, Properties properties, Level level, String logPath) {
        if (level != null) {
            System.setProperty("mariadb.logging.slf4j.enable", "false");
            System.setProperty("mariadb.logging.fallback", "JDK");
            RemoteLogHelper.setLogLevel("org.mariadb.jdbc", level);
        }
        super.setDriverLogLevel(driver, properties, level, logPath);
    }

    @Override
    public void setFetchSize(Statement stmt, int fetchSize) throws SQLException {
        stmt.setFetchSize(fetchSize);
    }

    @Override
    public boolean detect(@NotNull Driver driver, @Nullable String url) {
        if (driver == null) {
            MariaJdbcHelper.$$$reportNull$$$0(5);
        }
        return MariaJdbcHelper.classNameContains(driver, "maria");
    }

    @NotNull
    static MariaJdbcHelper create(@Nullable Connection delegate, @Nullable String versionStr) {
        String version = MariaJdbcHelper.extractVersion(versionStr);
        return new MariaJdbcHelper(version, delegate);
    }

    @Nullable
    public static String extractVersion(@Nullable String str) {
        String res = JdbcNativeUtil.findVersion(str, MYSQL_PREFIXED_VERSION_PATTERN);
        if (res == null) {
            res = JdbcNativeUtil.findVersion(str, JdbcNativeUtil.DEFAULT_VERSION_PATTERN);
        }
        return res;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dbmsName";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rs";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "driver";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "properties";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sslMode";
                break;
            }
        }
        objectArray2[1] = "com/intellij/database/remote/jdbc/helpers/MariaJdbcHelper";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "getRow";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "enableSsl";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "detect";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

