/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugins.webDeployment.config;

import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.NlsSafe;
import com.jetbrains.plugins.webDeployment.WDBundle;
import com.jetbrains.plugins.webDeployment.WebDeploymentIcons;
import java.util.function.Supplier;
import javax.swing.Icon;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;

public enum AccessType {
    SFTP(WDBundle.messagePointer("accessType.sftp.title", new Object[0]), WebDeploymentIcons.Sftp, 22, "sftp", "/", () -> ""),
    FTP(WDBundle.messagePointer("accessType.ftp.title", new Object[0]), WebDeploymentIcons.Ftp, 21, "ftp", "/", () -> ""),
    FTPS(WDBundle.messagePointer("accessType.ftps.title", new Object[0]), WebDeploymentIcons.Ftps, 21, "ftps", "/", () -> ""),
    WEBDAV(WDBundle.messagePointer("accessType.webdav.title", new Object[0]), WebDeploymentIcons.Webdav, 6180, "dav", "/webdav", "webdav", () -> ""),
    MOUNT(WDBundle.messagePointer("accessType.mount.title", new Object[0]), WebDeploymentIcons.Mounted, 0, null, "", WDBundle.messagePointer("mounted.server.description", new Object[0])),
    LOCAL(WDBundle.messagePointer("accessType.local.title", new Object[0]), WebDeploymentIcons.Local, 0, null, "", WDBundle.messagePointer("local.server.description", new Object[0]));

    private final Supplier<@NlsContexts.Label String> myTitle;
    private final Icon myIcon;
    private final int myDefaultPort;
    private final String myScheme;
    @NlsSafe
    private final String myDefaultRootFolder;
    private String myPrefix;
    private final Supplier<@Nls(capitalization=Nls.Capitalization.Sentence) String> myDescription;

    private AccessType(Supplier<String> title, @NonNls Icon icon, int defaultPort, /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @Nls(capitalization=Nls.Capitalization.Sentence) String scheme, String defaultRootFolder, Supplier<String> description) {
        this(title, icon, defaultPort, scheme, defaultRootFolder, "", description);
    }

    private AccessType(Supplier<String> title, @NonNls Icon icon, int defaultPort, String scheme, /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @Nls(capitalization=Nls.Capitalization.Sentence) String defaultRootFolder, String prefix, Supplier<String> description) {
        this.myTitle = title;
        this.myIcon = icon;
        this.myDefaultPort = defaultPort;
        this.myScheme = scheme;
        this.myDefaultRootFolder = defaultRootFolder;
        this.myPrefix = prefix;
        this.myDescription = description;
    }

    String getPrefix() {
        return this.myPrefix;
    }

    public Icon getIcon() {
        return this.myIcon;
    }

    @NlsContexts.Label
    public String getTitle() {
        return this.myTitle.get();
    }

    public int getDefaultPort() {
        return this.myDefaultPort;
    }

    public String getScheme() {
        return this.myScheme;
    }

    @NlsSafe
    public String getDefaultRootFolder() {
        return this.myDefaultRootFolder;
    }

    public boolean isProtocolBased() {
        return this.myScheme != null;
    }

    @Nls(capitalization=Nls.Capitalization.Sentence)
    public String getDescription() {
        return this.myDescription.get();
    }

    public String toString() {
        return this.myTitle.toString();
    }
}

