/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.localization.validation;

import com.intellij.lang.annotation.AnnotationHolder;
import com.intellij.lang.annotation.Annotator;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.psi.PsiElement;
import com.jetbrains.localization.LocaleFileType;
import com.jetbrains.localization.LocaleLanguage;
import com.jetbrains.localization.validation.LocaleAnnotator;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public final class LocaleAnnotatingVisitor
implements Annotator {
    private static final Logger LOGGER = Logger.getInstance((String)LocaleAnnotatingVisitor.class.getName());
    private final List<LocaleAnnotator> myAnnotators = new ArrayList<LocaleAnnotator>();

    public LocaleAnnotatingVisitor() {
        for (Class<? extends LocaleAnnotator> cls : ((LocaleLanguage)LocaleFileType.INSTANCE.getLanguage()).getAnnotators()) {
            LocaleAnnotator annotator;
            try {
                annotator = cls.newInstance();
            }
            catch (IllegalAccessException | InstantiationException e) {
                LOGGER.error((Throwable)e);
                continue;
            }
            this.myAnnotators.add(annotator);
        }
    }

    public void annotate(@NotNull PsiElement psiElement, @NotNull AnnotationHolder holder) {
        if (psiElement == null) {
            LocaleAnnotatingVisitor.$$$reportNull$$$0(0);
        }
        if (holder == null) {
            LocaleAnnotatingVisitor.$$$reportNull$$$0(1);
        }
        for (LocaleAnnotator annotator : this.myAnnotators) {
            annotator.annotateElement(psiElement, holder);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "psiElement";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "holder";
                break;
            }
        }
        objectArray[1] = "com/jetbrains/localization/validation/LocaleAnnotatingVisitor";
        objectArray[2] = "annotate";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

