/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.textmate.language.syntax.lexer;

import com.intellij.openapi.util.text.Strings;
import com.intellij.util.containers.FList;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntList;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Queue;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.textmate.Constants;
import org.jetbrains.plugins.textmate.language.TextMateLanguageDescriptor;
import org.jetbrains.plugins.textmate.language.syntax.SyntaxNodeDescriptor;
import org.jetbrains.plugins.textmate.language.syntax.TextMateCapture;
import org.jetbrains.plugins.textmate.language.syntax.lexer.SyntaxMatchUtils;
import org.jetbrains.plugins.textmate.language.syntax.lexer.TextMateLexerState;
import org.jetbrains.plugins.textmate.language.syntax.lexer.TextMateScope;
import org.jetbrains.plugins.textmate.language.syntax.selector.TextMateWeigh;
import org.jetbrains.plugins.textmate.regex.MatchData;
import org.jetbrains.plugins.textmate.regex.RegexUtil;
import org.jetbrains.plugins.textmate.regex.StringWithId;
import org.jetbrains.plugins.textmate.regex.TextMateRange;

public final class TextMateLexer {
    private static final int MAX_LOOPS_COUNT = 10;
    private int myCurrentOffset;
    private CharSequence myText;
    @NotNull
    private TextMateScope myCurrentScope;
    private IntList myNestedScope;
    private FList<TextMateLexerState> myStates;
    private final CharSequence myLanguageScopeName;
    private final int myLineLimit;
    private final boolean myStripWhitespaces;
    private final Runnable myCheckCancelledCallback;
    private final TextMateLexerState myLanguageInitialState;

    public TextMateLexer(@NotNull TextMateLanguageDescriptor languageDescriptor, int lineLimit) {
        if (languageDescriptor == null) {
            TextMateLexer.$$$reportNull$$$0(0);
        }
        this(languageDescriptor, lineLimit, false);
    }

    public TextMateLexer(@NotNull TextMateLanguageDescriptor languageDescriptor, int lineLimit, boolean stripWhitespaces) {
        if (languageDescriptor == null) {
            TextMateLexer.$$$reportNull$$$0(1);
        }
        this.myCurrentOffset = 0;
        this.myText = "";
        this.myCurrentScope = TextMateScope.EMPTY;
        this.myNestedScope = IntArrayList.of();
        this.myStates = FList.emptyList();
        this.myLanguageScopeName = languageDescriptor.getScopeName();
        this.myLanguageInitialState = TextMateLexerState.notMatched(languageDescriptor.getRootSyntaxNode());
        this.myLineLimit = lineLimit;
        this.myStripWhitespaces = stripWhitespaces;
        this.myCheckCancelledCallback = SyntaxMatchUtils.getCheckCancelledCallback();
    }

    public void init(CharSequence text, int startOffset) {
        this.myText = text;
        this.myCurrentOffset = startOffset;
        this.myStates = FList.singleton((Object)this.myLanguageInitialState);
        this.myCurrentScope = new TextMateScope(this.myLanguageScopeName, null);
        this.myNestedScope = IntArrayList.of((int[])new int[]{1});
    }

    public int getCurrentOffset() {
        return this.myCurrentOffset;
    }

    public void advanceLine(@NotNull Queue<Token> output) {
        int startLineOffset;
        int endLineOffset;
        if (output == null) {
            TextMateLexer.$$$reportNull$$$0(2);
        }
        for (endLineOffset = startLineOffset = this.myCurrentOffset; endLineOffset < this.myText.length(); ++endLineOffset) {
            if (this.myText.charAt(endLineOffset) != '\n') continue;
            ++endLineOffset;
            break;
        }
        CharSequence lineCharSequence = this.myText.subSequence(startLineOffset, endLineOffset);
        if (this.myLineLimit >= 0 && lineCharSequence.length() > this.myLineLimit) {
            this.myStates = this.parseLine(lineCharSequence.subSequence(0, this.myLineLimit), output, this.myStates, startLineOffset, 0, 0);
            this.addToken(output, endLineOffset);
        } else {
            this.myStates = this.parseLine(lineCharSequence, output, this.myStates, startLineOffset, 0, 0);
        }
    }

    private FList<TextMateLexerState> parseLine(@NotNull CharSequence line, @NotNull Queue<Token> output, @NotNull FList<TextMateLexerState> states, int lineStartOffset, int linePosition, int lineByteOffset) {
        if (line == null) {
            TextMateLexer.$$$reportNull$$$0(3);
        }
        if (output == null) {
            TextMateLexer.$$$reportNull$$$0(4);
        }
        if (states == null) {
            TextMateLexer.$$$reportNull$$$0(5);
        }
        FList lastSuccessState = states;
        int lastSuccessStateOccursCount = 0;
        int lastMovedOffset = lineStartOffset;
        boolean matchBeginOfString = lineStartOffset == 0;
        int anchorByteOffset = -1;
        StringWithId string = new StringWithId(line);
        FList whileStates = states;
        while (!whileStates.isEmpty()) {
            TextMateLexerState whileState = (TextMateLexerState)whileStates.getHead();
            whileStates = whileStates.getTail();
            if (whileState.syntaxRule.getStringAttribute(Constants.StringKey.WHILE) == null) continue;
            MatchData matchWhile = SyntaxMatchUtils.matchStringRegex(Constants.StringKey.WHILE, string, lineByteOffset, anchorByteOffset, matchBeginOfString, whileState);
            if (matchWhile.matched()) {
                if (anchorByteOffset != -1) continue;
                anchorByteOffset = matchWhile.byteOffset().end;
                continue;
            }
            this.closeScopeSelector(output, linePosition + lineStartOffset);
            this.closeScopeSelector(output, linePosition + lineStartOffset);
            states = whileStates;
            anchorByteOffset = -1;
        }
        HashSet<TextMateLexerState> localStates = new HashSet<TextMateLexerState>();
        while (true) {
            int endPosition;
            TextMateLexerState lastState = (TextMateLexerState)states.getHead();
            SyntaxNodeDescriptor lastRule = lastState.syntaxRule;
            TextMateLexerState currentState = SyntaxMatchUtils.matchFirst(lastRule, string, lineByteOffset, anchorByteOffset, matchBeginOfString, TextMateWeigh.Priority.NORMAL, this.myCurrentScope);
            SyntaxNodeDescriptor currentRule = currentState.syntaxRule;
            MatchData currentMatch = currentState.matchData;
            MatchData endMatch = SyntaxMatchUtils.matchStringRegex(Constants.StringKey.END, string, lineByteOffset, anchorByteOffset, matchBeginOfString, lastState);
            if (endMatch.matched() && (!currentMatch.matched() || currentMatch.byteOffset().start >= endMatch.byteOffset().start || lastState.equals(currentState))) {
                TextMateLexerState poppedState = (TextMateLexerState)states.getHead();
                if (poppedState.matchData.matched() && !poppedState.matchedEOL) {
                    anchorByteOffset = poppedState.matchData.byteOffset().end;
                }
                states = states.getTail();
                TextMateRange endRange = endMatch.charRange(line, string.bytes);
                int startPosition = endPosition = endRange.start;
                this.closeScopeSelector(output, startPosition + lineStartOffset);
                if (lastRule.getCaptureRules(Constants.CaptureKey.END_CAPTURES) == null && lastRule.getCaptureRules(Constants.CaptureKey.CAPTURES) == null || this.parseCaptures(output, Constants.CaptureKey.END_CAPTURES, lastRule, endMatch, string, line, lineStartOffset, (FList<TextMateLexerState>)states) || this.parseCaptures(output, Constants.CaptureKey.CAPTURES, lastRule, endMatch, string, line, lineStartOffset, (FList<TextMateLexerState>)states)) {
                    endPosition = endRange.end;
                }
                this.closeScopeSelector(output, endPosition + lineStartOffset);
                if (linePosition == endPosition && TextMateLexer.containsLexerState(localStates, poppedState) && poppedState.enterByteOffset == lineByteOffset) {
                    this.addToken(output, line.length() + lineStartOffset);
                    break;
                }
                localStates.remove(poppedState);
            } else if (currentMatch.matched()) {
                anchorByteOffset = currentMatch.byteOffset().end;
                TextMateRange currentRange = currentMatch.charRange(line, string.bytes);
                int startPosition = currentRange.start;
                endPosition = currentRange.end;
                if (currentRule.getStringAttribute(Constants.StringKey.BEGIN) != null) {
                    states = states.prepend((Object)currentState);
                    CharSequence name = SyntaxMatchUtils.getStringAttribute(Constants.StringKey.NAME, currentRule, string, currentMatch);
                    this.openScopeSelector(output, name, startPosition + lineStartOffset);
                    this.parseCaptures(output, Constants.CaptureKey.BEGIN_CAPTURES, currentRule, currentMatch, string, line, lineStartOffset, (FList<TextMateLexerState>)states);
                    this.parseCaptures(output, Constants.CaptureKey.CAPTURES, currentRule, currentMatch, string, line, lineStartOffset, (FList<TextMateLexerState>)states);
                    CharSequence contentName = SyntaxMatchUtils.getStringAttribute(Constants.StringKey.CONTENT_NAME, currentRule, string, currentMatch);
                    this.openScopeSelector(output, contentName, endPosition + lineStartOffset);
                } else if (currentRule.getStringAttribute(Constants.StringKey.MATCH) != null) {
                    CharSequence name = SyntaxMatchUtils.getStringAttribute(Constants.StringKey.NAME, currentRule, string, currentMatch);
                    this.openScopeSelector(output, name, startPosition + lineStartOffset);
                    this.parseCaptures(output, Constants.CaptureKey.CAPTURES, currentRule, currentMatch, string, line, lineStartOffset, (FList<TextMateLexerState>)states);
                    this.closeScopeSelector(output, endPosition + lineStartOffset);
                }
                if (linePosition == endPosition && TextMateLexer.containsLexerState(localStates, currentState)) {
                    this.addToken(output, line.length() + lineStartOffset);
                    break;
                }
                localStates.add(currentState);
            } else {
                this.addToken(output, line.length() + lineStartOffset);
                break;
            }
            if (lastMovedOffset < this.myCurrentOffset) {
                lastSuccessState = states;
                lastSuccessStateOccursCount = 0;
                lastMovedOffset = this.myCurrentOffset;
            } else if (lastSuccessState.equals((Object)states)) {
                if (lastSuccessStateOccursCount > 10) {
                    this.addToken(output, line.length() + lineStartOffset);
                    break;
                }
                ++lastSuccessStateOccursCount;
            }
            if (linePosition != endPosition) {
                linePosition = endPosition;
                lineByteOffset = RegexUtil.byteOffsetByCharOffset(line, linePosition);
            }
            if (this.myCheckCancelledCallback == null) continue;
            this.myCheckCancelledCallback.run();
        }
        return states;
    }

    private static boolean containsLexerState(Set<TextMateLexerState> states, TextMateLexerState state) {
        for (TextMateLexerState s : states) {
            if (s.enterByteOffset != state.enterByteOffset || !s.syntaxRule.equals(state.syntaxRule)) continue;
            return true;
        }
        return false;
    }

    private boolean parseCaptures(@NotNull Queue<Token> output, Constants.CaptureKey captureKey, SyntaxNodeDescriptor rule, MatchData matchData, StringWithId string, CharSequence line, int startLineOffset, FList<TextMateLexerState> states) {
        TextMateCapture[] captures;
        if (output == null) {
            TextMateLexer.$$$reportNull$$$0(6);
        }
        if ((captures = rule.getCaptureRules(captureKey)) == null) {
            return false;
        }
        LinkedList<TextMateRange> activeCaptureRanges = new LinkedList<TextMateRange>();
        for (int group = 0; group < matchData.count(); ++group) {
            TextMateRange byteRange;
            TextMateCapture capture;
            TextMateCapture textMateCapture = capture = group < captures.length ? captures[group] : null;
            if (capture == null || (byteRange = matchData.byteOffset(group)).isEmpty()) continue;
            TextMateRange captureRange = matchData.charRange(line, string.bytes, group);
            while (!activeCaptureRanges.isEmpty() && ((TextMateRange)activeCaptureRanges.peek()).end <= captureRange.start) {
                this.closeScopeSelector(output, startLineOffset + ((TextMateRange)activeCaptureRanges.pop()).end);
            }
            if (capture instanceof TextMateCapture.Name) {
                int selectorStartOffset;
                CharSequence captureName = ((TextMateCapture.Name)capture).getName();
                CharSequence scopeName = rule.hasBackReference(captureKey, group) ? SyntaxMatchUtils.replaceGroupsWithMatchDataInCaptures(captureName, string, matchData) : captureName;
                int indexOfSpace = Strings.indexOf((CharSequence)scopeName, (char)' ', (int)(selectorStartOffset = 0));
                if (indexOfSpace == -1) {
                    this.openScopeSelector(output, scopeName, startLineOffset + captureRange.start);
                    activeCaptureRanges.push(captureRange);
                    continue;
                }
                while (indexOfSpace >= 0) {
                    this.openScopeSelector(output, scopeName.subSequence(selectorStartOffset, indexOfSpace), startLineOffset + captureRange.start);
                    selectorStartOffset = indexOfSpace + 1;
                    indexOfSpace = Strings.indexOf((CharSequence)scopeName, (char)' ', (int)selectorStartOffset);
                    activeCaptureRanges.push(captureRange);
                }
                this.openScopeSelector(output, scopeName.subSequence(selectorStartOffset, scopeName.length()), startLineOffset + captureRange.start);
                activeCaptureRanges.push(captureRange);
                continue;
            }
            if (capture instanceof TextMateCapture.Rule) {
                CharSequence capturedString = line.subSequence(0, captureRange.end);
                StringWithId capturedStringWithId = new StringWithId(capturedString);
                TextMateLexerState captureState = new TextMateLexerState(((TextMateCapture.Rule)capture).getNode(), matchData, TextMateWeigh.Priority.NORMAL, byteRange.start, capturedStringWithId);
                this.parseLine(capturedString, output, (FList<TextMateLexerState>)states.prepend((Object)captureState), startLineOffset, captureRange.start, byteRange.start);
                continue;
            }
            throw new IllegalStateException("unknown capture type: " + capture);
        }
        while (!activeCaptureRanges.isEmpty()) {
            this.closeScopeSelector(output, startLineOffset + ((TextMateRange)activeCaptureRanges.pop()).end);
        }
        return true;
    }

    private void openScopeSelector(@NotNull Queue<Token> output, @Nullable CharSequence name, int position) {
        if (output == null) {
            TextMateLexer.$$$reportNull$$$0(7);
        }
        this.addToken(output, position);
        int indexOfSpace = name != null ? Strings.indexOf((CharSequence)name, (char)' ', (int)0) : -1;
        int prevIndexOfSpace = 0;
        int count = 0;
        while (indexOfSpace >= 0) {
            this.myCurrentScope = this.myCurrentScope.add(name.subSequence(prevIndexOfSpace, indexOfSpace));
            prevIndexOfSpace = indexOfSpace + 1;
            indexOfSpace = Strings.indexOf((CharSequence)name, (char)' ', (int)prevIndexOfSpace);
            ++count;
        }
        this.myCurrentScope = this.myCurrentScope.add(name != null ? name.subSequence(prevIndexOfSpace, name.length()) : null);
        this.myNestedScope.add(count + 1);
    }

    private void closeScopeSelector(@NotNull Queue<Token> output, int position) {
        CharSequence lastOpenedName;
        if (output == null) {
            TextMateLexer.$$$reportNull$$$0(8);
        }
        if ((lastOpenedName = this.myCurrentScope.getScopeName()) != null && !lastOpenedName.isEmpty()) {
            this.addToken(output, position);
        }
        if (!this.myNestedScope.isEmpty()) {
            int nested = this.myNestedScope.getInt(this.myNestedScope.size() - 1);
            this.myNestedScope.removeInt(this.myNestedScope.size() - 1);
            for (int i = 0; i < nested; ++i) {
                this.myCurrentScope = this.myCurrentScope.getParentOrSelf();
            }
        }
    }

    private void addToken(@NotNull Queue<Token> output, int position) {
        if (output == null) {
            TextMateLexer.$$$reportNull$$$0(9);
        }
        if ((position = Math.min(position, this.myText.length())) > this.myCurrentOffset) {
            int wsEnd;
            boolean newState = this.myCurrentScope.getParent() == null;
            int wsStart = this.myCurrentOffset;
            while (this.myStripWhitespaces && position > this.myCurrentOffset && Character.isWhitespace(this.myText.charAt(this.myCurrentOffset))) {
                ++this.myCurrentOffset;
            }
            if (wsStart < this.myCurrentOffset) {
                output.offer(new Token(TextMateScope.WHITESPACE, wsStart, this.myCurrentOffset, newState));
                newState = false;
            }
            for (wsEnd = position; this.myStripWhitespaces && wsEnd > this.myCurrentOffset && Character.isWhitespace(this.myText.charAt(wsEnd - 1)); --wsEnd) {
            }
            if (this.myCurrentOffset < wsEnd) {
                output.offer(new Token(this.myCurrentScope, this.myCurrentOffset, wsEnd, newState));
            }
            if (wsEnd < position) {
                output.offer(new Token(TextMateScope.WHITESPACE, wsEnd, position, newState));
            }
            this.myCurrentOffset = position;
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "languageDescriptor";
                break;
            }
            case 2: 
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "output";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "line";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "states";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/plugins/textmate/language/syntax/lexer/TextMateLexer";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "advanceLine";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "parseLine";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "parseCaptures";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "openScopeSelector";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "closeScopeSelector";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "addToken";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static final class Token {
        public final TextMateScope scope;
        public final int startOffset;
        public final int endOffset;
        public final boolean restartable;

        private Token(TextMateScope scope, int startOffset, int endOffset, boolean restartable) {
            this.scope = scope;
            this.startOffset = startOffset;
            this.endOffset = endOffset;
            this.restartable = restartable;
        }
    }
}

