/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.microservices.ui.diagrams.model.searchers;

import com.google.common.graph.MutableNetwork;
import com.google.common.graph.Network;
import com.intellij.microservices.mq.MQDestination;
import com.intellij.microservices.mq.MQResolverManager;
import com.intellij.microservices.mq.MQTargetInfo;
import com.intellij.microservices.mq.MQType;
import com.intellij.microservices.mq.UnknownMQProviderType;
import com.intellij.microservices.ui.MicroservicesUiBundle;
import com.intellij.microservices.ui.diagrams.MsDiagramRelationship;
import com.intellij.microservices.ui.diagrams.MsDiagramRelationshipsKt;
import com.intellij.microservices.ui.diagrams.model.MsDiagramEndpoint;
import com.intellij.microservices.ui.diagrams.model.MsDiagramMQDestination;
import com.intellij.microservices.ui.diagrams.model.MsDiagramMQSeedElement;
import com.intellij.microservices.ui.diagrams.model.MsDiagramRequest;
import com.intellij.microservices.ui.diagrams.model.MsDiagramSeed;
import com.intellij.microservices.ui.diagrams.model.MsDiagramWebservice;
import com.intellij.microservices.ui.diagrams.model.MsDiagramWholeProjectSeed;
import com.intellij.microservices.ui.diagrams.model.RequestToMQueue;
import com.intellij.microservices.ui.diagrams.model.RequestsSearcher;
import com.intellij.microservices.ui.diagrams.presentation.MsDiagramEdge;
import com.intellij.microservices.ui.diagrams.utils.GraphUtilsKt;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001c\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u0000 \u00122\u00020\u0001:\u0001\u0012B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J.\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u00052\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\rH\u0016J(\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00070\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\rH\u0016\u00a8\u0006\u0013"}, d2={"Lcom/intellij/microservices/ui/diagrams/model/searchers/RequestsToMQSearcher;", "Lcom/intellij/microservices/ui/diagrams/model/RequestsSearcher;", "<init>", "()V", "search", "Lcom/google/common/graph/Network;", "Lcom/intellij/microservices/ui/diagrams/model/MsDiagramEndpoint;", "Lcom/intellij/microservices/ui/diagrams/model/MsDiagramRequest;", "seed", "Lcom/intellij/microservices/ui/diagrams/model/MsDiagramSeed;", "searchParams", "Lcom/intellij/microservices/ui/diagrams/model/RequestsSearcher$SearchParams;", "indicator", "Lcom/intellij/openapi/progress/ProgressIndicator;", "searchForRequestsFormingAnEdge", "", "edge", "Lcom/intellij/microservices/ui/diagrams/presentation/MsDiagramEdge;", "Companion", "intellij.microservices.ui"})
@SourceDebugExtension(value={"SMAP\nRequestsToMQSearcher.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RequestsToMQSearcher.kt\ncom/intellij/microservices/ui/diagrams/model/searchers/RequestsToMQSearcher\n+ 2 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 3 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,81:1\n992#2:82\n1021#2,3:83\n1024#2,3:93\n381#3,7:86\n462#3:96\n412#3:97\n462#3:102\n412#3:103\n1246#4,4:98\n1246#4,4:104\n*S KotlinDebug\n*F\n+ 1 RequestsToMQSearcher.kt\ncom/intellij/microservices/ui/diagrams/model/searchers/RequestsToMQSearcher\n*L\n47#1:82\n47#1:83,3\n47#1:93,3\n47#1:86,7\n48#1:96\n48#1:97\n50#1:102\n50#1:103\n48#1:98,4\n50#1:104,4\n*E\n"})
public final class RequestsToMQSearcher
implements RequestsSearcher {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final Set<MsDiagramRelationship> SUPPORTED_RELATIONSHIPS;

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public Network<MsDiagramEndpoint, MsDiagramRequest> search(@NotNull MsDiagramSeed seed, @NotNull RequestsSearcher.SearchParams searchParams, @Nullable ProgressIndicator indicator) {
        void $this$mapValuesTo$iv$iv;
        MsDiagramEndpoint msDiagramEndpoint;
        Map map;
        Object k;
        void $this$mapValuesTo$iv$iv2;
        void $this$mapValues$iv;
        Object value$iv$iv$iv;
        Object $this$getOrPut$iv$iv$iv;
        Object key$iv$iv;
        void $this$groupByTo$iv$iv;
        Map $this$groupBy$iv;
        Pair pair;
        Intrinsics.checkNotNullParameter((Object)seed, (String)"seed");
        Intrinsics.checkNotNullParameter((Object)searchParams, (String)"searchParams");
        MsDiagramSeed msDiagramSeed = seed;
        if (msDiagramSeed instanceof MsDiagramMQSeedElement) {
            pair = new Pair((Object)((MsDiagramMQSeedElement)seed).getProject(), (Object)((MQDestination)CollectionsKt.first((Iterable)((MsDiagramMQSeedElement)seed).getDestinationsToDisplay())).getType());
        } else if (msDiagramSeed instanceof MsDiagramWholeProjectSeed) {
            pair = new Pair((Object)((MsDiagramWholeProjectSeed)seed).getProject(), (Object)UnknownMQProviderType.INSTANCE);
        } else {
            throw new IllegalStateException(("Unknown seed " + seed).toString());
        }
        Pair pair2 = pair;
        Project project = (Project)pair2.component1();
        MQType mqTypeToSearch = (MQType)pair2.component2();
        ProgressIndicator progressIndicator = indicator;
        if (progressIndicator != null) {
            progressIndicator.setIndeterminate(true);
        }
        ProgressIndicator progressIndicator2 = indicator;
        if (progressIndicator2 != null) {
            progressIndicator2.setText(MicroservicesUiBundle.message("microservices.diagrams.webservices.searching.mq.requests", new Object[0]));
        }
        Map moduleToMQUsages = RequestsSearcher.Companion.resolveAllAndGroupByModules((Sequence)ActionsKt.runReadAction(() -> RequestsToMQSearcher.search$lambda$0(project, mqTypeToSearch)), indicator, RequestsToMQSearcher::search$lambda$1);
        Sequence sequence = SequencesKt.flattenSequenceOfIterable((Sequence)CollectionsKt.asSequence((Iterable)moduleToMQUsages.values()));
        boolean $i$f$groupBy = false;
        void var11_11 = $this$groupBy$iv;
        Map destination$iv$iv = new LinkedHashMap();
        boolean $i$f$groupByTo = false;
        for (Object element$iv$iv : $this$groupByTo$iv$iv) {
            Object object;
            MQTargetInfo it = (MQTargetInfo)element$iv$iv;
            boolean bl = false;
            key$iv$iv = it.getDestination();
            $this$getOrPut$iv$iv$iv = destination$iv$iv;
            boolean $i$f$getOrPut = false;
            value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
            if (value$iv$iv$iv == null) {
                boolean bl2 = false;
                List answer$iv$iv$iv = new ArrayList();
                $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                object = answer$iv$iv$iv;
            } else {
                object = value$iv$iv$iv;
            }
            List list$iv$iv = (List)object;
            list$iv$iv.add(element$iv$iv);
        }
        $this$groupBy$iv = destination$iv$iv;
        boolean $i$f$mapValues = false;
        $this$groupByTo$iv$iv = $this$mapValues$iv;
        destination$iv$iv = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapValues$iv.size()));
        boolean $i$f$mapValuesTo = false;
        Iterable $this$associateByTo$iv$iv$iv = $this$mapValuesTo$iv$iv2.entrySet();
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
            void it$iv$iv;
            key$iv$iv = (Map.Entry)element$iv$iv$iv;
            $this$getOrPut$iv$iv$iv = destination$iv$iv;
            boolean bl = false;
            value$iv$iv$iv = (Map.Entry)element$iv$iv$iv;
            k = it$iv$iv.getKey();
            map = $this$getOrPut$iv$iv$iv;
            boolean bl3 = false;
            MQDestination destination = (MQDestination)value$iv$iv$iv.getKey();
            List usages = (List)value$iv$iv$iv.getValue();
            msDiagramEndpoint = new MsDiagramMQDestination(project, destination, usages);
            map.put(k, msDiagramEndpoint);
        }
        Map destinationToMQElement = destination$iv$iv;
        Map $this$mapValues$iv2 = moduleToMQUsages;
        boolean $i$f$mapValues2 = false;
        destination$iv$iv = $this$mapValues$iv2;
        Map destination$iv$iv2 = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapValues$iv2.size()));
        boolean $i$f$mapValuesTo2 = false;
        Iterable $this$associateByTo$iv$iv$iv2 = $this$mapValuesTo$iv$iv.entrySet();
        boolean $i$f$associateByTo2 = false;
        for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv2) {
            void it$iv$iv;
            $this$getOrPut$iv$iv$iv = (Map.Entry)element$iv$iv$iv;
            Map map2 = destination$iv$iv2;
            boolean bl = false;
            Map.Entry entry = (Map.Entry)element$iv$iv$iv;
            k = it$iv$iv.getKey();
            map = map2;
            boolean bl4 = false;
            Module module = (Module)entry.getKey();
            msDiagramEndpoint = new MsDiagramWebservice(module);
            map.put(k, msDiagramEndpoint);
        }
        Map moduleToWebservice = destination$iv$iv2;
        MutableNetwork requestsGraph = GraphUtilsKt.mutableNetworkOf(moduleToWebservice.values());
        for (Map.Entry entry : moduleToMQUsages.entrySet()) {
            Module module = entry.getKey();
            List usages = entry.getValue();
            Object v = moduleToWebservice.get(module);
            Intrinsics.checkNotNull(v);
            MsDiagramWebservice webservice = (MsDiagramWebservice)v;
            if (!searchParams.getFromTests() && webservice.getContainsTestsOnly()) continue;
            for (MQTargetInfo usage : usages) {
                Object v2 = destinationToMQElement.get(usage.getDestination());
                Intrinsics.checkNotNull(v2);
                MsDiagramMQDestination target = (MsDiagramMQDestination)v2;
                requestsGraph.addEdge((Object)webservice, (Object)target, (Object)new RequestToMQueue(webservice, target, usage));
            }
        }
        return (Network)requestsGraph;
    }

    @Override
    @NotNull
    public Iterable<MsDiagramRequest> searchForRequestsFormingAnEdge(@NotNull MsDiagramEdge edge, @NotNull RequestsSearcher.SearchParams searchParams, @Nullable ProgressIndicator indicator) {
        Intrinsics.checkNotNullParameter((Object)((Object)edge), (String)"edge");
        Intrinsics.checkNotNullParameter((Object)searchParams, (String)"searchParams");
        MsDiagramEndpoint source = edge.getSource().getIdentifyingElement();
        MsDiagramEndpoint target = edge.getTarget().getIdentifyingElement();
        if (!(source instanceof MsDiagramWebservice && target instanceof MsDiagramMQDestination && SUPPORTED_RELATIONSHIPS.contains((Object)edge.getRelationship()))) {
            return CollectionsKt.emptyList();
        }
        return edge.getRequests();
    }

    private static final Sequence search$lambda$0(Project $project, MQType $mqTypeToSearch) {
        return MQResolverManager.Companion.getInstance($project).getAllVariants($mqTypeToSearch);
    }

    private static final PsiElement search$lambda$1(MQTargetInfo it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.resolveToPsiElement();
    }

    static {
        MsDiagramRelationship[] msDiagramRelationshipArray = new MsDiagramRelationship[]{MsDiagramRelationshipsKt.ADMINISTRATION_RELATIONSHIP, MsDiagramRelationshipsKt.RECEIVE_RELATIONSHIP, MsDiagramRelationshipsKt.SEND_RELATIONSHIP, MsDiagramRelationshipsKt.SEND_AND_RECEIVE_RELATIONSHIP, MsDiagramRelationshipsKt.STREAM_FORWARD_RELATIONSHIP, MsDiagramRelationshipsKt.UNKNOWN_RELATIONSHIP};
        SUPPORTED_RELATIONSHIPS = SetsKt.setOf((Object[])msDiagramRelationshipArray);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lcom/intellij/microservices/ui/diagrams/model/searchers/RequestsToMQSearcher$Companion;", "", "<init>", "()V", "SUPPORTED_RELATIONSHIPS", "", "Lcom/intellij/microservices/ui/diagrams/MsDiagramRelationship;", "intellij.microservices.ui"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

