/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.intellij.database.dataSource.AbstractDataSource;
import com.intellij.database.dataSource.DataSourceStorage;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.dataSource.srcStorage.DbSrcModelStorageCore;
import com.intellij.database.model.DasModel;
import com.intellij.database.model.ModelTextStorage;
import com.intellij.database.model.RawDataSource;
import com.intellij.database.model.basic.BasicModModel;
import com.intellij.database.model.basic.BasicModel;
import com.intellij.database.view.structure.DvTreeInternalFunKt;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectCloseListener;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.sql.database.SqlDataSource;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.messages.Topic;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Service
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u001c\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0007\u0018\u0000 \u00132\u00020\u0001:\u0004\u0013\u0014\u0015\u0016B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\n\u001a\u00020\u000b2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00070\rH\u0002J\u0010\u0010\u000e\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u000f\u001a\u00020\u0006J\u0010\u0010\u0010\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u000f\u001a\u00020\u0006J\b\u0010\u0012\u001a\u00020\u000bH\u0016R\u001a\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lcom/intellij/database/BasicModelRegistry;", "Lcom/intellij/openapi/Disposable;", "<init>", "()V", "models", "Lcom/github/benmanes/caffeine/cache/Cache;", "Lcom/intellij/database/model/basic/BasicModel;", "Lcom/intellij/database/model/RawDataSource;", "disposed", "", "collectModels", "", "dataSources", "", "getDataSource", "model", "getLocalDataSource", "Lcom/intellij/database/dataSource/LocalDataSource;", "dispose", "Companion", "DataSourceListener", "StorageListener", "ProjectManagerEventListener", "intellij.database.core.impl"})
public final class BasicModelRegistry
implements Disposable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Cache<BasicModel, RawDataSource> models;
    private boolean disposed;

    public BasicModelRegistry() {
        Cache cache2 = Caffeine.newBuilder().weakKeys().weakValues().build();
        Intrinsics.checkNotNullExpressionValue((Object)cache2, (String)"build(...)");
        this.models = cache2;
        MessageBusConnection messageBusConnection = ApplicationManager.getApplication().getMessageBus().connect();
        Topic<AbstractDataSource.Listener> topic = AbstractDataSource.TOPIC;
        Intrinsics.checkNotNullExpressionValue(topic, (String)"TOPIC");
        messageBusConnection.subscribe(topic, (Object)new DataSourceListener());
        Topic<DataSourceStorage.Listener> topic2 = DataSourceStorage.TOPIC;
        Intrinsics.checkNotNullExpressionValue(topic2, (String)"TOPIC");
        messageBusConnection.subscribe(topic2, (Object)new StorageListener());
        messageBusConnection.subscribe(ProjectCloseListener.TOPIC, (Object)new ProjectManagerEventListener());
        List<LocalDataSource> list = DataSourceStorage.getStorage().getDataSources();
        Intrinsics.checkNotNullExpressionValue(list, (String)"getDataSources(...)");
        List<LocalDataSource> globalDataSources = list;
        this.collectModels((Iterable<? extends RawDataSource>)globalDataSources);
        Project[] projectArray = ProjectManager.getInstance().getOpenProjects();
        Intrinsics.checkNotNullExpressionValue((Object)projectArray, (String)"getOpenProjects(...)");
        for (Project project : projectArray) {
            List<LocalDataSource> projectDataSources;
            Intrinsics.checkNotNull((Object)project);
            Project p2 = project;
            Intrinsics.checkNotNullExpressionValue(DataSourceStorage.getProjectStorage(p2).getDataSources(), (String)"getDataSources(...)");
            this.collectModels((Iterable<? extends RawDataSource>)projectDataSources);
        }
    }

    private final void collectModels(Iterable<? extends RawDataSource> dataSources) {
        for (RawDataSource rawDataSource : dataSources) {
            DasModel dasModel = rawDataSource.getModel();
            BasicModel m = dasModel instanceof BasicModel ? (BasicModel)dasModel : null;
            if (m == null) continue;
            this.models.put((Object)m, (Object)rawDataSource);
        }
    }

    @Nullable
    public final RawDataSource getDataSource(@NotNull BasicModel model) {
        Intrinsics.checkNotNullParameter((Object)model, (String)"model");
        return (RawDataSource)this.models.getIfPresent((Object)model);
    }

    @Nullable
    public final LocalDataSource getLocalDataSource(@NotNull BasicModel model) {
        Intrinsics.checkNotNullParameter((Object)model, (String)"model");
        RawDataSource rawDataSource = this.getDataSource(model);
        return rawDataSource instanceof LocalDataSource ? (LocalDataSource)rawDataSource : null;
    }

    public void dispose() {
        this.disposed = true;
        this.models.invalidateAll();
    }

    @JvmStatic
    @NotNull
    public static final BasicModelRegistry instance() {
        return Companion.instance();
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0007\u00a8\u0006\u0006"}, d2={"Lcom/intellij/database/BasicModelRegistry$Companion;", "", "<init>", "()V", "instance", "Lcom/intellij/database/BasicModelRegistry;", "intellij.database.core.impl"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final BasicModelRegistry instance() {
            Object object = ApplicationManager.getApplication().getService(BasicModelRegistry.class);
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getService(...)");
            return (BasicModelRegistry)object;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J$\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\b\u0010\b\u001a\u0004\u0018\u00010\t2\b\u0010\n\u001a\u0004\u0018\u00010\tH\u0016\u00a8\u0006\u000b"}, d2={"Lcom/intellij/database/BasicModelRegistry$DataSourceListener;", "Lcom/intellij/database/dataSource/AbstractDataSource$Listener;", "<init>", "(Lcom/intellij/database/BasicModelRegistry;)V", "onModelReplaced", "", "dataSource", "Lcom/intellij/database/model/RawDataSource;", "oldModel", "Lcom/intellij/database/model/basic/BasicModel;", "newModel", "intellij.database.core.impl"})
    private final class DataSourceListener
    implements AbstractDataSource.Listener {
        @Override
        public void onModelReplaced(@NotNull RawDataSource dataSource, @Nullable BasicModel oldModel, @Nullable BasicModel newModel) {
            Intrinsics.checkNotNullParameter((Object)dataSource, (String)"dataSource");
            if (BasicModelRegistry.this.disposed) {
                return;
            }
            if (oldModel != null) {
                BasicModelRegistry.this.models.invalidate((Object)oldModel);
            }
            if (newModel != null) {
                BasicModelRegistry.this.models.put((Object)newModel, (Object)dataSource);
            }
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016\u00a8\u0006\b"}, d2={"Lcom/intellij/database/BasicModelRegistry$ProjectManagerEventListener;", "Lcom/intellij/openapi/project/ProjectCloseListener;", "<init>", "(Lcom/intellij/database/BasicModelRegistry;)V", "projectClosed", "", "project", "Lcom/intellij/openapi/project/Project;", "intellij.database.core.impl"})
    private final class ProjectManagerEventListener
    implements ProjectCloseListener {
        public void projectClosed(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            DvTreeInternalFunKt.invalidateEntriesThat(BasicModelRegistry.this.models, (arg_0, arg_1) -> ProjectManagerEventListener.projectClosed$lambda$0(project, arg_0, arg_1));
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private static final boolean projectClosed$lambda$0(Project $project, BasicModel m, RawDataSource ds) {
            Intrinsics.checkNotNullParameter((Object)m, (String)"m");
            Intrinsics.checkNotNullParameter((Object)ds, (String)"ds");
            SqlDataSource sqlDataSource = ds instanceof SqlDataSource ? (SqlDataSource)ds : null;
            if ((sqlDataSource != null ? sqlDataSource.getProject() : null) == $project) return true;
            BasicModModel basicModModel = m instanceof BasicModModel ? (BasicModModel)m : null;
            ModelTextStorage modelTextStorage = basicModModel != null ? basicModModel.getTextStorage() : null;
            DbSrcModelStorageCore dbSrcModelStorageCore = modelTextStorage instanceof DbSrcModelStorageCore ? (DbSrcModelStorageCore)modelTextStorage : null;
            if ((dbSrcModelStorageCore != null ? dbSrcModelStorageCore.getProject() : null) != $project) return false;
            return true;
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016\u00a8\u0006\b"}, d2={"Lcom/intellij/database/BasicModelRegistry$StorageListener;", "Lcom/intellij/database/dataSource/DataSourceStorage$Listener;", "<init>", "(Lcom/intellij/database/BasicModelRegistry;)V", "dataSourceRemoved", "", "dataSource", "Lcom/intellij/database/dataSource/LocalDataSource;", "intellij.database.core.impl"})
    private final class StorageListener
    implements DataSourceStorage.Listener {
        @Override
        public void dataSourceRemoved(@NotNull LocalDataSource dataSource) {
            BasicModel m;
            Intrinsics.checkNotNullParameter((Object)dataSource, (String)"dataSource");
            DasModel dasModel = dataSource.getModel();
            BasicModel basicModel = m = dasModel instanceof BasicModel ? (BasicModel)dasModel : null;
            if (m != null) {
                BasicModelRegistry.this.models.invalidate((Object)m);
            }
        }
    }
}

